[
  [
    "https://cafe.uesb.br/idp/shibboleth", 
    {
      "entity_id": "https://cafe.uesb.br/idp/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/cafe.uesb.br.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://cafe.uesb.br/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://cafe.uesb.br/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://cafe.uesb.br/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://cafe.uesb.br/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "edu.br", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "information_url": [
                  {
                    "lang": "en", 
                    "text": "http://www.uesb.br/", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "http://www.uesb.br/", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }
                ], 
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "UESB - Universidade Estadual do Sudoeste da Bahia", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "UESB - Universidade Estadual do Sudoeste da Bahia", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "en", 
                    "text": "UESB - Universidade Estadual do Sudoeste da Bahia", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "UESB - Universidade Estadual do Sudoeste da Bahia", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDoDCCAogCAQAwDQYJKoZIhvcNAQEFBQAwgZUxDTALBgNVBAoTBFVFU0IxDzAN\nBgNVBAsTBlVJTkZPUjEjMCEGCSqGSIb3DQEJARYUbGVvbmFyZG9AdWVzYi5lZHUu\nYnIxHTAbBgNVBAcTFFZpdG9yaWEgZGEgQ29ucXVpc3RhMQswCQYDVQQIEwJCQTEL\nMAkGA1UEBhMCQlIxFTATBgNVBAMTDGNhZmUudWVzYi5icjAeFw0xMzA5MjAxODIz\nMjFaFw0xNjA5MTkxODIzMjFaMIGVMQ0wCwYDVQQKEwRVRVNCMQ8wDQYDVQQLEwZV\nSU5GT1IxIzAhBgkqhkiG9w0BCQEWFGxlb25hcmRvQHVlc2IuZWR1LmJyMR0wGwYD\nVQQHExRWaXRvcmlhIGRhIENvbnF1aXN0YTELMAkGA1UECBMCQkExCzAJBgNVBAYT\nAkJSMRUwEwYDVQQDEwxjYWZlLnVlc2IuYnIwggEiMA0GCSqGSIb3DQEBAQUAA4IB\nDwAwggEKAoIBAQDX5Qd680PTIaF0ZaDfpTfPIdAIp+ydojMhCd34S3idsFGwSKiJ\nNnfOn65iPMJFynxfQuqoo9wWnPAcS22fudOTuqdwf6NFl3sUM6fXh1UmQn2pyHxe\nUrJCwViQDV6ZplF0Uw3ABnYew3gZfUk/34NR8kkB2NdBs6jp7PD+nWn9fPLNd23p\nthdpumkzbkkzRM9SweDmFbbCwJcrn0JR2H1xtUlqT/Aq9Vb8BT3JD44mZypxKU4d\njI2/Kr9ZqaidQTcOqloiBoT1Az/fKmd1xXDDH8VFJvCGOSaXyWdEPR5kazOTLYyL\nQAq5KdWcpqU23keAklg0tw41kt1Wl1E+rb9fAgMBAAEwDQYJKoZIhvcNAQEFBQAD\nggEBAE0BAVExopeUKLY/yXZhQ+rw6uYi+JY64Y3w2qp3o4TKqgN9j5ziZge76fWL\n4zMh7PO1TsZLnlWPcP4oP1OQNc4EiiiNGgLT4DfNU3NtpFFhVCKU5v3JUcw/ZHGj\nJ4diZ6Rb6Q2TCcBJV02Gz7p6U6nhXE0blVlyqWuZ4GZWg2PSTHgaG2JzHUHC+wzf\n7OaEuX3loT+wlm2Jq2ebDBlm+Yoth1pwE+puOluSk23P6aa71SkQjxb4pEv9sx8A\nW8Xj75F/MRL9CKazIOsUVwMSJnhDgZCDc/XxD29lBYLycFS5AJiCngmO+nYI61bv\nf+RldW1MxS+H81kufj7Rum74V4I=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://cafe.uesb.br:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }, 
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://cafe.uesb.br:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "pt-br", 
                "text": "http://www.rnp.br/_arquivo/servicos/Politica_CAFe_IDP_final.pdf", 
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy"
              }
            ], 
            "registration_authority": "http://cafe.rnp.br", 
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo", 
            "registration_instant": "2010-01-01T00:00:00Z"
          }
        ]
      }, 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://cafe.uesb.br:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://cafe.uesb.br:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "edu.br", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDoDCCAogCAQAwDQYJKoZIhvcNAQEFBQAwgZUxDTALBgNVBAoTBFVFU0IxDzAN\nBgNVBAsTBlVJTkZPUjEjMCEGCSqGSIb3DQEJARYUbGVvbmFyZG9AdWVzYi5lZHUu\nYnIxHTAbBgNVBAcTFFZpdG9yaWEgZGEgQ29ucXVpc3RhMQswCQYDVQQIEwJCQTEL\nMAkGA1UEBhMCQlIxFTATBgNVBAMTDGNhZmUudWVzYi5icjAeFw0xMzA5MjAxODIz\nMjFaFw0xNjA5MTkxODIzMjFaMIGVMQ0wCwYDVQQKEwRVRVNCMQ8wDQYDVQQLEwZV\nSU5GT1IxIzAhBgkqhkiG9w0BCQEWFGxlb25hcmRvQHVlc2IuZWR1LmJyMR0wGwYD\nVQQHExRWaXRvcmlhIGRhIENvbnF1aXN0YTELMAkGA1UECBMCQkExCzAJBgNVBAYT\nAkJSMRUwEwYDVQQDEwxjYWZlLnVlc2IuYnIwggEiMA0GCSqGSIb3DQEBAQUAA4IB\nDwAwggEKAoIBAQDX5Qd680PTIaF0ZaDfpTfPIdAIp+ydojMhCd34S3idsFGwSKiJ\nNnfOn65iPMJFynxfQuqoo9wWnPAcS22fudOTuqdwf6NFl3sUM6fXh1UmQn2pyHxe\nUrJCwViQDV6ZplF0Uw3ABnYew3gZfUk/34NR8kkB2NdBs6jp7PD+nWn9fPLNd23p\nthdpumkzbkkzRM9SweDmFbbCwJcrn0JR2H1xtUlqT/Aq9Vb8BT3JD44mZypxKU4d\njI2/Kr9ZqaidQTcOqloiBoT1Az/fKmd1xXDDH8VFJvCGOSaXyWdEPR5kazOTLYyL\nQAq5KdWcpqU23keAklg0tw41kt1Wl1E+rb9fAgMBAAEwDQYJKoZIhvcNAQEFBQAD\nggEBAE0BAVExopeUKLY/yXZhQ+rw6uYi+JY64Y3w2qp3o4TKqgN9j5ziZge76fWL\n4zMh7PO1TsZLnlWPcP4oP1OQNc4EiiiNGgLT4DfNU3NtpFFhVCKU5v3JUcw/ZHGj\nJ4diZ6Rb6Q2TCcBJV02Gz7p6U6nhXE0blVlyqWuZ4GZWg2PSTHgaG2JzHUHC+wzf\n7OaEuX3loT+wlm2Jq2ebDBlm+Yoth1pwE+puOluSk23P6aa71SkQjxb4pEv9sx8A\nW8Xj75F/MRL9CKazIOsUVwMSJnhDgZCDc/XxD29lBYLycFS5AJiCngmO+nYI61bv\nf+RldW1MxS+H81kufj7Rum74V4I=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "UESB - Universidade Estadual do Sudoeste da Bahia", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }, 
          {
            "lang": "pt-br", 
            "text": "UESB - Universidade Estadual do Sudoeste da Bahia", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "UESB - Universidade Estadual do Sudoeste da Bahia", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }, 
          {
            "lang": "pt-br", 
            "text": "UESB - Universidade Estadual do Sudoeste da Bahia", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.uesb.br/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }, 
          {
            "lang": "pt-br", 
            "text": "http://www.uesb.br/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "email_address": [
            {
              "text": "leonardo@uesb.edu.br", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Leonardo", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://kilwtest.it.ki.se/shibboleth", 
    {
      "entity_id": "https://kilwtest.it.ki.se/shibboleth", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://kilwtest.it.ki.se/Shibboleth.sso/SLO/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://kilwtest.it.ki.se/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://kilwtest.it.ki.se/Shibboleth.sso/SLO/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://kilwtest.it.ki.se/Shibboleth.sso/SLO/Artifact"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "assertion_consumer_service": [
            {
              "index": "0", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://kilwtest.it.ki.se/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://kilwtest.it.ki.se/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://kilwtest.it.ki.se/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://kilwtest.it.ki.se/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://kilwtest.it.ki.se/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://kilwtest.it.ki.se/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://kilwtest.it.ki.se/Shibboleth.sso/Login"
              }, 
              {
                "index": "2", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://kilwtest.it.ki.se/Shibboleth.sso/Login"
              }, 
              {
                "index": "3", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://kilwtest.it.ki.se/Shibboleth.sso/Login"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "text": "kiladoktest01.it.ki.se", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=kiladoktest01.it.ki.se", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIDCTCCAfGgAwIBAgIJAMJ9LjHSUsvoMA0GCSqGSIb3DQEBBQUAMCExHzAdBgNV\nBAMTFmtpbGFkb2t0ZXN0MDEuaXQua2kuc2UwHhcNMTEwNTI2MTMyNTMzWhcNMjEw\nNTIzMTMyNTMzWjAhMR8wHQYDVQQDExZraWxhZG9rdGVzdDAxLml0LmtpLnNlMIIB\nIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAqOUmjHK3EDwdhiUDbm9oW/u8\nn/ksrSapvbz+TTMQ70a01QHdcU1d48Dq2rjOVUpiZvV+SVjrSsSaqoTW6X0jUwgO\nnzQZayVMGia9x5Y0zphksK0RIXrcZhN34zamHyg+ioVqumZWVfaXbfkDUphfJ25E\n+HzioYe9pzr+dWeS0bTMQ6kcgI+KZqVfpKYeNn/6c5zgfYFUy8lp7pYr5yRr7HKM\nxbezT7PTdMIXwqI291G4VaTed/jDFOtYInMI3nGcg1U75TjMxbJIjDl24hWMxb3t\nWP1vAQvQDhTYuAPaQZq/FPCYWBbbKmHUG2RcquSWYullHwvWgRnzXi04/8luwQID\nAQABo0QwQjAhBgNVHREEGjAYghZraWxhZG9rdGVzdDAxLml0LmtpLnNlMB0GA1Ud\nDgQWBBTm4IeB4clBD5Xy65Su9mR25oz94DANBgkqhkiG9w0BAQUFAAOCAQEApjAT\nZMzYK0b21AfhOC4ELmXzRIG7tjEqpG1S2KGjTML3OPQ3iqY0+6NH5ihcG7L5U+Ot\nS3HswID9RV4fRkvB2HJ1cBDSH8DbCCi6LyYydJPfJloYJ/AdrumlJQDVJRNyYD6T\n53on7zeJaKv3n9eJrhqdnoEy0ofJtTAydbEx+F3AT3tW+jjpo5biuyuOa6W0wv0J\nDICtfX5UbSz96NxJbSCjoD23hMXqMOcUT3Pllk1MuPeK18rxZWy8qwxVk+E/haLr\nOaQPhM+ucEz0I/gHI37mAyzAz8w9PSTjwN+GKKngB+8IcdOQcUVRIhhTtu+ukBjR\ne01/KT+BtiGpAdoAUA==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "0", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://kilwtest.it.ki.se/Shibboleth.sso/Artifact/SOAP"
            }
          ]
        }
      ], 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-2.0/kilwtest.it.ki.se-shibboleth.xml"
      }
    }
  ], 
  [
    "https://ticket.iop.org/shibboleth", 
    {
      "entity_id": "https://ticket.iop.org/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/ticket.iop.org.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "organization": {
        "organization_name": [
          {
            "lang": "de", 
            "text": "IOP online services", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "IOP online services", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "http://www.iop.org/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Peter", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "peter.haworth@iop.org", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Haworth", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Matt", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "matthew.keen@iop.org", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Keen", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Keith", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "keith.jones@iop.org", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Jones", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "spsso_descriptor": [
        {
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ticket.iop.org/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ticket.iop.org/Shibboleth.sso/SAML/Artifact"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://rdcdev.ticket.iop.org/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://rdcdev.ticket.iop.org/Shibboleth.sso/SAML/Artifact"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://dev.ticket.iop.org/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://dev.ticket.iop.org/Shibboleth.sso/SAML/Artifact"
            }, 
            {
              "index": "7", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ticket.iop.org/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "8", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ticket.iop.org/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "9", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://rdcdev.ticket.iop.org/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "10", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://rdcdev.ticket.iop.org/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "11", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://dev.ticket.iop.org/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "12", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://dev.ticket.iop.org/Shibboleth.sso/SAML2/Artifact"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "ticket.iop.org", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=ticket.iop.org,OU=Member\\, VeriSign Trust Network,OU=Authenticated by VeriSign,OU=Terms of use at www.verisign.co.uk/rpa (c)05,O=IOP Publishing Ltd,L=Bristol,ST=Avon,C=GB", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFejCCBGKgAwIBAgIQRs9QFKCMIHlnWILL+H/kMjANBgkqhkiG9w0BAQUFADCB\ntTELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMR8wHQYDVQQL\nExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMTswOQYDVQQLEzJUZXJtcyBvZiB1c2Ug\nYXQgaHR0cHM6Ly93d3cudmVyaXNpZ24uY29tL3JwYSAoYykxMDEvMC0GA1UEAxMm\nVmVyaVNpZ24gQ2xhc3MgMyBTZWN1cmUgU2VydmVyIENBIC0gRzMwHhcNMTEwMzA5\nMDAwMDAwWhcNMTIwNDA2MjM1OTU5WjCB6DELMAkGA1UEBhMCR0IxDTALBgNVBAgT\nBEF2b24xEDAOBgNVBAcUB0JyaXN0b2wxGzAZBgNVBAoUEklPUCBQdWJsaXNoaW5n\nIEx0ZDE1MDMGA1UECxQsVGVybXMgb2YgdXNlIGF0IHd3dy52ZXJpc2lnbi5jby51\nay9ycGEgKGMpMDUxIjAgBgNVBAsTGUF1dGhlbnRpY2F0ZWQgYnkgVmVyaVNpZ24x\nJzAlBgNVBAsTHk1lbWJlciwgVmVyaVNpZ24gVHJ1c3QgTmV0d29yazEXMBUGA1UE\nAxQOdGlja2V0LmlvcC5vcmcwgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAK0k\nvYlzSH7vvdi1wquPhBap5XOkZbXSTzxFauceC62qdw2xOwCJW+N8VPliT2bF0+Ic\nuqBRWXRoF7+z5aJWf7Zrq4XjxlJVd0TkiNGSXRY7IA7c2ciNPS8YP+iVrjoHcO0N\n9JFZkfuqnFdajf6exlCe0ZpW9Q/i9QUBglS8oeQhAgMBAAGjggHTMIIBzzAJBgNV\nHRMEAjAAMAsGA1UdDwQEAwIFoDBFBgNVHR8EPjA8MDqgOKA2hjRodHRwOi8vU1ZS\nU2VjdXJlLUczLWNybC52ZXJpc2lnbi5jb20vU1ZSU2VjdXJlRzMuY3JsMEYGA1Ud\nIAQ/MD0wOwYLYIZIAYb4RQEHFwMwLDAqBggrBgEFBQcCARYeaHR0cHM6Ly93d3cu\ndmVyaXNpZ24uY28udWsvcnBhMB0GA1UdJQQWMBQGCCsGAQUFBwMBBggrBgEFBQcD\nAjAfBgNVHSMEGDAWgBQNRFwWU0TBgn4dIKsl9AFj2L55pTB2BggrBgEFBQcBAQRq\nMGgwJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLnZlcmlzaWduLmNvbTBABggrBgEF\nBQcwAoY0aHR0cDovL1NWUlNlY3VyZS1HMy1haWEudmVyaXNpZ24uY29tL1NWUlNl\nY3VyZUczLmNlcjBuBggrBgEFBQcBDARiMGChXqBcMFowWDBWFglpbWFnZS9naWYw\nITAfMAcGBSsOAwIaBBRLa7kolgYMu9BSOJsprEsHiyEFGDAmFiRodHRwOi8vbG9n\nby52ZXJpc2lnbi5jb20vdnNsb2dvMS5naWYwDQYJKoZIhvcNAQEFBQADggEBABp/\nvWyJLNePxfNv1kLP9w2F5O6vpJr/y4NuH/Wv5LpJinN9KZ6Jht7zC2g7VaGvA75+\nbb95cQ43uJ8KpOMmsaQ4vapwAZLxW/twUMUh2qbUmlmBnkKBPNZxzCRcNmhKOAfe\nngqzUjEo/eZpsFfuvg9d/9L1od5kDfGFr4OFeN+Tin7zHoKbRv129NyIwLhaSixA\nt7LgIqlDQ4PRHCg0YWsE1CBSzSy+nWgDmWjcRIYeFoXve+wpsup3gtoBcxSKp6R5\nZo/W8ldI1Yak/Rkmn/73b1cGG0uqRDWfOHiswnes/xjDIQS9qqJRlNFHd9jkHxwb\nNy/fu2lNRrmtoPmTctI=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "ticket.iop.org", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=ticket.iop.org,OU=Member\\, VeriSign Trust Network,OU=Authenticated by VeriSign,OU=Terms of use at www.verisign.co.uk/rpa (c)05,O=IOP Publishing Ltd,L=Bristol,ST=Avon,C=GB", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFejCCBGKgAwIBAgIQRs9QFKCMIHlnWILL+H/kMjANBgkqhkiG9w0BAQUFADCB\ntTELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMR8wHQYDVQQL\nExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMTswOQYDVQQLEzJUZXJtcyBvZiB1c2Ug\nYXQgaHR0cHM6Ly93d3cudmVyaXNpZ24uY29tL3JwYSAoYykxMDEvMC0GA1UEAxMm\nVmVyaVNpZ24gQ2xhc3MgMyBTZWN1cmUgU2VydmVyIENBIC0gRzMwHhcNMTEwMzA5\nMDAwMDAwWhcNMTIwNDA2MjM1OTU5WjCB6DELMAkGA1UEBhMCR0IxDTALBgNVBAgT\nBEF2b24xEDAOBgNVBAcUB0JyaXN0b2wxGzAZBgNVBAoUEklPUCBQdWJsaXNoaW5n\nIEx0ZDE1MDMGA1UECxQsVGVybXMgb2YgdXNlIGF0IHd3dy52ZXJpc2lnbi5jby51\nay9ycGEgKGMpMDUxIjAgBgNVBAsTGUF1dGhlbnRpY2F0ZWQgYnkgVmVyaVNpZ24x\nJzAlBgNVBAsTHk1lbWJlciwgVmVyaVNpZ24gVHJ1c3QgTmV0d29yazEXMBUGA1UE\nAxQOdGlja2V0LmlvcC5vcmcwgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAK0k\nvYlzSH7vvdi1wquPhBap5XOkZbXSTzxFauceC62qdw2xOwCJW+N8VPliT2bF0+Ic\nuqBRWXRoF7+z5aJWf7Zrq4XjxlJVd0TkiNGSXRY7IA7c2ciNPS8YP+iVrjoHcO0N\n9JFZkfuqnFdajf6exlCe0ZpW9Q/i9QUBglS8oeQhAgMBAAGjggHTMIIBzzAJBgNV\nHRMEAjAAMAsGA1UdDwQEAwIFoDBFBgNVHR8EPjA8MDqgOKA2hjRodHRwOi8vU1ZS\nU2VjdXJlLUczLWNybC52ZXJpc2lnbi5jb20vU1ZSU2VjdXJlRzMuY3JsMEYGA1Ud\nIAQ/MD0wOwYLYIZIAYb4RQEHFwMwLDAqBggrBgEFBQcCARYeaHR0cHM6Ly93d3cu\ndmVyaXNpZ24uY28udWsvcnBhMB0GA1UdJQQWMBQGCCsGAQUFBwMBBggrBgEFBQcD\nAjAfBgNVHSMEGDAWgBQNRFwWU0TBgn4dIKsl9AFj2L55pTB2BggrBgEFBQcBAQRq\nMGgwJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLnZlcmlzaWduLmNvbTBABggrBgEF\nBQcwAoY0aHR0cDovL1NWUlNlY3VyZS1HMy1haWEudmVyaXNpZ24uY29tL1NWUlNl\nY3VyZUczLmNlcjBuBggrBgEFBQcBDARiMGChXqBcMFowWDBWFglpbWFnZS9naWYw\nITAfMAcGBSsOAwIaBBRLa7kolgYMu9BSOJsprEsHiyEFGDAmFiRodHRwOi8vbG9n\nby52ZXJpc2lnbi5jb20vdnNsb2dvMS5naWYwDQYJKoZIhvcNAQEFBQADggEBABp/\nvWyJLNePxfNv1kLP9w2F5O6vpJr/y4NuH/Wv5LpJinN9KZ6Jht7zC2g7VaGvA75+\nbb95cQ43uJ8KpOMmsaQ4vapwAZLxW/twUMUh2qbUmlmBnkKBPNZxzCRcNmhKOAfe\nngqzUjEo/eZpsFfuvg9d/9L1od5kDfGFr4OFeN+Tin7zHoKbRv129NyIwLhaSixA\nt7LgIqlDQ4PRHCg0YWsE1CBSzSy+nWgDmWjcRIYeFoXve+wpsup3gtoBcxSKp6R5\nZo/W8ldI1Yak/Rkmn/73b1cGG0uqRDWfOHiswnes/xjDIQS9qqJRlNFHd9jkHxwb\nNy/fu2lNRrmtoPmTctI=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://umbrella.psi.ch/", 
    {
      "entity_id": "https://umbrella.psi.ch/", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/umbrella.psi.ch.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "en", 
                "text": "https://www.switch.ch/aai/federation/switchaai/metadata-registration-practice-statement-20110711.txt", 
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy"
              }
            ], 
            "registration_authority": "http://rr.aai.switch.ch/", 
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo", 
            "registration_instant": "2005-09-01T14:00:00Z"
          }
        ]
      }, 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "psi.ch", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "PSI - Paul Scherrer Institut", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }, 
          {
            "lang": "en", 
            "text": "PSI - Paul Scherrer Institute", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "http://www.psi.ch/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://umbrella.psi.ch/Shibboleth.sso/https://umbrella.psi.ch/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://umbrella.psi.ch/Shibboleth.sso/https://umbrella.psi.ch/idp/profile/SAML2/Artifact/SSO"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://umbrella.psi.ch/Shibboleth.sso/SAML2/SOAP/ECP"
            }, 
            {
              "is_default": "true", 
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://umbrella.psi.ch/Shibboleth.sso/https://umbrella.psi.ch/idp/profile/SAML/POST/SSO"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://umbrella.psi.ch/Shibboleth.sso/https://umbrella.psi.ch/idp/profile/SAML/Artifact/SSO"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Umbrella Test Service Provider", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "en", 
                    "text": "Umbrella Test Service Provider for developing  bridging between eduGain and Umbrella Federation", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }
            ]
          }, 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ], 
          "attribute_consuming_service": [
            {
              "index": "1", 
              "service_description": [
                {
                  "lang": "en", 
                  "text": "Umbrella Test Service Provider for developing  bridging between eduGain and Umbrella Federation", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription"
                }
              ], 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService", 
              "requested_attribute": [
                {
                  "is_required": "true", 
                  "friendly_name": "eduPersonPrincipalName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.6"
                }, 
                {
                  "is_required": "true", 
                  "friendly_name": "eduPersonTargetedID", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.10"
                }
              ], 
              "service_name": [
                {
                  "lang": "en", 
                  "text": "Umbrella Test Service Provider", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }
              ]
            }
          ], 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDGDCCAgCgAwIBAgIJAPuvSPAzAC6mMA0GCSqGSIb3DQEBBQUAMBoxGDAWBgNV\nBAMTD3VtYnJlbGxhLnBzaS5jaDAeFw0xMzExMjgxMDQ2MjBaFw0xNjExMjcxMDQ2\nMjBaMBoxGDAWBgNVBAMTD3VtYnJlbGxhLnBzaS5jaDCCASIwDQYJKoZIhvcNAQEB\nBQADggEPADCCAQoCggEBAMHaKoQKIBkNpDp0I5R2yZ7uy2WShKsDm9IMxz+D0EzL\nS7k/KCKIt15E6iksEvy6KhKQUmHDjx0T/W9D+hZkAj3NaSytBCB3phGrMUFSotw9\n/GSt0e/C4x0Bju/SD5OwLOAX5QvMJllMlkGTUXQ+T6LcNBcA5kSL/jza2vssAOC0\n9vz0zK7uAxGG2/IrZ55UGL6RFB5lV4m+45DLjd/bnmk0KzPDbfCgpnq+kc4NUFov\nECrZUJ+CkOUdS6x+Jg4wsUyYWHAMA77JoQtJUWYzLMlaN/hfWoIwsG049Wp20+w3\naxkrc0u/Bd+YQB2e66sv+gzMfpxkoxs78qv9uJGaNo0CAwEAAaNhMF8wPgYDVR0R\nBDcwNYIPdW1icmVsbGEucHNpLmNohiJodHRwczovL3VtYnJlbGxhLnBzaS5jaC9z\naGliYm9sZXRoMB0GA1UdDgQWBBSycOrbvoq6pE/JYBQQAso92I6NXDANBgkqhkiG\n9w0BAQUFAAOCAQEAfarU3Y9Fi2+2Om89eMvkGB/29lZZnR+7w78sVyu6dZlMcJzT\nSJPNQXVbqAJfPEQLmSxBXxVwvoqEJH80c95xjt59p3CMuXKMxGZ+elpCin9fePrP\npDkU/CXfNNSU1OIZnSttk6Yh6uQ814ZtxqZES1zDP63Ajm/aM9L2mrxD1UJ2OWAh\nRMaDxuEU6fZCZk9ej8os9Kf2k5XmJ8x5v9cJJ3dXFxEz7tGhb7wMSBlFIsdt+j3l\nmB0SSH6Wh64W+Tkwp4HES9XCdEWbuSeJEO+0MEC8kBR13YlXLIsGU95Q5694eeun\njXaHZDgEhAR+tFkQFgpQhGcJTs1bLugCxSjdrA==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ]
        }
      ], 
      "contact_person": [
        {
          "contact_type": "support", 
          "telephone_number": [
            {
              "text": "+41563103509", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&TelephoneNumber"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "sur_name": {
            "text": "Abt", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "given_name": {
            "text": "Bj\u00f6rn", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "mailto:bjoern.abt@psi.ch", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ]
        }, 
        {
          "contact_type": "technical", 
          "telephone_number": [
            {
              "text": "+41563103509", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&TelephoneNumber"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "sur_name": {
            "text": "Abt", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "given_name": {
            "text": "Bj\u00f6rn", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "mailto:bjoern.abt@psi.ch", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://gidp.geant.net/sp/module.php/saml/sp/metadata.php/default-sp", 
    {
      "entity_id": "https://gidp.geant.net/sp/module.php/saml/sp/metadata.php/default-sp", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-2.0/gidp.geant.net-sp-module.php-saml-sp-metadata.php-default-sp.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "GEANT", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "GEANT", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.geant.net", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "email_address": [
            {
              "text": "edugain-ot@geant.net", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://gidp.geant.net/sp/module.php/saml/sp/saml2-logout.php/default-sp"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "0", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://gidp.geant.net/sp/module.php/saml/sp/saml2-acs.php/default-sp"
            }, 
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://gidp.geant.net/sp/module.php/saml/sp/saml1-acs.php/default-sp"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://gidp.geant.net/sp/module.php/saml/sp/saml2-acs.php/default-sp"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://gidp.geant.net/sp/module.php/saml/sp/saml1-acs.php/default-sp/artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIFUzCCBDugAwIBAgIRAOipFX0RJIRenc077AEf/TMwDQYJKoZIhvcNAQEFBQAwNjELMAkGA1UEBhMCTkwxDzANBgNVBAoTBlRFUkVOQTEWMBQGA1UEAxMNVEVSRU5BIFNTTCBDQTAeFw0xMDEyMjIwMDAwMDBaFw0xMzEyMjEyMzU5NTlaMIHwMRswGQYDVQQDExJ3d3cuZ2lkcC5nZWFudC5uZXQxHDAaBgNVBAMTE2lkcDIuZ2lkcC5nZWFudC5uZXQxHDAaBgNVBAMTE2lkcDEuZ2lkcC5nZWFudC5uZXQxCzAJBgNVBAYTAkdCMRcwFQYDVQQIEw5DYW1icmlkZ2VzaGlyZTESMBAGA1UEBxMJQ2FtYnJpZGdlMUIwQAYDVQQKEzlEZWxpdmVyeSBvZiBBZHZhbmNlZCBOZXR3b3JrIFRlY2hub2xvZ3kgdG8gRXVyb3BlIExpbWl0ZWQxFzAVBgNVBAMTDmdpZHAuZ2VhbnQubmV0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAxshl/HoJhaoNUgaZ8HTIexsHKN2r7Lee0f+k04Jxnmo6o5OauxOpM0991B1xt+5FyXobgNjQSIcKKEvLwaTH7HYYI9bWvfHfVXaYzPOLySPKo+c3Tldbfq0NUXo18ZWuRadEaY+waChcnlkP7yq3ZPxva4aWUvA4iCqpjbZGpMYoJvWhrHua982mBOq29j2+1VwRpBFaverOb2f4jenhlnxstvF6KUSm6B6Y1XUfwJMjAEXxXdai7RodznXV8pCoJMGyn2GN7ClGCq6qHqtSerxdymGHNVpR7pXZ1tF/mI7JIsF+NFErmZJcW79pl7m5ZoZNR+SIDexdg1/IydduGwIDAQABo4IBnzCCAZswHwYDVR0jBBgwFoAUDL2TaAzz3qujSWsrN1dH6pDjue0wHQYDVR0OBBYEFArEHsfdZvlpOxPguP9/En90/NMgMA4GA1UdDwEB/wQEAwIFoDAMBgNVHRMBAf8EAjAAMB0GA1UdJQQWMBQGCCsGAQUFBwMBBggrBgEFBQcDAjAYBgNVHSAEETAPMA0GCysGAQQBsjEBAgIdMDoGA1UdHwQzMDEwL6AtoCuGKWh0dHA6Ly9jcmwudGNzLnRlcmVuYS5vcmcvVEVSRU5BU1NMQ0EuY3JsMG0GCCsGAQUFBwEBBGEwXzA1BggrBgEFBQcwAoYpaHR0cDovL2NydC50Y3MudGVyZW5hLm9yZy9URVJFTkFTU0xDQS5jcnQwJgYIKwYBBQUHMAGGGmh0dHA6Ly9vY3NwLnRjcy50ZXJlbmEub3JnMFcGA1UdEQRQME6CDmdpZHAuZ2VhbnQubmV0ghNpZHAxLmdpZHAuZ2VhbnQubmV0ghNpZHAyLmdpZHAuZ2VhbnQubmV0ghJ3d3cuZ2lkcC5nZWFudC5uZXQwDQYJKoZIhvcNAQEFBQADggEBAH56nltzImiMVOv5DJxcTo2cpGBWPO+OI7S1Ns76cS6PzWbkm/zjPPZI871Pfgw6n3Q3V3Kpc48hRyx3WPH/9nk+YnFEUjkjaRCzeWR6A2oYSb83iI2n/33+E2AmyZ1FX5E1nfxRtSBLYyHPdXYQ6A/TN4qtm/9QHrbcISPEQJwvJn4/BOQDrvsjZDJeq7Srrr2An//RpNdC9cA4wU+m0oJPbPHGl32ENO6JVK7gJPYw2WBDER1SMwAEThtUthQyZhp1z6jA/hoeHfM4QR2/mT458LpRXs1c5VGAeC+4pjfJ4skXAU17Nq+ut8+fJMjjQSXOpv10kS2jNq2XfPmN+K4=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "encryption", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIFUzCCBDugAwIBAgIRAOipFX0RJIRenc077AEf/TMwDQYJKoZIhvcNAQEFBQAwNjELMAkGA1UEBhMCTkwxDzANBgNVBAoTBlRFUkVOQTEWMBQGA1UEAxMNVEVSRU5BIFNTTCBDQTAeFw0xMDEyMjIwMDAwMDBaFw0xMzEyMjEyMzU5NTlaMIHwMRswGQYDVQQDExJ3d3cuZ2lkcC5nZWFudC5uZXQxHDAaBgNVBAMTE2lkcDIuZ2lkcC5nZWFudC5uZXQxHDAaBgNVBAMTE2lkcDEuZ2lkcC5nZWFudC5uZXQxCzAJBgNVBAYTAkdCMRcwFQYDVQQIEw5DYW1icmlkZ2VzaGlyZTESMBAGA1UEBxMJQ2FtYnJpZGdlMUIwQAYDVQQKEzlEZWxpdmVyeSBvZiBBZHZhbmNlZCBOZXR3b3JrIFRlY2hub2xvZ3kgdG8gRXVyb3BlIExpbWl0ZWQxFzAVBgNVBAMTDmdpZHAuZ2VhbnQubmV0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAxshl/HoJhaoNUgaZ8HTIexsHKN2r7Lee0f+k04Jxnmo6o5OauxOpM0991B1xt+5FyXobgNjQSIcKKEvLwaTH7HYYI9bWvfHfVXaYzPOLySPKo+c3Tldbfq0NUXo18ZWuRadEaY+waChcnlkP7yq3ZPxva4aWUvA4iCqpjbZGpMYoJvWhrHua982mBOq29j2+1VwRpBFaverOb2f4jenhlnxstvF6KUSm6B6Y1XUfwJMjAEXxXdai7RodznXV8pCoJMGyn2GN7ClGCq6qHqtSerxdymGHNVpR7pXZ1tF/mI7JIsF+NFErmZJcW79pl7m5ZoZNR+SIDexdg1/IydduGwIDAQABo4IBnzCCAZswHwYDVR0jBBgwFoAUDL2TaAzz3qujSWsrN1dH6pDjue0wHQYDVR0OBBYEFArEHsfdZvlpOxPguP9/En90/NMgMA4GA1UdDwEB/wQEAwIFoDAMBgNVHRMBAf8EAjAAMB0GA1UdJQQWMBQGCCsGAQUFBwMBBggrBgEFBQcDAjAYBgNVHSAEETAPMA0GCysGAQQBsjEBAgIdMDoGA1UdHwQzMDEwL6AtoCuGKWh0dHA6Ly9jcmwudGNzLnRlcmVuYS5vcmcvVEVSRU5BU1NMQ0EuY3JsMG0GCCsGAQUFBwEBBGEwXzA1BggrBgEFBQcwAoYpaHR0cDovL2NydC50Y3MudGVyZW5hLm9yZy9URVJFTkFTU0xDQS5jcnQwJgYIKwYBBQUHMAGGGmh0dHA6Ly9vY3NwLnRjcy50ZXJlbmEub3JnMFcGA1UdEQRQME6CDmdpZHAuZ2VhbnQubmV0ghNpZHAxLmdpZHAuZ2VhbnQubmV0ghNpZHAyLmdpZHAuZ2VhbnQubmV0ghJ3d3cuZ2lkcC5nZWFudC5uZXQwDQYJKoZIhvcNAQEFBQADggEBAH56nltzImiMVOv5DJxcTo2cpGBWPO+OI7S1Ns76cS6PzWbkm/zjPPZI871Pfgw6n3Q3V3Kpc48hRyx3WPH/9nk+YnFEUjkjaRCzeWR6A2oYSb83iI2n/33+E2AmyZ1FX5E1nfxRtSBLYyHPdXYQ6A/TN4qtm/9QHrbcISPEQJwvJn4/BOQDrvsjZDJeq7Srrr2An//RpNdC9cA4wU+m0oJPbPHGl32ENO6JVK7gJPYw2WBDER1SMwAEThtUthQyZhp1z6jA/hoeHfM4QR2/mT458LpRXs1c5VGAeC+4pjfJ4skXAU17Nq+ut8+fJMjjQSXOpv10kS2jNq2XfPmN+K4=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "attribute_consuming_service": [
            {
              "index": "0", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService", 
              "requested_attribute": [
                {
                  "is_required": "true", 
                  "friendly_name": "email", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:0.9.2342.19200300.100.1.3"
                }, 
                {
                  "is_required": "false", 
                  "friendly_name": "eduPersonAffiliation", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.1"
                }, 
                {
                  "is_required": "true", 
                  "friendly_name": "eduPersonTargetedID", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.10"
                }, 
                {
                  "is_required": "true", 
                  "friendly_name": "eduPersonScopedAffiliation", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.9"
                }, 
                {
                  "is_required": "false", 
                  "friendly_name": "displayName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.16.840.1.113730.3.1.241"
                }, 
                {
                  "is_required": "false", 
                  "friendly_name": "commonName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.5.4.3"
                }, 
                {
                  "is_required": "false", 
                  "friendly_name": "schacHomeOrganization", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.25178.1.2.9"
                }, 
                {
                  "is_required": "false", 
                  "friendly_name": "schacHomeOrganizationType", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.25178.1.2.10"
                }
              ], 
              "service_name": [
                {
                  "lang": "en", 
                  "text": "GEANT SP Proxy", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }
              ]
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://vmshib.ufrpe.br/idp/shibboleth", 
    {
      "entity_id": "https://vmshib.ufrpe.br/idp/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/vmshib.ufrpe.br.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://vmshib.ufrpe.br/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://vmshib.ufrpe.br/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://vmshib.ufrpe.br/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://vmshib.ufrpe.br/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "ufrpe.br", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "information_url": [
                  {
                    "lang": "en", 
                    "text": "http://www.ufrpe.br/", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "http://www.ufrpe.br/", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }
                ], 
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "UFRPE - Universidade Federal Rural de Pernambuco", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "UFRPE - Universidade Federal Rural de Pernambuco", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "en", 
                    "text": "UFRPE - Universidade Federal Rural de Pernambuco", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "UFRPE - Universidade Federal Rural de Pernambuco", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIID+DCCAuACAQAwDQYJKoZIhvcNAQEFBQAwgcExOTA3BgNVBAoTMFVOSVZFUlNJ\nREFERSBGRURFUkFMIFJVUkFMIERFIFBFUk5BTUJVQ08gLyBVRlJQRTEMMAoGA1UE\nCxMDQ1BEMSkwJwYJKoZIhvcNAQkBFhpjb29yZC5zdXBvcnRlQG50aS51ZnJwZS5i\ncjEPMA0GA1UEBxMGUkVDSUZFMRMwEQYDVQQIEwpQRVJOQU1CVUNPMQswCQYDVQQG\nEwJCUjEYMBYGA1UEAxMPdm1zaGliLnVmcnBlLmJyMB4XDTEzMDkwMjEyMDEwMVoX\nDTE2MDkwMTEyMDEwMVowgcExOTA3BgNVBAoTMFVOSVZFUlNJREFERSBGRURFUkFM\nIFJVUkFMIERFIFBFUk5BTUJVQ08gLyBVRlJQRTEMMAoGA1UECxMDQ1BEMSkwJwYJ\nKoZIhvcNAQkBFhpjb29yZC5zdXBvcnRlQG50aS51ZnJwZS5icjEPMA0GA1UEBxMG\nUkVDSUZFMRMwEQYDVQQIEwpQRVJOQU1CVUNPMQswCQYDVQQGEwJCUjEYMBYGA1UE\nAxMPdm1zaGliLnVmcnBlLmJyMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKC\nAQEA2nK7Wq2HIdxRO5pOn/OqjL+pqF4ymtMwh9gm5NIDVw+51eTY7vgF2JfhyI6R\ngpBjdXy/mdbcQFDeCOeHm5dGSvrj6GijudN8SxmpOtJhrg1QXUsVCORBGVDqg4pJ\nxPpF7F7Os/KHjcw5R1e3FQfDBf+RMi+3n/8tw2F5/4XXvaEuzDj3kEIaG9l+1szw\ntgfw8nOBv2aCEFJw3diNojnh7LCTHQyP6WzSTRhmtaqqJ7SS0jgbbWuWtuF2OOxK\nRi3mASA0DmRaTrMY9usutfkddpxJ0f7VjhTjam+4J8a6PsWJvXO5SoHKW/GvP61C\nVW/ya6DZKKjS8OGk1sQ0ApbryQIDAQABMA0GCSqGSIb3DQEBBQUAA4IBAQASVqt+\nfIOD7MU30TUjylL5F1TH4F7Wco3Oh/TA1GmiOo3n3Jw/Jwp/SO/cRehHgG0P5Inh\nod01LhGYR8IWYhNE0/xW5AmohOMPrPrFvGhZYdea8q5lDUgMOAhJ6HcVtX916i30\nBOZRJT6YBZ1+gM11j+uzVH1POrPRpBKIG2mFXIENyykcUH1/fzZq6nCYQRkRqwGW\nQqr/W736U+9O7maGgwiyyB1Qoh009siTxLjIHPWqu+Uv99CKYioPv87dUpXRrG/w\nT03SRkawusIfxjWkchmxr1AZmJmC+k4fvfPp1U4CPgBpN/bn0/z+jacWe7P6XSV2\nA7uW95WfCmbke4rc", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://vmshib.ufrpe.br:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }, 
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://vmshib.ufrpe.br:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "pt-br", 
                "text": "http://www.rnp.br/_arquivo/servicos/Politica_CAFe_IDP_final.pdf", 
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy"
              }
            ], 
            "registration_authority": "http://cafe.rnp.br", 
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo", 
            "registration_instant": "2010-01-01T00:00:00Z"
          }
        ]
      }, 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://vmshib.ufrpe.br:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://vmshib.ufrpe.br:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "ufrpe.br", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIID+DCCAuACAQAwDQYJKoZIhvcNAQEFBQAwgcExOTA3BgNVBAoTMFVOSVZFUlNJ\nREFERSBGRURFUkFMIFJVUkFMIERFIFBFUk5BTUJVQ08gLyBVRlJQRTEMMAoGA1UE\nCxMDQ1BEMSkwJwYJKoZIhvcNAQkBFhpjb29yZC5zdXBvcnRlQG50aS51ZnJwZS5i\ncjEPMA0GA1UEBxMGUkVDSUZFMRMwEQYDVQQIEwpQRVJOQU1CVUNPMQswCQYDVQQG\nEwJCUjEYMBYGA1UEAxMPdm1zaGliLnVmcnBlLmJyMB4XDTEzMDkwMjEyMDEwMVoX\nDTE2MDkwMTEyMDEwMVowgcExOTA3BgNVBAoTMFVOSVZFUlNJREFERSBGRURFUkFM\nIFJVUkFMIERFIFBFUk5BTUJVQ08gLyBVRlJQRTEMMAoGA1UECxMDQ1BEMSkwJwYJ\nKoZIhvcNAQkBFhpjb29yZC5zdXBvcnRlQG50aS51ZnJwZS5icjEPMA0GA1UEBxMG\nUkVDSUZFMRMwEQYDVQQIEwpQRVJOQU1CVUNPMQswCQYDVQQGEwJCUjEYMBYGA1UE\nAxMPdm1zaGliLnVmcnBlLmJyMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKC\nAQEA2nK7Wq2HIdxRO5pOn/OqjL+pqF4ymtMwh9gm5NIDVw+51eTY7vgF2JfhyI6R\ngpBjdXy/mdbcQFDeCOeHm5dGSvrj6GijudN8SxmpOtJhrg1QXUsVCORBGVDqg4pJ\nxPpF7F7Os/KHjcw5R1e3FQfDBf+RMi+3n/8tw2F5/4XXvaEuzDj3kEIaG9l+1szw\ntgfw8nOBv2aCEFJw3diNojnh7LCTHQyP6WzSTRhmtaqqJ7SS0jgbbWuWtuF2OOxK\nRi3mASA0DmRaTrMY9usutfkddpxJ0f7VjhTjam+4J8a6PsWJvXO5SoHKW/GvP61C\nVW/ya6DZKKjS8OGk1sQ0ApbryQIDAQABMA0GCSqGSIb3DQEBBQUAA4IBAQASVqt+\nfIOD7MU30TUjylL5F1TH4F7Wco3Oh/TA1GmiOo3n3Jw/Jwp/SO/cRehHgG0P5Inh\nod01LhGYR8IWYhNE0/xW5AmohOMPrPrFvGhZYdea8q5lDUgMOAhJ6HcVtX916i30\nBOZRJT6YBZ1+gM11j+uzVH1POrPRpBKIG2mFXIENyykcUH1/fzZq6nCYQRkRqwGW\nQqr/W736U+9O7maGgwiyyB1Qoh009siTxLjIHPWqu+Uv99CKYioPv87dUpXRrG/w\nT03SRkawusIfxjWkchmxr1AZmJmC+k4fvfPp1U4CPgBpN/bn0/z+jacWe7P6XSV2\nA7uW95WfCmbke4rc", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "UFRPE - Universidade Federal Rural de Pernambuco", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }, 
          {
            "lang": "pt-br", 
            "text": "UFRPE - Universidade Federal Rural de Pernambuco", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "UFRPE - Universidade Federal Rural de Pernambuco", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }, 
          {
            "lang": "pt-br", 
            "text": "UFRPE - Universidade Federal Rural de Pernambuco", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.ufrpe.br/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }, 
          {
            "lang": "pt-br", 
            "text": "http://www.ufrpe.br/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "email_address": [
            {
              "text": "coord.suporte@nti.ufrpe.br", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Fred Medeiros", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://www.jwatch.org/shibboleth", 
    {
      "entity_id": "https://www.jwatch.org/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/www.jwatch.org.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "organization": {
        "organization_name": [
          {
            "lang": "de", 
            "text": "Journal Watch", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "Journal Watch", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "http://www.jwatch.org/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Ryan", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "shibboleth-admin@highwire.stanford.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Krebs", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "shibboleth.highwire.org", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=shibboleth.highwire.org", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIDOjCCAiKgAwIBAgIBADANBgkqhkiG9w0BAQQFADAiMSAwHgYDVQQDExdzaGli\nYm9sZXRoLmhpZ2h3aXJlLm9yZzAeFw0xMTA1MjMyMzIwNTVaFw0xNDA1MjIyMzIw\nNTVaMCIxIDAeBgNVBAMTF3NoaWJib2xldGguaGlnaHdpcmUub3JnMIIBIjANBgkq\nhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwPqatbaGYPuGmKF9zuEEmyun2/v2UMRB\n2zWg0l6T5Evy9vHSwmPqmhZF62oIdm1IWNjZNbl5JhXCLOJPNtVRnnqxbGfdJLWF\nJoAnY6ZuU3jNiO4Ocu+G1K0Dn6AA3nWvgV99wQvWZmrQaMSoQUm3T9avPPr8xgIs\nGLM4DmMtxVbx2q9muUkV8dafX26lIBZuHtlW2cdnEtf/Ezm5+us9xtz0XKzdgaoL\nEV3i4e47w7Mdpms2M6+JGyk0KwcsYmZLf5LFnWgI/5JMAv+mUZEKNoQFHH1qNiLj\n8HO3cl5KFCUbhpdTKq6EU3DBz1shcxQUG7sykXtdhLefP6iVf9kfKQIDAQABo3sw\neTAdBgNVHQ4EFgQU/YLrmdITx8wbuLe37oAx96MP0bwwSgYDVR0jBEMwQYAU/YLr\nmdITx8wbuLe37oAx96MP0byhJqQkMCIxIDAeBgNVBAMTF3NoaWJib2xldGguaGln\naHdpcmUub3JnggEAMAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEEBQADggEBAGwG\ngkjqlP/+vS8djbKbENIVbKJfqsGM1inuvxERJpwTXoASXTJIpMds1/N16j3s1P1j\n5+UHIdD29vMyukXjLqYY0rd3/xPJ1Sm+w1mnLBgfdE0YMVlQ/zN4ZoyEIzUDA+XS\nf6chvj10tDpE5V3rxLHli6GEo0n848TU2jy5Q0dpmUgtRsn691OviUWNrgGBkaC4\nBbMczrg56rOzqdmn5SIhPt+RzRVn0gnM4eoAThpHg9jLt5SvhNChqOwnY+PByLbB\nY4UozdQzsttgTsqCAAhNXTQQq71Hxvnanm0ak3RKkPQW/tSFsdjiTWDGp2z2djDP\n+d1ZBewNsC/cUy447ok=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "shibboleth.highwire.org", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=shibboleth.highwire.org", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIDOjCCAiKgAwIBAgIBADANBgkqhkiG9w0BAQQFADAiMSAwHgYDVQQDExdzaGli\nYm9sZXRoLmhpZ2h3aXJlLm9yZzAeFw0xMTA1MjMyMzIwNTVaFw0xNDA1MjIyMzIw\nNTVaMCIxIDAeBgNVBAMTF3NoaWJib2xldGguaGlnaHdpcmUub3JnMIIBIjANBgkq\nhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwPqatbaGYPuGmKF9zuEEmyun2/v2UMRB\n2zWg0l6T5Evy9vHSwmPqmhZF62oIdm1IWNjZNbl5JhXCLOJPNtVRnnqxbGfdJLWF\nJoAnY6ZuU3jNiO4Ocu+G1K0Dn6AA3nWvgV99wQvWZmrQaMSoQUm3T9avPPr8xgIs\nGLM4DmMtxVbx2q9muUkV8dafX26lIBZuHtlW2cdnEtf/Ezm5+us9xtz0XKzdgaoL\nEV3i4e47w7Mdpms2M6+JGyk0KwcsYmZLf5LFnWgI/5JMAv+mUZEKNoQFHH1qNiLj\n8HO3cl5KFCUbhpdTKq6EU3DBz1shcxQUG7sykXtdhLefP6iVf9kfKQIDAQABo3sw\neTAdBgNVHQ4EFgQU/YLrmdITx8wbuLe37oAx96MP0bwwSgYDVR0jBEMwQYAU/YLr\nmdITx8wbuLe37oAx96MP0byhJqQkMCIxIDAeBgNVBAMTF3NoaWJib2xldGguaGln\naHdpcmUub3JnggEAMAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEEBQADggEBAGwG\ngkjqlP/+vS8djbKbENIVbKJfqsGM1inuvxERJpwTXoASXTJIpMds1/N16j3s1P1j\n5+UHIdD29vMyukXjLqYY0rd3/xPJ1Sm+w1mnLBgfdE0YMVlQ/zN4ZoyEIzUDA+XS\nf6chvj10tDpE5V3rxLHli6GEo0n848TU2jy5Q0dpmUgtRsn691OviUWNrgGBkaC4\nBbMczrg56rOzqdmn5SIhPt+RzRVn0gnM4eoAThpHg9jLt5SvhNChqOwnY+PByLbB\nY4UozdQzsttgTsqCAAhNXTQQq71Hxvnanm0ak3RKkPQW/tSFsdjiTWDGp2z2djDP\n+d1ZBewNsC/cUy447ok=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://shibboleth.highwire.org/applications/jnlwatch/Shibboleth.sso/SAML/Artifact"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://shibboleth.highwire.org/applications/jnlwatch/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://shibboleth.highwire.org/applications/jnlwatch/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://shibboleth.highwire.org/applications/jnlwatch/Shibboleth.sso/SAML2/POST"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://idp.ph-freiburg.de/idp/shibboleth", 
    {
      "entity_id": "https://idp.ph-freiburg.de/idp/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/idp.ph-freiburg.de.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.ph-freiburg.de/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.ph-freiburg.de/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.ph-freiburg.de/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.ph-freiburg.de/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "ph-freiburg.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "text": "idp.ph-freiburg.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=idp.ph-freiburg.de,O=Paedagogische Hochschule Freiburg,L=Freiburg,ST=Baden-Wuerttemberg,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFYDCCBEigAwIBAgIED0XYvTANBgkqhkiG9w0BAQUFADCBrTELMAkGA1UEBhMC\nREUxGzAZBgNVBAgTEkJhZGVuLVd1ZXJ0dGVtYmVyZzERMA8GA1UEBxMIRnJlaWJ1\ncmcxKjAoBgNVBAoTIVBhZWRhZ29naXNjaGUgSG9jaHNjaHVsZSBGcmVpYnVyZzEM\nMAoGA1UECxMDWklLMREwDwYDVQQDEwhQSC1GUiBDQTEhMB8GCSqGSIb3DQEJARYS\ncGtpQHBoLWZyZWlidXJnLmRlMB4XDTA5MTIxNDE1MzUxMFoXDTE0MTIxMzE1MzUx\nMFowgYYxCzAJBgNVBAYTAkRFMRswGQYDVQQIExJCYWRlbi1XdWVydHRlbWJlcmcx\nETAPBgNVBAcTCEZyZWlidXJnMSowKAYDVQQKEyFQYWVkYWdvZ2lzY2hlIEhvY2hz\nY2h1bGUgRnJlaWJ1cmcxGzAZBgNVBAMTEmlkcC5waC1mcmVpYnVyZy5kZTCCASIw\nDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAM828KxElHwjl/c6j9CG8AFT+y7J\n4w4yw0qc9Up8zZtzQPuJa+xaG3D3vDcfYB12i2mqdsOrB2ONYUSBgq29myZ6h1kx\nSqQTuOS0Ms+L6xH40XYkApDq76knlDgSzVWy3rnoT539QXLwyo5lMjqqo+/1a5hV\nKP3fygx0BRO45IGgfgvvjSHvEuxWOSTFYSFawj1QhZj1Kdr5LORt1BhG02QADVnA\nj4cTA3gv9O/MN9MnViBM4Vmp4pIUi7SgcwGLxAQcDgoaA4LADU2PF2qsoKCdJOv9\nW4LKtLLqv8rrLajinD/F6rFfbF0Y0MkiE/wQKHY6+DE2LbP5EZwSc8vj5a8CAwEA\nAaOCAaswggGnMAkGA1UdEwQCMAAwCwYDVR0PBAQDAgXgMB0GA1UdJQQWMBQGCCsG\nAQUFBwMCBggrBgEFBQcDATAdBgNVHQ4EFgQUbBM+NKAEus52mOzdt5CcTaSKs8Qw\nHwYDVR0jBBgwFoAUcc1Tb+nFrN3ri2RPPjhAO2OMRaIwgYgGA1UdHwSBgDB+MD2g\nO6A5hjdodHRwOi8vY2RwMS5wY2EuZGZuLmRlL3BoLWZyZWlidXJnLWNhL3B1Yi9j\ncmwvY2FjcmwuY3JsMD2gO6A5hjdodHRwOi8vY2RwMi5wY2EuZGZuLmRlL3BoLWZy\nZWlidXJnLWNhL3B1Yi9jcmwvY2FjcmwuY3JsMIGiBggrBgEFBQcBAQSBlTCBkjBH\nBggrBgEFBQcwAoY7aHR0cDovL2NkcDEucGNhLmRmbi5kZS9waC1mcmVpYnVyZy1j\nYS9wdWIvY2FjZXJ0L2NhY2VydC5jcnQwRwYIKwYBBQUHMAKGO2h0dHA6Ly9jZHAy\nLnBjYS5kZm4uZGUvcGgtZnJlaWJ1cmctY2EvcHViL2NhY2VydC9jYWNlcnQuY3J0\nMA0GCSqGSIb3DQEBBQUAA4IBAQB50CER7ZpXfLAHmrAOUCQXWTDAYWmRCx+kuM93\nLmsV51v9wj3ABXW6gTYf5/uBOqepakXVh6F4UDrOMudsyANOGVAyjKKGsf9O80y2\nRcB44enObtzulPJruBlTjuDeJa0JMG2fktq/G24OQ0EbsE/iU7Bjzi/bhBJ8PZ/Q\n+C2L4u2g+MzuP715KXq0TvF1WrqU6E4SlNo57GGwOTEcc236ldrWkA7E2c27x0Gr\nACQ2fRteTKA1w2KTSEDlL+tI4L0fj4Vs/6utxsFGQKsLlZh3XYJV6UN+LWuuV4Ld\nskKvylp9V9RQYU0paW2EUEcSWQ4LqNBNFBfyMYd0FkhipnTt", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://idp.ph-freiburg.de:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://idp.ph-freiburg.de:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://idp.ph-freiburg.de:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://idp.ph-freiburg.de:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "ph-freiburg.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "text": "idp.ph-freiburg.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=idp.ph-freiburg.de,O=Paedagogische Hochschule Freiburg,L=Freiburg,ST=Baden-Wuerttemberg,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFYDCCBEigAwIBAgIED0XYvTANBgkqhkiG9w0BAQUFADCBrTELMAkGA1UEBhMC\nREUxGzAZBgNVBAgTEkJhZGVuLVd1ZXJ0dGVtYmVyZzERMA8GA1UEBxMIRnJlaWJ1\ncmcxKjAoBgNVBAoTIVBhZWRhZ29naXNjaGUgSG9jaHNjaHVsZSBGcmVpYnVyZzEM\nMAoGA1UECxMDWklLMREwDwYDVQQDEwhQSC1GUiBDQTEhMB8GCSqGSIb3DQEJARYS\ncGtpQHBoLWZyZWlidXJnLmRlMB4XDTA5MTIxNDE1MzUxMFoXDTE0MTIxMzE1MzUx\nMFowgYYxCzAJBgNVBAYTAkRFMRswGQYDVQQIExJCYWRlbi1XdWVydHRlbWJlcmcx\nETAPBgNVBAcTCEZyZWlidXJnMSowKAYDVQQKEyFQYWVkYWdvZ2lzY2hlIEhvY2hz\nY2h1bGUgRnJlaWJ1cmcxGzAZBgNVBAMTEmlkcC5waC1mcmVpYnVyZy5kZTCCASIw\nDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAM828KxElHwjl/c6j9CG8AFT+y7J\n4w4yw0qc9Up8zZtzQPuJa+xaG3D3vDcfYB12i2mqdsOrB2ONYUSBgq29myZ6h1kx\nSqQTuOS0Ms+L6xH40XYkApDq76knlDgSzVWy3rnoT539QXLwyo5lMjqqo+/1a5hV\nKP3fygx0BRO45IGgfgvvjSHvEuxWOSTFYSFawj1QhZj1Kdr5LORt1BhG02QADVnA\nj4cTA3gv9O/MN9MnViBM4Vmp4pIUi7SgcwGLxAQcDgoaA4LADU2PF2qsoKCdJOv9\nW4LKtLLqv8rrLajinD/F6rFfbF0Y0MkiE/wQKHY6+DE2LbP5EZwSc8vj5a8CAwEA\nAaOCAaswggGnMAkGA1UdEwQCMAAwCwYDVR0PBAQDAgXgMB0GA1UdJQQWMBQGCCsG\nAQUFBwMCBggrBgEFBQcDATAdBgNVHQ4EFgQUbBM+NKAEus52mOzdt5CcTaSKs8Qw\nHwYDVR0jBBgwFoAUcc1Tb+nFrN3ri2RPPjhAO2OMRaIwgYgGA1UdHwSBgDB+MD2g\nO6A5hjdodHRwOi8vY2RwMS5wY2EuZGZuLmRlL3BoLWZyZWlidXJnLWNhL3B1Yi9j\ncmwvY2FjcmwuY3JsMD2gO6A5hjdodHRwOi8vY2RwMi5wY2EuZGZuLmRlL3BoLWZy\nZWlidXJnLWNhL3B1Yi9jcmwvY2FjcmwuY3JsMIGiBggrBgEFBQcBAQSBlTCBkjBH\nBggrBgEFBQcwAoY7aHR0cDovL2NkcDEucGNhLmRmbi5kZS9waC1mcmVpYnVyZy1j\nYS9wdWIvY2FjZXJ0L2NhY2VydC5jcnQwRwYIKwYBBQUHMAKGO2h0dHA6Ly9jZHAy\nLnBjYS5kZm4uZGUvcGgtZnJlaWJ1cmctY2EvcHViL2NhY2VydC9jYWNlcnQuY3J0\nMA0GCSqGSIb3DQEBBQUAA4IBAQB50CER7ZpXfLAHmrAOUCQXWTDAYWmRCx+kuM93\nLmsV51v9wj3ABXW6gTYf5/uBOqepakXVh6F4UDrOMudsyANOGVAyjKKGsf9O80y2\nRcB44enObtzulPJruBlTjuDeJa0JMG2fktq/G24OQ0EbsE/iU7Bjzi/bhBJ8PZ/Q\n+C2L4u2g+MzuP715KXq0TvF1WrqU6E4SlNo57GGwOTEcc236ldrWkA7E2c27x0Gr\nACQ2fRteTKA1w2KTSEDlL+tI4L0fj4Vs/6utxsFGQKsLlZh3XYJV6UN+LWuuV4Ld\nskKvylp9V9RQYU0paW2EUEcSWQ4LqNBNFBfyMYd0FkhipnTt", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "de", 
            "text": "P\u00e4dagogische Hochschule Freiburg", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "PH-Freiburg", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "http://www.ph-freiburg.de/zik/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Stephan", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "lauffer@ph-freiburg.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Lauffer", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Martin", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "duffner@ph-freiburg.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Duffner", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }
      ]
    }
  ], 
  [
    "https://mds.sunet.se/shibboleth", 
    {
      "entity_id": "https://mds.sunet.se/shibboleth", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://mds.sunet.se/Shibboleth.sso/SLO/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://mds.sunet.se/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://mds.sunet.se/Shibboleth.sso/SLO/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://mds.sunet.se/Shibboleth.sso/SLO/Artifact"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://mds.sunet.se/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://mds.sunet.se/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://mds.sunet.se/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://mds.sunet.se/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://mds.sunet.se/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://mds.sunet.se/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://mds.sunet.se/Shibboleth.sso/DS/ds.sunet.se"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "mds.sunet.se", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=mds.sunet.se", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIC+TCCAeGgAwIBAgIJAOvVefVlKf4tMA0GCSqGSIb3DQEBBQUAMBcxFTATBgNV\nBAMTDG1kcy5zdW5ldC5zZTAeFw0xMTEwMDMwOTIwMDRaFw0yMTA5MzAwOTIwMDRa\nMBcxFTATBgNVBAMTDG1kcy5zdW5ldC5zZTCCASIwDQYJKoZIhvcNAQEBBQADggEP\nADCCAQoCggEBAMM1mRFzygysIo9Qw7XabyoIe0nbATiS428GJ2oB3PSDLjmnf1CI\nkXwSBogHyAvdmQF04QCxeGki39cib/hTsxEbA14iGc/uyEbs4tFMgPvSPh3t8Uos\n1a8iHngnjpA0VuBH7VP3w0nCvj1eV5EobHKVk0NLgtXDgl87w6COPEre/5QN9IBf\n0/M7uO7zueXhpAzyO2+u+tZN2uacy5L2KTdiFxvFHAjaEjMnlVzbD7wehALIXNBg\nxtHUSITj2nwTjq7X/3sQbrusYL9DrW7RKLzzLSuHxRr4Dz+PESOjZUxBjTcwE4uJ\n2fmPuHfCtsxXHUnm7Ap3Df5I1exmSjc3inkCAwEAAaNIMEYwJQYDVR0RBB4wHIIM\nbWRzLnN1bmV0LnNlhgxtZHMuc3VuZXQuc2UwHQYDVR0OBBYEFB+CPP645D+t0FSk\n/40HaWtGmOP6MA0GCSqGSIb3DQEBBQUAA4IBAQAz/rf6fDHJU8Dp6hahHkVNRWRu\ncdVruda7guUIJ6MQWgl1N9Twfm2OvUSaM5fPtsqfoYTkv4ThVs8vGYyw+Y2oAnBa\nXKvUeP6S6et7cKQZCtpi9UgK8s1dHK7oqJaluW9tGes1Mcer/qKFdYunLlXYi8PA\nPRgEOb2hquFNE5V+0vXeiVqo/fAhlHxZ5jJbSQ2RnnN7ycVCQDZZlaEYPrGpaZVS\n9gYHwnECD5EPl8QsVymK2Co28pXAwpdo4btmWAeDhmy+8yOMjoS+T3k+/wiEmLLp\ndnjCadQzQamnqs4mfuypLT2wWWjkat9QKAM9gHkMwcC1Uv2RM2QeR8FDySJX", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "mds.sunet.se", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=mds.sunet.se", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIC+TCCAeGgAwIBAgIJAOvVefVlKf4tMA0GCSqGSIb3DQEBBQUAMBcxFTATBgNV\nBAMTDG1kcy5zdW5ldC5zZTAeFw0xMTEwMDMwOTIwMDRaFw0yMTA5MzAwOTIwMDRa\nMBcxFTATBgNVBAMTDG1kcy5zdW5ldC5zZTCCASIwDQYJKoZIhvcNAQEBBQADggEP\nADCCAQoCggEBAMM1mRFzygysIo9Qw7XabyoIe0nbATiS428GJ2oB3PSDLjmnf1CI\nkXwSBogHyAvdmQF04QCxeGki39cib/hTsxEbA14iGc/uyEbs4tFMgPvSPh3t8Uos\n1a8iHngnjpA0VuBH7VP3w0nCvj1eV5EobHKVk0NLgtXDgl87w6COPEre/5QN9IBf\n0/M7uO7zueXhpAzyO2+u+tZN2uacy5L2KTdiFxvFHAjaEjMnlVzbD7wehALIXNBg\nxtHUSITj2nwTjq7X/3sQbrusYL9DrW7RKLzzLSuHxRr4Dz+PESOjZUxBjTcwE4uJ\n2fmPuHfCtsxXHUnm7Ap3Df5I1exmSjc3inkCAwEAAaNIMEYwJQYDVR0RBB4wHIIM\nbWRzLnN1bmV0LnNlhgxtZHMuc3VuZXQuc2UwHQYDVR0OBBYEFB+CPP645D+t0FSk\n/40HaWtGmOP6MA0GCSqGSIb3DQEBBQUAA4IBAQAz/rf6fDHJU8Dp6hahHkVNRWRu\ncdVruda7guUIJ6MQWgl1N9Twfm2OvUSaM5fPtsqfoYTkv4ThVs8vGYyw+Y2oAnBa\nXKvUeP6S6et7cKQZCtpi9UgK8s1dHK7oqJaluW9tGes1Mcer/qKFdYunLlXYi8PA\nPRgEOb2hquFNE5V+0vXeiVqo/fAhlHxZ5jJbSQ2RnnN7ycVCQDZZlaEYPrGpaZVS\n9gYHwnECD5EPl8QsVymK2Co28pXAwpdo4btmWAeDhmy+8yOMjoS+T3k+/wiEmLLp\ndnjCadQzQamnqs4mfuypLT2wWWjkat9QKAM9gHkMwcC1Uv2RM2QeR8FDySJX", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://mds.sunet.se/Shibboleth.sso/Artifact/SOAP"
            }
          ], 
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://mds.sunet.se/Shibboleth.sso/NIM/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://mds.sunet.se/Shibboleth.sso/NIM/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://mds.sunet.se/Shibboleth.sso/NIM/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://mds.sunet.se/Shibboleth.sso/NIM/Artifact"
            }
          ]
        }
      ], 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-2.0/mds.sunet.se-shibboleth.xml"
      }
    }
  ], 
  [
    "https://idp.it.gu.se/idp/shibboleth", 
    {
      "entity_id": "https://idp.it.gu.se/idp/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-2.0/idp.it.gu.se-idp-shibboleth.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.it.gu.se/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.it.gu.se/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.it.gu.se/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.it.gu.se/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "gu.se", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "logo": [
                  {
                    "lang": "sv", 
                    "text": "https://www.gu.se/digitalAssets/1374/1374690_lo_gu_left.png", 
                    "width": "344", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo", 
                    "height": "50"
                  }, 
                  {
                    "lang": "en", 
                    "text": "https://www.gu.se/digitalAssets/1374/1374690_lo_gu_left.png", 
                    "width": "376", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo", 
                    "height": "50"
                  }
                ], 
                "display_name": [
                  {
                    "lang": "sv", 
                    "text": "G\u00f6teborgs Universitet", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }, 
                  {
                    "lang": "en", 
                    "text": "University of Gothenburg", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "sv", 
                    "text": "Identity Provider f\u00f6r anst\u00e4llda och studenter vid G\u00f6teborgs universitet.", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }, 
                  {
                    "lang": "en", 
                    "text": "The University of Gothenburg Identity Provider is used by employees and students at the university.", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }, 
              {
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DiscoHints", 
                "geolocation_hint": [
                  {
                    "text": "geo:57.6986,11.9712", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&GeolocationHint"
                  }
                ], 
                "domain_hint": [
                  {
                    "text": "gu.se", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DomainHint"
                  }
                ]
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDGzCCAgOgAwIBAgIUGLU4YqWFYHboh+F+iLNYkBw8XNAwDQYJKoZIhvcNAQEF\nBQAwFzEVMBMGA1UEAxMMaWRwLml0Lmd1LnNlMB4XDTA5MDgyNDExMzA1OFoXDTI5\nMDgyNDExMzA1OFowFzEVMBMGA1UEAxMMaWRwLml0Lmd1LnNlMIIBIjANBgkqhkiG\n9w0BAQEFAAOCAQ8AMIIBCgKCAQEApOVkzaHuTCe+7lf79UnQ5iQ/8OLbJpwOxPTF\nwEPIHbMMU/aCVnxoZnwNApblqvpP2uOsQvh8d0uDv2iVC5BMN0ff9M+9rN7D/gAo\nL+w8CmWiHRudKyZLu8Gu89SGxyQ59AVCbJzGaEE9h/CmMYHCj/ONJ8mtjG9uw6u+\nVj+L8PHXsPHQsLvcl3/D7duIYH/xHRbPzXS0imux+r/OcSCR3aCPCx3uuAfVPxGS\n9Y/ifynV586V3szIM7O15SeXKenFMKjQhzA23ZPcHhDSxWnVGUDWFDRDNAXfD7BF\nKRBCaUlWZvczqsV3eGtW8XgOmuW/7yJT5REfrrSLOKprAK8yoQIDAQABo18wXTA8\nBgNVHREENTAzggxpZHAuaXQuZ3Uuc2WGI2h0dHBzOi8vaWRwLml0Lmd1LnNlL2lk\ncC9zaGliYm9sZXRoMB0GA1UdDgQWBBSpKDUl7ZRxhQ1/HRmVbFd+NbwxmzANBgkq\nhkiG9w0BAQUFAAOCAQEAXfaYlHQj4KRaJmMbWFV0XyNUlHNio8010vLv3t6WztlZ\njZFL/hTQIFhmYEA04Davdk+1/1JvcRePSpg2VCxT/QwHyOR3eimmQ6FKXWls/zO/\nV01sJrlLdf/53pzXYsVSOf50UK+GtrSB3hhzrFmeaBALOysGqk2h2/UdYISXxa/e\nMyQ/aOI5u+0Wlq2RdIXF8MrtnwBTRhNXLcXYzz4fPsdjd4TmmJLQLXLmFLE/IA+/\nCP9nuvekzvPla7AXlXPwPvbUunwZIZkN3aHzMY/08FKIYRLb9VmqInKXw8tIBSqG\nMoX9SCDPBh2j39QZupTaPkylXDshurod7B2XtXdHPg==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://idp.it.gu.se:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://idp.it.gu.se:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://idp.it.gu.se:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://idp.it.gu.se:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "gu.se", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDGzCCAgOgAwIBAgIUGLU4YqWFYHboh+F+iLNYkBw8XNAwDQYJKoZIhvcNAQEF\nBQAwFzEVMBMGA1UEAxMMaWRwLml0Lmd1LnNlMB4XDTA5MDgyNDExMzA1OFoXDTI5\nMDgyNDExMzA1OFowFzEVMBMGA1UEAxMMaWRwLml0Lmd1LnNlMIIBIjANBgkqhkiG\n9w0BAQEFAAOCAQ8AMIIBCgKCAQEApOVkzaHuTCe+7lf79UnQ5iQ/8OLbJpwOxPTF\nwEPIHbMMU/aCVnxoZnwNApblqvpP2uOsQvh8d0uDv2iVC5BMN0ff9M+9rN7D/gAo\nL+w8CmWiHRudKyZLu8Gu89SGxyQ59AVCbJzGaEE9h/CmMYHCj/ONJ8mtjG9uw6u+\nVj+L8PHXsPHQsLvcl3/D7duIYH/xHRbPzXS0imux+r/OcSCR3aCPCx3uuAfVPxGS\n9Y/ifynV586V3szIM7O15SeXKenFMKjQhzA23ZPcHhDSxWnVGUDWFDRDNAXfD7BF\nKRBCaUlWZvczqsV3eGtW8XgOmuW/7yJT5REfrrSLOKprAK8yoQIDAQABo18wXTA8\nBgNVHREENTAzggxpZHAuaXQuZ3Uuc2WGI2h0dHBzOi8vaWRwLml0Lmd1LnNlL2lk\ncC9zaGliYm9sZXRoMB0GA1UdDgQWBBSpKDUl7ZRxhQ1/HRmVbFd+NbwxmzANBgkq\nhkiG9w0BAQUFAAOCAQEAXfaYlHQj4KRaJmMbWFV0XyNUlHNio8010vLv3t6WztlZ\njZFL/hTQIFhmYEA04Davdk+1/1JvcRePSpg2VCxT/QwHyOR3eimmQ6FKXWls/zO/\nV01sJrlLdf/53pzXYsVSOf50UK+GtrSB3hhzrFmeaBALOysGqk2h2/UdYISXxa/e\nMyQ/aOI5u+0Wlq2RdIXF8MrtnwBTRhNXLcXYzz4fPsdjd4TmmJLQLXLmFLE/IA+/\nCP9nuvekzvPla7AXlXPwPvbUunwZIZkN3aHzMY/08FKIYRLb9VmqInKXw8tIBSqG\nMoX9SCDPBh2j39QZupTaPkylXDshurod7B2XtXdHPg==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "GU", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "sv", 
            "text": "G\u00f6teborgs Universitet", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }, 
          {
            "lang": "en", 
            "text": "University of Gothenburg", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.gu.se", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "company": {
            "text": "G\u00f6teborgs universitet", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Company"
          }, 
          "email_address": [
            {
              "text": "pablo.millet@gu.se", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://ephraim.tu-berlin.de/shibboleth", 
    {
      "entity_id": "https://ephraim.tu-berlin.de/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/ephraim.tu-berlin.de.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibboleth.tubit.tu-berlin.de/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibboleth.tubit.tu-berlin.de/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibboleth.tubit.tu-berlin.de/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibboleth.tubit.tu-berlin.de/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "tu-berlin.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "shibboleth.tubit.tu-berlin.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=shibboleth.tubit.tu-berlin.de,OU=tubIT,O=Technische Universitaet Berlin,L=Berlin,ST=Berlin,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFMzCCBBugAwIBAgIEDied9zANBgkqhkiG9w0BAQUFADBnMQswCQYDVQQGEwJE\nRTEnMCUGA1UEChMeVGVjaG5pc2NoZSBVbml2ZXJzaXRhZXQgQmVybGluMQ8wDQYD\nVQQDEwZUVUItQ0ExHjAcBgkqhkiG9w0BCQEWD2NhQFRVLUJlcmxpbi5ERTAeFw0w\nOTA1MTExMjU2MDhaFw0xNDA1MTAxMjU2MDhaMIGQMQswCQYDVQQGEwJERTEPMA0G\nA1UECBMGQmVybGluMQ8wDQYDVQQHEwZCZXJsaW4xJzAlBgNVBAoTHlRlY2huaXNj\naGUgVW5pdmVyc2l0YWV0IEJlcmxpbjEOMAwGA1UECxMFdHViSVQxJjAkBgNVBAMT\nHXNoaWJib2xldGgudHViaXQudHUtYmVybGluLmRlMIIBIjANBgkqhkiG9w0BAQEF\nAAOCAQ8AMIIBCgKCAQEA3qUvqkY4p+iLKlQ33hRjbJWVMsJh7Qk7+dbJcbS+X269\nfnOt0pJKGybCHzpGN6bSPixm+pteRQ/ZfdSo7+3Th0YDBstBapNGkw61rnQpOOxm\nds3hH4yooAOYbf3pGaE1Rm8aCwq9cDODLwtujd/qgCChVL1k+pFHtHhov0M98AZ2\nQF1IM9+sYWSttbcTJ8TnE4oQH6MUftHiE6TNtEfKWOkgx8BK1XP3OGEd0qBYAuGl\npwMC6ublvAMSTg46rLxP04x73MbsXY9gGpaszUBRjJKKIC4Cdo+JndIgx+CTN9r5\nVVXnjOV5ryhSTD7rT7koyzaBkgLWtURysx3p/j4xLwIDAQABo4IBuzCCAbcwCQYD\nVR0TBAIwADALBgNVHQ8EBAMCBPAwEwYDVR0lBAwwCgYIKwYBBQUHAwEwHQYDVR0O\nBBYEFKurFzJOpMsyIAwwO3BAbZxryLf6MB8GA1UdIwQYMBaAFCMyQp7+YkJO+07Q\nF5t45+2KjD54MCEGA1UdEQQaMBiBFmlkbUB0dWJpdC50dS1iZXJsaW4uZGUwgYMG\nA1UdHwR8MHowO6A5oDeGNWh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvdHUtYmVybGlu\nLWNhL3B1Yi9jcmwvY2FjcmwuY3JsMDugOaA3hjVodHRwOi8vY2RwMi5wY2EuZGZu\nLmRlL3R1LWJlcmxpbi1jYS9wdWIvY3JsL2NhY3JsLmNybDCBngYIKwYBBQUHAQEE\ngZEwgY4wRQYIKwYBBQUHMAKGOWh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvdHUtYmVy\nbGluLWNhL3B1Yi9jYWNlcnQvY2FjZXJ0LmNydDBFBggrBgEFBQcwAoY5aHR0cDov\nL2NkcDIucGNhLmRmbi5kZS90dS1iZXJsaW4tY2EvcHViL2NhY2VydC9jYWNlcnQu\nY3J0MA0GCSqGSIb3DQEBBQUAA4IBAQAwzxECaQ3fX5bZPlaszbbLGAodZW2VkUS8\ncyOASU1zQW0wArj4MolDZ+LZnEBCEVQwTD4bFlcQDIVeqeSbuDNXcnYtC9DKhdjQ\nyor//cu1WZ6zcUa+2NYjNMcCAj0qM1fraYaM3hPTCGREL/BjjKeENgduAmWKQeRM\n3X7Hw1sTK0Y0IfQVNsORi8H7bZDbtTKOR1eYIWRndHbNtKuRgEIG4Ud2FMjl+iX6\ntSNMelecSxtYYjrOFp4SiZDG5LCjEVoRSPwhBAOV+iMOAjqlGA4L+cqDyrWRKYb4\nsXWbU7+qrckzBNerB/L9cym1gAeK1LvL7WG3LhHY9AywW34Ewwe7", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "shibboleth.tubit.tu-berlin.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=shibboleth.tubit.tu-berlin.de,OU=tubIT,O=Technische Universitaet Berlin,L=Berlin,ST=Berlin,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFMzCCBBugAwIBAgIEDied9zANBgkqhkiG9w0BAQUFADBnMQswCQYDVQQGEwJE\nRTEnMCUGA1UEChMeVGVjaG5pc2NoZSBVbml2ZXJzaXRhZXQgQmVybGluMQ8wDQYD\nVQQDEwZUVUItQ0ExHjAcBgkqhkiG9w0BCQEWD2NhQFRVLUJlcmxpbi5ERTAeFw0w\nOTA1MTExMjU2MDhaFw0xNDA1MTAxMjU2MDhaMIGQMQswCQYDVQQGEwJERTEPMA0G\nA1UECBMGQmVybGluMQ8wDQYDVQQHEwZCZXJsaW4xJzAlBgNVBAoTHlRlY2huaXNj\naGUgVW5pdmVyc2l0YWV0IEJlcmxpbjEOMAwGA1UECxMFdHViSVQxJjAkBgNVBAMT\nHXNoaWJib2xldGgudHViaXQudHUtYmVybGluLmRlMIIBIjANBgkqhkiG9w0BAQEF\nAAOCAQ8AMIIBCgKCAQEA3qUvqkY4p+iLKlQ33hRjbJWVMsJh7Qk7+dbJcbS+X269\nfnOt0pJKGybCHzpGN6bSPixm+pteRQ/ZfdSo7+3Th0YDBstBapNGkw61rnQpOOxm\nds3hH4yooAOYbf3pGaE1Rm8aCwq9cDODLwtujd/qgCChVL1k+pFHtHhov0M98AZ2\nQF1IM9+sYWSttbcTJ8TnE4oQH6MUftHiE6TNtEfKWOkgx8BK1XP3OGEd0qBYAuGl\npwMC6ublvAMSTg46rLxP04x73MbsXY9gGpaszUBRjJKKIC4Cdo+JndIgx+CTN9r5\nVVXnjOV5ryhSTD7rT7koyzaBkgLWtURysx3p/j4xLwIDAQABo4IBuzCCAbcwCQYD\nVR0TBAIwADALBgNVHQ8EBAMCBPAwEwYDVR0lBAwwCgYIKwYBBQUHAwEwHQYDVR0O\nBBYEFKurFzJOpMsyIAwwO3BAbZxryLf6MB8GA1UdIwQYMBaAFCMyQp7+YkJO+07Q\nF5t45+2KjD54MCEGA1UdEQQaMBiBFmlkbUB0dWJpdC50dS1iZXJsaW4uZGUwgYMG\nA1UdHwR8MHowO6A5oDeGNWh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvdHUtYmVybGlu\nLWNhL3B1Yi9jcmwvY2FjcmwuY3JsMDugOaA3hjVodHRwOi8vY2RwMi5wY2EuZGZu\nLmRlL3R1LWJlcmxpbi1jYS9wdWIvY3JsL2NhY3JsLmNybDCBngYIKwYBBQUHAQEE\ngZEwgY4wRQYIKwYBBQUHMAKGOWh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvdHUtYmVy\nbGluLWNhL3B1Yi9jYWNlcnQvY2FjZXJ0LmNydDBFBggrBgEFBQcwAoY5aHR0cDov\nL2NkcDIucGNhLmRmbi5kZS90dS1iZXJsaW4tY2EvcHViL2NhY2VydC9jYWNlcnQu\nY3J0MA0GCSqGSIb3DQEBBQUAA4IBAQAwzxECaQ3fX5bZPlaszbbLGAodZW2VkUS8\ncyOASU1zQW0wArj4MolDZ+LZnEBCEVQwTD4bFlcQDIVeqeSbuDNXcnYtC9DKhdjQ\nyor//cu1WZ6zcUa+2NYjNMcCAj0qM1fraYaM3hPTCGREL/BjjKeENgduAmWKQeRM\n3X7Hw1sTK0Y0IfQVNsORi8H7bZDbtTKOR1eYIWRndHbNtKuRgEIG4Ud2FMjl+iX6\ntSNMelecSxtYYjrOFp4SiZDG5LCjEVoRSPwhBAOV+iMOAjqlGA4L+cqDyrWRKYb4\nsXWbU7+qrckzBNerB/L9cym1gAeK1LvL7WG3LhHY9AywW34Ewwe7", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://shibboleth.tubit.tu-berlin.de:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://shibboleth.tubit.tu-berlin.de:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://shibboleth.tubit.tu-berlin.de:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://shibboleth.tubit.tu-berlin.de:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "tu-berlin.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "shibboleth.tubit.tu-berlin.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=shibboleth.tubit.tu-berlin.de,OU=tubIT,O=Technische Universitaet Berlin,L=Berlin,ST=Berlin,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFMzCCBBugAwIBAgIEDied9zANBgkqhkiG9w0BAQUFADBnMQswCQYDVQQGEwJE\nRTEnMCUGA1UEChMeVGVjaG5pc2NoZSBVbml2ZXJzaXRhZXQgQmVybGluMQ8wDQYD\nVQQDEwZUVUItQ0ExHjAcBgkqhkiG9w0BCQEWD2NhQFRVLUJlcmxpbi5ERTAeFw0w\nOTA1MTExMjU2MDhaFw0xNDA1MTAxMjU2MDhaMIGQMQswCQYDVQQGEwJERTEPMA0G\nA1UECBMGQmVybGluMQ8wDQYDVQQHEwZCZXJsaW4xJzAlBgNVBAoTHlRlY2huaXNj\naGUgVW5pdmVyc2l0YWV0IEJlcmxpbjEOMAwGA1UECxMFdHViSVQxJjAkBgNVBAMT\nHXNoaWJib2xldGgudHViaXQudHUtYmVybGluLmRlMIIBIjANBgkqhkiG9w0BAQEF\nAAOCAQ8AMIIBCgKCAQEA3qUvqkY4p+iLKlQ33hRjbJWVMsJh7Qk7+dbJcbS+X269\nfnOt0pJKGybCHzpGN6bSPixm+pteRQ/ZfdSo7+3Th0YDBstBapNGkw61rnQpOOxm\nds3hH4yooAOYbf3pGaE1Rm8aCwq9cDODLwtujd/qgCChVL1k+pFHtHhov0M98AZ2\nQF1IM9+sYWSttbcTJ8TnE4oQH6MUftHiE6TNtEfKWOkgx8BK1XP3OGEd0qBYAuGl\npwMC6ublvAMSTg46rLxP04x73MbsXY9gGpaszUBRjJKKIC4Cdo+JndIgx+CTN9r5\nVVXnjOV5ryhSTD7rT7koyzaBkgLWtURysx3p/j4xLwIDAQABo4IBuzCCAbcwCQYD\nVR0TBAIwADALBgNVHQ8EBAMCBPAwEwYDVR0lBAwwCgYIKwYBBQUHAwEwHQYDVR0O\nBBYEFKurFzJOpMsyIAwwO3BAbZxryLf6MB8GA1UdIwQYMBaAFCMyQp7+YkJO+07Q\nF5t45+2KjD54MCEGA1UdEQQaMBiBFmlkbUB0dWJpdC50dS1iZXJsaW4uZGUwgYMG\nA1UdHwR8MHowO6A5oDeGNWh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvdHUtYmVybGlu\nLWNhL3B1Yi9jcmwvY2FjcmwuY3JsMDugOaA3hjVodHRwOi8vY2RwMi5wY2EuZGZu\nLmRlL3R1LWJlcmxpbi1jYS9wdWIvY3JsL2NhY3JsLmNybDCBngYIKwYBBQUHAQEE\ngZEwgY4wRQYIKwYBBQUHMAKGOWh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvdHUtYmVy\nbGluLWNhL3B1Yi9jYWNlcnQvY2FjZXJ0LmNydDBFBggrBgEFBQcwAoY5aHR0cDov\nL2NkcDIucGNhLmRmbi5kZS90dS1iZXJsaW4tY2EvcHViL2NhY2VydC9jYWNlcnQu\nY3J0MA0GCSqGSIb3DQEBBQUAA4IBAQAwzxECaQ3fX5bZPlaszbbLGAodZW2VkUS8\ncyOASU1zQW0wArj4MolDZ+LZnEBCEVQwTD4bFlcQDIVeqeSbuDNXcnYtC9DKhdjQ\nyor//cu1WZ6zcUa+2NYjNMcCAj0qM1fraYaM3hPTCGREL/BjjKeENgduAmWKQeRM\n3X7Hw1sTK0Y0IfQVNsORi8H7bZDbtTKOR1eYIWRndHbNtKuRgEIG4Ud2FMjl+iX6\ntSNMelecSxtYYjrOFp4SiZDG5LCjEVoRSPwhBAOV+iMOAjqlGA4L+cqDyrWRKYb4\nsXWbU7+qrckzBNerB/L9cym1gAeK1LvL7WG3LhHY9AywW34Ewwe7", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "shibboleth.tubit.tu-berlin.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=shibboleth.tubit.tu-berlin.de,OU=tubIT,O=Technische Universitaet Berlin,L=Berlin,ST=Berlin,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFMzCCBBugAwIBAgIEDied9zANBgkqhkiG9w0BAQUFADBnMQswCQYDVQQGEwJE\nRTEnMCUGA1UEChMeVGVjaG5pc2NoZSBVbml2ZXJzaXRhZXQgQmVybGluMQ8wDQYD\nVQQDEwZUVUItQ0ExHjAcBgkqhkiG9w0BCQEWD2NhQFRVLUJlcmxpbi5ERTAeFw0w\nOTA1MTExMjU2MDhaFw0xNDA1MTAxMjU2MDhaMIGQMQswCQYDVQQGEwJERTEPMA0G\nA1UECBMGQmVybGluMQ8wDQYDVQQHEwZCZXJsaW4xJzAlBgNVBAoTHlRlY2huaXNj\naGUgVW5pdmVyc2l0YWV0IEJlcmxpbjEOMAwGA1UECxMFdHViSVQxJjAkBgNVBAMT\nHXNoaWJib2xldGgudHViaXQudHUtYmVybGluLmRlMIIBIjANBgkqhkiG9w0BAQEF\nAAOCAQ8AMIIBCgKCAQEA3qUvqkY4p+iLKlQ33hRjbJWVMsJh7Qk7+dbJcbS+X269\nfnOt0pJKGybCHzpGN6bSPixm+pteRQ/ZfdSo7+3Th0YDBstBapNGkw61rnQpOOxm\nds3hH4yooAOYbf3pGaE1Rm8aCwq9cDODLwtujd/qgCChVL1k+pFHtHhov0M98AZ2\nQF1IM9+sYWSttbcTJ8TnE4oQH6MUftHiE6TNtEfKWOkgx8BK1XP3OGEd0qBYAuGl\npwMC6ublvAMSTg46rLxP04x73MbsXY9gGpaszUBRjJKKIC4Cdo+JndIgx+CTN9r5\nVVXnjOV5ryhSTD7rT7koyzaBkgLWtURysx3p/j4xLwIDAQABo4IBuzCCAbcwCQYD\nVR0TBAIwADALBgNVHQ8EBAMCBPAwEwYDVR0lBAwwCgYIKwYBBQUHAwEwHQYDVR0O\nBBYEFKurFzJOpMsyIAwwO3BAbZxryLf6MB8GA1UdIwQYMBaAFCMyQp7+YkJO+07Q\nF5t45+2KjD54MCEGA1UdEQQaMBiBFmlkbUB0dWJpdC50dS1iZXJsaW4uZGUwgYMG\nA1UdHwR8MHowO6A5oDeGNWh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvdHUtYmVybGlu\nLWNhL3B1Yi9jcmwvY2FjcmwuY3JsMDugOaA3hjVodHRwOi8vY2RwMi5wY2EuZGZu\nLmRlL3R1LWJlcmxpbi1jYS9wdWIvY3JsL2NhY3JsLmNybDCBngYIKwYBBQUHAQEE\ngZEwgY4wRQYIKwYBBQUHMAKGOWh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvdHUtYmVy\nbGluLWNhL3B1Yi9jYWNlcnQvY2FjZXJ0LmNydDBFBggrBgEFBQcwAoY5aHR0cDov\nL2NkcDIucGNhLmRmbi5kZS90dS1iZXJsaW4tY2EvcHViL2NhY2VydC9jYWNlcnQu\nY3J0MA0GCSqGSIb3DQEBBQUAA4IBAQAwzxECaQ3fX5bZPlaszbbLGAodZW2VkUS8\ncyOASU1zQW0wArj4MolDZ+LZnEBCEVQwTD4bFlcQDIVeqeSbuDNXcnYtC9DKhdjQ\nyor//cu1WZ6zcUa+2NYjNMcCAj0qM1fraYaM3hPTCGREL/BjjKeENgduAmWKQeRM\n3X7Hw1sTK0Y0IfQVNsORi8H7bZDbtTKOR1eYIWRndHbNtKuRgEIG4Ud2FMjl+iX6\ntSNMelecSxtYYjrOFp4SiZDG5LCjEVoRSPwhBAOV+iMOAjqlGA4L+cqDyrWRKYb4\nsXWbU7+qrckzBNerB/L9cym1gAeK1LvL7WG3LhHY9AywW34Ewwe7", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "de", 
            "text": "Universit\u00e4t Berlin (Technische Universit\u00e4t)", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "Technische Universit\u00e4t Berlin", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "http://www.tu-berlin.de", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Gerd", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "schering@tubit.tu-berlin.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Schering", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Gerd", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "schering@tubit.tu-berlin.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Schering", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Thomas", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "gepard@tubit.tu-berlin.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Gebhardt", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Thomas", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "gepard@tubit.tu-berlin.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Gebhardt", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "tubit-", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "tubit-shibbolethsupport@lists.tu-berlin.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "shibbolethsupport", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "tubit-", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "tubit-shibbolethsupport@lists.tu-berlin.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "shibbolethsupport", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "http://stipendieansokan-test.uaf.uu.se/stipendium", 
    {
      "entity_id": "http://stipendieansokan-test.uaf.uu.se/stipendium", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-2.0/stipendieansokan-test.uaf.uu.se-stipendium.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "attribute_value": [
              {
                "text": "http://www.swamid.se/category/hei-service", 
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue", 
                "extension_attributes": {
                  "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                }
              }, 
              {
                "text": "http://www.swamid.se/category/research-and-education", 
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue", 
                "extension_attributes": {
                  "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                }
              }
            ], 
            "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute", 
            "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
            "name": "http://macedir.org/entity-category"
          }
        ]
      }, 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "UU", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Uppsala universitet", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.uu.se", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "http://stipendieansokan-test.uaf.uu.se:80/stipendium/saml/SingleLogout/alias/defaultAlias"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "http://stipendieansokan-test.uaf.uu.se:80/stipendium/saml/SingleLogout/alias/defaultAlias"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "0", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "http://stipendieansokan-test.uaf.uu.se:80/stipendium/saml/SSO/alias/defaultAlias"
            }, 
            {
              "is_default": "true", 
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "http://stipendieansokan-test.uaf.uu.se:80/stipendium/saml/SSO/alias/defaultAlias"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "http://stipendieansokan-test.uaf.uu.se:80/stipendium/saml/SSO/alias/defaultAlias"
            }, 
            {
              "index": "3", 
              "location": "http://stipendieansokan-test.uaf.uu.se:80/stipendium/saml/HoKSSO/alias/defaultAlias", 
              "binding": "urn:oasis:names:tc:SAML:2.0:profiles:holder-of-key:SSO:browser", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "extension_attributes": {
                "{urn:oasis:names:tc:SAML:2.0:profiles:holder-of-key:SSO:browser}ProtocolBinding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact"
              }
            }, 
            {
              "index": "4", 
              "location": "http://stipendieansokan-test.uaf.uu.se:80/stipendium/saml/HoKSSO/alias/defaultAlias", 
              "binding": "urn:oasis:names:tc:SAML:2.0:profiles:holder-of-key:SSO:browser", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "extension_attributes": {
                "{urn:oasis:names:tc:SAML:2.0:profiles:holder-of-key:SSO:browser}ProtocolBinding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST"
              }
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "logo": [
                  {
                    "text": "https://stipendieansokan-test.uaf.uu.se/stipendium/img/UU-logga_125x125.png", 
                    "width": "125", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo", 
                    "height": "125"
                  }
                ], 
                "information_url": [
                  {
                    "lang": "en", 
                    "text": "http://stipendieansokan-test.uaf.uu.se/stipendium/stipac/login?lang=en", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }, 
                  {
                    "lang": "sv", 
                    "text": "http://stipendieansokan-test.uaf.uu.se/stipendium/stipac/login", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }
                ], 
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Scholarship Test", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }, 
                  {
                    "lang": "sv", 
                    "text": "Stipendiehantering Test", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "sv", 
                    "text": "System f\u00f6r att s\u00f6ka och hantera stipendium vid Uppsala universitet (Test)", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }, 
                  {
                    "lang": "en", 
                    "text": "Scholarship management system at Uppsala university (Test)", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }
            ]
          }, 
          "name_id_format": [
            {
              "text": "urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ], 
          "want_assertions_signed": "true", 
          "authn_requests_signed": "true", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDYzCCAkugAwIBAgIEXsncWDANBgkqhkiG9w0BAQsFADBiMQswCQYDVQQGEwJzZTEQMA4GA1UE\nCBMHU3ZlcmlnZTEQMA4GA1UEBxMHVXBwc2FsYTELMAkGA1UEChMCVVUxCzAJBgNVBAsTAklUMRUw\nEwYDVQQDEwxUb21teSBTdGVudmkwHhcNMTQwMTIxMTIzMzIxWhcNMTcxMDEyMTIzMzIxWjBiMQsw\nCQYDVQQGEwJzZTEQMA4GA1UECBMHU3ZlcmlnZTEQMA4GA1UEBxMHVXBwc2FsYTELMAkGA1UEChMC\nVVUxCzAJBgNVBAsTAklUMRUwEwYDVQQDEwxUb21teSBTdGVudmkwggEiMA0GCSqGSIb3DQEBAQUA\nA4IBDwAwggEKAoIBAQCYm9zOwWOyPzD3W2ophyDRR2YKEuWdP1ZzQAUf7nwBRa0sf62UODcvavGJ\nFK+yVjdtDayls5KPyIfHiW0vJAjWPrhCRE/Nk4pCyPhEbVhBtSA/JfXUEtB9Otf79G8PmxCJGfUN\nTeaFIl1PhEjQtQGS9IHe/N0P/Gxn9hJL+452ePbScB0hpC2/Z61GV2GDmz8l8g2FS4BXC/OxpqkR\nTfWqVvO7h8UJrrPfntqLTEHpD9Ex0LAy9RBXAj/4eUt8obzr84IJLITF875icjXyRcq0510gtGAr\nLytJxy/5KQ/Y2rUVfVBSg3m4C5BRiTAKjNncx+JFhq665tyiLtOTITxPAgMBAAGjITAfMB0GA1Ud\nDgQWBBTFo53xd9YijvyHlNUZ6Gt1YLLjQTANBgkqhkiG9w0BAQsFAAOCAQEAEFmcm96wM5/SwNCj\ni5uX3XFkQ2IDqeVmAAOmY/3cRh/kXxSM1OR1rifCl4kQlHHxV/9+r1EwiJ+LIhhnBHwJLM2TVFKD\nDRm5Lq9ghRzjiKponRltsGQzdZx5b5dAsG+J3J0TWJCp+HXoO6FNbIs0WAPm2nGkICyUi+ZBmdM1\nNHqA2JtG95d1VrNeZMmou7CdUBqRIWSlQPcGhawq4tKrs/6C79JLwfDhIPidJ3V0gkVSjm1FSNC5\nDJLTyRKIJB8d1r0/RpePenawO79D5eJlDeUTpu0LcPMyCKPGVT0tFaU/TyF6Jn8CJ2ZIlybtdXtp\nlQDSN7w4inBTDBIKvjWfVg==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ]
        }
      ], 
      "contact_person": [
        {
          "email_address": [
            {
              "text": "stipendie-datordrift@its.uu.se", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "company": {
            "text": "Uppsala universitet", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Company"
          }, 
          "sur_name": {
            "text": "Stipendiehantering", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://idp.dlr.de/idp/shibboleth", 
    {
      "entity_id": "https://idp.dlr.de/idp/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/idp.dlr.de.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.dlr.de/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.dlr.de/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.dlr.de/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.dlr.de/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "dlr.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "text": "idp.dlr.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=idp.dlr.de,O=Deutsches Zentrum fuer Luft- und Raumfahrt e.V. (DLR),C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFBzCCA++gAwIBAgIEC8u/fjANBgkqhkiG9w0BAQUFADB+MQswCQYDVQQGEwJE\nRTE+MDwGA1UEChM1RGV1dHNjaGVzIFplbnRydW0gZnVlciBMdWZ0LSB1bmQgUmF1\nbWZhaHJ0IGUuVi4gKERMUikxFTATBgNVBAMTDERMUiBDQSAtIEcwMjEYMBYGCSqG\nSIb3DQEJARYJY2FAZGxyLmRlMB4XDTA4MDIwODExNTAwN1oXDTEzMDIwNjExNTAw\nN1owYjELMAkGA1UEBhMCREUxPjA8BgNVBAoTNURldXRzY2hlcyBaZW50cnVtIGZ1\nZXIgTHVmdC0gdW5kIFJhdW1mYWhydCBlLlYuIChETFIpMRMwEQYDVQQDEwppZHAu\nZGxyLmRlMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAxh5rErO6Qlwc\ndruGYlRGvcT9dWfHzsas2PJFWqhV/rftZbnWytSVVKhnFkuanBjf8L3J2eV19OW7\nWwX/rp+q5Pi/Z6JaMlP6fxUN/WTpk78g4+0OhRuoLV1KHdu15MoWs3783PlUcJgJ\nct5WWj+xF7JHbhhNFDe+Rgvj8YxGDBPKP6P2Ut7CZn4NpVxdhklst9+f9atdeZIN\nX1V4o/T9cwzaCOGq/YQpwaelNPftQL+bafAvTti9VjU3mb2j3lE4PzqYYGOV+x6p\nzbo11okLeWqTxjojGPkMdN4N41fa7VFY2ePvI4vB1yMl5+GeK4U3DyVCQLW2QwW5\nqCA6JYbSlwIDAQABo4IBpzCCAaMwCQYDVR0TBAIwADALBgNVHQ8EBAMCBeAwHQYD\nVR0lBBYwFAYIKwYBBQUHAwIGCCsGAQUFBwMBMB0GA1UdDgQWBBQRq/Omucsl/TzT\n65CUDwGldzWRKTAfBgNVHSMEGDAWgBRmoqXzRT2+lHczLTCbISj3/AwdtTAUBgNV\nHREEDTALgQlyYUBkbHIuZGUwewYDVR0fBHQwcjA3oDWgM4YxaHR0cDovL2NkcDEu\ncGNhLmRmbi5kZS9kbHItY2EvcHViL2NybC9nX2NhY3JsLmNybDA3oDWgM4YxaHR0\ncDovL2NkcDIucGNhLmRmbi5kZS9kbHItY2EvcHViL2NybC9nX2NhY3JsLmNybDCB\nlgYIKwYBBQUHAQEEgYkwgYYwQQYIKwYBBQUHMAKGNWh0dHA6Ly9jZHAxLnBjYS5k\nZm4uZGUvZGxyLWNhL3B1Yi9jYWNlcnQvZ19jYWNlcnQuY3J0MEEGCCsGAQUFBzAC\nhjVodHRwOi8vY2RwMi5wY2EuZGZuLmRlL2Rsci1jYS9wdWIvY2FjZXJ0L2dfY2Fj\nZXJ0LmNydDANBgkqhkiG9w0BAQUFAAOCAQEAEJI2dEuw0JLghN/WqQg5F/3hm+GK\n7O/JP1cumra0PUdRBRcNunqMKFQmZsXs+qOFhsHeYWK6mPfxqOUV7mXLRfintjLZ\nIyvfIEuJgQRL9ksiqs5M0aqdSfjueIdw969pyr2fINpY206EWnoj7w9ULFAEhNPv\n+8sezskmCtSdz67IoKMO/xeboHkXT/gzPwYtqgJUmGollv579ZETb2ILy67OKDAe\nyXbmklXUV0ItF6seXlz1/wtmShoUWmXh7pBLp2Dl/642X0PrsLv1fjCeOlvVHGIo\nHUbHHKBnr2VeUN5gxHUc2RJRuPhywCI8IfdyZP8YboU8BYMt6uE8SmIl3A==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://idp.dlr.de:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://idp.dlr.de:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://idp.dlr.de:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://idp.dlr.de:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "dlr.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "text": "idp.dlr.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=idp.dlr.de,O=Deutsches Zentrum fuer Luft- und Raumfahrt e.V. (DLR),C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFBzCCA++gAwIBAgIEC8u/fjANBgkqhkiG9w0BAQUFADB+MQswCQYDVQQGEwJE\nRTE+MDwGA1UEChM1RGV1dHNjaGVzIFplbnRydW0gZnVlciBMdWZ0LSB1bmQgUmF1\nbWZhaHJ0IGUuVi4gKERMUikxFTATBgNVBAMTDERMUiBDQSAtIEcwMjEYMBYGCSqG\nSIb3DQEJARYJY2FAZGxyLmRlMB4XDTA4MDIwODExNTAwN1oXDTEzMDIwNjExNTAw\nN1owYjELMAkGA1UEBhMCREUxPjA8BgNVBAoTNURldXRzY2hlcyBaZW50cnVtIGZ1\nZXIgTHVmdC0gdW5kIFJhdW1mYWhydCBlLlYuIChETFIpMRMwEQYDVQQDEwppZHAu\nZGxyLmRlMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAxh5rErO6Qlwc\ndruGYlRGvcT9dWfHzsas2PJFWqhV/rftZbnWytSVVKhnFkuanBjf8L3J2eV19OW7\nWwX/rp+q5Pi/Z6JaMlP6fxUN/WTpk78g4+0OhRuoLV1KHdu15MoWs3783PlUcJgJ\nct5WWj+xF7JHbhhNFDe+Rgvj8YxGDBPKP6P2Ut7CZn4NpVxdhklst9+f9atdeZIN\nX1V4o/T9cwzaCOGq/YQpwaelNPftQL+bafAvTti9VjU3mb2j3lE4PzqYYGOV+x6p\nzbo11okLeWqTxjojGPkMdN4N41fa7VFY2ePvI4vB1yMl5+GeK4U3DyVCQLW2QwW5\nqCA6JYbSlwIDAQABo4IBpzCCAaMwCQYDVR0TBAIwADALBgNVHQ8EBAMCBeAwHQYD\nVR0lBBYwFAYIKwYBBQUHAwIGCCsGAQUFBwMBMB0GA1UdDgQWBBQRq/Omucsl/TzT\n65CUDwGldzWRKTAfBgNVHSMEGDAWgBRmoqXzRT2+lHczLTCbISj3/AwdtTAUBgNV\nHREEDTALgQlyYUBkbHIuZGUwewYDVR0fBHQwcjA3oDWgM4YxaHR0cDovL2NkcDEu\ncGNhLmRmbi5kZS9kbHItY2EvcHViL2NybC9nX2NhY3JsLmNybDA3oDWgM4YxaHR0\ncDovL2NkcDIucGNhLmRmbi5kZS9kbHItY2EvcHViL2NybC9nX2NhY3JsLmNybDCB\nlgYIKwYBBQUHAQEEgYkwgYYwQQYIKwYBBQUHMAKGNWh0dHA6Ly9jZHAxLnBjYS5k\nZm4uZGUvZGxyLWNhL3B1Yi9jYWNlcnQvZ19jYWNlcnQuY3J0MEEGCCsGAQUFBzAC\nhjVodHRwOi8vY2RwMi5wY2EuZGZuLmRlL2Rsci1jYS9wdWIvY2FjZXJ0L2dfY2Fj\nZXJ0LmNydDANBgkqhkiG9w0BAQUFAAOCAQEAEJI2dEuw0JLghN/WqQg5F/3hm+GK\n7O/JP1cumra0PUdRBRcNunqMKFQmZsXs+qOFhsHeYWK6mPfxqOUV7mXLRfintjLZ\nIyvfIEuJgQRL9ksiqs5M0aqdSfjueIdw969pyr2fINpY206EWnoj7w9ULFAEhNPv\n+8sezskmCtSdz67IoKMO/xeboHkXT/gzPwYtqgJUmGollv579ZETb2ILy67OKDAe\nyXbmklXUV0ItF6seXlz1/wtmShoUWmXh7pBLp2Dl/642X0PrsLv1fjCeOlvVHGIo\nHUbHHKBnr2VeUN5gxHUc2RJRuPhywCI8IfdyZP8YboU8BYMt6uE8SmIl3A==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "de", 
            "text": "DLR - Deutsches Zentrum fuer Luft- und Raumfahrt e.V.", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "DLR - Deutsches Zentrum fuer Luft- und Raumfahrt e.V.", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "http://www.dlr.de", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Gert", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "Gert.Ohme@t-systems-sfr.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Ohme", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Gert", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "Gert.Ohme@t-systems-sfr.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Ohme", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }
      ]
    }
  ], 
  [
    "https://atlases.muni.cz/shibboleth", 
    {
      "entity_id": "https://atlases.muni.cz/shibboleth", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://atlases.muni.cz/Shibboleth.sso/SLO/POST"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "0", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://atlases.muni.cz/Shibboleth.sso/SAML2/POST"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "name_id_format": [
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ], 
          "attribute_consuming_service": [
            {
              "index": "0", 
              "service_description": [
                {
                  "lang": "en", 
                  "text": "to provide access to the three atlases: (1) Dermatopathology, (2) Fetal and Neonatal Pathology, (3) Pathology for Pre-graduate Students of Medicine. The atlases may serve as sources of teaching material for pre-graduate as well as postgraduate students of pathology", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription"
                }, 
                {
                  "lang": "da", 
                  "text": "give adgang til tre atlasser: (1) Dermato-patologi, (2) Foster- og neonatal patologi, (3) Patologi for medicinstuderende. Atlasserne kan bruges som undervisningsmateriale for patologistuderende", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription"
                }
              ], 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService", 
              "requested_attribute": [
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.10"
                }
              ], 
              "service_name": [
                {
                  "lang": "en", 
                  "text": "Pathology Images", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }, 
                {
                  "lang": "da", 
                  "text": "Patologi-atlasser", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }
              ]
            }
          ], 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIEZzCCA0+gAwIBAgILAQAAAAABID3xVZIwDQYJKoZIhvcNAQEFBQAwajEjMCEGA1UECxMaT3JnYW5pemF0aW9uIFZhbGlkYXRpb24gQ0ExEzARBgNVBAoTCkdsb2JhbFNpZ24xLjAsBgNVBAMTJUdsb2JhbFNpZ24gT3JnYW5pemF0aW9uIFZhbGlkYXRpb24gQ0EwHhcNMDkwMzI1MTMwNTE0WhcNMTIwNTA5MDcwNzU3WjCBgzELMAkGA1UEBhMCREsxETAPBgNVBAgTCE9kZW5zZSBNMREwDwYDVQQHEwhPZGVuc2UgTTEbMBkGA1UECxMSV0FZRiAtIFNlY3JldGFyaWF0MR0wGwYDVQQKExRTeWRkYW5zayBVbml2ZXJzaXRldDESMBAGA1UEAxQJKi53YXlmLmRrMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDBsuiyO84OVwkKR0TL6w8viWV4jMg+Jy7LgiEtYfHdnVBCvdM9XJJetS0MiJtulBH4/4ZWrfeGeHgLPvSjp6FiRdI1nDg/33ofc0TdNytxX4tBCzvxM0C4yCCaEXda+tqXJmGua+mVubMhS8kizHjL+s7A8xUqXoEFqOMHtgqoAQIDAQABo4IBdjCCAXIwHwYDVR0jBBgwFoAUfW0q7Garp1E2qwJp8XCPxFkLmh8wSQYIKwYBBQUHAQEEPTA7MDkGCCsGAQUFBzAChi1odHRwOi8vc2VjdXJlLmdsb2JhbHNpZ24ubmV0L2NhY2VydC9vcmd2MS5jcnQwPwYDVR0fBDgwNjA0oDKgMIYuaHR0cDovL2NybC5nbG9iYWxzaWduLm5ldC9Pcmdhbml6YXRpb25WYWwxLmNybDAdBgNVHQ4EFgQUvlkjTc0iuzcvi752QgktLT01obgwCQYDVR0TBAIwADAOBgNVHQ8BAf8EBAMCBaAwKQYDVR0lBCIwIAYIKwYBBQUHAwEGCCsGAQUFBwMCBgorBgEEAYI3CgMDMEsGA1UdIAREMEIwQAYJKwYBBAGgMgEUMDMwMQYIKwYBBQUHAgEWJWh0dHA6Ly93d3cuZ2xvYmFsc2lnbi5uZXQvcmVwb3NpdG9yeS8wEQYJYIZIAYb4QgEBBAQDAgbAMA0GCSqGSIb3DQEBBQUAA4IBAQCKPVJYHjKOrzWtjPBTEJOwIzE0wSIcA+9+GNR5Pvk+6OTf2QTUDDHpXiiIEcYPL1kN/BEvA+N2y+7qyI5MlL7DNIu9clx1lcqhXiQ0lWcu7Bmb7VNPKq5WS1W81GhbZrO6BJtsQctU6odDXMoORay7FxnaxGHOaJlCSQDgT7QrRhzyd80X8NxrSV25byCTb31du8xoO+WagnqAp6xbKs6IsESDw2r/i3rLOXbL37B7lnbjcLC963xN6j7+kiyqiCjvrP0GLfSV4/FN9i9hWrdMlcbnvr23yz5Jflc1oFPtJx7GZqtV0uTijGxCr+aRaUzBPqc3kyavHJcCsn5TcL1t", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "encryption", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIEZzCCA0+gAwIBAgILAQAAAAABID3xVZIwDQYJKoZIhvcNAQEFBQAwajEjMCEGA1UECxMaT3JnYW5pemF0aW9uIFZhbGlkYXRpb24gQ0ExEzARBgNVBAoTCkdsb2JhbFNpZ24xLjAsBgNVBAMTJUdsb2JhbFNpZ24gT3JnYW5pemF0aW9uIFZhbGlkYXRpb24gQ0EwHhcNMDkwMzI1MTMwNTE0WhcNMTIwNTA5MDcwNzU3WjCBgzELMAkGA1UEBhMCREsxETAPBgNVBAgTCE9kZW5zZSBNMREwDwYDVQQHEwhPZGVuc2UgTTEbMBkGA1UECxMSV0FZRiAtIFNlY3JldGFyaWF0MR0wGwYDVQQKExRTeWRkYW5zayBVbml2ZXJzaXRldDESMBAGA1UEAxQJKi53YXlmLmRrMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDBsuiyO84OVwkKR0TL6w8viWV4jMg+Jy7LgiEtYfHdnVBCvdM9XJJetS0MiJtulBH4/4ZWrfeGeHgLPvSjp6FiRdI1nDg/33ofc0TdNytxX4tBCzvxM0C4yCCaEXda+tqXJmGua+mVubMhS8kizHjL+s7A8xUqXoEFqOMHtgqoAQIDAQABo4IBdjCCAXIwHwYDVR0jBBgwFoAUfW0q7Garp1E2qwJp8XCPxFkLmh8wSQYIKwYBBQUHAQEEPTA7MDkGCCsGAQUFBzAChi1odHRwOi8vc2VjdXJlLmdsb2JhbHNpZ24ubmV0L2NhY2VydC9vcmd2MS5jcnQwPwYDVR0fBDgwNjA0oDKgMIYuaHR0cDovL2NybC5nbG9iYWxzaWduLm5ldC9Pcmdhbml6YXRpb25WYWwxLmNybDAdBgNVHQ4EFgQUvlkjTc0iuzcvi752QgktLT01obgwCQYDVR0TBAIwADAOBgNVHQ8BAf8EBAMCBaAwKQYDVR0lBCIwIAYIKwYBBQUHAwEGCCsGAQUFBwMCBgorBgEEAYI3CgMDMEsGA1UdIAREMEIwQAYJKwYBBAGgMgEUMDMwMQYIKwYBBQUHAgEWJWh0dHA6Ly93d3cuZ2xvYmFsc2lnbi5uZXQvcmVwb3NpdG9yeS8wEQYJYIZIAYb4QgEBBAQDAgbAMA0GCSqGSIb3DQEBBQUAA4IBAQCKPVJYHjKOrzWtjPBTEJOwIzE0wSIcA+9+GNR5Pvk+6OTf2QTUDDHpXiiIEcYPL1kN/BEvA+N2y+7qyI5MlL7DNIu9clx1lcqhXiQ0lWcu7Bmb7VNPKq5WS1W81GhbZrO6BJtsQctU6odDXMoORay7FxnaxGHOaJlCSQDgT7QrRhzyd80X8NxrSV25byCTb31du8xoO+WagnqAp6xbKs6IsESDw2r/i3rLOXbL37B7lnbjcLC963xN6j7+kiyqiCjvrP0GLfSV4/FN9i9hWrdMlcbnvr23yz5Jflc1oFPtJx7GZqtV0uTijGxCr+aRaUzBPqc3kyavHJcCsn5TcL1t", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ]
        }
      ], 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/atlases.muni.cz.xml"
      }
    }
  ], 
  [
    "https://www-s.redi-bw.de", 
    {
      "entity_id": "https://www-s.redi-bw.de", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/www-s.redi-bw.de.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "organization": {
        "organization_name": [
          {
            "lang": "de", 
            "text": "Universit\u00e4t Freiburg", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "ReDI Stuttgart", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "http://www.uni-freiburg.de/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Hans-Adolf", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "ruppert@ub.uni-freiburg.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Ruppert", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "ReDI", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "info@redi-bw.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Team", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://www-s.redi-bw.de/Shibboleth.sso/SLO/Artifact"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://www-s.redi-bw.de/Shibboleth.sso/SLO/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://www-s.redi-bw.de/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://www-s.redi-bw.de/Shibboleth.sso/SLO/SOAP"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www-s.redi-bw.de/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www-s.redi-bw.de/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www-s.redi-bw.de/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www-s.redi-bw.de/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www-s.redi-bw.de/Shibboleth.sso/SAML/Artifact"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www-s.redi-bw.de/Shibboleth.sso/SAML/POST"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ], 
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://www-s.redi-bw.de/Shibboleth.sso/NIM/Artifact"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://www-s.redi-bw.de/Shibboleth.sso/NIM/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://www-s.redi-bw.de/Shibboleth.sso/NIM/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://www-s.redi-bw.de/Shibboleth.sso/NIM/SOAP"
            }
          ], 
          "key_descriptor": [
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "www-s.redi-bw.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "emailAddress=info@redi-bw.de,CN=www-s.redi-bw.de,OU=Universitaetsbibliothek,O=Universitaet Freiburg,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFZjCCBE6gAwIBAgIEC0feAzANBgkqhkiG9w0BAQUFADCBhjELMAkGA1UEBhMC\nREUxHjAcBgNVBAoTFVVuaXZlcnNpdGFldCBGcmVpYnVyZzEWMBQGA1UECxMNUmVj\naGVuemVudHJ1bTEYMBYGA1UEAxMPVW5pLUZSIENBIC0gRzAyMSUwIwYJKoZIhvcN\nAQkBFhZwa2lAcnoudW5pLWZyZWlidXJnLmRlMB4XDTA3MTAzMTExMDEwOFoXDTEy\nMTAyOTExMDEwOFowgYoxCzAJBgNVBAYTAkRFMR4wHAYDVQQKExVVbml2ZXJzaXRh\nZXQgRnJlaWJ1cmcxIDAeBgNVBAsTF1VuaXZlcnNpdGFldHNiaWJsaW90aGVrMRkw\nFwYDVQQDExB3d3ctcy5yZWRpLWJ3LmRlMR4wHAYJKoZIhvcNAQkBFg9pbmZvQHJl\nZGktYncuZGUwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQClimyACau2\n7dtk/2Cd4F7vJfsEiAnyHkXG5LbBNDK286gOIXROgnOwEb6fLc08eR6F/79PlGqA\nNCvzUyMnIDSnNwdiXkofOvNKjYBCpSWzmnZjz4Spn2Fzb9LyDpKe2QAqZ8P8MWYF\nP9Up9C/cRcyprhJHqzL/kMNPQUVPAZWgHhkqjlZifQqElASXJ3u3vNfbWZ6RbuZ1\nPK7Z8l++u1nGkAoBrNr7bpKx4hHbPjQI53XiwpH0VAstYZHnqe7B9z/XCCeYjQMx\nigd03a8+wg0tkDqHDErYyk9ueuHrD72qsi96tdIshudVobdpJVdG2AlBHBl2O3Yj\nQlF0PPqGWAvZAgMBAAGjggHUMIIB0DAJBgNVHRMEAjAAMAsGA1UdDwQEAwIF4DAd\nBgNVHSUEFjAUBggrBgEFBQcDAgYIKwYBBQUHAwEwHQYDVR0OBBYEFKEmtco6yR2f\nnO4Yt4UbhdMLOFFwMB8GA1UdIwQYMBaAFDNnqdbxk1U2rKEyvcHkljn/THAxMBoG\nA1UdEQQTMBGBD2luZm9AcmVkaS1idy5kZTCBjwYDVR0fBIGHMIGEMECgPqA8hjpo\ndHRwOi8vY2RwMS5wY2EuZGZuLmRlL3VuaS1mcmVpYnVyZy1jYS9wdWIvY3JsL2df\nY2FjcmwuY3JsMECgPqA8hjpodHRwOi8vY2RwMi5wY2EuZGZuLmRlL3VuaS1mcmVp\nYnVyZy1jYS9wdWIvY3JsL2dfY2FjcmwuY3JsMIGoBggrBgEFBQcBAQSBmzCBmDBK\nBggrBgEFBQcwAoY+aHR0cDovL2NkcDEucGNhLmRmbi5kZS91bmktZnJlaWJ1cmct\nY2EvcHViL2NhY2VydC9nX2NhY2VydC5jcnQwSgYIKwYBBQUHMAKGPmh0dHA6Ly9j\nZHAyLnBjYS5kZm4uZGUvdW5pLWZyZWlidXJnLWNhL3B1Yi9jYWNlcnQvZ19jYWNl\ncnQuY3J0MA0GCSqGSIb3DQEBBQUAA4IBAQBB6TJb5jerQHmk9LwCvwEQrQGo/C52\n5DOdukZ2zV9SzgRb877XjjwCfNgVRurYyyJnBj95/kX2R7Ry8tDgY3LiDyRRGhXT\nrMdWWZgyEZrn0Aqk28hk2zm+U5f9OFTnwj6wRWfIAglAZxnsTUGFoHw3f2+f7tl1\ndKaPVl2nTMUOq3mJrgkMDwKksVH7miOw2U1dxyXNnPYFJcPKy04wXN4hj5fgJrQk\n7B/eFzIlQAv58jPToJuIf0AQ/tE6s0HbdVQk704V3vJ0shgvYk9XRG79H7xmqKIU\n5+Ku1V1/b70GA9disF4/zyhDZf6InNqnJfDn9nsiBkFInMqCDijq7l12", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "www-s.redi-bw.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "emailAddress=info@redi-bw.de,CN=www-s.redi-bw.de,OU=Universitaetsbibliothek,O=Universitaet Freiburg,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFZjCCBE6gAwIBAgIEC0feAzANBgkqhkiG9w0BAQUFADCBhjELMAkGA1UEBhMC\nREUxHjAcBgNVBAoTFVVuaXZlcnNpdGFldCBGcmVpYnVyZzEWMBQGA1UECxMNUmVj\naGVuemVudHJ1bTEYMBYGA1UEAxMPVW5pLUZSIENBIC0gRzAyMSUwIwYJKoZIhvcN\nAQkBFhZwa2lAcnoudW5pLWZyZWlidXJnLmRlMB4XDTA3MTAzMTExMDEwOFoXDTEy\nMTAyOTExMDEwOFowgYoxCzAJBgNVBAYTAkRFMR4wHAYDVQQKExVVbml2ZXJzaXRh\nZXQgRnJlaWJ1cmcxIDAeBgNVBAsTF1VuaXZlcnNpdGFldHNiaWJsaW90aGVrMRkw\nFwYDVQQDExB3d3ctcy5yZWRpLWJ3LmRlMR4wHAYJKoZIhvcNAQkBFg9pbmZvQHJl\nZGktYncuZGUwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQClimyACau2\n7dtk/2Cd4F7vJfsEiAnyHkXG5LbBNDK286gOIXROgnOwEb6fLc08eR6F/79PlGqA\nNCvzUyMnIDSnNwdiXkofOvNKjYBCpSWzmnZjz4Spn2Fzb9LyDpKe2QAqZ8P8MWYF\nP9Up9C/cRcyprhJHqzL/kMNPQUVPAZWgHhkqjlZifQqElASXJ3u3vNfbWZ6RbuZ1\nPK7Z8l++u1nGkAoBrNr7bpKx4hHbPjQI53XiwpH0VAstYZHnqe7B9z/XCCeYjQMx\nigd03a8+wg0tkDqHDErYyk9ueuHrD72qsi96tdIshudVobdpJVdG2AlBHBl2O3Yj\nQlF0PPqGWAvZAgMBAAGjggHUMIIB0DAJBgNVHRMEAjAAMAsGA1UdDwQEAwIF4DAd\nBgNVHSUEFjAUBggrBgEFBQcDAgYIKwYBBQUHAwEwHQYDVR0OBBYEFKEmtco6yR2f\nnO4Yt4UbhdMLOFFwMB8GA1UdIwQYMBaAFDNnqdbxk1U2rKEyvcHkljn/THAxMBoG\nA1UdEQQTMBGBD2luZm9AcmVkaS1idy5kZTCBjwYDVR0fBIGHMIGEMECgPqA8hjpo\ndHRwOi8vY2RwMS5wY2EuZGZuLmRlL3VuaS1mcmVpYnVyZy1jYS9wdWIvY3JsL2df\nY2FjcmwuY3JsMECgPqA8hjpodHRwOi8vY2RwMi5wY2EuZGZuLmRlL3VuaS1mcmVp\nYnVyZy1jYS9wdWIvY3JsL2dfY2FjcmwuY3JsMIGoBggrBgEFBQcBAQSBmzCBmDBK\nBggrBgEFBQcwAoY+aHR0cDovL2NkcDEucGNhLmRmbi5kZS91bmktZnJlaWJ1cmct\nY2EvcHViL2NhY2VydC9nX2NhY2VydC5jcnQwSgYIKwYBBQUHMAKGPmh0dHA6Ly9j\nZHAyLnBjYS5kZm4uZGUvdW5pLWZyZWlidXJnLWNhL3B1Yi9jYWNlcnQvZ19jYWNl\ncnQuY3J0MA0GCSqGSIb3DQEBBQUAA4IBAQBB6TJb5jerQHmk9LwCvwEQrQGo/C52\n5DOdukZ2zV9SzgRb877XjjwCfNgVRurYyyJnBj95/kX2R7Ry8tDgY3LiDyRRGhXT\nrMdWWZgyEZrn0Aqk28hk2zm+U5f9OFTnwj6wRWfIAglAZxnsTUGFoHw3f2+f7tl1\ndKaPVl2nTMUOq3mJrgkMDwKksVH7miOw2U1dxyXNnPYFJcPKy04wXN4hj5fgJrQk\n7B/eFzIlQAv58jPToJuIf0AQ/tE6s0HbdVQk704V3vJ0shgvYk9XRG79H7xmqKIU\n5+Ku1V1/b70GA9disF4/zyhDZf6InNqnJfDn9nsiBkFInMqCDijq7l12", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://www.content-select.com/simplesaml/module.php/saml/sp/metadata.php/preselect.media-sp", 
    {
      "entity_id": "https://www.content-select.com/simplesaml/module.php/saml/sp/metadata.php/preselect.media-sp", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/www.content-select.com.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "organization": {
        "organization_name": [
          {
            "lang": "de", 
            "text": "Preselect.media GmbH, Gruenwald", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "Preselect.media GmbH, Gruenwald", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "http://www.content-select.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Andreas", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "a.fuerlinger@preselect.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Fuerlinger", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://www.content-select.com/simplesaml/module.php/saml/sp/saml2-logout.php/preselect.media-sp"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "www.content-select.com", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=www.content-select.com,OU=Domain Control Validated - RapidSSL(R),OU=See www.rapidssl.com/resources/cps (c)11,OU=GT34580426,O=www.content-select.com,C=DE,serialNumber=KigR834DJIZuIEHAagJ0xVfd/ETeEvlJ", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIE9zCCA9+gAwIBAgIDBEopMA0GCSqGSIb3DQEBBQUAMDwxCzAJBgNVBAYTAlVT\nMRcwFQYDVQQKEw5HZW9UcnVzdCwgSW5jLjEUMBIGA1UEAxMLUmFwaWRTU0wgQ0Ew\nHhcNMTExMjA1MTIxNzQ0WhcNMTIxMjA3MTIxMzAwWjCB8zEpMCcGA1UEBRMgS2ln\nUjgzNERKSVp1SUVIQWFnSjB4VmZkL0VUZUV2bEoxCzAJBgNVBAYTAkRFMR8wHQYD\nVQQKExZ3d3cuY29udGVudC1zZWxlY3QuY29tMRMwEQYDVQQLEwpHVDM0NTgwNDI2\nMTEwLwYDVQQLEyhTZWUgd3d3LnJhcGlkc3NsLmNvbS9yZXNvdXJjZXMvY3BzIChj\nKTExMS8wLQYDVQQLEyZEb21haW4gQ29udHJvbCBWYWxpZGF0ZWQgLSBSYXBpZFNT\nTChSKTEfMB0GA1UEAxMWd3d3LmNvbnRlbnQtc2VsZWN0LmNvbTCCASIwDQYJKoZI\nhvcNAQEBBQADggEPADCCAQoCggEBANSTVbAyh0XF+bApU51WEeiotNOn7q/HQ7/Z\n0DSSTgsklWbB5kgDBBo4flY5a/PWuO0H5jBWAs2DXALafzelgMYssqA2up9xiK3M\neIVDro2W+2yFv9CfODJyIVCD8vTZFjqSfoehHF2Pjzp1YAQE0MUbgtX+VCE8oUOL\ntpp2iT7XHOr6DPD/6k8dovxuKQyo1xSkiyJ4CW/HrZQ+heauzyTXalZEfJDMlKib\nWnhjdpoXUA6xOSXoh992UjuEQxXoCYkGZHJQCaHBRx9UFuG4TMVRzq6g9h//Xcld\nH+H8xRctL7G2q1ehJm0IDLd9fOkvYyHTJWDy184/92R9BUSAlk0CAwEAAaOCAUgw\nggFEMB8GA1UdIwQYMBaAFGtpPWoYQkrdjwJlOf01JIZ4kRYwMA4GA1UdDwEB/wQE\nAwIFoDAdBgNVHSUEFjAUBggrBgEFBQcDAQYIKwYBBQUHAwIwNQYDVR0RBC4wLIIW\nd3d3LmNvbnRlbnQtc2VsZWN0LmNvbYISY29udGVudC1zZWxlY3QuY29tMEMGA1Ud\nHwQ8MDowOKA2oDSGMmh0dHA6Ly9yYXBpZHNzbC1jcmwuZ2VvdHJ1c3QuY29tL2Ny\nbHMvcmFwaWRzc2wuY3JsMB0GA1UdDgQWBBRjoYiCPyPt2k/XtEiyOs1ET+ygvjAM\nBgNVHRMBAf8EAjAAMEkGCCsGAQUFBwEBBD0wOzA5BggrBgEFBQcwAoYtaHR0cDov\nL3JhcGlkc3NsLWFpYS5nZW90cnVzdC5jb20vcmFwaWRzc2wuY3J0MA0GCSqGSIb3\nDQEBBQUAA4IBAQAYh5XWr45tlba/mmjOSw2HkGTqRk9rxN6K8VeXwG1+1hr7d2J7\nP34Tt8ln6vBAiSBrNW1j+kHXpxfUS+k/EGTn4m+2NfbKJfKHqEDgUGjYtI5/lu+T\nTrczpZ5qf+a8HSnnnbyH4IL7VKPUneQ22EGppDKLf1FznpJ4pXFmGyM4XU68mlmT\nVqFzNc/40cAysWElKPnDuaEeaNHPj+ygg16o2gELDdZVpcqNPj/u2sGyG8Ve0DoT\n5PFbqWVKT7ei0rDFL5jWiqrmDWQGDJ7afzoPozmz4jaZXVxOkC5bHTL0wtHVFG8Z\nXvtaOslqoxKB8TiLxGjJAXztJJFWwMwF5ebp", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "www.content-select.com", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=www.content-select.com,OU=Domain Control Validated - RapidSSL(R),OU=See www.rapidssl.com/resources/cps (c)11,OU=GT34580426,O=www.content-select.com,C=DE,serialNumber=KigR834DJIZuIEHAagJ0xVfd/ETeEvlJ", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIE9zCCA9+gAwIBAgIDBEopMA0GCSqGSIb3DQEBBQUAMDwxCzAJBgNVBAYTAlVT\nMRcwFQYDVQQKEw5HZW9UcnVzdCwgSW5jLjEUMBIGA1UEAxMLUmFwaWRTU0wgQ0Ew\nHhcNMTExMjA1MTIxNzQ0WhcNMTIxMjA3MTIxMzAwWjCB8zEpMCcGA1UEBRMgS2ln\nUjgzNERKSVp1SUVIQWFnSjB4VmZkL0VUZUV2bEoxCzAJBgNVBAYTAkRFMR8wHQYD\nVQQKExZ3d3cuY29udGVudC1zZWxlY3QuY29tMRMwEQYDVQQLEwpHVDM0NTgwNDI2\nMTEwLwYDVQQLEyhTZWUgd3d3LnJhcGlkc3NsLmNvbS9yZXNvdXJjZXMvY3BzIChj\nKTExMS8wLQYDVQQLEyZEb21haW4gQ29udHJvbCBWYWxpZGF0ZWQgLSBSYXBpZFNT\nTChSKTEfMB0GA1UEAxMWd3d3LmNvbnRlbnQtc2VsZWN0LmNvbTCCASIwDQYJKoZI\nhvcNAQEBBQADggEPADCCAQoCggEBANSTVbAyh0XF+bApU51WEeiotNOn7q/HQ7/Z\n0DSSTgsklWbB5kgDBBo4flY5a/PWuO0H5jBWAs2DXALafzelgMYssqA2up9xiK3M\neIVDro2W+2yFv9CfODJyIVCD8vTZFjqSfoehHF2Pjzp1YAQE0MUbgtX+VCE8oUOL\ntpp2iT7XHOr6DPD/6k8dovxuKQyo1xSkiyJ4CW/HrZQ+heauzyTXalZEfJDMlKib\nWnhjdpoXUA6xOSXoh992UjuEQxXoCYkGZHJQCaHBRx9UFuG4TMVRzq6g9h//Xcld\nH+H8xRctL7G2q1ehJm0IDLd9fOkvYyHTJWDy184/92R9BUSAlk0CAwEAAaOCAUgw\nggFEMB8GA1UdIwQYMBaAFGtpPWoYQkrdjwJlOf01JIZ4kRYwMA4GA1UdDwEB/wQE\nAwIFoDAdBgNVHSUEFjAUBggrBgEFBQcDAQYIKwYBBQUHAwIwNQYDVR0RBC4wLIIW\nd3d3LmNvbnRlbnQtc2VsZWN0LmNvbYISY29udGVudC1zZWxlY3QuY29tMEMGA1Ud\nHwQ8MDowOKA2oDSGMmh0dHA6Ly9yYXBpZHNzbC1jcmwuZ2VvdHJ1c3QuY29tL2Ny\nbHMvcmFwaWRzc2wuY3JsMB0GA1UdDgQWBBRjoYiCPyPt2k/XtEiyOs1ET+ygvjAM\nBgNVHRMBAf8EAjAAMEkGCCsGAQUFBwEBBD0wOzA5BggrBgEFBQcwAoYtaHR0cDov\nL3JhcGlkc3NsLWFpYS5nZW90cnVzdC5jb20vcmFwaWRzc2wuY3J0MA0GCSqGSIb3\nDQEBBQUAA4IBAQAYh5XWr45tlba/mmjOSw2HkGTqRk9rxN6K8VeXwG1+1hr7d2J7\nP34Tt8ln6vBAiSBrNW1j+kHXpxfUS+k/EGTn4m+2NfbKJfKHqEDgUGjYtI5/lu+T\nTrczpZ5qf+a8HSnnnbyH4IL7VKPUneQ22EGppDKLf1FznpJ4pXFmGyM4XU68mlmT\nVqFzNc/40cAysWElKPnDuaEeaNHPj+ygg16o2gELDdZVpcqNPj/u2sGyG8Ve0DoT\n5PFbqWVKT7ei0rDFL5jWiqrmDWQGDJ7afzoPozmz4jaZXVxOkC5bHTL0wtHVFG8Z\nXvtaOslqoxKB8TiLxGjJAXztJJFWwMwF5ebp", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "0", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.content-select.com/simplesaml/module.php/saml/sp/saml2-acs.php/preselect.media-sp"
            }, 
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.content-select.com/simplesaml/module.php/saml/sp/saml1-acs.php/preselect.media-sp"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.content-select.com/simplesaml/module.php/saml/sp/saml2-acs.php/preselect.media-sp"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.content-select.com/simplesaml/module.php/saml/sp/saml1-acs.php/preselect.media-sp/artifact"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://download.portal.chalmers.se/shibboleth", 
    {
      "entity_id": "https://download.portal.chalmers.se/shibboleth", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDGDCCAgCgAwIBAgIJALWMAnfoeEVTMA0GCSqGSIb3DQEBBQUAMCYxJDAiBgNV\nBAMTG2Rvd25sb2FkLnBvcnRhbC5jaGFsbWVycy5zZTAeFw0xMzAyMTMwODUxMjla\nFw0yMzAyMTEwODUxMjlaMCYxJDAiBgNVBAMTG2Rvd25sb2FkLnBvcnRhbC5jaGFs\nbWVycy5zZTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAPbG9acyl2gu\nWdBwDx/r2gP4VufkHGiGheTy8jutaG+KjEcw1+0gbXR7j5q0ikaNki1tRaFmSpnZ\nDotWPOF5ZEsp8MI24NoIijkZTPhVVqRrq4FkZT/L2z6MXUpSXcVLgdxoRX9SSVgv\ncs522ZRTQe6WplkNU3oLKP+gkZl9ukdiFgLQNgeyEphRjN2Ec7OWLepizbotZdu8\n69gmzqHLbNZLiugcBpwIbQO5FkDbxSSdmGOyUWRjcHswJRYo2MMFhrbYYVUIiK1u\nY0wcfRdARkfsbbPG5w8hv4DjEJ2JZ+ofBnfnA6ESn/XEOQ9CAsQ2NbJjUj4rfT88\nEuaGtA/9PqkCAwEAAaNJMEcwJgYDVR0RBB8wHYIbZG93bmxvYWQucG9ydGFsLmNo\nYWxtZXJzLnNlMB0GA1UdDgQWBBQba5syq555BkfQhoVoklnnfDhStDANBgkqhkiG\n9w0BAQUFAAOCAQEAO75ObgCaN++7fT0Y1B7XiEQ2p8oNmND5BedRV9TahI8+zykh\n3j8HSTgEXqGK6DFER9SE7tCxtx3sEytVSpE2pEnqWxWKoU491kZGqWGOm6oSDEWT\n8dMpbx9Z/ZBBo5JdvYDI5Q7MvWIf7+aAhTTcFdQAWqLxje21c3Hpl9zWQ0I9H1p3\nmlThPPb5z+XmLaeAQ6Ux+abiWO+DODJZsidLX3/Aaz86RujVnqk95vY9QxUtynIF\nBfKJHhQBqFivpHyPMnT3y6+UtDE4vfTqLWp5UZoXpKsf/Zo/7+5RQhzlPSxQT0+4\n+//vS+QQnFOG6SANEuSxYURni+8Zk25O5yQlDg==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://download.portal.chalmers.se/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://download.portal.chalmers.se/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://download.portal.chalmers.se/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://download.portal.chalmers.se/Shibboleth.sso/SAML/POST"
            }
          ]
        }
      ], 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-2.0/download.portal.chalmers.se-shibboleth.xml"
      }
    }
  ], 
  [
    "https://test-sp.aco.net/shibboleth", 
    {
      "entity_id": "https://test-sp.aco.net/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/test-sp.aco.net.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "registration_authority": "http://eduid.at", 
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo", 
            "registration_instant": "2008-07-15T13:42:53Z"
          }
        ]
      }, 
      "organization": {
        "organization_name": [
          {
            "lang": "de", 
            "text": "ACOnet", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }, 
          {
            "lang": "en", 
            "text": "ACOnet", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "ACOnet", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }, 
          {
            "lang": "en", 
            "text": "ACOnet", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "http://www.aco.net/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }, 
          {
            "lang": "en", 
            "text": "http://www.aco.net/?L=1", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://saml-test.aco.net/Shibboleth.sso/SLO/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://saml-test.aco.net/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://saml-test.aco.net/Shibboleth.sso/SLO/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://saml-test.aco.net/Shibboleth.sso/SLO/Artifact"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://saml-test.aco.net/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://test-sp.aco.net/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://saml-test.aco.net/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://test-sp.aco.net/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://saml-test.aco.net/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://test-sp.aco.net/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "7", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://saml-test.aco.net/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "8", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://test-sp.aco.net/Shibboleth.sso/SAML2/ECP"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://saml-test.aco.net/Shibboleth.sso/Login"
              }, 
              {
                "index": "2", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://test-sp.aco.net/Shibboleth.sso/Login"
              }, 
              {
                "logo": [
                  {
                    "text": "https://www.aco.net/fileadmin/aconet/Logos/Banner/234x60.gif", 
                    "width": "234", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo", 
                    "height": "60"
                  }
                ], 
                "information_url": [
                  {
                    "lang": "de", 
                    "text": "https://aai-wiki.univie.ac.at/SAML-Test", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }
                ], 
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "ACOnet Test Service Provider", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }, 
                  {
                    "lang": "de", 
                    "text": "ACOnet Test Service Provider", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "en", 
                    "text": "A SAML2 Service Provider available to all ACOnet Identity Federation members for testing purposes.", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }, 
                  {
                    "lang": "de", 
                    "text": "Ein SAML2 Service Provider, der allen ACOnet Identity Federation Mitgliedern f\u00fcr Tests zur Verf\u00fcgung steht.", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }
            ]
          }, 
          "name_id_format": [
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://saml-test.aco.net/Shibboleth.sso/Artifact/SOAP"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://test-sp.aco.net/Shibboleth.sso/Artifact/SOAP"
            }
          ], 
          "attribute_consuming_service": [
            {
              "index": "0", 
              "service_description": [
                {
                  "lang": "en", 
                  "text": "A SAML2 Service Provider available to all ACOnet Identity Federation members for testing purposes.", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription"
                }, 
                {
                  "lang": "de", 
                  "text": "Ein SAML2 Service Provider, der allen ACOnet Identity Federation Mitgliedern f\u00fcr Tests zur Verf\u00fcgung steht.", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription"
                }
              ], 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService", 
              "requested_attribute": [
                {
                  "friendly_name": "eduPersonScopedAffiliation", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.9"
                }, 
                {
                  "friendly_name": "eduPersonPrincipalName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.6"
                }, 
                {
                  "friendly_name": "eduPersonTargetedID", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.10"
                }, 
                {
                  "friendly_name": "eduPersonEntitlement", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.7"
                }, 
                {
                  "friendly_name": "displayName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.16.840.1.113730.3.1.241"
                }, 
                {
                  "friendly_name": "givenName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.5.4.42"
                }, 
                {
                  "friendly_name": "sn", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.5.4.4"
                }, 
                {
                  "friendly_name": "mail", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:0.9.2342.19200300.100.1.3"
                }, 
                {
                  "friendly_name": "schacHomeOrganization", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.25178.1.2.9"
                }, 
                {
                  "friendly_name": "schacHomeOrganizationType", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.25178.1.2.10"
                }
              ], 
              "service_name": [
                {
                  "lang": "en", 
                  "text": "ACOnet Test Service Provider", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }, 
                {
                  "lang": "de", 
                  "text": "ACOnet Test Service Provider", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }
              ]
            }
          ], 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDGDCCAgCgAwIBAgIJAObaiwc63DWQMA0GCSqGSIb3DQEBBQUAMBoxGDAWBgNV\nBAMTD3Rlc3Qtc3AuYWNvLm5ldDAeFw0wODA3MDkxMTQ1NTVaFw0xODA3MDcxMTQ1\nNTVaMBoxGDAWBgNVBAMTD3Rlc3Qtc3AuYWNvLm5ldDCCASIwDQYJKoZIhvcNAQEB\nBQADggEPADCCAQoCggEBALZXEDbiffZnDnsWcJlVUBlaAyEycf+0Bjg/DjsQAz4l\nvG9poVFKlPjaQCQCyk56PXhN0ZuZZJEylHHfMrJvfM6bpylY/a+KFyeNi28acrlg\nu+BRx7uXg+wac0mfp9Z9nj93qQBP4iC7Lbv9AUDrHvp6ig/MF8P8sEb3VZRwwJDc\nx2fLuro/TueYcT0Xw3Y70vkjaAbkugjNE2pU3OL7TxgXx+qzsOmoPiWI61VgpSkm\npmxsN1bjiKJs1sqQ/K3pQ9mcR6Mb5STShcpKf6ZqmuUD53oPeWyB03vmi0AzCXeU\nuGftaM2iWwhaxLApEE6cgxctR2lc91sQtoCo0B1FIMkCAwEAAaNhMF8wPgYDVR0R\nBDcwNYIPdGVzdC1zcC5hY28ubmV0hiJodHRwczovL3Rlc3Qtc3AuYWNvLm5ldC9z\naGliYm9sZXRoMB0GA1UdDgQWBBTyPUKdsFFI3eqmI9OQsgaDw6e8fjANBgkqhkiG\n9w0BAQUFAAOCAQEAeD0OZAEjUr2RJFCbW820q0iG49x0jvL3lSvbYKaUY+4zthXj\n394fALks0blb7XceA857NfIXHn2NI9ZrHllmpTjc6IeD332c6NW8AevYjU+mwGuM\nejLfUgi137jrXaP7jlGSL85aFIWTGoBT6IZu+qiVo8qbWY5EH+3gSIQYCYpfKuaJ\n6EbpYsqZ1tEg6tfUGJK4Ly87HHBCRNwDV9/85yGt+puwvjsPeaXELsGOpTaA8lGJ\ni0o8V/egkPa0mbqghudG9cwZluJCJSWxvxv7yersHIdedRwZyv7vSGu4FI4g39Km\nvNzoGHMHg8pOo6cx9Arah88V+SEsBxtCh3V9Fg==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ]
        }
      ], 
      "contact_person": [
        {
          "given_name": {
            "text": "ACOnet", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "mailto:eduid@aco.net", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Identity Federation Operator", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "ACOnet", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "mailto:eduid@aco.net", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Identity Federation Operator", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }
      ]
    }
  ], 
  [
    "https://mds.lan.kth.se/shibboleth", 
    {
      "entity_id": "https://mds.lan.kth.se/shibboleth", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://mds.lan.kth.se/Shibboleth.sso/SLO/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://mds.lan.kth.se/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://mds.lan.kth.se/Shibboleth.sso/SLO/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://mds.lan.kth.se/Shibboleth.sso/SLO/Artifact"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://mds.lan.kth.se/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://mds.lan.kth.se/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://mds.lan.kth.se/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://mds.lan.kth.se/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://mds.lan.kth.se/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://mds.lan.kth.se/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://mds.lan.kth.se/Shibboleth.sso/DS/ds.sunet.se"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "mds.lan.kth.se", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=mds.lan.kth.se", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIDATCCAemgAwIBAgIJAKuJLl2VWSDhMA0GCSqGSIb3DQEBBQUAMBkxFzAVBgNV\nBAMTDm1kcy5sYW4ua3RoLnNlMB4XDTExMTAyNTE0MDMzN1oXDTIxMTAyMjE0MDMz\nN1owGTEXMBUGA1UEAxMObWRzLmxhbi5rdGguc2UwggEiMA0GCSqGSIb3DQEBAQUA\nA4IBDwAwggEKAoIBAQD1ZMkEwaMPbixuO7VOmHpZ86vfKMIw5P6AzprpKXLV7m5q\nPFyb3OcK5B8R6iN+uNAE9T4G57G1N0VEQqAdZzOodZRaIypXd8Y6f0PmWPjaptC7\nRCjfyXOEdTeHPBFmJrdkdykF6/jv0zn+BE3wuVCqbULDaHd1l4eBi2Lz7elxVsVX\nrxNDJHG+qRrohbka4tSSCi6yUcSo3Go0Nv7fd5gjidMuqoTK5B0fSfEW5qg8x/Kn\nIrvIFCTlMl81PybL9D/H2uopC8jqWvMkMK8db4P4Ckq96J3KvaIbZyWPmbN0nEgR\n5gwpc7alwRrAOaxit/fB54ps6sR3s7NUwuQcx77zAgMBAAGjTDBKMCkGA1UdEQQi\nMCCCDm1kcy5sYW4ua3RoLnNlhg5tZHMubGFuLmt0aC5zZTAdBgNVHQ4EFgQU0UDQ\niSy3a0gXV/eYtxzIfft90kAwDQYJKoZIhvcNAQEFBQADggEBAHE3lggheqGWhWcS\nO2MECNb8+wKFMS+06ht2j+WJYrqtE73dGdVIwCwkSfT0C0P85NShGCdexaUfzZD6\n4vLqHHfx+zSvJomqkOV0khSte59BsajGET0aa3obgJJaWCjfsgFu840qqKX1sDcD\nmFV1KDcpYhC52EveHBchKQ45ZH/KqKJ4laQy6OkCMQPQolX+KxY8nyJ4J6qACCdY\nA/uj+L0Hs/4CBKkM9kbs0P6oszY0dbWwXLY8+bjZpD0XqZULIkjJixlJ0nQk12uE\nWq6nlMKr18cS90g2FgxclTGMrHuSxPvAdDKGAfO29lzRLGWoCSDLKqIAeajHnRNc\nK4y2OQU=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "mds.lan.kth.se", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=mds.lan.kth.se", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIDATCCAemgAwIBAgIJAKuJLl2VWSDhMA0GCSqGSIb3DQEBBQUAMBkxFzAVBgNV\nBAMTDm1kcy5sYW4ua3RoLnNlMB4XDTExMTAyNTE0MDMzN1oXDTIxMTAyMjE0MDMz\nN1owGTEXMBUGA1UEAxMObWRzLmxhbi5rdGguc2UwggEiMA0GCSqGSIb3DQEBAQUA\nA4IBDwAwggEKAoIBAQD1ZMkEwaMPbixuO7VOmHpZ86vfKMIw5P6AzprpKXLV7m5q\nPFyb3OcK5B8R6iN+uNAE9T4G57G1N0VEQqAdZzOodZRaIypXd8Y6f0PmWPjaptC7\nRCjfyXOEdTeHPBFmJrdkdykF6/jv0zn+BE3wuVCqbULDaHd1l4eBi2Lz7elxVsVX\nrxNDJHG+qRrohbka4tSSCi6yUcSo3Go0Nv7fd5gjidMuqoTK5B0fSfEW5qg8x/Kn\nIrvIFCTlMl81PybL9D/H2uopC8jqWvMkMK8db4P4Ckq96J3KvaIbZyWPmbN0nEgR\n5gwpc7alwRrAOaxit/fB54ps6sR3s7NUwuQcx77zAgMBAAGjTDBKMCkGA1UdEQQi\nMCCCDm1kcy5sYW4ua3RoLnNlhg5tZHMubGFuLmt0aC5zZTAdBgNVHQ4EFgQU0UDQ\niSy3a0gXV/eYtxzIfft90kAwDQYJKoZIhvcNAQEFBQADggEBAHE3lggheqGWhWcS\nO2MECNb8+wKFMS+06ht2j+WJYrqtE73dGdVIwCwkSfT0C0P85NShGCdexaUfzZD6\n4vLqHHfx+zSvJomqkOV0khSte59BsajGET0aa3obgJJaWCjfsgFu840qqKX1sDcD\nmFV1KDcpYhC52EveHBchKQ45ZH/KqKJ4laQy6OkCMQPQolX+KxY8nyJ4J6qACCdY\nA/uj+L0Hs/4CBKkM9kbs0P6oszY0dbWwXLY8+bjZpD0XqZULIkjJixlJ0nQk12uE\nWq6nlMKr18cS90g2FgxclTGMrHuSxPvAdDKGAfO29lzRLGWoCSDLKqIAeajHnRNc\nK4y2OQU=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://mds.lan.kth.se/Shibboleth.sso/Artifact/SOAP"
            }
          ], 
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://mds.lan.kth.se/Shibboleth.sso/NIM/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://mds.lan.kth.se/Shibboleth.sso/NIM/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://mds.lan.kth.se/Shibboleth.sso/NIM/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://mds.lan.kth.se/Shibboleth.sso/NIM/Artifact"
            }
          ]
        }
      ], 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-2.0/mds.lan.kth.se-shibboleth.xml"
      }
    }
  ], 
  [
    "https://www07test.sub.su.se", 
    {
      "entity_id": "https://www07test.sub.su.se", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www07test.sub.su.se/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www07test.sub.su.se/Shibboleth.sso/SAML/Artifact"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www07test.sub.su.se/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www07test.sub.su.se/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www07test.sub.su.se/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www07test.sub.su.se/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "swamid", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }, 
                  {
                    "text": "www07test.sub.su.se", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=www07test.sub.su.se", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIB5TCCAU6gAwIBAgIJAMMRnP48jAtqMA0GCSqGSIb3DQEBBQUAMB4xHDAaBgNV\nBAMTE3d3dzA3dGVzdC5zdWIuc3Uuc2UwHhcNMDkxMjA4MTAyMjMzWhcNMTIxMjA3\nMTAyMjMzWjAeMRwwGgYDVQQDExN3d3cwN3Rlc3Quc3ViLnN1LnNlMIGfMA0GCSqG\nSIb3DQEBAQUAA4GNADCBiQKBgQC9adDbmgkldLxg7+sU4Yh7vgHpMpCWJx3PJG4z\n1oqyG2AdYjjWeNkXpindtpadS7KaVcV+Zoc1PzqLOdp89gX5J84sox/XzCPu/RAZ\nlxtruQxRXbkYYTQYtOJaevl6eaPWsR1r2x/RQ8IW9iNOAiuw3D1CudvvphPi0M4p\nYma7NwIDAQABoyswKTAnBgNVHSUEIDAeBggrBgEFBQcDAQYIKwYBBQUHAwIGCCsG\nAQUFBwMEMA0GCSqGSIb3DQEBBQUAA4GBAKgR4QcvuxFjM3GXE1iyl8ehd5VkQv7x\nbi95mXj6IdK6mzg5QwofBSltHWNKv/AHpPuBzWd0LjCstdWeJXOCoEJe7twLsFGG\nkU+Y2c688RcV0cUVNvcympR5pYNU7ky0uPd/RCV4vnZ9DQqAKCcB/3wZ2cbfyBIR\ngG19ycA9AsUe", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "swamid", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }, 
                  {
                    "text": "www07test.sub.su.se", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=www07test.sub.su.se", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIB5TCCAU6gAwIBAgIJAMMRnP48jAtqMA0GCSqGSIb3DQEBBQUAMB4xHDAaBgNV\nBAMTE3d3dzA3dGVzdC5zdWIuc3Uuc2UwHhcNMDkxMjA4MTAyMjMzWhcNMTIxMjA3\nMTAyMjMzWjAeMRwwGgYDVQQDExN3d3cwN3Rlc3Quc3ViLnN1LnNlMIGfMA0GCSqG\nSIb3DQEBAQUAA4GNADCBiQKBgQC9adDbmgkldLxg7+sU4Yh7vgHpMpCWJx3PJG4z\n1oqyG2AdYjjWeNkXpindtpadS7KaVcV+Zoc1PzqLOdp89gX5J84sox/XzCPu/RAZ\nlxtruQxRXbkYYTQYtOJaevl6eaPWsR1r2x/RQ8IW9iNOAiuw3D1CudvvphPi0M4p\nYma7NwIDAQABoyswKTAnBgNVHSUEIDAeBggrBgEFBQcDAQYIKwYBBQUHAwIGCCsG\nAQUFBwMEMA0GCSqGSIb3DQEBBQUAA4GBAKgR4QcvuxFjM3GXE1iyl8ehd5VkQv7x\nbi95mXj6IdK6mzg5QwofBSltHWNKv/AHpPuBzWd0LjCstdWeJXOCoEJe7twLsFGG\nkU+Y2c688RcV0cUVNvcympR5pYNU7ky0uPd/RCV4vnZ9DQqAKCcB/3wZ2cbfyBIR\ngG19ycA9AsUe", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://www07test.sub.su.se/Shibboleth.sso/Artifact/SOAP"
            }
          ], 
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://www07test.sub.su.se/Shibboleth.sso/NIM/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://www07test.sub.su.se/Shibboleth.sso/NIM/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://www07test.sub.su.se/Shibboleth.sso/NIM/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://www07test.sub.su.se/Shibboleth.sso/NIM/Artifact"
            }
          ]
        }
      ], 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-2.0/www07test.sub.su.se.xml"
      }
    }
  ], 
  [
    "https://unitcf.se/shibboleth", 
    {
      "entity_id": "https://unitcf.se/shibboleth", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://unitcf.se/Shibboleth.sso/SLO/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://unitcf.se/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://unitcf.se/Shibboleth.sso/SLO/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://unitcf.se/Shibboleth.sso/SLO/Artifact"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://unitcf.se/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://unitcf.se/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://unitcf.se/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://unitcf.se/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://unitcf.se/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://unitcf.se/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://unitcf.se/Shibboleth.sso/DS"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "unitcf.se", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=unitcf.se", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIC7TCCAdWgAwIBAgIJAPLtJRFIh63tMA0GCSqGSIb3DQEBBQUAMBQxEjAQBgNV\nBAMTCXVuaXRjZi5zZTAeFw0xMDA1MjYyMDI1MzZaFw0yMDA1MjMyMDI1MzZaMBQx\nEjAQBgNVBAMTCXVuaXRjZi5zZTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoC\nggEBAK4QYuhlDS3lqTEx/GMTYbcXm26G1r8bQJy31fW873gWXsB+WLOv9WPXNjBM\nR/WOli0VgSMesjliHSv9BwBQ8J0rLHD3snvj/yp3aHAvBFdElw1GK3+DrK8JN34X\npgl1KPBzmsS8lwYyyoZYCfmCxrczKs1ZIa3YBuOWLmxFh5P2TS1oaqdwlxQ+N8Xp\nXvv29rMpn5GsSjd8Ue1In2rHO0+4+oewiyQ0SKBpMSiNjxC5c50gT1dpeK2XUZLI\novvTWIPJuUzLX6b7Ft0gEw/kwvcDlVl/C/GNqOtEVPsD/mp03/eVVZVISpj7AUP1\nl7rli6ep61P5ccxH60HjaxzknyECAwEAAaNCMEAwHwYDVR0RBBgwFoIJdW5pdGNm\nLnNlhgl1bml0Y2Yuc2UwHQYDVR0OBBYEFDoYivNyzl6FLDkqruQ/1XAUQBOhMA0G\nCSqGSIb3DQEBBQUAA4IBAQCN10PiM/GBO8l9cArV3pSiuy/T1nTVEHF8cbiwzauM\nZq1dkTh52ccMeeIFItqGZ5c6IxM/KYJhGCrPw8IfICrVe2h+iLdKfu3nI8KgYIc8\nIYvoxNXSPTHiGAA5E1l2MyxAjkP89dUZgnTposoErzmFfsAas+YU28PuIFtB9E4H\nwkGECUu1qorOSdf5XxpxOLootvH6e06In5RLJR5M7Be8uBHDsJPs+w2/TqFmfu8n\nSUnwp5njZX1iqAiERi1qmNuxK4CgeQbaGUqdAngBmO560yd8gaxWcKKSPB1xyZk7\nIGfIdN4NBcMSvwweZYGgdB368AlQ5QP/h0xigpr/VCZG", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "unitcf.se", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=unitcf.se", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIC7TCCAdWgAwIBAgIJAPLtJRFIh63tMA0GCSqGSIb3DQEBBQUAMBQxEjAQBgNV\nBAMTCXVuaXRjZi5zZTAeFw0xMDA1MjYyMDI1MzZaFw0yMDA1MjMyMDI1MzZaMBQx\nEjAQBgNVBAMTCXVuaXRjZi5zZTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoC\nggEBAK4QYuhlDS3lqTEx/GMTYbcXm26G1r8bQJy31fW873gWXsB+WLOv9WPXNjBM\nR/WOli0VgSMesjliHSv9BwBQ8J0rLHD3snvj/yp3aHAvBFdElw1GK3+DrK8JN34X\npgl1KPBzmsS8lwYyyoZYCfmCxrczKs1ZIa3YBuOWLmxFh5P2TS1oaqdwlxQ+N8Xp\nXvv29rMpn5GsSjd8Ue1In2rHO0+4+oewiyQ0SKBpMSiNjxC5c50gT1dpeK2XUZLI\novvTWIPJuUzLX6b7Ft0gEw/kwvcDlVl/C/GNqOtEVPsD/mp03/eVVZVISpj7AUP1\nl7rli6ep61P5ccxH60HjaxzknyECAwEAAaNCMEAwHwYDVR0RBBgwFoIJdW5pdGNm\nLnNlhgl1bml0Y2Yuc2UwHQYDVR0OBBYEFDoYivNyzl6FLDkqruQ/1XAUQBOhMA0G\nCSqGSIb3DQEBBQUAA4IBAQCN10PiM/GBO8l9cArV3pSiuy/T1nTVEHF8cbiwzauM\nZq1dkTh52ccMeeIFItqGZ5c6IxM/KYJhGCrPw8IfICrVe2h+iLdKfu3nI8KgYIc8\nIYvoxNXSPTHiGAA5E1l2MyxAjkP89dUZgnTposoErzmFfsAas+YU28PuIFtB9E4H\nwkGECUu1qorOSdf5XxpxOLootvH6e06In5RLJR5M7Be8uBHDsJPs+w2/TqFmfu8n\nSUnwp5njZX1iqAiERi1qmNuxK4CgeQbaGUqdAngBmO560yd8gaxWcKKSPB1xyZk7\nIGfIdN4NBcMSvwweZYGgdB368AlQ5QP/h0xigpr/VCZG", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://unitcf.se/Shibboleth.sso/Artifact/SOAP"
            }
          ], 
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://unitcf.se/Shibboleth.sso/NIM/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://unitcf.se/Shibboleth.sso/NIM/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://unitcf.se/Shibboleth.sso/NIM/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://unitcf.se/Shibboleth.sso/NIM/Artifact"
            }
          ]
        }
      ], 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-2.0/unitcf.se-shibboleth.xml"
      }
    }
  ], 
  [
    "https://cafe.ifnmg.edu.br/idp/shibboleth", 
    {
      "entity_id": "https://cafe.ifnmg.edu.br/idp/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/cafe.ifnmg.edu.br.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://cafe.ifnmg.edu.br/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://cafe.ifnmg.edu.br/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://cafe.ifnmg.edu.br/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://cafe.ifnmg.edu.br/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "edu.br", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "information_url": [
                  {
                    "lang": "en", 
                    "text": "http://www.ifnmg.edu.br/", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "http://www.ifnmg.edu.br/", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }
                ], 
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "IFNMG - Instituto Federal Do Norte De Minas Gerais", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "IFNMG - Instituto Federal Do Norte De Minas Gerais", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "en", 
                    "text": "IFNMG - Instituto Federal Do Norte De Minas Gerais", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "IFNMG - Instituto Federal Do Norte De Minas Gerais", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIEbjCCA1YCAQAwDQYJKoZIhvcNAQEFBQAwgfwxOzA5BgNVBAoTMklGTk1HIC0g\nSW5zdGl0dXRvIEZlZGVyYWwgRG8gTm9ydGUgRGUgTWluYXMgR2VyYWlzMUIwQAYD\nVQQLFDlER1RJIC0gRGlyZXRvcmlhIERlIEdlc3TDo28gRGUgVGVjbm9sb2dpYSBE\nYSBJbmZvcm1hw6fDo28xITAfBgkqhkiG9w0BCQEWEmFkbWluQGlmbm1nLmVkdS5i\ncjEWMBQGA1UEBxMNTW9udGVzIENsYXJvczEVMBMGA1UECBMMTWluYXMgR2VyYWlz\nMQswCQYDVQQGEwJCUjEaMBgGA1UEAxMRY2FmZS5pZm5tZy5lZHUuYnIwHhcNMTMx\nMTA1MjE1MzEwWhcNMTYxMTA0MjE1MzEwWjCB/DE7MDkGA1UEChMySUZOTUcgLSBJ\nbnN0aXR1dG8gRmVkZXJhbCBEbyBOb3J0ZSBEZSBNaW5hcyBHZXJhaXMxQjBABgNV\nBAsUOURHVEkgLSBEaXJldG9yaWEgRGUgR2VzdMOjbyBEZSBUZWNub2xvZ2lhIERh\nIEluZm9ybWHDp8OjbzEhMB8GCSqGSIb3DQEJARYSYWRtaW5AaWZubWcuZWR1LmJy\nMRYwFAYDVQQHEw1Nb250ZXMgQ2xhcm9zMRUwEwYDVQQIEwxNaW5hcyBHZXJhaXMx\nCzAJBgNVBAYTAkJSMRowGAYDVQQDExFjYWZlLmlmbm1nLmVkdS5icjCCASIwDQYJ\nKoZIhvcNAQEBBQADggEPADCCAQoCggEBAK9uROMCbnEj8V6di0FPFPgvZEkK/maZ\nkaMPAeWFWBIsWdvvVcUYLPm/TKSgkEL3LA9gqD6LupuNHtuqVbihU2FRJ63ld57t\n/TI4K2hm1VwN9le1ajyf/GXgEcrSMkjpxbHI3rFF2PMoFR4yXmt3FVdyEXrMnIg3\n5viPKdWZyNSjdZjctPTDHoU5LZEVbdCJSm547nQdthFBUXnMxcHzsZwfx/duHrvl\nQaFDPTCKZpvy9RGTwEJ0B2iYnPz5eR8SbspvKefhQJUYRgCnljf8x5qGRmzWQoT8\nFy+4/mvZmg+nrpvA7fOJt1nz3fMTujY3nFM78hybPM5Rc9KsPmRmLsECAwEAATAN\nBgkqhkiG9w0BAQUFAAOCAQEAntnSiyrTaKTSoQcf8yqORTIO306rR+XEcZ2PdPeS\nPhbKGs6aBgHJZEU/L5YIdpuqZ5LQUNfeZEN5OwkBlGN/EljwzbhG/BJUxPYlbCiE\neZJPZ42KSEFmN0vMVE6w/9qk+b12ZxN6Jxacf5YoRwZxsMuyWzyi32zhtdWsZXpl\nXJ+KSCrwJ4xqzhWijIbVRAyVH9LV7LJauYJMMtCLvcdA4LoZwsMdfJBhXyzrStfF\nMu85g0yi6D/P4xUr9Sfh5PrlYz0DOq4K8uOcMUuQdgHI4XrY2GR5Bsb/bhEj1G3y\ncxwm5m7irBCpuw6n0qXBnOBlv+ZnUvSL2IuRPXpUw2vJ0A==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://cafe.ifnmg.edu.br:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }, 
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://cafe.ifnmg.edu.br:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "pt-br", 
                "text": "http://www.rnp.br/_arquivo/servicos/Politica_CAFe_IDP_final.pdf", 
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy"
              }
            ], 
            "registration_authority": "http://cafe.rnp.br", 
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo", 
            "registration_instant": "2010-01-01T00:00:00Z"
          }
        ]
      }, 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://cafe.ifnmg.edu.br:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://cafe.ifnmg.edu.br:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "edu.br", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIEbjCCA1YCAQAwDQYJKoZIhvcNAQEFBQAwgfwxOzA5BgNVBAoTMklGTk1HIC0g\nSW5zdGl0dXRvIEZlZGVyYWwgRG8gTm9ydGUgRGUgTWluYXMgR2VyYWlzMUIwQAYD\nVQQLFDlER1RJIC0gRGlyZXRvcmlhIERlIEdlc3TDo28gRGUgVGVjbm9sb2dpYSBE\nYSBJbmZvcm1hw6fDo28xITAfBgkqhkiG9w0BCQEWEmFkbWluQGlmbm1nLmVkdS5i\ncjEWMBQGA1UEBxMNTW9udGVzIENsYXJvczEVMBMGA1UECBMMTWluYXMgR2VyYWlz\nMQswCQYDVQQGEwJCUjEaMBgGA1UEAxMRY2FmZS5pZm5tZy5lZHUuYnIwHhcNMTMx\nMTA1MjE1MzEwWhcNMTYxMTA0MjE1MzEwWjCB/DE7MDkGA1UEChMySUZOTUcgLSBJ\nbnN0aXR1dG8gRmVkZXJhbCBEbyBOb3J0ZSBEZSBNaW5hcyBHZXJhaXMxQjBABgNV\nBAsUOURHVEkgLSBEaXJldG9yaWEgRGUgR2VzdMOjbyBEZSBUZWNub2xvZ2lhIERh\nIEluZm9ybWHDp8OjbzEhMB8GCSqGSIb3DQEJARYSYWRtaW5AaWZubWcuZWR1LmJy\nMRYwFAYDVQQHEw1Nb250ZXMgQ2xhcm9zMRUwEwYDVQQIEwxNaW5hcyBHZXJhaXMx\nCzAJBgNVBAYTAkJSMRowGAYDVQQDExFjYWZlLmlmbm1nLmVkdS5icjCCASIwDQYJ\nKoZIhvcNAQEBBQADggEPADCCAQoCggEBAK9uROMCbnEj8V6di0FPFPgvZEkK/maZ\nkaMPAeWFWBIsWdvvVcUYLPm/TKSgkEL3LA9gqD6LupuNHtuqVbihU2FRJ63ld57t\n/TI4K2hm1VwN9le1ajyf/GXgEcrSMkjpxbHI3rFF2PMoFR4yXmt3FVdyEXrMnIg3\n5viPKdWZyNSjdZjctPTDHoU5LZEVbdCJSm547nQdthFBUXnMxcHzsZwfx/duHrvl\nQaFDPTCKZpvy9RGTwEJ0B2iYnPz5eR8SbspvKefhQJUYRgCnljf8x5qGRmzWQoT8\nFy+4/mvZmg+nrpvA7fOJt1nz3fMTujY3nFM78hybPM5Rc9KsPmRmLsECAwEAATAN\nBgkqhkiG9w0BAQUFAAOCAQEAntnSiyrTaKTSoQcf8yqORTIO306rR+XEcZ2PdPeS\nPhbKGs6aBgHJZEU/L5YIdpuqZ5LQUNfeZEN5OwkBlGN/EljwzbhG/BJUxPYlbCiE\neZJPZ42KSEFmN0vMVE6w/9qk+b12ZxN6Jxacf5YoRwZxsMuyWzyi32zhtdWsZXpl\nXJ+KSCrwJ4xqzhWijIbVRAyVH9LV7LJauYJMMtCLvcdA4LoZwsMdfJBhXyzrStfF\nMu85g0yi6D/P4xUr9Sfh5PrlYz0DOq4K8uOcMUuQdgHI4XrY2GR5Bsb/bhEj1G3y\ncxwm5m7irBCpuw6n0qXBnOBlv+ZnUvSL2IuRPXpUw2vJ0A==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "IFNMG - Instituto Federal Do Norte De Minas Gerais", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }, 
          {
            "lang": "pt-br", 
            "text": "IFNMG - Instituto Federal Do Norte De Minas Gerais", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "IFNMG - Instituto Federal Do Norte De Minas Gerais", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }, 
          {
            "lang": "pt-br", 
            "text": "IFNMG - Instituto Federal Do Norte De Minas Gerais", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.ifnmg.edu.br/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }, 
          {
            "lang": "pt-br", 
            "text": "http://www.ifnmg.edu.br/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "email_address": [
            {
              "text": "christopher.mota@ifnmg.edu.br", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Christopher Mota", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://terena.org/sp", 
    {
      "entity_id": "https://terena.org/sp", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-externals-2.0/terena.org.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "TERENA", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "TERENA", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.terena.org/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "TERENA", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "aai@terena.org", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "AAI team", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://login.terena.org/wayf/module.php/saml/sp/saml2-logout.php/default-sp"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "0", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://login.terena.org/wayf/module.php/saml/sp/saml2-acs.php/default-sp"
            }, 
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://login.terena.org/wayf/module.php/saml/sp/saml1-acs.php/default-sp"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://login.terena.org/wayf/module.php/saml/sp/saml2-acs.php/default-sp"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://login.terena.org/wayf/module.php/saml/sp/saml1-acs.php/default-sp/artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "TERENA Service Provider Proxy", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "description": [
                  {
                    "lang": "en", 
                    "text": "A service provider proxy for all TERENA federated services", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "information_url": [
                  {
                    "lang": "en", 
                    "text": "https://confluence.terena.org/display/aai/Service+Provider+Proxy", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }
                ], 
                "privacy_statement_url": [
                  {
                    "lang": "en", 
                    "text": "http://www.terena.org/p3p", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&PrivacyStatementURL"
                  }
                ], 
                "logo": [
                  {
                    "text": "https://www.terena.org/gfx/terena_logo_slogan_rgb-350x97.png", 
                    "width": "350", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo", 
                    "height": "94"
                  }
                ]
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIEkjCCA3qgAwIBAgIJAL90CxMEVb/kMA0GCSqGSIb3DQEBBQUAMIGMMQswCQYDVQQGEwJOTDELMAkGA1UECBMCTkgxEjAQBgNVBAcTCUFtc3RlcmRhbTEPMA0GA1UEChMGVEVSRU5BMQwwCgYDVQQLEwNJVFMxHjAcBgNVBAMTFWh0dHBzOi8vdGVyZW5hLm9yZy9zcDEdMBsGCSqGSIb3DQEJARYOYWFpQHRlcmVuYS5vcmcwHhcNMTEwMTEyMTUyNjM4WhcNMjEwMTExMTUyNjM4WjCBjDELMAkGA1UEBhMCTkwxCzAJBgNVBAgTAk5IMRIwEAYDVQQHEwlBbXN0ZXJkYW0xDzANBgNVBAoTBlRFUkVOQTEMMAoGA1UECxMDSVRTMR4wHAYDVQQDExVodHRwczovL3RlcmVuYS5vcmcvc3AxHTAbBgkqhkiG9w0BCQEWDmFhaUB0ZXJlbmEub3JnMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwTxx8JBWSpBJiZgdvGOJDXLwaE29Opx1CBbIrYHm47Oy4btsf0BzCmfdSPDlydDm6//355hsQU8BgIh/waEwFZZCg/XyzrJEXCDTZBm1H210aT7FNp356azqKOO1bYWcku0xpFOWWf3jCIkjtOiTkbl12Tw7Y+zJRhV2+jleC5td3JxZ6k1qotgN+1cGwZ2Tv2HhSNeMC4QsGOyBqeP+7B1CLFqFZSiLWGVqcZi0fGkXf+SrTSEH/kLzdciEg2EePyQPcLCKNz9RiIhSmsLE/Rr1ksOvZGmyWFe7YsPyJOLsNyYcZTufDVwpl9fDuJdYy2GdMT1kSNNOpZXZ7QcgYwIDAQABo4H0MIHxMB0GA1UdDgQWBBQ6tVqjpKC8+30XF/qWlaZ3fUKTvDCBwQYDVR0jBIG5MIG2gBQ6tVqjpKC8+30XF/qWlaZ3fUKTvKGBkqSBjzCBjDELMAkGA1UEBhMCTkwxCzAJBgNVBAgTAk5IMRIwEAYDVQQHEwlBbXN0ZXJkYW0xDzANBgNVBAoTBlRFUkVOQTEMMAoGA1UECxMDSVRTMR4wHAYDVQQDExVodHRwczovL3RlcmVuYS5vcmcvc3AxHTAbBgkqhkiG9w0BCQEWDmFhaUB0ZXJlbmEub3JnggkAv3QLEwRVv+QwDAYDVR0TBAUwAwEB/zANBgkqhkiG9w0BAQUFAAOCAQEAn+06i7zZE7MjuB68gCaNvnCkrgfumi4PWiP6kaE6+LU2MTbxdFyoSAoKh6Ft9TDi+8ANAsn5jRQ5xLUE4YoVbub/KufMwdlX0zO9i+Q//npDTFESnWsiMi7DHg/av1LtzrYYZvE2E1e5c/7wo/axx8Bk7qsE9YXFRs372vDkDwOGSkLbRtgwdCUX47CE/fXvccPDHH217XMed2cVOGFjQgidsFZlJbSfSvQjWYw5LIE0wo9RtsEu5I3WAIar8Wr6/nhVOgIBUStpcw94GwlPxLywfij5CJ9HT+sN2SOj4YmKPBtcwHI75uNZp7XRy85jRjrvhahg5baIQ0u3aL8aMA==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "encryption", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIEkjCCA3qgAwIBAgIJAL90CxMEVb/kMA0GCSqGSIb3DQEBBQUAMIGMMQswCQYDVQQGEwJOTDELMAkGA1UECBMCTkgxEjAQBgNVBAcTCUFtc3RlcmRhbTEPMA0GA1UEChMGVEVSRU5BMQwwCgYDVQQLEwNJVFMxHjAcBgNVBAMTFWh0dHBzOi8vdGVyZW5hLm9yZy9zcDEdMBsGCSqGSIb3DQEJARYOYWFpQHRlcmVuYS5vcmcwHhcNMTEwMTEyMTUyNjM4WhcNMjEwMTExMTUyNjM4WjCBjDELMAkGA1UEBhMCTkwxCzAJBgNVBAgTAk5IMRIwEAYDVQQHEwlBbXN0ZXJkYW0xDzANBgNVBAoTBlRFUkVOQTEMMAoGA1UECxMDSVRTMR4wHAYDVQQDExVodHRwczovL3RlcmVuYS5vcmcvc3AxHTAbBgkqhkiG9w0BCQEWDmFhaUB0ZXJlbmEub3JnMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwTxx8JBWSpBJiZgdvGOJDXLwaE29Opx1CBbIrYHm47Oy4btsf0BzCmfdSPDlydDm6//355hsQU8BgIh/waEwFZZCg/XyzrJEXCDTZBm1H210aT7FNp356azqKOO1bYWcku0xpFOWWf3jCIkjtOiTkbl12Tw7Y+zJRhV2+jleC5td3JxZ6k1qotgN+1cGwZ2Tv2HhSNeMC4QsGOyBqeP+7B1CLFqFZSiLWGVqcZi0fGkXf+SrTSEH/kLzdciEg2EePyQPcLCKNz9RiIhSmsLE/Rr1ksOvZGmyWFe7YsPyJOLsNyYcZTufDVwpl9fDuJdYy2GdMT1kSNNOpZXZ7QcgYwIDAQABo4H0MIHxMB0GA1UdDgQWBBQ6tVqjpKC8+30XF/qWlaZ3fUKTvDCBwQYDVR0jBIG5MIG2gBQ6tVqjpKC8+30XF/qWlaZ3fUKTvKGBkqSBjzCBjDELMAkGA1UEBhMCTkwxCzAJBgNVBAgTAk5IMRIwEAYDVQQHEwlBbXN0ZXJkYW0xDzANBgNVBAoTBlRFUkVOQTEMMAoGA1UECxMDSVRTMR4wHAYDVQQDExVodHRwczovL3RlcmVuYS5vcmcvc3AxHTAbBgkqhkiG9w0BCQEWDmFhaUB0ZXJlbmEub3JnggkAv3QLEwRVv+QwDAYDVR0TBAUwAwEB/zANBgkqhkiG9w0BAQUFAAOCAQEAn+06i7zZE7MjuB68gCaNvnCkrgfumi4PWiP6kaE6+LU2MTbxdFyoSAoKh6Ft9TDi+8ANAsn5jRQ5xLUE4YoVbub/KufMwdlX0zO9i+Q//npDTFESnWsiMi7DHg/av1LtzrYYZvE2E1e5c/7wo/axx8Bk7qsE9YXFRs372vDkDwOGSkLbRtgwdCUX47CE/fXvccPDHH217XMed2cVOGFjQgidsFZlJbSfSvQjWYw5LIE0wo9RtsEu5I3WAIar8Wr6/nhVOgIBUStpcw94GwlPxLywfij5CJ9HT+sN2SOj4YmKPBtcwHI75uNZp7XRy85jRjrvhahg5baIQ0u3aL8aMA==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "attribute_consuming_service": [
            {
              "index": "0", 
              "service_description": [
                {
                  "lang": "en", 
                  "text": "A Service Provider Proxy for all TERENA Federated Services", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription"
                }
              ], 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService", 
              "requested_attribute": [
                {
                  "is_required": "true", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.10"
                }, 
                {
                  "is_required": "true", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.6"
                }, 
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.1"
                }, 
                {
                  "is_required": "true", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:0.9.2342.19200300.100.1.3"
                }, 
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.16.840.1.113730.3.1.241"
                }, 
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.5.4.4"
                }, 
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.5.4.42"
                }
              ], 
              "service_name": [
                {
                  "lang": "en", 
                  "text": "TERENA Service Provider Proxy", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }
              ]
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://login2.hs-mittweida.de/idp/shibboleth", 
    {
      "entity_id": "https://login2.hs-mittweida.de/idp/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/login2.hs-mittweida.de.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://login2.hs-mittweida.de/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://login2.hs-mittweida.de/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://login2.hs-mittweida.de/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "hs-mittweida.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "login2.hs-mittweida.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=login2.hs-mittweida.de,O=Hochschule Mittweida (FH) - University of Applied Sciences,L=Mittweida,ST=Sachsen,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFiTCCBHGgAwIBAgIEDR0M3jANBgkqhkiG9w0BAQUFADCBpjELMAkGA1UEBhMC\nREUxEDAOBgNVBAgTB1NhY2hzZW4xEjAQBgNVBAcTCU1pdHR3ZWlkYTFDMEEGA1UE\nChM6SG9jaHNjaHVsZSBNaXR0d2VpZGEgKEZIKSAtIFVuaXZlcnNpdHkgb2YgQXBw\nbGllZCBTY2llbmNlczEQMA4GA1UEAxMHSFRXTSBDQTEaMBgGCSqGSIb3DQEJARYL\ncGtpQGh0d20uZGUwHhcNMDgxMDIxMDgxNDA3WhcNMTMxMDIwMDgxNDA3WjCBmTEL\nMAkGA1UEBhMCREUxEDAOBgNVBAgTB1NhY2hzZW4xEjAQBgNVBAcTCU1pdHR3ZWlk\nYTFDMEEGA1UEChM6SG9jaHNjaHVsZSBNaXR0d2VpZGEgKEZIKSAtIFVuaXZlcnNp\ndHkgb2YgQXBwbGllZCBTY2llbmNlczEfMB0GA1UEAxMWbG9naW4yLmhzLW1pdHR3\nZWlkYS5kZTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAKYgPFWH0AnT\nCh9RD41shYVlrsyiay80CEumGXqLkW+uGlRa5DaxJUmFCrOUoj2ond31l/PLSA3D\n/UuJo1mFGSX8T19xKTUZAaKgLE14dxwukbxjjX27y0nK7VfMxoLmTAgWS0AMdIue\nSl7MRgqSXCg3wwuKQphHhcYPl2uDPQK/Yv8U6d0zlAnr/eiwFk4scz2/PgE8Ts+N\nQ4z6g83VNQKlSqGa+ExZ7Np0VjD51AXrNynVISaBoXtJfjFkwOvV3DaFooV5e4NC\n56Gx3GabqG89s85aDGzkB43WVTzScO5FGBMOQsYfO6kzyUwp1VUCj3DJtueTRWPU\nnlBcDFjN7NsCAwEAAaOCAcgwggHEMAkGA1UdEwQCMAAwCwYDVR0PBAQDAgXgMB0G\nA1UdJQQWMBQGCCsGAQUFBwMCBggrBgEFBQcDATAdBgNVHQ4EFgQUirW4438b5lTj\nrX6ByfHLGB/jJzQwHwYDVR0jBBgwFoAUthDQcSc/RbN2Lii4Ib5AORnredgwFgYD\nVR0RBA8wDYELcGtpQGh0d20uZGUwgYsGA1UdHwSBgzCBgDA+oDygOoY4aHR0cDov\nL2NkcDEucGNhLmRmbi5kZS9ocy1taXR0d2VpZGEtY2EvcHViL2NybC9jYWNybC5j\ncmwwPqA8oDqGOGh0dHA6Ly9jZHAyLnBjYS5kZm4uZGUvaHMtbWl0dHdlaWRhLWNh\nL3B1Yi9jcmwvY2FjcmwuY3JsMIGkBggrBgEFBQcBAQSBlzCBlDBIBggrBgEFBQcw\nAoY8aHR0cDovL2NkcDEucGNhLmRmbi5kZS9ocy1taXR0d2VpZGEtY2EvcHViL2Nh\nY2VydC9jYWNlcnQuY3J0MEgGCCsGAQUFBzAChjxodHRwOi8vY2RwMi5wY2EuZGZu\nLmRlL2hzLW1pdHR3ZWlkYS1jYS9wdWIvY2FjZXJ0L2NhY2VydC5jcnQwDQYJKoZI\nhvcNAQEFBQADggEBAAGcArobqCHlzG8GO5wWaAS+mLqjWBLbROftIBz2xAj6FcyH\nYDixCT16/Zgt/H6+KUaHxnIQ5vPf9QSJTYMDqtr/WdS8FOPXovFT3mKQunAP+SgG\nqcadVUu9hZ6c9q8BsTIf+jY/G2WQX7LgNQ03JfAomdaQEhmGYqrHoQMCFCN3CLb/\n7t1/xH96cStRITB2nN9liEwTRLrGEc9XMAFM0lgjj+o7M/f9xfzagWw5HfYzjHte\nPAloYirtXrNJfNjAdtSpX6D8uq4TKtLwWVAuu3RsJwqMLjABQsyDJV2xXnYoJoy5\n+NSkVBR/TI4nZCwb990PUBiK5mAszI7kxISvEcg=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "login2.hs-mittweida.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=login2.hs-mittweida.de,O=Hochschule Mittweida (FH) - University of Applied Sciences,L=Mittweida,ST=Sachsen,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFiTCCBHGgAwIBAgIEDR0M3jANBgkqhkiG9w0BAQUFADCBpjELMAkGA1UEBhMC\nREUxEDAOBgNVBAgTB1NhY2hzZW4xEjAQBgNVBAcTCU1pdHR3ZWlkYTFDMEEGA1UE\nChM6SG9jaHNjaHVsZSBNaXR0d2VpZGEgKEZIKSAtIFVuaXZlcnNpdHkgb2YgQXBw\nbGllZCBTY2llbmNlczEQMA4GA1UEAxMHSFRXTSBDQTEaMBgGCSqGSIb3DQEJARYL\ncGtpQGh0d20uZGUwHhcNMDgxMDIxMDgxNDA3WhcNMTMxMDIwMDgxNDA3WjCBmTEL\nMAkGA1UEBhMCREUxEDAOBgNVBAgTB1NhY2hzZW4xEjAQBgNVBAcTCU1pdHR3ZWlk\nYTFDMEEGA1UEChM6SG9jaHNjaHVsZSBNaXR0d2VpZGEgKEZIKSAtIFVuaXZlcnNp\ndHkgb2YgQXBwbGllZCBTY2llbmNlczEfMB0GA1UEAxMWbG9naW4yLmhzLW1pdHR3\nZWlkYS5kZTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAKYgPFWH0AnT\nCh9RD41shYVlrsyiay80CEumGXqLkW+uGlRa5DaxJUmFCrOUoj2ond31l/PLSA3D\n/UuJo1mFGSX8T19xKTUZAaKgLE14dxwukbxjjX27y0nK7VfMxoLmTAgWS0AMdIue\nSl7MRgqSXCg3wwuKQphHhcYPl2uDPQK/Yv8U6d0zlAnr/eiwFk4scz2/PgE8Ts+N\nQ4z6g83VNQKlSqGa+ExZ7Np0VjD51AXrNynVISaBoXtJfjFkwOvV3DaFooV5e4NC\n56Gx3GabqG89s85aDGzkB43WVTzScO5FGBMOQsYfO6kzyUwp1VUCj3DJtueTRWPU\nnlBcDFjN7NsCAwEAAaOCAcgwggHEMAkGA1UdEwQCMAAwCwYDVR0PBAQDAgXgMB0G\nA1UdJQQWMBQGCCsGAQUFBwMCBggrBgEFBQcDATAdBgNVHQ4EFgQUirW4438b5lTj\nrX6ByfHLGB/jJzQwHwYDVR0jBBgwFoAUthDQcSc/RbN2Lii4Ib5AORnredgwFgYD\nVR0RBA8wDYELcGtpQGh0d20uZGUwgYsGA1UdHwSBgzCBgDA+oDygOoY4aHR0cDov\nL2NkcDEucGNhLmRmbi5kZS9ocy1taXR0d2VpZGEtY2EvcHViL2NybC9jYWNybC5j\ncmwwPqA8oDqGOGh0dHA6Ly9jZHAyLnBjYS5kZm4uZGUvaHMtbWl0dHdlaWRhLWNh\nL3B1Yi9jcmwvY2FjcmwuY3JsMIGkBggrBgEFBQcBAQSBlzCBlDBIBggrBgEFBQcw\nAoY8aHR0cDovL2NkcDEucGNhLmRmbi5kZS9ocy1taXR0d2VpZGEtY2EvcHViL2Nh\nY2VydC9jYWNlcnQuY3J0MEgGCCsGAQUFBzAChjxodHRwOi8vY2RwMi5wY2EuZGZu\nLmRlL2hzLW1pdHR3ZWlkYS1jYS9wdWIvY2FjZXJ0L2NhY2VydC5jcnQwDQYJKoZI\nhvcNAQEFBQADggEBAAGcArobqCHlzG8GO5wWaAS+mLqjWBLbROftIBz2xAj6FcyH\nYDixCT16/Zgt/H6+KUaHxnIQ5vPf9QSJTYMDqtr/WdS8FOPXovFT3mKQunAP+SgG\nqcadVUu9hZ6c9q8BsTIf+jY/G2WQX7LgNQ03JfAomdaQEhmGYqrHoQMCFCN3CLb/\n7t1/xH96cStRITB2nN9liEwTRLrGEc9XMAFM0lgjj+o7M/f9xfzagWw5HfYzjHte\nPAloYirtXrNJfNjAdtSpX6D8uq4TKtLwWVAuu3RsJwqMLjABQsyDJV2xXnYoJoy5\n+NSkVBR/TI4nZCwb990PUBiK5mAszI7kxISvEcg=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://login2.hs-mittweida.de:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://login2.hs-mittweida.de:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://login2.hs-mittweida.de:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://login2.hs-mittweida.de:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "hs-mittweida.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "login2.hs-mittweida.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=login2.hs-mittweida.de,O=Hochschule Mittweida (FH) - University of Applied Sciences,L=Mittweida,ST=Sachsen,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFiTCCBHGgAwIBAgIEDR0M3jANBgkqhkiG9w0BAQUFADCBpjELMAkGA1UEBhMC\nREUxEDAOBgNVBAgTB1NhY2hzZW4xEjAQBgNVBAcTCU1pdHR3ZWlkYTFDMEEGA1UE\nChM6SG9jaHNjaHVsZSBNaXR0d2VpZGEgKEZIKSAtIFVuaXZlcnNpdHkgb2YgQXBw\nbGllZCBTY2llbmNlczEQMA4GA1UEAxMHSFRXTSBDQTEaMBgGCSqGSIb3DQEJARYL\ncGtpQGh0d20uZGUwHhcNMDgxMDIxMDgxNDA3WhcNMTMxMDIwMDgxNDA3WjCBmTEL\nMAkGA1UEBhMCREUxEDAOBgNVBAgTB1NhY2hzZW4xEjAQBgNVBAcTCU1pdHR3ZWlk\nYTFDMEEGA1UEChM6SG9jaHNjaHVsZSBNaXR0d2VpZGEgKEZIKSAtIFVuaXZlcnNp\ndHkgb2YgQXBwbGllZCBTY2llbmNlczEfMB0GA1UEAxMWbG9naW4yLmhzLW1pdHR3\nZWlkYS5kZTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAKYgPFWH0AnT\nCh9RD41shYVlrsyiay80CEumGXqLkW+uGlRa5DaxJUmFCrOUoj2ond31l/PLSA3D\n/UuJo1mFGSX8T19xKTUZAaKgLE14dxwukbxjjX27y0nK7VfMxoLmTAgWS0AMdIue\nSl7MRgqSXCg3wwuKQphHhcYPl2uDPQK/Yv8U6d0zlAnr/eiwFk4scz2/PgE8Ts+N\nQ4z6g83VNQKlSqGa+ExZ7Np0VjD51AXrNynVISaBoXtJfjFkwOvV3DaFooV5e4NC\n56Gx3GabqG89s85aDGzkB43WVTzScO5FGBMOQsYfO6kzyUwp1VUCj3DJtueTRWPU\nnlBcDFjN7NsCAwEAAaOCAcgwggHEMAkGA1UdEwQCMAAwCwYDVR0PBAQDAgXgMB0G\nA1UdJQQWMBQGCCsGAQUFBwMCBggrBgEFBQcDATAdBgNVHQ4EFgQUirW4438b5lTj\nrX6ByfHLGB/jJzQwHwYDVR0jBBgwFoAUthDQcSc/RbN2Lii4Ib5AORnredgwFgYD\nVR0RBA8wDYELcGtpQGh0d20uZGUwgYsGA1UdHwSBgzCBgDA+oDygOoY4aHR0cDov\nL2NkcDEucGNhLmRmbi5kZS9ocy1taXR0d2VpZGEtY2EvcHViL2NybC9jYWNybC5j\ncmwwPqA8oDqGOGh0dHA6Ly9jZHAyLnBjYS5kZm4uZGUvaHMtbWl0dHdlaWRhLWNh\nL3B1Yi9jcmwvY2FjcmwuY3JsMIGkBggrBgEFBQcBAQSBlzCBlDBIBggrBgEFBQcw\nAoY8aHR0cDovL2NkcDEucGNhLmRmbi5kZS9ocy1taXR0d2VpZGEtY2EvcHViL2Nh\nY2VydC9jYWNlcnQuY3J0MEgGCCsGAQUFBzAChjxodHRwOi8vY2RwMi5wY2EuZGZu\nLmRlL2hzLW1pdHR3ZWlkYS1jYS9wdWIvY2FjZXJ0L2NhY2VydC5jcnQwDQYJKoZI\nhvcNAQEFBQADggEBAAGcArobqCHlzG8GO5wWaAS+mLqjWBLbROftIBz2xAj6FcyH\nYDixCT16/Zgt/H6+KUaHxnIQ5vPf9QSJTYMDqtr/WdS8FOPXovFT3mKQunAP+SgG\nqcadVUu9hZ6c9q8BsTIf+jY/G2WQX7LgNQ03JfAomdaQEhmGYqrHoQMCFCN3CLb/\n7t1/xH96cStRITB2nN9liEwTRLrGEc9XMAFM0lgjj+o7M/f9xfzagWw5HfYzjHte\nPAloYirtXrNJfNjAdtSpX6D8uq4TKtLwWVAuu3RsJwqMLjABQsyDJV2xXnYoJoy5\n+NSkVBR/TI4nZCwb990PUBiK5mAszI7kxISvEcg=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "login2.hs-mittweida.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=login2.hs-mittweida.de,O=Hochschule Mittweida (FH) - University of Applied Sciences,L=Mittweida,ST=Sachsen,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFiTCCBHGgAwIBAgIEDR0M3jANBgkqhkiG9w0BAQUFADCBpjELMAkGA1UEBhMC\nREUxEDAOBgNVBAgTB1NhY2hzZW4xEjAQBgNVBAcTCU1pdHR3ZWlkYTFDMEEGA1UE\nChM6SG9jaHNjaHVsZSBNaXR0d2VpZGEgKEZIKSAtIFVuaXZlcnNpdHkgb2YgQXBw\nbGllZCBTY2llbmNlczEQMA4GA1UEAxMHSFRXTSBDQTEaMBgGCSqGSIb3DQEJARYL\ncGtpQGh0d20uZGUwHhcNMDgxMDIxMDgxNDA3WhcNMTMxMDIwMDgxNDA3WjCBmTEL\nMAkGA1UEBhMCREUxEDAOBgNVBAgTB1NhY2hzZW4xEjAQBgNVBAcTCU1pdHR3ZWlk\nYTFDMEEGA1UEChM6SG9jaHNjaHVsZSBNaXR0d2VpZGEgKEZIKSAtIFVuaXZlcnNp\ndHkgb2YgQXBwbGllZCBTY2llbmNlczEfMB0GA1UEAxMWbG9naW4yLmhzLW1pdHR3\nZWlkYS5kZTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAKYgPFWH0AnT\nCh9RD41shYVlrsyiay80CEumGXqLkW+uGlRa5DaxJUmFCrOUoj2ond31l/PLSA3D\n/UuJo1mFGSX8T19xKTUZAaKgLE14dxwukbxjjX27y0nK7VfMxoLmTAgWS0AMdIue\nSl7MRgqSXCg3wwuKQphHhcYPl2uDPQK/Yv8U6d0zlAnr/eiwFk4scz2/PgE8Ts+N\nQ4z6g83VNQKlSqGa+ExZ7Np0VjD51AXrNynVISaBoXtJfjFkwOvV3DaFooV5e4NC\n56Gx3GabqG89s85aDGzkB43WVTzScO5FGBMOQsYfO6kzyUwp1VUCj3DJtueTRWPU\nnlBcDFjN7NsCAwEAAaOCAcgwggHEMAkGA1UdEwQCMAAwCwYDVR0PBAQDAgXgMB0G\nA1UdJQQWMBQGCCsGAQUFBwMCBggrBgEFBQcDATAdBgNVHQ4EFgQUirW4438b5lTj\nrX6ByfHLGB/jJzQwHwYDVR0jBBgwFoAUthDQcSc/RbN2Lii4Ib5AORnredgwFgYD\nVR0RBA8wDYELcGtpQGh0d20uZGUwgYsGA1UdHwSBgzCBgDA+oDygOoY4aHR0cDov\nL2NkcDEucGNhLmRmbi5kZS9ocy1taXR0d2VpZGEtY2EvcHViL2NybC9jYWNybC5j\ncmwwPqA8oDqGOGh0dHA6Ly9jZHAyLnBjYS5kZm4uZGUvaHMtbWl0dHdlaWRhLWNh\nL3B1Yi9jcmwvY2FjcmwuY3JsMIGkBggrBgEFBQcBAQSBlzCBlDBIBggrBgEFBQcw\nAoY8aHR0cDovL2NkcDEucGNhLmRmbi5kZS9ocy1taXR0d2VpZGEtY2EvcHViL2Nh\nY2VydC9jYWNlcnQuY3J0MEgGCCsGAQUFBzAChjxodHRwOi8vY2RwMi5wY2EuZGZu\nLmRlL2hzLW1pdHR3ZWlkYS1jYS9wdWIvY2FjZXJ0L2NhY2VydC5jcnQwDQYJKoZI\nhvcNAQEFBQADggEBAAGcArobqCHlzG8GO5wWaAS+mLqjWBLbROftIBz2xAj6FcyH\nYDixCT16/Zgt/H6+KUaHxnIQ5vPf9QSJTYMDqtr/WdS8FOPXovFT3mKQunAP+SgG\nqcadVUu9hZ6c9q8BsTIf+jY/G2WQX7LgNQ03JfAomdaQEhmGYqrHoQMCFCN3CLb/\n7t1/xH96cStRITB2nN9liEwTRLrGEc9XMAFM0lgjj+o7M/f9xfzagWw5HfYzjHte\nPAloYirtXrNJfNjAdtSpX6D8uq4TKtLwWVAuu3RsJwqMLjABQsyDJV2xXnYoJoy5\n+NSkVBR/TI4nZCwb990PUBiK5mAszI7kxISvEcg=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "de", 
            "text": "Hochschule Mittweida - University of Applied Sciences", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "Hochschule Mittweida", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "http://www.hs-mittweida.de/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Matthias", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "luehr@hs-mittweida.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "L\u00fchr", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Jens", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "rabe@hs-mittweida.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Rabe", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://wiki.its.uu.se/shibboleth", 
    {
      "entity_id": "https://wiki.its.uu.se/shibboleth", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://wiki.its.uu.se/Shibboleth.sso/SLO/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://wiki.its.uu.se/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://wiki.its.uu.se/Shibboleth.sso/SLO/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://wiki.its.uu.se/Shibboleth.sso/SLO/Artifact"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "assertion_consumer_service": [
            {
              "index": "0", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://wiki.its.uu.se/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://wiki.its.uu.se/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://wiki.its.uu.se/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://wiki.its.uu.se/Shibboleth.sso/SAML2/ECP"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "display_name": [
                  {
                    "lang": "sv", 
                    "text": "IT-avdelningens Wiki", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }, 
                  {
                    "lang": "en", 
                    "text": "IT Department Wiki", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "sv", 
                    "text": "Uppsala universitets IT-avdelnings interna wiki", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }, 
                  {
                    "lang": "en", 
                    "text": "The internal Wiki for the IT Department at Uppsala University", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "text": "pugnax.its.uu.se", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=pugnax.its.uu.se", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIC9zCCAd+gAwIBAgIJAIEkN+8ylUzuMA0GCSqGSIb3DQEBBQUAMBsxGTAXBgNV\nBAMTEHB1Z25heC5pdHMudXUuc2UwHhcNMTIwMzI5MTI0ODI3WhcNMjIwMzI3MTI0\nODI3WjAbMRkwFwYDVQQDExBwdWduYXguaXRzLnV1LnNlMIIBIjANBgkqhkiG9w0B\nAQEFAAOCAQ8AMIIBCgKCAQEAp9HVFza7nA9Fh9sC8vy+uMffu02L6lRs5nAW7diP\nlTXyBF9rdZqpWsDmLpjHXxpi0aMtTsN1NPqxMFbRTVKfq6nqCSzSQcO0BLsE9UmT\nVzBgHMoBrhijdTOUNTP6ERotOspin7d5/WB3wnJSDs54lKsB4lyoaScEitBQb8JA\nMhaM24GepDIiP7wQmssJxKyyIEaBoM81L33XD5UCwBiAW8ZwBkYuKmtq/lru3+fL\nxoT/BOhdjbwFNKwHgUB0LDAmwHKsj0FcnJc6apxG+eE0MzOZ5dkoiNpyybwVt1/U\nKrmRgqlci4EhpPFRVD3S6uojs2WGBFpYaGHSgf7m3pLSbwIDAQABoz4wPDAbBgNV\nHREEFDASghBwdWduYXguaXRzLnV1LnNlMB0GA1UdDgQWBBRnYVgSJGy17XqAvfXt\nWkHkNJNL/jANBgkqhkiG9w0BAQUFAAOCAQEAHKyn+Y9WjCo6bVT7XI0OrJj5MbVy\nT7HPRhOOoC+SjvH3TgQBKO06yM/7yDpRQTQHBGbtX6hGmBMSNhs+saMvxcX4Ynte\nTIu8VDBgm4pKnZL3Py5pVRns8ivjjDe7Ae6PjCcknSTgZtVAirCaOtnk8W+vu+HA\nd/g/Y37yeGrhLJiBtyq+NVgVgeGHMSqkTfaV9l4sZdvqTf7jFJTpuMebgzvFn6u1\nXMGVrPxSiWUso4tYO1oJTLWtcYY7WOdDErYMapTQnBr4dAp6xEidPIBKWZtiDt/n\noRKVGees9hV1yjdopT21LpRoP51+BZSaPKC3HC84mM8E/1hm6zznifrP/w==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "0", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://wiki.its.uu.se/Shibboleth.sso/Artifact/SOAP"
            }
          ]
        }
      ], 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-2.0/wiki.its.uu.se-shibboleth.xml"
      }
    }
  ], 
  [
    "https://www.mit-ik.ladok.se/gui-sp", 
    {
      "entity_id": "https://www.mit-ik.ladok.se/gui-sp", 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "attribute": [
              {
                "attribute_value": [
                  {
                    "text": "http://www.swamid.se/category/research-and-education", 
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue", 
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    }
                  }, 
                  {
                    "text": "http://www.swamid.se/category/hei-service", 
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue", 
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    }
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute", 
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                "name": "http://macedir.org/entity-category"
              }
            ], 
            "__class__": "urn:oasis:names:tc:SAML:metadata:attribute&EntityAttributes"
          }
        ]
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://www.mit-ik.ladok.se/Shibboleth.sso/SLO/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://www.mit-ik.ladok.se/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://www.mit-ik.ladok.se/Shibboleth.sso/SLO/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://www.mit-ik.ladok.se/Shibboleth.sso/SLO/Artifact"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.mit-ik.ladok.se/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.mit-ik.ladok.se/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.mit-ik.ladok.se/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.mit-ik.ladok.se/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.mit-ik.ladok.se/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://www.mit-ik.ladok.se/Shibboleth.sso/Login"
              }, 
              {
                "information_url": [
                  {
                    "lang": "sv", 
                    "text": "https://confluence.its.umu.se/confluence/pages/viewpage.action?pageId=5310677", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }
                ], 
                "display_name": [
                  {
                    "lang": "sv", 
                    "text": "Ladok3 MIT IK", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "sv", 
                    "text": "Ladok3-projektets Migrations-, Integrations- och Testmilj\u00f6 (MIT-milj\u00f6n)", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }
            ]
          }, 
          "key_descriptor": [
            {
              "encryption_method": [
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod", 
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#aes128-cbc"
                }, 
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod", 
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#aes192-cbc"
                }, 
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod", 
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#aes256-cbc"
                }, 
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod", 
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#tripledes-cbc"
                }, 
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod", 
                  "algorithm": "http://www.w3.org/2009/xmlenc11#rsa-oaep"
                }, 
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod", 
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p"
                }
              ], 
              "key_info": {
                "key_name": [
                  {
                    "text": "https://www.mit-ik.ladok.se/gui-sp", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }, 
                  {
                    "text": "www.mit-ik.ladok.se", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=www.mit-ik.ladok.se", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIDJDCCAgygAwIBAgIJANL6yf7/ut6nMA0GCSqGSIb3DQEBBQUAMB4xHDAaBgNV\nBAMTE3d3dy5taXQtaWsubGFkb2suc2UwHhcNMTMxMjA1MTEyMzE2WhcNMjMxMjAz\nMTEyMzE2WjAeMRwwGgYDVQQDExN3d3cubWl0LWlrLmxhZG9rLnNlMIIBIjANBgkq\nhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA8n5D2gQ7nHF/GL8+pjQwVWDCltO4Zxim\n8aN+KsuQexMHhDhQqrOsNY3smAbqKjyA50sZgc+kG2+pm5nJ3BtAFUJxOqHSsBFN\nhkpEmSlhXvN8z6GBW3PJU3X++LAi2PP6Cc5U1uLuROHjdlqhazCDB8iAPxkK4U2J\nSmtqokM+rlFWSqag+cL/rQuySL5JVAH1Ez9WmYd5bZQaC2acUwojuBAE+RUtkH/d\nint0TKVxLRiYitHsqoPnPjkaf2i+xek2793pO/5D0PWDSDKv+2uMoWDGguwGuJga\n76H+nO33kAM3CEaCpks9didq/vCf+OkUW6jIx7zDLYAldRhY9uvZiQIDAQABo2Uw\nYzBCBgNVHREEOzA5ghN3d3cubWl0LWlrLmxhZG9rLnNlhiJodHRwczovL3d3dy5t\naXQtaWsubGFkb2suc2UvZ3VpLXNwMB0GA1UdDgQWBBR66X4ZBaD5XtilseE47n6e\n5rc6lDANBgkqhkiG9w0BAQUFAAOCAQEAka+wRN3C8Kv4SMDSjDhiIejGOZ4KZOXD\nLkUOt8AGlNTl7tzaQyznpuB4ojVemgAbnwAu2foUaERbqpD47XHzuBY7Ktmvd7ZN\nw5jZNJ5xf+W+WZ82dRhEvCtvn0acOC7bJhFAmhYQK5ZRQ3n87bxGB9WIGmUr1HKa\nGw4/2Un4tYKbcbHpsVtrq/5ZOQRSbxcNKv+PZMCWVTvGI8Su7WQO2khvyDM8jfDK\nbuip7GVO7Wnq60m3Ec56C5ZEokbcHqqy0phe/qJLj7gK0d78IN/gMJ0wGPRsUsgJ\nf7yN1uMpnUl12o/qmXNaqs7r1AOJ2CLfd+gRzYL9kS9FsLfKTrrwtg==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://www.mit-ik.ladok.se/Shibboleth.sso/Artifact/SOAP"
            }
          ], 
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://www.mit-ik.ladok.se/Shibboleth.sso/NIM/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://www.mit-ik.ladok.se/Shibboleth.sso/NIM/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://www.mit-ik.ladok.se/Shibboleth.sso/NIM/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://www.mit-ik.ladok.se/Shibboleth.sso/NIM/Artifact"
            }
          ]
        }
      ], 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-2.0/www.mit-ik.ladok.se-gui-sp.xml"
      }
    }
  ], 
  [
    "https://studienportal.vetmed.uni-muenchen.de/shibboleth", 
    {
      "entity_id": "https://studienportal.vetmed.uni-muenchen.de/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/studienportal.vetmed.uni-muenchen.de.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "en", 
                "text": "https://www.aai.dfn.de/en/join/", 
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy"
              }, 
              {
                "lang": "de", 
                "text": "https://www.aai.dfn.de/teilnahme/", 
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy"
              }
            ], 
            "registration_authority": "https://www.aai.dfn.de", 
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo", 
            "registration_instant": "2013-04-30T13:50:47Z"
          }
        ]
      }, 
      "organization": {
        "organization_name": [
          {
            "lang": "de", 
            "text": "e29", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }, 
          {
            "lang": "en", 
            "text": "e29", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "Ludwig-Maximilians-Universit\u00e4t M\u00fcnchen", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }, 
          {
            "lang": "en", 
            "text": "Ludwig-Maximilians-Universit\u00e4t M\u00fcnchen", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "https://lmuidp.lrz.de", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }, 
          {
            "lang": "en", 
            "text": "https://lmuidp.lrz.de", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://studienportal.vetmed.uni-muenchen.de/Shibboleth.sso/SLO/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://studienportal.vetmed.uni-muenchen.de/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://studienportal.vetmed.uni-muenchen.de/Shibboleth.sso/SLO/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://studienportal.vetmed.uni-muenchen.de/Shibboleth.sso/SLO/Artifact"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://studienportal.vetmed.uni-muenchen.de/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://studienportal.vetmed.uni-muenchen.de/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://studienportal.vetmed.uni-muenchen.de/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://studienportal.vetmed.uni-muenchen.de/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://studienportal.vetmed.uni-muenchen.de/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://studienportal.vetmed.uni-muenchen.de/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://studienportal.vetmed.uni-muenchen.de/Shibboleth.sso/Login"
              }, 
              {
                "information_url": [
                  {
                    "lang": "de", 
                    "text": "https://studienportal.vetmed.uni-muenchen.de", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }, 
                  {
                    "lang": "en", 
                    "text": "https://studienportal.vetmed.uni-muenchen.de", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }
                ], 
                "display_name": [
                  {
                    "lang": "de", 
                    "text": "Studienportal tier\u00e4rztliche Fakult\u00e4t LMU", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }, 
                  {
                    "lang": "en", 
                    "text": "Studienportal tier\u00e4rztliche Fakult\u00e4t LMU", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "de", 
                    "text": "Studienportal tier\u00e4rztliche Fakult\u00e4t LMU", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }, 
                  {
                    "lang": "en", 
                    "text": "Studienportal tier\u00e4rztliche Fakult\u00e4t LMU", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "text": "studienportal.vetmed.uni-muenchen.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=studienportal.vetmed.uni-muenchen.de,OU=Tieraerztliche Fakultaet,O=Ludwig-Maximilians-Universitaet Muenchen,L=Muenchen,ST=Bayern,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFrDCCBJSgAwIBAgIEEOYptTANBgkqhkiG9w0BAQUFADCBkDELMAkGA1UEBhMC\nREUxDzANBgNVBAgTBkJheWVybjERMA8GA1UEBxMITXVlbmNoZW4xMTAvBgNVBAoT\nKEx1ZHdpZy1NYXhpbWlsaWFucy1Vbml2ZXJzaXRhZXQgTXVlbmNoZW4xDzANBgNV\nBAMTBkxNVS1DQTEZMBcGCSqGSIb3DQEJARYKcGtpQGxtdS5kZTAeFw0xMDEwMjYx\nMDIzMzNaFw0xNTEwMjUxMDIzMzNaMIG2MQswCQYDVQQGEwJERTEPMA0GA1UECBMG\nQmF5ZXJuMREwDwYDVQQHEwhNdWVuY2hlbjExMC8GA1UEChMoTHVkd2lnLU1heGlt\naWxpYW5zLVVuaXZlcnNpdGFldCBNdWVuY2hlbjEhMB8GA1UECxMYVGllcmFlcnp0\nbGljaGUgRmFrdWx0YWV0MS0wKwYDVQQDEyRzdHVkaWVucG9ydGFsLnZldG1lZC51\nbmktbXVlbmNoZW4uZGUwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCf\naVM4c+oiLWXWdu/PVBS7JHqdNKqk//w0wQoH4o/g6gRK5LiSOy3Dqloz5UpFYjNW\nD7lQEzcg1Ar/0/NsQ3HEU75k7uUaOmZi+kNse8seagyCjlfWnU5DAsPDFG7SiotU\n0AX6dPL+GkzyWKpdG7/HrGze43pFbYkB67KaAuwLHPGZwBzeyIDyL9RPjdRXflhI\no/sxJh5tv/9tLpxNupacnk7mfz1xDlfvSLyWEjr6pL/JtLR7Z3BQ5/PISFncWO+Q\nZfrY7TGZ/E9uS2pnfteOY22Y6rR1FiVgcIowzScVTOwyshvopoVI1/u3d+ChMhBI\nezjRfr1udeSajAk/RqVTAgMBAAGjggHkMIIB4DAJBgNVHRMEAjAAMAsGA1UdDwQE\nAwIF4DAdBgNVHSUEFjAUBggrBgEFBQcDAgYIKwYBBQUHAwEwHQYDVR0OBBYEFGIL\nBlMn4wIAUnAiU7s+tIBt1iu0MB8GA1UdIwQYMBaAFHmHeGov+pu8I0+UpqN3HR4O\nlIAPMDIGA1UdEQQrMCmBJ2FkbWluaXN0cmF0b3JAaXQudmV0bWVkLnVuaS1tdWVu\nY2hlbi5kZTCBiwYDVR0fBIGDMIGAMD6gPKA6hjhodHRwOi8vY2RwMS5wY2EuZGZu\nLmRlL3VuaS1tdWVuY2hlbi1jYS9wdWIvY3JsL2NhY3JsLmNybDA+oDygOoY4aHR0\ncDovL2NkcDIucGNhLmRmbi5kZS91bmktbXVlbmNoZW4tY2EvcHViL2NybC9jYWNy\nbC5jcmwwgaQGCCsGAQUFBwEBBIGXMIGUMEgGCCsGAQUFBzAChjxodHRwOi8vY2Rw\nMS5wY2EuZGZuLmRlL3VuaS1tdWVuY2hlbi1jYS9wdWIvY2FjZXJ0L2NhY2VydC5j\ncnQwSAYIKwYBBQUHMAKGPGh0dHA6Ly9jZHAyLnBjYS5kZm4uZGUvdW5pLW11ZW5j\naGVuLWNhL3B1Yi9jYWNlcnQvY2FjZXJ0LmNydDANBgkqhkiG9w0BAQUFAAOCAQEA\nXoE3xNYk2QmdKevsY4W/szKTswy74uqQ3utXm5Hf5+/9+Cgd7BStYRZVHI24veXq\na0YOorNUumnTkZFUB4B5OZpaDw9t80WSaefC3o1zc0PXH9+caRhoqmnBSG1JdF6L\nkY0pqAOralMzMChLKOrRb2cnjxHWa/Ug9C7XaXmEJhjP+7GCjZSLMS/du1E1wyKc\n3fN+WdEbKF4OiY1lK+MBlgDyGdXqkrAFX8JbGo1uWyGgDKu2gT7QhMeNXDPzpWn8\nYwnP4oYTHPCDNHFJR6XyRTogzebI5RgoL2eLI8SOf0LXXBTE2KvM2cOWFSmKlgFd\nNL76LsPu9j46CldHJOaVdg==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ]
        }
      ], 
      "contact_person": [
        {
          "given_name": {
            "text": "Cyrill", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "mailto:studienportal@it.vetmed.uni-muenchen.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Matenaers", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Studienportal", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "mailto:studienportal@it.vetmed.uni-muenchen.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Helpdesk", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "support"
        }
      ]
    }
  ], 
  [
    "https://db.ub.uni-stuttgart.de", 
    {
      "entity_id": "https://db.ub.uni-stuttgart.de", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/db.ub.uni-stuttgart.de.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "organization": {
        "organization_name": [
          {
            "lang": "de", 
            "text": "Universit\u00e4t Stuttgart", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "Universit\u00e4tsbibliothek Stuttgart", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "http://www.uni-stuttgart.de", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Ralf", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "ralf.engelmann@ub.uni-stuttgart.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Engelmann", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Ralf", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "ralf.engelmann@ub.uni-stuttgart.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Engelmann", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "spsso_descriptor": [
        {
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://db.ub.uni-stuttgart.de/Shibboleth.shire"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://db.ub.uni-stuttgart.de/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://db.ub.uni-stuttgart.de/Shibboleth.sso/SAML2/POST"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "db.ub.uni-stuttgart.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=db.ub.uni-stuttgart.de,OU=Universitaetsbibliothek,O=Universitaet Stuttgart,L=Stuttgart,ST=Baden-Wuerttemberg,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFbDCCBFSgAwIBAgIEDB2VKDANBgkqhkiG9w0BAQUFADCBlDELMAkGA1UEBhMC\nREUxEjAQBgNVBAcTCVN0dXR0Z2FydDEfMB0GA1UEChMWVW5pdmVyc2l0YWV0IFN0\ndXR0Z2FydDEoMCYGA1UEAxMfVW5pdmVyc2l0YWV0IFN0dXR0Z2FydCBDQSAtIEcw\nMTEmMCQGCSqGSIb3DQEJARYXY2EtZzAxQHVuaS1zdHV0dGdhcnQuZGUwHhcNMDgw\nNDEwMTMzNTIxWhcNMTMwNDA5MTMzNTIxWjCBojELMAkGA1UEBhMCREUxGzAZBgNV\nBAgTEkJhZGVuLVd1ZXJ0dGVtYmVyZzESMBAGA1UEBxMJU3R1dHRnYXJ0MR8wHQYD\nVQQKExZVbml2ZXJzaXRhZXQgU3R1dHRnYXJ0MSAwHgYDVQQLExdVbml2ZXJzaXRh\nZXRzYmlibGlvdGhlazEfMB0GA1UEAxMWZGIudWIudW5pLXN0dXR0Z2FydC5kZTCC\nASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAKwE50dOQQkZznyAAfZEINPH\nhaepUOZgEqAAHDjKEbxVg3WLZKg9CPQ8k1+nWxV8ZomJzXbw+kx1v7NPKdNPXBNw\nqmt6aQAiJHcUtzMGlfGI1YDrC/p0zFmjtno+a++sRSVgfBrSQME7JQ8CPVreSa20\n0MDsWR/OOdzVZo47PhzDYyOiABa/CEiU1k51zciw3XpbEnMqKwZ2tNxX++zgvhyg\nn5MhITT88Lukmz92XF0JyEeNJWE0Q0AKcS6V6A+jKQznEXpQ88c2Zit44z3bJM/9\na9RBlMQ+CuPSuf7aznUY3AOysD5jWlvpJfDC2mMg3KTC1RNTuaoYmtBjJW0Nnj0C\nAwEAAaOCAbQwggGwMAkGA1UdEwQCMAAwCwYDVR0PBAQDAgXgMB0GA1UdJQQWMBQG\nCCsGAQUFBwMCBggrBgEFBQcDATAdBgNVHQ4EFgQUtB7lnAegYLLmVzFpTp8/Lymc\nR0UwHwYDVR0jBBgwFoAUva0nWiw3zw1EH3Iaqrc3mREuAgQwgY0GA1UdHwSBhTCB\ngjA/oD2gO4Y5aHR0cDovL2NkcDEucGNhLmRmbi5kZS91bmktc3R1dHRnYXJ0LWNh\nL3B1Yi9jcmwvY2FjcmwuY3JsMD+gPaA7hjlodHRwOi8vY2RwMi5wY2EuZGZuLmRl\nL3VuaS1zdHV0dGdhcnQtY2EvcHViL2NybC9jYWNybC5jcmwwgaYGCCsGAQUFBwEB\nBIGZMIGWMEkGCCsGAQUFBzAChj1odHRwOi8vY2RwMS5wY2EuZGZuLmRlL3VuaS1z\ndHV0dGdhcnQtY2EvcHViL2NhY2VydC9jYWNlcnQuY3J0MEkGCCsGAQUFBzAChj1o\ndHRwOi8vY2RwMi5wY2EuZGZuLmRlL3VuaS1zdHV0dGdhcnQtY2EvcHViL2NhY2Vy\ndC9jYWNlcnQuY3J0MA0GCSqGSIb3DQEBBQUAA4IBAQCjpYUB2mqfLUpU7uke8uvu\n3b6W/lDX8N54gmmdPfvjYF5ASmXdIdH64P6bspBPfqBajj0RfWflgGO85givR98w\neVT2uqYrXKDIVknHs6/2SqolgcEkSSIUZwiGn4aNuV7BVcTB0bon6O+QJNUz/Ju8\nKG81dktd/OYbDq/yABvrWa2yvbroHwJZj9fydBBFvaT2l1KHv6NVauLXAqYyhDF8\nTkkerRdtxkOOv2vskPFo2HwZ0MZ/S9c5BJwKs0hGklHvT8/cnzAm1tO9TD8jG+9+\nc1GXBwlpyqeX1oyjmAwFsCP0IXVzw11n7BtSjylDJKYARAlw+qtCibuS9S+6oYQ2", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "db.ub.uni-stuttgart.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=db.ub.uni-stuttgart.de,OU=Universitaetsbibliothek,O=Universitaet Stuttgart,L=Stuttgart,ST=Baden-Wuerttemberg,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFbDCCBFSgAwIBAgIEDB2VKDANBgkqhkiG9w0BAQUFADCBlDELMAkGA1UEBhMC\nREUxEjAQBgNVBAcTCVN0dXR0Z2FydDEfMB0GA1UEChMWVW5pdmVyc2l0YWV0IFN0\ndXR0Z2FydDEoMCYGA1UEAxMfVW5pdmVyc2l0YWV0IFN0dXR0Z2FydCBDQSAtIEcw\nMTEmMCQGCSqGSIb3DQEJARYXY2EtZzAxQHVuaS1zdHV0dGdhcnQuZGUwHhcNMDgw\nNDEwMTMzNTIxWhcNMTMwNDA5MTMzNTIxWjCBojELMAkGA1UEBhMCREUxGzAZBgNV\nBAgTEkJhZGVuLVd1ZXJ0dGVtYmVyZzESMBAGA1UEBxMJU3R1dHRnYXJ0MR8wHQYD\nVQQKExZVbml2ZXJzaXRhZXQgU3R1dHRnYXJ0MSAwHgYDVQQLExdVbml2ZXJzaXRh\nZXRzYmlibGlvdGhlazEfMB0GA1UEAxMWZGIudWIudW5pLXN0dXR0Z2FydC5kZTCC\nASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAKwE50dOQQkZznyAAfZEINPH\nhaepUOZgEqAAHDjKEbxVg3WLZKg9CPQ8k1+nWxV8ZomJzXbw+kx1v7NPKdNPXBNw\nqmt6aQAiJHcUtzMGlfGI1YDrC/p0zFmjtno+a++sRSVgfBrSQME7JQ8CPVreSa20\n0MDsWR/OOdzVZo47PhzDYyOiABa/CEiU1k51zciw3XpbEnMqKwZ2tNxX++zgvhyg\nn5MhITT88Lukmz92XF0JyEeNJWE0Q0AKcS6V6A+jKQznEXpQ88c2Zit44z3bJM/9\na9RBlMQ+CuPSuf7aznUY3AOysD5jWlvpJfDC2mMg3KTC1RNTuaoYmtBjJW0Nnj0C\nAwEAAaOCAbQwggGwMAkGA1UdEwQCMAAwCwYDVR0PBAQDAgXgMB0GA1UdJQQWMBQG\nCCsGAQUFBwMCBggrBgEFBQcDATAdBgNVHQ4EFgQUtB7lnAegYLLmVzFpTp8/Lymc\nR0UwHwYDVR0jBBgwFoAUva0nWiw3zw1EH3Iaqrc3mREuAgQwgY0GA1UdHwSBhTCB\ngjA/oD2gO4Y5aHR0cDovL2NkcDEucGNhLmRmbi5kZS91bmktc3R1dHRnYXJ0LWNh\nL3B1Yi9jcmwvY2FjcmwuY3JsMD+gPaA7hjlodHRwOi8vY2RwMi5wY2EuZGZuLmRl\nL3VuaS1zdHV0dGdhcnQtY2EvcHViL2NybC9jYWNybC5jcmwwgaYGCCsGAQUFBwEB\nBIGZMIGWMEkGCCsGAQUFBzAChj1odHRwOi8vY2RwMS5wY2EuZGZuLmRlL3VuaS1z\ndHV0dGdhcnQtY2EvcHViL2NhY2VydC9jYWNlcnQuY3J0MEkGCCsGAQUFBzAChj1o\ndHRwOi8vY2RwMi5wY2EuZGZuLmRlL3VuaS1zdHV0dGdhcnQtY2EvcHViL2NhY2Vy\ndC9jYWNlcnQuY3J0MA0GCSqGSIb3DQEBBQUAA4IBAQCjpYUB2mqfLUpU7uke8uvu\n3b6W/lDX8N54gmmdPfvjYF5ASmXdIdH64P6bspBPfqBajj0RfWflgGO85givR98w\neVT2uqYrXKDIVknHs6/2SqolgcEkSSIUZwiGn4aNuV7BVcTB0bon6O+QJNUz/Ju8\nKG81dktd/OYbDq/yABvrWa2yvbroHwJZj9fydBBFvaT2l1KHv6NVauLXAqYyhDF8\nTkkerRdtxkOOv2vskPFo2HwZ0MZ/S9c5BJwKs0hGklHvT8/cnzAm1tO9TD8jG+9+\nc1GXBwlpyqeX1oyjmAwFsCP0IXVzw11n7BtSjylDJKYARAlw+qtCibuS9S+6oYQ2", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://filesender.funet.fi", 
    {
      "entity_id": "https://filesender.funet.fi", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/filesender.funet.fi.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "en", 
                "text": "http://www.csc.fi/english/institutions/haka/instructions/join/eduGAINRegistrationStatement/", 
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy"
              }
            ], 
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo", 
            "registration_authority": "http://www.csc.fi/haka"
          }, 
          {
            "attribute": [
              {
                "attribute_value": [
                  {
                    "text": "http://www.geant.net/uri/dataprotection-code-of-conduct/v1", 
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue", 
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    }
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute", 
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                "name": "http://macedir.org/entity-category"
              }
            ], 
            "__class__": "urn:oasis:names:tc:SAML:metadata:attribute&EntityAttributes"
          }
        ]
      }, 
      "organization": {
        "organization_name": [
          {
            "lang": "fi", 
            "text": "CSC - Tieteen tietotekniikan keskus Oy", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }, 
          {
            "lang": "en", 
            "text": "CSC - IT Center for Science Ltd.", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }, 
          {
            "lang": "sv", 
            "text": "CSC - Tieteen tietotekniikan keskus Oy", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "fi", 
            "text": "CSC - Tieteen tietotekniikan keskus Oy", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }, 
          {
            "lang": "en", 
            "text": "CSC - IT Center for Science Ltd.", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }, 
          {
            "lang": "sv", 
            "text": "CSC - Tieteen tietotekniikan keskus Oy", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "fi", 
            "text": "http://www.csc.fi", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }, 
          {
            "lang": "en", 
            "text": "http://www.csc.fi", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }, 
          {
            "lang": "sv", 
            "text": "http://www.csc.fi", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "is_default": "true", 
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://filesender.funet.fi/simplesaml/module.php/saml/sp/saml2-acs.php/SP"
            }, 
            {
              "is_default": "false", 
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://filesender.funet.fi/simplesaml/module.php/saml/sp/saml2-acs.php/SP"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://filesender.funet.fi/simplesaml/module.php/saml/disco.php"
              }, 
              {
                "privacy_statement_url": [
                  {
                    "lang": "en", 
                    "text": "https://filesender.funet.fi/privacypolicy.html", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&PrivacyStatementURL"
                  }, 
                  {
                    "lang": "fi", 
                    "text": "https://filesender.funet.fi/privacypolicy.html", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&PrivacyStatementURL"
                  }
                ], 
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Funet FileSender", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }, 
                  {
                    "lang": "fi", 
                    "text": "Funet FileSender", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }, 
                  {
                    "lang": "sv", 
                    "text": "Funet FileSender", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "fi", 
                    "text": "Funet FileSender tarjoaa helpon ja turvallisen tavan jakaa suuria tiedostoja.", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }, 
                  {
                    "lang": "sv", 
                    "text": "Funet FileSender erbjuder en l\u00e4tt och s\u00e4ker s\u00e4tt att dela stora datafilar till vem som helst.", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }, 
                  {
                    "lang": "en", 
                    "text": "Funet FileSender offers an easy and a secure way to share large files with anyone.", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }
            ]
          }, 
          "name_id_format": [
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ], 
          "attribute_consuming_service": [
            {
              "index": "1", 
              "service_name": [
                {
                  "lang": "fi", 
                  "text": "Funet FileSender", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }, 
                {
                  "lang": "en", 
                  "text": "Funet FileSender", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }, 
                {
                  "lang": "sv", 
                  "text": "Funet FileSender", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }
              ], 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService", 
              "is_default": "true", 
              "requested_attribute": [
                {
                  "is_required": "true", 
                  "friendly_name": "cn", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.5.4.3"
                }, 
                {
                  "is_required": "true", 
                  "friendly_name": "displayName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.16.840.1.113730.3.1.241"
                }, 
                {
                  "is_required": "true", 
                  "friendly_name": "eduPersonPrincipalName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.6"
                }, 
                {
                  "is_required": "true", 
                  "friendly_name": "mail", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:0.9.2342.19200300.100.1.3"
                }
              ], 
              "service_description": [
                {
                  "lang": "fi", 
                  "text": "Funet FileSender tarjoaa helpon ja turvallisen tavan jakaa suuria tiedostoja.", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription"
                }, 
                {
                  "lang": "en", 
                  "text": "Funet FileSender offers an easy and a secure way to share large files with anyone.", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription"
                }, 
                {
                  "lang": "sv", 
                  "text": "Funet FileSender erbjuder en latt och saker satt att dela stora datafilar till vem som helst.", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription"
                }
              ]
            }
          ], 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIE2TCCA8GgAwIBAgIQX2leAqJlB3Q/3iPF8QljNTANBgkqhkiG9w0BAQUFADA2\nMQswCQYDVQQGEwJOTDEPMA0GA1UEChMGVEVSRU5BMRYwFAYDVQQDEw1URVJFTkEg\nU1NMIENBMB4XDTEyMDYyNjAwMDAwMFoXDTE1MDYyNjIzNTk1OVowgbAxCzAJBgNV\nBAYTAkZJMQ4wDAYDVQQREwUwMjEwMTEQMA4GA1UECBMHdXVzaW1hYTEOMAwGA1UE\nBxMFRXNwb28xFjAUBgNVBAkTDUtlaWxhcmFudGEgMTQxKTAnBgNVBAoTIENTQyAt\nIElUIENlbnRlciBmb3IgU2NpZW5jZSBMdGQuMQ4wDAYDVQQLEwVGVU5FVDEcMBoG\nA1UEAxMTZmlsZXNlbmRlci5mdW5ldC5maTCCASIwDQYJKoZIhvcNAQEBBQADggEP\nADCCAQoCggEBAMZgasarh1nW+r5+zxxElcXiJm7oQVBGDSVwlkZr+7Op8NvdG+Hg\nqC3r64lrmNUgI6LgQ56BH0lDZCdWmH1r4IWmps+VUHEyRb83uDNis+61wnyPW2+k\n0O7JCygTwvltycl4Iw6eaPxERHhgV27r85jMJQbeLMaN+oNZ2HgLEAK8mnksa+IS\nVYULX9ybvh/0YrqfKvhs3bO0fNP9IvUj3HVGCOu5lxHSrZWG5ppmxrVZcRbTYyfz\nPcU5xp0wpvNKju8NQhPlpOhmtvaC8zEDDiRGGG5BTLBc/dMz7gExcjFRh7uUFImx\nkaQBMgbC4Q1PEAfc1HW4dCXH63rTvx7+yNECAwEAAaOCAWYwggFiMB8GA1UdIwQY\nMBaAFAy9k2gM896ro0lrKzdXR+qQ47ntMB0GA1UdDgQWBBS0whoofsD3sLHsJarO\nfwv9F9uGyzAOBgNVHQ8BAf8EBAMCBaAwDAYDVR0TAQH/BAIwADAdBgNVHSUEFjAU\nBggrBgEFBQcDAQYIKwYBBQUHAwIwGAYDVR0gBBEwDzANBgsrBgEEAbIxAQICHTA6\nBgNVHR8EMzAxMC+gLaArhilodHRwOi8vY3JsLnRjcy50ZXJlbmEub3JnL1RFUkVO\nQVNTTENBLmNybDBtBggrBgEFBQcBAQRhMF8wNQYIKwYBBQUHMAKGKWh0dHA6Ly9j\ncnQudGNzLnRlcmVuYS5vcmcvVEVSRU5BU1NMQ0EuY3J0MCYGCCsGAQUFBzABhhpo\ndHRwOi8vb2NzcC50Y3MudGVyZW5hLm9yZzAeBgNVHREEFzAVghNmaWxlc2VuZGVy\nLmZ1bmV0LmZpMA0GCSqGSIb3DQEBBQUAA4IBAQCo97bKpkoqXDVVfg868CNBrSYi\n1bWlUGH732ijBmo3CIDV08G5Q7/0hejeKKTJfw02XNAxHBjatcB9umyuZUKa2Xf/\nFq9C5c4z3aH1DOpUaVDzRr3gKxEloP0iJfp/jR00cs8hNKw0Lzw/dXVIQ+ObT1B7\n4Qm4RJUOIO/yHNqLvs0QRhYCnonyfUN5Hg5RA0hGwBXJzLZpVYG4yNVYEuSS47BA\nNuSoiRuRqUwvjh1crrpK3aEPzrhwALKEQo0tIKOpSHjVUwvGXWtoljY7JJJt94y1\no9pAScnCYOeqNoQ//wrcSVQcwozZLhGlymlLAyDI0rx/hM9v+8PL1E0iFmf/", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ]
        }
      ], 
      "contact_person": [
        {
          "given_name": {
            "text": "Harri", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "mailto:funyht@csc.fi", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Kuusisto", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Tomi", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "mailto:noc@funet.fi", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Salmi", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Tomi", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "mailto:noc@funet.fi", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Salmi", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "support"
        }
      ]
    }
  ], 
  [
    "https://cambro-staging-next.umdc.umu.se/shibboleth", 
    {
      "entity_id": "https://cambro-staging-next.umdc.umu.se/shibboleth", 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://cambro-staging-next.umdc.umu.se/Shibboleth.sso/SLO/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://cambro-staging-next.umdc.umu.se/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://cambro-staging-next.umdc.umu.se/Shibboleth.sso/SLO/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://cambro-staging-next.umdc.umu.se/Shibboleth.sso/SLO/Artifact"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://cambro-staging-next.umdc.umu.se/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://cambro-staging-next.umdc.umu.se/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://cambro-staging-next.umdc.umu.se/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://cambro-staging-next.umdc.umu.se/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://cambro-staging-next.umdc.umu.se/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://cambro-staging-next.umdc.umu.se/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://cambro-staging-next.umdc.umu.se/Shibboleth.sso/DS"
              }
            ]
          }, 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://cambro-staging-next.umdc.umu.se/Shibboleth.sso/Artifact/SOAP"
            }
          ], 
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://cambro-staging-next.umdc.umu.se/Shibboleth.sso/NIM/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://cambro-staging-next.umdc.umu.se/Shibboleth.sso/NIM/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://cambro-staging-next.umdc.umu.se/Shibboleth.sso/NIM/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://cambro-staging-next.umdc.umu.se/Shibboleth.sso/NIM/Artifact"
            }
          ]
        }
      ], 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-2.0/cambro-staging-next.umdc.umu.se-shibboleth.xml"
      }
    }
  ], 
  [
    "https://idp.uqam.ca/idp/shibboleth", 
    {
      "entity_id": "https://idp.uqam.ca/idp/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/idp.uqam.ca.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.uqam.ca/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.uqam.ca/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.uqam.ca/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.uqam.ca/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "uqam.ca", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "UQAM | Universit\u00e9 du Qu\u00e9bec \u00e0 Montr\u00e9al", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }, 
                  {
                    "lang": "fr", 
                    "text": "UQAM | Universit\u00e9 du Qu\u00e9bec \u00e0 Montr\u00e9al", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }, 
                  {
                    "lang": "es", 
                    "text": "UQAM | Universit\u00e9 du Qu\u00e9bec \u00e0 Montr\u00e9al", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }, 
                  {
                    "lang": "pt", 
                    "text": "UQAM | Universit\u00e9 du Qu\u00e9bec \u00e0 Montr\u00e9al", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }, 
                  {
                    "lang": "it", 
                    "text": "UQAM | Universit\u00e9 du Qu\u00e9bec \u00e0 Montr\u00e9al", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "description": [
                  {
                    "lang": "en", 
                    "text": "Students, employees and other UQAM account holders", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }, 
                  {
                    "lang": "fr", 
                    "text": "\u00c3tudiants, employ\u00e9s et autres d\u00e9tenteurs d'identifiants UQAM", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }, 
                  {
                    "lang": "es", 
                    "text": "Los estudiantes, los empleados y otros titulares de identificadores UQAM", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }, 
                  {
                    "lang": "pt", 
                    "text": "Os alunos, funcion\u00e1rios e outros detentores de identifica\u00e7\u00e3o UQAM", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }, 
                  {
                    "lang": "it", 
                    "text": "Gli studenti, i dipendenti e gli altri titolari di identificatori UQAM", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "information_url": [
                  {
                    "lang": "en", 
                    "text": "http://www.uqam.ca/en/about/presentation_en.htm", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }, 
                  {
                    "lang": "fr", 
                    "text": "http://www.uqam.ca", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }, 
                  {
                    "lang": "es", 
                    "text": "http://www.uqam.ca/es/aproposito/presentacion.htm", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }, 
                  {
                    "lang": "pt", 
                    "text": "http://www.uqam.ca/pt/sobrea/apresentacao.htm", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }
                ], 
                "privacy_statement_url": [
                  {
                    "lang": "fr", 
                    "text": "http://www.instances.uqam.ca/ReglementsPolitiquesDocuments/Documents/REGLEMENT_NO_15.pdf", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&PrivacyStatementURL"
                  }
                ], 
                "logo": [
                  {
                    "text": "https://idp.uqam.ca/images/logo_uqam-48x16.png", 
                    "width": "48", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo", 
                    "height": "16"
                  }, 
                  {
                    "text": "https://idp.uqam.ca/images/logo_uqam-182x60.png", 
                    "width": "182", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo", 
                    "height": "60"
                  }, 
                  {
                    "text": "https://idp.uqam.ca/images/logo_uqam-1960x647.png", 
                    "width": "1960", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo", 
                    "height": "647"
                  }
                ]
              }, 
              {
                "ip_hint": [
                  {
                    "text": "132.208.0.0/16", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&IPHint"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DiscoHints", 
                "geolocation_hint": [
                  {
                    "text": "geo:45.512843,-73.560893", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&GeolocationHint"
                  }
                ], 
                "domain_hint": [
                  {
                    "text": "uqam.ca", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DomainHint"
                  }
                ]
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDFzCCAf+gAwIBAgIUWJxXbZuGIlRqAdUeM+MQM60cBjIwDQYJKoZIhvcNAQEF\nBQAwFjEUMBIGA1UEAxMLaWRwLnVxYW0uY2EwHhcNMDkwNjAzMTUxNDI3WhcNMjkw\nNjAzMTUxNDI3WjAWMRQwEgYDVQQDEwtpZHAudXFhbS5jYTCCASIwDQYJKoZIhvcN\nAQEBBQADggEPADCCAQoCggEBALTvLffPT+7KOUB1E4/VfYGDMTj8qyRceKedTLxG\n5y1gVngrl1wi3s3qF7aDV8P0SJmJJTtOplxnNNUCTPFyEtKD8TtUAL00Uk2xqB7c\nzgXjXpa5LB0obAz4tkOrrpD/WAffCfjaxiUY7JngPozOsvjCfCp/Yh77Q7wfa1Zx\nDx65/vQCcgFUaXxcb7vq6ilohDcjQPzMJJvfFjJK2Rg+uNPoEbms15ebQzHfQ4Ci\nUbE+vQ5LxkruxNnOiq0d/C4hizKn5uC7oPxNjpEFe4y5cv5BG78KHkr9sKcWSVwg\n0k9ZtvXS2zGkQPM24f8g9WaF389JJlExaqKms+NPZyNpBqkCAwEAAaNdMFswOgYD\nVR0RBDMwMYILaWRwLnVxYW0uY2GGImh0dHBzOi8vaWRwLnVxYW0uY2EvaWRwL3No\naWJib2xldGgwHQYDVR0OBBYEFDVR7RoTZA/UsE/TttH8CaUzxeQ/MA0GCSqGSIb3\nDQEBBQUAA4IBAQBoEgpeo8w8SCBHmi/ShGkcMB9A2JFCpUfspkNOQQ7GSAsl2ix1\n/nY0120ooY4V7OWaRyRMkxtL9ycKwMMbJBREj6qiZCeDh4fy5KtyWJePI0+piKUG\nNMl4+fKSXD27kO0aClaPkYiSZeSWfoZEFWq+99FJ8A9uyr9lTyjjkXil87LfoYdg\niJPe/MZXHYtLYGJcpD8eaIBshbjWWetxlfus6fDAkmu2cVZGwYiMhT/v0CTzhl3C\nl3HcCJmuresheZwe0OdBG9Qh/VHQeOftbJD/6/HhmHBZMJE33H3x8b5ZurP3oxFO\nfiFLy80FQ90W2jDA5xLADjiDZY7BwQMSmzLn", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://idp.uqam.ca:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://idp.uqam.ca:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "en", 
                "text": "http://www.canarie.ca/templates/services/docs/CAF_join_en.pdf", 
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy"
              }, 
              {
                "lang": "fr", 
                "text": "http://www.canarie.ca/templates/services/docs/CAF_join_fr.pdf", 
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy"
              }
            ], 
            "registration_authority": "http://www.canarie.ca", 
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo", 
            "registration_instant": "2013-07-22T00:00:00Z"
          }
        ]
      }, 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://idp.uqam.ca:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://idp.uqam.ca:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "uqam.ca", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Universit\u00e9 du Qu\u00e9bec \u00e0 Montr\u00e9al", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }, 
                  {
                    "lang": "fr", 
                    "text": "Universit\u00e9 du Qu\u00e9bec \u00e0 Montr\u00e9al", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }, 
                  {
                    "lang": "es", 
                    "text": "Universit\u00e9 du Qu\u00e9bec \u00e0 Montr\u00e9al", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }, 
                  {
                    "lang": "pt", 
                    "text": "Universit\u00e9 du Qu\u00e9bec \u00e0 Montr\u00e9al", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }, 
                  {
                    "lang": "it", 
                    "text": "Universit\u00e9 du Qu\u00e9bec \u00e0 Montr\u00e9al", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDFzCCAf+gAwIBAgIUWJxXbZuGIlRqAdUeM+MQM60cBjIwDQYJKoZIhvcNAQEF\nBQAwFjEUMBIGA1UEAxMLaWRwLnVxYW0uY2EwHhcNMDkwNjAzMTUxNDI3WhcNMjkw\nNjAzMTUxNDI3WjAWMRQwEgYDVQQDEwtpZHAudXFhbS5jYTCCASIwDQYJKoZIhvcN\nAQEBBQADggEPADCCAQoCggEBALTvLffPT+7KOUB1E4/VfYGDMTj8qyRceKedTLxG\n5y1gVngrl1wi3s3qF7aDV8P0SJmJJTtOplxnNNUCTPFyEtKD8TtUAL00Uk2xqB7c\nzgXjXpa5LB0obAz4tkOrrpD/WAffCfjaxiUY7JngPozOsvjCfCp/Yh77Q7wfa1Zx\nDx65/vQCcgFUaXxcb7vq6ilohDcjQPzMJJvfFjJK2Rg+uNPoEbms15ebQzHfQ4Ci\nUbE+vQ5LxkruxNnOiq0d/C4hizKn5uC7oPxNjpEFe4y5cv5BG78KHkr9sKcWSVwg\n0k9ZtvXS2zGkQPM24f8g9WaF389JJlExaqKms+NPZyNpBqkCAwEAAaNdMFswOgYD\nVR0RBDMwMYILaWRwLnVxYW0uY2GGImh0dHBzOi8vaWRwLnVxYW0uY2EvaWRwL3No\naWJib2xldGgwHQYDVR0OBBYEFDVR7RoTZA/UsE/TttH8CaUzxeQ/MA0GCSqGSIb3\nDQEBBQUAA4IBAQBoEgpeo8w8SCBHmi/ShGkcMB9A2JFCpUfspkNOQQ7GSAsl2ix1\n/nY0120ooY4V7OWaRyRMkxtL9ycKwMMbJBREj6qiZCeDh4fy5KtyWJePI0+piKUG\nNMl4+fKSXD27kO0aClaPkYiSZeSWfoZEFWq+99FJ8A9uyr9lTyjjkXil87LfoYdg\niJPe/MZXHYtLYGJcpD8eaIBshbjWWetxlfus6fDAkmu2cVZGwYiMhT/v0CTzhl3C\nl3HcCJmuresheZwe0OdBG9Qh/VHQeOftbJD/6/HhmHBZMJE33H3x8b5ZurP3oxFO\nfiFLy80FQ90W2jDA5xLADjiDZY7BwQMSmzLn", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Universit\u00e9 du Qu\u00e9bec \u00e0 Montr\u00e9al", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }, 
          {
            "lang": "fr", 
            "text": "Universit\u00e9 du Qu\u00e9bec \u00e0 Montr\u00e9al", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }, 
          {
            "lang": "es", 
            "text": "Universit\u00e9 du Qu\u00e9bec \u00e0 Montr\u00e9al", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }, 
          {
            "lang": "pt", 
            "text": "Universit\u00e9 du Qu\u00e9bec \u00e0 Montr\u00e9al", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }, 
          {
            "lang": "it", 
            "text": "Universit\u00e9 du Qu\u00e9bec \u00e0 Montr\u00e9al", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "UQAM | Universit\u00e9 du Qu\u00e9bec \u00e0 Montr\u00e9al", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }, 
          {
            "lang": "fr", 
            "text": "UQAM | Universit\u00e9 du Qu\u00e9bec \u00e0 Montr\u00e9al", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }, 
          {
            "lang": "es", 
            "text": "UQAM | Universit\u00e9 du Qu\u00e9bec \u00e0 Montr\u00e9al", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }, 
          {
            "lang": "pt", 
            "text": "UQAM | Universit\u00e9 du Qu\u00e9bec \u00e0 Montr\u00e9al", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }, 
          {
            "lang": "it", 
            "text": "UQAM | Universit\u00e9 du Qu\u00e9bec \u00e0 Montr\u00e9al", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.uqam.ca/en/about/presentation_en.htm", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }, 
          {
            "lang": "fr", 
            "text": "http://www.uqam.ca", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }, 
          {
            "lang": "es", 
            "text": "http://www.uqam.ca/es/aproposito/presentacion.htm", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }, 
          {
            "lang": "pt", 
            "text": "http://www.uqam.ca/pt/sobrea/apresentacao.htm", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "email_address": [
            {
              "text": "shibboleth@uqam.ca", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://login.slub-dresden.de/idp/shibboleth", 
    {
      "entity_id": "https://login.slub-dresden.de/idp/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/login.slub-dresden.de.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://login.slub-dresden.de/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://login.slub-dresden.de/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://login.slub-dresden.de/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://login.slub-dresden.de/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "slub-dresden.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "text": "login.slub-dresden.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=login.slub-dresden.de,OU=IT,O=Saechsische Landes-\\, Staats- und Universitaetsbibliothek Dresden,L=Dresden,ST=Sachsen,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFejCCBGKgAwIBAgIEER82YjANBgkqhkiG9w0BAQUFADCBhTELMAkGA1UEBhMC\nREUxKDAmBgNVBAoTH1RlY2huaXNjaGUgVW5pdmVyc2l0YWV0IERyZXNkZW4xDDAK\nBgNVBAsTA1pJSDEcMBoGA1UEAxMTVFUgRHJlc2RlbiBDQSAtIEcwMjEgMB4GCSqG\nSIb3DQEJARYRcGtpQHR1LWRyZXNkZW4uZGUwHhcNMTAxMjA4MTY1NjUxWhcNMTUx\nMjA3MTY1NjUxWjCBqTELMAkGA1UEBhMCREUxEDAOBgNVBAgTB1NhY2hzZW4xEDAO\nBgNVBAcTB0RyZXNkZW4xSTBHBgNVBAoTQFNhZWNoc2lzY2hlIExhbmRlcy0sIFN0\nYWF0cy0gdW5kIFVuaXZlcnNpdGFldHNiaWJsaW90aGVrIERyZXNkZW4xCzAJBgNV\nBAsTAklUMR4wHAYDVQQDExVsb2dpbi5zbHViLWRyZXNkZW4uZGUwggEiMA0GCSqG\nSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDWvW+lzOJGBUl2VquB2WwwWdNabWSjkTcH\nfnSq2NT7V6/hhYIA051JeThS5riLRyPxCk6bpQt7vOl+v7+sh4pQnumaTt3uYibo\n4JHrHUko2zaNJ+62/5hZKtpSbYbSxUjwwTHv9ENbBZOdj7lxjiTf/xv/DQYXfuAn\nfjFnzJ46UfPNRiMXjICFwOX9pBX6Pvi+47JlirhChb8D6D0rX+cu6Yle7sYGDnHR\nRbAAx0atENk+fAYonpetFTF0mjOvvKlb99CMkTMi8h8viE2tLD1z+ds6xyCAk34y\nBzUakng0+ZZ3xuEK5LhkDJ9CRXSiqAmc2PpzqIcj07HgthGaXd7HAgMBAAGjggHK\nMIIBxjAJBgNVHRMEAjAAMAsGA1UdDwQEAwIE8DATBgNVHSUEDDAKBggrBgEFBQcD\nATAdBgNVHQ4EFgQUyKpSOjY02z3nvcEr+Pq2R6An10swHwYDVR0jBBgwFoAUxStT\nkxeDyfVGQu1Dat+2gKZH8uAwIgYDVR0RBBswGYEXbmllZGVybEBzbHViLWRyZXNk\nZW4uZGUwgYsGA1UdHwSBgzCBgDA+oDygOoY4aHR0cDovL2NkcDEucGNhLmRmbi5k\nZS90dS1kcmVzZGVuLWNhL3B1Yi9jcmwvZ19jYWNybC5jcmwwPqA8oDqGOGh0dHA6\nLy9jZHAyLnBjYS5kZm4uZGUvdHUtZHJlc2Rlbi1jYS9wdWIvY3JsL2dfY2Fjcmwu\nY3JsMIGkBggrBgEFBQcBAQSBlzCBlDBIBggrBgEFBQcwAoY8aHR0cDovL2NkcDEu\ncGNhLmRmbi5kZS90dS1kcmVzZGVuLWNhL3B1Yi9jYWNlcnQvZ19jYWNlcnQuY3J0\nMEgGCCsGAQUFBzAChjxodHRwOi8vY2RwMi5wY2EuZGZuLmRlL3R1LWRyZXNkZW4t\nY2EvcHViL2NhY2VydC9nX2NhY2VydC5jcnQwDQYJKoZIhvcNAQEFBQADggEBAI+A\n/aJshQD10aJl6Zmc7Kdo6DehIu8ev4v3AhTAnTlHdFDaM4Bn38DMzv2lTniRzxs4\ncsaCLtCArLzhDimZ4Co4t8fD7zAvfxMPK9KLdS+oGkD3jSuCNWeGYJlXieOarwI5\n7YnQZj2aJj/q/h67IN9EhO5TmSE8E91BoZDb/D1HFOnDtNmBWRl2YIDRAPbdYILi\ntlvGffPyCHqGDVPGr4/udHHoPLlX5xJOeUPsTqJWvyJH0dZ1QhotnXsZLB+1Zlgi\nRjBDLVfeKIoVbNUYlEvIqADoSO32kE60Ria8L84XZ/PRUIMyV7+0OjgatpQxMxQj\n+IJTcEjcKl3hPdIic+E=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "key_info": {
                "key_name": [
                  {
                    "text": "login.slub-dresden.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=login.slub-dresden.de,OU=IT,O=Saechsische Landes-\\, Staats- und Universitaetsbibliothek Dresden,L=Dresden,ST=Sachsen,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFejCCBGKgAwIBAgIEER82YjANBgkqhkiG9w0BAQUFADCBhTELMAkGA1UEBhMC\nREUxKDAmBgNVBAoTH1RlY2huaXNjaGUgVW5pdmVyc2l0YWV0IERyZXNkZW4xDDAK\nBgNVBAsTA1pJSDEcMBoGA1UEAxMTVFUgRHJlc2RlbiBDQSAtIEcwMjEgMB4GCSqG\nSIb3DQEJARYRcGtpQHR1LWRyZXNkZW4uZGUwHhcNMTAxMjA4MTY1NjUxWhcNMTUx\nMjA3MTY1NjUxWjCBqTELMAkGA1UEBhMCREUxEDAOBgNVBAgTB1NhY2hzZW4xEDAO\nBgNVBAcTB0RyZXNkZW4xSTBHBgNVBAoTQFNhZWNoc2lzY2hlIExhbmRlcy0sIFN0\nYWF0cy0gdW5kIFVuaXZlcnNpdGFldHNiaWJsaW90aGVrIERyZXNkZW4xCzAJBgNV\nBAsTAklUMR4wHAYDVQQDExVsb2dpbi5zbHViLWRyZXNkZW4uZGUwggEiMA0GCSqG\nSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDWvW+lzOJGBUl2VquB2WwwWdNabWSjkTcH\nfnSq2NT7V6/hhYIA051JeThS5riLRyPxCk6bpQt7vOl+v7+sh4pQnumaTt3uYibo\n4JHrHUko2zaNJ+62/5hZKtpSbYbSxUjwwTHv9ENbBZOdj7lxjiTf/xv/DQYXfuAn\nfjFnzJ46UfPNRiMXjICFwOX9pBX6Pvi+47JlirhChb8D6D0rX+cu6Yle7sYGDnHR\nRbAAx0atENk+fAYonpetFTF0mjOvvKlb99CMkTMi8h8viE2tLD1z+ds6xyCAk34y\nBzUakng0+ZZ3xuEK5LhkDJ9CRXSiqAmc2PpzqIcj07HgthGaXd7HAgMBAAGjggHK\nMIIBxjAJBgNVHRMEAjAAMAsGA1UdDwQEAwIE8DATBgNVHSUEDDAKBggrBgEFBQcD\nATAdBgNVHQ4EFgQUyKpSOjY02z3nvcEr+Pq2R6An10swHwYDVR0jBBgwFoAUxStT\nkxeDyfVGQu1Dat+2gKZH8uAwIgYDVR0RBBswGYEXbmllZGVybEBzbHViLWRyZXNk\nZW4uZGUwgYsGA1UdHwSBgzCBgDA+oDygOoY4aHR0cDovL2NkcDEucGNhLmRmbi5k\nZS90dS1kcmVzZGVuLWNhL3B1Yi9jcmwvZ19jYWNybC5jcmwwPqA8oDqGOGh0dHA6\nLy9jZHAyLnBjYS5kZm4uZGUvdHUtZHJlc2Rlbi1jYS9wdWIvY3JsL2dfY2Fjcmwu\nY3JsMIGkBggrBgEFBQcBAQSBlzCBlDBIBggrBgEFBQcwAoY8aHR0cDovL2NkcDEu\ncGNhLmRmbi5kZS90dS1kcmVzZGVuLWNhL3B1Yi9jYWNlcnQvZ19jYWNlcnQuY3J0\nMEgGCCsGAQUFBzAChjxodHRwOi8vY2RwMi5wY2EuZGZuLmRlL3R1LWRyZXNkZW4t\nY2EvcHViL2NhY2VydC9nX2NhY2VydC5jcnQwDQYJKoZIhvcNAQEFBQADggEBAI+A\n/aJshQD10aJl6Zmc7Kdo6DehIu8ev4v3AhTAnTlHdFDaM4Bn38DMzv2lTniRzxs4\ncsaCLtCArLzhDimZ4Co4t8fD7zAvfxMPK9KLdS+oGkD3jSuCNWeGYJlXieOarwI5\n7YnQZj2aJj/q/h67IN9EhO5TmSE8E91BoZDb/D1HFOnDtNmBWRl2YIDRAPbdYILi\ntlvGffPyCHqGDVPGr4/udHHoPLlX5xJOeUPsTqJWvyJH0dZ1QhotnXsZLB+1Zlgi\nRjBDLVfeKIoVbNUYlEvIqADoSO32kE60Ria8L84XZ/PRUIMyV7+0OjgatpQxMxQj\n+IJTcEjcKl3hPdIic+E=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://login.slub-dresden.de:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://login.slub-dresden.de:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://login.slub-dresden.de:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://login.slub-dresden.de:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "slub-dresden.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "login.slub-dresden.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=login.slub-dresden.de,OU=IT,O=Saechsische Landes-\\, Staats- und Universitaetsbibliothek Dresden,L=Dresden,ST=Sachsen,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFejCCBGKgAwIBAgIEER82YjANBgkqhkiG9w0BAQUFADCBhTELMAkGA1UEBhMC\nREUxKDAmBgNVBAoTH1RlY2huaXNjaGUgVW5pdmVyc2l0YWV0IERyZXNkZW4xDDAK\nBgNVBAsTA1pJSDEcMBoGA1UEAxMTVFUgRHJlc2RlbiBDQSAtIEcwMjEgMB4GCSqG\nSIb3DQEJARYRcGtpQHR1LWRyZXNkZW4uZGUwHhcNMTAxMjA4MTY1NjUxWhcNMTUx\nMjA3MTY1NjUxWjCBqTELMAkGA1UEBhMCREUxEDAOBgNVBAgTB1NhY2hzZW4xEDAO\nBgNVBAcTB0RyZXNkZW4xSTBHBgNVBAoTQFNhZWNoc2lzY2hlIExhbmRlcy0sIFN0\nYWF0cy0gdW5kIFVuaXZlcnNpdGFldHNiaWJsaW90aGVrIERyZXNkZW4xCzAJBgNV\nBAsTAklUMR4wHAYDVQQDExVsb2dpbi5zbHViLWRyZXNkZW4uZGUwggEiMA0GCSqG\nSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDWvW+lzOJGBUl2VquB2WwwWdNabWSjkTcH\nfnSq2NT7V6/hhYIA051JeThS5riLRyPxCk6bpQt7vOl+v7+sh4pQnumaTt3uYibo\n4JHrHUko2zaNJ+62/5hZKtpSbYbSxUjwwTHv9ENbBZOdj7lxjiTf/xv/DQYXfuAn\nfjFnzJ46UfPNRiMXjICFwOX9pBX6Pvi+47JlirhChb8D6D0rX+cu6Yle7sYGDnHR\nRbAAx0atENk+fAYonpetFTF0mjOvvKlb99CMkTMi8h8viE2tLD1z+ds6xyCAk34y\nBzUakng0+ZZ3xuEK5LhkDJ9CRXSiqAmc2PpzqIcj07HgthGaXd7HAgMBAAGjggHK\nMIIBxjAJBgNVHRMEAjAAMAsGA1UdDwQEAwIE8DATBgNVHSUEDDAKBggrBgEFBQcD\nATAdBgNVHQ4EFgQUyKpSOjY02z3nvcEr+Pq2R6An10swHwYDVR0jBBgwFoAUxStT\nkxeDyfVGQu1Dat+2gKZH8uAwIgYDVR0RBBswGYEXbmllZGVybEBzbHViLWRyZXNk\nZW4uZGUwgYsGA1UdHwSBgzCBgDA+oDygOoY4aHR0cDovL2NkcDEucGNhLmRmbi5k\nZS90dS1kcmVzZGVuLWNhL3B1Yi9jcmwvZ19jYWNybC5jcmwwPqA8oDqGOGh0dHA6\nLy9jZHAyLnBjYS5kZm4uZGUvdHUtZHJlc2Rlbi1jYS9wdWIvY3JsL2dfY2Fjcmwu\nY3JsMIGkBggrBgEFBQcBAQSBlzCBlDBIBggrBgEFBQcwAoY8aHR0cDovL2NkcDEu\ncGNhLmRmbi5kZS90dS1kcmVzZGVuLWNhL3B1Yi9jYWNlcnQvZ19jYWNlcnQuY3J0\nMEgGCCsGAQUFBzAChjxodHRwOi8vY2RwMi5wY2EuZGZuLmRlL3R1LWRyZXNkZW4t\nY2EvcHViL2NhY2VydC9nX2NhY2VydC5jcnQwDQYJKoZIhvcNAQEFBQADggEBAI+A\n/aJshQD10aJl6Zmc7Kdo6DehIu8ev4v3AhTAnTlHdFDaM4Bn38DMzv2lTniRzxs4\ncsaCLtCArLzhDimZ4Co4t8fD7zAvfxMPK9KLdS+oGkD3jSuCNWeGYJlXieOarwI5\n7YnQZj2aJj/q/h67IN9EhO5TmSE8E91BoZDb/D1HFOnDtNmBWRl2YIDRAPbdYILi\ntlvGffPyCHqGDVPGr4/udHHoPLlX5xJOeUPsTqJWvyJH0dZ1QhotnXsZLB+1Zlgi\nRjBDLVfeKIoVbNUYlEvIqADoSO32kE60Ria8L84XZ/PRUIMyV7+0OjgatpQxMxQj\n+IJTcEjcKl3hPdIic+E=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "login.slub-dresden.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=login.slub-dresden.de,OU=IT,O=Saechsische Landes-\\, Staats- und Universitaetsbibliothek Dresden,L=Dresden,ST=Sachsen,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFejCCBGKgAwIBAgIEER82YjANBgkqhkiG9w0BAQUFADCBhTELMAkGA1UEBhMC\nREUxKDAmBgNVBAoTH1RlY2huaXNjaGUgVW5pdmVyc2l0YWV0IERyZXNkZW4xDDAK\nBgNVBAsTA1pJSDEcMBoGA1UEAxMTVFUgRHJlc2RlbiBDQSAtIEcwMjEgMB4GCSqG\nSIb3DQEJARYRcGtpQHR1LWRyZXNkZW4uZGUwHhcNMTAxMjA4MTY1NjUxWhcNMTUx\nMjA3MTY1NjUxWjCBqTELMAkGA1UEBhMCREUxEDAOBgNVBAgTB1NhY2hzZW4xEDAO\nBgNVBAcTB0RyZXNkZW4xSTBHBgNVBAoTQFNhZWNoc2lzY2hlIExhbmRlcy0sIFN0\nYWF0cy0gdW5kIFVuaXZlcnNpdGFldHNiaWJsaW90aGVrIERyZXNkZW4xCzAJBgNV\nBAsTAklUMR4wHAYDVQQDExVsb2dpbi5zbHViLWRyZXNkZW4uZGUwggEiMA0GCSqG\nSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDWvW+lzOJGBUl2VquB2WwwWdNabWSjkTcH\nfnSq2NT7V6/hhYIA051JeThS5riLRyPxCk6bpQt7vOl+v7+sh4pQnumaTt3uYibo\n4JHrHUko2zaNJ+62/5hZKtpSbYbSxUjwwTHv9ENbBZOdj7lxjiTf/xv/DQYXfuAn\nfjFnzJ46UfPNRiMXjICFwOX9pBX6Pvi+47JlirhChb8D6D0rX+cu6Yle7sYGDnHR\nRbAAx0atENk+fAYonpetFTF0mjOvvKlb99CMkTMi8h8viE2tLD1z+ds6xyCAk34y\nBzUakng0+ZZ3xuEK5LhkDJ9CRXSiqAmc2PpzqIcj07HgthGaXd7HAgMBAAGjggHK\nMIIBxjAJBgNVHRMEAjAAMAsGA1UdDwQEAwIE8DATBgNVHSUEDDAKBggrBgEFBQcD\nATAdBgNVHQ4EFgQUyKpSOjY02z3nvcEr+Pq2R6An10swHwYDVR0jBBgwFoAUxStT\nkxeDyfVGQu1Dat+2gKZH8uAwIgYDVR0RBBswGYEXbmllZGVybEBzbHViLWRyZXNk\nZW4uZGUwgYsGA1UdHwSBgzCBgDA+oDygOoY4aHR0cDovL2NkcDEucGNhLmRmbi5k\nZS90dS1kcmVzZGVuLWNhL3B1Yi9jcmwvZ19jYWNybC5jcmwwPqA8oDqGOGh0dHA6\nLy9jZHAyLnBjYS5kZm4uZGUvdHUtZHJlc2Rlbi1jYS9wdWIvY3JsL2dfY2Fjcmwu\nY3JsMIGkBggrBgEFBQcBAQSBlzCBlDBIBggrBgEFBQcwAoY8aHR0cDovL2NkcDEu\ncGNhLmRmbi5kZS90dS1kcmVzZGVuLWNhL3B1Yi9jYWNlcnQvZ19jYWNlcnQuY3J0\nMEgGCCsGAQUFBzAChjxodHRwOi8vY2RwMi5wY2EuZGZuLmRlL3R1LWRyZXNkZW4t\nY2EvcHViL2NhY2VydC9nX2NhY2VydC5jcnQwDQYJKoZIhvcNAQEFBQADggEBAI+A\n/aJshQD10aJl6Zmc7Kdo6DehIu8ev4v3AhTAnTlHdFDaM4Bn38DMzv2lTniRzxs4\ncsaCLtCArLzhDimZ4Co4t8fD7zAvfxMPK9KLdS+oGkD3jSuCNWeGYJlXieOarwI5\n7YnQZj2aJj/q/h67IN9EhO5TmSE8E91BoZDb/D1HFOnDtNmBWRl2YIDRAPbdYILi\ntlvGffPyCHqGDVPGr4/udHHoPLlX5xJOeUPsTqJWvyJH0dZ1QhotnXsZLB+1Zlgi\nRjBDLVfeKIoVbNUYlEvIqADoSO32kE60Ria8L84XZ/PRUIMyV7+0OjgatpQxMxQj\n+IJTcEjcKl3hPdIic+E=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "de", 
            "text": "SLUB Dresden", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "SLUB Dresden", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "http://www.slub-dresden.de/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Falk", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "niederl@slub-dresden.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Niederlein", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://www.thieme-connect.de/ejournals/shib-login", 
    {
      "entity_id": "https://www.thieme-connect.de/ejournals/shib-login", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/www.thieme-connect.de.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "organization": {
        "organization_name": [
          {
            "lang": "de", 
            "text": "Georg Thieme Verlag KG", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "https://www.thieme-connect.de/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "https://www.thieme-connect.de/ejournals/home.html", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Manfred", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "thiemedev@fiz-karlsruhe.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Deutsch", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Ute", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "ute.guenther@thieme.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "G\u00fcnther", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }
      ], 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://www.thieme-connect.de/Shibboleth.sso/SLO/Artifact"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://www.thieme-connect.de/Shibboleth.sso/SLO/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://www.thieme-connect.de/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://www.thieme-connect.de/Shibboleth.sso/SLO/SOAP"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.thieme-connect.de/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.thieme-connect.de/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.thieme-connect.de/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.thieme-connect.de/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.thieme-connect.de/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.thieme-connect.de/Shibboleth.sso/SAML/Artifact"
            }, 
            {
              "index": "7", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.thieme-connect.com/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "8", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.thieme-connect.com/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "9", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.thieme-connect.com/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "10", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.thieme-connect.com/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "11", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.thieme-connect.com/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "12", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.thieme-connect.com/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://www.thieme-connect.de/Shibboleth.sso/Login"
              }, 
              {
                "index": "2", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://www.thieme-connect.com/Shibboleth.sso/Login"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "www.thieme-connect.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=www.thieme-connect.de,OU=Terms of use at www.verisign.com/rpa (c)05,OU=EDV,O=Georg Thieme Verlag KG,L=Stuttgart,ST=Baden-Wuerttemberg,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFOzCCBCOgAwIBAgIQaPkkRHSsYs5cFgJ+NXut4zANBgkqhkiG9w0BAQUFADCB\nvDELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMR8wHQYDVQQL\nExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMTswOQYDVQQLEzJUZXJtcyBvZiB1c2Ug\nYXQgaHR0cHM6Ly93d3cudmVyaXNpZ24uY29tL3JwYSAoYykxMDE2MDQGA1UEAxMt\nVmVyaVNpZ24gQ2xhc3MgMyBJbnRlcm5hdGlvbmFsIFNlcnZlciBDQSAtIEczMB4X\nDTExMDUyNDAwMDAwMFoXDTEzMDYyNDIzNTk1OVowgcIxCzAJBgNVBAYTAkRFMRsw\nGQYDVQQIExJCYWRlbi1XdWVydHRlbWJlcmcxEjAQBgNVBAcUCVN0dXR0Z2FydDEf\nMB0GA1UEChQWR2VvcmcgVGhpZW1lIFZlcmxhZyBLRzEMMAoGA1UECxQDRURWMTMw\nMQYDVQQLFCpUZXJtcyBvZiB1c2UgYXQgd3d3LnZlcmlzaWduLmNvbS9ycGEgKGMp\nMDUxHjAcBgNVBAMUFXd3dy50aGllbWUtY29ubmVjdC5kZTCBnzANBgkqhkiG9w0B\nAQEFAAOBjQAwgYkCgYEAy7N3v5982eULiKneK7c/7GQEF7mSUwS4WT6IGQUFacPR\ny+UaIWYpkD2fo3JOzD9EvJYY31Jr2D7woUxUEGhOZPIihkXV3wmnFYH1MZOuAFGu\nvv9xRNtuZy0xQL9XBfMhXl8tZzlSk6Q+c5O29zn7KsnAHqMuLCLWe1sGvmRFvjkC\nAwEAAaOCAbMwggGvMAkGA1UdEwQCMAAwCwYDVR0PBAQDAgWgMEQGA1UdIAQ9MDsw\nOQYLYIZIAYb4RQEHFwMwKjAoBggrBgEFBQcCARYcaHR0cHM6Ly93d3cudmVyaXNp\nZ24uY29tL3JwYTBBBgNVHR8EOjA4MDagNKAyhjBodHRwOi8vU1ZSSW50bC1HMy1j\ncmwudmVyaXNpZ24uY29tL1NWUkludGxHMy5jcmwwKAYDVR0lBCEwHwYIKwYBBQUH\nAwEGCCsGAQUFBwMCBglghkgBhvhCBAEwcgYIKwYBBQUHAQEEZjBkMCQGCCsGAQUF\nBzABhhhodHRwOi8vb2NzcC52ZXJpc2lnbi5jb20wPAYIKwYBBQUHMAKGMGh0dHA6\nLy9TVlJJbnRsLUczLWFpYS52ZXJpc2lnbi5jb20vU1ZSSW50bEczLmNlcjBuBggr\nBgEFBQcBDARiMGChXqBcMFowWDBWFglpbWFnZS9naWYwITAfMAcGBSsOAwIaBBRL\na7kolgYMu9BSOJsprEsHiyEFGDAmFiRodHRwOi8vbG9nby52ZXJpc2lnbi5jb20v\ndnNsb2dvMS5naWYwDQYJKoZIhvcNAQEFBQADggEBAFfyCoUP94l9AvTkRjl/ZFm9\nzp/r8MojOzcYHeYJ6ICJ92utCJSJSoErI2BH4Ril61esPJW6OtVEqRpbnv3DHHx6\nyFzZuLXEd+AMz0uBiGBrDs9pA0PVsY3jwaKgDrfJ/QvD5tz/Pl3NS1NR4NVPmbwr\nXyFtLfp8jQpAwbiY1oI8JOKidxvJrQ9HU55PI4rPfC4jOn1lvHsls2KOzButAcXh\nZMeJk4CGI8D/IajWeE5LKbEWWIvneaICam2oTmU3L1OWMSD7kfht9KYTTA/FEcD+\nnwgsd3yT09XaawJMzO16JyyCoE/Mg/CXs70KAkju/noY71pLGmyJ44r/QTnAtCw=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "www.thieme-connect.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=www.thieme-connect.de,OU=Terms of use at www.verisign.com/rpa (c)05,OU=EDV,O=Georg Thieme Verlag KG,L=Stuttgart,ST=Baden-Wuerttemberg,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFOzCCBCOgAwIBAgIQaPkkRHSsYs5cFgJ+NXut4zANBgkqhkiG9w0BAQUFADCB\nvDELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMR8wHQYDVQQL\nExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMTswOQYDVQQLEzJUZXJtcyBvZiB1c2Ug\nYXQgaHR0cHM6Ly93d3cudmVyaXNpZ24uY29tL3JwYSAoYykxMDE2MDQGA1UEAxMt\nVmVyaVNpZ24gQ2xhc3MgMyBJbnRlcm5hdGlvbmFsIFNlcnZlciBDQSAtIEczMB4X\nDTExMDUyNDAwMDAwMFoXDTEzMDYyNDIzNTk1OVowgcIxCzAJBgNVBAYTAkRFMRsw\nGQYDVQQIExJCYWRlbi1XdWVydHRlbWJlcmcxEjAQBgNVBAcUCVN0dXR0Z2FydDEf\nMB0GA1UEChQWR2VvcmcgVGhpZW1lIFZlcmxhZyBLRzEMMAoGA1UECxQDRURWMTMw\nMQYDVQQLFCpUZXJtcyBvZiB1c2UgYXQgd3d3LnZlcmlzaWduLmNvbS9ycGEgKGMp\nMDUxHjAcBgNVBAMUFXd3dy50aGllbWUtY29ubmVjdC5kZTCBnzANBgkqhkiG9w0B\nAQEFAAOBjQAwgYkCgYEAy7N3v5982eULiKneK7c/7GQEF7mSUwS4WT6IGQUFacPR\ny+UaIWYpkD2fo3JOzD9EvJYY31Jr2D7woUxUEGhOZPIihkXV3wmnFYH1MZOuAFGu\nvv9xRNtuZy0xQL9XBfMhXl8tZzlSk6Q+c5O29zn7KsnAHqMuLCLWe1sGvmRFvjkC\nAwEAAaOCAbMwggGvMAkGA1UdEwQCMAAwCwYDVR0PBAQDAgWgMEQGA1UdIAQ9MDsw\nOQYLYIZIAYb4RQEHFwMwKjAoBggrBgEFBQcCARYcaHR0cHM6Ly93d3cudmVyaXNp\nZ24uY29tL3JwYTBBBgNVHR8EOjA4MDagNKAyhjBodHRwOi8vU1ZSSW50bC1HMy1j\ncmwudmVyaXNpZ24uY29tL1NWUkludGxHMy5jcmwwKAYDVR0lBCEwHwYIKwYBBQUH\nAwEGCCsGAQUFBwMCBglghkgBhvhCBAEwcgYIKwYBBQUHAQEEZjBkMCQGCCsGAQUF\nBzABhhhodHRwOi8vb2NzcC52ZXJpc2lnbi5jb20wPAYIKwYBBQUHMAKGMGh0dHA6\nLy9TVlJJbnRsLUczLWFpYS52ZXJpc2lnbi5jb20vU1ZSSW50bEczLmNlcjBuBggr\nBgEFBQcBDARiMGChXqBcMFowWDBWFglpbWFnZS9naWYwITAfMAcGBSsOAwIaBBRL\na7kolgYMu9BSOJsprEsHiyEFGDAmFiRodHRwOi8vbG9nby52ZXJpc2lnbi5jb20v\ndnNsb2dvMS5naWYwDQYJKoZIhvcNAQEFBQADggEBAFfyCoUP94l9AvTkRjl/ZFm9\nzp/r8MojOzcYHeYJ6ICJ92utCJSJSoErI2BH4Ril61esPJW6OtVEqRpbnv3DHHx6\nyFzZuLXEd+AMz0uBiGBrDs9pA0PVsY3jwaKgDrfJ/QvD5tz/Pl3NS1NR4NVPmbwr\nXyFtLfp8jQpAwbiY1oI8JOKidxvJrQ9HU55PI4rPfC4jOn1lvHsls2KOzButAcXh\nZMeJk4CGI8D/IajWeE5LKbEWWIvneaICam2oTmU3L1OWMSD7kfht9KYTTA/FEcD+\nnwgsd3yT09XaawJMzO16JyyCoE/Mg/CXs70KAkju/noY71pLGmyJ44r/QTnAtCw=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://www.thieme-connect.de/Shibboleth.sso/NIM/Artifact"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://www.thieme-connect.de/Shibboleth.sso/NIM/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://www.thieme-connect.de/Shibboleth.sso/NIM/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://www.thieme-connect.de/Shibboleth.sso/NIM/SOAP"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://sso.utu.fi/sso-idp", 
    {
      "entity_id": "https://sso.utu.fi/sso-idp", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/sso.utu.fi.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://sso.utu.fi:443/sso/SSORedirect/metaAlias/utu/sso-idp"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "utu.fi", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "display_name": [
                  {
                    "lang": "fi", 
                    "text": "Turun yliopisto", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }, 
                  {
                    "lang": "en", 
                    "text": "University of Turku", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }, 
                  {
                    "lang": "sv", 
                    "text": "\u00c5bo universitet", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIHATCCBemgAwIBAgIQA4hFUiEZYqQbSVWEoSGbCjANBgkqhkiG9w0BAQUFADBp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\n8MIAfW66Oc6zKMOf26tiwK0/jhtn", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "en", 
                "text": "http://www.csc.fi/english/institutions/haka/instructions/join/eduGAINRegistrationStatement/", 
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy"
              }
            ], 
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo", 
            "registration_authority": "http://www.csc.fi/haka"
          }
        ]
      }, 
      "organization": {
        "organization_name": [
          {
            "lang": "fi", 
            "text": "Turun yliopisto", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }, 
          {
            "lang": "en", 
            "text": "University of Turku", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }, 
          {
            "lang": "sv", 
            "text": "Abo universitet", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "fi", 
            "text": "Turun yliopisto", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }, 
          {
            "lang": "en", 
            "text": "University of Turku", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }, 
          {
            "lang": "sv", 
            "text": "Abo universitet", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "fi", 
            "text": "http://www.utu.fi/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }, 
          {
            "lang": "en", 
            "text": "http://www.utu.fi/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }, 
          {
            "lang": "sv", 
            "text": "http://www.utu.fi/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Petri", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "mailto:hakajasen@utu.fi", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Teraspuro", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Elina", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "mailto:hakajasen@utu.fi", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Toivanen", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "support"
        }
      ]
    }
  ], 
  [
    "https://akino.hh.se/shibboleth", 
    {
      "entity_id": "https://akino.hh.se/shibboleth", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://akino.hh.se/Shibboleth.sso/SLO/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://akino.hh.se/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://akino.hh.se/Shibboleth.sso/SLO/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://akino.hh.se/Shibboleth.sso/SLO/Artifact"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://akino.hh.se/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://akino.hh.se/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://akino.hh.se/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://akino.hh.se/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://akino.hh.se/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://akino.hh.se/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "akino.hh.se", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=akino.hh.se", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIC6DCCAdCgAwIBAgIJANFCVxC7y6BWMA0GCSqGSIb3DQEBBQUAMBYxFDASBgNV\nBAMTC2FraW5vLmhoLnNlMB4XDTA5MTAyNzA4MjU1N1oXDTE5MTAyNTA4MjU1N1ow\nFjEUMBIGA1UEAxMLYWtpbm8uaGguc2UwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw\nggEKAoIBAQD2Y7TZAeEnPMmlwz3hoXDa/wFIRy6Bodm63LdzbL1cy8PQwgtZM5n7\n8CqSy0tE5dpGeGK3oqEJkalbQa9mY/+HGf4ENC7CzlRnJ/xYpLSBiAHCz0ch9+Tc\nZqbbB7IDEhWEiwj25dZ3OG6wqveHtZGQueju34RwF9slrjAPHkXrHC0zSHLVB+hr\nupH8FHTCEJhTY80mZy1DVBEVU6s0DFDjhTX7zYeytM51tKh5iSqJ/dI4jp7GAWx5\n0pDslYxX29aGUbBaKUL83L4RpLW4hecbPiWYeG4tw5Z3pEhifCo0YEffwFJjTGsh\nTP3XAeiOVEInvmH1jK+LgUpzz7rnyy7pAgMBAAGjOTA3MBYGA1UdEQQPMA2CC2Fr\naW5vLmhoLnNlMB0GA1UdDgQWBBQavhHSFdU5J1TVygW7QNzSuG4QTDANBgkqhkiG\n9w0BAQUFAAOCAQEAlxMSNZxBeI4qFUaUBdH0S8FSheF5ynIutcj5bXfmst4rBxRa\nCZIB+NLzwGIp2rwNM53uB3P1osDr+BilLeFUvgSiGwMYFdAHkr9Bg2WqJj9/phW3\nscmeVlwizwXyQscs8fYr9UQGGjrt+tYIJ8NbZCp7bLyjZdwjC2MGe2bDQzA/S2ye\nJfTpxJCZp5ocIfNyPCGmpf6pLBYjQbVfqO4bNJOvaArHylA8wYb5nYO1HFoqKOB/\n7ayOBgrV5oO97iUTRmBU9Ka8GIqJqdC4LIUwj6HcmCJ94rQbldH5/nbitL9ND2oY\ns2ozMUSsHZxcwpFZ7NQ4lLsgm9VihBDXZ4mTXQ==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "akino.hh.se", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=akino.hh.se", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIC6DCCAdCgAwIBAgIJANFCVxC7y6BWMA0GCSqGSIb3DQEBBQUAMBYxFDASBgNV\nBAMTC2FraW5vLmhoLnNlMB4XDTA5MTAyNzA4MjU1N1oXDTE5MTAyNTA4MjU1N1ow\nFjEUMBIGA1UEAxMLYWtpbm8uaGguc2UwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw\nggEKAoIBAQD2Y7TZAeEnPMmlwz3hoXDa/wFIRy6Bodm63LdzbL1cy8PQwgtZM5n7\n8CqSy0tE5dpGeGK3oqEJkalbQa9mY/+HGf4ENC7CzlRnJ/xYpLSBiAHCz0ch9+Tc\nZqbbB7IDEhWEiwj25dZ3OG6wqveHtZGQueju34RwF9slrjAPHkXrHC0zSHLVB+hr\nupH8FHTCEJhTY80mZy1DVBEVU6s0DFDjhTX7zYeytM51tKh5iSqJ/dI4jp7GAWx5\n0pDslYxX29aGUbBaKUL83L4RpLW4hecbPiWYeG4tw5Z3pEhifCo0YEffwFJjTGsh\nTP3XAeiOVEInvmH1jK+LgUpzz7rnyy7pAgMBAAGjOTA3MBYGA1UdEQQPMA2CC2Fr\naW5vLmhoLnNlMB0GA1UdDgQWBBQavhHSFdU5J1TVygW7QNzSuG4QTDANBgkqhkiG\n9w0BAQUFAAOCAQEAlxMSNZxBeI4qFUaUBdH0S8FSheF5ynIutcj5bXfmst4rBxRa\nCZIB+NLzwGIp2rwNM53uB3P1osDr+BilLeFUvgSiGwMYFdAHkr9Bg2WqJj9/phW3\nscmeVlwizwXyQscs8fYr9UQGGjrt+tYIJ8NbZCp7bLyjZdwjC2MGe2bDQzA/S2ye\nJfTpxJCZp5ocIfNyPCGmpf6pLBYjQbVfqO4bNJOvaArHylA8wYb5nYO1HFoqKOB/\n7ayOBgrV5oO97iUTRmBU9Ka8GIqJqdC4LIUwj6HcmCJ94rQbldH5/nbitL9ND2oY\ns2ozMUSsHZxcwpFZ7NQ4lLsgm9VihBDXZ4mTXQ==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://akino.hh.se/Shibboleth.sso/Artifact/SOAP"
            }
          ], 
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://akino.hh.se/Shibboleth.sso/NIM/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://akino.hh.se/Shibboleth.sso/NIM/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://akino.hh.se/Shibboleth.sso/NIM/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://akino.hh.se/Shibboleth.sso/NIM/Artifact"
            }
          ]
        }
      ], 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-2.0/akino.hh.se-shibboleth.xml"
      }
    }
  ], 
  [
    "https://shibboleth.uni-bonn.de/idp/shibboleth", 
    {
      "entity_id": "https://shibboleth.uni-bonn.de/idp/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/shibboleth.uni-bonn.de.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibboleth.uni-bonn.de/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibboleth.uni-bonn.de/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibboleth.uni-bonn.de/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibboleth.uni-bonn.de/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "uni-bonn.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "text": "shibboleth.uni-bonn.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=shibboleth.uni-bonn.de,OU=Hochschulrechenzentrum,O=Universitaet Bonn,L=Bonn,ST=Nordrhein-Westfalen,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIGQTCCBSmgAwIBAgIHEunRqyAN0TANBgkqhkiG9w0BAQUFADCBujELMAkGA1UE\nBhMCREUxHDAaBgNVBAgTE05vcmRyaGVpbi1XZXN0ZmFsZW4xDTALBgNVBAcTBEJv\nbm4xGjAYBgNVBAoTEVVuaXZlcnNpdGFldCBCb25uMR8wHQYDVQQLExZIb2Noc2No\ndWxyZWNoZW56ZW50cnVtMR0wGwYDVQQDExRVbml2ZXJzaXRhZXQgQm9ubiBDQTEi\nMCAGCSqGSIb3DQEJARYTY2FhZG1pbkB1bmktYm9ubi5kZTAeFw0xMTExMjExMzM3\nMzJaFw0xNjExMTkxMzM3MzJaMIGYMQswCQYDVQQGEwJERTEcMBoGA1UECBMTTm9y\nZHJoZWluLVdlc3RmYWxlbjENMAsGA1UEBxMEQm9ubjEaMBgGA1UEChMRVW5pdmVy\nc2l0YWV0IEJvbm4xHzAdBgNVBAsTFkhvY2hzY2h1bHJlY2hlbnplbnRydW0xHzAd\nBgNVBAMTFnNoaWJib2xldGgudW5pLWJvbm4uZGUwggEiMA0GCSqGSIb3DQEBAQUA\nA4IBDwAwggEKAoIBAQDhmb095e8n0Ntnl+T69lwmLIJOsoR9K2H+queaqzrEoXWx\nX3EEJSb7nIHQ9RuP4kUo8KRkUtYNoKBV/LZC2XH+NKvgnGyYFIu6GKBZFXeYuQMc\nVRTypqEeTJnQ9Vt7N+7c2KojOQ5lB8qtJk5EuAkofgKBgePgVgob7a3SFx+0HnNX\nR6SDOBQQo695NdgDhuUSiS63WRi0Lafec2xjpb+a9Iq5gjhUsP7lhve3fjm7fnky\nIARB6EE8N37htwEFquG1UWFMvPxa0URymi0GZuTH6Fjok6CnR+NWGrK8QufltW9U\nONE0/KJrNM5f5HxtuBa+n3To/u9VPag4SQirvuQtAgMBAAGjggJqMIICZjAJBgNV\nHRMEAjAAMAsGA1UdDwQEAwIF4DAdBgNVHSUEFjAUBggrBgEFBQcDAgYIKwYBBQUH\nAwEwHQYDVR0OBBYEFHqcomCwNt7ndEc81rP8KsSSBdtQMB8GA1UdIwQYMBaAFOs3\n0OvXhC5GnhLTsxjbjeWC5GinMIHJBgNVHREEgcEwgb6BD2J2d0B1bmktYm9ubi5k\nZYIWc2hpYmJvbGV0aC51bmktYm9ubi5kZYIbc2hpYmJvbGV0aC5yaHJ6LnVuaS1i\nb25uLmRlghxzaGliYm9sZXRoMS5yaHJ6LnVuaS1ib25uLmRlghxzaGliYm9sZXRo\nMi5yaHJ6LnVuaS1ib25uLmRlghxzaGliYm9sZXRoMy5yaHJ6LnVuaS1ib25uLmRl\nghxzaGliYm9sZXRoNC5yaHJ6LnVuaS1ib25uLmRlMIGBBgNVHR8EejB4MDqgOKA2\nhjRodHRwOi8vY2RwMS5wY2EuZGZuLmRlL3VuaS1ib25uLWNhL3B1Yi9jcmwvY2Fj\ncmwuY3JsMDqgOKA2hjRodHRwOi8vY2RwMi5wY2EuZGZuLmRlL3VuaS1ib25uLWNh\nL3B1Yi9jcmwvY2FjcmwuY3JsMIGcBggrBgEFBQcBAQSBjzCBjDBEBggrBgEFBQcw\nAoY4aHR0cDovL2NkcDEucGNhLmRmbi5kZS91bmktYm9ubi1jYS9wdWIvY2FjZXJ0\nL2NhY2VydC5jcnQwRAYIKwYBBQUHMAKGOGh0dHA6Ly9jZHAyLnBjYS5kZm4uZGUv\ndW5pLWJvbm4tY2EvcHViL2NhY2VydC9jYWNlcnQuY3J0MA0GCSqGSIb3DQEBBQUA\nA4IBAQBpSi0VhhudTolynhedRGNbvHi8uK8HD51pG9Xm1BTlqIMa4VwkrBeU07As\nnsSciEBSiALIhrLayokU/z5EpROSE4HBvHMomjSezpkPQ60bwIABSplmiwCpu5zF\nArW5cuNFvSdgVKqkElg4Us2uZYcu9s3HdJWB5giU3GbhyReAviQOHO5Dzo+4twbp\nFqDbI6Tj+m4ZOd1u19hcR4TBIvgn7CEk7tSAZfdEQF+nRlYmFyV0LMGCAqksIYC/\nJJvOc54vwjBXXA+3LU5CSoTt7wjLXC2BjLH4OeJL05owk55toOhNNXg1AxMw1Gew\nNHr2AA4aMaB5TQyo2nz1udsI86g4", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://shibboleth.uni-bonn.de:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://shibboleth.uni-bonn.de:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://shibboleth.uni-bonn.de:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://shibboleth.uni-bonn.de:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "uni-bonn.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "text": "shibboleth.uni-bonn.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=shibboleth.uni-bonn.de,OU=Hochschulrechenzentrum,O=Universitaet Bonn,L=Bonn,ST=Nordrhein-Westfalen,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIGQTCCBSmgAwIBAgIHEunRqyAN0TANBgkqhkiG9w0BAQUFADCBujELMAkGA1UE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\nNHr2AA4aMaB5TQyo2nz1udsI86g4", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "de", 
            "text": "uni-bonn.de", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "Universit\u00e4t Bonn", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "http://www.uni-bonn.de", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Irina", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "neerfeld@uni-bonn.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Neerfeld", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Annette", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "jamitzky@uni-bonn.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Jamitzky", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://connect.funet.fi/shibboleth", 
    {
      "entity_id": "https://connect.funet.fi/shibboleth", 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "attribute": [
              {
                "attribute_value": [
                  {
                    "text": "http://www.swamid.se/category/eu-adequate-protection", 
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue", 
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    }
                  }, 
                  {
                    "text": "http://www.swamid.se/category/research-and-education", 
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue", 
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    }
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute", 
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                "name": "http://macedir.org/entity-category"
              }
            ], 
            "__class__": "urn:oasis:names:tc:SAML:metadata:attribute&EntityAttributes"
          }
        ]
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://connect.funet.fi/Shibboleth.sso/SLO/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://connect.funet.fi/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://connect.funet.fi/Shibboleth.sso/SLO/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://connect.funet.fi/Shibboleth.sso/SLO/Artifact"
            }
          ], 
          "attribute_consuming_service": [
            {
              "index": "0", 
              "service_description": [
                {
                  "lang": "en", 
                  "text": "FUNET E-Meeting Service (Adobe Connect)", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription"
                }
              ], 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService", 
              "requested_attribute": [
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.6"
                }, 
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:0.9.2342.19200300.100.1.3"
                }, 
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.5.4.42"
                }, 
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.5.4.4"
                }, 
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.9"
                }, 
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.1"
                }
              ], 
              "service_name": [
                {
                  "lang": "en", 
                  "text": "FUNET E-Meeting Service", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }
              ]
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://connect.funet.fi/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://connect.funet.fi/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://connect.funet.fi/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://connect.funet.fi/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://connect.funet.fi/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://connect.funet.fi/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://connect.funet.fi/Shibboleth.sso/DS/ds.swamid.se"
              }, 
              {
                "index": "2", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://connect.funet.fi/Shibboleth.sso/DS/haka.funet.fi"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "connect.funet.fi", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=connect.funet.fi", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIC9zCCAd+gAwIBAgIJAKZpZsXKkzHCMA0GCSqGSIb3DQEBBQUAMBsxGTAXBgNV\nBAMTEGNvbm5lY3QuZnVuZXQuZmkwHhcNMTIwMjE2MTE0NTMwWhcNMTUwMjE1MTE0\nNTMwWjAbMRkwFwYDVQQDExBjb25uZWN0LmZ1bmV0LmZpMIIBIjANBgkqhkiG9w0B\nAQEFAAOCAQ8AMIIBCgKCAQEA9qHZQfn+2SyyuRhpm+wnEIxXj4eZjNkfQvy/hSih\nfDvnx5QpNerbXt+SIy2YQHmFhn5N5Hdn1onPf91IzshAQVXacIdzqFEXdwl2k4M9\nBw7FiObtFokW4ukEZTEnDPhwTu89oaVuXLLsGt9tCiNBKaSniip4HpMMBEK41jU4\nwzmm+LSQF8xYl+AgagZaydHCVSIQC1PnXqPR1dcnoBzP2t01YqWCfCyxHjHVBYtk\njrXpse9rb0pj1xlurvG1lveqeAStM8AkXiP2gSBQpv88y/YU6UgT1eOLsI65Ox2w\nZWTd36jYbUxHOsRAsZxSy0IokvGIHDK6ykjU9wLthwWXYwIDAQABoz4wPDAbBgNV\nHREEFDASghBjb25uZWN0LmZ1bmV0LmZpMB0GA1UdDgQWBBRxLCa7bCuoP7HKshs5\nFyw8ab6LXzANBgkqhkiG9w0BAQUFAAOCAQEAxw74TU9pNDmMVFq7AXkvHOlnKM9q\nl7c5F7D/KVXOrigwiIn0xwj+kr4ElZp1qrVLgC+fEHk9C2uKR9iJiR1z2SnOEn1U\nTeFtpdM7HaGBivCjsX5d1zMiTILSNkU7u+cJPH9EASOnTjSIbktDfHLApZ+t9yfg\nNPPGeZN6Q8qZuKoJBi7obLAsWbcTSxgIBrYK4G0BS9Hiy3W4gp1gqTflpYx0YBHv\nrNvLo5T1BgsjLc1kQsoAAn8pUP8GHb1KSJ0SY2IKV+k9oWEF3Nd1n/+43bPB666B\nEMBSvHkNXEFDf/FDbw4kjn5ie1pmF4qu+jHVHyB4y4Roz0QFoYIeOWaRMw==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "connect.funet.fi", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=connect.funet.fi", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIC9zCCAd+gAwIBAgIJAKZpZsXKkzHCMA0GCSqGSIb3DQEBBQUAMBsxGTAXBgNV\nBAMTEGNvbm5lY3QuZnVuZXQuZmkwHhcNMTIwMjE2MTE0NTMwWhcNMTUwMjE1MTE0\nNTMwWjAbMRkwFwYDVQQDExBjb25uZWN0LmZ1bmV0LmZpMIIBIjANBgkqhkiG9w0B\nAQEFAAOCAQ8AMIIBCgKCAQEA9qHZQfn+2SyyuRhpm+wnEIxXj4eZjNkfQvy/hSih\nfDvnx5QpNerbXt+SIy2YQHmFhn5N5Hdn1onPf91IzshAQVXacIdzqFEXdwl2k4M9\nBw7FiObtFokW4ukEZTEnDPhwTu89oaVuXLLsGt9tCiNBKaSniip4HpMMBEK41jU4\nwzmm+LSQF8xYl+AgagZaydHCVSIQC1PnXqPR1dcnoBzP2t01YqWCfCyxHjHVBYtk\njrXpse9rb0pj1xlurvG1lveqeAStM8AkXiP2gSBQpv88y/YU6UgT1eOLsI65Ox2w\nZWTd36jYbUxHOsRAsZxSy0IokvGIHDK6ykjU9wLthwWXYwIDAQABoz4wPDAbBgNV\nHREEFDASghBjb25uZWN0LmZ1bmV0LmZpMB0GA1UdDgQWBBRxLCa7bCuoP7HKshs5\nFyw8ab6LXzANBgkqhkiG9w0BAQUFAAOCAQEAxw74TU9pNDmMVFq7AXkvHOlnKM9q\nl7c5F7D/KVXOrigwiIn0xwj+kr4ElZp1qrVLgC+fEHk9C2uKR9iJiR1z2SnOEn1U\nTeFtpdM7HaGBivCjsX5d1zMiTILSNkU7u+cJPH9EASOnTjSIbktDfHLApZ+t9yfg\nNPPGeZN6Q8qZuKoJBi7obLAsWbcTSxgIBrYK4G0BS9Hiy3W4gp1gqTflpYx0YBHv\nrNvLo5T1BgsjLc1kQsoAAn8pUP8GHb1KSJ0SY2IKV+k9oWEF3Nd1n/+43bPB666B\nEMBSvHkNXEFDf/FDbw4kjn5ie1pmF4qu+jHVHyB4y4Roz0QFoYIeOWaRMw==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://connect.funet.fi/Shibboleth.sso/Artifact/SOAP"
            }
          ], 
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://connect.funet.fi/Shibboleth.sso/NIM/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://connect.funet.fi/Shibboleth.sso/NIM/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://connect.funet.fi/Shibboleth.sso/NIM/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://connect.funet.fi/Shibboleth.sso/NIM/Artifact"
            }
          ]
        }
      ], 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-2.0/connect.funet.fi-shibboleth.xml"
      }
    }
  ], 
  [
    "https://wiseflow.dk", 
    {
      "contact_person": [
        {
          "given_name": {
            "text": "Administrator", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "tim@uniwise.dk", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "entity_id": "https://wiseflow.dk", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://wiseflow.dk/simplesaml/module.php/saml/sp/saml2-logout.php/default-sp"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://wiseflow.dk/simplesaml/module.php/saml/sp/saml2-acs.php/default-sp"
            }, 
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://wiseflow.dk/simplesaml/module.php/saml/sp/saml1-acs.php/default-sp"
            }, 
            {
              "index": "0", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://wiseflow.dk/simplesaml/module.php/saml/sp/saml2-acs.php/default-sp"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "name_id_format": [
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ], 
          "attribute_consuming_service": [
            {
              "index": "0", 
              "service_description": [
                {
                  "lang": "en", 
                  "text": "to facilitate digital management of written exams", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription"
                }, 
                {
                  "lang": "da", 
                  "text": "at facilitere digital h\u008c\u00e5ndtering af skriftlige eksaminer", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription"
                }
              ], 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService", 
              "requested_attribute": [
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.5"
                }, 
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.6"
                }, 
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.9"
                }, 
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.10"
                }, 
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.5.4.42"
                }, 
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:0.9.2342.19200300.100.1.3"
                }, 
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.2428.90.1.4"
                }, 
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.16.840.1.113730.3.1.39"
                }, 
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.25178.1.2.9"
                }, 
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.5.4.4"
                }, 
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.25178.1.2.15"
                }
              ], 
              "service_name": [
                {
                  "lang": "en", 
                  "text": "WISEflow", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }, 
                {
                  "lang": "da", 
                  "text": "WISEflow", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }
              ]
            }
          ], 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIE3DCCA8SgAwIBAgISESGN5Wvxcvytdf/HTMhbFEk/MA0GCSqGSIb3DQEBBQUAMFcxCzAJBgNVBAYTAkJFMRkwFwYDVQQKExBHbG9iYWxTaWduIG52LXNhMS0wKwYDVQQDEyRHbG9iYWxTaWduIERvbWFpbiBWYWxpZGF0aW9uIENBIC0gRzIwHhcNMTMxMTIxMTM1MjA2WhcNMTQxMjMxMTI1MDEwWjA7MSEwHwYDVQQLExhEb21haW4gQ29udHJvbCBWYWxpZGF0ZWQxFjAUBgNVBAMMDSoud2lzZWZsb3cuZGswggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQC6s0JtLsYVlJyk0wecpxSI61QY+YJA9CWGHN4+ffPPHdxJHWLuM4CC63vQgw5TFGiOVW38R+FZXyUELOJsruEuP0hvgcsIEVRqJWp9vlAE1vMsHTC2mfGQGwcC2AbwcpPl2+CLBj6uKOcPWzR/N6S9bUsokleeSnfltP5s7VQkFcjcPdbJQWnlRzTwKZTaOxLRfuTnJPGc8D92XWgpCK4u4/pFQEIz00Uzw93ULbRK7tmKF+wyFEKf6FtX7YEO04lqqGpmsJ1daXNzS/izlTM/3Esf0m/SP7N/qNP3BFNv9Nx6i6D7ha/lkT044zBvZcf1+sqF62eRxY/h1247eGi5AgMBAAGjggG8MIIBuDAOBgNVHQ8BAf8EBAMCBaAwSQYDVR0gBEIwQDA+BgZngQwBAgEwNDAyBggrBgEFBQcCARYmaHR0cHM6Ly93d3cuZ2xvYmFsc2lnbi5jb20vcmVwb3NpdG9yeS8wJQYDVR0RBB4wHIINKi53aXNlZmxvdy5ka4ILd2lzZWZsb3cuZGswCQYDVR0TBAIwADAdBgNVHSUEFjAUBggrBgEFBQcDAQYIKwYBBQUHAwIwPwYDVR0fBDgwNjA0oDKgMIYuaHR0cDovL2NybC5nbG9iYWxzaWduLmNvbS9ncy9nc2RvbWFpbnZhbGcyLmNybDCBiAYIKwYBBQUHAQEEfDB6MEEGCCsGAQUFBzAChjVodHRwOi8vc2VjdXJlLmdsb2JhbHNpZ24uY29tL2NhY2VydC9nc2RvbWFpbnZhbGcyLmNydDA1BggrBgEFBQcwAYYpaHR0cDovL29jc3AyLmdsb2JhbHNpZ24uY29tL2dzZG9tYWludmFsZzIwHQYDVR0OBBYEFDWkeXXAWKP/NtMfriWD19/ncjzAMB8GA1UdIwQYMBaAFJat+rBbuYNkKnbCHIpp2kLc/v0oMA0GCSqGSIb3DQEBBQUAA4IBAQCXpVjrhLApjVv+gianFNVw9rfxh1TqsqB1SaImeMTfmaMFKZdVwU8rvIaG7QKrJ8Q6DddNuILkCJsYdPFIT4a9XTpNLztSA0otwSQdw/PQilxyN+anGYNTEMjMYaiN7lbab4jifU85UHBdXliOQ/4x17vADrPT7zVR019ZkmUs/6jjIJCVxnGxUhlDersSXLfIMffOGj+pEqqe2cM0Xdyn9WWQ6OqoHkW5Mpk0bFYRV2KgGsh6H8zqFz3Bpl245IcpGipteoVUV6jAsovk3xUv8fTS18Hjvyg76E8B8pKYyVGjfmogt6EaLfdRBVu18caqSUmLMwszQXEjRakqwGp1", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "encryption", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIE3DCCA8SgAwIBAgISESGN5Wvxcvytdf/HTMhbFEk/MA0GCSqGSIb3DQEBBQUAMFcxCzAJBgNVBAYTAkJFMRkwFwYDVQQKExBHbG9iYWxTaWduIG52LXNhMS0wKwYDVQQDEyRHbG9iYWxTaWduIERvbWFpbiBWYWxpZGF0aW9uIENBIC0gRzIwHhcNMTMxMTIxMTM1MjA2WhcNMTQxMjMxMTI1MDEwWjA7MSEwHwYDVQQLExhEb21haW4gQ29udHJvbCBWYWxpZGF0ZWQxFjAUBgNVBAMMDSoud2lzZWZsb3cuZGswggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQC6s0JtLsYVlJyk0wecpxSI61QY+YJA9CWGHN4+ffPPHdxJHWLuM4CC63vQgw5TFGiOVW38R+FZXyUELOJsruEuP0hvgcsIEVRqJWp9vlAE1vMsHTC2mfGQGwcC2AbwcpPl2+CLBj6uKOcPWzR/N6S9bUsokleeSnfltP5s7VQkFcjcPdbJQWnlRzTwKZTaOxLRfuTnJPGc8D92XWgpCK4u4/pFQEIz00Uzw93ULbRK7tmKF+wyFEKf6FtX7YEO04lqqGpmsJ1daXNzS/izlTM/3Esf0m/SP7N/qNP3BFNv9Nx6i6D7ha/lkT044zBvZcf1+sqF62eRxY/h1247eGi5AgMBAAGjggG8MIIBuDAOBgNVHQ8BAf8EBAMCBaAwSQYDVR0gBEIwQDA+BgZngQwBAgEwNDAyBggrBgEFBQcCARYmaHR0cHM6Ly93d3cuZ2xvYmFsc2lnbi5jb20vcmVwb3NpdG9yeS8wJQYDVR0RBB4wHIINKi53aXNlZmxvdy5ka4ILd2lzZWZsb3cuZGswCQYDVR0TBAIwADAdBgNVHSUEFjAUBggrBgEFBQcDAQYIKwYBBQUHAwIwPwYDVR0fBDgwNjA0oDKgMIYuaHR0cDovL2NybC5nbG9iYWxzaWduLmNvbS9ncy9nc2RvbWFpbnZhbGcyLmNybDCBiAYIKwYBBQUHAQEEfDB6MEEGCCsGAQUFBzAChjVodHRwOi8vc2VjdXJlLmdsb2JhbHNpZ24uY29tL2NhY2VydC9nc2RvbWFpbnZhbGcyLmNydDA1BggrBgEFBQcwAYYpaHR0cDovL29jc3AyLmdsb2JhbHNpZ24uY29tL2dzZG9tYWludmFsZzIwHQYDVR0OBBYEFDWkeXXAWKP/NtMfriWD19/ncjzAMB8GA1UdIwQYMBaAFJat+rBbuYNkKnbCHIpp2kLc/v0oMA0GCSqGSIb3DQEBBQUAA4IBAQCXpVjrhLApjVv+gianFNVw9rfxh1TqsqB1SaImeMTfmaMFKZdVwU8rvIaG7QKrJ8Q6DddNuILkCJsYdPFIT4a9XTpNLztSA0otwSQdw/PQilxyN+anGYNTEMjMYaiN7lbab4jifU85UHBdXliOQ/4x17vADrPT7zVR019ZkmUs/6jjIJCVxnGxUhlDersSXLfIMffOGj+pEqqe2cM0Xdyn9WWQ6OqoHkW5Mpk0bFYRV2KgGsh6H8zqFz3Bpl245IcpGipteoVUV6jAsovk3xUv8fTS18Hjvyg76E8B8pKYyVGjfmogt6EaLfdRBVu18caqSUmLMwszQXEjRakqwGp1", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ]
        }
      ], 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/wiseflow.dk.xml"
      }
    }
  ], 
  [
    "https://www.vho.de/idpvzg", 
    {
      "entity_id": "https://www.vho.de/idpvzg", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/www.vho.de.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://www.vho.de/idpvzg/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://www.vho.de/idpvzg/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://www.vho.de/idpvzg/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://www.vho.de/idpvzg/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "vzg.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "text": "www.vho.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=www.vho.de,OU=Digitale Bibliothek,O=Gemeinsamer Bibliotheksverbund (GBV),L=GOETTINGEN,ST=NIEDERSACHSEN,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIGfzCCBWegAwIBAgIED/+i6zANBgkqhkiG9w0BAQUFADCBuzELMAkGA1UEBhMC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\nCFNwbRrYB0gGPASPkZD9WxiosAZp/uqr6QTZIUDSSmWt2B0=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://www.vho.de:8443/idpvzg/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://www.vho.de:8443/idpvzg/profile/SAML2/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://www.vho.de:8443/idpvzg/profile/SAML1/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://www.vho.de:8443/idpvzg/profile/SAML2/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "vzg.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "text": "www.vho.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=www.vho.de,OU=Digitale Bibliothek,O=Gemeinsamer Bibliotheksverbund (GBV),L=GOETTINGEN,ST=NIEDERSACHSEN,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIGfzCCBWegAwIBAgIED/+i6zANBgkqhkiG9w0BAQUFADCBuzELMAkGA1UEBhMC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\nCFNwbRrYB0gGPASPkZD9WxiosAZp/uqr6QTZIUDSSmWt2B0=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "de", 
            "text": "IdP der Verbundzentrale", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "Verbundzentrale G\u00f6ttingen (VZG)", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "http://www.vho.de", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Franck", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "borel@gbv.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Borel", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Gerald", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "steilen@gbv.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Steilen", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Till", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "kinstler@gbv.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Kinstler", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://via-idp.lanet.lv", 
    {
      "entity_id": "https://via-idp.lanet.lv", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/via-idp.lanet.lv.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://via-idp.lanet.lv/simplesaml/saml2/idp/SingleLogoutService.php"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://via-idp.lanet.lv/simplesaml/saml2/idp/SSOService.php"
            }
          ], 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIICgTCCAeoCCQDwejraQ84XOTANBgkqhkiG9w0BAQUFADCBhDELMAkGA1UEBhMCTFYxDTALBgNVBAgMBFJpZ2ExDTALBgNVBAcMBFJpZ2ExCzAJBgNVBAoMAkxVMQwwCgYDVQQLDANJVEQxFTATBgNVBAMMDGx1LWlkcC5sdS5sdjElMCMGCSqGSIb3DQEJARYWaXRzZXJ2aXNz\nIGF0IGx1IGRvdCBsdjAeFw0xMzAzMjExMDQ0MDJaFw0yODAzMTcxMDQ0MDJaMIGEMQswCQYDVQQGEwJMVjENMAsGA1UECAwEUmlnYTENMAsGA1UEBwwEUmlnYTELMAkGA1UECgwCTFUxDDAKBgNVBAsMA0lURDEVMBMGA1UEAwwMbHUtaWRwLmx1Lmx2MSUwIwYJKoZIhvcNAQkB\nFhZpdHNlcnZpc3MgYXQgbHUgZG90IGx2MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCYSufWasOdnbIDeD2PnmalwxckHx5WLF1WjN1eE0ENJeTldBQDI/ui5ZBxerPyR20ENXbpo+LqjvyIJvQjkx2hkqJ24df0xQThzdbCyGjuA2G7BSNtBLfiboDX5paKOt0aTsyONeO1\nZBGi2uWZxKY+YhuUR9+lxOgGAtfaioNqEQIDAQABMA0GCSqGSIb3DQEBBQUAA4GBAFbTpdFcy+0DUyhi8qOFnFz5yskz2iezD5a8OiOz6dc3bZBuppX/j/mYosMD23vcCsf7jZJzLAl4c57yxirFuYfG8Ho+2SqFB2DARVoZg7Zp8hwJl1aSruxBOb2hdcajpSek3yl+42Am0RdQ\nyOWlzJ0viw82thKw8EOzYCZZMFDK", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "encryption", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIICgTCCAeoCCQDwejraQ84XOTANBgkqhkiG9w0BAQUFADCBhDELMAkGA1UEBhMCTFYxDTALBgNVBAgMBFJpZ2ExDTALBgNVBAcMBFJpZ2ExCzAJBgNVBAoMAkxVMQwwCgYDVQQLDANJVEQxFTATBgNVBAMMDGx1LWlkcC5sdS5sdjElMCMGCSqGSIb3DQEJARYWaXRzZXJ2aXNz\nIGF0IGx1IGRvdCBsdjAeFw0xMzAzMjExMDQ0MDJaFw0yODAzMTcxMDQ0MDJaMIGEMQswCQYDVQQGEwJMVjENMAsGA1UECAwEUmlnYTENMAsGA1UEBwwEUmlnYTELMAkGA1UECgwCTFUxDDAKBgNVBAsMA0lURDEVMBMGA1UEAwwMbHUtaWRwLmx1Lmx2MSUwIwYJKoZIhvcNAQkB\nFhZpdHNlcnZpc3MgYXQgbHUgZG90IGx2MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCYSufWasOdnbIDeD2PnmalwxckHx5WLF1WjN1eE0ENJeTldBQDI/ui5ZBxerPyR20ENXbpo+LqjvyIJvQjkx2hkqJ24df0xQThzdbCyGjuA2G7BSNtBLfiboDX5paKOt0aTsyONeO1\nZBGi2uWZxKY+YhuUR9+lxOgGAtfaioNqEQIDAQABMA0GCSqGSIb3DQEBBQUAA4GBAFbTpdFcy+0DUyhi8qOFnFz5yskz2iezD5a8OiOz6dc3bZBuppX/j/mYosMD23vcCsf7jZJzLAl4c57yxirFuYfG8Ho+2SqFB2DARVoZg7Zp8hwJl1aSruxBOb2hdcajpSek3yl+42Am0RdQ\nyOWlzJ0viw82thKw8EOzYCZZMFDK", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "en", 
                "text": "https://laife.lanet.lv/wiki/Latvian-Academic-Identity-Federation-Policy.pdf", 
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy"
              }
            ], 
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo", 
            "registration_authority": "http://laife.lanet.lv/"
          }
        ]
      }, 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "LAIFE - VIA", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Ventspils University College - VIA IDP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://laife.lanet.lv/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }, 
          {
            "lang": "lv", 
            "text": "http://www.venta.lv/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "email_address": [
            {
              "text": "itserviss@lu.lv", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "ITserviss", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://hades.slu.se/shibboleth", 
    {
      "entity_id": "https://hades.slu.se/shibboleth", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://hades.slu.se/Shibboleth.sso/SLO/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://hades.slu.se/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://hades.slu.se/Shibboleth.sso/SLO/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://hades.slu.se/Shibboleth.sso/SLO/Artifact"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "assertion_consumer_service": [
            {
              "index": "0", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://hades.slu.se/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://hades.slu.se/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://hades.slu.se/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://hades.slu.se/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://hades.slu.se/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://hades.slu.se/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://hades.slu.se/Shibboleth.sso/Login"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "text": "fme1-1.ad.slu.se", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=fme1-1.ad.slu.se", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIC9zCCAd+gAwIBAgIJAID0pitDTgz2MA0GCSqGSIb3DQEBBQUAMBsxGTAXBgNV\nBAMTEGZtZTEtMS5hZC5zbHUuc2UwHhcNMTIwNjI3MDg0NDEzWhcNMjIwNjI1MDg0\nNDEzWjAbMRkwFwYDVQQDExBmbWUxLTEuYWQuc2x1LnNlMIIBIjANBgkqhkiG9w0B\nAQEFAAOCAQ8AMIIBCgKCAQEAw7oOCbv2+Z2jh0uM6YlV7Q9sF0uH03jBj67JPA4r\nCIXIFdJ/g7gLliZa+DjxaNlPxQAE4xc3vGGO7TUyKCftvRIUI49Phm8WKtapy6XE\nPb52xE0ie+B0RO2boUG9xiM50WlZT0VsmdYjwHey7fT5UZjaGa/PLOAAoKXLvfJG\nVQb1IAO8bQ+k4XWf/2oR2BLEKWmy3xW1T4ew34SmAPcpbwZOxj5t0GRDt6lblHvG\nL4KB5a6hEOuU+0U0KjFYKG2PYLJUB4RM6ctmGOnuwUyoWmFAN1h4OZzXoyckr8u2\ngdaWyFL+k/ojckmw5aaJBpce332Bh9wy53W6J77qa0ANawIDAQABoz4wPDAbBgNV\nHREEFDASghBmbWUxLTEuYWQuc2x1LnNlMB0GA1UdDgQWBBSrX7qpYidl+M3/uMRp\nBZk7JtDvtTANBgkqhkiG9w0BAQUFAAOCAQEAAh37ouHU+pXCxffOUOrDNkBSJSAb\nmmD67HCLmcdLwMxBLji/M/FTK5RYdxlwAwK5F1ntbHovDJKWMva7wuWzmjbcSJ6R\nJVrolJWJDR+Fc84L2Lh1Q3sVOXjDXU5Lw+yYApNcs+f2TdYZEa9HDqTyEjupjecd\na7N6bBlELYgoYFbTpg8AmQOsvVl2yQQiX07lBHHeGOn4i1bbB6ip6exRTxUqf0Ed\nQM0LY0RQjVj4+R+UdaRYQfizHG1rnKcEiRzi/mXYt2YXSjKuyvNUn6uc1GY9/3aJ\n9wX+6Hnwlg8X2wAoLJDLxAoOWSUSyPLCSzqp90tYAn1L6/pX68R46PWq4Q==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "0", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://hades.slu.se/Shibboleth.sso/Artifact/SOAP"
            }
          ]
        }
      ], 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-2.0/hades.slu.se-shibboleth.xml"
      }
    }
  ], 
  [
    "https://services.aai.mpg.de/idp/proxy/idp", 
    {
      "entity_id": "https://services.aai.mpg.de/idp/proxy/idp", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/services.aai.mpg.de.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://services.aai.mpg.de/idp/proxy/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://services.aai.mpg.de/idp/proxy/profile/SAML2/Redirect/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://services.aai.mpg.de/idp/proxy/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://services.aai.mpg.de/idp/proxy/profile/SAML2/POST-SimpleSign/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "mpg.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "services.aai.mpg.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=services.aai.mpg.de,OU=PKI,O=Max-Planck-Gesellschaft,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFVDCCBDygAwIBAgIEDpZLlDANBgkqhkiG9w0BAQUFADBeMQswCQYDVQQGEwJE\nRTEgMB4GA1UEChMXTWF4LVBsYW5jay1HZXNlbGxzY2hhZnQxDzANBgNVBAMTBk1Q\nRyBDQTEcMBoGCSqGSIb3DQEJARYNbXBnLWNhQG1wZy5kZTAeFw0wOTA4MDMxMTQ2\nMTNaFw0xNDA4MDIxMTQ2MTNaMFsxCzAJBgNVBAYTAkRFMSAwHgYDVQQKExdNYXgt\nUGxhbmNrLUdlc2VsbHNjaGFmdDEMMAoGA1UECxMDUEtJMRwwGgYDVQQDExNzZXJ2\naWNlcy5hYWkubXBnLmRlMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA\nwo/JY5GAYrXqDlrEhVK+3pVjg+fse6ZDZP2pCdmNw0LFnDxNjEXve/5PvMT6PDi9\nlCb2YPLYl8brtICD/rev9O9NyAaReZ/2HApvMNgFBlAsWSlp4NKruwcG4Sz2VG+a\nT3stcy0ud8pdFSlfe9hvRcDm6/F4d/rEoRwuGtxq4y3u1OrcFPLltOaBRQiLEfXP\nkEe4XRndVqDO2Tdv3FVK2kcQsChc3RF53BA+nRrrMzdYFHNSasR2FTAa4sCqGrXW\nfOhBk7YqX8BYyN5WcgHOUYk7o/sjAUzlc7Irk2a4TpUQTeZjxf2I3eJh3A4U/zsm\n5lGTEyoigyt7NgioMz0aaQIDAQABo4ICGzCCAhcwCQYDVR0TBAIwADALBgNVHQ8E\nBAMCBeAwHQYDVR0lBBYwFAYIKwYBBQUHAwIGCCsGAQUFBwMBMB0GA1UdDgQWBBRP\n2PB1xPMrpSNtJnu/DplMCTithDAfBgNVHSMEGDAWgBQC1h5uCau/WGWnCjxIM2HR\nzn3DWzCBjwYDVR0RBIGHMIGEghNzZXJ2aWNlcy5hYWkubXBnLmRlgg5wdWIuYWFp\nLm1wZy5kZYILYWFpLmd3ZGcuZGWCD3NoaWItaWRwLm1wZy5kZYIQc2hpYi1pZHAu\nZ3dkZy5kZYcEhkwYEIcEhkwYDIcEhkwYCoEbdGhvcnN0ZW4uaGluZGVybWFubkBn\nd2RnLmRlMHcGA1UdHwRwMG4wNaAzoDGGL2h0dHA6Ly9jZHAxLnBjYS5kZm4uZGUv\nbXBnLWNhL3B1Yi9jcmwvY2FjcmwuY3JsMDWgM6Axhi9odHRwOi8vY2RwMi5wY2Eu\nZGZuLmRlL21wZy1jYS9wdWIvY3JsL2NhY3JsLmNybDCBkgYIKwYBBQUHAQEEgYUw\ngYIwPwYIKwYBBQUHMAKGM2h0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvbXBnLWNhL3B1\nYi9jYWNlcnQvY2FjZXJ0LmNydDA/BggrBgEFBQcwAoYzaHR0cDovL2NkcDIucGNh\nLmRmbi5kZS9tcGctY2EvcHViL2NhY2VydC9jYWNlcnQuY3J0MA0GCSqGSIb3DQEB\nBQUAA4IBAQB3YUqg8sgrAdvD1gRqbo8OPl4M9VBoIBhX3Ex6EUWFYAosQPruOVrz\nom+mXgeN2RdCl2Vq/hua/vYvmNGjnBONfkCHAM7y75r2oo94MC3EhQLVfwUnR5Cq\nHHEJoE5ErvAgPS4w6iWCuZbHVpJEXmaQuu16EX//WWcTmBG9JQ1UeF1XnVRdCzWz\nivgAWoFdxV7rPIXYUrgiLOzdzRyTzsP7odbUcGscrbbHRL44ua06ioo3iggojKRJ\nDktGe+x1VIK6EIzYwwOfhn6xcXAfrAIBj+AnWOGM16KAMb1CqFM81GYAZxUItKdh\nguP31RSo9hKlJTxwkQ7O6HcoNbkOHuH7", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "services.aai.mpg.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=services.aai.mpg.de,OU=PKI,O=Max-Planck-Gesellschaft,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFVDCCBDygAwIBAgIEDpZLlDANBgkqhkiG9w0BAQUFADBeMQswCQYDVQQGEwJE\nRTEgMB4GA1UEChMXTWF4LVBsYW5jay1HZXNlbGxzY2hhZnQxDzANBgNVBAMTBk1Q\nRyBDQTEcMBoGCSqGSIb3DQEJARYNbXBnLWNhQG1wZy5kZTAeFw0wOTA4MDMxMTQ2\nMTNaFw0xNDA4MDIxMTQ2MTNaMFsxCzAJBgNVBAYTAkRFMSAwHgYDVQQKExdNYXgt\nUGxhbmNrLUdlc2VsbHNjaGFmdDEMMAoGA1UECxMDUEtJMRwwGgYDVQQDExNzZXJ2\naWNlcy5hYWkubXBnLmRlMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA\nwo/JY5GAYrXqDlrEhVK+3pVjg+fse6ZDZP2pCdmNw0LFnDxNjEXve/5PvMT6PDi9\nlCb2YPLYl8brtICD/rev9O9NyAaReZ/2HApvMNgFBlAsWSlp4NKruwcG4Sz2VG+a\nT3stcy0ud8pdFSlfe9hvRcDm6/F4d/rEoRwuGtxq4y3u1OrcFPLltOaBRQiLEfXP\nkEe4XRndVqDO2Tdv3FVK2kcQsChc3RF53BA+nRrrMzdYFHNSasR2FTAa4sCqGrXW\nfOhBk7YqX8BYyN5WcgHOUYk7o/sjAUzlc7Irk2a4TpUQTeZjxf2I3eJh3A4U/zsm\n5lGTEyoigyt7NgioMz0aaQIDAQABo4ICGzCCAhcwCQYDVR0TBAIwADALBgNVHQ8E\nBAMCBeAwHQYDVR0lBBYwFAYIKwYBBQUHAwIGCCsGAQUFBwMBMB0GA1UdDgQWBBRP\n2PB1xPMrpSNtJnu/DplMCTithDAfBgNVHSMEGDAWgBQC1h5uCau/WGWnCjxIM2HR\nzn3DWzCBjwYDVR0RBIGHMIGEghNzZXJ2aWNlcy5hYWkubXBnLmRlgg5wdWIuYWFp\nLm1wZy5kZYILYWFpLmd3ZGcuZGWCD3NoaWItaWRwLm1wZy5kZYIQc2hpYi1pZHAu\nZ3dkZy5kZYcEhkwYEIcEhkwYDIcEhkwYCoEbdGhvcnN0ZW4uaGluZGVybWFubkBn\nd2RnLmRlMHcGA1UdHwRwMG4wNaAzoDGGL2h0dHA6Ly9jZHAxLnBjYS5kZm4uZGUv\nbXBnLWNhL3B1Yi9jcmwvY2FjcmwuY3JsMDWgM6Axhi9odHRwOi8vY2RwMi5wY2Eu\nZGZuLmRlL21wZy1jYS9wdWIvY3JsL2NhY3JsLmNybDCBkgYIKwYBBQUHAQEEgYUw\ngYIwPwYIKwYBBQUHMAKGM2h0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvbXBnLWNhL3B1\nYi9jYWNlcnQvY2FjZXJ0LmNydDA/BggrBgEFBQcwAoYzaHR0cDovL2NkcDIucGNh\nLmRmbi5kZS9tcGctY2EvcHViL2NhY2VydC9jYWNlcnQuY3J0MA0GCSqGSIb3DQEB\nBQUAA4IBAQB3YUqg8sgrAdvD1gRqbo8OPl4M9VBoIBhX3Ex6EUWFYAosQPruOVrz\nom+mXgeN2RdCl2Vq/hua/vYvmNGjnBONfkCHAM7y75r2oo94MC3EhQLVfwUnR5Cq\nHHEJoE5ErvAgPS4w6iWCuZbHVpJEXmaQuu16EX//WWcTmBG9JQ1UeF1XnVRdCzWz\nivgAWoFdxV7rPIXYUrgiLOzdzRyTzsP7odbUcGscrbbHRL44ua06ioo3iggojKRJ\nDktGe+x1VIK6EIzYwwOfhn6xcXAfrAIBj+AnWOGM16KAMb1CqFM81GYAZxUItKdh\nguP31RSo9hKlJTxwkQ7O6HcoNbkOHuH7", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://services.aai.mpg.de:8443/idp/proxy/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://services.aai.mpg.de:8443/idp/proxy/profile/SAML2/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://services.aai.mpg.de:8443/idp/proxy/profile/SAML1/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://services.aai.mpg.de:8443/idp/proxy/profile/SAML2/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "mpg.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "services.aai.mpg.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=services.aai.mpg.de,OU=PKI,O=Max-Planck-Gesellschaft,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFVDCCBDygAwIBAgIEDpZLlDANBgkqhkiG9w0BAQUFADBeMQswCQYDVQQGEwJE\nRTEgMB4GA1UEChMXTWF4LVBsYW5jay1HZXNlbGxzY2hhZnQxDzANBgNVBAMTBk1Q\nRyBDQTEcMBoGCSqGSIb3DQEJARYNbXBnLWNhQG1wZy5kZTAeFw0wOTA4MDMxMTQ2\nMTNaFw0xNDA4MDIxMTQ2MTNaMFsxCzAJBgNVBAYTAkRFMSAwHgYDVQQKExdNYXgt\nUGxhbmNrLUdlc2VsbHNjaGFmdDEMMAoGA1UECxMDUEtJMRwwGgYDVQQDExNzZXJ2\naWNlcy5hYWkubXBnLmRlMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA\nwo/JY5GAYrXqDlrEhVK+3pVjg+fse6ZDZP2pCdmNw0LFnDxNjEXve/5PvMT6PDi9\nlCb2YPLYl8brtICD/rev9O9NyAaReZ/2HApvMNgFBlAsWSlp4NKruwcG4Sz2VG+a\nT3stcy0ud8pdFSlfe9hvRcDm6/F4d/rEoRwuGtxq4y3u1OrcFPLltOaBRQiLEfXP\nkEe4XRndVqDO2Tdv3FVK2kcQsChc3RF53BA+nRrrMzdYFHNSasR2FTAa4sCqGrXW\nfOhBk7YqX8BYyN5WcgHOUYk7o/sjAUzlc7Irk2a4TpUQTeZjxf2I3eJh3A4U/zsm\n5lGTEyoigyt7NgioMz0aaQIDAQABo4ICGzCCAhcwCQYDVR0TBAIwADALBgNVHQ8E\nBAMCBeAwHQYDVR0lBBYwFAYIKwYBBQUHAwIGCCsGAQUFBwMBMB0GA1UdDgQWBBRP\n2PB1xPMrpSNtJnu/DplMCTithDAfBgNVHSMEGDAWgBQC1h5uCau/WGWnCjxIM2HR\nzn3DWzCBjwYDVR0RBIGHMIGEghNzZXJ2aWNlcy5hYWkubXBnLmRlgg5wdWIuYWFp\nLm1wZy5kZYILYWFpLmd3ZGcuZGWCD3NoaWItaWRwLm1wZy5kZYIQc2hpYi1pZHAu\nZ3dkZy5kZYcEhkwYEIcEhkwYDIcEhkwYCoEbdGhvcnN0ZW4uaGluZGVybWFubkBn\nd2RnLmRlMHcGA1UdHwRwMG4wNaAzoDGGL2h0dHA6Ly9jZHAxLnBjYS5kZm4uZGUv\nbXBnLWNhL3B1Yi9jcmwvY2FjcmwuY3JsMDWgM6Axhi9odHRwOi8vY2RwMi5wY2Eu\nZGZuLmRlL21wZy1jYS9wdWIvY3JsL2NhY3JsLmNybDCBkgYIKwYBBQUHAQEEgYUw\ngYIwPwYIKwYBBQUHMAKGM2h0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvbXBnLWNhL3B1\nYi9jYWNlcnQvY2FjZXJ0LmNydDA/BggrBgEFBQcwAoYzaHR0cDovL2NkcDIucGNh\nLmRmbi5kZS9tcGctY2EvcHViL2NhY2VydC9jYWNlcnQuY3J0MA0GCSqGSIb3DQEB\nBQUAA4IBAQB3YUqg8sgrAdvD1gRqbo8OPl4M9VBoIBhX3Ex6EUWFYAosQPruOVrz\nom+mXgeN2RdCl2Vq/hua/vYvmNGjnBONfkCHAM7y75r2oo94MC3EhQLVfwUnR5Cq\nHHEJoE5ErvAgPS4w6iWCuZbHVpJEXmaQuu16EX//WWcTmBG9JQ1UeF1XnVRdCzWz\nivgAWoFdxV7rPIXYUrgiLOzdzRyTzsP7odbUcGscrbbHRL44ua06ioo3iggojKRJ\nDktGe+x1VIK6EIzYwwOfhn6xcXAfrAIBj+AnWOGM16KAMb1CqFM81GYAZxUItKdh\nguP31RSo9hKlJTxwkQ7O6HcoNbkOHuH7", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "services.aai.mpg.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=services.aai.mpg.de,OU=PKI,O=Max-Planck-Gesellschaft,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFVDCCBDygAwIBAgIEDpZLlDANBgkqhkiG9w0BAQUFADBeMQswCQYDVQQGEwJE\nRTEgMB4GA1UEChMXTWF4LVBsYW5jay1HZXNlbGxzY2hhZnQxDzANBgNVBAMTBk1Q\nRyBDQTEcMBoGCSqGSIb3DQEJARYNbXBnLWNhQG1wZy5kZTAeFw0wOTA4MDMxMTQ2\nMTNaFw0xNDA4MDIxMTQ2MTNaMFsxCzAJBgNVBAYTAkRFMSAwHgYDVQQKExdNYXgt\nUGxhbmNrLUdlc2VsbHNjaGFmdDEMMAoGA1UECxMDUEtJMRwwGgYDVQQDExNzZXJ2\naWNlcy5hYWkubXBnLmRlMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA\nwo/JY5GAYrXqDlrEhVK+3pVjg+fse6ZDZP2pCdmNw0LFnDxNjEXve/5PvMT6PDi9\nlCb2YPLYl8brtICD/rev9O9NyAaReZ/2HApvMNgFBlAsWSlp4NKruwcG4Sz2VG+a\nT3stcy0ud8pdFSlfe9hvRcDm6/F4d/rEoRwuGtxq4y3u1OrcFPLltOaBRQiLEfXP\nkEe4XRndVqDO2Tdv3FVK2kcQsChc3RF53BA+nRrrMzdYFHNSasR2FTAa4sCqGrXW\nfOhBk7YqX8BYyN5WcgHOUYk7o/sjAUzlc7Irk2a4TpUQTeZjxf2I3eJh3A4U/zsm\n5lGTEyoigyt7NgioMz0aaQIDAQABo4ICGzCCAhcwCQYDVR0TBAIwADALBgNVHQ8E\nBAMCBeAwHQYDVR0lBBYwFAYIKwYBBQUHAwIGCCsGAQUFBwMBMB0GA1UdDgQWBBRP\n2PB1xPMrpSNtJnu/DplMCTithDAfBgNVHSMEGDAWgBQC1h5uCau/WGWnCjxIM2HR\nzn3DWzCBjwYDVR0RBIGHMIGEghNzZXJ2aWNlcy5hYWkubXBnLmRlgg5wdWIuYWFp\nLm1wZy5kZYILYWFpLmd3ZGcuZGWCD3NoaWItaWRwLm1wZy5kZYIQc2hpYi1pZHAu\nZ3dkZy5kZYcEhkwYEIcEhkwYDIcEhkwYCoEbdGhvcnN0ZW4uaGluZGVybWFubkBn\nd2RnLmRlMHcGA1UdHwRwMG4wNaAzoDGGL2h0dHA6Ly9jZHAxLnBjYS5kZm4uZGUv\nbXBnLWNhL3B1Yi9jcmwvY2FjcmwuY3JsMDWgM6Axhi9odHRwOi8vY2RwMi5wY2Eu\nZGZuLmRlL21wZy1jYS9wdWIvY3JsL2NhY3JsLmNybDCBkgYIKwYBBQUHAQEEgYUw\ngYIwPwYIKwYBBQUHMAKGM2h0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvbXBnLWNhL3B1\nYi9jYWNlcnQvY2FjZXJ0LmNydDA/BggrBgEFBQcwAoYzaHR0cDovL2NkcDIucGNh\nLmRmbi5kZS9tcGctY2EvcHViL2NhY2VydC9jYWNlcnQuY3J0MA0GCSqGSIb3DQEB\nBQUAA4IBAQB3YUqg8sgrAdvD1gRqbo8OPl4M9VBoIBhX3Ex6EUWFYAosQPruOVrz\nom+mXgeN2RdCl2Vq/hua/vYvmNGjnBONfkCHAM7y75r2oo94MC3EhQLVfwUnR5Cq\nHHEJoE5ErvAgPS4w6iWCuZbHVpJEXmaQuu16EX//WWcTmBG9JQ1UeF1XnVRdCzWz\nivgAWoFdxV7rPIXYUrgiLOzdzRyTzsP7odbUcGscrbbHRL44ua06ioo3iggojKRJ\nDktGe+x1VIK6EIzYwwOfhn6xcXAfrAIBj+AnWOGM16KAMb1CqFM81GYAZxUItKdh\nguP31RSo9hKlJTxwkQ7O6HcoNbkOHuH7", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "de", 
            "text": "Max-Planck-Gesellschaft", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "Max-Planck-Gesellschaft", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "http://www.mpg.de/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Sebastian", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "sebastian.rieger@gwdg.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Rieger", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Matthias", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "matthias.egger@rzg.mpg.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Egger", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Thorsten", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "thorsten.hindermann@gwdg.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Hindermann", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://bibliometrics.ki.se/shibboleth", 
    {
      "entity_id": "https://bibliometrics.ki.se/shibboleth", 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "attribute": [
              {
                "attribute_value": [
                  {
                    "text": "http://www.swamid.se/category/hei-service", 
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue", 
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    }
                  }, 
                  {
                    "text": "http://www.swamid.se/category/research-and-education", 
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue", 
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    }
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute", 
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                "name": "http://macedir.org/entity-category"
              }
            ], 
            "__class__": "urn:oasis:names:tc:SAML:metadata:attribute&EntityAttributes"
          }
        ]
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://bibliometrics.ki.se/Shibboleth.sso/SLO/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://bibliometrics.ki.se/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://bibliometrics.ki.se/Shibboleth.sso/SLO/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://bibliometrics.ki.se/Shibboleth.sso/SLO/Artifact"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://bibliometrics.ki.se/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://bibliometrics.ki.se/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://bibliometrics.ki.se/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://bibliometrics.ki.se/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://bibliometrics.ki.se/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://bibliometrics.ki.se/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "dakini", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=dakini", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_issuer_serial": {
                      "x509_serial_number": {
                        "text": "13185477282229581982", 
                        "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SerialNumber"
                      }, 
                      "x509_issuer_name": {
                        "text": "CN=dakini", 
                        "__class__": "http://www.w3.org/2000/09/xmldsig#&X509IssuerName"
                      }, 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509IssuerSerial"
                    }, 
                    "x509_certificate": {
                      "text": "MIIC2TCCAcGgAwIBAgIJALb8ObqBRvieMA0GCSqGSIb3DQEBBQUAMBExDzANBgNV\nBAMTBmRha2luaTAeFw0wOTA4MjAwODQ1MDhaFw0xOTA4MTgwODQ1MDhaMBExDzAN\nBgNVBAMTBmRha2luaTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBALWH\nC8Fn5KzWao6uaivX319kdey1mI8ig50awhcF3wkTW+ZZxP4vkbC6YBcrmQOO1iKd\nEVj16GLWaJ8Ut+iVY/rvPgdS2jDbZ2w8BEoa0Vbzn8lcuuBM13oudRiTVVGzLY1V\nPgKzmT3n13VTPEnJeAVgS8SzA15ncMIUQaMLnXxjSzJvzk9f5dWD1Gj0cygpwMT5\nf0oKa0UjYK71kj9we96CVQEi7Rab0sO9jwr+a+nIOUbmND9cLDcsH4p33s/toxJw\nDhNNyk0qn9d31FdEdWxvjKadB3e3XQfidSQcWCi+zj7QSbg4l4JdbCT4dHxnbxhF\nwZ4QYQDb4mAwT6Z4cgMCAwEAAaM0MDIwEQYDVR0RBAowCIIGZGFraW5pMB0GA1Ud\nDgQWBBTxVcu+3um0LDAQLjN13N8+gEAKRjANBgkqhkiG9w0BAQUFAAOCAQEAbSsU\nSIRr47OU0aMebcZdoN/rRlJ0WQoMxb/bK89MiUr9AqWdCJ+DRGuQyXhieMIlOaJu\nWCqlajH795ZfZExSDDH/PG3EhcvC2rOMuBWbAxlpYc0hsXBq8NilZhiSSAqrYurG\nNEKkvNz7AU9EB9u1GMIO3p3UTKiXDVVaGL6fSseSKXsaYH6udoRz++25eDeQPUgp\nHgDpL2zWJcwd1mIaNAxIylz+rR4Rakohiwdl2dkMIT3aimODRAvQVf4wvV08Q11M\nDK12w8bmjGJp07CTu/QuoWW+jyY1S0k6Kv3LN6VtXWckviepGDFNzdGgML9V5fRJ\nfP+xp1jCheyR/F9V3w==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "dakini", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=dakini", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_issuer_serial": {
                      "x509_serial_number": {
                        "text": "13185477282229581982", 
                        "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SerialNumber"
                      }, 
                      "x509_issuer_name": {
                        "text": "CN=dakini", 
                        "__class__": "http://www.w3.org/2000/09/xmldsig#&X509IssuerName"
                      }, 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509IssuerSerial"
                    }, 
                    "x509_certificate": {
                      "text": "MIIC2TCCAcGgAwIBAgIJALb8ObqBRvieMA0GCSqGSIb3DQEBBQUAMBExDzANBgNV\nBAMTBmRha2luaTAeFw0wOTA4MjAwODQ1MDhaFw0xOTA4MTgwODQ1MDhaMBExDzAN\nBgNVBAMTBmRha2luaTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBALWH\nC8Fn5KzWao6uaivX319kdey1mI8ig50awhcF3wkTW+ZZxP4vkbC6YBcrmQOO1iKd\nEVj16GLWaJ8Ut+iVY/rvPgdS2jDbZ2w8BEoa0Vbzn8lcuuBM13oudRiTVVGzLY1V\nPgKzmT3n13VTPEnJeAVgS8SzA15ncMIUQaMLnXxjSzJvzk9f5dWD1Gj0cygpwMT5\nf0oKa0UjYK71kj9we96CVQEi7Rab0sO9jwr+a+nIOUbmND9cLDcsH4p33s/toxJw\nDhNNyk0qn9d31FdEdWxvjKadB3e3XQfidSQcWCi+zj7QSbg4l4JdbCT4dHxnbxhF\nwZ4QYQDb4mAwT6Z4cgMCAwEAAaM0MDIwEQYDVR0RBAowCIIGZGFraW5pMB0GA1Ud\nDgQWBBTxVcu+3um0LDAQLjN13N8+gEAKRjANBgkqhkiG9w0BAQUFAAOCAQEAbSsU\nSIRr47OU0aMebcZdoN/rRlJ0WQoMxb/bK89MiUr9AqWdCJ+DRGuQyXhieMIlOaJu\nWCqlajH795ZfZExSDDH/PG3EhcvC2rOMuBWbAxlpYc0hsXBq8NilZhiSSAqrYurG\nNEKkvNz7AU9EB9u1GMIO3p3UTKiXDVVaGL6fSseSKXsaYH6udoRz++25eDeQPUgp\nHgDpL2zWJcwd1mIaNAxIylz+rR4Rakohiwdl2dkMIT3aimODRAvQVf4wvV08Q11M\nDK12w8bmjGJp07CTu/QuoWW+jyY1S0k6Kv3LN6VtXWckviepGDFNzdGgML9V5fRJ\nfP+xp1jCheyR/F9V3w==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://bibliometrics.ki.se/Shibboleth.sso/NIM/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://bibliometrics.ki.se/Shibboleth.sso/NIM/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://bibliometrics.ki.se/Shibboleth.sso/NIM/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://bibliometrics.ki.se/Shibboleth.sso/NIM/Artifact"
            }
          ]
        }
      ], 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-2.0/bibliometrics.ki.se-shibboleth.xml"
      }
    }
  ], 
  [
    "https://its-pd0062.ad.umu.se/shibboleth-sp", 
    {
      "entity_id": "https://its-pd0062.ad.umu.se/shibboleth-sp", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://its-pd0062.ad.umu.se/Shibboleth.sso/SLO/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://its-pd0062.ad.umu.se/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://its-pd0062.ad.umu.se/Shibboleth.sso/SLO/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://its-pd0062.ad.umu.se/Shibboleth.sso/SLO/Artifact"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://its-pd0062.ad.umu.se/Shibboleth.sso/SLO/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://its-pd0062.ad.umu.se/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://its-pd0062.ad.umu.se/Shibboleth.sso/SLO/POST"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://its-pd0062.ad.umu.se/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://its-pd0062.ad.umu.se/Shibboleth.sso/SAML2/POST-SimpleSign"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://its-pd0062.ad.umu.se/Shibboleth.sso/DS/ds.swamid.se"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "text": "its-pd0062.ad.umu.se", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=its-pd0062.ad.umu.se", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIDAzCCAeugAwIBAgIJAISQ+6OrrBvmMA0GCSqGSIb3DQEBBQUAMB8xHTAbBgNV\nBAMTFGl0cy1wZDAwNjIuYWQudW11LnNlMB4XDTEyMDQwNDEzNDQyNloXDTIyMDQw\nMjEzNDQyNlowHzEdMBsGA1UEAxMUaXRzLXBkMDA2Mi5hZC51bXUuc2UwggEiMA0G\nCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCV0RgOrba9T2uZM3oirmyK0pCuuE4G\nmBw0Xk1urDsI7SRZ86zZP+e0yZYPIHDO8W1O0ca2cTrWixg/mjSRUEHb84ja7pwE\nKdJ23uhEMpfVCG2wfOOWMoWsuPjsA+EwaV8Sd0wfOHnlHeiZnZfLPT6rX/r81hOe\nglFxZX/jYmhbATAx333CpCcCK4sE9PK6lilgMhBBTMqFQw0ORKpNk8MXYAc3ws+m\n0oJonE3R/1u7CuoRbC6ByOgv8ygF30Wsbxi1mew8schl/xdRZ827hI4Vpx3NsUlT\n4i4rN91L2WfaSjnzlXoV6Mgl+lrdnJEzlaBk+a2TnN4jQGUElCvj4tr1AgMBAAGj\nQjBAMB8GA1UdEQQYMBaCFGl0cy1wZDAwNjIuYWQudW11LnNlMB0GA1UdDgQWBBSt\noiK8tNwfMNNOo9CtJ+Ch28e9kzANBgkqhkiG9w0BAQUFAAOCAQEARczFJycPFM5g\ndZu0R/ET3IlhaLzam8np4HudzZG321dBuqy1kmJX11gCtT39gJJCFU4TJqTZZQN5\na3DgryGRz9+a/YsUwQSSQooFqeI7lgWdOsfjeRYxrj3IWYtK+1Djmv1FqCrKiY6I\nq33PJ7wIY9VmHLuZNRvnPJymJ96KXp1PGuzPf+D9EJAmLACahbtKQN4BPZRUY2W1\ngPYoStBXXQQMzgcSfcJ30uSYzJKp/xbjR+X8ATcrcy1rruzix+4nq7RuyZ9IVaTT\nx8KpMVoGa5QkJcKJqsqD0oBy6YCPuJiDcouhncPIU+cy5vTOG9YXjzBC/Td01ZLn\nXF6Xb2bzkg==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "0", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://its-pd0062.ad.umu.se/Shibboleth.sso/Artifact/SOAP"
            }
          ], 
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://its-pd0062.ad.umu.se/Shibboleth.sso/NIM/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://its-pd0062.ad.umu.se/Shibboleth.sso/NIM/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://its-pd0062.ad.umu.se/Shibboleth.sso/NIM/POST"
            }
          ]
        }
      ], 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-2.0/its-pd0062.ad.umu.se-shibboleth-sp.xml"
      }
    }
  ], 
  [
    "https://login.rz.rwth-aachen.de/shibboleth", 
    {
      "entity_id": "https://login.rz.rwth-aachen.de/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/login.rz.rwth-aachen.de.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://login.rz.rwth-aachen.de/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://login.rz.rwth-aachen.de/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://login.rz.rwth-aachen.de/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "rwth-aachen.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "login.rz.rwth-aachen.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=login.rz.rwth-aachen.de,OU=Rechen- und Kommunikationszentum,O=RWTH Aachen,L=Aachen,ST=Nordrhein-Westfalen,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFCzCCA/OgAwIBAgIEC1FmFjANBgkqhkiG9w0BAQUFADBeMQswCQYDVQQGEwJE\nRTEUMBIGA1UEChMLUldUSCBBYWNoZW4xFzAVBgNVBAMTDlJXVEggQWFjaGVuIENB\nMSAwHgYJKoZIhvcNAQkBFhFjYUByd3RoLWFhY2hlbi5kZTAeFw0wNzExMDcxNjMy\nMDhaFw0xMjExMDUxNjMyMDhaMIGfMQswCQYDVQQGEwJERTEcMBoGA1UECBMTTm9y\nZHJoZWluLVdlc3RmYWxlbjEPMA0GA1UEBxMGQWFjaGVuMRQwEgYDVQQKEwtSV1RI\nIEFhY2hlbjEpMCcGA1UECxMgUmVjaGVuLSB1bmQgS29tbXVuaWthdGlvbnN6ZW50\ndW0xIDAeBgNVBAMTF2xvZ2luLnJ6LnJ3dGgtYWFjaGVuLmRlMIIBIjANBgkqhkiG\n9w0BAQEFAAOCAQ8AMIIBCgKCAQEAs2hVOkyelzF5UQylTADmmcHzrwzRjteUTx6b\nSCnQlTUiCsMGdICcOdP/kzBHDTJsd5AAlb5DMZ5M4O4Vl1NaJPLDT7nQj3oAF9pu\nCNv9XeguWwR1Bsy+KzJ+ixxVP0nt6665zY9FSRPJOVII6ziNUgedmtFV96jWQ49P\nR6duFD9CDyAlLj2DZSANeG50sX1Bcfc5F6UHSgkTzLnJqtl3ufQ/ltZyb3iEmOLS\nmcoOKaS/HUV4vp1y6zVCLbU/i8t82vr6zFB0zJuQiiFQtrp1j/V06XuXxzjpleUz\njySyWf+4W1svGGWkQdZyPdht90i1NFCYQIhSY+U3iNNGl2SnOwIDAQABo4IBjTCC\nAYkwCQYDVR0TBAIwADALBgNVHQ8EBAMCBeAwHQYDVR0lBBYwFAYIKwYBBQUHAwIG\nCCsGAQUFBwMBMB0GA1UdDgQWBBSOzgsiaPAKHD8PTdDijBwTIGvetTAfBgNVHSME\nGDAWgBRu1T7AHC9xyTy/SU7valVI7NHyODB5BgNVHR8EcjBwMDagNKAyhjBodHRw\nOi8vY2RwMS5wY2EuZGZuLmRlL3J3dGgtY2EvcHViL2NybC9jYWNybC5jcmwwNqA0\noDKGMGh0dHA6Ly9jZHAyLnBjYS5kZm4uZGUvcnd0aC1jYS9wdWIvY3JsL2NhY3Js\nLmNybDCBlAYIKwYBBQUHAQEEgYcwgYQwQAYIKwYBBQUHMAKGNGh0dHA6Ly9jZHAx\nLnBjYS5kZm4uZGUvcnd0aC1jYS9wdWIvY2FjZXJ0L2NhY2VydC5jcnQwQAYIKwYB\nBQUHMAKGNGh0dHA6Ly9jZHAyLnBjYS5kZm4uZGUvcnd0aC1jYS9wdWIvY2FjZXJ0\nL2NhY2VydC5jcnQwDQYJKoZIhvcNAQEFBQADggEBAGl5Pq3DyUfhi1G/TEB6/rlf\nfPG85RidFcLXm5BamuZithBT2F/pvFRnlnaogUU6ik9I73qdxFLKAX7c+K/BC89D\njEosFBgD4zCHRTe3gnyBhG4+T40smabgvEBS1LOJPib14nLPOPouFnvdwaD+hCq0\n3XjbCwyEGgGnODTgFAkL+bWx/mgEZpbiCtzYuOVxojm0hQ5i42l9RIKsLrZ3ooT/\nT6qF9criC1jOHj11gJeZ11z/znefgOY+oK9vlc/41+JzhDWiiZ2KB05aiSfq+mTF\nsHc/L7HpK3d6tFerveNpu6HAAyALsqwKOS2CqmANj5EDFnY57yTDWJZcgsMlK+c=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "login.rz.rwth-aachen.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=login.rz.rwth-aachen.de,OU=Rechen- und Kommunikationszentum,O=RWTH Aachen,L=Aachen,ST=Nordrhein-Westfalen,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFCzCCA/OgAwIBAgIEC1FmFjANBgkqhkiG9w0BAQUFADBeMQswCQYDVQQGEwJE\nRTEUMBIGA1UEChMLUldUSCBBYWNoZW4xFzAVBgNVBAMTDlJXVEggQWFjaGVuIENB\nMSAwHgYJKoZIhvcNAQkBFhFjYUByd3RoLWFhY2hlbi5kZTAeFw0wNzExMDcxNjMy\nMDhaFw0xMjExMDUxNjMyMDhaMIGfMQswCQYDVQQGEwJERTEcMBoGA1UECBMTTm9y\nZHJoZWluLVdlc3RmYWxlbjEPMA0GA1UEBxMGQWFjaGVuMRQwEgYDVQQKEwtSV1RI\nIEFhY2hlbjEpMCcGA1UECxMgUmVjaGVuLSB1bmQgS29tbXVuaWthdGlvbnN6ZW50\ndW0xIDAeBgNVBAMTF2xvZ2luLnJ6LnJ3dGgtYWFjaGVuLmRlMIIBIjANBgkqhkiG\n9w0BAQEFAAOCAQ8AMIIBCgKCAQEAs2hVOkyelzF5UQylTADmmcHzrwzRjteUTx6b\nSCnQlTUiCsMGdICcOdP/kzBHDTJsd5AAlb5DMZ5M4O4Vl1NaJPLDT7nQj3oAF9pu\nCNv9XeguWwR1Bsy+KzJ+ixxVP0nt6665zY9FSRPJOVII6ziNUgedmtFV96jWQ49P\nR6duFD9CDyAlLj2DZSANeG50sX1Bcfc5F6UHSgkTzLnJqtl3ufQ/ltZyb3iEmOLS\nmcoOKaS/HUV4vp1y6zVCLbU/i8t82vr6zFB0zJuQiiFQtrp1j/V06XuXxzjpleUz\njySyWf+4W1svGGWkQdZyPdht90i1NFCYQIhSY+U3iNNGl2SnOwIDAQABo4IBjTCC\nAYkwCQYDVR0TBAIwADALBgNVHQ8EBAMCBeAwHQYDVR0lBBYwFAYIKwYBBQUHAwIG\nCCsGAQUFBwMBMB0GA1UdDgQWBBSOzgsiaPAKHD8PTdDijBwTIGvetTAfBgNVHSME\nGDAWgBRu1T7AHC9xyTy/SU7valVI7NHyODB5BgNVHR8EcjBwMDagNKAyhjBodHRw\nOi8vY2RwMS5wY2EuZGZuLmRlL3J3dGgtY2EvcHViL2NybC9jYWNybC5jcmwwNqA0\noDKGMGh0dHA6Ly9jZHAyLnBjYS5kZm4uZGUvcnd0aC1jYS9wdWIvY3JsL2NhY3Js\nLmNybDCBlAYIKwYBBQUHAQEEgYcwgYQwQAYIKwYBBQUHMAKGNGh0dHA6Ly9jZHAx\nLnBjYS5kZm4uZGUvcnd0aC1jYS9wdWIvY2FjZXJ0L2NhY2VydC5jcnQwQAYIKwYB\nBQUHMAKGNGh0dHA6Ly9jZHAyLnBjYS5kZm4uZGUvcnd0aC1jYS9wdWIvY2FjZXJ0\nL2NhY2VydC5jcnQwDQYJKoZIhvcNAQEFBQADggEBAGl5Pq3DyUfhi1G/TEB6/rlf\nfPG85RidFcLXm5BamuZithBT2F/pvFRnlnaogUU6ik9I73qdxFLKAX7c+K/BC89D\njEosFBgD4zCHRTe3gnyBhG4+T40smabgvEBS1LOJPib14nLPOPouFnvdwaD+hCq0\n3XjbCwyEGgGnODTgFAkL+bWx/mgEZpbiCtzYuOVxojm0hQ5i42l9RIKsLrZ3ooT/\nT6qF9criC1jOHj11gJeZ11z/znefgOY+oK9vlc/41+JzhDWiiZ2KB05aiSfq+mTF\nsHc/L7HpK3d6tFerveNpu6HAAyALsqwKOS2CqmANj5EDFnY57yTDWJZcgsMlK+c=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://login.rz.rwth-aachen.de:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://login.rz.rwth-aachen.de:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://login.rz.rwth-aachen.de:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://login.rz.rwth-aachen.de:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "rwth-aachen.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "login.rz.rwth-aachen.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=login.rz.rwth-aachen.de,OU=Rechen- und Kommunikationszentum,O=RWTH Aachen,L=Aachen,ST=Nordrhein-Westfalen,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFCzCCA/OgAwIBAgIEC1FmFjANBgkqhkiG9w0BAQUFADBeMQswCQYDVQQGEwJE\nRTEUMBIGA1UEChMLUldUSCBBYWNoZW4xFzAVBgNVBAMTDlJXVEggQWFjaGVuIENB\nMSAwHgYJKoZIhvcNAQkBFhFjYUByd3RoLWFhY2hlbi5kZTAeFw0wNzExMDcxNjMy\nMDhaFw0xMjExMDUxNjMyMDhaMIGfMQswCQYDVQQGEwJERTEcMBoGA1UECBMTTm9y\nZHJoZWluLVdlc3RmYWxlbjEPMA0GA1UEBxMGQWFjaGVuMRQwEgYDVQQKEwtSV1RI\nIEFhY2hlbjEpMCcGA1UECxMgUmVjaGVuLSB1bmQgS29tbXVuaWthdGlvbnN6ZW50\ndW0xIDAeBgNVBAMTF2xvZ2luLnJ6LnJ3dGgtYWFjaGVuLmRlMIIBIjANBgkqhkiG\n9w0BAQEFAAOCAQ8AMIIBCgKCAQEAs2hVOkyelzF5UQylTADmmcHzrwzRjteUTx6b\nSCnQlTUiCsMGdICcOdP/kzBHDTJsd5AAlb5DMZ5M4O4Vl1NaJPLDT7nQj3oAF9pu\nCNv9XeguWwR1Bsy+KzJ+ixxVP0nt6665zY9FSRPJOVII6ziNUgedmtFV96jWQ49P\nR6duFD9CDyAlLj2DZSANeG50sX1Bcfc5F6UHSgkTzLnJqtl3ufQ/ltZyb3iEmOLS\nmcoOKaS/HUV4vp1y6zVCLbU/i8t82vr6zFB0zJuQiiFQtrp1j/V06XuXxzjpleUz\njySyWf+4W1svGGWkQdZyPdht90i1NFCYQIhSY+U3iNNGl2SnOwIDAQABo4IBjTCC\nAYkwCQYDVR0TBAIwADALBgNVHQ8EBAMCBeAwHQYDVR0lBBYwFAYIKwYBBQUHAwIG\nCCsGAQUFBwMBMB0GA1UdDgQWBBSOzgsiaPAKHD8PTdDijBwTIGvetTAfBgNVHSME\nGDAWgBRu1T7AHC9xyTy/SU7valVI7NHyODB5BgNVHR8EcjBwMDagNKAyhjBodHRw\nOi8vY2RwMS5wY2EuZGZuLmRlL3J3dGgtY2EvcHViL2NybC9jYWNybC5jcmwwNqA0\noDKGMGh0dHA6Ly9jZHAyLnBjYS5kZm4uZGUvcnd0aC1jYS9wdWIvY3JsL2NhY3Js\nLmNybDCBlAYIKwYBBQUHAQEEgYcwgYQwQAYIKwYBBQUHMAKGNGh0dHA6Ly9jZHAx\nLnBjYS5kZm4uZGUvcnd0aC1jYS9wdWIvY2FjZXJ0L2NhY2VydC5jcnQwQAYIKwYB\nBQUHMAKGNGh0dHA6Ly9jZHAyLnBjYS5kZm4uZGUvcnd0aC1jYS9wdWIvY2FjZXJ0\nL2NhY2VydC5jcnQwDQYJKoZIhvcNAQEFBQADggEBAGl5Pq3DyUfhi1G/TEB6/rlf\nfPG85RidFcLXm5BamuZithBT2F/pvFRnlnaogUU6ik9I73qdxFLKAX7c+K/BC89D\njEosFBgD4zCHRTe3gnyBhG4+T40smabgvEBS1LOJPib14nLPOPouFnvdwaD+hCq0\n3XjbCwyEGgGnODTgFAkL+bWx/mgEZpbiCtzYuOVxojm0hQ5i42l9RIKsLrZ3ooT/\nT6qF9criC1jOHj11gJeZ11z/znefgOY+oK9vlc/41+JzhDWiiZ2KB05aiSfq+mTF\nsHc/L7HpK3d6tFerveNpu6HAAyALsqwKOS2CqmANj5EDFnY57yTDWJZcgsMlK+c=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "login.rz.rwth-aachen.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=login.rz.rwth-aachen.de,OU=Rechen- und Kommunikationszentum,O=RWTH Aachen,L=Aachen,ST=Nordrhein-Westfalen,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFCzCCA/OgAwIBAgIEC1FmFjANBgkqhkiG9w0BAQUFADBeMQswCQYDVQQGEwJE\nRTEUMBIGA1UEChMLUldUSCBBYWNoZW4xFzAVBgNVBAMTDlJXVEggQWFjaGVuIENB\nMSAwHgYJKoZIhvcNAQkBFhFjYUByd3RoLWFhY2hlbi5kZTAeFw0wNzExMDcxNjMy\nMDhaFw0xMjExMDUxNjMyMDhaMIGfMQswCQYDVQQGEwJERTEcMBoGA1UECBMTTm9y\nZHJoZWluLVdlc3RmYWxlbjEPMA0GA1UEBxMGQWFjaGVuMRQwEgYDVQQKEwtSV1RI\nIEFhY2hlbjEpMCcGA1UECxMgUmVjaGVuLSB1bmQgS29tbXVuaWthdGlvbnN6ZW50\ndW0xIDAeBgNVBAMTF2xvZ2luLnJ6LnJ3dGgtYWFjaGVuLmRlMIIBIjANBgkqhkiG\n9w0BAQEFAAOCAQ8AMIIBCgKCAQEAs2hVOkyelzF5UQylTADmmcHzrwzRjteUTx6b\nSCnQlTUiCsMGdICcOdP/kzBHDTJsd5AAlb5DMZ5M4O4Vl1NaJPLDT7nQj3oAF9pu\nCNv9XeguWwR1Bsy+KzJ+ixxVP0nt6665zY9FSRPJOVII6ziNUgedmtFV96jWQ49P\nR6duFD9CDyAlLj2DZSANeG50sX1Bcfc5F6UHSgkTzLnJqtl3ufQ/ltZyb3iEmOLS\nmcoOKaS/HUV4vp1y6zVCLbU/i8t82vr6zFB0zJuQiiFQtrp1j/V06XuXxzjpleUz\njySyWf+4W1svGGWkQdZyPdht90i1NFCYQIhSY+U3iNNGl2SnOwIDAQABo4IBjTCC\nAYkwCQYDVR0TBAIwADALBgNVHQ8EBAMCBeAwHQYDVR0lBBYwFAYIKwYBBQUHAwIG\nCCsGAQUFBwMBMB0GA1UdDgQWBBSOzgsiaPAKHD8PTdDijBwTIGvetTAfBgNVHSME\nGDAWgBRu1T7AHC9xyTy/SU7valVI7NHyODB5BgNVHR8EcjBwMDagNKAyhjBodHRw\nOi8vY2RwMS5wY2EuZGZuLmRlL3J3dGgtY2EvcHViL2NybC9jYWNybC5jcmwwNqA0\noDKGMGh0dHA6Ly9jZHAyLnBjYS5kZm4uZGUvcnd0aC1jYS9wdWIvY3JsL2NhY3Js\nLmNybDCBlAYIKwYBBQUHAQEEgYcwgYQwQAYIKwYBBQUHMAKGNGh0dHA6Ly9jZHAx\nLnBjYS5kZm4uZGUvcnd0aC1jYS9wdWIvY2FjZXJ0L2NhY2VydC5jcnQwQAYIKwYB\nBQUHMAKGNGh0dHA6Ly9jZHAyLnBjYS5kZm4uZGUvcnd0aC1jYS9wdWIvY2FjZXJ0\nL2NhY2VydC5jcnQwDQYJKoZIhvcNAQEFBQADggEBAGl5Pq3DyUfhi1G/TEB6/rlf\nfPG85RidFcLXm5BamuZithBT2F/pvFRnlnaogUU6ik9I73qdxFLKAX7c+K/BC89D\njEosFBgD4zCHRTe3gnyBhG4+T40smabgvEBS1LOJPib14nLPOPouFnvdwaD+hCq0\n3XjbCwyEGgGnODTgFAkL+bWx/mgEZpbiCtzYuOVxojm0hQ5i42l9RIKsLrZ3ooT/\nT6qF9criC1jOHj11gJeZ11z/znefgOY+oK9vlc/41+JzhDWiiZ2KB05aiSfq+mTF\nsHc/L7HpK3d6tFerveNpu6HAAyALsqwKOS2CqmANj5EDFnY57yTDWJZcgsMlK+c=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "de", 
            "text": "RWTH Aachen", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "RWTH Aachen", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "http://www.rwth-aachen.de", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Christian", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "bischof@rz.rwth-aachen.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Bischof", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Wilfred", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "sso@rz.rwth-aachen.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Gasper", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://www.diva-portal.org/shibboleth", 
    {
      "entity_id": "https://www.diva-portal.org/shibboleth", 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "attribute": [
              {
                "attribute_value": [
                  {
                    "text": "http://www.swamid.se/category/hei-service", 
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue", 
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    }
                  }, 
                  {
                    "text": "http://www.swamid.se/category/research-and-education", 
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue", 
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    }
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute", 
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                "name": "http://macedir.org/entity-category"
              }
            ], 
            "__class__": "urn:oasis:names:tc:SAML:metadata:attribute&EntityAttributes"
          }
        ]
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://www.diva-portal.org/Shibboleth.sso/SLO/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://www.diva-portal.org/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://www.diva-portal.org/Shibboleth.sso/SLO/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://www.diva-portal.org/Shibboleth.sso/SLO/Artifact"
            }
          ], 
          "attribute_consuming_service": [
            {
              "index": "0", 
              "service_description": [
                {
                  "lang": "en", 
                  "text": "DiVA \u2013 Academic Archive Online - is a system for electronic publishing and for registering publications produced by researchers, teachers and students. Uppsala University Library develops and maintains DiVA.", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription"
                }
              ], 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService", 
              "requested_attribute": [
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.6"
                }, 
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:0.9.2342.19200300.100.1.3"
                }, 
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.5.4.42"
                }, 
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.5.4.4"
                }, 
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.9"
                }, 
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.1"
                }
              ], 
              "service_name": [
                {
                  "lang": "en", 
                  "text": "DiVA", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }
              ]
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.diva-portal.org/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.diva-portal.org/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.diva-portal.org/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.diva-portal.org/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.diva-portal.org/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.diva-portal.org/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "www.diva-portal.org", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=www.diva-portal.org", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIDADCCAeigAwIBAgIJALws/Gp4u0qUMA0GCSqGSIb3DQEBBQUAMB4xHDAaBgNV\nBAMTE3d3dy5kaXZhLXBvcnRhbC5vcmcwHhcNMTAwMTI2MTMzMDA0WhcNMjAwMTI0\nMTMzMDA0WjAeMRwwGgYDVQQDExN3d3cuZGl2YS1wb3J0YWwub3JnMIIBIjANBgkq\nhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAxiqePLbYzwDdJ7db9++auHZNsjAhXhpm\nAIfDlpu0ZJ6PdxsRtwT5aQzjTkvBce7JYezri6Z8u/un+yPqA/NjAOgJvygIxfCI\nXGMMiw8FA+RX/UNtJBWTr/eJOFRLbQ3xhnmkv3qS1jODtGFrc/ycf+V9GeP2f6GV\nKT1zRoQvoXEurU/LketNnoVr6cIu+dWQXLldJbsvFepw1dIuKlWs3PauFVgiw7cV\n1wioFKcPfYUt7hg5ZpUlK2I8AszgwRQZAACqS8zNc54Q97RbgptL+ua21v4R703H\ndxtuRAWUrDe7uU4HTZucYKqomZI3pS5UbdHxDIupOl6Alot9lfTN/wIDAQABo0Ew\nPzAeBgNVHREEFzAVghN3d3cuZGl2YS1wb3J0YWwub3JnMB0GA1UdDgQWBBQyrnjR\nZLYO63h6dvCxoMPSvgG8FDANBgkqhkiG9w0BAQUFAAOCAQEAbUAQQ0OV0npudm5T\nRjcc/INAcF5fJ2sDejOMWa3unB5XbWHUbPmBmN0vCchVs97QUWVIsHTm6wAjdi0N\nIjW6umykM+aJ0jCRHNwD7wbwet55rHU+pxK3YxRRN5D3JdjN+ttswwNPv83r85o0\ndIEDJtDobA2HT+i6/A2uK2JR7DzpWw2RcG+iCrNmMI9L2YXIs+p5CjS32Pdmn77B\n2C9DSmBXboPTPxfmIOo1S6B4ZEtJ7W2s425lx38v4oEo+TspFAqzTDs8+fTw9/aa\nJ1z0kVcxmvNLpIVh3rlkUQvNycE22FMDlp6sDtIn/KaODR5hKSGHT2Cdk4tpktkh\nH5e8OA==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "www.diva-portal.org", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=www.diva-portal.org", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIDADCCAeigAwIBAgIJALws/Gp4u0qUMA0GCSqGSIb3DQEBBQUAMB4xHDAaBgNV\nBAMTE3d3dy5kaXZhLXBvcnRhbC5vcmcwHhcNMTAwMTI2MTMzMDA0WhcNMjAwMTI0\nMTMzMDA0WjAeMRwwGgYDVQQDExN3d3cuZGl2YS1wb3J0YWwub3JnMIIBIjANBgkq\nhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAxiqePLbYzwDdJ7db9++auHZNsjAhXhpm\nAIfDlpu0ZJ6PdxsRtwT5aQzjTkvBce7JYezri6Z8u/un+yPqA/NjAOgJvygIxfCI\nXGMMiw8FA+RX/UNtJBWTr/eJOFRLbQ3xhnmkv3qS1jODtGFrc/ycf+V9GeP2f6GV\nKT1zRoQvoXEurU/LketNnoVr6cIu+dWQXLldJbsvFepw1dIuKlWs3PauFVgiw7cV\n1wioFKcPfYUt7hg5ZpUlK2I8AszgwRQZAACqS8zNc54Q97RbgptL+ua21v4R703H\ndxtuRAWUrDe7uU4HTZucYKqomZI3pS5UbdHxDIupOl6Alot9lfTN/wIDAQABo0Ew\nPzAeBgNVHREEFzAVghN3d3cuZGl2YS1wb3J0YWwub3JnMB0GA1UdDgQWBBQyrnjR\nZLYO63h6dvCxoMPSvgG8FDANBgkqhkiG9w0BAQUFAAOCAQEAbUAQQ0OV0npudm5T\nRjcc/INAcF5fJ2sDejOMWa3unB5XbWHUbPmBmN0vCchVs97QUWVIsHTm6wAjdi0N\nIjW6umykM+aJ0jCRHNwD7wbwet55rHU+pxK3YxRRN5D3JdjN+ttswwNPv83r85o0\ndIEDJtDobA2HT+i6/A2uK2JR7DzpWw2RcG+iCrNmMI9L2YXIs+p5CjS32Pdmn77B\n2C9DSmBXboPTPxfmIOo1S6B4ZEtJ7W2s425lx38v4oEo+TspFAqzTDs8+fTw9/aa\nJ1z0kVcxmvNLpIVh3rlkUQvNycE22FMDlp6sDtIn/KaODR5hKSGHT2Cdk4tpktkh\nH5e8OA==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://www.diva-portal.org/Shibboleth.sso/NIM/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://www.diva-portal.org/Shibboleth.sso/NIM/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://www.diva-portal.org/Shibboleth.sso/NIM/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://www.diva-portal.org/Shibboleth.sso/NIM/Artifact"
            }
          ]
        }
      ], 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-2.0/www.diva-portal.org-shibboleth.xml"
      }
    }
  ], 
  [
    "https://shibboleth.antagning.se/shibboleth-idp", 
    {
      "entity_id": "https://shibboleth.antagning.se/shibboleth-idp", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-2.0/shibboleth.antagning.se-shibboleth-idp.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibboleth.antagning.se/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibboleth.antagning.se/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibboleth.antagning.se/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibboleth.antagning.se/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "studera.nu", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "display_name": [
                  {
                    "lang": "sv", 
                    "text": "Antagning.se", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }, 
                  {
                    "lang": "en", 
                    "text": "Universityadmissions.se", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "sv", 
                    "text": "Identity Provider f\u00f6r s\u00f6kande med konto i NyA-systemet.", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }, 
                  {
                    "lang": "en", 
                    "text": "The Identity Provider for students with account in the NyA-system.", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIBwjCCAWygAwIBAgIJALANRraT06m8MA0GCSqGSIb3DQEBBQUAMCIxIDAeBgNVBAMTF3NoaWJib2xldGguYW50YWduaW5nLnNlMB4XDTEwMDkxNzEyNDQxN1oXDTIwMDkxNDEyNDQxN1owIjEgMB4GA1UEAxMXc2hpYmJvbGV0aC5hbnRhZ25pbmcuc2UwXDANBgkqhkiG9w0BAQEFAANLADBIAkEAvO4xzF2oRbNcBA1MKuxm6wPaIJQv3HJFA1LuMSSfPao9PUIv86h5LwlG7ptNB5ffUjyrEyNA5GbGCiQ+PzpeeQIDAQABo4GEMIGBMB0GA1UdDgQWBBRxz4/fk7N81wJl0hzH9/t/zCkd9DBSBgNVHSMESzBJgBRxz4/fk7N81wJl0hzH9/t/zCkd9KEmpCQwIjEgMB4GA1UEAxMXc2hpYmJvbGV0aC5hbnRhZ25pbmcuc2WCCQCwDUa2k9OpvDAMBgNVHRMEBTADAQH/MA0GCSqGSIb3DQEBBQUAA0EAtZiOTVSQiLgyDrJAx97tuP3rc2LIj6fpo/Vrh7i/o+8tSfP/Nm0ld1+EphqklGSnDFpU+IkesmgGcgHxAOCB1w==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://shibboleth.antagning.se:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://shibboleth.antagning.se:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://shibboleth.antagning.se:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://shibboleth.antagning.se:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "studera.nu", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIBwjCCAWygAwIBAgIJALANRraT06m8MA0GCSqGSIb3DQEBBQUAMCIxIDAeBgNVBAMTF3NoaWJib2xldGguYW50YWduaW5nLnNlMB4XDTEwMDkxNzEyNDQxN1oXDTIwMDkxNDEyNDQxN1owIjEgMB4GA1UEAxMXc2hpYmJvbGV0aC5hbnRhZ25pbmcuc2UwXDANBgkqhkiG9w0BAQEFAANLADBIAkEAvO4xzF2oRbNcBA1MKuxm6wPaIJQv3HJFA1LuMSSfPao9PUIv86h5LwlG7ptNB5ffUjyrEyNA5GbGCiQ+PzpeeQIDAQABo4GEMIGBMB0GA1UdDgQWBBRxz4/fk7N81wJl0hzH9/t/zCkd9DBSBgNVHSMESzBJgBRxz4/fk7N81wJl0hzH9/t/zCkd9KEmpCQwIjEgMB4GA1UEAxMXc2hpYmJvbGV0aC5hbnRhZ25pbmcuc2WCCQCwDUa2k9OpvDAMBgNVHRMEBTADAQH/MA0GCSqGSIb3DQEBBQUAA0EAtZiOTVSQiLgyDrJAx97tuP3rc2LIj6fpo/Vrh7i/o+8tSfP/Nm0ld1+EphqklGSnDFpU+IkesmgGcgHxAOCB1w==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "UHR", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "sv", 
            "text": "Antagning.se", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }, 
          {
            "lang": "en", 
            "text": "Universityadmissions.se", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.uhr.se", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "company": {
            "text": "Swedish Council for Higher Education", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Company"
          }, 
          "email_address": [
            {
              "text": "appldrift_saml@uhr.se", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://idp.dhbw-mannheim.de/idp/shibboleth", 
    {
      "entity_id": "https://idp.dhbw-mannheim.de/idp/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/idp.dhbw-mannheim.de.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.dhbw-mannheim.de/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.dhbw-mannheim.de/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.dhbw-mannheim.de/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.dhbw-mannheim.de/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "dhbw-mannheim.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "text": "idp.dhbw-mannheim.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=idp.dhbw-mannheim.de,OU=DFN-PKI,O=DFN-Verein,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFDTCCA/WgAwIBAgIED5oe9DANBgkqhkiG9w0BAQUFADBVMQswCQYDVQQGEwJE\nRTETMBEGA1UEChMKREZOLVZlcmVpbjEQMA4GA1UECxMHREZOLVBLSTEfMB0GA1UE\nAxMWREZOLVZlcmVpbiBDQSBTZXJ2aWNlczAeFw0xMDAyMTYxMzQ1MDhaFw0xNTAy\nMTUxMzQ1MDhaMFMxCzAJBgNVBAYTAkRFMRMwEQYDVQQKEwpERk4tVmVyZWluMRAw\nDgYDVQQLEwdERk4tUEtJMR0wGwYDVQQDExRpZHAuZGhidy1tYW5uaGVpbS5kZTCC\nASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAN4HcD6iRl82cDFmVIXVWrt0\nB3mdaeXvAjMwhPP9fwYrjseqCHdB6tGwpM7qGqDqn4oH2cm84Oe5LgsfNEl/de86\nFmG+uwlSO34ztqmgm0fbvssrYUUXDW5sHBdLEcVYfuE7F9FziZ319OAyMfDr0TzA\nQuTx6EskDQi3z6VQDSKd4ecukdzJlPqWXqKSyPgLmBx7cAgi9wLefywxj8MdIy6w\nwYn7EXr2VqxO4FyENLYP3sE4X7OI9cQnjZNpmumMtbYMBsmPlvBrb4zTIBvdeddT\nvnDsAGJnRBwUCSnLSCh181LUd3EouygVKpBC0p1x80x0KLMCAjlrolAKCw8kKRkC\nAwEAAaOCAeUwggHhMAkGA1UdEwQCMAAwCwYDVR0PBAQDAgXgMB0GA1UdJQQWMBQG\nCCsGAQUFBwMCBggrBgEFBQcDATAdBgNVHQ4EFgQUEBW5zFwFRcHimyV0gzL/04l/\nEpUwHwYDVR0jBBgwFoAUHanxhiZ2Tc9d/VCjbuvxvCJ1beswJwYDVR0RBCAwHoEc\nYWFpX3RlY2huaWtAZGhidy1tYW5uaGVpbS5kZTCBkQYDVR0fBIGJMIGGMEGgP6A9\nhjtodHRwOi8vY2RwMS5wY2EuZGZuLmRlL2dsb2JhbC1zZXJ2aWNlcy1jYS9wdWIv\nY3JsL2NhY3JsLmNybDBBoD+gPYY7aHR0cDovL2NkcDIucGNhLmRmbi5kZS9nbG9i\nYWwtc2VydmljZXMtY2EvcHViL2NybC9jYWNybC5jcmwwgaoGCCsGAQUFBwEBBIGd\nMIGaMEsGCCsGAQUFBzAChj9odHRwOi8vY2RwMS5wY2EuZGZuLmRlL2dsb2JhbC1z\nZXJ2aWNlcy1jYS9wdWIvY2FjZXJ0L2NhY2VydC5jcnQwSwYIKwYBBQUHMAKGP2h0\ndHA6Ly9jZHAyLnBjYS5kZm4uZGUvZ2xvYmFsLXNlcnZpY2VzLWNhL3B1Yi9jYWNl\ncnQvY2FjZXJ0LmNydDANBgkqhkiG9w0BAQUFAAOCAQEAMaLUWMFvevF1ZcYO+TMm\nShhWkK7DiZqZ34K/4yqLVZc3JphztPT4ROohQz7xxkAcE8JOiieJCUnGGv4j7q1Z\nu7Enek/8VtFZBCXl/LiE3hH0KNaDEgRS4J+T0slTMGJxNqgPgy09A4xYlXUhznKt\nzFz46kMafDW0djOIzvvaMfkYqd6Px5gjJPiHUfVRMhhMspRSHTAp5aLMhBhznpPo\n7daIwVJjyoLxjm2E2aQ1ICC2uKy+q2qqeQZJB+LNbrYa0i/xtzToa4uD3jnqi/2H\n+hlMbJ6WpFHIBUd4Y1JfW7VEr4Ym1LtRPYYpfE7m0GrM7QPh5ph+YpC6uX2mlIZW\nTw==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://idp.dhbw-mannheim.de:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://idp.dhbw-mannheim.de:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://idp.dhbw-mannheim.de:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://idp.dhbw-mannheim.de:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "dhbw-mannheim.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "text": "idp.dhbw-mannheim.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=idp.dhbw-mannheim.de,OU=DFN-PKI,O=DFN-Verein,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFDTCCA/WgAwIBAgIED5oe9DANBgkqhkiG9w0BAQUFADBVMQswCQYDVQQGEwJE\nRTETMBEGA1UEChMKREZOLVZlcmVpbjEQMA4GA1UECxMHREZOLVBLSTEfMB0GA1UE\nAxMWREZOLVZlcmVpbiBDQSBTZXJ2aWNlczAeFw0xMDAyMTYxMzQ1MDhaFw0xNTAy\nMTUxMzQ1MDhaMFMxCzAJBgNVBAYTAkRFMRMwEQYDVQQKEwpERk4tVmVyZWluMRAw\nDgYDVQQLEwdERk4tUEtJMR0wGwYDVQQDExRpZHAuZGhidy1tYW5uaGVpbS5kZTCC\nASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAN4HcD6iRl82cDFmVIXVWrt0\nB3mdaeXvAjMwhPP9fwYrjseqCHdB6tGwpM7qGqDqn4oH2cm84Oe5LgsfNEl/de86\nFmG+uwlSO34ztqmgm0fbvssrYUUXDW5sHBdLEcVYfuE7F9FziZ319OAyMfDr0TzA\nQuTx6EskDQi3z6VQDSKd4ecukdzJlPqWXqKSyPgLmBx7cAgi9wLefywxj8MdIy6w\nwYn7EXr2VqxO4FyENLYP3sE4X7OI9cQnjZNpmumMtbYMBsmPlvBrb4zTIBvdeddT\nvnDsAGJnRBwUCSnLSCh181LUd3EouygVKpBC0p1x80x0KLMCAjlrolAKCw8kKRkC\nAwEAAaOCAeUwggHhMAkGA1UdEwQCMAAwCwYDVR0PBAQDAgXgMB0GA1UdJQQWMBQG\nCCsGAQUFBwMCBggrBgEFBQcDATAdBgNVHQ4EFgQUEBW5zFwFRcHimyV0gzL/04l/\nEpUwHwYDVR0jBBgwFoAUHanxhiZ2Tc9d/VCjbuvxvCJ1beswJwYDVR0RBCAwHoEc\nYWFpX3RlY2huaWtAZGhidy1tYW5uaGVpbS5kZTCBkQYDVR0fBIGJMIGGMEGgP6A9\nhjtodHRwOi8vY2RwMS5wY2EuZGZuLmRlL2dsb2JhbC1zZXJ2aWNlcy1jYS9wdWIv\nY3JsL2NhY3JsLmNybDBBoD+gPYY7aHR0cDovL2NkcDIucGNhLmRmbi5kZS9nbG9i\nYWwtc2VydmljZXMtY2EvcHViL2NybC9jYWNybC5jcmwwgaoGCCsGAQUFBwEBBIGd\nMIGaMEsGCCsGAQUFBzAChj9odHRwOi8vY2RwMS5wY2EuZGZuLmRlL2dsb2JhbC1z\nZXJ2aWNlcy1jYS9wdWIvY2FjZXJ0L2NhY2VydC5jcnQwSwYIKwYBBQUHMAKGP2h0\ndHA6Ly9jZHAyLnBjYS5kZm4uZGUvZ2xvYmFsLXNlcnZpY2VzLWNhL3B1Yi9jYWNl\ncnQvY2FjZXJ0LmNydDANBgkqhkiG9w0BAQUFAAOCAQEAMaLUWMFvevF1ZcYO+TMm\nShhWkK7DiZqZ34K/4yqLVZc3JphztPT4ROohQz7xxkAcE8JOiieJCUnGGv4j7q1Z\nu7Enek/8VtFZBCXl/LiE3hH0KNaDEgRS4J+T0slTMGJxNqgPgy09A4xYlXUhznKt\nzFz46kMafDW0djOIzvvaMfkYqd6Px5gjJPiHUfVRMhhMspRSHTAp5aLMhBhznpPo\n7daIwVJjyoLxjm2E2aQ1ICC2uKy+q2qqeQZJB+LNbrYa0i/xtzToa4uD3jnqi/2H\n+hlMbJ6WpFHIBUd4Y1JfW7VEr4Ym1LtRPYYpfE7m0GrM7QPh5ph+YpC6uX2mlIZW\nTw==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "de", 
            "text": "DHBW Mannheim IDP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "DHBW Mannheim", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "http://www.dhbw-mannheim.de", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Matthias", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "weinbrenner@dhbw-mannheim.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Weinbrenner", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://cafe.ifpi.edu.br/idp/shibboleth", 
    {
      "entity_id": "https://cafe.ifpi.edu.br/idp/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/cafe.ifpi.edu.br.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://cafe.ifpi.edu.br/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://cafe.ifpi.edu.br/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://cafe.ifpi.edu.br/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://cafe.ifpi.edu.br/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "ifpi.edu.br", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "information_url": [
                  {
                    "lang": "en", 
                    "text": "http://www.ifpi.edu.br/", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "http://www.ifpi.edu.br/", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }
                ], 
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "IFPI - Instituto Federal do Piaui", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "IFPI - Instituto Federal do Piaui", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "en", 
                    "text": "IFPI - Instituto Federal do Piaui", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "IFPI - Instituto Federal do Piaui", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIID0jCCAroCAQAwDQYJKoZIhvcNAQEFBQAwga4xKjAoBgNVBAoTIUlGUEkgLSBJ\nbnN0aXR1dG8gRmVkZXJhbCBkbyBQaWF1aTE1MDMGA1UECxMsRFRJIC0gRGlyZXRv\ncmlhIGRlIFRlY25vbG9naWEgZGEgSW5mb3JtYXRpY2ExETAPBgNVBAcTCFRlcmVz\naW5hMQ4wDAYDVQQIEwVQaWF1aTELMAkGA1UEBhMCQlIxGTAXBgNVBAMTEGNhZmUu\naWZwaS5lZHUuYnIwHhcNMTIwMzA4MTYyNTQyWhcNMTUwMzA4MTYyNTQyWjCBrjEq\nMCgGA1UEChMhSUZQSSAtIEluc3RpdHV0byBGZWRlcmFsIGRvIFBpYXVpMTUwMwYD\nVQQLEyxEVEkgLSBEaXJldG9yaWEgZGUgVGVjbm9sb2dpYSBkYSBJbmZvcm1hdGlj\nYTERMA8GA1UEBxMIVGVyZXNpbmExDjAMBgNVBAgTBVBpYXVpMQswCQYDVQQGEwJC\nUjEZMBcGA1UEAxMQY2FmZS5pZnBpLmVkdS5icjCCASIwDQYJKoZIhvcNAQEBBQAD\nggEPADCCAQoCggEBAMQd7Bb3N4li2CCgKYw+KTPSXGW+YPzKJCu3hPc6ObQzb0CN\ntqnNEX3vA/tBZt7hS7XfCdOuwPvHA8ZdVFTlDx2mQu26KHXN20O2WittOtMiD7pe\nlPsa72/HVPLKUVxhkafhVL5MpJhv4oZf5uLPYVRhx4ZpoAjkXvIVu6eKXunJZ/hL\nqUymk3/Srt6kFLnX2UAEQQcxoLlXNKlUVwNPVjZf5UBRKMckpWCdvW3chSnSmUHg\nMI/ASJzp1Ob2Ef+xsAU5bzIFgaVnGUkaOrPzz3INjerXrtee/g0XZ1qSPEpX+31J\nto0UWMBUjTpF5L519WTOrPZB9NgFFrrE5epG/70CAwEAATANBgkqhkiG9w0BAQUF\nAAOCAQEAHCfbOer/V7b9fUJ61tNCSRb/868nudvWDxy66/iBCUwvhXw9bDWszY0K\nOSP/8qI03Lvyt7/JqR2jqV15VBNrSCv5avGNE/sd/4cv3LGeqyoFTNudQPcrHVf+\nxuv71hJ0LHNzh1PDiklIYzcOzi/bJm3dd4DwxRA7uAqVLZzhi3XywQswgvDFZ1G1\nVnM8IFE6OfIb5b5EkQWQKMJ2i75/YL0Qqi7XUlLb8OYfoxi003HyM5QuJqynea8L\nDOPsk2WAnhI0wZtPxcZv6JKawH3m7/41wUm6EdGO0BPjAamRYFOmNyJthdlJxEDm\n2dFaz6UnNXlYSIMJ6HtpNFz/DQw1zA==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://cafe.ifpi.edu.br:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }, 
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://cafe.ifpi.edu.br:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "pt-br", 
                "text": "http://www.rnp.br/_arquivo/servicos/Politica_CAFe_IDP_final.pdf", 
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy"
              }
            ], 
            "registration_authority": "http://cafe.rnp.br", 
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo", 
            "registration_instant": "2010-01-01T00:00:00Z"
          }
        ]
      }, 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://cafe.ifpi.edu.br:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://cafe.ifpi.edu.br:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "edu.br", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIID0jCCAroCAQAwDQYJKoZIhvcNAQEFBQAwga4xKjAoBgNVBAoTIUlGUEkgLSBJ\nbnN0aXR1dG8gRmVkZXJhbCBkbyBQaWF1aTE1MDMGA1UECxMsRFRJIC0gRGlyZXRv\ncmlhIGRlIFRlY25vbG9naWEgZGEgSW5mb3JtYXRpY2ExETAPBgNVBAcTCFRlcmVz\naW5hMQ4wDAYDVQQIEwVQaWF1aTELMAkGA1UEBhMCQlIxGTAXBgNVBAMTEGNhZmUu\naWZwaS5lZHUuYnIwHhcNMTIwMzA4MTYyNTQyWhcNMTUwMzA4MTYyNTQyWjCBrjEq\nMCgGA1UEChMhSUZQSSAtIEluc3RpdHV0byBGZWRlcmFsIGRvIFBpYXVpMTUwMwYD\nVQQLEyxEVEkgLSBEaXJldG9yaWEgZGUgVGVjbm9sb2dpYSBkYSBJbmZvcm1hdGlj\nYTERMA8GA1UEBxMIVGVyZXNpbmExDjAMBgNVBAgTBVBpYXVpMQswCQYDVQQGEwJC\nUjEZMBcGA1UEAxMQY2FmZS5pZnBpLmVkdS5icjCCASIwDQYJKoZIhvcNAQEBBQAD\nggEPADCCAQoCggEBAMQd7Bb3N4li2CCgKYw+KTPSXGW+YPzKJCu3hPc6ObQzb0CN\ntqnNEX3vA/tBZt7hS7XfCdOuwPvHA8ZdVFTlDx2mQu26KHXN20O2WittOtMiD7pe\nlPsa72/HVPLKUVxhkafhVL5MpJhv4oZf5uLPYVRhx4ZpoAjkXvIVu6eKXunJZ/hL\nqUymk3/Srt6kFLnX2UAEQQcxoLlXNKlUVwNPVjZf5UBRKMckpWCdvW3chSnSmUHg\nMI/ASJzp1Ob2Ef+xsAU5bzIFgaVnGUkaOrPzz3INjerXrtee/g0XZ1qSPEpX+31J\nto0UWMBUjTpF5L519WTOrPZB9NgFFrrE5epG/70CAwEAATANBgkqhkiG9w0BAQUF\nAAOCAQEAHCfbOer/V7b9fUJ61tNCSRb/868nudvWDxy66/iBCUwvhXw9bDWszY0K\nOSP/8qI03Lvyt7/JqR2jqV15VBNrSCv5avGNE/sd/4cv3LGeqyoFTNudQPcrHVf+\nxuv71hJ0LHNzh1PDiklIYzcOzi/bJm3dd4DwxRA7uAqVLZzhi3XywQswgvDFZ1G1\nVnM8IFE6OfIb5b5EkQWQKMJ2i75/YL0Qqi7XUlLb8OYfoxi003HyM5QuJqynea8L\nDOPsk2WAnhI0wZtPxcZv6JKawH3m7/41wUm6EdGO0BPjAamRYFOmNyJthdlJxEDm\n2dFaz6UnNXlYSIMJ6HtpNFz/DQw1zA==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "IFPI - Instituto Federal do Piaui", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }, 
          {
            "lang": "pt-br", 
            "text": "IFPI - Instituto Federal do Piaui", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "IFPI - Instituto Federal do Piaui", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }, 
          {
            "lang": "pt-br", 
            "text": "IFPI - Instituto Federal do Piaui", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.ifpi.edu.br/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }, 
          {
            "lang": "pt-br", 
            "text": "http://www.ifpi.edu.br/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "email_address": [
            {
              "text": "manuel@ifpi.edu.br", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Manuel Goncalves da Silva Neto", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://gallus.scilifelab.se/shibboleth", 
    {
      "entity_id": "https://gallus.scilifelab.se/shibboleth", 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "attribute": [
              {
                "attribute_value": [
                  {
                    "text": "http://www.swamid.se/category/eu-adequate-protection", 
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue", 
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    }
                  }, 
                  {
                    "text": "http://www.swamid.se/category/research-and-education", 
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue", 
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    }
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute", 
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                "name": "http://macedir.org/entity-category"
              }
            ], 
            "__class__": "urn:oasis:names:tc:SAML:metadata:attribute&EntityAttributes"
          }
        ]
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://gallus.scilifelab.se/Shibboleth.sso/SLO/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://gallus.scilifelab.se/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://gallus.scilifelab.se/Shibboleth.sso/SLO/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://gallus.scilifelab.se/Shibboleth.sso/SLO/Artifact"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://gallus.scilifelab.se/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://gallus.scilifelab.se/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://gallus.scilifelab.se/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://gallus.scilifelab.se/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://gallus.scilifelab.se/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://gallus.scilifelab.se/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://gallus.scilifelab.se/Shibboleth.sso/Login"
              }, 
              {
                "index": "2", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://gallus.scilifelab.se/Shibboleth.sso/DS"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "encryption_method": [
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod", 
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#aes128-cbc"
                }, 
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod", 
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#aes192-cbc"
                }, 
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod", 
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#aes256-cbc"
                }, 
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod", 
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#tripledes-cbc"
                }, 
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod", 
                  "algorithm": "http://www.w3.org/2009/xmlenc11#rsa-oaep"
                }, 
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod", 
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p"
                }
              ], 
              "key_info": {
                "key_name": [
                  {
                    "text": "gallus.scilifelab.se", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }, 
                  {
                    "text": "http://gallus.scilifelab.se/", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=gallus.scilifelab.se", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIDITCCAgmgAwIBAgIJAMNm2ATTA3mgMA0GCSqGSIb3DQEBBQUAMB8xHTAbBgNV\nBAMTFGdhbGx1cy5zY2lsaWZlbGFiLnNlMB4XDTEyMDgwNjExNDIwN1oXDTIyMDgw\nNDExNDIwN1owHzEdMBsGA1UEAxMUZ2FsbHVzLnNjaWxpZmVsYWIuc2UwggEiMA0G\nCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDJ5UUWP6K/vHk6+uLJPsuNDRxvSi/C\nyjL6e8OevDofr5REK3Ttuhq+qvFwlSUDqHCzeGZxH819Xwok5gJasLf4KKlV6k6H\nuSaRN/njMDwBjloUyja1P/ja5LgFmzly4Pm3VnKIw4MTxeXlLRhEDOSDv303Wp6e\nZpS/vNDkkZbEYpM4iMh6FQM2sIb6EaHYXnicYd4k+1fnWiCiuydG23emvGHmT5Tn\nrOFYI1LSpLGBwkwlM1FDoPCufWYhweHg4LuiUPmbxlQEdJOqy6JrqvFYrYPRV3UR\ntE/OBJ2Ld8L07xlL0o7b8q9+2ccU2ad6XmEs29YsnaMOCvqCBs1GPgH5AgMBAAGj\nYDBeMD0GA1UdEQQ2MDSCFGdhbGx1cy5zY2lsaWZlbGFiLnNlhhxodHRwOi8vZ2Fs\nbHVzLnNjaWxpZmVsYWIuc2UvMB0GA1UdDgQWBBSvHdjNMd+O6sjfHQTrJmhBVxRh\nqzANBgkqhkiG9w0BAQUFAAOCAQEAgzfV6iPbPgfPuWa+/faIYEFV2eKtjzQb74f+\nFe9SYZtBlKtXIPo5oJCx22oh3sDcSJtklRrp+HtVY7Op1sHxaKhEOWjq5hJrrp+9\npRVTnJVCtaIUBcajWMwfG2O1H8Tkpetnj/8qLDaTW0Fd3pF9e4vsIAs66/knJ9bT\nwiCijozckPEz8KVGgW/4TLB8F8ErIHDWVFU4cSezFknpqfe/qPWnCA3E/JVrJhki\nyJdT9GhQ6NTeXbhHS6otn+MTJrWd1kB2hT417PEcHZQO4bbyMWZjsNFgd0haIcOh\nqR3yqb2bdeQUWqkU0/5RA1uDcK8D+f2xAC2npJVHTd1a+1rKgA==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://gallus.scilifelab.se/Shibboleth.sso/Artifact/SOAP"
            }
          ], 
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://gallus.scilifelab.se/Shibboleth.sso/NIM/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://gallus.scilifelab.se/Shibboleth.sso/NIM/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://gallus.scilifelab.se/Shibboleth.sso/NIM/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://gallus.scilifelab.se/Shibboleth.sso/NIM/Artifact"
            }
          ]
        }
      ], 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-2.0/gallus.scilifelab.se-shibboleth.xml"
      }
    }
  ], 
  [
    "https://www.ifmsa.se/sp", 
    {
      "entity_id": "https://www.ifmsa.se/sp", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-2.0/www.ifmsa.se-sp.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "attribute": [
              {
                "attribute_value": [
                  {
                    "text": "http://www.swamid.se/category/eu-adequate-protection", 
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue", 
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    }
                  }, 
                  {
                    "text": "http://www.swamid.se/category/research-and-education", 
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue", 
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    }
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute", 
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                "name": "http://macedir.org/entity-category"
              }
            ], 
            "__class__": "urn:oasis:names:tc:SAML:metadata:attribute&EntityAttributes"
          }
        ]
      }, 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "IFMSA-Sweden", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "IFMSA-Sweden", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.ifmsa.se", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://www.ifmsa.se/Shibboleth.sso/SLO/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://www.ifmsa.se/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://www.ifmsa.se/Shibboleth.sso/SLO/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://www.ifmsa.se/Shibboleth.sso/SLO/Artifact"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.ifmsa.se/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.ifmsa.se/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.ifmsa.se/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.ifmsa.se/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.ifmsa.se/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.ifmsa.se/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://www.ifmsa.se/Shibboleth.sso/DS/ds.swamid.se"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "text": "ifmsa.se", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=ifmsa.se", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIC3zCCAcegAwIBAgIJAJSL4oXsFFGDMA0GCSqGSIb3DQEBBQUAMBMxETAPBgNV\nBAMTCGlmbXNhLnNlMB4XDTEyMDkwNjEyMjYxNloXDTIyMDkwNDEyMjYxNlowEzER\nMA8GA1UEAxMIaWZtc2Euc2UwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIB\nAQDBiLhwVpqbr3rI7WcjH4MId7XxuayfJjSCt//kzKVQvMetGh302UQ8YdveRIic\ntIjQ4fjuF2F+GUJyC4nEX3zdsQusCbRA7Dq70K1d5qkT1qvh0leYWBrr2XbXZCIQ\n4/tl4uEHJyXKP5vgWXjqf2mBIYHNsIy068JVfH1dGZ+zBr7H5cebMRG9r/aC90Yl\nWvZ24qFRmCuNGp+pP5/H/jm0ZnQ38QzHF9WCmWfDuL4p+5PBxOab5LCEaT6113MN\n5mOBwbjcFozKzZ2lAX3F0c9K0FqdBxm7hHFm40smzjnnFsgu5TtBIH5Sjgw61QZB\nMzNfuDlKJ6Wt8bjrytYOrNsJAgMBAAGjNjA0MBMGA1UdEQQMMAqCCGlmbXNhLnNl\nMB0GA1UdDgQWBBQSYXjcmZHvwcBTDE45NlQOMwy4UjANBgkqhkiG9w0BAQUFAAOC\nAQEAZRggMXTdRBuNvZFmjYbrDmRgDEdmbaAQ0mfkfD0imSulc39RRq3+9uaRzmTl\n/uThMJwgFtIjrEChsh8Gv0nzk6SuXGwTPybu0wPBBCP1TRZgKl6oGaWUK8kpBy6g\ntkBxI6tIDSkEFpG2CP+Sj6MFYNeI8p2+GuhiAyW1X6bKnIIO7aSgdhU9fV1/mMzt\nMcQYhqSDMw8qGAXKxF3942Ft3gXvnstP3X8l5LM2Ypih/ZDo4PUwUyiEw3RQUXKz\nX40wJ5KGvRmsxTM5VbkQ8wS7EWuIkQG/iXCyD+b1BExCsuXvX3nN24bsBLUtV8wE\n2qw2QAI6MLkoVEpC6c1oX0xn+Q==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://www.ifmsa.se/Shibboleth.sso/Artifact/SOAP"
            }
          ], 
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://www.ifmsa.se/Shibboleth.sso/NIM/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://www.ifmsa.se/Shibboleth.sso/NIM/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://www.ifmsa.se/Shibboleth.sso/NIM/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://www.ifmsa.se/Shibboleth.sso/NIM/Artifact"
            }
          ]
        }
      ], 
      "contact_person": [
        {
          "contact_type": "technical", 
          "company": {
            "text": "IFMSA-Sweden", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Company"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "sur_name": {
            "text": "Liu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "given_name": {
            "text": "Mats", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "admin@ifmsa.se", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ]
        }, 
        {
          "contact_type": "administrative", 
          "company": {
            "text": "IFMSA-Sweden", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Company"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "sur_name": {
            "text": "Liu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "given_name": {
            "text": "Mats", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "admin@ifmsa.se", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://shib.ufg.br/idp/shibboleth", 
    {
      "entity_id": "https://shib.ufg.br/idp/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/shib.ufg.br.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shib.ufg.br/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shib.ufg.br/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shib.ufg.br/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shib.ufg.br/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "ufg.br", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "information_url": [
                  {
                    "lang": "en", 
                    "text": "http://www.ufg.br/", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "http://www.ufg.br/", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }
                ], 
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "UFG - Universidade Federal de Goias", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "UFG - Universidade Federal de Goias", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "en", 
                    "text": "UFG - Universidade Federal de Goias", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "UFG - Universidade Federal de Goias", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIEGDCCAwACAQAwDQYJKoZIhvcNAQEFBQAwgdExLTArBgNVBAoUJFVGRyAtIFVu\naXZlcnNpZGFkZSBGZWRlcmFsIGRlIEdvacOhczE0MDIGA1UECxMrQ0VSQ09NUCAt\nIENlbnRybyBkZSBSZWN1cnNvcyBDb21wdXRhY2lvbmFpczEjMCEGCSqGSIb3DQEJ\nARYUcmVkZXNAY2VyY29tcC51ZmcuYnIxETAPBgNVBAcUCEdvacOibmlhMQ8wDQYD\nVQQIFAZHb2nDoXMxCzAJBgNVBAYTAkJSMRQwEgYDVQQDEwtzaGliLnVmZy5icjAe\nFw0xMTAzMTAxOTQ2MzZaFw0xNDAzMDkxOTQ2MzZaMIHRMS0wKwYDVQQKFCRVRkcg\nLSBVbml2ZXJzaWRhZGUgRmVkZXJhbCBkZSBHb2nDoXMxNDAyBgNVBAsTK0NFUkNP\nTVAgLSBDZW50cm8gZGUgUmVjdXJzb3MgQ29tcHV0YWNpb25haXMxIzAhBgkqhkiG\n9w0BCQEWFHJlZGVzQGNlcmNvbXAudWZnLmJyMREwDwYDVQQHFAhHb2nDom5pYTEP\nMA0GA1UECBQGR29pw6FzMQswCQYDVQQGEwJCUjEUMBIGA1UEAxMLc2hpYi51Zmcu\nYnIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDjd7v1zv9XiZujENay\nVRf+lRcFHvUq3KtLFWnys3UhsAlQPiXl3rCdCV3qgC3mLFKoQtCIvxW0ubaX7E+7\nU1FGdLZHZBgkCXdvJ32wMtF/DEhiD/AwT6JMjSWLcE9eGK35NBaB6kC91Pn9oID8\nOjggQmFAot2NQ7KRlSNJg3nY3RQYCFZghgsLec9+0h/YHaRuKgDKcFnreAQ9UQ4M\n4Q1jPKitFkn/IJa2okSwXIu6gwV/2Y2I92ar3LgbNfpXCPW/gGqflkPEA+4AXwRb\n7ZbOdqsDg/PLMzi3jS4VHIOVUHx4fg7PZF+CEJpNG65i5pQB2d9VI2he2e3gUtnY\nxZeBAgMBAAEwDQYJKoZIhvcNAQEFBQADggEBAJSsyw+/FRhaSSFPutZN5upO6q/A\nlrui0K4WMGeEh6mJmZu2vX1MB2H7ljxtxZ2I1Gmi4/oNzLzzz4o4lglpN0jnnWx0\nVBZYB+hVNrn03riHaAj9lB4H0IvPGkjsz5j0WM/1To5Mi6iFY+1ac+1p2oFdIWLX\nvoqnzQVYm+5/3zSbVVYFRE5YA655K80+D5F1CxGaaSeEl61lX8G3ncyLJ8GjGQy7\nEuXcPceE+fwojuBV3wZl5Hl6OkeoB9sS+7zuPyc7TWTLxCsrWHRDWlRtargNuxPn\n2KF7d+EaJHILB9sC/ESy/4TMy+XvpU/T1ylvRR2+bW24nPGKHuGuqmETC6I=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://shib.ufg.br:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }, 
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://shib.ufg.br:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "pt-br", 
                "text": "http://www.rnp.br/_arquivo/servicos/Politica_CAFe_IDP_final.pdf", 
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy"
              }
            ], 
            "registration_authority": "http://cafe.rnp.br", 
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo", 
            "registration_instant": "2010-01-01T00:00:00Z"
          }
        ]
      }, 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://shib.ufg.br:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://shib.ufg.br:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "ufg.br", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIEGDCCAwACAQAwDQYJKoZIhvcNAQEFBQAwgdExLTArBgNVBAoUJFVGRyAtIFVu\naXZlcnNpZGFkZSBGZWRlcmFsIGRlIEdvacOhczE0MDIGA1UECxMrQ0VSQ09NUCAt\nIENlbnRybyBkZSBSZWN1cnNvcyBDb21wdXRhY2lvbmFpczEjMCEGCSqGSIb3DQEJ\nARYUcmVkZXNAY2VyY29tcC51ZmcuYnIxETAPBgNVBAcUCEdvacOibmlhMQ8wDQYD\nVQQIFAZHb2nDoXMxCzAJBgNVBAYTAkJSMRQwEgYDVQQDEwtzaGliLnVmZy5icjAe\nFw0xMTAzMTAxOTQ2MzZaFw0xNDAzMDkxOTQ2MzZaMIHRMS0wKwYDVQQKFCRVRkcg\nLSBVbml2ZXJzaWRhZGUgRmVkZXJhbCBkZSBHb2nDoXMxNDAyBgNVBAsTK0NFUkNP\nTVAgLSBDZW50cm8gZGUgUmVjdXJzb3MgQ29tcHV0YWNpb25haXMxIzAhBgkqhkiG\n9w0BCQEWFHJlZGVzQGNlcmNvbXAudWZnLmJyMREwDwYDVQQHFAhHb2nDom5pYTEP\nMA0GA1UECBQGR29pw6FzMQswCQYDVQQGEwJCUjEUMBIGA1UEAxMLc2hpYi51Zmcu\nYnIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDjd7v1zv9XiZujENay\nVRf+lRcFHvUq3KtLFWnys3UhsAlQPiXl3rCdCV3qgC3mLFKoQtCIvxW0ubaX7E+7\nU1FGdLZHZBgkCXdvJ32wMtF/DEhiD/AwT6JMjSWLcE9eGK35NBaB6kC91Pn9oID8\nOjggQmFAot2NQ7KRlSNJg3nY3RQYCFZghgsLec9+0h/YHaRuKgDKcFnreAQ9UQ4M\n4Q1jPKitFkn/IJa2okSwXIu6gwV/2Y2I92ar3LgbNfpXCPW/gGqflkPEA+4AXwRb\n7ZbOdqsDg/PLMzi3jS4VHIOVUHx4fg7PZF+CEJpNG65i5pQB2d9VI2he2e3gUtnY\nxZeBAgMBAAEwDQYJKoZIhvcNAQEFBQADggEBAJSsyw+/FRhaSSFPutZN5upO6q/A\nlrui0K4WMGeEh6mJmZu2vX1MB2H7ljxtxZ2I1Gmi4/oNzLzzz4o4lglpN0jnnWx0\nVBZYB+hVNrn03riHaAj9lB4H0IvPGkjsz5j0WM/1To5Mi6iFY+1ac+1p2oFdIWLX\nvoqnzQVYm+5/3zSbVVYFRE5YA655K80+D5F1CxGaaSeEl61lX8G3ncyLJ8GjGQy7\nEuXcPceE+fwojuBV3wZl5Hl6OkeoB9sS+7zuPyc7TWTLxCsrWHRDWlRtargNuxPn\n2KF7d+EaJHILB9sC/ESy/4TMy+XvpU/T1ylvRR2+bW24nPGKHuGuqmETC6I=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "UFG - Universidade Federal de Goias", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }, 
          {
            "lang": "pt-br", 
            "text": "UFG - Universidade Federal de Goias", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "UFG - Universidade Federal de Goias", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }, 
          {
            "lang": "pt-br", 
            "text": "UFG - Universidade Federal de Goias", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.ufg.br/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }, 
          {
            "lang": "pt-br", 
            "text": "http://www.ufg.br/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "email_address": [
            {
              "text": "douglasfilho@cercomp.ufg.br", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Douglas Borges de Oliveira Filho", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://foodl.org/simplesaml/module.php/saml/sp/metadata.php/saml", 
    {
      "entity_id": "https://foodl.org/simplesaml/module.php/saml/sp/metadata.php/saml", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/foodl.org.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "attribute": [
              {
                "attribute_value": [
                  {
                    "text": "http://www.geant.net/uri/dataprotection-code-of-conduct/v1", 
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue", 
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    }
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute", 
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                "name": "http://macedir.org/entity-category"
              }
            ], 
            "__class__": "urn:oasis:names:tc:SAML:metadata:attribute&EntityAttributes"
          }, 
          {
            "registration_policy": [
              {
                "lang": "en", 
                "text": "http://www.feide.no/files/feide/metadata-registration-practice-statement.pdf", 
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy"
              }
            ], 
            "registration_authority": "http://feide.no/", 
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo", 
            "registration_instant": "2011-05-05T06:16:34Z"
          }
        ]
      }, 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "UNINETT", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }, 
          {
            "lang": "no", 
            "text": "UNINETT", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "UNINETT", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }, 
          {
            "lang": "no", 
            "text": "UNINETT", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.uninett.no/english", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }, 
          {
            "lang": "no", 
            "text": "http://www.uninett.no/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://foodl.org/simplesaml/module.php/saml/sp/saml2-logout.php/saml"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "0", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://foodl.org/simplesaml/module.php/saml/sp/saml2-acs.php/saml"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "logo": [
                  {
                    "text": "https://foodl.org/res/foodle_logo.png", 
                    "width": "187", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo", 
                    "height": "58"
                  }
                ], 
                "privacy_statement_url": [
                  {
                    "lang": "en", 
                    "text": "https://rnd.feide.no/software/foodle/foodle-privacy-policy/", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&PrivacyStatementURL"
                  }
                ], 
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Foodle", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }, 
                  {
                    "lang": "no", 
                    "text": "Foodle", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }, 
                  {
                    "lang": "nn", 
                    "text": "Foodle", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "en", 
                    "text": "Foodle is a generic poll and survey tool for deciding meeting dates.", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }, 
                  {
                    "lang": "no", 
                    "text": "Foodle er et generisk poll og survey verkt\u00f8y for \u00e5 bli enige om m\u00f8tedatoer.", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }, 
                  {
                    "lang": "nn", 
                    "text": "Foodle er eit generisk poll- og survey-verkt\u00f8y for \u00e5 verte einige om m\u00f8tedatoar.", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIEAzCCAuugAwIBAgIJAN6InyocvS6WMA0GCSqGSIb3DQEBBQUAMF4xCzAJBgNVBAYTAk5PMRIwEAYDVQQIEwlUcm9uZGhlaW0xEjAQBgNVBAcTCVRyb25kaGVpbTETMBEGA1UEChMKVU5JTkVUVCBBUzESMBAGA1UEAxMJZm9vZGwub3JnMB4XDTEzMTExNTA3MzAzN1oXDTIzMTExNTA3MzAzN1owXjELMAkGA1UEBhMCTk8xEjAQBgNVBAgTCVRyb25kaGVpbTESMBAGA1UEBxMJVHJvbmRoZWltMRMwEQYDVQQKEwpVTklORVRUIEFTMRIwEAYDVQQDEwlmb29kbC5vcmcwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCs9ZRmG1+NCOVT3GA3rSoK2iv4hJg7XLlVWGZgd1YVV07msCVrioenq5EBUQHFf5BZbmDuiml0CTjM2qEXxbgII2KIOtBUsofe9S9qXXErBksVc5mRZrOBg93tYo5yGS2tWglaGra2zdkYpgVOD9CRR+cwWy1eGG9aZwGzBOQ9SJFA47jKtveJhfSedKDYc9ecEHVBS6VYP1rzPBurCSp/zxQmR78GHl7hHiLhoZkuHE2K0X5G3f9dzv+5iJJtyGJoRvSM+m0s+w5j0DMXb/4qCfiDpXnf2O/LIUFdnQZDZcGWHiec2oNcpnBODWdKmVoKH3FwTUPXpKlrtKxzTp0XAgMBAAGjgcMwgcAwHQYDVR0OBBYEFNlwjQzSL6Oy0QdRww1HZY3rFV+aMIGQBgNVHSMEgYgwgYWAFNlwjQzSL6Oy0QdRww1HZY3rFV+aoWKkYDBeMQswCQYDVQQGEwJOTzESMBAGA1UECBMJVHJvbmRoZWltMRIwEAYDVQQHEwlUcm9uZGhlaW0xEzARBgNVBAoTClVOSU5FVFQgQVMxEjAQBgNVBAMTCWZvb2RsLm9yZ4IJAN6InyocvS6WMAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEFBQADggEBAFtWxCyhzpjsGnCARlZPCOR1SPLwDnJjbyrX0pJ+ESfY+kPi41G658WAsu2xxvNgOoV3aas66b1llCtCUBjRyXRCCHZP87nXpmXZMSqD7XNEBB70HoD2KAQ0U7yM/gPNFRTqxKtEKTH7EV9Uv++eYfLusPLq++l+pwkOcsgAFlEkCwr/6QZl54G+WnSlCyuHH4UDUu+e/TJgQoA4/a6GyMO1YBMyHQY8TblE8yfkogzvpgqBHp4EXjc7rvMJpcARmbMT69c0OQ+OoJqooa+pzSJ8WlckT/Kv8YDB/SZTDO38ZAOcwHF74LvVUCqN24kEFkf94mvMMCiZyE5djOyNxhY=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "encryption", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIEAzCCAuugAwIBAgIJAN6InyocvS6WMA0GCSqGSIb3DQEBBQUAMF4xCzAJBgNVBAYTAk5PMRIwEAYDVQQIEwlUcm9uZGhlaW0xEjAQBgNVBAcTCVRyb25kaGVpbTETMBEGA1UEChMKVU5JTkVUVCBBUzESMBAGA1UEAxMJZm9vZGwub3JnMB4XDTEzMTExNTA3MzAzN1oXDTIzMTExNTA3MzAzN1owXjELMAkGA1UEBhMCTk8xEjAQBgNVBAgTCVRyb25kaGVpbTESMBAGA1UEBxMJVHJvbmRoZWltMRMwEQYDVQQKEwpVTklORVRUIEFTMRIwEAYDVQQDEwlmb29kbC5vcmcwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCs9ZRmG1+NCOVT3GA3rSoK2iv4hJg7XLlVWGZgd1YVV07msCVrioenq5EBUQHFf5BZbmDuiml0CTjM2qEXxbgII2KIOtBUsofe9S9qXXErBksVc5mRZrOBg93tYo5yGS2tWglaGra2zdkYpgVOD9CRR+cwWy1eGG9aZwGzBOQ9SJFA47jKtveJhfSedKDYc9ecEHVBS6VYP1rzPBurCSp/zxQmR78GHl7hHiLhoZkuHE2K0X5G3f9dzv+5iJJtyGJoRvSM+m0s+w5j0DMXb/4qCfiDpXnf2O/LIUFdnQZDZcGWHiec2oNcpnBODWdKmVoKH3FwTUPXpKlrtKxzTp0XAgMBAAGjgcMwgcAwHQYDVR0OBBYEFNlwjQzSL6Oy0QdRww1HZY3rFV+aMIGQBgNVHSMEgYgwgYWAFNlwjQzSL6Oy0QdRww1HZY3rFV+aoWKkYDBeMQswCQYDVQQGEwJOTzESMBAGA1UECBMJVHJvbmRoZWltMRIwEAYDVQQHEwlUcm9uZGhlaW0xEzARBgNVBAoTClVOSU5FVFQgQVMxEjAQBgNVBAMTCWZvb2RsLm9yZ4IJAN6InyocvS6WMAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEFBQADggEBAFtWxCyhzpjsGnCARlZPCOR1SPLwDnJjbyrX0pJ+ESfY+kPi41G658WAsu2xxvNgOoV3aas66b1llCtCUBjRyXRCCHZP87nXpmXZMSqD7XNEBB70HoD2KAQ0U7yM/gPNFRTqxKtEKTH7EV9Uv++eYfLusPLq++l+pwkOcsgAFlEkCwr/6QZl54G+WnSlCyuHH4UDUu+e/TJgQoA4/a6GyMO1YBMyHQY8TblE8yfkogzvpgqBHp4EXjc7rvMJpcARmbMT69c0OQ+OoJqooa+pzSJ8WlckT/Kv8YDB/SZTDO38ZAOcwHF74LvVUCqN24kEFkf94mvMMCiZyE5djOyNxhY=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "attribute_consuming_service": [
            {
              "index": "0", 
              "service_description": [
                {
                  "lang": "en", 
                  "text": "Foodle is a generic poll and survey tool for deciding meeting dates.", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription"
                }, 
                {
                  "lang": "no", 
                  "text": "Foodle er et generisk poll og survey verkt\u00f8y for \u00e5 bli enige om m\u00f8tedatoer.", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription"
                }, 
                {
                  "lang": "nn", 
                  "text": "Foodle er eit generisk poll- og survey-verkt\u00f8y for \u00e5 verte einige om m\u00f8tedatoar.", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription"
                }
              ], 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService", 
              "requested_attribute": [
                {
                  "is_required": "true", 
                  "friendly_name": "mail", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:0.9.2342.19200300.100.1.3"
                }, 
                {
                  "friendly_name": "eduPersonPrincipalName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.6"
                }, 
                {
                  "friendly_name": "eduPersonTargetedID", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.10"
                }, 
                {
                  "friendly_name": "displayName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.16.840.1.113730.3.1.241"
                }, 
                {
                  "friendly_name": "preferredLanguage", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.16.840.1.113730.3.1.39"
                }, 
                {
                  "friendly_name": "cn", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.5.4.3"
                }, 
                {
                  "friendly_name": "sn", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.5.4.4"
                }, 
                {
                  "friendly_name": "givenName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.5.4.42"
                }
              ], 
              "service_name": [
                {
                  "lang": "en", 
                  "text": "Foodle", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }
              ]
            }
          ]
        }
      ], 
      "contact_person": [
        {
          "given_name": {
            "text": "Feide Support", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "support@feide.no", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://idp.hgo.se/idp/shibboleth", 
    {
      "entity_id": "https://idp.hgo.se/idp/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-2.0-obsolete/idp.hgo.se-idp-shibboleth.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.hgo.se/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.hgo.se/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.hgo.se/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.hgo.se/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "hgo.se", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDWDCCAkCgAwIBAgIES4+8uzANBgkqhkiG9w0BAQUFADBuMQswCQYDVQQGEwJT\nRTEQMA4GA1UECBMHR290bGFuZDEOMAwGA1UEBxMFVmlzYnkxCzAJBgNVBAoTAklU\nMRswGQYDVQQLExJHb3RsYW5kIFVuaXZlcnNpdHkxEzARBgNVBAMTCmlkcC5oZ28u\nc2UwHhcNMTAwMzA0MTM1OTIzWhcNMjAwMzAxMTM1OTIzWjBuMQswCQYDVQQGEwJT\nRTEQMA4GA1UECBMHR290bGFuZDEOMAwGA1UEBxMFVmlzYnkxCzAJBgNVBAoTAklU\nMRswGQYDVQQLExJHb3RsYW5kIFVuaXZlcnNpdHkxEzARBgNVBAMTCmlkcC5oZ28u\nc2UwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDZMqgS3wqDLOKVwYHG\n5FRrM13gk+lP+Alm45T0pK192Cl3OWildw4qNiMv10oocbZUoE9PFn6PESSwF6Nt\n2nm3um4ePSbzowYwGOuRLQJfXj4FK3Dj2PO1OLD7oK4VXgka+kG93/oyEaeSfe3t\n93eFgp8bb58b42ED/CAcxvGzcHHyG0WzFTtO3hSuscy/6BKEekVefQJfpPnCuuMN\n2NothDvL+IHO7+DXMeHfH56L1P4fLz+jSMCL2hXGuZxc1f/+l9b4VpegUQx9IGk2\nRspt3CtOHDI7hhUu5xlbxad0uyAu34dMOz/6jB3UDHYTOEoCjBGhf8RE9zeWFT5D\nVXhtAgMBAAEwDQYJKoZIhvcNAQEFBQADggEBAIZdx0R84klmPoZq7uMPh1pPJ76X\n2xpmzCoxhRqjq2Uy9HKfiu9pwo21H9w+PvXhUtdsTInAAhPl1khupPzV/uJeCybl\nmbgtQgNr5UnLtfNz7GQD0EXe0UuC+bP+Qrl6NrCke73MCOLITajJ4ggdfdF3C55e\nG1kXEv3DPMpB8tRlcf4W3fT9ZKR+6zzSOkvuMzLIzv1UBTxUas19DYYNzE3+u/9Q\n8IHjPqr0JsKZiNBRofXwLZ6y2xztQqBVDmV4yNoOLNUDDOFHYwiuR1aAJ2rNoOF7\nUTU+mTp7woVtJsWWGJRG1iDB7UxpIHdPwDBDPEfxlw11kdJ+HIyaYCrQL4A=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://idp.hgo.se:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://idp.hgo.se:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://idp.hgo.se:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://idp.hgo.se:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "hgo.se", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDWDCCAkCgAwIBAgIES4+8uzANBgkqhkiG9w0BAQUFADBuMQswCQYDVQQGEwJT\nRTEQMA4GA1UECBMHR290bGFuZDEOMAwGA1UEBxMFVmlzYnkxCzAJBgNVBAoTAklU\nMRswGQYDVQQLExJHb3RsYW5kIFVuaXZlcnNpdHkxEzARBgNVBAMTCmlkcC5oZ28u\nc2UwHhcNMTAwMzA0MTM1OTIzWhcNMjAwMzAxMTM1OTIzWjBuMQswCQYDVQQGEwJT\nRTEQMA4GA1UECBMHR290bGFuZDEOMAwGA1UEBxMFVmlzYnkxCzAJBgNVBAoTAklU\nMRswGQYDVQQLExJHb3RsYW5kIFVuaXZlcnNpdHkxEzARBgNVBAMTCmlkcC5oZ28u\nc2UwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDZMqgS3wqDLOKVwYHG\n5FRrM13gk+lP+Alm45T0pK192Cl3OWildw4qNiMv10oocbZUoE9PFn6PESSwF6Nt\n2nm3um4ePSbzowYwGOuRLQJfXj4FK3Dj2PO1OLD7oK4VXgka+kG93/oyEaeSfe3t\n93eFgp8bb58b42ED/CAcxvGzcHHyG0WzFTtO3hSuscy/6BKEekVefQJfpPnCuuMN\n2NothDvL+IHO7+DXMeHfH56L1P4fLz+jSMCL2hXGuZxc1f/+l9b4VpegUQx9IGk2\nRspt3CtOHDI7hhUu5xlbxad0uyAu34dMOz/6jB3UDHYTOEoCjBGhf8RE9zeWFT5D\nVXhtAgMBAAEwDQYJKoZIhvcNAQEFBQADggEBAIZdx0R84klmPoZq7uMPh1pPJ76X\n2xpmzCoxhRqjq2Uy9HKfiu9pwo21H9w+PvXhUtdsTInAAhPl1khupPzV/uJeCybl\nmbgtQgNr5UnLtfNz7GQD0EXe0UuC+bP+Qrl6NrCke73MCOLITajJ4ggdfdF3C55e\nG1kXEv3DPMpB8tRlcf4W3fT9ZKR+6zzSOkvuMzLIzv1UBTxUas19DYYNzE3+u/9Q\n8IHjPqr0JsKZiNBRofXwLZ6y2xztQqBVDmV4yNoOLNUDDOFHYwiuR1aAJ2rNoOF7\nUTU+mTp7woVtJsWWGJRG1iDB7UxpIHdPwDBDPEfxlw11kdJ+HIyaYCrQL4A=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "HGO", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "sv", 
            "text": "H\u00f6gskolan p\u00e5 Gotland", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }, 
          {
            "lang": "en", 
            "text": "H\u00f6gskolan p\u00e5 Gotland", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.hgo.se", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Joacim", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "joacim.breiler@hgo.se", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Breiler", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://shib-idp.cms.hu-berlin.de/idp/shibboleth", 
    {
      "entity_id": "https://shib-idp.cms.hu-berlin.de/idp/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/shib-idp.cms.hu-berlin.de.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "single_logout_service": [
            {
              "response_location": "https://shib-idp.cms.hu-berlin.de/idp/profile/SAML2/Redirect/SLO", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://shib-idp.cms.hu-berlin.de/idp/profile/SAML2/Redirect/SLO"
            }, 
            {
              "response_location": "https://shib-idp.cms.hu-berlin.de/idp/profile/SAML2/POST/SLO", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://shib-idp.cms.hu-berlin.de/idp/profile/SAML2/POST/SLO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://shib-idp.cms.hu-berlin.de:8443/idp/profile/SAML2/SOAP/SLO"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shib-idp.cms.hu-berlin.de/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shib-idp.cms.hu-berlin.de/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shib-idp.cms.hu-berlin.de/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shib-idp.cms.hu-berlin.de/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "hu-berlin.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "information_url": [
                  {
                    "lang": "de", 
                    "text": "http://www.hu-berlin.de/", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }, 
                  {
                    "lang": "en", 
                    "text": "http://www.hu-berlin.de/", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }
                ], 
                "display_name": [
                  {
                    "lang": "de", 
                    "text": "Humboldt-Universit\u00e4t zu Berlin", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }, 
                  {
                    "lang": "en", 
                    "text": "Humboldt-Universit\u00e4t zu Berlin", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "de", 
                    "text": "IdP der Humboldt-Universit\u00e4t zu Berlin", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }, 
                  {
                    "lang": "en", 
                    "text": "IdP der Humboldt-Universit\u00e4t zu Berlin", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "text": "shibboleth.uvf.hu-berlin.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=shibboleth.uvf.hu-berlin.de,OU=ZE Computer- und Medienservice,O=Humboldt-Universitaet zu Berlin,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFzTCCBLWgAwIBAgIHEqpQbkSDdTANBgkqhkiG9w0BAQUFADBoMQswCQYDVQQG\nEwJERTEoMCYGA1UEChMfSHVtYm9sZHQtVW5pdmVyc2l0YWV0IHp1IEJlcmxpbjEO\nMAwGA1UEAxMFSFUtQ0ExHzAdBgkqhkiG9w0BCQEWEHBraUBodS1iZXJsaW4uZGUw\nHhcNMTExMDA0MDkzMzE5WhcNMTYxMDAyMDkzMzE5WjCBhjELMAkGA1UEBhMCREUx\nKDAmBgNVBAoTH0h1bWJvbGR0LVVuaXZlcnNpdGFldCB6dSBCZXJsaW4xJzAlBgNV\nBAsTHlpFIENvbXB1dGVyLSB1bmQgTWVkaWVuc2VydmljZTEkMCIGA1UEAxMbc2hp\nYmJvbGV0aC51dmYuaHUtYmVybGluLmRlMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8A\nMIIBCgKCAQEA0vBDQzp17iY3EpgON9nw4NprsoHn0GtfkzmL2t1yYRW5U67hdMNg\ntrTQ2OHpD5Yzk2zi88L1y0aRBIsWV/DvvPM+k3NkUKfD5hDrPogHphvUvjIvJG4A\n3oDpb4Tx7TmF1ZBe1M2+xeQ+MhaUrbM8JDcRdgtScgWrEp3qkLY/xMRjVsv6sPbw\n3m3BS2Kayg7Y11d0HCuPYXM8c6dtOSNNKAUYA1IG8FkhtAEVo86goCGETYLQxGLb\nCXfeNg7G8jrKa8NUN0+mOdnpvBX7jSVGSKTYsH3C8QPkMEkYOBCq++WoCDQGIF34\nzAH3QjlIvD6KGKfwFASbV6Q+6jvI1PqG2QIDAQABo4ICWzCCAlcwCQYDVR0TBAIw\nADALBgNVHQ8EBAMCBeAwHQYDVR0lBBYwFAYIKwYBBQUHAwIGCCsGAQUFBwMBMB0G\nA1UdDgQWBBRgpVpqIZHoHu6A3wNr8YHGwX0chjAfBgNVHSMEGDAWgBQf9Sw+90Cr\nLpCgatPieV7yds2DdDCBtgYDVR0RBIGuMIGrghhzaGliLWRzLmNtcy5odS1iZXJs\naW4uZGWCGXNoaWItaWRwLmNtcy5odS1iZXJsaW4uZGWCHnNoaWJib2xldGgtZHMu\nY21zLmh1LWJlcmxpbi5kZYIfc2hpYmJvbGV0aC1pZHAuY21zLmh1LWJlcmxpbi5k\nZYIbc2hpYmJvbGV0aC51dmYuaHUtYmVybGluLmRlgRZzaGliYWRtaW5AaHUtYmVy\nbGluLmRlMIGDBgNVHR8EfDB6MDugOaA3hjVodHRwOi8vY2RwMS5wY2EuZGZuLmRl\nL2h1LWJlcmxpbi1jYS9wdWIvY3JsL2NhY3JsLmNybDA7oDmgN4Y1aHR0cDovL2Nk\ncDIucGNhLmRmbi5kZS9odS1iZXJsaW4tY2EvcHViL2NybC9jYWNybC5jcmwwgZ4G\nCCsGAQUFBwEBBIGRMIGOMEUGCCsGAQUFBzAChjlodHRwOi8vY2RwMS5wY2EuZGZu\nLmRlL2h1LWJlcmxpbi1jYS9wdWIvY2FjZXJ0L2NhY2VydC5jcnQwRQYIKwYBBQUH\nMAKGOWh0dHA6Ly9jZHAyLnBjYS5kZm4uZGUvaHUtYmVybGluLWNhL3B1Yi9jYWNl\ncnQvY2FjZXJ0LmNydDANBgkqhkiG9w0BAQUFAAOCAQEABeQzv7HU+e81io7Uh6Ux\n88a61i75dPU+gPsGutyrSj8BGpuYB55gt5Huv95uLXM7XlY4/MzElucvyLdr0nan\n9wO7HpNYVoYfcM2+BT/gD8tQrAPYf49c7vNXN6f4+DAUC66oAMR+6F2tHybAupoE\nqLGnBMAzaKgp9QibCCJb6PnpY6iLNHRMFYFyoYAsST3A8TvEp5o/ga1wziqlWR5U\n63trGi6EXf/TWfqjRVl/vIbqKjJGlXexNaxXUHJmApPMa/J83PE/GZD9nvdYqfli\nXElaOsRM2A6AOAMlKljXc1i3ZeMFMmr5+yOET0AouaSMjgKNn6oBUnf8U34udgZg\nMQ==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://shib-idp.cms.hu-berlin.de:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://shib-idp.cms.hu-berlin.de:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "en", 
                "text": "https://www.aai.dfn.de/en/join/", 
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy"
              }, 
              {
                "lang": "de", 
                "text": "https://www.aai.dfn.de/teilnahme/", 
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy"
              }
            ], 
            "registration_authority": "https://www.aai.dfn.de", 
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo", 
            "registration_instant": "2011-10-21T09:44:34Z"
          }
        ]
      }, 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://shib-idp.cms.hu-berlin.de:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://shib-idp.cms.hu-berlin.de:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "hu-berlin.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "text": "shibboleth.uvf.hu-berlin.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=shibboleth.uvf.hu-berlin.de,OU=ZE Computer- und Medienservice,O=Humboldt-Universitaet zu Berlin,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFzTCCBLWgAwIBAgIHEqpQbkSDdTANBgkqhkiG9w0BAQUFADBoMQswCQYDVQQG\nEwJERTEoMCYGA1UEChMfSHVtYm9sZHQtVW5pdmVyc2l0YWV0IHp1IEJlcmxpbjEO\nMAwGA1UEAxMFSFUtQ0ExHzAdBgkqhkiG9w0BCQEWEHBraUBodS1iZXJsaW4uZGUw\nHhcNMTExMDA0MDkzMzE5WhcNMTYxMDAyMDkzMzE5WjCBhjELMAkGA1UEBhMCREUx\nKDAmBgNVBAoTH0h1bWJvbGR0LVVuaXZlcnNpdGFldCB6dSBCZXJsaW4xJzAlBgNV\nBAsTHlpFIENvbXB1dGVyLSB1bmQgTWVkaWVuc2VydmljZTEkMCIGA1UEAxMbc2hp\nYmJvbGV0aC51dmYuaHUtYmVybGluLmRlMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8A\nMIIBCgKCAQEA0vBDQzp17iY3EpgON9nw4NprsoHn0GtfkzmL2t1yYRW5U67hdMNg\ntrTQ2OHpD5Yzk2zi88L1y0aRBIsWV/DvvPM+k3NkUKfD5hDrPogHphvUvjIvJG4A\n3oDpb4Tx7TmF1ZBe1M2+xeQ+MhaUrbM8JDcRdgtScgWrEp3qkLY/xMRjVsv6sPbw\n3m3BS2Kayg7Y11d0HCuPYXM8c6dtOSNNKAUYA1IG8FkhtAEVo86goCGETYLQxGLb\nCXfeNg7G8jrKa8NUN0+mOdnpvBX7jSVGSKTYsH3C8QPkMEkYOBCq++WoCDQGIF34\nzAH3QjlIvD6KGKfwFASbV6Q+6jvI1PqG2QIDAQABo4ICWzCCAlcwCQYDVR0TBAIw\nADALBgNVHQ8EBAMCBeAwHQYDVR0lBBYwFAYIKwYBBQUHAwIGCCsGAQUFBwMBMB0G\nA1UdDgQWBBRgpVpqIZHoHu6A3wNr8YHGwX0chjAfBgNVHSMEGDAWgBQf9Sw+90Cr\nLpCgatPieV7yds2DdDCBtgYDVR0RBIGuMIGrghhzaGliLWRzLmNtcy5odS1iZXJs\naW4uZGWCGXNoaWItaWRwLmNtcy5odS1iZXJsaW4uZGWCHnNoaWJib2xldGgtZHMu\nY21zLmh1LWJlcmxpbi5kZYIfc2hpYmJvbGV0aC1pZHAuY21zLmh1LWJlcmxpbi5k\nZYIbc2hpYmJvbGV0aC51dmYuaHUtYmVybGluLmRlgRZzaGliYWRtaW5AaHUtYmVy\nbGluLmRlMIGDBgNVHR8EfDB6MDugOaA3hjVodHRwOi8vY2RwMS5wY2EuZGZuLmRl\nL2h1LWJlcmxpbi1jYS9wdWIvY3JsL2NhY3JsLmNybDA7oDmgN4Y1aHR0cDovL2Nk\ncDIucGNhLmRmbi5kZS9odS1iZXJsaW4tY2EvcHViL2NybC9jYWNybC5jcmwwgZ4G\nCCsGAQUFBwEBBIGRMIGOMEUGCCsGAQUFBzAChjlodHRwOi8vY2RwMS5wY2EuZGZu\nLmRlL2h1LWJlcmxpbi1jYS9wdWIvY2FjZXJ0L2NhY2VydC5jcnQwRQYIKwYBBQUH\nMAKGOWh0dHA6Ly9jZHAyLnBjYS5kZm4uZGUvaHUtYmVybGluLWNhL3B1Yi9jYWNl\ncnQvY2FjZXJ0LmNydDANBgkqhkiG9w0BAQUFAAOCAQEABeQzv7HU+e81io7Uh6Ux\n88a61i75dPU+gPsGutyrSj8BGpuYB55gt5Huv95uLXM7XlY4/MzElucvyLdr0nan\n9wO7HpNYVoYfcM2+BT/gD8tQrAPYf49c7vNXN6f4+DAUC66oAMR+6F2tHybAupoE\nqLGnBMAzaKgp9QibCCJb6PnpY6iLNHRMFYFyoYAsST3A8TvEp5o/ga1wziqlWR5U\n63trGi6EXf/TWfqjRVl/vIbqKjJGlXexNaxXUHJmApPMa/J83PE/GZD9nvdYqfli\nXElaOsRM2A6AOAMlKljXc1i3ZeMFMmr5+yOET0AouaSMjgKNn6oBUnf8U34udgZg\nMQ==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "de", 
            "text": "e233", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }, 
          {
            "lang": "en", 
            "text": "e233", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "Humboldt-Universit\u00e4t zu Berlin", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }, 
          {
            "lang": "en", 
            "text": "Humboldt-University Berlin", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "http://www.hu-berlin.de/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }, 
          {
            "lang": "en", 
            "text": "http://www.hu-berlin.de/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Petra", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "mailto:shibadmin@hu-berlin.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Berg", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Petra", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "mailto:shibadmin@hu-berlin.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Berg", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Petra", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "mailto:shibadmin@hu-berlin.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Berg", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "support"
        }
      ]
    }
  ], 
  [
    "https://theia.unifei.edu.br/idp/shibboleth", 
    {
      "entity_id": "https://theia.unifei.edu.br/idp/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/theia.unifei.edu.br.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://theia.unifei.edu.br/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://theia.unifei.edu.br/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://theia.unifei.edu.br/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://theia.unifei.edu.br/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "unifei.edu.br", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "information_url": [
                  {
                    "lang": "en", 
                    "text": "http://www.unifei.edu.br/", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "http://www.unifei.edu.br/", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }
                ], 
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "UNIFEI - Universidade Federal de Itajuba", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "UNIFEI - Universidade Federal de Itajuba", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "en", 
                    "text": "UNIFEI - Universidade Federal de Itajuba", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "UNIFEI - Universidade Federal de Itajuba", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDqjCCApICAQAwDQYJKoZIhvcNAQEFBQAwgZoxDzANBgNVBAoTBnVuaWZlaTEM\nMAoGA1UECxMDZHNpMSUwIwYJKoZIhvcNAQkBFhZldmVyYWxkb0B1bmlmZWkuZWR1\nLmJyMRAwDgYDVQQHEwdpdGFqdWJhMRUwEwYDVQQIEwxNaW5hcyBHZXJhaXMxCzAJ\nBgNVBAYTAkJSMRwwGgYDVQQDExN0aGVpYS51bmlmZWkuZWR1LmJyMB4XDTExMDIy\nMjE5NDEwNVoXDTE0MDIyMTE5NDEwNVowgZoxDzANBgNVBAoTBnVuaWZlaTEMMAoG\nA1UECxMDZHNpMSUwIwYJKoZIhvcNAQkBFhZldmVyYWxkb0B1bmlmZWkuZWR1LmJy\nMRAwDgYDVQQHEwdpdGFqdWJhMRUwEwYDVQQIEwxNaW5hcyBHZXJhaXMxCzAJBgNV\nBAYTAkJSMRwwGgYDVQQDExN0aGVpYS51bmlmZWkuZWR1LmJyMIIBIjANBgkqhkiG\n9w0BAQEFAAOCAQ8AMIIBCgKCAQEAszS24eQWB14ZsvJbc7/L0OIx91T7/x8eIMAg\niljM/qQb6YscjrpRZF5sMgQExLzvkDWloF10S8tHdAJ85WtLcDHzL6yxv5PlP0dG\n0uA2QL1NqaFYziyasi3MOihRozQ3VyDJLit7nKjb3r9BFlRKxEHH2DzU8ya2q9im\ndlZH9o6jyLk3qYWc88OmshEaqFCzRQre0GPYyLxDgc9mMAtVcG1y5MF2IBxUHG2M\nexL5GNVVRxvH8r+z0ZXssC/35SGmgZXNP83TcAyo7gOcPiLfuNr3E552ffFDjw3i\nGJiR9iyw5sUFMDqMshDUZnaqXpAmHBOGGk/sxa8lcdlJDArBrQIDAQABMA0GCSqG\nSIb3DQEBBQUAA4IBAQBhktjReQRXN2QOley8nhzYJKTThbZdNWg9M7JhClsq43ys\nNMRPWVbGyFPealR7UEAY8NK2i/RBAwAQ1XGvUITAoICuHHzTYBc6EcXp22BEl+gN\nqDLyZOdNaLaWaMpRbd21dBOqe8CTGBxhes5Dwe/L0bBZgV/vHk9Qw6v9I+xaQroW\n3aGrRnyxD8rPbcvLGHUPfoFdskkG2Y7UQUAYy8QlDApcA9hbplhgz5cVmqAR+vli\nFBlXJ1FNxrGhVjRg4ULTHR4H5JA6OXRLjI9gVKPbWk1/SblGi01wStR79SPBXO9c\n2N3Q1WgSwTkR3BxJaxn8/S5iu4mQ+OXuVTxo5R0y", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://theia.unifei.edu.br:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }, 
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://theia.unifei.edu.br:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "pt-br", 
                "text": "http://www.rnp.br/_arquivo/servicos/Politica_CAFe_IDP_final.pdf", 
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy"
              }
            ], 
            "registration_authority": "http://cafe.rnp.br", 
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo", 
            "registration_instant": "2010-01-01T00:00:00Z"
          }
        ]
      }, 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://theia.unifei.edu.br:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://theia.unifei.edu.br:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "unifei.edu.br", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDqjCCApICAQAwDQYJKoZIhvcNAQEFBQAwgZoxDzANBgNVBAoTBnVuaWZlaTEM\nMAoGA1UECxMDZHNpMSUwIwYJKoZIhvcNAQkBFhZldmVyYWxkb0B1bmlmZWkuZWR1\nLmJyMRAwDgYDVQQHEwdpdGFqdWJhMRUwEwYDVQQIEwxNaW5hcyBHZXJhaXMxCzAJ\nBgNVBAYTAkJSMRwwGgYDVQQDExN0aGVpYS51bmlmZWkuZWR1LmJyMB4XDTExMDIy\nMjE5NDEwNVoXDTE0MDIyMTE5NDEwNVowgZoxDzANBgNVBAoTBnVuaWZlaTEMMAoG\nA1UECxMDZHNpMSUwIwYJKoZIhvcNAQkBFhZldmVyYWxkb0B1bmlmZWkuZWR1LmJy\nMRAwDgYDVQQHEwdpdGFqdWJhMRUwEwYDVQQIEwxNaW5hcyBHZXJhaXMxCzAJBgNV\nBAYTAkJSMRwwGgYDVQQDExN0aGVpYS51bmlmZWkuZWR1LmJyMIIBIjANBgkqhkiG\n9w0BAQEFAAOCAQ8AMIIBCgKCAQEAszS24eQWB14ZsvJbc7/L0OIx91T7/x8eIMAg\niljM/qQb6YscjrpRZF5sMgQExLzvkDWloF10S8tHdAJ85WtLcDHzL6yxv5PlP0dG\n0uA2QL1NqaFYziyasi3MOihRozQ3VyDJLit7nKjb3r9BFlRKxEHH2DzU8ya2q9im\ndlZH9o6jyLk3qYWc88OmshEaqFCzRQre0GPYyLxDgc9mMAtVcG1y5MF2IBxUHG2M\nexL5GNVVRxvH8r+z0ZXssC/35SGmgZXNP83TcAyo7gOcPiLfuNr3E552ffFDjw3i\nGJiR9iyw5sUFMDqMshDUZnaqXpAmHBOGGk/sxa8lcdlJDArBrQIDAQABMA0GCSqG\nSIb3DQEBBQUAA4IBAQBhktjReQRXN2QOley8nhzYJKTThbZdNWg9M7JhClsq43ys\nNMRPWVbGyFPealR7UEAY8NK2i/RBAwAQ1XGvUITAoICuHHzTYBc6EcXp22BEl+gN\nqDLyZOdNaLaWaMpRbd21dBOqe8CTGBxhes5Dwe/L0bBZgV/vHk9Qw6v9I+xaQroW\n3aGrRnyxD8rPbcvLGHUPfoFdskkG2Y7UQUAYy8QlDApcA9hbplhgz5cVmqAR+vli\nFBlXJ1FNxrGhVjRg4ULTHR4H5JA6OXRLjI9gVKPbWk1/SblGi01wStR79SPBXO9c\n2N3Q1WgSwTkR3BxJaxn8/S5iu4mQ+OXuVTxo5R0y", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "UNIFEI - Universidade Federal de Itajuba", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }, 
          {
            "lang": "pt-br", 
            "text": "UNIFEI - Universidade Federal de Itajuba", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "UNIFEI - Universidade Federal de Itajuba", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }, 
          {
            "lang": "pt-br", 
            "text": "UNIFEI - Universidade Federal de Itajuba", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.unifei.edu.br/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }, 
          {
            "lang": "pt-br", 
            "text": "http://www.unifei.edu.br/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "email_address": [
            {
              "text": "everaldo@unifei.edu.br", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Everaldo Campos", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://cafe1.ufes.br/idp/shibboleth", 
    {
      "entity_id": "https://cafe1.ufes.br/idp/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/cafe1.ufes.br.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://cafe1.ufes.br/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://cafe1.ufes.br/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://cafe1.ufes.br/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://cafe1.ufes.br/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "ufes.br", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "information_url": [
                  {
                    "lang": "en", 
                    "text": "http://www.ufes.br/", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "http://www.ufes.br/", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }
                ], 
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "UFES - Universidade Federal do Espirito Santo", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "UFES - Universidade Federal do Espirito Santo", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "en", 
                    "text": "UFES - Universidade Federal do Espirito Santo", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "UFES - Universidade Federal do Espirito Santo", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIEPDCCAyQCARUwDQYJKoZIhvcNAQEFBQAwgeMxNjA0BgNVBAoTLVVuaXZlcnNp\nZGFkZSBGZWRlcmFsIGRvIEVzcGlyaXRvIFNhbnRvIC0gVUZFUzEvMC0GA1UECxMm\nTnVjbGVvIGRlIFByb2Nlc3NhbWVudG8gZGUgRGFkb3MgLSBOUEQxKDAmBgkqhkiG\n9w0BCQEWGWRpcmV0b3IuZ2VyYWxAbnBkLnVmZXMuYnIxEDAOBgNVBAcTB1ZpdG9y\naWExFzAVBgNVBAgTDkVzcGlyaXRvIFNhbnRvMQswCQYDVQQGEwJCUjEWMBQGA1UE\nAxMNY2FmZTEudWZlcy5icjAeFw0xMTA4MDMxMzA4MDVaFw0xNDA4MDIxMzA4MDVa\nMIHjMTYwNAYDVQQKEy1Vbml2ZXJzaWRhZGUgRmVkZXJhbCBkbyBFc3Bpcml0byBT\nYW50byAtIFVGRVMxLzAtBgNVBAsTJk51Y2xlbyBkZSBQcm9jZXNzYW1lbnRvIGRl\nIERhZG9zIC0gTlBEMSgwJgYJKoZIhvcNAQkBFhlkaXJldG9yLmdlcmFsQG5wZC51\nZmVzLmJyMRAwDgYDVQQHEwdWaXRvcmlhMRcwFQYDVQQIEw5Fc3Bpcml0byBTYW50\nbzELMAkGA1UEBhMCQlIxFjAUBgNVBAMTDWNhZmUxLnVmZXMuYnIwggEiMA0GCSqG\nSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDcv1BsThQWzeWTogJgUgbU3tU4UUOuHjXT\nB8AFXxIVARB1RVyksT4wFC5Q2tKXvqin/E4m6LmkdqKwJLj1CRetcEc41Rz0Re5J\n8/EjOE+3BUQXV961qDJIQ86Dpl6jKxjapIWCXd4fLoCF0WLIJG1tf9McAkK39SgH\ny9ImQZTgN8clsY3GOm+FU2HXUcV9W5iDh75b5byN+YCmSxernLHrpyeVIz03ZReJ\nfsNXhASJpoFAzoWNTMoi7WrUwRHrvB6RNjq3dQJrb5XUC88IwfQ512y9W6kUeTm6\nyZVJ0MeiUogHkTgpaaClal9VxPIyvZTV38XafljGrzss2DA2xqUvAgMBAAEwDQYJ\nKoZIhvcNAQEFBQADggEBAMVNejcbIY2nJUMXayK7055pjINhCUOH9R1oDIAbL6i3\nKdfahk1XlHN5kM3yOQ3T6hVf2GNy8s9SaAI6VZ5nvzReS0V81tdrzwn8Zrv2BLvc\ncP1WuYtXbOHzFgzornsflt2PKEQpT9mNnUzTagqdqxfW/8Dwp/+ZesFbmDwtN58d\n65/jAMm5oG1zaK/2V2PNELSHmswG0lk8EGaRY3LSKRDIbcMAxkA3gycMP5zEflqF\nB4YZRuxdXGqMUClpbdMxjfKICVL1rOV4wU8r6p40gSyNagGSZW8e78efc5GPL0g4\nbcL1avijCNm7WtrEOBPVFjablxgw0Hrk7CU99BXZwI4=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://cafe1.ufes.br:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }, 
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://cafe1.ufes.br:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "pt-br", 
                "text": "http://www.rnp.br/_arquivo/servicos/Politica_CAFe_IDP_final.pdf", 
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy"
              }
            ], 
            "registration_authority": "http://cafe.rnp.br", 
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo", 
            "registration_instant": "2010-01-01T00:00:00Z"
          }
        ]
      }, 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://cafe1.ufes.br:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://cafe1.ufes.br:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "ufes.br", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIEPDCCAyQCARUwDQYJKoZIhvcNAQEFBQAwgeMxNjA0BgNVBAoTLVVuaXZlcnNp\nZGFkZSBGZWRlcmFsIGRvIEVzcGlyaXRvIFNhbnRvIC0gVUZFUzEvMC0GA1UECxMm\nTnVjbGVvIGRlIFByb2Nlc3NhbWVudG8gZGUgRGFkb3MgLSBOUEQxKDAmBgkqhkiG\n9w0BCQEWGWRpcmV0b3IuZ2VyYWxAbnBkLnVmZXMuYnIxEDAOBgNVBAcTB1ZpdG9y\naWExFzAVBgNVBAgTDkVzcGlyaXRvIFNhbnRvMQswCQYDVQQGEwJCUjEWMBQGA1UE\nAxMNY2FmZTEudWZlcy5icjAeFw0xMTA4MDMxMzA4MDVaFw0xNDA4MDIxMzA4MDVa\nMIHjMTYwNAYDVQQKEy1Vbml2ZXJzaWRhZGUgRmVkZXJhbCBkbyBFc3Bpcml0byBT\nYW50byAtIFVGRVMxLzAtBgNVBAsTJk51Y2xlbyBkZSBQcm9jZXNzYW1lbnRvIGRl\nIERhZG9zIC0gTlBEMSgwJgYJKoZIhvcNAQkBFhlkaXJldG9yLmdlcmFsQG5wZC51\nZmVzLmJyMRAwDgYDVQQHEwdWaXRvcmlhMRcwFQYDVQQIEw5Fc3Bpcml0byBTYW50\nbzELMAkGA1UEBhMCQlIxFjAUBgNVBAMTDWNhZmUxLnVmZXMuYnIwggEiMA0GCSqG\nSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDcv1BsThQWzeWTogJgUgbU3tU4UUOuHjXT\nB8AFXxIVARB1RVyksT4wFC5Q2tKXvqin/E4m6LmkdqKwJLj1CRetcEc41Rz0Re5J\n8/EjOE+3BUQXV961qDJIQ86Dpl6jKxjapIWCXd4fLoCF0WLIJG1tf9McAkK39SgH\ny9ImQZTgN8clsY3GOm+FU2HXUcV9W5iDh75b5byN+YCmSxernLHrpyeVIz03ZReJ\nfsNXhASJpoFAzoWNTMoi7WrUwRHrvB6RNjq3dQJrb5XUC88IwfQ512y9W6kUeTm6\nyZVJ0MeiUogHkTgpaaClal9VxPIyvZTV38XafljGrzss2DA2xqUvAgMBAAEwDQYJ\nKoZIhvcNAQEFBQADggEBAMVNejcbIY2nJUMXayK7055pjINhCUOH9R1oDIAbL6i3\nKdfahk1XlHN5kM3yOQ3T6hVf2GNy8s9SaAI6VZ5nvzReS0V81tdrzwn8Zrv2BLvc\ncP1WuYtXbOHzFgzornsflt2PKEQpT9mNnUzTagqdqxfW/8Dwp/+ZesFbmDwtN58d\n65/jAMm5oG1zaK/2V2PNELSHmswG0lk8EGaRY3LSKRDIbcMAxkA3gycMP5zEflqF\nB4YZRuxdXGqMUClpbdMxjfKICVL1rOV4wU8r6p40gSyNagGSZW8e78efc5GPL0g4\nbcL1avijCNm7WtrEOBPVFjablxgw0Hrk7CU99BXZwI4=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "UFES - Universidade Federal do Espirito Santo", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }, 
          {
            "lang": "pt-br", 
            "text": "UFES - Universidade Federal do Espirito Santo", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "UFES - Universidade Federal do Espirito Santo", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }, 
          {
            "lang": "pt-br", 
            "text": "UFES - Universidade Federal do Espirito Santo", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.ufes.br/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }, 
          {
            "lang": "pt-br", 
            "text": "http://www.ufes.br/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "email_address": [
            {
              "text": "renan.manola@ufes.br", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Renan Manola", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://umdac-strike.ad.umu.se/shibboleth", 
    {
      "entity_id": "https://umdac-strike.ad.umu.se/shibboleth", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://sp.example.org/Shibboleth.sso/SLO/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://sp.example.org/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://sp.example.org/Shibboleth.sso/SLO/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://sp.example.org/Shibboleth.sso/SLO/Artifact"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sp.example.org/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sp.example.org/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sp.example.org/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sp.example.org/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sp.example.org/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sp.example.org/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://sp.example.org/Shibboleth.sso/DS/ds.swamid.se"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "sp.strike.ad.umu.se", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "emailAddress=datordrift@umdac.umu.se,CN=sp.strike.ad.umu.se,OU=ITS,O=Umea universitet,L=Umea,ST=Vasterbotten,C=SE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIE1jCCA76gAwIBAgIJANgp9G5gZX/7MA0GCSqGSIb3DQEBBQUAMIGiMQswCQYD\nVQQGEwJTRTEVMBMGA1UECBMMVmFzdGVyYm90dGVuMQ0wCwYDVQQHEwRVbWVhMRkw\nFwYDVQQKExBVbWVhIHVuaXZlcnNpdGV0MQwwCgYDVQQLEwNJVFMxHDAaBgNVBAMT\nE3NwLnN0cmlrZS5hZC51bXUuc2UxJjAkBgkqhkiG9w0BCQEWF2RhdG9yZHJpZnRA\ndW1kYWMudW11LnNlMB4XDTExMDIxMDEzMjI0MVoXDTEzMTIyNDEzMjI0MVowgaIx\nCzAJBgNVBAYTAlNFMRUwEwYDVQQIEwxWYXN0ZXJib3R0ZW4xDTALBgNVBAcTBFVt\nZWExGTAXBgNVBAoTEFVtZWEgdW5pdmVyc2l0ZXQxDDAKBgNVBAsTA0lUUzEcMBoG\nA1UEAxMTc3Auc3RyaWtlLmFkLnVtdS5zZTEmMCQGCSqGSIb3DQEJARYXZGF0b3Jk\ncmlmdEB1bWRhYy51bXUuc2UwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIB\nAQD3cDW3/Z5H0wDknkiHATmn5+pSap07JCNKUrwBQZquE2Nfr3Idw83A3qMUwY7Z\nEW1jQU69j363dqGv9Ypc8ViQ9jSR5+O9iTaMYIpJHJSiFju3wFHbwZMJckFdsRjt\njsWCdh1EGU/oJP0HdijvDtr1eM6VjeB3a3oEOlN9ECPkGAR03m+O8CPviRSSwXJD\nyvtJKgBNy6U3t2o13L1i7xgvNNcywRu4vtdkt5K+NI/P7C0H/j1DzAbZzqfyJhBO\nKPW1X2Wetk6nubsw49k2XnRUFkqamvSe6shL4492cwRYpxmKTX+e/RUde0+Ve7VS\n0VaD9+9utUzO/kG/cOeXtzsDAgMBAAGjggELMIIBBzAdBgNVHQ4EFgQUbDEDfqkU\nfWcjQC7Y53yHYNEgGLQwgdcGA1UdIwSBzzCBzIAUbDEDfqkUfWcjQC7Y53yHYNEg\nGLShgaikgaUwgaIxCzAJBgNVBAYTAlNFMRUwEwYDVQQIEwxWYXN0ZXJib3R0ZW4x\nDTALBgNVBAcTBFVtZWExGTAXBgNVBAoTEFVtZWEgdW5pdmVyc2l0ZXQxDDAKBgNV\nBAsTA0lUUzEcMBoGA1UEAxMTc3Auc3RyaWtlLmFkLnVtdS5zZTEmMCQGCSqGSIb3\nDQEJARYXZGF0b3JkcmlmdEB1bWRhYy51bXUuc2WCCQDYKfRuYGV/+zAMBgNVHRME\nBTADAQH/MA0GCSqGSIb3DQEBBQUAA4IBAQAVvAHw6N0vq1/WK6Xgu63vgI3Y6E62\nioR3z4ysf0RMFCO1X3t3ZV119uINUKcV8IOsQL4yaSSPk25kAd+WELjX03pRfbzx\npr07qZjmDGQ4+NXeEfQzHNS1ONmWB5ehb07q+BQ3NBO9fNecboLqhKXO4aY6DGd8\n6sUsvhBBTHjDBoIe7VuIA53XdUCLFfvS/SwDBJOPfQeSg+16uzMWF7wpF+xFhvWn\nPyekLl4nWhrS6lKYrMdR4u5gQI8nzSycLqHiWrC3ftlFEYpEau1MskWdOAAd3r8q\nlI1794b9Dm6mV7L0EhmDNsX6gIy5lHdW5rfaW9gTZdImBpGECbBQlehm", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "sp.strike.ad.umu.se", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "emailAddress=datordrift@umdac.umu.se,CN=sp.strike.ad.umu.se,OU=ITS,O=Umea universitet,L=Umea,ST=Vasterbotten,C=SE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIE1jCCA76gAwIBAgIJANgp9G5gZX/7MA0GCSqGSIb3DQEBBQUAMIGiMQswCQYD\nVQQGEwJTRTEVMBMGA1UECBMMVmFzdGVyYm90dGVuMQ0wCwYDVQQHEwRVbWVhMRkw\nFwYDVQQKExBVbWVhIHVuaXZlcnNpdGV0MQwwCgYDVQQLEwNJVFMxHDAaBgNVBAMT\nE3NwLnN0cmlrZS5hZC51bXUuc2UxJjAkBgkqhkiG9w0BCQEWF2RhdG9yZHJpZnRA\ndW1kYWMudW11LnNlMB4XDTExMDIxMDEzMjI0MVoXDTEzMTIyNDEzMjI0MVowgaIx\nCzAJBgNVBAYTAlNFMRUwEwYDVQQIEwxWYXN0ZXJib3R0ZW4xDTALBgNVBAcTBFVt\nZWExGTAXBgNVBAoTEFVtZWEgdW5pdmVyc2l0ZXQxDDAKBgNVBAsTA0lUUzEcMBoG\nA1UEAxMTc3Auc3RyaWtlLmFkLnVtdS5zZTEmMCQGCSqGSIb3DQEJARYXZGF0b3Jk\ncmlmdEB1bWRhYy51bXUuc2UwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIB\nAQD3cDW3/Z5H0wDknkiHATmn5+pSap07JCNKUrwBQZquE2Nfr3Idw83A3qMUwY7Z\nEW1jQU69j363dqGv9Ypc8ViQ9jSR5+O9iTaMYIpJHJSiFju3wFHbwZMJckFdsRjt\njsWCdh1EGU/oJP0HdijvDtr1eM6VjeB3a3oEOlN9ECPkGAR03m+O8CPviRSSwXJD\nyvtJKgBNy6U3t2o13L1i7xgvNNcywRu4vtdkt5K+NI/P7C0H/j1DzAbZzqfyJhBO\nKPW1X2Wetk6nubsw49k2XnRUFkqamvSe6shL4492cwRYpxmKTX+e/RUde0+Ve7VS\n0VaD9+9utUzO/kG/cOeXtzsDAgMBAAGjggELMIIBBzAdBgNVHQ4EFgQUbDEDfqkU\nfWcjQC7Y53yHYNEgGLQwgdcGA1UdIwSBzzCBzIAUbDEDfqkUfWcjQC7Y53yHYNEg\nGLShgaikgaUwgaIxCzAJBgNVBAYTAlNFMRUwEwYDVQQIEwxWYXN0ZXJib3R0ZW4x\nDTALBgNVBAcTBFVtZWExGTAXBgNVBAoTEFVtZWEgdW5pdmVyc2l0ZXQxDDAKBgNV\nBAsTA0lUUzEcMBoGA1UEAxMTc3Auc3RyaWtlLmFkLnVtdS5zZTEmMCQGCSqGSIb3\nDQEJARYXZGF0b3JkcmlmdEB1bWRhYy51bXUuc2WCCQDYKfRuYGV/+zAMBgNVHRME\nBTADAQH/MA0GCSqGSIb3DQEBBQUAA4IBAQAVvAHw6N0vq1/WK6Xgu63vgI3Y6E62\nioR3z4ysf0RMFCO1X3t3ZV119uINUKcV8IOsQL4yaSSPk25kAd+WELjX03pRfbzx\npr07qZjmDGQ4+NXeEfQzHNS1ONmWB5ehb07q+BQ3NBO9fNecboLqhKXO4aY6DGd8\n6sUsvhBBTHjDBoIe7VuIA53XdUCLFfvS/SwDBJOPfQeSg+16uzMWF7wpF+xFhvWn\nPyekLl4nWhrS6lKYrMdR4u5gQI8nzSycLqHiWrC3ftlFEYpEau1MskWdOAAd3r8q\nlI1794b9Dm6mV7L0EhmDNsX6gIy5lHdW5rfaW9gTZdImBpGECbBQlehm", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://sp.example.org/Shibboleth.sso/Artifact/SOAP"
            }
          ], 
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://sp.example.org/Shibboleth.sso/NIM/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://sp.example.org/Shibboleth.sso/NIM/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://sp.example.org/Shibboleth.sso/NIM/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://sp.example.org/Shibboleth.sso/NIM/Artifact"
            }
          ]
        }
      ], 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-2.0/umdac-strike.ad.umu.se-shibboleth.xml"
      }
    }
  ], 
  [
    "https://rems.csc.fi", 
    {
      "entity_id": "https://rems.csc.fi", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-2.0/rems.csc.fi.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "attribute": [
              {
                "attribute_value": [
                  {
                    "text": "http://www.swamid.se/category/research-and-education", 
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue", 
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    }
                  }, 
                  {
                    "text": "http://www.swamid.se/category/eu-adequate-protection", 
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue", 
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    }
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute", 
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                "name": "http://macedir.org/entity-category"
              }
            ], 
            "__class__": "urn:oasis:names:tc:SAML:metadata:attribute&EntityAttributes"
          }
        ]
      }, 
      "organization": {
        "organization_name": [
          {
            "lang": "fi", 
            "text": "CSC - Tieteen tietotekniikan keskus Oy", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }, 
          {
            "lang": "en", 
            "text": "CSC - IT Center for Science Ltd.", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }, 
          {
            "lang": "sv", 
            "text": "CSC - IT-centret f\u00f6r vetenskap", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "fi", 
            "text": "CSC - Tieteen tietotekniikan keskus Oy", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }, 
          {
            "lang": "en", 
            "text": "CSC - IT Center for Science Ltd.", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }, 
          {
            "lang": "sv", 
            "text": "CSC - IT-centret f\u00f6r vetenskap", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "fi", 
            "text": "http://www.csc.fi", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }, 
          {
            "lang": "en", 
            "text": "http://www.csc.fi", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }, 
          {
            "lang": "sv", 
            "text": "http://www.csc.fi", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "is_default": "true", 
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://rems.csc.fi/Shibboleth.sso/SAML2/POST"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://rems.csc.fi/Shibboleth.sso/Login"
              }, 
              {
                "index": "2", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://rems.csc.fi/Shibboleth.sso/Login2"
              }, 
              {
                "privacy_statement_url": [
                  {
                    "lang": "en", 
                    "text": "https://rems.csc.fi/web/guest/privacy-policy", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&PrivacyStatementURL"
                  }, 
                  {
                    "lang": "fi", 
                    "text": "https://rems.csc.fi/web/guest/tietosuojaseloste", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&PrivacyStatementURL"
                  }
                ], 
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "REMS", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }, 
                  {
                    "lang": "fi", 
                    "text": "REMS", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "en", 
                    "text": "Resource Entitlement Management\n                    System", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }, 
                  {
                    "lang": "fi", 
                    "text": "REMS-palvelun kautta tutkijat voivat hakea k\u00e4ytt\u00f6oikeuksia tutkimuksen tietoaineistoihin", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }
            ]
          }, 
          "name_id_format": [
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ], 
          "attribute_consuming_service": [
            {
              "index": "1", 
              "service_name": [
                {
                  "lang": "fi", 
                  "text": "REMS", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }, 
                {
                  "lang": "en", 
                  "text": "REMS", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }
              ], 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService", 
              "is_default": "true", 
              "requested_attribute": [
                {
                  "friendly_name": "cn", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.5.4.3"
                }, 
                {
                  "friendly_name": "displayName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.16.840.1.113730.3.1.241"
                }, 
                {
                  "friendly_name": "eduPersonAffiliation", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.1"
                }, 
                {
                  "friendly_name": "eduPersonPrincipalName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.6"
                }, 
                {
                  "friendly_name": "mail", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:0.9.2342.19200300.100.1.3"
                }, 
                {
                  "friendly_name": "schacHomeOrganization", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.25178.1.2.9"
                }, 
                {
                  "friendly_name": "schacHomeOrganizationType", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.25178.1.2.10"
                }, 
                {
                  "friendly_name": "sn", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.5.4.4"
                }
              ], 
              "service_description": [
                {
                  "lang": "fi", 
                  "text": "Valtuutuuksien Hallinta\n                Jarjestelma", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription"
                }, 
                {
                  "lang": "en", 
                  "text": "Resource Entitlement Management\n                System", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription"
                }
              ]
            }
          ], 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIC6DCCAdCgAwIBAgIJAJNkHpbnqskZMA0GCSqGSIb3DQEBBQUAMBYxFDASBgNV\n                        BAMTC3JlbXMuY3NjLmZpMB4XDTEyMTAwNDA2NDc1M1oXDTIyMTAwMjA2NDc1M1ow\n                        FjEUMBIGA1UEAxMLcmVtcy5jc2MuZmkwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw\n                        ggEKAoIBAQCti37oqpPuAfgsIAc7VwKA+3L99iuTlFG9jlGTJiurXW/ARwl5y8FX\n                        HWDYmdg5GECe7qHsvKAhgGnJ6x0qmhJZacbvBuhofGZBHliG6ykCX377HA09pDr1\n                        db9WRhRMwz/w46mZU/9n/r3BfXXNpmAsdHiC/nD+0lPoOEHfo9wN0JsqO4SQUbya\n                        0cyMle8YVlPeF+8voug2lNvcDRcx9CRvAMTHuJX9HBTYE0XtAgHZOymZ10KvBDnq\n                        Lw7z0bndgUuSAp5puWH1eKGZt1S6rslLeMVw7xlTlds4HmGc5CRkJyZ0WKkU0VI2\n                        THDKIHlWCkJ+X0i04TFYtiJKxwavAjoRAgMBAAGjOTA3MBYGA1UdEQQPMA2CC3Jl\n                        bXMuY3NjLmZpMB0GA1UdDgQWBBSTogtyEd5toTA7qpl65syr7UE9OzANBgkqhkiG\n                        9w0BAQUFAAOCAQEAkHuPNT6e9a3PG8dy/OcUfY+ln2NA1gThNFRc0ZdhsRML1MXk\n                        hTPyv6v04KsyfEH4OjkpyTqcVCvs6jjVZrQmPyzU3nXu1aPyM7lYvGikVM/oFRAV\n                        0H4Cz+Yj8mKCddTdxAAiNyuqjOf+eYlRv3SyNjIYYM6OmqD0mH/mPZ6ado41ALUN\n                        0iqdiwFeKwjOlKALGVW92ihgU8uX3ScC6jCbAdPTu2m+NBO42pKNVYasHI0PBJmB\n                        HCZKDHCPHeGmXn6ab0zU6GbvGrxAKWDwJNw9mgRfxKqvTpVI9hY8QOE4eAjH7UJz\n                        c3E0G+pYuKCVKHVH6HOcuVL23IneYlhKtmz+Kw==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ]
        }
      ], 
      "contact_person": [
        {
          "given_name": {
            "text": "Janne", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "mailto:janne.lauros@csc.fi", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Lauros", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Janne", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "mailto:janne.lauros@csc.fi", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Lauros", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "support"
        }
      ]
    }
  ], 
  [
    "https://se.timeedit.net/lnu-employee-sp", 
    {
      "entity_id": "https://se.timeedit.net/lnu-employee-sp", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-2.0/se.timeedit.net-web-lnu-db1-timeedit-ssoMetadata-lnu_pers_saml2.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "attribute": [
              {
                "attribute_value": [
                  {
                    "text": "http://www.swamid.se/category/research-and-education", 
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue", 
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    }
                  }, 
                  {
                    "text": "http://www.swamid.se/category/hei-service", 
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue", 
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    }
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute", 
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                "name": "http://macedir.org/entity-category"
              }
            ], 
            "__class__": "urn:oasis:names:tc:SAML:metadata:attribute&EntityAttributes"
          }
        ]
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "TimeEdit", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "support@evolvera.se", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Support", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://se.timeedit.net/web/lnu/db1/timeedit/ssoLogout/lnu_pers_saml2"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "is_default": "false", 
              "index": "0", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://se.timeedit.net/web/lnu/db1/timeedit/ssoResponse/lnu_pers_saml2"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "display_name": [
                  {
                    "lang": "sv", 
                    "text": "TimeEdit f\u00f6r anst\u00e4llda vid Linn\u00e9universitetet", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }, 
                  {
                    "lang": "en", 
                    "text": "TimeEdit for employees at Linaeus University", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "sv", 
                    "text": "TimeEdit, utvecklat av Evolvera AB", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }, 
                  {
                    "lang": "en", 
                    "text": "TimeEdit, developed by Evolvera AB", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }
            ]
          }, 
          "name_id_format": [
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ], 
          "want_assertions_signed": "false", 
          "authn_requests_signed": "true", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDIDCCAggCCQDSfJxeKVOg3jANBgkqhkiG9w0BAQUFADBSMQswCQYDVQQGEwJTRTESMBAGA1UE\nBxQJR8O2dGVib3JnMRQwEgYDVQQKEwtUaW1lRWRpdCBBQjEZMBcGA1UEAxMQYXV0aC50aW1lZWRp\ndC5zZTAeFw0xMzA2MTQwNzE0MTlaFw0xNTA2MTQwNzE0MTlaMFIxCzAJBgNVBAYTAlNFMRIwEAYD\nVQQHFAlHw7Z0ZWJvcmcxFDASBgNVBAoTC1RpbWVFZGl0IEFCMRkwFwYDVQQDExBhdXRoLnRpbWVl\nZGl0LnNlMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAoL+lyBleTM0UGwGPLXPcfBMr\nomnPqP8+qlE+rOs0mEbvNyXdEWT0Z5P/XoMVfERJQQ6v5DAJF4c3o1BiPshZL8cj6QdLuJXLfVNG\nu5mzq/lKpB/n38Y4cWYxIyNtBcV9vcKDIRUbQP/27nEPMsbs2IaCXf6V3l3yQqbymZTyd8nBfZZF\nG95zDKBTSD5UQ3XW+LbvjKSZY4qDjyFkeOfj8kVyltWTHRMvKTKGLeNrGyCFiaMY/vfyA22gOyz4\nO2cY/oqFs8+82AOs3Si4+eGkFAq3CdEWSE4c69oDrzEWk+bKgxw5qyhWQ/13eh8AiZMDeqhT7q32\nRthqEp8GfwPM1QIDAQABMA0GCSqGSIb3DQEBBQUAA4IBAQCRsLvMI4OJ076STPIyxnwk6bXRG5RL\nMR1pJ3umMNCa1LR1RnH1feuvm9dxerUTow7bPIsarJarh0iEIj2kLtu/prPm+ZcAKeEjh27pSM7m\n1F0XBkDqeP1msR+7g0aHlt0MzrKm/Esb1JX9YCO3MHl1XFc8xSnv2bxKWvER+tmDWkFrC0y1u2+H\nB/CfyES8ntBP6F7aZ6UQ4GTrqF0MZNGBoWFyXecGe5XEwWJwP4otSrJ2q7cbQU33xEcri0dHiMMl\nTiN/6f25dSm5UFCxqWGGAQndGfn/tE5FSqJlrHnbF2M6x4eH3MEIbHebI+nJlk6ASPdgIssvsDcd\nGImnaeS4", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://ladok3-06.ladok.umu.se/gui-sp", 
    {
      "entity_id": "https://ladok3-06.ladok.umu.se/gui-sp", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://ladok3-06.ladok.umu.se/Shibboleth.sso/SLO/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://ladok3-06.ladok.umu.se/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://ladok3-06.ladok.umu.se/Shibboleth.sso/SLO/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://ladok3-06.ladok.umu.se/Shibboleth.sso/SLO/Artifact"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ladok3-06.ladok.umu.se/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ladok3-06.ladok.umu.se/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ladok3-06.ladok.umu.se/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ladok3-06.ladok.umu.se/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ladok3-06.ladok.umu.se/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ladok3-06.ladok.umu.se/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "text": "https://ladok3-06.ladok.umu.se/gui-sp", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }, 
                  {
                    "text": "ladok3-06.ladok.umu.se", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=ladok3-06.ladok.umu.se", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIDMDCCAhigAwIBAgIJALk1rPJOG1teMA0GCSqGSIb3DQEBBQUAMCExHzAdBgNV\nBAMTFmxhZG9rMy0wNi5sYWRvay51bXUuc2UwHhcNMTIwNjI5MTIwODEwWhcNMjIw\nNjI3MTIwODEwWjAhMR8wHQYDVQQDExZsYWRvazMtMDYubGFkb2sudW11LnNlMIIB\nIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAy7RjhC7f4/gfQK127LuRggwD\n6VUcajCmZ8HpXZp29b/ghxNhgVlLDiIrLpD+bDaRoyJ20VssaWJ7KdLj2jFAjOmz\nCfPhvAd3kVmLLvVVOG12XlOh81RdQKZBm6qkvC/kTS6fxUHkympbGzFPmhGt6kEs\nz6BbdoOTzXTlXO4/H5N7N9ShspBhbc9NETinrPtIIykgjHSbfWMVdYQqCJbIdbM7\ny61Re55wfl8m6ppNra+oykYly2jhvlN0Vb4QGqpJBB0XzOAVh/DHt9oEDryxxaeG\n6JVhDwD15vx4tdm6ypd7qwNXp0c9nYteYNiSL+qXisKVJZ/JLcllxC7dLZ6GHQID\nAQABo2swaTBIBgNVHREEQTA/ghZsYWRvazMtMDYubGFkb2sudW11LnNlhiVodHRw\nczovL2xhZG9rMy0wNi5sYWRvay51bXUuc2UvZ3VpLXNwMB0GA1UdDgQWBBRK+n8d\nwSrEb8l1peNFBoe/bchVGjANBgkqhkiG9w0BAQUFAAOCAQEAqV8BTMudvEvzIUu1\n7bdjIVNCvNRb914WsPmQR6KhKhRzHVRJFqeSkMtvzCTi4YzaNE59l6iKcFG20ffZ\nO5WwEUhy8TtPgLrdK+Zi1rYfE3pULUs+LQLxz3h0reEW35y084ahB9uhYdkfjqEU\n/8LYg09v4gGOnjCLLj+mOEjpH7oVMWPuLSPbgL8RMfBX1SF51pDs1tp+rjGdbc7c\nPsCzYLHD+n9ygXpZsmmVmYi0YjZbrpYOLJlg/IU+jTfQ8ag4d8QEEz6Zfv+BL8iy\nU5ov36jyE84soQ3NsxFo3cndYZE3Epi7pMNaKAO2OUlS2R2R+l/9pdyzQqcOU6bq\nz181Cw==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://ladok3-06.ladok.umu.se/Shibboleth.sso/Artifact/SOAP"
            }
          ], 
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://ladok3-06.ladok.umu.se/Shibboleth.sso/NIM/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://ladok3-06.ladok.umu.se/Shibboleth.sso/NIM/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://ladok3-06.ladok.umu.se/Shibboleth.sso/NIM/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://ladok3-06.ladok.umu.se/Shibboleth.sso/NIM/Artifact"
            }
          ]
        }
      ], 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-2.0/swamid-1.0/ladok3-06.ladok.umu.se-gui-sp.xml"
      }
    }
  ], 
  [
    "https://idp.ub.hsu-hh.de/idp/shibboleth", 
    {
      "entity_id": "https://idp.ub.hsu-hh.de/idp/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/idp.ub.hsu-hh.de.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.ub.hsu-hh.de/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.ub.hsu-hh.de/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.ub.hsu-hh.de/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.ub.hsu-hh.de/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "hsu-hh.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "idp.ub.hsu-hh.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=idp.ub.hsu-hh.de,O=Helmut-Schmidt-Universitaet Universitaet der Bundeswehr Hamburg,L=Hamburg,ST=Hamburg,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFmTCCBIGgAwIBAgIEDtrvHzANBgkqhkiG9w0BAQUFADCBizELMAkGA1UEBhMC\nREUxSDBGBgNVBAoTP0hlbG11dC1TY2htaWR0LVVuaXZlcnNpdGFldCBVbml2ZXJz\naXRhZXQgZGVyIEJ1bmRlc3dlaHIgSGFtYnVyZzEVMBMGA1UEAxMMSFNVIENBIC0g\nRzAxMRswGQYJKoZIhvcNAQkBFgxjYUBoc3UtaGguZGUwHhcNMDkwOTI0MTMxODA4\nWhcNMTQwOTIzMTMxODA4WjCBljELMAkGA1UEBhMCREUxEDAOBgNVBAgTB0hhbWJ1\ncmcxEDAOBgNVBAcTB0hhbWJ1cmcxSDBGBgNVBAoTP0hlbG11dC1TY2htaWR0LVVu\naXZlcnNpdGFldCBVbml2ZXJzaXRhZXQgZGVyIEJ1bmRlc3dlaHIgSGFtYnVyZzEZ\nMBcGA1UEAxMQaWRwLnViLmhzdS1oaC5kZTCCASIwDQYJKoZIhvcNAQEBBQADggEP\nADCCAQoCggEBAJozfQt8GxD1AKQPEqsTcJipCihzU0Gc2gw+qkWWOLEN6K63wICQ\nCjnV2+n4I0uz1cAzzaauAkdFVCjxXrhgq8K/kYGiyLJvl+wHazN6SqSzrEskgCSR\nQrOrn8YzQTtWe7kZR9aVOJFY8p2MqL4UWwUNYqIe4+2InIn3qaimG1mP0CGJT8Ck\nLya8gg7LUWltXvVcWQmsJjBUGPR9TyNxBXTGn/tw0crt18w7TjiwwTacMAsaQEby\no2rHoEFe+c7gQF7ZMYc0yia1+oylmBLHuqy5Pxo3mxyG6fYflVwPMCye3BFEm6fI\nNJQvKZ04sKbk/8+wXsLUWsNhO62zajHYDY0CAwEAAaOCAfYwggHyMAkGA1UdEwQC\nMAAwCwYDVR0PBAQDAgXgMB0GA1UdJQQWMBQGCCsGAQUFBwMCBggrBgEFBQcDATAd\nBgNVHQ4EFgQUzCawY/z2k64WBdr0a5agbjeydZMwHwYDVR0jBBgwFoAU0OF/Hccy\nvOKQu1gUgBTGX53swaowIAYDVR0RBBkwF4EVaWRwQGhzdS1iaWJsaW90aGVrLmRl\nMIGdBgNVHR8EgZUwgZIwR6BFoEOGQWh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvaGVs\nbXV0LXNjaG1pZHQtdW5pLWhoLWNhL3B1Yi9jcmwvY2FjcmwuY3JsMEegRaBDhkFo\ndHRwOi8vY2RwMi5wY2EuZGZuLmRlL2hlbG11dC1zY2htaWR0LXVuaS1oaC1jYS9w\ndWIvY3JsL2NhY3JsLmNybDCBtgYIKwYBBQUHAQEEgakwgaYwUQYIKwYBBQUHMAKG\nRWh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvaGVsbXV0LXNjaG1pZHQtdW5pLWhoLWNh\nL3B1Yi9jYWNlcnQvY2FjZXJ0LmNydDBRBggrBgEFBQcwAoZFaHR0cDovL2NkcDIu\ncGNhLmRmbi5kZS9oZWxtdXQtc2NobWlkdC11bmktaGgtY2EvcHViL2NhY2VydC9j\nYWNlcnQuY3J0MA0GCSqGSIb3DQEBBQUAA4IBAQAVuAzmub19Uck2UxkTRAfgQ5Yz\noO3H9crRrXfAfi2EeS/2nd+pn/S9xwaeMcBE02SE6H2ujjWpb4T6zoe8oWeCihHt\nbByDVICPRMvPU0IkLgAlQmUgGTi7SMlFuv/inoEA0Cvjv6EGSC7L8JmzrUzB0Fgi\ns70BXg+QladY3A2Odwt3xgAeCZo8pXrrSqqEjgsToD/dSKi9hAdlah5feBRw8fGw\ng0sqqQB13BJSbmspSm/UTPv1ZQP7VrAIOpP2p9OLGARi9fLxpSfsczPS62BW69Xf\nmd5/h8e4VJDeQ8uU102FbhB7brNCg3SuWZsJivRwy1aaMDvL1zVDP7xULLCG", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "idp.ub.hsu-hh.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=idp.ub.hsu-hh.de,O=Helmut-Schmidt-Universitaet Universitaet der Bundeswehr Hamburg,L=Hamburg,ST=Hamburg,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFmTCCBIGgAwIBAgIEDtrvHzANBgkqhkiG9w0BAQUFADCBizELMAkGA1UEBhMC\nREUxSDBGBgNVBAoTP0hlbG11dC1TY2htaWR0LVVuaXZlcnNpdGFldCBVbml2ZXJz\naXRhZXQgZGVyIEJ1bmRlc3dlaHIgSGFtYnVyZzEVMBMGA1UEAxMMSFNVIENBIC0g\nRzAxMRswGQYJKoZIhvcNAQkBFgxjYUBoc3UtaGguZGUwHhcNMDkwOTI0MTMxODA4\nWhcNMTQwOTIzMTMxODA4WjCBljELMAkGA1UEBhMCREUxEDAOBgNVBAgTB0hhbWJ1\ncmcxEDAOBgNVBAcTB0hhbWJ1cmcxSDBGBgNVBAoTP0hlbG11dC1TY2htaWR0LVVu\naXZlcnNpdGFldCBVbml2ZXJzaXRhZXQgZGVyIEJ1bmRlc3dlaHIgSGFtYnVyZzEZ\nMBcGA1UEAxMQaWRwLnViLmhzdS1oaC5kZTCCASIwDQYJKoZIhvcNAQEBBQADggEP\nADCCAQoCggEBAJozfQt8GxD1AKQPEqsTcJipCihzU0Gc2gw+qkWWOLEN6K63wICQ\nCjnV2+n4I0uz1cAzzaauAkdFVCjxXrhgq8K/kYGiyLJvl+wHazN6SqSzrEskgCSR\nQrOrn8YzQTtWe7kZR9aVOJFY8p2MqL4UWwUNYqIe4+2InIn3qaimG1mP0CGJT8Ck\nLya8gg7LUWltXvVcWQmsJjBUGPR9TyNxBXTGn/tw0crt18w7TjiwwTacMAsaQEby\no2rHoEFe+c7gQF7ZMYc0yia1+oylmBLHuqy5Pxo3mxyG6fYflVwPMCye3BFEm6fI\nNJQvKZ04sKbk/8+wXsLUWsNhO62zajHYDY0CAwEAAaOCAfYwggHyMAkGA1UdEwQC\nMAAwCwYDVR0PBAQDAgXgMB0GA1UdJQQWMBQGCCsGAQUFBwMCBggrBgEFBQcDATAd\nBgNVHQ4EFgQUzCawY/z2k64WBdr0a5agbjeydZMwHwYDVR0jBBgwFoAU0OF/Hccy\nvOKQu1gUgBTGX53swaowIAYDVR0RBBkwF4EVaWRwQGhzdS1iaWJsaW90aGVrLmRl\nMIGdBgNVHR8EgZUwgZIwR6BFoEOGQWh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvaGVs\nbXV0LXNjaG1pZHQtdW5pLWhoLWNhL3B1Yi9jcmwvY2FjcmwuY3JsMEegRaBDhkFo\ndHRwOi8vY2RwMi5wY2EuZGZuLmRlL2hlbG11dC1zY2htaWR0LXVuaS1oaC1jYS9w\ndWIvY3JsL2NhY3JsLmNybDCBtgYIKwYBBQUHAQEEgakwgaYwUQYIKwYBBQUHMAKG\nRWh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvaGVsbXV0LXNjaG1pZHQtdW5pLWhoLWNh\nL3B1Yi9jYWNlcnQvY2FjZXJ0LmNydDBRBggrBgEFBQcwAoZFaHR0cDovL2NkcDIu\ncGNhLmRmbi5kZS9oZWxtdXQtc2NobWlkdC11bmktaGgtY2EvcHViL2NhY2VydC9j\nYWNlcnQuY3J0MA0GCSqGSIb3DQEBBQUAA4IBAQAVuAzmub19Uck2UxkTRAfgQ5Yz\noO3H9crRrXfAfi2EeS/2nd+pn/S9xwaeMcBE02SE6H2ujjWpb4T6zoe8oWeCihHt\nbByDVICPRMvPU0IkLgAlQmUgGTi7SMlFuv/inoEA0Cvjv6EGSC7L8JmzrUzB0Fgi\ns70BXg+QladY3A2Odwt3xgAeCZo8pXrrSqqEjgsToD/dSKi9hAdlah5feBRw8fGw\ng0sqqQB13BJSbmspSm/UTPv1ZQP7VrAIOpP2p9OLGARi9fLxpSfsczPS62BW69Xf\nmd5/h8e4VJDeQ8uU102FbhB7brNCg3SuWZsJivRwy1aaMDvL1zVDP7xULLCG", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://idp.ub.hsu-hh.de:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://idp.ub.hsu-hh.de:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://idp.ub.hsu-hh.de:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://idp.ub.hsu-hh.de:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "hsu-hh.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "idp.ub.hsu-hh.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=idp.ub.hsu-hh.de,O=Helmut-Schmidt-Universitaet Universitaet der Bundeswehr Hamburg,L=Hamburg,ST=Hamburg,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFmTCCBIGgAwIBAgIEDtrvHzANBgkqhkiG9w0BAQUFADCBizELMAkGA1UEBhMC\nREUxSDBGBgNVBAoTP0hlbG11dC1TY2htaWR0LVVuaXZlcnNpdGFldCBVbml2ZXJz\naXRhZXQgZGVyIEJ1bmRlc3dlaHIgSGFtYnVyZzEVMBMGA1UEAxMMSFNVIENBIC0g\nRzAxMRswGQYJKoZIhvcNAQkBFgxjYUBoc3UtaGguZGUwHhcNMDkwOTI0MTMxODA4\nWhcNMTQwOTIzMTMxODA4WjCBljELMAkGA1UEBhMCREUxEDAOBgNVBAgTB0hhbWJ1\ncmcxEDAOBgNVBAcTB0hhbWJ1cmcxSDBGBgNVBAoTP0hlbG11dC1TY2htaWR0LVVu\naXZlcnNpdGFldCBVbml2ZXJzaXRhZXQgZGVyIEJ1bmRlc3dlaHIgSGFtYnVyZzEZ\nMBcGA1UEAxMQaWRwLnViLmhzdS1oaC5kZTCCASIwDQYJKoZIhvcNAQEBBQADggEP\nADCCAQoCggEBAJozfQt8GxD1AKQPEqsTcJipCihzU0Gc2gw+qkWWOLEN6K63wICQ\nCjnV2+n4I0uz1cAzzaauAkdFVCjxXrhgq8K/kYGiyLJvl+wHazN6SqSzrEskgCSR\nQrOrn8YzQTtWe7kZR9aVOJFY8p2MqL4UWwUNYqIe4+2InIn3qaimG1mP0CGJT8Ck\nLya8gg7LUWltXvVcWQmsJjBUGPR9TyNxBXTGn/tw0crt18w7TjiwwTacMAsaQEby\no2rHoEFe+c7gQF7ZMYc0yia1+oylmBLHuqy5Pxo3mxyG6fYflVwPMCye3BFEm6fI\nNJQvKZ04sKbk/8+wXsLUWsNhO62zajHYDY0CAwEAAaOCAfYwggHyMAkGA1UdEwQC\nMAAwCwYDVR0PBAQDAgXgMB0GA1UdJQQWMBQGCCsGAQUFBwMCBggrBgEFBQcDATAd\nBgNVHQ4EFgQUzCawY/z2k64WBdr0a5agbjeydZMwHwYDVR0jBBgwFoAU0OF/Hccy\nvOKQu1gUgBTGX53swaowIAYDVR0RBBkwF4EVaWRwQGhzdS1iaWJsaW90aGVrLmRl\nMIGdBgNVHR8EgZUwgZIwR6BFoEOGQWh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvaGVs\nbXV0LXNjaG1pZHQtdW5pLWhoLWNhL3B1Yi9jcmwvY2FjcmwuY3JsMEegRaBDhkFo\ndHRwOi8vY2RwMi5wY2EuZGZuLmRlL2hlbG11dC1zY2htaWR0LXVuaS1oaC1jYS9w\ndWIvY3JsL2NhY3JsLmNybDCBtgYIKwYBBQUHAQEEgakwgaYwUQYIKwYBBQUHMAKG\nRWh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvaGVsbXV0LXNjaG1pZHQtdW5pLWhoLWNh\nL3B1Yi9jYWNlcnQvY2FjZXJ0LmNydDBRBggrBgEFBQcwAoZFaHR0cDovL2NkcDIu\ncGNhLmRmbi5kZS9oZWxtdXQtc2NobWlkdC11bmktaGgtY2EvcHViL2NhY2VydC9j\nYWNlcnQuY3J0MA0GCSqGSIb3DQEBBQUAA4IBAQAVuAzmub19Uck2UxkTRAfgQ5Yz\noO3H9crRrXfAfi2EeS/2nd+pn/S9xwaeMcBE02SE6H2ujjWpb4T6zoe8oWeCihHt\nbByDVICPRMvPU0IkLgAlQmUgGTi7SMlFuv/inoEA0Cvjv6EGSC7L8JmzrUzB0Fgi\ns70BXg+QladY3A2Odwt3xgAeCZo8pXrrSqqEjgsToD/dSKi9hAdlah5feBRw8fGw\ng0sqqQB13BJSbmspSm/UTPv1ZQP7VrAIOpP2p9OLGARi9fLxpSfsczPS62BW69Xf\nmd5/h8e4VJDeQ8uU102FbhB7brNCg3SuWZsJivRwy1aaMDvL1zVDP7xULLCG", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "idp.ub.hsu-hh.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=idp.ub.hsu-hh.de,O=Helmut-Schmidt-Universitaet Universitaet der Bundeswehr Hamburg,L=Hamburg,ST=Hamburg,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFmTCCBIGgAwIBAgIEDtrvHzANBgkqhkiG9w0BAQUFADCBizELMAkGA1UEBhMC\nREUxSDBGBgNVBAoTP0hlbG11dC1TY2htaWR0LVVuaXZlcnNpdGFldCBVbml2ZXJz\naXRhZXQgZGVyIEJ1bmRlc3dlaHIgSGFtYnVyZzEVMBMGA1UEAxMMSFNVIENBIC0g\nRzAxMRswGQYJKoZIhvcNAQkBFgxjYUBoc3UtaGguZGUwHhcNMDkwOTI0MTMxODA4\nWhcNMTQwOTIzMTMxODA4WjCBljELMAkGA1UEBhMCREUxEDAOBgNVBAgTB0hhbWJ1\ncmcxEDAOBgNVBAcTB0hhbWJ1cmcxSDBGBgNVBAoTP0hlbG11dC1TY2htaWR0LVVu\naXZlcnNpdGFldCBVbml2ZXJzaXRhZXQgZGVyIEJ1bmRlc3dlaHIgSGFtYnVyZzEZ\nMBcGA1UEAxMQaWRwLnViLmhzdS1oaC5kZTCCASIwDQYJKoZIhvcNAQEBBQADggEP\nADCCAQoCggEBAJozfQt8GxD1AKQPEqsTcJipCihzU0Gc2gw+qkWWOLEN6K63wICQ\nCjnV2+n4I0uz1cAzzaauAkdFVCjxXrhgq8K/kYGiyLJvl+wHazN6SqSzrEskgCSR\nQrOrn8YzQTtWe7kZR9aVOJFY8p2MqL4UWwUNYqIe4+2InIn3qaimG1mP0CGJT8Ck\nLya8gg7LUWltXvVcWQmsJjBUGPR9TyNxBXTGn/tw0crt18w7TjiwwTacMAsaQEby\no2rHoEFe+c7gQF7ZMYc0yia1+oylmBLHuqy5Pxo3mxyG6fYflVwPMCye3BFEm6fI\nNJQvKZ04sKbk/8+wXsLUWsNhO62zajHYDY0CAwEAAaOCAfYwggHyMAkGA1UdEwQC\nMAAwCwYDVR0PBAQDAgXgMB0GA1UdJQQWMBQGCCsGAQUFBwMCBggrBgEFBQcDATAd\nBgNVHQ4EFgQUzCawY/z2k64WBdr0a5agbjeydZMwHwYDVR0jBBgwFoAU0OF/Hccy\nvOKQu1gUgBTGX53swaowIAYDVR0RBBkwF4EVaWRwQGhzdS1iaWJsaW90aGVrLmRl\nMIGdBgNVHR8EgZUwgZIwR6BFoEOGQWh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvaGVs\nbXV0LXNjaG1pZHQtdW5pLWhoLWNhL3B1Yi9jcmwvY2FjcmwuY3JsMEegRaBDhkFo\ndHRwOi8vY2RwMi5wY2EuZGZuLmRlL2hlbG11dC1zY2htaWR0LXVuaS1oaC1jYS9w\ndWIvY3JsL2NhY3JsLmNybDCBtgYIKwYBBQUHAQEEgakwgaYwUQYIKwYBBQUHMAKG\nRWh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvaGVsbXV0LXNjaG1pZHQtdW5pLWhoLWNh\nL3B1Yi9jYWNlcnQvY2FjZXJ0LmNydDBRBggrBgEFBQcwAoZFaHR0cDovL2NkcDIu\ncGNhLmRmbi5kZS9oZWxtdXQtc2NobWlkdC11bmktaGgtY2EvcHViL2NhY2VydC9j\nYWNlcnQuY3J0MA0GCSqGSIb3DQEBBQUAA4IBAQAVuAzmub19Uck2UxkTRAfgQ5Yz\noO3H9crRrXfAfi2EeS/2nd+pn/S9xwaeMcBE02SE6H2ujjWpb4T6zoe8oWeCihHt\nbByDVICPRMvPU0IkLgAlQmUgGTi7SMlFuv/inoEA0Cvjv6EGSC7L8JmzrUzB0Fgi\ns70BXg+QladY3A2Odwt3xgAeCZo8pXrrSqqEjgsToD/dSKi9hAdlah5feBRw8fGw\ng0sqqQB13BJSbmspSm/UTPv1ZQP7VrAIOpP2p9OLGARi9fLxpSfsczPS62BW69Xf\nmd5/h8e4VJDeQ8uU102FbhB7brNCg3SuWZsJivRwy1aaMDvL1zVDP7xULLCG", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "de", 
            "text": "Helmut-Schmidt-Universit\u00e4t", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "HSU Hamburg", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "http://ub.hsu-hh.de", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Ulrich", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "idp@hsu-bibliothek.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Hahn", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Ulrich", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "uhahn@hsu-bibliothek.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Hahn", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }
      ]
    }
  ], 
  [
    "https://dourado.ufs.br/idp/shibboleth", 
    {
      "entity_id": "https://dourado.ufs.br/idp/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/dourado.ufs.br.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://dourado.ufs.br/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://dourado.ufs.br/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://dourado.ufs.br/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://dourado.ufs.br/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "ufs.br", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "information_url": [
                  {
                    "lang": "en", 
                    "text": "http://www.ufs.br/", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "http://www.ufs.br/", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }
                ], 
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "UFS - Universidade Federal de Sergipe", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "UFS - Universidade Federal de Sergipe", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "en", 
                    "text": "UFS - Universidade Federal de Sergipe", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "UFS - Universidade Federal de Sergipe", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIEEjCCAvoCAQAwDQYJKoZIhvcNAQEFBQAwgc4xLjAsBgNVBAoTJVVGUyAtIFVu\naXZlcnNpZGFkZSBGZWRlcmFsIGRlIFNlcmdpcGUxLzAtBgNVBAsTJkNQRCAtIENl\nbnRybyBkZSBQcm9jZXNzYW1lbnRvIGRlIERhZG9zMRswGQYJKoZIhvcNAQkBFgxy\nZWRlc0B1ZnMuYnIxFjAUBgNVBAcTDVNhbyBDcmlzdG92YW8xEDAOBgNVBAgTB1Nl\ncmdpcGUxCzAJBgNVBAYTAkJSMRcwFQYDVQQDEw5kb3VyYWRvLnVmcy5icjAeFw0x\nMjEwMzAxNzI1NDFaFw0xNTEwMzAxNzI1NDFaMIHOMS4wLAYDVQQKEyVVRlMgLSBV\nbml2ZXJzaWRhZGUgRmVkZXJhbCBkZSBTZXJnaXBlMS8wLQYDVQQLEyZDUEQgLSBD\nZW50cm8gZGUgUHJvY2Vzc2FtZW50byBkZSBEYWRvczEbMBkGCSqGSIb3DQEJARYM\ncmVkZXNAdWZzLmJyMRYwFAYDVQQHEw1TYW8gQ3Jpc3RvdmFvMRAwDgYDVQQIEwdT\nZXJnaXBlMQswCQYDVQQGEwJCUjEXMBUGA1UEAxMOZG91cmFkby51ZnMuYnIwggEi\nMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCuuogQEudWqFoQPdA7n9TrUUYX\nXauTI4yRaEuEoeyvKultDI/HnZDCQ1so3QIjjlWgY5bLTOuYZR/+bw1ufVCtQNH8\nzCgEmnbjZVuG01q2eoOzCyLjL7I/HwhFHTXOKoXNLyC6K2JgF4QYDISAcVG7Xkhb\nD5dA6PGtwyCu+43hVKg42zu8R7KUJjj3Iu5FUTB9txGt4gM5j3twqDde6iNUXILh\n3Gf/V01JdGgIhLlsMf3d0ac1sH4Ks0KkaQsnhkc4Rt7fHDFlS3NkOTNt95oYyiOT\nSK/QZzbOr6TVOuC08Y+ya8BE2spu37VBaUCuers4FbfFp2WIu/XO8hfG9MJTAgMB\nAAEwDQYJKoZIhvcNAQEFBQADggEBAGm86P1eqdEODlBQrjKLcCm+jJOpSd2k+Yvg\nNgI6oDhoJnCA34RuO7dDKIE8OoWu51NYP3I2dZn8FGo4sGOagOtkfXBzGwTaGBbM\nnqjcHZbj7cqbBbdaWA10256dNN8lB6IX8IJTGB1vu2uSx6dbC3WdOO/POlkQGiYl\nEjldMN9pv9SRV4aj25Do4wPFnb+N/qTTNlXqUzvUXtkalwG1IuGfZIZSI4RHAQyB\nDU//RrjVffnvYgV75NfL3dX7wYbS9lP5NJ3CiBQmxUH+lGDx8F/CW1cObMYXfZSa\noAQqY3yZoERxESGkhFsV+v49S2aZ3baNM6Bt3YRPrCEUHY/lc8o=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://dourado.ufs.br:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }, 
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://dourado.ufs.br:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "pt-br", 
                "text": "http://www.rnp.br/_arquivo/servicos/Politica_CAFe_IDP_final.pdf", 
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy"
              }
            ], 
            "registration_authority": "http://cafe.rnp.br", 
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo", 
            "registration_instant": "2010-01-01T00:00:00Z"
          }
        ]
      }, 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://dourado.ufs.br:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://dourado.ufs.br:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "ufs.br", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIEEjCCAvoCAQAwDQYJKoZIhvcNAQEFBQAwgc4xLjAsBgNVBAoTJVVGUyAtIFVu\naXZlcnNpZGFkZSBGZWRlcmFsIGRlIFNlcmdpcGUxLzAtBgNVBAsTJkNQRCAtIENl\nbnRybyBkZSBQcm9jZXNzYW1lbnRvIGRlIERhZG9zMRswGQYJKoZIhvcNAQkBFgxy\nZWRlc0B1ZnMuYnIxFjAUBgNVBAcTDVNhbyBDcmlzdG92YW8xEDAOBgNVBAgTB1Nl\ncmdpcGUxCzAJBgNVBAYTAkJSMRcwFQYDVQQDEw5kb3VyYWRvLnVmcy5icjAeFw0x\nMjEwMzAxNzI1NDFaFw0xNTEwMzAxNzI1NDFaMIHOMS4wLAYDVQQKEyVVRlMgLSBV\nbml2ZXJzaWRhZGUgRmVkZXJhbCBkZSBTZXJnaXBlMS8wLQYDVQQLEyZDUEQgLSBD\nZW50cm8gZGUgUHJvY2Vzc2FtZW50byBkZSBEYWRvczEbMBkGCSqGSIb3DQEJARYM\ncmVkZXNAdWZzLmJyMRYwFAYDVQQHEw1TYW8gQ3Jpc3RvdmFvMRAwDgYDVQQIEwdT\nZXJnaXBlMQswCQYDVQQGEwJCUjEXMBUGA1UEAxMOZG91cmFkby51ZnMuYnIwggEi\nMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCuuogQEudWqFoQPdA7n9TrUUYX\nXauTI4yRaEuEoeyvKultDI/HnZDCQ1so3QIjjlWgY5bLTOuYZR/+bw1ufVCtQNH8\nzCgEmnbjZVuG01q2eoOzCyLjL7I/HwhFHTXOKoXNLyC6K2JgF4QYDISAcVG7Xkhb\nD5dA6PGtwyCu+43hVKg42zu8R7KUJjj3Iu5FUTB9txGt4gM5j3twqDde6iNUXILh\n3Gf/V01JdGgIhLlsMf3d0ac1sH4Ks0KkaQsnhkc4Rt7fHDFlS3NkOTNt95oYyiOT\nSK/QZzbOr6TVOuC08Y+ya8BE2spu37VBaUCuers4FbfFp2WIu/XO8hfG9MJTAgMB\nAAEwDQYJKoZIhvcNAQEFBQADggEBAGm86P1eqdEODlBQrjKLcCm+jJOpSd2k+Yvg\nNgI6oDhoJnCA34RuO7dDKIE8OoWu51NYP3I2dZn8FGo4sGOagOtkfXBzGwTaGBbM\nnqjcHZbj7cqbBbdaWA10256dNN8lB6IX8IJTGB1vu2uSx6dbC3WdOO/POlkQGiYl\nEjldMN9pv9SRV4aj25Do4wPFnb+N/qTTNlXqUzvUXtkalwG1IuGfZIZSI4RHAQyB\nDU//RrjVffnvYgV75NfL3dX7wYbS9lP5NJ3CiBQmxUH+lGDx8F/CW1cObMYXfZSa\noAQqY3yZoERxESGkhFsV+v49S2aZ3baNM6Bt3YRPrCEUHY/lc8o=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "UFS - Universidade Federal de Sergipe", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }, 
          {
            "lang": "pt-br", 
            "text": "UFS - Universidade Federal de Sergipe", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "UFS - Universidade Federal de Sergipe", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }, 
          {
            "lang": "pt-br", 
            "text": "UFS - Universidade Federal de Sergipe", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.ufs.br/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }, 
          {
            "lang": "pt-br", 
            "text": "http://www.ufs.br/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "email_address": [
            {
              "text": "rodrigus@ufs.br", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Rodrigus Oliveira Feitosa", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://capuccino.info.ufrn.br/idp/shibboleth", 
    {
      "entity_id": "https://capuccino.info.ufrn.br/idp/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/capuccino.info.ufrn.br.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://capuccino.info.ufrn.br/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://capuccino.info.ufrn.br/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://capuccino.info.ufrn.br/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://capuccino.info.ufrn.br/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "ufrn.br", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "information_url": [
                  {
                    "lang": "en", 
                    "text": "http://www.ufrn.br/", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "http://www.ufrn.br/", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }
                ], 
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "UFRN - Universidade Federal do Rio Grande do Norte", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "UFRN - Universidade Federal do Rio Grande do Norte", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "en", 
                    "text": "UFRN - Universidade Federal do Rio Grande do Norte", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "UFRN - Universidade Federal do Rio Grande do Norte", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIEUjCCAzoCAQAwDQYJKoZIhvcNAQEFBQAwge4xOzA5BgNVBAoTMlVGUk4gLSBV\nbml2ZXJzaWRhZGUgRmVkZXJhbCBkbyBSaW8gZ3JhbmRlIGRvIE5vcnRlMTAwLgYD\nVQQLEydTaW5mbyAtIFN1cGVyaW50ZW5kZW5jaWEgZGUgaW5mb3JtYXRpY2ExITAf\nBgkqhkiG9w0BCQEWEnJlZGVzQGluZm8udWZybi5icjEOMAwGA1UEBxMFTmF0YWwx\nHDAaBgNVBAgTE1JpbyBHcmFuZGUgZG8gTm9ydGUxCzAJBgNVBAYTAkJSMR8wHQYD\nVQQDExZjYXB1Y2Npbm8uaW5mby51ZnJuLmJyMB4XDTEyMDYxODE3NTA0M1oXDTE1\nMDYxODE3NTA0M1owge4xOzA5BgNVBAoTMlVGUk4gLSBVbml2ZXJzaWRhZGUgRmVk\nZXJhbCBkbyBSaW8gZ3JhbmRlIGRvIE5vcnRlMTAwLgYDVQQLEydTaW5mbyAtIFN1\ncGVyaW50ZW5kZW5jaWEgZGUgaW5mb3JtYXRpY2ExITAfBgkqhkiG9w0BCQEWEnJl\nZGVzQGluZm8udWZybi5icjEOMAwGA1UEBxMFTmF0YWwxHDAaBgNVBAgTE1JpbyBH\ncmFuZGUgZG8gTm9ydGUxCzAJBgNVBAYTAkJSMR8wHQYDVQQDExZjYXB1Y2Npbm8u\naW5mby51ZnJuLmJyMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA1tLx\n+5Q99cvQ6T4dFLqtoXnaeVtePhdogMKFxJsNwxWL901s+NPJT3f4dkEJ9rMry6g2\nWg9U+f96mY5iViRSP09RF6IPyHwU0xUh6gZE2ggvLKKbddkU9I380M3n0SJWRSXe\nrMZwL1qiVEA+Ysgvh1CS+NWKmTzn1GC3MCUjB4mA8fdZ+Xh+SlCbSEtbTo0nQxqt\ng2xx+t+jO2YZIawYp+pYEza5gMWTI58csYXijWzWV/SqaUXDN7nEd08UpLVyzKEf\nrtFsA/U5/v3cqdQ3f9czTABbp6RQuN8sXJ1z/rpID+og2W3o0QmIaJ/GtocyEWtK\nU8KkFewao0aPe2OITQIDAQABMA0GCSqGSIb3DQEBBQUAA4IBAQBm3htwaGiZLjwh\naJBskxikHeSo95d8uf9Jnh/Ce8KiarRS98hTnn+MBzCcQdQMl6+rVf7Nd9ecRAUC\nUROzPMhbd3+4CF1seVnHbQItxJJdHpvp4KgmkysIqGHXbdy2ah5ajnP+29ow9Uyf\nMUewqb/okcT6h9InBfNzL2bDTOpvy2HsKWcxfX+QArNJnW4mLUqCOa4pfUfv8D5B\no26FhWVhKC93SsUtin1nMtt0/Mw/kRhP30DSsdUzkZBCgL0KnFvdyuy9agT2t0FX\nVoyPFzWCEFj7zzgaFo4Lyc+HeehnKK8p9cZEZu0Jl0r0qFuI65LpMXttzrGxEmlE\nwaiW5wfG", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://capuccino.info.ufrn.br:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }, 
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://capuccino.info.ufrn.br:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "pt-br", 
                "text": "http://www.rnp.br/_arquivo/servicos/Politica_CAFe_IDP_final.pdf", 
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy"
              }
            ], 
            "registration_authority": "http://cafe.rnp.br", 
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo", 
            "registration_instant": "2010-01-01T00:00:00Z"
          }
        ]
      }, 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://capuccino.info.ufrn.br:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://capuccino.info.ufrn.br:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "ufrn.br", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIEUjCCAzoCAQAwDQYJKoZIhvcNAQEFBQAwge4xOzA5BgNVBAoTMlVGUk4gLSBV\nbml2ZXJzaWRhZGUgRmVkZXJhbCBkbyBSaW8gZ3JhbmRlIGRvIE5vcnRlMTAwLgYD\nVQQLEydTaW5mbyAtIFN1cGVyaW50ZW5kZW5jaWEgZGUgaW5mb3JtYXRpY2ExITAf\nBgkqhkiG9w0BCQEWEnJlZGVzQGluZm8udWZybi5icjEOMAwGA1UEBxMFTmF0YWwx\nHDAaBgNVBAgTE1JpbyBHcmFuZGUgZG8gTm9ydGUxCzAJBgNVBAYTAkJSMR8wHQYD\nVQQDExZjYXB1Y2Npbm8uaW5mby51ZnJuLmJyMB4XDTEyMDYxODE3NTA0M1oXDTE1\nMDYxODE3NTA0M1owge4xOzA5BgNVBAoTMlVGUk4gLSBVbml2ZXJzaWRhZGUgRmVk\nZXJhbCBkbyBSaW8gZ3JhbmRlIGRvIE5vcnRlMTAwLgYDVQQLEydTaW5mbyAtIFN1\ncGVyaW50ZW5kZW5jaWEgZGUgaW5mb3JtYXRpY2ExITAfBgkqhkiG9w0BCQEWEnJl\nZGVzQGluZm8udWZybi5icjEOMAwGA1UEBxMFTmF0YWwxHDAaBgNVBAgTE1JpbyBH\ncmFuZGUgZG8gTm9ydGUxCzAJBgNVBAYTAkJSMR8wHQYDVQQDExZjYXB1Y2Npbm8u\naW5mby51ZnJuLmJyMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA1tLx\n+5Q99cvQ6T4dFLqtoXnaeVtePhdogMKFxJsNwxWL901s+NPJT3f4dkEJ9rMry6g2\nWg9U+f96mY5iViRSP09RF6IPyHwU0xUh6gZE2ggvLKKbddkU9I380M3n0SJWRSXe\nrMZwL1qiVEA+Ysgvh1CS+NWKmTzn1GC3MCUjB4mA8fdZ+Xh+SlCbSEtbTo0nQxqt\ng2xx+t+jO2YZIawYp+pYEza5gMWTI58csYXijWzWV/SqaUXDN7nEd08UpLVyzKEf\nrtFsA/U5/v3cqdQ3f9czTABbp6RQuN8sXJ1z/rpID+og2W3o0QmIaJ/GtocyEWtK\nU8KkFewao0aPe2OITQIDAQABMA0GCSqGSIb3DQEBBQUAA4IBAQBm3htwaGiZLjwh\naJBskxikHeSo95d8uf9Jnh/Ce8KiarRS98hTnn+MBzCcQdQMl6+rVf7Nd9ecRAUC\nUROzPMhbd3+4CF1seVnHbQItxJJdHpvp4KgmkysIqGHXbdy2ah5ajnP+29ow9Uyf\nMUewqb/okcT6h9InBfNzL2bDTOpvy2HsKWcxfX+QArNJnW4mLUqCOa4pfUfv8D5B\no26FhWVhKC93SsUtin1nMtt0/Mw/kRhP30DSsdUzkZBCgL0KnFvdyuy9agT2t0FX\nVoyPFzWCEFj7zzgaFo4Lyc+HeehnKK8p9cZEZu0Jl0r0qFuI65LpMXttzrGxEmlE\nwaiW5wfG", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "UFRN - Universidade Federal do Rio Grande do Norte", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }, 
          {
            "lang": "pt-br", 
            "text": "UFRN - Universidade Federal do Rio Grande do Norte", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "UFRN - Universidade Federal do Rio Grande do Norte", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }, 
          {
            "lang": "pt-br", 
            "text": "UFRN - Universidade Federal do Rio Grande do Norte", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.ufrn.br/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }, 
          {
            "lang": "pt-br", 
            "text": "http://www.ufrn.br/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "email_address": [
            {
              "text": "redes@info.ufrn.br", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "SINFO", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://sgw.africa-grid.org/shibboleth", 
    {
      "entity_id": "https://sgw.africa-grid.org/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-2.0/sgw.africa-grid.org-shibboleth.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Consorzio COMETA", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "COMETA", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.consorzio-cometa.it/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Marco", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "mailto:marco.fargetta@ct.infn.it", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }, 
            {
              "text": "mailto:credentials-admin@ct.infn.it", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Fargetta", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Roberto", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "mailto:roberto.barbera@ct.infn.it", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }, 
            {
              "text": "mailto:credentials-admin@ct.infn.it", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Barbera", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }
      ], 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://sgw.africa-grid.org/Shibboleth.sso/SLO/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://sgw.africa-grid.org/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://sgw.africa-grid.org/Shibboleth.sso/SLO/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://sgw.africa-grid.org/Shibboleth.sso/SLO/Artifact"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sgw.africa-grid.org/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sgw.africa-grid.org/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sgw.africa-grid.org/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sgw.africa-grid.org/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sgw.africa-grid.org/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sgw.africa-grid.org/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Africa Grid Science Gateway", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }, 
                  {
                    "lang": "it", 
                    "text": "Africa Grid Science Gateway", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "en", 
                    "text": "This service allows to use on a Grid infrastructure the lighthouse applications of the eI4Africa project", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }, 
                  {
                    "lang": "it", 
                    "text": "Questo servizio permette l'accesso e l'uso delle applicazioni/servizi Grid sviluppati per il progetto eI4Africa", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }, 
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://sgw.africa-grid.org/Shibboleth.sso/DS"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "text": "www.catania-science-gateways.it", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }, 
                  {
                    "text": "aginfra-sg.ct.infn.it", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }, 
                  {
                    "text": "cogito-med.ct.infn.it", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }, 
                  {
                    "text": "earthserver-sg.consorzio-cometa.it", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }, 
                  {
                    "text": "ecsg.dch-rp.eu", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }, 
                  {
                    "text": "garr-sg.ct.infn.it", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }, 
                  {
                    "text": "klios.ct.infn.it", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }, 
                  {
                    "text": "liferay2.ct.infn.it", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }, 
                  {
                    "text": "sgw.africa-grid.org", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }, 
                  {
                    "text": "www.progetto-icaro.it", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=www.catania-science-gateways.it,OU=COMETA,O=Istituto Nazionale di Fisica Nucleare,street=Via S.Sofia n.64,L=Catania,ST=Italy,postalCode=95123,C=IT", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIF0TCCBLmgAwIBAgIRAJjvs9uxU/ydSPVPqQh6szEwDQYJKoZIhvcNAQEFBQAw\nNjELMAkGA1UEBhMCTkwxDzANBgNVBAoTBlRFUkVOQTEWMBQGA1UEAxMNVEVSRU5B\nIFNTTCBDQTAeFw0xMzAxMDcwMDAwMDBaFw0xNjAxMDcyMzU5NTlaMIHFMQswCQYD\nVQQGEwJJVDEOMAwGA1UEERMFOTUxMjMxDjAMBgNVBAgTBUl0YWx5MRAwDgYDVQQH\nEwdDYXRhbmlhMRkwFwYDVQQJExBWaWEgUy5Tb2ZpYSBuLjY0MS4wLAYDVQQKEyVJ\nc3RpdHV0byBOYXppb25hbGUgZGkgRmlzaWNhIE51Y2xlYXJlMQ8wDQYDVQQLEwZD\nT01FVEExKDAmBgNVBAMTH3d3dy5jYXRhbmlhLXNjaWVuY2UtZ2F0ZXdheXMuaXQw\nggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDMR2RMw4cNImWSKdvZjDhz\n3JuO7/pMOnGw4hF6uu09cqX8qqBpkU/gd33xq7J254ojywwiIlLT7QaTce4YQU2W\nO5mPyqdHjnpA+C0fJWrQgRyJEXsOzwpxyUG42tim/9jgNNDaUuNSGgrMLGlzl0sU\ni3Cq04AY0hukrtFGe6DFvDsm8xoNwfV8jmO3IipWJdJdezRnCGDgTZqgIWj3yrHo\nLjfgLbs85AJ31plMahcEni1jDZYgzu7FurbKpO4FGSLUEI8VUxncdYx3IWidqYBD\nTjxFGIiRIcD59DTIBxZYT4IgGHhG1whnUtE7nZhtuxFvnxfH4gPi7mPcRwidNHg9\nAgMBAAGjggJIMIICRDAfBgNVHSMEGDAWgBQMvZNoDPPeq6NJays3V0fqkOO57TAd\nBgNVHQ4EFgQU+qOkofxo+Ei3aGD2lLEkM4L7LS0wDgYDVR0PAQH/BAQDAgWgMAwG\nA1UdEwEB/wQCMAAwHQYDVR0lBBYwFAYIKwYBBQUHAwEGCCsGAQUFBwMCMCIGA1Ud\nIAQbMBkwDQYLKwYBBAGyMQECAh0wCAYGZ4EMAQICMDoGA1UdHwQzMDEwL6AtoCuG\nKWh0dHA6Ly9jcmwudGNzLnRlcmVuYS5vcmcvVEVSRU5BU1NMQ0EuY3JsMG0GCCsG\nAQUFBwEBBGEwXzA1BggrBgEFBQcwAoYpaHR0cDovL2NydC50Y3MudGVyZW5hLm9y\nZy9URVJFTkFTU0xDQS5jcnQwJgYIKwYBBQUHMAGGGmh0dHA6Ly9vY3NwLnRjcy50\nZXJlbmEub3JnMIH1BgNVHREEge0wgeqCH3d3dy5jYXRhbmlhLXNjaWVuY2UtZ2F0\nZXdheXMuaXSCFWFnaW5mcmEtc2cuY3QuaW5mbi5pdIIVY29naXRvLW1lZC5jdC5p\nbmZuLml0giJlYXJ0aHNlcnZlci1zZy5jb25zb3J6aW8tY29tZXRhLml0gg5lY3Nn\nLmRjaC1ycC5ldYISZ2Fyci1zZy5jdC5pbmZuLml0ghBrbGlvcy5jdC5pbmZuLml0\nghNsaWZlcmF5Mi5jdC5pbmZuLml0ghNzZ3cuYWZyaWNhLWdyaWQub3JnghV3d3cu\ncHJvZ2V0dG8taWNhcm8uaXQwDQYJKoZIhvcNAQEFBQADggEBAIzikPZKDI8rXlUU\niF8KUeEVYZMyBfRtl0sQYBZCprDoVpCr74CPTxQ72Jrh2mD8oAz0ZYVgOA19AbM8\nPskJlhx4bmDJvWU/C2FrOgYDNg9Tl7dqLnr18GDt7DuC0KXCDupgtBmwy7mayNgA\nn2jbIaYsfMI7k1msS1XoaVX7kBMgmeGY3V11Om9Te7iMWKFOhpavI2hbf741ODtV\nzBen58Q2WzjVEKVQYbY7UgtcYzOM44GhMcdS65lLsBviK7HzyB6I5Iu3TR0bcpFE\n2V4bd6L5foq3Qn+WO9wqOwnOk3qfD/TQId7NWv0ZE2vp8fPPaaRF2XcA7Qh5xltt\nj/MCNlE=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://sgw.africa-grid.org/Shibboleth.sso/Artifact/SOAP"
            }
          ], 
          "attribute_consuming_service": [
            {
              "index": "1", 
              "service_description": [
                {
                  "lang": "en", 
                  "text": "This service allows to use on a Grid infrastructure the lighthouse applications of the eI4Africa project", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription"
                }
              ], 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService", 
              "requested_attribute": [
                {
                  "is_required": "true", 
                  "friendly_name": "mail", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:0.9.2342.19200300.100.1.3"
                }
              ], 
              "service_name": [
                {
                  "lang": "en", 
                  "text": "Africa Grid Science Gateway", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }
              ]
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://sp.eblib.com/shibboleth", 
    {
      "entity_id": "https://sp.eblib.com/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/sp.eblib.com.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "organization": {
        "organization_name": [
          {
            "lang": "de", 
            "text": "Ebook Library", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "EBL", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "http://www.eblib.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Vinay", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "v@ebooks.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Bharadwaj", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://sp.eblib.com/Shibboleth.sso/SLO/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://sp.eblib.com/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://sp.eblib.com/Shibboleth.sso/SLO/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://sp.eblib.com/Shibboleth.sso/SLO/Artifact"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sp.eblib.com/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sp.eblib.com/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sp.eblib.com/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sp.eblib.com/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sp.eblib.com/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sp.eblib.com/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://sp.eblib.com/Shibboleth.sso/DS"
              }, 
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://sp.eblib.com/Shibboleth.sso/ACODS"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "ebooks.com", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "emailAddress=vinay.bharadwaj@ebooks.com,CN=ebooks.com,OU=Area Servizi ICT,O=Politecnico di Milano,L=Milan,ST=Milan,C=IT", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIDNzCCAqCgAwIBAgIBATANBgkqhkiG9w0BAQUFADCBqDELMAkGA1UEBhMCSVQx\nDjAMBgNVBAgTBU1pbGFuMQ4wDAYDVQQHEwVNaWxhbjEeMBwGA1UEChMVUG9saXRl\nY25pY28gZGkgTWlsYW5vMRkwFwYDVQQLExBBcmVhIFNlcnZpemkgSUNUMRMwEQYD\nVQQDEwplYm9va3MuY29tMSkwJwYJKoZIhvcNAQkBFhp2aW5heS5iaGFyYWR3YWpA\nZWJvb2tzLmNvbTAeFw0xMTAyMjMxNTU2NDRaFw0xNjAyMjIxNTU2NDRaMIGoMQsw\nCQYDVQQGEwJJVDEOMAwGA1UECBMFTWlsYW4xDjAMBgNVBAcTBU1pbGFuMR4wHAYD\nVQQKExVQb2xpdGVjbmljbyBkaSBNaWxhbm8xGTAXBgNVBAsTEEFyZWEgU2Vydml6\naSBJQ1QxEzARBgNVBAMTCmVib29rcy5jb20xKTAnBgkqhkiG9w0BCQEWGnZpbmF5\nLmJoYXJhZHdhakBlYm9va3MuY29tMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKB\ngQD9XQY5ysPYf4+guHJH+o75Ebn+bXE44uogDRo+IMLqCKxvEV5+C9RaDLKmeAs1\nYbYaHRx1Y5bHgHgj4nX44k266qpV78WoUEslkP9ivOKW4+waMzYvRGSC++vMIVtr\nir6jQ94WvCxnS6JPJ5mDX6mEiVPIfuevBqYt+Cgj0Q2bMQIDAQABo28wbTAMBgNV\nHRMBAf8EAjAAMB0GA1UdDgQWBBS99SAMv7ZRQnNJ64Q5iC+xVikSCDALBgNVHQ8E\nBAMCBLAwEQYJYIZIAYb4QgEBBAQDAgWgMB4GCWCGSAGG+EIBDQQRFg94Y2EgY2Vy\ndGlmaWNhdGUwDQYJKoZIhvcNAQEFBQADgYEAG9XLSlU6eORQ1LTL481PFvwsmxUq\nq0Dc6MRsFLwilB3nI1MyA9R6EDh/Tw1Fo7YiZ397OrgYEMvVV5GC+z923Zta9pI+\nh71V8Nt69iFENpx52d3BuYDNkhjSf5oo1KkVHgAmhCPjhFqFa+B6BE79KIz2Bwrx\nYzM6IclOG3yKzoY=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "ebooks.com", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "emailAddress=vinay.bharadwaj@ebooks.com,CN=ebooks.com,OU=Area Servizi ICT,O=Politecnico di Milano,L=Milan,ST=Milan,C=IT", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIDNzCCAqCgAwIBAgIBATANBgkqhkiG9w0BAQUFADCBqDELMAkGA1UEBhMCSVQx\nDjAMBgNVBAgTBU1pbGFuMQ4wDAYDVQQHEwVNaWxhbjEeMBwGA1UEChMVUG9saXRl\nY25pY28gZGkgTWlsYW5vMRkwFwYDVQQLExBBcmVhIFNlcnZpemkgSUNUMRMwEQYD\nVQQDEwplYm9va3MuY29tMSkwJwYJKoZIhvcNAQkBFhp2aW5heS5iaGFyYWR3YWpA\nZWJvb2tzLmNvbTAeFw0xMTAyMjMxNTU2NDRaFw0xNjAyMjIxNTU2NDRaMIGoMQsw\nCQYDVQQGEwJJVDEOMAwGA1UECBMFTWlsYW4xDjAMBgNVBAcTBU1pbGFuMR4wHAYD\nVQQKExVQb2xpdGVjbmljbyBkaSBNaWxhbm8xGTAXBgNVBAsTEEFyZWEgU2Vydml6\naSBJQ1QxEzARBgNVBAMTCmVib29rcy5jb20xKTAnBgkqhkiG9w0BCQEWGnZpbmF5\nLmJoYXJhZHdhakBlYm9va3MuY29tMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKB\ngQD9XQY5ysPYf4+guHJH+o75Ebn+bXE44uogDRo+IMLqCKxvEV5+C9RaDLKmeAs1\nYbYaHRx1Y5bHgHgj4nX44k266qpV78WoUEslkP9ivOKW4+waMzYvRGSC++vMIVtr\nir6jQ94WvCxnS6JPJ5mDX6mEiVPIfuevBqYt+Cgj0Q2bMQIDAQABo28wbTAMBgNV\nHRMBAf8EAjAAMB0GA1UdDgQWBBS99SAMv7ZRQnNJ64Q5iC+xVikSCDALBgNVHQ8E\nBAMCBLAwEQYJYIZIAYb4QgEBBAQDAgWgMB4GCWCGSAGG+EIBDQQRFg94Y2EgY2Vy\ndGlmaWNhdGUwDQYJKoZIhvcNAQEFBQADgYEAG9XLSlU6eORQ1LTL481PFvwsmxUq\nq0Dc6MRsFLwilB3nI1MyA9R6EDh/Tw1Fo7YiZ397OrgYEMvVV5GC+z923Zta9pI+\nh71V8Nt69iFENpx52d3BuYDNkhjSf5oo1KkVHgAmhCPjhFqFa+B6BE79KIz2Bwrx\nYzM6IclOG3yKzoY=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://sp.eblib.com/Shibboleth.sso/NIM/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://sp.eblib.com/Shibboleth.sso/NIM/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://sp.eblib.com/Shibboleth.sso/NIM/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://sp.eblib.com/Shibboleth.sso/NIM/Artifact"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://fordrop.irt.kth.se/shibboleth", 
    {
      "entity_id": "https://fordrop.irt.kth.se/shibboleth", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://fordrop.irt.kth.se/Shibboleth.sso/SLO/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://fordrop.irt.kth.se/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://fordrop.irt.kth.se/Shibboleth.sso/SLO/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://fordrop.irt.kth.se/Shibboleth.sso/SLO/Artifact"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://fordrop.irt.kth.se/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://fordrop.irt.kth.se/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://fordrop.irt.kth.se/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://fordrop.irt.kth.se/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://fordrop.irt.kth.se/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://fordrop.irt.kth.se/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://fordrop.irt.kth.se/Shibboleth.sso/DS"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "fordrop.irt.kth.se", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=fordrop.irt.kth.se", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIDETCCAfmgAwIBAgIJALYWrF8Mgt6iMA0GCSqGSIb3DQEBBQUAMB0xGzAZBgNV\nBAMTEmZvcmRyb3AuaXJ0Lmt0aC5zZTAeFw0xMDA0MjMxMjEwMTRaFw0yMDA0MjAx\nMjEwMTRaMB0xGzAZBgNVBAMTEmZvcmRyb3AuaXJ0Lmt0aC5zZTCCASIwDQYJKoZI\nhvcNAQEBBQADggEPADCCAQoCggEBALDjcpcRnb1b7Cfk9KuJpabF6iLe62b0p1mi\nCfGwleRoaANiDGHu01m4gnXvsA6yk1bedJP6z7Pl0rQkMZ2tlDcCEMg8AwyTQL2v\nY10C20c+rSbfXoWNUI8jyAtLsNBKwsSTvid64x8l5gGpJZCpgfvK6kYJcrLokLqs\n6lWrrad/VecTHzklXWEAhxeCD7eUUJtC0Y4Fi8XhKS7BKKI7JG+YbPocVnP/opFh\nWGe4Q6+wPWU1I7X1HC2bKrEpvwVZsgFN4V0E7wnrDe1yotM6CqlsuWPvyCD4/IYB\nAnOtiMZJMQ0hbeaYoXW+oSvD/aYkJSfQEfMN+4hdo9L1OyvPIwMCAwEAAaNUMFIw\nMQYDVR0RBCowKIISZm9yZHJvcC5pcnQua3RoLnNlhhJmb3Jkcm9wLmlydC5rdGgu\nc2UwHQYDVR0OBBYEFE5WIOqS0aJWpa1XenjHOgjF1BINMA0GCSqGSIb3DQEBBQUA\nA4IBAQBOLO7wR5XjinscjsU2AvZ9s6shS/pcIA+4/OyNYmHr4i3frmu31WqMfY1j\nWhUpLHCKl4EYJubk0HwAq25b8l7Jwmz2UbtyZ7QvV1vGUqo0oxVK9p0rS7ojO1f7\nmrdBB0U3Axu4vW+ckKyGR6NRDYMobRrG04XCOi88NskTHL3VLRA6zNegFre9VdJI\npw3UvNnJVA9f5U6hOjK5BhxhE/6sNwRDWWWsLlkjzWtqFbTkmRU6cicyvDoD2jzS\nGf34FPGbKFm1+jJpyOoBAfizkFtGFRM3zkyhGZtGcQgUobPdCUEpCnAkqOIs/bpZ\n3IRNZyiAYdh9b48o6SY/HQuZn5VP", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "fordrop.irt.kth.se", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=fordrop.irt.kth.se", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIDETCCAfmgAwIBAgIJALYWrF8Mgt6iMA0GCSqGSIb3DQEBBQUAMB0xGzAZBgNV\nBAMTEmZvcmRyb3AuaXJ0Lmt0aC5zZTAeFw0xMDA0MjMxMjEwMTRaFw0yMDA0MjAx\nMjEwMTRaMB0xGzAZBgNVBAMTEmZvcmRyb3AuaXJ0Lmt0aC5zZTCCASIwDQYJKoZI\nhvcNAQEBBQADggEPADCCAQoCggEBALDjcpcRnb1b7Cfk9KuJpabF6iLe62b0p1mi\nCfGwleRoaANiDGHu01m4gnXvsA6yk1bedJP6z7Pl0rQkMZ2tlDcCEMg8AwyTQL2v\nY10C20c+rSbfXoWNUI8jyAtLsNBKwsSTvid64x8l5gGpJZCpgfvK6kYJcrLokLqs\n6lWrrad/VecTHzklXWEAhxeCD7eUUJtC0Y4Fi8XhKS7BKKI7JG+YbPocVnP/opFh\nWGe4Q6+wPWU1I7X1HC2bKrEpvwVZsgFN4V0E7wnrDe1yotM6CqlsuWPvyCD4/IYB\nAnOtiMZJMQ0hbeaYoXW+oSvD/aYkJSfQEfMN+4hdo9L1OyvPIwMCAwEAAaNUMFIw\nMQYDVR0RBCowKIISZm9yZHJvcC5pcnQua3RoLnNlhhJmb3Jkcm9wLmlydC5rdGgu\nc2UwHQYDVR0OBBYEFE5WIOqS0aJWpa1XenjHOgjF1BINMA0GCSqGSIb3DQEBBQUA\nA4IBAQBOLO7wR5XjinscjsU2AvZ9s6shS/pcIA+4/OyNYmHr4i3frmu31WqMfY1j\nWhUpLHCKl4EYJubk0HwAq25b8l7Jwmz2UbtyZ7QvV1vGUqo0oxVK9p0rS7ojO1f7\nmrdBB0U3Axu4vW+ckKyGR6NRDYMobRrG04XCOi88NskTHL3VLRA6zNegFre9VdJI\npw3UvNnJVA9f5U6hOjK5BhxhE/6sNwRDWWWsLlkjzWtqFbTkmRU6cicyvDoD2jzS\nGf34FPGbKFm1+jJpyOoBAfizkFtGFRM3zkyhGZtGcQgUobPdCUEpCnAkqOIs/bpZ\n3IRNZyiAYdh9b48o6SY/HQuZn5VP", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://fordrop.irt.kth.se/Shibboleth.sso/NIM/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://fordrop.irt.kth.se/Shibboleth.sso/NIM/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://fordrop.irt.kth.se/Shibboleth.sso/NIM/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://fordrop.irt.kth.se/Shibboleth.sso/NIM/Artifact"
            }
          ]
        }
      ], 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-2.0/fordrop.irt.kth.se-shibboleth.xml"
      }
    }
  ], 
  [
    "https://betafoo.nordu.net/saml2/metadata/", 
    {
      "contact_person": [
        {
          "contact_type": "technical", 
          "company": {
            "text": "NORDUnet A/S", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Company"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "sur_name": {
            "text": "Lundberg", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "given_name": {
            "text": "Johan", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "lundberg@nordu.net", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ]
        }
      ], 
      "entity_id": "https://betafoo.nordu.net/saml2/metadata/", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://betafoo.nordu.net/saml2/ls/"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://betafoo.nordu.net/saml2/acs/"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIC3DCCAcSgAwIBAgIJAMvFLpEMEvybMA0GCSqGSIb3DQEBBQUAMBIxEDAOBgNV\nBAMTB2JldGFmb28wHhcNMTIwMTIzMTMwNzAwWhcNMjIwMTIwMTMwNzAwWjASMRAw\nDgYDVQQDEwdiZXRhZm9vMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA\nn96BBnx0AbGpOlFnSJB2OM5eq/7nzzUx/lwfXIUxolYmz3m7QD16V6+wSRaVvK9R\n+83uUFjiFlKs9OEFRfcDJYgYhlV7r/SXyy41AlPrsqTCuYwEMErtVXePOc88it+V\nnX2wamumJxszGFxon9NXqwnTaza/yM0DFXPi5GJLwI0nhKugiXmlFQHICq2xcNBA\nEGjHQrL2FM//Fg3f8OJsJzqu2GjplWLNrphbdDH3++RJQQ+cNWq4XOzxTnM4BYoj\nn0Avwn35xA7dYdb7cu1qTzss/KCjjDxrJBE7mxJ9b1TK0gxSANfkiKxveJrAJque\nYjLmt2F268BRyMncF91SNwIDAQABozUwMzASBgNVHREECzAJggdiZXRhZm9vMB0G\nA1UdDgQWBBQCWrIP+6UbPqDmZu4046xkI8hUwjANBgkqhkiG9w0BAQUFAAOCAQEA\nEDFP2mVE6wKa2qQdfJUPGLnPp8a5UZKkwrvGpRYcgPp2JRUPRY0sBJlOPM8JeGKi\nrdb+7oWy5pHdpXWEY3gD+Vod7aHJ2g8fQ70l+nqHmh5pFTzqb3dnh8Dbn9M8cG0F\n2bATYYQt7fLEmGIFQ81Ix5Qnm+owPw7QxemE7DaGL4CCyNB5xiX0Kx38eCeEFps8\nFqI3Il3tF2U+FgOT+nizupQelaoagRNerw3p2FHEYeBaTCYiW3IF7lUMIjoX2MYI\n9P5iyOC2nGSq2vAzarevECtjw7KtKuX4K37LIEB5r07NXCPlfgTzHq1KomrY5Lhm\n91krk/l5w5Ayt90FuWQbAA==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "want_assertions_signed": "true", 
          "authn_requests_signed": "false", 
          "attribute_consuming_service": [
            {
              "index": "1", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService", 
              "requested_attribute": [
                {
                  "is_required": "true", 
                  "friendly_name": "uid", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "0.9.2342.19200300.100.1.1"
                }, 
                {
                  "is_required": "false", 
                  "friendly_name": "eduPersonAffiliation", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.1"
                }
              ], 
              "service_name": [
                {
                  "lang": "en", 
                  "text": "Federated Django sample SP", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }
              ]
            }
          ]
        }
      ], 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-2.0/betafoo.nordu.net-saml2-metadata.xml"
      }
    }
  ], 
  [
    "https://sp2.cesnet.cz/sp/shibboleth/edugain", 
    {
      "entity_id": "https://sp2.cesnet.cz/sp/shibboleth/edugain", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/sp2.cesnet.cz.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "en", 
                "text": "http://www.eduid.cz/wiki/_media/en/eduid/policy/policy_eduid_en-1_1.pdf", 
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy"
              }, 
              {
                "lang": "cs", 
                "text": "http://www.eduid.cz/wiki/_media/eduid/policy/policy_eduid_cz-1_1-3.pdf", 
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy"
              }
            ], 
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo", 
            "registration_authority": "http://www.eduid.cz/"
          }
        ]
      }, 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "CESNET", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }, 
          {
            "lang": "cs", 
            "text": "CESNET", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "CESNET, a. l. e.", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }, 
          {
            "lang": "cs", 
            "text": "CESNET, z. s. p. o.", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.ces.net/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }, 
          {
            "lang": "cs", 
            "text": "http://www.cesnet.cz/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://sp2.cesnet.cz/edugain/Shibboleth.sso/SLO/Artifact"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://sp2.cesnet.cz/edugain/Shibboleth.sso/SLO/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://sp2.cesnet.cz/edugain/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://sp2.cesnet.cz/edugain/Shibboleth.sso/SLO/SOAP"
            }
          ], 
          "attribute_consuming_service": [
            {
              "index": "0", 
              "service_description": [
                {
                  "lang": "en", 
                  "text": "Shows available attributes and assertions", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription"
                }
              ], 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService", 
              "requested_attribute": [
                {
                  "friendly_name": "email", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:0.9.2342.19200300.100.1.3"
                }, 
                {
                  "friendly_name": "eduPersonPrincipalName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.6"
                }, 
                {
                  "friendly_name": "eduPersonEntitlement", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.7"
                }, 
                {
                  "friendly_name": "eduPersonTargetedID", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.10"
                }, 
                {
                  "friendly_name": "email", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:mail"
                }, 
                {
                  "friendly_name": "eduPersonPrincipalName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:eduPersonPrincipalName"
                }, 
                {
                  "friendly_name": "eduPersonEntitlement", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:eduPersonEntitlement"
                }, 
                {
                  "friendly_name": "eduPersonTargetedID", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:eduPersonTargetedID"
                }
              ], 
              "service_name": [
                {
                  "lang": "en", 
                  "text": "CESNET Test SP", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }
              ]
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sp2.cesnet.cz/edugain/Shibboleth.sso/SAML/Artifact"
            }, 
            {
              "index": "7", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sp2.cesnet.cz/edugain/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "8", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sp2.cesnet.cz/edugain/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "9", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sp2.cesnet.cz/edugain/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "10", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sp2.cesnet.cz/edugain/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "11", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sp2.cesnet.cz/edugain/Shibboleth.sso/SAML2/POST-SimpleSign"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://sp2.cesnet.cz/edugain/Shibboleth.sso/DS"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "CESNET Test SP", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }, 
                  {
                    "lang": "cs", 
                    "text": "CESNET Test SP", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "en", 
                    "text": "A test SP showing released attributes and SAML assertions.", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }, 
                  {
                    "lang": "cs", 
                    "text": "Testovac\u00ed SP - ukazuje doru\u010den\u00e9 atributy a SAML zpr\u00e1vy.", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "sp2.cesnet.cz", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=sp2.cesnet.cz,O=CESNET,DC=cesnet-ca,DC=cz", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIELzCCAxegAwIBAgIEQrOJWDANBgkqhkiG9w0BAQUFADBDMRIwEAYKCZImiZPy\nLGQBGRYCY3oxGTAXBgoJkiaJk/IsZAEZFgljZXNuZXQtY2ExEjAQBgNVBAMTCUNF\nU05FVCBDQTAeFw0xMDAyMjIwOTU5MzFaFw0xMTAzMjIxMDI5MzFaMFgxEjAQBgoJ\nkiaJk/IsZAEZFgJjejEZMBcGCgmSJomT8ixkARkWCWNlc25ldC1jYTEPMA0GA1UE\nChMGQ0VTTkVUMRYwFAYDVQQDEw1zcDIuY2VzbmV0LmN6MIGfMA0GCSqGSIb3DQEB\nAQUAA4GNADCBiQKBgQC+Q9oT1doCHIBxlNtPhsfVhfTUAQ8EcBnbOZeNRpcabQ4v\nXvb65ji2Wgis3LDvr1oin0u1i5kTI35bi8nHjRYIfTtPwv+eXVEjsHbR+kDymmo+\nNeRT19ogZlNjslL2CZKtpb9b1cabIgco6rPWOo42CPiMGhp3pmTZD50MwrZS5wID\nAQABo4IBmDCCAZQwDgYDVR0PAQH/BAQDAgWgMBkGA1UdIAQSMBAwDgYMKwYBBAG+\neQECAgIAMBgGA1UdEQQRMA+CDXNwMi5jZXNuZXQuY3owggELBgNVHR8EggECMIH/\nMFqgWKBWpFQwUjESMBAGCgmSJomT8ixkARkWAmN6MRkwFwYKCZImiZPyLGQBGRYJ\nY2VzbmV0LWNhMRIwEAYDVQQDEwlDRVNORVQgQ0ExDTALBgNVBAMTBENSTDUwgaCg\ngZ2ggZqGQmh0dHA6Ly93d3cuY2VzbmV0LmN6L3BraS9jcmwvY249Q0VTTkVUJTIw\nQ0EsZGM9Y2VzbmV0LWNhLGRjPWN6LmNybIZUbGRhcDovL2xkYXAuY2VzbmV0LWNh\nLmN6L2NuPUNFU05FVCUyMENBLGRjPWNlc25ldC1jYSxkYz1jej9jZXJ0aWZpY2F0\nZVJldm9jYXRpb25MaXN0MB8GA1UdIwQYMBaAFC9sBcNRJqyvOZw+ODXdUikngMX1\nMB0GA1UdDgQWBBSo9Hnbvg5HchstLUwj8kkBHA88HDANBgkqhkiG9w0BAQUFAAOC\nAQEAgbnrp/sPF76DlC2Ehll9I417XOnOZdW3C1rKcZSh9vm6tonse21pBVC4799H\nAjy4i22AbIg37N9Wh7sfUf0pZbuen4Eo6PEdUTQhIsJTAp/Dpp7WlQwjDRSUCTS7\nPyqPHKHCacSogDCwilylgBvD/VokryJKWce4cIr2YT09+uMCCIqHNYcihDEBOdGM\n0S1uFcV7bUeHtXqvDfWeSaU0XgraSZvSuDGu1S5BkKvg3GbaYlakjEZce6g1GQsA\n035XrYOVM4U3+W/C8SuxS47R31SGE1xsBWbwz6EPhUK1/SFAoAPDZ5P1aeuugcEX\nOdbkmjrpK8okfqGw+9V2Sgk08Q==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "sp2.cesnet.cz", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=sp2.cesnet.cz,O=CESNET,DC=cesnet-ca,DC=cz", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIELzCCAxegAwIBAgIEQrOJWDANBgkqhkiG9w0BAQUFADBDMRIwEAYKCZImiZPy\nLGQBGRYCY3oxGTAXBgoJkiaJk/IsZAEZFgljZXNuZXQtY2ExEjAQBgNVBAMTCUNF\nU05FVCBDQTAeFw0xMDAyMjIwOTU5MzFaFw0xMTAzMjIxMDI5MzFaMFgxEjAQBgoJ\nkiaJk/IsZAEZFgJjejEZMBcGCgmSJomT8ixkARkWCWNlc25ldC1jYTEPMA0GA1UE\nChMGQ0VTTkVUMRYwFAYDVQQDEw1zcDIuY2VzbmV0LmN6MIGfMA0GCSqGSIb3DQEB\nAQUAA4GNADCBiQKBgQC+Q9oT1doCHIBxlNtPhsfVhfTUAQ8EcBnbOZeNRpcabQ4v\nXvb65ji2Wgis3LDvr1oin0u1i5kTI35bi8nHjRYIfTtPwv+eXVEjsHbR+kDymmo+\nNeRT19ogZlNjslL2CZKtpb9b1cabIgco6rPWOo42CPiMGhp3pmTZD50MwrZS5wID\nAQABo4IBmDCCAZQwDgYDVR0PAQH/BAQDAgWgMBkGA1UdIAQSMBAwDgYMKwYBBAG+\neQECAgIAMBgGA1UdEQQRMA+CDXNwMi5jZXNuZXQuY3owggELBgNVHR8EggECMIH/\nMFqgWKBWpFQwUjESMBAGCgmSJomT8ixkARkWAmN6MRkwFwYKCZImiZPyLGQBGRYJ\nY2VzbmV0LWNhMRIwEAYDVQQDEwlDRVNORVQgQ0ExDTALBgNVBAMTBENSTDUwgaCg\ngZ2ggZqGQmh0dHA6Ly93d3cuY2VzbmV0LmN6L3BraS9jcmwvY249Q0VTTkVUJTIw\nQ0EsZGM9Y2VzbmV0LWNhLGRjPWN6LmNybIZUbGRhcDovL2xkYXAuY2VzbmV0LWNh\nLmN6L2NuPUNFU05FVCUyMENBLGRjPWNlc25ldC1jYSxkYz1jej9jZXJ0aWZpY2F0\nZVJldm9jYXRpb25MaXN0MB8GA1UdIwQYMBaAFC9sBcNRJqyvOZw+ODXdUikngMX1\nMB0GA1UdDgQWBBSo9Hnbvg5HchstLUwj8kkBHA88HDANBgkqhkiG9w0BAQUFAAOC\nAQEAgbnrp/sPF76DlC2Ehll9I417XOnOZdW3C1rKcZSh9vm6tonse21pBVC4799H\nAjy4i22AbIg37N9Wh7sfUf0pZbuen4Eo6PEdUTQhIsJTAp/Dpp7WlQwjDRSUCTS7\nPyqPHKHCacSogDCwilylgBvD/VokryJKWce4cIr2YT09+uMCCIqHNYcihDEBOdGM\n0S1uFcV7bUeHtXqvDfWeSaU0XgraSZvSuDGu1S5BkKvg3GbaYlakjEZce6g1GQsA\n035XrYOVM4U3+W/C8SuxS47R31SGE1xsBWbwz6EPhUK1/SFAoAPDZ5P1aeuugcEX\nOdbkmjrpK8okfqGw+9V2Sgk08Q==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://sp2.cesnet.cz/edugain/Shibboleth.sso/Artifact/SOAP"
            }
          ], 
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://sp2.cesnet.cz/edugain/Shibboleth.sso/NIM/Artifact"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://sp2.cesnet.cz/edugain/Shibboleth.sso/NIM/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://sp2.cesnet.cz/edugain/Shibboleth.sso/NIM/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://sp2.cesnet.cz/edugain/Shibboleth.sso/NIM/SOAP"
            }
          ]
        }
      ], 
      "contact_person": [
        {
          "given_name": {
            "text": "Ivan", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "novakoi@fel.cvut.cz", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Novakov", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://lu-idp1.lu.lv", 
    {
      "entity_id": "https://lu-idp1.lu.lv", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/lu-idp1.lu.lv.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://lu-idp1.lu.lv/simplesaml/saml2/idp/SingleLogoutService.php"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://lu-idp1.lu.lv/simplesaml/saml2/idp/SSOService.php"
            }
          ], 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDMDCCAhgCAQAwDQYJKoZIhvcNAQEEBQAwXjELMAkGA1UEBhMCTFYxDzANBgNV\nBAgTBkxhdHZpYTENMAsGA1UEBxMEUmlnYTELMAkGA1UEChMCTFUxCzAJBgNVBAsT\nAkxVMRUwEwYDVQQDEwxsdS1pZHAubHUubHYwHhcNMTMwMzA1MTI0NjEzWhcNMjMw\nMzAzMTI0NjEzWjBeMQswCQYDVQQGEwJMVjEPMA0GA1UECBMGTGF0dmlhMQ0wCwYD\nVQQHEwRSaWdhMQswCQYDVQQKEwJMVTELMAkGA1UECxMCTFUxFTATBgNVBAMTDGx1\nLWlkcC5sdS5sdjCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBALVP1+R8\nESt5pHCtzIWOiF+yw+IQMzYSWe4LB/tbyNzAnZ0q/nRaJe0XQpasWpobIGVXvzvh\ncWmMf/sxiM2OW8jzrNsQcEk+E69brgq9eE4lEbhHGbmBjangJLXI3cEwVickWXqQ\nqhe0cUPBMD1FZARwGlL8YWZRQ5+dfB933EO8dR4LSdLbNXjglCEwGG2e6XHzbl4w\n7JS+SLaTjLjRB0ITCp9HtvxciFakPX/gzGOJM54UuF68siLGyokP7s/T7XgOxnFL\nZ54FRLckXOkDzcyfMn+6VB5r7MAIE1E25zcllZbfvqKDtb4JmeP5o3UOfY2TUCIg\nQbiA+GZGz8xTcbkCAwEAATANBgkqhkiG9w0BAQQFAAOCAQEABN89j8izhz6LrVsr\npTj6u8ZE4mlUkDsvXJSxiuz7VNsf3M/y63QAdMNot/HSjEhl+a4utrcXiv63qtsC\n/GJNoI2uu6cBvMR6QXLf2rsuPG8bhIRciXu05PiY3gbHiiPJWOQuPEBSSFBMskiU\nU3dxJNFd+EmUjigNrpObWNOjGypQE7v+WlZ6261kkCUbSEKixQ28Py4tqS6CJehn\npdgKs1TNu4MoBxUjg8yo3b+1UaA96NmMbA3XUSd2K9qOV9NzJ64E9e7d04u+VVBv\nD2TcA6zOrv9jXb96N0u0D9Bz2K6rDsdV7T1N+3L3LcLzP7qj/jNlRU8tagDbXrwz\njo0gpQ==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "encryption", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDMDCCAhgCAQAwDQYJKoZIhvcNAQEEBQAwXjELMAkGA1UEBhMCTFYxDzANBgNV\nBAgTBkxhdHZpYTENMAsGA1UEBxMEUmlnYTELMAkGA1UEChMCTFUxCzAJBgNVBAsT\nAkxVMRUwEwYDVQQDEwxsdS1pZHAubHUubHYwHhcNMTMwMzA1MTI0NjEzWhcNMjMw\nMzAzMTI0NjEzWjBeMQswCQYDVQQGEwJMVjEPMA0GA1UECBMGTGF0dmlhMQ0wCwYD\nVQQHEwRSaWdhMQswCQYDVQQKEwJMVTELMAkGA1UECxMCTFUxFTATBgNVBAMTDGx1\nLWlkcC5sdS5sdjCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBALVP1+R8\nESt5pHCtzIWOiF+yw+IQMzYSWe4LB/tbyNzAnZ0q/nRaJe0XQpasWpobIGVXvzvh\ncWmMf/sxiM2OW8jzrNsQcEk+E69brgq9eE4lEbhHGbmBjangJLXI3cEwVickWXqQ\nqhe0cUPBMD1FZARwGlL8YWZRQ5+dfB933EO8dR4LSdLbNXjglCEwGG2e6XHzbl4w\n7JS+SLaTjLjRB0ITCp9HtvxciFakPX/gzGOJM54UuF68siLGyokP7s/T7XgOxnFL\nZ54FRLckXOkDzcyfMn+6VB5r7MAIE1E25zcllZbfvqKDtb4JmeP5o3UOfY2TUCIg\nQbiA+GZGz8xTcbkCAwEAATANBgkqhkiG9w0BAQQFAAOCAQEABN89j8izhz6LrVsr\npTj6u8ZE4mlUkDsvXJSxiuz7VNsf3M/y63QAdMNot/HSjEhl+a4utrcXiv63qtsC\n/GJNoI2uu6cBvMR6QXLf2rsuPG8bhIRciXu05PiY3gbHiiPJWOQuPEBSSFBMskiU\nU3dxJNFd+EmUjigNrpObWNOjGypQE7v+WlZ6261kkCUbSEKixQ28Py4tqS6CJehn\npdgKs1TNu4MoBxUjg8yo3b+1UaA96NmMbA3XUSd2K9qOV9NzJ64E9e7d04u+VVBv\nD2TcA6zOrv9jXb96N0u0D9Bz2K6rDsdV7T1N+3L3LcLzP7qj/jNlRU8tagDbXrwz\njo0gpQ==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "en", 
                "text": "https://laife.lanet.lv/wiki/Latvian-Academic-Identity-Federation-Policy.pdf", 
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy"
              }
            ], 
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo", 
            "registration_authority": "http://laife.lanet.lv/"
          }
        ]
      }, 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "LAIFE - LU", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Latvian Identity Federation LAIFE - LU IDP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://laife.lanet.lv/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }, 
          {
            "lang": "lv", 
            "text": "http://www.lu.lv/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "email_address": [
            {
              "text": "serviss@lanet.lv", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Administrator", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://idp1.hs-augsburg.de/idp/shibboleth", 
    {
      "entity_id": "https://idp1.hs-augsburg.de/idp/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/idp1.hs-augsburg.de.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp1.hs-augsburg.de/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp1.hs-augsburg.de/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "hs-augsburg.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "idp1.hs-augsburg.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=idp1.hs-augsburg.de,OU=Rechenzentrum,O=Fachhochschule Augsburg,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFQDCCBCigAwIBAgIEDWb0jzANBgkqhkiG9w0BAQUFADCBiDELMAkGA1UEBhMC\nREUxIDAeBgNVBAoTF0ZhY2hob2Noc2NodWxlIEF1Z3NidXJnMRYwFAYDVQQLEw1S\nZWNoZW56ZW50cnVtMR0wGwYDVQQDExRGSCBBdWdzYnVyZyBDQSAtIEcwMjEgMB4G\nCSqGSIb3DQEJARYRY2FAZmgtYXVnc2J1cmcuZGUwHhcNMDgxMjE2MDkzODA3WhcN\nMTMxMjE1MDkzODA3WjBlMQswCQYDVQQGEwJERTEgMB4GA1UEChMXRmFjaGhvY2hz\nY2h1bGUgQXVnc2J1cmcxFjAUBgNVBAsTDVJlY2hlbnplbnRydW0xHDAaBgNVBAMT\nE2lkcDEuaHMtYXVnc2J1cmcuZGUwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEK\nAoIBAQC8gWpAiIyVdxXsA68rHTJ5LvlxZfhDEjnEFUvayvT/0Y2iXRZSnb+79jzI\nkz+HCgSQwHh9TG9ypJZn8RB9vkxUTMgU5f/pIvOdI4DV6KlAQX7RGdIPRxBaWXjo\nVcqoayxntkfMU61jRA9p2bk0EA3uT/pxnzve0gAn3wF4DH1V+1AO/Rmb/d0m15my\n42JzGOUKcs6RyaF5VqjGVQLLD72n18YD5zbQBylxn0r+WbrJ8ASKvKiRu/T86oF3\nToQmWPjEqMnB2XIyYu7uz8Y5RCHgcM/DMXLjXxOr7pqdU7yQvbpcHhHr4QTTdzGR\naMAj/Oqio6QPuOKy1L61dXSBceytAgMBAAGjggHSMIIBzjAJBgNVHRMEAjAAMAsG\nA1UdDwQEAwIF4DAdBgNVHSUEFjAUBggrBgEFBQcDAgYIKwYBBQUHAwEwHQYDVR0O\nBBYEFKUAUSuvuh5EWFNPXRYWICHovPa8MB8GA1UdIwQYMBaAFNVwF+PewZf0CD7p\nOhGz6IjxkEfkMBwGA1UdEQQVMBOBEWNhQGZoLWF1Z3NidXJnLmRlMIGNBgNVHR8E\ngYUwgYIwP6A9oDuGOWh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvZmgtYXVnc2J1cmct\nY2EvcHViL2NybC9nX2NhY3JsLmNybDA/oD2gO4Y5aHR0cDovL2NkcDIucGNhLmRm\nbi5kZS9maC1hdWdzYnVyZy1jYS9wdWIvY3JsL2dfY2FjcmwuY3JsMIGmBggrBgEF\nBQcBAQSBmTCBljBJBggrBgEFBQcwAoY9aHR0cDovL2NkcDEucGNhLmRmbi5kZS9m\naC1hdWdzYnVyZy1jYS9wdWIvY2FjZXJ0L2dfY2FjZXJ0LmNydDBJBggrBgEFBQcw\nAoY9aHR0cDovL2NkcDIucGNhLmRmbi5kZS9maC1hdWdzYnVyZy1jYS9wdWIvY2Fj\nZXJ0L2dfY2FjZXJ0LmNydDANBgkqhkiG9w0BAQUFAAOCAQEAPHeiCv3u24AxLffg\niUTaEQq/+w8f2IgigO26Oq3Z2L5jLH9OeFXjKHOj2L1SzrW5cvuKijmMhSvlcCsI\ndSbt5uzza86ypR9wQARcVBEO1o2HIGEkIcy4IoLF/fQddMs5g5/12YJjtUt5vyJY\nf8IMl0N3Qq5SSIqh0QUfeFxFxArwJjLnMxA9bvg9Vy9jdftZoAJ5F5Ulf3Ofnpqf\nOEKCBtjuDDCfT2ZXClPIavsE8cXoGDo6xgP5zV8o0IvzDTM3DhlD6lMvVj4IFhjj\nAymMd/bc0s9QWtg6cTNyjd4QbIaSAMZXApNYRDkYyB2v5Tmi1YAlDXUS/DmWmb4Z\ncln+zg==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "idp1.hs-augsburg.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=idp1.hs-augsburg.de,OU=Rechenzentrum,O=Fachhochschule Augsburg,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFQDCCBCigAwIBAgIEDWb0jzANBgkqhkiG9w0BAQUFADCBiDELMAkGA1UEBhMC\nREUxIDAeBgNVBAoTF0ZhY2hob2Noc2NodWxlIEF1Z3NidXJnMRYwFAYDVQQLEw1S\nZWNoZW56ZW50cnVtMR0wGwYDVQQDExRGSCBBdWdzYnVyZyBDQSAtIEcwMjEgMB4G\nCSqGSIb3DQEJARYRY2FAZmgtYXVnc2J1cmcuZGUwHhcNMDgxMjE2MDkzODA3WhcN\nMTMxMjE1MDkzODA3WjBlMQswCQYDVQQGEwJERTEgMB4GA1UEChMXRmFjaGhvY2hz\nY2h1bGUgQXVnc2J1cmcxFjAUBgNVBAsTDVJlY2hlbnplbnRydW0xHDAaBgNVBAMT\nE2lkcDEuaHMtYXVnc2J1cmcuZGUwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEK\nAoIBAQC8gWpAiIyVdxXsA68rHTJ5LvlxZfhDEjnEFUvayvT/0Y2iXRZSnb+79jzI\nkz+HCgSQwHh9TG9ypJZn8RB9vkxUTMgU5f/pIvOdI4DV6KlAQX7RGdIPRxBaWXjo\nVcqoayxntkfMU61jRA9p2bk0EA3uT/pxnzve0gAn3wF4DH1V+1AO/Rmb/d0m15my\n42JzGOUKcs6RyaF5VqjGVQLLD72n18YD5zbQBylxn0r+WbrJ8ASKvKiRu/T86oF3\nToQmWPjEqMnB2XIyYu7uz8Y5RCHgcM/DMXLjXxOr7pqdU7yQvbpcHhHr4QTTdzGR\naMAj/Oqio6QPuOKy1L61dXSBceytAgMBAAGjggHSMIIBzjAJBgNVHRMEAjAAMAsG\nA1UdDwQEAwIF4DAdBgNVHSUEFjAUBggrBgEFBQcDAgYIKwYBBQUHAwEwHQYDVR0O\nBBYEFKUAUSuvuh5EWFNPXRYWICHovPa8MB8GA1UdIwQYMBaAFNVwF+PewZf0CD7p\nOhGz6IjxkEfkMBwGA1UdEQQVMBOBEWNhQGZoLWF1Z3NidXJnLmRlMIGNBgNVHR8E\ngYUwgYIwP6A9oDuGOWh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvZmgtYXVnc2J1cmct\nY2EvcHViL2NybC9nX2NhY3JsLmNybDA/oD2gO4Y5aHR0cDovL2NkcDIucGNhLmRm\nbi5kZS9maC1hdWdzYnVyZy1jYS9wdWIvY3JsL2dfY2FjcmwuY3JsMIGmBggrBgEF\nBQcBAQSBmTCBljBJBggrBgEFBQcwAoY9aHR0cDovL2NkcDEucGNhLmRmbi5kZS9m\naC1hdWdzYnVyZy1jYS9wdWIvY2FjZXJ0L2dfY2FjZXJ0LmNydDBJBggrBgEFBQcw\nAoY9aHR0cDovL2NkcDIucGNhLmRmbi5kZS9maC1hdWdzYnVyZy1jYS9wdWIvY2Fj\nZXJ0L2dfY2FjZXJ0LmNydDANBgkqhkiG9w0BAQUFAAOCAQEAPHeiCv3u24AxLffg\niUTaEQq/+w8f2IgigO26Oq3Z2L5jLH9OeFXjKHOj2L1SzrW5cvuKijmMhSvlcCsI\ndSbt5uzza86ypR9wQARcVBEO1o2HIGEkIcy4IoLF/fQddMs5g5/12YJjtUt5vyJY\nf8IMl0N3Qq5SSIqh0QUfeFxFxArwJjLnMxA9bvg9Vy9jdftZoAJ5F5Ulf3Ofnpqf\nOEKCBtjuDDCfT2ZXClPIavsE8cXoGDo6xgP5zV8o0IvzDTM3DhlD6lMvVj4IFhjj\nAymMd/bc0s9QWtg6cTNyjd4QbIaSAMZXApNYRDkYyB2v5Tmi1YAlDXUS/DmWmb4Z\ncln+zg==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://idp1.hs-augsburg.de:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://idp1.hs-augsburg.de:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://idp1.hs-augsburg.de:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://idp1.hs-augsburg.de:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "hs-augsburg.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "idp1.hs-augsburg.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=idp1.hs-augsburg.de,OU=Rechenzentrum,O=Fachhochschule Augsburg,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFQDCCBCigAwIBAgIEDWb0jzANBgkqhkiG9w0BAQUFADCBiDELMAkGA1UEBhMC\nREUxIDAeBgNVBAoTF0ZhY2hob2Noc2NodWxlIEF1Z3NidXJnMRYwFAYDVQQLEw1S\nZWNoZW56ZW50cnVtMR0wGwYDVQQDExRGSCBBdWdzYnVyZyBDQSAtIEcwMjEgMB4G\nCSqGSIb3DQEJARYRY2FAZmgtYXVnc2J1cmcuZGUwHhcNMDgxMjE2MDkzODA3WhcN\nMTMxMjE1MDkzODA3WjBlMQswCQYDVQQGEwJERTEgMB4GA1UEChMXRmFjaGhvY2hz\nY2h1bGUgQXVnc2J1cmcxFjAUBgNVBAsTDVJlY2hlbnplbnRydW0xHDAaBgNVBAMT\nE2lkcDEuaHMtYXVnc2J1cmcuZGUwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEK\nAoIBAQC8gWpAiIyVdxXsA68rHTJ5LvlxZfhDEjnEFUvayvT/0Y2iXRZSnb+79jzI\nkz+HCgSQwHh9TG9ypJZn8RB9vkxUTMgU5f/pIvOdI4DV6KlAQX7RGdIPRxBaWXjo\nVcqoayxntkfMU61jRA9p2bk0EA3uT/pxnzve0gAn3wF4DH1V+1AO/Rmb/d0m15my\n42JzGOUKcs6RyaF5VqjGVQLLD72n18YD5zbQBylxn0r+WbrJ8ASKvKiRu/T86oF3\nToQmWPjEqMnB2XIyYu7uz8Y5RCHgcM/DMXLjXxOr7pqdU7yQvbpcHhHr4QTTdzGR\naMAj/Oqio6QPuOKy1L61dXSBceytAgMBAAGjggHSMIIBzjAJBgNVHRMEAjAAMAsG\nA1UdDwQEAwIF4DAdBgNVHSUEFjAUBggrBgEFBQcDAgYIKwYBBQUHAwEwHQYDVR0O\nBBYEFKUAUSuvuh5EWFNPXRYWICHovPa8MB8GA1UdIwQYMBaAFNVwF+PewZf0CD7p\nOhGz6IjxkEfkMBwGA1UdEQQVMBOBEWNhQGZoLWF1Z3NidXJnLmRlMIGNBgNVHR8E\ngYUwgYIwP6A9oDuGOWh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvZmgtYXVnc2J1cmct\nY2EvcHViL2NybC9nX2NhY3JsLmNybDA/oD2gO4Y5aHR0cDovL2NkcDIucGNhLmRm\nbi5kZS9maC1hdWdzYnVyZy1jYS9wdWIvY3JsL2dfY2FjcmwuY3JsMIGmBggrBgEF\nBQcBAQSBmTCBljBJBggrBgEFBQcwAoY9aHR0cDovL2NkcDEucGNhLmRmbi5kZS9m\naC1hdWdzYnVyZy1jYS9wdWIvY2FjZXJ0L2dfY2FjZXJ0LmNydDBJBggrBgEFBQcw\nAoY9aHR0cDovL2NkcDIucGNhLmRmbi5kZS9maC1hdWdzYnVyZy1jYS9wdWIvY2Fj\nZXJ0L2dfY2FjZXJ0LmNydDANBgkqhkiG9w0BAQUFAAOCAQEAPHeiCv3u24AxLffg\niUTaEQq/+w8f2IgigO26Oq3Z2L5jLH9OeFXjKHOj2L1SzrW5cvuKijmMhSvlcCsI\ndSbt5uzza86ypR9wQARcVBEO1o2HIGEkIcy4IoLF/fQddMs5g5/12YJjtUt5vyJY\nf8IMl0N3Qq5SSIqh0QUfeFxFxArwJjLnMxA9bvg9Vy9jdftZoAJ5F5Ulf3Ofnpqf\nOEKCBtjuDDCfT2ZXClPIavsE8cXoGDo6xgP5zV8o0IvzDTM3DhlD6lMvVj4IFhjj\nAymMd/bc0s9QWtg6cTNyjd4QbIaSAMZXApNYRDkYyB2v5Tmi1YAlDXUS/DmWmb4Z\ncln+zg==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "idp1.hs-augsburg.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=idp1.hs-augsburg.de,OU=Rechenzentrum,O=Fachhochschule Augsburg,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFQDCCBCigAwIBAgIEDWb0jzANBgkqhkiG9w0BAQUFADCBiDELMAkGA1UEBhMC\nREUxIDAeBgNVBAoTF0ZhY2hob2Noc2NodWxlIEF1Z3NidXJnMRYwFAYDVQQLEw1S\nZWNoZW56ZW50cnVtMR0wGwYDVQQDExRGSCBBdWdzYnVyZyBDQSAtIEcwMjEgMB4G\nCSqGSIb3DQEJARYRY2FAZmgtYXVnc2J1cmcuZGUwHhcNMDgxMjE2MDkzODA3WhcN\nMTMxMjE1MDkzODA3WjBlMQswCQYDVQQGEwJERTEgMB4GA1UEChMXRmFjaGhvY2hz\nY2h1bGUgQXVnc2J1cmcxFjAUBgNVBAsTDVJlY2hlbnplbnRydW0xHDAaBgNVBAMT\nE2lkcDEuaHMtYXVnc2J1cmcuZGUwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEK\nAoIBAQC8gWpAiIyVdxXsA68rHTJ5LvlxZfhDEjnEFUvayvT/0Y2iXRZSnb+79jzI\nkz+HCgSQwHh9TG9ypJZn8RB9vkxUTMgU5f/pIvOdI4DV6KlAQX7RGdIPRxBaWXjo\nVcqoayxntkfMU61jRA9p2bk0EA3uT/pxnzve0gAn3wF4DH1V+1AO/Rmb/d0m15my\n42JzGOUKcs6RyaF5VqjGVQLLD72n18YD5zbQBylxn0r+WbrJ8ASKvKiRu/T86oF3\nToQmWPjEqMnB2XIyYu7uz8Y5RCHgcM/DMXLjXxOr7pqdU7yQvbpcHhHr4QTTdzGR\naMAj/Oqio6QPuOKy1L61dXSBceytAgMBAAGjggHSMIIBzjAJBgNVHRMEAjAAMAsG\nA1UdDwQEAwIF4DAdBgNVHSUEFjAUBggrBgEFBQcDAgYIKwYBBQUHAwEwHQYDVR0O\nBBYEFKUAUSuvuh5EWFNPXRYWICHovPa8MB8GA1UdIwQYMBaAFNVwF+PewZf0CD7p\nOhGz6IjxkEfkMBwGA1UdEQQVMBOBEWNhQGZoLWF1Z3NidXJnLmRlMIGNBgNVHR8E\ngYUwgYIwP6A9oDuGOWh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvZmgtYXVnc2J1cmct\nY2EvcHViL2NybC9nX2NhY3JsLmNybDA/oD2gO4Y5aHR0cDovL2NkcDIucGNhLmRm\nbi5kZS9maC1hdWdzYnVyZy1jYS9wdWIvY3JsL2dfY2FjcmwuY3JsMIGmBggrBgEF\nBQcBAQSBmTCBljBJBggrBgEFBQcwAoY9aHR0cDovL2NkcDEucGNhLmRmbi5kZS9m\naC1hdWdzYnVyZy1jYS9wdWIvY2FjZXJ0L2dfY2FjZXJ0LmNydDBJBggrBgEFBQcw\nAoY9aHR0cDovL2NkcDIucGNhLmRmbi5kZS9maC1hdWdzYnVyZy1jYS9wdWIvY2Fj\nZXJ0L2dfY2FjZXJ0LmNydDANBgkqhkiG9w0BAQUFAAOCAQEAPHeiCv3u24AxLffg\niUTaEQq/+w8f2IgigO26Oq3Z2L5jLH9OeFXjKHOj2L1SzrW5cvuKijmMhSvlcCsI\ndSbt5uzza86ypR9wQARcVBEO1o2HIGEkIcy4IoLF/fQddMs5g5/12YJjtUt5vyJY\nf8IMl0N3Qq5SSIqh0QUfeFxFxArwJjLnMxA9bvg9Vy9jdftZoAJ5F5Ulf3Ofnpqf\nOEKCBtjuDDCfT2ZXClPIavsE8cXoGDo6xgP5zV8o0IvzDTM3DhlD6lMvVj4IFhjj\nAymMd/bc0s9QWtg6cTNyjd4QbIaSAMZXApNYRDkYyB2v5Tmi1YAlDXUS/DmWmb4Z\ncln+zg==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "de", 
            "text": "Hochschule Augsburg", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "Hochschule Augsburg", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "http://www.hs-augsburg.de/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Arno", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "arno.schneider@hs-augsburg.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Schneider", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Arno", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "arno.schneider@hs-augsburg.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Schneider", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://idp2.hv.se/idp/shibboleth", 
    {
      "entity_id": "https://idp2.hv.se/idp/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-2.0/idp2.hv.se-idp-shibboleth.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp2.hv.se/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp2.hv.se/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp2.hv.se/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp2.hv.se/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "hv.se", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "University West", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }, 
                  {
                    "lang": "sv", 
                    "text": "H\u00f6gskolan V\u00e4st", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "en", 
                    "text": "Identity Provider for University West", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }, 
                  {
                    "lang": "sv", 
                    "text": "Identity Provider f\u00f6r H\u00f6gskolan V\u00e4st", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }, 
              {
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DiscoHints", 
                "geolocation_hint": [
                  {
                    "text": "geo:58.2822,12.2934", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&GeolocationHint"
                  }
                ], 
                "domain_hint": [
                  {
                    "text": "hv.se", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DomainHint"
                  }
                ]
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDPDCCAiSgAwIBAgIVALAAqmf9+n0EkV7vMRq5ZDh3UVEHMA0GCSqGSIb3DQEB\nBQUAMB8xHTAbBgNVBAMTFGxzYW1sMDMuc2VydmVyLmh2LnNlMB4XDTEyMTEyNjA5\nNTgyNloXDTMyMTEyNjA5NTgyNlowHzEdMBsGA1UEAxMUbHNhbWwwMy5zZXJ2ZXIu\naHYuc2UwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCAwm0DgWJkMIvo\nooXb2NlHLLPl59NDgh5MXYPBCETWU20T2voM+g2M7d5c/Jb1iMVC/kP3FYuK8Nmy\nl6o3VLSaRIENTcZTOLEjHPO301NCu6dRIgM+iwkZnZ0luUgfxEf9aBnmwA0V7vKp\nRliOzNDYmZ7FL6z6ZDh6ULjnPV6KeGd4bQIrW2ywTOirz+BGGn0UXChuOanDnEvo\nfv3Vrr1wh1bbGmr0G6w5JlSLPPKtoKG5DGRjzkq3mfiP97N6ZgI4F0e815Sbb3B7\nVLCZ/JZMRxOj9bP5Q7LhpDn0+LpmK/DS/YAs8rivg1WgKkuJgiYTOAlewyZTZT6v\n1m9x3LexAgMBAAGjbzBtMEwGA1UdEQRFMEOCFGxzYW1sMDMuc2VydmVyLmh2LnNl\nhitodHRwczovL2xzYW1sMDMuc2VydmVyLmh2LnNlL2lkcC9zaGliYm9sZXRoMB0G\nA1UdDgQWBBR9Gm8Z5H9QjIJK2yvAM0y2i1hkpzANBgkqhkiG9w0BAQUFAAOCAQEA\nKXF5jmIhYbIVM425IZMSH9vb6Gm5R3rk0s6h4BGyeMPpLQ/ECjnwitsQFTZG2dci\nvvi4JbU8mryOVDt9NlNUtdgzbiaP3VcrkWHq7at+DsW+ipD5ioMIWZa6/hIqMU7U\neQLX7YM4sjy3b4aa6rdTh+r2yp2GcFmpbJNhSncXA3lgH5I+BBKUgKIrLHdsdkGj\nIebD+y3AIEczoLLKVQ7W5d81Ifrh1JLJ8IVOt4S+9LUsgGJmu04NQaeQyaQcodTs\ndqEra6A3S5DN0BAWsLH3aBkA3fL/f6f3HUQwmd7dG+OUOtP+5DaB1YdeeXYMz5Wj\naRQKNbVQdPN5ht6TrINjDQ==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://idp2.hv.se:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://idp2.hv.se:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://idp2.hv.se:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://idp2.hv.se:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "hv.se", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDPDCCAiSgAwIBAgIVALAAqmf9+n0EkV7vMRq5ZDh3UVEHMA0GCSqGSIb3DQEB\nBQUAMB8xHTAbBgNVBAMTFGxzYW1sMDMuc2VydmVyLmh2LnNlMB4XDTEyMTEyNjA5\nNTgyNloXDTMyMTEyNjA5NTgyNlowHzEdMBsGA1UEAxMUbHNhbWwwMy5zZXJ2ZXIu\naHYuc2UwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCAwm0DgWJkMIvo\nooXb2NlHLLPl59NDgh5MXYPBCETWU20T2voM+g2M7d5c/Jb1iMVC/kP3FYuK8Nmy\nl6o3VLSaRIENTcZTOLEjHPO301NCu6dRIgM+iwkZnZ0luUgfxEf9aBnmwA0V7vKp\nRliOzNDYmZ7FL6z6ZDh6ULjnPV6KeGd4bQIrW2ywTOirz+BGGn0UXChuOanDnEvo\nfv3Vrr1wh1bbGmr0G6w5JlSLPPKtoKG5DGRjzkq3mfiP97N6ZgI4F0e815Sbb3B7\nVLCZ/JZMRxOj9bP5Q7LhpDn0+LpmK/DS/YAs8rivg1WgKkuJgiYTOAlewyZTZT6v\n1m9x3LexAgMBAAGjbzBtMEwGA1UdEQRFMEOCFGxzYW1sMDMuc2VydmVyLmh2LnNl\nhitodHRwczovL2xzYW1sMDMuc2VydmVyLmh2LnNlL2lkcC9zaGliYm9sZXRoMB0G\nA1UdDgQWBBR9Gm8Z5H9QjIJK2yvAM0y2i1hkpzANBgkqhkiG9w0BAQUFAAOCAQEA\nKXF5jmIhYbIVM425IZMSH9vb6Gm5R3rk0s6h4BGyeMPpLQ/ECjnwitsQFTZG2dci\nvvi4JbU8mryOVDt9NlNUtdgzbiaP3VcrkWHq7at+DsW+ipD5ioMIWZa6/hIqMU7U\neQLX7YM4sjy3b4aa6rdTh+r2yp2GcFmpbJNhSncXA3lgH5I+BBKUgKIrLHdsdkGj\nIebD+y3AIEczoLLKVQ7W5d81Ifrh1JLJ8IVOt4S+9LUsgGJmu04NQaeQyaQcodTs\ndqEra6A3S5DN0BAWsLH3aBkA3fL/f6f3HUQwmd7dG+OUOtP+5DaB1YdeeXYMz5Wj\naRQKNbVQdPN5ht6TrINjDQ==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "sv", 
            "text": "HV", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }, 
          {
            "lang": "en", 
            "text": "HV", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "sv", 
            "text": "H\u00f6gskolan V\u00e4st", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }, 
          {
            "lang": "en", 
            "text": "University West", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "sv", 
            "text": "http://www.hv.se", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }, 
          {
            "lang": "en", 
            "text": "http://www.hv.se", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "contact_type": "administrative", 
          "company": {
            "text": "H\u00f6gskolan V\u00e4st", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Company"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "sur_name": {
            "text": "Andersson", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "given_name": {
            "text": "Magnus", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "Magnus.Andersson@hv.se", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ]
        }, 
        {
          "contact_type": "technical", 
          "company": {
            "text": "H\u00f6gskolan V\u00e4st", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Company"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "sur_name": {
            "text": "Jiresj\u00f6", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "given_name": {
            "text": "Christian", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "Christian.Jiresjo@hv.se", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://lingon.ladok.umu.se:8087/sp.xml", 
    {
      "entity_id": "https://lingon.ladok.umu.se:8087/sp.xml", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-2.0/lingon.ladok.umu.se-8087-sp.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "organization": {
        "organization_name": [
          {
            "lang": "se", 
            "text": "Ume Universitet", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "se", 
            "text": "Ume Universitet", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.umu.se", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Roland", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "roland.hedberg@umu.se", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Hedberg", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://lingon.ladok.umu.se:8087/sls"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://lingon.ladok.umu.se:8087/acs/post"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://lingon.ladok.umu.se:8087/acs/redirect"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://lingon.ladok.umu.se:8087/acs/artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://lingon.ladok.umu.se:8087/ecp"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://lingon.ladok.umu.se:8087/disco"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "encryption", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIC8jCCAlugAwIBAgIJAJHg2V5J31I8MA0GCSqGSIb3DQEBBQUAMFoxCzAJBgNV\n                        BAYTAlNFMQ0wCwYDVQQHEwRVbWVhMRgwFgYDVQQKEw9VbWVhIFVuaXZlcnNpdHkx\n                        EDAOBgNVBAsTB0lUIFVuaXQxEDAOBgNVBAMTB1Rlc3QgU1AwHhcNMDkxMDI2MTMz\n                        MTE1WhcNMTAxMDI2MTMzMTE1WjBaMQswCQYDVQQGEwJTRTENMAsGA1UEBxMEVW1l\n                        YTEYMBYGA1UEChMPVW1lYSBVbml2ZXJzaXR5MRAwDgYDVQQLEwdJVCBVbml0MRAw\n                        DgYDVQQDEwdUZXN0IFNQMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDkJWP7\n                        bwOxtH+E15VTaulNzVQ/0cSbM5G7abqeqSNSs0l0veHr6/ROgW96ZeQ57fzVy2MC\n                        FiQRw2fzBs0n7leEmDJyVVtBTavYlhAVXDNa3stgvh43qCfLx+clUlOvtnsoMiiR\n                        mo7qf0BoPKTj7c0uLKpDpEbAHQT4OF1HRYVxMwIDAQABo4G/MIG8MB0GA1UdDgQW\n                        BBQ7RgbMJFDGRBu9o3tDQDuSoBy7JjCBjAYDVR0jBIGEMIGBgBQ7RgbMJFDGRBu9\n                        o3tDQDuSoBy7JqFepFwwWjELMAkGA1UEBhMCU0UxDTALBgNVBAcTBFVtZWExGDAW\n                        BgNVBAoTD1VtZWEgVW5pdmVyc2l0eTEQMA4GA1UECxMHSVQgVW5pdDEQMA4GA1UE\n                        AxMHVGVzdCBTUIIJAJHg2V5J31I8MAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEF\n                        BQADgYEAMuRwwXRnsiyWzmRikpwinnhTmbooKm5TINPE7A7gSQ710RxioQePPhZO\n                        zkM27NnHTrCe2rBVg0EGz7QTd1JIwLPvgoj4VTi/fSha/tXrYUaqc9AqU1kWI4WN\n                        +vffBGQ09mo+6CffuFTZYeOhzP/2stAPwCTU4kxEoiy0KpZMANI=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIC8jCCAlugAwIBAgIJAJHg2V5J31I8MA0GCSqGSIb3DQEBBQUAMFoxCzAJBgNV\n                        BAYTAlNFMQ0wCwYDVQQHEwRVbWVhMRgwFgYDVQQKEw9VbWVhIFVuaXZlcnNpdHkx\n                        EDAOBgNVBAsTB0lUIFVuaXQxEDAOBgNVBAMTB1Rlc3QgU1AwHhcNMDkxMDI2MTMz\n                        MTE1WhcNMTAxMDI2MTMzMTE1WjBaMQswCQYDVQQGEwJTRTENMAsGA1UEBxMEVW1l\n                        YTEYMBYGA1UEChMPVW1lYSBVbml2ZXJzaXR5MRAwDgYDVQQLEwdJVCBVbml0MRAw\n                        DgYDVQQDEwdUZXN0IFNQMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDkJWP7\n                        bwOxtH+E15VTaulNzVQ/0cSbM5G7abqeqSNSs0l0veHr6/ROgW96ZeQ57fzVy2MC\n                        FiQRw2fzBs0n7leEmDJyVVtBTavYlhAVXDNa3stgvh43qCfLx+clUlOvtnsoMiiR\n                        mo7qf0BoPKTj7c0uLKpDpEbAHQT4OF1HRYVxMwIDAQABo4G/MIG8MB0GA1UdDgQW\n                        BBQ7RgbMJFDGRBu9o3tDQDuSoBy7JjCBjAYDVR0jBIGEMIGBgBQ7RgbMJFDGRBu9\n                        o3tDQDuSoBy7JqFepFwwWjELMAkGA1UEBhMCU0UxDTALBgNVBAcTBFVtZWExGDAW\n                        BgNVBAoTD1VtZWEgVW5pdmVyc2l0eTEQMA4GA1UECxMHSVQgVW5pdDEQMA4GA1UE\n                        AxMHVGVzdCBTUIIJAJHg2V5J31I8MAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEF\n                        BQADgYEAMuRwwXRnsiyWzmRikpwinnhTmbooKm5TINPE7A7gSQ710RxioQePPhZO\n                        zkM27NnHTrCe2rBVg0EGz7QTd1JIwLPvgoj4VTi/fSha/tXrYUaqc9AqU1kWI4WN\n                        +vffBGQ09mo+6CffuFTZYeOhzP/2stAPwCTU4kxEoiy0KpZMANI=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "want_assertions_signed": "true", 
          "authn_requests_signed": "false", 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://lingon.ladok.umu.se:8087/ars"
            }
          ], 
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://lingon.ladok.umu.se:8087/mni"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://lingon.ladok.umu.se:8087/mni"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://lingon.ladok.umu.se:8087/mni"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://lingon.ladok.umu.se:8087/acs/artifact"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://nacho.adm.gu.se/shibboleth", 
    {
      "entity_id": "https://nacho.adm.gu.se/shibboleth", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://nacho.adm.gu.se/Shibboleth.sso/SLO/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://nacho.adm.gu.se/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://nacho.adm.gu.se/Shibboleth.sso/SLO/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://nacho.adm.gu.se/Shibboleth.sso/SLO/Artifact"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://nacho.adm.gu.se/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://nacho.adm.gu.se/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://nacho.adm.gu.se/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://nacho.adm.gu.se/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://nacho.adm.gu.se/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://nacho.adm.gu.se/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://nacho.adm.gu.se/Shibboleth.sso/DS"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "nacho-pc", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=nacho-pc", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIC3zCCAcegAwIBAgIJANjsPUfkRN00MA0GCSqGSIb3DQEBBQUAMBMxETAPBgNV\nBAMTCG5hY2hvLXBjMB4XDTEwMDQxMzEzMzI1OVoXDTIwMDQxMDEzMzI1OVowEzER\nMA8GA1UEAxMIbmFjaG8tcGMwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIB\nAQC99pEipkOSaRwbIYY/dfFIR2/COahYi+fU3qDpCmG6JbZzO3O9ybjF/sUmt1fA\nUnq+1HinEwSGDfizUoN+/NUcAG4N8juD+UL9bbYEcfx7Ly7jlGiZa3Fr3zFqxXGQ\nw+vAtnk4tKtt0kNKPXNs9oApEzGpUAj12EQBRMiKLhFPqNMo8YQ+OUqCyZMYm2Oc\nuJFj9QBN3vLCRFJJZCt7kmpfnC9M4KdMFvhzbDMixrk4qdjuUB0W7bRAiHk0Yupw\nQUZMk0kF4AJrWFliUIsNVIm3q4I0AOlAgbii5rsarDjGaRlE421K6TZxwx+0UfnQ\nG3pn+xmBV7purr0y6VmQOaZvAgMBAAGjNjA0MBMGA1UdEQQMMAqCCG5hY2hvLXBj\nMB0GA1UdDgQWBBQAzw+GSXwuDMhAaUP+M9D28G8yNDANBgkqhkiG9w0BAQUFAAOC\nAQEAKmp+HbJKFXb+NEPdktE8Y+PKV9YWsPpBKCxSHxDkgFSXLnCjxr6RpPYPvgqY\noHjkqzea//qZ4oqVRjOBauGqZ1u+PBYEwsZGSL6v2/AMjM51D1VOvMJz3Rt63ee1\n+oIZbU7teIK3n5BpSjHhScglXf2psZEEmQ5FGTLMUvq1Ri5bMJjmVNNyQH0Cm1WM\nIGGsITC3/oso3+KzpqcWISIqCeBFfYZ4mh/PIOoZEpYSN9jkMBHtlcc9mcR6aQX3\n0KtgoDtLnJA0Xw9ubL3YhxZLOdWTswHGr4AoplV09zQkNG87GIfVDAtzmZHLlP6S\ns0eg2zS0HU2kmUbaL6tbYB5jyw==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "nacho-pc", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=nacho-pc", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIC3zCCAcegAwIBAgIJANjsPUfkRN00MA0GCSqGSIb3DQEBBQUAMBMxETAPBgNV\nBAMTCG5hY2hvLXBjMB4XDTEwMDQxMzEzMzI1OVoXDTIwMDQxMDEzMzI1OVowEzER\nMA8GA1UEAxMIbmFjaG8tcGMwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIB\nAQC99pEipkOSaRwbIYY/dfFIR2/COahYi+fU3qDpCmG6JbZzO3O9ybjF/sUmt1fA\nUnq+1HinEwSGDfizUoN+/NUcAG4N8juD+UL9bbYEcfx7Ly7jlGiZa3Fr3zFqxXGQ\nw+vAtnk4tKtt0kNKPXNs9oApEzGpUAj12EQBRMiKLhFPqNMo8YQ+OUqCyZMYm2Oc\nuJFj9QBN3vLCRFJJZCt7kmpfnC9M4KdMFvhzbDMixrk4qdjuUB0W7bRAiHk0Yupw\nQUZMk0kF4AJrWFliUIsNVIm3q4I0AOlAgbii5rsarDjGaRlE421K6TZxwx+0UfnQ\nG3pn+xmBV7purr0y6VmQOaZvAgMBAAGjNjA0MBMGA1UdEQQMMAqCCG5hY2hvLXBj\nMB0GA1UdDgQWBBQAzw+GSXwuDMhAaUP+M9D28G8yNDANBgkqhkiG9w0BAQUFAAOC\nAQEAKmp+HbJKFXb+NEPdktE8Y+PKV9YWsPpBKCxSHxDkgFSXLnCjxr6RpPYPvgqY\noHjkqzea//qZ4oqVRjOBauGqZ1u+PBYEwsZGSL6v2/AMjM51D1VOvMJz3Rt63ee1\n+oIZbU7teIK3n5BpSjHhScglXf2psZEEmQ5FGTLMUvq1Ri5bMJjmVNNyQH0Cm1WM\nIGGsITC3/oso3+KzpqcWISIqCeBFfYZ4mh/PIOoZEpYSN9jkMBHtlcc9mcR6aQX3\n0KtgoDtLnJA0Xw9ubL3YhxZLOdWTswHGr4AoplV09zQkNG87GIfVDAtzmZHLlP6S\ns0eg2zS0HU2kmUbaL6tbYB5jyw==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://nacho.adm.gu.se/Shibboleth.sso/Artifact/SOAP"
            }
          ], 
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://nacho.adm.gu.se/Shibboleth.sso/NIM/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://nacho.adm.gu.se/Shibboleth.sso/NIM/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://nacho.adm.gu.se/Shibboleth.sso/NIM/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://nacho.adm.gu.se/Shibboleth.sso/NIM/Artifact"
            }
          ]
        }
      ], 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-2.0/nacho.adm.gu.se-shibboleth.xml"
      }
    }
  ], 
  [
    "https://idp2.jacobs-university.de/idp/shibboleth", 
    {
      "entity_id": "https://idp2.jacobs-university.de/idp/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/idp2.jacobs-university.de.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp2.jacobs-university.de/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp2.jacobs-university.de/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp2.jacobs-university.de/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp2.jacobs-university.de/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "jacobs-university.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "text": "idp2.jacobs-university.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=idp2.jacobs-university.de,O=Jacobs University Bremen gGmbH,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFKzCCBBOgAwIBAgIEEgMQTjANBgkqhkiG9w0BAQUFADBsMQswCQYDVQQGEwJE\nRTEnMCUGA1UEChMeSmFjb2JzIFVuaXZlcnNpdHkgQnJlbWVuIGdHbWJIMQ8wDQYD\nVQQLEwZJUkMtSVQxIzAhBgNVBAMTGkphY29icyBVbml2ZXJzaXR5IENBIC0gRzAx\nMB4XDTExMDUzMDEyNTExMFoXDTE2MDUyODEyNTExMFowWjELMAkGA1UEBhMCREUx\nJzAlBgNVBAoTHkphY29icyBVbml2ZXJzaXR5IEJyZW1lbiBnR21iSDEiMCAGA1UE\nAxMZaWRwMi5qYWNvYnMtdW5pdmVyc2l0eS5kZTCCASIwDQYJKoZIhvcNAQEBBQAD\nggEPADCCAQoCggEBALBn+nYoa8EkdT59Kn5iyaouvhAZTZsuAB2hqg2Ldo/8J4Pc\nSU6y0ck/a2xgK45CDK+bE12fGM1A828Z+Zkx615PyXRve3Z3uhKLwWh+aVh9Czsn\nO5a4GGPLY/fVeeJyAWk95Vgco2h7hGxOrCGynMCx+wa89SIA1q4DYo4stDPu5zaC\nkZn2+m2eH6Ht6UjIqA4GEhh9/lXNoLJruq/kFgUA0TC5KelRWO2M40zACljgUXjZ\n3ISZXtFqI+1kHTxUd6h/mlsKVk4iFjYLK5HZwl+8/pueO3spiNISLZ8KBewyehVv\ncGsYLGermgavGpNfuHXQn5eZ9nBveWd6zWkGZz0CAwEAAaOCAeUwggHhMAkGA1Ud\nEwQCMAAwCwYDVR0PBAQDAgTwMBMGA1UdJQQMMAoGCCsGAQUFBwMBMB0GA1UdDgQW\nBBTismVGIRouSFz019/hsKvjP4k35TAfBgNVHSMEGDAWgBQcq0Ha1JXUnR6CzU19\nEyU37B+IpzApBgNVHREEIjAggR5pdHN1cHBvcnRAamFjb2JzLXVuaXZlcnNpdHku\nZGUwgZUGA1UdHwSBjTCBijBDoEGgP4Y9aHR0cDovL2NkcDEucGNhLmRmbi5kZS9q\nYWNvYnMtdW5pdmVyc2l0eS1jYS9wdWIvY3JsL2NhY3JsLmNybDBDoEGgP4Y9aHR0\ncDovL2NkcDIucGNhLmRmbi5kZS9qYWNvYnMtdW5pdmVyc2l0eS1jYS9wdWIvY3Js\nL2NhY3JsLmNybDCBrgYIKwYBBQUHAQEEgaEwgZ4wTQYIKwYBBQUHMAKGQWh0dHA6\nLy9jZHAxLnBjYS5kZm4uZGUvamFjb2JzLXVuaXZlcnNpdHktY2EvcHViL2NhY2Vy\ndC9jYWNlcnQuY3J0ME0GCCsGAQUFBzAChkFodHRwOi8vY2RwMi5wY2EuZGZuLmRl\nL2phY29icy11bml2ZXJzaXR5LWNhL3B1Yi9jYWNlcnQvY2FjZXJ0LmNydDANBgkq\nhkiG9w0BAQUFAAOCAQEAdpCxa/1qVbMWIpJaOkAvhMC6U329LELs5yQLETHvmlPN\nr3t1ULEQnssVDVtD7QfoKpUnRTmcSdOj13e+lTf2KEH46jVowVG9R4xZ4pf9huB6\nIq8CkpOUYTdhzbf3XP/YQRzSWNRe4TJQXqVgvmuG810yKbDRiA2gMnHnE1vbz4u+\n+dL9AEycWmnXgWu5K9QlyAKQxs35VZU1J+2x8PRO8of/csD1C4EcoEwq986tpjRd\nIabwcBEXXxXY0P6/0zC5UrnPCkzyZmL67m/gGNmGhJ3tDnb9mxdrp6t+5JmtG4Qf\nUlOc3b1APPVI3weamhzR+rrUr45b/yLBbFTLwXsTWw==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://idp2.jacobs-university.de:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://idp2.jacobs-university.de:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://idp2.jacobs-university.de:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://idp2.jacobs-university.de:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "jacobs-university.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "text": "idp2.jacobs-university.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=idp2.jacobs-university.de,O=Jacobs University Bremen gGmbH,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFKzCCBBOgAwIBAgIEEgMQTjANBgkqhkiG9w0BAQUFADBsMQswCQYDVQQGEwJE\nRTEnMCUGA1UEChMeSmFjb2JzIFVuaXZlcnNpdHkgQnJlbWVuIGdHbWJIMQ8wDQYD\nVQQLEwZJUkMtSVQxIzAhBgNVBAMTGkphY29icyBVbml2ZXJzaXR5IENBIC0gRzAx\nMB4XDTExMDUzMDEyNTExMFoXDTE2MDUyODEyNTExMFowWjELMAkGA1UEBhMCREUx\nJzAlBgNVBAoTHkphY29icyBVbml2ZXJzaXR5IEJyZW1lbiBnR21iSDEiMCAGA1UE\nAxMZaWRwMi5qYWNvYnMtdW5pdmVyc2l0eS5kZTCCASIwDQYJKoZIhvcNAQEBBQAD\nggEPADCCAQoCggEBALBn+nYoa8EkdT59Kn5iyaouvhAZTZsuAB2hqg2Ldo/8J4Pc\nSU6y0ck/a2xgK45CDK+bE12fGM1A828Z+Zkx615PyXRve3Z3uhKLwWh+aVh9Czsn\nO5a4GGPLY/fVeeJyAWk95Vgco2h7hGxOrCGynMCx+wa89SIA1q4DYo4stDPu5zaC\nkZn2+m2eH6Ht6UjIqA4GEhh9/lXNoLJruq/kFgUA0TC5KelRWO2M40zACljgUXjZ\n3ISZXtFqI+1kHTxUd6h/mlsKVk4iFjYLK5HZwl+8/pueO3spiNISLZ8KBewyehVv\ncGsYLGermgavGpNfuHXQn5eZ9nBveWd6zWkGZz0CAwEAAaOCAeUwggHhMAkGA1Ud\nEwQCMAAwCwYDVR0PBAQDAgTwMBMGA1UdJQQMMAoGCCsGAQUFBwMBMB0GA1UdDgQW\nBBTismVGIRouSFz019/hsKvjP4k35TAfBgNVHSMEGDAWgBQcq0Ha1JXUnR6CzU19\nEyU37B+IpzApBgNVHREEIjAggR5pdHN1cHBvcnRAamFjb2JzLXVuaXZlcnNpdHku\nZGUwgZUGA1UdHwSBjTCBijBDoEGgP4Y9aHR0cDovL2NkcDEucGNhLmRmbi5kZS9q\nYWNvYnMtdW5pdmVyc2l0eS1jYS9wdWIvY3JsL2NhY3JsLmNybDBDoEGgP4Y9aHR0\ncDovL2NkcDIucGNhLmRmbi5kZS9qYWNvYnMtdW5pdmVyc2l0eS1jYS9wdWIvY3Js\nL2NhY3JsLmNybDCBrgYIKwYBBQUHAQEEgaEwgZ4wTQYIKwYBBQUHMAKGQWh0dHA6\nLy9jZHAxLnBjYS5kZm4uZGUvamFjb2JzLXVuaXZlcnNpdHktY2EvcHViL2NhY2Vy\ndC9jYWNlcnQuY3J0ME0GCCsGAQUFBzAChkFodHRwOi8vY2RwMi5wY2EuZGZuLmRl\nL2phY29icy11bml2ZXJzaXR5LWNhL3B1Yi9jYWNlcnQvY2FjZXJ0LmNydDANBgkq\nhkiG9w0BAQUFAAOCAQEAdpCxa/1qVbMWIpJaOkAvhMC6U329LELs5yQLETHvmlPN\nr3t1ULEQnssVDVtD7QfoKpUnRTmcSdOj13e+lTf2KEH46jVowVG9R4xZ4pf9huB6\nIq8CkpOUYTdhzbf3XP/YQRzSWNRe4TJQXqVgvmuG810yKbDRiA2gMnHnE1vbz4u+\n+dL9AEycWmnXgWu5K9QlyAKQxs35VZU1J+2x8PRO8of/csD1C4EcoEwq986tpjRd\nIabwcBEXXxXY0P6/0zC5UrnPCkzyZmL67m/gGNmGhJ3tDnb9mxdrp6t+5JmtG4Qf\nUlOc3b1APPVI3weamhzR+rrUr45b/yLBbFTLwXsTWw==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "de", 
            "text": "Jacobs University Bremen gGmbH", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "Jacobs University Bremen gGmbH", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "http://www.jacobs-university.de", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Mario", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "itsupport@jacobs-university.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Kaiser", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Torge", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "t.schmidt@jacobs-university.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Schmidt", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }
      ]
    }
  ], 
  [
    "https://calipso.cpd.ufv.br/idp/shibboleth", 
    {
      "entity_id": "https://calipso.cpd.ufv.br/idp/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/calipso.cpd.ufv.br.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://calipso.cpd.ufv.br/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://calipso.cpd.ufv.br/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://calipso.cpd.ufv.br/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://calipso.cpd.ufv.br/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "ufv.br", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "information_url": [
                  {
                    "lang": "en", 
                    "text": "http://www.ufv.br/", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "http://www.ufv.br/", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }
                ], 
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "UFV - Universidade Federal de Vicosa", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "UFV - Universidade Federal de Vicosa", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "en", 
                    "text": "UFV - Universidade Federal de Vicosa", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "UFV - Universidade Federal de Vicosa", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIEfTCCA2WgAwIBAgIBADANBgkqhkiG9w0BAQUFADCB3TELMAkGA1UEBhMCQlIx\nFTATBgNVBAgTDE1pbmFzIEdlcmFpczEPMA0GA1UEBxMGVmljb3NhMS0wKwYDVQQK\nEyRVRlYgLSBVbml2ZXJzaWRhZGUgRmVkZXJhbCBkZSBWaWNvc2ExNDAyBgNVBAsT\nK0RUSSAtIERpcmV0b3JpYSBkZSBUZWNub2xvZ2lhIGRhIEluZm9ybWFjYW8xJDAi\nBgkqhkiG9w0BCQEWFXBvbGx5YW5uYS5tb3RhQHVmdi5icjEbMBkGA1UEAxMSY2Fs\naXBzby5jcGQudWZ2LmJyMB4XDTEwMDQwODEyMjk0MFoXDTEzMDQwNzEyMjk0MFow\ngd0xCzAJBgNVBAYTAkJSMRUwEwYDVQQIEwxNaW5hcyBHZXJhaXMxDzANBgNVBAcT\nBlZpY29zYTEtMCsGA1UEChMkVUZWIC0gVW5pdmVyc2lkYWRlIEZlZGVyYWwgZGUg\nVmljb3NhMTQwMgYDVQQLEytEVEkgLSBEaXJldG9yaWEgZGUgVGVjbm9sb2dpYSBk\nYSBJbmZvcm1hY2FvMSQwIgYJKoZIhvcNAQkBFhVwb2xseWFubmEubW90YUB1ZnYu\nYnIxGzAZBgNVBAMTEmNhbGlwc28uY3BkLnVmdi5icjCCASIwDQYJKoZIhvcNAQEB\nBQADggEPADCCAQoCggEBAMozVW2X3OMKcEQcp4RnGTFR2s6iSFoHvkVPjYkpWszZ\n+QfEV3GroXsLWv/RjJ+QtXhXfttFB0fNdiCWhxh2wbkeF2t1v21B+sCirnf+1qm6\ne0oetbRxK6k5O39pioOdEdUrMoN5s2WLoqMmK8ryqgb25GwLVolne9S4Wwyaocgp\nbDYjG11lZia7bEO03TsKPv7i5s4d2htD/wU+qkDT52H6aGI09L25bpwT+/aeUeIH\nFvy750y5voXDaXx6MH9DrGslG7Dr9S/207uq0AxIrHaIgUbl6307tZhFbN32kBLT\nd/413Qb6H4RKsxwv+DLmy3UEa/c4UGeN7Vn7RDm5+/0CAwEAAaNGMEQwCQYDVR0T\nBAIwADALBgNVHQ8EBAMCBaAwKgYDVR0lBCMwIQYIKwYBBQUHAwEGCWCGSAGG+EIE\nAQYKKwYBBAGCNwoDAzANBgkqhkiG9w0BAQUFAAOCAQEAAzFQSYz2mWPl2z0fhnc8\nKfVtknNUnZFOzozeTD4UrmtTjRZo2O2BY6+9imoLcPtW3GH1fV7maZBk2QdHm1NN\n63yt1rqfMVplsCBbRpgSEBdIEHwUDmT3xGrFphhW84QGIh7dJuhdvaQ522C/YVyK\nzqppjlaUSZgqp4/jL8okZfDRgP+Sw3dBt0zJ+YpR60EQ7niv9mUKsJH4JXGcVtV+\neTUY0S2J5SynJg4s5y9P2tMykzU/tA1pa+B1joFMAe37uKlKTiTWPJgSz/Q0/1bY\nZEvbFOP1xLmtYXK8ipoyp3dauE5ls2QwIhanMz5A6SpPJYWO+9nLq7MQiSwfuvvJ\n1Q==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://calipso.cpd.ufv.br:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }, 
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://calipso.cpd.ufv.br:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "pt-br", 
                "text": "http://www.rnp.br/_arquivo/servicos/Politica_CAFe_IDP_final.pdf", 
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy"
              }
            ], 
            "registration_authority": "http://cafe.rnp.br", 
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo", 
            "registration_instant": "2010-01-01T00:00:00Z"
          }
        ]
      }, 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://calipso.cpd.ufv.br:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://calipso.cpd.ufv.br:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "ufv.br", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIEfTCCA2WgAwIBAgIBADANBgkqhkiG9w0BAQUFADCB3TELMAkGA1UEBhMCQlIx\nFTATBgNVBAgTDE1pbmFzIEdlcmFpczEPMA0GA1UEBxMGVmljb3NhMS0wKwYDVQQK\nEyRVRlYgLSBVbml2ZXJzaWRhZGUgRmVkZXJhbCBkZSBWaWNvc2ExNDAyBgNVBAsT\nK0RUSSAtIERpcmV0b3JpYSBkZSBUZWNub2xvZ2lhIGRhIEluZm9ybWFjYW8xJDAi\nBgkqhkiG9w0BCQEWFXBvbGx5YW5uYS5tb3RhQHVmdi5icjEbMBkGA1UEAxMSY2Fs\naXBzby5jcGQudWZ2LmJyMB4XDTEwMDQwODEyMjk0MFoXDTEzMDQwNzEyMjk0MFow\ngd0xCzAJBgNVBAYTAkJSMRUwEwYDVQQIEwxNaW5hcyBHZXJhaXMxDzANBgNVBAcT\nBlZpY29zYTEtMCsGA1UEChMkVUZWIC0gVW5pdmVyc2lkYWRlIEZlZGVyYWwgZGUg\nVmljb3NhMTQwMgYDVQQLEytEVEkgLSBEaXJldG9yaWEgZGUgVGVjbm9sb2dpYSBk\nYSBJbmZvcm1hY2FvMSQwIgYJKoZIhvcNAQkBFhVwb2xseWFubmEubW90YUB1ZnYu\nYnIxGzAZBgNVBAMTEmNhbGlwc28uY3BkLnVmdi5icjCCASIwDQYJKoZIhvcNAQEB\nBQADggEPADCCAQoCggEBAMozVW2X3OMKcEQcp4RnGTFR2s6iSFoHvkVPjYkpWszZ\n+QfEV3GroXsLWv/RjJ+QtXhXfttFB0fNdiCWhxh2wbkeF2t1v21B+sCirnf+1qm6\ne0oetbRxK6k5O39pioOdEdUrMoN5s2WLoqMmK8ryqgb25GwLVolne9S4Wwyaocgp\nbDYjG11lZia7bEO03TsKPv7i5s4d2htD/wU+qkDT52H6aGI09L25bpwT+/aeUeIH\nFvy750y5voXDaXx6MH9DrGslG7Dr9S/207uq0AxIrHaIgUbl6307tZhFbN32kBLT\nd/413Qb6H4RKsxwv+DLmy3UEa/c4UGeN7Vn7RDm5+/0CAwEAAaNGMEQwCQYDVR0T\nBAIwADALBgNVHQ8EBAMCBaAwKgYDVR0lBCMwIQYIKwYBBQUHAwEGCWCGSAGG+EIE\nAQYKKwYBBAGCNwoDAzANBgkqhkiG9w0BAQUFAAOCAQEAAzFQSYz2mWPl2z0fhnc8\nKfVtknNUnZFOzozeTD4UrmtTjRZo2O2BY6+9imoLcPtW3GH1fV7maZBk2QdHm1NN\n63yt1rqfMVplsCBbRpgSEBdIEHwUDmT3xGrFphhW84QGIh7dJuhdvaQ522C/YVyK\nzqppjlaUSZgqp4/jL8okZfDRgP+Sw3dBt0zJ+YpR60EQ7niv9mUKsJH4JXGcVtV+\neTUY0S2J5SynJg4s5y9P2tMykzU/tA1pa+B1joFMAe37uKlKTiTWPJgSz/Q0/1bY\nZEvbFOP1xLmtYXK8ipoyp3dauE5ls2QwIhanMz5A6SpPJYWO+9nLq7MQiSwfuvvJ\n1Q==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "UFV - Universidade Federal de Vicosa", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }, 
          {
            "lang": "pt-br", 
            "text": "UFV - Universidade Federal de Vicosa", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "UFV - Universidade Federal de Vicosa", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }, 
          {
            "lang": "pt-br", 
            "text": "UFV - Universidade Federal de Vicosa", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.ufv.br/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }, 
          {
            "lang": "pt-br", 
            "text": "http://www.ufv.br/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "email_address": [
            {
              "text": "pollyanna.mota@ufv.br", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Pollyanna Lopes Mota", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://idp.uni-wuppertal.de/idp/shibboleth", 
    {
      "entity_id": "https://idp.uni-wuppertal.de/idp/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/idp.uni-wuppertal.de.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.uni-wuppertal.de/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.uni-wuppertal.de/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.uni-wuppertal.de/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.uni-wuppertal.de/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "uni-wuppertal.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "text": "idp.uni-wuppertal.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=idp.uni-wuppertal.de,O=Bergische Universitaet Wuppertal,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFaTCCBFGgAwIBAgIED/eV6DANBgkqhkiG9w0BAQUFADCBuDELMAkGA1UEBhMC\nREUxHDAaBgNVBAgTE05vcmRyaGVpbi1XZXN0ZmFsZW4xEjAQBgNVBAcTCVd1cHBl\ncnRhbDEpMCcGA1UEChMgQmVyZ2lzY2hlIFVuaXZlcnNpdGFldCBXdXBwZXJ0YWwx\nDDAKBgNVBAsTA1pJTTEZMBcGA1UEAxMQVW5pLVd1cHBlcnRhbCBDQTEjMCEGCSqG\nSIb3DQEJARYUcGtpQHVuaS13dXBwZXJ0YWwuZGUwHhcNMTAwNDI4MTExMzI4WhcN\nMTUwNDI3MTExMzI4WjBXMQswCQYDVQQGEwJERTEpMCcGA1UEChMgQmVyZ2lzY2hl\nIFVuaXZlcnNpdGFldCBXdXBwZXJ0YWwxHTAbBgNVBAMTFGlkcC51bmktd3VwcGVy\ndGFsLmRlMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAncKYnT23i7mX\nryQsRo9hoc0c5MLAA8Tffh8xJtLrdHZgt5NwyjXeFxTgFa6EAGfbJVOqRzPzTvrR\nKmfbv6rftqMNs2m3qoNePiESt77Nw14G1mPOEA2nY5nxz59qHQOCkOuOj3hB3CV4\n3WGMrn8uxWcIPb7eQQGPE/DNX2NyEKpbkgVM3rSYHY8wbwtvRcqlhnQfEsNWMykB\no3GjbTMvuK+nN/xbES8T623N6MVPlCDgNCTOAI3+VGAz2NOMNA4J1hrA+xj3TQ76\nuwm85E6nDcVITe1uDCW7aSW5/0zLXuX0WL+YQTdm721Mcy4RraZ5Nht35fM7Yd/A\nYs1g6BfAXQIDAQABo4IB2TCCAdUwCQYDVR0TBAIwADALBgNVHQ8EBAMCBeAwHQYD\nVR0lBBYwFAYIKwYBBQUHAwIGCCsGAQUFBwMBMB0GA1UdDgQWBBQHaE47CvxpJd6L\n83/B5MjuYAX6czAfBgNVHSMEGDAWgBQLpNtTFRSiYzkI4dRpouy3IHkMGjAjBgNV\nHREEHDAagRh6ZWlwZWx0QHVuaS13dXBwZXJ0YWwuZGUwgY0GA1UdHwSBhTCBgjA/\noD2gO4Y5aHR0cDovL2NkcDEucGNhLmRmbi5kZS91bmktd3VwcGVydGFsLWNhL3B1\nYi9jcmwvY2FjcmwuY3JsMD+gPaA7hjlodHRwOi8vY2RwMi5wY2EuZGZuLmRlL3Vu\naS13dXBwZXJ0YWwtY2EvcHViL2NybC9jYWNybC5jcmwwgaYGCCsGAQUFBwEBBIGZ\nMIGWMEkGCCsGAQUFBzAChj1odHRwOi8vY2RwMS5wY2EuZGZuLmRlL3VuaS13dXBw\nZXJ0YWwtY2EvcHViL2NhY2VydC9jYWNlcnQuY3J0MEkGCCsGAQUFBzAChj1odHRw\nOi8vY2RwMi5wY2EuZGZuLmRlL3VuaS13dXBwZXJ0YWwtY2EvcHViL2NhY2VydC9j\nYWNlcnQuY3J0MA0GCSqGSIb3DQEBBQUAA4IBAQBDVsvT8z+AmPlmk/MEKY5Nt5vP\nw3B3oUunFn+sbe2EKFVHr72cArNYSMGifmfTEMEpq3BStFG/o+oC0r6UEV58sLOk\nXm3YiD9H82ZAtoHwn73b/bCXftUugPAj/cHXp1VuEA74Gsh+EoeTk2lgD++AdgCN\n7owrEXrDgtZ8howA/wRhEg8QQxrUVviY1wyfxfU4F6RGS7RpQpqrmvx5ER/dkuIs\ndSxphgBVgx8fkgALpLoD+UhRa3rqTA+0ZKRdKQpxBpGU5/3aN6btgI3pbaSbjtYl\nWVERos0F4cDzSzGONgdQWlLLndqyEZwW33kGpnxHgtDXQf9QtbY3JgawBNAV", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://idp.uni-wuppertal.de:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://idp.uni-wuppertal.de:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://idp.uni-wuppertal.de:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://idp.uni-wuppertal.de:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "uni-wuppertal.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "text": "idp.uni-wuppertal.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=idp.uni-wuppertal.de,O=Bergische Universitaet Wuppertal,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFaTCCBFGgAwIBAgIED/eV6DANBgkqhkiG9w0BAQUFADCBuDELMAkGA1UEBhMC\nREUxHDAaBgNVBAgTE05vcmRyaGVpbi1XZXN0ZmFsZW4xEjAQBgNVBAcTCVd1cHBl\ncnRhbDEpMCcGA1UEChMgQmVyZ2lzY2hlIFVuaXZlcnNpdGFldCBXdXBwZXJ0YWwx\nDDAKBgNVBAsTA1pJTTEZMBcGA1UEAxMQVW5pLVd1cHBlcnRhbCBDQTEjMCEGCSqG\nSIb3DQEJARYUcGtpQHVuaS13dXBwZXJ0YWwuZGUwHhcNMTAwNDI4MTExMzI4WhcN\nMTUwNDI3MTExMzI4WjBXMQswCQYDVQQGEwJERTEpMCcGA1UEChMgQmVyZ2lzY2hl\nIFVuaXZlcnNpdGFldCBXdXBwZXJ0YWwxHTAbBgNVBAMTFGlkcC51bmktd3VwcGVy\ndGFsLmRlMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAncKYnT23i7mX\nryQsRo9hoc0c5MLAA8Tffh8xJtLrdHZgt5NwyjXeFxTgFa6EAGfbJVOqRzPzTvrR\nKmfbv6rftqMNs2m3qoNePiESt77Nw14G1mPOEA2nY5nxz59qHQOCkOuOj3hB3CV4\n3WGMrn8uxWcIPb7eQQGPE/DNX2NyEKpbkgVM3rSYHY8wbwtvRcqlhnQfEsNWMykB\no3GjbTMvuK+nN/xbES8T623N6MVPlCDgNCTOAI3+VGAz2NOMNA4J1hrA+xj3TQ76\nuwm85E6nDcVITe1uDCW7aSW5/0zLXuX0WL+YQTdm721Mcy4RraZ5Nht35fM7Yd/A\nYs1g6BfAXQIDAQABo4IB2TCCAdUwCQYDVR0TBAIwADALBgNVHQ8EBAMCBeAwHQYD\nVR0lBBYwFAYIKwYBBQUHAwIGCCsGAQUFBwMBMB0GA1UdDgQWBBQHaE47CvxpJd6L\n83/B5MjuYAX6czAfBgNVHSMEGDAWgBQLpNtTFRSiYzkI4dRpouy3IHkMGjAjBgNV\nHREEHDAagRh6ZWlwZWx0QHVuaS13dXBwZXJ0YWwuZGUwgY0GA1UdHwSBhTCBgjA/\noD2gO4Y5aHR0cDovL2NkcDEucGNhLmRmbi5kZS91bmktd3VwcGVydGFsLWNhL3B1\nYi9jcmwvY2FjcmwuY3JsMD+gPaA7hjlodHRwOi8vY2RwMi5wY2EuZGZuLmRlL3Vu\naS13dXBwZXJ0YWwtY2EvcHViL2NybC9jYWNybC5jcmwwgaYGCCsGAQUFBwEBBIGZ\nMIGWMEkGCCsGAQUFBzAChj1odHRwOi8vY2RwMS5wY2EuZGZuLmRlL3VuaS13dXBw\nZXJ0YWwtY2EvcHViL2NhY2VydC9jYWNlcnQuY3J0MEkGCCsGAQUFBzAChj1odHRw\nOi8vY2RwMi5wY2EuZGZuLmRlL3VuaS13dXBwZXJ0YWwtY2EvcHViL2NhY2VydC9j\nYWNlcnQuY3J0MA0GCSqGSIb3DQEBBQUAA4IBAQBDVsvT8z+AmPlmk/MEKY5Nt5vP\nw3B3oUunFn+sbe2EKFVHr72cArNYSMGifmfTEMEpq3BStFG/o+oC0r6UEV58sLOk\nXm3YiD9H82ZAtoHwn73b/bCXftUugPAj/cHXp1VuEA74Gsh+EoeTk2lgD++AdgCN\n7owrEXrDgtZ8howA/wRhEg8QQxrUVviY1wyfxfU4F6RGS7RpQpqrmvx5ER/dkuIs\ndSxphgBVgx8fkgALpLoD+UhRa3rqTA+0ZKRdKQpxBpGU5/3aN6btgI3pbaSbjtYl\nWVERos0F4cDzSzGONgdQWlLLndqyEZwW33kGpnxHgtDXQf9QtbY3JgawBNAV", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "de", 
            "text": "Bergische Universit\u00e4t Wuppertal", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "Bergische Universit\u00e4t Wuppertal", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "http://www.uni-wuppertal.de", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Rene", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "zeipelt@uni-wuppertal.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Zeipelt", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Rene", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "zeipelt@uni-wuppertal.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Zeipelt", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://www.degruyter.com/shibboleth", 
    {
      "entity_id": "https://www.degruyter.com/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/www.degruyter.com.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "organization": {
        "organization_name": [
          {
            "lang": "de", 
            "text": "De Gruyter Online", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "De Gruyter Online", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "http://www.degruyter.de/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Scott", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "it@ifactory.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Cipriano", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Ulrike", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "ulrike.engel@degruyter.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Engel", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }
      ], 
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "www.degruyter.com", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=www.degruyter.com", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIDGzCCAgOgAwIBAgIEEpCtsTANBgkqhkiG9w0BAQsFADAcMRowGAYDVQQDExF3\nd3cuZGVncnV5dGVyLmNvbTAeFw0xMjAxMjcwMzE2MzBaFw0xNTAxMjYwMzE2MzBa\nMBwxGjAYBgNVBAMTEXd3dy5kZWdydXl0ZXIuY29tMIIBIjANBgkqhkiG9w0BAQEF\nAAOCAQ8AMIIBCgKCAQEAtToxdgbSOQHMFtLO+p50jHIis3Cg1n08fU8scnC5mGnm\nQKBb+io0YLFMZ+pGrYWl3nOr3lsVnSj+7FWTJYWlGqkGf4fW0htYxeLUYTmw17pg\n2yzjaKKmefQ5EX03dVnMmFfG6n4ITBms/xm28u3JRWmAZ8i4SUZhsZM1UAKmyddv\nDeF4P/MDOg+HotkEZzv8Ce0Iqf5xS2Gl2NvJuQBVQfROyXvC1UvWFPJry8Sp5izg\nnekjb87CWD/sHj/1/ih+t7KTKhyqPEcdywOYzVAlL28LNJm1Sx2T6b+qmxu0sLe8\ne0A7K8/Klevx0c+L+1apbh1vYVH4e3KN+mhsUbBSyQIDAQABo2UwYzAdBgNVHQ4E\nFgQUX0SLbR2HWLTt/d7PhuyMq4CVAD0wQgYDVR0RBDswOYYkaHR0cHM6Ly93d3cu\nZGVncnV5dGVyLmNvbS9zaGliYm9sZXRoghF3d3cuZGVncnV5dGVyLmNvbTANBgkq\nhkiG9w0BAQsFAAOCAQEAM/uD1qjWNFP9lOUk48zRve2pIZIkq+lOr4JB7ORLUaLn\nUFIC3ay1JwSGEoaic0VA9kNGCfevUluMLZJfAtYYQkTx0hqF264tf8W2MdvaFlJa\nWwqciyEhs/Wg4daMUoSfCrKUwhwb3veY5nToqgJ5zJ/5sZYRdjzDH7PumH3klSG0\ne6FV3DgCekCajSBjOoQLjlcgseHXTX3/JguL9uyJVxMNPArbW6ciE7nCAXwg2neL\nklxijSNZsJQno36M5UueC9aLK4mdoJrS06CRLOeyxBNQachanmq6XBx/yWSeBBq5\nvxnuL36+AybWxM2JdPoPKWxXLxi9KgtY1Fw/Heyaug==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "www.degruyter.com", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=www.degruyter.com", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIDGzCCAgOgAwIBAgIEEpCtsTANBgkqhkiG9w0BAQsFADAcMRowGAYDVQQDExF3\nd3cuZGVncnV5dGVyLmNvbTAeFw0xMjAxMjcwMzE2MzBaFw0xNTAxMjYwMzE2MzBa\nMBwxGjAYBgNVBAMTEXd3dy5kZWdydXl0ZXIuY29tMIIBIjANBgkqhkiG9w0BAQEF\nAAOCAQ8AMIIBCgKCAQEAtToxdgbSOQHMFtLO+p50jHIis3Cg1n08fU8scnC5mGnm\nQKBb+io0YLFMZ+pGrYWl3nOr3lsVnSj+7FWTJYWlGqkGf4fW0htYxeLUYTmw17pg\n2yzjaKKmefQ5EX03dVnMmFfG6n4ITBms/xm28u3JRWmAZ8i4SUZhsZM1UAKmyddv\nDeF4P/MDOg+HotkEZzv8Ce0Iqf5xS2Gl2NvJuQBVQfROyXvC1UvWFPJry8Sp5izg\nnekjb87CWD/sHj/1/ih+t7KTKhyqPEcdywOYzVAlL28LNJm1Sx2T6b+qmxu0sLe8\ne0A7K8/Klevx0c+L+1apbh1vYVH4e3KN+mhsUbBSyQIDAQABo2UwYzAdBgNVHQ4E\nFgQUX0SLbR2HWLTt/d7PhuyMq4CVAD0wQgYDVR0RBDswOYYkaHR0cHM6Ly93d3cu\nZGVncnV5dGVyLmNvbS9zaGliYm9sZXRoghF3d3cuZGVncnV5dGVyLmNvbTANBgkq\nhkiG9w0BAQsFAAOCAQEAM/uD1qjWNFP9lOUk48zRve2pIZIkq+lOr4JB7ORLUaLn\nUFIC3ay1JwSGEoaic0VA9kNGCfevUluMLZJfAtYYQkTx0hqF264tf8W2MdvaFlJa\nWwqciyEhs/Wg4daMUoSfCrKUwhwb3veY5nToqgJ5zJ/5sZYRdjzDH7PumH3klSG0\ne6FV3DgCekCajSBjOoQLjlcgseHXTX3/JguL9uyJVxMNPArbW6ciE7nCAXwg2neL\nklxijSNZsJQno36M5UueC9aLK4mdoJrS06CRLOeyxBNQachanmq6XBx/yWSeBBq5\nvxnuL36+AybWxM2JdPoPKWxXLxi9KgtY1Fw/Heyaug==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.degruyter.com/oa/auth/rcv/shib/post"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.degruyter.com/oa/auth/rcv/shib/art"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.degruyter.com/oa/auth/rcv/saml2/post"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.degruyter.com/oa/auth/rcv/saml2/art"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://shibboleth.ufsc.br/idp/shibboleth", 
    {
      "entity_id": "https://shibboleth.ufsc.br/idp/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/shibboleth.ufsc.br.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibboleth.ufsc.br/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibboleth.ufsc.br/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibboleth.ufsc.br/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibboleth.ufsc.br/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "ufsc.br", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "information_url": [
                  {
                    "lang": "en", 
                    "text": "http://www.ufsc.br/", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "http://www.ufsc.br/", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }
                ], 
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "UFSC - Universidade Federal de Santa Catarina", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "UFSC - Universidade Federal de Santa Catarina", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "en", 
                    "text": "UFSC - Universidade Federal de Santa Catarina", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "UFSC - Universidade Federal de Santa Catarina", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIESzCCAzOgAwIBAgIBADANBgkqhkiG9w0BAQUFADCBxDELMAkGA1UEBhMCQlIx\nFzAVBgNVBAgTDlNhbnRhIENhdGFyaW5hMRYwFAYDVQQHEw1GbG9yaWFub3BvbGlz\nMTYwNAYDVQQKEy1VRlNDIC0gVW5pdmVyc2lkYWRlIEZlZGVyYWwgZGUgU2FudGEg\nQ2F0YXJpbmExLzAtBgNVBAsTJk5QRCAtIE51Y2xlbyBkZSBQcm9jZXNzYW1lbnRv\nIGRlIERhZG9zMRswGQYDVQQDExJzaGliYm9sZXRoLnVmc2MuYnIwHhcNMTAwNTAy\nMTUyNTQzWhcNMTMwNTAxMTUyNTQzWjCBxDELMAkGA1UEBhMCQlIxFzAVBgNVBAgT\nDlNhbnRhIENhdGFyaW5hMRYwFAYDVQQHEw1GbG9yaWFub3BvbGlzMTYwNAYDVQQK\nEy1VRlNDIC0gVW5pdmVyc2lkYWRlIEZlZGVyYWwgZGUgU2FudGEgQ2F0YXJpbmEx\nLzAtBgNVBAsTJk5QRCAtIE51Y2xlbyBkZSBQcm9jZXNzYW1lbnRvIGRlIERhZG9z\nMRswGQYDVQQDExJzaGliYm9sZXRoLnVmc2MuYnIwggEiMA0GCSqGSIb3DQEBAQUA\nA4IBDwAwggEKAoIBAQC/oBIF0VeleZ37F3PzefDHAIrgwIaN2aRyLzZ4Uv8/FYsW\nLIXeOxXr49qJ77jFFkv/UzXZJvLvb6yhKC0A18E+ZDcKSQZuYoG8Arx+ohPREI82\n4htm1uAwGAw/SUsDVTgFodHOmIOmal71f6sorCKb1GeBkDkpkSYyYXG3t7fktVY7\n41kqaPcGellMrccwKztjFs31GvNLNZCpLOpF3lLmmpDApOaFO1f9qbSKv0GZPYPm\n/8NxE+4wJMUVHzExCpn/YV0rBd4DfNhU4LJGx6yYQCe+Rj6Uu9vL3AHcBU5kPT/g\ngxte+CDsQADIoYct8oPPDsZa4ezejgh1+XbTcqTzAgMBAAGjRjBEMAkGA1UdEwQC\nMAAwCwYDVR0PBAQDAgWgMCoGA1UdJQQjMCEGCCsGAQUFBwMBBglghkgBhvhCBAEG\nCisGAQQBgjcKAwMwDQYJKoZIhvcNAQEFBQADggEBABDXKoRWo0mR3SNv98le5NbN\n0QeuL52xlm51qmhWHKCT0ph0AmfDO4LdG/o1oPrtZup34/7BBRKHifuvluknH2DW\ndD9JhriTxsCsw/6Q5UtkQ2ZL40eic2VKk7LKsv8WsVq0Dddfz9aQVAmqnAExKLux\nYY+Hd0263kpDiu/0yEiT4G/3RPhKAmtib08Muc5FPQfIjM/IpF0OydhKYLCPQhtQ\n+0L6xe7VreHsP/n9EoGQ/2hZty+D4k2myZ/ypZH00jSs4+0cVysLZGKbRp481nOn\nutYTuLXJ0VDcCFf3RMwNYDCkW9k160NOZIap3RGIftCo2KR12TlxIE0+McltbGQ=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://shibboleth.ufsc.br:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }, 
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://shibboleth.ufsc.br:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "pt-br", 
                "text": "http://www.rnp.br/_arquivo/servicos/Politica_CAFe_IDP_final.pdf", 
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy"
              }
            ], 
            "registration_authority": "http://cafe.rnp.br", 
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo", 
            "registration_instant": "2010-01-01T00:00:00Z"
          }
        ]
      }, 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://shibboleth.ufsc.br:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://shibboleth.ufsc.br:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "ufsc.br", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIESzCCAzOgAwIBAgIBADANBgkqhkiG9w0BAQUFADCBxDELMAkGA1UEBhMCQlIx\nFzAVBgNVBAgTDlNhbnRhIENhdGFyaW5hMRYwFAYDVQQHEw1GbG9yaWFub3BvbGlz\nMTYwNAYDVQQKEy1VRlNDIC0gVW5pdmVyc2lkYWRlIEZlZGVyYWwgZGUgU2FudGEg\nQ2F0YXJpbmExLzAtBgNVBAsTJk5QRCAtIE51Y2xlbyBkZSBQcm9jZXNzYW1lbnRv\nIGRlIERhZG9zMRswGQYDVQQDExJzaGliYm9sZXRoLnVmc2MuYnIwHhcNMTAwNTAy\nMTUyNTQzWhcNMTMwNTAxMTUyNTQzWjCBxDELMAkGA1UEBhMCQlIxFzAVBgNVBAgT\nDlNhbnRhIENhdGFyaW5hMRYwFAYDVQQHEw1GbG9yaWFub3BvbGlzMTYwNAYDVQQK\nEy1VRlNDIC0gVW5pdmVyc2lkYWRlIEZlZGVyYWwgZGUgU2FudGEgQ2F0YXJpbmEx\nLzAtBgNVBAsTJk5QRCAtIE51Y2xlbyBkZSBQcm9jZXNzYW1lbnRvIGRlIERhZG9z\nMRswGQYDVQQDExJzaGliYm9sZXRoLnVmc2MuYnIwggEiMA0GCSqGSIb3DQEBAQUA\nA4IBDwAwggEKAoIBAQC/oBIF0VeleZ37F3PzefDHAIrgwIaN2aRyLzZ4Uv8/FYsW\nLIXeOxXr49qJ77jFFkv/UzXZJvLvb6yhKC0A18E+ZDcKSQZuYoG8Arx+ohPREI82\n4htm1uAwGAw/SUsDVTgFodHOmIOmal71f6sorCKb1GeBkDkpkSYyYXG3t7fktVY7\n41kqaPcGellMrccwKztjFs31GvNLNZCpLOpF3lLmmpDApOaFO1f9qbSKv0GZPYPm\n/8NxE+4wJMUVHzExCpn/YV0rBd4DfNhU4LJGx6yYQCe+Rj6Uu9vL3AHcBU5kPT/g\ngxte+CDsQADIoYct8oPPDsZa4ezejgh1+XbTcqTzAgMBAAGjRjBEMAkGA1UdEwQC\nMAAwCwYDVR0PBAQDAgWgMCoGA1UdJQQjMCEGCCsGAQUFBwMBBglghkgBhvhCBAEG\nCisGAQQBgjcKAwMwDQYJKoZIhvcNAQEFBQADggEBABDXKoRWo0mR3SNv98le5NbN\n0QeuL52xlm51qmhWHKCT0ph0AmfDO4LdG/o1oPrtZup34/7BBRKHifuvluknH2DW\ndD9JhriTxsCsw/6Q5UtkQ2ZL40eic2VKk7LKsv8WsVq0Dddfz9aQVAmqnAExKLux\nYY+Hd0263kpDiu/0yEiT4G/3RPhKAmtib08Muc5FPQfIjM/IpF0OydhKYLCPQhtQ\n+0L6xe7VreHsP/n9EoGQ/2hZty+D4k2myZ/ypZH00jSs4+0cVysLZGKbRp481nOn\nutYTuLXJ0VDcCFf3RMwNYDCkW9k160NOZIap3RGIftCo2KR12TlxIE0+McltbGQ=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "UFSC - Universidade Federal de Santa Catarina", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }, 
          {
            "lang": "pt-br", 
            "text": "UFSC - Universidade Federal de Santa Catarina", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "UFSC - Universidade Federal de Santa Catarina", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }, 
          {
            "lang": "pt-br", 
            "text": "UFSC - Universidade Federal de Santa Catarina", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.ufsc.br/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }, 
          {
            "lang": "pt-br", 
            "text": "http://www.ufsc.br/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "email_address": [
            {
              "text": "marcio@npd.ufsc.br", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Marcio Clemes", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://idp.hochschule-bc.de/idp/shibboleth", 
    {
      "entity_id": "https://idp.hochschule-bc.de/idp/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/idp.hochschule-bc.de.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.hochschule-bc.de/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.hochschule-bc.de/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.hochschule-bc.de/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.hochschule-bc.de/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "hochschule-bc.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "rz1ads.fh-biberach.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "text": "idp.hochschule-bc.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=idp.hochschule-bc.de,OU=Rechenzentrum,O=Hochschule Biberach,L=Biberach,ST=Baden-Wuerttemberg,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFlTCCBH2gAwIBAgIEEV0vSzANBgkqhkiG9w0BAQUFADCBtTELMAkGA1UEBhMC\nREUxGzAZBgNVBAgTEkJhZGVuLVd1ZXJ0dGVtYmVyZzERMA8GA1UEBxMIQmliZXJh\nY2gxHDAaBgNVBAoTE0hvY2hzY2h1bGUgQmliZXJhY2gxFjAUBgNVBAsTDVJlY2hl\nbnplbnRydW0xHTAbBgNVBAMTFEhCQy1HbG9iYWwgQ0EgLSBHIDAxMSEwHwYJKoZI\nhvcNAQkBFhJwa2lAZmgtYmliZXJhY2guZGUwHhcNMTEwMTI0MTcwNzA4WhcNMTYw\nMTIzMTcwNzA4WjCBkjELMAkGA1UEBhMCREUxGzAZBgNVBAgTEkJhZGVuLVd1ZXJ0\ndGVtYmVyZzERMA8GA1UEBxMIQmliZXJhY2gxHDAaBgNVBAoTE0hvY2hzY2h1bGUg\nQmliZXJhY2gxFjAUBgNVBAsTDVJlY2hlbnplbnRydW0xHTAbBgNVBAMTFGlkcC5o\nb2Noc2NodWxlLWJjLmRlMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA\nqtj8K4twdlFO6g3v+5yAWFmcQF2w3RB5dt6fUhF79dhb52jSWwqax/zhGjznGHsh\ncGa2ssx0Srbdd0q6B8pE4qj/6aj7Zwex/mUTZpn1ohvAxmtXhu8UorK42klm9NJV\nA/RSs1mNKqG1sMJIVVAxzJrQ0AcIfYVgkh5pY0tuzCWu2badGTdoiY5xzhy1jcGm\nzRZlWFUO/0iUlEPAZbIHbvqjDrEQ5I/O9AGEIoY2bS2ezEqIULPKXILdFLl/W5m6\n15ctpggBz3iIBZXMnmFNhWYsGGMwv+Q2poANbKlZFZBFsjwwa3DJ9YpNzJKyILgm\n16LqgL+fCGMGPOkvmLIgcwIDAQABo4IBzDCCAcgwCQYDVR0TBAIwADALBgNVHQ8E\nBAMCBeAwHQYDVR0lBBYwFAYIKwYBBQUHAwIGCCsGAQUFBwMBMB0GA1UdDgQWBBRP\n8JgV2opFP3hcLzImHnukv6OGpjAfBgNVHSMEGDAWgBSREBR4GID92wzwllHKuEQz\n3ElITTAkBgNVHREEHTAbgRlzdHVldHpsZUBob2Noc2NodWxlLWJjLmRlMIGFBgNV\nHR8EfjB8MDygOqA4hjZodHRwOi8vY2RwMS5wY2EuZGZuLmRlL2hiYy1nbG9iYWwt\nY2EvcHViL2NybC9jYWNybC5jcmwwPKA6oDiGNmh0dHA6Ly9jZHAyLnBjYS5kZm4u\nZGUvaGJjLWdsb2JhbC1jYS9wdWIvY3JsL2NhY3JsLmNybDCBoAYIKwYBBQUHAQEE\ngZMwgZAwRgYIKwYBBQUHMAKGOmh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvaGJjLWds\nb2JhbC1jYS9wdWIvY2FjZXJ0L2NhY2VydC5jcnQwRgYIKwYBBQUHMAKGOmh0dHA6\nLy9jZHAyLnBjYS5kZm4uZGUvaGJjLWdsb2JhbC1jYS9wdWIvY2FjZXJ0L2NhY2Vy\ndC5jcnQwDQYJKoZIhvcNAQEFBQADggEBAE5WRkxDRsl5jqKwvJCgE4d223Q0n1Tm\n/6tcHlZRGF9U+xktoJbGW3RWMIEWlhO0fdRpF+5yNoYaCjWRsnb3cHT87RecdMCm\ndr2I3fqtuThgpyU+zfUJKfBBqBsp6bQzxxXqcDvnRuhs6AlFMs4s1TG7NyqAs91u\njqqXuLDDqLvZ/sYxFbSf1CXga/ccJPds6NVnMjQgE4bh3FawgFkOD/YWwXjTKbFC\nT7JWbpKEY0A7BSZxatAiCiRYlZSQdvAed4gcD2u5exbUehy9H53yaNX/3Kq3W5Zs\n+rz+tAL97HDBS6P/Dla1hVADcTSuIrFu7C4rJ92NHkT4Ol5261esM9s=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://idp.hochschule-bc.de:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://idp.hochschule-bc.de:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://idp.hochschule-bc.de:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://idp.hochschule-bc.de:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "hochschule-bc.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "rz1ads.fh-biberach.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "text": "idp.hochschule-bc.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=idp.hochschule-bc.de,OU=Rechenzentrum,O=Hochschule Biberach,L=Biberach,ST=Baden-Wuerttemberg,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFlTCCBH2gAwIBAgIEEV0vSzANBgkqhkiG9w0BAQUFADCBtTELMAkGA1UEBhMC\nREUxGzAZBgNVBAgTEkJhZGVuLVd1ZXJ0dGVtYmVyZzERMA8GA1UEBxMIQmliZXJh\nY2gxHDAaBgNVBAoTE0hvY2hzY2h1bGUgQmliZXJhY2gxFjAUBgNVBAsTDVJlY2hl\nbnplbnRydW0xHTAbBgNVBAMTFEhCQy1HbG9iYWwgQ0EgLSBHIDAxMSEwHwYJKoZI\nhvcNAQkBFhJwa2lAZmgtYmliZXJhY2guZGUwHhcNMTEwMTI0MTcwNzA4WhcNMTYw\nMTIzMTcwNzA4WjCBkjELMAkGA1UEBhMCREUxGzAZBgNVBAgTEkJhZGVuLVd1ZXJ0\ndGVtYmVyZzERMA8GA1UEBxMIQmliZXJhY2gxHDAaBgNVBAoTE0hvY2hzY2h1bGUg\nQmliZXJhY2gxFjAUBgNVBAsTDVJlY2hlbnplbnRydW0xHTAbBgNVBAMTFGlkcC5o\nb2Noc2NodWxlLWJjLmRlMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA\nqtj8K4twdlFO6g3v+5yAWFmcQF2w3RB5dt6fUhF79dhb52jSWwqax/zhGjznGHsh\ncGa2ssx0Srbdd0q6B8pE4qj/6aj7Zwex/mUTZpn1ohvAxmtXhu8UorK42klm9NJV\nA/RSs1mNKqG1sMJIVVAxzJrQ0AcIfYVgkh5pY0tuzCWu2badGTdoiY5xzhy1jcGm\nzRZlWFUO/0iUlEPAZbIHbvqjDrEQ5I/O9AGEIoY2bS2ezEqIULPKXILdFLl/W5m6\n15ctpggBz3iIBZXMnmFNhWYsGGMwv+Q2poANbKlZFZBFsjwwa3DJ9YpNzJKyILgm\n16LqgL+fCGMGPOkvmLIgcwIDAQABo4IBzDCCAcgwCQYDVR0TBAIwADALBgNVHQ8E\nBAMCBeAwHQYDVR0lBBYwFAYIKwYBBQUHAwIGCCsGAQUFBwMBMB0GA1UdDgQWBBRP\n8JgV2opFP3hcLzImHnukv6OGpjAfBgNVHSMEGDAWgBSREBR4GID92wzwllHKuEQz\n3ElITTAkBgNVHREEHTAbgRlzdHVldHpsZUBob2Noc2NodWxlLWJjLmRlMIGFBgNV\nHR8EfjB8MDygOqA4hjZodHRwOi8vY2RwMS5wY2EuZGZuLmRlL2hiYy1nbG9iYWwt\nY2EvcHViL2NybC9jYWNybC5jcmwwPKA6oDiGNmh0dHA6Ly9jZHAyLnBjYS5kZm4u\nZGUvaGJjLWdsb2JhbC1jYS9wdWIvY3JsL2NhY3JsLmNybDCBoAYIKwYBBQUHAQEE\ngZMwgZAwRgYIKwYBBQUHMAKGOmh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvaGJjLWds\nb2JhbC1jYS9wdWIvY2FjZXJ0L2NhY2VydC5jcnQwRgYIKwYBBQUHMAKGOmh0dHA6\nLy9jZHAyLnBjYS5kZm4uZGUvaGJjLWdsb2JhbC1jYS9wdWIvY2FjZXJ0L2NhY2Vy\ndC5jcnQwDQYJKoZIhvcNAQEFBQADggEBAE5WRkxDRsl5jqKwvJCgE4d223Q0n1Tm\n/6tcHlZRGF9U+xktoJbGW3RWMIEWlhO0fdRpF+5yNoYaCjWRsnb3cHT87RecdMCm\ndr2I3fqtuThgpyU+zfUJKfBBqBsp6bQzxxXqcDvnRuhs6AlFMs4s1TG7NyqAs91u\njqqXuLDDqLvZ/sYxFbSf1CXga/ccJPds6NVnMjQgE4bh3FawgFkOD/YWwXjTKbFC\nT7JWbpKEY0A7BSZxatAiCiRYlZSQdvAed4gcD2u5exbUehy9H53yaNX/3Kq3W5Zs\n+rz+tAL97HDBS6P/Dla1hVADcTSuIrFu7C4rJ92NHkT4Ol5261esM9s=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "de", 
            "text": "Hochschule Biberach", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "Hochschule Biberach", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "http://www.hochschule-bc.de", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Roland", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "forderer@hochschule-bc.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Forderer", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "DFN-AAI", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "hotline@aai.dfn.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Support", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://aai-logon.uni.li/idp/shibboleth", 
    {
      "entity_id": "https://aai-logon.uni.li/idp/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/aai-logon.uni.li.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://aai-logon.uni.li/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://aai-logon.uni.li/idp/profile/SAML2/Redirect/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://aai-logon.uni.li/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://aai-logon.uni.li/idp/profile/SAML2/POST-SimpleSign/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "uni.li", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "logo": [
                  {
                    "text": "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAAXNSR0IArs4c6QAAACF0RVh0U29mdHdhcmUAR3JhcGhpY0NvbnZlcnRlciAoSW50ZWwpd4f6GQAAACRJREFUeJxiYBgFlINdalL/icG41I4aQKIBo4BGAAAAAP//AwAhn6eucY32zQAAAABJRU5ErkJggg==", 
                    "width": "16", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo", 
                    "height": "16"
                  }, 
                  {
                    "text": "data:image/png;base64,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", 
                    "width": "80", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo", 
                    "height": "60"
                  }
                ], 
                "display_name": [
                  {
                    "lang": "de", 
                    "text": "Universit\u00e4t Liechtenstein", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }, 
                  {
                    "lang": "en", 
                    "text": "University of Liechtenstein", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "de", 
                    "text": "Universit\u00e4t Liechtenstein", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }, 
                  {
                    "lang": "en", 
                    "text": "University of Liechtenstein", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }, 
              {
                "ip_hint": [
                  {
                    "text": "195.176.84.0/23", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&IPHint"
                  }, 
                  {
                    "text": "193.5.26.0/23", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&IPHint"
                  }, 
                  {
                    "text": "193.5.26.0/24", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&IPHint"
                  }, 
                  {
                    "text": "193.5.27.0/24", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&IPHint"
                  }, 
                  {
                    "text": "193.222.112.0/20", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&IPHint"
                  }, 
                  {
                    "text": "193.222.112.0/21", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&IPHint"
                  }, 
                  {
                    "text": "193.222.120.0/22", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&IPHint"
                  }, 
                  {
                    "text": "193.222.124.0/23", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&IPHint"
                  }, 
                  {
                    "text": "195.176.80.0/22", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&IPHint"
                  }, 
                  {
                    "text": "193.222.126.0/24", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&IPHint"
                  }, 
                  {
                    "text": "193.222.127.0/24", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&IPHint"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DiscoHints", 
                "geolocation_hint": [
                  {
                    "text": "geo:47.149655,9.516456", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&GeolocationHint"
                  }
                ], 
                "domain_hint": [
                  {
                    "text": "uni.li", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DomainHint"
                  }
                ]
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDLDCCAhSgAwIBAgIVAP7KVxUdRY7elqq2OvamARNF3EqkMA0GCSqGSIb3DQEB\nBQUAMBsxGTAXBgNVBAMTEGFhaS1sb2dvbi51bmkubGkwHhcNMTEwMjIzMTYxNzEz\nWhcNMTQwMjIzMTYxNzEzWjAbMRkwFwYDVQQDExBhYWktbG9nb24udW5pLmxpMIIB\nIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAmBtxcfEwbrf1mVnSSYlBEk4c\nuL9qaUWgC2yL865lFUiDV8YfcfGW2IEH9VhxFqCoR0FWcHFLwjRBNbPAKApJKNIo\nnHyAjG1cV9xmbV1IrYbJ5An3grdttLLl9Bd3cJOgrteenEFVqZ88DRZUXRhL2Fra\nMRzVwF5bmIOzQB+dgPna+9bO8f7QBnJnCFAiZvpTsByvrFWD7tLZqxhgmo9LRA3z\nGJMRRL+84PDUEUgqZWzLiuNT1DbjWQCAJmTXpz7SPcuL4xA8ptqkiOF0hdYPfWCz\nCxc2ex1AuFxZrH1+s++8pKCVoT95IiV3Gs99A8zl7K/9uid/cUh7FUKhuNKFwQID\nAQABo2cwZTBEBgNVHREEPTA7ghBhYWktbG9nb24udW5pLmxphidodHRwczovL2Fh\naS1sb2dvbi51bmkubGkvaWRwL3NoaWJib2xldGgwHQYDVR0OBBYEFJlvfp9tflll\nx8GGWV2rgJ3DIZ5gMA0GCSqGSIb3DQEBBQUAA4IBAQBxAuAnIbX9N4FQxENsz+j7\nElrr0JGtfl1CKJ/NmP0RYfNkQY7bsEzaiwNh0NqSmyt/RQfZRqn5VVzpYjhjWsZB\nrVRtGEGvxZniGeWIomnMNE9ydRCh0p7kdDFJWL2CaQNMQVtH7S5DqFaZ0mQsRrHV\nHriuYIkDiPVh+Na+gP9qtU34UxPL4sgmDSoXVotZ+6ajdpZr8LFl85gow53ICaZ7\nMrDxL9Jo+5sBGE/8m70LgO/2K+ysAbYlcK0iAL+IJTVmF9lSJJZmrZvq5OcAEOPX\nXS/Qn/lUfwKFLRU+MT/NFboEp3w12jAjCFz+Ii5LonkOhIxzwEWXc2WJcC/aqiXJ", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDIDCCAgigAwIBAgIJAOhZUJ08jQ66MA0GCSqGSIb3DQEBBQUAMBsxGTAXBgNV\nBAMTEGFhaS1sb2dvbi51bmkubGkwHhcNMTMwMTIxMDc1NTM0WhcNMTYwMTIxMDc1\nNTM0WjAbMRkwFwYDVQQDExBhYWktbG9nb24udW5pLmxpMIIBIjANBgkqhkiG9w0B\nAQEFAAOCAQ8AMIIBCgKCAQEAoWSikfE9lbGDSuDLVYRukm1vnqczuErl+U53ZR3K\nT0HMCutP37H0/oEbQdidEH4snG43NZ8uUqnbpmlYESWW6IaaNWhja9K5RfdutZb7\nu9ag3VYZNaVsONLz9OhVtuTSDaMM4SaBVpjKeAW5/V6q1zlTtHIYT/RuLJaZTRll\nxQZkXWiOQb1gfBuj3BqJ0mYwu4vc6rHrWp2sQ3VxavQ5tIAAdm6Ljexd2FEmRVsv\nbc0nuiHUja6mUJAXps6qAJuvPqmKpzrmipfWl3TE6AYHfRlXME+ipIQXXcIEqR1c\nO7OtECCO2ZD2raFIgEO0/gk1Z9jND/zX1DuJ6Yo97v0nJQIDAQABo2cwZTBEBgNV\nHREEPTA7ghBhYWktbG9nb24udW5pLmxphidodHRwczovL2FhaS1sb2dvbi51bmku\nbGkvaWRwL3NoaWJib2xldGgwHQYDVR0OBBYEFBJkmiO3dfjxi25odK77DbKq3fXE\nMA0GCSqGSIb3DQEBBQUAA4IBAQB502va1acwsrgm9jjB6P8FDVWnDOgwWajKwxc5\njDTHIXBFrVurD9LR1jv/imeQKB+vK/CIYVkdmel8jdr/JAkEXtBaQehQgmdnvSeF\nkxfP7braAEbzvpvVvqOeQ33K7WGq8Jw2mSsosrIVxCjxv1WMNbMc6feuhqbx3OLF\n+FpqZwXbA7/lQ/qwMk0fP2dpLYOvfeZG92JyyWqnM0iTUAgFf7xB3Ti4PN8VtRTY\n5+Iqh51yf857CF3PaAYT7wdjGjubkar4zI71q9MQTOZuN4nEtaXFWKJL5tKvo3J4\nKAKEnDkWfKGmYBn6v6NDMXTH1nBVdQnoCDJYipJn+LsStgby", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://aai-logon.uni.li:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://aai-logon.uni.li:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "en", 
                "text": "https://www.switch.ch/aai/federation/switchaai/metadata-registration-practice-statement-20110711.txt", 
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy"
              }
            ], 
            "registration_authority": "http://rr.aai.switch.ch/", 
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo", 
            "registration_instant": "2013-07-24T06:43:39Z"
          }
        ]
      }, 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://aai-logon.uni.li:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://aai-logon.uni.li:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "uni.li", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDLDCCAhSgAwIBAgIVAP7KVxUdRY7elqq2OvamARNF3EqkMA0GCSqGSIb3DQEB\nBQUAMBsxGTAXBgNVBAMTEGFhaS1sb2dvbi51bmkubGkwHhcNMTEwMjIzMTYxNzEz\nWhcNMTQwMjIzMTYxNzEzWjAbMRkwFwYDVQQDExBhYWktbG9nb24udW5pLmxpMIIB\nIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAmBtxcfEwbrf1mVnSSYlBEk4c\nuL9qaUWgC2yL865lFUiDV8YfcfGW2IEH9VhxFqCoR0FWcHFLwjRBNbPAKApJKNIo\nnHyAjG1cV9xmbV1IrYbJ5An3grdttLLl9Bd3cJOgrteenEFVqZ88DRZUXRhL2Fra\nMRzVwF5bmIOzQB+dgPna+9bO8f7QBnJnCFAiZvpTsByvrFWD7tLZqxhgmo9LRA3z\nGJMRRL+84PDUEUgqZWzLiuNT1DbjWQCAJmTXpz7SPcuL4xA8ptqkiOF0hdYPfWCz\nCxc2ex1AuFxZrH1+s++8pKCVoT95IiV3Gs99A8zl7K/9uid/cUh7FUKhuNKFwQID\nAQABo2cwZTBEBgNVHREEPTA7ghBhYWktbG9nb24udW5pLmxphidodHRwczovL2Fh\naS1sb2dvbi51bmkubGkvaWRwL3NoaWJib2xldGgwHQYDVR0OBBYEFJlvfp9tflll\nx8GGWV2rgJ3DIZ5gMA0GCSqGSIb3DQEBBQUAA4IBAQBxAuAnIbX9N4FQxENsz+j7\nElrr0JGtfl1CKJ/NmP0RYfNkQY7bsEzaiwNh0NqSmyt/RQfZRqn5VVzpYjhjWsZB\nrVRtGEGvxZniGeWIomnMNE9ydRCh0p7kdDFJWL2CaQNMQVtH7S5DqFaZ0mQsRrHV\nHriuYIkDiPVh+Na+gP9qtU34UxPL4sgmDSoXVotZ+6ajdpZr8LFl85gow53ICaZ7\nMrDxL9Jo+5sBGE/8m70LgO/2K+ysAbYlcK0iAL+IJTVmF9lSJJZmrZvq5OcAEOPX\nXS/Qn/lUfwKFLRU+MT/NFboEp3w12jAjCFz+Ii5LonkOhIxzwEWXc2WJcC/aqiXJ", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDIDCCAgigAwIBAgIJAOhZUJ08jQ66MA0GCSqGSIb3DQEBBQUAMBsxGTAXBgNV\nBAMTEGFhaS1sb2dvbi51bmkubGkwHhcNMTMwMTIxMDc1NTM0WhcNMTYwMTIxMDc1\nNTM0WjAbMRkwFwYDVQQDExBhYWktbG9nb24udW5pLmxpMIIBIjANBgkqhkiG9w0B\nAQEFAAOCAQ8AMIIBCgKCAQEAoWSikfE9lbGDSuDLVYRukm1vnqczuErl+U53ZR3K\nT0HMCutP37H0/oEbQdidEH4snG43NZ8uUqnbpmlYESWW6IaaNWhja9K5RfdutZb7\nu9ag3VYZNaVsONLz9OhVtuTSDaMM4SaBVpjKeAW5/V6q1zlTtHIYT/RuLJaZTRll\nxQZkXWiOQb1gfBuj3BqJ0mYwu4vc6rHrWp2sQ3VxavQ5tIAAdm6Ljexd2FEmRVsv\nbc0nuiHUja6mUJAXps6qAJuvPqmKpzrmipfWl3TE6AYHfRlXME+ipIQXXcIEqR1c\nO7OtECCO2ZD2raFIgEO0/gk1Z9jND/zX1DuJ6Yo97v0nJQIDAQABo2cwZTBEBgNV\nHREEPTA7ghBhYWktbG9nb24udW5pLmxphidodHRwczovL2FhaS1sb2dvbi51bmku\nbGkvaWRwL3NoaWJib2xldGgwHQYDVR0OBBYEFBJkmiO3dfjxi25odK77DbKq3fXE\nMA0GCSqGSIb3DQEBBQUAA4IBAQB502va1acwsrgm9jjB6P8FDVWnDOgwWajKwxc5\njDTHIXBFrVurD9LR1jv/imeQKB+vK/CIYVkdmel8jdr/JAkEXtBaQehQgmdnvSeF\nkxfP7braAEbzvpvVvqOeQ33K7WGq8Jw2mSsosrIVxCjxv1WMNbMc6feuhqbx3OLF\n+FpqZwXbA7/lQ/qwMk0fP2dpLYOvfeZG92JyyWqnM0iTUAgFf7xB3Ti4PN8VtRTY\n5+Iqh51yf857CF3PaAYT7wdjGjubkar4zI71q9MQTOZuN4nEtaXFWKJL5tKvo3J4\nKAKEnDkWfKGmYBn6v6NDMXTH1nBVdQnoCDJYipJn+LsStgby", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "uni.li", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "Universit\u00e4t Liechtenstein", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }, 
          {
            "lang": "en", 
            "text": "University of Liechtenstein", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "http://www.uni.li/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "AAI", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "mailto:aai@uni.li", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Team", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "support"
        }, 
        {
          "given_name": {
            "text": "AAI", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "mailto:aai@uni.li", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Team", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://portalservices.miun.se/shibboleth", 
    {
      "entity_id": "https://portalservices.miun.se/shibboleth", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://portalservices.miun.se/Shibboleth.sso/SLO/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://portalservices.miun.se/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://portalservices.miun.se/Shibboleth.sso/SLO/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://portalservices.miun.se/Shibboleth.sso/SLO/Artifact"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POS