/*
 * Renesas R-Car xHCI controller firmware version 3
 *
 * Copyright (c) 2014, Renesas Electronics Corporation
 * All rights reserved.
 *
 * Redistribution and use in binary form, without modification, are permitted
 * provided that the following conditions are met:
 *
 * 1. Redistribution in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 2. The name of Renesas Electronics Corporation may not be used to endorse or
 *    promote products derived from this software without specific prior written
 *    permission.
 * 3. Reverse engineering, decompilation, or disassembly of this software is
 *    not permitted.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS ELECTRONICS CORPORATION DISCLAIMS
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS. IN NO EVENT SHALL RENESAS ELECTRONICS
 * CORPORATION BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
 * OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * This file is generated from the firmware blob r8a779x_usb3_v3.dlmem
 * with associated license file LICENCE.r8a779x_usb3, both taken from
 * linux-firmware.git [1] as of:
 *
 *     commit 7c3dfc0bb21bf717dc19a6b677a866aef8b70c35
 *     Author: Yoshihiro Shimoda
 *     Date:   Wed Aug 10 19:56:39 2016 +0900
 *
 *         usb: host: xhci-rcar: update firmware for R-Car H3 and M3-W
 *
 * To generate the content of the array below, use ie. the following command:
 * $ hexdump -v -e '/4 "0x%08x, "' r8a779x_usb3_v3.dlmem | \
 *	sed "s@\(.\{47\}\) @\1\n@g"
 *
 * [1] git://git.kernel.org/pub/scm/linux/kernel/git/dwmw2/linux-firmware.git
 */

#ifndef __FIRMWARE_R8A779X_USB3_V3__
#define __FIRMWARE_R8A779X_USB3_V3__

static const u32 firmware_r8a779x_usb3_v3[] = {
	0xf4c455aa, 0x00d20014, 0x00000000, 0x23dc00e8,
	0x00000000, 0x1a5c2007, 0x0001ff63, 0x001eff80,
	0x0001ff23, 0x007f1a44, 0xff631a5c, 0xff800001,
	0xff2301e2, 0x1a440001, 0x0780007f, 0x06250061,
	0x00021e74, 0x40002e05, 0x40002e05, 0x8000f625,
	0xdc90062a, 0x556f0000, 0xdd14062a, 0x17040000,
	0x5573d612, 0x15ea062a, 0x57650000, 0x16c285d5,
	0x060200f0, 0x1deaffe0, 0xe4251724, 0x05d9128d,
	0x10001620, 0xe4251764, 0xd6151724, 0x1db1129f,
	0x8625ef25, 0x0088063f, 0x32010002, 0x3200007d,
	0x0392ffbe, 0x05e251e0, 0xffbe3200, 0x51e003e4,
	0x520005ba, 0xef2515f5, 0x063f8625, 0x000200ae,
	0x007d3200, 0xd6151724, 0x05b9129d, 0x0d8cffbe,
	0xd61417c4, 0xd6179e24, 0x000037d3, 0x4ad0ffbe,
	0x06405201, 0x26e6007f, 0x0f9a0631, 0x063f0000,
	0x00000e64, 0x0782007f, 0x8f250061, 0xee248019,
	0x30030000, 0x00f4063f, 0x00710002, 0x80158725,
	0x00d00626, 0x3a010002, 0x0108063f, 0x00700002,
	0x0505f01d, 0x7e3d0501, 0x7d030008, 0x80001640,
	0x150d1511, 0xf6241509, 0x0509fd00, 0x1503121f,
	0x801d7725, 0x00013723, 0x1764121e, 0x063f5c11,
	0x0002013e, 0x0642006e, 0x0780007f, 0xe8060061,
	0x0d0cffbe, 0x0001577d, 0x007f0640, 0x0d0a07be,
	0x17201624, 0x9c00062a, 0x118a03ff, 0x17210764,
	0xffec0602, 0xf6240d89, 0x35011720, 0x12820503,
	0x1505125d, 0x1724007f, 0x11461721, 0xf6241db2,
	0x55021720, 0x12c2100a, 0x3f6211c4, 0x160a172d,
	0x15030001, 0x17295724, 0x05bb51e2, 0x17250764,
	0x17251724, 0xeeee062a, 0x12c2eeee, 0x576211c4,
	0x007f172d, 0x00610780, 0xe8060086, 0x17e0ffbe,
	0x5c591724, 0x1281580a, 0xe9e00db1, 0x17240d92,
	0x129dd605, 0x172405d9, 0x129dd605, 0x500bfdd1,
	0x007f0640, 0x3bd60631, 0x063f0000, 0x00000e64,
	0x0780007f, 0x06250061, 0x00021e74, 0x40002e05,
	0x40002e05, 0x0dd00744, 0x17441201, 0xef840dd1,
	0xea610dd1, 0x0dc205e1, 0x0dd1ea63, 0x15b50df2,
	0x0046ff80, 0x1de251e0, 0x14b6ff80, 0xff800df5,
	0x0dc50116, 0x023aff80, 0xff8005b5, 0xff800360,
	0x05c514be, 0xffbe3201, 0x3f841702, 0x39fd0dd1,
	0x0622ddf2, 0xaaaa1100, 0x32013902, 0x16d8ffbe,
	0x0640d5f5, 0x0780007f, 0xffbe0061, 0x51e00398,
	0x320105ca, 0x00eeffbe, 0x1c3affbe, 0x0386ffbe,
	0x05ca51e0, 0xffbe3201, 0xff8000dc, 0xff800438,
	0x321f04a2, 0xfebcffbf, 0x036affbe, 0x05ca51e0,
	0xffbe3201, 0x172400c0, 0x1282d60d, 0xffbe15e9,
	0xf62442ce, 0x1500d600, 0xf1ff5620, 0x1501114a,
	0xd6051724, 0x05d9128d, 0xd6019e24, 0x000087d3,
	0xd6b91724, 0x08f01764, 0x032affbe, 0x05ca51e0,
	0xffbe3201, 0xef250080, 0x063f8625, 0x000202fc,
	0x007d3201, 0x030effbe, 0x05ca51e0, 0xffbe3201,
	0xff800064, 0x062604d6, 0x000224ac, 0x1de8ffbe,
	0x15f251e0, 0x02eeffbe, 0x05ca51e0, 0xffbe3201,
	0xef250044, 0x063f8625, 0x00020338, 0x007d3200,
	0x016087e0, 0xffbe3201, 0x52011578, 0x0dd05744,
	0x007f0640, 0x30e10780, 0xd6051724, 0x128dd200,
	0x172415a9, 0x1282d60d, 0x172405d1, 0x1285d605,
	0x9e240da1, 0x17d3d600, 0xffbe0000, 0xff80440a,
	0x6dd500e2, 0x481affbe, 0xd7e91724, 0x15d11284,
	0xd60d1724, 0x15911282, 0x1e26ffbe, 0xd6011724,
	0x05b91298, 0xd602bfc4, 0xd6051724, 0x05d9129b,
	0x04001640, 0xd6051764, 0xd7e91724, 0x05a91284,
	0x1724d201, 0x128dd605, 0x17240d91, 0x1282d60d,
	0xd1e005d9, 0xffbe05ba, 0xef251eda, 0x063f82b1,
	0x000203de, 0x1724007d, 0x1282d60d, 0xd1e035a9,
	0x172435ea, 0x1281d6b9, 0x178425f9, 0x11e008f3,
	0xea0125ba, 0x80001625, 0x00c4de02, 0x301d15d5,
	0xffbe0086, 0x51e0d8a6, 0x372a0de2, 0xe73b0001,
	0x063f0001, 0x00020422, 0x51e0007c, 0x87c405ca,
	0x0da5d6b8, 0x1724ea41, 0x52025c59, 0x05a91281,
	0xe9ea5201, 0x1201e5d7, 0x08f91744, 0xd60c8fc4,
	0x05dad1e0, 0x205affbe, 0x03caff80, 0x30ff0640,
	0x00610780, 0x8625ef25, 0x046a063f, 0x32010002,
	0xffbe007d, 0xffbe1572, 0x064015de, 0x0780007f,
	0x17a40061, 0x12610dd1, 0x178415ba, 0x11e0e459,
	0xffbe0df2, 0xef2542f2, 0x063f806d, 0x0002049a,
	0x9e24007d, 0x1fd3d60f, 0x07440000, 0x17240dd1,
	0x1285d605, 0x27c405e9, 0xff80d6b2, 0x45d50092,
	0x82b9ef25, 0x04c4063f, 0x007d0002, 0x05c251e0,
	0x181effbe, 0x17243da5, 0x1282e421, 0x32000dd9,
	0x13deffbe, 0x82c1ef25, 0x04e8063f, 0x007d0002,
	0x0dd00744, 0x17242da5, 0x1288e421, 0xffbe05b9,
	0x17242250, 0x1289e425, 0xffbe05b9, 0x1724224c,
	0x128ae425, 0xffbe05b9, 0xffbe24d6, 0x51e000f8,
	0x320105ca, 0xfe4effbd, 0xe4211724, 0x0dd91281,
	0x0dd117a4, 0x05da1261, 0xd60f9e24, 0x00001fd3,
	0xd60c9fc4, 0x0026ff80, 0x007f0640, 0x00610780,
	0x8625ef25, 0x0556063f, 0x32000002, 0xffbe007d,
	0xffbe1562, 0x0640166e, 0x0782007f, 0xef250061,
	0x063f8019, 0x00020574, 0x007d3003, 0x8625ef25,
	0x0582063f, 0x32000002, 0xffbe007d, 0xffbe168c,
	0x372316b4, 0xef250001, 0x063f801d, 0x0002059a,
	0xffbe007d, 0x06421724, 0x0780007f, 0x172400e1,
	0x1281e421, 0x17240d81, 0x1284e439, 0xff8005c1,
	0x45c50090, 0x82b9ef25, 0x05c8063f, 0x007d0002,
	0x05c251e0, 0x188affbe, 0xef253d95, 0x063f82d5,
	0x000205e0, 0x007d3200, 0x8311ef25, 0x05ec063f,
	0x007d0002, 0x08f717a4, 0x05ba11e0, 0x0450ff80,
	0x02bcff80, 0x08f71784, 0x25821262, 0x08f717a4,
	0x1dca11e0, 0x456cffbe, 0xffbee00a, 0xef25313e,
	0x063f82e1, 0x00020622, 0xef25007d, 0x063f82f1,
	0x0002062e, 0xffbe007d, 0xe1e0327a, 0xffbe05f2,
	0x51e04542, 0xffbe05ba, 0x06402cf4, 0x078200ff,
	0xef250061, 0x063f8019, 0x00020658, 0x007d3003,
	0x8625ef25, 0x0666063f, 0x32010002, 0x1724007d,
	0x1281ea01, 0x07c405b1, 0xffbeea00, 0xf62416da,
	0x1558d600, 0x00105640, 0x1559110a, 0x171affbe,
	0x00013723, 0x801def25, 0x0698063f, 0x007d0002,
	0x85adef25, 0x06a4063f, 0x007d0002, 0x8019ef25,
	0x06b2063f, 0x30030002, 0xffbe007d, 0x3723174e,
	0xef250001, 0x063f801d, 0x000206c6, 0x0642007d,
	0x0780007f, 0x121f0061, 0x5c00f624, 0x15091507,
	0x150d150b, 0xfd00f624, 0x15031505, 0xe900f624,
	0x15071505, 0xd600f624, 0x15061505, 0x0d911282,
	0x1764121f, 0x0000d605, 0x00000000, 0x00000000,
	0x8001ef25, 0x0714063f, 0x007d0002, 0x8015ef25,
	0x01ec0626, 0x3a020002, 0x0728063f, 0x007d0002,
	0x8021ef25, 0x0734063f, 0x007d0002, 0x007f0640,
	0x00210780, 0xfbccffbd, 0x07d01620, 0x0fb8f624,
	0x56801480, 0x5481ffff, 0x14835482, 0x001c1620,
	0x0818f624, 0x520413b0, 0x120353b1, 0x13b313b2,
	0x5bb45a01, 0x5c8153b5, 0x00c85620, 0x5e205482,
	0x5c830190, 0x00645e20, 0x54855c84, 0x04870486,
	0x00fa5620, 0x5e205488, 0x5c89012c, 0x5e20548a,
	0x5c8b0014, 0x03c05620, 0x5205548c, 0x539b539a,
	0x639c6206, 0x6b9d6a09, 0x539f5b9e, 0x63a153a0,
	0x5ba25a0a, 0x00105e20, 0x5a025ba3, 0x5ba55ba4,
	0x13a713a6, 0x5ba913a8, 0x13ab5baa, 0x13ad13ac,
	0x5baf53ae, 0x003f0640, 0x00610780, 0xe000f624,
	0x96201544, 0x9e24f0ff, 0x1152fb75, 0x03001682,
	0xafd31545, 0xffbe0000, 0x27c41806, 0xef25d6b2,
	0x063f834d, 0x00020812, 0xffbe007d, 0x064018a0,
	0x0782007f, 0xef250061, 0x063f8019, 0x0002082c,
	0x007d3003, 0x08f317a4, 0x1d8a1261, 0xd6051724,
	0x15c9129c, 0x08001640, 0xd6051764, 0x00001200,
	0x00000000, 0x00000000, 0x12671241, 0x1724fd96,
	0x129cd605, 0x074405b1, 0xffbe08f3, 0x51e02500,
	0xffbe1dc2, 0x37232554, 0xef250001, 0x063f801d,
	0x0002087e, 0x1724007d, 0x5640d605, 0x114a0300,
	0xffbe15c2, 0x17241a1e, 0x1282fd05, 0x17240de1,
	0x1285d605, 0x0d95fd91, 0x00013723, 0x801def25,
	0x08b0063f, 0x007d0002, 0x007f0642, 0x00610782,
	0x8019ef25, 0x08c6063f, 0x30030002, 0xffbe007d,
	0x51e02650, 0xffbe05da, 0xffbe26d6, 0x37232710,
	0xef250001, 0x063f801d, 0x000208e6, 0x0642007d,
	0x0780007f, 0xffbe0021, 0x51e02906, 0xffbe05b2,
	0x06402acc, 0x0780003f, 0xef250061, 0x063f8631,
	0x0002090e, 0x51e0007d, 0xffbe05ba, 0x0640325c,
	0x0780007f, 0xd20070e1, 0x17441201, 0x16250855,
	0xce028000, 0xde020330, 0x17240334, 0xe802eab5,
	0xea9aeaca, 0x003f16c2, 0x35c2e9e2, 0x001f16dd,
	0x000c36e2, 0x170631c4, 0x362694b4, 0x12d894b0,
	0x1261129c, 0x05d21df1, 0x0da11263, 0x1da515c2,
	0x0001e739, 0x0974063f, 0x007c0002, 0xe73b15d5,
	0x063f0001, 0x00020982, 0x06aa007c, 0x0dc2ffff,
	0x0da5d201, 0x0009e73b, 0x0998063f, 0x007c0002,
	0xff8005b5, 0xea41003e, 0x003f56dd, 0xeab65744,
	0x1640c5d5, 0xf6240001, 0x1503ea00, 0xe802155a,
	0xea9aeaca, 0x003f16c2, 0xbd8ae9e2, 0x05fad261,
	0x8339ef25, 0x09d4063f, 0x007d0002, 0x70ff0640,
	0x00610780, 0x5864f006, 0x5ad81303, 0x12d85a9c,
	0x0dba1299, 0x80011724, 0x30005640, 0x25d2114a,
	0x80011724, 0x129a12ca, 0x52c25002, 0x572a51c4,
	0x66408001, 0x514c8000, 0x060b1d82, 0x15d1fff0,
	0x57eb5201, 0x5f2400c0, 0x514be435, 0x38020de2,
	0x000c16e2, 0x854def25, 0x47e211c4, 0x32440fc9,
	0x0a40063f, 0x007d0002, 0x007f0640, 0x00e10780,
	0x2200063c, 0xf624aaaa, 0xe86000a4, 0xea610384,
	0x0d8205e1, 0x0d91ea63, 0x0dd50db2, 0x4292ffbe,
	0xff800dd5, 0x0da50034, 0x0076ff80, 0xffbe05f5,
	0x05c542de, 0xffbe3202, 0x3f840ed2, 0x39fd00a5,
	0x391c05d2, 0xffbe3202, 0x17840eae, 0x11e000a9,
	0x0640ddba, 0x078000ff, 0xefa40061, 0xea6100a5,
	0x159205e1, 0x05e1ea63, 0x0da50d82, 0x430effbe,
	0xffbe0da5, 0x05f543bc, 0x4406ffbe, 0x320305c5,
	0x0e88ffbe, 0x00a53fa4, 0x0d8239fd, 0x33000622,
	0x3902aaaa, 0xffbe3204, 0x06400e5e, 0x0780007f,
	0xef8400e1, 0xe7a400a7, 0x101d00a7, 0xffed0602,
	0x00424de1, 0x00160013, 0x001c0019, 0x0022001f,
	0x00280025, 0x002e002b, 0x00340031, 0x003a0037,
	0x0040003d, 0x00490043, 0xffbe0046, 0x3da543ea,
	0x4488ffbe, 0xffbe35f5, 0x35c5448a, 0x0098ff80,
	0xff803595, 0x2de500d4, 0x0114ff80, 0xff802db5,
	0x2d8501a8, 0x01e0ff80, 0xff8025d5, 0x25a502fe,
	0x05b0ff80, 0xff801df5, 0x1dc505d4, 0x694effbe,
	0xffbe1d95, 0x15e56a22, 0x0604ff80, 0xff8015b5,
	0x1585061e, 0x6c9effbe, 0xffbe0dd5, 0x0da56cea,
	0x6d96ffbe, 0xffbe05f5, 0x05c56e5e, 0xffbe3204,
	0x3f840dba, 0x39fd00a7, 0x06220d82, 0xaaaa4400,
	0x32083902, 0x0d90ffbe, 0x00a73fa4, 0x0d9239fc,
	0x55000622, 0x3902aaaa, 0x00103620, 0x0d78ffbe,
	0x00ff0640, 0x00a717a4, 0x1dab1269, 0x000a0042,
	0x001b000c, 0x0010000e, 0x0012001b, 0x001b0014,
	0x07be0016, 0x07be4470, 0x07be4522, 0x07be458e,
	0x07be45ae, 0x07be461a, 0x07be463a, 0x32054696,
	0x0d4807be, 0x17a4007f, 0x126900a7, 0x00421dcb,
	0x001d000a, 0x0010000c, 0x0016000e, 0x00140012,
	0x0018001d, 0x46fc07be, 0x47d607be, 0x494407be,
	0x487207be, 0x4a3607be, 0x4a8a07be, 0x497a07be,
	0x4b7407be, 0x07be3206, 0x007f0d02, 0x00a717a4,
	0xffe70602, 0x004245d1, 0x00460019, 0x001d001b,
	0x0021001f, 0x00250023, 0x00290027, 0x002d002b,
	0x0031002f, 0x00350033, 0x00370046, 0x003b0039,
	0x0046003d, 0x0046003f, 0x07be0041, 0x07be4b80,
	0x07be4c5e, 0x07be4d0c, 0x07be4d72, 0x07be4dd2,
	0x07be4e8c, 0x07be4f12, 0x07be504c, 0x07be50f6,
	0x07be512c, 0x07be51c6, 0x07be5212, 0x07be5320,
	0x07be5462, 0x07be54d0, 0x07be55fa, 0x07be562e,
	0x07be5698, 0x07be56d0, 0x07be582c, 0x3207599c,
	0x0c6807be, 0x17a4007f, 0x126900a7, 0x00421d8b,
	0x0019000a, 0x000e000c, 0x00100019, 0x00120019,
	0x00140019, 0x5a3e07be, 0x5abc07be, 0x5b5407be,
	0x5bba07be, 0x5c2207be, 0x5d3c07be, 0x07be3208,
	0x007f0c2a, 0x00a717a4, 0x0d811261, 0x12631582,
	0x0dd205f1, 0x05e21264, 0x07be05f5, 0x07805d24,
	0x07be0010, 0x32095f2c, 0x0c0007be, 0x0786007f,
	0x378470e1, 0x16240811, 0xe8068284, 0xe9c2eac5,
	0xe4391724, 0xd200e200, 0x07a4de24, 0x05e91283,
	0x07b337a4, 0x6cb6ffbe, 0xffbe65e5, 0x171da9f6,
	0x12d90001, 0x1264129d, 0xf7dd0d9a, 0x05e20006,
	0x0007e79d, 0xe2d8d201, 0x17bbe29f, 0x3784000d,
	0xcf250811, 0x063f83cd, 0x00020dbc, 0x129f12de,
	0x00793802, 0xf6241201, 0x139c00ac, 0xd1e0039d,
	0xe1e02582, 0x171d0dda, 0xf6240015, 0x12ddeb54,
	0x12c3129e, 0x121ff1c2, 0x15031501, 0x120115a5,
	0x00acf624, 0x571d139c, 0x56ca000b, 0x5241001f,
	0x00c017ea, 0x139d125f, 0x07b4f624, 0x05030501,
	0x0e5497c4, 0x0e540fc4, 0x000d3f3b, 0x0e5407c4,
	0x17441203, 0x300700a7, 0x3acb3298, 0x3ac63a9b,
	0x08e0ffbe, 0x00ac3624, 0x00401620, 0x1501f003,
	0x17250503, 0x3e24839d, 0x400a0e54, 0x1505480b,
	0x05ccffbe, 0x70ff0646, 0x00210780, 0x00a717a4,
	0x0d911261, 0x126415f2, 0x15f22591, 0x1d811266,
	0x1d950de2, 0x003aff80, 0xfd191724, 0x129512c5,
	0x16c21242, 0x17440003, 0x15851714, 0x0132ff80,
	0xffbe0dd5, 0x0da55f18, 0x01a6ff80, 0xffbe05f5,
	0x05c560f8, 0xffbe320a, 0x06400ab2, 0x0780003f,
	0x5f2400e1, 0xee2407b1, 0x662407a4, 0x100b8000,
	0x50021298, 0x51cc52c2, 0x0da211e0, 0xffdf0602,
	0x172a05f1, 0x56400001, 0x51428000, 0x320b05ba,
	0x56405dc5, 0x51423000, 0x36c255e2, 0x100b00ff,
	0xe72512cb, 0x129b841d, 0x063f3802, 0x00020efa,
	0x5744007c, 0x008a0810, 0x060d680a, 0x05baff01,
	0x45b53205, 0x100d6ac5, 0x172211c4, 0x16c28299,
	0x12610007, 0x12633df2, 0x100a35ea, 0x66c21285,
	0x16ca0003, 0x5a01001f, 0x00c05fe2, 0x17196764,
	0x100c62c2, 0x172211c4, 0x5f64ea49, 0x114b171d,
	0x17241dea, 0x12c5fd19, 0x12421295, 0x000376c2,
	0xfd191724, 0x129512c5, 0x000316c2, 0xfd9a11ee,
	0x172d69c4, 0x16c28299, 0x12610007, 0x126315b2,
	0x61c40daa, 0xea49172c, 0x05d25942, 0x17441206,
	0x15c500a7, 0x00133620, 0x000f3fbd, 0x6b0effbe,
	0xef250dd5, 0x063f8625, 0x00020fa8, 0x007d3201,
	0xf6241201, 0x138400a4, 0x06401383, 0x172400ff,
	0x5e24e421, 0x128107a4, 0x172405d9, 0x1283e439,
	0x37ab05d9, 0x07be000f, 0x17846a64, 0x12c50811,
	0x172211c4, 0x16c28299, 0x12630007, 0xf62405f2,
	0x038300a4, 0x13841201, 0x172425a5, 0x57241719,
	0x12c2171d, 0x172211c4, 0x5142ea49, 0xfd191724,
	0x129512c5, 0x05f251e0, 0x16c21242, 0x17440003,
	0x0dd51714, 0x17155784, 0x000316c2, 0x05fa11ea,
	0x000f3fab, 0x00133620, 0x6a7207be, 0x0788007f,
	0x67240021, 0x62d2eab1, 0x160c629a, 0x1261ffff,
	0x126315b3, 0x12691592, 0x126b0df2, 0x126d0dd2,
	0x06020db2, 0x0d82ffef, 0xffed1602, 0x05c31261,
	0x12611259, 0x57844d9b, 0x5e240811, 0x100a8284,
	0x11cb12c5, 0x05b26261, 0x0dba6262, 0x51c452c2,
	0x8085572a, 0x05d9528e, 0x07635200, 0x05f50001,
	0xeb6d5724, 0x00015763, 0xeb715724, 0x5503f003,
	0x1b005640, 0x05075505, 0x56ca530d, 0x568a0003,
	0x538d0080, 0x57225b0e, 0x5ecb0001, 0x6eca00e0,
	0x590d001f, 0x52d45b8e, 0x538f5299, 0xffff560c,
	0x05e35261, 0x05c25269, 0xffef060a, 0x3f8205ea,
	0x3ec7000d, 0x05d5000f, 0xeab13f24, 0x3a9c3acc,
	0xffbe3003, 0x12050436, 0x00a71744, 0x003f0648,
	0x00a717a4, 0x0d811261, 0x12631582, 0x0dd205f1,
	0x05e21264, 0x07be05f5, 0x07be5eac, 0x07be5fc4,
	0x320b6022, 0x082407be, 0x17a4007f, 0x126900a7,
	0x00421dab, 0x000c000a, 0x000e001b, 0x001b0010,
	0x00140012, 0x0016001b, 0x603607be, 0x613a07be,
	0x61a607be, 0x61c607be, 0x623207be, 0x625207be,
	0x62d007be, 0x07be320c, 0x007f07e2, 0x00a717a4,
	0x05d11261, 0x12620db2, 0x05d505c2, 0x643807be,
	0x655407be, 0x07be320d, 0x007f07c2, 0x00a717a4,
	0x05d11261, 0x126205e2, 0x05f505e2, 0x654007be,
	0x65fe07be, 0x666607be, 0x07be320e, 0x0780079e,
	0x008610e1, 0xeac5e806, 0x077de9c4, 0x077d8289,
	0x077d828d, 0x077d8291, 0x077d8295, 0x077d8299,
	0x077d829d, 0xe00682a1, 0xd8070087, 0x6b06ffbe,
	0x8285171d, 0x301c381b, 0x129d12d9, 0x05ca1264,
	0x6c54ffbe, 0xffbe05b5, 0x06406c86, 0x078010ff,
	0xd80770e1, 0xd008009b, 0xc809009a, 0x009ce006,
	0xeac5e81c, 0x82841624, 0x301de9c2, 0x46203a00,
	0xffbe0020, 0x301c062a, 0x401a381b, 0xffbe4819,
	0x301c6cba, 0x0001171d, 0x401a381b, 0x12d94819,
	0x1264129d, 0xffbe158a, 0xf7dd6e9e, 0x48190006,
	0x381b401a, 0x05ca301c, 0x6f1affbe, 0xffbe05e5,
	0x05b56f4e, 0x6f54ffbe, 0x70ff0640, 0x10e10780,
	0xe8060086, 0xe9c4eac5, 0x0087e006, 0xffbed807,
	0x171d7016, 0xee3d8285, 0x301c8284, 0x12d9381b,
	0x1264129d, 0xffbe0dea, 0xf7dd7012, 0x381b0006,
	0x05ca301c, 0x7064ffbe, 0xffbe05e5, 0x05b570c6,
	0x70f8ffbe, 0x10ff0640, 0x00610780, 0xe8060086,
	0x1624eac4, 0xe9c205a4, 0x00051728, 0x008b5807,
	0x30025002, 0x529852d0, 0x00013e0a, 0x32900087,
	0x2da25a61, 0x1dc25a63, 0x35aa5a64, 0x129d12da,
	0x05e21261, 0x0d821263, 0x0da21265, 0x30080dd5,
	0x8512ffbe, 0x300825f5, 0x85f4ffbe, 0x300825b5,
	0x86d6ffbe, 0x30081df5, 0x879cffbe, 0x12da1db5,
	0x1261129d, 0x126505b2, 0xffbe05ca, 0x15a58858,
	0x8862ffbe, 0x12da0df5, 0x1261129d, 0x126505b2,
	0xffbe05ca, 0x05e58860, 0x8886ffbe, 0xffbe05b5,
	0x577d88ac, 0x06400001, 0x0780007f, 0x00860061,
	0xeac4e806, 0x05a41624, 0xefc7e9c2, 0x30070004,
	0xffbe05ca, 0x05b588c4, 0x8976ffbe, 0x0005577d,
	0x007f0640, 0xffe1078a, 0x00bc3620, 0x8cbcffbe,
	0xffbea00a, 0x57638cbe, 0xffbe0002, 0x57638cb6,
	0xffbe0004, 0x57638cb4, 0x36200006, 0xffbe00bc,
	0x57638cae, 0x36200008, 0xffbe00bc, 0x57638caa,
	0xffbe000a, 0x57638cdc, 0xffbe000c, 0x57638cd4,
	0xffbe000e, 0x57638cd2, 0x36200010, 0xffbe00bc,
	0x57638ccc, 0xaa000012, 0xb200ba00, 0xe815ca00,
	0x1624eac3, 0xe9c204a4, 0xd860f01d, 0xe063c067,
	0x0220dff4, 0xffbe3018, 0xf01d8c42, 0xe7ea1061,
	0x57e30220, 0x5fe30003, 0x17ea0005, 0x50650220,
	0x57ebe1db, 0x11dc0220, 0x5fe351c2, 0x10640007,
	0x022017eb, 0x11cad862, 0x000957e3, 0xdfeae066,
	0x30180220, 0xffbed9c2, 0xe7ea8c16, 0xf01d0220,
	0xd060e1db, 0x000b17e3, 0xd8633018, 0x0220d7e2,
	0x8c04ffbe, 0x1061f01d, 0x0220dfea, 0x000d57e3,
	0x000f5fe3, 0x022017ea, 0xd9da5065, 0x022057eb,
	0x51c211db, 0x00115fe3, 0x17eb1064, 0xd0620220,
	0x57e311ca, 0xd8660013, 0x0220d7ea, 0xd1c23018,
	0x8c0affbe, 0x0220dfea, 0xb9fcd9da, 0xb81c05a9,
	0x05a9b1fb, 0xee1db01b, 0xca410040, 0xca640099,
	0x10159dc1, 0x500212c2, 0xbf6a51c4, 0x11c403bd,
	0x03ddb762, 0x0095aa41, 0x85f1aa68, 0xffff064a,
	0x00210780, 0x00041706, 0x12da0087, 0x16c2129d,
	0x3a610003, 0x2dc255b1, 0x3dd13a63, 0x3a6415e2,
	0x12614dda, 0x0de205e1, 0x05e11263, 0x45e50d82,
	0xa402ffbe, 0xffbe45c5, 0x4595a464, 0xa546ffbe,
	0xffbe3de5, 0x3db5a602, 0x05e11261, 0x12630de2,
	0x0d8205e1, 0xffbe35b5, 0x3595a3b8, 0xa41affbe,
	0xffbe2de5, 0x2db5a4d2, 0xa58effbe, 0x12612d85,
	0x0de205e1, 0x05e11263, 0x25850d82, 0xa35cffbe,
	0xffbe1de5, 0x1db5a3d0, 0xa47cffbe, 0xffbe1d85,
	0x15d5a538, 0x05e11261, 0x12630de2, 0x0d8205e1,
	0xffbe0dd5, 0x0db5a31c, 0xa3a6ffbe, 0xffbe0d85,
	0x05d5a428, 0xa50effbe, 0x520105a5, 0x003f0640,
	0x00210780, 0x0fc11784, 0x05f211e0, 0x0fb8f624,
	0x03883069, 0xabf4ffbe, 0xfd111724, 0x05b11284,
	0xfd081fc4, 0x003f0640, 0xf0e10780, 0x8625ef25,
	0x3201d200, 0x15e4063f, 0x007d0002, 0x5c591724,
	0x1281c00a, 0x0000e7e9, 0x80001625, 0x00c0ce02,
	0x301c1db5, 0xffbe0086, 0xe80ac6b2, 0x15b2e9e0,
	0xff80301d, 0x373d00a0, 0xdf390001, 0x063f0001,
	0x0002161e, 0x5261007b, 0xcfdd05c2, 0x05b20003,
	0x0d95d201, 0x1724e241, 0x12815c59, 0x000017e9,
	0xe587e1e2, 0x8625ef25, 0x164a063f, 0x30180002,
	0x501a007d, 0xf0ff0640, 0x10e10780, 0x5c591724,
	0x1281ea02, 0xea0105a9, 0x80001625, 0x00c0de02,
	0x301d15e5, 0xffbe0086, 0xe00ac642, 0x0de2e1e0,
	0xff80301c, 0x373c0030, 0xe73b0001, 0x063f0001,
	0x0002168e, 0x5261007c, 0xea410db2, 0x5c591724,
	0x12815202, 0x520105a9, 0xe5c7e9ea, 0x06405200,
	0x1a5c10ff, 0x00011726, 0x0001062a, 0x17630012,
	0x12cb0001, 0x114a128b, 0x00125640, 0x0dea11ea,
	0x17461202, 0x00000002, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x1a440000, 0xf624007f,
	0x03800d24, 0x00dc1620, 0x12021381, 0x03831382,
	0x0d290764, 0x12011388, 0x007f1389, 0x00e10780,
	0x09e1ef84, 0x09e1e7a4, 0x1267101d, 0x0042259b,
	0x000b0008, 0x0011000e, 0x00170014, 0x001d001a,
	0x006eff80, 0xff8015d5, 0x15a501c2, 0xd03cffbe,
	0xffbe0df5, 0x0dc5d088, 0xd0f8ffbe, 0xff800d95,
	0x05e501f8, 0xd1f6ffbe, 0xffbe05b5, 0x3f84d2f4,
	0x39fd09e1, 0x06220d92, 0xaaaa6600, 0x36203902,
	0xffbe0020, 0x3fa401d2, 0x39fc09e1, 0x06220d92,
	0xaaaa7700, 0x36203902, 0xffbe0040, 0x178401ba,
	0x11e009e1, 0xff8005b2, 0x0640066c, 0x078000ff,
	0x17a40021, 0x126109e1, 0x05f205d1, 0x0d821263,
	0xff800d95, 0x05e5002c, 0x0056ff80, 0xffbe05b5,
	0xffbecdd4, 0x5784d2a8, 0x17a409e1, 0x51e209e3,
	0xf62405d2, 0x13a409bc, 0x064003a5, 0x0780003f,
	0xffbe0061, 0x1724cc88, 0x12815c59, 0xef250df1,
	0x063f8625, 0x000217f4, 0x007d3201, 0x8625ef25,
	0x1802063f, 0x300a0002, 0x0640007d, 0x0788007f,
	0x17240061, 0x12815c59, 0x17246de1, 0x5640c0a1,
	0x114a8000, 0x17240d9a, 0x129cd621, 0x962405d1,
	0x1fd2d623, 0x17240000, 0x5640c0a1, 0x114a8000,
	0x12035da2, 0xc000f624, 0x15501531, 0x55b2114a,
	0x8625ef25, 0x1856063f, 0x32010002, 0x1724007d,
	0x128efb75, 0x178415c9, 0x06025c61, 0xfdc2ffdf,
	0x5c611784, 0xffde0602, 0x172405ea, 0x06c2fb9d,
	0xf5fa000c, 0xfb759624, 0x0000afd2, 0xc0648fc4,
	0xd6239624, 0x00009fd2, 0x0dd11784, 0x05fa1262,
	0x3a013200, 0x4a024200, 0x3224ffbe, 0x17441202,
	0x172409e1, 0x1282c061, 0x074405c9, 0x1db509e1,
	0xc000f624, 0x35583d5a, 0xffbd4210, 0x1624fdf4,
	0xf00308fc, 0x16201501, 0x150300c0, 0x20001620,
	0x17251505, 0x362481ad, 0x400a09bc, 0x1507480b,
	0xfad6ffbd, 0x007f0648, 0x00210780, 0x09e117a4,
	0x05e211e0, 0x05f21264, 0x0d821265, 0xffbe0d95,
	0x05e5ccac, 0xccf2ffbe, 0xffbe05b5, 0xffbecd76,
	0x5784d14c, 0x17a409e1, 0x51e209e3, 0x12640db2,
	0x9e2405da, 0x07d3c049, 0xf6240000, 0x13a409bc,
	0x064003a5, 0x0780003f, 0xffbe0061, 0x1784cf60,
	0x126609e1, 0xef250dda, 0x063f824d, 0x0002195a,
	0xef25007d, 0x063f8251, 0x00021966, 0x0640007d,
	0x0780007f, 0xffbe0021, 0x1784d2a0, 0x12610a15,
	0x05d20de1, 0x05e11263, 0x0d950d82, 0xd30cffbe,
	0xffbe05e5, 0x05b5d3da, 0xd4b4ffbe, 0x003f0640,
	0x00210780, 0x0a0d1724, 0x00ff062b, 0x5200ffff,
	0x1262114b, 0x96400da2, 0x11f20030, 0x96400d92,
	0x11f20031, 0x0d950d82, 0xd518ffbe, 0xffbe05e5,
	0x05b5d5f8, 0xd60effbe, 0x003f0640, 0x00210780,
	0x0a0d1724, 0x5ec25200, 0x060b00ff, 0x15eaff80,
	0x12611298, 0x05f215b1, 0x0d811263, 0x126f0da2,
	0x0dc50db2, 0xd63cffbe, 0xffbe0d95, 0x05e5d64c,
	0xd65cffbe, 0xffbe05b5, 0x0640d662, 0x17a4003f,
	0x12610a0f, 0x05f21581, 0x05f11263, 0x126f0d82,
	0x0d950d82, 0xd65a07be, 0xd68007be, 0xd6a607be,
	0xd6c007be, 0x0780007f, 0x17840021, 0x52000a0d,
	0xff800602, 0x05e20df9, 0xff7e0602, 0x0d8205e9,
	0xffbe0d95, 0x05e5d6f6, 0xd706ffbe, 0xffbe05b5,
	0x0640d720, 0x1784003f, 0x06020a0d, 0x05baff80,
	0xd74607be, 0xff7f0602, 0x07be05ba, 0x07bed768,
	0x0780d76e, 0x17240021, 0x062b0a0d, 0xffff00ff,
	0x114b5200, 0x0da21262, 0x00309640, 0x0d9211f2,
	0x00319640, 0x0d8211f2, 0xffbe0d95, 0x05e5d822,
	0xd8d4ffbe, 0xffbe05b5, 0x0640d8ec, 0x1784003f,
	0x520109e1, 0x05ba1266, 0xd91a07be, 0x1784007f,
	0x520109e1, 0x05ba1266, 0xd98007be, 0x0780007f,
	0xee240061, 0x301dc500, 0xd9d6ffbe, 0x0009361d,
	0xd9e8ffbe, 0x0012361d, 0xffbe3a00, 0x361dda00,
	0x3a000019, 0xda2cffbe, 0x001f361d, 0xffbe3a01,
	0x361dd9ec, 0x3a010026, 0xda18ffbe, 0x007f0640,
	0x00610780, 0xc500ee24, 0xffbe301d, 0x361dda12,
	0xffbe0005, 0x0640da1a, 0x0780007f, 0x170400e1,
	0x16c2097c, 0x12610007, 0x126305b2, 0xffbe05ba,
	0x1724db90, 0x1285c0a1, 0x063c2dd1, 0xaaaa8800,
	0x0b71efa4, 0x0b700744, 0x0d91ea61, 0xea630db2,
	0xea650dc2, 0xea660dd2, 0x0df50de2, 0xdce8ffbe,
	0xffbe0dc5, 0x0d95dd3a, 0xdddcffbe, 0xffbe05e5,
	0x05b5de32, 0x00a6ff80, 0x0b713fa4, 0x05e239fd,
	0x3620391c, 0xffbd0080, 0x1784fd8e, 0x11e00b71,
	0x0640dd8a, 0x078000ff, 0x170400e1, 0x16c2093c,
	0x12610007, 0x126305b2, 0xffbe05ba, 0xffbedbb8,
	0x51e0eba0, 0x17243592, 0x1285c0a1, 0x063c2dd1,
	0xaaaacc00, 0x0c57efa4, 0x0c560744, 0x0d91ea61,
	0xea630db2, 0xea650dc2, 0xea660dd2, 0x0df50de2,
	0xe2dcffbe, 0xffbe0dc5, 0x0d95e32e, 0xe3e8ffbe,
	0xffbe05e5, 0x05b5e47c, 0x00feff80, 0x0c573fa4,
	0x05e239fd, 0x3620391c, 0xffbd0400, 0x1784fd0a,
	0x11e00c57, 0x0640dd8a, 0x078000ff, 0xef840061,
	0x101d0b73, 0x359b126b, 0x000c0042, 0x0012000f,
	0x00180015, 0x001e001b, 0x00240021, 0x002a0027,
	0xffbe002d, 0x2595dd88, 0x005cff80, 0xffbe1de5,
	0x1db5de12, 0xde3effbe, 0xffbe1d85, 0x15d5de94,
	0xde9cffbe, 0xffbe15a5, 0x0df5dea4, 0xdf38ffbe,
	0xffbe0dc5, 0x0d95dfaa, 0xdfe0ffbe, 0xffbe05e5,
	0x05b5dff6, 0xe054ffbe, 0x0b733f84, 0x0d9239fd,
	0x99000622, 0x3902aaaa, 0x01003620, 0xfc78ffbd,
	0x007f0640, 0x00610780, 0x0b73efa4, 0x0d81ea61,
	0xea630da2, 0x0dd20db1, 0x0de2ea65, 0xffbe0df5,
	0x0dc5e036, 0xe05cffbe, 0xffbe0d95, 0x05e5e098,
	0xe0e8ffbe, 0xffbe05b5, 0x3fa4e198, 0x39fd0b73,
	0x06220d92, 0xaaaabb00, 0x36203902, 0xffbd0200,
	0x0640fc26, 0x0780007f, 0xef840061, 0x101d0c59,
	0x359b126b, 0x000c0042, 0x0012000f, 0x00180015,
	0x001e001b, 0x00240021, 0x002a0027, 0xffbe002d,
	0x2595e3c8, 0x005cff80, 0xffbe1de5, 0x1db5e41c,
	0xe47affbe, 0xffbe1d85, 0x15d5e4e0, 0xe508ffbe,
	0xffbe15a5, 0x0df5e530, 0xe544ffbe, 0xffbe0dc5,
	0x0d95e61e, 0xe680ffbe, 0xffbe05e5, 0x05b5e696,
	0xe728ffbe, 0x0c593f84, 0x0d9239fd, 0xdd000622,
	0x3902aaaa, 0x08003620, 0xfb9cffbd, 0x007f0640,
	0x00610780, 0x0c59efa4, 0x0d81ea61, 0xea630dd2,
	0x05f20de1, 0x0de2ea65, 0xffbe0df5, 0x0dc5e70a,
	0xe734ffbe, 0xffbe0d95, 0x05e5e840, 0xe890ffbe,
	0xffbe05b5, 0x3fa4e8c4, 0x39fd0c59, 0x06220d92,
	0xaaaaee00, 0x36203902, 0xffbd1000, 0x0640fb4a,
	0x0780007f, 0x17240061, 0x1286c061, 0x16200d99,
	0x17640020, 0x3202c061, 0xffbe3a00, 0xefa4ef1c,
	0x07440cd5, 0xea610cd9, 0x0db20d91, 0x15c1ea63,
	0xea650db2, 0x0de20dc1, 0xffbe0df5, 0x0dc5eb38,
	0xeb5effbe, 0xffbe0d95, 0x05e5ebe6, 0xec4affbe,
	0xffbe05b5, 0x3fa4ecc8, 0x39fd0cd5, 0x06220d92,
	0xaaaaff00, 0x36203902, 0xffbd2000, 0x17a4fada,
	0x11e00cd9, 0x0640d5da, 0x0000007f, 0x000200de,
	0x0000102c, 0x00001064, 0x0000109e, 0x0000111c,
	0x0000115a, 0x00020142, 0x00020154, 0x000011a6,
	0x000011ee, 0x000012a6, 0x00001250, 0x000012f4,
	0x00001376, 0x0000ccc8, 0x0000ccfc, 0x0000cd72,
	0x0000cda8, 0x0000ce0a, 0x0000cecc, 0x000215d0,
	0x0000cfc4, 0x0000d018, 0x0000d062, 0x00021650,
	0x0000d12e, 0x0000d1a8, 0x0000d204, 0x0000d274,
	0x0000d2d0, 0x0000d334, 0x0000d3fe, 0x0000d462,
	0x0000d4e8, 0x0000d54a, 0x0000d5d0, 0x0000d632,
	0x0000d67a, 0x0000d6e2, 0x0000d73a, 0x0000d7b4,
	0x0000d84c, 0x0000d8c4, 0x0000d916, 0x0000d968,
	0x0000d9e4, 0x0000da36, 0x0000dab2, 0x0000db04,
	0x0000db5a, 0x0000db84, 0x0000dba4, 0x0000dbd8,
	0x0000dc22, 0x0000dc50, 0x0000dc90, 0x0000dcc6,
	0x0000dd14, 0x0000dd62, 0x0000dd86, 0x0000dda2,
	0x0000ddba, 0x0000ddce, 0x0000dde2, 0x0000ddf8,
	0x0000de12, 0x0000de28, 0x0000de3e, 0x0000de84,
	0x0000defe, 0x0000dfb2, 0x0000dfe6, 0x0000e01a,
	0x0000e050, 0x0000e086, 0x0000e0bc, 0x0000e0f2,
	0x0000e150, 0x0000e19c, 0x0000e1d0, 0x0000e212,
	0x0000e304, 0x0000e27a, 0x0000e318, 0x0000e3a4,
	0x0000e42a, 0x0000c608, 0x0000c6d8, 0x0000c74e,
	0x0000c76a, 0x0000c786, 0x0000c7d6, 0x0000c866,
	0x0000c930, 0x0000c960, 0x0000c98e, 0x0000c9c8,
	0x0000c9de, 0x0000c9fc, 0x0000ca28, 0x0000ca6c,
	0x0000ca90, 0x0000caa2, 0x0000cae4, 0x0000cb88,
	0x0000cc30, 0x0000cc52, 0x0000e578, 0x0000ea76,
	0x0000eae6, 0x0000eb6a, 0x0002196a, 0x00021998,
	0x0000eff6, 0x0000f018, 0x000219d4, 0x00021a16,
	0x0000f11e, 0x0000f146, 0x00021a3e, 0x00021a6e,
	0x0000f23e, 0x0000f268, 0x0000f29e, 0x00021a8a,
	0x0000f3c8, 0x0000f3e8, 0x00021ac6, 0x00021ad6,
	0x0000f48a, 0x00021ae6, 0x00021b28, 0x0000f57e,
	0x0000f60c, 0x0000f660, 0x0000f68a, 0x0000f6a2,
	0x0000f6b2, 0x0000f6dc, 0x00021b42, 0x00021bbe,
	0x0000f940, 0x0000f9b6, 0x0000fe5e, 0x0000ffbc,
	0x00010084, 0x000105e0, 0x000106ee, 0x00010722,
	0x00010762, 0x0001078a, 0x000107f8, 0x0001085c,
	0x0001089e, 0x000109e8, 0x00010be0, 0x00010c84,
	0x00010cf4, 0x00010d82, 0x00010da0, 0x00010e0e,
	0x00010e60, 0x00010eb4, 0x00010f18, 0x00010f66,
	0x00010f6e, 0x00010f76, 0x00010fb6, 0x00010fd4,
	0x00001ed6, 0x00002164, 0x000022bc, 0x000023ec,
	0x00002328, 0x00002530, 0x00000000, 0x000025d4,
	0x0000274c, 0x000208ea, 0x000034b4, 0x000035ca,
	0x000036ae, 0x0000372e, 0x0000382e, 0x0000385e,
	0x00003910, 0x00003960, 0x0000398e, 0x000039fc,
	0x00003a68, 0x00003a98, 0x00003ace, 0x00003b0e,
	0x00003b2e, 0x00003b60, 0x00003b6a, 0x000208fe,
	0x00003bb4, 0x00003cba, 0x00003d48, 0x00003dd4,
	0x00003e80, 0x00003f26, 0x0002091a, 0x00004030,
	0x0000408a, 0x00004116, 0x00004144, 0x000041e4,
	0x00004328, 0x00004416, 0x0000450a, 0x00004572,
	0x000045a8, 0x000045fc, 0x00004650, 0x0000468c,
	0x000046de, 0x00004790, 0x0000488c, 0x00004a8c,
	0x000048ac, 0x00004ab0, 0x00000000, 0x00000000,
	0x00000000, 0x00004c18, 0x00004ae0, 0x000022f2,
	0x00004e64, 0x00006e08, 0x00006c0e, 0x00007a08,
	0x00007a48, 0x00007aba, 0x00007ada, 0x00007af8,
	0x00007b82, 0x00007bd2, 0x00007c40, 0x00007cae,
	0x000211b6, 0x00021206, 0x00021274, 0x00008484,
	0x0000851c, 0x0000857a, 0x000085ca, 0x0000865e,
	0x00008758, 0x000087ec, 0x000088a2, 0x00008948,
	0x00008a54, 0x00008ac8, 0x00008b58, 0x00008bdc,
	0x00008bf2, 0x00008c4c, 0x00008cb4, 0x00008d5e,
	0x00008de6, 0x00008e6c, 0x00008f34, 0x00008f5e,
	0x00008ff4, 0x00009046, 0x000090da, 0x0000911c,
	0x00009146, 0x0000918e, 0x000091ae, 0x000091fa,
	0x000092e4, 0x000093a0, 0x000093e2, 0x00009424,
	0x00009458, 0x00009488, 0x000094ca, 0x0000950c,
	0x00009540, 0x00009586, 0x000096ac, 0x000097f6,
	0x000212c0, 0x00009bb2, 0x00009bde, 0x00009c12,
	0x00021362, 0x00009daa, 0x00009e20, 0x00009e7a,
	0x00009eb4, 0x00009f1a, 0x00009f7e, 0x00009fd6,
	0x0000a00a, 0x0002138c, 0x0000a0cc, 0x0000a110,
	0x0000a156, 0x0000a192, 0x0000a1e2, 0x0000a28e,
	0x0000a3ec, 0x0000a4ac, 0x0000a4d6, 0x0000a52a,
	0x0000a62c, 0x0000a662, 0x0000a77c, 0x0000a7be,
	0x0000a7e4, 0x0000a820, 0x0000a87a, 0x0000a914,
	0x0000a972, 0x0000aa32, 0x0000aaa2, 0x0000abf8,
	0x0000ad28, 0x0000ad48, 0x0000adb0, 0x0000ae52,
	0x0000ae8c, 0x0000af88, 0x0000b002, 0x0000b0ae,
	0x0000b1aa, 0x0000b2f0, 0x0000b3b0, 0x0000b442,
	0x0000b470, 0x0000b51a, 0x0000b550, 0x0000b578,
	0x0000b59a, 0x0000b5cc, 0x0000b5f6, 0x0000b648,
	0x0000b78e, 0x0000b7e6, 0x0000b894, 0x000214e8,
	0x0000bb76, 0x0000bce2, 0x0000bd04, 0x0000bd94,
	0x0000be98, 0x0000bfb0, 0x0000bfb2, 0x0000bff2,
	0x0000c060, 0x0000c0d8, 0x0000c158, 0x0000c1c6,
	0x0000c30e, 0x000215a8, 0x0000c388, 0x0000c4d0,
	0x0000c50e, 0x0000c548, 0x0000c588, 0x0000c5c8,
	0x000013e4, 0x00001436, 0x0000147e, 0x000014a6,
	0x000014de, 0x000014f2, 0x00001546, 0x000015c4,
	0x000015ea, 0x0000164c, 0x00001660, 0x0000168e,
	0x000016ca, 0x000016f0, 0x0000171e, 0x0000175e,
	0x00001798, 0x000017be, 0x000017e4, 0x0000183a,
	0x0000186a, 0x000018cc, 0x0000193a, 0x0002017e,
	0x00001966, 0x0000198e, 0x0000a1ca, 0x0000c2b4,
	0x000201bc, 0x0000cc74, 0x00011014, 0x00011076,
	0x000032dc, 0x000079cf
};

#endif /* __FIRMWARE_R8A779X_USB3_V3__ */
