/*###############################################################################
# Linux Management Providers (LMP), Software Inventory provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com, nodir2000@yahoo.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "cmpiOpenDRIM_SAPAvailableForSoftwareInventory.h"

CMPIObjectPath* SoftwareInventory_OpenDRIM_SAPAvailableForSoftwareInventory_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_SAPAvailableForSoftwareInventory& instance) {
	_E_;
	Objectpath op(broker, OpenDRIM_SAPAvailableForSoftwareInventory_classnames[0], OpenDRIM_SAPAvailableForSoftwareInventory_NAMESPACE);

	if (!instance.AvailableSAP_isNULL)
		op.addKey("AvailableSAP", instance.AvailableSAP);

	if (!instance.ManagedElement_isNULL)
		op.addKey("ManagedElement", instance.ManagedElement);

	_L_;
	return op.getHdl();
}

CMPIInstance* SoftwareInventory_OpenDRIM_SAPAvailableForSoftwareInventory_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_SAPAvailableForSoftwareInventory& instance) {
	_E_;
	Objectpath op(broker, SoftwareInventory_OpenDRIM_SAPAvailableForSoftwareInventory_toCMPIObjectPath(broker, instance));
	Instance ci(broker, op);

	_L_;
	return ci.getHdl();
}

void SoftwareInventory_OpenDRIM_SAPAvailableForSoftwareInventory_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_SAPAvailableForSoftwareInventory& instance) {
	_E_;
	Objectpath op(broker, (CMPIObjectPath*) ref);

	if (op.getKey("AvailableSAP", instance.AvailableSAP) == OK)
		instance.AvailableSAP_isNULL = false;

	if (op.getKey("ManagedElement", instance.ManagedElement) == OK)
		instance.ManagedElement_isNULL = false;

	_L_;
}

void SoftwareInventory_OpenDRIM_SAPAvailableForSoftwareInventory_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_SAPAvailableForSoftwareInventory& instance) {
	_E_;
	Instance inst(broker, (CMPIInstance*) ci);

	if (inst.getProperty("AvailableSAP", instance.AvailableSAP) == OK)
		instance.AvailableSAP_isNULL = false;

	if (inst.getProperty("ManagedElement", instance.ManagedElement) == OK)
		instance.ManagedElement_isNULL = false;

	_L_;
}

