/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.request.async;

import java.lang.reflect.Constructor;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeanUtils;
import org.springframework.util.ClassUtils;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.context.request.async.AsyncWebRequest;
import org.springframework.web.context.request.async.NoSupportAsyncWebRequest;
import org.springframework.web.context.request.async.WebAsyncManager;

public abstract class WebAsyncUtils {
    public static final String WEB_ASYNC_MANAGER_ATTRIBUTE = WebAsyncManager.class.getName() + ".WEB_ASYNC_MANAGER";

    public static WebAsyncManager getAsyncManager(ServletRequest servletRequest) {
        WebAsyncManager asyncManager = (WebAsyncManager)servletRequest.getAttribute(WEB_ASYNC_MANAGER_ATTRIBUTE);
        if (asyncManager == null) {
            asyncManager = new WebAsyncManager();
            servletRequest.setAttribute(WEB_ASYNC_MANAGER_ATTRIBUTE, (Object)asyncManager);
        }
        return asyncManager;
    }

    public static WebAsyncManager getAsyncManager(WebRequest webRequest) {
        int scope = 0;
        WebAsyncManager asyncManager = (WebAsyncManager)webRequest.getAttribute(WEB_ASYNC_MANAGER_ATTRIBUTE, scope);
        if (asyncManager == null) {
            asyncManager = new WebAsyncManager();
            webRequest.setAttribute(WEB_ASYNC_MANAGER_ATTRIBUTE, asyncManager, scope);
        }
        return asyncManager;
    }

    public static AsyncWebRequest createAsyncWebRequest(HttpServletRequest request, HttpServletResponse response) {
        return ClassUtils.hasMethod(ServletRequest.class, (String)"startAsync", (Class[])new Class[0]) ? WebAsyncUtils.createStandardServletAsyncWebRequest(request, response) : new NoSupportAsyncWebRequest(request, response);
    }

    private static AsyncWebRequest createStandardServletAsyncWebRequest(HttpServletRequest request, HttpServletResponse response) {
        try {
            String className = "org.springframework.web.context.request.async.StandardServletAsyncWebRequest";
            Class clazz = ClassUtils.forName((String)className, (ClassLoader)WebAsyncUtils.class.getClassLoader());
            Constructor constructor = clazz.getConstructor(HttpServletRequest.class, HttpServletResponse.class);
            return (AsyncWebRequest)BeanUtils.instantiateClass(constructor, (Object[])new Object[]{request, response});
        }
        catch (Throwable t) {
            throw new IllegalStateException("Failed to instantiate StandardServletAsyncWebRequest", t);
        }
    }
}

