#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Mopi
# SPDX-FileCopyrightText: © 2017 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# The Night of the Rabbit
# send your bug reports to contact@dotslashplay.it
###

script_version=20240901.2

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='the-night-of-the-rabbit'
GAME_NAME='The Night of the Rabbit'

ARCHIVE_BASE_0_NAME='setup_the_night_of_the_rabbit_1.2.3.0389_(18473).exe'
ARCHIVE_BASE_0_MD5='f809a5911492fc4dcb8c90f09f2ca515'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1_NAME='setup_the_night_of_the_rabbit_1.2.3.0389_(18473)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='0cfd2d4a5a604e4bf5d070a22fdcc73e'
ARCHIVE_BASE_0_PART2_NAME='setup_the_night_of_the_rabbit_1.2.3.0389_(18473)-2.bin'
ARCHIVE_BASE_0_PART2_MD5='3b510f6837a5aee5fb4ab5c34643c844'
ARCHIVE_BASE_0_SIZE='6200000'
ARCHIVE_BASE_0_VERSION='1.2.3.0389-gog18473'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/the_night_of_the_rabbit'

VISIONAIRE_NAME='rabbit'

CONTENT_PATH_DEFAULT='app'
CONTENT_GAME0_BIN_PATH="${CONTENT_PATH_DEFAULT}/__support/app"
CONTENT_GAME0_BIN_FILES='
config.ini'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/Local Settings/Application Data/Daedalic Entertainment/The Night of the Rabbit'
## Work around missing audio in videos
## TODO: Check if it is still required with current WINE builds
WINE_WINETRICKS_VERBS='dsound'

PKG_BIN_ARCH='32'

## Ensure easy upgrades from packages generated with pre-20240901.2 scripts
PKG_DATA_PROVIDES="${PKG_DATA_PROVIDES:-}
the-night-of-the-rabbit-scenes
the-night-of-the-rabbit-videos"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
