//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Device/SphericalAxisForm.h
//! @brief     Defines class SphericalAxisForm
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_DEVICE_SPHERICALAXISFORM_H
#define BORNAGAIN_GUI_VIEW_DEVICE_SPHERICALAXISFORM_H

#include <QFormLayout>

class BasicAxisItem;
class SafeSpinBox;
class ScientificSpinBox;

/// The form for a spherical axis: contains the bare bone widgets for the user to enter
/// the number of bins and to select the range in degrees (minimum & maximum)
/// The input widgets will be inserted in the form given in the constructor

class SphericalAxisForm : public QObject {
    Q_OBJECT
public:
    SphericalAxisForm(QFormLayout* form, QWidget* parent);
    void setAxisItem(BasicAxisItem* axisItem);
    void setEnabled(bool enabled);

    //! Reload UI from data
    void updateData();

signals:
    void dataChanged();

private slots:
    void onNbinsValueChanged(int value);
    void onMinimumValueChanged(double value);
    void onMaximumValueChanged(double value);

private:
    SafeSpinBox* m_nbinsSpinBox;
    ScientificSpinBox* m_minimumSpinBox;
    ScientificSpinBox* m_maximumSpinBox;
    BasicAxisItem* m_axisItem;
};

#endif // BORNAGAIN_GUI_VIEW_DEVICE_SPHERICALAXISFORM_H
