//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Fit/JobRealTimeWidget.h
//! @brief     Defines class JobRealTimeWidget
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_FIT_JOBREALTIMEWIDGET_H
#define BORNAGAIN_GUI_VIEW_FIT_JOBREALTIMEWIDGET_H

#include "GUI/View/Item/ItemStackPresenter.h"

class JobItem;
class JobModel;
class ParameterTuningWidget;

//! The JobRealTimeWidget class provides tuning of sample parameters in real time.
//! Located on the right side of JobView and is visible when realtime activity is selected.

class JobRealTimeWidget : public QWidget {
    Q_OBJECT
public:
    JobRealTimeWidget(JobModel* jobModel, QWidget* parent = nullptr);

    ParameterTuningWidget* parameterTuningWidget(JobItem* jobItem);

    void resizeEvent(QResizeEvent* event) override;
    void setJobItem(JobItem* jobItem);

signals:
    void widthChanged(int width);

private:
    bool isValidJobItem(JobItem* item);
    void applySettings();

    ItemStackPresenter<ParameterTuningWidget>* m_stackedWidget;
    JobModel* m_jobModel;
};

#endif // BORNAGAIN_GUI_VIEW_FIT_JOBREALTIMEWIDGET_H
