//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Job/JobViewActivities.h
//! @brief     Defines class JobViewActivities
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_JOB_JOBVIEWACTIVITIES_H
#define BORNAGAIN_GUI_VIEW_JOB_JOBVIEWACTIVITIES_H

#include "GUI/View/Job/JobViewFlags.h"
#include <QMap>
#include <QStringList>
#include <QVector>

enum class JobViewActivity { JobView, RealTime, Fitting };

//! The JobViewActivities namespace is a helper to get info related to JobView activities

namespace JobViewActivities {

QList<JobViewActivity> all();

QString nameFromActivity(JobViewActivity activity);
JobViewActivity activityFromName(QString name);

QVector<JobViewFlags::Dock> activeDocks(JobViewActivity activity);

} // namespace JobViewActivities

#endif // BORNAGAIN_GUI_VIEW_JOB_JOBVIEWACTIVITIES_H
