{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetSize: TVector3;
    procedure SetSize(const Value: TVector3);
    function GetManifold: Boolean;
    procedure SetManifold(const Value: Boolean);
    function GetTexCoord: TX3DNode;
    procedure SetTexCoord(const Value: TX3DNode);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdSize: TSFVec3f;
    { Internal wrapper for property @code(Size). This wrapper API may change, we advise to access simpler @code(Size) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSize: TSFVec3f read FFdSize;
    {  }
    property Size: TVector3 read GetSize write SetSize;

    strict private FFdSolid: TSFBool;
    { Internal wrapper for property @code(Solid). This wrapper API may change, we advise to access simpler @code(Solid) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSolid: TSFBool read FFdSolid;

    strict private FFdManifold: TSFBool;
    { Internal wrapper for property @code(Manifold). This wrapper API may change, we advise to access simpler @code(Manifold) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdManifold: TSFBool read FFdManifold;
    {  }
    property Manifold: Boolean read GetManifold write SetManifold;

    strict private FFdTexCoord: TSFNode;
    { Internal wrapper for property @code(TexCoord). This wrapper API may change, we advise to access simpler @code(TexCoord) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdTexCoord: TSFNode read FFdTexCoord;
    {  }
    property TexCoord: TX3DNode read GetTexCoord write SetTexCoord;

{$endif read_interface}

{$ifdef read_implementation}

{ TTeapotNode ----------------------------------------------- }

function TTeapotNode.GetSize: TVector3;
begin
  Result := FdSize.Value;
end;

procedure TTeapotNode.SetSize(const Value: TVector3);
begin
  FdSize.Send(Value);
end;

function TTeapotNode.GetManifold: Boolean;
begin
  Result := FdManifold.Value;
end;

procedure TTeapotNode.SetManifold(const Value: Boolean);
begin
  FdManifold.Send(Value);
end;

function TTeapotNode.GetTexCoord: TX3DNode;
begin
  if FdTexCoord.Value is TX3DNode then
    Result := TX3DNode(FdTexCoord.Value)
  else
    Result := nil;
end;

procedure TTeapotNode.SetTexCoord(const Value: TX3DNode);
begin
  FdTexCoord.Send(Value);
end;

class function TTeapotNode.ClassX3DType: String;
begin
  Result := 'Teapot';
end;

procedure TTeapotNode.CreateNode;
begin
  inherited;

  FFdSize := TSFVec3f.Create(Self, False, 'size', Vector3(3, 3, 3));
   FdSize.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSize);

  FFdSolid := TSFBool.Create(Self, False, 'solid', true);
   FdSolid.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSolid);

  FFdManifold := TSFBool.Create(Self, False, 'manifold', false);
   FdManifold.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdManifold);

  FFdTexCoord := TSFNode.Create(Self, True, 'texCoord', [TTextureCoordinateGeneratorNode, TProjectedTextureCoordinateNode, TMultiGeneratedTextureCoordinateNode]);
   FdTexCoord.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdTexCoord);
end;

{$endif read_implementation}
