{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetAmbientIntensity: Single;
    procedure SetAmbientIntensity(const Value: Single);
    function GetBackAmbientIntensity: Single;
    procedure SetBackAmbientIntensity(const Value: Single);
    function GetBackDiffuseColor: TCastleColorRGB;
    procedure SetBackDiffuseColor(const Value: TCastleColorRGB);
    function GetBackEmissiveColor: TCastleColorRGB;
    procedure SetBackEmissiveColor(const Value: TCastleColorRGB);
    function GetBackShininess: Single;
    procedure SetBackShininess(const Value: Single);
    function GetBackSpecularColor: TCastleColorRGB;
    procedure SetBackSpecularColor(const Value: TCastleColorRGB);
    function GetBackTransparency: Single;
    procedure SetBackTransparency(const Value: Single);
    function GetDiffuseColor: TCastleColorRGB;
    procedure SetDiffuseColor(const Value: TCastleColorRGB);
    function GetEmissiveColor: TCastleColorRGB;
    procedure SetEmissiveColor(const Value: TCastleColorRGB);
    function GetShininess: Single;
    procedure SetShininess(const Value: Single);
    function GetSeparateBackColor: Boolean;
    procedure SetSeparateBackColor(const Value: Boolean);
    function GetSpecularColor: TCastleColorRGB;
    procedure SetSpecularColor(const Value: TCastleColorRGB);
    function GetTransparency: Single;
    procedure SetTransparency(const Value: Single);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdAmbientIntensity: TSFFloat;
    { Internal wrapper for property @code(AmbientIntensity). This wrapper API may change, we advise to access simpler @code(AmbientIntensity) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdAmbientIntensity: TSFFloat read FFdAmbientIntensity;
    {  }
    property AmbientIntensity: Single read GetAmbientIntensity write SetAmbientIntensity;

    strict private FFdBackAmbientIntensity: TSFFloat;
    { Internal wrapper for property @code(BackAmbientIntensity). This wrapper API may change, we advise to access simpler @code(BackAmbientIntensity) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdBackAmbientIntensity: TSFFloat read FFdBackAmbientIntensity;
    {  }
    property BackAmbientIntensity: Single read GetBackAmbientIntensity write SetBackAmbientIntensity;

    strict private FFdBackDiffuseColor: TSFColor;
    { Internal wrapper for property @code(BackDiffuseColor). This wrapper API may change, we advise to access simpler @code(BackDiffuseColor) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdBackDiffuseColor: TSFColor read FFdBackDiffuseColor;
    {  }
    property BackDiffuseColor: TCastleColorRGB read GetBackDiffuseColor write SetBackDiffuseColor;

    strict private FFdBackEmissiveColor: TSFColor;
    { Internal wrapper for property @code(BackEmissiveColor). This wrapper API may change, we advise to access simpler @code(BackEmissiveColor) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdBackEmissiveColor: TSFColor read FFdBackEmissiveColor;
    {  }
    property BackEmissiveColor: TCastleColorRGB read GetBackEmissiveColor write SetBackEmissiveColor;

    strict private FFdBackShininess: TSFFloat;
    { Internal wrapper for property @code(BackShininess). This wrapper API may change, we advise to access simpler @code(BackShininess) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdBackShininess: TSFFloat read FFdBackShininess;
    {  }
    property BackShininess: Single read GetBackShininess write SetBackShininess;

    strict private FFdBackSpecularColor: TSFColor;
    { Internal wrapper for property @code(BackSpecularColor). This wrapper API may change, we advise to access simpler @code(BackSpecularColor) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdBackSpecularColor: TSFColor read FFdBackSpecularColor;
    {  }
    property BackSpecularColor: TCastleColorRGB read GetBackSpecularColor write SetBackSpecularColor;

    strict private FFdBackTransparency: TSFFloat;
    { Internal wrapper for property @code(BackTransparency). This wrapper API may change, we advise to access simpler @code(BackTransparency) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdBackTransparency: TSFFloat read FFdBackTransparency;
    {  }
    property BackTransparency: Single read GetBackTransparency write SetBackTransparency;

    strict private FFdDiffuseColor: TSFColor;
    { Internal wrapper for property @code(DiffuseColor). This wrapper API may change, we advise to access simpler @code(DiffuseColor) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdDiffuseColor: TSFColor read FFdDiffuseColor;
    {  }
    property DiffuseColor: TCastleColorRGB read GetDiffuseColor write SetDiffuseColor;

    strict private FFdEmissiveColor: TSFColor;
    { Internal wrapper for property @code(EmissiveColor). This wrapper API may change, we advise to access simpler @code(EmissiveColor) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdEmissiveColor: TSFColor read FFdEmissiveColor;
    {  }
    property EmissiveColor: TCastleColorRGB read GetEmissiveColor write SetEmissiveColor;

    strict private FFdShininess: TSFFloat;
    { Internal wrapper for property @code(Shininess). This wrapper API may change, we advise to access simpler @code(Shininess) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdShininess: TSFFloat read FFdShininess;
    {  }
    property Shininess: Single read GetShininess write SetShininess;

    strict private FFdSeparateBackColor: TSFBool;
    { Internal wrapper for property @code(SeparateBackColor). This wrapper API may change, we advise to access simpler @code(SeparateBackColor) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSeparateBackColor: TSFBool read FFdSeparateBackColor;
    {  }
    property SeparateBackColor: Boolean read GetSeparateBackColor write SetSeparateBackColor;

    strict private FFdSpecularColor: TSFColor;
    { Internal wrapper for property @code(SpecularColor). This wrapper API may change, we advise to access simpler @code(SpecularColor) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSpecularColor: TSFColor read FFdSpecularColor;
    {  }
    property SpecularColor: TCastleColorRGB read GetSpecularColor write SetSpecularColor;

    strict private FFdTransparency: TSFFloat;
    { Internal wrapper for property @code(Transparency). This wrapper API may change, we advise to access simpler @code(Transparency) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdTransparency: TSFFloat read FFdTransparency;
    {  }
    property Transparency: Single read GetTransparency write SetTransparency;

{$endif read_interface}

{$ifdef read_implementation}

{ TTwoSidedMaterialNode ----------------------------------------------- }

function TTwoSidedMaterialNode.GetAmbientIntensity: Single;
begin
  Result := FdAmbientIntensity.Value;
end;

procedure TTwoSidedMaterialNode.SetAmbientIntensity(const Value: Single);
begin
  FdAmbientIntensity.Send(Value);
end;

function TTwoSidedMaterialNode.GetBackAmbientIntensity: Single;
begin
  Result := FdBackAmbientIntensity.Value;
end;

procedure TTwoSidedMaterialNode.SetBackAmbientIntensity(const Value: Single);
begin
  FdBackAmbientIntensity.Send(Value);
end;

function TTwoSidedMaterialNode.GetBackDiffuseColor: TCastleColorRGB;
begin
  Result := FdBackDiffuseColor.Value;
end;

procedure TTwoSidedMaterialNode.SetBackDiffuseColor(const Value: TCastleColorRGB);
begin
  FdBackDiffuseColor.Send(Value);
end;

function TTwoSidedMaterialNode.GetBackEmissiveColor: TCastleColorRGB;
begin
  Result := FdBackEmissiveColor.Value;
end;

procedure TTwoSidedMaterialNode.SetBackEmissiveColor(const Value: TCastleColorRGB);
begin
  FdBackEmissiveColor.Send(Value);
end;

function TTwoSidedMaterialNode.GetBackShininess: Single;
begin
  Result := FdBackShininess.Value;
end;

procedure TTwoSidedMaterialNode.SetBackShininess(const Value: Single);
begin
  FdBackShininess.Send(Value);
end;

function TTwoSidedMaterialNode.GetBackSpecularColor: TCastleColorRGB;
begin
  Result := FdBackSpecularColor.Value;
end;

procedure TTwoSidedMaterialNode.SetBackSpecularColor(const Value: TCastleColorRGB);
begin
  FdBackSpecularColor.Send(Value);
end;

function TTwoSidedMaterialNode.GetBackTransparency: Single;
begin
  Result := FdBackTransparency.Value;
end;

procedure TTwoSidedMaterialNode.SetBackTransparency(const Value: Single);
begin
  FdBackTransparency.Send(Value);
end;

function TTwoSidedMaterialNode.GetDiffuseColor: TCastleColorRGB;
begin
  Result := FdDiffuseColor.Value;
end;

procedure TTwoSidedMaterialNode.SetDiffuseColor(const Value: TCastleColorRGB);
begin
  FdDiffuseColor.Send(Value);
end;

function TTwoSidedMaterialNode.GetEmissiveColor: TCastleColorRGB;
begin
  Result := FdEmissiveColor.Value;
end;

procedure TTwoSidedMaterialNode.SetEmissiveColor(const Value: TCastleColorRGB);
begin
  FdEmissiveColor.Send(Value);
end;

function TTwoSidedMaterialNode.GetShininess: Single;
begin
  Result := FdShininess.Value;
end;

procedure TTwoSidedMaterialNode.SetShininess(const Value: Single);
begin
  FdShininess.Send(Value);
end;

function TTwoSidedMaterialNode.GetSeparateBackColor: Boolean;
begin
  Result := FdSeparateBackColor.Value;
end;

procedure TTwoSidedMaterialNode.SetSeparateBackColor(const Value: Boolean);
begin
  FdSeparateBackColor.Send(Value);
end;

function TTwoSidedMaterialNode.GetSpecularColor: TCastleColorRGB;
begin
  Result := FdSpecularColor.Value;
end;

procedure TTwoSidedMaterialNode.SetSpecularColor(const Value: TCastleColorRGB);
begin
  FdSpecularColor.Send(Value);
end;

function TTwoSidedMaterialNode.GetTransparency: Single;
begin
  Result := FdTransparency.Value;
end;

procedure TTwoSidedMaterialNode.SetTransparency(const Value: Single);
begin
  FdTransparency.Send(Value);
end;

class function TTwoSidedMaterialNode.ClassX3DType: String;
begin
  Result := 'TwoSidedMaterial';
end;

procedure TTwoSidedMaterialNode.CreateNode;
begin
  inherited;

  FFdAmbientIntensity := TSFFloat.Create(Self, True, 'ambientIntensity', 0.2);
   FdAmbientIntensity.ChangeAlways := chVisibleNonGeometry;
   FdAmbientIntensity.MustBeNonnegative := true;
  AddField(FFdAmbientIntensity);

  FFdBackAmbientIntensity := TSFFloat.Create(Self, True, 'backAmbientIntensity', 0.2);
   FdBackAmbientIntensity.ChangeAlways := chVisibleNonGeometry;
   FdBackAmbientIntensity.MustBeNonnegative := true;
  AddField(FFdBackAmbientIntensity);

  FFdBackDiffuseColor := TSFColor.Create(Self, True, 'backDiffuseColor', Vector3(0.8, 0.8, 0.8));
   FdBackDiffuseColor.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdBackDiffuseColor);

  FFdBackEmissiveColor := TSFColor.Create(Self, True, 'backEmissiveColor', Vector3(0, 0, 0));
   FdBackEmissiveColor.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdBackEmissiveColor);

  FFdBackShininess := TSFFloat.Create(Self, True, 'backShininess', 0.2);
   FdBackShininess.ChangeAlways := chVisibleNonGeometry;
   FdBackShininess.MustBeNonnegative := true;
  AddField(FFdBackShininess);

  FFdBackSpecularColor := TSFColor.Create(Self, True, 'backSpecularColor', Vector3(0, 0, 0));
   FdBackSpecularColor.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdBackSpecularColor);

  FFdBackTransparency := TSFFloat.Create(Self, True, 'backTransparency', 0);
   FdBackTransparency.ChangeAlways := chVisibleNonGeometry;
   FdBackTransparency.MustBeNonnegative := true;
  AddField(FFdBackTransparency);

  FFdDiffuseColor := TSFColor.Create(Self, True, 'diffuseColor', Vector3(0.8, 0.8, 0.8));
   FdDiffuseColor.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdDiffuseColor);

  FFdEmissiveColor := TSFColor.Create(Self, True, 'emissiveColor', Vector3(0, 0, 0));
   FdEmissiveColor.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdEmissiveColor);

  FFdShininess := TSFFloat.Create(Self, True, 'shininess', 0.2);
   FdShininess.ChangeAlways := chVisibleNonGeometry;
   FdShininess.MustBeNonnegative := true;
  AddField(FFdShininess);

  FFdSeparateBackColor := TSFBool.Create(Self, True, 'separateBackColor', false);
   FdSeparateBackColor.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSeparateBackColor);

  FFdSpecularColor := TSFColor.Create(Self, True, 'specularColor', Vector3(0, 0, 0));
   FdSpecularColor.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSpecularColor);

  FFdTransparency := TSFFloat.Create(Self, True, 'transparency', 0);
   FdTransparency.ChangeAlways := chVisibleNonGeometry;
   FdTransparency.MustBeNonnegative := true;
  AddField(FFdTransparency);
end;

{$endif read_implementation}
