/*
 *
 *  Copyright (C) 1999, Institute for MicroTherapy
 *
 *  This software and supporting documentation were developed by
 *
 *    University of Witten/Herdecke
 *    Department of Radiology and MicroTherapy
 *    Institute for MicroTherapy
 *    Medical computer science
 *    
 *    Universitaetsstrasse 142
 *    44799 Bochum, Germany
 *    
 *    http://www.microtherapy.de/go/cs
 *    mailto:computer.science@microtherapy.de
 *
 *  THIS SOFTWARE IS MADE AVAILABLE,  AS IS,  AND THE INSTITUTE MAKES  NO 
 *  WARRANTY REGARDING THE SOFTWARE, ITS PERFORMANCE, ITS MERCHANTABILITY
 *  OR FITNESS FOR ANY PARTICULAR USE, FREEDOM FROM ANY COMPUTER DISEASES 
 *  OR ITS CONFORMITY TO ANY SPECIFICATION. THE ENTIRE RISK AS TO QUALITY 
 *  AND PERFORMANCE OF THE SOFTWARE IS WITH THE USER.
 *
 *  Author :      $Author: kleber $
 *  Last update : $Date: 2001/06/06 10:32:29 $
 *  Revision :    $Revision: 1.1.1.1 $
 *  State:        $State: Exp $
*/

package browser;

/*
	A basic extension of the java.awt.Dialog class
 */

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import J2Ci.*;
import jToolkit.gui.*;
import main.MainContext;

/**
 * Opens a Send-To-Dialog for sending IODs, series and studies to another DICOM-application.
 * After choosing a target and clicking on OK the targetID is returned in selectedItem.
 * Element okClicked indicates whether the SendTo-Button is clicked or not.
 *
 * @author Andreas Schroeter
 * @since 30.04.1999
*/
public class SendToDlg extends JDialog
{
    JList list;
    
    /**
     * Indicated whether the SentTo button was clicked to close the dialog frame.
    */
    public boolean okClicked = false;
    
    /**
     * Contains a targetID after dialog closing (if OK-Button is clicked).
    */
    public String selectedItem = null;
    
    private jDVInterface dvi;
    JFrame parent;
    boolean highQualityScreen = false;
    
	public SendToDlg(JFrame parent, jDVInterface dvi)
	{
		super(parent);
		
		this.parent = parent;
		

		// This code is automatically generated by Visual Cafe when you add
		// components to the visual environment. It instantiates and initializes
		// the components. To modify the code, only use code syntax that matches
		// what Visual Cafe can generate, or Visual Cafe may be unable to back
		// parse your Java file into its visual environment.
		//{{INIT_CONTROLS
		getContentPane().setLayout(new BorderLayout (5, 5));
		
		
		setVisible(false);
		setLocation (300, 200);
		//}}
        setModal (true);
		setTitle("Send IOD to...");

		//{{REGISTER_LISTENERS
		SymWindow aSymWindow = new SymWindow();
		this.addWindowListener(aSymWindow);
		//}}
		
		this.dvi = dvi;
		

		DefaultListModel lm = new DefaultListModel(); 
		
		list = new JList (lm);
		getContentPane().add("Center", new JScrollPane(list));
		
		JPanel p = new JPanel ();		
				
		p.setBackground(java.awt.Color.lightGray);	
		
		sendBt.setText("Send to");
		p.add(sendBt);
		
		infoBt.setText("Details...");
		p.add(infoBt);
		
		cancelBt.setText("Cancel");
		p.add(cancelBt);
		
		getContentPane().add ("South", p);
		
		LoadAll ();
		
		SymAction lSymAction = new SymAction();
		infoBt.addActionListener(lSymAction);
		sendBt.addActionListener(lSymAction);
		cancelBt.addActionListener(lSymAction);
		infoBt.addKeyListener(lSymAction);
		sendBt.addKeyListener(lSymAction);
		cancelBt.addKeyListener(lSymAction);
		cancelBt.grabFocus();
		pack();
	}
	

    /**
     * Shows or hides the component depending on the boolean flag b.
     * @param b  if true, show the component; otherwise, hide the component.
     * @see java.awt.Component#isVisible
     */
    public void setVisible(boolean b)
	{
		if(b)
		{
			Rectangle bounds = getParent().getBounds();
			Rectangle abounds = getBounds();
	
			setLocation(bounds.x + (bounds.width - abounds.width)/ 2,
				 bounds.y + (bounds.height - abounds.height)/2);
		}
		super.setVisible(b);
	}

	//{{DECLARE_CONTROLS
	JButton sendBt = new JButton ();
	JButton cancelBt = new JButton ();
	JButton infoBt = new JButton ();
	//}}

	class SymWindow extends java.awt.event.WindowAdapter
	{
		public void windowClosing(java.awt.event.WindowEvent event)
		{
			Object object = event.getSource();
			if (object == SendToDlg.this)
				SendToDlg_WindowClosing(event);
		}
	}
	
	void SendToDlg_WindowClosing(java.awt.event.WindowEvent event)
	{
		setVisible(false);
	}
	
	class SymAction  extends KeyAdapter implements java.awt.event.ActionListener
	{
		public void actionPerformed(java.awt.event.ActionEvent event)
		{
			handle( event.getSource());
			
		}
		public void keyPressed(KeyEvent e)
		{
		    if (e.getKeyCode() == KeyEvent.VK_ENTER) handle(e.getSource());
		 }
        private void handle(Object source)
        {
			if (source == infoBt) OnDetails ();
			if (source == sendBt) OnSend ();
			if (source == cancelBt) SendToDlg_WindowClosing (null);
            
        }


	}
	
	protected void LoadAll()
	{
	    DefaultListModel lm = (DefaultListModel) list.getModel();
	    
	    int nrOfTargets = dvi.getNumberOfTargets(jDVPSPeerType.DVPSE_storage);
	    
	    for (int i = 0; i < nrOfTargets; i++)
	    {
	        String tid = dvi.getTargetID(i,jDVPSPeerType.DVPSE_storage);
	        
	        lm.addElement (dvi.getTargetDescription(tid));
	    }
	}
	
	protected void OnSend()
	{
	    
	    DefaultListModel lm = (DefaultListModel) list.getModel();
	    
	    int si = list.getSelectedIndex();
	    if (si == -1) return;
	    
	    okClicked = true;	    
	    selectedItem = dvi.getTargetID(si,jDVPSPeerType.DVPSE_storage);
	    
	    SendToDlg_WindowClosing (null);
	}
	
	public void OnDetails ()
	{	
	    int si = list.getSelectedIndex();
	    if (si == -1) return;	    
	    
	    JDialog detailDlg = new JDialog (this, "Details", true);
	    detailDlg.getContentPane().setLayout (new BorderLayout (5, 5));
	    JTextArea info = new JTextArea();
	    info.setTabSize(15);	    
	    info.setEditable(false);
	    CommandJButton okBt = new CommandJButton (new DisposeCommand(detailDlg), 0);
	    okBt.setText("  Ok  ");
	    okBt.setBackground(java.awt.Color.lightGray);		
	    JPanel p = new JPanel ();
	    p.add (okBt);
		
        
		
	    String tid = dvi.getTargetID(si,jDVPSPeerType.DVPSE_storage);
	    String desc, hostn, aet;
	    info.append("Description:\t" + dvi.getTargetDescription(tid));
	    info.append("\nID:\t" + tid);
	    info.append("\nHostname:\t" + dvi.getTargetHostname(tid));
	    info.append("\nPort:\t" + dvi.getTargetPort(tid));
	    info.append("\nAE Title:\t" + dvi.getTargetAETitle(tid));
	    info.append("\nMax. PDU:\t" + dvi.getTargetMaxPDU(tid));
	    info.append("\nImplicit Only:\t" + dvi.getTargetImplicitOnly(tid) );
	    info.append("\nDisable new VRs:\t" + dvi.getTargetDisableNewVRs(tid));
	    
	    info.append("\nUse TLS:\t" + (dvi.getTargetUseTLS(tid) ? "yes" : "no"));
	    info.append("\nBit Preserving Mode:\t" + (dvi.getTargetBitPreservingMode(tid)));
	    
	    int peerAuthentication = dvi.getTargetPeerAuthentication(tid);
	    String peerAuthenticationDescription = "";
	    if (peerAuthentication == 0)peerAuthenticationDescription = "Verify peer certificate, refuse transmission if absent";
	    if (peerAuthentication == 1)peerAuthenticationDescription = "Verify peer certificate if present";
	    if (peerAuthentication == 2)peerAuthenticationDescription = "Don't verify peer certificate";
	    
	    info.append("\nPeer Authentication:\t" + peerAuthenticationDescription);

	    int numberOfCipherSuites = dvi.getTargetNumberOfCipherSuites(tid);
	    if (numberOfCipherSuites> 0)
	    {
	        info.append("\nCipher Suites");
	        
	        for (int i = 0; i < numberOfCipherSuites; i++) 
	            info.append("\n    NR: " + i +"\t" + dvi.getTargetCipherSuite(tid, i));
	    }   
	    detailDlg.getContentPane().add ("South", p);
	    detailDlg.getContentPane().add ("Center", new JScrollPane(info));
	    detailDlg.pack();
	    detailDlg.setLocationRelativeTo(this);
	    detailDlg.show();
	}
}
/*
 *  CVS Log
 *  $Log: SendToDlg.java,v $
 *  Revision 1.1.1.1  2001/06/06 10:32:29  kleber
 *  Init commit for DICOMscope 3.5
 *  Create new CVS
 *
*/
