/*
 *      fhist - file history and comparison tools
 *      Copyright (C) 2002, 2008 Peter Miller
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 3 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program. If not, see
 *      <http://www.gnu.org/licenses/>.
 */

#ifndef COMMON_UNDO_H
#define COMMON_UNDO_H

#include <main.h>


/**
  * The undo function is called when quit() is cvalled with a non-zero
  * exit status.  This allows temporaty files (etc) to be cleaned up on
  * an error exit.
  */
void undo(void);

/**
  * The undo_unlink fucntiuon is used to register afile which should be
  * unlinked in the event of an error.
  */
void undo_unlink(const char *);

#endif /* COMMON_UNDO_H */
