/* puzzle-view.c generated by valac 0.34.0.4-5c9b2, the Vala compiler
 * generated from puzzle-view.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <cairo.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define TYPE_TILE_IMAGE (tile_image_get_type ())
#define TILE_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TILE_IMAGE, TileImage))
#define TILE_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TILE_IMAGE, TileImageClass))
#define IS_TILE_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TILE_IMAGE))
#define IS_TILE_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TILE_IMAGE))
#define TILE_IMAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TILE_IMAGE, TileImageClass))

typedef struct _TileImage TileImage;
typedef struct _TileImageClass TileImageClass;
typedef struct _TileImagePrivate TileImagePrivate;

#define TYPE_TILE (tile_get_type ())
#define TILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TILE, Tile))
#define TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TILE, TileClass))
#define IS_TILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TILE))
#define IS_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TILE))
#define TILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TILE, TileClass))

typedef struct _Tile Tile;
typedef struct _TileClass TileClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_PUZZLE_VIEW (puzzle_view_get_type ())
#define PUZZLE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE_VIEW, PuzzleView))
#define PUZZLE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE_VIEW, PuzzleViewClass))
#define IS_PUZZLE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE_VIEW))
#define IS_PUZZLE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE_VIEW))
#define PUZZLE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE_VIEW, PuzzleViewClass))

typedef struct _PuzzleView PuzzleView;
typedef struct _PuzzleViewClass PuzzleViewClass;
typedef struct _PuzzleViewPrivate PuzzleViewPrivate;

#define TYPE_PUZZLE (puzzle_get_type ())
#define PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE, Puzzle))
#define PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE, PuzzleClass))
#define IS_PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE))
#define IS_PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE))
#define PUZZLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE, PuzzleClass))

typedef struct _Puzzle Puzzle;
typedef struct _PuzzleClass PuzzleClass;

#define TYPE_THEME (theme_get_type ())
#define THEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME, Theme))
#define THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME, ThemeClass))
#define IS_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME))
#define IS_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME))
#define THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME, ThemeClass))

typedef struct _Theme Theme;
typedef struct _ThemeClass ThemeClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _TileImage {
	GObject parent_instance;
	TileImagePrivate * priv;
	Tile* tile;
	gdouble x;
	gdouble y;
	gdouble source_x;
	gdouble source_y;
	gdouble source_time;
	gdouble target_x;
	gdouble target_y;
	gdouble duration;
};

struct _TileImageClass {
	GObjectClass parent_class;
};

struct _PuzzleView {
	GtkDrawingArea parent_instance;
	PuzzleViewPrivate * priv;
};

struct _PuzzleViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _PuzzleViewPrivate {
	Puzzle* _puzzle;
	Theme* theme;
	TileImage* selected_tile;
	guint selection_timeout;
	gdouble selected_x_offset;
	gdouble selected_y_offset;
	GHashTable* tiles;
	GTimer* animation_timer;
	guint animation_timeout;
};


static gpointer tile_image_parent_class = NULL;
static gpointer puzzle_view_parent_class = NULL;

GType tile_image_get_type (void) G_GNUC_CONST;
GType tile_get_type (void) G_GNUC_CONST;
enum  {
	TILE_IMAGE_DUMMY_PROPERTY
};
TileImage* tile_image_new (Tile* tile);
TileImage* tile_image_construct (GType object_type, Tile* tile);
static void tile_image_finalize (GObject* obj);
GType puzzle_view_get_type (void) G_GNUC_CONST;
GType puzzle_get_type (void) G_GNUC_CONST;
GType theme_get_type (void) G_GNUC_CONST;
#define PUZZLE_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PUZZLE_VIEW, PuzzleViewPrivate))
enum  {
	PUZZLE_VIEW_DUMMY_PROPERTY,
	PUZZLE_VIEW_PUZZLE,
	PUZZLE_VIEW_GAME_IN_PROGRESS
};
#define PUZZLE_VIEW_minimum_size 80
PuzzleView* puzzle_view_new (void);
PuzzleView* puzzle_view_construct (GType object_type);
static void _g_object_unref0_ (gpointer var);
Theme* theme_new (void);
Theme* theme_construct (GType object_type);
static void puzzle_view_redraw_tile (PuzzleView* self, TileImage* image);
static void puzzle_view_get_dimensions (PuzzleView* self, guint* x, guint* y, guint* size, guint* gap);
static void puzzle_view_move_tile_to_location (PuzzleView* self, TileImage* image, guint x, guint y, gdouble duration);
Puzzle* puzzle_view_get_puzzle (PuzzleView* self);
guint puzzle_get_size (Puzzle* self);
static void puzzle_view_move_tile (PuzzleView* self, TileImage* image, gdouble x, gdouble y, gdouble duration);
static gboolean puzzle_view_animate_cb (PuzzleView* self);
static gboolean _puzzle_view_animate_cb_gsource_func (gpointer self);
static void puzzle_view_real_get_preferred_width (GtkWidget* base, gint* minimum, gint* natural);
static void puzzle_view_real_get_preferred_height (GtkWidget* base, gint* minimum, gint* natural);
static void puzzle_view_tile_moved_cb (PuzzleView* self, Puzzle* puzzle, Tile* tile, guint x, guint y);
static gboolean puzzle_view_real_configure_event (GtkWidget* base, GdkEventConfigure* event);
void puzzle_get_tile_location (Puzzle* self, Tile* tile, guint* x, guint* y);
static gboolean puzzle_view_real_draw (GtkWidget* base, cairo_t* context);
void theme_draw_arrow (Theme* self, cairo_t* context, guint size, guint gap);
void theme_draw_socket (Theme* self, cairo_t* context, guint size);
gboolean puzzle_get_paused (Puzzle* self);
void theme_draw_paused_tile (Theme* self, cairo_t* context, guint size);
void theme_draw_tile (Theme* self, cairo_t* context, guint size, Tile* tile);
static void puzzle_view_pick_tile (PuzzleView* self, gdouble x, gdouble y);
gboolean puzzle_get_is_solved (Puzzle* self);
static gboolean puzzle_view_selection_timeout_cb (PuzzleView* self);
static gboolean _puzzle_view_selection_timeout_cb_gsource_func (gpointer self);
static gboolean puzzle_view_on_right_half (PuzzleView* self, gdouble x);
static void puzzle_view_drop_tile (PuzzleView* self, gdouble x, gdouble y);
gboolean puzzle_can_switch (Puzzle* self, guint x0, guint y0, guint x1, guint y1);
void puzzle_switch_tiles (Puzzle* self, guint x0, guint y0, guint x1, guint y1);
static void puzzle_view_move_tile_to_right_half (PuzzleView* self, TileImage* image);
Tile* puzzle_get_tile (Puzzle* self, guint x, guint y);
static gboolean puzzle_view_real_button_press_event (GtkWidget* base, GdkEventButton* event);
static gboolean puzzle_view_real_button_release_event (GtkWidget* base, GdkEventButton* event);
static gboolean puzzle_view_real_motion_notify_event (GtkWidget* base, GdkEventMotion* event);
void puzzle_view_set_puzzle (PuzzleView* self, Puzzle* value);
static void _puzzle_view_tile_moved_cb_puzzle_tile_moved (Puzzle* _sender, Tile* tile, guint x, guint y, gpointer self);
static void _puzzle_view_puzzle___lambda4_ (PuzzleView* self);
static void __puzzle_view_puzzle___lambda4__puzzle_paused_changed (Puzzle* _sender, gpointer self);
gboolean puzzle_view_get_game_in_progress (PuzzleView* self);
static void puzzle_view_finalize (GObject* obj);
static void _vala_puzzle_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_puzzle_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gpointer _g_object_ref0 (gpointer self) {
#line 37 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	return self ? g_object_ref (self) : NULL;
#line 195 "puzzle-view.c"
}


TileImage* tile_image_construct (GType object_type, Tile* tile) {
	TileImage * self = NULL;
	Tile* _tmp0_ = NULL;
	Tile* _tmp1_ = NULL;
#line 35 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	g_return_val_if_fail (tile != NULL, NULL);
#line 35 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	self = (TileImage*) g_object_new (object_type, NULL);
#line 37 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp0_ = tile;
#line 37 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 37 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_g_object_unref0 (self->tile);
#line 37 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	self->tile = _tmp1_;
#line 35 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	return self;
#line 217 "puzzle-view.c"
}


TileImage* tile_image_new (Tile* tile) {
#line 35 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	return tile_image_construct (TYPE_TILE_IMAGE, tile);
#line 224 "puzzle-view.c"
}


static void tile_image_class_init (TileImageClass * klass) {
#line 12 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	tile_image_parent_class = g_type_class_peek_parent (klass);
#line 12 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	G_OBJECT_CLASS (klass)->finalize = tile_image_finalize;
#line 233 "puzzle-view.c"
}


static void tile_image_instance_init (TileImage * self) {
}


static void tile_image_finalize (GObject* obj) {
	TileImage * self;
#line 12 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TILE_IMAGE, TileImage);
#line 15 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_g_object_unref0 (self->tile);
#line 12 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	G_OBJECT_CLASS (tile_image_parent_class)->finalize (obj);
#line 249 "puzzle-view.c"
}


GType tile_image_get_type (void) {
	static volatile gsize tile_image_type_id__volatile = 0;
	if (g_once_init_enter (&tile_image_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TileImageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tile_image_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TileImage), 0, (GInstanceInitFunc) tile_image_instance_init, NULL };
		GType tile_image_type_id;
		tile_image_type_id = g_type_register_static (G_TYPE_OBJECT, "TileImage", &g_define_type_info, 0);
		g_once_init_leave (&tile_image_type_id__volatile, tile_image_type_id);
	}
	return tile_image_type_id__volatile;
}


static void _g_object_unref0_ (gpointer var) {
#line 100 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 268 "puzzle-view.c"
}


PuzzleView* puzzle_view_construct (GType object_type) {
	PuzzleView * self = NULL;
	GHashFunc _tmp0_ = NULL;
	GEqualFunc _tmp1_ = NULL;
	GHashTable* _tmp2_ = NULL;
	Theme* _tmp3_ = NULL;
	GTimer* _tmp4_ = NULL;
	GTimer* _tmp5_ = NULL;
#line 96 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	self = (PuzzleView*) g_object_new (object_type, NULL);
#line 98 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	gtk_widget_set_events ((GtkWidget*) self, (gint) (((GDK_EXPOSURE_MASK | GDK_BUTTON_PRESS_MASK) | GDK_POINTER_MOTION_MASK) | GDK_BUTTON_RELEASE_MASK));
#line 100 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp0_ = g_direct_hash;
#line 100 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp1_ = g_direct_equal;
#line 100 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_object_unref0_, _g_object_unref0_);
#line 100 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_g_hash_table_unref0 (self->priv->tiles);
#line 100 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	self->priv->tiles = _tmp2_;
#line 102 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp3_ = theme_new ();
#line 102 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_g_object_unref0 (self->priv->theme);
#line 102 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	self->priv->theme = _tmp3_;
#line 104 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp4_ = g_timer_new ();
#line 104 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_g_timer_destroy0 (self->priv->animation_timer);
#line 104 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	self->priv->animation_timer = _tmp4_;
#line 105 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp5_ = self->priv->animation_timer;
#line 105 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	g_timer_start (_tmp5_);
#line 96 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	return self;
#line 312 "puzzle-view.c"
}


PuzzleView* puzzle_view_new (void) {
#line 96 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	return puzzle_view_construct (TYPE_PUZZLE_VIEW);
#line 319 "puzzle-view.c"
}


static void puzzle_view_redraw_tile (PuzzleView* self, TileImage* image) {
	guint x_offset = 0U;
	guint y_offset = 0U;
	guint size = 0U;
	guint gap = 0U;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	TileImage* _tmp4_ = NULL;
	gdouble _tmp5_ = 0.0;
	TileImage* _tmp6_ = NULL;
	gdouble _tmp7_ = 0.0;
#line 127 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	g_return_if_fail (self != NULL);
#line 127 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	g_return_if_fail (image != NULL);
#line 130 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	puzzle_view_get_dimensions (self, &_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
#line 130 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	x_offset = _tmp0_;
#line 130 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	y_offset = _tmp1_;
#line 130 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	size = _tmp2_;
#line 130 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	gap = _tmp3_;
#line 132 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp4_ = image;
#line 132 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp5_ = _tmp4_->x;
#line 132 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp6_ = image;
#line 132 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp7_ = _tmp6_->y;
#line 132 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	gtk_widget_queue_draw_area ((GtkWidget*) self, (gint) (_tmp5_ + 0.5), (gint) (_tmp7_ + 0.5), (gint) size, (gint) size);
#line 360 "puzzle-view.c"
}


static void puzzle_view_move_tile_to_location (PuzzleView* self, TileImage* image, guint x, guint y, gdouble duration) {
	guint x_offset = 0U;
	guint y_offset = 0U;
	guint size = 0U;
	guint gap = 0U;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	guint target_x = 0U;
	guint _tmp4_ = 0U;
	guint _tmp5_ = 0U;
	guint _tmp6_ = 0U;
	guint _tmp7_ = 0U;
	Puzzle* _tmp8_ = NULL;
	Puzzle* _tmp9_ = NULL;
	guint _tmp10_ = 0U;
	guint _tmp11_ = 0U;
	guint target_y = 0U;
	guint _tmp14_ = 0U;
	guint _tmp15_ = 0U;
	guint _tmp16_ = 0U;
	TileImage* _tmp17_ = NULL;
	guint _tmp18_ = 0U;
	gdouble _tmp19_ = 0.0;
#line 135 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	g_return_if_fail (self != NULL);
#line 135 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	g_return_if_fail (image != NULL);
#line 138 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	puzzle_view_get_dimensions (self, &_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
#line 138 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	x_offset = _tmp0_;
#line 138 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	y_offset = _tmp1_;
#line 138 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	size = _tmp2_;
#line 138 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	gap = _tmp3_;
#line 140 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp4_ = x_offset;
#line 140 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp5_ = x;
#line 140 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp6_ = size;
#line 140 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	target_x = _tmp4_ + (_tmp5_ * _tmp6_);
#line 141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp7_ = x;
#line 141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp8_ = puzzle_view_get_puzzle (self);
#line 141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp9_ = _tmp8_;
#line 141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp10_ = puzzle_get_size (_tmp9_);
#line 141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp11_ = _tmp10_;
#line 141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	if (_tmp7_ >= _tmp11_) {
#line 423 "puzzle-view.c"
		guint _tmp12_ = 0U;
		guint _tmp13_ = 0U;
#line 142 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp12_ = target_x;
#line 142 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp13_ = gap;
#line 142 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		target_x = _tmp12_ + _tmp13_;
#line 432 "puzzle-view.c"
	}
#line 143 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp14_ = y_offset;
#line 143 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp15_ = y;
#line 143 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp16_ = size;
#line 143 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	target_y = _tmp14_ + (_tmp15_ * _tmp16_);
#line 144 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp17_ = image;
#line 144 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp18_ = target_x;
#line 144 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp19_ = duration;
#line 144 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	puzzle_view_move_tile (self, _tmp17_, (gdouble) _tmp18_, (gdouble) target_y, _tmp19_);
#line 450 "puzzle-view.c"
}


static gboolean _puzzle_view_animate_cb_gsource_func (gpointer self) {
	gboolean result;
	result = puzzle_view_animate_cb ((PuzzleView*) self);
#line 171 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	return result;
#line 459 "puzzle-view.c"
}


static void puzzle_view_move_tile (PuzzleView* self, TileImage* image, gdouble x, gdouble y, gdouble duration) {
	gboolean _tmp0_ = FALSE;
	TileImage* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	TileImage* _tmp7_ = NULL;
	TileImage* _tmp8_ = NULL;
	gdouble _tmp9_ = 0.0;
	TileImage* _tmp10_ = NULL;
	TileImage* _tmp11_ = NULL;
	gdouble _tmp12_ = 0.0;
	TileImage* _tmp13_ = NULL;
	GTimer* _tmp14_ = NULL;
	gdouble _tmp15_ = 0.0;
	TileImage* _tmp16_ = NULL;
	gdouble _tmp17_ = 0.0;
	TileImage* _tmp18_ = NULL;
	gdouble _tmp19_ = 0.0;
	TileImage* _tmp20_ = NULL;
	gdouble _tmp21_ = 0.0;
	gdouble _tmp22_ = 0.0;
	guint _tmp31_ = 0U;
#line 147 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	g_return_if_fail (self != NULL);
#line 147 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	g_return_if_fail (image != NULL);
#line 149 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp1_ = image;
#line 149 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp2_ = _tmp1_->x;
#line 149 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp3_ = x;
#line 149 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	if (_tmp2_ == _tmp3_) {
#line 497 "puzzle-view.c"
		TileImage* _tmp4_ = NULL;
		gdouble _tmp5_ = 0.0;
		gdouble _tmp6_ = 0.0;
#line 149 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp4_ = image;
#line 149 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp5_ = _tmp4_->y;
#line 149 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp6_ = y;
#line 149 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp0_ = _tmp5_ == _tmp6_;
#line 509 "puzzle-view.c"
	} else {
#line 149 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp0_ = FALSE;
#line 513 "puzzle-view.c"
	}
#line 149 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	if (_tmp0_) {
#line 150 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		return;
#line 519 "puzzle-view.c"
	}
#line 152 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp7_ = image;
#line 152 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp8_ = image;
#line 152 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp9_ = _tmp8_->x;
#line 152 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp7_->source_x = _tmp9_;
#line 153 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp10_ = image;
#line 153 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp11_ = image;
#line 153 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp12_ = _tmp11_->y;
#line 153 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp10_->source_y = _tmp12_;
#line 154 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp13_ = image;
#line 154 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp14_ = self->priv->animation_timer;
#line 154 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp15_ = g_timer_elapsed (_tmp14_, NULL);
#line 154 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp13_->source_time = _tmp15_;
#line 155 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp16_ = image;
#line 155 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp17_ = x;
#line 155 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp16_->target_x = _tmp17_;
#line 156 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp18_ = image;
#line 156 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp19_ = y;
#line 156 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp18_->target_y = _tmp19_;
#line 157 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp20_ = image;
#line 157 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp21_ = duration;
#line 157 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp20_->duration = _tmp21_;
#line 160 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp22_ = duration;
#line 160 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	if (_tmp22_ == ((gdouble) 0)) {
#line 567 "puzzle-view.c"
		TileImage* _tmp23_ = NULL;
		TileImage* _tmp24_ = NULL;
		TileImage* _tmp25_ = NULL;
		gdouble _tmp26_ = 0.0;
		TileImage* _tmp27_ = NULL;
		TileImage* _tmp28_ = NULL;
		gdouble _tmp29_ = 0.0;
		TileImage* _tmp30_ = NULL;
#line 162 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp23_ = image;
#line 162 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		puzzle_view_redraw_tile (self, _tmp23_);
#line 163 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp24_ = image;
#line 163 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp25_ = image;
#line 163 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp26_ = _tmp25_->target_x;
#line 163 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp24_->x = _tmp26_;
#line 164 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp27_ = image;
#line 164 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp28_ = image;
#line 164 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp29_ = _tmp28_->target_y;
#line 164 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp27_->y = _tmp29_;
#line 165 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp30_ = image;
#line 165 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		puzzle_view_redraw_tile (self, _tmp30_);
#line 166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		return;
#line 602 "puzzle-view.c"
	}
#line 170 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp31_ = self->priv->animation_timeout;
#line 170 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	if (_tmp31_ == ((guint) 0)) {
#line 608 "puzzle-view.c"
		guint _tmp32_ = 0U;
#line 171 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp32_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 10, _puzzle_view_animate_cb_gsource_func, g_object_ref (self), g_object_unref);
#line 171 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		self->priv->animation_timeout = _tmp32_;
#line 614 "puzzle-view.c"
	}
}


static gboolean puzzle_view_animate_cb (PuzzleView* self) {
	gboolean result = FALSE;
	gdouble t = 0.0;
	GTimer* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	guint x_offset = 0U;
	guint y_offset = 0U;
	guint size = 0U;
	guint gap = 0U;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	guint _tmp5_ = 0U;
	gboolean animating = FALSE;
	GHashTableIter iter = {0};
	GHashTable* _tmp6_ = NULL;
	gboolean _tmp55_ = FALSE;
#line 174 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 176 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp0_ = self->priv->animation_timer;
#line 176 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp1_ = g_timer_elapsed (_tmp0_, NULL);
#line 176 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	t = _tmp1_;
#line 179 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	puzzle_view_get_dimensions (self, &_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_);
#line 179 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	x_offset = _tmp2_;
#line 179 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	y_offset = _tmp3_;
#line 179 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	size = _tmp4_;
#line 179 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	gap = _tmp5_;
#line 181 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	animating = FALSE;
#line 182 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp6_ = self->priv->tiles;
#line 182 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	g_hash_table_iter_init (&iter, _tmp6_);
#line 183 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	while (TRUE) {
#line 662 "puzzle-view.c"
		Tile* tile = NULL;
		TileImage* image = NULL;
		gconstpointer _tmp7_ = NULL;
		gconstpointer _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		Tile* _tmp10_ = NULL;
		TileImage* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		TileImage* _tmp13_ = NULL;
		gdouble _tmp14_ = 0.0;
		TileImage* _tmp15_ = NULL;
		gdouble _tmp16_ = 0.0;
		TileImage* _tmp21_ = NULL;
		gdouble _tmp22_ = 0.0;
		TileImage* _tmp23_ = NULL;
		gdouble _tmp24_ = 0.0;
		TileImage* _tmp25_ = NULL;
		gdouble _tmp26_ = 0.0;
		TileImage* _tmp54_ = NULL;
#line 187 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp9_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp7_), (gpointer*) (&_tmp8_));
#line 187 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_g_object_unref0 (tile);
#line 187 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp10_ = _g_object_ref0 (_tmp7_);
#line 187 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		tile = _tmp10_;
#line 187 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_g_object_unref0 (image);
#line 187 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp11_ = _g_object_ref0 (_tmp8_);
#line 187 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		image = _tmp11_;
#line 187 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		if (!_tmp9_) {
#line 188 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_g_object_unref0 (image);
#line 188 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_g_object_unref0 (tile);
#line 188 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			break;
#line 704 "puzzle-view.c"
		}
#line 190 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp13_ = image;
#line 190 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp14_ = _tmp13_->x;
#line 190 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp15_ = image;
#line 190 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp16_ = _tmp15_->target_x;
#line 190 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		if (_tmp14_ == _tmp16_) {
#line 716 "puzzle-view.c"
			TileImage* _tmp17_ = NULL;
			gdouble _tmp18_ = 0.0;
			TileImage* _tmp19_ = NULL;
			gdouble _tmp20_ = 0.0;
#line 190 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp17_ = image;
#line 190 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp18_ = _tmp17_->y;
#line 190 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp19_ = image;
#line 190 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp20_ = _tmp19_->target_y;
#line 190 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp12_ = _tmp18_ == _tmp20_;
#line 731 "puzzle-view.c"
		} else {
#line 190 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp12_ = FALSE;
#line 735 "puzzle-view.c"
		}
#line 190 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		if (_tmp12_) {
#line 191 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_g_object_unref0 (image);
#line 191 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_g_object_unref0 (tile);
#line 191 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			continue;
#line 745 "puzzle-view.c"
		}
#line 194 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp21_ = image;
#line 194 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		puzzle_view_redraw_tile (self, _tmp21_);
#line 197 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp22_ = t;
#line 197 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp23_ = image;
#line 197 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp24_ = _tmp23_->source_time;
#line 197 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp25_ = image;
#line 197 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp26_ = _tmp25_->duration;
#line 197 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		if (_tmp22_ >= (_tmp24_ + _tmp26_)) {
#line 763 "puzzle-view.c"
			TileImage* _tmp27_ = NULL;
			TileImage* _tmp28_ = NULL;
			gdouble _tmp29_ = 0.0;
			TileImage* _tmp30_ = NULL;
			TileImage* _tmp31_ = NULL;
			gdouble _tmp32_ = 0.0;
#line 199 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp27_ = image;
#line 199 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp28_ = image;
#line 199 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp29_ = _tmp28_->target_x;
#line 199 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp27_->x = _tmp29_;
#line 200 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp30_ = image;
#line 200 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp31_ = image;
#line 200 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp32_ = _tmp31_->target_y;
#line 200 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp30_->y = _tmp32_;
#line 786 "puzzle-view.c"
		} else {
			gdouble d = 0.0;
			gdouble _tmp33_ = 0.0;
			TileImage* _tmp34_ = NULL;
			gdouble _tmp35_ = 0.0;
			TileImage* _tmp36_ = NULL;
			gdouble _tmp37_ = 0.0;
			TileImage* _tmp38_ = NULL;
			TileImage* _tmp39_ = NULL;
			gdouble _tmp40_ = 0.0;
			TileImage* _tmp41_ = NULL;
			gdouble _tmp42_ = 0.0;
			TileImage* _tmp43_ = NULL;
			gdouble _tmp44_ = 0.0;
			gdouble _tmp45_ = 0.0;
			TileImage* _tmp46_ = NULL;
			TileImage* _tmp47_ = NULL;
			gdouble _tmp48_ = 0.0;
			TileImage* _tmp49_ = NULL;
			gdouble _tmp50_ = 0.0;
			TileImage* _tmp51_ = NULL;
			gdouble _tmp52_ = 0.0;
			gdouble _tmp53_ = 0.0;
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp33_ = t;
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp34_ = image;
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp35_ = _tmp34_->source_time;
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp36_ = image;
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp37_ = _tmp36_->duration;
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			d = (_tmp33_ - _tmp35_) / _tmp37_;
#line 205 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp38_ = image;
#line 205 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp39_ = image;
#line 205 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp40_ = _tmp39_->source_x;
#line 205 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp41_ = image;
#line 205 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp42_ = _tmp41_->target_x;
#line 205 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp43_ = image;
#line 205 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp44_ = _tmp43_->source_x;
#line 205 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp45_ = d;
#line 205 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp38_->x = _tmp40_ + ((_tmp42_ - _tmp44_) * _tmp45_);
#line 206 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp46_ = image;
#line 206 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp47_ = image;
#line 206 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp48_ = _tmp47_->source_y;
#line 206 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp49_ = image;
#line 206 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp50_ = _tmp49_->target_y;
#line 206 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp51_ = image;
#line 206 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp52_ = _tmp51_->source_y;
#line 206 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp53_ = d;
#line 206 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp46_->y = _tmp48_ + ((_tmp50_ - _tmp52_) * _tmp53_);
#line 207 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			animating = TRUE;
#line 860 "puzzle-view.c"
		}
#line 211 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp54_ = image;
#line 211 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		puzzle_view_redraw_tile (self, _tmp54_);
#line 183 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_g_object_unref0 (image);
#line 183 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_g_object_unref0 (tile);
#line 870 "puzzle-view.c"
	}
#line 215 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp55_ = animating;
#line 215 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	if (_tmp55_) {
#line 216 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		result = TRUE;
#line 216 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		return result;
#line 880 "puzzle-view.c"
	}
#line 218 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	self->priv->animation_timeout = (guint) 0;
#line 219 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	result = FALSE;
#line 219 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	return result;
#line 888 "puzzle-view.c"
}


static void puzzle_view_real_get_preferred_width (GtkWidget* base, gint* minimum, gint* natural) {
	PuzzleView * self;
	gint _vala_minimum = 0;
	gint _vala_natural = 0;
	gint size = 0;
	Puzzle* _tmp0_ = NULL;
	Puzzle* _tmp1_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
#line 222 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	self = (PuzzleView*) base;
#line 224 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	size = 0;
#line 225 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp0_ = puzzle_view_get_puzzle (self);
#line 225 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp1_ = _tmp0_;
#line 225 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	if (_tmp1_ != NULL) {
#line 911 "puzzle-view.c"
		Puzzle* _tmp2_ = NULL;
		Puzzle* _tmp3_ = NULL;
		guint _tmp4_ = 0U;
		guint _tmp5_ = 0U;
#line 226 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp2_ = puzzle_view_get_puzzle (self);
#line 226 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp3_ = _tmp2_;
#line 226 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp4_ = puzzle_get_size (_tmp3_);
#line 226 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp5_ = _tmp4_;
#line 226 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		size = (gint) (((_tmp5_ * 2) + 1.5) * PUZZLE_VIEW_minimum_size);
#line 926 "puzzle-view.c"
	}
#line 227 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp6_ = size;
#line 227 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp7_ = MAX (_tmp6_, 500);
#line 227 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_vala_natural = _tmp7_;
#line 227 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_vala_minimum = _vala_natural;
#line 222 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	if (minimum) {
#line 222 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		*minimum = _vala_minimum;
#line 940 "puzzle-view.c"
	}
#line 222 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	if (natural) {
#line 222 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		*natural = _vala_natural;
#line 946 "puzzle-view.c"
	}
}


static void puzzle_view_real_get_preferred_height (GtkWidget* base, gint* minimum, gint* natural) {
	PuzzleView * self;
	gint _vala_minimum = 0;
	gint _vala_natural = 0;
	gint size = 0;
	Puzzle* _tmp0_ = NULL;
	Puzzle* _tmp1_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
#line 230 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	self = (PuzzleView*) base;
#line 232 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	size = 0;
#line 233 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp0_ = puzzle_view_get_puzzle (self);
#line 233 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp1_ = _tmp0_;
#line 233 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	if (_tmp1_ != NULL) {
#line 970 "puzzle-view.c"
		Puzzle* _tmp2_ = NULL;
		Puzzle* _tmp3_ = NULL;
		guint _tmp4_ = 0U;
		guint _tmp5_ = 0U;
#line 234 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp2_ = puzzle_view_get_puzzle (self);
#line 234 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp3_ = _tmp2_;
#line 234 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp4_ = puzzle_get_size (_tmp3_);
#line 234 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp5_ = _tmp4_;
#line 234 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		size = (gint) ((_tmp5_ + 1) * PUZZLE_VIEW_minimum_size);
#line 985 "puzzle-view.c"
	}
#line 235 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp6_ = size;
#line 235 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp7_ = MAX (_tmp6_, 300);
#line 235 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_vala_natural = _tmp7_;
#line 235 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_vala_minimum = _vala_natural;
#line 230 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	if (minimum) {
#line 230 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		*minimum = _vala_minimum;
#line 999 "puzzle-view.c"
	}
#line 230 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	if (natural) {
#line 230 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		*natural = _vala_natural;
#line 1005 "puzzle-view.c"
	}
}


static void puzzle_view_get_dimensions (PuzzleView* self, guint* x, guint* y, guint* size, guint* gap) {
	guint _vala_x = 0U;
	guint _vala_y = 0U;
	guint _vala_size = 0U;
	guint _vala_gap = 0U;
	guint width = 0U;
	gint _tmp0_ = 0;
	Puzzle* _tmp1_ = NULL;
	Puzzle* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	guint height = 0U;
	gint _tmp5_ = 0;
	Puzzle* _tmp6_ = NULL;
	Puzzle* _tmp7_ = NULL;
	guint _tmp8_ = 0U;
	guint _tmp9_ = 0U;
	guint _tmp10_ = 0U;
	gint _tmp11_ = 0;
	Puzzle* _tmp12_ = NULL;
	Puzzle* _tmp13_ = NULL;
	guint _tmp14_ = 0U;
	guint _tmp15_ = 0U;
	gint _tmp16_ = 0;
	Puzzle* _tmp17_ = NULL;
	Puzzle* _tmp18_ = NULL;
	guint _tmp19_ = 0U;
	guint _tmp20_ = 0U;
#line 238 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	g_return_if_fail (self != NULL);
#line 241 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 241 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp1_ = puzzle_view_get_puzzle (self);
#line 241 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp2_ = _tmp1_;
#line 241 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp3_ = puzzle_get_size (_tmp2_);
#line 241 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp4_ = _tmp3_;
#line 241 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	width = (guint) (_tmp0_ / ((2 * _tmp4_) + 1.5));
#line 242 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp5_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 242 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp6_ = puzzle_view_get_puzzle (self);
#line 242 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp7_ = _tmp6_;
#line 242 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp8_ = puzzle_get_size (_tmp7_);
#line 242 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp9_ = _tmp8_;
#line 242 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	height = (guint) (_tmp5_ / (_tmp9_ + 1));
#line 243 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp10_ = MIN (width, height);
#line 243 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_vala_size = _tmp10_;
#line 244 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_vala_gap = _vala_size / 2;
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp11_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp12_ = puzzle_view_get_puzzle (self);
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp13_ = _tmp12_;
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp14_ = puzzle_get_size (_tmp13_);
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp15_ = _tmp14_;
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_vala_x = ((_tmp11_ - ((2 * _tmp15_) * _vala_size)) - _vala_gap) / 2;
#line 246 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp16_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 246 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp17_ = puzzle_view_get_puzzle (self);
#line 246 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp18_ = _tmp17_;
#line 246 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp19_ = puzzle_get_size (_tmp18_);
#line 246 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp20_ = _tmp19_;
#line 246 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_vala_y = (_tmp16_ - (_tmp20_ * _vala_size)) / 2;
#line 238 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	if (x) {
#line 238 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		*x = _vala_x;
#line 1098 "puzzle-view.c"
	}
#line 238 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	if (y) {
#line 238 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		*y = _vala_y;
#line 1104 "puzzle-view.c"
	}
#line 238 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	if (size) {
#line 238 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		*size = _vala_size;
#line 1110 "puzzle-view.c"
	}
#line 238 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	if (gap) {
#line 238 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		*gap = _vala_gap;
#line 1116 "puzzle-view.c"
	}
}


static void puzzle_view_tile_moved_cb (PuzzleView* self, Puzzle* puzzle, Tile* tile, guint x, guint y) {
	GHashTable* _tmp0_ = NULL;
	Tile* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
#line 249 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	g_return_if_fail (self != NULL);
#line 249 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	g_return_if_fail (puzzle != NULL);
#line 249 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	g_return_if_fail (tile != NULL);
#line 251 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp0_ = self->priv->tiles;
#line 251 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp1_ = tile;
#line 251 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp2_ = g_hash_table_lookup (_tmp0_, _tmp1_);
#line 251 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp3_ = x;
#line 251 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp4_ = y;
#line 251 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	puzzle_view_move_tile_to_location (self, (TileImage*) _tmp2_, _tmp3_, _tmp4_, 0.2);
#line 1145 "puzzle-view.c"
}


static gboolean puzzle_view_real_configure_event (GtkWidget* base, GdkEventConfigure* event) {
	PuzzleView * self;
	gboolean result = FALSE;
	GHashTableIter iter = {0};
	GHashTable* _tmp0_ = NULL;
#line 254 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	self = (PuzzleView*) base;
#line 254 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 257 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp0_ = self->priv->tiles;
#line 257 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	g_hash_table_iter_init (&iter, _tmp0_);
#line 258 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	while (TRUE) {
#line 1164 "puzzle-view.c"
		Tile* tile = NULL;
		TileImage* image = NULL;
		gconstpointer _tmp1_ = NULL;
		gconstpointer _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		Tile* _tmp4_ = NULL;
		TileImage* _tmp5_ = NULL;
		guint x = 0U;
		guint y = 0U;
		Puzzle* _tmp6_ = NULL;
		Puzzle* _tmp7_ = NULL;
		Tile* _tmp8_ = NULL;
		guint _tmp9_ = 0U;
		guint _tmp10_ = 0U;
		TileImage* _tmp11_ = NULL;
		guint _tmp12_ = 0U;
		guint _tmp13_ = 0U;
#line 262 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp3_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp1_), (gpointer*) (&_tmp2_));
#line 262 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_g_object_unref0 (tile);
#line 262 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp4_ = _g_object_ref0 (_tmp1_);
#line 262 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		tile = _tmp4_;
#line 262 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_g_object_unref0 (image);
#line 262 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp5_ = _g_object_ref0 (_tmp2_);
#line 262 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		image = _tmp5_;
#line 262 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		if (!_tmp3_) {
#line 263 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_g_object_unref0 (image);
#line 263 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_g_object_unref0 (tile);
#line 263 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			break;
#line 1204 "puzzle-view.c"
		}
#line 265 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp6_ = puzzle_view_get_puzzle (self);
#line 265 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp7_ = _tmp6_;
#line 265 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp8_ = tile;
#line 265 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		puzzle_get_tile_location (_tmp7_, _tmp8_, &_tmp9_, &_tmp10_);
#line 265 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		x = _tmp9_;
#line 265 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		y = _tmp10_;
#line 266 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp11_ = image;
#line 266 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp12_ = x;
#line 266 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp13_ = y;
#line 266 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		puzzle_view_move_tile_to_location (self, _tmp11_, _tmp12_, _tmp13_, (gdouble) 0);
#line 258 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_g_object_unref0 (image);
#line 258 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_g_object_unref0 (tile);
#line 1230 "puzzle-view.c"
	}
#line 268 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_g_object_unref0 (self->priv->selected_tile);
#line 268 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	self->priv->selected_tile = NULL;
#line 270 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	result = FALSE;
#line 270 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	return result;
#line 1240 "puzzle-view.c"
}


static gboolean puzzle_view_real_draw (GtkWidget* base, cairo_t* context) {
	PuzzleView * self;
	gboolean result = FALSE;
	Puzzle* _tmp0_ = NULL;
	Puzzle* _tmp1_ = NULL;
	guint x_offset = 0U;
	guint y_offset = 0U;
	guint size = 0U;
	guint gap = 0U;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	guint _tmp5_ = 0U;
	cairo_t* _tmp6_ = NULL;
	gdouble w = 0.0;
	guint _tmp7_ = 0U;
	gdouble ax = 0.0;
	guint _tmp8_ = 0U;
	Puzzle* _tmp9_ = NULL;
	Puzzle* _tmp10_ = NULL;
	guint _tmp11_ = 0U;
	guint _tmp12_ = 0U;
	guint _tmp13_ = 0U;
	guint _tmp14_ = 0U;
	gdouble _tmp15_ = 0.0;
	gdouble ay = 0.0;
	guint _tmp16_ = 0U;
	Puzzle* _tmp17_ = NULL;
	Puzzle* _tmp18_ = NULL;
	guint _tmp19_ = 0U;
	guint _tmp20_ = 0U;
	guint _tmp21_ = 0U;
	cairo_t* _tmp22_ = NULL;
	gdouble _tmp23_ = 0.0;
	gdouble _tmp24_ = 0.0;
	Theme* _tmp25_ = NULL;
	cairo_t* _tmp26_ = NULL;
	guint _tmp27_ = 0U;
	guint _tmp28_ = 0U;
	cairo_t* _tmp29_ = NULL;
	GHashTableIter iter = {0};
	GHashTable* _tmp69_ = NULL;
	GHashTable* _tmp105_ = NULL;
	Puzzle* _tmp141_ = NULL;
	Puzzle* _tmp142_ = NULL;
	gboolean _tmp143_ = FALSE;
	gboolean _tmp144_ = FALSE;
#line 273 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	self = (PuzzleView*) base;
#line 273 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	g_return_val_if_fail (context != NULL, FALSE);
#line 275 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp0_ = puzzle_view_get_puzzle (self);
#line 275 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp1_ = _tmp0_;
#line 275 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	if (_tmp1_ == NULL) {
#line 276 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		result = FALSE;
#line 276 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		return result;
#line 1305 "puzzle-view.c"
	}
#line 279 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	puzzle_view_get_dimensions (self, &_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_);
#line 279 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	x_offset = _tmp2_;
#line 279 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	y_offset = _tmp3_;
#line 279 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	size = _tmp4_;
#line 279 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	gap = _tmp5_;
#line 282 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp6_ = context;
#line 282 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	cairo_save (_tmp6_);
#line 283 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp7_ = gap;
#line 283 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	w = _tmp7_ * 0.5;
#line 284 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp8_ = x_offset;
#line 284 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp9_ = puzzle_view_get_puzzle (self);
#line 284 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp10_ = _tmp9_;
#line 284 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp11_ = puzzle_get_size (_tmp10_);
#line 284 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp12_ = _tmp11_;
#line 284 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp13_ = size;
#line 284 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp14_ = gap;
#line 284 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp15_ = w;
#line 284 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	ax = (_tmp8_ + (_tmp12_ * _tmp13_)) + ((_tmp14_ - _tmp15_) * 0.5);
#line 285 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp16_ = y_offset;
#line 285 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp17_ = puzzle_view_get_puzzle (self);
#line 285 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp18_ = _tmp17_;
#line 285 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp19_ = puzzle_get_size (_tmp18_);
#line 285 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp20_ = _tmp19_;
#line 285 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp21_ = size;
#line 285 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	ay = _tmp16_ + ((_tmp20_ * _tmp21_) * 0.5);
#line 286 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp22_ = context;
#line 286 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp23_ = ax;
#line 286 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp24_ = ay;
#line 286 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	cairo_translate (_tmp22_, _tmp23_, _tmp24_);
#line 287 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp25_ = self->priv->theme;
#line 287 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp26_ = context;
#line 287 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp27_ = size;
#line 287 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp28_ = gap;
#line 287 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	theme_draw_arrow (_tmp25_, _tmp26_, _tmp27_, _tmp28_);
#line 288 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp29_ = context;
#line 288 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	cairo_restore (_tmp29_);
#line 1379 "puzzle-view.c"
	{
		gint y = 0;
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		y = 0;
#line 1384 "puzzle-view.c"
		{
			gboolean _tmp30_ = FALSE;
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp30_ = TRUE;
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			while (TRUE) {
#line 1391 "puzzle-view.c"
				gint _tmp32_ = 0;
				Puzzle* _tmp33_ = NULL;
				Puzzle* _tmp34_ = NULL;
				guint _tmp35_ = 0U;
				guint _tmp36_ = 0U;
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
				if (!_tmp30_) {
#line 1399 "puzzle-view.c"
					gint _tmp31_ = 0;
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
					_tmp31_ = y;
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
					y = _tmp31_ + 1;
#line 1405 "puzzle-view.c"
				}
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
				_tmp30_ = FALSE;
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
				_tmp32_ = y;
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
				_tmp33_ = puzzle_view_get_puzzle (self);
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
				_tmp34_ = _tmp33_;
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
				_tmp35_ = puzzle_get_size (_tmp34_);
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
				_tmp36_ = _tmp35_;
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
				if (!(((guint) _tmp32_) < _tmp36_)) {
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
					break;
#line 1423 "puzzle-view.c"
				}
				{
					gint x = 0;
#line 293 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
					x = 0;
#line 1429 "puzzle-view.c"
					{
						gboolean _tmp37_ = FALSE;
#line 293 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
						_tmp37_ = TRUE;
#line 293 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
						while (TRUE) {
#line 1436 "puzzle-view.c"
							gint _tmp39_ = 0;
							Puzzle* _tmp40_ = NULL;
							Puzzle* _tmp41_ = NULL;
							guint _tmp42_ = 0U;
							guint _tmp43_ = 0U;
							cairo_t* _tmp44_ = NULL;
							gint _tmp45_ = 0;
							Puzzle* _tmp46_ = NULL;
							Puzzle* _tmp47_ = NULL;
							guint _tmp48_ = 0U;
							guint _tmp49_ = 0U;
							Theme* _tmp65_ = NULL;
							cairo_t* _tmp66_ = NULL;
							guint _tmp67_ = 0U;
							cairo_t* _tmp68_ = NULL;
#line 293 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							if (!_tmp37_) {
#line 1454 "puzzle-view.c"
								gint _tmp38_ = 0;
#line 293 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
								_tmp38_ = x;
#line 293 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
								x = _tmp38_ + 1;
#line 1460 "puzzle-view.c"
							}
#line 293 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp37_ = FALSE;
#line 293 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp39_ = x;
#line 293 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp40_ = puzzle_view_get_puzzle (self);
#line 293 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp41_ = _tmp40_;
#line 293 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp42_ = puzzle_get_size (_tmp41_);
#line 293 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp43_ = _tmp42_;
#line 293 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							if (!(((guint) _tmp39_) < (_tmp43_ * 2))) {
#line 293 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
								break;
#line 1478 "puzzle-view.c"
							}
#line 295 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp44_ = context;
#line 295 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							cairo_save (_tmp44_);
#line 296 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp45_ = x;
#line 296 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp46_ = puzzle_view_get_puzzle (self);
#line 296 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp47_ = _tmp46_;
#line 296 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp48_ = puzzle_get_size (_tmp47_);
#line 296 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp49_ = _tmp48_;
#line 296 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							if (((guint) _tmp45_) >= _tmp49_) {
#line 1496 "puzzle-view.c"
								cairo_t* _tmp50_ = NULL;
								guint _tmp51_ = 0U;
								guint _tmp52_ = 0U;
								gint _tmp53_ = 0;
								guint _tmp54_ = 0U;
								guint _tmp55_ = 0U;
								gint _tmp56_ = 0;
								guint _tmp57_ = 0U;
#line 297 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
								_tmp50_ = context;
#line 297 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
								_tmp51_ = x_offset;
#line 297 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
								_tmp52_ = gap;
#line 297 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
								_tmp53_ = x;
#line 297 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
								_tmp54_ = size;
#line 297 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
								_tmp55_ = y_offset;
#line 297 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
								_tmp56_ = y;
#line 297 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
								_tmp57_ = size;
#line 297 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
								cairo_translate (_tmp50_, (gdouble) ((_tmp51_ + _tmp52_) + (_tmp53_ * _tmp54_)), (gdouble) (_tmp55_ + (_tmp56_ * _tmp57_)));
#line 1523 "puzzle-view.c"
							} else {
								cairo_t* _tmp58_ = NULL;
								guint _tmp59_ = 0U;
								gint _tmp60_ = 0;
								guint _tmp61_ = 0U;
								guint _tmp62_ = 0U;
								gint _tmp63_ = 0;
								guint _tmp64_ = 0U;
#line 299 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
								_tmp58_ = context;
#line 299 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
								_tmp59_ = x_offset;
#line 299 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
								_tmp60_ = x;
#line 299 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
								_tmp61_ = size;
#line 299 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
								_tmp62_ = y_offset;
#line 299 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
								_tmp63_ = y;
#line 299 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
								_tmp64_ = size;
#line 299 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
								cairo_translate (_tmp58_, (gdouble) (_tmp59_ + (_tmp60_ * _tmp61_)), (gdouble) (_tmp62_ + (_tmp63_ * _tmp64_)));
#line 1548 "puzzle-view.c"
							}
#line 300 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp65_ = self->priv->theme;
#line 300 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp66_ = context;
#line 300 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp67_ = size;
#line 300 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							theme_draw_socket (_tmp65_, _tmp66_, _tmp67_);
#line 301 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp68_ = context;
#line 301 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							cairo_restore (_tmp68_);
#line 1562 "puzzle-view.c"
						}
					}
				}
			}
		}
	}
#line 306 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp69_ = self->priv->tiles;
#line 306 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	g_hash_table_iter_init (&iter, _tmp69_);
#line 307 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	while (TRUE) {
#line 1575 "puzzle-view.c"
		Tile* tile = NULL;
		TileImage* image = NULL;
		gconstpointer _tmp70_ = NULL;
		gconstpointer _tmp71_ = NULL;
		gboolean _tmp72_ = FALSE;
		Tile* _tmp73_ = NULL;
		TileImage* _tmp74_ = NULL;
		gboolean _tmp75_ = FALSE;
		gboolean _tmp76_ = FALSE;
		TileImage* _tmp77_ = NULL;
		TileImage* _tmp78_ = NULL;
		cairo_t* _tmp87_ = NULL;
		cairo_t* _tmp88_ = NULL;
		TileImage* _tmp89_ = NULL;
		gdouble _tmp90_ = 0.0;
		TileImage* _tmp91_ = NULL;
		gdouble _tmp92_ = 0.0;
		Puzzle* _tmp93_ = NULL;
		Puzzle* _tmp94_ = NULL;
		gboolean _tmp95_ = FALSE;
		gboolean _tmp96_ = FALSE;
		cairo_t* _tmp104_ = NULL;
#line 311 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp72_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp70_), (gpointer*) (&_tmp71_));
#line 311 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_g_object_unref0 (tile);
#line 311 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp73_ = _g_object_ref0 (_tmp70_);
#line 311 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		tile = _tmp73_;
#line 311 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_g_object_unref0 (image);
#line 311 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp74_ = _g_object_ref0 (_tmp71_);
#line 311 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		image = _tmp74_;
#line 311 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		if (!_tmp72_) {
#line 312 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_g_object_unref0 (image);
#line 312 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_g_object_unref0 (tile);
#line 312 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			break;
#line 1620 "puzzle-view.c"
		}
#line 314 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp77_ = image;
#line 314 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp78_ = self->priv->selected_tile;
#line 314 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		if (_tmp77_ == _tmp78_) {
#line 314 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp76_ = TRUE;
#line 1630 "puzzle-view.c"
		} else {
			TileImage* _tmp79_ = NULL;
			gdouble _tmp80_ = 0.0;
			TileImage* _tmp81_ = NULL;
			gdouble _tmp82_ = 0.0;
#line 314 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp79_ = image;
#line 314 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp80_ = _tmp79_->x;
#line 314 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp81_ = image;
#line 314 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp82_ = _tmp81_->target_x;
#line 314 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp76_ = _tmp80_ != _tmp82_;
#line 1646 "puzzle-view.c"
		}
#line 314 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		if (_tmp76_) {
#line 314 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp75_ = TRUE;
#line 1652 "puzzle-view.c"
		} else {
			TileImage* _tmp83_ = NULL;
			gdouble _tmp84_ = 0.0;
			TileImage* _tmp85_ = NULL;
			gdouble _tmp86_ = 0.0;
#line 314 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp83_ = image;
#line 314 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp84_ = _tmp83_->y;
#line 314 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp85_ = image;
#line 314 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp86_ = _tmp85_->target_y;
#line 314 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp75_ = _tmp84_ != _tmp86_;
#line 1668 "puzzle-view.c"
		}
#line 314 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		if (_tmp75_) {
#line 315 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_g_object_unref0 (image);
#line 315 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_g_object_unref0 (tile);
#line 315 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			continue;
#line 1678 "puzzle-view.c"
		}
#line 317 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp87_ = context;
#line 317 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		cairo_save (_tmp87_);
#line 318 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp88_ = context;
#line 318 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp89_ = image;
#line 318 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp90_ = _tmp89_->x;
#line 318 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp91_ = image;
#line 318 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp92_ = _tmp91_->y;
#line 318 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		cairo_translate (_tmp88_, (gdouble) ((gint) (_tmp90_ + 0.5)), (gdouble) ((gint) (_tmp92_ + 0.5)));
#line 319 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp93_ = puzzle_view_get_puzzle (self);
#line 319 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp94_ = _tmp93_;
#line 319 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp95_ = puzzle_get_paused (_tmp94_);
#line 319 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp96_ = _tmp95_;
#line 319 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		if (_tmp96_) {
#line 1706 "puzzle-view.c"
			Theme* _tmp97_ = NULL;
			cairo_t* _tmp98_ = NULL;
			guint _tmp99_ = 0U;
#line 320 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp97_ = self->priv->theme;
#line 320 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp98_ = context;
#line 320 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp99_ = size;
#line 320 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			theme_draw_paused_tile (_tmp97_, _tmp98_, _tmp99_);
#line 1718 "puzzle-view.c"
		} else {
			Theme* _tmp100_ = NULL;
			cairo_t* _tmp101_ = NULL;
			guint _tmp102_ = 0U;
			Tile* _tmp103_ = NULL;
#line 322 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp100_ = self->priv->theme;
#line 322 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp101_ = context;
#line 322 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp102_ = size;
#line 322 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp103_ = tile;
#line 322 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			theme_draw_tile (_tmp100_, _tmp101_, _tmp102_, _tmp103_);
#line 1734 "puzzle-view.c"
		}
#line 323 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp104_ = context;
#line 323 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		cairo_restore (_tmp104_);
#line 307 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_g_object_unref0 (image);
#line 307 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_g_object_unref0 (tile);
#line 1744 "puzzle-view.c"
	}
#line 327 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp105_ = self->priv->tiles;
#line 327 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	g_hash_table_iter_init (&iter, _tmp105_);
#line 328 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	while (TRUE) {
#line 1752 "puzzle-view.c"
		Tile* tile = NULL;
		TileImage* image = NULL;
		gconstpointer _tmp106_ = NULL;
		gconstpointer _tmp107_ = NULL;
		gboolean _tmp108_ = FALSE;
		Tile* _tmp109_ = NULL;
		TileImage* _tmp110_ = NULL;
		gboolean _tmp111_ = FALSE;
		gboolean _tmp112_ = FALSE;
		TileImage* _tmp113_ = NULL;
		TileImage* _tmp114_ = NULL;
		cairo_t* _tmp123_ = NULL;
		cairo_t* _tmp124_ = NULL;
		TileImage* _tmp125_ = NULL;
		gdouble _tmp126_ = 0.0;
		TileImage* _tmp127_ = NULL;
		gdouble _tmp128_ = 0.0;
		Puzzle* _tmp129_ = NULL;
		Puzzle* _tmp130_ = NULL;
		gboolean _tmp131_ = FALSE;
		gboolean _tmp132_ = FALSE;
		cairo_t* _tmp140_ = NULL;
#line 332 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp108_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp106_), (gpointer*) (&_tmp107_));
#line 332 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_g_object_unref0 (tile);
#line 332 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp109_ = _g_object_ref0 (_tmp106_);
#line 332 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		tile = _tmp109_;
#line 332 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_g_object_unref0 (image);
#line 332 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp110_ = _g_object_ref0 (_tmp107_);
#line 332 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		image = _tmp110_;
#line 332 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		if (!_tmp108_) {
#line 333 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_g_object_unref0 (image);
#line 333 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_g_object_unref0 (tile);
#line 333 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			break;
#line 1797 "puzzle-view.c"
		}
#line 335 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp113_ = image;
#line 335 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp114_ = self->priv->selected_tile;
#line 335 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		if (_tmp113_ != _tmp114_) {
#line 1805 "puzzle-view.c"
			TileImage* _tmp115_ = NULL;
			gdouble _tmp116_ = 0.0;
			TileImage* _tmp117_ = NULL;
			gdouble _tmp118_ = 0.0;
#line 335 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp115_ = image;
#line 335 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp116_ = _tmp115_->x;
#line 335 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp117_ = image;
#line 335 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp118_ = _tmp117_->target_x;
#line 335 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp112_ = _tmp116_ == _tmp118_;
#line 1820 "puzzle-view.c"
		} else {
#line 335 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp112_ = FALSE;
#line 1824 "puzzle-view.c"
		}
#line 335 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		if (_tmp112_) {
#line 1828 "puzzle-view.c"
			TileImage* _tmp119_ = NULL;
			gdouble _tmp120_ = 0.0;
			TileImage* _tmp121_ = NULL;
			gdouble _tmp122_ = 0.0;
#line 335 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp119_ = image;
#line 335 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp120_ = _tmp119_->y;
#line 335 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp121_ = image;
#line 335 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp122_ = _tmp121_->target_y;
#line 335 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp111_ = _tmp120_ == _tmp122_;
#line 1843 "puzzle-view.c"
		} else {
#line 335 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp111_ = FALSE;
#line 1847 "puzzle-view.c"
		}
#line 335 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		if (_tmp111_) {
#line 336 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_g_object_unref0 (image);
#line 336 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_g_object_unref0 (tile);
#line 336 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			continue;
#line 1857 "puzzle-view.c"
		}
#line 338 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp123_ = context;
#line 338 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		cairo_save (_tmp123_);
#line 339 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp124_ = context;
#line 339 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp125_ = image;
#line 339 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp126_ = _tmp125_->x;
#line 339 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp127_ = image;
#line 339 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp128_ = _tmp127_->y;
#line 339 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		cairo_translate (_tmp124_, (gdouble) ((gint) (_tmp126_ + 0.5)), (gdouble) ((gint) (_tmp128_ + 0.5)));
#line 340 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp129_ = puzzle_view_get_puzzle (self);
#line 340 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp130_ = _tmp129_;
#line 340 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp131_ = puzzle_get_paused (_tmp130_);
#line 340 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp132_ = _tmp131_;
#line 340 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		if (_tmp132_) {
#line 1885 "puzzle-view.c"
			Theme* _tmp133_ = NULL;
			cairo_t* _tmp134_ = NULL;
			guint _tmp135_ = 0U;
#line 341 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp133_ = self->priv->theme;
#line 341 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp134_ = context;
#line 341 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp135_ = size;
#line 341 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			theme_draw_paused_tile (_tmp133_, _tmp134_, _tmp135_);
#line 1897 "puzzle-view.c"
		} else {
			Theme* _tmp136_ = NULL;
			cairo_t* _tmp137_ = NULL;
			guint _tmp138_ = 0U;
			Tile* _tmp139_ = NULL;
#line 343 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp136_ = self->priv->theme;
#line 343 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp137_ = context;
#line 343 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp138_ = size;
#line 343 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp139_ = tile;
#line 343 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			theme_draw_tile (_tmp136_, _tmp137_, _tmp138_, _tmp139_);
#line 1913 "puzzle-view.c"
		}
#line 344 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp140_ = context;
#line 344 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		cairo_restore (_tmp140_);
#line 328 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_g_object_unref0 (image);
#line 328 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_g_object_unref0 (tile);
#line 1923 "puzzle-view.c"
	}
#line 348 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp141_ = puzzle_view_get_puzzle (self);
#line 348 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp142_ = _tmp141_;
#line 348 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp143_ = puzzle_get_paused (_tmp142_);
#line 348 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp144_ = _tmp143_;
#line 348 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	if (_tmp144_) {
#line 1935 "puzzle-view.c"
		cairo_t* _tmp145_ = NULL;
		cairo_t* _tmp146_ = NULL;
		cairo_t* _tmp147_ = NULL;
		cairo_t* _tmp148_ = NULL;
		gint _tmp149_ = 0;
		gchar* text = NULL;
		const gchar* _tmp150_ = NULL;
		gchar* _tmp151_ = NULL;
		cairo_text_extents_t extents = {0};
		cairo_t* _tmp152_ = NULL;
		const gchar* _tmp153_ = NULL;
		cairo_text_extents_t _tmp154_ = {0};
		cairo_t* _tmp155_ = NULL;
		gint _tmp156_ = 0;
		cairo_text_extents_t _tmp157_ = {0};
		gdouble _tmp158_ = 0.0;
		gint _tmp159_ = 0;
		cairo_text_extents_t _tmp160_ = {0};
		gdouble _tmp161_ = 0.0;
		cairo_t* _tmp162_ = NULL;
		cairo_t* _tmp163_ = NULL;
		const gchar* _tmp164_ = NULL;
#line 350 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp145_ = context;
#line 350 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		cairo_set_source_rgba (_tmp145_, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.75);
#line 351 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp146_ = context;
#line 351 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		cairo_paint (_tmp146_);
#line 353 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp147_ = context;
#line 353 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		cairo_select_font_face (_tmp147_, "Sans", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
#line 354 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp148_ = context;
#line 354 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp149_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 354 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		cairo_set_font_size (_tmp148_, _tmp149_ * 0.125);
#line 356 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp150_ = _ ("Paused");
#line 356 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp151_ = g_strdup (_tmp150_);
#line 356 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		text = _tmp151_;
#line 358 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp152_ = context;
#line 358 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp153_ = text;
#line 358 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		cairo_text_extents (_tmp152_, _tmp153_, &_tmp154_);
#line 358 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		extents = _tmp154_;
#line 359 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp155_ = context;
#line 359 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp156_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 359 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp157_ = extents;
#line 359 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp158_ = _tmp157_.width;
#line 359 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp159_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 359 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp160_ = extents;
#line 359 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp161_ = _tmp160_.height;
#line 359 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		cairo_move_to (_tmp155_, (_tmp156_ - _tmp158_) / 2.0, (_tmp159_ + _tmp161_) / 2.0);
#line 360 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp162_ = context;
#line 360 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		cairo_set_source_rgb (_tmp162_, (gdouble) 1, (gdouble) 1, (gdouble) 1);
#line 361 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp163_ = context;
#line 361 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp164_ = text;
#line 361 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		cairo_show_text (_tmp163_, _tmp164_);
#line 348 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_g_free0 (text);
#line 2018 "puzzle-view.c"
	}
#line 364 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	result = FALSE;
#line 364 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	return result;
#line 2024 "puzzle-view.c"
}


static gboolean _puzzle_view_selection_timeout_cb_gsource_func (gpointer self) {
	gboolean result;
	result = puzzle_view_selection_timeout_cb ((PuzzleView*) self);
#line 394 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	return result;
#line 2033 "puzzle-view.c"
}


static void puzzle_view_pick_tile (PuzzleView* self, gdouble x, gdouble y) {
	TileImage* _tmp0_ = NULL;
	Puzzle* _tmp1_ = NULL;
	Puzzle* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	guint x_offset = 0U;
	guint y_offset = 0U;
	guint size = 0U;
	guint gap = 0U;
	guint _tmp5_ = 0U;
	guint _tmp6_ = 0U;
	guint _tmp7_ = 0U;
	guint _tmp8_ = 0U;
	GHashTableIter iter = {0};
	GHashTable* _tmp9_ = NULL;
#line 367 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	g_return_if_fail (self != NULL);
#line 369 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp0_ = self->priv->selected_tile;
#line 369 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	if (_tmp0_ != NULL) {
#line 370 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		return;
#line 2061 "puzzle-view.c"
	}
#line 372 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp1_ = puzzle_view_get_puzzle (self);
#line 372 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp2_ = _tmp1_;
#line 372 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp3_ = puzzle_get_is_solved (_tmp2_);
#line 372 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp4_ = _tmp3_;
#line 372 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	if (_tmp4_) {
#line 373 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		return;
#line 2075 "puzzle-view.c"
	}
#line 376 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	puzzle_view_get_dimensions (self, &_tmp5_, &_tmp6_, &_tmp7_, &_tmp8_);
#line 376 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	x_offset = _tmp5_;
#line 376 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	y_offset = _tmp6_;
#line 376 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	size = _tmp7_;
#line 376 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	gap = _tmp8_;
#line 378 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp9_ = self->priv->tiles;
#line 378 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	g_hash_table_iter_init (&iter, _tmp9_);
#line 379 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	while (TRUE) {
#line 2093 "puzzle-view.c"
		Tile* tile = NULL;
		TileImage* image = NULL;
		gconstpointer _tmp10_ = NULL;
		gconstpointer _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		Tile* _tmp13_ = NULL;
		TileImage* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_ = FALSE;
		gboolean _tmp17_ = FALSE;
		gdouble _tmp18_ = 0.0;
		TileImage* _tmp19_ = NULL;
		gdouble _tmp20_ = 0.0;
#line 383 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp12_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp10_), (gpointer*) (&_tmp11_));
#line 383 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_g_object_unref0 (tile);
#line 383 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp13_ = _g_object_ref0 (_tmp10_);
#line 383 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		tile = _tmp13_;
#line 383 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_g_object_unref0 (image);
#line 383 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp14_ = _g_object_ref0 (_tmp11_);
#line 383 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		image = _tmp14_;
#line 383 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		if (!_tmp12_) {
#line 384 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_g_object_unref0 (image);
#line 384 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_g_object_unref0 (tile);
#line 384 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			break;
#line 2129 "puzzle-view.c"
		}
#line 386 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp18_ = x;
#line 386 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp19_ = image;
#line 386 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp20_ = _tmp19_->x;
#line 386 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		if (_tmp18_ >= _tmp20_) {
#line 2139 "puzzle-view.c"
			gdouble _tmp21_ = 0.0;
			TileImage* _tmp22_ = NULL;
			gdouble _tmp23_ = 0.0;
			guint _tmp24_ = 0U;
#line 386 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp21_ = x;
#line 386 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp22_ = image;
#line 386 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp23_ = _tmp22_->x;
#line 386 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp24_ = size;
#line 386 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp17_ = _tmp21_ <= (_tmp23_ + _tmp24_);
#line 2154 "puzzle-view.c"
		} else {
#line 386 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp17_ = FALSE;
#line 2158 "puzzle-view.c"
		}
#line 386 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		if (_tmp17_) {
#line 2162 "puzzle-view.c"
			gdouble _tmp25_ = 0.0;
			TileImage* _tmp26_ = NULL;
			gdouble _tmp27_ = 0.0;
#line 386 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp25_ = y;
#line 386 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp26_ = image;
#line 386 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp27_ = _tmp26_->y;
#line 386 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp16_ = _tmp25_ >= _tmp27_;
#line 2174 "puzzle-view.c"
		} else {
#line 386 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp16_ = FALSE;
#line 2178 "puzzle-view.c"
		}
#line 386 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		if (_tmp16_) {
#line 2182 "puzzle-view.c"
			gdouble _tmp28_ = 0.0;
			TileImage* _tmp29_ = NULL;
			gdouble _tmp30_ = 0.0;
			guint _tmp31_ = 0U;
#line 386 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp28_ = y;
#line 386 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp29_ = image;
#line 386 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp30_ = _tmp29_->y;
#line 386 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp31_ = size;
#line 386 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp15_ = _tmp28_ <= (_tmp30_ + _tmp31_);
#line 2197 "puzzle-view.c"
		} else {
#line 386 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp15_ = FALSE;
#line 2201 "puzzle-view.c"
		}
#line 386 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		if (_tmp15_) {
#line 2205 "puzzle-view.c"
			TileImage* _tmp32_ = NULL;
			TileImage* _tmp33_ = NULL;
			gdouble _tmp34_ = 0.0;
			TileImage* _tmp35_ = NULL;
			gdouble _tmp36_ = 0.0;
			gdouble _tmp37_ = 0.0;
			TileImage* _tmp38_ = NULL;
			gdouble _tmp39_ = 0.0;
			guint _tmp40_ = 0U;
			guint _tmp42_ = 0U;
#line 388 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp32_ = image;
#line 388 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp33_ = _g_object_ref0 (_tmp32_);
#line 388 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_g_object_unref0 (self->priv->selected_tile);
#line 388 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			self->priv->selected_tile = _tmp33_;
#line 389 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp34_ = x;
#line 389 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp35_ = image;
#line 389 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp36_ = _tmp35_->x;
#line 389 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			self->priv->selected_x_offset = _tmp34_ - _tmp36_;
#line 390 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp37_ = y;
#line 390 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp38_ = image;
#line 390 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp39_ = _tmp38_->y;
#line 390 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			self->priv->selected_y_offset = _tmp37_ - _tmp39_;
#line 392 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp40_ = self->priv->selection_timeout;
#line 392 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			if (_tmp40_ != ((guint) 0)) {
#line 2244 "puzzle-view.c"
				guint _tmp41_ = 0U;
#line 393 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
				_tmp41_ = self->priv->selection_timeout;
#line 393 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
				g_source_remove (_tmp41_);
#line 2250 "puzzle-view.c"
			}
#line 394 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp42_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 200, _puzzle_view_selection_timeout_cb_gsource_func, g_object_ref (self), g_object_unref);
#line 394 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			self->priv->selection_timeout = _tmp42_;
#line 2256 "puzzle-view.c"
		}
#line 379 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_g_object_unref0 (image);
#line 379 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_g_object_unref0 (tile);
#line 2262 "puzzle-view.c"
	}
}


static gboolean puzzle_view_selection_timeout_cb (PuzzleView* self) {
	gboolean result = FALSE;
#line 399 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 401 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	self->priv->selection_timeout = (guint) 0;
#line 402 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	result = FALSE;
#line 402 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	return result;
#line 2277 "puzzle-view.c"
}


static gboolean puzzle_view_on_right_half (PuzzleView* self, gdouble x) {
	gboolean result = FALSE;
	guint x_offset = 0U;
	guint y_offset = 0U;
	guint size = 0U;
	guint gap = 0U;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	gdouble _tmp4_ = 0.0;
	Puzzle* _tmp5_ = NULL;
	Puzzle* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	guint _tmp8_ = 0U;
#line 405 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 408 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	puzzle_view_get_dimensions (self, &_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
#line 408 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	x_offset = _tmp0_;
#line 408 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	y_offset = _tmp1_;
#line 408 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	size = _tmp2_;
#line 408 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	gap = _tmp3_;
#line 410 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp4_ = x;
#line 410 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp5_ = puzzle_view_get_puzzle (self);
#line 410 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp6_ = _tmp5_;
#line 410 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp7_ = puzzle_get_size (_tmp6_);
#line 410 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp8_ = _tmp7_;
#line 410 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	result = _tmp4_ > ((x_offset + (size * _tmp8_)) + (gap * 0.5));
#line 410 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	return result;
#line 2322 "puzzle-view.c"
}


static void puzzle_view_drop_tile (PuzzleView* self, gdouble x, gdouble y) {
	TileImage* _tmp0_ = NULL;
	guint x_offset = 0U;
	guint y_offset = 0U;
	guint size = 0U;
	guint gap = 0U;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	gdouble _tmp5_ = 0.0;
	guint _tmp6_ = 0U;
	gdouble _tmp7_ = 0.0;
	gdouble _tmp8_ = 0.0;
	guint _tmp9_ = 0U;
	gdouble _tmp10_ = 0.0;
	gint tile_y = 0;
	gdouble _tmp11_ = 0.0;
	guint _tmp12_ = 0U;
	guint _tmp13_ = 0U;
	gdouble _tmp14_ = 0.0;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	Puzzle* _tmp18_ = NULL;
	Puzzle* _tmp19_ = NULL;
	guint _tmp20_ = 0U;
	guint _tmp21_ = 0U;
	gint _tmp22_ = 0;
	gint tile_x = 0;
	gdouble _tmp23_ = 0.0;
	gboolean _tmp24_ = FALSE;
	guint selected_x = 0U;
	guint selected_y = 0U;
	Puzzle* _tmp63_ = NULL;
	Puzzle* _tmp64_ = NULL;
	TileImage* _tmp65_ = NULL;
	Tile* _tmp66_ = NULL;
	guint _tmp67_ = 0U;
	guint _tmp68_ = 0U;
	Puzzle* _tmp69_ = NULL;
	Puzzle* _tmp70_ = NULL;
	guint _tmp71_ = 0U;
	guint _tmp72_ = 0U;
	gint _tmp73_ = 0;
	gint _tmp74_ = 0;
	gboolean _tmp75_ = FALSE;
#line 413 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	g_return_if_fail (self != NULL);
#line 415 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp0_ = self->priv->selected_tile;
#line 415 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	if (_tmp0_ == NULL) {
#line 416 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		return;
#line 2381 "puzzle-view.c"
	}
#line 419 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	puzzle_view_get_dimensions (self, &_tmp1_, &_tmp2_, &_tmp3_, &_tmp4_);
#line 419 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	x_offset = _tmp1_;
#line 419 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	y_offset = _tmp2_;
#line 419 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	size = _tmp3_;
#line 419 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	gap = _tmp4_;
#line 422 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp5_ = x;
#line 422 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp6_ = size;
#line 422 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp7_ = self->priv->selected_x_offset;
#line 422 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	x = _tmp5_ + ((_tmp6_ * 0.5) - _tmp7_);
#line 423 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp8_ = y;
#line 423 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp9_ = size;
#line 423 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp10_ = self->priv->selected_x_offset;
#line 423 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	y = _tmp8_ + ((_tmp9_ * 0.5) - _tmp10_);
#line 425 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp11_ = y;
#line 425 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp12_ = y_offset;
#line 425 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp13_ = size;
#line 425 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp14_ = floor ((_tmp11_ - _tmp12_) / _tmp13_);
#line 425 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	tile_y = (gint) _tmp14_;
#line 426 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp15_ = tile_y;
#line 426 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp16_ = MAX (_tmp15_, 0);
#line 426 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	tile_y = _tmp16_;
#line 427 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp17_ = tile_y;
#line 427 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp18_ = puzzle_view_get_puzzle (self);
#line 427 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp19_ = _tmp18_;
#line 427 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp20_ = puzzle_get_size (_tmp19_);
#line 427 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp21_ = _tmp20_;
#line 427 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp22_ = MIN (_tmp17_, ((gint) _tmp21_) - 1);
#line 427 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	tile_y = _tmp22_;
#line 431 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp23_ = x;
#line 431 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp24_ = puzzle_view_on_right_half (self, _tmp23_);
#line 431 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	if (_tmp24_) {
#line 2445 "puzzle-view.c"
		Puzzle* _tmp25_ = NULL;
		Puzzle* _tmp26_ = NULL;
		guint _tmp27_ = 0U;
		guint _tmp28_ = 0U;
		gdouble _tmp29_ = 0.0;
		guint _tmp30_ = 0U;
		Puzzle* _tmp31_ = NULL;
		Puzzle* _tmp32_ = NULL;
		guint _tmp33_ = 0U;
		guint _tmp34_ = 0U;
		guint _tmp35_ = 0U;
		guint _tmp36_ = 0U;
		guint _tmp37_ = 0U;
		gdouble _tmp38_ = 0.0;
		gint _tmp39_ = 0;
		Puzzle* _tmp40_ = NULL;
		Puzzle* _tmp41_ = NULL;
		guint _tmp42_ = 0U;
		guint _tmp43_ = 0U;
		gint _tmp44_ = 0;
		gint _tmp45_ = 0;
		Puzzle* _tmp46_ = NULL;
		Puzzle* _tmp47_ = NULL;
		guint _tmp48_ = 0U;
		guint _tmp49_ = 0U;
		gint _tmp50_ = 0;
#line 433 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp25_ = puzzle_view_get_puzzle (self);
#line 433 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp26_ = _tmp25_;
#line 433 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp27_ = puzzle_get_size (_tmp26_);
#line 433 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp28_ = _tmp27_;
#line 433 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp29_ = x;
#line 433 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp30_ = x_offset;
#line 433 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp31_ = puzzle_view_get_puzzle (self);
#line 433 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp32_ = _tmp31_;
#line 433 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp33_ = puzzle_get_size (_tmp32_);
#line 433 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp34_ = _tmp33_;
#line 433 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp35_ = size;
#line 433 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp36_ = gap;
#line 433 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp37_ = size;
#line 433 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp38_ = floor ((_tmp29_ - ((_tmp30_ + (_tmp34_ * _tmp35_)) + _tmp36_)) / _tmp37_);
#line 433 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		tile_x = ((gint) _tmp28_) + ((gint) _tmp38_);
#line 434 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp39_ = tile_x;
#line 434 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp40_ = puzzle_view_get_puzzle (self);
#line 434 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp41_ = _tmp40_;
#line 434 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp42_ = puzzle_get_size (_tmp41_);
#line 434 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp43_ = _tmp42_;
#line 434 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp44_ = MAX (_tmp39_, (gint) _tmp43_);
#line 434 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		tile_x = _tmp44_;
#line 435 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp45_ = tile_x;
#line 435 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp46_ = puzzle_view_get_puzzle (self);
#line 435 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp47_ = _tmp46_;
#line 435 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp48_ = puzzle_get_size (_tmp47_);
#line 435 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp49_ = _tmp48_;
#line 435 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp50_ = MIN (_tmp45_, (2 * ((gint) _tmp49_)) - 1);
#line 435 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		tile_x = _tmp50_;
#line 2530 "puzzle-view.c"
	} else {
		gdouble _tmp51_ = 0.0;
		guint _tmp52_ = 0U;
		guint _tmp53_ = 0U;
		gdouble _tmp54_ = 0.0;
		gint _tmp55_ = 0;
		gint _tmp56_ = 0;
		gint _tmp57_ = 0;
		Puzzle* _tmp58_ = NULL;
		Puzzle* _tmp59_ = NULL;
		guint _tmp60_ = 0U;
		guint _tmp61_ = 0U;
		gint _tmp62_ = 0;
#line 439 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp51_ = x;
#line 439 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp52_ = x_offset;
#line 439 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp53_ = size;
#line 439 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp54_ = floor ((_tmp51_ - _tmp52_) / _tmp53_);
#line 439 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		tile_x = (gint) _tmp54_;
#line 440 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp55_ = tile_x;
#line 440 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp56_ = MAX (_tmp55_, 0);
#line 440 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		tile_x = _tmp56_;
#line 441 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp57_ = tile_x;
#line 441 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp58_ = puzzle_view_get_puzzle (self);
#line 441 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp59_ = _tmp58_;
#line 441 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp60_ = puzzle_get_size (_tmp59_);
#line 441 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp61_ = _tmp60_;
#line 441 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp62_ = MIN (_tmp57_, ((gint) _tmp61_) - 1);
#line 441 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		tile_x = _tmp62_;
#line 2574 "puzzle-view.c"
	}
#line 446 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp63_ = puzzle_view_get_puzzle (self);
#line 446 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp64_ = _tmp63_;
#line 446 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp65_ = self->priv->selected_tile;
#line 446 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp66_ = _tmp65_->tile;
#line 446 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	puzzle_get_tile_location (_tmp64_, _tmp66_, &_tmp67_, &_tmp68_);
#line 446 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	selected_x = _tmp67_;
#line 446 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	selected_y = _tmp68_;
#line 447 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp69_ = puzzle_view_get_puzzle (self);
#line 447 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp70_ = _tmp69_;
#line 447 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp71_ = selected_x;
#line 447 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp72_ = selected_y;
#line 447 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp73_ = tile_x;
#line 447 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp74_ = tile_y;
#line 447 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp75_ = puzzle_can_switch (_tmp70_, _tmp71_, _tmp72_, (guint) _tmp73_, (guint) _tmp74_);
#line 447 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	if (_tmp75_) {
#line 2606 "puzzle-view.c"
		Puzzle* _tmp76_ = NULL;
		Puzzle* _tmp77_ = NULL;
		guint _tmp78_ = 0U;
		guint _tmp79_ = 0U;
		gint _tmp80_ = 0;
		gint _tmp81_ = 0;
#line 448 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp76_ = puzzle_view_get_puzzle (self);
#line 448 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp77_ = _tmp76_;
#line 448 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp78_ = selected_x;
#line 448 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp79_ = selected_y;
#line 448 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp80_ = tile_x;
#line 448 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp81_ = tile_y;
#line 448 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		puzzle_switch_tiles (_tmp77_, _tmp78_, _tmp79_, (guint) _tmp80_, (guint) _tmp81_);
#line 2627 "puzzle-view.c"
	} else {
		TileImage* _tmp82_ = NULL;
		guint _tmp83_ = 0U;
		guint _tmp84_ = 0U;
#line 450 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp82_ = self->priv->selected_tile;
#line 450 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp83_ = selected_x;
#line 450 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp84_ = selected_y;
#line 450 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		puzzle_view_move_tile_to_location (self, _tmp82_, _tmp83_, _tmp84_, 0.2);
#line 2640 "puzzle-view.c"
	}
#line 451 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_g_object_unref0 (self->priv->selected_tile);
#line 451 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	self->priv->selected_tile = NULL;
#line 2646 "puzzle-view.c"
}


static void puzzle_view_move_tile_to_right_half (PuzzleView* self, TileImage* image) {
#line 454 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	g_return_if_fail (self != NULL);
#line 454 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	g_return_if_fail (image != NULL);
#line 2655 "puzzle-view.c"
	{
		guint y = 0U;
#line 457 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		y = (guint) 0;
#line 2660 "puzzle-view.c"
		{
			gboolean _tmp0_ = FALSE;
#line 457 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp0_ = TRUE;
#line 457 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			while (TRUE) {
#line 2667 "puzzle-view.c"
				guint _tmp2_ = 0U;
				Puzzle* _tmp3_ = NULL;
				Puzzle* _tmp4_ = NULL;
				guint _tmp5_ = 0U;
				guint _tmp6_ = 0U;
#line 457 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
				if (!_tmp0_) {
#line 2675 "puzzle-view.c"
					guint _tmp1_ = 0U;
#line 457 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
					_tmp1_ = y;
#line 457 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
					y = _tmp1_ + 1;
#line 2681 "puzzle-view.c"
				}
#line 457 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
				_tmp0_ = FALSE;
#line 457 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
				_tmp2_ = y;
#line 457 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
				_tmp3_ = puzzle_view_get_puzzle (self);
#line 457 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
				_tmp4_ = _tmp3_;
#line 457 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
				_tmp5_ = puzzle_get_size (_tmp4_);
#line 457 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
				_tmp6_ = _tmp5_;
#line 457 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
				if (!(_tmp2_ < _tmp6_)) {
#line 457 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
					break;
#line 2699 "puzzle-view.c"
				}
				{
					guint x = 0U;
					Puzzle* _tmp7_ = NULL;
					Puzzle* _tmp8_ = NULL;
					guint _tmp9_ = 0U;
					guint _tmp10_ = 0U;
#line 459 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
					_tmp7_ = puzzle_view_get_puzzle (self);
#line 459 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
					_tmp8_ = _tmp7_;
#line 459 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
					_tmp9_ = puzzle_get_size (_tmp8_);
#line 459 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
					_tmp10_ = _tmp9_;
#line 459 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
					x = _tmp10_;
#line 2717 "puzzle-view.c"
					{
						gboolean _tmp11_ = FALSE;
#line 459 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
						_tmp11_ = TRUE;
#line 459 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
						while (TRUE) {
#line 2724 "puzzle-view.c"
							guint _tmp13_ = 0U;
							Puzzle* _tmp14_ = NULL;
							Puzzle* _tmp15_ = NULL;
							guint _tmp16_ = 0U;
							guint _tmp17_ = 0U;
							Puzzle* _tmp18_ = NULL;
							Puzzle* _tmp19_ = NULL;
							guint _tmp20_ = 0U;
							guint _tmp21_ = 0U;
							Tile* _tmp22_ = NULL;
							Tile* _tmp23_ = NULL;
							gboolean _tmp24_ = FALSE;
#line 459 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							if (!_tmp11_) {
#line 2739 "puzzle-view.c"
								guint _tmp12_ = 0U;
#line 459 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
								_tmp12_ = x;
#line 459 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
								x = _tmp12_ + 1;
#line 2745 "puzzle-view.c"
							}
#line 459 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp11_ = FALSE;
#line 459 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp13_ = x;
#line 459 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp14_ = puzzle_view_get_puzzle (self);
#line 459 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp15_ = _tmp14_;
#line 459 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp16_ = puzzle_get_size (_tmp15_);
#line 459 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp17_ = _tmp16_;
#line 459 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							if (!(_tmp13_ < (_tmp17_ * 2))) {
#line 459 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
								break;
#line 2763 "puzzle-view.c"
							}
#line 461 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp18_ = puzzle_view_get_puzzle (self);
#line 461 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp19_ = _tmp18_;
#line 461 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp20_ = x;
#line 461 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp21_ = y;
#line 461 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp22_ = puzzle_get_tile (_tmp19_, _tmp20_, _tmp21_);
#line 461 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp23_ = _tmp22_;
#line 461 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp24_ = _tmp23_ == NULL;
#line 461 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_g_object_unref0 (_tmp23_);
#line 461 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							if (_tmp24_) {
#line 2783 "puzzle-view.c"
								guint source_x = 0U;
								guint source_y = 0U;
								Puzzle* _tmp25_ = NULL;
								Puzzle* _tmp26_ = NULL;
								TileImage* _tmp27_ = NULL;
								Tile* _tmp28_ = NULL;
								guint _tmp29_ = 0U;
								guint _tmp30_ = 0U;
								Puzzle* _tmp31_ = NULL;
								Puzzle* _tmp32_ = NULL;
								guint _tmp33_ = 0U;
								guint _tmp34_ = 0U;
#line 464 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
								_tmp25_ = puzzle_view_get_puzzle (self);
#line 464 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
								_tmp26_ = _tmp25_;
#line 464 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
								_tmp27_ = image;
#line 464 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
								_tmp28_ = _tmp27_->tile;
#line 464 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
								puzzle_get_tile_location (_tmp26_, _tmp28_, &_tmp29_, &_tmp30_);
#line 464 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
								source_x = _tmp29_;
#line 464 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
								source_y = _tmp30_;
#line 465 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
								_tmp31_ = puzzle_view_get_puzzle (self);
#line 465 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
								_tmp32_ = _tmp31_;
#line 465 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
								_tmp33_ = x;
#line 465 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
								_tmp34_ = y;
#line 465 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
								puzzle_switch_tiles (_tmp32_, source_x, source_y, _tmp33_, _tmp34_);
#line 466 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
								return;
#line 2822 "puzzle-view.c"
							}
						}
					}
				}
			}
		}
	}
#line 470 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	g_assert_not_reached ();
#line 2832 "puzzle-view.c"
}


static gboolean puzzle_view_real_button_press_event (GtkWidget* base, GdkEventButton* event) {
	PuzzleView * self;
	gboolean result = FALSE;
	Puzzle* _tmp0_ = NULL;
	Puzzle* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	GdkEventButton* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
#line 473 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	self = (PuzzleView*) base;
#line 473 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 475 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp0_ = puzzle_view_get_puzzle (self);
#line 475 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp1_ = _tmp0_;
#line 475 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp2_ = puzzle_get_paused (_tmp1_);
#line 475 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp3_ = _tmp2_;
#line 475 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	if (_tmp3_) {
#line 476 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		result = FALSE;
#line 476 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		return result;
#line 2863 "puzzle-view.c"
	}
#line 478 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp4_ = event;
#line 478 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp5_ = _tmp4_->button;
#line 478 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	if (_tmp5_ == ((guint) 1)) {
#line 2871 "puzzle-view.c"
		GdkEventButton* _tmp6_ = NULL;
		GdkEventType _tmp7_ = 0;
#line 480 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp6_ = event;
#line 480 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp7_ = _tmp6_->type;
#line 480 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		if (_tmp7_ == GDK_BUTTON_PRESS) {
#line 2880 "puzzle-view.c"
			TileImage* _tmp8_ = NULL;
#line 482 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp8_ = self->priv->selected_tile;
#line 482 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			if (_tmp8_ == NULL) {
#line 2886 "puzzle-view.c"
				GdkEventButton* _tmp9_ = NULL;
				gdouble _tmp10_ = 0.0;
				GdkEventButton* _tmp11_ = NULL;
				gdouble _tmp12_ = 0.0;
#line 483 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
				_tmp9_ = event;
#line 483 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
				_tmp10_ = _tmp9_->x;
#line 483 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
				_tmp11_ = event;
#line 483 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
				_tmp12_ = _tmp11_->y;
#line 483 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
				puzzle_view_pick_tile (self, _tmp10_, _tmp12_);
#line 2901 "puzzle-view.c"
			} else {
				TileImage* _tmp13_ = NULL;
#line 484 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
				_tmp13_ = self->priv->selected_tile;
#line 484 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
				if (_tmp13_ != NULL) {
#line 2908 "puzzle-view.c"
					GdkEventButton* _tmp14_ = NULL;
					gdouble _tmp15_ = 0.0;
					GdkEventButton* _tmp16_ = NULL;
					gdouble _tmp17_ = 0.0;
#line 485 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
					_tmp14_ = event;
#line 485 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
					_tmp15_ = _tmp14_->x;
#line 485 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
					_tmp16_ = event;
#line 485 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
					_tmp17_ = _tmp16_->y;
#line 485 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
					puzzle_view_drop_tile (self, _tmp15_, _tmp17_);
#line 2923 "puzzle-view.c"
				}
			}
		} else {
			GdkEventButton* _tmp18_ = NULL;
			GdkEventType _tmp19_ = 0;
#line 487 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp18_ = event;
#line 487 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp19_ = _tmp18_->type;
#line 487 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			if (_tmp19_ == GDK_DOUBLE_BUTTON_PRESS) {
#line 2935 "puzzle-view.c"
				GdkEventButton* _tmp20_ = NULL;
				gdouble _tmp21_ = 0.0;
				GdkEventButton* _tmp22_ = NULL;
				gdouble _tmp23_ = 0.0;
				gboolean _tmp24_ = FALSE;
				TileImage* _tmp25_ = NULL;
#line 490 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
				_tmp20_ = event;
#line 490 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
				_tmp21_ = _tmp20_->x;
#line 490 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
				_tmp22_ = event;
#line 490 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
				_tmp23_ = _tmp22_->y;
#line 490 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
				puzzle_view_pick_tile (self, _tmp21_, _tmp23_);
#line 491 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
				_tmp25_ = self->priv->selected_tile;
#line 491 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
				if (_tmp25_ != NULL) {
#line 2956 "puzzle-view.c"
					TileImage* _tmp26_ = NULL;
					gdouble _tmp27_ = 0.0;
					gboolean _tmp28_ = FALSE;
#line 491 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
					_tmp26_ = self->priv->selected_tile;
#line 491 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
					_tmp27_ = _tmp26_->x;
#line 491 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
					_tmp28_ = puzzle_view_on_right_half (self, _tmp27_);
#line 491 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
					_tmp24_ = !_tmp28_;
#line 2968 "puzzle-view.c"
				} else {
#line 491 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
					_tmp24_ = FALSE;
#line 2972 "puzzle-view.c"
				}
#line 491 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
				if (_tmp24_) {
#line 2976 "puzzle-view.c"
					TileImage* _tmp29_ = NULL;
#line 492 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
					_tmp29_ = self->priv->selected_tile;
#line 492 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
					puzzle_view_move_tile_to_right_half (self, _tmp29_);
#line 2982 "puzzle-view.c"
				}
#line 493 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
				_g_object_unref0 (self->priv->selected_tile);
#line 493 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
				self->priv->selected_tile = NULL;
#line 2988 "puzzle-view.c"
			}
		}
	}
#line 497 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	result = FALSE;
#line 497 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	return result;
#line 2996 "puzzle-view.c"
}


static gboolean puzzle_view_real_button_release_event (GtkWidget* base, GdkEventButton* event) {
	PuzzleView * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GdkEventButton* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	guint _tmp10_ = 0U;
#line 500 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	self = (PuzzleView*) base;
#line 500 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 502 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp2_ = event;
#line 502 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp3_ = _tmp2_->button;
#line 502 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	if (_tmp3_ == ((guint) 1)) {
#line 3018 "puzzle-view.c"
		TileImage* _tmp4_ = NULL;
#line 502 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp4_ = self->priv->selected_tile;
#line 502 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp1_ = _tmp4_ != NULL;
#line 3024 "puzzle-view.c"
	} else {
#line 502 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp1_ = FALSE;
#line 3028 "puzzle-view.c"
	}
#line 502 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	if (_tmp1_) {
#line 3032 "puzzle-view.c"
		guint _tmp5_ = 0U;
#line 502 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp5_ = self->priv->selection_timeout;
#line 502 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp0_ = _tmp5_ == ((guint) 0);
#line 3038 "puzzle-view.c"
	} else {
#line 502 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp0_ = FALSE;
#line 3042 "puzzle-view.c"
	}
#line 502 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	if (_tmp0_) {
#line 3046 "puzzle-view.c"
		GdkEventButton* _tmp6_ = NULL;
		gdouble _tmp7_ = 0.0;
		GdkEventButton* _tmp8_ = NULL;
		gdouble _tmp9_ = 0.0;
#line 503 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp6_ = event;
#line 503 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp7_ = _tmp6_->x;
#line 503 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp8_ = event;
#line 503 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp9_ = _tmp8_->y;
#line 503 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		puzzle_view_drop_tile (self, _tmp7_, _tmp9_);
#line 3061 "puzzle-view.c"
	}
#line 505 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp10_ = self->priv->selection_timeout;
#line 505 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	if (_tmp10_ != ((guint) 0)) {
#line 3067 "puzzle-view.c"
		guint _tmp11_ = 0U;
#line 506 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp11_ = self->priv->selection_timeout;
#line 506 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		g_source_remove (_tmp11_);
#line 3073 "puzzle-view.c"
	}
#line 507 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	self->priv->selection_timeout = (guint) 0;
#line 509 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	result = FALSE;
#line 509 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	return result;
#line 3081 "puzzle-view.c"
}


static gboolean puzzle_view_real_motion_notify_event (GtkWidget* base, GdkEventMotion* event) {
	PuzzleView * self;
	gboolean result = FALSE;
	TileImage* _tmp0_ = NULL;
#line 512 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	self = (PuzzleView*) base;
#line 512 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 514 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp0_ = self->priv->selected_tile;
#line 514 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	if (_tmp0_ != NULL) {
#line 3097 "puzzle-view.c"
		TileImage* _tmp1_ = NULL;
		GdkEventMotion* _tmp2_ = NULL;
		gdouble _tmp3_ = 0.0;
		gdouble _tmp4_ = 0.0;
		GdkEventMotion* _tmp5_ = NULL;
		gdouble _tmp6_ = 0.0;
		gdouble _tmp7_ = 0.0;
#line 515 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp1_ = self->priv->selected_tile;
#line 515 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp2_ = event;
#line 515 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp3_ = _tmp2_->x;
#line 515 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp4_ = self->priv->selected_x_offset;
#line 515 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp5_ = event;
#line 515 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp6_ = _tmp5_->y;
#line 515 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp7_ = self->priv->selected_y_offset;
#line 515 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		puzzle_view_move_tile (self, _tmp1_, (gdouble) ((gint) (_tmp3_ - _tmp4_)), (gdouble) ((gint) (_tmp6_ - _tmp7_)), (gdouble) 0);
#line 3121 "puzzle-view.c"
	}
#line 517 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	result = FALSE;
#line 517 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	return result;
#line 3127 "puzzle-view.c"
}


Puzzle* puzzle_view_get_puzzle (PuzzleView* self) {
	Puzzle* result;
	Puzzle* _tmp0_ = NULL;
#line 50 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 50 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp0_ = self->priv->_puzzle;
#line 50 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	result = _tmp0_;
#line 50 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	return result;
#line 3142 "puzzle-view.c"
}


static void _puzzle_view_tile_moved_cb_puzzle_tile_moved (Puzzle* _sender, Tile* tile, guint x, guint y, gpointer self) {
#line 70 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	puzzle_view_tile_moved_cb ((PuzzleView*) self, _sender, tile, x, y);
#line 3149 "puzzle-view.c"
}


static void _puzzle_view_puzzle___lambda4_ (PuzzleView* self) {
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 3156 "puzzle-view.c"
}


static void __puzzle_view_puzzle___lambda4__puzzle_paused_changed (Puzzle* _sender, gpointer self) {
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_puzzle_view_puzzle___lambda4_ ((PuzzleView*) self);
#line 3163 "puzzle-view.c"
}


void puzzle_view_set_puzzle (PuzzleView* self, Puzzle* value) {
	Puzzle* _tmp0_ = NULL;
	Puzzle* _tmp2_ = NULL;
	Puzzle* _tmp3_ = NULL;
	GHashTable* _tmp4_ = NULL;
	Puzzle* _tmp35_ = NULL;
	Puzzle* _tmp36_ = NULL;
#line 51 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	g_return_if_fail (self != NULL);
#line 53 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp0_ = self->priv->_puzzle;
#line 53 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	if (_tmp0_ != NULL) {
#line 3180 "puzzle-view.c"
		Puzzle* _tmp1_ = NULL;
#line 54 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		_tmp1_ = self->priv->_puzzle;
#line 54 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		g_signal_handlers_disconnect_by_func (_tmp1_, NULL, self);
#line 3186 "puzzle-view.c"
	}
#line 55 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp2_ = value;
#line 55 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 55 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_g_object_unref0 (self->priv->_puzzle);
#line 55 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	self->priv->_puzzle = _tmp3_;
#line 56 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp4_ = self->priv->tiles;
#line 56 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	g_hash_table_remove_all (_tmp4_);
#line 3200 "puzzle-view.c"
	{
		gint y = 0;
#line 57 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		y = 0;
#line 3205 "puzzle-view.c"
		{
			gboolean _tmp5_ = FALSE;
#line 57 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp5_ = TRUE;
#line 57 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			while (TRUE) {
#line 3212 "puzzle-view.c"
				gint _tmp7_ = 0;
				Puzzle* _tmp8_ = NULL;
				Puzzle* _tmp9_ = NULL;
				guint _tmp10_ = 0U;
				guint _tmp11_ = 0U;
#line 57 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
				if (!_tmp5_) {
#line 3220 "puzzle-view.c"
					gint _tmp6_ = 0;
#line 57 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
					_tmp6_ = y;
#line 57 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
					y = _tmp6_ + 1;
#line 3226 "puzzle-view.c"
				}
#line 57 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
				_tmp5_ = FALSE;
#line 57 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
				_tmp7_ = y;
#line 57 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
				_tmp8_ = puzzle_view_get_puzzle (self);
#line 57 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
				_tmp9_ = _tmp8_;
#line 57 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
				_tmp10_ = puzzle_get_size (_tmp9_);
#line 57 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
				_tmp11_ = _tmp10_;
#line 57 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
				if (!(((guint) _tmp7_) < _tmp11_)) {
#line 57 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
					break;
#line 3244 "puzzle-view.c"
				}
				{
					gint x = 0;
#line 59 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
					x = 0;
#line 3250 "puzzle-view.c"
					{
						gboolean _tmp12_ = FALSE;
#line 59 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
						_tmp12_ = TRUE;
#line 59 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
						while (TRUE) {
#line 3257 "puzzle-view.c"
							gint _tmp14_ = 0;
							Puzzle* _tmp15_ = NULL;
							Puzzle* _tmp16_ = NULL;
							guint _tmp17_ = 0U;
							guint _tmp18_ = 0U;
							Tile* tile = NULL;
							Puzzle* _tmp19_ = NULL;
							Puzzle* _tmp20_ = NULL;
							gint _tmp21_ = 0;
							gint _tmp22_ = 0;
							Tile* _tmp23_ = NULL;
							Tile* _tmp24_ = NULL;
							TileImage* image = NULL;
							Tile* _tmp25_ = NULL;
							TileImage* _tmp26_ = NULL;
							TileImage* _tmp27_ = NULL;
							gint _tmp28_ = 0;
							gint _tmp29_ = 0;
							GHashTable* _tmp30_ = NULL;
							Tile* _tmp31_ = NULL;
							Tile* _tmp32_ = NULL;
							TileImage* _tmp33_ = NULL;
							TileImage* _tmp34_ = NULL;
#line 59 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							if (!_tmp12_) {
#line 3283 "puzzle-view.c"
								gint _tmp13_ = 0;
#line 59 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
								_tmp13_ = x;
#line 59 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
								x = _tmp13_ + 1;
#line 3289 "puzzle-view.c"
							}
#line 59 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp12_ = FALSE;
#line 59 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp14_ = x;
#line 59 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp15_ = puzzle_view_get_puzzle (self);
#line 59 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp16_ = _tmp15_;
#line 59 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp17_ = puzzle_get_size (_tmp16_);
#line 59 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp18_ = _tmp17_;
#line 59 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							if (!(((guint) _tmp14_) < (_tmp18_ * 2))) {
#line 59 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
								break;
#line 3307 "puzzle-view.c"
							}
#line 61 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp19_ = puzzle_view_get_puzzle (self);
#line 61 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp20_ = _tmp19_;
#line 61 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp21_ = x;
#line 61 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp22_ = y;
#line 61 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp23_ = puzzle_get_tile (_tmp20_, (guint) _tmp21_, (guint) _tmp22_);
#line 61 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							tile = _tmp23_;
#line 62 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp24_ = tile;
#line 62 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							if (_tmp24_ == NULL) {
#line 63 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
								_g_object_unref0 (tile);
#line 63 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
								continue;
#line 3329 "puzzle-view.c"
							}
#line 65 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp25_ = tile;
#line 65 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp26_ = tile_image_new (_tmp25_);
#line 65 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							image = _tmp26_;
#line 66 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp27_ = image;
#line 66 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp28_ = x;
#line 66 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp29_ = y;
#line 66 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							puzzle_view_move_tile_to_location (self, _tmp27_, (guint) _tmp28_, (guint) _tmp29_, (gdouble) 0);
#line 67 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp30_ = self->priv->tiles;
#line 67 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp31_ = tile;
#line 67 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp32_ = _g_object_ref0 (_tmp31_);
#line 67 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp33_ = image;
#line 67 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp34_ = _g_object_ref0 (_tmp33_);
#line 67 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							g_hash_table_insert (_tmp30_, _tmp32_, _tmp34_);
#line 59 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_g_object_unref0 (image);
#line 59 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_g_object_unref0 (tile);
#line 3361 "puzzle-view.c"
						}
					}
				}
			}
		}
	}
#line 70 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp35_ = self->priv->_puzzle;
#line 70 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	g_signal_connect_object (_tmp35_, "tile-moved", (GCallback) _puzzle_view_tile_moved_cb_puzzle_tile_moved, self, 0);
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp36_ = self->priv->_puzzle;
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	g_signal_connect_object (_tmp36_, "paused-changed", (GCallback) __puzzle_view_puzzle___lambda4__puzzle_paused_changed, self, 0);
#line 72 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	gtk_widget_queue_resize ((GtkWidget*) self);
#line 51 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	g_object_notify ((GObject *) self, "puzzle");
#line 3380 "puzzle-view.c"
}


gboolean puzzle_view_get_game_in_progress (PuzzleView* self) {
	gboolean result;
	Puzzle* _tmp0_ = NULL;
	Puzzle* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
#line 110 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 112 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp0_ = puzzle_view_get_puzzle (self);
#line 112 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp1_ = _tmp0_;
#line 112 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp2_ = puzzle_get_is_solved (_tmp1_);
#line 112 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_tmp3_ = _tmp2_;
#line 112 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	if (_tmp3_) {
#line 113 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		result = FALSE;
#line 113 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		return result;
#line 3406 "puzzle-view.c"
	}
	{
		guint y = 0U;
#line 115 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		y = (guint) 0;
#line 3412 "puzzle-view.c"
		{
			gboolean _tmp4_ = FALSE;
#line 115 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			_tmp4_ = TRUE;
#line 115 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
			while (TRUE) {
#line 3419 "puzzle-view.c"
				guint _tmp6_ = 0U;
				Puzzle* _tmp7_ = NULL;
				Puzzle* _tmp8_ = NULL;
				guint _tmp9_ = 0U;
				guint _tmp10_ = 0U;
#line 115 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
				if (!_tmp4_) {
#line 3427 "puzzle-view.c"
					guint _tmp5_ = 0U;
#line 115 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
					_tmp5_ = y;
#line 115 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
					y = _tmp5_ + 1;
#line 3433 "puzzle-view.c"
				}
#line 115 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
				_tmp4_ = FALSE;
#line 115 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
				_tmp6_ = y;
#line 115 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
				_tmp7_ = puzzle_view_get_puzzle (self);
#line 115 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
				_tmp8_ = _tmp7_;
#line 115 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
				_tmp9_ = puzzle_get_size (_tmp8_);
#line 115 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
				_tmp10_ = _tmp9_;
#line 115 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
				if (!(_tmp6_ < _tmp10_)) {
#line 115 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
					break;
#line 3451 "puzzle-view.c"
				}
				{
					guint x = 0U;
					Puzzle* _tmp11_ = NULL;
					Puzzle* _tmp12_ = NULL;
					guint _tmp13_ = 0U;
					guint _tmp14_ = 0U;
#line 117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
					_tmp11_ = puzzle_view_get_puzzle (self);
#line 117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
					_tmp12_ = _tmp11_;
#line 117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
					_tmp13_ = puzzle_get_size (_tmp12_);
#line 117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
					_tmp14_ = _tmp13_;
#line 117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
					x = _tmp14_;
#line 3469 "puzzle-view.c"
					{
						gboolean _tmp15_ = FALSE;
#line 117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
						_tmp15_ = TRUE;
#line 117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
						while (TRUE) {
#line 3476 "puzzle-view.c"
							guint _tmp17_ = 0U;
							Puzzle* _tmp18_ = NULL;
							Puzzle* _tmp19_ = NULL;
							guint _tmp20_ = 0U;
							guint _tmp21_ = 0U;
							Puzzle* _tmp22_ = NULL;
							Puzzle* _tmp23_ = NULL;
							guint _tmp24_ = 0U;
							guint _tmp25_ = 0U;
							Tile* _tmp26_ = NULL;
							Tile* _tmp27_ = NULL;
							gboolean _tmp28_ = FALSE;
#line 117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							if (!_tmp15_) {
#line 3491 "puzzle-view.c"
								guint _tmp16_ = 0U;
#line 117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
								_tmp16_ = x;
#line 117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
								x = _tmp16_ + 1;
#line 3497 "puzzle-view.c"
							}
#line 117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp15_ = FALSE;
#line 117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp17_ = x;
#line 117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp18_ = puzzle_view_get_puzzle (self);
#line 117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp19_ = _tmp18_;
#line 117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp20_ = puzzle_get_size (_tmp19_);
#line 117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp21_ = _tmp20_;
#line 117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							if (!(_tmp17_ < (_tmp21_ * 2))) {
#line 117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
								break;
#line 3515 "puzzle-view.c"
							}
#line 119 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp22_ = puzzle_view_get_puzzle (self);
#line 119 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp23_ = _tmp22_;
#line 119 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp24_ = x;
#line 119 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp25_ = y;
#line 119 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp26_ = puzzle_get_tile (_tmp23_, _tmp24_, _tmp25_);
#line 119 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp27_ = _tmp26_;
#line 119 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_tmp28_ = _tmp27_ == NULL;
#line 119 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							_g_object_unref0 (_tmp27_);
#line 119 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
							if (_tmp28_) {
#line 120 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
								result = TRUE;
#line 120 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
								return result;
#line 3539 "puzzle-view.c"
							}
						}
					}
				}
			}
		}
	}
#line 123 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	result = FALSE;
#line 123 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	return result;
#line 3551 "puzzle-view.c"
}


static void puzzle_view_class_init (PuzzleViewClass * klass) {
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	puzzle_view_parent_class = g_type_class_peek_parent (klass);
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	g_type_class_add_private (klass, sizeof (PuzzleViewPrivate));
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	((GtkWidgetClass *) klass)->get_preferred_width = puzzle_view_real_get_preferred_width;
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	((GtkWidgetClass *) klass)->get_preferred_height = puzzle_view_real_get_preferred_height;
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	((GtkWidgetClass *) klass)->configure_event = puzzle_view_real_configure_event;
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	((GtkWidgetClass *) klass)->draw = puzzle_view_real_draw;
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	((GtkWidgetClass *) klass)->button_press_event = puzzle_view_real_button_press_event;
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	((GtkWidgetClass *) klass)->button_release_event = puzzle_view_real_button_release_event;
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	((GtkWidgetClass *) klass)->motion_notify_event = puzzle_view_real_motion_notify_event;
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_puzzle_view_get_property;
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_puzzle_view_set_property;
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	G_OBJECT_CLASS (klass)->finalize = puzzle_view_finalize;
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), PUZZLE_VIEW_PUZZLE, g_param_spec_object ("puzzle", "puzzle", "puzzle", TYPE_PUZZLE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), PUZZLE_VIEW_GAME_IN_PROGRESS, g_param_spec_boolean ("game-in-progress", "game-in-progress", "game-in-progress", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 3584 "puzzle-view.c"
}


static void puzzle_view_instance_init (PuzzleView * self) {
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	self->priv = PUZZLE_VIEW_GET_PRIVATE (self);
#line 47 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	self->priv->_puzzle = NULL;
#line 80 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	self->priv->selected_tile = NULL;
#line 83 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	self->priv->selection_timeout = (guint) 0;
#line 94 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	self->priv->animation_timeout = (guint) 0;
#line 3599 "puzzle-view.c"
}


static void puzzle_view_finalize (GObject* obj) {
	PuzzleView * self;
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PUZZLE_VIEW, PuzzleView);
#line 47 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_g_object_unref0 (self->priv->_puzzle);
#line 77 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_g_object_unref0 (self->priv->theme);
#line 80 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_g_object_unref0 (self->priv->selected_tile);
#line 90 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_g_hash_table_unref0 (self->priv->tiles);
#line 93 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	_g_timer_destroy0 (self->priv->animation_timer);
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	G_OBJECT_CLASS (puzzle_view_parent_class)->finalize (obj);
#line 3619 "puzzle-view.c"
}


GType puzzle_view_get_type (void) {
	static volatile gsize puzzle_view_type_id__volatile = 0;
	if (g_once_init_enter (&puzzle_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PuzzleViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) puzzle_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PuzzleView), 0, (GInstanceInitFunc) puzzle_view_instance_init, NULL };
		GType puzzle_view_type_id;
		puzzle_view_type_id = g_type_register_static (gtk_drawing_area_get_type (), "PuzzleView", &g_define_type_info, 0);
		g_once_init_leave (&puzzle_view_type_id__volatile, puzzle_view_type_id);
	}
	return puzzle_view_type_id__volatile;
}


static void _vala_puzzle_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	PuzzleView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PUZZLE_VIEW, PuzzleView);
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	switch (property_id) {
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		case PUZZLE_VIEW_PUZZLE:
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		g_value_set_object (value, puzzle_view_get_puzzle (self));
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		break;
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		case PUZZLE_VIEW_GAME_IN_PROGRESS:
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		g_value_set_boolean (value, puzzle_view_get_game_in_progress (self));
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		break;
#line 3652 "puzzle-view.c"
		default:
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		break;
#line 3658 "puzzle-view.c"
	}
}


static void _vala_puzzle_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	PuzzleView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PUZZLE_VIEW, PuzzleView);
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
	switch (property_id) {
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		case PUZZLE_VIEW_PUZZLE:
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		puzzle_view_set_puzzle (self, g_value_get_object (value));
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		break;
#line 3674 "puzzle-view.c"
		default:
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-tetravex/src/puzzle-view.vala"
		break;
#line 3680 "puzzle-view.c"
	}
}



