//**************************************************************************************************
//                                        App_gSpiceUI.hpp                                         *
//                                       ------------------                                        *
// Description : The main application class. It all begins here.                                   *
// Started     : 2003-08-15                                                                        *
// Last Update : 2015-01-05                                                                        *
// Copyright   : (C) 2003 by MSWaters                                                              *
//**************************************************************************************************

//**************************************************************************************************
//                                                                                                 *
//      This program is free software; you can redistribute it and/or modify it under the          *
//      terms of the GNU General Public License as published by the Free Software Foundation;      *
//      either version 3 of the License, or (at your option) any later version.                    *
//                                                                                                 *
//**************************************************************************************************

#ifndef APP_GSPICEUI_HPP
#define APP_GSPICEUI_HPP

// System includes

//#include <iostream>

// In the following include using <locale.h> instead of <clocale> at the request of a user running
// Solaris 9 on a Ultra SPARC and Sun's C++ compiler.
//#include <locale.h> ???

// Application includes

#include "CmdLinePcr.hpp"
#include "main/FrmMain.hpp"

// wxWidgets includes

#include <wx/config.h>

// This flag indicates debug mode, if it's enabled gspiceui will produce lots of lovely console spew
bool  g_bDebug;

//**************************************************************************************************

class App_gSpiceUI : public wxApp
{
  private :

    wxLocale    m_oLocale;
    CmdLinePcr  m_oCmdLnPcr;
    FrmMain   * m_poFrmMain;

  public :

    App_gSpiceUI( void );
   ~App_gSpiceUI( );

    // Event handlers
    virtual  bool  OnInit  ( void );
//  virtual  int   OnRun   ( void );
//  virtual  int   MainLoop( void );
    virtual  int   OnExit  ( void );

    // Leave this as the last line as private access is envoked by this macro
//  wxDECLARE_EVENT_TABLE( );
};

//**************************************************************************************************

#endif // APP_GSPICEUI_HPP
