#
# Copyright by The HDF Group.
# All rights reserved.
#
# This file is part of HDF5.  The full HDF5 copyright notice, including
# terms governing use, modification, and redistribution, is contained in
# the COPYING file, which can be found at the root of the source code
# distribution tree, or in https://www.hdfgroup.org/licenses.
# If you do not have access to either file, you may request a copy from
# help@hdfgroup.org.
#
option (USE_LIBAEC "Use AEC library as SZip Filter" OFF)
option (USE_LIBAEC_STATIC "Use static AEC library " OFF)
option (ZLIB_USE_EXTERNAL "Use External Library Building for ZLIB" 0)
option (SZIP_USE_EXTERNAL "Use External Library Building for SZIP" 0)

option (BUILD_ZLIB_WITH_FETCHCONTENT "Use FetchContent to use original source files" OFF)
if (BUILD_ZLIB_WITH_FETCHCONTENT)
  set (ZLIB_USE_EXTERNAL "Use External Library Building for ZLIB" 1)
  if (NOT ZLIB_USE_LOCALCONTENT)
    set (ZLIB_URL ${ZLIB_TGZ_ORIGPATH}/${ZLIB_TGZ_ORIGNAME})
  else ()
    set (ZLIB_URL ${TGZPATH}/${ZLIB_TGZ_ORIGNAME})
  endif ()
  if (CMAKE_VERSION VERSION_GREATER_EQUAL "3.15.0")
    message (VERBOSE "Filter ZLIB file is ${ZLIB_URL}")
  endif ()
endif ()

option (BUILD_SZIP_WITH_FETCHCONTENT "Use FetchContent to use original source files" OFF)
if (BUILD_SZIP_WITH_FETCHCONTENT)
  # Only libaec library is usable
  set (USE_LIBAEC ON CACHE BOOL "Use libaec szip replacement" FORCE)
  set (SZIP_USE_EXTERNAL "Use External Library Building for SZIP" 1)
  if (NOT LIBAEC_USE_LOCALCONTENT)
    set (SZIP_URL ${LIBAEC_TGZ_ORIGPATH}/${LIBAEC_TGZ_ORIGNAME})
  else ()
    set (SZIP_URL ${TGZPATH}/${LIBAEC_TGZ_ORIGNAME})
  endif ()
  if (CMAKE_VERSION VERSION_GREATER_EQUAL "3.15.0")
    message (VERBOSE "Filter SZIP file is ${SZIP_URL}")
  endif ()
endif ()

include (ExternalProject)
#option (HDF5_ALLOW_EXTERNAL_SUPPORT "Allow External Library Building (NO GIT TGZ)" "NO")
set (HDF5_ALLOW_EXTERNAL_SUPPORT "NO" CACHE STRING "Allow External Library Building (NO GIT TGZ)")
set_property (CACHE HDF5_ALLOW_EXTERNAL_SUPPORT PROPERTY STRINGS NO GIT TGZ)
if (HDF5_ALLOW_EXTERNAL_SUPPORT MATCHES "GIT" OR HDF5_ALLOW_EXTERNAL_SUPPORT MATCHES "TGZ")
  set (ZLIB_USE_EXTERNAL "Use External Library Building for ZLIB" 1)
  set (SZIP_USE_EXTERNAL "Use External Library Building for SZIP" 1)
  if (HDF5_ALLOW_EXTERNAL_SUPPORT MATCHES "GIT")
    set (ZLIB_URL ${ZLIB_GIT_URL} CACHE STRING "Path to zlib git repository")
    set (ZLIB_BRANCH ${ZLIB_GIT_BRANCH})
    set (SZIP_URL ${SZIP_GIT_URL} CACHE STRING "Path to szip git repository")
    set (SZIP_BRANCH ${SZIP_GIT_BRANCH})
  elseif (HDF5_ALLOW_EXTERNAL_SUPPORT MATCHES "TGZ")
    if (NOT TGZPATH)
      set (TGZPATH ${HDF5_SOURCE_DIR})
    endif ()
    if (NOT BUILD_ZLIB_WITH_FETCHCONTENT)
      set (ZLIB_URL ${TGZPATH}/${ZLIB_TGZ_NAME})
    endif ()
    if (NOT EXISTS "${ZLIB_URL}")
      set (HDF5_ENABLE_Z_LIB_SUPPORT OFF CACHE BOOL "" FORCE)
      if (CMAKE_VERSION VERSION_GREATER_EQUAL "3.15.0")
        message (VERBOSE "Filter ZLIB file ${ZLIB_URL} not found")
      endif ()
    endif ()
    if (NOT BUILD_SZIP_WITH_FETCHCONTENT)
      set (SZIP_URL ${TGZPATH}/${SZIP_TGZ_NAME})
      if (USE_LIBAEC)
        set (SZIP_URL ${TGZPATH}/${SZAEC_TGZ_NAME})
      endif ()
    endif ()
    if (NOT EXISTS "${SZIP_URL}")
      set (HDF5_ENABLE_SZIP_SUPPORT OFF CACHE BOOL "" FORCE)
      if (CMAKE_VERSION VERSION_GREATER_EQUAL "3.15.0")
        message (VERBOSE "Filter SZIP file ${SZIP_URL} not found")
      endif ()
    endif ()
  else ()
    set (ZLIB_USE_EXTERNAL 0)
    set (SZIP_USE_EXTERNAL 0)
  endif ()
endif ()

#-----------------------------------------------------------------------------
# Option for ZLib support
#-----------------------------------------------------------------------------
option (HDF5_ENABLE_Z_LIB_SUPPORT "Enable Zlib Filters" OFF)
if (HDF5_ENABLE_Z_LIB_SUPPORT)
  if (NOT H5_ZLIB_HEADER)
    if (NOT ZLIB_USE_EXTERNAL)
      find_package (ZLIB NAMES ${ZLIB_PACKAGE_NAME}${HDF_PACKAGE_EXT} COMPONENTS static shared)
      if (NOT ZLIB_FOUND)
        find_package (ZLIB) # Legacy find
      endif ()
      if (ZLIB_FOUND)
        set (H5_HAVE_FILTER_DEFLATE 1)
        set (H5_HAVE_ZLIB_H 1)
        set (H5_HAVE_LIBZ 1)
        set (H5_ZLIB_HEADER "zlib.h")
        set (ZLIB_INCLUDE_DIR_GEN ${ZLIB_INCLUDE_DIR})
        set (ZLIB_INCLUDE_DIRS ${ZLIB_INCLUDE_DIRS} ${ZLIB_INCLUDE_DIR})
        set (LINK_COMP_LIBS ${LINK_COMP_LIBS} ${ZLIB_LIBRARIES})
      endif ()
    else ()
      if (BUILD_ZLIB_WITH_FETCHCONTENT)
        # Only tgz files available
        ORIGINAL_ZLIB_LIBRARY ("TGZ")
        set (H5_HAVE_FILTER_DEFLATE 1)
        set (H5_HAVE_ZLIB_H 1)
        set (H5_HAVE_LIBZ 1)
        if (CMAKE_VERSION VERSION_GREATER_EQUAL "3.15.0")
          message (VERBOSE "HDF5_ZLIB is built from fetch content")
        endif ()
        set (LINK_COMP_LIBS ${LINK_COMP_LIBS} ${ZLIB_STATIC_LIBRARY})
      elseif (HDF5_ALLOW_EXTERNAL_SUPPORT MATCHES "GIT" OR HDF5_ALLOW_EXTERNAL_SUPPORT MATCHES "TGZ")
        EXTERNAL_ZLIB_LIBRARY (${HDF5_ALLOW_EXTERNAL_SUPPORT})
        set (H5_HAVE_FILTER_DEFLATE 1)
        set (H5_HAVE_ZLIB_H 1)
        set (H5_HAVE_LIBZ 1)
        if (CMAKE_VERSION VERSION_GREATER_EQUAL "3.15.0")
          message (VERBOSE "Filter HDF5_ZLIB is built")
        endif ()
        set (LINK_COMP_LIBS ${LINK_COMP_LIBS} ${ZLIB_STATIC_LIBRARY})
      else ()
        message (FATAL_ERROR " ZLib is Required for ZLib support in HDF5")
      endif ()
    endif ()
  else ()
    # This project is being called from within another and ZLib is already configured
    set (H5_HAVE_FILTER_DEFLATE 1)
    set (H5_HAVE_ZLIB_H 1)
    set (H5_HAVE_LIBZ 1)
  endif ()
  if (H5_HAVE_FILTER_DEFLATE)
    set (EXTERNAL_FILTERS "${EXTERNAL_FILTERS} DEFLATE")
  endif ()
  INCLUDE_DIRECTORIES (${ZLIB_INCLUDE_DIRS})
  if (CMAKE_VERSION VERSION_GREATER_EQUAL "3.15.0")
    message (VERBOSE "Filter HDF5_ZLIB is ON")
  endif ()
endif ()

#-----------------------------------------------------------------------------
# Option for SzLib support
#-----------------------------------------------------------------------------
option (HDF5_ENABLE_SZIP_SUPPORT "Use SZip Filter" OFF)
if (HDF5_ENABLE_SZIP_SUPPORT)
  option (HDF5_ENABLE_SZIP_ENCODING "Use SZip Encoding" OFF)
  if (NOT SZIP_USE_EXTERNAL)
    set(SZIP_FOUND FALSE)
    if (USE_LIBAEC)
      set(libaec_USE_STATIC_LIBS ${USE_LIBAEC_STATIC})
      find_package (libaec 1.0.5 CONFIG)
      if (SZIP_FOUND)
        set (LINK_COMP_LIBS ${LINK_COMP_LIBS} ${SZIP_LIBRARIES})
      endif ()
    endif ()
    if (NOT SZIP_FOUND)
      find_package (SZIP NAMES ${SZIP_PACKAGE_NAME}${HDF_PACKAGE_EXT} COMPONENTS static shared)
      if (NOT SZIP_FOUND)
        find_package (SZIP) # Legacy find
      endif ()
      if (SZIP_FOUND)
        set (H5_HAVE_FILTER_SZIP 1)
        set (H5_HAVE_SZLIB_H 1)
        set (H5_HAVE_LIBSZ 1)
        set (SZIP_INCLUDE_DIR_GEN ${SZIP_INCLUDE_DIR})
        set (SZIP_INCLUDE_DIRS ${SZIP_INCLUDE_DIRS} ${SZIP_INCLUDE_DIR})
        set (LINK_COMP_LIBS ${LINK_COMP_LIBS} ${SZIP_LIBRARIES})
      endif ()
    endif ()
  else ()
    if (BUILD_SZIP_WITH_FETCHCONTENT)
      # Only tgz files available
      ORIGINAL_SZIP_LIBRARY ("TGZ" ${HDF5_ENABLE_SZIP_ENCODING})
      set (H5_HAVE_FILTER_SZIP 1)
      set (H5_HAVE_SZLIB_H 1)
      set (H5_HAVE_LIBSZ 1)
      if (CMAKE_VERSION VERSION_GREATER_EQUAL "3.15.0")
        message (VERBOSE "SZIP is built from fetch content")
      endif ()
      if (USE_LIBAEC)
        if (CMAKE_VERSION VERSION_GREATER_EQUAL "3.15.0")
          message (VERBOSE "... with library AEC")
        endif ()
        set (SZIP_PACKAGE_NAME ${LIBAEC_PACKAGE_NAME})
      else ()
        set (SZIP_PACKAGE_NAME ${SZIP_PACKAGE_NAME})
      endif ()
      set (LINK_COMP_LIBS ${LINK_COMP_LIBS} ${SZIP_STATIC_LIBRARY})
    elseif (HDF5_ALLOW_EXTERNAL_SUPPORT MATCHES "GIT" OR HDF5_ALLOW_EXTERNAL_SUPPORT MATCHES "TGZ")
      EXTERNAL_SZIP_LIBRARY (${HDF5_ALLOW_EXTERNAL_SUPPORT} ${HDF5_ENABLE_SZIP_ENCODING})
      set (H5_HAVE_FILTER_SZIP 1)
      set (H5_HAVE_SZLIB_H 1)
      set (H5_HAVE_LIBSZ 1)
      if (CMAKE_VERSION VERSION_GREATER_EQUAL "3.15.0")
        message (VERBOSE "Filter SZIP is built")
      endif ()
      if (USE_LIBAEC)
        if (CMAKE_VERSION VERSION_GREATER_EQUAL "3.15.0")
          message (VERBOSE "... with library AEC")
        endif ()
        set (SZIP_PACKAGE_NAME ${LIBAEC_PACKAGE_NAME})
      else ()
        set (SZIP_PACKAGE_NAME ${SZIP_PACKAGE_NAME})
      endif ()
      set (LINK_COMP_LIBS ${LINK_COMP_LIBS} ${SZIP_STATIC_LIBRARY})
    else ()
      message (FATAL_ERROR "SZIP is Required for SZIP support in HDF5")
    endif ()
  endif ()
  INCLUDE_DIRECTORIES (${SZIP_INCLUDE_DIRS})
  if (CMAKE_VERSION VERSION_GREATER_EQUAL "3.15.0")
    message (VERBOSE "Filter SZIP is ON")
  endif ()
  if (H5_HAVE_FILTER_SZIP)
    set (EXTERNAL_FILTERS "${EXTERNAL_FILTERS} DECODE")
  endif ()
  if (HDF5_ENABLE_SZIP_ENCODING)
    set (H5_HAVE_SZIP_ENCODER 1)
    set (EXTERNAL_FILTERS "${EXTERNAL_FILTERS} ENCODE")
  endif ()
endif ()
