/***********************************************************************************

    Copyright (C) 2007-2020 Ahmet Öztürk (aoz_2@yahoo.com)

    This file is part of Lifeograph.

    Lifeograph is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Lifeograph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_WIDGET_ENTRYLIST_HEADER
#define LIFEOGRAPH_WIDGET_ENTRYLIST_HEADER


#include <gtkmm.h>

#include "../diarydata.hpp"
#include "../entry.hpp"


namespace LIFEO
{

class WidgetEntryList : public Gtk::TreeView
{
    public:
                                        WidgetEntryList( BaseObjectType*,
                                                         const Glib::RefPtr<Gtk::Builder>& );
                                        ~WidgetEntryList();

            void                        set_editable( bool );

            void                        clear();

            void                        present_element( const DiaryElement* );
            void                        expand_element( const DiaryElement* );
            void                        go_up( bool );
            void                        go_down( bool );
            void                        set_sorting_criteria( SortCriterion );

            Gtk::TreePath               find_element( const DiaryElement* ) const;

            // SORTING FUNCTIONS
            int                         sort_by_date( const Gtk::TreeModel::iterator&,
                                                      const Gtk::TreeModel::iterator& );
            int                         sort_by_name( const Gtk::TreeModel::iterator&,
                                                      const Gtk::TreeModel::iterator& );
            int                         sort_by_size( const Gtk::TreeModel::iterator&,
                                                      const Gtk::TreeModel::iterator& );
            int                         sort_by_change( const Gtk::TreeModel::iterator&,
                                                        const Gtk::TreeModel::iterator& );

            void                        cell_data_func_icon( Gtk::CellRenderer* cell,
                                                             const Gtk::TreeModel::iterator& iter );

            Gdk::Rectangle              get_item_rect( const DiaryElement* ) const;
            bool                        is_point_out_of_expander( const Gtk::TreePath&, int ) const;

            void                        do_for_each_selected_entry(
                                                const sigc::slot< void, Entry* >& );

            Glib::RefPtr< Gtk::TreeStore >
                                        m_treestore;

    protected:
            bool                        on_button_press_event( GdkEventButton* );
            bool                        on_button_release_event( GdkEventButton* );
            bool                        on_key_press_event( GdkEventKey* );

            void                        on_drag_begin(
                                            const Glib::RefPtr< Gdk::DragContext >& ) override;
            void                        on_drag_end(
                                            const Glib::RefPtr< Gdk::DragContext >& ) override;
            bool                        on_drag_motion( const Glib::RefPtr< Gdk::DragContext >&,
                                                        int, int, guint ) override;
            void                        on_drag_data_received(
                                            const Glib::RefPtr< Gdk::DragContext >&,
                                            int, int, const Gtk::SelectionData&,
                                            guint, guint ) override;

            void                        handle_selection_changed();

            bool                        on_test_expand_row( const Gtk::TreeIter&,
                                                            const Gtk::TreePath& ) override;
            bool                        on_test_collapse_row( const Gtk::TreeIter&,
                                                              const Gtk::TreePath& ) override;
            void                        on_row_expanded( const Gtk::TreeIter&,
                                                         const Gtk::TreePath& ) override;
            void                        on_row_collapsed( const Gtk::TreeIter&,
                                                          const Gtk::TreePath& ) override;
// tried to use it for filtering by tagged but did not work well:
            void                        on_row_activated( const Gtk::TreePath&,
                                                          Gtk::TreeViewColumn* ) override;

            bool                        make_path_deeper_last( Gtk::TreePath& );
            bool                        move_path_next( Gtk::TreePath& );

            // HELPER FUNCTION
            void                        move_entry_to_chapter( Entry*, Chapter* );

            class MultipleEntries : public DiaryElement
            {
                public:
                    Type                get_type() const
                    { return ET_MULTIPLE_ENTRIES; }
                    int                 get_size() const
                    { return 0; }
                    void                show() {}
                    const Icon&         get_icon32() const override;

                    VecEntries          m_entries;
            } m_multiple_entries;

            Column*                     m_TVC_main;
            Gtk::CellRendererPixbuf*    m_CRP_item_icon_primary;
            Gtk::CellRendererPixbuf*    m_CRP_item_icon_secondary;

            Entry*                      m_drop_target_last{ nullptr };
            Gtk::TreeViewDropPosition   m_drop_pos;
            bool                        m_flag_last_action_out_of_expander{ false };
            bool                        m_flag_editable{ false };

    friend class UIDiary;
};


} // end of namespace LIFEO

#endif
