package tests::ReportGroupInfoTest;

use strict;

use base qw/Lire::Test::TestCase/;

use Lire::Report::GroupInfo;

sub set_up {
    my $self = shift->SUPER::set_up();

    return $self;
}

sub tear_down {
    my $self = shift->SUPER::tear_down();

    return $self;
}

sub test_max_row_idx {
    my $self = $_[0];

    my $group = new Lire::Report::GroupInfo( bless ({},
                                                    'Lire::Report::GroupInfo'),
                                             'top' );
    $group->index( 0 );
    $group->row_idx( 0 );

    $self->assert_equals ( 0, $group->max_row_idx() );

    my $group1 = $group->create_group_info ( 'group1' );
    $self->assert_equals ( 1, $group->max_row_idx() );
    $self->assert_equals ( 1, $group1->max_row_idx() );

    my $group11 = $group1->create_group_info ( 'group11' );
    $self->assert_equals ( 2, $group->max_row_idx() );
    $self->assert_equals ( 2, $group1->max_row_idx() );
    $self->assert_equals ( 2, $group11->max_row_idx() );

    my $group12 = $group1->create_group_info ( 'group12' );
    $self->assert_equals ( 2, $group->max_row_idx() );
    $self->assert_equals ( 2, $group1->max_row_idx() );
    $self->assert_equals ( 2, $group11->max_row_idx() );
    $self->assert_equals ( 2, $group12->max_row_idx() );

    my $group111 = $group11->create_group_info ( 'group111' );
    $self->assert_equals ( 3, $group->max_row_idx() );
    $self->assert_equals ( 3, $group1->max_row_idx() );
    $self->assert_equals ( 3, $group11->max_row_idx() );
    $self->assert_equals ( 2, $group12->max_row_idx() );
    $self->assert_equals ( 3, $group111->max_row_idx() );
}

sub test_categorical_names {
    my $self = $_[0];

    my $group = new Lire::Report::GroupInfo( bless ({},
                                                    'Lire::Report::GroupInfo'),
                                             'top' );
    $group->index( 0 );
    $group->create_column_info( 'cell1', 'categorical', 'string' );
    $group->create_column_info( 'cell2', 'categorical', 'string' );
    $group->create_column_info( 'cell3', 'numerical', 'int' );

    $self->assert_deep_equals( [ 'cell1', 'cell2' ],
                               $group->categorical_names() );
}
1;
