/* main.hh - main function
 * Copyright 2003 Bas Wijnen <wijnen@debian.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef SHEVEK_MAINLOOP_HH
#define SHEVEK_MAINLOOP_HH

namespace shevek
{
  // convenience functions: start and stop the Glib main loop
  // don't use this, just use Gtk stuff, if you use gtk in your program.
  /// Start the Glib main loop.
  /** If you use Gtk, just use Gtk::Main::run instead.
   */
  void loop ();
  /// Tell the main loop to stop running when the current event is handled.
  /** There is no difference between this and Gtk::Main::quit.
   */
  void end_loop ();
}

#endif // defined SHEVEK_MAINLOOP_HH
