/*
    VLDocking Framework 2.1
    Copyright VLSOLUTIONS, 2004-2006

    email : info@vlsolutions.com
------------------------------------------------------------------------
This software is distributed under the CeCILL license, a GNU GPL-compatible
license adapted to french law.
French and English license headers are provided at the begining of
the source files of this software application.
------------------------------------------------------------------------
LICENCE CeCILL (FRENCH VERSION).
------------------------------------------------------------------------
Ce logiciel est un programme informatique servant  amliorer les interfaces
homme-machine d'applications Java bases sur Swing, en leur apportant un
ensemble de fonctions relatives au dockage des composants.

Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA
sur le site "http://www.cecill.info".

En contrepartie de l'accessibilit au code source et des droits de copie,
de modification et de redistribution accords par cette licence, il n'est
offert aux utilisateurs qu'une garantie limite.  Pour les mmes raisons,
seule une responsabilit restreinte pse sur l'auteur du programme,  le
titulaire des droits patrimoniaux et les concdants successifs.

A cet gard  l'attention de l'utilisateur est attire sur les risques
associs au chargement,   l'utilisation,   la modification et/ou au
dveloppement et  la reproduction du logiciel par l'utilisateur tant
donn sa spcificit de logiciel libre, qui peut le rendre complexe 
manipuler et qui le rserve donc  des dveloppeurs et des professionnels
avertis possdant  des  connaissances  informatiques approfondies.  Les
utilisateurs sont donc invits  charger  et  tester  l'adquation  du
logiciel  leurs besoins dans des conditions permettant d'assurer la
scurit de leurs systmes et ou de leurs donnes et, plus gnralement,
 l'utiliser et l'exploiter dans les mmes conditions de scurit.

Le fait que vous puissiez accder  cet en-tte signifie que vous avez
pris connaissance de la licence CeCILL, et que vous en avez accept les
termes.

------------------------------------------------------------------------
CeCILL License (ENGLISH VERSION)
------------------------------------------------------------------------

This software is a computer program whose purpose is to enhance Human-Computer
Interfaces written in Java with the Swing framework, providing them a set of
functions related to component docking.

This software is governed by the CeCILL  license under French law and
abiding by the rules of distribution of free software.  You can  use,
modify and/ or redistribute the software under the terms of the CeCILL
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info".

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability.

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or
data to be ensured and,  more generally, to use and operate it in the
same conditions as regards security.

The fact that you are presently reading this means that you have had
knowledge of the CeCILL license and that you accept its terms.

*/


package com.vlsolutions.swing.docking;
import java.awt.Window;


/** An abstract factory used by the <code>DockingDesktop</code> to create instance
 * of Dockable containers.
 * <p>
 * This factory enables API Extenders to change part of the behaviour on the DockingDesktop
 * (mostly about look and feel issues) without modifying the code of that central class.
 *
 * @see DockableContainer
 * @see DefaultDockableContainerFactory : the default implementation
 *
 * @author Lilian Chamontin, vlsolutions.
 * @version 1.1
 * @update 2007/01/08 Lilian Chamontin : updated to declare a new titlebar factory method
 * */
public abstract class DockableContainerFactory {

  private static DockableContainerFactory factory;
  
  /** Constant used to describe the type of usage a SingleDockableContainer is for*/
  public static final int PARENT_DESKTOP = 0;
  /** Constant used to describe the type of usage a SingleDockableContainer is for*/
  public static final int PARENT_TABBED_CONTAINER = 1;
  /** Constant used to describe the type of usage a SingleDockableContainer is for*/
  public static final int PARENT_SPLIT_CONTAINER = 2;

  /** Constant used to describe the type of usage a SingleDockableContainer is for*/
  public static final int PARENT_DETACHED_WINDOW = 3;
  

  /** This method is called by the DockingDesktop whenever a dockable is inserted
   * in its containment hierachy.
   *
   */
  public abstract SingleDockableContainer createDockableContainer(Dockable dockable, int parentType);
  
  /** @deprecated use the other createDockableContainer method ({@link #createDockableContainer(Dockable, int)} 
   */
  public SingleDockableContainer createDockableContainer(Dockable dockable, boolean c){
    return createDockableContainer(dockable, PARENT_SPLIT_CONTAINER);
  }

  /** This method is called when a tab insertion is requested by the DockingDesktop. */
  public abstract TabbedDockableContainer createTabbedDockableContainer();

  /** This method is called when a dockable is detached from the DockingDesktop and put 
   * in the FLOATING state. 
   *<p>
   * The floating container must be an instanceof Dialog or Window.
   */
  public abstract FloatingDockableContainer createFloatingDockableContainer(Window owner);
  
  /** This method is invoked when a dockable container needs to install a title bar.
   *<p> 
   * This method is used by the standard implementation of Docking (DockView, etc) but is optional 
   * for other implementations, as currently the titlebar isn't specified as a core component of 
   * the docking framework (i.e. it is not an interface).
   *@since 2.1.3
   */
  public abstract DockViewTitleBar createTitleBar();
  
  /** Returns the current factory.
   * <p> it no factory has been provided, it will
   * fall back on DefaultDockableContainerFactory
   */
  public static DockableContainerFactory getFactory(){
    if (factory == null){
      factory = new DefaultDockableContainerFactory();
    }
    return factory;
  }

  /** Changes the factory to be used by DockingDesktop.
   * <p>
   * Note that this change is not propagated to already docked components.
   * */
  public static void setFactory(DockableContainerFactory f){
     factory = f;
  }
  
  
}
