// Generated by LiveScript 1.4.0
(function(){
  var module, test, delay, Promise, timeLimitedPromise;
  module = QUnit.module, test = QUnit.test;
  module('core-js');
  delay = core.delay, Promise = core.Promise;
  timeLimitedPromise = function(time, fn){
    return Promise.race([
      new Promise(fn), new Promise(function(res, rej){
        setTimeout(rej, time);
      })
    ]);
  };
  test('delay', function(assert){
    assert.expect(3);
    assert.isFunction(delay);
    assert.ok(delay(42) instanceof Promise, 'returns promises');
    timeLimitedPromise(1e3, function(res){
      delay(10).then(function(it){
        res(it);
      });
    }).then(function(it){
      assert.ok(it === true, 'resolves as `true`');
    })['catch'](function(){
      assert.ok(false, 'rejected');
    }).then(assert.async());
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, Dict, Set, Symbol, ref$, keys, create, assign, make, from, toString$ = {}.toString;
  module = QUnit.module, test = QUnit.test;
  module('core-js');
  Dict = core.Dict, Set = core.Set, Symbol = core.Symbol;
  ref$ = core.Object, keys = ref$.keys, create = ref$.create, assign = ref$.assign, make = ref$.make;
  from = core.Array.from;
  test('Dict', function(assert){
    var dict1, dict2, dict3, done, iter;
    assert.isFunction(Dict);
    dict1 = Dict();
    assert.ok(!(dict1 instanceof Object));
    assert.deepEqual(keys(dict1), []);
    dict2 = Dict({
      q: 1,
      w: 2
    });
    assert.ok(!(dict2 instanceof Object));
    assert.deepEqual(keys(dict2), ['q', 'w']);
    assert.ok(dict2.q === 1);
    assert.ok(dict2.w === 2);
    dict3 = Dict(createIterable([[1, 1], [2, 2]]));
    assert.ok(!(dict3 instanceof Object));
    assert.deepEqual(keys(dict3), ['1', '2']);
    assert.ok(dict3[1] === 1);
    assert.ok(dict3[2] === 2);
    done = false;
    iter = createIterable([null, 1, 2], {
      'return': function(){
        done = true;
      }
    });
    try {
      new Dict(iter);
    } catch (e$) {}
    assert.ok(done, '.return #throw');
  });
  test('Dict.every', function(assert){
    var every, obj, ctx;
    every = Dict.every;
    assert.isFunction(every);
    every(obj = {
      q: 1
    }, function(val, key, that){
      assert.ok(val === 1);
      assert.ok(key === 'q');
      assert.ok(that === obj);
      assert.ok(this === ctx);
    }, ctx = {});
    assert.ok(every({
      q: 1,
      w: 2,
      e: 3
    }, function(it){
      return toString$.call(it).slice(8, -1) === 'Number';
    }));
    assert.ok(!every({
      q: 1,
      w: '2',
      e: 3
    }, function(it){
      return toString$.call(it).slice(8, -1) === 'Number';
    }));
  });
  test('Dict.filter', function(assert){
    var filter, obj, ctx;
    filter = Dict.filter;
    assert.isFunction(filter);
    filter(obj = {
      q: 1
    }, function(val, key, that){
      assert.ok(val === 1);
      assert.ok(key === 'q');
      assert.ok(that === obj);
      assert.ok(this === ctx);
    }, ctx = {});
    assert.deepEqual(filter({
      q: 1,
      w: 2,
      e: 3
    }, function(it){
      return it % 2;
    }), Dict({
      q: 1,
      e: 3
    }));
  });
  test('Dict.find', function(assert){
    var find, obj, ctx;
    find = Dict.find;
    assert.isFunction(find);
    find(obj = {
      q: 1
    }, function(val, key, that){
      assert.ok(val === 1);
      assert.ok(key === 'q');
      assert.ok(that === obj);
      assert.ok(this === ctx);
    }, ctx = {});
    assert.ok(find({
      q: 1,
      w: 2,
      e: 3
    }, function(it){
      return !(it % 2);
    }) === 2);
  });
  test('Dict.findKey', function(assert){
    var findKey, obj, ctx;
    findKey = Dict.findKey;
    assert.isFunction(findKey);
    findKey(obj = {
      q: 1
    }, function(val, key, that){
      assert.ok(val === 1);
      assert.ok(key === 'q');
      assert.ok(that === obj);
      assert.ok(this === ctx);
    }, ctx = {});
    assert.ok(findKey({
      q: 1,
      w: 2,
      e: 3
    }, function(it){
      return it === 2;
    }) === 'w');
  });
  test('Dict.forEach', function(assert){
    var forEach, obj, ctx, rez;
    forEach = Dict.forEach;
    assert.isFunction(forEach);
    forEach(obj = {
      q: 1
    }, function(val, key, that){
      assert.ok(val === 1);
      assert.ok(key === 'q');
      assert.ok(that === obj);
      assert.ok(this === ctx);
    }, ctx = {});
    rez = {};
    forEach({
      q: 1,
      w: 2
    }, function(){
      rez[arguments[1]] = arguments[0] + this;
    }, '_');
    assert.deepEqual(rez, {
      q: '1_',
      w: '2_'
    });
    rez = true;
    forEach(obj = {
      q: 1,
      w: 2
    }, function(){
      var rez;
      rez && (rez = obj === arguments[2]);
    });
    assert.ok(rez);
    rez = {};
    forEach(make({
      e: 3
    }, {
      q: 1,
      w: 2
    }), function(){
      rez[arguments[1]] = arguments[0];
    });
    assert.ok(!('e' in rez));
    rez = {};
    forEach([1, 2], function(){
      rez[arguments[1]] = arguments[0];
    });
    assert.ok(!('length' in rez));
    rez = {};
    forEach('123', function(){
      rez[arguments[1]] = arguments[0];
    });
    assert.ok('2' in rez);
  });
  test('Dict.keyOf', function(assert){
    var keyOf;
    keyOf = Dict.keyOf;
    assert.isFunction(keyOf);
    assert.ok(keyOf({
      q: 1,
      w: 2,
      e: 3
    }, 2) === 'w');
    assert.ok(keyOf({
      q: 1,
      w: 2,
      e: 3
    }, 4) === void 8);
    assert.ok(keyOf({
      q: 1,
      w: 2,
      e: NaN
    }, NaN) === void 8);
  });
  test('Dict.map', function(assert){
    var map, obj, ctx;
    map = Dict.map;
    assert.isFunction(map);
    map(obj = {
      q: 1
    }, function(val, key, that){
      assert.ok(val === 1);
      assert.ok(key === 'q');
      assert.ok(that === obj);
      assert.ok(this === ctx);
    }, ctx = {});
    assert.deepEqual(map({
      q: 1,
      w: 2,
      e: 3
    }, (function(it){
      return Math.pow(it, 2);
    })), Dict({
      q: 1,
      w: 4,
      e: 9
    }));
  });
  test('Dict.mapPairs', function(assert){
    var mapPairs, obj, ctx;
    mapPairs = Dict.mapPairs;
    assert.isFunction(mapPairs);
    mapPairs(obj = {
      q: 1
    }, function(val, key, that){
      assert.ok(val === 1);
      assert.ok(key === 'q');
      assert.ok(that === obj);
      assert.ok(this === ctx);
    }, ctx = {});
    assert.deepEqual(mapPairs({
      q: 1,
      w: 2,
      e: 3
    }, function(v, k){
      return v !== 2 && [k + k, v * v];
    }), Dict({
      qq: 1,
      ee: 9
    }));
  });
  test('Dict.reduce', function(assert){
    var reduce, obj, foo, memo;
    reduce = Dict.reduce;
    assert.isFunction(reduce);
    reduce(obj = {
      a: 1
    }, function(memo, val, key, that){
      assert.ok(memo === foo);
      assert.ok(val === 1);
      assert.ok(key === 'a');
      assert.ok(that === obj);
    }, foo = {});
    reduce({
      a: 1,
      b: 2
    }, function(memo, val, key){
      assert.ok(memo === 1);
      assert.ok(val === 2);
      assert.ok(key === 'b');
    });
    reduce({
      q: 1,
      w: 2,
      e: 3
    }, function(that, it){
      that[it] = it;
      return that;
    }, memo = {});
    assert.deepEqual(memo, {
      1: 1,
      2: 2,
      3: 3
    });
  });
  test('Dict.some', function(assert){
    var some, obj, ctx;
    some = Dict.some;
    assert.isFunction(some);
    some(obj = {
      q: 1
    }, function(val, key, that){
      assert.ok(val === 1);
      assert.ok(key === 'q');
      assert.ok(that === obj);
      assert.ok(this === ctx);
    }, ctx = {});
    assert.ok(!some({
      q: 1,
      w: 2,
      e: 3
    }, function(it){
      return toString$.call(it).slice(8, -1) === 'String';
    }));
    assert.ok(some({
      q: 1,
      w: '2',
      e: 3
    }, function(it){
      return toString$.call(it).slice(8, -1) === 'String';
    }));
  });
  test('Dict.includes', function(assert){
    var includes, dict, o;
    includes = Dict.includes;
    assert.isFunction(includes);
    dict = {
      q: 1,
      w: NaN,
      e: -0,
      r: o = {}
    };
    assert.ok(includes(dict, 1));
    assert.ok(includes(dict, -0));
    assert.ok(includes(dict, 0));
    assert.ok(includes(dict, NaN));
    assert.ok(includes(dict, o));
    assert.ok(!includes(dict, 4));
    assert.ok(!includes(dict, -0.5));
    assert.ok(!includes(dict, {}));
  });
  test('Dict.has', function(assert){
    var has;
    has = Dict.has;
    assert.isFunction(has);
    assert.ok(has({
      q: 1
    }, 'q'));
    assert.ok(!has({
      q: 1
    }, 'w'));
    assert.ok(has([1], 0));
    assert.ok(!has([], 0));
    assert.ok(!has(clone$({
      q: 1
    }), 'q'));
    assert.ok(!has({}, 'toString'));
  });
  test('Dict.get', function(assert){
    var get;
    get = Dict.get;
    assert.isFunction(get);
    assert.ok(get({
      q: 1
    }, 'q') === 1);
    assert.ok(get({
      q: 1
    }, 'w') === void 8);
    assert.ok(get([1], 0) === 1);
    assert.ok(get([], 0) === void 8);
    assert.ok(get(clone$({
      q: 1
    }), 'q') === void 8);
    assert.ok(get({}, 'toString') === void 8);
  });
  test('Dict.values', function(assert){
    var values, iter;
    values = Dict.values;
    assert.isFunction(values);
    iter = values({});
    assert.ok(iter[Symbol != null ? Symbol.toStringTag : void 8] === 'Dict Iterator');
    assert.isIterator(iter);
    assert.isIterable(iter);
    assert.deepEqual(from(values({
      q: 1,
      w: 2,
      e: 3
    })), [1, 2, 3]);
    assert.deepEqual(from(values(new String('qwe'))), ['q', 'w', 'e']);
    assert.deepEqual(from(values(assign(create({
      q: 1,
      w: 2,
      e: 3
    }), {
      a: 4,
      s: 5,
      d: 6
    }))), [4, 5, 6]);
  });
  test('Dict.keys', function(assert){
    var keys, iter;
    keys = Dict.keys;
    assert.isFunction(keys);
    iter = keys({});
    assert.ok(iter[Symbol != null ? Symbol.toStringTag : void 8] === 'Dict Iterator');
    assert.isIterator(iter);
    assert.isIterable(iter);
    assert.deepEqual(from(keys({
      q: 1,
      w: 2,
      e: 3
    })), ['q', 'w', 'e']);
    assert.deepEqual(from(keys(new String('qwe'))), ['0', '1', '2']);
    assert.deepEqual(from(keys(assign(create({
      q: 1,
      w: 2,
      e: 3
    }), {
      a: 4,
      s: 5,
      d: 6
    }))), ['a', 's', 'd']);
  });
  test('Dict.entries', function(assert){
    var entries, iter;
    entries = Dict.entries;
    assert.isFunction(entries);
    iter = entries({});
    assert.ok(iter[Symbol != null ? Symbol.toStringTag : void 8] === 'Dict Iterator');
    assert.isIterator(iter);
    assert.isIterable(iter);
    assert.deepEqual(from(entries({
      q: 1,
      w: 2,
      e: 3
    })), [['q', 1], ['w', 2], ['e', 3]]);
    assert.deepEqual(from(entries(new String('qwe'))), [['0', 'q'], ['1', 'w'], ['2', 'e']]);
    assert.deepEqual(from(entries(assign(create({
      q: 1,
      w: 2,
      e: 3
    }), {
      a: 4,
      s: 5,
      d: 6
    }))), [['a', 4], ['s', 5], ['d', 6]]);
  });
  function clone$(it){
    function fun(){} fun.prototype = it;
    return new fun;
  }
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, ref$, map, every, reduce, toString$ = {}.toString;
  module = QUnit.module, test = QUnit.test;
  module('core-js');
  ref$ = core.Array, map = ref$.map, every = ref$.every, reduce = ref$.reduce;
  test('Function#part', function(assert){
    var part, $, obj, fn, p;
    part = core.Function.part;
    $ = core._;
    assert.isFunction(part);
    assert.ok(part(function(it){
      return toString$.call(it).slice(8, -1) === 'String';
    }, 'qwe')());
    obj = {
      a: 42
    };
    obj.fn = part(function(it){
      return this.a + it;
    }, 21);
    assert.ok(obj.fn() === 63);
    fn = function(){
      return map(arguments, String).join(' ');
    };
    p = part(fn, $, 'Саша', $, 'шоссе', $, 'сосала');
    assert.isFunction(p, '.part with placeholders return function');
    assert.ok(p('Шла', 'по') === 'Шла Саша по шоссе undefined сосала', '.part with placeholders: args < placeholders');
    assert.ok(p('Шла', 'по', 'и') === 'Шла Саша по шоссе и сосала', '.part with placeholders: args == placeholders');
    assert.ok(p('Шла', 'по', 'и', 'сушку') === 'Шла Саша по шоссе и сосала сушку', '.part with placeholders: args > placeholders');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('core-js');
  test('core.getIteratorMethod', function(assert){
    var getIteratorMethod, iterable, iterFn;
    getIteratorMethod = core.getIteratorMethod;
    assert.isFunction(getIteratorMethod);
    iterable = createIterable([]);
    iterFn = getIteratorMethod(iterable);
    assert.isFunction(iterFn);
    assert.isIterator(iterFn.call(iterable));
    assert.isFunction(getIteratorMethod([]));
    assert.isFunction(getIteratorMethod(function(){
      return arguments;
    }()));
    assert.isFunction(getIteratorMethod(Array.prototype));
    assert.strictEqual(getIteratorMethod({}), void 8);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('core-js');
  test('core.getIterator', function(assert){
    var getIterator;
    getIterator = core.getIterator;
    assert.isFunction(getIterator);
    assert.isIterator(getIterator([]));
    assert.isIterator(getIterator(function(){
      return arguments;
    }()));
    assert.isIterator(getIterator(createIterable([])));
    assert.throws(function(){
      getIterator({});
    }, TypeError);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('core-js');
  test('core.isIterable', function(assert){
    var isIterable;
    isIterable = core.isIterable;
    assert.isFunction(isIterable);
    assert.ok(isIterable(createIterable([])));
    assert.ok(isIterable([]));
    assert.ok(isIterable(function(){
      return arguments;
    }()));
    assert.ok(isIterable(Array.prototype));
    assert.ok(!isIterable({}));
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('core-js');
  test('Number#@@iterator', function(assert){
    var getIterator, toStringTag, iter1, iter2, iter3, iter4, iter5, iter6;
    getIterator = core.getIterator;
    toStringTag = core.Symbol.toStringTag;
    iter1 = getIterator(2);
    assert.isIterator(iter1);
    assert.isIterable(iter1);
    assert.ok(iter1[toStringTag] === 'Number Iterator', '@@toStringTag');
    assert.deepEqual(iter1.next(), {
      done: false,
      value: 0
    }, '2 #1');
    assert.deepEqual(iter1.next(), {
      done: false,
      value: 1
    }, '2 #2');
    assert.deepEqual(iter1.next(), {
      done: true,
      value: void 8
    }, '2 #3');
    iter2 = getIterator(1.5);
    assert.deepEqual(iter2.next(), {
      done: false,
      value: 0
    }, '1.5 #1');
    assert.deepEqual(iter2.next(), {
      done: false,
      value: 1
    }, '1.5 #2');
    assert.deepEqual(iter2.next(), {
      done: true,
      value: void 8
    }, '1.5 #3');
    iter3 = getIterator(-1);
    assert.deepEqual(iter3.next(), {
      done: true,
      value: void 8
    }, '-1');
    iter4 = getIterator(NaN);
    assert.deepEqual(iter4.next(), {
      done: true,
      value: void 8
    }, 'NaN');
    iter5 = getIterator(Infinity);
    assert.deepEqual(iter5.next(), {
      done: false,
      value: 0
    }, 'Infinity #1');
    assert.deepEqual(iter5.next(), {
      done: false,
      value: 1
    }, 'Infinity #1');
    assert.deepEqual(iter5.next(), {
      done: false,
      value: 2
    }, 'Infinity #1');
    iter6 = getIterator(-Infinity);
    assert.deepEqual(iter6.next(), {
      done: true,
      value: void 8
    }, '-Infinity');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('core-js');
  test('Object.classof', function(assert){
    var classof, Class;
    classof = core.Object.classof;
    assert.isFunction(classof);
    assert.ok(classof(void 8) === 'Undefined', 'classof undefined is `Undefined`');
    assert.ok(classof(null) === 'Null', 'classof null is `Null`');
    assert.ok(classof(true) === 'Boolean', 'classof bool is `Boolean`');
    assert.ok(classof('string') === 'String', 'classof string is `String`');
    assert.ok(classof(7) === 'Number', 'classof number is `Number`');
    assert.ok(classof(core.Symbol()) === 'Symbol', 'classof symbol is `Symbol`');
    assert.ok(classof(new Boolean(false)) === 'Boolean', 'classof new Boolean is `Boolean`');
    assert.ok(classof(new String('')) === 'String', 'classof new String is `String`');
    assert.ok(classof(new Number(7)) === 'Number', 'classof new Number is `Number`');
    assert.ok(classof({}) === 'Object', 'classof {} is `Object`');
    assert.ok(classof([]) === 'Array', 'classof array is `Array`');
    assert.ok(classof(function(){}) === 'Function', 'classof function is `Function`');
    assert.ok(classof(/./) === 'RegExp', 'classof regexp is `Undefined`');
    assert.ok(classof(TypeError()) === 'Error', 'classof new TypeError is `RegExp`');
    assert.ok(classof(function(){
      return arguments;
    }()) === 'Arguments', 'classof arguments list is `Arguments`');
    assert.ok(classof(new core.Set) === 'Set', 'classof undefined is `Map`');
    assert.ok(classof(new core.Map) === 'Map', 'classof map is `Undefined`');
    assert.ok(classof(new core.WeakSet) === 'WeakSet', 'classof weakset is `WeakSet`');
    assert.ok(classof(new core.WeakMap) === 'WeakMap', 'classof weakmap is `WeakMap`');
    assert.ok(classof(new core.Promise(function(){})) === 'Promise', 'classof promise is `Promise`');
    assert.ok(classof(core.getIterator('')) === 'String Iterator', 'classof String Iterator is `String Iterator`');
    assert.ok(classof(core.getIterator([])) === 'Array Iterator', 'classof Array Iterator is `Array Iterator`');
    assert.ok(classof(new core.Set().entries()) === 'Set Iterator', 'classof Set Iterator is `Set Iterator`');
    assert.ok(classof(new core.Map().entries()) === 'Map Iterator', 'classof Map Iterator is `Map Iterator`');
    assert.ok(classof(Math) === 'Math', 'classof Math is `Math`');
    if (typeof JSON != 'undefined' && JSON !== null) {
      assert.ok(classof(JSON) === 'JSON', 'classof JSON is `JSON`');
    }
    Class = (function(){
      Class.displayName = 'Class';
      var prototype = Class.prototype, constructor = Class;
      Class.prototype[core.Symbol.toStringTag] = 'Class';
      function Class(){}
      return Class;
    }());
    assert.ok(classof(new Class) === 'Class', 'classof user class is [Symbol.toStringTag]');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('core-js');
  test('Object.define', function(assert){
    var ref$, define, defineProperty, foo, foo2;
    ref$ = core.Object, define = ref$.define, defineProperty = ref$.defineProperty;
    assert.isFunction(define);
    foo = {
      q: 1
    };
    assert.ok(foo === define(foo, {
      w: 2
    }));
    assert.ok(foo.w === 2);
    if (DESCRIPTORS) {
      foo = {
        q: 1
      };
      foo2 = defineProperty({}, 'w', {
        get: function(){
          return this.q + 1;
        }
      });
      define(foo, foo2);
      assert.ok(foo.w === 2);
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('core-js');
  test('Object.isObject', function(assert){
    var isObject;
    isObject = core.Object.isObject;
    assert.isFunction(isObject);
    assert.ok(!isObject(void 8), 'isObject undefined return false');
    assert.ok(!isObject(null), 'isObject null return false');
    assert.ok(!isObject(1), 'isObject number return false');
    assert.ok(!isObject(true), 'isObject bool return false');
    assert.ok(!isObject('string'), 'isObject string return false');
    assert.ok(isObject(new Number(1)), 'isObject new Number return true');
    assert.ok(isObject(new Boolean(false)), 'isObject new Boolean return true');
    assert.ok(isObject(new String(1)), 'isObject new String return true');
    assert.ok(isObject({}), 'isObject object return true');
    assert.ok(isObject([]), 'isObject array return true');
    assert.ok(isObject(/./), 'isObject regexp return true');
    assert.ok(isObject(function(){}), 'isObject function return true');
    assert.ok(isObject(new function(){}), 'isObject constructor instance return true');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('core-js');
  test('Object.make', function(assert){
    var make, object, foo;
    make = core.Object.make;
    assert.isFunction(make);
    object = make(foo = {
      q: 1
    }, {
      w: 2
    });
    assert.ok(core.Object.getPrototypeOf(object) === foo);
    assert.ok(object.w === 2);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('core-js');
  test('RegExp.escape', function(assert){
    var escape;
    escape = core.RegExp.escape;
    assert.isFunction(escape);
    assert.strictEqual(escape('qwe asd'), 'qwe asd', "Don't change simple string");
    assert.strictEqual(escape('\\[]{}()*+?.^$|'), '\\\\\\[\\]\\{\\}\\(\\)\\*\\+\\?\\.\\^\\$\\|', 'Escape all RegExp special chars');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('core-js');
  test('String#escapeHTML', function(assert){
    var escapeHTML;
    escapeHTML = core.String.escapeHTML;
    assert.isFunction(escapeHTML);
    assert.strictEqual(escapeHTML('qwe, asd'), 'qwe, asd');
    assert.strictEqual(escapeHTML('<div>qwe</div>'), '&lt;div&gt;qwe&lt;/div&gt;');
    assert.strictEqual(escapeHTML("&<>\"'"), '&amp;&lt;&gt;&quot;&apos;');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('core-js');
  test('String#unescapeHTML', function(assert){
    var unescapeHTML;
    unescapeHTML = core.String.unescapeHTML;
    assert.isFunction(unescapeHTML);
    assert.strictEqual(unescapeHTML('qwe, asd'), 'qwe, asd');
    assert.strictEqual(unescapeHTML('&lt;div&gt;qwe&lt;/div&gt;'), '<div>qwe</div>');
    assert.strictEqual(unescapeHTML('&amp;&lt;&gt;&quot;&apos;'), "&<>\"'");
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Array#copyWithin', function(assert){
    var copyWithin, a;
    copyWithin = core.Array.copyWithin;
    assert.isFunction(copyWithin);
    assert.strictEqual(a = copyWithin([1], 0), a);
    assert.deepEqual(copyWithin([1, 2, 3, 4, 5], 0, 3), [4, 5, 3, 4, 5]);
    assert.deepEqual(copyWithin([1, 2, 3, 4, 5], 1, 3), [1, 4, 5, 4, 5]);
    assert.deepEqual(copyWithin([1, 2, 3, 4, 5], 1, 2), [1, 3, 4, 5, 5]);
    assert.deepEqual(copyWithin([1, 2, 3, 4, 5], 2, 2), [1, 2, 3, 4, 5]);
    assert.deepEqual(copyWithin([1, 2, 3, 4, 5], 0, 3, 4), [4, 2, 3, 4, 5]);
    assert.deepEqual(copyWithin([1, 2, 3, 4, 5], 1, 3, 4), [1, 4, 3, 4, 5]);
    assert.deepEqual(copyWithin([1, 2, 3, 4, 5], 1, 2, 4), [1, 3, 4, 4, 5]);
    assert.deepEqual(copyWithin([1, 2, 3, 4, 5], 0, -2), [4, 5, 3, 4, 5]);
    assert.deepEqual(copyWithin([1, 2, 3, 4, 5], 0, -2, -1), [4, 2, 3, 4, 5]);
    assert.deepEqual(copyWithin([1, 2, 3, 4, 5], -4, -3, -2), [1, 3, 3, 4, 5]);
    assert.deepEqual(copyWithin([1, 2, 3, 4, 5], -4, -3, -1), [1, 3, 4, 4, 5]);
    assert.deepEqual(copyWithin([1, 2, 3, 4, 5], -4, -3), [1, 3, 4, 5, 5]);
    if (STRICT) {
      assert.throws(function(){
        copyWithin(null, 0);
      }, TypeError);
      assert.throws(function(){
        copyWithin(void 8, 0);
      }, TypeError);
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, toString$ = {}.toString;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Array#every', function(assert){
    var every, a, ctx, rez, arr;
    every = core.Array.every;
    assert.isFunction(every);
    every(a = [1], function(val, key, that){
      assert.same(arguments.length, 3, 'correct number of callback arguments');
      assert.same(val, 1, 'correct value in callback');
      assert.same(key, 0, 'correct index in callback');
      assert.same(that, a, 'correct link to array in callback');
      assert.same(this, ctx, 'correct callback context');
    }, ctx = {});
    assert.ok(every([1, 2, 3], function(it){
      return toString$.call(it).slice(8, -1) === 'Number';
    }));
    assert.ok(every([1, 2, 3], (function(it){
      return it < 4;
    })));
    assert.ok(!every([1, 2, 3], (function(it){
      return it < 3;
    })));
    assert.ok(!every([1, 2, 3], function(it){
      return toString$.call(it).slice(8, -1) === 'String';
    }));
    assert.ok(every([1, 2, 3], function(){
      return +this === 1;
    }, 1));
    rez = '';
    every([1, 2, 3], function(){
      return rez += arguments[1];
    });
    assert.ok(rez === '012');
    assert.ok(every(arr = [1, 2, 3], function(){
      return arguments[2] === arr;
    }));
    if (STRICT) {
      assert.throws(function(){
        every(null, function(){});
      }, TypeError);
      assert.throws(function(){
        every(void 8, function(){});
      }, TypeError);
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Array#fill', function(assert){
    var fill, a;
    fill = core.Array.fill;
    assert.isFunction(fill);
    assert.strictEqual(a = fill(Array(5), 5), a);
    assert.deepEqual(fill(Array(5), 5), [5, 5, 5, 5, 5]);
    assert.deepEqual(fill(Array(5), 5, 1), [void 8, 5, 5, 5, 5]);
    assert.deepEqual(fill(Array(5), 5, 1, 4), [void 8, 5, 5, 5, void 8]);
    assert.deepEqual(fill(Array(5), 5, 6, 1), [void 8, void 8, void 8, void 8, void 8]);
    assert.deepEqual(fill(Array(5), 5, -3, 4), [void 8, void 8, 5, 5, void 8]);
    if (STRICT) {
      assert.throws(function(){
        fill(null, 0);
      }, TypeError);
      assert.throws(function(){
        fill(void 8, 0);
      }, TypeError);
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Array#filter', function(assert){
    var filter, a, ctx;
    filter = core.Array.filter;
    assert.isFunction(filter);
    filter(a = [1], function(val, key, that){
      assert.same(arguments.length, 3, 'correct number of callback arguments');
      assert.same(val, 1, 'correct value in callback');
      assert.same(key, 0, 'correct index in callback');
      assert.same(that, a, 'correct link to array in callback');
      assert.same(this, ctx, 'correct callback context');
    }, ctx = {});
    assert.deepEqual([1, 2, 3, 4, 5], filter([1, 2, 3, 'q', {}, 4, true, 5], function(it){
      return typeof it === 'number';
    }));
    if (STRICT) {
      assert.throws(function(){
        filter(null, function(){});
      }, TypeError);
      assert.throws(function(){
        filter(void 8, function(){});
      }, TypeError);
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Array#findIndex', function(assert){
    var findIndex, arr, ctx;
    findIndex = core.Array.findIndex;
    assert.isFunction(findIndex);
    findIndex(arr = [1], function(val, key, that){
      assert.strictEqual(this, ctx);
      assert.strictEqual(val, 1);
      assert.strictEqual(key, 0);
      assert.strictEqual(that, arr);
    }, ctx = {});
    assert.strictEqual(findIndex([1, 3, NaN, 42, {}], (function(it){
      return it === 42;
    })), 3);
    if (STRICT) {
      assert.throws(function(){
        findIndex(null, 0);
      }, TypeError);
      assert.throws(function(){
        findIndex(void 8, 0);
      }, TypeError);
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Array#find', function(assert){
    var find, arr, ctx;
    find = core.Array.find;
    assert.isFunction(find);
    find(arr = [1], function(val, key, that){
      assert.strictEqual(this, ctx);
      assert.strictEqual(val, 1);
      assert.strictEqual(key, 0);
      assert.strictEqual(that, arr);
    }, ctx = {});
    assert.strictEqual(find([1, 3, NaN, 42, {}], (function(it){
      return it === 42;
    })), 42);
    assert.strictEqual(find([1, 3, NaN, 42, {}], (function(it){
      return it === 43;
    })), void 8);
    if (STRICT) {
      assert.throws(function(){
        find(null, 0);
      }, TypeError);
      assert.throws(function(){
        find(void 8, 0);
      }, TypeError);
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Array#forEach', function(assert){
    var forEach, a, ctx, rez, arr;
    forEach = core.Array.forEach;
    assert.isFunction(forEach);
    forEach(a = [1], function(val, key, that){
      assert.same(arguments.length, 3, 'correct number of callback arguments');
      assert.same(val, 1, 'correct value in callback');
      assert.same(key, 0, 'correct index in callback');
      assert.same(that, a, 'correct link to array in callback');
      assert.same(this, ctx, 'correct callback context');
    }, ctx = {});
    rez = '';
    forEach([1, 2, 3], function(it){
      rez += it;
    });
    assert.ok(rez === '123');
    rez = '';
    forEach([1, 2, 3], function(){
      rez += arguments[1];
    });
    assert.ok(rez === '012');
    rez = '';
    forEach([1, 2, 3], function(){
      rez += arguments[2];
    });
    assert.ok(rez === '1,2,31,2,31,2,3');
    rez = '';
    forEach([1, 2, 3], function(){
      rez += this;
    }, 1);
    assert.ok(rez === '111');
    rez = '';
    arr = [];
    arr[5] = '';
    forEach(arr, function(arg$, k){
      rez += k;
    });
    assert.ok(rez === '5');
    if (STRICT) {
      assert.throws(function(){
        forEach(null, function(){});
      }, TypeError);
      assert.throws(function(){
        forEach(void 8, function(){});
      }, TypeError);
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Array.from', function(assert){
    var ref$, from, isArray, defineProperty, iterator, type, col, ctx, i$, x$, len$, y$, done, iter, F, inst, a, array, called;
    ref$ = core.Array, from = ref$.from, isArray = ref$.isArray;
    defineProperty = core.Object.defineProperty;
    iterator = core.Symbol.iterator;
    assert.isFunction(from);
    assert.arity(from, 1);
    for (type in ref$ = {
      'array-like': {
        length: '3',
        0: '1',
        1: '2',
        2: '3'
      },
      arguments: fn$('1', '2', '3'),
      array: ['1', '2', '3'],
      iterable: createIterable(['1', '2', '3']),
      string: '123'
    }) {
      col = ref$[type];
      assert.arrayEqual(from(col), ['1', '2', '3'], "Works with " + type);
      assert.arrayEqual(from(col, (fn1$)), [1, 4, 9], "Works with " + type + "  + mapFn");
    }
    for (type in ref$ = {
      'array-like': {
        length: 1,
        0: 1
      },
      arguments: fn2$(1),
      array: [1],
      iterable: createIterable([1]),
      string: '1'
    }) {
      col = ref$[type];
      assert.arrayEqual(from(col, fn3$, ctx = {}), [42], "Works with " + type + ", correct result");
    }
    for (i$ = 0, len$ = (ref$ = [false, true, 0]).length; i$ < len$; ++i$) {
      x$ = ref$[i$];
      assert.arrayEqual(from(x$), [], "Works with " + x$);
    }
    for (i$ = 0, len$ = (ref$ = [null, void 8]).length; i$ < len$; ++i$) {
      y$ = ref$[i$];
      assert.throws(fn4$, TypeError, "Throws on " + y$);
    }
    assert.arrayEqual(from('𠮷𠮷𠮷'), ['𠮷', '𠮷', '𠮷'], 'Uses correct string iterator');
    done = true;
    iter = createIterable([1, 2, 3], {
      'return': function(){
        return done = false;
      }
    });
    from(iter, function(){
      return false;
    });
    assert.ok(done, '.return #default');
    done = false;
    iter = createIterable([1, 2, 3], {
      'return': function(){
        return done = true;
      }
    });
    try {
      from(iter, function(){
        throw 42;
      });
    } catch (e$) {}
    assert.ok(done, '.return #throw');
    F = function(){};
    inst = from.call(F, createIterable([1, 2]));
    assert.ok(inst instanceof F, 'generic, iterable case, instanceof');
    assert.arrayEqual(inst, [1, 2], 'generic, iterable case, elements');
    inst = from.call(F, {
      0: 1,
      1: 2,
      length: 2
    });
    assert.ok(inst instanceof F, 'generic, array-like case, instanceof');
    assert.arrayEqual(inst, [1, 2], 'generic, array-like case, elements');
    a = [1, 2, 3];
    done = false;
    a['@@iterator'] = void 8;
    a[iterator] = function(){
      done = true;
      return core.getIteratorMethod([]).call(this);
    };
    assert.arrayEqual(from(a), [1, 2, 3], 'Array with custom iterator, elements');
    assert.ok(done, 'call @@iterator in Array with custom iterator');
    array = [1, 2, 3];
    delete array[1];
    assert.arrayEqual(from(array, String), ['1', 'undefined', '3'], 'Ignores holes');
    assert.ok((function(){
      try {
        return from({
          length: -1,
          0: 1
        }, function(){
          throw 42;
        });
      } catch (e$) {}
    }()), 'Uses ToLength');
    assert.arrayEqual(from([], undefined), [], "Works with undefined as asecond argument");
    assert.throws(function(){
      from([], null);
    }, TypeError, "Throws with null as second argument");
    assert.throws(function(){
      from([], 0);
    }, TypeError, "Throws with 0 as second argument");
    assert.throws(function(){
      from([], '');
    }, TypeError, "Throws with '' as second argument");
    assert.throws(function(){
      from([], false);
    }, TypeError, "Throws with false as second argument");
    assert.throws(function(){
      from([], {});
    }, TypeError, "Throws with {} as second argument");
    if (DESCRIPTORS) {
      called = false;
      F = function(){};
      defineProperty(F.prototype, 0, {
        set: function(){
          var called;
          called = true;
        }
      });
      from.call(F, [1, 2, 3]);
      assert.ok(!called, 'Should not call prototype accessors');
    }
    function fn$(){
      return arguments;
    }
    function fn1$(it){
      return Math.pow(it, 2);
    }
    function fn2$(){
      return arguments;
    }
    function fn3$(val, key){
      assert.same(this, ctx, "Works with " + type + ", correct callback context");
      assert.same(val, type === 'string' ? '1' : 1, "Works with " + type + ", correct callback key");
      assert.same(key, 0, "Works with " + type + ", correct callback value");
      assert.same(arguments.length, 2, "Works with " + type + ", correct callback arguments number");
      return 42;
    }
    function fn4$(){
      from(y$);
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Array#indexOf', function(assert){
    var indexOf;
    indexOf = core.Array.indexOf;
    assert.isFunction(indexOf);
    assert.same(0, indexOf([1, 1, 1], 1));
    assert.same(-1, indexOf([1, 2, 3], 1, 1));
    assert.same(1, indexOf([1, 2, 3], 2, 1));
    assert.same(-1, indexOf([1, 2, 3], 2, -1));
    assert.same(1, indexOf([1, 2, 3], 2, -2));
    assert.same(-1, indexOf([NaN], NaN));
    assert.same(3, indexOf(Array(2).concat([1, 2, 3]), 2));
    assert.same(-1, indexOf(Array(1), void 8));
    assert.same(0, indexOf([1], 1, -0), "shouldn't return negative zero");
    if (STRICT) {
      assert.throws(function(){
        indexOf(null, 0);
      }, TypeError);
      assert.throws(function(){
        indexOf(void 8, 0);
      }, TypeError);
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Array.isArray', function(assert){
    var isArray;
    isArray = core.Array.isArray;
    assert.isFunction(isArray);
    assert.ok(!isArray({}));
    assert.ok(!isArray(function(){
      return arguments;
    }()));
    assert.ok(isArray([]));
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, Symbol, ref$, keys, values, entries;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  Symbol = core.Symbol;
  ref$ = core.Array, keys = ref$.keys, values = ref$.values, entries = ref$.entries;
  test('Array#@@iterator', function(assert){
    var iter;
    assert.isFunction(values);
    iter = core.getIterator(['q', 'w', 'e']);
    assert.isIterator(iter);
    assert.isIterable(iter);
    assert.strictEqual(iter[Symbol != null ? Symbol.toStringTag : void 8], 'Array Iterator');
    assert.deepEqual(iter.next(), {
      value: 'q',
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: 'w',
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: 'e',
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: void 8,
      done: true
    });
  });
  test('Array#keys', function(assert){
    var iter;
    assert.isFunction(keys);
    iter = keys(['q', 'w', 'e']);
    assert.isIterator(iter);
    assert.isIterable(iter);
    assert.strictEqual(iter[Symbol != null ? Symbol.toStringTag : void 8], 'Array Iterator');
    assert.deepEqual(iter.next(), {
      value: 0,
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: 1,
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: 2,
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: void 8,
      done: true
    });
  });
  test('Array#values', function(assert){
    var iter;
    assert.isFunction(values);
    iter = values(['q', 'w', 'e']);
    assert.isIterator(iter);
    assert.isIterable(iter);
    assert.strictEqual(iter[Symbol != null ? Symbol.toStringTag : void 8], 'Array Iterator');
    assert.deepEqual(iter.next(), {
      value: 'q',
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: 'w',
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: 'e',
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: void 8,
      done: true
    });
  });
  test('Array#entries', function(assert){
    var iter;
    assert.isFunction(entries);
    iter = entries(['q', 'w', 'e']);
    assert.isIterator(iter);
    assert.isIterable(iter);
    assert.strictEqual(iter[Symbol != null ? Symbol.toStringTag : void 8], 'Array Iterator');
    assert.deepEqual(iter.next(), {
      value: [0, 'q'],
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: [1, 'w'],
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: [2, 'e'],
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: void 8,
      done: true
    });
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Array#join', function(assert){
    var join;
    join = core.Array.join;
    assert.isFunction(join);
    assert.strictEqual(join([1, 2, 3], void 8), '1,2,3');
    assert.strictEqual(join('123'), '1,2,3');
    assert.strictEqual(join('123', '|'), '1|2|3');
    if (STRICT) {
      assert.throws(function(){
        join(null);
      }, TypeError);
      assert.throws(function(){
        join(void 8);
      }, TypeError);
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Array#lastIndexOf', function(assert){
    var lastIndexOf;
    lastIndexOf = core.Array.lastIndexOf;
    assert.isFunction(lastIndexOf);
    assert.same(2, lastIndexOf([1, 1, 1], 1));
    assert.same(-1, lastIndexOf([1, 2, 3], 3, 1));
    assert.same(1, lastIndexOf([1, 2, 3], 2, 1));
    assert.same(-1, lastIndexOf([1, 2, 3], 2, -3));
    assert.same(-1, lastIndexOf([1, 2, 3], 1, -4));
    assert.same(1, lastIndexOf([1, 2, 3], 2, -2));
    assert.same(-1, lastIndexOf([NaN], NaN));
    assert.same(1, lastIndexOf([1, 2, 3].concat(Array(2)), 2));
    assert.same(0, lastIndexOf([1], 1, -0), "shouldn't return negative zero");
    if (STRICT) {
      assert.throws(function(){
        lastIndexOf(null, 0);
      }, TypeError);
      assert.throws(function(){
        lastIndexOf(void 8, 0);
      }, TypeError);
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Array#map', function(assert){
    var map, a, ctx;
    map = core.Array.map;
    assert.isFunction(map);
    map(a = [1], function(val, key, that){
      assert.same(arguments.length, 3, 'correct number of callback arguments');
      assert.same(val, 1, 'correct value in callback');
      assert.same(key, 0, 'correct index in callback');
      assert.same(that, a, 'correct link to array in callback');
      return assert.same(this, ctx, 'correct callback context');
    }, ctx = {});
    assert.deepEqual([2, 3, 4], map([1, 2, 3], (function(it){
      return it + 1;
    })));
    assert.deepEqual([1, 3, 5], map([1, 2, 3], curry$(function(x$, y$){
      return x$ + y$;
    })));
    assert.deepEqual([2, 2, 2], map([1, 2, 3], function(){
      return +this;
    }, 2));
    if (STRICT) {
      assert.throws(function(){
        map(null, function(){});
      }, TypeError);
      assert.throws(function(){
        map(void 8, function(){});
      }, TypeError);
    }
  });
  function curry$(f, bound){
    var context,
    _curry = function(args) {
      return f.length > 1 ? function(){
        var params = args ? args.concat() : [];
        context = bound ? context || this : this;
        return params.push.apply(params, arguments) <
            f.length && arguments.length ?
          _curry.call(context, params) : f.apply(context, params);
      } : f;
    };
    return _curry();
  }
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Array.of', function(assert){
    var Array, defineProperty, F, inst, called;
    Array = core.Array;
    defineProperty = core.Object.defineProperty;
    assert.isFunction(Array.of);
    assert.arity(Array.of, 0);
    assert.deepEqual(Array.of(1), [1]);
    assert.deepEqual(Array.of(1, 2, 3), [1, 2, 3]);
    F = function(){};
    inst = Array.of.call(F, 1, 2);
    assert.ok(inst instanceof F);
    assert.strictEqual(inst[0], 1);
    assert.strictEqual(inst[1], 2);
    assert.strictEqual(inst.length, 2);
    if (DESCRIPTORS) {
      called = false;
      F = function(){};
      defineProperty(F.prototype, 0, {
        set: function(){
          var called;
          called = true;
        }
      });
      Array.of.call(F, 1, 2, 3);
      assert.ok(!called, 'Should not call prototype accessors');
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Array#reduceRight', function(assert){
    var reduceRight, a, accumulator, v, k;
    reduceRight = core.Array.reduceRight;
    assert.isFunction(reduceRight);
    reduceRight(a = [1], function(memo, val, key, that){
      assert.same(arguments.length, 4, 'correct number of callback arguments');
      assert.same(memo, accumulator, 'correct callback accumulator');
      assert.same(val, 1, 'correct value in callback');
      assert.same(key, 0, 'correct index in callback');
      assert.same(that, a, 'correct link to array in callback');
    }, accumulator = {});
    assert.same(reduceRight([1, 2, 3], curry$(function(x$, y$){
      return x$ + y$;
    }), 1), 7, 'works with initial accumulator');
    reduceRight(a = [1, 2], function(memo, val, key, that){
      assert.same(memo, 2, 'correct default accumulator');
      assert.same(val, 1, 'correct start value without initial accumulator');
      assert.same(key, 0, 'correct start index without initial accumulator');
    });
    assert.same(reduceRight([1, 2, 3], curry$(function(x$, y$){
      return x$ + y$;
    })), 6, 'works without initial accumulator');
    v = '';
    k = '';
    reduceRight([1, 2, 3], function(memo, a, b){
      v += a;
      k += b;
    }, 0);
    assert.same(v, '321', 'correct order #1');
    assert.same(k, '210', 'correct order #2');
    assert.same(reduceRight({
      0: 1,
      1: 2,
      length: 2
    }, curry$(function(x$, y$){
      return x$ + y$;
    })), 3, 'generic');
    if (STRICT) {
      assert.throws(function(){
        reduceRight(null, function(){}, 1);
      }, TypeError);
      assert.throws(function(){
        reduceRight(void 8, function(){}, 1);
      }, TypeError);
    }
  });
  function curry$(f, bound){
    var context,
    _curry = function(args) {
      return f.length > 1 ? function(){
        var params = args ? args.concat() : [];
        context = bound ? context || this : this;
        return params.push.apply(params, arguments) <
            f.length && arguments.length ?
          _curry.call(context, params) : f.apply(context, params);
      } : f;
    };
    return _curry();
  }
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Array#reduce', function(assert){
    var reduce, a, accumulator, v, k;
    reduce = core.Array.reduce;
    assert.isFunction(reduce);
    reduce(a = [1], function(memo, val, key, that){
      assert.same(arguments.length, 4, 'correct number of callback arguments');
      assert.same(memo, accumulator, 'correct callback accumulator');
      assert.same(val, 1, 'correct value in callback');
      assert.same(key, 0, 'correct index in callback');
      assert.same(that, a, 'correct link to array in callback');
    }, accumulator = {});
    assert.same(reduce([1, 2, 3], curry$(function(x$, y$){
      return x$ + y$;
    }), 1), 7, 'works with initial accumulator');
    reduce(a = [1, 2], function(memo, val, key, that){
      assert.same(memo, 1, 'correct default accumulator');
      assert.same(val, 2, 'correct start value without initial accumulator');
      assert.same(key, 1, 'correct start index without initial accumulator');
    });
    assert.same(reduce([1, 2, 3], curry$(function(x$, y$){
      return x$ + y$;
    })), 6, 'works without initial accumulator');
    v = '';
    k = '';
    reduce([1, 2, 3], function(memo, a, b){
      v += a;
      k += b;
    }, 0);
    assert.same(v, '123', 'correct order #1');
    assert.same(k, '012', 'correct order #2');
    assert.same(reduce({
      0: 1,
      1: 2,
      length: 2
    }, curry$(function(x$, y$){
      return x$ + y$;
    })), 3, 'generic');
    if (STRICT) {
      assert.throws(function(){
        reduce(null, function(){}, 1);
      }, TypeError);
      assert.throws(function(){
        reduce(void 8, function(){}, 1);
      }, TypeError);
    }
  });
  function curry$(f, bound){
    var context,
    _curry = function(args) {
      return f.length > 1 ? function(){
        var params = args ? args.concat() : [];
        context = bound ? context || this : this;
        return params.push.apply(params, arguments) <
            f.length && arguments.length ?
          _curry.call(context, params) : f.apply(context, params);
      } : f;
    };
    return _curry();
  }
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, toString$ = {}.toString;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Array#slice', function(assert){
    var slice, arr, str, list, ref$, e;
    slice = core.Array.slice;
    assert.isFunction(slice);
    arr = ['1', '2', '3', '4', '5'];
    assert.deepEqual(slice(arr), arr);
    assert.deepEqual(slice(arr, 1, 3), ['2', '3']);
    assert.deepEqual(slice(arr, 1, void 8), ['2', '3', '4', '5']);
    assert.deepEqual(slice(arr, 1, -1), ['2', '3', '4']);
    assert.deepEqual(slice(arr, -2, -1), ['4']);
    assert.deepEqual(slice(arr, -2, -3), []);
    str = '12345';
    assert.deepEqual(slice(str), arr);
    assert.deepEqual(slice(str, 1, 3), ['2', '3']);
    assert.deepEqual(slice(str, 1, void 8), ['2', '3', '4', '5']);
    assert.deepEqual(slice(str, 1, -1), ['2', '3', '4']);
    assert.deepEqual(slice(str, -2, -1), ['4']);
    assert.deepEqual(slice(str, -2, -3), []);
    if (list = typeof document != 'undefined' && document !== null ? (ref$ = document.body) != null ? ref$.childNodes : void 8 : void 8) {
      try {
        assert.strictEqual(toString$.call(slice(list)).slice(8, -1), 'Array');
      } catch (e$) {
        e = e$;
        assert.ok(false);
      }
    }
    if (NATIVE && STRICT) {
      assert.throws(function(){
        slice(null);
      }, TypeError);
      assert.throws(function(){
        slice(void 8);
      }, TypeError);
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, toString$ = {}.toString;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Array#some', function(assert){
    var some, a, ctx, rez, arr;
    some = core.Array.some;
    assert.isFunction(some);
    some(a = [1], function(val, key, that){
      assert.same(arguments.length, 3, 'correct number of callback arguments');
      assert.same(val, 1, 'correct value in callback');
      assert.same(key, 0, 'correct index in callback');
      assert.same(that, a, 'correct link to array in callback');
      assert.same(this, ctx, 'correct callback context');
    }, ctx = {});
    assert.ok(some([1, '2', 3], function(it){
      return toString$.call(it).slice(8, -1) === 'Number';
    }));
    assert.ok(some([1, 2, 3], (function(it){
      return it < 3;
    })));
    assert.ok(!some([1, 2, 3], (function(it){
      return it < 0;
    })));
    assert.ok(!some([1, 2, 3], function(it){
      return toString$.call(it).slice(8, -1) === 'String';
    }));
    assert.ok(!some([1, 2, 3], function(){
      return +this !== 1;
    }, 1));
    rez = '';
    some([1, 2, 3], function(){
      rez += arguments[1];
      return false;
    });
    assert.ok(rez === '012');
    assert.ok(!some(arr = [1, 2, 3], function(){
      return arguments[2] !== arr;
    }));
    if (STRICT) {
      assert.throws(function(){
        some(null, function(){});
      }, TypeError);
      assert.throws(function(){
        some(void 8, function(){});
      }, TypeError);
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Array#sort', function(assert){
    var sort;
    sort = core.Array.sort;
    assert.isFunction(sort);
    assert.ok(!!(function(){
      try {
        return sort([1, 2, 3], void 8);
      } catch (e$) {}
    }()), 'works with undefined');
    assert.throws(function(){
      sort([1, 2, 3], null);
    }, 'throws on null');
    assert.throws(function(){
      sort([1, 2, 3], {});
    }, 'throws on {}');
    if (STRICT) {
      assert.throws(function(){
        sort(null);
      }, TypeError, 'ToObject(this)');
      assert.throws(function(){
        sort(void 8);
      }, TypeError, 'ToObject(this)');
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Date.now', function(assert){
    var now;
    now = core.Date.now;
    assert.isFunction(now);
    assert.ok(+new Date - now() < 10, 'Date.now() ~ +new Date');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Date#toISOString', function(assert){
    var toISOString, ft, bc;
    toISOString = core.Date.toISOString;
    assert.isFunction(toISOString);
    assert.strictEqual(toISOString(new Date(0)), '1970-01-01T00:00:00.000Z');
    assert.strictEqual(toISOString(new Date(1e12 + 1)), '2001-09-09T01:46:40.001Z');
    assert.strictEqual(toISOString(new Date(-5e13 - 1)), '0385-07-25T07:06:39.999Z');
    ft = toISOString(new Date(1e15 + 1));
    assert.ok(ft === '+033658-09-27T01:46:40.001Z' || ft === '33658-09-27T01:46:40.001Z');
    bc = toISOString(new Date(-1e15 + 1));
    assert.ok(bc === '-029719-04-05T22:13:20.001Z' || bc === '-29719-04-05T22:13:20.001Z');
    assert.throws(function(){
      toISOString(new Date(NaN));
    }, RangeError);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Date#toJSON', function(assert){
    var ref$, toJSON, toISOString, d;
    ref$ = core.Date, toJSON = ref$.toJSON, toISOString = ref$.toISOString;
    assert.isFunction(toJSON);
    if (Date.prototype.toISOString) {
      d = new Date();
      assert.same(toJSON(d), toISOString(d), 'base');
    }
    assert.same(toJSON(new Date(NaN)), null, 'not finite');
    assert.same(toJSON({
      toISOString: function(){
        return 42;
      }
    }), 42, 'generic');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Function#bind', function(assert){
    var bind, obj, fn, inst, F, date;
    bind = core.Function.bind;
    assert.isFunction(bind);
    obj = {
      a: 42
    };
    assert.ok(42 === bind(function(){
      return this.a;
    }, obj)());
    assert.ok(void 8 === new (bind(function(){}, obj))().a);
    fn = function(a, b){
      this.a = a;
      this.b = b;
    };
    inst = new (bind(fn, null, 1))(2);
    assert.ok(inst instanceof fn);
    assert.strictEqual(inst.a, 1);
    assert.strictEqual(inst.b, 2);
    assert.ok(42 === bind(function(it){
      return it;
    }, null, 42)());
    fn = bind(RegExp.prototype.test, /a/);
    assert.ok(fn('a'));
    F = bind(Date, null, 2015);
    date = new F(6);
    assert.ok(date instanceof Date);
    assert.strictEqual(date.getFullYear(), 2015);
    assert.strictEqual(date.getMonth(), 6);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Function#@@hasInstance', function(assert){
    assert.ok(core.Symbol.hasInstance in Function.prototype);
    assert.ok(Function[core.Symbol.hasInstance](function(){}));
    assert.ok(!Function[core.Symbol.hasInstance]({}));
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, same, Map, Set, Symbol, ref$, getOwnPropertyDescriptor, freeze, iterator;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  same = function(a, b){
    if (a === b) {
      return a !== 0 || 1 / a === 1 / b;
    } else {
      return a != a && b != b;
    }
  };
  Map = core.Map, Set = core.Set, Symbol = core.Symbol;
  ref$ = core.Object, getOwnPropertyDescriptor = ref$.getOwnPropertyDescriptor, freeze = ref$.freeze;
  iterator = core.Symbol.iterator;
  test('Map', function(assert){
    var done, iter, a, o, key, C;
    assert.isFunction(Map);
    assert.ok('clear' in Map.prototype, 'clear in Map.prototype');
    assert.ok('delete' in Map.prototype, 'delete in Map.prototype');
    assert.ok('forEach' in Map.prototype, 'forEach in Map.prototype');
    assert.ok('get' in Map.prototype, 'get in Map.prototype');
    assert.ok('has' in Map.prototype, 'has in Map.prototype');
    assert.ok('set' in Map.prototype, 'set in Map.prototype');
    assert.ok(new Map instanceof Map, 'new Map instanceof Map');
    assert.strictEqual(new Map(createIterable([[1, 1], [2, 2], [3, 3]])).size, 3, 'Init from iterable');
    assert.strictEqual(new Map([[freeze({}), 1], [2, 3]]).size, 2, 'Support frozen objects');
    done = false;
    iter = createIterable([null, 1, 2], {
      'return': function(){
        return done = true;
      }
    });
    try {
      new Map(iter);
    } catch (e$) {}
    assert.ok(done, '.return #throw');
    a = [];
    done = false;
    a['@@iterator'] = void 8;
    a[iterator] = function(){
      done = true;
      return core.getIteratorMethod([]).call(this);
    };
    new Map(a);
    assert.ok(done);
    o = {};
    new Map().set(o, 1);
    if (DESCRIPTORS) {
      assert.arrayEqual((function(){
        var results$ = [];
        for (key in o) {
          results$.push(key);
        }
        return results$;
      }()), []);
      assert.arrayEqual(core.Object.keys(o), []);
    }
    assert.arrayEqual(core.Object.getOwnPropertyNames(o), []);
    assert.arrayEqual(core.Object.getOwnPropertySymbols(o), []);
    assert.arrayEqual(core.Reflect.ownKeys(o), []);
    if (nativeSubclass) {
      C = nativeSubclass(Map);
      assert.ok(new C instanceof C, 'correct subclassing with native classes #1');
      assert.ok(new C instanceof Map, 'correct subclassing with native classes #2');
      assert.same(new C().set(1, 2).get(1), 2, 'correct subclassing with native classes #3');
    }
  });
  test('Map#clear', function(assert){
    var M, f;
    assert.isFunction(Map.prototype.clear);
    M = new Map;
    M.clear();
    assert.strictEqual(M.size, 0);
    M = new Map().set(1, 2).set(2, 3).set(1, 4);
    M.clear();
    assert.strictEqual(M.size, 0);
    assert.ok(!M.has(1));
    assert.ok(!M.has(2));
    M = new Map().set(1, 2).set(f = freeze({}), 3);
    M.clear();
    assert.strictEqual(M.size, 0, 'Support frozen objects');
    assert.ok(!M.has(1));
    assert.ok(!M.has(f));
  });
  test('Map#delete', function(assert){
    var a, M, f;
    assert.isFunction(Map.prototype['delete']);
    a = [];
    M = new Map().set(NaN, 1).set(2, 1).set(3, 1).set(2, 5).set(1, 4).set(a, {});
    assert.strictEqual(M.size, 5);
    assert.ok(M['delete'](NaN));
    assert.strictEqual(M.size, 4);
    assert.ok(!M['delete'](4));
    assert.strictEqual(M.size, 4);
    M['delete']([]);
    assert.strictEqual(M.size, 4);
    M['delete'](a);
    assert.strictEqual(M.size, 3);
    M.set(freeze(f = {}), 42);
    assert.strictEqual(M.size, 4);
    M['delete'](f);
    assert.strictEqual(M.size, 3);
  });
  test('Map#forEach', function(assert){
    var r, T, count, M, a, map, s;
    assert.isFunction(Map.prototype.forEach);
    r = {};
    count = 0;
    M = new Map().set(NaN, 1).set(2, 1).set(3, 7).set(2, 5).set(1, 4).set(a = {}, 9);
    M.forEach(function(value, key){
      count++;
      r[value] = key;
    });
    assert.strictEqual(count, 5);
    assert.deepEqual(r, {
      1: NaN,
      7: 3,
      5: 2,
      4: 1,
      9: a
    });
    map = new Map([['0', 9], ['1', 9], ['2', 9], ['3', 9]]);
    s = "";
    map.forEach(function(value, key){
      s += key;
      if (key === '2') {
        map['delete']('2');
        map['delete']('3');
        map['delete']('1');
        map.set('4', 9);
      }
    });
    assert.strictEqual(s, '0124');
    map = new Map([['0', 1]]);
    s = "";
    map.forEach(function(it){
      map['delete']('0');
      if (s !== '') {
        throw '!!!';
      }
      s += it;
    });
    assert.strictEqual(s, '1');
    assert.throws(function(){
      Map.prototype.forEach.call(new Set, function(){});
    }, 'non-generic');
  });
  test('Map#get', function(assert){
    var o, f, M;
    assert.isFunction(Map.prototype.get);
    o = {};
    f = freeze({});
    M = new Map([[NaN, 1], [2, 1], [3, 1], [2, 5], [1, 4], [f, 42], [o, o]]);
    assert.strictEqual(M.get(NaN), 1);
    assert.strictEqual(M.get(4), void 8);
    assert.strictEqual(M.get({}), void 8);
    assert.strictEqual(M.get(o), o);
    assert.strictEqual(M.get(f), 42);
    assert.strictEqual(M.get(2), 5);
  });
  test('Map#has', function(assert){
    var o, f, M;
    assert.isFunction(Map.prototype.has);
    o = {};
    f = freeze({});
    M = new Map([[NaN, 1], [2, 1], [3, 1], [2, 5], [1, 4], [f, 42], [o, o]]);
    assert.ok(M.has(NaN));
    assert.ok(M.has(o));
    assert.ok(M.has(2));
    assert.ok(M.has(f));
    assert.ok(!M.has(4));
    assert.ok(!M.has({}));
  });
  test('Map#set', function(assert){
    var o, M, chain, f;
    assert.isFunction(Map.prototype.set);
    o = {};
    M = new Map().set(NaN, 1).set(2, 1).set(3, 1).set(2, 5).set(1, 4).set(o, o);
    assert.ok(M.size === 5);
    chain = M.set(7, 2);
    assert.strictEqual(chain, M);
    M.set(7, 2);
    assert.strictEqual(M.size, 6);
    assert.strictEqual(M.get(7), 2);
    assert.strictEqual(M.get(NaN), 1);
    M.set(NaN, 42);
    assert.strictEqual(M.size, 6);
    assert.strictEqual(M.get(NaN), 42);
    M.set({}, 11);
    assert.strictEqual(M.size, 7);
    assert.strictEqual(M.get(o), o);
    M.set(o, 27);
    assert.strictEqual(M.size, 7);
    assert.strictEqual(M.get(o), 27);
    assert.strictEqual(new Map().set(NaN, 2).set(NaN, 3).set(NaN, 4).size, 1);
    M = new Map().set(freeze(f = {}), 42);
    assert.strictEqual(M.get(f), 42);
  });
  test('Map#size', function(assert){
    var size, sizeDesc;
    size = new Map().set(2, 1).size;
    assert.strictEqual(typeof size, 'number', 'size is number');
    assert.strictEqual(size, 1, 'size is correct');
    if (DESCRIPTORS) {
      sizeDesc = getOwnPropertyDescriptor(Map.prototype, 'size');
      assert.ok(sizeDesc && sizeDesc.get, 'size is getter');
      assert.ok(sizeDesc && !sizeDesc.set, 'size isnt setter');
      assert.throws(function(){
        Map.prototype.size;
      }, TypeError);
    }
  });
  test('Map & -0', function(assert){
    var map, x$;
    map = new Map;
    map.set(-0, 1);
    assert.strictEqual(map.size, 1);
    assert.ok(map.has(0));
    assert.ok(map.has(-0));
    assert.strictEqual(map.get(0), 1);
    assert.strictEqual(map.get(-0), 1);
    map.forEach(function(val, key){
      return assert.ok(!same(key, -0));
    });
    map['delete'](-0);
    assert.strictEqual(map.size, 0);
    map = new Map([[-0, 1]]);
    map.forEach(function(val, key){
      return assert.ok(!same(key, -0));
    });
    x$ = map = new Map();
    x$.set(4, 4);
    x$.set(3, 3);
    x$.set(2, 2);
    x$.set(1, 1);
    x$.set(0, 0);
    assert.ok(map.has(-0));
  });
  test('Map#@@toStringTag', function(assert){
    assert.strictEqual(Map.prototype[Symbol != null ? Symbol.toStringTag : void 8], 'Map', 'Map::@@toStringTag is `Map`');
  });
  test('Map Iterator', function(assert){
    var map, keys, iterator;
    map = new Map([['a', 1], ['b', 2], ['c', 3], ['d', 4]]);
    keys = [];
    iterator = map.keys();
    keys.push(iterator.next().value);
    assert.ok(map['delete']('a'));
    assert.ok(map['delete']('b'));
    assert.ok(map['delete']('c'));
    map.set('e');
    keys.push(iterator.next().value);
    keys.push(iterator.next().value);
    assert.ok(iterator.next().done);
    map.set('f');
    assert.ok(iterator.next().done);
    assert.deepEqual(keys, ['a', 'd', 'e']);
  });
  test('Map#keys', function(assert){
    var iter;
    assert.isFunction(Map.prototype.keys);
    iter = new Map([['a', 'q'], ['s', 'w'], ['d', 'e']]).keys();
    assert.isIterator(iter);
    assert.isIterable(iter);
    assert.strictEqual(iter[Symbol != null ? Symbol.toStringTag : void 8], 'Map Iterator');
    assert.deepEqual(iter.next(), {
      value: 'a',
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: 's',
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: 'd',
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: void 8,
      done: true
    });
  });
  test('Map#values', function(assert){
    var iter;
    assert.isFunction(Map.prototype.values);
    iter = new Map([['a', 'q'], ['s', 'w'], ['d', 'e']]).values();
    assert.isIterator(iter);
    assert.isIterable(iter);
    assert.strictEqual(iter[Symbol != null ? Symbol.toStringTag : void 8], 'Map Iterator');
    assert.deepEqual(iter.next(), {
      value: 'q',
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: 'w',
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: 'e',
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: void 8,
      done: true
    });
  });
  test('Map#entries', function(assert){
    var iter;
    assert.isFunction(Map.prototype.entries);
    iter = new Map([['a', 'q'], ['s', 'w'], ['d', 'e']]).entries();
    assert.isIterator(iter);
    assert.isIterable(iter);
    assert.strictEqual(iter[Symbol != null ? Symbol.toStringTag : void 8], 'Map Iterator');
    assert.deepEqual(iter.next(), {
      value: ['a', 'q'],
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: ['s', 'w'],
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: ['d', 'e'],
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: void 8,
      done: true
    });
  });
  test('Map#@@iterator', function(assert){
    var iter;
    iter = core.getIterator(new Map([['a', 'q'], ['s', 'w'], ['d', 'e']]));
    assert.isIterator(iter);
    assert.isIterable(iter);
    assert.strictEqual(iter[Symbol != null ? Symbol.toStringTag : void 8], 'Map Iterator');
    assert.deepEqual(iter.next(), {
      value: ['a', 'q'],
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: ['s', 'w'],
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: ['d', 'e'],
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: void 8,
      done: true
    });
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Math.acosh', function(assert){
    var acosh;
    acosh = core.Math.acosh;
    assert.isFunction(acosh);
    assert.same(acosh(NaN), NaN);
    assert.same(acosh(0.5), NaN);
    assert.same(acosh(-1), NaN);
    assert.same(acosh(-1e300), NaN);
    assert.same(acosh(1), 0);
    assert.strictEqual(acosh(Infinity), Infinity);
    assert.epsilon(acosh(1234), 7.811163220849231);
    assert.epsilon(acosh(8.88), 2.8737631531629235);
    assert.epsilon(acosh(1e+160), 369.10676205960726);
    assert.epsilon(acosh(Number.MAX_VALUE), 710.475860073944);
    assert.epsilon(acosh(1 + core.Number.EPSILON), 2.1073424255447017e-8);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Math.asinh', function(assert){
    var asinh;
    asinh = core.Math.asinh;
    assert.isFunction(asinh);
    assert.same(asinh(NaN), NaN);
    assert.same(asinh(0), 0);
    assert.same(asinh(-0), -0);
    assert.strictEqual(asinh(Infinity), Infinity);
    assert.strictEqual(asinh(-Infinity), -Infinity);
    assert.epsilon(asinh(1234), 7.811163549201245);
    assert.epsilon(asinh(9.99), 2.997227420191335);
    assert.epsilon(asinh(1e150), 346.0809111296668);
    assert.epsilon(asinh(1e7), 16.811242831518268);
    assert.epsilon(asinh(-1e7), -16.811242831518268);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Math.atanh', function(assert){
    var atanh;
    atanh = core.Math.atanh;
    assert.isFunction(atanh);
    assert.same(atanh(NaN), NaN);
    assert.same(atanh(-2), NaN);
    assert.same(atanh(-1.5), NaN);
    assert.same(atanh(2), NaN);
    assert.same(atanh(1.5), NaN);
    assert.strictEqual(atanh(-1), -Infinity);
    assert.strictEqual(atanh(1), Infinity);
    assert.same(atanh(0), 0);
    assert.same(atanh(-0), -0);
    assert.same(atanh(-1e300), NaN);
    assert.same(atanh(1e300), NaN);
    assert.epsilon(atanh(0.5), 0.5493061443340549);
    assert.epsilon(atanh(-0.5), -0.5493061443340549);
    assert.epsilon(atanh(0.444), 0.47720201260109457);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Math.cbrt', function(assert){
    var cbrt;
    cbrt = core.Math.cbrt;
    assert.isFunction(cbrt);
    assert.same(cbrt(NaN), NaN);
    assert.same(cbrt(0), 0);
    assert.same(cbrt(-0), -0);
    assert.strictEqual(cbrt(Infinity), Infinity);
    assert.strictEqual(cbrt(-Infinity), -Infinity);
    assert.strictEqual(cbrt(-8), -2);
    assert.strictEqual(cbrt(8), 2);
    assert.epsilon(cbrt(-1000), -10);
    assert.epsilon(cbrt(1000), 10);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Math.clz32', function(assert){
    var clz32;
    clz32 = core.Math.clz32;
    assert.isFunction(clz32);
    assert.strictEqual(clz32(0), 32);
    assert.strictEqual(clz32(1), 31);
    assert.same(clz32(-1), 0);
    assert.strictEqual(clz32(0.6), 32);
    assert.same(clz32(Math.pow(2, 32) - 1), 0);
    assert.strictEqual(clz32(Math.pow(2, 32)), 32);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Math.cosh', function(assert){
    var cosh;
    cosh = core.Math.cosh;
    assert.isFunction(cosh);
    assert.same(cosh(NaN), NaN);
    assert.strictEqual(cosh(0), 1);
    assert.strictEqual(cosh(-0), 1);
    assert.strictEqual(cosh(Infinity), Infinity);
    assert.strictEqual(cosh(-Infinity), Infinity);
    assert.epsilon(cosh(12), 81377.39571257407, 3e-11);
    assert.epsilon(cosh(22), 1792456423.065795780980053377, 1e-5);
    assert.epsilon(cosh(-10), 11013.23292010332313972137);
    assert.epsilon(cosh(-23), 4872401723.1244513000, 1e-5);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Math.expm1', function(assert){
    var expm1;
    expm1 = core.Math.expm1;
    assert.isFunction(expm1);
    assert.same(expm1(NaN), NaN);
    assert.same(expm1(0), 0);
    assert.same(expm1(-0), -0);
    assert.strictEqual(expm1(Infinity), Infinity);
    assert.strictEqual(expm1(-Infinity), -1);
    assert.epsilon(expm1(10), 22025.465794806718, assert.epsilon(expm1(-10), -0.9999546000702375));
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Math.fround', function(assert){
    var fround, maxFloat32, minFloat32;
    fround = core.Math.fround;
    assert.isFunction(fround);
    assert.same(fround(void 8), NaN);
    assert.same(fround(NaN), NaN);
    assert.same(fround(0), 0);
    assert.same(fround(-0), -0);
    assert.same(fround(Number.MIN_VALUE), 0);
    assert.same(fround(-Number.MIN_VALUE), -0);
    assert.strictEqual(fround(Infinity), Infinity);
    assert.strictEqual(fround(-Infinity), -Infinity);
    assert.strictEqual(fround(1.7976931348623157e+308), Infinity);
    assert.strictEqual(fround(-1.7976931348623157e+308), -Infinity);
    assert.strictEqual(fround(3.4028235677973366e+38), Infinity);
    assert.strictEqual(fround(3), 3);
    assert.strictEqual(fround(-3), -3);
    maxFloat32 = 3.4028234663852886e+38;
    minFloat32 = 1.401298464324817e-45;
    assert.strictEqual(fround(maxFloat32), maxFloat32);
    assert.strictEqual(fround(-maxFloat32), -maxFloat32);
    assert.strictEqual(fround(maxFloat32 + Math.pow(2, Math.pow(2, 8 - 1) - 1 - 23 - 2)), maxFloat32);
    assert.strictEqual(fround(minFloat32), minFloat32);
    assert.strictEqual(fround(-minFloat32), -minFloat32);
    assert.same(fround(minFloat32 / 2), 0);
    assert.same(fround(-minFloat32 / 2), -0);
    assert.strictEqual(fround(minFloat32 / 2 + Math.pow(2, -202)), minFloat32);
    assert.strictEqual(fround(-minFloat32 / 2 - Math.pow(2, -202)), -minFloat32);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Math.hypot', function(assert){
    var hypot, sqrt;
    hypot = core.Math.hypot;
    sqrt = Math.sqrt;
    assert.isFunction(hypot);
    assert.strictEqual(hypot(), 0);
    assert.strictEqual(hypot(1), 1);
    assert.same(hypot('', 0), 0);
    assert.same(hypot(0, ''), 0);
    assert.strictEqual(hypot(Infinity, 0), Infinity);
    assert.strictEqual(hypot(-Infinity, 0), Infinity);
    assert.strictEqual(hypot(0, Infinity), Infinity);
    assert.strictEqual(hypot(0, -Infinity), Infinity);
    assert.strictEqual(hypot(Infinity, NaN), Infinity);
    assert.strictEqual(hypot(NaN, -Infinity), Infinity);
    assert.same(hypot(NaN, 0), NaN);
    assert.same(hypot(0, NaN), NaN);
    assert.same(hypot(0, -0), 0);
    assert.same(hypot(0, 0), 0);
    assert.same(hypot(-0, -0), 0);
    assert.same(hypot(-0, 0), 0);
    assert.strictEqual(hypot(0, 1), 1);
    assert.strictEqual(hypot(0, -1), 1);
    assert.strictEqual(hypot(-0, 1), 1);
    assert.strictEqual(hypot(-0, -1), 1);
    assert.same(hypot(0), 0);
    assert.strictEqual(hypot(1), 1);
    assert.strictEqual(hypot(2), 2);
    assert.strictEqual(hypot(0, 0, 1), 1);
    assert.strictEqual(hypot(0, 1, 0), 1);
    assert.strictEqual(hypot(1, 0, 0), 1);
    assert.strictEqual(hypot(2, 3, 4), sqrt(2 * 2 + 3 * 3 + 4 * 4));
    assert.strictEqual(hypot(2, 3, 4, 5), sqrt(2 * 2 + 3 * 3 + 4 * 4 + 5 * 5));
    assert.epsilon(hypot(66, 66), 93.33809511662427);
    assert.epsilon(hypot(0.1, 100), 100.0000499999875);
    assert.strictEqual(hypot(1e+300, 1e+300), 1.4142135623730952e+300);
    assert.strictEqual(Math.floor(hypot(1e-300, 1e-300) * 1e308), 141421356);
    assert.strictEqual(hypot(1e+300, 1e+300, 2, 3), 1.4142135623730952e+300);
    assert.strictEqual(hypot(-3, 4), 5);
    assert.strictEqual(hypot(3, -4), 5);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Math.imul', function(assert){
    var imul;
    imul = core.Math.imul;
    assert.isFunction(imul);
    assert.same(imul(0, 0), 0);
    assert.strictEqual(imul(123, 456), 56088);
    assert.strictEqual(imul(-123, 456), -56088);
    assert.strictEqual(imul(123, -456), -56088);
    assert.strictEqual(imul(19088743, 4275878552), 602016552);
    assert.same(imul(false, 7), 0);
    assert.same(imul(7, false), 0);
    assert.same(imul(false, false), 0);
    assert.strictEqual(imul(true, 7), 7);
    assert.strictEqual(imul(7, true), 7);
    assert.strictEqual(imul(true, true), 1);
    assert.same(imul(void 8, 7), 0);
    assert.same(imul(7, void 8), 0);
    assert.same(imul(void 8, void 8), 0);
    assert.same(imul('str', 7), 0);
    assert.same(imul(7, 'str'), 0);
    assert.same(imul({}, 7), 0);
    assert.same(imul(7, {}), 0);
    assert.same(imul([], 7), 0);
    assert.same(imul(7, []), 0);
    assert.strictEqual(imul(0xffffffff, 5), -5);
    assert.strictEqual(imul(0xfffffffe, 5), -10);
    assert.strictEqual(imul(2, 4), 8);
    assert.strictEqual(imul(-1, 8), -8);
    assert.strictEqual(imul(-2, -2), 4);
    assert.same(imul(-0, 7), 0);
    assert.same(imul(7, -0), 0);
    assert.same(imul(0.1, 7), 0);
    assert.same(imul(7, 0.1), 0);
    assert.same(imul(0.9, 7), 0);
    assert.same(imul(7, 0.9), 0);
    assert.strictEqual(imul(1.1, 7), 7);
    assert.strictEqual(imul(7, 1.1), 7);
    assert.strictEqual(imul(1.9, 7), 7);
    assert.strictEqual(imul(7, 1.9), 7);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Math.log10', function(assert){
    var log10;
    log10 = core.Math.log10;
    assert.isFunction(log10);
    assert.same(log10(''), log10(0));
    assert.same(log10(NaN), NaN);
    assert.same(log10(-1), NaN);
    assert.same(log10(0), -Infinity);
    assert.same(log10(-0), -Infinity);
    assert.same(log10(1), 0);
    assert.same(log10(Infinity), Infinity);
    assert.epsilon(log10(0.1), -1);
    assert.epsilon(log10(0.5), -0.3010299956639812);
    assert.epsilon(log10(1.5), 0.17609125905568124);
    assert.epsilon(log10(5), 0.6989700043360189);
    assert.epsilon(log10(50), 1.6989700043360187);
    assert.epsilon(log10(1000), 3);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Math.log1p', function(assert){
    var log1p;
    log1p = core.Math.log1p;
    assert.isFunction(log1p);
    assert.same(log1p(''), log1p(0));
    assert.same(log1p(NaN), NaN);
    assert.same(log1p(-2), NaN);
    assert.same(log1p(-1), -Infinity);
    assert.same(log1p(0), 0);
    assert.same(log1p(-0), -0);
    assert.same(log1p(Infinity), Infinity);
    assert.epsilon(log1p(5), 1.791759469228055);
    assert.epsilon(log1p(50), 3.9318256327243257);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Math.log2', function(assert){
    var log2;
    log2 = core.Math.log2;
    assert.isFunction(log2);
    assert.same(log2(''), log2(0));
    assert.same(log2(NaN), NaN);
    assert.same(log2(-1), NaN);
    assert.same(log2(0), -Infinity);
    assert.same(log2(-0), -Infinity);
    assert.same(log2(1), 0);
    assert.same(log2(Infinity), Infinity);
    assert.same(log2(0.5), -1);
    assert.same(log2(32), 5);
    assert.epsilon(log2(5), 2.321928094887362);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Math.sign', function(assert){
    var sign;
    sign = core.Math.sign;
    assert.isFunction(sign);
    assert.same(sign(NaN), NaN);
    assert.same(sign(), NaN);
    assert.same(sign(-0), -0);
    assert.same(sign(0), 0);
    assert.strictEqual(sign(Infinity), 1);
    assert.strictEqual(sign(-Infinity), -1);
    assert.strictEqual(sign(13510798882111488), 1);
    assert.strictEqual(sign(-13510798882111488), -1);
    assert.strictEqual(sign(42.5), 1);
    assert.strictEqual(sign(-42.5), -1);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Math.sinh', function(assert){
    var sinh;
    sinh = core.Math.sinh;
    assert.isFunction(sinh);
    assert.same(sinh(NaN), NaN);
    assert.same(sinh(0), 0);
    assert.same(sinh(-0), -0);
    assert.strictEqual(sinh(Infinity), Infinity);
    assert.strictEqual(sinh(-Infinity), -Infinity);
    assert.epsilon(sinh(-5), -74.20321057778875);
    assert.epsilon(sinh(2), 3.6268604078470186);
    assert.strictEqual(sinh(-2e-17), -2e-17);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Math.tanh', function(assert){
    var tanh;
    tanh = core.Math.tanh;
    assert.isFunction(tanh);
    assert.same(tanh(NaN), NaN);
    assert.same(tanh(0), 0);
    assert.same(tanh(-0), -0);
    assert.strictEqual(tanh(Infinity), 1);
    assert.strictEqual(tanh(90), 1);
    assert.epsilon(tanh(10), 0.9999999958776927);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Math.trunc', function(assert){
    var trunc;
    trunc = core.Math.trunc;
    assert.isFunction(trunc);
    assert.same(trunc(NaN), NaN, 'NaN -> NaN');
    assert.same(trunc(-0), -0, '-0 -> -0');
    assert.same(trunc(0), 0, '0 -> 0');
    assert.same(trunc(Infinity), Infinity, 'Infinity -> Infinity');
    assert.same(trunc(-Infinity), -Infinity, '-Infinity -> -Infinity');
    assert.same(trunc(null), 0, 'null -> 0');
    assert.same(trunc({}), NaN, '{} -> NaN');
    assert.strictEqual(trunc([]), 0, '[] -> 0');
    assert.strictEqual(trunc(1.01), 1, '1.01 -> 0');
    assert.strictEqual(trunc(1.99), 1, '1.99 -> 0');
    assert.strictEqual(trunc(-1), -1, '-1 -> -1');
    assert.strictEqual(trunc(-1.99), -1, '-1.99 -> -1');
    assert.strictEqual(trunc(-555.555), -555, '-555.555 -> -555');
    assert.strictEqual(trunc(0x20000000000001), 0x20000000000001, '0x20000000000001 -> 0x20000000000001');
    assert.strictEqual(trunc(-0x20000000000001), -0x20000000000001, '-0x20000000000001 -> -0x20000000000001');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Number.EPSILON', function(assert){
    var EPSILON;
    EPSILON = core.Number.EPSILON;
    assert.ok('EPSILON' in core.Number, 'EPSILON in Number');
    assert.strictEqual(EPSILON, Math.pow(2, -52), 'Is 2^-52');
    assert.ok(1 !== 1 + EPSILON, '1 isnt 1 + EPSILON');
    assert.strictEqual(1, 1 + EPSILON / 2, '1 is 1 + EPSILON / 2');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Number.isFinite', function(assert){
    var isFinite, create, i$, x$, ref$, len$, y$, e;
    isFinite = core.Number.isFinite;
    create = core.Object.create;
    assert.isFunction(isFinite);
    for (i$ = 0, len$ = (ref$ = [1, 0.1, -1, Math.pow(2, 16), Math.pow(2, 16) - 1, Math.pow(2, 31), Math.pow(2, 31) - 1, Math.pow(2, 32), Math.pow(2, 32) - 1, -0]).length; i$ < len$; ++i$) {
      x$ = ref$[i$];
      assert.ok(isFinite(x$), "isFinite " + typeof x$ + " " + x$);
    }
    for (i$ = 0, len$ = (ref$ = [NaN, Infinity, 'NaN', '5', false, new Number(NaN), new Number(Infinity), new Number(5), new Number(0.1), void 8, null, {}, fn$, create(null)]).length; i$ < len$; ++i$) {
      y$ = ref$[i$];
      assert.ok(!isFinite(y$), "not isFinite " + typeof y$ + " " + (fn1$()));
    }
    function fn$(){}
    function fn1$(){
      try {
        return String(y$);
      } catch (e$) {
        e = e$;
        return 'Object.create(null)';
      }
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Number.isInteger', function(assert){
    var isInteger, create, i$, x$, ref$, len$, y$, e;
    isInteger = core.Number.isInteger;
    create = core.Object.create;
    assert.isFunction(isInteger);
    for (i$ = 0, len$ = (ref$ = [1, -1, Math.pow(2, 16), Math.pow(2, 16) - 1, Math.pow(2, 31), Math.pow(2, 31) - 1, Math.pow(2, 32), Math.pow(2, 32) - 1, -0]).length; i$ < len$; ++i$) {
      x$ = ref$[i$];
      assert.ok(isInteger(x$), "isInteger " + typeof x$ + " " + x$);
    }
    for (i$ = 0, len$ = (ref$ = [NaN, 0.1, Infinity, 'NaN', '5', false, new Number(NaN), new Number(Infinity), new Number(5), new Number(0.1), void 8, null, {}, fn$, create(null)]).length; i$ < len$; ++i$) {
      y$ = ref$[i$];
      assert.ok(!isInteger(y$), "not isInteger " + typeof y$ + " " + (fn1$()));
    }
    function fn$(){}
    function fn1$(){
      try {
        return String(y$);
      } catch (e$) {
        e = e$;
        return 'Object.create(null)';
      }
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Number.isNaN', function(assert){
    var isNaN, create, i$, x$, ref$, len$, e;
    isNaN = core.Number.isNaN;
    create = core.Object.create;
    assert.isFunction(isNaN);
    assert.ok(isNaN(NaN), 'Number.isNaN NaN');
    for (i$ = 0, len$ = (ref$ = [1, 0.1, -1, Math.pow(2, 16), Math.pow(2, 16) - 1, Math.pow(2, 31), Math.pow(2, 31) - 1, Math.pow(2, 32), Math.pow(2, 32) - 1, -0, Infinity, 'NaN', '5', false, new Number(NaN), new Number(Infinity), new Number(5), new Number(0.1), void 8, null, {}, fn$, create(null)]).length; i$ < len$; ++i$) {
      x$ = ref$[i$];
      assert.ok(!isNaN(x$), "not Number.isNaN " + typeof x$ + " " + (fn1$()));
    }
    function fn$(){}
    function fn1$(){
      try {
        return String(x$);
      } catch (e$) {
        e = e$;
        return 'Object.create(null)';
      }
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Number.isSafeInteger', function(assert){
    var isSafeInteger, create, i$, x$, ref$, len$, y$, e;
    isSafeInteger = core.Number.isSafeInteger;
    create = core.Object.create;
    assert.isFunction(isSafeInteger);
    for (i$ = 0, len$ = (ref$ = [1, -1, Math.pow(2, 16), Math.pow(2, 16) - 1, Math.pow(2, 31), Math.pow(2, 31) - 1, Math.pow(2, 32), Math.pow(2, 32) - 1, -0, 9007199254740991, -9007199254740991]).length; i$ < len$; ++i$) {
      x$ = ref$[i$];
      assert.ok(isSafeInteger(x$), "isSafeInteger " + typeof x$ + " " + x$);
    }
    for (i$ = 0, len$ = (ref$ = [9007199254740992, -9007199254740992, NaN, 0.1, Infinity, 'NaN', '5', false, new Number(NaN), new Number(Infinity), new Number(5), new Number(0.1), void 8, null, {}, fn$, create(null)]).length; i$ < len$; ++i$) {
      y$ = ref$[i$];
      assert.ok(!isSafeInteger(y$), "not isSafeInteger " + typeof y$ + " " + (fn1$()));
    }
    function fn$(){}
    function fn1$(){
      try {
        return String(y$);
      } catch (e$) {
        e = e$;
        return 'Object.create(null)';
      }
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Number.MAX_SAFE_INTEGER', function(assert){
    assert.strictEqual(core.Number.MAX_SAFE_INTEGER, Math.pow(2, 53) - 1, 'Is 2^53 - 1');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Number.MIN_SAFE_INTEGER', function(assert){
    assert.strictEqual(core.Number.MIN_SAFE_INTEGER, -Math.pow(2, 53) + 1, 'Is -2^53 + 1');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Number.parseFloat', function(assert){
    var parseFloat, ws;
    parseFloat = core.Number.parseFloat;
    assert.isFunction(parseFloat);
    assert.arity(parseFloat, 1);
    assert.same(parseFloat, core.parseFloat);
    assert.same(parseFloat('0'), 0);
    assert.same(parseFloat(' 0'), 0);
    assert.same(parseFloat('+0'), 0);
    assert.same(parseFloat(' +0'), 0);
    assert.same(parseFloat('-0'), -0);
    assert.same(parseFloat(' -0'), -0);
    ws = '\x09\x0A\x0B\x0C\x0D\x20\xA0\u1680\u180E\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u3000\u2028\u2029\uFEFF';
    assert.same(parseFloat(ws + '+0'), 0);
    assert.same(parseFloat(ws + '-0'), -0);
    assert.same(parseFloat(null), NaN);
    assert.same(parseFloat(void 8), NaN);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Number.parseInt', function(assert){
    var parseInt, i$, r, x$, ref$, len$, ws, fakeZero;
    parseInt = core.Number.parseInt;
    assert.isFunction(parseInt);
    assert.arity(parseInt, 2);
    assert.same(parseInt, core.parseInt);
    for (i$ = 2; i$ <= 36; ++i$) {
      r = i$;
      assert.same(parseInt('10', r), r, "radix " + r);
    }
    for (i$ = 0, len$ = (ref$ = ['01', '08', '10', '42']).length; i$ < len$; ++i$) {
      x$ = ref$[i$];
      assert.same(parseInt(x$), parseInt(x$, 10), "default radix is 10: " + x$);
    }
    assert.same(parseInt('0x16'), parseInt('0x16', 16), "default radix is 16: 0x16");
    ws = '\x09\x0A\x0B\x0C\x0D\x20\xA0\u1680\u180E\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u3000\u2028\u2029\uFEFF';
    assert.same(parseInt('  0x16'), parseInt('0x16', 16), 'ignores leading whitespace #1');
    assert.same(parseInt('  42'), parseInt('42', 10), 'ignores leading whitespace #2');
    assert.same(parseInt('  08'), parseInt('08', 10), 'ignores leading whitespace #3');
    assert.same(parseInt(ws + '08'), parseInt('08', 10), 'ignores leading whitespace #4');
    assert.same(parseInt(ws + '0x16'), parseInt('0x16', 16), 'ignores leading whitespace #5');
    fakeZero = {
      valueOf: function(){
        return 0;
      }
    };
    assert.same(parseInt('08', fakeZero), parseInt('08', 10), 'valueOf #1');
    assert.same(parseInt('0x16', fakeZero), parseInt('0x16', 16), 'valueOf #2');
    assert.same(parseInt('-0xF'), -15, 'signed hex #1');
    assert.same(parseInt('-0xF', 16), -15, 'signed hex #2');
    assert.same(parseInt('+0xF'), 15, 'signed hex #3');
    assert.same(parseInt('+0xF', 16), 15, 'signed hex #4');
    assert.same(parseInt('10', -4294967294), 2, 'radix uses ToUint32');
    assert.same(parseInt(null), NaN);
    assert.same(parseInt(void 8), NaN);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Number#toFixed', function(assert){
    var toFixed;
    toFixed = core.Number.toFixed;
    assert.isFunction(toFixed);
    assert.same(toFixed(0.00008, 3), '0.000');
    assert.same(toFixed(0.9, 0), '1');
    assert.same(toFixed(1.255, 2), '1.25');
    assert.same(toFixed(1843654265.0774949, 5), '1843654265.07749');
    assert.same(toFixed(1000000000000000128, 0), '1000000000000000128');
    assert.same(toFixed(1), '1');
    assert.same(toFixed(1, 0), '1');
    assert.same(toFixed(1, 1), '1.0');
    assert.same(toFixed(1, 1.1), '1.0');
    assert.same(toFixed(1, 0.9), '1');
    assert.same(toFixed(1, '0'), '1');
    assert.same(toFixed(1, '1'), '1.0');
    assert.same(toFixed(1, '1.1'), '1.0');
    assert.same(toFixed(1, '0.9'), '1');
    assert.same(toFixed(1, NaN), '1');
    assert.same(toFixed(1, 'some string'), '1');
    assert.same((function(){
      try {
        return toFixed(1, -0.1);
      } catch (e$) {}
    }()), '1');
    assert.same(toFixed(Object(1)), '1');
    assert.same(toFixed(Object(1), 0), '1');
    assert.same(toFixed(Object(1), 1), '1.0');
    assert.same(toFixed(Object(1), 1.1), '1.0');
    assert.same(toFixed(Object(1), 0.9), '1');
    assert.same(toFixed(Object(1), '0'), '1');
    assert.same(toFixed(Object(1), '1'), '1.0');
    assert.same(toFixed(Object(1), '1.1'), '1.0');
    assert.same(toFixed(Object(1), '0.9'), '1');
    assert.same(toFixed(Object(1), NaN), '1');
    assert.same(toFixed(Object(1), 'some string'), '1');
    assert.same((function(){
      try {
        return toFixed(Object(1), -0.1);
      } catch (e$) {}
    }()), '1');
    assert.same(toFixed(NaN), 'NaN');
    assert.same(toFixed(NaN, 0), 'NaN');
    assert.same(toFixed(NaN, 1), 'NaN');
    assert.same(toFixed(NaN, 1.1), 'NaN');
    assert.same(toFixed(NaN, 0.9), 'NaN');
    assert.same(toFixed(NaN, '0'), 'NaN');
    assert.same(toFixed(NaN, '1'), 'NaN');
    assert.same(toFixed(NaN, '1.1'), 'NaN');
    assert.same(toFixed(NaN, '0.9'), 'NaN');
    assert.same(toFixed(NaN, NaN), 'NaN');
    assert.same(toFixed(NaN, 'some string'), 'NaN');
    assert.same((function(){
      try {
        return toFixed(NaN, -0.1);
      } catch (e$) {}
    }()), 'NaN');
    assert.same(toFixed(1e21), String(1e21));
    assert.same(toFixed(1e21, 0), String(1e21));
    assert.same(toFixed(1e21, 1), String(1e21));
    assert.same(toFixed(1e21, 1.1), String(1e21));
    assert.same(toFixed(1e21, 0.9), String(1e21));
    assert.same(toFixed(1e21, '0'), String(1e21));
    assert.same(toFixed(1e21, '1'), String(1e21));
    assert.same(toFixed(1e21, '1.1'), String(1e21));
    assert.same(toFixed(1e21, '0.9'), String(1e21));
    assert.same(toFixed(1e21, NaN), String(1e21));
    assert.same(toFixed(1e21, 'some string'), String(1e21));
    assert.same((function(){
      try {
        return toFixed(1e21, -0.1);
      } catch (e$) {}
    }()), String(1e21));
    assert.throws(function(){
      toFixed(1, -101);
    }, RangeError, 'If f < 0 or f > 20, throw a RangeError exception.');
    assert.throws(function(){
      toFixed(1, 101);
    }, RangeError, 'If f < 0 or f > 20, throw a RangeError exception.');
    assert.throws(function(){
      toFixed(NaN, Infinity);
    }, RangeError, 'If f < 0 or f > 20, throw a RangeError exception.');
    assert.throws(function(){
      toFixed({}, 1);
    }, TypeError, '? thisNumberValue(this value)');
    assert.throws(function(){
      toFixed('123', 1);
    }, TypeError, '? thisNumberValue(this value)');
    assert.throws(function(){
      toFixed(false, 1);
    }, TypeError, '? thisNumberValue(this value)');
    assert.throws(function(){
      toFixed(null, 1);
    }, TypeError, '? thisNumberValue(this value)');
    assert.throws(function(){
      toFixed(void 8, 1);
    }, TypeError, '? thisNumberValue(this value)');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Number#toPrecision', function(assert){
    var toPrecision;
    toPrecision = core.Number.toPrecision;
    assert.isFunction(toPrecision);
    assert.same(toPrecision(0.00008, 3), '0.0000800', '0.00008.toPrecision(3)');
    assert.same(toPrecision(1.255, 2), '1.3', '1.255.toPrecision(2)');
    assert.same(toPrecision(1843654265.0774949, 13), '1843654265.077', '1843654265.0774949.toPrecision(13)');
    assert.same(toPrecision(NaN, 1), 'NaN', 'If x is NaN, return the String "NaN".');
    assert.same(toPrecision(123.456), '123.456', 'If precision is undefined, return ! ToString(x).');
    assert.same(toPrecision(123.456, void 8), '123.456', 'If precision is undefined, return ! ToString(x).');
    assert.throws(function(){
      toPrecision(0.9, 0);
    }, RangeError, 'If p < 1 or p > 21, throw a RangeError exception.');
    assert.throws(function(){
      toPrecision(0.9, 101);
    }, RangeError, 'If p < 1 or p > 21, throw a RangeError exception.');
    assert.throws(function(){
      toPrecision({}, 1);
    }, TypeError, '? thisNumberValue(this value)');
    assert.throws(function(){
      toPrecision('123', 1);
    }, TypeError, '? thisNumberValue(this value)');
    assert.throws(function(){
      toPrecision(false, 1);
    }, TypeError, '? thisNumberValue(this value)');
    assert.throws(function(){
      toPrecision(null, 1);
    }, TypeError, '? thisNumberValue(this value)');
    assert.throws(function(){
      toPrecision(void 8, 1);
    }, TypeError, '? thisNumberValue(this value)');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Object.assign', function(assert){
    var ref$, assign, keys, defineProperty, foo, str, c, d, D, O, string, i$, x$, len$;
    ref$ = core.Object, assign = ref$.assign, keys = ref$.keys, defineProperty = ref$.defineProperty;
    assert.isFunction(assign);
    foo = {
      q: 1
    };
    assert.strictEqual(foo, assign(foo, {
      bar: 2
    }), 'assign return target');
    assert.strictEqual(foo.bar, 2, 'assign define properties');
    assert.deepEqual(assign({}, {
      q: 1
    }, {
      w: 2
    }), {
      q: 1,
      w: 2
    });
    assert.deepEqual(assign({}, 'qwe'), {
      0: 'q',
      1: 'w',
      2: 'e'
    });
    assert.throws(function(){
      assign(null, {
        q: 1
      });
    }, TypeError);
    assert.throws(function(){
      assign(void 8, {
        q: 1
      });
    }, TypeError);
    str = assign('qwe', {
      q: 1
    });
    assert.strictEqual(typeof str, 'object');
    assert.strictEqual(String(str), 'qwe');
    assert.strictEqual(str.q, 1);
    assert.same(assign({}, {
      valueOf: 42
    }).valueOf, 42, 'IE enum keys bug');
    if (DESCRIPTORS) {
      foo = {
        baz: 1
      };
      assign(foo, defineProperty({}, 'bar', {
        get: function(){
          return this.baz + 1;
        }
      }));
      assert.ok(foo.bar === void 8, "assign don't copy descriptors");
      c = core.Symbol('c');
      d = core.Symbol('d');
      D = (ref$ = {
        a: 'a'
      }, ref$[c] = 'c', ref$);
      defineProperty(D, 'b', {
        value: 'b'
      });
      defineProperty(D, d, {
        value: 'd'
      });
      O = assign({}, D);
      assert.strictEqual(O.a, 'a', 'a');
      assert.strictEqual(O.b, void 8, 'b');
      assert.strictEqual(O[c], 'c', 'c');
      assert.strictEqual(O[d], void 8, 'd');
      try {
        assert.strictEqual(Function('return core.Object.assign({b: 1}, {get a(){delete this.b;},b: 2})')().b, 1);
      } catch (e$) {}
      try {
        assert.strictEqual(Function('return core.Object.assign({b: 1}, {get a(){Object.defineProperty(this, "b", {value:4,enumerable:false});},b: 2})')().b, 1);
      } catch (e$) {}
    }
    string = 'abcdefghijklmnopqrst';
    O = {};
    for (i$ = 0, len$ = (ref$ = string.split('')).length; i$ < len$; ++i$) {
      x$ = ref$[i$];
      O[x$] = x$;
    }
    assert.strictEqual(keys(assign({}, O)).join(''), string);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Object.create', function(assert){
    var ref$, create, getPrototypeOf, getOwnPropertyNames, isObject, isPrototype, getPropertyNames, obj, fn;
    ref$ = core.Object, create = ref$.create, getPrototypeOf = ref$.getPrototypeOf, getOwnPropertyNames = ref$.getOwnPropertyNames;
    isObject = function(it){
      return it === Object(it);
    };
    isPrototype = function(a, b){
      return {}.isPrototypeOf.call(a, b);
    };
    getPropertyNames = function(object){
      var result, i$, x$, ref$, len$;
      result = getOwnPropertyNames(object);
      while (object = getPrototypeOf(object)) {
        for (i$ = 0, len$ = (ref$ = getOwnPropertyNames(object)).length; i$ < len$; ++i$) {
          x$ = ref$[i$];
          in$(x$, result) || result.push(x$);
        }
      }
      return result;
    };
    assert.isFunction(create);
    assert.arity(create, 2);
    assert.ok(isPrototype(obj = {
      q: 1
    }, create(obj)));
    assert.ok(create(obj).q === 1);
    fn = function(){
      return this.a = 1;
    };
    assert.ok(create(new fn) instanceof fn);
    assert.ok(fn.prototype === getPrototypeOf(getPrototypeOf(create(new fn))));
    assert.ok(create(new fn).a === 1);
    assert.ok(create({}, {
      a: {
        value: 42
      }
    }).a === 42);
    assert.ok(isObject(obj = create(null, {
      w: {
        value: 2
      }
    })));
    assert.ok(!('toString' in obj));
    assert.ok(obj.w === 2);
    assert.deepEqual(getPropertyNames(create(null)), []);
  });
  function in$(x, xs){
    var i = -1, l = xs.length >>> 0;
    while (++i < l) if (x === xs[i]) return true;
    return false;
  }
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Object.defineProperties', function(assert){
    var defineProperties, rez, src;
    defineProperties = core.Object.defineProperties;
    assert.isFunction(defineProperties);
    assert.arity(defineProperties, 2);
    assert.ok((rez = defineProperties(src = {}, {
      q: {
        value: 42
      },
      w: {
        value: 33
      }
    })) === src);
    assert.ok(rez.q === 42) && rez.w === 33;
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Object.defineProperty', function(assert){
    var ref$, defineProperty, create, rez, src;
    ref$ = core.Object, defineProperty = ref$.defineProperty, create = ref$.create;
    assert.isFunction(defineProperty);
    assert.arity(defineProperty, 3);
    assert.ok((rez = defineProperty(src = {}, 'q', {
      value: 42
    })) === src);
    assert.ok(rez.q === 42);
    assert.throws(function(){
      defineProperty(42, 1, {});
    });
    assert.throws(function(){
      defineProperty({}, create(null), {});
    });
    assert.throws(function(){
      defineProperty({}, 1, 1);
    });
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, toString$ = {}.toString;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Object.freeze', function(assert){
    var ref$, freeze, keys, getOwnPropertyNames, getOwnPropertySymbols, ownKeys, i$, len$, value, key;
    ref$ = core.Object, freeze = ref$.freeze, keys = ref$.keys, getOwnPropertyNames = ref$.getOwnPropertyNames, getOwnPropertySymbols = ref$.getOwnPropertySymbols;
    ownKeys = core.Reflect.ownKeys;
    assert.isFunction(freeze);
    assert.arity(freeze, 1);
    for (i$ = 0, len$ = (ref$ = [42, 'foo', false, null, void 8, {}]).length; i$ < len$; ++i$) {
      value = ref$[i$];
      assert.ok((fn$()), "accept " + toString$.call(value).slice(8, -1));
      assert.same(freeze(value), value, "returns target on " + toString$.call(value).slice(8, -1));
    }
    assert.arrayEqual((function(){
      var results$ = [];
      for (key in freeze({})) {
        results$.push(key);
      }
      return results$;
    }()), []);
    assert.arrayEqual(keys(freeze({})), []);
    assert.arrayEqual(getOwnPropertyNames(freeze({})), []);
    assert.arrayEqual(getOwnPropertySymbols(freeze({})), []);
    assert.arrayEqual(ownKeys(freeze({})), []);
    function fn$(){
      try {
        freeze(value);
        return true;
      } catch (e$) {}
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, toString$ = {}.toString;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Object.getOwnPropertyDescriptor', function(assert){
    var getOwnPropertyDescriptor, i$, ref$, len$, value;
    getOwnPropertyDescriptor = core.Object.getOwnPropertyDescriptor;
    assert.isFunction(getOwnPropertyDescriptor);
    assert.arity(getOwnPropertyDescriptor, 2);
    assert.deepEqual(getOwnPropertyDescriptor({
      q: 42
    }, 'q'), {
      writable: true,
      enumerable: true,
      configurable: true,
      value: 42
    });
    assert.ok(getOwnPropertyDescriptor({}, 'toString') === void 8);
    for (i$ = 0, len$ = (ref$ = [42, 'foo', false]).length; i$ < len$; ++i$) {
      value = ref$[i$];
      assert.ok((fn$()), "accept " + toString$.call(value).slice(8, -1));
    }
    for (i$ = 0, len$ = (ref$ = [null, void 8]).length; i$ < len$; ++i$) {
      value = ref$[i$];
      assert.throws(fn1$, TypeError, "throws on " + value);
    }
    function fn$(){
      try {
        getOwnPropertyDescriptor(value);
        return true;
      } catch (e$) {}
    }
    function fn1$(){
      getOwnPropertyDescriptor(value);
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, toString$ = {}.toString;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Object.getOwnPropertyNames', function(assert){
    var getOwnPropertyNames, fn1, fn2, names, i$, ref$, len$, value, iframe, w;
    getOwnPropertyNames = core.Object.getOwnPropertyNames;
    assert.isFunction(getOwnPropertyNames);
    assert.arity(getOwnPropertyNames, 1);
    fn1 = function(w){
      this.w = w != null ? w : 2;
    };
    fn2 = function(toString){
      this.toString = toString != null ? toString : 2;
    };
    fn1.prototype.q = fn2.prototype.q = 1;
    names = getOwnPropertyNames([1, 2, 3]);
    assert.strictEqual(names.length, 4);
    assert.ok(in$('0', names));
    assert.ok(in$('1', names));
    assert.ok(in$('2', names));
    assert.ok(in$('length', names));
    assert.deepEqual(getOwnPropertyNames(new fn1(1)), ['w']);
    assert.deepEqual(getOwnPropertyNames(new fn2(1)), ['toString']);
    assert.ok(in$('toString', getOwnPropertyNames(Array.prototype)));
    assert.ok(in$('toString', getOwnPropertyNames(Object.prototype)));
    assert.ok(in$('constructor', getOwnPropertyNames(Object.prototype)));
    for (i$ = 0, len$ = (ref$ = [42, 'foo', false]).length; i$ < len$; ++i$) {
      value = ref$[i$];
      assert.ok((fn$()), "accept " + toString$.call(value).slice(8, -1));
    }
    for (i$ = 0, len$ = (ref$ = [null, void 8]).length; i$ < len$; ++i$) {
      value = ref$[i$];
      assert.throws(fn1$, TypeError, "throws on " + value);
    }
    if (typeof document != 'undefined' && document !== null) {
      assert.ok((function(){
        try {
          iframe = document.createElement('iframe');
          iframe.src = 'http://example.com';
          document.documentElement.appendChild(iframe);
          w = iframe.contentWindow;
          document.documentElement.removeChild(iframe);
          return getOwnPropertyNames(w);
        } catch (e$) {}
      }()), 'IE11 bug with iframe and window');
    }
    function fn$(){
      try {
        getOwnPropertyNames(value);
        return true;
      } catch (e$) {}
    }
    function fn1$(){
      getOwnPropertyNames(value);
    }
  });
  function in$(x, xs){
    var i = -1, l = xs.length >>> 0;
    while (++i < l) if (x === xs[i]) return true;
    return false;
  }
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, toString$ = {}.toString;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Object.getPrototypeOf', function(assert){
    var ref$, create, getPrototypeOf, fn, obj, foo, bar, i$, len$, value;
    ref$ = core.Object, create = ref$.create, getPrototypeOf = ref$.getPrototypeOf;
    assert.isFunction(getPrototypeOf);
    assert.arity(getPrototypeOf, 1);
    assert.ok(getPrototypeOf({}) === Object.prototype);
    assert.ok(getPrototypeOf([]) === Array.prototype);
    assert.ok(getPrototypeOf(new (fn = (function(){
      fn.displayName = 'fn';
      var prototype = fn.prototype, constructor = fn;
      function fn(){}
      return fn;
    }()))) === fn.prototype);
    assert.ok(getPrototypeOf(create(obj = {
      q: 1
    })) === obj);
    assert.ok(getPrototypeOf(create(null)) === null);
    assert.ok(getPrototypeOf(getPrototypeOf({})) === null);
    foo = function(){};
    foo.prototype.foo = 'foo';
    bar = function(){};
    bar.prototype = create(foo.prototype);
    bar.prototype.constructor = bar;
    assert.strictEqual(getPrototypeOf(bar.prototype).foo, 'foo');
    for (i$ = 0, len$ = (ref$ = [42, 'foo', false]).length; i$ < len$; ++i$) {
      value = ref$[i$];
      assert.ok((fn$()), "accept " + toString$.call(value).slice(8, -1));
    }
    for (i$ = 0, len$ = (ref$ = [null, void 8]).length; i$ < len$; ++i$) {
      value = ref$[i$];
      assert.throws(fn1$, TypeError, "throws on " + value);
    }
    assert.strictEqual(getPrototypeOf('foo'), String.prototype);
    function fn$(){
      try {
        getPrototypeOf(value);
        return true;
      } catch (e$) {}
    }
    function fn1$(){
      getPrototypeOf(value);
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, toString$ = {}.toString;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Object.isExtensible', function(assert){
    var isExtensible, i$, ref$, len$, value;
    isExtensible = core.Object.isExtensible;
    assert.isFunction(isExtensible);
    assert.arity(isExtensible, 1);
    for (i$ = 0, len$ = (ref$ = [42, 'foo', false, null, void 8]).length; i$ < len$; ++i$) {
      value = ref$[i$];
      assert.ok((fn$()), "accept " + toString$.call(value).slice(8, -1));
      assert.same(isExtensible(value), false, "returns true on " + toString$.call(value).slice(8, -1));
    }
    assert.same(isExtensible({}), true);
    function fn$(){
      try {
        isExtensible(value);
        return true;
      } catch (e$) {}
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, toString$ = {}.toString;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Object.isFrozen', function(assert){
    var isFrozen, i$, ref$, len$, value;
    isFrozen = core.Object.isFrozen;
    assert.isFunction(isFrozen);
    assert.arity(isFrozen, 1);
    for (i$ = 0, len$ = (ref$ = [42, 'foo', false, null, void 8]).length; i$ < len$; ++i$) {
      value = ref$[i$];
      assert.ok((fn$()), "accept " + toString$.call(value).slice(8, -1));
      assert.same(isFrozen(value), true, "returns true on " + toString$.call(value).slice(8, -1));
    }
    assert.same(isFrozen({}), false);
    function fn$(){
      try {
        isFrozen(value);
        return true;
      } catch (e$) {}
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, toString$ = {}.toString;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Object.isSealed', function(assert){
    var isSealed, i$, ref$, len$, value;
    isSealed = core.Object.isSealed;
    assert.isFunction(isSealed);
    assert.arity(isSealed, 1);
    for (i$ = 0, len$ = (ref$ = [42, 'foo', false, null, void 8]).length; i$ < len$; ++i$) {
      value = ref$[i$];
      assert.ok((fn$()), "accept " + toString$.call(value).slice(8, -1));
      assert.same(isSealed(value), true, "returns true on " + toString$.call(value).slice(8, -1));
    }
    assert.same(isSealed({}), false);
    function fn$(){
      try {
        isSealed(value);
        return true;
      } catch (e$) {}
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Object.is', function(assert){
    var same;
    same = core.Object.is;
    assert.isFunction(same);
    assert.ok(same(1, 1), '1 is 1');
    assert.ok(same(NaN, NaN), '1 is 1');
    assert.ok(!same(0, -0), '0 isnt -0');
    assert.ok(!same({}, {}), '{} isnt {}');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, toString$ = {}.toString;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Object.keys', function(assert){
    var keys, fn1, fn2, i$, ref$, len$, value;
    keys = core.Object.keys;
    assert.isFunction(keys);
    assert.arity(keys, 1);
    fn1 = function(w){
      this.w = w != null ? w : 2;
    };
    fn2 = function(toString){
      this.toString = toString != null ? toString : 2;
    };
    fn1.prototype.q = fn2.prototype.q = 1;
    assert.deepEqual(keys([1, 2, 3]), ['0', '1', '2']);
    assert.deepEqual(keys(new fn1(1)), ['w']);
    assert.deepEqual(keys(new fn2(1)), ['toString']);
    assert.ok(!in$('push', keys(Array.prototype)));
    for (i$ = 0, len$ = (ref$ = [42, 'foo', false]).length; i$ < len$; ++i$) {
      value = ref$[i$];
      assert.ok((fn$()), "accept " + toString$.call(value).slice(8, -1));
    }
    for (i$ = 0, len$ = (ref$ = [null, void 8]).length; i$ < len$; ++i$) {
      value = ref$[i$];
      assert.throws(fn1$, TypeError, "throws on " + value);
    }
    function fn$(){
      try {
        keys(value);
        return true;
      } catch (e$) {}
    }
    function fn1$(){
      keys(value);
    }
  });
  function in$(x, xs){
    var i = -1, l = xs.length >>> 0;
    while (++i < l) if (x === xs[i]) return true;
    return false;
  }
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, toString$ = {}.toString;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Object.preventExtensions', function(assert){
    var ref$, preventExtensions, keys, getOwnPropertyNames, getOwnPropertySymbols, ownKeys, i$, len$, value, key;
    ref$ = core.Object, preventExtensions = ref$.preventExtensions, keys = ref$.keys, getOwnPropertyNames = ref$.getOwnPropertyNames, getOwnPropertySymbols = ref$.getOwnPropertySymbols;
    ownKeys = core.Reflect.ownKeys;
    assert.isFunction(preventExtensions);
    assert.arity(preventExtensions, 1);
    for (i$ = 0, len$ = (ref$ = [42, 'foo', false, null, void 8, {}]).length; i$ < len$; ++i$) {
      value = ref$[i$];
      assert.ok((fn$()), "accept " + toString$.call(value).slice(8, -1));
      assert.same(preventExtensions(value), value, "returns target on " + toString$.call(value).slice(8, -1));
    }
    assert.arrayEqual((function(){
      var results$ = [];
      for (key in preventExtensions({})) {
        results$.push(key);
      }
      return results$;
    }()), []);
    assert.arrayEqual(keys(preventExtensions({})), []);
    assert.arrayEqual(getOwnPropertyNames(preventExtensions({})), []);
    assert.arrayEqual(getOwnPropertySymbols(preventExtensions({})), []);
    assert.arrayEqual(ownKeys(preventExtensions({})), []);
    function fn$(){
      try {
        preventExtensions(value);
        return true;
      } catch (e$) {}
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, toString$ = {}.toString;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Object.seal', function(assert){
    var ref$, seal, keys, getOwnPropertyNames, getOwnPropertySymbols, ownKeys, i$, len$, value, key;
    ref$ = core.Object, seal = ref$.seal, keys = ref$.keys, getOwnPropertyNames = ref$.getOwnPropertyNames, getOwnPropertySymbols = ref$.getOwnPropertySymbols;
    ownKeys = core.Reflect.ownKeys;
    assert.isFunction(seal);
    assert.arity(seal, 1);
    for (i$ = 0, len$ = (ref$ = [42, 'foo', false, null, void 8, {}]).length; i$ < len$; ++i$) {
      value = ref$[i$];
      assert.ok((fn$()), "accept " + toString$.call(value).slice(8, -1));
      assert.same(seal(value), value, "returns target on " + toString$.call(value).slice(8, -1));
    }
    assert.arrayEqual((function(){
      var results$ = [];
      for (key in seal({})) {
        results$.push(key);
      }
      return results$;
    }()), []);
    assert.arrayEqual(keys(seal({})), []);
    assert.arrayEqual(getOwnPropertyNames(seal({})), []);
    assert.arrayEqual(getOwnPropertySymbols(seal({})), []);
    assert.arrayEqual(ownKeys(seal({})), []);
    function fn$(){
      try {
        seal(value);
        return true;
      } catch (e$) {}
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  if (PROTO) {
    module = QUnit.module, test = QUnit.test;
    module('ES6');
    test('Object.setPrototypeOf', function(assert){
      var setPrototypeOf, tmp;
      setPrototypeOf = core.Object.setPrototypeOf;
      assert.isFunction(setPrototypeOf);
      assert.ok('apply' in setPrototypeOf({}, Function.prototype), 'Parent properties in target');
      assert.strictEqual(setPrototypeOf({
        a: 2
      }, {
        b: function(){
          return Math.pow(this.a, 2);
        }
      }).b(), 4, 'Child and parent properties in target');
      assert.strictEqual(setPrototypeOf(tmp = {}, {
        a: 1
      }), tmp, 'setPrototypeOf return target');
      assert.ok(!('toString' in setPrototypeOf({}, null)), 'Can set null as prototype');
    });
  }
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('parseFloat', function(assert){
    var parseFloat, ws;
    parseFloat = core.parseFloat;
    assert.isFunction(parseFloat);
    assert.arity(parseFloat, 1);
    assert.same(parseFloat('0'), 0);
    assert.same(parseFloat(' 0'), 0);
    assert.same(parseFloat('+0'), 0);
    assert.same(parseFloat(' +0'), 0);
    assert.same(parseFloat('-0'), -0);
    assert.same(parseFloat(' -0'), -0);
    ws = '\x09\x0A\x0B\x0C\x0D\x20\xA0\u1680\u180E\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u3000\u2028\u2029\uFEFF';
    assert.same(parseFloat(ws + '+0'), 0);
    assert.same(parseFloat(ws + '-0'), -0);
    assert.same(parseFloat(null), NaN);
    assert.same(parseFloat(void 8), NaN);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('parseInt', function(assert){
    var parseInt, i$, r, x$, ref$, len$, ws, fakeZero;
    parseInt = core.parseInt;
    assert.isFunction(parseInt);
    assert.arity(parseInt, 2);
    for (i$ = 2; i$ <= 36; ++i$) {
      r = i$;
      assert.same(parseInt('10', r), r, "radix " + r);
    }
    for (i$ = 0, len$ = (ref$ = ['01', '08', '10', '42']).length; i$ < len$; ++i$) {
      x$ = ref$[i$];
      assert.same(parseInt(x$), parseInt(x$, 10), "default radix is 10: " + x$);
    }
    assert.same(parseInt('0x16'), parseInt('0x16', 16), "default radix is 16: 0x16");
    ws = '\x09\x0A\x0B\x0C\x0D\x20\xA0\u1680\u180E\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u3000\u2028\u2029\uFEFF';
    assert.same(parseInt('  0x16'), parseInt('0x16', 16), 'ignores leading whitespace #1');
    assert.same(parseInt('  42'), parseInt('42', 10), 'ignores leading whitespace #2');
    assert.same(parseInt('  08'), parseInt('08', 10), 'ignores leading whitespace #3');
    assert.same(parseInt(ws + '08'), parseInt('08', 10), 'ignores leading whitespace #4');
    assert.same(parseInt(ws + '0x16'), parseInt('0x16', 16), 'ignores leading whitespace #5');
    fakeZero = {
      valueOf: function(){
        return 0;
      }
    };
    assert.same(parseInt('08', fakeZero), parseInt('08', 10), 'valueOf #1');
    assert.same(parseInt('0x16', fakeZero), parseInt('0x16', 16), 'valueOf #2');
    assert.same(parseInt('-0xF'), -15, 'signed hex #1');
    assert.same(parseInt('-0xF', 16), -15, 'signed hex #2');
    assert.same(parseInt('+0xF'), 15, 'signed hex #3');
    assert.same(parseInt('+0xF', 16), 15, 'signed hex #4');
    assert.same(parseInt('10', -4294967294), 2, 'radix uses ToUint32');
    assert.same(parseInt(null), NaN);
    assert.same(parseInt(void 8), NaN);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  'use strict';
  var module, test, Promise, Symbol, iterator;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  Promise = core.Promise, Symbol = core.Symbol;
  iterator = Symbol.iterator;
  test('Promise', function(assert){
    assert.isFunction(Promise);
    assert.throws(function(){
      Promise();
    }, 'throws w/o `new`');
    new Promise(function(resolve, reject){
      assert.isFunction(Promise, 'resolver is function');
      assert.isFunction(Promise, 'rejector is function');
      assert.same(this, function(){
        return this;
      }(), 'correct executor context');
    });
  });
  if (DESCRIPTORS) {
    test('Promise operations order', function(assert){
      var expected, async, result, resolve, p, resolve2, p2;
      assert.expect(1);
      expected = 'DEHAFGBC';
      async = assert.async();
      result = '';
      p = new Promise(function(r){
        resolve = r;
      });
      resolve({
        then: function(){
          result += 'A';
          throw Error();
        }
      });
      p['catch'](function(){
        result += 'B';
      });
      p['catch'](function(){
        result += 'C';
        assert.same(result, expected);
        async();
      });
      p2 = new Promise(function(r){
        resolve2 = r;
      });
      resolve2(Object.defineProperty({}, 'then', {
        get: function(){
          result += 'D';
          throw Error();
        }
      }));
      result += 'E';
      p2['catch'](function(){
        result += 'F';
      });
      p2['catch'](function(){
        result += 'G';
      });
      result += 'H';
      setTimeout(function(){
        if (~result.indexOf('C')) {
          assert.same(result, expected);
        }
      }, 1e3);
    });
  }
  test('Promise#then', function(assert){
    var promise, FakePromise1, FakePromise2;
    assert.isFunction(Promise.prototype.then);
    assert.nonEnumerable(Promise.prototype, 'then');
    promise = new Promise(function(it){
      it(42);
    });
    promise.constructor = FakePromise1 = function(it){
      it(function(){}, function(){});
    };
    FakePromise1[Symbol != null ? Symbol.species : void 8] = FakePromise2 = function(it){
      it(function(){}, function(){});
    };
    assert.ok(promise.then(function(){}) instanceof FakePromise2, 'subclassing, @@species pattern');
    promise = new Promise(function(it){
      it(42);
    });
    promise.constructor = FakePromise1 = function(it){
      it(function(){}, function(){});
    };
    assert.ok(promise.then(function(){}) instanceof Promise, 'subclassing, incorrect `this` pattern');
    promise = new Promise(function(it){
      it(42);
    });
    promise.constructor = FakePromise1 = function(it){
      it(function(){}, function(){});
    };
    FakePromise1[Symbol != null ? Symbol.species : void 8] = function(){};
    assert.throws(function(){
      promise.then(function(){});
    }, 'NewPromiseCapability validations, #1');
    FakePromise1[Symbol != null ? Symbol.species : void 8] = function(it){
      it(null, function(){});
    };
    assert.throws(function(){
      promise.then(function(){});
    }, 'NewPromiseCapability validations, #2');
    FakePromise1[Symbol != null ? Symbol.species : void 8] = function(it){
      it(function(){}, null);
    };
    assert.throws(function(){
      promise.then(function(){});
    }, 'NewPromiseCapability validations, #3');
  });
  test('Promise#catch', function(assert){
    var promise, FakePromise1, FakePromise2;
    assert.isFunction(Promise.prototype['catch']);
    assert.nonEnumerable(Promise.prototype, 'catch');
    promise = new Promise(function(it){
      it(42);
    });
    promise.constructor = FakePromise1 = function(it){
      it(function(){}, function(){});
    };
    FakePromise1[Symbol != null ? Symbol.species : void 8] = FakePromise2 = function(it){
      it(function(){}, function(){});
    };
    assert.ok(promise['catch'](function(){}) instanceof FakePromise2, 'subclassing, @@species pattern');
    promise = new Promise(function(it){
      it(42);
    });
    promise.constructor = FakePromise1 = function(it){
      it(function(){}, function(){});
    };
    assert.ok(promise['catch'](function(){}) instanceof Promise, 'subclassing, incorrect `this` pattern');
    promise = new Promise(function(it){
      it(42);
    });
    promise.constructor = FakePromise1 = function(it){
      it(function(){}, function(){});
    };
    FakePromise1[Symbol != null ? Symbol.species : void 8] = function(){};
    assert.throws(function(){
      promise['catch'](function(){});
    }, 'NewPromiseCapability validations, #1');
    FakePromise1[Symbol != null ? Symbol.species : void 8] = function(it){
      it(null, function(){});
    };
    assert.throws(function(){
      promise['catch'](function(){});
    }, 'NewPromiseCapability validations, #2');
    FakePromise1[Symbol != null ? Symbol.species : void 8] = function(it){
      it(function(){}, null);
    };
    assert.throws(function(){
      promise['catch'](function(){});
    }, 'NewPromiseCapability validations, #3');
    assert.same(Promise.prototype['catch'].call({
      then: function(x, y){
        return y;
      }
    }, 42), 42, 'calling `.then`');
  });
  test('Promise#@@toStringTag', function(assert){
    assert.ok(Promise.prototype[Symbol != null ? Symbol.toStringTag : void 8] === 'Promise', 'Promise::@@toStringTag is `Promise`');
  });
  test('Promise.all', function(assert){
    var all, iter, a, done, resolve, FakePromise1, FakePromise2, FakePromise3;
    all = Promise.all;
    assert.isFunction(all);
    assert.arity(all, 1);
    iter = createIterable([1, 2, 3]);
    Promise.all(iter)['catch'](function(){});
    assert.ok(iter.received, 'works with iterables: iterator received');
    assert.ok(iter.called, 'works with iterables: next called');
    a = [];
    done = false;
    a['@@iterator'] = void 8;
    a[Symbol != null ? Symbol.iterator : void 8] = function(){
      done = true;
      return core.getIteratorMethod([]).call(this);
    };
    Promise.all(a);
    assert.ok(done);
    assert.throws(function(){
      all.call(null, [])['catch'](function(){});
    }, TypeError, 'throws without context');
    done = false;
    resolve = Promise.resolve;
    try {
      Promise.resolve = function(){
        throw 42;
      };
      Promise.all(createIterable([1, 2, 3], {
        'return': function(){
          done = true;
        }
      }))['catch'](function(){});
    } catch (e$) {}
    Promise.resolve = resolve;
    assert.ok(done, 'iteration closing');
    FakePromise1 = function(it){
      it(function(){}, function(){});
    };
    FakePromise1[Symbol != null ? Symbol.species : void 8] = FakePromise2 = function(it){
      it(function(){}, function(){});
    };
    FakePromise1.resolve = FakePromise2.resolve = bind$(Promise, 'resolve');
    assert.ok(all.call(FakePromise1, [1, 2, 3]) instanceof FakePromise1, 'subclassing, `this` pattern');
    FakePromise1 = function(){};
    FakePromise2 = function(it){
      it(null, function(){});
    };
    FakePromise3 = function(it){
      it(function(){}, null);
    };
    FakePromise1.resolve = FakePromise2.resolve = FakePromise3.resolve = bind$(Promise, 'resolve');
    assert.throws(function(){
      all.call(FakePromise1, [1, 2, 3]);
    }, 'NewPromiseCapability validations, #1');
    assert.throws(function(){
      all.call(FakePromise2, [1, 2, 3]);
    }, 'NewPromiseCapability validations, #2');
    assert.throws(function(){
      all.call(FakePromise3, [1, 2, 3]);
    }, 'NewPromiseCapability validations, #3');
  });
  test('Promise.race', function(assert){
    var race, iter, a, done, resolve, FakePromise1, FakePromise2, FakePromise3;
    race = Promise.race;
    assert.isFunction(race);
    assert.arity(race, 1);
    iter = createIterable([1, 2, 3]);
    Promise.race(iter)['catch'](function(){});
    assert.ok(iter.received, 'works with iterables: iterator received');
    assert.ok(iter.called, 'works with iterables: next called');
    a = [];
    done = false;
    a['@@iterator'] = void 8;
    a[Symbol != null ? Symbol.iterator : void 8] = function(){
      done = true;
      return core.getIteratorMethod([]).call(this);
    };
    Promise.race(a);
    assert.ok(done);
    assert.throws(function(){
      race.call(null, [])['catch'](function(){});
    }, TypeError, 'throws without context');
    done = false;
    resolve = Promise.resolve;
    try {
      Promise.resolve = function(){
        throw 42;
      };
      Promise.race(createIterable([1, 2, 3], {
        'return': function(){
          done = true;
        }
      }))['catch'](function(){});
    } catch (e$) {}
    Promise.resolve = resolve;
    assert.ok(done, 'iteration closing');
    FakePromise1 = function(it){
      it(function(){}, function(){});
    };
    FakePromise1[Symbol != null ? Symbol.species : void 8] = FakePromise2 = function(it){
      it(function(){}, function(){});
    };
    FakePromise1.resolve = FakePromise2.resolve = bind$(Promise, 'resolve');
    assert.ok(race.call(FakePromise1, [1, 2, 3]) instanceof FakePromise1, 'subclassing, `this` pattern');
    FakePromise1 = function(){};
    FakePromise2 = function(it){
      it(null, function(){});
    };
    FakePromise3 = function(it){
      it(function(){}, null);
    };
    FakePromise1.resolve = FakePromise2.resolve = FakePromise3.resolve = bind$(Promise, 'resolve');
    assert.throws(function(){
      race.call(FakePromise1, [1, 2, 3]);
    }, 'NewPromiseCapability validations, #1');
    assert.throws(function(){
      race.call(FakePromise2, [1, 2, 3]);
    }, 'NewPromiseCapability validations, #2');
    assert.throws(function(){
      race.call(FakePromise3, [1, 2, 3]);
    }, 'NewPromiseCapability validations, #3');
  });
  test('Promise.resolve', function(assert){
    var resolve, FakePromise1, FakePromise2;
    resolve = Promise.resolve;
    assert.isFunction(resolve);
    assert.throws(function(){
      resolve.call(null, 1)['catch'](function(){});
    }, TypeError, 'throws without context');
    FakePromise1 = function(it){
      it(function(){}, function(){});
    };
    FakePromise1[Symbol != null ? Symbol.species : void 8] = FakePromise2 = function(it){
      it(function(){}, function(){});
    };
    assert.ok(resolve.call(FakePromise1, 42) instanceof FakePromise1, 'subclassing, `this` pattern');
    assert.throws(function(){
      resolve.call(function(){}, 42);
    }, 'NewPromiseCapability validations, #1');
    assert.throws(function(){
      resolve.call(function(it){
        it(null, function(){});
      }, 42);
    }, 'NewPromiseCapability validations, #2');
    assert.throws(function(){
      resolve.call(function(it){
        it(function(){}, null);
      }, 42);
    }, 'NewPromiseCapability validations, #3');
  });
  test('Promise.reject', function(assert){
    var reject, FakePromise1, FakePromise2;
    reject = Promise.reject;
    assert.isFunction(reject);
    assert.throws(function(){
      reject.call(null, 1)['catch'](function(){});
    }, TypeError, 'throws without context');
    FakePromise1 = function(it){
      it(function(){}, function(){});
    };
    FakePromise1[Symbol != null ? Symbol.species : void 8] = FakePromise2 = function(it){
      it(function(){}, function(){});
    };
    assert.ok(reject.call(FakePromise1, 42) instanceof FakePromise1, 'subclassing, `this` pattern');
    assert.throws(function(){
      reject.call(function(){}, 42);
    }, 'NewPromiseCapability validations, #1');
    assert.throws(function(){
      reject.call(function(it){
        it(null, function(){});
      }, 42);
    }, 'NewPromiseCapability validations, #2');
    assert.throws(function(){
      reject.call(function(it){
        it(function(){}, null);
      }, 42);
    }, 'NewPromiseCapability validations, #3');
  });
  if (PROTO) {
    test('Promise subclassing', function(assert){
      var SubPromise, p1, p2, p3;
      SubPromise = function(it){
        var self;
        self = new Promise(it);
        core.Object.setPrototypeOf(self, SubPromise.prototype);
        self.mine = 'subclass';
        return self;
      };
      core.Object.setPrototypeOf(SubPromise, Promise);
      SubPromise.prototype = core.Object.create(Promise.prototype);
      SubPromise.prototype.constructor = SubPromise;
      p1 = SubPromise.resolve(5);
      assert.strictEqual(p1.mine, 'subclass');
      p1 = p1.then(function(it){
        return assert.strictEqual(it, 5);
      });
      assert.strictEqual(p1.mine, 'subclass');
      p2 = new SubPromise(function(it){
        return it(6);
      });
      assert.strictEqual(p2.mine, 'subclass');
      p2 = p2.then(function(it){
        return assert.strictEqual(it, 6);
      });
      assert.strictEqual(p2.mine, 'subclass');
      p3 = SubPromise.all([p1, p2]);
      assert.strictEqual(p3.mine, 'subclass');
      assert.ok(p3 instanceof Promise);
      assert.ok(p3 instanceof SubPromise);
      p3.then(assert.async(), function(it){
        return assert.ok(it, false);
      });
    });
  }
  QUnit.skip('Unhandled rejection tracking', function(assert){
    var done, start, onunhandledrejection, onrejectionhandled, $promise;
    done = false;
    start = assert.async();
    if (typeof process != 'undefined' && process !== null) {
      assert.expect(3);
      process.on('unhandledRejection', onunhandledrejection = function(reason, promise){
        process.removeListener('unhandledRejection', onunhandledrejection);
        assert.same(promise, $promise, 'unhandledRejection, promise');
        assert.same(reason, 42, 'unhandledRejection, reason');
        $promise['catch'](function(){});
      });
      process.on('rejectionHandled', onrejectionhandled = function(promise){
        process.removeListener('rejectionHandled', onrejectionhandled);
        assert.same(promise, $promise, 'rejectionHandled, promise');
        done || start();
        done = true;
      });
    } else {
      assert.expect(4);
      global.onunhandledrejection = function(it){
        assert.same(it.promise, $promise, 'onunhandledrejection, promise');
        assert.same(it.reason, 42, 'onunhandledrejection, reason');
        setTimeout(function(){
          $promise['catch'](function(){});
        }, 1);
        global.onunhandledrejection = null;
      };
      global.onrejectionhandled = function(it){
        assert.same(it.promise, $promise, 'onrejectionhandled, promise');
        assert.same(it.reason, 42, 'onrejectionhandled, reason');
        global.onrejectionhandled = null;
        done || start();
        done = true;
      };
    }
    Promise.reject(43)['catch'](function(){});
    $promise = Promise.reject(42);
    setTimeout(function(){
      done || start();
      done = true;
    }, 3e3);
  });
  function bind$(obj, key, target){
    return function(){ return (target || obj)[key].apply(obj, arguments) };
  }
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Reflect.apply', function(assert){
    var apply, C;
    apply = core.Reflect.apply;
    assert.isFunction(apply);
    assert.arity(apply, 3);
    if ('name' in apply) {
      assert.name(apply, 'apply');
    }
    assert.strictEqual(apply(Array.prototype.push, [1, 2], [3, 4, 5]), 5);
    C = function(a, b, c){
      return a + b + c;
    };
    C.apply = 42;
    assert.strictEqual(apply(C, null, ['foo', 'bar', 'baz']), 'foobarbaz', 'works with redefined apply');
    assert.throws(function(){
      apply(42, null, []);
    }, TypeError, 'throws on primitive');
    assert.throws(function(){
      apply(function(){}, null);
    }, TypeError, 'throws without third argument');
    assert.throws(function(){
      apply(function(){}, null, '123');
    }, TypeError, 'throws on primitive as third argument');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, getPrototypeOf;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  getPrototypeOf = core.Object.getPrototypeOf;
  test('Reflect.construct', function(assert){
    var construct, C, inst, f, e;
    construct = core.Reflect.construct;
    assert.isFunction(construct);
    assert.arity(construct, 2);
    if ('name' in construct) {
      assert.name(construct, 'construct');
    }
    C = function(a, b, c){
      return this.qux = a + b + c;
    };
    assert.strictEqual(construct(C, ['foo', 'bar', 'baz']).qux, 'foobarbaz', 'basic');
    C.apply = 42;
    assert.strictEqual(construct(C, ['foo', 'bar', 'baz']).qux, 'foobarbaz', 'works with redefined apply');
    inst = construct(function(){
      this.x = 42;
    }, [], Array);
    assert.strictEqual(inst.x, 42, 'constructor with newTarget');
    assert.ok(inst instanceof Array, 'prototype with newTarget');
    assert.throws(function(){
      construct(42, []);
    }, TypeError, 'throws on primitive');
    f = function(){};
    f.prototype = 42;
    assert.ok((function(){
      try {
        return getPrototypeOf(construct(f, [])) === Object.prototype;
      } catch (e$) {
        e = e$;
        return false;
      }
    }()));
    assert.same(typeof (function(){
      try {
        return construct(Date, []).getTime();
      } catch (e$) {}
    }()), 'number', 'works with native constructors with 2 arguments');
    assert.throws(function(){
      construct(function(){});
    }, 'throws when the second argument is not an object');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, ref$, defineProperty, getOwnPropertyDescriptor;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  ref$ = core.Object, defineProperty = ref$.defineProperty, getOwnPropertyDescriptor = ref$.getOwnPropertyDescriptor;
  test('Reflect.defineProperty', function(assert){
    var defineProperty, create, O;
    defineProperty = core.Reflect.defineProperty;
    create = core.Object.create;
    assert.isFunction(defineProperty);
    assert.arity(defineProperty, 3);
    if ('name' in defineProperty) {
      assert.name(defineProperty, 'defineProperty');
    }
    O = {};
    assert.strictEqual(defineProperty(O, 'foo', {
      value: 123
    }), true);
    assert.strictEqual(O.foo, 123);
    if (DESCRIPTORS) {
      O = {};
      defineProperty(O, 'foo', {
        value: 123,
        enumerable: true
      });
      assert.deepEqual(getOwnPropertyDescriptor(O, 'foo'), {
        value: 123,
        enumerable: true,
        configurable: false,
        writable: false
      });
      assert.strictEqual(defineProperty(O, 'foo', {
        value: 42
      }), false);
    }
    assert.throws(function(){
      defineProperty(42, 'foo', {
        value: 42
      });
    }, TypeError, 'throws on primitive');
    assert.throws(function(){
      defineProperty(42, 1, {});
    });
    assert.throws(function(){
      defineProperty({}, create(null), {});
    });
    assert.throws(function(){
      defineProperty({}, 1, 1);
    });
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, defineProperty;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  defineProperty = core.Object.defineProperty;
  test('Reflect.deleteProperty', function(assert){
    var deleteProperty, O;
    deleteProperty = core.Reflect.deleteProperty;
    assert.isFunction(deleteProperty);
    assert.arity(deleteProperty, 2);
    if ('name' in deleteProperty) {
      assert.name(deleteProperty, 'deleteProperty');
    }
    O = {
      bar: 456
    };
    assert.strictEqual(deleteProperty(O, 'bar'), true);
    assert.ok(!in$('bar', O));
    if (DESCRIPTORS) {
      assert.strictEqual(deleteProperty(defineProperty({}, 'foo', {
        value: 42
      }), 'foo'), false);
    }
    assert.throws(function(){
      deleteProperty(42, 'foo');
    }, TypeError, 'throws on primitive');
  });
  function in$(x, xs){
    var i = -1, l = xs.length >>> 0;
    while (++i < l) if (x === xs[i]) return true;
    return false;
  }
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, defineProperty, from;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  defineProperty = core.Object.defineProperty;
  from = core.Array.from;
  test('Reflect.enumerate', function(assert){
    var enumerate, iterator, obj, i, ref$;
    enumerate = core.Reflect.enumerate;
    iterator = core.Symbol.iterator;
    assert.isFunction(enumerate);
    assert.arity(enumerate, 1);
    if ('name' in enumerate) {
      assert.name(enumerate, 'enumerate');
    }
    obj = {
      foo: 1,
      bar: 2
    };
    i = enumerate(obj);
    assert.isIterable(i);
    assert.deepEqual(from(i), ['foo', 'bar'], 'bisic');
    obj = {
      q: 1,
      w: 2,
      e: 3
    };
    i = enumerate(obj);
    delete obj.w;
    assert.deepEqual(from(i), ['q', 'e'], 'ignore holes');
    obj = (ref$ = clone$({
      q: 1,
      w: 2,
      e: 3
    }), ref$.a = 4, ref$.s = 5, ref$.d = 6, ref$);
    assert.deepEqual(from(enumerate(obj)).sort(), ['a', 'd', 'e', 'q', 's', 'w'], 'works with prototype');
    assert.throws(function(){
      enumerate(42);
    }, TypeError, 'throws on primitive');
  });
  function clone$(it){
    function fun(){} fun.prototype = it;
    return new fun;
  }
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Reflect.getOwnPropertyDescriptor', function(assert){
    var getOwnPropertyDescriptor, obj, desc;
    getOwnPropertyDescriptor = core.Reflect.getOwnPropertyDescriptor;
    assert.isFunction(getOwnPropertyDescriptor);
    assert.arity(getOwnPropertyDescriptor, 2);
    if ('name' in getOwnPropertyDescriptor) {
      assert.name(getOwnPropertyDescriptor, 'getOwnPropertyDescriptor');
    }
    obj = {
      baz: 789
    };
    desc = getOwnPropertyDescriptor(obj, 'baz');
    assert.strictEqual(desc.value, 789);
    assert.throws(function(){
      getOwnPropertyDescriptor(42, 'constructor');
    }, TypeError, 'throws on primitive');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Reflect.getPrototypeOf', function(assert){
    var getPrototypeOf;
    getPrototypeOf = core.Reflect.getPrototypeOf;
    assert.isFunction(getPrototypeOf);
    assert.arity(getPrototypeOf, 1);
    if ('name' in getPrototypeOf) {
      assert.name(getPrototypeOf, 'getPrototypeOf');
    }
    assert.strictEqual(getPrototypeOf([]), Array.prototype);
    assert.throws(function(){
      getPrototypeOf(42);
    }, TypeError, 'throws on primitive');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, ref$, defineProperty, create;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  ref$ = core.Object, defineProperty = ref$.defineProperty, create = ref$.create;
  test('Reflect.get', function(assert){
    var get, target, receiver;
    get = core.Reflect.get;
    assert.isFunction(get);
    if ('name' in get) {
      assert.name(get, 'get');
    }
    assert.strictEqual(get({
      qux: 987
    }, 'qux'), 987);
    if (DESCRIPTORS) {
      target = create(defineProperty({
        z: 3
      }, 'w', {
        get: function(){
          return this;
        }
      }), {
        x: {
          value: 1
        },
        y: {
          get: function(){
            return this;
          }
        }
      });
      receiver = {};
      assert.strictEqual(get(target, 'x', receiver), 1, 'get x');
      assert.strictEqual(get(target, 'y', receiver), receiver, 'get y');
      assert.strictEqual(get(target, 'z', receiver), 3, 'get z');
      assert.strictEqual(get(target, 'w', receiver), receiver, 'get w');
      assert.strictEqual(get(target, 'u', receiver), void 8, 'get u');
    }
    assert.throws(function(){
      get(42, 'constructor');
    }, TypeError, 'throws on primitive');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Reflect.has', function(assert){
    var has, O;
    has = core.Reflect.has;
    assert.isFunction(has);
    assert.arity(has, 2);
    if ('name' in has) {
      assert.name(has, 'has');
    }
    O = {
      qux: 987
    };
    assert.strictEqual(has(O, 'qux'), true);
    assert.strictEqual(has(O, 'qwe'), false);
    assert.strictEqual(has(O, 'toString'), true);
    assert.throws(function(){
      has(42, 'constructor');
    }, TypeError, 'throws on primitive');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, ref$, defineProperty, preventExtensions;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  ref$ = core.Object, defineProperty = ref$.defineProperty, preventExtensions = ref$.preventExtensions;
  test('Reflect.isExtensible', function(assert){
    var isExtensible;
    isExtensible = core.Reflect.isExtensible;
    assert.isFunction(isExtensible);
    assert.arity(isExtensible, 1);
    if ('name' in isExtensible) {
      assert.name(isExtensible, 'isExtensible');
    }
    assert.ok(isExtensible({}));
    if (DESCRIPTORS) {
      assert.ok(!isExtensible(preventExtensions({})));
    }
    assert.throws(function(){
      isExtensible(42);
    }, TypeError, 'throws on primitive');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, defineProperty;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  defineProperty = core.Object.defineProperty;
  test('Reflect.ownKeys', function(assert){
    var ownKeys, sym, O1, keys, O2;
    ownKeys = core.Reflect.ownKeys;
    sym = core.Symbol('c');
    assert.isFunction(ownKeys);
    assert.arity(ownKeys, 1);
    if ('name' in ownKeys) {
      assert.name(ownKeys, 'ownKeys');
    }
    O1 = {
      a: 1
    };
    defineProperty(O1, 'b', {
      value: 2
    });
    O1[sym] = 3;
    keys = ownKeys(O1);
    assert.strictEqual(keys.length, 3, 'ownKeys return all own keys');
    assert.ok(in$('a', keys), 'ownKeys return all own keys: simple');
    assert.ok(in$('b', keys), 'ownKeys return all own keys: hidden');
    assert.strictEqual(O1[keys[2]], 3, 'ownKeys return all own keys: symbol');
    O2 = clone$(O1);
    keys = ownKeys(O2);
    assert.strictEqual(keys.length, 0, 'ownKeys return only own keys');
    assert.throws(function(){
      ownKeys(42);
    }, TypeError, 'throws on primitive');
  });
  function in$(x, xs){
    var i = -1, l = xs.length >>> 0;
    while (++i < l) if (x === xs[i]) return true;
    return false;
  }
  function clone$(it){
    function fun(){} fun.prototype = it;
    return new fun;
  }
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, ref$, defineProperty, isExtensible;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  ref$ = core.Object, defineProperty = ref$.defineProperty, isExtensible = ref$.isExtensible;
  test('Reflect.preventExtensions', function(assert){
    var preventExtensions, obj;
    preventExtensions = core.Reflect.preventExtensions;
    assert.isFunction(preventExtensions);
    assert.arity(preventExtensions, 1);
    if ('name' in preventExtensions) {
      assert.name(preventExtensions, 'preventExtensions');
    }
    obj = {};
    assert.ok(preventExtensions(obj), true);
    if (DESCRIPTORS) {
      assert.ok(!isExtensible(obj));
    }
    assert.throws(function(){
      preventExtensions(42);
    }, TypeError, 'throws on primitive');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  if (PROTO) {
    module = QUnit.module, test = QUnit.test;
    module('ES6');
    test('Reflect.setPrototypeOf', function(assert){
      var setPrototypeOf, obj, o;
      setPrototypeOf = core.Reflect.setPrototypeOf;
      assert.isFunction(setPrototypeOf);
      if ('name' in setPrototypeOf) {
        assert.name(setPrototypeOf, 'setPrototypeOf');
      }
      obj = {};
      assert.ok(setPrototypeOf(obj, Array.prototype), true);
      assert.ok(obj instanceof Array);
      assert.throws(function(){
        setPrototypeOf({}, 42);
      }, TypeError);
      assert.throws(function(){
        setPrototypeOf(42, {});
      }, TypeError, 'throws on primitive');
      assert.ok(setPrototypeOf(o = {}, o) === false, 'false on recursive __proto__');
    });
  }
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, ref$, defineProperty, getOwnPropertyDescriptor, create;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  ref$ = core.Object, defineProperty = ref$.defineProperty, getOwnPropertyDescriptor = ref$.getOwnPropertyDescriptor, create = ref$.create;
  test('Reflect.set', function(assert){
    var set, obj, target, receiver, out;
    set = core.Reflect.set;
    assert.isFunction(set);
    if ('name' in set) {
      assert.name(set, 'set');
    }
    obj = {};
    assert.ok(set(obj, 'quux', 654), true);
    assert.strictEqual(obj.quux, 654);
    target = {};
    receiver = {};
    set(target, 'foo', 1, receiver);
    assert.strictEqual(target.foo, void 8, 'target.foo === undefined');
    assert.strictEqual(receiver.foo, 1, 'receiver.foo === 1');
    if (DESCRIPTORS) {
      defineProperty(receiver, 'bar', {
        value: 0,
        writable: true,
        enumerable: false,
        configurable: true
      });
      set(target, 'bar', 1, receiver);
      assert.strictEqual(receiver.bar, 1, 'receiver.bar === 1');
      assert.strictEqual(getOwnPropertyDescriptor(receiver, 'bar').enumerable, false, 'enumerability not overridden');
      target = create(defineProperty({
        z: 3
      }, 'w', {
        set: function(){
          out = this;
        }
      }), {
        x: {
          value: 1,
          writable: true,
          configurable: true
        },
        y: {
          set: function(){
            out = this;
          }
        },
        c: {
          value: 1,
          writable: false,
          configurable: false
        }
      });
      assert.strictEqual(set(target, 'x', 2, target), true, 'set x');
      assert.strictEqual(target.x, 2, 'set x');
      out = null;
      assert.strictEqual(set(target, 'y', 2, target), true, 'set y');
      assert.strictEqual(out, target, 'set y');
      assert.strictEqual(set(target, 'z', 4, target), true);
      assert.strictEqual(target.z, 4, 'set z');
      out = null;
      assert.strictEqual(set(target, 'w', 1, target), true, 'set w');
      assert.strictEqual(out, target, 'set w');
      assert.strictEqual(set(target, 'u', 0, target), true, 'set u');
      assert.strictEqual(target.u, 0, 'set u');
      assert.strictEqual(set(target, 'c', 2, target), false, 'set c');
      assert.strictEqual(target.c, 1, 'set c');
    }
    assert.throws(function(){
      set(42, 'q', 42);
    }, TypeError, 'throws on primitive');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, same, Set, Map, Symbol, ref$, getOwnPropertyDescriptor, freeze, iterator;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  same = function(a, b){
    if (a === b) {
      return a !== 0 || 1 / a === 1 / b;
    } else {
      return a != a && b != b;
    }
  };
  Set = core.Set, Map = core.Map, Symbol = core.Symbol;
  ref$ = core.Object, getOwnPropertyDescriptor = ref$.getOwnPropertyDescriptor, freeze = ref$.freeze;
  iterator = core.Symbol.iterator;
  test('Set', function(assert){
    var from, S, r, done, iter, _add, a, o, key, C;
    from = core.Array.from;
    assert.isFunction(Set);
    assert.ok('add' in Set.prototype, 'add in Set.prototype');
    assert.ok('clear' in Set.prototype, 'clear in Set.prototype');
    assert.ok('delete' in Set.prototype, 'delete in Set.prototype');
    assert.ok('forEach' in Set.prototype, 'forEach in Set.prototype');
    assert.ok('has' in Set.prototype, 'has in Set.prototype');
    assert.ok(new Set instanceof Set, 'new Set instanceof Set');
    assert.strictEqual(new Set(createIterable([1, 2, 3])).size, 3, 'Init from iterable');
    assert.strictEqual(new Set([freeze({}), 1]).size, 2, 'Support frozen objects');
    S = new Set([1, 2, 3, 2, 1]);
    assert.strictEqual(S.size, 3);
    r = [];
    S.forEach(function(v){
      return r.push(v);
    });
    assert.deepEqual(r, [1, 2, 3]);
    assert.strictEqual(new Set([NaN, NaN, NaN]).size, 1);
    assert.deepEqual(from(new Set([3, 4]).add(2).add(1)), [3, 4, 2, 1]);
    done = false;
    iter = createIterable([null, 1, 2], {
      'return': function(){
        return done = true;
      }
    });
    _add = Set.prototype.add;
    Set.prototype.add = function(){
      throw 42;
    };
    try {
      new Set(iter);
    } catch (e$) {}
    Set.prototype.add = _add;
    assert.ok(done, '.return #throw');
    a = [];
    done = false;
    a['@@iterator'] = void 8;
    a[iterator] = function(){
      done = true;
      return core.getIteratorMethod([]).call(this);
    };
    new Set(a);
    assert.ok(done);
    o = {};
    new Set().add(o);
    if (DESCRIPTORS) {
      assert.arrayEqual((function(){
        var results$ = [];
        for (key in o) {
          results$.push(key);
        }
        return results$;
      }()), []);
      assert.arrayEqual(core.Object.keys(o), []);
    }
    assert.arrayEqual(core.Object.getOwnPropertyNames(o), []);
    assert.arrayEqual(core.Object.getOwnPropertySymbols(o), []);
    assert.arrayEqual(core.Reflect.ownKeys(o), []);
    if (nativeSubclass) {
      C = nativeSubclass(Set);
      assert.ok(new C instanceof C, 'correct subclassing with native classes #1');
      assert.ok(new C instanceof Set, 'correct subclassing with native classes #2');
      assert.ok(new C().add(2).has(2), 'correct subclassing with native classes #3');
    }
  });
  test('Set#add', function(assert){
    var a, S, chain, f;
    assert.isFunction(Set.prototype.add);
    a = [];
    S = new Set([NaN, 2, 3, 2, 1, a]);
    assert.strictEqual(S.size, 5);
    chain = S.add(NaN);
    assert.strictEqual(chain, S);
    assert.strictEqual(S.size, 5);
    S.add(2);
    assert.strictEqual(S.size, 5);
    S.add(a);
    assert.strictEqual(S.size, 5);
    S.add([]);
    assert.strictEqual(S.size, 6);
    S.add(4);
    assert.strictEqual(S.size, 7);
    S = new Set().add(freeze(f = {}));
    assert.ok(S.has(f));
  });
  test('Set#clear', function(assert){
    var S, f;
    assert.isFunction(Set.prototype.clear);
    S = new Set;
    S.clear();
    assert.strictEqual(S.size, 0);
    S = new Set([1, 2, 3, 2, 1]);
    S.clear();
    assert.strictEqual(S.size, 0);
    assert.ok(!S.has(1));
    assert.ok(!S.has(2));
    assert.ok(!S.has(3));
    S = new Set([1, f = freeze({})]);
    S.clear();
    assert.strictEqual(S.size, 0, 'Support frozen objects');
    assert.ok(!S.has(1));
    assert.ok(!S.has(f));
  });
  test('Set#delete', function(assert){
    var a, S, f;
    assert.isFunction(Set.prototype['delete']);
    a = [];
    S = new Set([NaN, 2, 3, 2, 1, a]);
    assert.strictEqual(S.size, 5);
    assert.strictEqual(S['delete'](NaN), true);
    assert.strictEqual(S.size, 4);
    assert.strictEqual(S['delete'](4), false);
    assert.strictEqual(S.size, 4);
    S['delete']([]);
    assert.strictEqual(S.size, 4);
    S['delete'](a);
    assert.strictEqual(S.size, 3);
    S.add(freeze(f = {}));
    assert.strictEqual(S.size, 4);
    S['delete'](f);
    assert.strictEqual(S.size, 3);
  });
  test('Set#forEach', function(assert){
    var r, count, S, set, s;
    assert.isFunction(Set.prototype.forEach);
    r = [];
    count = 0;
    S = new Set([1, 2, 3, 2, 1]);
    S.forEach(function(value){
      count++;
      r.push(value);
    });
    assert.strictEqual(count, 3);
    assert.deepEqual(r, [1, 2, 3]);
    set = new Set(['0', '1', '2', '3']);
    s = "";
    set.forEach(function(it){
      s += it;
      if (it === '2') {
        set['delete']('2');
        set['delete']('3');
        set['delete']('1');
        return set.add('4');
      }
    });
    assert.strictEqual(s, '0124');
    set = new Set(['0']);
    s = "";
    set.forEach(function(it){
      set['delete']('0');
      if (s !== '') {
        throw '!!!';
      }
      return s += it;
    });
    assert.strictEqual(s, '0');
    assert.throws(function(){
      Set.prototype.forEach.call(new Map, function(){});
    }, 'non-generic');
  });
  test('Set#has', function(assert){
    var a, f, S;
    assert.isFunction(Set.prototype.has);
    a = [];
    f = freeze({});
    S = new Set([NaN, 2, 3, 2, 1, f, a]);
    assert.ok(S.has(NaN));
    assert.ok(S.has(a));
    assert.ok(S.has(f));
    assert.ok(S.has(2));
    assert.ok(!S.has(4));
    assert.ok(!S.has([]));
  });
  test('Set#size', function(assert){
    var size, sizeDesc;
    size = new Set([1]).size;
    assert.strictEqual(typeof size, 'number', 'size is number');
    assert.strictEqual(size, 1, 'size is correct');
    if (DESCRIPTORS) {
      sizeDesc = getOwnPropertyDescriptor(Set.prototype, 'size');
      assert.ok(sizeDesc && sizeDesc.get, 'size is getter');
      assert.ok(sizeDesc && !sizeDesc.set, 'size isnt setter');
      assert.throws(function(){
        Set.prototype.size;
      }, TypeError);
    }
  });
  test('Set & -0', function(assert){
    var set, x$;
    set = new Set;
    set.add(-0);
    assert.strictEqual(set.size, 1);
    assert.ok(set.has(0));
    assert.ok(set.has(-0));
    set.forEach(function(it){
      return assert.ok(!same(it, -0));
    });
    set['delete'](-0);
    assert.strictEqual(set.size, 0);
    set = new Set([-0]);
    set.forEach(function(key){
      return assert.ok(!same(key, -0));
    });
    x$ = set = new Set();
    x$.add(4);
    x$.add(3);
    x$.add(2);
    x$.add(1);
    x$.add(0);
    assert.ok(set.has(-0));
  });
  test('Set#@@toStringTag', function(assert){
    assert.strictEqual(Set.prototype[Symbol != null ? Symbol.toStringTag : void 8], 'Set', 'Set::@@toStringTag is `Set`');
  });
  test('Set Iterator', function(assert){
    var set, keys, iterator;
    set = new Set(['a', 'b', 'c', 'd']);
    keys = [];
    iterator = set.keys();
    keys.push(iterator.next().value);
    assert.ok(set['delete']('a'));
    assert.ok(set['delete']('b'));
    assert.ok(set['delete']('c'));
    set.add('e');
    keys.push(iterator.next().value);
    keys.push(iterator.next().value);
    assert.ok(iterator.next().done);
    set.add('f');
    assert.ok(iterator.next().done);
    assert.deepEqual(keys, ['a', 'd', 'e']);
  });
  test('Set#keys', function(assert){
    var iter;
    assert.isFunction(Set.prototype.keys);
    iter = new Set(['q', 'w', 'e']).keys();
    assert.isIterator(iter);
    assert.isIterable(iter);
    assert.strictEqual(iter[Symbol != null ? Symbol.toStringTag : void 8], 'Set Iterator');
    assert.deepEqual(iter.next(), {
      value: 'q',
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: 'w',
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: 'e',
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: void 8,
      done: true
    });
  });
  test('Set#values', function(assert){
    var iter;
    assert.isFunction(Set.prototype.values);
    iter = new Set(['q', 'w', 'e']).values();
    assert.isIterator(iter);
    assert.isIterable(iter);
    assert.strictEqual(iter[Symbol != null ? Symbol.toStringTag : void 8], 'Set Iterator');
    assert.deepEqual(iter.next(), {
      value: 'q',
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: 'w',
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: 'e',
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: void 8,
      done: true
    });
  });
  test('Set#entries', function(assert){
    var iter;
    assert.isFunction(Set.prototype.entries);
    iter = new Set(['q', 'w', 'e']).entries();
    assert.isIterator(iter);
    assert.isIterable(iter);
    assert.strictEqual(iter[Symbol != null ? Symbol.toStringTag : void 8], 'Set Iterator');
    assert.deepEqual(iter.next(), {
      value: ['q', 'q'],
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: ['w', 'w'],
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: ['e', 'e'],
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: void 8,
      done: true
    });
  });
  test('Set#@@iterator', function(assert){
    var iter;
    iter = core.getIterator(new Set(['q', 'w', 'e']));
    assert.isIterator(iter);
    assert.isIterable(iter);
    assert.strictEqual(iter[Symbol != null ? Symbol.toStringTag : void 8], 'Set Iterator');
    assert.deepEqual(iter.next(), {
      value: 'q',
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: 'w',
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: 'e',
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: void 8,
      done: true
    });
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('String#anchor', function(assert){
    var anchor;
    anchor = core.String.anchor;
    assert.isFunction(anchor);
    assert.same(anchor('a', 'b'), '<a name="b">a</a>', 'lower case');
    assert.same(anchor('a', '"'), '<a name="&quot;">a</a>', 'escape quotes');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('String#big', function(assert){
    var big;
    big = core.String.big;
    assert.isFunction(big);
    assert.same(big('a'), '<big>a</big>', 'lower case');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('String#blink', function(assert){
    var blink;
    blink = core.String.blink;
    assert.isFunction(blink);
    assert.same(blink('a'), '<blink>a</blink>', 'lower case');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('String#bold', function(assert){
    var bold;
    bold = core.String.bold;
    assert.isFunction(bold);
    assert.same(bold('a'), '<b>a</b>', 'lower case');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('String#codePointAt', function(assert){
    var codePointAt;
    codePointAt = core.String.codePointAt;
    assert.isFunction(codePointAt);
    assert.strictEqual(codePointAt('abc\uD834\uDF06def', ''), 0x61);
    assert.strictEqual(codePointAt('abc\uD834\uDF06def', '_'), 0x61);
    assert.strictEqual(codePointAt('abc\uD834\uDF06def'), 0x61);
    assert.strictEqual(codePointAt('abc\uD834\uDF06def', -Infinity), void 8);
    assert.strictEqual(codePointAt('abc\uD834\uDF06def', -1), void 8);
    assert.strictEqual(codePointAt('abc\uD834\uDF06def', -0), 0x61);
    assert.strictEqual(codePointAt('abc\uD834\uDF06def', 0), 0x61);
    assert.strictEqual(codePointAt('abc\uD834\uDF06def', 3), 0x1D306);
    assert.strictEqual(codePointAt('abc\uD834\uDF06def', 4), 0xDF06);
    assert.strictEqual(codePointAt('abc\uD834\uDF06def', 5), 0x64);
    assert.strictEqual(codePointAt('abc\uD834\uDF06def', 42), void 8);
    assert.strictEqual(codePointAt('abc\uD834\uDF06def', Infinity), void 8);
    assert.strictEqual(codePointAt('abc\uD834\uDF06def', Infinity), void 8);
    assert.strictEqual(codePointAt('abc\uD834\uDF06def', NaN), 0x61);
    assert.strictEqual(codePointAt('abc\uD834\uDF06def', false), 0x61);
    assert.strictEqual(codePointAt('abc\uD834\uDF06def', null), 0x61);
    assert.strictEqual(codePointAt('abc\uD834\uDF06def', void 8), 0x61);
    assert.strictEqual(codePointAt('\uD834\uDF06def', ''), 0x1D306);
    assert.strictEqual(codePointAt('\uD834\uDF06def', '1'), 0xDF06);
    assert.strictEqual(codePointAt('\uD834\uDF06def', '_'), 0x1D306);
    assert.strictEqual(codePointAt('\uD834\uDF06def'), 0x1D306);
    assert.strictEqual(codePointAt('\uD834\uDF06def', -1), void 8);
    assert.strictEqual(codePointAt('\uD834\uDF06def', -0), 0x1D306);
    assert.strictEqual(codePointAt('\uD834\uDF06def', 0), 0x1D306);
    assert.strictEqual(codePointAt('\uD834\uDF06def', 1), 0xDF06);
    assert.strictEqual(codePointAt('\uD834\uDF06def', 42), void 8);
    assert.strictEqual(codePointAt('\uD834\uDF06def', false), 0x1D306);
    assert.strictEqual(codePointAt('\uD834\uDF06def', null), 0x1D306);
    assert.strictEqual(codePointAt('\uD834\uDF06def', void 8), 0x1D306);
    assert.strictEqual(codePointAt('\uD834abc', ''), 0xD834);
    assert.strictEqual(codePointAt('\uD834abc', '_'), 0xD834);
    assert.strictEqual(codePointAt('\uD834abc'), 0xD834);
    assert.strictEqual(codePointAt('\uD834abc', -1), void 8);
    assert.strictEqual(codePointAt('\uD834abc', -0), 0xD834);
    assert.strictEqual(codePointAt('\uD834abc', 0), 0xD834);
    assert.strictEqual(codePointAt('\uD834abc', false), 0xD834);
    assert.strictEqual(codePointAt('\uD834abc', NaN), 0xD834);
    assert.strictEqual(codePointAt('\uD834abc', null), 0xD834);
    assert.strictEqual(codePointAt('\uD834abc', void 8), 0xD834);
    assert.strictEqual(codePointAt('\uDF06abc', ''), 0xDF06);
    assert.strictEqual(codePointAt('\uDF06abc', '_'), 0xDF06);
    assert.strictEqual(codePointAt('\uDF06abc'), 0xDF06);
    assert.strictEqual(codePointAt('\uDF06abc', -1), void 8);
    assert.strictEqual(codePointAt('\uDF06abc', -0), 0xDF06);
    assert.strictEqual(codePointAt('\uDF06abc', 0), 0xDF06);
    assert.strictEqual(codePointAt('\uDF06abc', false), 0xDF06);
    assert.strictEqual(codePointAt('\uDF06abc', NaN), 0xDF06);
    assert.strictEqual(codePointAt('\uDF06abc', null), 0xDF06);
    assert.strictEqual(codePointAt('\uDF06abc', void 8), 0xDF06);
    if (STRICT) {
      assert.throws(function(){
        codePointAt(null, 0);
      }, TypeError);
      assert.throws(function(){
        codePointAt(void 8, 0);
      }, TypeError);
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('String#endsWith', function(assert){
    var endsWith, re, ref$, e, O, ref1$;
    endsWith = core.String.endsWith;
    assert.isFunction(endsWith);
    assert.ok(endsWith('undefined'));
    assert.ok(!endsWith('undefined', null));
    assert.ok(endsWith('abc', ''));
    assert.ok(endsWith('abc', 'c'));
    assert.ok(endsWith('abc', 'bc'));
    assert.ok(!endsWith('abc', 'ab'));
    assert.ok(endsWith('abc', '', NaN));
    assert.ok(!endsWith('abc', 'c', -1));
    assert.ok(endsWith('abc', 'a', 1));
    assert.ok(endsWith('abc', 'c', Infinity));
    assert.ok(endsWith('abc', 'a', true));
    assert.ok(!endsWith('abc', 'c', 'x'));
    assert.ok(!endsWith('abc', 'a', 'x'));
    if (STRICT) {
      assert.throws(function(){
        endsWith(null, '.');
      }, TypeError);
      assert.throws(function(){
        endsWith(void 8, '.');
      }, TypeError);
    }
    re = /./;
    assert.throws(function(){
      endsWith('/./', re);
    }, TypeError);
    re[(ref$ = core.Symbol) != null ? ref$.match : void 8] = false;
    assert.ok((function(){
      try {
        return endsWith('/./', re);
      } catch (e$) {
        e = e$;
        return false;
      }
    }()));
    O = {};
    assert.ok((function(){
      try {
        return endsWith('[object Object]', O);
      } catch (e$) {
        e = e$;
        return false;
      }
    }()));
    O[(ref1$ = core.Symbol) != null ? ref1$.match : void 8] = true;
    assert.throws(function(){
      endsWith('[object Object]', O);
    }, TypeError);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('String#fixed', function(assert){
    var fixed;
    fixed = core.String.fixed;
    assert.isFunction(fixed);
    assert.same(fixed('a'), '<tt>a</tt>', 'lower case');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('String#fontcolor', function(assert){
    var fontcolor;
    fontcolor = core.String.fontcolor;
    assert.isFunction(fontcolor);
    assert.same(fontcolor('a', 'b'), '<font color="b">a</font>', 'lower case');
    assert.same(fontcolor('a', '"'), '<font color="&quot;">a</font>', 'escape quotes');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('String#fontsize', function(assert){
    var fontsize;
    fontsize = core.String.fontsize;
    assert.isFunction(fontsize);
    assert.same(fontsize('a', 'b'), '<font size="b">a</font>', 'lower case');
    assert.same(fontsize('a', '"'), '<font size="&quot;">a</font>', 'escape quotes');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('String.fromCodePoint', function(assert){
    var fromCodePoint, tmp, counter, result;
    fromCodePoint = core.String.fromCodePoint;
    assert.isFunction(fromCodePoint);
    assert.arity(fromCodePoint, 1);
    if ('name' in fromCodePoint) {
      assert.name(fromCodePoint, 'fromCodePoint');
    }
    assert.strictEqual(fromCodePoint(''), '\0');
    assert.strictEqual(fromCodePoint(), '');
    assert.strictEqual(fromCodePoint(-0), '\0');
    assert.strictEqual(fromCodePoint(0), '\0');
    assert.strictEqual(fromCodePoint(0x1D306), '\uD834\uDF06');
    assert.strictEqual(fromCodePoint(0x1D306, 0x61, 0x1D307), '\uD834\uDF06a\uD834\uDF07');
    assert.strictEqual(fromCodePoint(0x61, 0x62, 0x1D307), 'ab\uD834\uDF07');
    assert.strictEqual(fromCodePoint(false), '\0');
    assert.strictEqual(fromCodePoint(null), '\0');
    assert.throws(function(){
      fromCodePoint('_');
    }, RangeError);
    assert.throws(function(){
      fromCodePoint('+Infinity');
    }, RangeError);
    assert.throws(function(){
      fromCodePoint('-Infinity');
    }, RangeError);
    assert.throws(function(){
      fromCodePoint(-1);
    }, RangeError);
    assert.throws(function(){
      fromCodePoint(0x10FFFF + 1);
    }, RangeError);
    assert.throws(function(){
      fromCodePoint(3.14);
    }, RangeError);
    assert.throws(function(){
      fromCodePoint(3e-2);
    }, RangeError);
    assert.throws(function(){
      fromCodePoint(-Infinity);
    }, RangeError);
    assert.throws(function(){
      fromCodePoint(Infinity);
    }, RangeError);
    assert.throws(function(){
      fromCodePoint(NaN);
    }, RangeError);
    assert.throws(function(){
      fromCodePoint(void 8);
    }, RangeError);
    assert.throws(function(){
      fromCodePoint({});
    }, RangeError);
    assert.throws(function(){
      fromCodePoint(/./);
    }, RangeError);
    tmp = 0x60;
    assert.strictEqual(fromCodePoint({
      valueOf: function(){
        return ++tmp;
      }
    }), 'a');
    assert.strictEqual(tmp, 0x61);
    counter = Math.pow(2, 15) * 3 / 2;
    result = [];
    while (--counter >= 0) {
      result.push(0);
    }
    fromCodePoint.apply(null, result);
    counter = Math.pow(2, 15) * 3 / 2;
    result = [];
    while (--counter >= 0) {
      result.push(0xFFFF + 1);
    }
    fromCodePoint.apply(null, result);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('String#includes', function(assert){
    var includes, re, ref$, e, O, ref1$;
    includes = core.String.includes;
    assert.isFunction(includes);
    assert.ok(!includes('abc'));
    assert.ok(includes('aundefinedb'));
    assert.ok(includes('abcd', 'b', 1));
    assert.ok(!includes('abcd', 'b', 2));
    if (STRICT) {
      assert.throws(function(){
        includes(null, '.');
      }, TypeError);
      assert.throws(function(){
        includes(void 8, '.');
      }, TypeError);
    }
    re = /./;
    assert.throws(function(){
      includes('/./', re);
    }, TypeError);
    re[(ref$ = core.Symbol) != null ? ref$.match : void 8] = false;
    assert.ok((function(){
      try {
        return includes('/./', re);
      } catch (e$) {
        e = e$;
        return false;
      }
    }()));
    O = {};
    assert.ok((function(){
      try {
        return includes('[object Object]', O);
      } catch (e$) {
        e = e$;
        return false;
      }
    }()));
    O[(ref1$ = core.Symbol) != null ? ref1$.match : void 8] = true;
    assert.throws(function(){
      includes('[object Object]', O);
    }, TypeError);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('String#italics', function(assert){
    var italics;
    italics = core.String.italics;
    assert.isFunction(italics);
    assert.same(italics('a'), '<i>a</i>', 'lower case');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('String#@@iterator', function(assert){
    var iter, ref$;
    iter = core.getIterator('qwe');
    assert.isIterator(iter);
    assert.strictEqual(iter[(ref$ = core.Symbol) != null ? ref$.toStringTag : void 8], 'String Iterator');
    assert.deepEqual(iter.next(), {
      value: 'q',
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: 'w',
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: 'e',
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: void 8,
      done: true
    });
    assert.strictEqual(core.Array.from('𠮷𠮷𠮷').length, 3);
    iter = core.getIterator('𠮷𠮷𠮷');
    assert.deepEqual(iter.next(), {
      value: '𠮷',
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: '𠮷',
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: '𠮷',
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: void 8,
      done: true
    });
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('String#link', function(assert){
    var link;
    link = core.String.link;
    assert.isFunction(link);
    assert.same(link('a', 'b'), '<a href="b">a</a>', 'lower case');
    assert.same(link('a', '"'), '<a href="&quot;">a</a>', 'escape quotes');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('String.raw', function(assert){
    var raw;
    raw = core.String.raw;
    assert.isFunction(raw);
    assert.arity(raw, 1);
    if ('name' in raw) {
      assert.name(raw, 'raw');
    }
    assert.strictEqual(raw({
      raw: ['Hi\\n', '!']
    }, 'Bob'), 'Hi\\nBob!', 'raw is array');
    assert.strictEqual(raw({
      raw: 'test'
    }, 0, 1, 2), 't0e1s2t', 'raw is string');
    assert.strictEqual(raw({
      raw: 'test'
    }, 0), 't0est', 'lacks substituting');
    assert.throws(function(){
      raw({});
    }, TypeError);
    assert.throws(function(){
      raw({
        raw: null
      });
    }, TypeError);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('String#repeat', function(assert){
    var repeat;
    repeat = core.String.repeat;
    assert.isFunction(repeat);
    assert.strictEqual(repeat('qwe', 3), 'qweqweqwe');
    assert.strictEqual(repeat('qwe', 2.5), 'qweqwe');
    assert.throws(function(){
      repeat('qwe', -1);
    }, RangeError);
    assert.throws(function(){
      repeat('qwe', Infinity);
    }, RangeError);
    if (STRICT) {
      assert.throws(function(){
        repeat(null, 1);
      }, TypeError);
      assert.throws(function(){
        repeat(void 8, 1);
      }, TypeError);
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('String#small', function(assert){
    var small;
    small = core.String.small;
    assert.isFunction(small);
    assert.same(small('a'), '<small>a</small>', 'lower case');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('String#startsWith', function(assert){
    var startsWith, re, ref$, e, O, ref1$;
    startsWith = core.String.startsWith;
    assert.isFunction(startsWith);
    assert.ok(startsWith('undefined'));
    assert.ok(!startsWith('undefined', null));
    assert.ok(startsWith('abc', ''));
    assert.ok(startsWith('abc', 'a'));
    assert.ok(startsWith('abc', 'ab'));
    assert.ok(!startsWith('abc', 'bc'));
    assert.ok(startsWith('abc', '', NaN));
    assert.ok(startsWith('abc', 'a', -1));
    assert.ok(!startsWith('abc', 'a', 1));
    assert.ok(!startsWith('abc', 'a', Infinity));
    assert.ok(startsWith('abc', 'b', true));
    assert.ok(startsWith('abc', 'a', 'x'));
    if (STRICT) {
      assert.throws(function(){
        startsWith(null, '.');
      }, TypeError);
      assert.throws(function(){
        startsWith(void 8, '.');
      }, TypeError);
    }
    re = /./;
    assert.throws(function(){
      startsWith('/./', re);
    }, TypeError);
    re[(ref$ = core.Symbol) != null ? ref$.match : void 8] = false;
    assert.ok((function(){
      try {
        return startsWith('/./', re);
      } catch (e$) {
        e = e$;
        return false;
      }
    }()));
    O = {};
    assert.ok((function(){
      try {
        return startsWith('[object Object]', O);
      } catch (e$) {
        e = e$;
        return false;
      }
    }()));
    O[(ref1$ = core.Symbol) != null ? ref1$.match : void 8] = true;
    assert.throws(function(){
      startsWith('[object Object]', O);
    }, TypeError);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('String#strike', function(assert){
    var strike;
    strike = core.String.strike;
    assert.isFunction(strike);
    assert.same(strike('a'), '<strike>a</strike>', 'lower case');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('String#sub', function(assert){
    var sub;
    sub = core.String.sub;
    assert.isFunction(sub);
    assert.same(sub('a'), '<sub>a</sub>', 'lower case');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('String#sup', function(assert){
    var sup;
    sup = core.String.sup;
    assert.isFunction(sup);
    assert.same(sup('a'), '<sup>a</sup>', 'lower case');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('String#trim', function(assert){
    var trim;
    trim = core.String.trim;
    assert.isFunction(trim);
    assert.strictEqual(trim(' \n  q w e \n  '), 'q w e', 'removes whitespaces at left & right side of string');
    assert.strictEqual(trim('\x09\x0A\x0B\x0C\x0D\x20\xA0\u1680\u180E\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u3000\u2028\u2029\uFEFF'), '', 'removes all whitespaces');
    assert.strictEqual(trim('\u200b\u0085'), '\u200b\u0085', "shouldn't remove this symbols");
    if (STRICT) {
      assert.throws(function(){
        trim(null, 0);
      }, TypeError);
      assert.throws(function(){
        trim(void 8, 0);
      }, TypeError);
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, Symbol, JSON, ref$, defineProperty, getOwnPropertyDescriptor, create, i$, len$, $key;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  Symbol = core.Symbol, JSON = core.JSON;
  ref$ = core.Object, defineProperty = ref$.defineProperty, getOwnPropertyDescriptor = ref$.getOwnPropertyDescriptor, create = ref$.create;
  test('Symbol', function(assert){
    var s1, s2, O, count, i;
    assert.isFunction(Symbol);
    s1 = Symbol('foo');
    s2 = Symbol('foo');
    assert.ok(s1 !== s2, 'Symbol("foo") !== Symbol("foo")');
    O = {};
    O[s1] = 42;
    assert.ok(O[s1] === 42, 'Symbol() work as key');
    assert.ok(O[s2] !== 42, 'Various symbols from one description are various keys');
    if (DESCRIPTORS) {
      count = 0;
      for (i in O) {
        count++;
      }
      assert.ok(count === 0, 'object[Symbol()] is not enumerable');
    }
  });
  test('Well-known Symbols', function(assert){
    var i$, x$, ref$, len$;
    for (i$ = 0, len$ = (ref$ = ['hasInstance', 'isConcatSpreadable', 'iterator', 'match', 'replace', 'search', 'species', 'split', 'toPrimitive', 'toStringTag', 'unscopables']).length; i$ < len$; ++i$) {
      x$ = ref$[i$];
      assert.ok(x$ in Symbol, "Symbol." + x$ + " available");
      assert.ok(Object(Symbol[x$]) instanceof Symbol, "Symbol." + x$ + " is symbol");
    }
  });
  test('Global symbol registry', function(assert){
    var symbol;
    assert.isFunction(Symbol['for'], 'Symbol.for is function');
    assert.isFunction(Symbol.keyFor, 'Symbol.keyFor is function');
    symbol = Symbol['for']('foo');
    assert.strictEqual(Symbol['for']('foo'), symbol);
    assert.strictEqual(Symbol.keyFor(symbol), 'foo');
    assert.throws(function(){
      Symbol.keyFor('foo');
    }, 'throws on non-symbol');
  });
  test('Symbol#@@toPrimitive', function(assert){
    var S;
    assert.isFunction(Symbol.prototype[Symbol.toPrimitive]);
    S = Symbol();
    assert.same(S, S[Symbol.toPrimitive](), 'works');
  });
  test('Symbol#@@toStringTag', function(assert){
    assert.ok(Symbol.prototype[Symbol.toStringTag] === 'Symbol', 'Symbol::@@toStringTag is `Symbol`');
  });
  test('Object.getOwnPropertySymbols', function(assert){
    var ref$, getOwnPropertySymbols, getOwnPropertyNames, obj, foo, i$, x$, len$;
    ref$ = core.Object, getOwnPropertySymbols = ref$.getOwnPropertySymbols, getOwnPropertyNames = ref$.getOwnPropertyNames;
    assert.isFunction(getOwnPropertySymbols);
    obj = {
      q: 1,
      w: 2,
      e: 3
    };
    obj[Symbol()] = 42;
    obj[Symbol()] = 43;
    assert.deepEqual(getOwnPropertyNames(obj).sort(), ['e', 'q', 'w']);
    assert.strictEqual(getOwnPropertySymbols(obj).length, 2);
    foo = (ref$ = clone$(obj), ref$.a = 1, ref$.s = 2, ref$.d = 3, ref$);
    foo[Symbol()] = 44;
    assert.deepEqual(getOwnPropertyNames(foo).sort(), ['a', 'd', 's']);
    assert.strictEqual(getOwnPropertySymbols(foo).length, 1);
    assert.strictEqual(getOwnPropertySymbols(Object.prototype).length, 0);
    for (i$ = 0, len$ = (ref$ = [42, 'foo', false]).length; i$ < len$; ++i$) {
      x$ = ref$[i$];
      assert.ok(getOwnPropertySymbols(x$), "accept " + typeof x$);
    }
  });
  if (JSON != null) {
    test('Symbols & JSON.stringify', function(assert){
      var ref$;
      assert.strictEqual(JSON.stringify([1, Symbol('foo'), false, Symbol('bar'), {}]), '[1,null,false,null,{}]', 'array value');
      assert.strictEqual(JSON.stringify({
        foo: Symbol('foo')
      }), '{}', 'object value');
      if (DESCRIPTORS) {
        assert.strictEqual(JSON.stringify((ref$ = {}, ref$[Symbol('foo')] = 1, ref$.bar = 2, ref$)), '{"bar":2}', 'object key');
      }
      assert.strictEqual(JSON.stringify(Symbol('foo')), void 8, 'symbol value');
      if (typeof Symbol() === 'symbol') {
        assert.strictEqual(JSON.stringify(Object(Symbol('foo'))), '{}', 'boxed symbol');
      }
    });
  }
  if (DESCRIPTORS) {
    test('Symbols & descriptors', function(assert){
      var ref$, create, defineProperty, getOwnPropertyDescriptor, keys, getOwnPropertyNames, getOwnPropertySymbols, d, e, f, i, j, proto, O, desc;
      ref$ = core.Object, create = ref$.create, defineProperty = ref$.defineProperty, getOwnPropertyDescriptor = ref$.getOwnPropertyDescriptor, keys = ref$.keys, getOwnPropertyNames = ref$.getOwnPropertyNames, getOwnPropertySymbols = ref$.getOwnPropertySymbols;
      d = Symbol('d');
      e = Symbol('e');
      f = Symbol('f');
      i = Symbol('i');
      j = Symbol('j');
      proto = (ref$ = {
        g: 'g'
      }, ref$[i] = 'i', ref$);
      defineProperty(proto, 'h', {
        value: 'h'
      });
      defineProperty(proto, 'j', {
        value: 'j'
      });
      O = create(proto);
      O.a = 'a';
      O[d] = 'd';
      defineProperty(O, 'b', {
        value: 'b'
      });
      defineProperty(O, 'c', {
        value: 'c',
        enumerable: true
      });
      defineProperty(O, e, {
        configurable: true,
        writable: true,
        value: 'e'
      });
      desc = {
        value: 'f',
        enumerable: true
      };
      defineProperty(O, f, desc);
      assert.strictEqual(desc.enumerable, true, 'defineProperty not changes descriptor object');
      assert.deepEqual(getOwnPropertyDescriptor(O, 'a'), {
        configurable: true,
        writable: true,
        enumerable: true,
        value: 'a'
      }, 'getOwnPropertyDescriptor a');
      assert.deepEqual(getOwnPropertyDescriptor(O, 'b'), {
        configurable: false,
        writable: false,
        enumerable: false,
        value: 'b'
      }, 'getOwnPropertyDescriptor b');
      assert.deepEqual(getOwnPropertyDescriptor(O, 'c'), {
        configurable: false,
        writable: false,
        enumerable: true,
        value: 'c'
      }, 'getOwnPropertyDescriptor c');
      assert.deepEqual(getOwnPropertyDescriptor(O, d), {
        configurable: true,
        writable: true,
        enumerable: true,
        value: 'd'
      }, 'getOwnPropertyDescriptor d');
      assert.deepEqual(getOwnPropertyDescriptor(O, e), {
        configurable: true,
        writable: true,
        enumerable: false,
        value: 'e'
      }, 'getOwnPropertyDescriptor e');
      assert.deepEqual(getOwnPropertyDescriptor(O, f), {
        configurable: false,
        writable: false,
        enumerable: true,
        value: 'f'
      }, 'getOwnPropertyDescriptor f');
      assert.strictEqual(getOwnPropertyDescriptor(O, 'g'), void 8, 'getOwnPropertyDescriptor g');
      assert.strictEqual(getOwnPropertyDescriptor(O, 'h'), void 8, 'getOwnPropertyDescriptor h');
      assert.strictEqual(getOwnPropertyDescriptor(O, i), void 8, 'getOwnPropertyDescriptor i');
      assert.strictEqual(getOwnPropertyDescriptor(O, j), void 8, 'getOwnPropertyDescriptor j');
      assert.strictEqual(getOwnPropertyDescriptor(O, 'k'), void 8, 'getOwnPropertyDescriptor k');
      assert.strictEqual(getOwnPropertyDescriptor(Object.prototype, 'toString').enumerable, false, 'getOwnPropertyDescriptor on Object.prototype');
      assert.strictEqual(getOwnPropertyDescriptor(Object.prototype, d), void 8, 'getOwnPropertyDescriptor on Object.prototype missed symbol');
      assert.strictEqual(keys(O).length, 2, 'Object.keys');
      assert.strictEqual(getOwnPropertyNames(O).length, 3, 'Object.getOwnPropertyNames');
      assert.strictEqual(getOwnPropertySymbols(O).length, 3, 'Object.getOwnPropertySymbols');
      assert.strictEqual(core.Reflect.ownKeys(O).length, 6, 'Reflect.ownKeys');
      delete O[e];
      O[e] = 'e';
      assert.deepEqual(getOwnPropertyDescriptor(O, e), {
        configurable: true,
        writable: true,
        enumerable: true,
        value: 'e'
      }, 'redefined non-enum key');
    });
    test('Symbols & Object.defineProperties', function(assert){
      var ref$, defineProperty, defineProperties, c, d, D, O;
      ref$ = core.Object, defineProperty = ref$.defineProperty, defineProperties = ref$.defineProperties;
      c = core.Symbol('c');
      d = core.Symbol('d');
      D = (ref$ = {
        a: {
          value: 'a'
        }
      }, ref$[c] = {
        value: 'c'
      }, ref$);
      defineProperty(D, 'b', {
        value: {
          value: 'b'
        }
      });
      defineProperty(D, d, {
        value: {
          value: 'd'
        }
      });
      O = defineProperties({}, D);
      assert.strictEqual(O.a, 'a', 'a');
      assert.strictEqual(O.b, void 8, 'b');
      assert.strictEqual(O[c], 'c', 'c');
      assert.strictEqual(O[d], void 8, 'd');
    });
    test('Symbols & Object.create', function(assert){
      var ref$, defineProperty, create, c, d, D, O;
      ref$ = core.Object, defineProperty = ref$.defineProperty, create = ref$.create;
      c = core.Symbol('c');
      d = core.Symbol('d');
      D = (ref$ = {
        a: {
          value: 'a'
        }
      }, ref$[c] = {
        value: 'c'
      }, ref$);
      defineProperty(D, 'b', {
        value: {
          value: 'b'
        }
      });
      defineProperty(D, d, {
        value: {
          value: 'd'
        }
      });
      O = create(null, D);
      assert.strictEqual(O.a, 'a', 'a');
      assert.strictEqual(O.b, void 8, 'b');
      assert.strictEqual(O[c], 'c', 'c');
      assert.strictEqual(O[d], void 8, 'd');
    });
    for (i$ = 0, len$ = (ref$ = ['Map', 'Set', 'Promise']).length; i$ < len$; ++i$) {
      $key = ref$[i$];
      (fn$.call(this, $key));
    }
    test("Array@@species", function(assert){
      var C;
      assert.strictEqual(Array[core.Symbol.species], Array, "Array@@species === Array");
      C = core.Object.create(Array);
      assert.strictEqual(C[core.Symbol.species], C, "Array sub");
    });
  }
  function clone$(it){
    function fun(){} fun.prototype = it;
    return new fun;
  }
  function fn$(key){
    test(key + "@@species", function(assert){
      var C;
      assert.strictEqual(core[key][core.Symbol.species], core[key], key + "@@species === " + key);
      C = core.Object.create(core[key]);
      assert.strictEqual(C[core.Symbol.species], C, key + " sub");
    });
  }
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('ArrayBuffer', function(assert){
    var ArrayBuffer, b, ref$;
    ArrayBuffer = core.ArrayBuffer;
    assert.same(ArrayBuffer, Object(ArrayBuffer), 'is object');
    b = new ArrayBuffer(123);
    assert.same(b.byteLength, 123, 'length');
    assert.throws(function(){
      new ArrayBuffer(-1);
    }, RangeError, 'negative length');
    assert.ok((function(){
      try {
        return new ArrayBuffer(0.5);
      } catch (e$) {}
    }()), 'fractional length');
    assert.ok((function(){
      try {
        return new ArrayBuffer();
      } catch (e$) {}
    }()), 'missed length');
    DESCRIPTORS && assert.same(ArrayBuffer[(ref$ = core.Symbol) != null ? ref$.species : void 8], ArrayBuffer, '@@species');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('ArrayBuffer.isView', function(assert){
    var ArrayBuffer, DataView, isView, i$, x$, ref$, len$, y$;
    ArrayBuffer = core.ArrayBuffer, DataView = core.DataView;
    isView = ArrayBuffer.isView;
    assert.isFunction(isView);
    assert.arity(isView, 1);
    for (i$ = 0, len$ = (ref$ = ['Float32Array', 'Float64Array', 'Int8Array', 'Int16Array', 'Int32Array', 'Uint8Array', 'Uint16Array', 'Uint32Array', 'Uint8ClampedArray']).length; i$ < len$; ++i$) {
      x$ = ref$[i$];
      if (core[x$]) {
        assert.same(isView(new core[x$]([1])), true, x$ + " - true");
      }
    }
    assert.same(isView(new DataView(new ArrayBuffer(1))), true, "DataView - true");
    assert.same(isView(new ArrayBuffer(1)), false, "ArrayBuffer - false");
    for (i$ = 0, len$ = (ref$ = [void 8, null, false, true, 0, 1, '', 'qwe', {}, [], fn$]).length; i$ < len$; ++i$) {
      y$ = ref$[i$];
      assert.same(isView(y$), false, y$ + " - false");
    }
    function fn$(){}
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('ArrayBuffer#slice', function(assert){
    var ArrayBuffer, slice, buffer;
    ArrayBuffer = core.ArrayBuffer;
    slice = ArrayBuffer.slice;
    assert.isFunction(slice);
    buffer = arrayToBuffer([1, 2, 3, 4, 5]);
    assert.ok(buffer instanceof ArrayBuffer, 'correct buffer');
    assert.ok(slice(buffer) !== buffer, 'returns new buffer');
    assert.ok(slice(buffer) instanceof ArrayBuffer, 'correct instance');
    assert.arrayEqual(bufferToArray(slice(buffer)), [1, 2, 3, 4, 5]);
    assert.arrayEqual(bufferToArray(slice(buffer, 1, 3)), [2, 3]);
    assert.arrayEqual(bufferToArray(slice(buffer, 1, void 8)), [2, 3, 4, 5]);
    assert.arrayEqual(bufferToArray(slice(buffer, 1, -1)), [2, 3, 4]);
    assert.arrayEqual(bufferToArray(slice(buffer, -2, -1)), [4]);
    assert.arrayEqual(bufferToArray(slice(buffer, -2, -3)), []);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, ref$, keys, getOwnPropertyDescriptor, defineProperty, ArrayBuffer, $name, $bytes;
  module = QUnit.module, test = QUnit.test;
  ref$ = core.Object, keys = ref$.keys, getOwnPropertyDescriptor = ref$.getOwnPropertyDescriptor, defineProperty = ref$.defineProperty;
  module('ES6');
  if (DESCRIPTORS) {
    ArrayBuffer = core.ArrayBuffer;
    for ($name in ref$ = {
      Float32Array: 4,
      Float64Array: 8,
      Int8Array: 1,
      Int16Array: 2,
      Int32Array: 4,
      Uint8Array: 1,
      Uint16Array: 2,
      Uint32Array: 4,
      Uint8ClampedArray: 1
    }) {
      $bytes = ref$[$name];
      (fn$.call(this, $name, $bytes));
    }
  }
  function import$(obj, src){
    var own = {}.hasOwnProperty;
    for (var key in src) if (own.call(src, key)) obj[key] = src[key];
    return obj;
  }
  function fn$(name, bytes){
    var Typed, this$ = this;
    Typed = core[name];
    test(name + " constructor", function(assert){
      var a, e, b, ref$;
      assert.isFunction(Typed);
      assert.same(Typed.BYTES_PER_ELEMENT, bytes, name + ".BYTES_PER_ELEMENT");
      a = new Typed(4);
      assert.same(a.BYTES_PER_ELEMENT, bytes, '#BYTES_PER_ELEMENT');
      assert.same(a.byteOffset, 0, name + '#byteOffset, passed number');
      assert.same(a.byteLength, 4 * bytes, '#byteLength, passed number');
      assert.arrayEqual(a, [0, 0, 0, 0], 'correct values, passed number');
      try {
        a = new Typed('0x4');
        assert.same(a.byteOffset, 0, '#byteOffset, passed string');
        assert.same(a.byteLength, 4 * bytes, '#byteLength, passed string');
        assert.arrayEqual(a, [0, 0, 0, 0], 'correct values, passed string');
      } catch (e$) {
        e = e$;
        assert.same(e, [0, 0, 0, 0], 'passed string');
      }
      try {
        a = new Typed(true);
        assert.same(a.byteOffset, 0, '#byteOffset, passed boolean');
        assert.same(a.byteLength, 1 * bytes, '#byteLength, passed boolean');
        assert.arrayEqual(a, [0], 'correct values, passed boolean');
      } catch (e$) {
        e = e$;
        assert.same(e, [0], 'passed boolean');
      }
      try {
        a = new Typed();
        assert.same(a.byteOffset, 0, '#byteOffset, passed boolean');
        assert.same(a.byteLength, 0, '#byteLength, passed boolean');
        assert.arrayEqual(a, [], 'correct values, passed boolean');
      } catch (e$) {
        e = e$;
        assert.same(e, [], 'passed boolean');
      }
      try {
        a = new Typed(void 8);
        assert.same(a.byteOffset, 0, '#byteOffset, passed boolean');
        assert.same(a.byteLength, 0, '#byteLength, passed boolean');
        assert.arrayEqual(a, [], 'correct values, passed boolean');
      } catch (e$) {
        e = e$;
        assert.same(e, [], 'passed boolean');
      }
      try {
        a = new Typed(-0);
        assert.same(a.byteOffset, 0, '#byteOffset, passed boolean');
        assert.same(a.byteLength, 0, '#byteLength, passed boolean');
        assert.arrayEqual(a, [], 'correct values, passed boolean');
      } catch (e$) {
        e = e$;
        assert.same(e, [], 'passed boolean');
      }
      try {
        a = new Typed(NaN);
        assert.same(a.byteOffset, 0, '#byteOffset, passed boolean');
        assert.same(a.byteLength, 0, '#byteLength, passed boolean');
        assert.arrayEqual(a, [], 'correct values, passed boolean');
      } catch (e$) {
        e = e$;
        assert.same(e, [], 'passed boolean');
      }
      try {
        a = new Typed(1.5);
        assert.same(a.byteOffset, 0, '#byteOffset, passed boolean');
        assert.same(a.byteLength, 1 * bytes, '#byteLength, passed boolean');
        assert.arrayEqual(a, [0], 'correct values, passed boolean');
      } catch (e$) {
        e = e$;
        assert.same(e, [0], 'passed boolean');
      }
      NATIVE && assert.throws(function(){
        new Typed(-1);
      }, RangeError, 'throws on -1');
      try {
        a = new Typed(null);
        assert.same(a.byteOffset, 0, '#byteOffset, passed null');
        assert.same(a.byteLength, 0, '#byteLength, passed null');
        assert.arrayEqual(a, [], 'correct values, passed null');
      } catch (e$) {
        e = e$;
        assert.same(e, [], 'passed null');
      }
      a = new Typed([1, 2, 3, 4]);
      assert.same(a.byteOffset, 0, '#byteOffset, passed array');
      assert.same(a.byteLength, 4 * bytes, '#byteLength, passed array');
      assert.arrayEqual(a, [1, 2, 3, 4], 'correct values, passed array');
      a = new Typed({
        0: 1,
        1: 2,
        2: 3,
        3: 4,
        length: 4
      });
      assert.same(a.byteOffset, 0, '#byteOffset, passed array-like');
      assert.same(a.byteLength, 4 * bytes, '#byteLength, passed array-like');
      assert.arrayEqual(a, [1, 2, 3, 4], 'correct values, passed array-like');
      try {
        a = new Typed({});
        assert.same(a.byteOffset, 0, '#byteOffset, passed empty object (also array-like case)');
        assert.same(a.byteLength, 0, '#byteLength, passed empty object (also array-like case)');
        assert.arrayEqual(a, [], 'correct values, passed empty object (also array-like case)');
      } catch (e$) {
        e = e$;
        assert.same(e, [], 'passed empty object (also array-like case)');
      }
      try {
        a = new Typed(createIterable([1, 2, 3, 4]));
        assert.same(a.byteOffset, 0, '#byteOffset, passed iterable');
        assert.same(a.byteLength, 4 * bytes, '#byteLength, passed iterable');
        assert.arrayEqual(a, [1, 2, 3, 4], 'correct values, passed iterable');
      } catch (e$) {
        e = e$;
        assert.same(e, [1, 2, 3, 4], 'passed iterable');
      }
      a = new Typed(new Typed([1, 2, 3, 4]));
      assert.same(a.byteOffset, 0, '#byteOffset, passed typed array');
      assert.same(a.byteLength, 4 * bytes, '#byteLength, passed typed array');
      assert.arrayEqual(a, [1, 2, 3, 4], 'correct values, passed typed array');
      b = new Typed([1, 2, 3, 4]);
      b[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.iterator : void 8] = function(){
        return createIterable([4, 3, 2, 1])[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.iterator : void 8]();
      };
      a = new Typed(b);
      assert.same(a.byteOffset, 0, '#byteOffset, passed typed array with custom iterator');
      assert.same(a.byteLength, 4 * bytes, '#byteLength, passed typed array with custom iterator');
      assert.arrayEqual(a, [1, 2, 3, 4], 'correct values, passed typed array with custom iterator');
      a = new Typed(new ArrayBuffer(8));
      assert.same(a.byteOffset, 0, '#byteOffset, passed buffer');
      assert.same(a.byteLength, 8, '#byteLength, passed buffer');
      assert.same(a.length, 8 / bytes, 'correct length, passed buffer');
      a = new Typed(new ArrayBuffer(16), 8);
      assert.same(a.byteOffset, 8, '#byteOffset, passed buffer and byteOffset');
      assert.same(a.byteLength, 8, '#byteLength, passed buffer and byteOffset');
      assert.same(a.length, 8 / bytes, 'correct length, passed buffer and byteOffset');
      a = new Typed(new ArrayBuffer(24), 8, 8 / bytes);
      assert.same(a.byteOffset, 8, '#byteOffset, passed buffer, byteOffset and length');
      assert.same(a.byteLength, 8, '#byteLength, passed buffer, byteOffset and length');
      assert.same(a.length, 8 / bytes, 'correct length, passed buffer, byteOffset and length');
      a = new Typed(new ArrayBuffer(8), void 8);
      assert.same(a.byteOffset, 0, '#byteOffset, passed buffer and undefined');
      assert.same(a.byteLength, 8, '#byteLength, passed buffer and undefined');
      assert.same(a.length, 8 / bytes, 'correct length, passed buffer and undefined');
      a = new Typed(new ArrayBuffer(16), 8, void 8);
      assert.same(a.byteOffset, 8, '#byteOffset, passed buffer, byteOffset and undefined');
      assert.same(a.byteLength, 8, '#byteLength, passed buffer, byteOffset and undefined');
      assert.same(a.length, 8 / bytes, 'correct length, passed buffer, byteOffset and undefined');
      a = new Typed(new ArrayBuffer(8), 8);
      assert.same(a.byteOffset, 8, '#byteOffset, passed buffer and byteOffset with buffer length');
      assert.same(a.byteLength, 0, '#byteLength, passed buffer and byteOffset with buffer length');
      assert.arrayEqual(a, [], 'correct values, passed buffer and byteOffset with buffer length');
      assert.throws(function(){
        new Typed(new ArrayBuffer(8), -1);
      }, RangeError, 'If offset < 0, throw a RangeError exception');
      if (bytes !== 1) {
        assert.throws(function(){
          new Typed(new ArrayBuffer(8), 3);
        }, RangeError, 'If offset modulo elementSize ≠ 0, throw a RangeError exception');
      }
      if (NATIVE) {
        if (bytes !== 1) {
          assert.throws(function(){
            new Typed(new ArrayBuffer(9));
          }, RangeError, 'If bufferByteLength modulo elementSize ≠ 0, throw a RangeError exception');
        }
        assert.throws(function(){
          new Typed(new ArrayBuffer(8), 16);
        }, RangeError, 'If newByteLength < 0, throw a RangeError exception');
        assert.throws(function(){
          new Typed(new ArrayBuffer(24), 8, 24);
        }, RangeError, 'If offset+newByteLength > bufferByteLength, throw a RangeError exception');
      } else {
        assert.throws(function(){
          new Typed(new ArrayBuffer(8), 16);
        }, 'If newByteLength < 0, throw a RangeError exception');
        assert.throws(function(){
          new Typed(new ArrayBuffer(24), 8, 24);
        }, 'If offset+newByteLength > bufferByteLength, throw a RangeError exception');
      }
      assert.throws(function(){
        Typed(1);
      }, TypeError, 'throws without `new`');
      assert.same(Typed[(ref$ = core.Symbol) != null ? ref$.species : void 8], Typed, '@@species');
    });
    test(name + " descriptors", function(assert){
      var typed, desc, base, key, e;
      typed = new Typed(2);
      desc = getOwnPropertyDescriptor(typed, 0);
      base = NATIVE
        ? {
          writable: true,
          enumerable: true,
          configurable: false
        }
        : {
          writable: desc.writable,
          enumerable: true,
          configurable: desc.configurable
        };
      NATIVE && assert.arrayEqual((function(){
        var results$ = [];
        for (key in typed) {
          results$.push(key);
        }
        return results$;
      }()), ['0', '1'], 'for-in');
      NATIVE && assert.arrayEqual(keys(typed), ['0', '1'], 'Object.keys');
      assert.deepEqual(getOwnPropertyDescriptor(typed, 0), import$({
        value: 0
      }, base), 'Object.getOwnPropertyDescriptor');
      if (NATIVE) {
        defineProperty(typed, 0, {
          value: 1,
          writable: true,
          enumerable: true,
          configurable: false
        });
        typed[0] = typed[1] = 2.5;
        assert.deepEqual(getOwnPropertyDescriptor(typed, 0), import$({
          value: typed[1]
        }, base), 'Object.defineProperty, valid descriptor #1');
        defineProperty(typed, 0, {
          value: 1
        });
        typed[0] = typed[1] = 3.5;
        assert.deepEqual(getOwnPropertyDescriptor(typed, 0), import$({
          value: typed[1]
        }, base), 'Object.defineProperty, valid descriptor #2');
      }
      NATIVE && (function(){
        try {
          defineProperty(typed, 0, {
            value: 2,
            writable: false,
            enumerable: true,
            configurable: false
          });
          return assert.ok(false, 'Object.defineProperty, invalid descriptor #1');
        } catch (e$) {
          e = e$;
          return assert.ok(true, 'Object.defineProperty, invalid descriptor #1');
        }
      }());
      NATIVE && (function(){
        try {
          defineProperty(typed, 0, {
            value: 2,
            writable: true,
            enumerable: false,
            configurable: false
          });
          return assert.ok(false, 'Object.defineProperty, invalid descriptor #2');
        } catch (e$) {
          e = e$;
          return assert.ok(true, 'Object.defineProperty, invalid descriptor #2');
        }
      }());
      NATIVE && (function(){
        try {
          defineProperty(typed, 0, {
            get: function(){
              return 2;
            }
          });
          return assert.ok(false, 'Object.defineProperty, invalid descriptor #3');
        } catch (e$) {
          e = e$;
          return assert.ok(true, 'Object.defineProperty, invalid descriptor #3');
        }
      }());
      try {
        defineProperty(typed, 0, {
          value: 2,
          get: function(){
            return 2;
          }
        });
        assert.ok(false, 'Object.defineProperty, invalid descriptor #4');
      } catch (e$) {
        e = e$;
        assert.ok(true, 'Object.defineProperty, invalid descriptor #4');
      }
    });
  }
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  DESCRIPTORS && test('Float32 conversions', function(assert){
    var Uint8Array, DataView, NAME, ARRAY, Typed, SET, GET, data, typed, uint8, view, viewFrom, z, i$, len$, ref$, value, conversion, little, big, rep;
    Uint8Array = core.Uint8Array, DataView = core.DataView;
    NAME = 'Float32';
    ARRAY = NAME + 'Array';
    Typed = core[ARRAY];
    SET = 'set' + NAME;
    GET = 'get' + NAME;
    data = [[0, 0, [0, 0, 0, 0]], [-0, -0, [0, 0, 0, 128]], [1, 1, [0, 0, 128, 63]], [-1, -1, [0, 0, 128, 191]], [1.1, 1.100000023841858, [205, 204, 140, 63]], [-1.1, -1.100000023841858, [205, 204, 140, 191]], [1.9, 1.899999976158142, [51, 51, 243, 63]], [-1.9, -1.899999976158142, [51, 51, 243, 191]], [127, 127, [0, 0, 254, 66]], [-127, -127, [0, 0, 254, 194]], [128, 128, [0, 0, 0, 67]], [-128, -128, [0, 0, 0, 195]], [255, 255, [0, 0, 127, 67]], [-255, -255, [0, 0, 127, 195]], [255.1, 255.10000610351562, [154, 25, 127, 67]], [255.9, 255.89999389648438, [102, 230, 127, 67]], [256, 256, [0, 0, 128, 67]], [32767, 32767, [0, 254, 255, 70]], [-32767, -32767, [0, 254, 255, 198]], [32768, 32768, [0, 0, 0, 71]], [-32768, -32768, [0, 0, 0, 199]], [65535, 65535, [0, 255, 127, 71]], [65536, 65536, [0, 0, 128, 71]], [65537, 65537, [128, 0, 128, 71]], [65536.54321, 65536.546875, [70, 0, 128, 71]], [-65536.54321, -65536.546875, [70, 0, 128, 199]], [2147483647, 2147483648, [0, 0, 0, 79]], [-2147483647, -2147483648, [0, 0, 0, 207]], [2147483648, 2147483648, [0, 0, 0, 79]], [-2147483648, -2147483648, [0, 0, 0, 207]], [2147483649, 2147483648, [0, 0, 0, 79]], [-2147483649, -2147483648, [0, 0, 0, 207]], [4294967295, 4294967296, [0, 0, 128, 79]], [4294967296, 4294967296, [0, 0, 128, 79]], [4294967297, 4294967296, [0, 0, 128, 79]], [9007199254740991, 9007199254740992, [0, 0, 0, 90]], [-9007199254740991, -9007199254740992, [0, 0, 0, 218]], [9007199254740992, 9007199254740992, [0, 0, 0, 90]], [-9007199254740992, -9007199254740992, [0, 0, 0, 218]], [9007199254740994, 9007199254740992, [0, 0, 0, 90]], [-9007199254740994, -9007199254740992, [0, 0, 0, 218]], [Infinity, Infinity, [0, 0, 128, 127]], [-Infinity, -Infinity, [0, 0, 128, 255]], [1.7976931348623157e+308, Infinity, [0, 0, 128, 127]], [-1.7976931348623157e+308, -Infinity, [0, 0, 128, 255]], [5e-324, 0, [0, 0, 0, 0]], [-5e-324, -0, [0, 0, 0, 128]]];
    typed = new Typed(1);
    uint8 = new Uint8Array(typed.buffer);
    view = new DataView(typed.buffer);
    viewFrom = function(it){
      return new DataView(new Uint8Array(it).buffer);
    };
    z = function(it){
      if (it === 0 && 1 / it === -Infinity) {
        return '-0';
      } else {
        return it;
      }
    };
    for (i$ = 0, len$ = data.length; i$ < len$; ++i$) {
      ref$ = data[i$], value = ref$[0], conversion = ref$[1], little = ref$[2];
      big = little.slice().reverse();
      rep = LITTLE_ENDIAN ? little : big;
      typed[0] = value;
      assert.same(typed[0], conversion, ARRAY + " " + z(value) + " -> " + z(conversion));
      assert.arrayEqual(uint8, rep, ARRAY + " " + z(value) + " -> [" + rep + "]");
      view[SET](0, value);
      assert.arrayEqual(uint8, big, "view." + SET + "(0, " + z(value) + ") -> [" + big + "]");
      assert.same(viewFrom(big)[GET](0), conversion, "view{" + big + "}." + GET + "(0) -> " + z(conversion));
      view[SET](0, value, false);
      assert.arrayEqual(uint8, big, "view." + SET + "(0, " + z(value) + ", false) -> [" + big + "]");
      assert.same(viewFrom(big)[GET](0, false), conversion, "view{" + big + "}." + GET + "(0, false) -> " + z(conversion));
      view[SET](0, value, true);
      assert.arrayEqual(uint8, little, "view." + SET + "(0, " + z(value) + ", true) -> [" + little + "]");
      assert.same(viewFrom(little)[GET](0, true), conversion, "view{" + little + "}." + GET + "(0, true) -> " + z(conversion));
    }
    typed[0] = NaN;
    assert.same(typed[0], NaN, "NaN -> NaN");
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  DESCRIPTORS && test('Float64 conversions', function(assert){
    var Uint8Array, DataView, NAME, ARRAY, Typed, SET, GET, data, typed, uint8, view, viewFrom, z, i$, len$, ref$, value, conversion, little, big, rep;
    Uint8Array = core.Uint8Array, DataView = core.DataView;
    NAME = 'Float64';
    ARRAY = NAME + 'Array';
    Typed = core[ARRAY];
    SET = 'set' + NAME;
    GET = 'get' + NAME;
    data = [[0, 0, [0, 0, 0, 0, 0, 0, 0, 0]], [-0, -0, [0, 0, 0, 0, 0, 0, 0, 128]], [1, 1, [0, 0, 0, 0, 0, 0, 240, 63]], [-1, -1, [0, 0, 0, 0, 0, 0, 240, 191]], [1.1, 1.1, [154, 153, 153, 153, 153, 153, 241, 63]], [-1.1, -1.1, [154, 153, 153, 153, 153, 153, 241, 191]], [1.9, 1.9, [102, 102, 102, 102, 102, 102, 254, 63]], [-1.9, -1.9, [102, 102, 102, 102, 102, 102, 254, 191]], [127, 127, [0, 0, 0, 0, 0, 192, 95, 64]], [-127, -127, [0, 0, 0, 0, 0, 192, 95, 192]], [128, 128, [0, 0, 0, 0, 0, 0, 96, 64]], [-128, -128, [0, 0, 0, 0, 0, 0, 96, 192]], [255, 255, [0, 0, 0, 0, 0, 224, 111, 64]], [-255, -255, [0, 0, 0, 0, 0, 224, 111, 192]], [255.1, 255.1, [51, 51, 51, 51, 51, 227, 111, 64]], [255.9, 255.9, [205, 204, 204, 204, 204, 252, 111, 64]], [256, 256, [0, 0, 0, 0, 0, 0, 112, 64]], [32767, 32767, [0, 0, 0, 0, 192, 255, 223, 64]], [-32767, -32767, [0, 0, 0, 0, 192, 255, 223, 192]], [32768, 32768, [0, 0, 0, 0, 0, 0, 224, 64]], [-32768, -32768, [0, 0, 0, 0, 0, 0, 224, 192]], [65535, 65535, [0, 0, 0, 0, 224, 255, 239, 64]], [65536, 65536, [0, 0, 0, 0, 0, 0, 240, 64]], [65537, 65537, [0, 0, 0, 0, 16, 0, 240, 64]], [65536.54321, 65536.54321, [14, 248, 252, 176, 8, 0, 240, 64]], [-65536.54321, -65536.54321, [14, 248, 252, 176, 8, 0, 240, 192]], [2147483647, 2147483647, [0, 0, 192, 255, 255, 255, 223, 65]], [-2147483647, -2147483647, [0, 0, 192, 255, 255, 255, 223, 193]], [2147483648, 2147483648, [0, 0, 0, 0, 0, 0, 224, 65]], [-2147483648, -2147483648, [0, 0, 0, 0, 0, 0, 224, 193]], [2147483649, 2147483649, [0, 0, 32, 0, 0, 0, 224, 65]], [-2147483649, -2147483649, [0, 0, 32, 0, 0, 0, 224, 193]], [4294967295, 4294967295, [0, 0, 224, 255, 255, 255, 239, 65]], [4294967296, 4294967296, [0, 0, 0, 0, 0, 0, 240, 65]], [4294967297, 4294967297, [0, 0, 16, 0, 0, 0, 240, 65]], [9007199254740991, 9007199254740991, [255, 255, 255, 255, 255, 255, 63, 67]], [-9007199254740991, -9007199254740991, [255, 255, 255, 255, 255, 255, 63, 195]], [9007199254740992, 9007199254740992, [0, 0, 0, 0, 0, 0, 64, 67]], [-9007199254740992, -9007199254740992, [0, 0, 0, 0, 0, 0, 64, 195]], [9007199254740994, 9007199254740994, [1, 0, 0, 0, 0, 0, 64, 67]], [-9007199254740994, -9007199254740994, [1, 0, 0, 0, 0, 0, 64, 195]], [Infinity, Infinity, [0, 0, 0, 0, 0, 0, 240, 127]], [-Infinity, -Infinity, [0, 0, 0, 0, 0, 0, 240, 255]], [-1.7976931348623157e+308, -1.7976931348623157e+308, [255, 255, 255, 255, 255, 255, 239, 255]], [1.7976931348623157e+308, 1.7976931348623157e+308, [255, 255, 255, 255, 255, 255, 239, 127]], [5e-324, 5e-324, [1, 0, 0, 0, 0, 0, 0, 0]], [-5e-324, -5e-324, [1, 0, 0, 0, 0, 0, 0, 128]]];
    typed = new Typed(1);
    uint8 = new Uint8Array(typed.buffer);
    view = new DataView(typed.buffer);
    viewFrom = function(it){
      return new DataView(new Uint8Array(it).buffer);
    };
    z = function(it){
      if (it === 0 && 1 / it === -Infinity) {
        return '-0';
      } else {
        return it;
      }
    };
    for (i$ = 0, len$ = data.length; i$ < len$; ++i$) {
      ref$ = data[i$], value = ref$[0], conversion = ref$[1], little = ref$[2];
      big = little.slice().reverse();
      rep = LITTLE_ENDIAN ? little : big;
      typed[0] = value;
      assert.same(typed[0], conversion, ARRAY + " " + z(value) + " -> " + z(conversion));
      assert.arrayEqual(uint8, rep, ARRAY + " " + z(value) + " -> [" + rep + "]");
      view[SET](0, value);
      assert.arrayEqual(uint8, big, "view." + SET + "(0, " + z(value) + ") -> [" + big + "]");
      assert.same(viewFrom(big)[GET](0), conversion, "view{" + big + "}." + GET + "(0) -> " + z(conversion));
      view[SET](0, value, false);
      assert.arrayEqual(uint8, big, "view." + SET + "(0, " + z(value) + ", false) -> [" + big + "]");
      assert.same(viewFrom(big)[GET](0, false), conversion, "view{" + big + "}." + GET + "(0, false) -> " + z(conversion));
      view[SET](0, value, true);
      assert.arrayEqual(uint8, little, "view." + SET + "(0, " + z(value) + ", true) -> [" + little + "]");
      assert.same(viewFrom(little)[GET](0, true), conversion, "view{" + little + "}." + GET + "(0, true) -> " + z(conversion));
    }
    typed[0] = NaN;
    assert.same(typed[0], NaN, "NaN -> NaN");
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  DESCRIPTORS && test('Int16 conversions', function(assert){
    var Uint8Array, DataView, NAME, ARRAY, Typed, SET, GET, data, typed, uint8, view, viewFrom, z, i$, len$, ref$, value, conversion, little, big, rep;
    Uint8Array = core.Uint8Array, DataView = core.DataView;
    NAME = 'Int16';
    ARRAY = NAME + 'Array';
    Typed = core[ARRAY];
    SET = 'set' + NAME;
    GET = 'get' + NAME;
    data = [[0, 0, [0, 0]], [-0, 0, [0, 0]], [1, 1, [1, 0]], [-1, -1, [255, 255]], [1.1, 1, [1, 0]], [-1.1, -1, [255, 255]], [1.9, 1, [1, 0]], [-1.9, -1, [255, 255]], [127, 127, [127, 0]], [-127, -127, [129, 255]], [128, 128, [128, 0]], [-128, -128, [128, 255]], [255, 255, [255, 0]], [-255, -255, [1, 255]], [255.1, 255, [255, 0]], [255.9, 255, [255, 0]], [256, 256, [0, 1]], [32767, 32767, [255, 127]], [-32767, -32767, [1, 128]], [32768, -32768, [0, 128]], [-32768, -32768, [0, 128]], [65535, -1, [255, 255]], [65536, 0, [0, 0]], [65537, 1, [1, 0]], [65536.54321, 0, [0, 0]], [-65536.54321, 0, [0, 0]], [2147483647, -1, [255, 255]], [-2147483647, 1, [1, 0]], [2147483648, 0, [0, 0]], [-2147483648, 0, [0, 0]], [4294967296, 0, [0, 0]], [9007199254740992, 0, [0, 0]], [-9007199254740992, 0, [0, 0]], [Infinity, 0, [0, 0]], [-Infinity, 0, [0, 0]], [-1.7976931348623157e+308, 0, [0, 0]], [1.7976931348623157e+308, 0, [0, 0]], [5e-324, 0, [0, 0]], [-5e-324, 0, [0, 0]], [NaN, 0, [0, 0]]];
    if (NATIVE || !/Android [2-4]/.test(typeof navigator != 'undefined' && navigator !== null ? navigator.userAgent : void 8)) {
      data = data.concat([[2147483649, 1, [1, 0]], [-2147483649, -1, [255, 255]], [4294967295, -1, [255, 255]], [4294967297, 1, [1, 0]], [9007199254740991, -1, [255, 255]], [-9007199254740991, 1, [1, 0]], [9007199254740994, 2, [2, 0]], [-9007199254740994, -2, [254, 255]]]);
    }
    typed = new Typed(1);
    uint8 = new Uint8Array(typed.buffer);
    view = new DataView(typed.buffer);
    viewFrom = function(it){
      return new DataView(new Uint8Array(it).buffer);
    };
    z = function(it){
      if (it === 0 && 1 / it === -Infinity) {
        return '-0';
      } else {
        return it;
      }
    };
    for (i$ = 0, len$ = data.length; i$ < len$; ++i$) {
      ref$ = data[i$], value = ref$[0], conversion = ref$[1], little = ref$[2];
      big = little.slice().reverse();
      rep = LITTLE_ENDIAN ? little : big;
      typed[0] = value;
      assert.same(typed[0], conversion, ARRAY + " " + z(value) + " -> " + z(conversion));
      assert.arrayEqual(uint8, rep, ARRAY + " " + z(value) + " -> [" + rep + "]");
      view[SET](0, value);
      assert.arrayEqual(uint8, big, "view." + SET + "(0, " + z(value) + ") -> [" + big + "]");
      assert.same(viewFrom(big)[GET](0), conversion, "view{" + big + "}." + GET + "(0) -> " + z(conversion));
      view[SET](0, value, false);
      assert.arrayEqual(uint8, big, "view." + SET + "(0, " + z(value) + ", false) -> [" + big + "]");
      assert.same(viewFrom(big)[GET](0, false), conversion, "view{" + big + "}." + GET + "(0, false) -> " + z(conversion));
      view[SET](0, value, true);
      assert.arrayEqual(uint8, little, "view." + SET + "(0, " + z(value) + ", true) -> [" + little + "]");
      assert.same(viewFrom(little)[GET](0, true), conversion, "view{" + little + "}." + GET + "(0, true) -> " + z(conversion));
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  DESCRIPTORS && test('Int32 conversions', function(assert){
    var Uint8Array, DataView, NAME, ARRAY, Typed, SET, GET, data, typed, uint8, view, viewFrom, z, i$, len$, ref$, value, conversion, little, big, rep;
    Uint8Array = core.Uint8Array, DataView = core.DataView;
    NAME = 'Int32';
    ARRAY = NAME + 'Array';
    Typed = core[ARRAY];
    SET = 'set' + NAME;
    GET = 'get' + NAME;
    data = [[0, 0, [0, 0, 0, 0]], [-0, 0, [0, 0, 0, 0]], [1, 1, [1, 0, 0, 0]], [-1, -1, [255, 255, 255, 255]], [1.1, 1, [1, 0, 0, 0]], [-1.1, -1, [255, 255, 255, 255]], [1.9, 1, [1, 0, 0, 0]], [-1.9, -1, [255, 255, 255, 255]], [127, 127, [127, 0, 0, 0]], [-127, -127, [129, 255, 255, 255]], [128, 128, [128, 0, 0, 0]], [-128, -128, [128, 255, 255, 255]], [255, 255, [255, 0, 0, 0]], [-255, -255, [1, 255, 255, 255]], [255.1, 255, [255, 0, 0, 0]], [255.9, 255, [255, 0, 0, 0]], [256, 256, [0, 1, 0, 0]], [32767, 32767, [255, 127, 0, 0]], [-32767, -32767, [1, 128, 255, 255]], [32768, 32768, [0, 128, 0, 0]], [-32768, -32768, [0, 128, 255, 255]], [65535, 65535, [255, 255, 0, 0]], [65536, 65536, [0, 0, 1, 0]], [65537, 65537, [1, 0, 1, 0]], [65536.54321, 65536, [0, 0, 1, 0]], [-65536.54321, -65536, [0, 0, 255, 255]], [2147483647, 2147483647, [255, 255, 255, 127]], [-2147483647, -2147483647, [1, 0, 0, 128]], [2147483648, -2147483648, [0, 0, 0, 128]], [-2147483648, -2147483648, [0, 0, 0, 128]], [2147483649, -2147483647, [1, 0, 0, 128]], [-2147483649, 2147483647, [255, 255, 255, 127]], [4294967295, -1, [255, 255, 255, 255]], [4294967296, 0, [0, 0, 0, 0]], [4294967297, 1, [1, 0, 0, 0]], [9007199254740991, -1, [255, 255, 255, 255]], [-9007199254740991, 1, [1, 0, 0, 0]], [9007199254740992, 0, [0, 0, 0, 0]], [-9007199254740992, 0, [0, 0, 0, 0]], [9007199254740994, 2, [2, 0, 0, 0]], [-9007199254740994, -2, [254, 255, 255, 255]], [Infinity, 0, [0, 0, 0, 0]], [-Infinity, 0, [0, 0, 0, 0]], [-1.7976931348623157e+308, 0, [0, 0, 0, 0]], [1.7976931348623157e+308, 0, [0, 0, 0, 0]], [5e-324, 0, [0, 0, 0, 0]], [-5e-324, 0, [0, 0, 0, 0]], [NaN, 0, [0, 0, 0, 0]]];
    typed = new Typed(1);
    uint8 = new Uint8Array(typed.buffer);
    view = new DataView(typed.buffer);
    viewFrom = function(it){
      return new DataView(new Uint8Array(it).buffer);
    };
    z = function(it){
      if (it === 0 && 1 / it === -Infinity) {
        return '-0';
      } else {
        return it;
      }
    };
    for (i$ = 0, len$ = data.length; i$ < len$; ++i$) {
      ref$ = data[i$], value = ref$[0], conversion = ref$[1], little = ref$[2];
      big = little.slice().reverse();
      rep = LITTLE_ENDIAN ? little : big;
      typed[0] = value;
      assert.same(typed[0], conversion, ARRAY + " " + z(value) + " -> " + z(conversion));
      assert.arrayEqual(uint8, rep, ARRAY + " " + z(value) + " -> [" + rep + "]");
      view[SET](0, value);
      assert.arrayEqual(uint8, big, "view." + SET + "(0, " + z(value) + ") -> [" + big + "]");
      assert.same(viewFrom(big)[GET](0), conversion, "view{" + big + "}." + GET + "(0) -> " + z(conversion));
      view[SET](0, value, false);
      assert.arrayEqual(uint8, big, "view." + SET + "(0, " + z(value) + ", false) -> [" + big + "]");
      assert.same(viewFrom(big)[GET](0, false), conversion, "view{" + big + "}." + GET + "(0, false) -> " + z(conversion));
      view[SET](0, value, true);
      assert.arrayEqual(uint8, little, "view." + SET + "(0, " + z(value) + ", true) -> [" + little + "]");
      assert.same(viewFrom(little)[GET](0, true), conversion, "view{" + little + "}." + GET + "(0, true) -> " + z(conversion));
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  DESCRIPTORS && test('Int8 conversions', function(assert){
    var Uint8Array, DataView, NAME, ARRAY, Typed, SET, GET, data, typed, uint8, view, viewFrom, z, i$, len$, ref$, value, conversion, little;
    Uint8Array = core.Uint8Array, DataView = core.DataView;
    NAME = 'Int8';
    ARRAY = NAME + 'Array';
    Typed = core[ARRAY];
    SET = 'set' + NAME;
    GET = 'get' + NAME;
    data = [[0, 0, [0]], [-0, 0, [0]], [1, 1, [1]], [-1, -1, [255]], [1.1, 1, [1]], [-1.1, -1, [255]], [1.9, 1, [1]], [-1.9, -1, [255]], [127, 127, [127]], [-127, -127, [129]], [128, -128, [128]], [-128, -128, [128]], [255, -1, [255]], [-255, 1, [1]], [255.1, -1, [255]], [255.9, -1, [255]], [256, 0, [0]], [32767, -1, [255]], [-32767, 1, [1]], [32768, 0, [0]], [-32768, 0, [0]], [65535, -1, [255]], [65536, 0, [0]], [65537, 1, [1]], [65536.54321, 0, [0]], [-65536.54321, 0, [0]], [2147483647, -1, [255]], [-2147483647, 1, [1]], [2147483648, 0, [0]], [-2147483648, 0, [0]], [4294967296, 0, [0]], [9007199254740992, 0, [0]], [-9007199254740992, 0, [0]], [Infinity, 0, [0]], [-Infinity, 0, [0]], [-1.7976931348623157e+308, 0, [0]], [1.7976931348623157e+308, 0, [0]], [5e-324, 0, [0]], [-5e-324, 0, [0]], [NaN, 0, [0]]];
    if (NATIVE || !/Android [2-4]/.test(typeof navigator != 'undefined' && navigator !== null ? navigator.userAgent : void 8)) {
      data = data.concat([[2147483649, 1, [1]], [-2147483649, -1, [255]], [4294967295, -1, [255]], [4294967297, 1, [1]], [9007199254740991, -1, [255]], [-9007199254740991, 1, [1]], [9007199254740994, 2, [2]], [-9007199254740994, -2, [254]]]);
    }
    typed = new Typed(1);
    uint8 = new Uint8Array(typed.buffer);
    view = new DataView(typed.buffer);
    viewFrom = function(it){
      return new DataView(new Uint8Array(it).buffer);
    };
    z = function(it){
      if (it === 0 && 1 / it === -Infinity) {
        return '-0';
      } else {
        return it;
      }
    };
    for (i$ = 0, len$ = data.length; i$ < len$; ++i$) {
      ref$ = data[i$], value = ref$[0], conversion = ref$[1], little = ref$[2];
      typed[0] = value;
      assert.same(typed[0], conversion, ARRAY + " " + z(value) + " -> " + z(conversion));
      assert.arrayEqual(uint8, little, ARRAY + " " + z(value) + " -> [" + little + "]");
      view[SET](0, value);
      assert.arrayEqual(uint8, little, "view." + SET + "(0, " + z(value) + ") -> [" + little + "]");
      assert.same(viewFrom(little)[GET](0), conversion, "view{" + little + "}." + GET + "(0) -> " + z(conversion));
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  DESCRIPTORS && test('Uint16 conversions', function(assert){
    var Uint8Array, DataView, NAME, ARRAY, Typed, SET, GET, data, typed, uint8, view, viewFrom, z, i$, len$, ref$, value, conversion, little, big, rep;
    Uint8Array = core.Uint8Array, DataView = core.DataView;
    NAME = 'Uint16';
    ARRAY = NAME + 'Array';
    Typed = core[ARRAY];
    SET = 'set' + NAME;
    GET = 'get' + NAME;
    data = [[0, 0, [0, 0]], [-0, 0, [0, 0]], [1, 1, [1, 0]], [-1, 65535, [255, 255]], [1.1, 1, [1, 0]], [-1.1, 65535, [255, 255]], [1.9, 1, [1, 0]], [-1.9, 65535, [255, 255]], [127, 127, [127, 0]], [-127, 65409, [129, 255]], [128, 128, [128, 0]], [-128, 65408, [128, 255]], [255, 255, [255, 0]], [-255, 65281, [1, 255]], [255.1, 255, [255, 0]], [255.9, 255, [255, 0]], [256, 256, [0, 1]], [32767, 32767, [255, 127]], [-32767, 32769, [1, 128]], [32768, 32768, [0, 128]], [-32768, 32768, [0, 128]], [65535, 65535, [255, 255]], [65536, 0, [0, 0]], [65537, 1, [1, 0]], [65536.54321, 0, [0, 0]], [-65536.54321, 0, [0, 0]], [2147483647, 65535, [255, 255]], [-2147483647, 1, [1, 0]], [2147483648, 0, [0, 0]], [-2147483648, 0, [0, 0]], [4294967296, 0, [0, 0]], [9007199254740992, 0, [0, 0]], [-9007199254740992, 0, [0, 0]], [Infinity, 0, [0, 0]], [-Infinity, 0, [0, 0]], [-1.7976931348623157e+308, 0, [0, 0]], [1.7976931348623157e+308, 0, [0, 0]], [5e-324, 0, [0, 0]], [-5e-324, 0, [0, 0]], [NaN, 0, [0, 0]]];
    if (NATIVE || !/Android [2-4]/.test(typeof navigator != 'undefined' && navigator !== null ? navigator.userAgent : void 8)) {
      data = data.concat([[2147483649, 1, [1, 0]], [-2147483649, 65535, [255, 255]], [4294967295, 65535, [255, 255]], [4294967297, 1, [1, 0]], [9007199254740991, 65535, [255, 255]], [-9007199254740991, 1, [1, 0]], [9007199254740994, 2, [2, 0]], [-9007199254740994, 65534, [254, 255]]]);
    }
    typed = new Typed(1);
    uint8 = new Uint8Array(typed.buffer);
    view = new DataView(typed.buffer);
    viewFrom = function(it){
      return new DataView(new Uint8Array(it).buffer);
    };
    z = function(it){
      if (it === 0 && 1 / it === -Infinity) {
        return '-0';
      } else {
        return it;
      }
    };
    for (i$ = 0, len$ = data.length; i$ < len$; ++i$) {
      ref$ = data[i$], value = ref$[0], conversion = ref$[1], little = ref$[2];
      big = little.slice().reverse();
      rep = LITTLE_ENDIAN ? little : big;
      typed[0] = value;
      assert.same(typed[0], conversion, ARRAY + " " + z(value) + " -> " + z(conversion));
      assert.arrayEqual(uint8, rep, ARRAY + " " + z(value) + " -> [" + rep + "]");
      view[SET](0, value);
      assert.arrayEqual(uint8, big, "view." + SET + "(0, " + z(value) + ") -> [" + big + "]");
      assert.same(viewFrom(big)[GET](0), conversion, "view{" + big + "}." + GET + "(0) -> " + z(conversion));
      view[SET](0, value, false);
      assert.arrayEqual(uint8, big, "view." + SET + "(0, " + z(value) + ", false) -> [" + big + "]");
      assert.same(viewFrom(big)[GET](0, false), conversion, "view{" + big + "}." + GET + "(0, false) -> " + z(conversion));
      view[SET](0, value, true);
      assert.arrayEqual(uint8, little, "view." + SET + "(0, " + z(value) + ", true) -> [" + little + "]");
      assert.same(viewFrom(little)[GET](0, true), conversion, "view{" + little + "}." + GET + "(0, true) -> " + z(conversion));
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  DESCRIPTORS && test('Uint32 conversions', function(assert){
    var Uint8Array, DataView, NAME, ARRAY, Typed, SET, GET, data, typed, uint8, view, viewFrom, z, i$, len$, ref$, value, conversion, little, big, rep;
    Uint8Array = core.Uint8Array, DataView = core.DataView;
    NAME = 'Uint32';
    ARRAY = NAME + 'Array';
    Typed = core[ARRAY];
    SET = 'set' + NAME;
    GET = 'get' + NAME;
    data = [[0, 0, [0, 0, 0, 0]], [-0, 0, [0, 0, 0, 0]], [1, 1, [1, 0, 0, 0]], [-1, 4294967295, [255, 255, 255, 255]], [1.1, 1, [1, 0, 0, 0]], [-1.1, 4294967295, [255, 255, 255, 255]], [1.9, 1, [1, 0, 0, 0]], [-1.9, 4294967295, [255, 255, 255, 255]], [127, 127, [127, 0, 0, 0]], [-127, 4294967169, [129, 255, 255, 255]], [128, 128, [128, 0, 0, 0]], [-128, 4294967168, [128, 255, 255, 255]], [255, 255, [255, 0, 0, 0]], [-255, 4294967041, [1, 255, 255, 255]], [255.1, 255, [255, 0, 0, 0]], [255.9, 255, [255, 0, 0, 0]], [256, 256, [0, 1, 0, 0]], [32767, 32767, [255, 127, 0, 0]], [-32767, 4294934529, [1, 128, 255, 255]], [32768, 32768, [0, 128, 0, 0]], [-32768, 4294934528, [0, 128, 255, 255]], [65535, 65535, [255, 255, 0, 0]], [65536, 65536, [0, 0, 1, 0]], [65537, 65537, [1, 0, 1, 0]], [65536.54321, 65536, [0, 0, 1, 0]], [-65536.54321, 4294901760, [0, 0, 255, 255]], [2147483647, 2147483647, [255, 255, 255, 127]], [-2147483647, 2147483649, [1, 0, 0, 128]], [2147483648, 2147483648, [0, 0, 0, 128]], [-2147483648, 2147483648, [0, 0, 0, 128]], [2147483649, 2147483649, [1, 0, 0, 128]], [-2147483649, 2147483647, [255, 255, 255, 127]], [4294967295, 4294967295, [255, 255, 255, 255]], [4294967296, 0, [0, 0, 0, 0]], [4294967297, 1, [1, 0, 0, 0]], [9007199254740991, 4294967295, [255, 255, 255, 255]], [-9007199254740991, 1, [1, 0, 0, 0]], [9007199254740992, 0, [0, 0, 0, 0]], [-9007199254740992, 0, [0, 0, 0, 0]], [9007199254740994, 2, [2, 0, 0, 0]], [-9007199254740994, 4294967294, [254, 255, 255, 255]], [Infinity, 0, [0, 0, 0, 0]], [-Infinity, 0, [0, 0, 0, 0]], [-1.7976931348623157e+308, 0, [0, 0, 0, 0]], [1.7976931348623157e+308, 0, [0, 0, 0, 0]], [5e-324, 0, [0, 0, 0, 0]], [-5e-324, 0, [0, 0, 0, 0]], [NaN, 0, [0, 0, 0, 0]]];
    typed = new Typed(1);
    uint8 = new Uint8Array(typed.buffer);
    view = new DataView(typed.buffer);
    viewFrom = function(it){
      return new DataView(new Uint8Array(it).buffer);
    };
    z = function(it){
      if (it === 0 && 1 / it === -Infinity) {
        return '-0';
      } else {
        return it;
      }
    };
    for (i$ = 0, len$ = data.length; i$ < len$; ++i$) {
      ref$ = data[i$], value = ref$[0], conversion = ref$[1], little = ref$[2];
      big = little.slice().reverse();
      rep = LITTLE_ENDIAN ? little : big;
      typed[0] = value;
      assert.same(typed[0], conversion, ARRAY + " " + z(value) + " -> " + z(conversion));
      assert.arrayEqual(uint8, rep, ARRAY + " " + z(value) + " -> [" + rep + "]");
      view[SET](0, value);
      assert.arrayEqual(uint8, big, "view." + SET + "(0, " + z(value) + ") -> [" + big + "]");
      assert.same(viewFrom(big)[GET](0), conversion, "view{" + big + "}." + GET + "(0) -> " + z(conversion));
      view[SET](0, value, false);
      assert.arrayEqual(uint8, big, "view." + SET + "(0, " + z(value) + ", false) -> [" + big + "]");
      assert.same(viewFrom(big)[GET](0, false), conversion, "view{" + big + "}." + GET + "(0, false) -> " + z(conversion));
      view[SET](0, value, true);
      assert.arrayEqual(uint8, little, "view." + SET + "(0, " + z(value) + ", true) -> [" + little + "]");
      assert.same(viewFrom(little)[GET](0, true), conversion, "view{" + little + "}." + GET + "(0, true) -> " + z(conversion));
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  DESCRIPTORS && test('Uint8Clamped conversions', function(assert){
    var Uint8Array, DataView, NAME, ARRAY, Typed, data, typed, uint8, z, i$, len$, ref$, value, conversion, little;
    Uint8Array = core.Uint8Array, DataView = core.DataView;
    NAME = 'Uint8Clamped';
    ARRAY = NAME + 'Array';
    Typed = core[ARRAY];
    data = [[0, 0, [0]], [-0, 0, [0]], [1, 1, [1]], [-1, 0, [0]], [1.1, 1, [1]], [-1.1, 0, [0]], [1.9, 2, [2]], [-1.9, 0, [0]], [127, 127, [127]], [-127, 0, [0]], [128, 128, [128]], [-128, 0, [0]], [255, 255, [255]], [-255, 0, [0]], [255.1, 255, [255]], [255.9, 255, [255]], [256, 255, [255]], [32767, 255, [255]], [-32767, 0, [0]], [32768, 255, [255]], [-32768, 0, [0]], [65535, 255, [255]], [65536, 255, [255]], [65537, 255, [255]], [65536.54321, 255, [255]], [-65536.54321, 0, [0]], [2147483647, 255, [255]], [-2147483647, 0, [0]], [2147483648, 255, [255]], [-2147483648, 0, [0]], [2147483649, 255, [255]], [-2147483649, 0, [0]], [4294967295, 255, [255]], [4294967296, 255, [255]], [4294967297, 255, [255]], [9007199254740991, 255, [255]], [-9007199254740991, 0, [0]], [9007199254740992, 255, [255]], [-9007199254740992, 0, [0]], [9007199254740994, 255, [255]], [-9007199254740994, 0, [0]], [Infinity, 255, [255]], [-Infinity, 0, [0]], [-1.7976931348623157e+308, 0, [0]], [1.7976931348623157e+308, 255, [255]], [5e-324, 0, [0]], [-5e-324, 0, [0]], [NaN, 0, [0]]];
    typed = new Typed(1);
    uint8 = new Uint8Array(typed.buffer);
    z = function(it){
      if (it === 0 && 1 / it === -Infinity) {
        return '-0';
      } else {
        return it;
      }
    };
    for (i$ = 0, len$ = data.length; i$ < len$; ++i$) {
      ref$ = data[i$], value = ref$[0], conversion = ref$[1], little = ref$[2];
      typed[0] = value;
      assert.same(typed[0], conversion, z(value) + " -> " + z(conversion));
      assert.arrayEqual(uint8, little, z(value) + " -> [" + little + "]");
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  DESCRIPTORS && test('Uint8 conversions', function(assert){
    var Uint8Array, DataView, NAME, ARRAY, Typed, SET, GET, data, typed, view, viewFrom, z, i$, len$, ref$, value, conversion, little;
    Uint8Array = core.Uint8Array, DataView = core.DataView;
    NAME = 'Uint8';
    ARRAY = NAME + 'Array';
    Typed = core[ARRAY];
    SET = 'set' + NAME;
    GET = 'get' + NAME;
    data = [[0, 0, [0]], [-0, 0, [0]], [1, 1, [1]], [-1, 255, [255]], [1.1, 1, [1]], [-1.1, 255, [255]], [1.9, 1, [1]], [-1.9, 255, [255]], [127, 127, [127]], [-127, 129, [129]], [128, 128, [128]], [-128, 128, [128]], [255, 255, [255]], [-255, 1, [1]], [255.1, 255, [255]], [255.9, 255, [255]], [256, 0, [0]], [32767, 255, [255]], [-32767, 1, [1]], [32768, 0, [0]], [-32768, 0, [0]], [65535, 255, [255]], [65536, 0, [0]], [65537, 1, [1]], [65536.54321, 0, [0]], [-65536.54321, 0, [0]], [2147483647, 255, [255]], [-2147483647, 1, [1]], [2147483648, 0, [0]], [-2147483648, 0, [0]], [4294967296, 0, [0]], [9007199254740992, 0, [0]], [-9007199254740992, 0, [0]], [Infinity, 0, [0]], [-Infinity, 0, [0]], [-1.7976931348623157e+308, 0, [0]], [1.7976931348623157e+308, 0, [0]], [5e-324, 0, [0]], [-5e-324, 0, [0]], [NaN, 0, [0]]];
    if (NATIVE || !/Android [2-4]/.test(typeof navigator != 'undefined' && navigator !== null ? navigator.userAgent : void 8)) {
      data = data.concat([[2147483649, 1, [1]], [-2147483649, 255, [255]], [4294967295, 255, [255]], [4294967297, 1, [1]], [9007199254740991, 255, [255]], [-9007199254740991, 1, [1]], [9007199254740994, 2, [2]], [-9007199254740994, 254, [254]]]);
    }
    typed = new Typed(1);
    view = new DataView(typed.buffer);
    viewFrom = function(it){
      return new DataView(new Uint8Array(it).buffer);
    };
    z = function(it){
      if (it === 0 && 1 / it === -Infinity) {
        return '-0';
      } else {
        return it;
      }
    };
    for (i$ = 0, len$ = data.length; i$ < len$; ++i$) {
      ref$ = data[i$], value = ref$[0], conversion = ref$[1], little = ref$[2];
      typed[0] = value;
      assert.same(typed[0], conversion, ARRAY + " " + z(value) + " -> " + z(conversion));
      assert.arrayEqual(typed, little, ARRAY + " " + z(value) + " -> [" + little + "]");
      view[SET](0, value);
      assert.arrayEqual(typed, little, "view." + SET + "(0, " + z(value) + ") -> [" + little + "]");
      assert.same(viewFrom(little)[GET](0), conversion, "view{" + little + "}." + GET + "(0) -> " + z(conversion));
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, DataView, ArrayBuffer, Uint8Array, i$, x$, ref$, len$, y$;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  DataView = core.DataView, ArrayBuffer = core.ArrayBuffer, Uint8Array = core.Uint8Array;
  test('DataView', function(assert){
    var a, d;
    assert.same(DataView, Object(DataView), 'is object');
    a = new DataView(new ArrayBuffer(8));
    assert.same(a.byteOffset, 0, '#byteOffset, passed buffer');
    assert.same(a.byteLength, 8, '#byteLength, passed buffer');
    a = new DataView(new ArrayBuffer(16), 8);
    assert.same(a.byteOffset, 8, '#byteOffset, passed buffer and byteOffset');
    assert.same(a.byteLength, 8, '#byteLength, passed buffer and byteOffset');
    a = new DataView(new ArrayBuffer(24), 8, 8);
    assert.same(a.byteOffset, 8, '#byteOffset, passed buffer, byteOffset and length');
    assert.same(a.byteLength, 8, '#byteLength, passed buffer, byteOffset and length');
    if (NATIVE) {
      a = new DataView(new ArrayBuffer(8), void 8);
      assert.same(a.byteOffset, 0, '#byteOffset, passed buffer and undefined');
      assert.same(a.byteLength, 8, '#byteLength, passed buffer and undefined');
    }
    if (NATIVE) {
      a = new DataView(new ArrayBuffer(16), 8, void 8);
      assert.same(a.byteOffset, 8, '#byteOffset, passed buffer, byteOffset and undefined');
      assert.same(a.byteLength, 8, '#byteLength, passed buffer, byteOffset and undefined');
    }
    if (NATIVE) {
      a = new DataView(new ArrayBuffer(8), 8);
      assert.same(a.byteOffset, 8, '#byteOffset, passed buffer and byteOffset with buffer length');
      assert.same(a.byteLength, 0, '#byteLength, passed buffer and byteOffset with buffer length');
    }
    if (NATIVE) {
      assert.throws(function(){
        new DataView(new ArrayBuffer(8), -1);
      }, RangeError, 'If offset < 0, throw a RangeError exception');
      assert.throws(function(){
        new DataView(new ArrayBuffer(8), 16);
      }, RangeError, 'If newByteLength < 0, throw a RangeError exception');
      assert.throws(function(){
        new DataView(new ArrayBuffer(24), 8, 24);
      }, RangeError, 'If offset+newByteLength > bufferByteLength, throw a RangeError exception');
    } else {
      assert.throws(function(){
        new DataView(new ArrayBuffer(8), -1);
      }, 'If offset < 0, throw a RangeError exception');
      assert.throws(function(){
        new DataView(new ArrayBuffer(8), 16);
      }, 'If newByteLength < 0, throw a RangeError exception');
      assert.throws(function(){
        new DataView(new ArrayBuffer(24), 8, 24);
      }, 'If offset+newByteLength > bufferByteLength, throw a RangeError exception');
    }
    if (NATIVE) {
      assert.throws(function(){
        DataView(1);
      }, TypeError, 'throws without `new`');
    } else {
      assert.throws(function(){
        DataView(1);
      }, 'throws without `new`');
    }
    d = new DataView(new ArrayBuffer(8));
    d.setUint32(0, 0x12345678);
    assert.same(d.getUint32(0), 0x12345678, 'big endian/big endian');
    d.setUint32(0, 0x12345678, true);
    assert.same(d.getUint32(0, true), 0x12345678, 'little endian/little endian');
    d.setUint32(0, 0x12345678, true);
    assert.same(d.getUint32(0), 0x78563412, 'little endian/big endian');
    d.setUint32(0, 0x12345678);
    assert.same(d.getUint32(0, true), 0x78563412, 'big endian/little endian');
    assert.throws(function(){
      new DataView({});
    }, 'non-ArrayBuffer argument');
    assert.ok(function(){
      var e;
      try {
        new DataView('foo');
      } catch (e$) {
        e = e$;
        return e;
      }
    }, 'non-ArrayBuffer argument');
  });
  DESCRIPTORS && test('DataView accessors', function(assert){
    var u, d, i$, ref$, len$, i, x;
    u = new Uint8Array(8);
    d = new DataView(u.buffer);
    assert.arrayEqual(u, [0, 0, 0, 0, 0, 0, 0, 0]);
    d.setUint8(0, 255);
    assert.arrayEqual(u, [0xff, 0, 0, 0, 0, 0, 0, 0]);
    d.setInt8(1, -1);
    assert.arrayEqual(u, [0xff, 0xff, 0, 0, 0, 0, 0, 0]);
    d.setUint16(2, 0x1234);
    assert.arrayEqual(u, [0xff, 0xff, 0x12, 0x34, 0, 0, 0, 0]);
    d.setInt16(4, -1);
    assert.arrayEqual(u, [0xff, 0xff, 0x12, 0x34, 0xff, 0xff, 0, 0]);
    d.setUint32(1, 0x12345678);
    assert.arrayEqual(u, [0xff, 0x12, 0x34, 0x56, 0x78, 0xff, 0, 0]);
    d.setInt32(4, -2023406815);
    assert.arrayEqual(u, [0xff, 0x12, 0x34, 0x56, 0x87, 0x65, 0x43, 0x21]);
    d.setFloat32(2, 1.2e+38);
    assert.arrayEqual(u, [0xff, 0x12, 0x7e, 0xb4, 0x8e, 0x52, 0x43, 0x21]);
    d.setFloat64(0, -1.2345678e+301);
    assert.arrayEqual(u, [0xfe, 0x72, 0x6f, 0x51, 0x5f, 0x61, 0x77, 0xe5]);
    for (i$ = 0, len$ = (ref$ = [0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87]).length; i$ < len$; ++i$) {
      i = i$;
      x = ref$[i$];
      u[i] = x;
    }
    assert.same(d.getUint8(0), 128);
    assert.same(d.getInt8(1), -127);
    assert.same(d.getUint16(2), 33411);
    assert.same(d.getInt16(3), -31868);
    assert.same(d.getUint32(4), 2223343239);
    assert.same(d.getInt32(2), -2105310075);
    assert.same(d.getFloat32(2), -1.932478247535851e-37);
    assert.same(d.getFloat64(0), -3.116851295377095e-306);
  });
  DESCRIPTORS && test('DataView endian', function(assert){
    var rawbuf, d;
    rawbuf = new Uint8Array([0, 1, 2, 3, 4, 5, 6, 7]).buffer;
    d = new DataView(rawbuf);
    assert.same(d.byteLength, 8, 'buffer');
    assert.same(d.byteOffset, 0, 'buffer');
    assert.throws(function(){
      return d.getUint8(-2);
    });
    assert.throws(function(){
      d.getUint8(8);
    }, 'bounds for buffer');
    assert.throws(function(){
      d.setUint8(-2, 0);
    }, 'bounds for buffer');
    assert.throws(function(){
      d.setUint8(8, 0);
    }, 'bounds for buffer');
    d = new DataView(rawbuf, 2);
    assert.same(d.byteLength, 6, 'buffer, byteOffset');
    assert.same(d.byteOffset, 2, 'buffer, byteOffset');
    assert.same(d.getUint8(5), 7, 'buffer, byteOffset');
    assert.throws(function(){
      d.getUint8(-2);
    }, 'bounds for buffer, byteOffset');
    assert.throws(function(){
      d.getUint8(6);
    }, 'bounds for buffer, byteOffset');
    assert.throws(function(){
      d.setUint8(-2, 0);
    }, 'bounds for buffer, byteOffset');
    assert.throws(function(){
      d.setUint8(6, 0);
    }, 'bounds for buffer, byteOffset');
    assert.throws(function(){
      new DataView(rawbuf, -1);
    }, 'invalid byteOffset');
    assert.throws(function(){
      new DataView(rawbuf, 9);
    }, 'invalid byteOffset');
    d = new DataView(rawbuf, 2, 4);
    assert.same(d.byteLength, 4, 'buffer, byteOffset, length');
    assert.same(d.byteOffset, 2, 'buffer, byteOffset, length');
    assert.same(d.getUint8(3), 5, 'buffer, byteOffset, length');
    assert.throws(function(){
      d.getUint8(-2);
    }, 'bounds for buffer, byteOffset, length');
    assert.throws(function(){
      d.getUint8(4);
    }, 'bounds for buffer, byteOffset, length');
    assert.throws(function(){
      d.setUint8(-2, 0);
    }, 'bounds for buffer, byteOffset, length');
    assert.throws(function(){
      d.setUint8(4, 0);
    }, 'bounds for buffer, byteOffset, length');
    assert.throws(function(){
      new DataView(rawbuf, 0, 9);
    }, 'invalid byteOffset+length');
    assert.throws(function(){
      new DataView(rawbuf, 8, 1);
    }, 'invalid byteOffset+length');
    assert.throws(function(){
      new DataView(rawbuf, 9, -1);
    }, 'invalid byteOffset+length');
  });
  for (i$ = 0, len$ = (ref$ = ['getUint8', 'getInt8', 'getUint16', 'getInt16', 'getUint32', 'getInt32', 'getFloat32', 'getFloat64']).length; i$ < len$; ++i$) {
    x$ = ref$[i$];
    (fn$.call(this, x$));
  }
  for (i$ = 0, len$ = (ref$ = ['setUint8', 'setInt8', 'setUint16', 'setInt16', 'setUint32', 'setInt32', 'setFloat32', 'setFloat64']).length; i$ < len$; ++i$) {
    y$ = ref$[i$];
    (fn1$.call(this, y$));
  }
  function fn$(name){
    test('DataView#' + name, function(assert){
      assert.isFunction(DataView.prototype[name]);
      NATIVE && assert.arity(DataView.prototype[name], 1);
      assert.same(new DataView(new ArrayBuffer(8))[name](0), 0, 'returns element');
    });
  }
  function fn1$(name){
    test('DataView#' + name, function(assert){
      assert.isFunction(DataView.prototype[name]);
      NATIVE && assert.arity(DataView.prototype[name], 2);
      assert.same(new DataView(new ArrayBuffer(8))[name](0, 0), void 8, 'void');
    });
  }
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, WeakMap, Map, freeze, iterator;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  WeakMap = core.WeakMap, Map = core.Map;
  freeze = core.Object.freeze;
  iterator = core.Symbol.iterator;
  test('WeakMap', function(assert){
    var a, f, M, done, iter, o, key, C, O;
    assert.isFunction(WeakMap);
    assert.ok('delete' in WeakMap.prototype, 'delete in WeakMap.prototype');
    assert.ok('get' in WeakMap.prototype, 'get in WeakMap.prototype');
    assert.ok('has' in WeakMap.prototype, 'has in WeakMap.prototype');
    assert.ok('set' in WeakMap.prototype, 'set in WeakMap.prototype');
    assert.ok(new WeakMap instanceof WeakMap, 'new WeakMap instanceof WeakMap');
    assert.strictEqual(new WeakMap(createIterable([[a = {}, 42]])).get(a), 42, 'Init from iterable');
    assert.strictEqual(new WeakMap([[f = freeze({}), 42]]).get(f), 42, 'Support frozen objects');
    M = new WeakMap;
    M.set(freeze(f = {}), 42);
    assert.strictEqual(M.has(f), true, 'works with frozen objects, #1');
    assert.strictEqual(M.get(f), 42, 'works with frozen objects, #2');
    M['delete'](f);
    assert.strictEqual(M.has(f), false, 'works with frozen objects, #3');
    assert.strictEqual(M.get(f), void 8, 'works with frozen objects, #4');
    done = false;
    iter = createIterable([null, 1, 2], {
      'return': function(){
        return done = true;
      }
    });
    try {
      new WeakMap(iter);
    } catch (e$) {}
    assert.ok(done, '.return #throw');
    assert.ok(!('clear' in WeakMap.prototype), 'should not contains `.clear` method');
    a = [];
    done = false;
    a['@@iterator'] = void 8;
    a[iterator] = function(){
      done = true;
      return core.getIteratorMethod([]).call(this);
    };
    new WeakMap(a);
    assert.ok(done);
    o = {};
    new WeakMap().set(o, 1);
    if (DESCRIPTORS) {
      assert.arrayEqual((function(){
        var results$ = [];
        for (key in o) {
          results$.push(key);
        }
        return results$;
      }()), []);
      assert.arrayEqual(core.Object.keys(o), []);
    }
    assert.arrayEqual(core.Object.getOwnPropertyNames(o), []);
    assert.arrayEqual(core.Object.getOwnPropertySymbols(o), []);
    assert.arrayEqual(core.Reflect.ownKeys(o), []);
    if (nativeSubclass) {
      C = nativeSubclass(WeakMap);
      assert.ok(new C instanceof C, 'correct subclassing with native classes #1');
      assert.ok(new C instanceof WeakMap, 'correct subclassing with native classes #2');
      assert.same(new C().set(O = {}, 2).get(O), 2, 'correct subclassing with native classes #3');
    }
  });
  test('WeakMap#delete', function(assert){
    var M, a, b;
    assert.isFunction(WeakMap.prototype['delete']);
    M = new WeakMap([[a = {}, 42], [b = {}, 21]]);
    assert.ok(M.has(a) && M.has(b), 'WeakMap has values before .delete()');
    M['delete'](a);
    assert.ok(!M.has(a) && M.has(b), 'WeakMap hasn`t value after .delete()');
    assert.ok((function(){
      try {
        return !M['delete'](1);
      } catch (e$) {}
    }()), 'return false on primitive');
  });
  test('WeakMap#get', function(assert){
    var M, a;
    assert.isFunction(WeakMap.prototype.get);
    M = new WeakMap();
    assert.strictEqual(M.get({}), void 8, 'WeakMap .get() before .set() return undefined');
    M.set(a = {}, 42);
    assert.strictEqual(M.get(a), 42, 'WeakMap .get() return value');
    M['delete'](a);
    assert.strictEqual(M.get(a), void 8, 'WeakMap .get() after .delete() return undefined');
    assert.ok((function(){
      try {
        return void 8 === M.get(1);
      } catch (e$) {}
    }()), 'return undefined on primitive');
  });
  test('WeakMap#has', function(assert){
    var M, a;
    assert.isFunction(WeakMap.prototype.has);
    M = new WeakMap();
    assert.ok(!M.has({}), 'WeakMap .has() before .set() return false');
    M.set(a = {}, 42);
    assert.ok(M.has(a), 'WeakMap .has() return true');
    M['delete'](a);
    assert.ok(!M.has(a), 'WeakMap .has() after .delete() return false');
    assert.ok((function(){
      try {
        return !M.has(1);
      } catch (e$) {}
    }()), 'return false on primitive');
  });
  test('WeakMap#set', function(assert){
    var w, a, e;
    assert.isFunction(WeakMap.prototype.set);
    assert.ok((w = new WeakMap).set(a = {}, 42) === w, 'chaining');
    assert.ok((function(){
      try {
        new WeakMap().set(42, 42);
        return false;
      } catch (e$) {
        e = e$;
        return true;
      }
    }()), 'throws with primitive keys');
  });
  test('WeakMap#@@toStringTag', function(assert){
    var ref$;
    assert.strictEqual(WeakMap.prototype[(ref$ = core.Symbol) != null ? ref$.toStringTag : void 8], 'WeakMap', 'WeakMap::@@toStringTag is `WeakMap`');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, WeakSet, freeze, iterator;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  WeakSet = core.WeakSet;
  freeze = core.Object.freeze;
  iterator = core.Symbol.iterator;
  test('WeakSet', function(assert){
    var a, f, S, done, iter, o, key, C, O;
    assert.isFunction(WeakSet);
    assert.ok('add' in WeakSet.prototype, 'add in WeakSet.prototype');
    assert.ok('delete' in WeakSet.prototype, 'delete in WeakSet.prototype');
    assert.ok('has' in WeakSet.prototype, 'has in WeakSet.prototype');
    assert.ok(new WeakSet instanceof WeakSet, 'new WeakSet instanceof WeakSet');
    assert.ok(new WeakSet(createIterable([a = {}])).has(a), 'Init from iterable');
    assert.ok(new WeakSet([freeze(f = {})]).has(f), 'Support frozen objects');
    S = new WeakSet;
    S.add(freeze(f = {}));
    assert.strictEqual(S.has(f), true, 'works with frozen objects, #1');
    S['delete'](f);
    assert.strictEqual(S.has(f), false, 'works with frozen objects, #2');
    done = false;
    iter = createIterable([null, 1, 2], {
      'return': function(){
        return done = true;
      }
    });
    try {
      new WeakSet(iter);
    } catch (e$) {}
    assert.ok(done, '.return #throw');
    assert.ok(!('clear' in WeakSet.prototype), 'should not contains `.clear` method');
    a = [];
    done = false;
    a['@@iterator'] = void 8;
    a[iterator] = function(){
      done = true;
      return core.getIteratorMethod([]).call(this);
    };
    new WeakSet(a);
    assert.ok(done);
    o = {};
    new WeakSet().add(o);
    if (DESCRIPTORS) {
      assert.arrayEqual((function(){
        var results$ = [];
        for (key in o) {
          results$.push(key);
        }
        return results$;
      }()), []);
      assert.arrayEqual(core.Object.keys(o), []);
    }
    assert.arrayEqual(core.Object.getOwnPropertyNames(o), []);
    assert.arrayEqual(core.Object.getOwnPropertySymbols(o), []);
    assert.arrayEqual(core.Reflect.ownKeys(o), []);
    if (nativeSubclass) {
      C = nativeSubclass(WeakSet);
      assert.ok(new C instanceof C, 'correct subclassing with native classes #1');
      assert.ok(new C instanceof WeakSet, 'correct subclassing with native classes #2');
      assert.ok(new C().add(O = {}).has(O), 'correct subclassing with native classes #3');
    }
  });
  test('WeakSet#add', function(assert){
    var w, e;
    assert.isFunction(WeakSet.prototype.add);
    assert.ok((w = new WeakSet).add({}) === w, 'chaining');
    assert.ok((function(){
      try {
        new WeakSet().add(42);
        return false;
      } catch (e$) {
        e = e$;
        return true;
      }
    }()), 'throws with primitive keys');
  });
  test('WeakSet#delete', function(assert){
    var S, a, b;
    assert.isFunction(WeakSet.prototype['delete']);
    S = new WeakSet().add(a = {}).add(b = {});
    assert.ok(S.has(a) && S.has(b), 'WeakSet has values before .delete()');
    S['delete'](a);
    assert.ok(!S.has(a) && S.has(b), 'WeakSet has`nt value after .delete()');
    assert.ok((function(){
      try {
        return !S['delete'](1);
      } catch (e$) {}
    }()), 'return false on primitive');
  });
  test('WeakSet#has', function(assert){
    var M, a;
    assert.isFunction(WeakSet.prototype.has);
    M = new WeakSet();
    assert.ok(!M.has({}), 'WeakSet has`nt value');
    M.add(a = {});
    assert.ok(M.has(a), 'WeakSet has value after .add()');
    M['delete'](a);
    assert.ok(!M.has(a), 'WeakSet hasn`t value after .delete()');
    assert.ok((function(){
      try {
        return !M.has(1);
      } catch (e$) {}
    }()), 'return false on primitive');
  });
  test('WeakSet::@@toStringTag', function(assert){
    var ref$;
    assert.strictEqual(WeakSet.prototype[(ref$ = core.Symbol) != null ? ref$.toStringTag : void 8], 'WeakSet', 'WeakSet::@@toStringTag is `WeakSet`');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Array#flatMap', function(assert){
    var flatMap, element, index, context, target, array, $context;
    flatMap = core.Array.flatMap;
    assert.isFunction(flatMap);
    assert.deepEqual(flatMap([], function(it){
      return it;
    }), []);
    assert.deepEqual(flatMap([1, 2, 3], function(it){
      return it;
    }), [1, 2, 3]);
    assert.deepEqual(flatMap([1, 2, 3], function(it){
      return [it, it];
    }), [1, 1, 2, 2, 3, 3]);
    assert.deepEqual(flatMap([1, 2, 3], function(it){
      return [[it], [it]];
    }), [[1], [1], [2], [2], [3], [3]]);
    assert.deepEqual(flatMap([1, [2, 3]], function(){
      return 1;
    }), [1, 1]);
    element = void 8;
    index = void 8;
    context = void 8;
    target = void 8;
    array = [1];
    flatMap(array, function($element, $index, $target){
      element = $element;
      index = $index;
      target = $target;
      context = this;
      return element;
    }, $context = {});
    assert.same(element, 1);
    assert.same(index, 0);
    assert.same(target, array);
    assert.same(context, $context);
    if (STRICT) {
      assert.throws(function(){
        flatMap(null, function(it){
          return it;
        });
      }, TypeError);
      assert.throws(function(){
        flatMap(void 8, function(it){
          return it;
        });
      }, TypeError);
    }
    if (NATIVE && DESCRIPTORS) {
      assert.ok((function(){
        try {
          return false === flatMap(core.Object.defineProperty({
            length: -1
          }, 0, {
            get: function(){
              throw Error();
            }
          }), function(it){
            return it;
          });
        } catch (e$) {}
      }()), 'uses ToLength');
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Array#flatten', function(assert){
    var flatten, arr;
    flatten = core.Array.flatten;
    assert.isFunction(flatten);
    assert.deepEqual(flatten([]), []);
    arr = [1, [2, 3], [4, [5, 6]]];
    assert.deepEqual(flatten(arr, 0), arr);
    assert.deepEqual(flatten(arr, 1), [1, 2, 3, 4, [5, 6]]);
    assert.deepEqual(flatten(arr), [1, 2, 3, 4, [5, 6]]);
    assert.deepEqual(flatten(arr, 2), [1, 2, 3, 4, 5, 6]);
    assert.deepEqual(flatten(arr, 3), [1, 2, 3, 4, 5, 6]);
    assert.deepEqual(flatten(arr, -1), arr);
    assert.deepEqual(flatten(arr, Infinity), [1, 2, 3, 4, 5, 6]);
    if (STRICT) {
      assert.throws(function(){
        flatten(null, function(it){
          return it;
        });
      }, TypeError);
      assert.throws(function(){
        flatten(void 8, function(it){
          return it;
        });
      }, TypeError);
    }
    if (NATIVE && DESCRIPTORS) {
      assert.ok((function(){
        try {
          return false === flatten(core.Object.defineProperty({
            length: -1
          }, 0, {
            get: function(){
              throw Error();
            }
          }), function(it){
            return it;
          });
        } catch (e$) {}
      }()), 'uses ToLength');
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Array#includes', function(assert){
    var includes, arr, o;
    includes = core.Array.includes;
    assert.isFunction(includes);
    arr = [1, 2, 3, -0, o = {}];
    assert.ok(includes(arr, 1));
    assert.ok(includes(arr, -0));
    assert.ok(includes(arr, 0));
    assert.ok(includes(arr, o));
    assert.ok(!includes(arr, 4));
    assert.ok(!includes(arr, -0.5));
    assert.ok(!includes(arr, {}));
    assert.ok(includes(Array(1), void 8));
    assert.ok(includes([NaN], NaN));
    if (STRICT) {
      assert.throws(function(){
        includes(null, 0);
      }, TypeError);
      assert.throws(function(){
        includes(void 8, 0);
      }, TypeError);
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('asap', function(assert){
    var asap, async, done, after;
    asap = core.asap;
    assert.expect(3);
    assert.isFunction(asap);
    assert.arity(asap, 1);
    async = assert.async();
    done = false;
    asap(function(){
      var done;
      if (!done) {
        done = true;
        assert.ok(after, 'works');
        async();
      }
    });
    setTimeout(function(){
      var done;
      if (!done) {
        done = true;
        assert.ok(false, 'fails');
        async();
      }
    }, 3e3);
    return after = true;
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Error.isError', function(assert){
    var isError;
    isError = core.Error.isError;
    assert.isFunction(isError);
    assert.same(isError(new TypeError), true);
    assert.same(isError({}), false);
    assert.same(isError(null), false);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('global', function(assert){
    var global;
    global = core.global;
    assert.same(global, Object(global), 'is object');
    assert.same(global.Math, Math, 'contains globals');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Map.from', function(assert){
    var Map, from, element, index, context, $$element, $context, arg, F;
    Map = core.Map;
    from = Map.from;
    assert.isFunction(from);
    assert.arity(from, 1);
    assert.ok(Map.from() instanceof Map);
    assert.deepEqual(core.Array.from(Map.from([])), []);
    assert.deepEqual(core.Array.from(Map.from([[1, 2]])), [[1, 2]]);
    assert.deepEqual(core.Array.from(Map.from([[1, 2], [2, 3], [1, 4]])), [[1, 4], [2, 3]]);
    assert.deepEqual(core.Array.from(Map.from(createIterable([[1, 2], [2, 3], [1, 4]]))), [[1, 4], [2, 3]]);
    element = void 8;
    index = void 8;
    context = void 8;
    Map.from([$$element = [1, 2]], function($element, $index){
      element = $element;
      index = $index;
      context = this;
      return element;
    }, $context = {});
    assert.same(element, $$element);
    assert.same(index, 0);
    assert.same(context, $context);
    assert.throws(function(){
      from([1, 2]);
    });
    arg = void 8;
    F = function(it){
      return arg = it;
    };
    from.call(F, createIterable([1, 2, 3]), function(it){
      return Math.pow(it, 2);
    });
    assert.deepEqual(arg, [1, 4, 9]);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Map.of', function(assert){
    var Map, $of, arg, F;
    Map = core.Map;
    $of = Map.of;
    assert.isFunction($of);
    assert.arity($of, 0);
    assert.ok(Map.of() instanceof Map);
    assert.deepEqual(core.Array.from(Map.of([1, 2])), [[1, 2]]);
    assert.deepEqual(core.Array.from(Map.of([1, 2], [2, 3], [1, 4])), [[1, 4], [2, 3]]);
    assert.throws(function(){
      $of(1);
    });
    arg = void 8;
    F = function(it){
      return arg = it;
    };
    $of.call(F, 1, 2, 3);
    assert.deepEqual(arg, [1, 2, 3]);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Math.clamp', function(assert){
    var clamp;
    clamp = core.Math.clamp;
    assert.isFunction(clamp);
    assert.arity(clamp, 3);
    assert.same(clamp(2, 4, 6), 4);
    assert.same(clamp(4, 2, 6), 4);
    assert.same(clamp(6, 2, 4), 4);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Math.DEG_PER_RAD', function(assert){
    var DEG_PER_RAD;
    DEG_PER_RAD = core.Math.DEG_PER_RAD;
    assert.ok('DEG_PER_RAD' in core.Math, 'DEG_PER_RAD in Math');
    assert.strictEqual(DEG_PER_RAD, Math.PI / 180, 'Is Math.PI / 180');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Math.degrees', function(assert){
    var degrees;
    degrees = core.Math.degrees;
    assert.isFunction(degrees);
    assert.arity(degrees, 1);
    assert.same(degrees(0), 0);
    assert.same(degrees(Math.PI / 2), 90);
    assert.same(degrees(Math.PI), 180);
    assert.same(degrees(3 * Math.PI / 2), 270);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Math.fscale', function(assert){
    var fscale;
    fscale = core.Math.fscale;
    assert.isFunction(fscale);
    assert.arity(fscale, 5);
    assert.same(fscale(3, 1, 2, 1, 2), 3);
    assert.same(fscale(0, 3, 5, 8, 10), 5);
    assert.same(fscale(1, 1, 1, 1, 1), NaN);
    assert.same(fscale(-1, -1, -1, -1, -1), NaN);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Math.iaddh', function(assert){
    var iaddh;
    iaddh = core.Math.iaddh;
    assert.isFunction(iaddh);
    assert.arity(iaddh, 4);
    assert.same(iaddh(0, 2, 1, 0), 2);
    assert.same(iaddh(0, 4, 1, 1), 5);
    assert.same(iaddh(2, 4, 1, 1), 5);
    assert.same(iaddh(0xffffffff, 4, 1, 1), 6);
    assert.same(iaddh(1, 4, 0xffffffff, 1), 6);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Math.imulh', function(assert){
    var imulh;
    imulh = core.Math.imulh;
    assert.isFunction(imulh);
    assert.arity(imulh, 2);
    assert.same(imulh(0xffffffff, 7), -1);
    assert.same(imulh(0xfffffff, 77), 4);
    assert.same(imulh(1, 7), 0);
    assert.same(imulh(-1, 7), -1);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Math.isubh', function(assert){
    var isubh;
    isubh = core.Math.isubh;
    assert.isFunction(isubh);
    assert.arity(isubh, 4);
    assert.same(isubh(0, 2, 1, 0), 1);
    assert.same(isubh(0, 4, 1, 1), 2);
    assert.same(isubh(2, 4, 1, 1), 3);
    assert.same(isubh(0xffffffff, 4, 1, 1), 3);
    assert.same(isubh(1, 4, 0xffffffff, 1), 2);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Math.RAD_PER_DEG', function(assert){
    var RAD_PER_DEG;
    RAD_PER_DEG = core.Math.RAD_PER_DEG;
    assert.ok('RAD_PER_DEG' in core.Math, 'RAD_PER_DEG in Math');
    assert.strictEqual(RAD_PER_DEG, 180 / Math.PI, 'Is 180 / Math.PI');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Math.radians', function(assert){
    var radians;
    radians = core.Math.radians;
    assert.isFunction(radians);
    assert.arity(radians, 1);
    assert.same(radians(0), 0);
    assert.same(radians(90), Math.PI / 2);
    assert.same(radians(180), Math.PI);
    assert.same(radians(270), 3 * Math.PI / 2);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Math.scale', function(assert){
    var scale;
    scale = core.Math.scale;
    assert.isFunction(scale);
    assert.arity(scale, 5);
    assert.same(scale(3, 1, 2, 1, 2), 3);
    assert.same(scale(0, 3, 5, 8, 10), 5);
    assert.same(scale(1, 1, 1, 1, 1), NaN);
    assert.same(scale(-1, -1, -1, -1, -1), NaN);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Math.signbit', function(assert){
    var signbit;
    signbit = core.Math.signbit;
    assert.isFunction(signbit);
    assert.same(signbit(NaN), NaN);
    assert.same(signbit(), NaN);
    assert.same(signbit(-0), false);
    assert.same(signbit(0), true);
    assert.strictEqual(signbit(Infinity), true);
    assert.strictEqual(signbit(-Infinity), false);
    assert.strictEqual(signbit(13510798882111488), true);
    assert.strictEqual(signbit(-13510798882111488), false);
    assert.strictEqual(signbit(42.5), true);
    assert.strictEqual(signbit(-42.5), false);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Math.umulh', function(assert){
    var umulh;
    umulh = core.Math.umulh;
    assert.isFunction(umulh);
    assert.arity(umulh, 2);
    assert.same(umulh(0xffffffff, 7), 6);
    assert.same(umulh(0xfffffff, 77), 4);
    assert.same(umulh(1, 7), 0);
    assert.same(umulh(-1, 7), 6);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  if (DESCRIPTORS) {
    test('Object#__defineGetter__', function(assert){
      var ref$, __defineGetter__, __defineSetter__, O, i$, x$, len$;
      ref$ = core.Object, __defineGetter__ = ref$.__defineGetter__, __defineSetter__ = ref$.__defineSetter__;
      assert.isFunction(__defineGetter__);
      O = {};
      assert.same(__defineGetter__(O, 'key', function(){
        return 42;
      }), void 8, 'void');
      assert.same(O.key, 42, 'works');
      __defineSetter__(O, 'key', function(){
        this.foo = 43;
      });
      O.key = 44;
      assert.ok(O.key === 42 && O.foo === 43, 'works with setter');
      if (STRICT) {
        for (i$ = 0, len$ = (ref$ = [null, void 8]).length; i$ < len$; ++i$) {
          x$ = ref$[i$];
          assert.throws(fn$, TypeError, "Throws on " + x$ + " as `this`");
        }
      }
      function fn$(){
        __defineGetter__(x$, 1, function(){});
      }
    });
  }
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  if (DESCRIPTORS) {
    test('Object#__defineSetter__', function(assert){
      var ref$, __defineSetter__, __defineGetter__, O, i$, x$, len$;
      ref$ = core.Object, __defineSetter__ = ref$.__defineSetter__, __defineGetter__ = ref$.__defineGetter__;
      assert.isFunction(__defineSetter__);
      O = {};
      assert.same(__defineSetter__(O, 'key', function(){
        this.foo = 43;
      }), void 8, 'void');
      O.key = 44;
      assert.same(O.foo, 43, 'works');
      O = {};
      __defineSetter__(O, 'key', function(){
        this.foo = 43;
      });
      __defineGetter__(O, 'key', function(){
        return 42;
      });
      O.key = 44;
      assert.ok(O.key === 42 && O.foo === 43, 'works with getter');
      if (STRICT) {
        for (i$ = 0, len$ = (ref$ = [null, void 8]).length; i$ < len$; ++i$) {
          x$ = ref$[i$];
          assert.throws(fn$, TypeError, "Throws on " + x$ + " as `this`");
        }
      }
      function fn$(){
        __defineSetter__(x$, 1, function(){});
      }
    });
  }
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Object.entries', function(assert){
    var ref$, entries, create, assign;
    ref$ = core.Object, entries = ref$.entries, create = ref$.create, assign = ref$.assign;
    assert.isFunction(entries);
    assert.arity(entries, 1);
    if ('name' in entries) {
      assert.name(entries, 'entries');
    }
    assert.deepEqual(entries({
      q: 1,
      w: 2,
      e: 3
    }), [['q', 1], ['w', 2], ['e', 3]]);
    assert.deepEqual(entries(new String('qwe')), [['0', 'q'], ['1', 'w'], ['2', 'e']]);
    assert.deepEqual(entries(assign(create({
      q: 1,
      w: 2,
      e: 3
    }), {
      a: 4,
      s: 5,
      d: 6
    })), [['a', 4], ['s', 5], ['d', 6]]);
    assert.deepEqual(entries({
      valueOf: 42
    }), [['valueOf', 42]], 'IE enum keys bug');
    try {
      assert.deepEqual(Function('return core.Object.entries({a: 1, get b(){delete this.c;return 2},c: 3})')(), [['a', 1], ['b', 2]]);
    } catch (e$) {}
    try {
      assert.deepEqual(Function('return core.Object.entries({a: 1, get b(){Object.defineProperty(this, "c", {value:4,enumerable:false});return 2},c: 3})')(), [['a', 1], ['b', 2]]);
    } catch (e$) {}
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, create;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  create = core.Object.create;
  test('Object.getOwnPropertyDescriptors', function(assert){
    var getOwnPropertyDescriptors, O, s, descs;
    getOwnPropertyDescriptors = core.Object.getOwnPropertyDescriptors;
    assert.isFunction(getOwnPropertyDescriptors);
    O = create({
      q: 1
    }, {
      e: {
        value: 3
      }
    });
    O.w = 2;
    s = core.Symbol('s');
    O[s] = 4;
    descs = getOwnPropertyDescriptors(O);
    assert.strictEqual(descs.q, void 8);
    assert.deepEqual(descs.w, {
      enumerable: true,
      configurable: true,
      writable: true,
      value: 2
    });
    if (DESCRIPTORS) {
      assert.deepEqual(descs.e, {
        enumerable: false,
        configurable: false,
        writable: false,
        value: 3
      });
    } else {
      assert.deepEqual(descs.e, {
        enumerable: true,
        configurable: true,
        writable: true,
        value: 3
      });
    }
    assert.strictEqual(descs[s].value, 4);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  if (DESCRIPTORS) {
    test('Object#__lookupGetter__', function(assert){
      var ref$, __lookupGetter__, __defineGetter__, create, O, F, i$, x$, len$;
      ref$ = core.Object, __lookupGetter__ = ref$.__lookupGetter__, __defineGetter__ = ref$.__defineGetter__;
      create = core.Object.create;
      assert.isFunction(__lookupGetter__);
      assert.same(__lookupGetter__({}, 'key'), void 8, 'empty object');
      assert.same(__lookupGetter__({
        key: 42
      }, 'key'), void 8, 'data descriptor');
      O = {};
      F = function(){};
      __defineGetter__(O, 'key', F);
      assert.same(__lookupGetter__(O, 'key'), F, 'own getter');
      assert.same(__lookupGetter__(create(O), 'key'), F, 'proto getter');
      assert.same(__lookupGetter__(create(O), 'foo'), void 8, 'empty proto');
      if (STRICT) {
        for (i$ = 0, len$ = (ref$ = [null, void 8]).length; i$ < len$; ++i$) {
          x$ = ref$[i$];
          assert.throws(fn$, TypeError, "Throws on " + x$ + " as `this`");
        }
      }
      function fn$(){
        __lookupGetter__(x$, 1);
      }
    });
  }
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  if (DESCRIPTORS) {
    test('Object#__lookupSetter__', function(assert){
      var ref$, __lookupSetter__, __defineSetter__, create, O, F, i$, x$, len$;
      ref$ = core.Object, __lookupSetter__ = ref$.__lookupSetter__, __defineSetter__ = ref$.__defineSetter__;
      create = core.Object.create;
      assert.isFunction(__lookupSetter__);
      assert.same(__lookupSetter__({}, 'key'), void 8, 'empty object');
      assert.same(__lookupSetter__({
        key: 42
      }, 'key'), void 8, 'data descriptor');
      O = {};
      F = function(){};
      __defineSetter__(O, 'key', F);
      assert.same(__lookupSetter__(O, 'key'), F, 'own setter');
      assert.same(__lookupSetter__(create(O), 'key'), F, 'proto setter');
      assert.same(__lookupSetter__(create(O), 'foo'), void 8, 'empty proto');
      if (STRICT) {
        for (i$ = 0, len$ = (ref$ = [null, void 8]).length; i$ < len$; ++i$) {
          x$ = ref$[i$];
          assert.throws(fn$, TypeError, "Throws on " + x$ + " as `this`");
        }
      }
      function fn$(){
        __lookupSetter__(x$, 1);
      }
    });
  }
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Object.values', function(assert){
    var ref$, values, create, assign;
    ref$ = core.Object, values = ref$.values, create = ref$.create, assign = ref$.assign;
    assert.isFunction(values);
    assert.arity(values, 1);
    if ('name' in values) {
      assert.name(values, 'values');
    }
    assert.deepEqual(values({
      q: 1,
      w: 2,
      e: 3
    }), [1, 2, 3]);
    assert.deepEqual(values(new String('qwe')), ['q', 'w', 'e']);
    assert.deepEqual(values(assign(create({
      q: 1,
      w: 2,
      e: 3
    }), {
      a: 4,
      s: 5,
      d: 6
    })), [4, 5, 6]);
    assert.deepEqual(values({
      valueOf: 42
    }), [42], 'IE enum keys bug');
    try {
      assert.deepEqual(Function('return core.Object.values({a: 1, get b(){delete this.c;return 2},c: 3})')(), [1, 2]);
    } catch (e$) {}
    try {
      assert.deepEqual(Function('return core.Object.values({a: 1, get b(){Object.defineProperty(this, "c", {value:4,enumerable:false});return 2},c: 3})')(), [1, 2]);
    } catch (e$) {}
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  'use strict';
  var module, test, Observable, Promise, Symbol;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  Observable = core.Observable, Promise = core.Promise, Symbol = core.Symbol;
  test('Observable', function(assert){
    var obsevable;
    assert.isFunction(Observable);
    assert.arity(Observable, 1);
    assert.throws(function(){
      Observable(function(){});
    }, 'throws w/o `new`');
    obsevable = new Observable(function(subscriptionObserver){
      var next, error, complete;
      assert.same(typeof subscriptionObserver, 'object', 'Subscription observer is object');
      assert.same(subscriptionObserver.constructor, Object);
      next = subscriptionObserver.next, error = subscriptionObserver.error, complete = subscriptionObserver.complete;
      assert.isFunction(next);
      assert.isFunction(error);
      assert.isFunction(complete);
      assert.arity(next, 1);
      assert.arity(error, 1);
      assert.arity(complete, 1);
      if (STRICT) {
        assert.same(this, function(){
          return this;
        }(), 'correct executor context');
      }
    });
    obsevable.subscribe({});
    assert.ok(obsevable instanceof Observable);
  });
  test('Observable#subscribe', function(assert){
    var subscription;
    assert.isFunction(Observable.prototype.subscribe);
    assert.arity(Observable.prototype.subscribe, 1);
    subscription = new Observable(function(){}).subscribe({});
    assert.same(typeof subscription, 'object', 'Subscription is object');
    assert.same(subscription.constructor, Object);
    assert.isFunction(subscription.unsubscribe);
    assert.arity(subscription.unsubscribe, 0);
  });
  test('Observable#forEach', function(assert){
    assert.isFunction(Observable.prototype.forEach);
    assert.arity(Observable.prototype.forEach, 1);
    assert.ok(new Observable(function(){}).forEach(function(){}) instanceof Promise, 'returns Promise');
  });
  test('Observable#constructor', function(assert){
    assert.same(Observable.prototype.constructor, Observable);
  });
  test('Observable#@@observable', function(assert){
    var observable;
    assert.isFunction(Observable.prototype[Symbol.observable]);
    observable = new Observable(function(){});
    assert.same(observable[Symbol.observable](), observable);
  });
  test('Observable.of', function(assert){
    assert.isFunction(Observable.of);
    assert.arity(Observable.of, 0);
  });
  test('Observable.from', function(assert){
    assert.isFunction(Observable.from);
    assert.arity(Observable.from, 1);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, Promise;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  Promise = core.Promise;
  test('Promise#finally', function(assert){
    assert.isFunction(Promise.prototype['finally']);
    assert.arity(Promise.prototype['finally'], 1);
    assert.nonEnumerable(Promise.prototype, 'finally');
    assert.ok(Promise.resolve(42)['finally'](function(){}) instanceof Promise, 'returns a promise');
  });
  test('Promise#finally, resolved', function(assert){
    var async, called, arg;
    assert.expect(3);
    async = assert.async();
    called = 0;
    arg = void 8;
    Promise.resolve(42)['finally'](function(it){
      called++;
      arg = it;
    }).then(function(it){
      assert.same(it, 42, 'resolved with a correct value');
      assert.same(called, 1, 'onFinally function called one time');
      assert.same(arg, void 8, 'onFinally function called with a correct argument');
      async();
    });
  });
  test('Promise#finally, rejected', function(assert){
    var async, called, arg;
    assert.expect(2);
    async = assert.async();
    called = 0;
    arg = void 8;
    Promise.reject(42)['finally'](function(it){
      called++;
      arg = it;
    })['catch'](function(){
      assert.same(called, 1, 'onFinally function called one time');
      assert.same(arg, void 8, 'onFinally function called with a correct argument');
      async();
    });
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, Promise;
  module = QUnit.module, test = QUnit.test;
  Promise = core.Promise;
  module('ES7');
  test('Promise.try', function(assert){
    assert.isFunction(Promise['try']);
    assert.arity(Promise['try'], 1);
    assert.ok(Promise['try'](function(){
      return 42;
    }) instanceof Promise, 'returns a promise');
  });
  test('Promise.try, resolved', function(assert){
    var async;
    assert.expect(1);
    async = assert.async();
    Promise['try'](function(){
      return 42;
    }).then(function(it){
      assert.same(it, 42, 'resolved with a correct value');
      async();
    });
  });
  test('Promise.try, rejected', function(assert){
    var async;
    assert.expect(1);
    async = assert.async();
    Promise['try'](function(){
      throw 42;
    })['catch'](function(){
      assert.ok(true, 'rejected as expected');
      async();
    });
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Reflect.defineMetadata', function(assert){
    var defineMetadata;
    defineMetadata = core.Reflect.defineMetadata;
    assert.isFunction(defineMetadata);
    assert.arity(defineMetadata, 4);
    assert.throws(function(){
      defineMetadata('key', 'value', void 8, void 8);
    }, TypeError);
    assert.same(defineMetadata('key', 'value', {}, void 8), void 8);
    assert.same(defineMetadata('key', 'value', {}, 'name'), void 8);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Reflect.deleteMetadata', function(assert){
    var ref$, defineMetadata, hasOwnMetadata, deleteMetadata, create, obj, prototype;
    ref$ = core.Reflect, defineMetadata = ref$.defineMetadata, hasOwnMetadata = ref$.hasOwnMetadata, deleteMetadata = ref$.deleteMetadata;
    create = core.Object.create;
    assert.isFunction(deleteMetadata);
    assert.arity(deleteMetadata, 2);
    assert.throws(function(){
      deleteMetadata('key', void 8, void 8);
    }, TypeError);
    assert.same(deleteMetadata('key', {}, void 8), false);
    obj = {};
    defineMetadata('key', 'value', obj, void 8);
    assert.same(deleteMetadata('key', obj, void 8), true);
    prototype = {};
    defineMetadata('key', 'value', prototype, void 8);
    assert.same(deleteMetadata('key', create(prototype), void 8), false);
    obj = {};
    defineMetadata('key', 'value', obj, void 8);
    deleteMetadata('key', obj, void 8);
    assert.same(hasOwnMetadata("key", obj, undefined), false);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Reflect.getMetadataKeys', function(assert){
    var ref$, defineMetadata, getMetadataKeys, create, obj, prototype;
    ref$ = core.Reflect, defineMetadata = ref$.defineMetadata, getMetadataKeys = ref$.getMetadataKeys;
    create = core.Object.create;
    assert.isFunction(getMetadataKeys);
    assert.arity(getMetadataKeys, 1);
    assert.throws(function(){
      getMetadataKeys(void 8, void 8);
    }, TypeError);
    assert.deepEqual(getMetadataKeys({}, void 8), []);
    obj = {};
    defineMetadata('key', 'value', obj, void 8);
    assert.deepEqual(getMetadataKeys(obj, void 8), ['key']);
    prototype = {};
    obj = create(prototype);
    defineMetadata('key', 'value', prototype, void 8);
    assert.deepEqual(getMetadataKeys(obj, void 8), ['key']);
    obj = {};
    defineMetadata('key0', 'value', obj, void 8);
    defineMetadata('key1', 'value', obj, void 8);
    assert.deepEqual(getMetadataKeys(obj, void 8), ['key0', 'key1']);
    obj = {};
    defineMetadata('key0', 'value', obj, void 8);
    defineMetadata('key1', 'value', obj, void 8);
    defineMetadata('key0', 'value', obj, void 8);
    assert.deepEqual(getMetadataKeys(obj, void 8), ['key0', 'key1']);
    prototype = {};
    defineMetadata('key2', 'value', prototype, void 8);
    obj = create(prototype);
    defineMetadata('key0', 'value', obj, void 8);
    defineMetadata('key1', 'value', obj, void 8);
    assert.deepEqual(getMetadataKeys(obj, void 8), ['key0', 'key1', 'key2']);
    obj = {};
    assert.deepEqual(getMetadataKeys({}, 'name'), []);
    obj = {};
    defineMetadata('key', 'value', obj, 'name');
    assert.deepEqual(getMetadataKeys(obj, 'name'), ['key']);
    prototype = {};
    obj = create(prototype);
    defineMetadata('key', 'value', prototype, 'name');
    assert.deepEqual(getMetadataKeys(obj, 'name'), ['key']);
    obj = {};
    defineMetadata('key0', 'value', obj, 'name');
    defineMetadata('key1', 'value', obj, 'name');
    defineMetadata('key0', 'value', obj, 'name');
    assert.deepEqual(getMetadataKeys(obj, 'name'), ['key0', 'key1']);
    prototype = {};
    defineMetadata('key2', 'value', prototype, 'name');
    obj = create(prototype);
    defineMetadata('key0', 'value', obj, 'name');
    defineMetadata('key1', 'value', obj, 'name');
    assert.deepEqual(getMetadataKeys(obj, 'name'), ['key0', 'key1', 'key2']);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Reflect.getMetadata', function(assert){
    var ref$, defineMetadata, getMetadata, create, obj, prototype;
    ref$ = core.Reflect, defineMetadata = ref$.defineMetadata, getMetadata = ref$.getMetadata;
    create = core.Object.create;
    assert.isFunction(getMetadata);
    assert.arity(getMetadata, 2);
    assert.throws(function(){
      getMetadata('key', void 8, void 8);
    }, TypeError);
    assert.same(getMetadata('key', {}, void 8), void 8);
    obj = {};
    defineMetadata('key', 'value', obj, void 8);
    assert.same(getMetadata('key', obj, void 8), 'value');
    prototype = {};
    obj = create(prototype);
    defineMetadata('key', 'value', prototype, void 8);
    assert.same(getMetadata('key', obj, void 8), 'value');
    assert.same(getMetadata('key', {}, 'name'), void 8);
    obj = {};
    defineMetadata('key', 'value', obj, 'name');
    assert.same(getMetadata('key', obj, 'name'), 'value');
    prototype = {};
    obj = create(prototype);
    defineMetadata('key', 'value', prototype, 'name');
    assert.same(getMetadata('key', obj, 'name'), 'value');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Reflect.getOwnMetadata', function(assert){
    var ref$, defineMetadata, getOwnMetadata, create, obj, prototype;
    ref$ = core.Reflect, defineMetadata = ref$.defineMetadata, getOwnMetadata = ref$.getOwnMetadata;
    create = core.Object.create;
    assert.isFunction(getOwnMetadata);
    assert.arity(getOwnMetadata, 2);
    assert.throws(function(){
      getOwnMetadata('key', void 8, void 8);
    }, TypeError);
    assert.same(getOwnMetadata('key', {}, void 8), void 8);
    obj = {};
    defineMetadata('key', 'value', obj, void 8);
    assert.same(getOwnMetadata('key', obj, void 8), 'value');
    prototype = {};
    obj = create(prototype);
    defineMetadata('key', 'value', prototype, void 8);
    assert.same(getOwnMetadata('key', obj, void 8), void 8);
    assert.same(getOwnMetadata('key', {}, 'name'), void 8);
    obj = {};
    defineMetadata('key', 'value', obj, 'name');
    assert.same(getOwnMetadata('key', obj, 'name'), 'value');
    prototype = {};
    obj = create(prototype);
    defineMetadata('key', 'value', prototype, 'name');
    assert.same(getOwnMetadata('key', obj, 'name'), void 8);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Reflect.getOwnMetadataKeys', function(assert){
    var ref$, defineMetadata, getOwnMetadataKeys, create, obj, prototype;
    ref$ = core.Reflect, defineMetadata = ref$.defineMetadata, getOwnMetadataKeys = ref$.getOwnMetadataKeys;
    create = core.Object.create;
    assert.isFunction(getOwnMetadataKeys);
    assert.arity(getOwnMetadataKeys, 1);
    assert.throws(function(){
      getOwnMetadataKeys(void 8, void 8);
    }, TypeError);
    assert.deepEqual(getOwnMetadataKeys({}, void 8), []);
    obj = {};
    defineMetadata('key', 'value', obj, void 8);
    assert.deepEqual(getOwnMetadataKeys(obj, void 8), ['key']);
    prototype = {};
    obj = create(prototype);
    defineMetadata('key', 'value', prototype, void 8);
    assert.deepEqual(getOwnMetadataKeys(obj, void 8), []);
    obj = {};
    defineMetadata('key0', 'value', obj, void 8);
    defineMetadata('key1', 'value', obj, void 8);
    assert.deepEqual(getOwnMetadataKeys(obj, void 8), ['key0', 'key1']);
    obj = {};
    defineMetadata('key0', 'value', obj, void 8);
    defineMetadata('key1', 'value', obj, void 8);
    defineMetadata('key0', 'value', obj, void 8);
    assert.deepEqual(getOwnMetadataKeys(obj, void 8), ['key0', 'key1']);
    prototype = {};
    defineMetadata('key2', 'value', prototype, void 8);
    obj = create(prototype);
    defineMetadata('key0', 'value', obj, void 8);
    defineMetadata('key1', 'value', obj, void 8);
    assert.deepEqual(getOwnMetadataKeys(obj, void 8), ['key0', 'key1']);
    obj = {};
    assert.deepEqual(getOwnMetadataKeys({}, 'name'), []);
    obj = {};
    defineMetadata('key', 'value', obj, 'name');
    assert.deepEqual(getOwnMetadataKeys(obj, 'name'), ['key']);
    prototype = {};
    obj = create(prototype);
    defineMetadata('key', 'value', prototype, 'name');
    assert.deepEqual(getOwnMetadataKeys(obj, 'name'), []);
    obj = {};
    defineMetadata('key0', 'value', obj, 'name');
    defineMetadata('key1', 'value', obj, 'name');
    defineMetadata('key0', 'value', obj, 'name');
    assert.deepEqual(getOwnMetadataKeys(obj, 'name'), ['key0', 'key1']);
    prototype = {};
    defineMetadata('key2', 'value', prototype, 'name');
    obj = create(prototype);
    defineMetadata('key0', 'value', obj, 'name');
    defineMetadata('key1', 'value', obj, 'name');
    assert.deepEqual(getOwnMetadataKeys(obj, 'name'), ['key0', 'key1']);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Reflect.hasMetadata', function(assert){
    var ref$, defineMetadata, hasMetadata, create, obj, prototype;
    ref$ = core.Reflect, defineMetadata = ref$.defineMetadata, hasMetadata = ref$.hasMetadata;
    create = core.Object.create;
    assert.isFunction(hasMetadata);
    assert.arity(hasMetadata, 2);
    assert.throws(function(){
      hasMetadata('key', void 8, void 8);
    }, TypeError);
    assert.same(hasMetadata('key', {}, void 8), false);
    obj = {};
    defineMetadata('key', 'value', obj, void 8);
    assert.same(hasMetadata('key', obj, void 8), true);
    prototype = {};
    obj = create(prototype);
    defineMetadata('key', 'value', prototype, void 8);
    assert.same(hasMetadata('key', obj, void 8), true);
    assert.same(hasMetadata('key', {}, 'name'), false);
    obj = {};
    defineMetadata('key', 'value', obj, 'name');
    assert.same(hasMetadata('key', obj, 'name'), true);
    prototype = {};
    obj = create(prototype);
    defineMetadata('key', 'value', prototype, 'name');
    assert.same(hasMetadata('key', obj, 'name'), true);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Reflect.hasOwnMetadata', function(assert){
    var ref$, defineMetadata, hasOwnMetadata, create, obj, prototype;
    ref$ = core.Reflect, defineMetadata = ref$.defineMetadata, hasOwnMetadata = ref$.hasOwnMetadata;
    create = core.Object.create;
    assert.isFunction(hasOwnMetadata);
    assert.arity(hasOwnMetadata, 2);
    assert.throws(function(){
      hasOwnMetadata('key', void 8, void 8);
    }, TypeError);
    assert.same(hasOwnMetadata('key', {}, void 8), false);
    obj = {};
    defineMetadata('key', 'value', obj, void 8);
    assert.same(hasOwnMetadata('key', obj, void 8), true);
    prototype = {};
    obj = create(prototype);
    defineMetadata('key', 'value', prototype, void 8);
    assert.same(hasOwnMetadata('key', obj, void 8), false);
    assert.same(hasOwnMetadata('key', {}, 'name'), false);
    obj = {};
    defineMetadata('key', 'value', obj, 'name');
    assert.same(hasOwnMetadata('key', obj, 'name'), true);
    prototype = {};
    obj = create(prototype);
    defineMetadata('key', 'value', prototype, 'name');
    assert.same(hasOwnMetadata('key', obj, 'name'), false);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Reflect.metadata', function(assert){
    var ref$, metadata, hasOwnMetadata, decorator, target;
    ref$ = core.Reflect, metadata = ref$.metadata, hasOwnMetadata = ref$.hasOwnMetadata;
    assert.isFunction(metadata);
    assert.arity(metadata, 2);
    assert.isFunction(metadata('key', 'value'));
    decorator = metadata('key', 'value');
    assert.throws(function(){
      decorator(void 8, 'name');
    }, TypeError);
    assert.throws(function(){
      decorator({}, void 8);
    }, TypeError);
    target = function(){};
    decorator(target);
    assert.same(hasOwnMetadata('key', target, void 8), true);
    target = {};
    decorator(target, 'name');
    assert.same(hasOwnMetadata('key', target, 'name'), true);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Set.from', function(assert){
    var Set, from, element, index, context, $context, arg, F;
    Set = core.Set;
    from = Set.from;
    assert.isFunction(from);
    assert.arity(from, 1);
    assert.ok(Set.from() instanceof Set);
    assert.deepEqual(core.Array.from(Set.from([])), []);
    assert.deepEqual(core.Array.from(Set.from([1])), [1]);
    assert.deepEqual(core.Array.from(Set.from([1, 2, 3, 2, 1])), [1, 2, 3]);
    assert.deepEqual(core.Array.from(Set.from(createIterable([1, 2, 3, 2, 1]))), [1, 2, 3]);
    element = void 8;
    index = void 8;
    context = void 8;
    Set.from([1], function($element, $index){
      element = $element;
      index = $index;
      context = this;
      return element;
    }, $context = {});
    assert.same(element, 1);
    assert.same(index, 0);
    assert.same(context, $context);
    assert.throws(function(){
      from(1);
    });
    arg = void 8;
    F = function(it){
      return arg = it;
    };
    from.call(F, createIterable([1, 2, 3]), function(it){
      return Math.pow(it, 2);
    });
    assert.deepEqual(arg, [1, 4, 9]);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Set.of', function(assert){
    var Set, $of, arg, F;
    Set = core.Set;
    $of = Set.of;
    assert.isFunction($of);
    assert.arity($of, 0);
    assert.ok(Set.of() instanceof Set);
    assert.deepEqual(core.Array.from(Set.of(1)), [1]);
    assert.deepEqual(core.Array.from(Set.of(1, 2, 3, 2, 1)), [1, 2, 3]);
    assert.throws(function(){
      $of(1);
    });
    arg = void 8;
    F = function(it){
      return arg = it;
    };
    $of.call(F, 1, 2, 3);
    assert.deepEqual(arg, [1, 2, 3]);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('String#at', function(assert){
    var at;
    at = core.String.at;
    assert.isFunction(at);
    assert.strictEqual(at('abc\uD834\uDF06def', -Infinity), '');
    assert.strictEqual(at('abc\uD834\uDF06def', -1), '');
    assert.strictEqual(at('abc\uD834\uDF06def', -0), 'a');
    assert.strictEqual(at('abc\uD834\uDF06def', +0), 'a');
    assert.strictEqual(at('abc\uD834\uDF06def', 1), 'b');
    assert.strictEqual(at('abc\uD834\uDF06def', 3), '\uD834\uDF06');
    assert.strictEqual(at('abc\uD834\uDF06def', 4), '\uDF06');
    assert.strictEqual(at('abc\uD834\uDF06def', 5), 'd');
    assert.strictEqual(at('abc\uD834\uDF06def', 42), '');
    assert.strictEqual(at('abc\uD834\uDF06def', Infinity), '');
    assert.strictEqual(at('abc\uD834\uDF06def', null), 'a');
    assert.strictEqual(at('abc\uD834\uDF06def', void 8), 'a');
    assert.strictEqual(at('abc\uD834\uDF06def'), 'a');
    assert.strictEqual(at('abc\uD834\uDF06def', false), 'a');
    assert.strictEqual(at('abc\uD834\uDF06def', NaN), 'a');
    assert.strictEqual(at('abc\uD834\uDF06def', ''), 'a');
    assert.strictEqual(at('abc\uD834\uDF06def', '_'), 'a');
    assert.strictEqual(at('abc\uD834\uDF06def', '1'), 'b');
    assert.strictEqual(at('abc\uD834\uDF06def', []), 'a');
    assert.strictEqual(at('abc\uD834\uDF06def', {}), 'a');
    assert.strictEqual(at('abc\uD834\uDF06def', -0.9), 'a');
    assert.strictEqual(at('abc\uD834\uDF06def', 1.9), 'b');
    assert.strictEqual(at('abc\uD834\uDF06def', 7.9), 'f');
    assert.strictEqual(at('abc\uD834\uDF06def', Math.pow(2, 32)), '');
    assert.strictEqual(at('\uD834\uDF06def', -Infinity), '');
    assert.strictEqual(at('\uD834\uDF06def', -1), '');
    assert.strictEqual(at('\uD834\uDF06def', -0), '\uD834\uDF06');
    assert.strictEqual(at('\uD834\uDF06def', 0), '\uD834\uDF06');
    assert.strictEqual(at('\uD834\uDF06def', 1), '\uDF06');
    assert.strictEqual(at('\uD834\uDF06def', 2), 'd');
    assert.strictEqual(at('\uD834\uDF06def', 3), 'e');
    assert.strictEqual(at('\uD834\uDF06def', 4), 'f');
    assert.strictEqual(at('\uD834\uDF06def', 42), '');
    assert.strictEqual(at('\uD834\uDF06def', Infinity), '');
    assert.strictEqual(at('\uD834\uDF06def', null), '\uD834\uDF06');
    assert.strictEqual(at('\uD834\uDF06def', void 8), '\uD834\uDF06');
    assert.strictEqual(at('\uD834\uDF06def'), '\uD834\uDF06');
    assert.strictEqual(at('\uD834\uDF06def', false), '\uD834\uDF06');
    assert.strictEqual(at('\uD834\uDF06def', NaN), '\uD834\uDF06');
    assert.strictEqual(at('\uD834\uDF06def', ''), '\uD834\uDF06');
    assert.strictEqual(at('\uD834\uDF06def', '_'), '\uD834\uDF06');
    assert.strictEqual(at('\uD834\uDF06def', '1'), '\uDF06');
    assert.strictEqual(at('\uD834abc', -Infinity), '');
    assert.strictEqual(at('\uD834abc', -1), '');
    assert.strictEqual(at('\uD834abc', -0), '\uD834');
    assert.strictEqual(at('\uD834abc', 0), '\uD834');
    assert.strictEqual(at('\uD834abc', 1), 'a');
    assert.strictEqual(at('\uD834abc', 42), '');
    assert.strictEqual(at('\uD834abc', Infinity), '');
    assert.strictEqual(at('\uD834abc', null), '\uD834');
    assert.strictEqual(at('\uD834abc', void 8), '\uD834');
    assert.strictEqual(at('\uD834abc'), '\uD834');
    assert.strictEqual(at('\uD834abc', false), '\uD834');
    assert.strictEqual(at('\uD834abc', NaN), '\uD834');
    assert.strictEqual(at('\uD834abc', ''), '\uD834');
    assert.strictEqual(at('\uD834abc', '_'), '\uD834');
    assert.strictEqual(at('\uD834abc', '1'), 'a');
    assert.strictEqual(at('\uDF06abc', -Infinity), '');
    assert.strictEqual(at('\uDF06abc', -1), '');
    assert.strictEqual(at('\uDF06abc', -0), '\uDF06');
    assert.strictEqual(at('\uDF06abc', 0), '\uDF06');
    assert.strictEqual(at('\uDF06abc', 1), 'a');
    assert.strictEqual(at('\uDF06abc', 42), '');
    assert.strictEqual(at('\uDF06abc', Infinity), '');
    assert.strictEqual(at('\uDF06abc', null), '\uDF06');
    assert.strictEqual(at('\uDF06abc', void 8), '\uDF06');
    assert.strictEqual(at('\uDF06abc'), '\uDF06');
    assert.strictEqual(at('\uDF06abc', false), '\uDF06');
    assert.strictEqual(at('\uDF06abc', NaN), '\uDF06');
    assert.strictEqual(at('\uDF06abc', ''), '\uDF06');
    assert.strictEqual(at('\uDF06abc', '_'), '\uDF06');
    assert.strictEqual(at('\uDF06abc', '1'), 'a');
    assert.strictEqual(at(42, 0), '4');
    assert.strictEqual(at(42, 1), '2');
    assert.strictEqual(at({
      toString: function(){
        return 'abc';
      }
    }, 2), 'c');
    if (STRICT) {
      assert.throws(function(){
        at(null, 0);
      }, TypeError);
      assert.throws(function(){
        at(void 8, 0);
      }, TypeError);
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('String#matchAll', function(assert){
    var matchAll, assign, i$, x$, ref$, len$, iter, y$, z$;
    matchAll = core.String.matchAll;
    assign = core.Object.assign;
    assert.isFunction(matchAll);
    for (i$ = 0, len$ = (ref$ = [
      'aabc', {
        toString: fn$
      }
    ]).length; i$ < len$; ++i$) {
      x$ = ref$[i$];
      iter = matchAll(x$, /[ac]/);
      assert.isIterator(iter);
      assert.isIterable(iter);
      assert.deepEqual(iter.next(), {
        value: assign(['a'], {
          input: 'aabc',
          index: 0
        }),
        done: false
      });
      assert.deepEqual(iter.next(), {
        value: assign(['a'], {
          input: 'aabc',
          index: 1
        }),
        done: false
      });
      assert.deepEqual(iter.next(), {
        value: assign(['c'], {
          input: 'aabc',
          index: 3
        }),
        done: false
      });
      assert.deepEqual(iter.next(), {
        value: null,
        done: true
      });
    }
    iter = matchAll('1111a2b3cccc', /(\d)(\D)/);
    assert.isIterator(iter);
    assert.isIterable(iter);
    assert.deepEqual(iter.next(), {
      value: assign(['1a', '1', 'a'], {
        input: '1111a2b3cccc',
        index: 3
      }),
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: assign(['2b', '2', 'b'], {
        input: '1111a2b3cccc',
        index: 5
      }),
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: assign(['3c', '3', 'c'], {
        input: '1111a2b3cccc',
        index: 7
      }),
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: null,
      done: true
    });
    for (i$ = 0, len$ = (ref$ = [null, void 8, 'qwe', NaN, 42, new Date(), {}, []]).length; i$ < len$; ++i$) {
      y$ = ref$[i$];
      assert.throws(fn1$, TypeError, "Throws on " + y$ + " as first arguments");
    }
    if (STRICT) {
      for (i$ = 0, len$ = (ref$ = [null, void 8]).length; i$ < len$; ++i$) {
        z$ = ref$[i$];
        assert.throws(fn2$, TypeError, "Throws on " + z$ + " as `this`");
      }
    }
    function fn$(){
      return 'aabc';
    }
    function fn1$(){
      matchAll('', y$);
    }
    function fn2$(){
      matchAll(z$, /./);
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('String#padEnd', function(assert){
    var padEnd;
    padEnd = core.String.padEnd;
    assert.isFunction(padEnd);
    assert.strictEqual(padEnd('abc', 5), 'abc  ');
    assert.strictEqual(padEnd('abc', 4, 'de'), 'abcd');
    assert.strictEqual(padEnd('abc'), 'abc');
    assert.strictEqual(padEnd('abc', 5, '_'), 'abc__');
    assert.strictEqual(padEnd('', 0), '');
    assert.strictEqual(padEnd('foo', 1), 'foo');
    assert.strictEqual(padEnd('foo', 5, ''), 'foo');
    if (STRICT) {
      assert.throws(function(){
        padEnd(null, 0);
      }, TypeError);
      assert.throws(function(){
        padEnd(void 8, 0);
      }, TypeError);
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('String#padStart', function(assert){
    var padStart;
    padStart = core.String.padStart;
    assert.isFunction(padStart);
    assert.strictEqual(padStart('abc', 5), '  abc');
    assert.strictEqual(padStart('abc', 4, 'de'), 'dabc');
    assert.strictEqual(padStart('abc'), 'abc');
    assert.strictEqual(padStart('abc', 5, '_'), '__abc');
    assert.strictEqual(padStart('', 0), '');
    assert.strictEqual(padStart('foo', 1), 'foo');
    assert.strictEqual(padStart('foo', 5, ''), 'foo');
    if (STRICT) {
      assert.throws(function(){
        padStart(null, 0);
      }, TypeError);
      assert.throws(function(){
        padStart(void 8, 0);
      }, TypeError);
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('String#trimLeft', function(assert){
    var trimLeft;
    trimLeft = core.String.trimLeft;
    assert.isFunction(trimLeft);
    assert.strictEqual(trimLeft(' \n  q w e \n  '), 'q w e \n  ', 'removes whitespaces at left side of string');
    assert.strictEqual(trimLeft('\x09\x0A\x0B\x0C\x0D\x20\xA0\u1680\u180E\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u3000\u2028\u2029\uFEFF'), '', 'removes all whitespaces');
    assert.strictEqual(trimLeft('\u200b\u0085'), '\u200b\u0085', "shouldn't remove this symbols");
    if (STRICT) {
      assert.throws(function(){
        trimLeft(null, 0);
      }, TypeError);
      assert.throws(function(){
        trimLeft(void 8, 0);
      }, TypeError);
    }
  });
  test('String#trimStart', function(assert){
    var trimStart;
    trimStart = core.String.trimStart;
    assert.isFunction(trimStart);
    assert.strictEqual(trimStart(' \n  q w e \n  '), 'q w e \n  ', 'removes whitespaces at left side of string');
    assert.strictEqual(trimStart('\x09\x0A\x0B\x0C\x0D\x20\xA0\u1680\u180E\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u3000\u2028\u2029\uFEFF'), '', 'removes all whitespaces');
    assert.strictEqual(trimStart('\u200b\u0085'), '\u200b\u0085', "shouldn't remove this symbols");
    if (STRICT) {
      assert.throws(function(){
        trimStart(null, 0);
      }, TypeError);
      assert.throws(function(){
        trimStart(void 8, 0);
      }, TypeError);
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('String#trimRight', function(assert){
    var trimRight;
    trimRight = core.String.trimRight;
    assert.isFunction(trimRight);
    assert.strictEqual(trimRight(' \n  q w e \n  '), ' \n  q w e', 'removes whitespaces at right side of string');
    assert.strictEqual(trimRight('\x09\x0A\x0B\x0C\x0D\x20\xA0\u1680\u180E\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u3000\u2028\u2029\uFEFF'), '', 'removes all whitespaces');
    assert.strictEqual(trimRight('\u200b\u0085'), '\u200b\u0085', "shouldn't remove this symbols");
    if (STRICT) {
      assert.throws(function(){
        trimRight(null, 0);
      }, TypeError);
      assert.throws(function(){
        trimRight(void 8, 0);
      }, TypeError);
    }
  });
  test('String#trimEnd', function(assert){
    var trimEnd;
    trimEnd = core.String.trimEnd;
    assert.isFunction(trimEnd);
    assert.strictEqual(trimEnd(' \n  q w e \n  '), ' \n  q w e', 'removes whitespaces at right side of string');
    assert.strictEqual(trimEnd('\x09\x0A\x0B\x0C\x0D\x20\xA0\u1680\u180E\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u3000\u2028\u2029\uFEFF'), '', 'removes all whitespaces');
    assert.strictEqual(trimEnd('\u200b\u0085'), '\u200b\u0085', "shouldn't remove this symbols");
    if (STRICT) {
      assert.throws(function(){
        trimEnd(null, 0);
      }, TypeError);
      assert.throws(function(){
        trimEnd(void 8, 0);
      }, TypeError);
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Symbol.asyncIterator', function(assert){
    var Symbol;
    Symbol = core.Symbol;
    assert.ok('asyncIterator' in Symbol, "Symbol.asyncIterator available");
    assert.ok(Object(Symbol.asyncIterator) instanceof Symbol, "Symbol.asyncIterator is symbol");
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Symbol.observable', function(assert){
    var Symbol;
    Symbol = core.Symbol;
    assert.ok('observable' in Symbol, "Symbol.observable available");
    assert.ok(Object(Symbol.observable) instanceof Symbol, "Symbol.observable is symbol");
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('System.global', function(assert){
    var global;
    global = core.System.global;
    assert.same(global, Object(global), 'is object');
    assert.same(global.Math, Math, 'contains globals');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('WeakMap.from', function(assert){
    var WeakMap, from, $1, element, index, context, $$element, $context, arg, F;
    WeakMap = core.WeakMap;
    from = WeakMap.from;
    assert.isFunction(from);
    assert.arity(from, 1);
    assert.ok(WeakMap.from() instanceof WeakMap);
    $1 = [];
    assert.same(WeakMap.from([[$1, 2]]).get($1), 2);
    assert.same(WeakMap.from(createIterable([[$1, 2]])).get($1), 2);
    element = void 8;
    index = void 8;
    context = void 8;
    WeakMap.from([$$element = [{}, 1]], function($element, $index){
      element = $element;
      index = $index;
      context = this;
      return element;
    }, $context = {});
    assert.same(element, $$element);
    assert.same(index, 0);
    assert.same(context, $context);
    assert.throws(function(){
      from([{}, 1]);
    });
    arg = void 8;
    F = function(it){
      return arg = it;
    };
    from.call(F, createIterable([1, 2, 3]), function(it){
      return Math.pow(it, 2);
    });
    assert.deepEqual(arg, [1, 4, 9]);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('WeakMap.of', function(assert){
    var WeakMap, $of, $1, arg, F;
    WeakMap = core.WeakMap;
    $of = WeakMap.of;
    assert.isFunction($of);
    assert.arity($of, 0);
    $1 = [];
    assert.ok(WeakMap.of() instanceof WeakMap);
    assert.same(WeakMap.of([$1, 2]).get($1), 2);
    assert.throws(function(){
      $of(1);
    });
    arg = void 8;
    F = function(it){
      return arg = it;
    };
    $of.call(F, 1, 2, 3);
    assert.deepEqual(arg, [1, 2, 3]);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('WeakSet.from', function(assert){
    var WeakSet, from, $1, element, index, context, $$element, $context, arg, F;
    WeakSet = core.WeakSet;
    from = WeakSet.from;
    assert.isFunction(from);
    assert.arity(from, 1);
    assert.ok(WeakSet.from() instanceof WeakSet);
    $1 = [];
    assert.ok(WeakSet.from([$1]).has($1));
    assert.ok(WeakSet.from(createIterable([$1])).has($1));
    element = void 8;
    index = void 8;
    context = void 8;
    WeakSet.from([$$element = {}], function($element, $index){
      element = $element;
      index = $index;
      context = this;
      return element;
    }, $context = {});
    assert.same(element, $$element);
    assert.same(index, 0);
    assert.same(context, $context);
    assert.throws(function(){
      from({});
    });
    arg = void 8;
    F = function(it){
      return arg = it;
    };
    from.call(F, createIterable([1, 2, 3]), function(it){
      return Math.pow(it, 2);
    });
    assert.deepEqual(arg, [1, 4, 9]);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('WeakSet.of', function(assert){
    var WeakSet, $of, $1, arg, F;
    WeakSet = core.WeakSet;
    $of = WeakSet.of;
    assert.isFunction($of);
    assert.arity($of, 0);
    $1 = [];
    assert.ok(WeakSet.of() instanceof WeakSet);
    assert.ok(WeakSet.of($1).has($1));
    assert.throws(function(){
      $of(1);
    });
    arg = void 8;
    F = function(it){
      return arg = it;
    };
    $of.call(F, 1, 2, 3);
    assert.deepEqual(arg, [1, 2, 3]);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('Web');
  test('Iterable DOM collections', function(assert){
    var absent, i$, x$, ref$, len$, Collection;
    absent = true;
    for (i$ = 0, len$ = (ref$ = ['CSSRuleList', 'CSSStyleDeclaration', 'CSSValueList', 'ClientRectList', 'DOMRectList', 'DOMStringList', 'DOMTokenList', 'DataTransferItemList', 'FileList', 'HTMLAllCollection', 'HTMLCollection', 'HTMLFormElement', 'HTMLSelectElement', 'MediaList', 'MimeTypeArray', 'NamedNodeMap', 'NodeList', 'PaintRequestList', 'Plugin', 'PluginArray', 'SVGLengthList', 'SVGNumberList', 'SVGPathSegList', 'SVGPointList', 'SVGStringList', 'SVGTransformList', 'SourceBufferList', 'StyleSheetList', 'TextTrackCueList', 'TextTrackList', 'TouchList']).length; i$ < len$; ++i$) {
      x$ = ref$[i$];
      Collection = global[x$];
      if (Collection) {
        assert.same(Collection.prototype[core.Symbol.toStringTag], x$, x$ + "::@@toStringTag is '" + x$ + "'");
        assert.isFunction(core.getIteratorMethod(Collection.prototype), x$ + "::@@iterator is function");
        absent = false;
      }
    }
    if ((typeof NodeList != 'undefined' && NodeList !== null) && ((typeof document != 'undefined' && document !== null) && document.querySelectorAll) && document.querySelectorAll('div') instanceof NodeList) {
      assert.isFunction(core.getIteratorMethod(document.querySelectorAll('div')), 'works with document.querySelectorAll');
    }
    if (absent) {
      assert.ok(true, 'DOM collections are absent');
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, timeLimitedPromise, setImmediate, clearImmediate, Promise;
  module = QUnit.module, test = QUnit.test;
  module('Web');
  timeLimitedPromise = function(time, fn){
    return Promise.race([
      new Promise(fn), new Promise(function(res, rej){
        return setTimeout(rej, time);
      })
    ]);
  };
  setImmediate = core.setImmediate, clearImmediate = core.clearImmediate, Promise = core.Promise;
  test('setImmediate / clearImmediate', function(assert){
    var def;
    assert.expect(6);
    assert.isFunction(setImmediate, 'setImmediate is function');
    assert.isFunction(clearImmediate, 'clearImmediate is function');
    timeLimitedPromise(1e3, function(res){
      setImmediate(function(){
        def = 'a';
        res();
      });
    }).then(function(){
      assert.ok(true, 'setImmediate works');
    })['catch'](function(){
      assert.ok(false, 'setImmediate works');
    }).then(assert.async());
    assert.strictEqual(def, void 8, 'setImmediate is async');
    timeLimitedPromise(1e3, function(res){
      setImmediate(function(a, b){
        res(a + b);
      }, 'a', 'b');
    }).then(function(it){
      assert.strictEqual(it, 'ab', 'setImmediate works with additional args');
    })['catch'](function(){
      assert.ok(false, 'setImmediate works with additional args');
    }).then(assert.async());
    timeLimitedPromise(50, function(res){
      clearImmediate(setImmediate(res));
    }).then(function(){
      assert.ok(false, 'clearImmediate works');
    })['catch'](function(){
      assert.ok(true, 'clearImmediate works');
    }).then(assert.async());
  });
  (function(it){
    if (typeof window != 'undefined' && window !== null) {
      window.onload = it;
    } else {
      it();
    }
  })(function(){
    setTimeout(function(){
      var x, now, inc;
      x = 0;
      now = +new Date;
      (inc = function(){
        setImmediate(function(){
          x = x + 1;
          if (+new Date() - now < 5e3) {
            inc();
          } else {
            if (typeof console != 'undefined' && console !== null) {
              console.log("setImmediate: " + x / 5 + " per second");
            }
          }
        });
      })();
    }, 5e3);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, setTimeout, setInterval, Promise, timeLimitedPromise;
  module = QUnit.module, test = QUnit.test;
  module('Web');
  setTimeout = core.setTimeout, setInterval = core.setInterval, Promise = core.Promise;
  timeLimitedPromise = function(time, fn){
    return Promise.race([
      new Promise(fn), new Promise(function(res, rej){
        return setTimeout(rej, time);
      })
    ]);
  };
  test('setTimeout / clearTimeout', function(assert){
    assert.expect(2);
    timeLimitedPromise(1e3, function(res){
      return setTimeout(function(a, b){
        return res(a + b);
      }, 10, 'a', 'b');
    }).then(function(it){
      return assert.strictEqual(it, 'ab', 'setTimeout works with additional args');
    })['catch'](function(){
      return assert.ok(false, 'setTimeout works with additional args');
    }).then(assert.async());
    timeLimitedPromise(50, function(res){
      return clearTimeout(setTimeout(res, 10));
    }).then(function(){
      return assert.ok(false, 'clearImmediate works with wraped setTimeout');
    })['catch'](function(){
      return assert.ok(true, 'clearImmediate works with wraped setTimeout');
    }).then(assert.async());
  });
  test('setInterval / clearInterval', function(assert){
    var i;
    assert.expect(1);
    i = 0;
    timeLimitedPromise(1e4, function(res, rej){
      var interval;
      return interval = setInterval(function(a, b){
        if (a + b !== 'ab' || i > 2) {
          rej({
            a: a,
            b: b,
            i: i
          });
        }
        if (i++ === 2) {
          clearInterval(interval);
          return setTimeout(res, 30);
        }
      }, 5, 'a', 'b');
    }).then(function(){
      return assert.ok(true, 'setInterval & clearInterval works with additional args');
    })['catch'](function(arg$){
      var ref$, a, b, i;
      ref$ = arg$ != null
        ? arg$
        : {}, a = ref$.a, b = ref$.b, i = ref$.i;
      return assert.ok(false, "setInterval & clearInterval works with additional args: " + a + ", " + b + ", times: " + i);
    }).then(assert.async());
  });
}).call(this);
