## API Report File for "@microsoft/fast-colors"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

// @public
export function blend(mode: ColorBlendMode, bottom: ColorRGBA64, top: ColorRGBA64): ColorRGBA64;

// @public
export function blendBurn(bottom: ColorRGBA64, top: ColorRGBA64): ColorRGBA64;

// @public (undocumented)
export function blendBurnChannel(bottom: number, top: number): number;

// @public
export function blendColor(bottom: ColorRGBA64, top: ColorRGBA64): ColorRGBA64;

// @public
export function blendDarken(bottom: ColorRGBA64, top: ColorRGBA64): ColorRGBA64;

// @public (undocumented)
export function blendDarkenChannel(bottom: number, top: number): number;

// @public
export function blendDodge(bottom: ColorRGBA64, top: ColorRGBA64): ColorRGBA64;

// @public (undocumented)
export function blendDodgeChannel(bottom: number, top: number): number;

// @public
export function blendLighten(bottom: ColorRGBA64, top: ColorRGBA64): ColorRGBA64;

// @public (undocumented)
export function blendLightenChannel(bottom: number, top: number): number;

// @public
export function blendMultiply(bottom: ColorRGBA64, top: ColorRGBA64): ColorRGBA64;

// @public (undocumented)
export function blendMultiplyChannel(bottom: number, top: number): number;

// @public
export function blendOverlay(bottom: ColorRGBA64, top: ColorRGBA64): ColorRGBA64;

// @public (undocumented)
export function blendOverlayChannel(bottom: number, top: number): number;

// @public
export function blendScreen(bottom: ColorRGBA64, top: ColorRGBA64): ColorRGBA64;

// @public (undocumented)
export function blendScreenChannel(bottom: number, top: number): number;

// @public
export function calculateOverlayColor(rgbMatch: ColorRGBA64, rgbBackground: ColorRGBA64, rgbOverlay?: ColorRGBA64): ColorRGBA64;

// @public
export function centeredRescale(input: ColorRGBA64[], config?: CenteredRescaleConfig): ColorRGBA64[];

// @public (undocumented)
export interface CenteredRescaleConfig {
    // (undocumented)
    scaleColorDark: ColorRGBA64;
    // (undocumented)
    scaleColorLight: ColorRGBA64;
    // (undocumented)
    spacing: number;
    // (undocumented)
    targetSize: number;
}

// @public
export function clamp(i: number, min: number, max: number): number;

// @public
export enum ColorBlendMode {
    // (undocumented)
    Burn = 0,
    // (undocumented)
    Color = 1,
    // (undocumented)
    Darken = 2,
    // (undocumented)
    Dodge = 3,
    // (undocumented)
    Lighten = 4,
    // (undocumented)
    Multiply = 5,
    // (undocumented)
    Overlay = 6,
    // (undocumented)
    Screen = 7
}

// @public
export class ColorHSL {
    constructor(hue: number, sat: number, lum: number);
    equalValue(rhs: ColorHSL): boolean;
    static fromObject(data: {
        h: number;
        s: number;
        l: number;
    }): ColorHSL | null;
    // (undocumented)
    readonly h: number;
    // (undocumented)
    readonly l: number;
    roundToPrecision(precision: number): ColorHSL;
    // (undocumented)
    readonly s: number;
    toObject(): {
        h: number;
        s: number;
        l: number;
    };
}

// @public
export class ColorHSV {
    constructor(hue: number, sat: number, val: number);
    equalValue(rhs: ColorHSV): boolean;
    static fromObject(data: {
        h: number;
        s: number;
        v: number;
    }): ColorHSV | null;
    // (undocumented)
    readonly h: number;
    roundToPrecision(precision: number): ColorHSV;
    // (undocumented)
    readonly s: number;
    toObject(): {
        h: number;
        s: number;
        v: number;
    };
    // (undocumented)
    readonly v: number;
}

// @public
export enum ColorInterpolationSpace {
    // (undocumented)
    HSL = 1,
    // (undocumented)
    HSV = 2,
    // (undocumented)
    LAB = 4,
    // (undocumented)
    LCH = 5,
    // (undocumented)
    RGB = 0,
    // (undocumented)
    XYZ = 3
}

// @public
export class ColorLAB {
    constructor(l: number, a: number, b: number);
    // (undocumented)
    readonly a: number;
    // (undocumented)
    readonly b: number;
    // (undocumented)
    static readonly epsilon: number;
    equalValue(rhs: ColorLAB): boolean;
    static fromObject(data: {
        l: number;
        a: number;
        b: number;
    }): ColorLAB | null;
    // (undocumented)
    static readonly kappa: number;
    // (undocumented)
    readonly l: number;
    roundToPrecision(precision: number): ColorLAB;
    toObject(): {
        l: number;
        a: number;
        b: number;
    };
}

// @public
export class ColorLCH {
    constructor(l: number, c: number, h: number);
    // (undocumented)
    readonly c: number;
    equalValue(rhs: ColorLCH): boolean;
    static fromObject(data: {
        l: number;
        c: number;
        h: number;
    }): ColorLCH | null;
    // (undocumented)
    readonly h: number;
    // (undocumented)
    readonly l: number;
    roundToPrecision(precision: number): ColorLCH;
    toObject(): {
        l: number;
        c: number;
        h: number;
    };
}

// @public
export class ColorPalette {
    constructor(config: ColorPaletteConfig);
    // (undocumented)
    static readonly defaultPaletteConfig: ColorPaletteConfig;
    // (undocumented)
    generatePaletteColorScale(): ColorScale;
    // (undocumented)
    static readonly greyscalePaletteConfig: ColorPaletteConfig;
    // (undocumented)
    readonly palette: ColorRGBA64[];
    // (undocumented)
    updatePaletteGenerationValues(newConfig: ColorPaletteConfig): boolean;
}

// @public (undocumented)
export interface ColorPaletteConfig {
    // (undocumented)
    baseColor?: ColorRGBA64;
    // (undocumented)
    baseScalePosition?: number;
    // (undocumented)
    clipDark?: number;
    // (undocumented)
    clipLight?: number;
    // (undocumented)
    interpolationMode?: ColorInterpolationSpace;
    // (undocumented)
    multiplyDark?: number;
    // (undocumented)
    multiplyLight?: number;
    // (undocumented)
    overlayDark?: number;
    // (undocumented)
    overlayLight?: number;
    // (undocumented)
    saturationAdjustmentCutoff?: number;
    // (undocumented)
    saturationDark?: number;
    // (undocumented)
    saturationLight?: number;
    // (undocumented)
    scaleColorDark?: ColorRGBA64;
    // (undocumented)
    scaleColorLight?: ColorRGBA64;
    // (undocumented)
    steps?: number;
}

// @public
export class ColorRGBA64 {
    constructor(red: number, green: number, blue: number, alpha?: number);
    readonly a: number;
    readonly b: number;
    clamp(): ColorRGBA64;
    equalValue(rhs: ColorRGBA64): boolean;
    static fromObject(data: ColorRGBA64Config): ColorRGBA64 | null;
    readonly g: number;
    readonly r: number;
    roundToPrecision(precision: number): ColorRGBA64;
    toObject(): Required<ColorRGBA64Config>;
    toStringHexARGB(): string;
    toStringHexRGB(): string;
    toStringHexRGBA(): string;
    toStringWebRGB(): string;
    toStringWebRGBA(): string;
}

// @public
export interface ColorRGBA64Config {
    // (undocumented)
    a?: number;
    // (undocumented)
    b: number;
    // (undocumented)
    g: number;
    // (undocumented)
    r: number;
}

// @public
export class ColorScale {
    constructor(stops: ColorScaleStop[]);
    // (undocumented)
    clone(): ColorScale;
    // (undocumented)
    static createBalancedColorScale(colors: ColorRGBA64[]): ColorScale;
    // (undocumented)
    findNextColor(position: number, contrast: number, searchDown?: boolean, interpolationMode?: ColorInterpolationSpace, contrastErrorMargin?: number, maxSearchIterations?: number): number;
    // (undocumented)
    getColor(position: number, interpolationMode?: ColorInterpolationSpace): ColorRGBA64;
    // (undocumented)
    trim(lowerBound: number, upperBound: number, interpolationMode?: ColorInterpolationSpace): ColorScale;
}

// @public (undocumented)
export interface ColorScaleStop {
    // (undocumented)
    color: ColorRGBA64;
    // (undocumented)
    position: number;
}

// @public
export class ColorXYZ {
    constructor(x: number, y: number, z: number);
    equalValue(rhs: ColorXYZ): boolean;
    static fromObject(data: {
        x: number;
        y: number;
        z: number;
    }): ColorXYZ | null;
    roundToPrecision(precision: number): ColorXYZ;
    toObject(): {
        x: number;
        y: number;
        z: number;
    };
    static readonly whitePoint: ColorXYZ;
    // (undocumented)
    readonly x: number;
    // (undocumented)
    readonly y: number;
    // (undocumented)
    readonly z: number;
}

// @public
export class ComponentStateColorPalette {
    constructor(config?: ComponentStateColorPaletteConfig);
    // (undocumented)
    static readonly defaultPaletteConfig: ComponentStateColorPaletteConfig;
    // (undocumented)
    palette: ColorRGBA64[];
    }

// @public
export interface ComponentStateColorPaletteConfig {
    baseColor?: ColorRGBA64;
    steps?: number;
}

// @public
export function computeAlphaBlend(bottom: ColorRGBA64, top: ColorRGBA64): ColorRGBA64;

// @public
export function contrastRatio(a: ColorRGBA64, b: ColorRGBA64): number;

// @public
export function darkenViaLAB(input: ColorRGBA64, amount: number, darkenConstant?: number): ColorRGBA64;

// @public (undocumented)
export const defaultCenteredRescaleConfig: CenteredRescaleConfig;

// @public
export const defaultPaletteExtractionConfig: PaletteExtractionConfig;

// @public
export const defaultQuantizeConfig: QuantizeConfig;

// @public
export function degreesToRadians(i: number): number;

// @public
export function denormalize(i: number, min: number, max: number): number;

// @public
export function desaturateViaLCH(input: ColorRGBA64, saturation: number, saturationConstant?: number): ColorRGBA64;

// @public
export function extractPalette(colors: QuantizedColor[], config?: PaletteExtractionConfig): PaletteEntry[];

// @public
export function generateOffCenterPalette(input: ColorRGBA64, outputSteps: number, greyscaleConfig?: ColorPaletteConfig, colorConfig?: ColorPaletteConfig): ColorPalette;

// @public
export function generateScaledPalettes(input: ColorRGBA64, shortPaletteLength?: number, config?: CenteredRescaleConfig): {
    short: ColorRGBA64[];
    long: ColorRGBA64[];
};

// @public
export function getHexStringForByte(i: number): string;

// @public
export class Histogram {
    constructor(source: PixelBlob, significantBits?: number, pixelSkipping?: number, isHistogramPixelValid?: ((pixel: number[]) => boolean) | null);
    // (undocumented)
    readonly data: Uint32Array;
    // (undocumented)
    getHistogramIndex: (r: number, g: number, b: number) => number;
    // (undocumented)
    getHistogramValue: (r: number, g: number, b: number) => number;
    // (undocumented)
    readonly maxBlue: number;
    // (undocumented)
    readonly maxGreen: number;
    // (undocumented)
    readonly maxRed: number;
    // (undocumented)
    readonly minBlue: number;
    // (undocumented)
    readonly minGreen: number;
    // (undocumented)
    readonly minRed: number;
    // (undocumented)
    setHistogramValue: (value: number, r: number, g: number, b: number) => void;
    // (undocumented)
    readonly significantBits: number;
    // (undocumented)
    readonly total: number;
}

// @public
export function hslToRGB(hsl: ColorHSL, alpha?: number): ColorRGBA64;

// @public
export function hsvToRGB(hsv: ColorHSV, alpha?: number): ColorRGBA64;

// @public
export class ImageDataPixelBlob implements PixelBlob {
    constructor(image: ImageData);
    // (undocumented)
    getPixel: (x: number, y: number) => ColorRGBA64;
    // (undocumented)
    getPixelRGBA: (x: number, y: number) => number[];
    // (undocumented)
    readonly height: number;
    // (undocumented)
    readonly totalPixels: number;
    // (undocumented)
    readonly width: number;
}

// @public
export function insertIntoSortedList(list: PixelBox[], newItem: PixelBox, sortPriority: (box: PixelBox) => number): void;

// @public
export function interpolateByColorSpace(position: number, space: ColorInterpolationSpace, left: ColorRGBA64, right: ColorRGBA64): ColorRGBA64;

// @public
export function interpolateHSL(position: number, left: ColorHSL, right: ColorHSL): ColorHSL;

// @public
export function interpolateHSV(position: number, left: ColorHSV, right: ColorHSV): ColorHSV;

// @public
export function interpolateLAB(position: number, left: ColorLAB, right: ColorLAB): ColorLAB;

// @public
export function interpolateLCH(position: number, left: ColorLCH, right: ColorLCH): ColorLCH;

// @public
export function interpolateRGB(position: number, left: ColorRGBA64, right: ColorRGBA64): ColorRGBA64;

// @public
export function interpolateXYZ(position: number, left: ColorXYZ, right: ColorXYZ): ColorXYZ;

// @public
export function isColorNamed(raw: string | NamedColors): raw is NamedColors;

// @public
export function isColorStringHexARGB(raw: string): boolean;

// @public
export function isColorStringHexRGB(raw: string): boolean;

// @public
export function isColorStringHexRGBA(raw: string): boolean;

// @public
export function isColorStringWebRGB(raw: string): boolean;

// @public
export function isColorStringWebRGBA(raw: string): boolean;

// @public
export function labToLCH(lab: ColorLAB): ColorLCH;

// @public
export function labToRGB(lab: ColorLAB, alpha?: number): ColorRGBA64;

// @public
export function labToXYZ(lab: ColorLAB): ColorXYZ;

// @public
export function lchToLAB(lch: ColorLCH): ColorLAB;

// @public
export function lchToRGB(lch: ColorLCH, alpha?: number): ColorRGBA64;

// @public
export function lerp(i: number, min: number, max: number): number;

// @public
export function lerpAnglesInDegrees(i: number, min: number, max: number): number;

// @public
export function lerpAnglesInRadians(i: number, min: number, max: number): number;

// @public
export function lightenViaLAB(input: ColorRGBA64, amount: number, darkenConstant?: number): ColorRGBA64;

// @public
export function loadImageData(source: string): Promise<ImageData>;

// @public
export function matchLightnessIndex(input: ColorRGBA64, reference: ColorRGBA64[]): number;

// @public
export type NamedColors = "aliceblue" | "antiquewhite" | "aqua" | "aquamarine" | "azure" | "beige" | "bisque" | "black" | "blanchedalmond" | "blue" | "blueviolet" | "brown" | "burlywood" | "cadetblue" | "chartreuse" | "chocolate" | "coral" | "cornflowerblue" | "cornsilk" | "crimson" | "cyan" | "darkblue" | "darkcyan" | "darkgoldenrod" | "darkgray" | "darkgreen" | "darkgrey" | "darkkhaki" | "darkmagenta" | "darkolivegreen" | "darkorange" | "darkorchid" | "darkred" | "darksalmon" | "darkseagreen" | "darkslateblue" | "darkslategray" | "darkslategrey" | "darkturquoise" | "darkviolet" | "deeppink" | "deepskyblue" | "dimgray" | "dimgrey" | "dodgerblue" | "firebrick" | "floralwhite" | "forestgreen" | "fuchsia" | "gainsboro" | "ghostwhite" | "gold" | "goldenrod" | "gray" | "green" | "greenyellow" | "grey" | "honeydew" | "hotpink" | "indianred" | "indigo" | "ivory" | "khaki" | "lavender" | "lavenderblush" | "lawngreen" | "lemonchiffon" | "lightblue" | "lightcoral" | "lightcyan" | "lightgoldenrodyellow" | "lightgray" | "lightgreen" | "lightgrey" | "lightpink" | "lightsalmon" | "lightseagreen" | "lightskyblue" | "lightslategray" | "lightslategrey" | "lightsteelblue" | "lightyellow" | "lime" | "limegreen" | "linen" | "magenta" | "maroon" | "mediumaquamarine" | "mediumblue" | "mediumorchid" | "mediumpurple" | "mediumseagreen" | "mediumslateblue" | "mediumspringgreen" | "mediumturquoise" | "mediumvioletred" | "midnightblue" | "mintcream" | "mistyrose" | "moccasin" | "navajowhite" | "navy" | "oldlace" | "olive" | "olivedrab" | "orange" | "orangered" | "orchid" | "palegoldenrod" | "palegreen" | "paleturquoise" | "palevioletred" | "papayawhip" | "peachpuff" | "peru" | "pink" | "plum" | "powderblue" | "purple" | "red" | "rosybrown" | "royalblue" | "saddlebrown" | "salmon" | "sandybrown" | "seagreen" | "seashell" | "sienna" | "silver" | "skyblue" | "slateblue" | "slategray" | "slategrey" | "snow" | "springgreen" | "steelblue" | "tan" | "teal" | "thistle" | "tomato" | "transparent" | "turquoise" | "violet" | "wheat" | "white" | "whitesmoke" | "yellow" | "yellowgreen";

// @public
export function normalize(i: number, min: number, max: number): number;

// @public (undocumented)
export interface PaletteEntry {
    // (undocumented)
    color?: QuantizedColor;
    // (undocumented)
    constraint: PaletteEntryConstraint;
    // (undocumented)
    found: boolean;
}

// @public (undocumented)
export interface PaletteEntryConstraint {
    // (undocumented)
    id: string;
    // (undocumented)
    maxLuminosity: number;
    // (undocumented)
    maxSaturation: number;
    // (undocumented)
    minLuminosity: number;
    // (undocumented)
    minSaturation: number;
    // (undocumented)
    targetLuminosity: number;
    // (undocumented)
    targetSaturation: number;
}

// @public
export interface PaletteExtractionConfig {
    // (undocumented)
    constraints: PaletteEntryConstraint[];
    // (undocumented)
    luminosityWeight: number;
    // (undocumented)
    populationWeight: number;
    // (undocumented)
    saturationWeight: number;
    // (undocumented)
    volumeWeight: number;
}

// @public
export function parseColor(raw: string): ColorRGBA64 | null;

// @public
export function parseColorHexARGB(raw: string): ColorRGBA64 | null;

// @public
export function parseColorHexRGB(raw: string): ColorRGBA64 | null;

// @public
export function parseColorHexRGBA(raw: string): ColorRGBA64 | null;

// Warning: (ae-forgotten-export) The symbol "namedColorsConfigs" needs to be exported by the entry point index.d.ts
//
// @public
export function parseColorNamed(raw: keyof typeof namedColorsConfigs): ColorRGBA64 | null;

// @public
export function parseColorWebRGB(raw: string): ColorRGBA64 | null;

// @public
export function parseColorWebRGBA(raw: string): ColorRGBA64 | null;

// @public
export interface PixelBlob {
    // (undocumented)
    getPixel(x: number, y: number): ColorRGBA64;
    getPixelRGBA(x: number, y: number): number[];
    // (undocumented)
    height: number;
    // (undocumented)
    totalPixels: number;
    // (undocumented)
    width: number;
}

// @public
export class PixelBox {
    constructor(globalHistogram: Histogram, minRed: number, maxRed: number, minGreen: number, maxGreen: number, minBlue: number, maxBlue: number);
    // (undocumented)
    readonly averageColor: ColorRGBA64;
    // (undocumented)
    readonly colorVolume: number;
    // (undocumented)
    readonly globalHistogram: Histogram;
    // (undocumented)
    readonly maxBlue: number;
    // (undocumented)
    readonly maxGreen: number;
    // (undocumented)
    readonly maxRed: number;
    // (undocumented)
    readonly minBlue: number;
    // (undocumented)
    readonly minGreen: number;
    // (undocumented)
    readonly minRed: number;
    modifiedMedianCut: () => [PixelBox | null, PixelBox | null];
    // (undocumented)
    readonly pixelCount: number;
    // (undocumented)
    readonly rangeBlue: number;
    // (undocumented)
    readonly rangeGreen: number;
    // (undocumented)
    readonly rangeRed: number;
}

// @public
export function quantize(source: PixelBlob, config?: QuantizeConfig): QuantizedColor[];

// @public
export interface QuantizeConfig {
    fractionByPopulation: number;
    isBoxValid: ((box: PixelBox) => boolean) | null;
    isHistogramPixelValid: ((pixel: number[]) => boolean) | null;
    maxIterations: number;
    pixelSkipping: number;
    significantBits: number;
    targetPaletteSize: number;
}

// @public
export interface QuantizedColor {
    // (undocumented)
    color: ColorRGBA64;
    // (undocumented)
    colorVolume: number;
    // (undocumented)
    pixelCount: number;
}

// @public
export function quantizeHistogram(histogram: Histogram, config?: QuantizeConfig): QuantizedColor[];

// @public
export function radiansToDegrees(i: number): number;

// @public
export function rescale(input: ColorRGBA64[], targetSize: number, preserveInputColors: boolean): ColorRGBA64[];

// @public
export function rgbToHSL(rgb: ColorRGBA64): ColorHSL;

// @public
export function rgbToHSV(rgb: ColorRGBA64): ColorHSV;

// @public
export function rgbToLAB(rgb: ColorRGBA64): ColorLAB;

// @public
export function rgbToLCH(rgb: ColorRGBA64): ColorLCH;

// @public
export function rgbToLinearLuminance(rgb: ColorRGBA64): number;

// @public
export function rgbToRelativeLuminance(rgb: ColorRGBA64): number;

// @public
export function rgbToTemperature(rgb: ColorRGBA64): number;

// @public
export function rgbToXYZ(rgb: ColorRGBA64): ColorXYZ;

// @public
export function roundToPrecisionSmall(i: number, precision: number): number;

// @public
export function saturateViaLCH(input: ColorRGBA64, saturation: number, saturationConstant?: number): ColorRGBA64;

// @public
export function temperatureToRGB(tempKelvin: number, alpha?: number): ColorRGBA64;

// @public
export function xyzToLAB(xyz: ColorXYZ): ColorLAB;

// @public
export function xyzToRGB(xyz: ColorXYZ, alpha?: number): ColorRGBA64;


// (No @packageDocumentation comment for this package)

```
