# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 394-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53375);
 script_cve_id("CVE-2003-0543", "CVE-2003-0544", "CVE-2003-0545");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Debian Security Advisory DSA 394-1 (openssl095)";
 script_name(name);

 desc = "The remote host is missing an update to openssl095
announced via advisory DSA 394-1.

Steve Henson of the OpenSSL core team identified and prepared fixes
for a number of vulnerabilities in the OpenSSL ASN1 code that were
discovered after running a test suite by British National
Infrastructure Security Coordination Centre (NISCC).

A bug in OpenSSLs SSL/TLS protocol was also identified which causes
OpenSSL to parse a client certificate from an SSL/TLS client when it
should reject it as a protocol error.

The Common Vulnerabilities and Exposures project identifies the
following problems:

CVE-2003-0543:

Integer overflow in OpenSSL that allows remote attackers to cause a
denial of service (crash) via an SSL client certificate with
certain ASN.1 tag values.

CVE-2003-0544:

OpenSSL does not properly track the number of characters in certain
ASN.1 inputs, which allows remote attackers to cause a denial of
service (crash) via an SSL client certificate that causes OpenSSL
to read past the end of a buffer when the long form is used.

CVE-2003-0545:

Double-free vulnerability allows remote attackers to cause a denial
of service (crash) and possibly execute arbitrary code via an SSL
client certificate with a certain invalid ASN.1 encoding.  This bug
was only present in OpenSSL 0.9.7 and is listed here only for
reference.

For the stable distribution (woody) this problem has been
fixed in openssl095 version 0.9.5a-6.woody.3.

This package is not present in the unstable (sid) or testing (sarge)
distribution.

We recommend that you upgrade your libssl095a packages and restart


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20394-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 394-1 (openssl095)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libssl095a", ver:"0.9.5a-6.woody.3", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
