#
#VID 018a84d0-2548-11df-b4a3-00e0815b8da8
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID 018a84d0-2548-11df-b4a3-00e0815b8da8
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2010 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(67052);
 script_cve_id("CVE-2010-0426");
 script_bugtraq_id(38362);
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"6.9");
 script_tag(name:"risk_factor", value:"High");
 script_name("FreeBSD Ports: sudo");

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: sudo

CVE-2010-0426
sudo 1.6.x before 1.6.9p21 and 1.7.x before 1.7.2p4, when a
pseudo-command is enabled, permits a match between the name of the
pseudo-command and the name of an executable file in an arbitrary
directory, which allows local users to gain privileges via a crafted
executable file, as demonstrated by a file named sudoedit in a user's
home directory.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.sudo.ws/pipermail/sudo-announce/2010-February/000092.html
http://www.sudo.ws/sudo/alerts/sudoedit_escalate.html
http://secunia.com/advisories/38659
http://www.vuxml.org/freebsd/018a84d0-2548-11df-b4a3-00e0815b8da8.html

Risk factor : High";

 script_description(desc);

 script_summary("FreeBSD Ports: sudo");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2010 E-Soft Inc. http://www.securityspace.com");
 script_family("FreeBSD Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"sudo");
if(!isnull(bver) && revcomp(a:bver, b:"1.7.2.4")<0) {
    security_note(0, data:"Package sudo version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
