###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_geoserver_detect.nasl 4769 2009-09-18 10:53:18Z sep $
#
# GeoServer Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Updated By: Verendra GG <verendragg@secpod.com> on 2010-04-28
# Updated the detection logic
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900945);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("GeoServer Version Detection");
  desc = "
  Overview: This script detects the installed version of GeoServer
  and sets the result in KB.

  Risk factor: None";

  script_description(desc);
  script_summary("Set the KB for the version of GeoServer");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 8080);
  exit(0);
}


include("http_func.inc");

geoPort = get_http_port(default:8080);
if(!geoPort){
  geoPort = 8080;
}

if(!get_port_state(geoPort)){
  exit(0);
}

foreach dir (make_list("/", "/geoserver", cgi_dirs()))
{
  path = string(dir, "/welcome.do");
  sndReq = http_get(item:path, port:geoPort);
  rcvRes = http_send_recv(port:geoPort, data:sndReq);

  ## Logic for version lesser then 2.0
  if(("My GeoServer" >< rcvRes) && ("Welcome to GeoServer" >< rcvRes))
  {
    ## Matches 1.7.0 or 1.7.0-RC1 or 1.7.0-beta1
    geoVer = eregmatch(pattern:"Welcome to GeoServer ([0-9.]+(-[a-zA-Z0-9]+)?)"
                      , string:rcvRes);
    if(geoVer[1])
    {
      ## to remove "." at the end
      geoVer = ereg_replace(pattern:"([0-9]\.[0-9]\.[0-9])\.", string:geoVer[1],
                            replace:"\1");
      ## Replacing "-" with "." ex 1.7.0-RC1 and 1.7.0-beta1
      geoVer = ereg_replace(pattern:string("-"), replace:string("."),
                            string:geoVer);
      set_kb_item(name:"www/" + geoPort + "/GeoServer",
                  value:geoVer + " under " + dir);
      security_note(data:"GeoServer version " + geoVer + " running at location "
                                          + dir +  " was detected on the host");
    }
  }

  ## Logic for version 2.0
  else
  {
    path = string(dir, "/web/?wicket:bookmarkablePage=:org.geoserver.web."+
                                                        "AboutGeoServerPage");
    sndReq = http_get(item:path, port:geoPort);
    rcvRes = http_send_recv(port:geoPort, data:sndReq);
    if((">About GeoServer<" >< rcvRes))
    {
      ## Matches 2.0.1 or 2.0.1-RC1 or 2.0.1-beta1
      geoVer = eregmatch(pattern:">GeoServer ([0-9]\.[0-9]\.[0-9]"+
                                 "(-[a-zA-Z0-9]+)?)<", string:rcvRes);
      if(geoVer[1])
      {
        ## to remove "." at the end
        geoVer = ereg_replace(pattern:"([0-9]\.[0-9]\.[0-9])\.", string:geoVer[1],
                              replace:"\1");
        ## Replacing "-" with "." ex 1.7.0-RC1 and 1.7.0-beta1
        geoVer = ereg_replace(pattern:string("-"), replace:string("."),
                              string:geoVer);
        set_kb_item(name:"www/" + geoPort + "/GeoServer",
                    value:geoVer + " under " + dir);
        security_note(data:"GeoServer version " + geoVer + 
                 " running at location " + dir +  " was detected on the host");

      }
    }
  }
}
