<?php
/**
*
* common [Português]
*
* @package language
* @version 1.0.9
* @Traduzido por: http://phpbbportugal.com - segundo as normas do Acordo Ortográfico
* @copyright (c) 2005 phpBB Group
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
* 
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine
//
// Some characters you may want to copy&paste:
// ’ » “ ” …
//

$lang = array_merge($lang, array(
	'TRANSLATION_INFO'					=> 'Traduzido por phpBB Portugal',
	'DIRECTION'							=> 'ltr',
	'DATE_FORMAT'						=> '|d M Y|',	// 01 Jan 2007 (with Relative days enabled) 
	'USER_LANG'							=> 'pt',

	'1_DAY'								=> '1 Dia',
	'1_MONTH'							=> '1 Mês',
	'1_YEAR'							=> '1 Ano',
	'2_WEEKS'							=> '2 Semanas',
	'3_MONTHS'							=> '3 Meses',
	'6_MONTHS'							=> '6 Meses',
	'7_DAYS'							=> '7 Dias',

	'ACCOUNT_ALREADY_ACTIVATED'			=> 'O seu registo já se encontra ativo.',
	'ACCOUNT_DEACTIVATED'				=> 'O seu registo foi desativado manualmente e apenas pode ser reativado por um Administrador.',
	'ACCOUNT_NOT_ACTIVATED'				=> 'O seu registo ainda não se encontra activo',
	'ACP'								=> 'Painel de Administração',
	'ACTIVE'							=> 'Ativo',
	'ACTIVE_ERROR'						=> 'Especificou um Utilizador inativo. Se continuar com problemas, contate um Administrador.',
	'ADMINISTRATOR'						=> 'Administrador',
	'ADMINISTRATORS'					=> 'Administradores',
	'AGE'								=> 'Idade',
	'AIM'								=> 'AIM',
	'ALLOWED'							=> 'Permitido',
	'ALL_FILES'							=> 'Todos os Ficheiros',
	'ALL_FORUMS'						=> 'Todos os Fóruns',
	'ALL_MESSAGES'						=> 'Todas as Mensagens',
	'ALL_POSTS'							=> 'Todas as Mensagens',
	'ALL_TIMES'							=> 'Os Horários são %1$s %2$s',
	'ALL_TOPICS'						=> 'Todos os Tópicos',
	'AND'								=> 'E',
	'ARE_WATCHING_FORUM'				=> 'Optou por receber atualizações deste Fórum.',
	'ARE_WATCHING_TOPIC'				=> 'Optou por receber atualizações deste Tópico.',
	'ASCENDING'							=> 'Crescente',
	'ATTACHMENTS'						=> 'Anexos',
	'ATTACHED_IMAGE_NOT_IMAGE'			=> 'O Ficheiro de imagem que anexou é inválido',
	'AUTHOR'							=> 'Autor',
	'AUTH_NO_PROFILE_CREATED'			=> 'Não foi possível criar o Perfil do Utilizador.',
	'AVATAR_DISALLOWED_CONTENT'			=> 'O envio foi recusado porque o Ficheiro foi identificado como potencialmente malicioso.',
	'AVATAR_DISALLOWED_EXTENSION'		=> 'A extensão %s não é permitida.',
	'AVATAR_EMPTY_REMOTE_DATA'			=> 'Avatar não foi enviado, por favor, tente enviar o Ficheiro manualmente.',
	'AVATAR_EMPTY_FILEUPLOAD'			=> 'O Ficheiro de Avatar enviado está vazio.',
	'AVATAR_INVALID_FILENAME'			=> '%s é um nome de Ficheiro inválido.',
	'AVATAR_NOT_UPLOADED'				=> 'O Avatar não foi enviado.',
	'AVATAR_NO_SIZE'					=> 'Não foi possível obter a largura e a altura do Avatar, por favor, indique-os manualmente.',
	'AVATAR_PARTIAL_UPLOAD'				=> 'O Ficheiro foi parcialmente enviado.',
	'AVATAR_PHP_SIZE_NA'				=> 'O Ficheiro do Avatar é demasiado grande.<br />Não foi possível determinar o tamanho máximo definido pelo PHP no php.ini.',
	'AVATAR_PHP_SIZE_OVERRUN'			=> 'O Ficheiro do Avatar é demasiado grande, sendo o máximo permitido de envio %1$d %2$s.<br />Por favor, note que isto é definido no php.ini e não pode ser alterado.',
	'AVATAR_REMOTE_UPLOAD_TIMEOUT'		=> 'O avatar especificado não pôde ser carregado porque o pedido excedeu o tempo limite.',
	'AVATAR_URL_INVALID'				=> 'A URL que especificou é inválida.',
	'AVATAR_URL_NOT_FOUND'				=> 'O Ficheiro indicado não foi encontrado.',
	'AVATAR_WRONG_FILESIZE'				=> 'O tamanho do Avatar deve estar entre 0 e %1$d %2$s.',
	'AVATAR_WRONG_SIZE'					=> 'O Avatar submetido tem %5$d pixels de largura e %6$d pixels de altura. Os Avatares devem ter %1$d pixels de largura e %2$d pixels de altura, mas não podem ser maiores do que %3$d pixels de largura e %4$d pixels de altura.',
	
	'BACK_TO_TOP'						=> 'Topo',
	'BACK_TO_PREV'						=> 'Voltar à página anterior',
	'BAN_TRIGGERED_BY_EMAIL'			=> 'O seu endereço de email foi banido do Fórum.',
	'BAN_TRIGGERED_BY_IP'				=> 'O seu endereço IP foi banido do Fórum.',
	'BAN_TRIGGERED_BY_USER'				=> 'O seu Nome de Utilizador foi banido do Fórum.',
	'BBCODE_GUIDE'						=> 'Guia BBCode',
	'BCC'								=> 'Bc',
	'BIRTHDAYS'							=> 'Aniversariantes',
	'BOARD_BAN_PERM'					=> 'Foi expulso permanentemente deste Fórum.<br /><br />Por favor, contate o %2$sAdministrador%3$s para mais informações.',
	'BOARD_BAN_REASON'					=> 'Razão da expulsão: %s',
	'BOARD_BAN_TIME'					=> 'Foi expulso deste Fórum até %1$s.<br /><br />Por favor, contate o %2$sAdministrador%3$s para mais informações.',
	'BOARD_DISABLE'						=> 'Este Fórum está indisponível no momento.',
	'BOARD_DISABLED'					=> 'Este Fórum está atualmente desativado.',
	'BOARD_UNAVAILABLE'					=> 'Este Fórum não se encontra disponível neste momento. Por Favor, tente novamente mais tarde.',
	'BROWSING_FORUM'					=> 'Utilizadores a ver este Fórum: %1$s',
	'BROWSING_FORUM_GUEST'				=> 'Utilizador a ver este Fórum: %1$s e %2$d visitante',
	'BROWSING_FORUM_GUESTS'				=> 'Utilizadores a ver este Fórum: %1$s e %2$d visitantes',
	'BYTES'								=> 'Bytes',

	'CANCEL'							=> 'Cancelar',
	'CHANGE'							=> 'Alterar',
	'CHANGE_FONT_SIZE'					=> 'Alterar o tamanho da fonte',
	'CHANGING_PREFERENCES'				=> 'Alterando as Preferências do Fórum',
	'CHANGING_PROFILE'					=> 'Alterando as Configurações de Perfil',
	'CLICK_VIEW_PRIVMSG'				=> 'Clique %saqui%s para ver sua Caixa de Entrada',
	'COLLAPSE_VIEW'						=> 'Visão de colapso',
	'CLOSE_WINDOW'						=> 'Fechar Janela',
	'COLOUR_SWATCH'						=> 'Paleta de Cores',
	'COMMA_SEPARATOR'					=> ', ',
	'CONFIRM'							=> 'Confirmar',
	'CONFIRM_CODE'						=> 'Código de Confirmação',
	'CONFIRM_CODE_EXPLAIN'				=> 'As letras são maiúsculas e minúsculas. Escreva-as exatamente como aparecem.',
	'CONFIRM_CODE_WRONG'				=> 'O Código de Confirmação está incorreto.',
	'CONFIRM_OPERATION'					=> 'Deseja continuar com esta operação?',
	'CONGRATULATIONS'					=> 'Parabéns a',
	'CONNECTION_FAILED'					=> 'A ligação falhou.',
	'CONNECTION_SUCCESS'				=> 'A ligação foi efetuada!',
	'COOKIES_DELETED'					=> 'Todos os cookies deste Fórum foram apagados.',
	'CURRENT_TIME'						=> 'Data/Hora: %s',

	'DAY'								=> 'Dia',
	'DAYS'								=> 'Dias',
	'DELETE'							=> 'Apagar',
	'DELETE_ALL'						=> 'Apagar Todos',
	'DELETE_COOKIES'					=> 'Apagar cookies',
	'DELETE_MARKED'						=> 'Apagar Selecionados',
	'DELETE_POST'						=> 'Apagar Mensagem',
	'DELIMITER'							=> 'Delimitador',
	'DESCENDING'						=> 'Decrescente',
	'DISABLED'							=> 'Desativado',
	'DISPLAY'							=> 'Mostrar',
	'DISPLAY_GUESTS'					=> 'Mostrar Visitantes',
	'DISPLAY_MESSAGES'					=> 'Mostrar mensagens anteriores',
	'DISPLAY_POSTS'						=> 'Mostrar mensagens anteriores',
	'DISPLAY_TOPICS'					=> 'Mostrar Tópicos anteriores',
	'DOWNLOADED'						=> 'Transferido',
	'DOWNLOADING_FILE'					=> 'A Transferir ficheiro',
	'DOWNLOAD_COUNT'					=> 'Transferido %d Vez',
	'DOWNLOAD_COUNTS'					=> 'Transferido %d Vezes',
	'DOWNLOAD_COUNT_NONE'				=> 'Ainda não foi transferido',
	'VIEWED_COUNT'						=> 'Visualizado %d vez',
	'VIEWED_COUNTS'						=> 'Visualizado %d vezes',
	'VIEWED_COUNT_NONE'					=> 'Ainda não foi visualizado',

	'EDIT_POST'							=> 'Editar Mensagem',
	'EMAIL'								=> 'Correio eletrónico', // Short form for EMAIL_ADDRESS
	'EMAIL_ADDRESS'						=> 'Endereço de email',
	'EMAIL_INVALID_EMAIL'				=> 'O endereço de email que introduziu é inválido.',
	'EMAIL_SMTP_ERROR_RESPONSE'			=> 'Ocorreu um problema ao enviar o email na <strong>Linha %1$s</strong>. Erro: %2$s.',
	'EMPTY_SUBJECT'						=> 'Quando se envia uma mensagem, deve ser especificado um ASSUNTO.',
	'EMPTY_MESSAGE_SUBJECT'				=> 'Precisa especificar um assunto quando escrever uma nova mensagem.',
	'ENABLED'							=> 'Ativado',
	'ENCLOSURE'							=> 'Documento anexo',
	'ENTER_USERNAME'					=> 'Introduza o Utilizador',
	'ERR_CHANGING_DIRECTORY'			=> 'Não foi possível alterar a diretoria.',
	'ERR_CONNECTING_SERVER'				=> 'Erro ao ligar-se ao servidor.',
	'ERR_JAB_AUTH'						=> 'Não foi autorizado a entrar no servidor Jabber.',
	'ERR_JAB_CONNECT'					=> 'Não foi possivel fazer a ligação ao servidor Jabber.',
	'ERR_UNABLE_TO_LOGIN'				=> 'Ocorreu um erro no acesso. Nome de Utilizador ou Senha incorretos.',
	'ERR_UNWATCHING'					=> 'Um erro ocorreu durante o cancelamento da subscrição.',
	'ERR_WATCHING'						=> 'Um erro ocorreu durante a subscrição.',	
	'ERR_WRONG_PATH_TO_PHPBB'			=> 'O local do script phpBB indicado parece não ser válido.',
	'EXPAND_VIEW'						=> 'Ver mais detalhes',
	'EXTENSION'							=> 'Extensão',
	'EXTENSION_DISABLED_AFTER_POSTING'	=> 'A extensão %s foi desativada e não pode ser exibida.',

	'FAQ'								=> 'FAQ',
	'FAQ_EXPLAIN'						=> 'Questões Mais Frequentes',
	'FILENAME'							=> 'Nome do Ficheiro',
	'FILESIZE'							=> 'Tamanho do Ficheiro',
	'FILEDATE'							=> 'Data do Ficheiro',
	'FILE_COMMENT'						=> 'Comentário do Ficheiro',
	'FILE_NOT_FOUND'					=> 'Ficheiro não encontrado.',
	'FIND_USERNAME'						=> 'Procurar Utilizador',
	'FOLDER'							=> 'Pasta',
	'FORGOT_PASS'						=> 'Esqueci-me da senha',
	'FORM_INVALID'						=> 'Campo inválido. Tente submeter novamente.',
	'FORUM'								=> 'Fórum',
	'FORUMS'							=> 'Fóruns',
	'FORUMS_MARKED'						=> 'Os Fóruns foram marcados como lidos.',
	'FORUM_CAT'							=> 'Categoria do Fórum',
	'FORUM_INDEX'						=> 'Índice do Fórum',
	'FORUM_LINK'						=> 'Endereço do Fórum',
	'FORUM_LOCATION'					=> 'Local do Fórum',
	'FORUM_LOCKED'						=> 'Fórum Bloqueado',
	'FORUM_RULES'						=> 'Regras do Fórum',
	'FORUM_RULES_LINK'					=> 'Por Favor, clique aqui para ver as regras do Fórum',
	'FROM'								=> 'de',
	'FSOCK_DISABLED'					=> 'Não foi possível concluir esta operação, porque a função <var>fsockopen</var> está desativada ou o servidor solicitado não foi encontrado.',
	'FSOCK_TIMEOUT'						=> 'O tempo limite esgotou-se durante a leitura do fluxo de rede',

	'FTP_FSOCK_HOST'					=> 'Servidor FTP',
	'FTP_FSOCK_HOST_EXPLAIN'			=> 'Servidor FTP utilizada para se ligar ao seu site.',
	'FTP_FSOCK_PASSWORD'				=> 'Senha do FTP',
	'FTP_FSOCK_PASSWORD_EXPLAIN'		=> 'Senha para o seu Nome de Utilizador do FTP.',
	'FTP_FSOCK_PORT'					=> 'Porta FTP',
	'FTP_FSOCK_PORT_EXPLAIN'			=> 'Porta utilizada para se ligar ao seu servidor FTP.',
	'FTP_FSOCK_ROOT_PATH'				=> 'Local do phpBB',
	'FTP_FSOCK_ROOT_PATH_EXPLAIN'		=> 'Caminho desde a raiz até ao seu Fórum phpBB.',
	'FTP_FSOCK_TIMEOUT'					=> 'Intervalo do FTP',
	'FTP_FSOCK_TIMEOUT_EXPLAIN'			=> 'Tempo, em segundos, que o sistema irá aguardar por uma resposta do servidor.',
	'FTP_FSOCK_USERNAME'				=> 'Nome de utilizador FTP',
	'FTP_FSOCK_USERNAME_EXPLAIN'		=> 'Nome de utilizador utilizado para se ligar ao seu servidor.',

	'FTP_HOST'							=> 'Servidor FTP',
	'FTP_HOST_EXPLAIN'					=> 'Servidor FTP utilizado para se ligar ao seu site.',
	'FTP_PASSWORD'						=> 'Senha do FTP',
	'FTP_PASSWORD_EXPLAIN'				=> 'Senha para de Utilizador do seu FTP.',
	'FTP_PORT'							=> 'Porta FTP',
	'FTP_PORT_EXPLAIN'					=> 'Porta utilizada para ligar ao seu servidor FTP.',
	'FTP_ROOT_PATH'						=> 'Local do phpBB',
	'FTP_ROOT_PATH_EXPLAIN'				=> 'Local desde a raiz até ao seu Fórum phpBB.',
	'FTP_TIMEOUT'						=> 'Intervalo FTP',
	'FTP_TIMEOUT_EXPLAIN'				=> 'Tempo, em segundos, que o sistema irá aguardar por uma resposta do seu servidor.',
	'FTP_USERNAME'						=> 'Nome do Utilizador do FTP',
	'FTP_USERNAME_EXPLAIN'				=> 'Nome de Utilizador utilizado para se conetar ao seu servidor.',

	'GENERAL_ERROR'						=> 'Erro Geral',
	'GB'								=> 'GB',
	'GIB'								=> 'GiB',
	'GO'								=> 'Avançar',
	'GOTO_PAGE'							=> 'Ir para página',
	'GROUP'								=> 'Grupo',
	'GROUPS'							=> 'Grupos',
	'GROUP_ERR_TYPE'					=> 'O tipo de grupo especificado é inapropriado.',
	'GROUP_ERR_USERNAME'				=> 'Especifique um nome para o Grupo.',
	'GROUP_ERR_USER_LONG'				=> 'O Nome do Grupo é muito grande.',
	'GUEST'								=> 'Visitante',
	'GUEST_USERS_ONLINE'				=> 'Há %d visitantes online',
	'GUEST_USERS_TOTAL'					=> '%d visitantes',
	'GUEST_USERS_ZERO_ONLINE'			=> 'Não há visitantes online',
	'GUEST_USERS_ZERO_TOTAL'			=> 'nenhum visitante',
	'GUEST_USER_ONLINE'					=> 'Há %d visitante online',
	'GUEST_USER_TOTAL'					=> '%d visitante',
	'G_ADMINISTRATORS'					=> 'Administrador',
	'G_BOTS'							=> 'Motores de Busca',
	'G_GUESTS'							=> 'Visitantes',
	'G_REGISTERED'						=> 'Utilizadores',
	'G_REGISTERED_COPPA'				=> 'Utilizadores COPPA Registados',
	'G_GLOBAL_MODERATORS'				=> 'Moderador Global',
	'G_NEWLY_REGISTERED'				=> 'Utilizadores Registados Recentemente',

	'HIDDEN_USERS_ONLINE'				=> '%d utilizadores invisíveis online',
	'HIDDEN_USERS_TOTAL'				=> '%d invisíveis ',
	'HIDDEN_USERS_TOTAL_AND'			=> '%d invisíveis e ',
	'HIDDEN_USERS_ZERO_ONLINE'			=> '0 utilizadores invisíveis online',
	'HIDDEN_USERS_ZERO_TOTAL'			=> 'nenhum invisível ',
	'HIDDEN_USERS_ZERO_TOTAL_AND'		=> 'nenhum invisível e ',
	'HIDDEN_USER_ONLINE'				=> '%d utilizadores invisíveis online',
	'HIDDEN_USER_TOTAL'					=> '%d invisíveis ',
	'HIDDEN_USER_TOTAL_AND'				=> '%d invisíveis e ',
	'HIDE_GUESTS'						=> 'Visitantes invisíveis',
	'HIDE_ME'							=> 'Ocultar o meu estado nesta sessão',
	'HOURS'								=> 'Horas',
	'HOME'								=> 'Página Principal',

	'ICQ'								=> 'ICQ',
	'ICQ_STATUS'						=> 'Estado do ICQ',
	'IF'								=> 'Se',
	'IMAGE'								=> 'Imagem',
	'IMAGE_FILETYPE_INVALID'			=> 'O formato de imagem %d não é suportado para a miniatura %s.',
	'IMAGE_FILETYPE_MISMATCH'			=> 'Tipo de Ficheiro da imagem em desacordo: extensão esperada %1$s mas a extensão informada foi %2$s.',
	'IN'								=> 'em',
	'INDEX'								=> 'Índice',
	'INFORMATION'						=> 'Informação',
	'INTERESTS'							=> 'Interesses',
	'INVALID_DIGEST_CHALLENGE'			=> 'Desafio de Sumário Inválido.',
	'INVALID_EMAIL_LOG'					=> '%s é um endereço de email possivelmente incorreto?',
	'IP'								=> 'IP',
	'IP_BLACKLISTED'					=> 'O Seu endereço de IP %1$s foi expulso porque está na lista negra. Para mais detalhes leia <a href="%2$s">%2$s</a>.',

	'JABBER'							=> 'Jabber',
	'JOINED'							=> 'Registado',
	'JUMP_PAGE'							=> 'Número da página para onde deseja ir.',
	'JUMP_TO'							=> 'Ir para',
	'JUMP_TO_PAGE'						=> 'Clique para ir à página...',

	'KB'								=> 'KB',
	'KIB'								=> 'KiB',

	'LAST_POST'							=> 'Última Mensagem',
	'LAST_UPDATED'						=> 'Última Atualização',
	'LAST_VISIT'						=> 'Última visita',
	'LDAP_NO_LDAP_EXTENSION'			=> 'Extensão LDAP não disponível.',
	'LDAP_NO_SERVER_CONNECTION'			=> 'Não foi possível ligar-se ao servidor LDAP.',
	'LDAP_SEARCH_FAILED'				=> 'Ocorreu um erro durante a pesquisa na pasta LDAP.',
	'LEGEND'							=> 'Legenda',
	'LOCATION'							=> 'Localização',
	'LOCK_POST'							=> 'Bloquear Mensagem',
	'LOCK_POST_EXPLAIN'					=> 'Edição Prévia',
	'LOCK_TOPIC'						=> 'Bloquear Tópico',
	'LOGIN'								=> 'Ligue-se',
	'LOGIN_CHECK_PM'					=> 'Ver Mensagens Privadas.',
	'LOGIN_CONFIRMATION'				=> 'Confirmação de acesso',
	'LOGIN_CONFIRM_EXPLAIN'				=> 'Para prevenir ataques "brute force" o Administrador exige o código de confirmação após sucessivas tentativas falhadas de acesso. O código é exibido na imagem abaixo. Se tiver problemas em ver esta imagem, por favor, contate um %sAdministrador%s.', // unused
    'LOGIN_ERROR_ATTEMPTS'				=> 'Excedeu o número máximo de tentativas de acesso. Além do seu nome de Utilizador e Senha tem de resolver o CAPTCHA abaixo',
	'LOGIN_ERROR_EXTERNAL_AUTH_APACHE'	=> 'Não foi autenticado pelo Apache.',
	'LOGIN_ERROR_PASSWORD'				=> 'A Senha introduzida não está correta, tente novamente. Se continuar com problemas, contate um %sAdministrador do Fórum%s.',
	'LOGIN_ERROR_PASSWORD_CONVERT'		=> 'Não foi possível converter a sua Senha ao atualizar este Fórum. Por favor peça uma %snova senha%s. Se continuar com problemas, contate um %sAdministrador do Fórum%s.',
	'LOGIN_ERROR_USERNAME'				=> 'Especificou um nome de Utilizador incorreto. Confirme o seu nome de Utilizador e tente novamente. Se continuar com problemas, por favor, contate um %sAdministrador do Fórum%s.',
	'LOGIN_FORUM'						=> 'Para ver ou enviar mensagens neste Fórum deve inserir a Senha.',
	'LOGIN_INFO'						=> 'O acesso completo ao Fórum necessita dum Registo que demora apenas alguns segundos. Antes de se Registar leia: - FAQ - Condições de Utilização - Política de Privacidade Respeite as regras do Fórum.',
	'LOGIN_VIEWFORUM'					=> 'Para ver o conteúdo completo deste Fórum é necessário estar ligado.',
	'LOGIN_EXPLAIN_EDIT'				=> 'Para editar Mensagens neste Fórum tem de estar registado e ligado.',
	'LOGIN_EXPLAIN_VIEWONLINE'			=> 'Para aparecer na lista tem de estar registado e ligado.',
	'LOGOUT'							=> 'Desligar Sessão',
	'LOGOUT_USER'						=> 'Sair [ %s ]',
	'LOG_ME_IN'							=> 'Na próxima visita entrar automaticamente',

	'MARK'								=> 'Selecionar',
	'MARK_ALL'							=> 'Selecionar Todos',
	'MARK_FORUMS_READ'					=> 'Marcar todos os Fóruns como lidos',
	'MARK_SUBFORUMS_READ'				=> 'Marcar todos os subfóruns como lidos',
	'MB'								=> 'MB',
	'MIB'								=> 'MiB',
	'MCP'								=> 'Painel de Moderação',
	'MEMBERLIST'						=> 'Utilizadores',
	'MEMBERLIST_EXPLAIN'				=> 'Ver a lista completa de Utilizadores',
	'MERGE'								=> 'Fundir',
	'MERGE_POSTS'						=> 'Mover Mensagens',
	'MERGE_TOPIC'						=> 'Fundir Tópicos',
	'MESSAGE'							=> 'Mensagem',
	'MESSAGES'							=> 'Mensagens',
	'MESSAGE_BODY'						=> 'Corpo da Mensagem',
	'MINUTES'							=> 'Minutos',
	'MODERATE'							=> 'Moderado',
	'MODERATOR'							=> 'Moderador',
	'MODERATORS'						=> 'Moderadores',
	'MODULE_NOT_ACCESS'					=> 'Módulo não encontrado',
	'MODULE_NOT_FIND'					=> 'O Módulo %s não foi encontrado',
	'MODULE_FILE_INCORRECT_CLASS'		=> 'O ficheiro do Módulo %s não tem a classe correta [%s]',
	'MONTH'								=> 'Mês',
	'MOVE'								=> 'Mover',
	'MSNM'								=> 'MSM/WLM',

	'NA'								=> 'N/A',
	'NEWEST_USER'						=> '%s é o(a) nosso(a) Utilizador(a) mais recente. Bem-vindo(a) ao Fórum',
	'NEW_MESSAGE'						=> 'Nova Mensagem',
	'NEW_MESSAGES'						=> 'Novas Mensagens',
	'NEW_PM'							=> '%d mensagem privada nova',
	'NEW_PMS'							=> '%d mensagens privadas novas',
	'NEW_POST'							=> 'Nova Mensagem',   // Not used anymore
	'NEW_POSTS'							=> 'Novas Mensagens',   // Not used anymore
	'NEXT'								=> 'Próximo',      // Used in pagination
	'NEXT_STEP'							=> 'Próximo',
	'NEVER'								=> 'Nunca',
	'NO'								=> 'Não',
	'NOT_ALLOWED_MANAGE_GROUP'			=> 'Não está autorizado a administrar este grupo do “Painel de Administração”.',
	'NOT_AUTHORISED'					=> 'Não está autorizado a aceder esta área.',
	'NOT_WATCHING_FORUM'				=> 'Já não se encontra a receber atualizações deste Fórum.',
	'NOT_WATCHING_TOPIC'				=> 'Já não se encontra a receber atualizações deste Tópico.',
	'NOTIFY_ADMIN'						=> 'Por favor, notifique o Administrador ou webmaster deste Fórum.',
	'NOTIFY_ADMIN_EMAIL'				=> 'Por favor, notifique o Administrador ou webmaster deste Fórum: <a href="mailto:%1$s">%1$s</a>',
	'NO_ACCESS_ATTACHMENT'				=> 'Não está autorizado a aceder este Ficheiro.',
	'NO_ACTION'							=> 'Nenhuma ação especificada.',
	'NO_ADMINISTRATORS'					=> 'Este Fórum não tem Administradores.',
	'NO_AUTH_ADMIN'						=> 'Não tem permissões de Administrador, logo não pode aceder ao Painel de Administração.',
	'NO_AUTH_ADMIN_USER_DIFFER'			=> 'Não pode autenticar-se novamente com outro nome de utilizador.',
	'NO_AUTH_OPERATION'					=> 'Não tem as permissões necessárias para completar esta operação.',
	'NO_CONNECT_TO_SMTP_HOST'			=> 'Não foi possível ligar ao servidor SMTP : %s : %s',
	'NO_BIRTHDAYS'						=> 'Hoje não há aniversariantes',
	'NO_EMAIL_MESSAGE'					=> 'Mensagem do email estava em branco.',
	'NO_EMAIL_RESPONSE_CODE'			=> 'Não foi possível receber os códigos de erro do servidor de email.',
	'NO_EMAIL_SUBJECT'					=> 'Não foi definido um assunto para este email',
	'NO_FORUM'							=> 'O Fórum selecionado não existe.',
	'NO_FORUMS'							=> 'Este Fórum não tem Tópicos.',
	'NO_GROUP'							=> 'Este Grupo não existe.',
	'NO_GROUP_MEMBERS'					=> 'Este Grupo não tem Utilizadores.',
	'NO_IPS_DEFINED'					=> 'Nenhum endereço de IP ou nome de Servidor definido',
	'NO_MEMBERS'						=> 'Nenhum Utilizador foi encontrado com estes critérios de pesquisa.',
	'NO_MESSAGES'						=> 'Sem Mensagens',
	'NO_MODE'							=> 'Nenhum modo foi especificado.',
	'NO_MODERATORS'						=> 'Este Fórum não tem Moderadores.',
	'NO_NEW_MESSAGES'					=> 'Sem novas mensagens',
	'NO_NEW_PM'							=> 'Mensagens Privadas novas: <strong>0</strong>',
	'NO_NEW_POSTS'						=> 'Sem mensagens novas',   // Not used anymore
	'NO_ONLINE_USERS'					=> 'Nenhum utilizador registado',
	'NO_POSTS'							=> 'Nenhuma mensagem',
	'NO_POSTS_TIME_FRAME'				=> 'Não existem mensagens neste Tópico no prazo selecionado.',
	'NO_FEED_ENABLED'					=> 'Os Feeds não estão disponíveis neste Fórum.',
	'NO_FEED'							=> 'O Feed solicitado não está disponível.',
	'NO_STYLE_DATA'						=> 'Não foi possível obter os dados do estilo',
	'NO_SUBJECT'						=> 'Sem assunto.',
	'NO_SUCH_SEARCH_MODULE'				=> 'A Pesquisa especificada não existe.',
	'NO_SUPPORTED_AUTH_METHODS'			=> 'Nenhum método de autenticação suportado.',
	'NO_TOPIC'							=> 'Este Tópico não existe.',
	'NO_TOPIC_FORUM'					=> 'Este Tópico ou Fórum não existem.',
	'NO_TOPICS'							=> 'Não há mensagens ou Tópicos neste Fórum.',
	'NO_TOPICS_TIME_FRAME'				=> 'Não há Tópicos neste Fórum no prazo selecionado.',
	'NO_UNREAD_PM'						=> '0 Mensagem não lidas',
	'NO_UNREAD_POSTS'					=> 'Não há novas mensagens',
	'NO_UPLOAD_FORM_FOUND'				=> 'O envio do ficheiro foi iniciado, mas nenhuma forma de envio válida foi encontrada.',
	'NO_USER'							=> 'Este Utilizador não existe.',
	'NO_USERS'							=> 'Estes Utilizadores não existem.',
	'NO_USER_SPECIFIED'					=> 'Nenhum nome de Utilizador foi especificado.',

	// Nullar/Singular/Plural language entry. The key numbers define the number range in which a certain grammatical expression is valid.
	'NUM_POSTS_IN_QUEUE'				=> array(
		0								=> 'Nenhuma mensagem na lista',		// 0
		1								=> '1 mensagem na lista',		// 1
		2								=> '%d mensagens na lista',		// 2+
	),	
	
	'OCCUPATION'							=> 'Ocupação',
	'OFFLINE'							=> 'Desligado',
	'ONLINE'							=> 'Ligado',
	'ONLINE_BUDDIES'					=> 'Amigos ligados',
	'ONLINE_USERS_TOTAL'				=> 'No total há %d Utilizadores ligados :: ',
	'ONLINE_USERS_ZERO_TOTAL'			=> 'No total há 0 Utilizadores ligados :: ',
	'ONLINE_USER_TOTAL'					=> 'No total há %d Utilizador ligado :: ',
	'OPTIONS'							=> 'Opções',

	'PAGE_OF'							=> 'Página %1$d de %2$d',
	'PASSWORD'							=> 'Senha',
	'PIXEL'								=> 'px',
	'PLAY_QUICKTIME_FILE'				=> 'Reproduzir ficheiro Quicktime',
	'PM'								=> 'MP',
	'PM_REPORTED'						=> 'Clique para ver relatório',
	'POSTING_MESSAGE'					=> 'Enviar mensagem para %s',
	'POSTING_PRIVATE_MESSAGE'			=> 'Escrevendo Mensagem Privada',
	'POST'								=> 'Mensagem',
	'POST_ANNOUNCEMENT'					=> 'Anúncio',
	'POST_STICKY'						=> 'Fixo',
	'POSTED'							=> 'Enviado',
	'POSTED_IN_FORUM'					=> 'no',
	'POSTED_ON_DATE'					=> 'em',
	'POSTS'								=> 'Mensagens',
	'POSTS_UNAPPROVED'					=> 'Pelo menos uma mensagem neste Tópico não foi aprovada.',
	'POST_BY_AUTHOR'					=> 'por',
	'POST_BY_FOE'						=> 'Está mensagem foi enviada por %1$s que está na sua lista de ignorados. Para mostrar a mensagem clique %2$sAqui%3$s.',
	'POST_DAY'							=> '%.2f mensagens por dia',
	'POST_DETAILS'						=> 'Detalhes da mensagem',
	'POST_NEW_TOPIC'					=> 'Criar Novo Tópico',
	'POST_PCT'							=> '%.2f%% de todas as mensagens',
	'POST_PCT_ACTIVE'					=> '%.2f%% das mensagens dos Utilizadores',
	'POST_PCT_ACTIVE_OWN'				=> '%.2f%% das suas mensagens',
	'POST_REPLY'						=> 'Responder',
	'POST_REPORTED'						=> 'Clique aqui para ver as denúncias',
	'POST_SUBJECT'						=> 'Assunto da Mensagem',
	'POST_TIME'							=> 'Data da Mensagem',
	'POST_TOPIC'						=> 'Criar um novo Tópico',
	'POST_UNAPPROVED'					=> 'Clique para aprovar a mensagem',
	'POWERED_BY'						=> 'Desenvolvido por %s',
	'PREVIEW'							=> 'Prever',
	'PREVIOUS'							=> 'Anterior',      // Used in pagination
	'PREVIOUS_STEP'						=> 'Anterior',
	'PRIVACY'							=> 'Política de Privacidade',
	'PRIVATE_MESSAGE'					=> 'Mensagem Privada',
	'PRIVATE_MESSAGES'					=> 'Mensagens Privadas',
	'PRIVATE_MESSAGING'					=> 'A enviar Mensagem Privada',
	'PROFILE'							=> 'Painel de Controlo do Utilizador',
	'RANK'								=> 'Classificação',

	'READING_FORUM'						=> 'Ver Tópicos em %s',
	'READING_GLOBAL_ANNOUNCE'			=> 'A ler Anúncio Global',
	'READING_LINK'						=> 'Seguinte endereço do Fórum %s',
	'READING_TOPIC'						=> 'A ler Tópico em %s',
	'READ_PROFILE'						=> 'Perfil',
	'REASON'							=> 'Razão',
	'RECORD_ONLINE_USERS'				=> 'O recorde de utilizadores online foi de %1$s em %2$s',
	'REDIRECT'							=> 'Redirecionar',
	'REDIRECTS'							=> 'Total de redirecionamentos',
	'REGISTER'							=> 'Registe-se',
	'REGISTERED_USERS'					=> 'Membros ligados:',
	'REG_USERS_ONLINE'					=> 'Há %d utilizadores registados e ',
	'REG_USERS_TOTAL'					=> '%d registados, ',
	'REG_USERS_TOTAL_AND'				=> '%d registados e ',
	'REG_USERS_ZERO_ONLINE'				=> 'Não há utilizadores registados e ',
	'REG_USERS_ZERO_TOTAL'				=> '0 registados, ',
	'REG_USERS_ZERO_TOTAL_AND'			=> '0 registados e ',
	'REG_USER_ONLINE'					=> 'Há %d utilizadores registados e ',
	'REG_USER_TOTAL'					=> '%d registado, ',
	'REG_USER_TOTAL_AND'				=> '%d registado e ',
	'REMOVE'							=> 'Remover',
	'REMOVE_INSTALL'					=> 'Apague, mova ou renomeie a diretoria de instalação.',
	'REPLIES'							=> 'Respostas',
	'REPLY_WITH_QUOTE'					=> 'Resposta com citações',
	'REPLYING_GLOBAL_ANNOUNCE'			=> 'A responder a Anúncio Global',
	'REPLYING_MESSAGE'					=> 'A responder a mensagem em %s',
	'REPORT_BY'							=> 'Denunciada por',
	'REPORT_POST'						=> 'Denunciar esta mensagem',
	'REPORTING_POST'					=> 'A denunciar Mensagem',
	'RESEND_ACTIVATION'					=> 'Reenviar email de Ativação',
	'RESET'								=> 'Reiniciar',
	'RESTORE_PERMISSIONS'				=> 'Restaurar Permissões',
	'RETURN_INDEX'						=> 'Clique %saqui%s para voltar ao Índice',
	'RETURN_FORUM'						=> 'Clique %saqui%s para voltar ao Fórum',
	'RETURN_PAGE'						=> 'Clique %saqui%s para voltar à página anterior',
	'RETURN_TOPIC'						=> 'Clique %saqui%s para voltar ao Tópico',
	'RETURN_TO'							=> 'Voltar para',
	'FEED'								=> 'Feed',
	'FEED_NEWS'							=> 'Novidades',
	'FEED_TOPICS_ACTIVE'				=> 'Tópicos ativos',
	'FEED_TOPICS_NEW'					=> 'Novos Tópicos',
	'RULES_ATTACH_CAN'					=> 'Enviar anexos: Permitido',
	'RULES_ATTACH_CANNOT'				=> 'Enviar anexos: Proibido',
	'RULES_DELETE_CAN'					=> 'Apagar Mensagens: Permitido',
	'RULES_DELETE_CANNOT'				=> 'Apagar Mensagens: Proibido',
	'RULES_DOWNLOAD_CAN'				=> 'Transferir anexos: Permitido',
	'RULES_DOWNLOAD_CANNOT'				=> 'Transferir anexos: Proibido',
	'RULES_EDIT_CAN'					=> 'Editar Mensagens: Permitido',
	'RULES_EDIT_CANNOT'					=> 'Editar Mensagens: Proibido',
	'RULES_LOCK_CAN'					=> 'Bloquear Tópicos: Permitido',
	'RULES_LOCK_CANNOT'					=> 'Bloquear Tópicos: Proibido',
	'RULES_POST_CAN'					=> 'Criar Tópicos: Permitido',
	'RULES_POST_CANNOT'					=> 'Criar Tópicos: Proibido',
	'RULES_REPLY_CAN'					=> 'Responder Tópicos: Permitido',
	'RULES_REPLY_CANNOT'				=> 'Responder Tópicos: Proibido',
	'RULES_VOTE_CAN'					=> 'Votar em votações: Permitido',
	'RULES_VOTE_CANNOT'					=> 'Votar em votações: Proibido',

	'SEARCH'							=> 'Pesquisar',
	'SEARCH_MINI'						=> 'Pesquisar…',
	'SEARCH_ADV'						=> 'Pesquisa avançada',
	'SEARCH_ADV_EXPLAIN'				=> 'Ver opções avançadas de pesquisa',
	'SEARCH_KEYWORDS'					=> 'Palavra-Chave',
	'SEARCHING_FORUMS'					=> 'Pesquisando nos Fóruns',
	'SEARCH_ACTIVE_TOPICS'				=> 'Ver Tópicos ativos',
	'SEARCH_FOR'						=> 'Pesquisar por',
	'SEARCH_FORUM'						=> 'Neste Fórum…',
	'SEARCH_NEW'						=> 'Ver Tópicos com mensagens novas',
	'SEARCH_POSTS_BY'					=> 'Pesquisar mensagens por',
	'SEARCH_SELF'						=> 'Ver as minhas Mensagens',
	'SEARCH_TOPIC'						=> 'Pesquisar neste Tópico…',
	'SEARCH_UNANSWERED'					=> 'Ver mensagens sem resposta',
	'SEARCH_UNREAD'						=> 'Ver mensagens por ler',
	'SEARCH_USER_POSTS'					=> 'Pesquisar mensagens dos utilizadores',
	'SECONDS'							=> 'Segundos',
	'SELECT'							=> 'Selecionar',
	'SELECT_ALL_CODE'					=> 'Selecionar todos',
	'SELECT_DESTINATION_FORUM'			=> 'Selecione o Fórum de destino',
	'SELECT_FORUM'						=> 'Selecione o Fórum',
	'SEND_EMAIL'						=> 'Correio eletrónico',				// Used for submit buttons
	'SEND_EMAIL_USER'					=> 'Enviar email a',            // Used as: {L_SEND_EMAIL_USER} {USERNAME} -> E-mail UserX
	'SEND_PRIVATE_MESSAGE'				=> 'Enviar Mensagem Privada',
	'SETTINGS'							=> 'Configurações',
	'SIGNATURE'							=> 'Assinatura',
	'SKIP'								=> 'Ir para o conteúdo',
	'SMTP_NO_AUTH_SUPPORT'				=> 'O Servidor SMTP não suporta autenticação.',
	'SORRY_AUTH_READ'					=> 'Não está autorizado a ver este Fórum.',
	'SORRY_AUTH_VIEW_ATTACH'			=> 'Não está autorizado a transferir este anexo.',
	'SORT_BY'							=> 'Ordenar por',
	'SORT_JOINED'						=> 'Data de Registo',
	'SORT_LOCATION'						=> 'Localização',
	'SORT_RANK'							=> 'Classificação',
	'SORT_POSTS'						=> 'Mensagens',
	'SORT_TOPIC_TITLE'					=> 'Título do Tópico',
	'SORT_USERNAME'						=> 'Utilizador',
	'SPLIT_TOPIC'						=> 'Dividir Tópico',
	'SQL_ERROR_OCCURRED'				=> 'Ocorreu um erro SQL enquanto esta página era processada. Contate um %sAdministrador do Fórum%s se o problema persistir',
	'STATISTICS'						=> 'Estatísticas do Fórum:',
	'START_WATCHING_FORUM'				=> 'Observar Fórum',
	'START_WATCHING_TOPIC'				=> 'Observar Tópico',
	'STOP_WATCHING_FORUM'				=> 'Parar de Observar Fórum',
	'STOP_WATCHING_TOPIC'				=> 'Parar de Observar Tópico',
	'SUBFORUM'							=> 'Subfórum',
	'SUBFORUMS'							=> 'Subfóruns',
	'SUBJECT'							=> 'Assunto',
	'SUBMIT'							=> 'Enviar',

	'TB'								=> 'TB',

	'TERMS_USE'							=> 'Condições de utilização',
	'TEST_CONNECTION'					=> 'Testar Ligação',
	'THE_TEAM'							=> 'Equipa',
	'TIB'								=> 'TiB',
	'TIME'								=> 'Data',

	'TOO_LARGE'							=> 'O valor que inseriu é muito grande.',
    'TOO_LARGE_MAX_RECIPIENTS'			=> 'O valor do configurado para o <strong>número máximo de destinatários permitidos por Mensagem Privada</strong> é muito grande.',

	'TOO_LONG'							=> 'O valor definido é muito longo.',

	'TOO_LONG_AIM'						=> 'O nome de Utilizador do AIM indicado é muito curto.',
	'TOO_LONG_CONFIRM_CODE'				=> 'O código de confirmação indicado é muito curto.',
	'TOO_LONG_DATEFORMAT'				=> 'O formato da data indicada é muito longa.',
	'TOO_LONG_ICQ'						=> 'O número ICQ indicado é muito curto.',
	'TOO_LONG_INTERESTS'				=> 'Os interesses indicados são muito curtos.',
	'TOO_LONG_JABBER'					=> 'A nome da conta Jabber indicada é muito longa.',
	'TOO_LONG_LOCATION'					=> 'A localização indicada é muito longa.',
	'TOO_LONG_MSN'						=> 'O nome MSN/WLM indicado é muito curto.',
	'TOO_LONG_NEW_PASSWORD'				=> 'A Senha indicada é muito longa.',
	'TOO_LONG_OCCUPATION'				=> 'A ocupação indicada é muito longa.',
	'TOO_LONG_PASSWORD_CONFIRM'			=> 'A confirmação da Senha indicada é muito longa.',
	'TOO_LONG_USER_PASSWORD'			=> 'A Senha é muito longa.',
	'TOO_LONG_USERNAME'					=> 'O nome de Utilizador indicado é muito curto.',
	'TOO_LONG_EMAIL'					=> 'O endereço de email indicado é muito curto.',
	'TOO_LONG_EMAIL_CONFIRM'			=> 'A confirmação do endereço de email indicada é muito longa.',
	'TOO_LONG_WEBSITE'					=> 'O endereço do sítio web indicado é muito curto.',
	'TOO_LONG_YIM'						=> 'O nome do Yahoo! Messenger indicado é muito curto.',

	'TOO_MANY_VOTE_OPTIONS'				=> 'Escolheu muitas opções.',

	'TOO_SHORT'							=> 'O valor definido é muito curto.',

	'TOO_SHORT_AIM'						=> 'O nome de utilizador AIM indicado é muito curto.',
	'TOO_SHORT_CONFIRM_CODE'			=> 'O Código de Confirmação indicado é muito curto.',
	'TOO_SHORT_DATEFORMAT'				=> 'O formato da data indicada é muito curta.',
	'TOO_SHORT_ICQ'						=> 'O número ICQ indicado é muito curto.',
	'TOO_SHORT_INTERESTS'				=> 'Os interesses indicados são muito curtos.',
	'TOO_SHORT_JABBER'					=> 'O nome da conta Jabber indicado é muito curto.',
	'TOO_SHORT_LOCATION'				=> 'A localização indicada é muito curta.',
	'TOO_SHORT_MSN'						=> 'O nome MSNM/WLM indicado é muito curto.',
	'TOO_SHORT_NEW_PASSWORD'			=> 'A senha é muito curta.',
	'TOO_SHORT_OCCUPATION'				=> 'A ocupação indicada é muito curta.',
	'TOO_SHORT_PASSWORD_CONFIRM'		=> 'A confirmação da senha é muito curta.',
	'TOO_SHORT_USER_PASSWORD'			=> 'A senha é muito curta.',
	'TOO_SHORT_USERNAME'				=> 'O nome de utilizador é muito curto.',
	'TOO_SHORT_EMAIL'					=> 'O endereço de email é muito curto.',
	'TOO_SHORT_EMAIL_CONFIRM'			=> 'A confirmação do endereço de email é muito curta.',
	'TOO_SHORT_WEBSITE'					=> 'O endereço do sítio web indicado é muito curto.',
	'TOO_SHORT_YIM'						=> 'O nome do Yahoo! Messenger indicado é muito curto.',

	'TOO_SMALL'							=> 'O valor que inseriu é muito pequeno.',
	'TOO_SMALL_MAX_RECIPIENTS'			=> 'O valor do configurado para o <strong>número máximo de destinatários permitidos por Mensagem Privada</strong> é muito pequeno.',

	'TOPIC'								=> 'Tópico',
	'TOPICS'							=> 'Tópicos',
	'TOPICS_UNAPPROVED'					=> 'Pelo menos um Tópico neste Fórum ainda não foi aprovado.',
	'TOPIC_ICON'						=> 'Ícone do Tópico',
	'TOPIC_LOCKED'						=> 'Este Tópico está bloqueado. Não pode editar mensagens ou responder.',
	'TOPIC_LOCKED_SHORT'				=> 'Tópico Bloqueado',
	'TOPIC_MOVED'						=> 'Tópico Movido',
	'TOPIC_REVIEW'						=> 'Rever o Tópico',
	'TOPIC_TITLE'						=> 'Título do Tópico',
	'TOPIC_UNAPPROVED'					=> 'Este Tópico não foi aprovado',
	'TOTAL_ATTACHMENTS'					=> 'Anexo(s)',
	'TOTAL_LOG'							=> '1 registo',
	'TOTAL_LOGS'						=> '%d registos',
	'TOTAL_NO_PM'						=> 'Sem Mensagens Privadas',
	'TOTAL_PM'							=> '1 Mensagem Privada no total',
	'TOTAL_PMS'							=> 'Tem um total de %d Mensagens Privadas',
	'TOTAL_POSTS'						=> 'Total de Mensagens',
	'TOTAL_POSTS_OTHER'					=> 'Total de Mensagens %d',
	'TOTAL_POSTS_ZERO'					=> 'Total de Mensagens 0',
	'TOPIC_REPORTED'					=> 'Este Tópico foi reportado com sucesso',
	'TOTAL_TOPICS_OTHER'				=> 'Total de Tópicos %d',
	'TOTAL_TOPICS_ZERO'					=> 'Total de Tópicos 0',
	'TOTAL_USERS_OTHER'					=> 'Total de Utilizadores %d',
	'TOTAL_USERS_ZERO'					=> 'Total de Utilizadores 0',
	'TRACKED_PHP_ERROR'					=> 'Erros PHP encontrados: %s',

	'UNABLE_GET_IMAGE_SIZE'				=> 'Não foi possível determinar as dimensões da imagem. Por favor verifique se o URL que inseriu está correto.',
	'UNABLE_TO_DELIVER_FILE'			=> 'Incapaz de entregar Ficheiro.',
	'UNKNOWN_BROWSER'					=> 'Navegador Desconhecido',
	'UNMARK_ALL'						=> 'Desmarcar todos',
	'UNREAD_MESSAGES'					=> 'Mensagens não lidas',
	'UNREAD_PM'							=> '%d mensagem não lida',
	'UNREAD_PMS'						=> '%d mensagens não lidas',
	'UNREAD_POST'						=> 'Mensagem não lida',
	'UNREAD_POSTS'						=> 'Mensagens não lidas',
	'UNWATCH_FORUM_CONFIRM'				=> 'Tem certeza que deseja cancelar a assinatura deste fórum?',
	'UNWATCH_FORUM_DETAILED'			=> 'Tem certeza que deseja cancelar a assinatura do fórum “%s”?',
	'UNWATCH_TOPIC_CONFIRM'				=> 'Tem certeza que deseja cancelar a assinatura deste Tópico?',
	'UNWATCH_TOPIC_DETAILED'			=> 'Tem certeza que deseja cancelar a assinatura do Tópico “%s”?',
	'UNWATCHED_FORUMS'					=> 'Já não se encontra a observar este Fórum.',
	'UNWATCHED_TOPICS'					=> 'Já não se encontra a observar este Tópico.',
	'UNWATCHED_FORUMS_TOPICS'			=> 'Já não se encontra a observar as entradas selecionadas.',
	'UPDATE'							=> 'Atualizar',
	'UPLOAD_IN_PROGRESS'				=> 'O envio está em progresso.',
	'URL_REDIRECT'						=> 'Se o seu navegador não suporta redirecionamentos, %sPor Favor, clique aqui para ser redirecionado%s.',
	'USERGROUPS'						=> 'Grupos',
	'USERNAME'							=> 'Utilizador',
	'USERNAMES'							=> 'Utilizadores',
	'USER_AVATAR'						=> 'Avatar do Utilizador',
	'USER_CANNOT_READ'					=> 'Não pode ler mensagens neste Fórum.',
	'USER_POST'							=> '%d Mensagem',
	'USER_POSTS'						=> '%d Mensagens',
	'USERS'								=> 'Utilizadores',
	'USE_PERMISSIONS'					=> 'Testar permissões do utilizador',

	'USER_NEW_PERMISSION_DISALLOWED'	=> 'Pedimos desculpa, mas não está autorizado a utilizar este recurso. Pode ter que estar registado e ter que participar mais para usar este recurso.',

	'VARIANT_DATE_SEPARATOR'			=> ' / ',
	'VIEWED'							=> 'Visto',
	'VIEWING_FAQ'						=> 'A ver a FAQ',
	'VIEWING_MEMBERS'					=> 'A Ver detalhes dos Utilizadores',
	'VIEWING_ONLINE'					=> 'A Ver quem está online',
	'VIEWING_MCP'						=> 'A Ver Painel de Moderação',
	'VIEWING_MEMBER_PROFILE'			=> 'A Ver Perfil dos Utilizadores',
	'VIEWING_PRIVATE_MESSAGES'			=> 'A Ver Mensagens Privadas',
	'VIEWING_REGISTER'					=> 'Registar uma nova conta',
	'VIEWING_UCP'						=> 'A Ver o Painel de Controlo do Utilizador',
	'VIEWS'								=> 'Visualizações',
	'VIEW_BOOKMARKS'					=> 'Ver Favoritos',
	'VIEW_FORUM_LOGS'					=> 'Ver registos',
	'VIEW_LATEST_POST'					=> 'Veja a última Mensagem',
	'VIEW_NEWEST_POST'					=> 'A ver Mensagens Novas',
	'VIEW_NOTES'						=> 'Ver Notas do Utilizador',
	'VIEW_ONLINE_TIME'					=> 'Informação relativa aos utilizadores ativos no último %d minuto',
	'VIEW_ONLINE_TIMES'					=> 'Informação relativa aos utilizadores ativos nos últimos %d minutos',
	'VIEW_TOPIC'						=> 'Ver Tópico',
	'VIEW_TOPIC_ANNOUNCEMENT'			=> 'Anúncio: ',
	'VIEW_TOPIC_GLOBAL'					=> 'Anúncio Global: ',
	'VIEW_TOPIC_LOCKED'					=> 'Bloqueado: ',
	'VIEW_TOPIC_LOGS'					=> 'Ver registos',
	'VIEW_TOPIC_MOVED'					=> 'Movido: ',
	'VIEW_TOPIC_POLL'					=> 'Votação: ',
	'VIEW_TOPIC_STICKY'					=> 'Fixo: ',
	'VISIT_WEBSITE'						=> 'Visitar o sítio web',

	'WARNINGS'							=> 'Avisos',
	'WARN_USER'							=> 'Avisar Utilizador',
	'WATCH_FORUM_CONFIRM'				=> 'Tem certeza que deseja subscrever este Fórum?',
	'WATCH_FORUM_DETAILED'				=> 'Tem certeza que deseja subscrever o Fórum “%s”?',
	'WATCH_TOPIC_CONFIRM'				=> 'Tem certeza que deseja subscrever este Tópico?',
	'WATCH_TOPIC_DETAILED'				=> 'Tem certeza que deseja subscrever o Tópico “%s”?',
	'WELCOME_SUBJECT'					=> 'Bem vindo ao Fórum %s',
	'WEBSITE'							=> 'Sítio web',
	'WHOIS'								=> 'Quem',
	'WHO_IS_ONLINE'						=> 'Quem está ligado:',
	'WRONG_PASSWORD'					=> 'Senha errada.',
	'WRONG_DATA_COLOUR'					=> 'O valor da cor digitado é inválido.',

	'WRONG_DATA_ICQ'					=> 'O número ICQ indicado não é válido.',
	'WRONG_DATA_JABBER'					=> 'O nome indicado não é um nome de conta Jabber válido.',
	'WRONG_DATA_LANG'					=> 'A linguagem indicada não é válida.',
	'WRONG_DATA_WEBSITE'				=> 'O endereço do sítio web indicado não é uma URL válida, incluindo o protocolo. Por exemplo http://www.exemplo.com/.',
	'WROTE'								=> 'Escreveu',

	'YEAR'								=> 'Ano',
	'YEAR_MONTH_DAY'					=> '(DD-MM-YYYY)',
	'YES'								=> 'Sim',
	'YIM'								=> 'YIM',
	'YOU_LAST_VISIT'					=> 'Última visita: %s',
	'YOU_NEW_PM'						=> 'Tem uma Mensagem Privada nova.',
	'YOU_NEW_PMS'						=> 'Tem Mensagens Privadas novas.',
	'YOU_NO_NEW_PM'						=> 'Não tem Mensagens Privadas novas.',

	'datetime'			=> array(
		'TODAY'		=> 'Hoje',
		'TOMORROW'	=> 'Amanhã',
		'YESTERDAY'	=> 'Ontem',
		'AGO'		=> array(
			0		=> 'Há menos de 1 minuto',
			1		=> 'Há %d minute atrás',
			2		=> 'Há %d minutos atrás',
			60		=> 'Há 1 hota atrás',
		),
		
		'Sunday'						=> 'domingo',
		'Monday'						=> 'segunda-feira',
		'Tuesday'						=> 'terça-feira',
		'Wednesday'						=> 'quarta-feira',
		'Thursday'						=> 'quinta-feira',
		'Friday'						=> 'sexta-feira',
		'Saturday'						=> 'sábado',

		'Sun'							=> 'domingo',
		'Mon'							=> 'segunda',
		'Tue'							=> 'terça',
		'Wed'							=> 'quarta',
		'Thu'							=> 'quinta',
		'Fri'							=> 'sexta',
		'Sat'							=> 'sábado',

		'January'						=> 'janeiro',
		'February'						=> 'fevereiro',
		'March'							=> 'março',
		'April'							=> 'abril',
		'May'							=> 'maio',
		'June'							=> 'junho',
		'July'							=> 'julho',
		'August'						=> 'agosto',
		'September'						=> 'setembro',
		'October'						=> 'outubro',
		'November'						=> 'novembro',
		'December'						=> 'dezembro',

		'Jan'							=> 'jan',
		'Feb'							=> 'fev',
		'Mar'							=> 'mar',
		'Apr'							=> 'abr',
		'May_short'						=> 'mai',	// Short representation of "May". May_short used because in english the short and long date are the same for May.		 
		'Jun'							=> 'jun',
		'Jul'							=> 'jul',
		'Aug'							=> 'ago',
		'Sep'							=> 'set',
		'Oct'							=> 'out',
		'Nov'							=> 'nov',
		'Dec'							=> 'dez',
	),

	'tz'								=> array(
		'-12'							=> 'TMG - 12 Horas',
		'-11'							=> 'TMG - 11 Horas',
		'-10'							=> 'TMG - 10 Horas',
		'-9.5'							=> 'TMG - 9:30 Horas',
		'-9'							=> 'TMG - 9 Horas',
		'-8'							=> 'TMG - 8 Horas',
		'-7'							=> 'TMG - 7 Horas',
		'-6'							=> 'TMG - 6 Horas',
		'-5'							=> 'TMG - 5 Horas',
		'-4.5'							=> 'TMG - 4.5 horas',
		'-4'							=> 'TMG - 4 Horas',
		'-3.5'							=> 'TMG - 3.5 Horas',
		'-3'							=> 'TMG - 3 Horas',
		'-2'							=> 'TMG - 2 Horas',
		'-1'							=> 'TMG - 1 Hora',
		'0'								=> 'TMG',
		'1'								=> 'TMG + 1 Hora',
		'2'								=> 'TMG + 2 Horas',
		'3'								=> 'TMG + 3 Horas',
		'3.5'							=> 'TMG + 3:30 Horas',
		'4'								=> 'TMG + 4 Horas',
		'4.5'							=> 'TMG + 4:30 Horas',
		'5'								=> 'TMG + 5 Horas',
		'5.5'							=> 'TMG + 5:30 Horas',
		'5.75'							=> 'TMG + 5:45 Horas',
		'6'								=> 'TMG + 6 Horas',
		'6.5'							=> 'TMG + 6:30 Horas',
		'7'								=> 'TMG + 7 Horas',
		'8'								=> 'TMG + 8 Horas',
		'8.75'							=> 'TMG + 8:45 Horas',
		'9'								=> 'TMG + 9 Horas',
		'9.5'							=> 'TMG + 9:30 Horas',
		'10'							=> 'TMG + 10 Horas',
		'10.5'							=> 'TMG + 10:30 Horas',
		'11'							=> 'TMG + 11 Horas',
		'11.5'							=> 'TMG + 11:30 Horas',
		'12'							=> 'TMG + 12 Horas',
		'12.75'							=> 'TMG + 12:45 Horas',
		'13'							=> 'TMG + 13 Horas',
		'14'							=> 'TMG + 14 Horas',
		'dst'	=> '[ <abbr title="Horário de Verão ativo">DST</abbr> ]',
	),

	'tz_zones'                     	=> array(
		'-12'                     	=> '[TMG-12] Eniwetok, Kwajalein',
        '-11'                    	=> '[TMG-11] Atol de Midway, Samoa',
        '-10'                    	=> '[TMG-10] Havai, Honolulu',
		'-9.5'						=> '[TMG - 9:30] Marquesas Islands Time',
        '-9'                     	=> '[TMG-9] Alasca',
        '-8'                     	=> '[TMG-8] Anchorage, Los Angeles, São Francisco, Seattle',
        '-7'                     	=> '[TMG-7] Denver, Edmonton, Phoenix, Salt Lake City, Santa Fé',
        '-6'                     	=> '[TMG-6] Chicago, Guatemala, Cidade do México, Saskatchewan Este',
        '-5'                    	=> '[TMG-5] Bogotá, Kingston, Lima, Nova Iorque',
        '-4.5'                     	=> '[TMG-4.5] Venezuela',
        '-4'                    	=> '[TMG-4] Caracas, Labrador, La Paz, Províncias Marítimas, Santiago',
        '-3.5'                    	=> '[TMG-3.5] Horário Padrão [Canadá], Terra Nova e Labrador',
        '-3'                    	=> '[TMG-3] Brasília, Buenos Aires, Georgetown, Rio de Janeiro, São Paulo',
        '-2'                     	=> '[TMG-2] Atlântico Centro',
        '-1'                    	=> '[TMG-1] Açores, Arq. Cabo Verde',
        '0'                        	=> '[TMG] Dublin, Edimburgo, Islândia, Lisboa, Londres, Casablanca',
        '1'                      	=> '[TMG+1] Alkmaar, Amesterdão, Berlim, Berna, Bruxelas, Madrid, Paris, Roma, Roterdão, Oslo, Viena',
        '2'                       	=> '[TMG+2] Atenas, Bucareste, Harare, Helsínquia, Israel, Istambul',
        '3'                     	=> '[TMG+3] Ankara, Bagdade, Bahrein, Beirute, Kuwait, Moscovo, Nairóbi, Riyadh',
        '3.5'                     	=> '[TMG+3.5] Irão',
        '4'                        	=> '[TMG+4] Abu Dhabi, Cabul, Mascate, Tbilisi, Volgogrado',
        '4.5'                     	=> '[TMG+4.5] Afeganistão',
        '5'                        	=> '[TMG+5] Calcutá, Madras, Nova Deli',
        '5.5'                     	=> '[TMG+5.5] Índia',
		'5.75'						=> '[TMG + 5:45] Nepal Time',
        '6'                        	=> '[TMG+6] Almaty, Dhakar, Catmandu',
        '6.5'                     	=> '[TMG+6.5] Rangum',
        '7'                        	=> '[TMG+7] Banguecoque, Hanói, Jacarta, Phnom Penh',
        '8'                        	=> '[TMG+8] Pequim, Hong Kong, Kuala Lumpur, Manila, Perth, Singapura, Taipei',
		'8.75'						=> '[TMG + 8:45] Southeastern Western Australia Standard Time',
        '9'                        	=> '[TMG+9] Mijn, Osaka, Sapporo, Seul, Tóquio, Yakutsk',
        '9.5'                     	=> '[TMG+9.5] Adelaide, Darwin',
        '10'                     	=> '[TMG+10] Brisbane, Camberra, Guam, Hobart, Melbourne, Porto Moresby, Sydney, Vertaal',
		'10.5'						=> '[TMG + 10:30] Lord Howe Standard Time',
        '11'                     	=> '[TMG+11] Magadan, Nova Caledónia, Ilhas Salomão',
		'11.5'						=> '[TMG + 11:30] Norfolk Island Time',
        '12'                     	=> '[TMG+12] Auckland, Gemak, Fiji, Kamchatka, Ilhas Marshall, Suva, Wellington',
		'12.75'						=> '[TMG + 12:45] Chatham Islands Time',
		'13'						=> '[TMG + 13] Tonga Time, Phoenix Islands Time',
		'14'						=> '[TMG + 14] Line Island Time',
       ),

	// The value is only an example and will get replaced by the current time on view 
	'dateformats'						=> array( 
		'd M Y, H:i'					=> '01 Jan 2008, 17:37',
		'd M Y H:i'						=> '01 Jan 2008 17:37',
		'M jS, \'y, H:i'				=> 'Jan 1st, \'07, 17:37',
		'D M d, Y g:i a'				=> 'Seg Jan 01, 2008 5:37 pm',
		'F jS, Y, g:i a'				=> 'Janeiro 1st, 2008, 5:37 pm',
		'|d M Y|, H:i'					=> 'Hoje, 17:37 / 01 Jan 2008, 17:37',
		'|F jS, Y|, g:i a'				=> 'Hoje, 5:37 pm / Janeiro 1st, 2008, 5:37 pm'
	), 

	// The default dateformat which will be used on new installs in this language 
	// Translators should change this if a the usual date format is different 
	'default_dateformat'				=> 'd/M/Y, H:i', // 20/Abr/2009, 09:17
	
));

?>