# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.eventhub import EventHubManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestEventHubManagementDisasterRecoveryConfigsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(EventHubManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_disaster_recovery_configs_list_authorization_rules(self, resource_group):
        response = self.client.disaster_recovery_configs.list_authorization_rules(
            resource_group_name=resource_group.name,
            namespace_name="str",
            alias="str",
            api_version="2024-01-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_disaster_recovery_configs_get_authorization_rule(self, resource_group):
        response = self.client.disaster_recovery_configs.get_authorization_rule(
            resource_group_name=resource_group.name,
            namespace_name="str",
            alias="str",
            authorization_rule_name="str",
            api_version="2024-01-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_disaster_recovery_configs_list_keys(self, resource_group):
        response = self.client.disaster_recovery_configs.list_keys(
            resource_group_name=resource_group.name,
            namespace_name="str",
            alias="str",
            authorization_rule_name="str",
            api_version="2024-01-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_disaster_recovery_configs_check_name_availability(self, resource_group):
        response = self.client.disaster_recovery_configs.check_name_availability(
            resource_group_name=resource_group.name,
            namespace_name="str",
            parameters={"name": "str"},
            api_version="2024-01-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_disaster_recovery_configs_list(self, resource_group):
        response = self.client.disaster_recovery_configs.list(
            resource_group_name=resource_group.name,
            namespace_name="str",
            api_version="2024-01-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_disaster_recovery_configs_create_or_update(self, resource_group):
        response = self.client.disaster_recovery_configs.create_or_update(
            resource_group_name=resource_group.name,
            namespace_name="str",
            alias="str",
            parameters={
                "alternateName": "str",
                "id": "str",
                "location": "str",
                "name": "str",
                "partnerNamespace": "str",
                "pendingReplicationOperationsCount": 0,
                "provisioningState": "str",
                "role": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
            api_version="2024-01-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_disaster_recovery_configs_delete(self, resource_group):
        response = self.client.disaster_recovery_configs.delete(
            resource_group_name=resource_group.name,
            namespace_name="str",
            alias="str",
            api_version="2024-01-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_disaster_recovery_configs_get(self, resource_group):
        response = self.client.disaster_recovery_configs.get(
            resource_group_name=resource_group.name,
            namespace_name="str",
            alias="str",
            api_version="2024-01-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_disaster_recovery_configs_break_pairing(self, resource_group):
        response = self.client.disaster_recovery_configs.break_pairing(
            resource_group_name=resource_group.name,
            namespace_name="str",
            alias="str",
            api_version="2024-01-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_disaster_recovery_configs_fail_over(self, resource_group):
        response = self.client.disaster_recovery_configs.fail_over(
            resource_group_name=resource_group.name,
            namespace_name="str",
            alias="str",
            api_version="2024-01-01",
        )

        # please add some check logic here by yourself
        # ...
