// Copyright (C) 2020 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR LGPL-3.0-only OR GPL-2.0-only OR GPL-3.0-only

#include "qhelplink.h"

/*!
    \class QHelpLink
    \since 5.15
    \inmodule QtHelp
    \brief The QHelpLink struct provides the data associated with a help link.

    The QHelpLink object is a data object that describes a link to a documentation file.
    The description of the help link contains the document title and URL of the document.
    \sa QHelpEngineCore
*/

/*!
    \variable QHelpLink::url
    \brief The target url of the link.
*/
/*!
    \variable QHelpLink::title
    \brief The title of the link.
*/
