% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edge_direction.R
\name{guide_edge_direction}
\alias{guide_edge_direction}
\title{Edge direction guide}
\usage{
guide_edge_direction(
  title = waiver(),
  title.position = NULL,
  title.theme = NULL,
  title.hjust = NULL,
  title.vjust = NULL,
  arrow = TRUE,
  arrow.position = NULL,
  barwidth = NULL,
  barheight = NULL,
  nbin = 500,
  direction = NULL,
  default.unit = "line",
  reverse = FALSE,
  order = 0,
  override.aes = list(),
  ...
)
}
\arguments{
\item{title}{A character string or expression indicating a title of guide.
If \code{NULL}, the title is not shown. By default
(\code{\link[ggplot2:waiver]{waiver()}}), the name of the scale object or the name
specified in \code{\link[ggplot2:labs]{labs()}} is used for the title.}

\item{title.position}{A character string indicating the position of a
title. One of "top" (default for a vertical guide), "bottom", "left"
(default for a horizontal guide), or "right."}

\item{title.theme}{A theme object for rendering the title text. Usually the
object of \code{\link[ggplot2:element_text]{element_text()}} is expected. By default, the theme is
specified by \code{legend.title} in \code{\link[ggplot2:theme]{theme()}} or theme.}

\item{title.hjust}{A number specifying horizontal justification of the
title text.}

\item{title.vjust}{A number specifying vertical justification of the title
text.}

\item{arrow}{Logical. Should an arrow be drawn to illustrate the direction.
Defaults to \code{TRUE}}

\item{arrow.position}{The position of the arrow relative to the example edge.}

\item{barwidth}{A numeric or a \code{\link[grid:unit]{grid::unit()}} object specifying
the width of the colourbar. Default value is \code{legend.key.width} or
\code{legend.key.size} in \code{\link[ggplot2:theme]{theme()}} or theme.}

\item{barheight}{A numeric or a \code{\link[grid:unit]{grid::unit()}} object specifying
the height of the colourbar. Default value is \code{legend.key.height} or
\code{legend.key.size} in \code{\link[ggplot2:theme]{theme()}} or theme.}

\item{nbin}{A numeric specifying the number of bins for drawing the
colourbar. A smoother colourbar results from a larger value.}

\item{direction}{A character string indicating the direction of the guide.
One of "horizontal" or "vertical."}

\item{default.unit}{A character string indicating \code{\link[grid:unit]{grid::unit()}}
for \code{barwidth} and \code{barheight}.}

\item{reverse}{logical. If \code{TRUE} the colourbar is reversed. By default,
the highest value is on the top and the lowest value is on the bottom}

\item{order}{positive integer less than 99 that specifies the order of
this guide among multiple guides. This controls the order in which
multiple guides are displayed, not the contents of the guide itself.
If 0 (default), the order is determined by a secret algorithm.}

\item{override.aes}{A list specifying aesthetic parameters of legend key.}

\item{...}{ignored.}
}
\description{
This guide is intended to show the direction of edges based on the aesthetics
mapped to its progression, such as changing width, colour and opacity.
}
\examples{
gr <- tidygraph::as_tbl_graph(highschool)
ggraph(gr, layout = 'kk') +
  geom_edge_fan(aes(alpha = stat(index))) +
  guides(edge_alpha = guide_edge_direction())
}
