% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{setFooter}
\alias{setFooter}
\title{Set footer for all worksheets}
\usage{
setFooter(wb, text, position = "center")
}
\arguments{
\item{wb}{A workbook object}

\item{text}{footer text. A character vector of length 1.}

\item{position}{Position of text in footer. One of "left", "center" or "right"}
}
\description{
DEPRECATED
}
\examples{
\dontrun{
wb <- createWorkbook("Edgar Anderson")
addWorksheet(wb, "S1")
writeDataTable(wb, "S1", x = iris[1:30,], xy = c("C", 5))

## set all headers
setHeader(wb, "This is a header", position="center")
setHeader(wb, "To the left", position="left")
setHeader(wb, "On the right", position="right")

## set all footers
setFooter(wb, "Center Footer Here", position="center")
setFooter(wb, "Bottom left", position="left")
setFooter(wb, Sys.Date(), position="right")

\dontrun{saveWorkbook(wb, "headerFooterExample.xlsx", overwrite = TRUE)}
}
}
\author{
Alexander Walker
}
