% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polyCub.R
\name{polyCub}
\alias{polyCub}
\title{Wrapper Function for the Various Cubature Methods}
\usage{
polyCub(polyregion, f, method = c("SV", "midpoint", "iso", "exact.Gauss"),
  ..., plot = FALSE)
}
\arguments{
\item{polyregion}{a polygonal domain.
The following classes are supported:
\code{"\link[spatstat.geom]{owin}"} from package \pkg{spatstat.geom},
\code{"gpc.poly"} from \pkg{gpclib},
\code{"\linkS4class{SpatialPolygons}"}, \code{"\linkS4class{Polygons}"},
and \code{"\linkS4class{Polygon}"} from package \pkg{sp}, as well as
\code{"\link[sf:st_polygon]{(MULTI)POLYGON}"} from package \pkg{sf}.
(For these classes, \pkg{polyCub} knows how to get an \code{\link{xylist}}.)}

\item{f}{a two-dimensional real-valued function to be integrated over
\code{polyregion}. As its first argument it must take a coordinate matrix,
i.e., a numeric matrix with two columns, and it must return a numeric vector
of length the number of coordinates.\cr
For the \code{"exact.Gauss"} \code{method},
\code{f} is ignored since it is specific to the bivariate normal density.}

\item{method}{choose one of the implemented cubature methods (partial
argument matching is applied), see \code{help("\link{polyCub-package}")}
for an overview. Defaults to using product Gauss cubature
implemented in \code{\link{polyCub.SV}}.}

\item{...}{arguments of \code{f} or of the specific \code{method}.}

\item{plot}{logical indicating if an illustrative plot of the numerical
integration should be produced.}
}
\value{
The approximated integral of \code{f} over \code{polyregion}.
}
\description{
The wrapper function \code{polyCub} can be used to call specific cubature
methods via its \code{method} argument. It calls \code{\link{polyCub.SV}}
by default, which implements general-purpose product Gauss cubature.
}
\seealso{
Details and examples in the \code{vignette("polyCub")}
and on the method-specific help pages.

Other polyCub-methods: 
\code{\link{polyCub.SV}()},
\code{\link{polyCub.exact.Gauss}()},
\code{\link{polyCub.iso}()},
\code{\link{polyCub.midpoint}()}
}
\concept{polyCub-methods}
\keyword{math}
\keyword{spatial}
