% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{py_install}
\alias{py_install}
\title{Install Python packages}
\usage{
py_install(
  packages,
  envname = NULL,
  method = c("auto", "virtualenv", "conda"),
  conda = "auto",
  python_version = NULL,
  pip = FALSE,
  ...
)
}
\arguments{
\item{packages}{A vector of Python packages to install.}

\item{envname}{The name, or full path, of the environment in which Python
packages are to be installed. When \code{NULL} (the default), the active
environment as set by the \code{RETICULATE_PYTHON_ENV} variable will be used;
if that is unset, then the \code{r-reticulate} environment will be used.}

\item{method}{Installation method. By default, "auto" automatically finds a
method that will work in the local environment. Change the default to force
a specific installation method. Note that the "virtualenv" method is not
available on Windows.}

\item{conda}{Path to conda executable (or "auto" to find conda using the
PATH and other conventional install locations).}

\item{python_version}{The requested Python version. Ignored when attempting
to install with a Python virtual environment.}

\item{pip}{Boolean; use \code{pip} for package installation? This is only relevant
when Conda environments are used, as otherwise packages will be installed
from the Conda repositories.}

\item{...}{Additional arguments passed to \code{\link[=conda_install]{conda_install()}}
or \code{\link[=virtualenv_install]{virtualenv_install()}}.}
}
\description{
Install Python packages into a virtual environment or Conda environment.
}
\details{
On Linux and OS X the "virtualenv" method will be used by default
("conda" will be used if virtualenv isn't available). On Windows, the
"conda" method is always used.
}
\seealso{
\link{conda-tools}, \link{virtualenv-tools}
}
