% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_locate_bound.R
\name{stri_locate_all_boundaries}
\alias{stri_locate_all_boundaries}
\alias{stri_locate_last_boundaries}
\alias{stri_locate_first_boundaries}
\alias{stri_locate_all_words}
\alias{stri_locate_last_words}
\alias{stri_locate_first_words}
\title{Locate Text Boundaries}
\usage{
stri_locate_all_boundaries(
  str,
  omit_no_match = FALSE,
  get_length = FALSE,
  ...,
  opts_brkiter = NULL
)

stri_locate_last_boundaries(str, get_length = FALSE, ..., opts_brkiter = NULL)

stri_locate_first_boundaries(str, get_length = FALSE, ..., opts_brkiter = NULL)

stri_locate_all_words(
  str,
  omit_no_match = FALSE,
  locale = NULL,
  get_length = FALSE
)

stri_locate_last_words(str, locale = NULL, get_length = FALSE)

stri_locate_first_words(str, locale = NULL, get_length = FALSE)
}
\arguments{
\item{str}{character vector or an object coercible to}

\item{omit_no_match}{single logical value; if \code{TRUE},
a no-match will be indicated by a matrix with 0 rows
\code{stri_locate_all_*} only}

\item{get_length}{single logical value; if \code{FALSE} (default),
generate \emph{from-to} matrices; otherwise, output
\emph{from-length} ones}

\item{...}{additional settings for \code{opts_brkiter}}

\item{opts_brkiter}{named list with \pkg{ICU} BreakIterator's settings,
see \code{\link{stri_opts_brkiter}};
\code{NULL} for default break iterator, i.e., \code{line_break}}

\item{locale}{\code{NULL} or \code{''} for text boundary analysis following
the conventions of the default locale, or a single string with
locale identifier, see \link{stringi-locale}}
}
\value{
\code{stri_locate_all_*} yields a list of \code{length(str)}
integer matrices.
\code{stri_locate_first_*} and \code{stri_locate_last_*} generate
return an integer matrix.
See \code{\link{stri_locate}} for more details.
}
\description{
These functions locate text boundaries
(like character, word, line, or sentence boundaries).
Use \code{stri_locate_all_*} to locate all the matches.
\code{stri_locate_first_*} and \code{stri_locate_last_*}
give the first or the last matches, respectively.
}
\details{
Vectorized over \code{str}.

For more information on text boundary analysis
performed by \pkg{ICU}'s \code{BreakIterator}, see
\link{stringi-search-boundaries}.

For \code{stri_locate_*_words},
just like in \code{\link{stri_extract_all_words}} and \code{\link{stri_count_words}},
\pkg{ICU}'s word \code{BreakIterator} iterator is used
to locate the word boundaries, and all non-word characters
(\code{UBRK_WORD_NONE} rule status) are ignored.
This function is equivalent to a call to
\code{stri_locate_*_boundaries(str, type='word', skip_word_none=TRUE, locale=locale)}
}
\examples{
test <- 'The\u00a0above-mentioned    features are very useful. Spam, spam, eggs, bacon, and spam.'
stri_locate_all_words(test)
stri_locate_all_boundaries(
    'Mr. Jones and Mrs. Brown are very happy. So am I, Prof. Smith.',
    type='sentence',
    locale='en_US@ss=standard' # ICU >= 56 only
)



}
\seealso{
The official online manual of \pkg{stringi} at \url{https://stringi.gagolewski.com/}

Other search_locate: 
\code{\link{about_search}},
\code{\link{stri_locate_all}()}

Other indexing: 
\code{\link{stri_locate_all}()},
\code{\link{stri_sub_all}()},
\code{\link{stri_sub}()}

Other locale_sensitive: 
\code{\link{\%s<\%}()},
\code{\link{about_locale}},
\code{\link{about_search_boundaries}},
\code{\link{about_search_coll}},
\code{\link{stri_compare}()},
\code{\link{stri_count_boundaries}()},
\code{\link{stri_duplicated}()},
\code{\link{stri_enc_detect2}()},
\code{\link{stri_extract_all_boundaries}()},
\code{\link{stri_opts_collator}()},
\code{\link{stri_order}()},
\code{\link{stri_rank}()},
\code{\link{stri_sort_key}()},
\code{\link{stri_sort}()},
\code{\link{stri_split_boundaries}()},
\code{\link{stri_trans_tolower}()},
\code{\link{stri_unique}()},
\code{\link{stri_wrap}()}

Other text_boundaries: 
\code{\link{about_search_boundaries}},
\code{\link{about_search}},
\code{\link{stri_count_boundaries}()},
\code{\link{stri_extract_all_boundaries}()},
\code{\link{stri_opts_brkiter}()},
\code{\link{stri_split_boundaries}()},
\code{\link{stri_split_lines}()},
\code{\link{stri_trans_tolower}()},
\code{\link{stri_wrap}()}
}
\concept{indexing}
\concept{locale_sensitive}
\concept{search_locate}
\concept{text_boundaries}
\author{
\href{https://www.gagolewski.com/}{Marek Gagolewski} and other contributors
}
