% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggsurvplot_add_all.R
\name{ggsurvplot_add_all}
\alias{ggsurvplot_add_all}
\title{Add Survival Curves of Pooled Patients onto the Main Plot}
\usage{
ggsurvplot_add_all(
  fit,
  data,
  legend.title = "Strata",
  legend.labs = NULL,
  pval = FALSE,
  ...
)
}
\arguments{
\item{fit}{an object of class survfit.}

\item{data}{a dataset used to fit survival curves. If not supplied then data
will be extracted from 'fit' object.}

\item{legend.title}{legend title.}

\item{legend.labs}{character vector specifying legend labels. Used to replace
the names of the strata from the fit. Should be given in the same order as
those strata.}

\item{pval}{logical value, a numeric or a string. If logical and TRUE, the
p-value is added on the plot. If numeric, than the computet p-value is
substituted with the one passed with this parameter. If character, then the
customized string appears on the plot. See examples - Example 3.}

\item{...}{other arguments passed to the \code{\link{ggsurvplot}()} function.}
}
\value{
Return a ggsurvplot.
}
\description{
Add survival curves of pooled patients onto the main plot stratified by grouping variables.
}
\examples{
library(survival)

# Fit survival curves
fit <- surv_fit(Surv(time, status) ~ sex, data = lung)

# Visualize survival curves
ggsurvplot(fit, data = lung,
          risk.table = TRUE, pval = TRUE,
          surv.median.line = "hv", palette = "jco")

# Add survival curves of pooled patients (Null model)
# Use add.all = TRUE option
ggsurvplot(fit, data = lung,
          risk.table = TRUE, pval = TRUE,
          surv.median.line = "hv", palette = "jco",
          add.all = TRUE)

}
\seealso{
\code{\link{ggsurvplot}}
}
