
#line 1 "ragel/i18n/th.c.rl"
#include <assert.h>
#include <ruby.h>

#if defined(_WIN32)
#include <stddef.h>
#endif

#ifdef HAVE_RUBY_RE_H
#include <ruby/re.h>
#else
#include <re.h>
#endif

#ifdef HAVE_RUBY_ENCODING_H
#include <ruby/encoding.h>
#define ENCODED_STR_NEW(ptr, len) \
    rb_enc_str_new(ptr, len, rb_utf8_encoding())
#else
#define ENCODED_STR_NEW(ptr, len) \
    rb_str_new(ptr, len)
#endif

#ifndef RSTRING_PTR
#define RSTRING_PTR(s) (RSTRING(s)->ptr)
#endif

#ifndef RSTRING_LEN
#define RSTRING_LEN(s) (RSTRING(s)->len)
#endif

#define DATA_GET(FROM, TYPE, NAME) \
  Data_Get_Struct(FROM, TYPE, NAME); \
  if (NAME == NULL) { \
    rb_raise(rb_eArgError, "NULL found for " # NAME " when it shouldn't be."); \
  }
 
typedef struct lexer_state {
  int content_len;
  int line_number;
  int current_line;
  int start_col;
  size_t mark;
  size_t keyword_start;
  size_t keyword_end;
  size_t next_keyword_start;
  size_t content_start;
  size_t content_end;
  size_t docstring_content_type_start;
  size_t docstring_content_type_end;
  size_t query_start;
  size_t last_newline;
  size_t final_newline;
} lexer_state;

static VALUE mGherkin;
static VALUE mGherkinLexer;
static VALUE mCLexer;
static VALUE cI18nLexer;
static VALUE rb_eGherkinLexingError;

#define LEN(AT, P) (P - data - lexer->AT)
#define MARK(M, P) (lexer->M = (P) - data)
#define PTR_TO(P) (data + lexer->P)

#define STORE_KW_END_CON(EVENT) \
  store_multiline_kw_con(listener, # EVENT, \
    PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end - 1)), \
    PTR_TO(content_start), LEN(content_start, PTR_TO(content_end)), \
    lexer->current_line, lexer->start_col); \
    if (lexer->content_end != 0) { \
      p = PTR_TO(content_end - 1); \
    } \
    lexer->content_end = 0

#define STORE_ATTR(ATTR) \
    store_attr(listener, # ATTR, \
      PTR_TO(content_start), LEN(content_start, p), \
      lexer->line_number)


#line 254 "ragel/i18n/th.c.rl"


/** Data **/

#line 89 "ext/gherkin_lexer_th/gherkin_lexer_th.c"
static const char _lexer_actions[] = {
	0, 1, 0, 1, 1, 1, 2, 1, 
	3, 1, 4, 1, 5, 1, 6, 1, 
	7, 1, 8, 1, 9, 1, 10, 1, 
	11, 1, 12, 1, 13, 1, 16, 1, 
	17, 1, 18, 1, 19, 1, 20, 1, 
	21, 1, 22, 1, 23, 2, 1, 18, 
	2, 4, 5, 2, 13, 0, 2, 14, 
	15, 2, 17, 0, 2, 17, 2, 2, 
	17, 16, 2, 17, 19, 2, 18, 6, 
	2, 18, 7, 2, 18, 8, 2, 18, 
	9, 2, 18, 10, 2, 18, 16, 2, 
	20, 21, 2, 22, 0, 2, 22, 2, 
	2, 22, 16, 2, 22, 19, 3, 3, 
	14, 15, 3, 5, 14, 15, 3, 11, 
	14, 15, 3, 12, 14, 15, 3, 13, 
	14, 15, 3, 14, 15, 18, 3, 17, 
	0, 11, 3, 17, 14, 15, 4, 1, 
	14, 15, 18, 4, 4, 5, 14, 15, 
	4, 17, 0, 14, 15, 5, 17, 0, 
	11, 14, 15
};

static const short _lexer_key_offsets[] = {
	0, 0, 12, 14, 19, 20, 21, 22, 
	23, 24, 25, 26, 27, 28, 29, 30, 
	31, 32, 33, 34, 35, 36, 37, 38, 
	39, 40, 41, 43, 45, 56, 57, 58, 
	60, 62, 67, 72, 77, 82, 86, 90, 
	92, 93, 94, 95, 96, 97, 98, 99, 
	100, 101, 102, 103, 104, 105, 106, 107, 
	112, 119, 124, 128, 134, 137, 139, 145, 
	156, 157, 158, 159, 160, 161, 162, 163, 
	164, 165, 166, 167, 169, 170, 171, 172, 
	173, 174, 175, 176, 177, 178, 179, 180, 
	181, 182, 183, 184, 185, 186, 187, 188, 
	189, 190, 191, 192, 193, 194, 195, 196, 
	197, 198, 199, 200, 201, 202, 203, 204, 
	205, 206, 207, 208, 209, 210, 211, 212, 
	213, 214, 215, 216, 217, 225, 228, 232, 
	234, 236, 238, 240, 242, 244, 246, 248, 
	250, 252, 254, 257, 259, 261, 263, 265, 
	267, 269, 271, 273, 275, 277, 279, 281, 
	283, 285, 287, 289, 291, 293, 295, 297, 
	299, 301, 303, 305, 307, 309, 311, 313, 
	315, 317, 319, 321, 323, 325, 327, 329, 
	331, 333, 335, 337, 339, 341, 343, 345, 
	347, 349, 360, 362, 364, 366, 368, 370, 
	372, 374, 376, 378, 380, 382, 384, 386, 
	388, 390, 392, 394, 396, 398, 400, 402, 
	404, 406, 408, 410, 412, 414, 416, 418, 
	420, 422, 425, 427, 429, 431, 433, 435, 
	437, 439, 441, 443, 445, 447, 449, 451, 
	453, 455, 457, 459, 461, 463, 465, 467, 
	469, 471, 473, 475, 477, 479, 481, 483, 
	485, 487, 489, 491, 493, 495, 497, 499, 
	501, 503, 505, 507, 509, 511, 513, 515, 
	517, 519, 521, 523, 525, 527, 529, 531, 
	533, 535, 537, 539, 541, 545, 547, 549, 
	551, 553, 555, 557, 559, 561, 563, 565, 
	567, 569, 571, 573, 575, 577, 579, 581, 
	583, 585, 587, 589, 591, 593, 595, 597, 
	600, 602, 604, 606, 608, 610, 612, 614, 
	616, 618, 620, 622, 624, 626, 628, 630, 
	632, 634, 636, 638, 640, 642, 644, 646, 
	648, 650, 652, 654, 656, 658, 660, 662, 
	664, 666, 668, 670, 672, 674, 676, 678, 
	680, 682, 684, 686, 688, 689, 690, 691, 
	692, 693, 694, 695, 696, 697, 698, 699, 
	700, 701, 702, 703, 704, 705, 706, 707, 
	708, 709, 710, 711, 712, 713, 714, 715, 
	716, 717, 718, 719, 721, 722, 723, 724, 
	725, 726, 727, 728, 729, 730, 731, 732, 
	733, 734, 735, 736, 737, 738, 739, 740, 
	741, 742, 743, 744, 745, 746, 753, 756, 
	758, 760, 762, 764, 766, 768, 770, 772, 
	774, 776, 778, 780, 783, 785, 787, 789, 
	791, 793, 795, 797, 799, 801, 803, 805, 
	807, 809, 811, 813, 815, 817, 819, 821, 
	823, 825, 827, 829, 831, 833, 835, 837, 
	839, 841, 843, 845, 847, 849, 851, 853, 
	855, 857, 859, 861, 863, 865, 867, 869, 
	871, 873, 875, 877, 879, 881, 883, 885, 
	887, 889, 891, 893, 895, 897, 899, 901, 
	903, 905, 907, 909, 911, 913, 915, 917, 
	919, 921, 923, 925, 927, 929, 931, 933, 
	935, 937, 939, 941, 943, 945, 947, 949, 
	950, 951, 952, 953, 954, 955, 956, 957, 
	958, 959, 960, 961, 962, 963, 964, 965, 
	966, 967, 968, 969, 970, 971, 972, 973, 
	974, 975, 976, 977, 978, 979, 980, 981, 
	982, 983, 984, 985, 986, 987, 988, 989, 
	990, 991, 992, 993, 994, 995, 996, 997, 
	998, 999, 1000, 1001, 1002, 1003, 1004, 1005, 
	1006, 1007, 1008, 1009, 1010, 1011, 1012, 1013, 
	1014, 1015, 1016, 1017, 1018, 1019, 1020, 1021, 
	1022, 1023, 1024, 1025, 1026, 1027, 1028, 1029, 
	1030, 1031, 1040, 1043, 1047, 1049, 1051, 1053, 
	1055, 1057, 1059, 1061, 1063, 1065, 1067, 1069, 
	1071, 1073, 1075, 1077, 1079, 1081, 1083, 1085, 
	1087, 1089, 1091, 1093, 1095, 1097, 1099, 1101, 
	1103, 1105, 1107, 1109, 1111, 1113, 1116, 1118, 
	1120, 1122, 1124, 1126, 1128, 1130, 1132, 1134, 
	1136, 1138, 1140, 1142, 1144, 1146, 1148, 1150, 
	1152, 1154, 1156, 1158, 1160, 1162, 1164, 1166, 
	1168, 1170, 1172, 1174, 1176, 1178, 1180, 1182, 
	1184, 1186, 1188, 1190, 1192, 1194, 1196, 1198, 
	1200, 1202, 1204, 1206, 1208, 1210, 1212, 1214, 
	1216, 1218, 1220, 1222, 1224, 1226, 1228, 1230, 
	1232, 1234, 1236, 1238, 1240, 1242, 1244, 1246, 
	1248, 1250, 1252, 1254, 1256, 1258, 1260, 1262, 
	1264, 1266, 1268, 1270, 1272, 1274, 1278, 1280, 
	1282, 1285, 1287, 1289, 1291, 1293, 1295, 1297, 
	1299, 1301, 1303, 1305, 1307, 1309, 1311, 1313, 
	1315, 1317, 1319, 1321, 1323, 1325, 1327, 1329, 
	1331, 1333, 1335, 1337, 1339, 1341, 1343, 1345, 
	1347, 1349, 1352, 1354, 1356, 1358, 1360, 1362, 
	1364, 1366, 1368, 1370, 1372, 1374, 1376, 1378, 
	1380, 1382, 1384, 1386, 1388, 1390, 1392, 1394, 
	1396, 1398, 1400, 1402, 1404, 1406, 1408, 1410, 
	1412, 1414, 1416, 1418, 1420, 1422, 1424, 1426, 
	1428, 1430, 1432, 1434, 1437, 1438, 1439, 1441, 
	1442, 1443, 1444, 1445, 1446, 1447, 1448, 1449, 
	1450, 1451, 1452, 1453, 1454, 1455, 1456, 1457, 
	1458, 1459, 1460, 1461, 1462, 1463, 1464, 1465, 
	1466, 1467, 1468, 1469, 1470, 1471, 1472, 1473, 
	1474, 1483, 1486, 1491, 1493, 1495, 1497, 1499, 
	1501, 1503, 1505, 1507, 1509, 1511, 1513, 1515, 
	1517, 1519, 1521, 1523, 1525, 1527, 1529, 1531, 
	1533, 1535, 1537, 1539, 1541, 1543, 1545, 1547, 
	1549, 1551, 1553, 1555, 1557, 1560, 1562, 1564, 
	1566, 1568, 1570, 1572, 1574, 1576, 1578, 1580, 
	1582, 1584, 1586, 1588, 1590, 1592, 1594, 1596, 
	1598, 1600, 1602, 1604, 1606, 1608, 1610, 1612, 
	1614, 1616, 1618, 1620, 1622, 1624, 1626, 1628, 
	1630, 1632, 1634, 1636, 1638, 1640, 1642, 1644, 
	1646, 1648, 1650, 1652, 1654, 1656, 1658, 1660, 
	1662, 1664, 1666, 1668, 1670, 1672, 1674, 1676, 
	1678, 1680, 1682, 1684, 1686, 1688, 1690, 1692, 
	1694, 1696, 1698, 1700, 1702, 1704, 1706, 1708, 
	1710, 1712, 1714, 1716, 1718, 1720, 1722, 1724, 
	1726, 1728, 1730, 1732, 1734, 1736, 1738, 1740, 
	1742, 1744, 1746, 1748, 1750, 1752, 1754, 1756, 
	1758, 1760, 1762, 1764, 1766, 1768, 1770, 1772, 
	1774, 1776, 1778, 1780, 1782, 1784, 1786, 1788, 
	1790, 1794, 1796, 1798, 1801, 1803, 1805, 1807, 
	1809, 1811, 1813, 1815, 1817, 1819, 1821, 1823, 
	1827, 1829, 1831, 1833, 1835, 1837, 1839, 1841, 
	1843, 1845, 1847, 1849, 1851, 1853, 1855, 1857, 
	1859, 1861, 1863, 1865, 1867, 1869, 1871, 1873, 
	1875, 1877, 1879, 1881, 1883, 1885, 1888, 1890, 
	1892, 1894, 1896, 1898, 1900, 1902, 1904, 1906, 
	1908, 1910, 1912, 1914, 1916, 1918, 1920, 1922, 
	1924, 1926, 1928, 1930, 1932, 1934, 1936, 1938, 
	1940, 1942, 1944, 1946, 1948, 1950, 1952, 1954, 
	1956, 1958, 1960, 1962, 1964, 1966, 1968, 1970, 
	1972, 1974, 1976, 1977, 1978, 1981, 1982, 1983, 
	1984, 1985, 1986, 1987, 1988, 1989, 1990, 1991, 
	1992, 1993, 1994, 1995, 1996, 1997, 1998, 1999, 
	2008, 2011, 2016, 2018, 2020, 2022, 2024, 2026, 
	2028, 2030, 2032, 2034, 2036, 2038, 2040, 2042, 
	2044, 2046, 2048, 2050, 2052, 2054, 2056, 2058, 
	2060, 2062, 2064, 2066, 2068, 2070, 2072, 2074, 
	2076, 2078, 2080, 2082, 2085, 2087, 2089, 2091, 
	2093, 2095, 2097, 2099, 2101, 2103, 2105, 2107, 
	2109, 2111, 2113, 2115, 2117, 2119, 2121, 2123, 
	2125, 2127, 2129, 2131, 2133, 2135, 2137, 2139, 
	2141, 2143, 2145, 2147, 2149, 2151, 2153, 2155, 
	2157, 2159, 2161, 2163, 2165, 2167, 2169, 2171, 
	2173, 2175, 2177, 2179, 2181, 2183, 2185, 2187, 
	2189, 2191, 2193, 2195, 2197, 2199, 2201, 2203, 
	2205, 2207, 2209, 2211, 2213, 2215, 2217, 2219, 
	2221, 2223, 2225, 2227, 2229, 2231, 2233, 2235, 
	2237, 2239, 2241, 2243, 2245, 2247, 2249, 2251, 
	2253, 2255, 2257, 2259, 2261, 2263, 2265, 2267, 
	2269, 2271, 2273, 2275, 2277, 2279, 2281, 2283, 
	2285, 2287, 2289, 2291, 2293, 2295, 2297, 2299, 
	2301, 2303, 2305, 2307, 2309, 2311, 2313, 2315, 
	2319, 2321, 2323, 2326, 2328, 2330, 2332, 2334, 
	2336, 2338, 2340, 2342, 2344, 2346, 2348, 2351, 
	2353, 2355, 2357, 2359, 2361, 2363, 2365, 2367, 
	2369, 2371, 2373, 2375, 2377, 2379, 2381, 2383, 
	2385, 2388, 2390, 2392, 2394, 2396, 2398, 2400, 
	2402, 2404, 2406, 2408, 2410, 2412, 2414, 2416, 
	2418, 2420, 2422, 2424, 2426, 2428, 2430, 2432, 
	2434, 2436, 2438, 2440, 2442, 2444, 2446, 2448, 
	2450, 2452, 2454, 2456, 2458, 2460, 2462, 2464, 
	2466, 2468, 2470, 2472, 2474, 2476, 2477, 2478, 
	2479, 2480, 2481, 2482, 2483, 2484, 2485, 2486, 
	2487, 2488, 2489, 2490, 2492, 2493, 2494, 2495, 
	2496, 2497, 2498, 2499, 2500, 2501, 2502, 2503, 
	2504, 2505, 2506, 2507, 2508, 2509, 2510, 2511, 
	2512, 2513, 2514, 2515, 2516, 2517, 2518, 2519, 
	2520, 2521, 2522, 2523, 2524
};

static const char _lexer_trans_keys[] = {
	-32, -17, 10, 32, 34, 35, 37, 42, 
	64, 124, 9, 13, -72, -71, -127, -124, 
	-118, -108, -86, -32, -72, -77, -32, -72, 
	-85, -32, -72, -103, -32, -72, -108, -32, 
	-71, -125, -32, -72, -85, -32, -71, -119, 
	32, 10, 13, 10, 13, -32, 10, 32, 
	34, 35, 37, 42, 64, 124, 9, 13, 
	34, 34, 10, 13, 10, 13, 10, 32, 
	34, 9, 13, 10, 32, 34, 9, 13, 
	10, 32, 34, 9, 13, 10, 32, 34, 
	9, 13, 10, 32, 9, 13, 10, 32, 
	9, 13, 10, 13, 10, 95, 70, 69, 
	65, 84, 85, 82, 69, 95, 69, 78, 
	68, 95, 37, 13, 32, 64, 9, 10, 
	9, 10, 13, 32, 64, 11, 12, 10, 
	32, 64, 9, 13, 32, 124, 9, 13, 
	10, 32, 92, 124, 9, 13, 10, 92, 
	124, 10, 92, 10, 32, 92, 124, 9, 
	13, -32, 10, 32, 34, 35, 37, 42, 
	64, 124, 9, 13, -32, -72, -89, -32, 
	-72, -78, -32, -72, -95, -32, -72, -107, 
	-86, -32, -71, -119, -32, -72, -83, -32, 
	-72, -121, -32, -72, -127, -32, -72, -78, 
	-32, -72, -93, -32, -72, -105, -32, -72, 
	-78, -32, -72, -121, -32, -72, -104, -32, 
	-72, -72, -32, -72, -93, -32, -72, -127, 
	-32, -72, -76, -32, -72, -120, 58, 10, 
	10, -32, 10, 32, 35, 37, 64, 9, 
	13, -72, -71, 10, -124, -118, -86, 10, 
	-32, 10, -72, 10, -89, 10, -32, 10, 
	-72, 10, -78, 10, -32, 10, -72, 10, 
	-95, 10, -32, 10, -72, 10, -107, -86, 
	10, -32, 10, -71, 10, -119, 10, -32, 
	10, -72, 10, -83, 10, -32, 10, -72, 
	10, -121, 10, -32, 10, -72, 10, -127, 
	10, -32, 10, -72, 10, -78, 10, -32, 
	10, -72, 10, -93, 10, -32, 10, -72, 
	10, -105, 10, -32, 10, -72, 10, -78, 
	10, -32, 10, -72, 10, -121, 10, -32, 
	10, -72, 10, -104, 10, -32, 10, -72, 
	10, -72, 10, -32, 10, -72, 10, -93, 
	10, -32, 10, -72, 10, -127, 10, -32, 
	10, -72, 10, -76, 10, -32, 10, -72, 
	10, -120, 10, 10, 58, -32, 10, 32, 
	34, 35, 37, 42, 64, 124, 9, 13, 
	-32, 10, -72, 10, -78, 10, -32, 10, 
	-72, 10, -95, 10, -32, 10, -72, 10, 
	-78, 10, -32, 10, -72, 10, -93, 10, 
	-32, 10, -72, 10, -106, 10, -32, 10, 
	-72, 10, -72, 10, -32, 10, -72, 10, 
	-108, 10, -32, 10, -72, 10, -126, 10, 
	-32, 10, -72, 10, -83, 10, -32, 10, 
	-72, 10, -121, 10, -32, 10, -72, -71, 
	10, -107, 10, -32, 10, -72, 10, -79, 
	10, -32, 10, -72, 10, -89, 10, -32, 
	10, -72, 10, -83, 10, -32, 10, -72, 
	10, -94, 10, -32, 10, -71, 10, -120, 
	10, -32, 10, -72, 10, -78, 10, -32, 
	10, -72, 10, -121, 10, -128, 10, -32, 
	10, -72, 10, -85, 10, -32, 10, -72, 
	10, -107, 10, -32, 10, -72, 10, -72, 
	10, -32, 10, -72, 10, -127, 10, -32, 
	10, -72, 10, -78, 10, -32, 10, -72, 
	10, -93, 10, -32, 10, -72, 10, -109, 
	10, -32, 10, -71, 10, -116, 10, -32, 
	10, -72, 10, -93, 10, -32, 10, -72, 
	10, -72, 10, -32, 10, -72, 10, -101, 
	10, -32, 10, -71, 10, -128, -127, -126, 
	10, -32, 10, -72, 10, -103, 10, -32, 
	10, -72, 10, -89, 10, -32, 10, -72, 
	10, -124, 10, -32, 10, -72, 10, -76, 
	10, -32, 10, -72, 10, -108, 10, -32, 
	10, -72, 10, -124, 10, -32, 10, -72, 
	10, -93, 10, -32, 10, -72, 10, -121, 
	10, -32, 10, -72, 10, -86, -85, 10, 
	-32, 10, -72, 10, -93, 10, -32, 10, 
	-71, 10, -119, 10, -32, 10, -72, 10, 
	-78, 10, -32, 10, -72, 10, -121, 10, 
	-32, 10, -72, 10, -126, 10, -32, 10, 
	-72, 10, -83, 10, -32, 10, -72, 10, 
	-121, 10, -32, 10, -72, 10, -91, 10, 
	-32, 10, -72, 10, -79, 10, -32, 10, 
	-72, 10, -127, 10, 10, 95, 10, 70, 
	10, 69, 10, 65, 10, 84, 10, 85, 
	10, 82, 10, 69, 10, 95, 10, 69, 
	10, 78, 10, 68, 10, 95, 10, 37, 
	-32, -72, -78, -32, -72, -95, -32, -72, 
	-78, -32, -72, -93, -32, -72, -106, -32, 
	-72, -72, -32, -72, -108, -32, -72, -126, 
	-32, -72, -83, -32, -72, -121, -32, -72, 
	-71, -107, -32, -72, -79, -32, -72, -89, 
	-32, -72, -83, -32, -72, -94, -32, -71, 
	-120, -32, -72, -78, -32, -72, -121, 58, 
	10, 10, -32, 10, 32, 35, 124, 9, 
	13, -72, -71, 10, -124, 10, -32, 10, 
	-72, 10, -89, 10, -32, 10, -72, 10, 
	-78, 10, -32, 10, -72, 10, -95, 10, 
	-32, 10, -72, 10, -107, -86, 10, -32, 
	10, -71, 10, -119, 10, -32, 10, -72, 
	10, -83, 10, -32, 10, -72, 10, -121, 
	10, -32, 10, -72, 10, -127, 10, -32, 
	10, -72, 10, -78, 10, -32, 10, -72, 
	10, -93, 10, -32, 10, -72, 10, -105, 
	10, -32, 10, -72, 10, -78, 10, -32, 
	10, -72, 10, -121, 10, -32, 10, -72, 
	10, -104, 10, -32, 10, -72, 10, -72, 
	10, -32, 10, -72, 10, -93, 10, -32, 
	10, -72, 10, -127, 10, -32, 10, -72, 
	10, -76, 10, -32, 10, -72, 10, -120, 
	10, 10, 58, -32, 10, -72, 10, -78, 
	10, -32, 10, -72, 10, -95, 10, -32, 
	10, -72, 10, -78, 10, -32, 10, -72, 
	10, -93, 10, -32, 10, -72, 10, -106, 
	10, -126, 10, -32, 10, -72, 10, -124, 
	10, -32, 10, -72, 10, -93, 10, -32, 
	10, -72, 10, -121, 10, -32, 10, -72, 
	10, -85, 10, -32, 10, -72, 10, -91, 
	10, -32, 10, -72, 10, -79, 10, -32, 
	10, -72, 10, -127, 10, -128, -32, -72, 
	-85, -32, -72, -107, -32, -72, -72, -32, 
	-72, -127, -32, -72, -78, -32, -72, -93, 
	-32, -72, -109, -32, -71, -116, -32, -72, 
	-79, -32, -72, -121, -32, -72, -103, -32, 
	-72, -79, -32, -71, -119, -32, -72, -103, 
	-32, -72, -93, -32, -72, -72, -32, -72, 
	-101, -32, -71, -128, -32, -72, -85, -32, 
	-72, -107, -32, -72, -72, -32, -72, -127, 
	-32, -72, -78, -32, -72, -93, -32, -72, 
	-109, -32, -71, -116, 58, 10, 10, -32, 
	10, 32, 35, 37, 42, 64, 9, 13, 
	-72, -71, 10, -127, -124, -108, 10, -32, 
	10, -72, 10, -77, 10, -32, 10, -72, 
	10, -85, 10, -32, 10, -72, 10, -103, 
	10, -32, 10, -72, 10, -108, 10, -32, 
	10, -71, 10, -125, 10, -32, 10, -72, 
	10, -85, 10, -32, 10, -71, 10, -119, 
	10, 10, 32, -32, 10, -72, 10, -89, 
	10, -32, 10, -72, 10, -78, 10, -32, 
	10, -72, 10, -95, 10, -32, 10, -72, 
	10, -107, -86, 10, -32, 10, -71, 10, 
	-119, 10, -32, 10, -72, 10, -83, 10, 
	-32, 10, -72, 10, -121, 10, -32, 10, 
	-72, 10, -127, 10, -32, 10, -72, 10, 
	-78, 10, -32, 10, -72, 10, -93, 10, 
	-32, 10, -72, 10, -105, 10, -32, 10, 
	-72, 10, -78, 10, -32, 10, -72, 10, 
	-121, 10, -32, 10, -72, 10, -104, 10, 
	-32, 10, -72, 10, -72, 10, -32, 10, 
	-72, 10, -93, 10, -32, 10, -72, 10, 
	-127, 10, -32, 10, -72, 10, -76, 10, 
	-32, 10, -72, 10, -120, 10, 10, 58, 
	-32, 10, -72, 10, -78, 10, -32, 10, 
	-72, 10, -95, 10, -32, 10, -72, 10, 
	-78, 10, -32, 10, -72, 10, -93, 10, 
	-32, 10, -72, 10, -106, 10, -32, 10, 
	-72, 10, -79, 10, -32, 10, -72, 10, 
	-121, 10, -32, 10, -72, 10, -103, 10, 
	-32, 10, -72, 10, -79, 10, -32, 10, 
	-71, 10, -119, 10, -32, 10, -72, 10, 
	-103, 10, -128, -127, -126, 10, -32, 10, 
	-72, 10, -95, -85, 10, -32, 10, -72, 
	10, -73, 10, -32, 10, -71, 10, -120, 
	10, -32, 10, -72, 10, -83, 10, -32, 
	10, -72, 10, -107, 10, -32, 10, -72, 
	10, -72, 10, -32, 10, -72, 10, -127, 
	10, -32, 10, -72, 10, -78, 10, -32, 
	10, -72, 10, -93, 10, -32, 10, -72, 
	10, -109, 10, -32, 10, -71, 10, -116, 
	10, -32, 10, -72, 10, -107, -91, 10, 
	-32, 10, -71, 10, -120, 10, -32, 10, 
	-72, 10, -80, 10, -32, 10, -72, 10, 
	-124, 10, -32, 10, -72, 10, -93, 10, 
	-32, 10, -72, 10, -121, 10, -32, 10, 
	-72, 10, -85, 10, -32, 10, -72, 10, 
	-91, 10, -32, 10, -72, 10, -79, 10, 
	-32, 10, -72, 10, -127, 10, 10, 95, 
	10, 70, 10, 69, 10, 65, 10, 84, 
	10, 85, 10, 82, 10, 69, 10, 95, 
	10, 69, 10, 78, 10, 68, 10, 95, 
	10, 37, -128, -127, -126, -32, -72, -95, 
	-85, -32, -72, -73, -32, -71, -120, -32, 
	-72, -83, -32, -72, -107, -32, -72, -72, 
	-32, -72, -127, -32, -72, -78, -32, -72, 
	-93, -32, -72, -109, -32, -71, -116, 58, 
	10, 10, -32, 10, 32, 35, 37, 42, 
	64, 9, 13, -72, -71, 10, -127, -124, 
	-108, -86, 10, -32, 10, -72, 10, -77, 
	10, -32, 10, -72, 10, -85, 10, -32, 
	10, -72, 10, -103, 10, -32, 10, -72, 
	10, -108, 10, -32, 10, -71, 10, -125, 
	10, -32, 10, -72, 10, -85, 10, -32, 
	10, -71, 10, -119, 10, 10, 32, -32, 
	10, -72, 10, -89, 10, -32, 10, -72, 
	10, -78, 10, -32, 10, -72, 10, -95, 
	10, -32, 10, -72, 10, -107, -86, 10, 
	-32, 10, -71, 10, -119, 10, -32, 10, 
	-72, 10, -83, 10, -32, 10, -72, 10, 
	-121, 10, -32, 10, -72, 10, -127, 10, 
	-32, 10, -72, 10, -78, 10, -32, 10, 
	-72, 10, -93, 10, -32, 10, -72, 10, 
	-105, 10, -32, 10, -72, 10, -78, 10, 
	-32, 10, -72, 10, -121, 10, -32, 10, 
	-72, 10, -104, 10, -32, 10, -72, 10, 
	-72, 10, -32, 10, -72, 10, -93, 10, 
	-32, 10, -72, 10, -127, 10, -32, 10, 
	-72, 10, -76, 10, -32, 10, -72, 10, 
	-120, 10, 10, 58, -32, 10, -72, 10, 
	-78, 10, -32, 10, -72, 10, -95, 10, 
	-32, 10, -72, 10, -78, 10, -32, 10, 
	-72, 10, -93, 10, -32, 10, -72, 10, 
	-106, 10, -32, 10, -72, 10, -79, 10, 
	-32, 10, -72, 10, -121, 10, -32, 10, 
	-72, 10, -103, 10, -32, 10, -72, 10, 
	-79, 10, -32, 10, -71, 10, -119, 10, 
	-32, 10, -72, 10, -103, 10, -32, 10, 
	-72, 10, -93, 10, -32, 10, -72, 10, 
	-72, 10, -32, 10, -72, 10, -101, 10, 
	-32, 10, -71, 10, -128, 10, -32, 10, 
	-72, 10, -85, 10, -32, 10, -72, 10, 
	-107, 10, -32, 10, -72, 10, -72, 10, 
	-32, 10, -72, 10, -127, 10, -32, 10, 
	-72, 10, -78, 10, -32, 10, -72, 10, 
	-93, 10, -32, 10, -72, 10, -109, 10, 
	-32, 10, -71, 10, -116, 10, -128, -127, 
	-126, 10, -32, 10, -72, 10, -95, -85, 
	10, -32, 10, -72, 10, -73, 10, -32, 
	10, -71, 10, -120, 10, -32, 10, -72, 
	10, -83, 10, -32, 10, -72, 10, -107, 
	-103, -91, 10, -32, 10, -71, 10, -120, 
	10, -32, 10, -72, 10, -89, 10, -32, 
	10, -72, 10, -124, 10, -32, 10, -72, 
	10, -76, 10, -32, 10, -72, 10, -108, 
	10, -32, 10, -72, 10, -80, 10, -32, 
	10, -72, 10, -124, 10, -32, 10, -72, 
	10, -93, 10, -32, 10, -72, 10, -121, 
	10, -32, 10, -72, 10, -86, -85, 10, 
	-32, 10, -72, 10, -93, 10, -32, 10, 
	-71, 10, -119, 10, -32, 10, -72, 10, 
	-78, 10, -32, 10, -72, 10, -121, 10, 
	-32, 10, -72, 10, -126, 10, -32, 10, 
	-72, 10, -83, 10, -32, 10, -72, 10, 
	-121, 10, -32, 10, -72, 10, -91, 10, 
	-32, 10, -72, 10, -79, 10, -32, 10, 
	-72, 10, -127, 10, 10, 95, 10, 70, 
	10, 69, 10, 65, 10, 84, 10, 85, 
	10, 82, 10, 69, 10, 95, 10, 69, 
	10, 78, 10, 68, 10, 95, 10, 37, 
	-32, -72, -107, -103, -91, -32, -71, -120, 
	-32, -72, -89, -32, -72, -124, -32, -72, 
	-76, -32, -72, -108, 58, 10, 10, -32, 
	10, 32, 35, 37, 42, 64, 9, 13, 
	-72, -71, 10, -127, -124, -108, -86, 10, 
	-32, 10, -72, 10, -77, 10, -32, 10, 
	-72, 10, -85, 10, -32, 10, -72, 10, 
	-103, 10, -32, 10, -72, 10, -108, 10, 
	-32, 10, -71, 10, -125, 10, -32, 10, 
	-72, 10, -85, 10, -32, 10, -71, 10, 
	-119, 10, 10, 32, -32, 10, -72, 10, 
	-89, 10, -32, 10, -72, 10, -78, 10, 
	-32, 10, -72, 10, -95, 10, -32, 10, 
	-72, 10, -107, -86, 10, -32, 10, -71, 
	10, -119, 10, -32, 10, -72, 10, -83, 
	10, -32, 10, -72, 10, -121, 10, -32, 
	10, -72, 10, -127, 10, -32, 10, -72, 
	10, -78, 10, -32, 10, -72, 10, -93, 
	10, -32, 10, -72, 10, -105, 10, -32, 
	10, -72, 10, -78, 10, -32, 10, -72, 
	10, -121, 10, -32, 10, -72, 10, -104, 
	10, -32, 10, -72, 10, -72, 10, -32, 
	10, -72, 10, -93, 10, -32, 10, -72, 
	10, -127, 10, -32, 10, -72, 10, -76, 
	10, -32, 10, -72, 10, -120, 10, 10, 
	58, -32, 10, -72, 10, -78, 10, -32, 
	10, -72, 10, -95, 10, -32, 10, -72, 
	10, -78, 10, -32, 10, -72, 10, -93, 
	10, -32, 10, -72, 10, -106, 10, -32, 
	10, -72, 10, -79, 10, -32, 10, -72, 
	10, -121, 10, -32, 10, -72, 10, -103, 
	10, -32, 10, -72, 10, -79, 10, -32, 
	10, -71, 10, -119, 10, -32, 10, -72, 
	10, -103, 10, -32, 10, -72, 10, -93, 
	10, -32, 10, -72, 10, -72, 10, -32, 
	10, -72, 10, -101, 10, -32, 10, -71, 
	10, -128, 10, -32, 10, -72, 10, -85, 
	10, -32, 10, -72, 10, -107, 10, -32, 
	10, -72, 10, -72, 10, -32, 10, -72, 
	10, -127, 10, -32, 10, -72, 10, -78, 
	10, -32, 10, -72, 10, -93, 10, -32, 
	10, -72, 10, -109, 10, -32, 10, -71, 
	10, -116, 10, -128, -127, -126, 10, -32, 
	10, -72, 10, -95, -85, 10, -32, 10, 
	-72, 10, -73, 10, -32, 10, -71, 10, 
	-120, 10, -32, 10, -72, 10, -83, 10, 
	-32, 10, -72, 10, -107, -91, 10, -32, 
	10, -71, 10, -120, 10, -32, 10, -72, 
	10, -80, 10, -32, 10, -72, 10, -124, 
	10, -32, 10, -72, 10, -93, 10, -32, 
	10, -72, 10, -121, 10, -32, 10, -72, 
	10, -86, -85, 10, -32, 10, -72, 10, 
	-93, 10, -32, 10, -71, 10, -119, 10, 
	-32, 10, -72, 10, -78, 10, -32, 10, 
	-72, 10, -121, 10, -32, 10, -72, 10, 
	-126, 10, -32, 10, -72, 10, -83, 10, 
	-32, 10, -72, 10, -121, 10, -32, 10, 
	-72, 10, -91, 10, -32, 10, -72, 10, 
	-79, 10, -32, 10, -72, 10, -127, 10, 
	10, 95, 10, 70, 10, 69, 10, 65, 
	10, 84, 10, 85, 10, 82, 10, 69, 
	10, 95, 10, 69, 10, 78, 10, 68, 
	10, 95, 10, 37, -32, -72, -80, -32, 
	-72, -124, -32, -72, -93, -32, -72, -121, 
	-32, -72, -86, -85, -32, -72, -93, -32, 
	-71, -119, -32, -72, -78, -32, -72, -121, 
	-32, -72, -126, -32, -72, -83, -32, -72, 
	-121, -32, -72, -91, -32, -72, -79, -32, 
	-72, -127, -69, -65, 0
};

static const char _lexer_single_lengths[] = {
	0, 10, 2, 5, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 2, 2, 9, 1, 1, 2, 
	2, 3, 3, 3, 3, 2, 2, 2, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 3, 
	5, 3, 2, 4, 3, 2, 4, 9, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 2, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 6, 3, 4, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 3, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 9, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 3, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 4, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 3, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 2, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 5, 3, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 3, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 7, 3, 4, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 3, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 4, 2, 2, 
	3, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 3, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 3, 1, 1, 2, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	7, 3, 5, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 3, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	4, 2, 2, 3, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 4, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 3, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 1, 1, 3, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 7, 
	3, 5, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 3, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 4, 
	2, 2, 3, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 3, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	3, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 2, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 0
};

static const char _lexer_range_lengths[] = {
	0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 1, 0, 0, 0, 
	0, 1, 1, 1, 1, 1, 1, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	1, 1, 1, 1, 0, 0, 1, 1, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 1, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 1, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0
};

static const short _lexer_index_offsets[] = {
	0, 0, 12, 15, 21, 23, 25, 27, 
	29, 31, 33, 35, 37, 39, 41, 43, 
	45, 47, 49, 51, 53, 55, 57, 59, 
	61, 63, 65, 68, 71, 82, 84, 86, 
	89, 92, 97, 102, 107, 112, 116, 120, 
	123, 125, 127, 129, 131, 133, 135, 137, 
	139, 141, 143, 145, 147, 149, 151, 153, 
	158, 165, 170, 174, 180, 184, 187, 193, 
	204, 206, 208, 210, 212, 214, 216, 218, 
	220, 222, 224, 226, 229, 231, 233, 235, 
	237, 239, 241, 243, 245, 247, 249, 251, 
	253, 255, 257, 259, 261, 263, 265, 267, 
	269, 271, 273, 275, 277, 279, 281, 283, 
	285, 287, 289, 291, 293, 295, 297, 299, 
	301, 303, 305, 307, 309, 311, 313, 315, 
	317, 319, 321, 323, 325, 333, 337, 342, 
	345, 348, 351, 354, 357, 360, 363, 366, 
	369, 372, 375, 379, 382, 385, 388, 391, 
	394, 397, 400, 403, 406, 409, 412, 415, 
	418, 421, 424, 427, 430, 433, 436, 439, 
	442, 445, 448, 451, 454, 457, 460, 463, 
	466, 469, 472, 475, 478, 481, 484, 487, 
	490, 493, 496, 499, 502, 505, 508, 511, 
	514, 517, 528, 531, 534, 537, 540, 543, 
	546, 549, 552, 555, 558, 561, 564, 567, 
	570, 573, 576, 579, 582, 585, 588, 591, 
	594, 597, 600, 603, 606, 609, 612, 615, 
	618, 621, 625, 628, 631, 634, 637, 640, 
	643, 646, 649, 652, 655, 658, 661, 664, 
	667, 670, 673, 676, 679, 682, 685, 688, 
	691, 694, 697, 700, 703, 706, 709, 712, 
	715, 718, 721, 724, 727, 730, 733, 736, 
	739, 742, 745, 748, 751, 754, 757, 760, 
	763, 766, 769, 772, 775, 778, 781, 784, 
	787, 790, 793, 796, 799, 804, 807, 810, 
	813, 816, 819, 822, 825, 828, 831, 834, 
	837, 840, 843, 846, 849, 852, 855, 858, 
	861, 864, 867, 870, 873, 876, 879, 882, 
	886, 889, 892, 895, 898, 901, 904, 907, 
	910, 913, 916, 919, 922, 925, 928, 931, 
	934, 937, 940, 943, 946, 949, 952, 955, 
	958, 961, 964, 967, 970, 973, 976, 979, 
	982, 985, 988, 991, 994, 997, 1000, 1003, 
	1006, 1009, 1012, 1015, 1018, 1020, 1022, 1024, 
	1026, 1028, 1030, 1032, 1034, 1036, 1038, 1040, 
	1042, 1044, 1046, 1048, 1050, 1052, 1054, 1056, 
	1058, 1060, 1062, 1064, 1066, 1068, 1070, 1072, 
	1074, 1076, 1078, 1080, 1083, 1085, 1087, 1089, 
	1091, 1093, 1095, 1097, 1099, 1101, 1103, 1105, 
	1107, 1109, 1111, 1113, 1115, 1117, 1119, 1121, 
	1123, 1125, 1127, 1129, 1131, 1133, 1140, 1144, 
	1147, 1150, 1153, 1156, 1159, 1162, 1165, 1168, 
	1171, 1174, 1177, 1180, 1184, 1187, 1190, 1193, 
	1196, 1199, 1202, 1205, 1208, 1211, 1214, 1217, 
	1220, 1223, 1226, 1229, 1232, 1235, 1238, 1241, 
	1244, 1247, 1250, 1253, 1256, 1259, 1262, 1265, 
	1268, 1271, 1274, 1277, 1280, 1283, 1286, 1289, 
	1292, 1295, 1298, 1301, 1304, 1307, 1310, 1313, 
	1316, 1319, 1322, 1325, 1328, 1331, 1334, 1337, 
	1340, 1343, 1346, 1349, 1352, 1355, 1358, 1361, 
	1364, 1367, 1370, 1373, 1376, 1379, 1382, 1385, 
	1388, 1391, 1394, 1397, 1400, 1403, 1406, 1409, 
	1412, 1415, 1418, 1421, 1424, 1427, 1430, 1433, 
	1435, 1437, 1439, 1441, 1443, 1445, 1447, 1449, 
	1451, 1453, 1455, 1457, 1459, 1461, 1463, 1465, 
	1467, 1469, 1471, 1473, 1475, 1477, 1479, 1481, 
	1483, 1485, 1487, 1489, 1491, 1493, 1495, 1497, 
	1499, 1501, 1503, 1505, 1507, 1509, 1511, 1513, 
	1515, 1517, 1519, 1521, 1523, 1525, 1527, 1529, 
	1531, 1533, 1535, 1537, 1539, 1541, 1543, 1545, 
	1547, 1549, 1551, 1553, 1555, 1557, 1559, 1561, 
	1563, 1565, 1567, 1569, 1571, 1573, 1575, 1577, 
	1579, 1581, 1583, 1585, 1587, 1589, 1591, 1593, 
	1595, 1597, 1606, 1610, 1615, 1618, 1621, 1624, 
	1627, 1630, 1633, 1636, 1639, 1642, 1645, 1648, 
	1651, 1654, 1657, 1660, 1663, 1666, 1669, 1672, 
	1675, 1678, 1681, 1684, 1687, 1690, 1693, 1696, 
	1699, 1702, 1705, 1708, 1711, 1714, 1718, 1721, 
	1724, 1727, 1730, 1733, 1736, 1739, 1742, 1745, 
	1748, 1751, 1754, 1757, 1760, 1763, 1766, 1769, 
	1772, 1775, 1778, 1781, 1784, 1787, 1790, 1793, 
	1796, 1799, 1802, 1805, 1808, 1811, 1814, 1817, 
	1820, 1823, 1826, 1829, 1832, 1835, 1838, 1841, 
	1844, 1847, 1850, 1853, 1856, 1859, 1862, 1865, 
	1868, 1871, 1874, 1877, 1880, 1883, 1886, 1889, 
	1892, 1895, 1898, 1901, 1904, 1907, 1910, 1913, 
	1916, 1919, 1922, 1925, 1928, 1931, 1934, 1937, 
	1940, 1943, 1946, 1949, 1952, 1955, 1960, 1963, 
	1966, 1970, 1973, 1976, 1979, 1982, 1985, 1988, 
	1991, 1994, 1997, 2000, 2003, 2006, 2009, 2012, 
	2015, 2018, 2021, 2024, 2027, 2030, 2033, 2036, 
	2039, 2042, 2045, 2048, 2051, 2054, 2057, 2060, 
	2063, 2066, 2070, 2073, 2076, 2079, 2082, 2085, 
	2088, 2091, 2094, 2097, 2100, 2103, 2106, 2109, 
	2112, 2115, 2118, 2121, 2124, 2127, 2130, 2133, 
	2136, 2139, 2142, 2145, 2148, 2151, 2154, 2157, 
	2160, 2163, 2166, 2169, 2172, 2175, 2178, 2181, 
	2184, 2187, 2190, 2193, 2197, 2199, 2201, 2204, 
	2206, 2208, 2210, 2212, 2214, 2216, 2218, 2220, 
	2222, 2224, 2226, 2228, 2230, 2232, 2234, 2236, 
	2238, 2240, 2242, 2244, 2246, 2248, 2250, 2252, 
	2254, 2256, 2258, 2260, 2262, 2264, 2266, 2268, 
	2270, 2279, 2283, 2289, 2292, 2295, 2298, 2301, 
	2304, 2307, 2310, 2313, 2316, 2319, 2322, 2325, 
	2328, 2331, 2334, 2337, 2340, 2343, 2346, 2349, 
	2352, 2355, 2358, 2361, 2364, 2367, 2370, 2373, 
	2376, 2379, 2382, 2385, 2388, 2392, 2395, 2398, 
	2401, 2404, 2407, 2410, 2413, 2416, 2419, 2422, 
	2425, 2428, 2431, 2434, 2437, 2440, 2443, 2446, 
	2449, 2452, 2455, 2458, 2461, 2464, 2467, 2470, 
	2473, 2476, 2479, 2482, 2485, 2488, 2491, 2494, 
	2497, 2500, 2503, 2506, 2509, 2512, 2515, 2518, 
	2521, 2524, 2527, 2530, 2533, 2536, 2539, 2542, 
	2545, 2548, 2551, 2554, 2557, 2560, 2563, 2566, 
	2569, 2572, 2575, 2578, 2581, 2584, 2587, 2590, 
	2593, 2596, 2599, 2602, 2605, 2608, 2611, 2614, 
	2617, 2620, 2623, 2626, 2629, 2632, 2635, 2638, 
	2641, 2644, 2647, 2650, 2653, 2656, 2659, 2662, 
	2665, 2668, 2671, 2674, 2677, 2680, 2683, 2686, 
	2689, 2692, 2695, 2698, 2701, 2704, 2707, 2710, 
	2713, 2716, 2719, 2722, 2725, 2728, 2731, 2734, 
	2737, 2742, 2745, 2748, 2752, 2755, 2758, 2761, 
	2764, 2767, 2770, 2773, 2776, 2779, 2782, 2785, 
	2790, 2793, 2796, 2799, 2802, 2805, 2808, 2811, 
	2814, 2817, 2820, 2823, 2826, 2829, 2832, 2835, 
	2838, 2841, 2844, 2847, 2850, 2853, 2856, 2859, 
	2862, 2865, 2868, 2871, 2874, 2877, 2881, 2884, 
	2887, 2890, 2893, 2896, 2899, 2902, 2905, 2908, 
	2911, 2914, 2917, 2920, 2923, 2926, 2929, 2932, 
	2935, 2938, 2941, 2944, 2947, 2950, 2953, 2956, 
	2959, 2962, 2965, 2968, 2971, 2974, 2977, 2980, 
	2983, 2986, 2989, 2992, 2995, 2998, 3001, 3004, 
	3007, 3010, 3013, 3015, 3017, 3021, 3023, 3025, 
	3027, 3029, 3031, 3033, 3035, 3037, 3039, 3041, 
	3043, 3045, 3047, 3049, 3051, 3053, 3055, 3057, 
	3066, 3070, 3076, 3079, 3082, 3085, 3088, 3091, 
	3094, 3097, 3100, 3103, 3106, 3109, 3112, 3115, 
	3118, 3121, 3124, 3127, 3130, 3133, 3136, 3139, 
	3142, 3145, 3148, 3151, 3154, 3157, 3160, 3163, 
	3166, 3169, 3172, 3175, 3179, 3182, 3185, 3188, 
	3191, 3194, 3197, 3200, 3203, 3206, 3209, 3212, 
	3215, 3218, 3221, 3224, 3227, 3230, 3233, 3236, 
	3239, 3242, 3245, 3248, 3251, 3254, 3257, 3260, 
	3263, 3266, 3269, 3272, 3275, 3278, 3281, 3284, 
	3287, 3290, 3293, 3296, 3299, 3302, 3305, 3308, 
	3311, 3314, 3317, 3320, 3323, 3326, 3329, 3332, 
	3335, 3338, 3341, 3344, 3347, 3350, 3353, 3356, 
	3359, 3362, 3365, 3368, 3371, 3374, 3377, 3380, 
	3383, 3386, 3389, 3392, 3395, 3398, 3401, 3404, 
	3407, 3410, 3413, 3416, 3419, 3422, 3425, 3428, 
	3431, 3434, 3437, 3440, 3443, 3446, 3449, 3452, 
	3455, 3458, 3461, 3464, 3467, 3470, 3473, 3476, 
	3479, 3482, 3485, 3488, 3491, 3494, 3497, 3500, 
	3503, 3506, 3509, 3512, 3515, 3518, 3521, 3524, 
	3529, 3532, 3535, 3539, 3542, 3545, 3548, 3551, 
	3554, 3557, 3560, 3563, 3566, 3569, 3572, 3576, 
	3579, 3582, 3585, 3588, 3591, 3594, 3597, 3600, 
	3603, 3606, 3609, 3612, 3615, 3618, 3621, 3624, 
	3627, 3631, 3634, 3637, 3640, 3643, 3646, 3649, 
	3652, 3655, 3658, 3661, 3664, 3667, 3670, 3673, 
	3676, 3679, 3682, 3685, 3688, 3691, 3694, 3697, 
	3700, 3703, 3706, 3709, 3712, 3715, 3718, 3721, 
	3724, 3727, 3730, 3733, 3736, 3739, 3742, 3745, 
	3748, 3751, 3754, 3757, 3760, 3763, 3765, 3767, 
	3769, 3771, 3773, 3775, 3777, 3779, 3781, 3783, 
	3785, 3787, 3789, 3791, 3794, 3796, 3798, 3800, 
	3802, 3804, 3806, 3808, 3810, 3812, 3814, 3816, 
	3818, 3820, 3822, 3824, 3826, 3828, 3830, 3832, 
	3834, 3836, 3838, 3840, 3842, 3844, 3846, 3848, 
	3850, 3852, 3854, 3856, 3858
};

static const short _lexer_trans_targs[] = {
	2, 1354, 28, 28, 29, 39, 41, 25, 
	55, 58, 28, 0, 3, 779, 0, 4, 
	64, 363, 528, 546, 0, 5, 0, 6, 
	0, 7, 0, 8, 0, 9, 0, 10, 
	0, 11, 0, 12, 0, 13, 0, 14, 
	0, 15, 0, 16, 0, 17, 0, 18, 
	0, 19, 0, 20, 0, 21, 0, 22, 
	0, 23, 0, 24, 0, 25, 0, 26, 
	0, 28, 40, 27, 28, 40, 27, 2, 
	28, 28, 29, 39, 41, 25, 55, 58, 
	28, 0, 30, 0, 31, 0, 33, 32, 
	32, 33, 32, 32, 34, 34, 35, 34, 
	34, 34, 34, 35, 34, 34, 34, 34, 
	36, 34, 34, 34, 34, 37, 34, 34, 
	28, 38, 38, 0, 28, 38, 38, 0, 
	28, 40, 39, 28, 0, 42, 0, 43, 
	0, 44, 0, 45, 0, 46, 0, 47, 
	0, 48, 0, 49, 0, 50, 0, 51, 
	0, 52, 0, 53, 0, 54, 0, 1356, 
	0, 0, 0, 0, 0, 56, 57, 28, 
	57, 57, 55, 56, 56, 28, 57, 55, 
	57, 0, 58, 59, 58, 0, 63, 62, 
	61, 59, 62, 60, 0, 61, 59, 60, 
	0, 61, 60, 63, 62, 61, 59, 62, 
	60, 2, 63, 63, 29, 39, 41, 25, 
	55, 58, 63, 0, 65, 0, 66, 0, 
	67, 0, 68, 0, 69, 0, 70, 0, 
	71, 0, 72, 0, 73, 0, 74, 0, 
	75, 0, 76, 348, 0, 77, 0, 78, 
	0, 79, 0, 80, 0, 81, 0, 82, 
	0, 83, 0, 84, 0, 85, 0, 86, 
	0, 87, 0, 88, 0, 89, 0, 90, 
	0, 91, 0, 92, 0, 93, 0, 94, 
	0, 95, 0, 96, 0, 97, 0, 98, 
	0, 99, 0, 100, 0, 101, 0, 102, 
	0, 103, 0, 104, 0, 105, 0, 106, 
	0, 107, 0, 108, 0, 109, 0, 110, 
	0, 111, 0, 112, 0, 113, 0, 114, 
	0, 115, 0, 116, 0, 117, 0, 118, 
	0, 119, 0, 120, 0, 121, 0, 122, 
	0, 124, 123, 124, 123, 125, 124, 124, 
	28, 334, 28, 124, 123, 126, 276, 124, 
	123, 127, 201, 265, 124, 123, 128, 124, 
	123, 129, 124, 123, 130, 124, 123, 131, 
	124, 123, 132, 124, 123, 133, 124, 123, 
	134, 124, 123, 135, 124, 123, 136, 124, 
	123, 137, 124, 123, 138, 124, 123, 139, 
	186, 124, 123, 140, 124, 123, 141, 124, 
	123, 142, 124, 123, 143, 124, 123, 144, 
	124, 123, 145, 124, 123, 146, 124, 123, 
	147, 124, 123, 148, 124, 123, 149, 124, 
	123, 150, 124, 123, 151, 124, 123, 152, 
	124, 123, 153, 124, 123, 154, 124, 123, 
	155, 124, 123, 156, 124, 123, 157, 124, 
	123, 158, 124, 123, 159, 124, 123, 160, 
	124, 123, 161, 124, 123, 162, 124, 123, 
	163, 124, 123, 164, 124, 123, 165, 124, 
	123, 166, 124, 123, 167, 124, 123, 168, 
	124, 123, 169, 124, 123, 170, 124, 123, 
	171, 124, 123, 172, 124, 123, 173, 124, 
	123, 174, 124, 123, 175, 124, 123, 176, 
	124, 123, 177, 124, 123, 178, 124, 123, 
	179, 124, 123, 180, 124, 123, 181, 124, 
	123, 182, 124, 123, 183, 124, 123, 184, 
	124, 123, 124, 185, 123, 2, 28, 28, 
	29, 39, 41, 25, 55, 58, 28, 0, 
	187, 124, 123, 188, 124, 123, 189, 124, 
	123, 190, 124, 123, 191, 124, 123, 192, 
	124, 123, 193, 124, 123, 194, 124, 123, 
	195, 124, 123, 196, 124, 123, 197, 124, 
	123, 198, 124, 123, 199, 124, 123, 200, 
	124, 123, 184, 124, 123, 202, 124, 123, 
	203, 124, 123, 204, 124, 123, 205, 124, 
	123, 206, 124, 123, 207, 124, 123, 208, 
	124, 123, 209, 124, 123, 210, 124, 123, 
	211, 124, 123, 212, 124, 123, 213, 124, 
	123, 214, 124, 123, 215, 124, 123, 216, 
	124, 123, 217, 124, 123, 218, 240, 124, 
	123, 219, 124, 123, 220, 124, 123, 221, 
	124, 123, 222, 124, 123, 223, 124, 123, 
	224, 124, 123, 225, 124, 123, 226, 124, 
	123, 227, 124, 123, 228, 124, 123, 229, 
	124, 123, 230, 124, 123, 231, 124, 123, 
	232, 124, 123, 233, 124, 123, 234, 124, 
	123, 235, 124, 123, 236, 124, 123, 237, 
	124, 123, 238, 124, 123, 239, 124, 123, 
	184, 124, 123, 241, 124, 123, 242, 124, 
	123, 243, 124, 123, 244, 124, 123, 245, 
	124, 123, 246, 124, 123, 247, 124, 123, 
	248, 124, 123, 249, 124, 123, 250, 124, 
	123, 251, 124, 123, 252, 124, 123, 253, 
	124, 123, 254, 124, 123, 255, 124, 123, 
	256, 124, 123, 257, 124, 123, 258, 124, 
	123, 259, 124, 123, 260, 124, 123, 261, 
	124, 123, 262, 124, 123, 263, 124, 123, 
	264, 124, 123, 184, 124, 123, 266, 124, 
	123, 267, 124, 123, 268, 124, 123, 269, 
	124, 123, 270, 124, 123, 271, 124, 123, 
	272, 124, 123, 273, 124, 123, 274, 124, 
	123, 275, 124, 123, 240, 124, 123, 241, 
	277, 292, 124, 123, 278, 124, 123, 279, 
	124, 123, 280, 124, 123, 281, 124, 123, 
	282, 124, 123, 283, 124, 123, 284, 124, 
	123, 285, 124, 123, 286, 124, 123, 287, 
	124, 123, 288, 124, 123, 289, 124, 123, 
	290, 124, 123, 291, 124, 123, 184, 124, 
	123, 293, 124, 123, 294, 124, 123, 295, 
	124, 123, 296, 124, 123, 297, 124, 123, 
	298, 124, 123, 299, 124, 123, 300, 124, 
	123, 301, 124, 123, 302, 124, 123, 303, 
	124, 123, 304, 325, 124, 123, 305, 124, 
	123, 306, 124, 123, 307, 124, 123, 308, 
	124, 123, 309, 124, 123, 310, 124, 123, 
	311, 124, 123, 312, 124, 123, 313, 124, 
	123, 314, 124, 123, 315, 124, 123, 316, 
	124, 123, 317, 124, 123, 318, 124, 123, 
	319, 124, 123, 320, 124, 123, 321, 124, 
	123, 322, 124, 123, 323, 124, 123, 324, 
	124, 123, 274, 124, 123, 326, 124, 123, 
	327, 124, 123, 328, 124, 123, 329, 124, 
	123, 330, 124, 123, 331, 124, 123, 332, 
	124, 123, 333, 124, 123, 184, 124, 123, 
	124, 335, 123, 124, 336, 123, 124, 337, 
	123, 124, 338, 123, 124, 339, 123, 124, 
	340, 123, 124, 341, 123, 124, 342, 123, 
	124, 343, 123, 124, 344, 123, 124, 345, 
	123, 124, 346, 123, 124, 347, 123, 124, 
	28, 123, 349, 0, 350, 0, 351, 0, 
	352, 0, 353, 0, 354, 0, 355, 0, 
	356, 0, 357, 0, 358, 0, 359, 0, 
	360, 0, 361, 0, 362, 0, 121, 0, 
	364, 0, 365, 0, 366, 0, 367, 0, 
	368, 0, 369, 0, 370, 0, 371, 0, 
	372, 0, 373, 0, 374, 0, 375, 0, 
	376, 0, 377, 0, 378, 0, 379, 0, 
	380, 503, 0, 381, 0, 382, 0, 383, 
	0, 384, 0, 385, 0, 386, 0, 387, 
	0, 388, 0, 389, 0, 390, 0, 391, 
	0, 392, 0, 393, 0, 394, 0, 395, 
	0, 396, 0, 397, 0, 398, 0, 399, 
	0, 400, 0, 401, 0, 402, 0, 403, 
	0, 405, 404, 405, 404, 406, 405, 405, 
	28, 28, 405, 404, 407, 481, 405, 404, 
	408, 405, 404, 409, 405, 404, 410, 405, 
	404, 411, 405, 404, 412, 405, 404, 413, 
	405, 404, 414, 405, 404, 415, 405, 404, 
	416, 405, 404, 417, 405, 404, 418, 405, 
	404, 419, 405, 404, 420, 466, 405, 404, 
	421, 405, 404, 422, 405, 404, 423, 405, 
	404, 424, 405, 404, 425, 405, 404, 426, 
	405, 404, 427, 405, 404, 428, 405, 404, 
	429, 405, 404, 430, 405, 404, 431, 405, 
	404, 432, 405, 404, 433, 405, 404, 434, 
	405, 404, 435, 405, 404, 436, 405, 404, 
	437, 405, 404, 438, 405, 404, 439, 405, 
	404, 440, 405, 404, 441, 405, 404, 442, 
	405, 404, 443, 405, 404, 444, 405, 404, 
	445, 405, 404, 446, 405, 404, 447, 405, 
	404, 448, 405, 404, 449, 405, 404, 450, 
	405, 404, 451, 405, 404, 452, 405, 404, 
	453, 405, 404, 454, 405, 404, 455, 405, 
	404, 456, 405, 404, 457, 405, 404, 458, 
	405, 404, 459, 405, 404, 460, 405, 404, 
	461, 405, 404, 462, 405, 404, 463, 405, 
	404, 464, 405, 404, 465, 405, 404, 405, 
	185, 404, 467, 405, 404, 468, 405, 404, 
	469, 405, 404, 470, 405, 404, 471, 405, 
	404, 472, 405, 404, 473, 405, 404, 474, 
	405, 404, 475, 405, 404, 476, 405, 404, 
	477, 405, 404, 478, 405, 404, 479, 405, 
	404, 480, 405, 404, 465, 405, 404, 482, 
	405, 404, 483, 405, 404, 484, 405, 404, 
	485, 405, 404, 486, 405, 404, 487, 405, 
	404, 488, 405, 404, 489, 405, 404, 490, 
	405, 404, 491, 405, 404, 492, 405, 404, 
	493, 405, 404, 494, 405, 404, 495, 405, 
	404, 496, 405, 404, 497, 405, 404, 498, 
	405, 404, 499, 405, 404, 500, 405, 404, 
	501, 405, 404, 502, 405, 404, 465, 405, 
	404, 504, 0, 505, 0, 506, 0, 507, 
	0, 508, 0, 509, 0, 510, 0, 511, 
	0, 512, 0, 513, 0, 514, 0, 515, 
	0, 516, 0, 517, 0, 518, 0, 519, 
	0, 520, 0, 521, 0, 522, 0, 523, 
	0, 524, 0, 525, 0, 526, 0, 527, 
	0, 402, 0, 529, 0, 530, 0, 531, 
	0, 532, 0, 533, 0, 534, 0, 535, 
	0, 536, 0, 537, 0, 538, 0, 539, 
	0, 540, 0, 541, 0, 542, 0, 543, 
	0, 544, 0, 545, 0, 25, 0, 547, 
	0, 548, 0, 549, 0, 550, 0, 551, 
	0, 552, 0, 553, 0, 554, 0, 555, 
	0, 556, 0, 557, 0, 558, 0, 559, 
	0, 560, 0, 561, 0, 562, 0, 563, 
	0, 564, 0, 565, 0, 566, 0, 567, 
	0, 568, 0, 569, 0, 570, 0, 571, 
	0, 572, 0, 573, 0, 574, 0, 575, 
	0, 576, 0, 577, 0, 578, 0, 579, 
	0, 580, 0, 581, 0, 582, 0, 583, 
	0, 585, 584, 585, 584, 586, 585, 585, 
	28, 765, 609, 28, 585, 584, 587, 701, 
	585, 584, 588, 610, 683, 585, 584, 589, 
	585, 584, 590, 585, 584, 591, 585, 584, 
	592, 585, 584, 593, 585, 584, 594, 585, 
	584, 595, 585, 584, 596, 585, 584, 597, 
	585, 584, 598, 585, 584, 599, 585, 584, 
	600, 585, 584, 601, 585, 584, 602, 585, 
	584, 603, 585, 584, 604, 585, 584, 605, 
	585, 584, 606, 585, 584, 607, 585, 584, 
	608, 585, 584, 609, 585, 584, 585, 185, 
	584, 611, 585, 584, 612, 585, 584, 613, 
	585, 584, 614, 585, 584, 615, 585, 584, 
	616, 585, 584, 617, 585, 584, 618, 585, 
	584, 619, 585, 584, 620, 585, 584, 621, 
	585, 584, 622, 668, 585, 584, 623, 585, 
	584, 624, 585, 584, 625, 585, 584, 626, 
	585, 584, 627, 585, 584, 628, 585, 584, 
	629, 585, 584, 630, 585, 584, 631, 585, 
	584, 632, 585, 584, 633, 585, 584, 634, 
	585, 584, 635, 585, 584, 636, 585, 584, 
	637, 585, 584, 638, 585, 584, 639, 585, 
	584, 640, 585, 584, 641, 585, 584, 642, 
	585, 584, 643, 585, 584, 644, 585, 584, 
	645, 585, 584, 646, 585, 584, 647, 585, 
	584, 648, 585, 584, 649, 585, 584, 650, 
	585, 584, 651, 585, 584, 652, 585, 584, 
	653, 585, 584, 654, 585, 584, 655, 585, 
	584, 656, 585, 584, 657, 585, 584, 658, 
	585, 584, 659, 585, 584, 660, 585, 584, 
	661, 585, 584, 662, 585, 584, 663, 585, 
	584, 664, 585, 584, 665, 585, 584, 666, 
	585, 584, 667, 585, 584, 585, 185, 584, 
	669, 585, 584, 670, 585, 584, 671, 585, 
	584, 672, 585, 584, 673, 585, 584, 674, 
	585, 584, 675, 585, 584, 676, 585, 584, 
	677, 585, 584, 678, 585, 584, 679, 585, 
	584, 680, 585, 584, 681, 585, 584, 682, 
	585, 584, 667, 585, 584, 684, 585, 584, 
	685, 585, 584, 686, 585, 584, 687, 585, 
	584, 688, 585, 584, 689, 585, 584, 690, 
	585, 584, 691, 585, 584, 692, 585, 584, 
	693, 585, 584, 694, 585, 584, 695, 585, 
	584, 696, 585, 584, 697, 585, 584, 698, 
	585, 584, 699, 585, 584, 700, 585, 584, 
	609, 585, 584, 702, 735, 744, 585, 584, 
	703, 585, 584, 704, 585, 584, 705, 714, 
	585, 584, 706, 585, 584, 707, 585, 584, 
	708, 585, 584, 709, 585, 584, 710, 585, 
	584, 711, 585, 584, 712, 585, 584, 713, 
	585, 584, 609, 585, 584, 715, 585, 584, 
	716, 585, 584, 717, 585, 584, 718, 585, 
	584, 719, 585, 584, 720, 585, 584, 721, 
	585, 584, 722, 585, 584, 723, 585, 584, 
	724, 585, 584, 725, 585, 584, 726, 585, 
	584, 727, 585, 584, 728, 585, 584, 729, 
	585, 584, 730, 585, 584, 731, 585, 584, 
	732, 585, 584, 733, 585, 584, 734, 585, 
	584, 667, 585, 584, 736, 585, 584, 737, 
	585, 584, 738, 741, 585, 584, 739, 585, 
	584, 740, 585, 584, 609, 585, 584, 742, 
	585, 584, 743, 585, 584, 609, 585, 584, 
	745, 585, 584, 746, 585, 584, 747, 585, 
	584, 748, 585, 584, 749, 585, 584, 750, 
	585, 584, 751, 585, 584, 752, 585, 584, 
	753, 585, 584, 754, 585, 584, 755, 585, 
	584, 756, 585, 584, 757, 585, 584, 758, 
	585, 584, 759, 585, 584, 760, 585, 584, 
	761, 585, 584, 762, 585, 584, 763, 585, 
	584, 764, 585, 584, 667, 585, 584, 585, 
	766, 584, 585, 767, 584, 585, 768, 584, 
	585, 769, 584, 585, 770, 584, 585, 771, 
	584, 585, 772, 584, 585, 773, 584, 585, 
	774, 584, 585, 775, 584, 585, 776, 584, 
	585, 777, 584, 585, 778, 584, 585, 28, 
	584, 780, 1058, 1312, 0, 781, 0, 782, 
	0, 783, 792, 0, 784, 0, 785, 0, 
	786, 0, 787, 0, 788, 0, 789, 0, 
	790, 0, 791, 0, 25, 0, 793, 0, 
	794, 0, 795, 0, 796, 0, 797, 0, 
	798, 0, 799, 0, 800, 0, 801, 0, 
	802, 0, 803, 0, 804, 0, 805, 0, 
	806, 0, 807, 0, 808, 0, 809, 0, 
	810, 0, 811, 0, 812, 0, 813, 0, 
	814, 0, 816, 815, 816, 815, 817, 816, 
	816, 28, 1044, 840, 28, 816, 815, 818, 
	968, 816, 815, 819, 841, 914, 932, 816, 
	815, 820, 816, 815, 821, 816, 815, 822, 
	816, 815, 823, 816, 815, 824, 816, 815, 
	825, 816, 815, 826, 816, 815, 827, 816, 
	815, 828, 816, 815, 829, 816, 815, 830, 
	816, 815, 831, 816, 815, 832, 816, 815, 
	833, 816, 815, 834, 816, 815, 835, 816, 
	815, 836, 816, 815, 837, 816, 815, 838, 
	816, 815, 839, 816, 815, 840, 816, 815, 
	816, 185, 815, 842, 816, 815, 843, 816, 
	815, 844, 816, 815, 845, 816, 815, 846, 
	816, 815, 847, 816, 815, 848, 816, 815, 
	849, 816, 815, 850, 816, 815, 851, 816, 
	815, 852, 816, 815, 853, 899, 816, 815, 
	854, 816, 815, 855, 816, 815, 856, 816, 
	815, 857, 816, 815, 858, 816, 815, 859, 
	816, 815, 860, 816, 815, 861, 816, 815, 
	862, 816, 815, 863, 816, 815, 864, 816, 
	815, 865, 816, 815, 866, 816, 815, 867, 
	816, 815, 868, 816, 815, 869, 816, 815, 
	870, 816, 815, 871, 816, 815, 872, 816, 
	815, 873, 816, 815, 874, 816, 815, 875, 
	816, 815, 876, 816, 815, 877, 816, 815, 
	878, 816, 815, 879, 816, 815, 880, 816, 
	815, 881, 816, 815, 882, 816, 815, 883, 
	816, 815, 884, 816, 815, 885, 816, 815, 
	886, 816, 815, 887, 816, 815, 888, 816, 
	815, 889, 816, 815, 890, 816, 815, 891, 
	816, 815, 892, 816, 815, 893, 816, 815, 
	894, 816, 815, 895, 816, 815, 896, 816, 
	815, 897, 816, 815, 898, 816, 815, 816, 
	185, 815, 900, 816, 815, 901, 816, 815, 
	902, 816, 815, 903, 816, 815, 904, 816, 
	815, 905, 816, 815, 906, 816, 815, 907, 
	816, 815, 908, 816, 815, 909, 816, 815, 
	910, 816, 815, 911, 816, 815, 912, 816, 
	815, 913, 816, 815, 898, 816, 815, 915, 
	816, 815, 916, 816, 815, 917, 816, 815, 
	918, 816, 815, 919, 816, 815, 920, 816, 
	815, 921, 816, 815, 922, 816, 815, 923, 
	816, 815, 924, 816, 815, 925, 816, 815, 
	926, 816, 815, 927, 816, 815, 928, 816, 
	815, 929, 816, 815, 930, 816, 815, 931, 
	816, 815, 840, 816, 815, 933, 816, 815, 
	934, 816, 815, 935, 816, 815, 936, 816, 
	815, 937, 816, 815, 938, 816, 815, 939, 
	816, 815, 940, 816, 815, 941, 816, 815, 
	942, 816, 815, 943, 816, 815, 944, 816, 
	815, 945, 816, 815, 946, 816, 815, 947, 
	816, 815, 948, 816, 815, 949, 816, 815, 
	950, 816, 815, 951, 816, 815, 952, 816, 
	815, 953, 816, 815, 954, 816, 815, 955, 
	816, 815, 956, 816, 815, 957, 816, 815, 
	958, 816, 815, 959, 816, 815, 960, 816, 
	815, 961, 816, 815, 962, 816, 815, 963, 
	816, 815, 964, 816, 815, 965, 816, 815, 
	966, 816, 815, 967, 816, 815, 898, 816, 
	815, 969, 981, 1002, 816, 815, 970, 816, 
	815, 971, 816, 815, 972, 947, 816, 815, 
	973, 816, 815, 974, 816, 815, 975, 816, 
	815, 976, 816, 815, 977, 816, 815, 978, 
	816, 815, 979, 816, 815, 980, 816, 815, 
	840, 816, 815, 982, 816, 815, 983, 816, 
	815, 984, 987, 999, 816, 815, 985, 816, 
	815, 986, 816, 815, 840, 816, 815, 988, 
	816, 815, 989, 816, 815, 990, 816, 815, 
	991, 816, 815, 992, 816, 815, 993, 816, 
	815, 994, 816, 815, 995, 816, 815, 996, 
	816, 815, 997, 816, 815, 998, 816, 815, 
	898, 816, 815, 1000, 816, 815, 1001, 816, 
	815, 840, 816, 815, 1003, 816, 815, 1004, 
	816, 815, 1005, 816, 815, 1006, 816, 815, 
	1007, 816, 815, 1008, 816, 815, 1009, 816, 
	815, 1010, 816, 815, 1011, 816, 815, 1012, 
	816, 815, 1013, 816, 815, 1014, 1035, 816, 
	815, 1015, 816, 815, 1016, 816, 815, 1017, 
	816, 815, 1018, 816, 815, 1019, 816, 815, 
	1020, 816, 815, 1021, 816, 815, 1022, 816, 
	815, 1023, 816, 815, 1024, 816, 815, 1025, 
	816, 815, 1026, 816, 815, 1027, 816, 815, 
	1028, 816, 815, 1029, 816, 815, 1030, 816, 
	815, 1031, 816, 815, 1032, 816, 815, 1033, 
	816, 815, 1034, 816, 815, 941, 816, 815, 
	1036, 816, 815, 1037, 816, 815, 1038, 816, 
	815, 1039, 816, 815, 1040, 816, 815, 1041, 
	816, 815, 1042, 816, 815, 1043, 816, 815, 
	898, 816, 815, 816, 1045, 815, 816, 1046, 
	815, 816, 1047, 815, 816, 1048, 815, 816, 
	1049, 815, 816, 1050, 815, 816, 1051, 815, 
	816, 1052, 815, 816, 1053, 815, 816, 1054, 
	815, 816, 1055, 815, 816, 1056, 815, 816, 
	1057, 815, 816, 28, 815, 1059, 0, 1060, 
	0, 1061, 1064, 1309, 0, 1062, 0, 1063, 
	0, 25, 0, 1065, 0, 1066, 0, 1067, 
	0, 1068, 0, 1069, 0, 1070, 0, 1071, 
	0, 1072, 0, 1073, 0, 1074, 0, 1075, 
	0, 1076, 0, 1077, 0, 1079, 1078, 1079, 
	1078, 1080, 1079, 1079, 28, 1295, 1103, 28, 
	1079, 1078, 1081, 1231, 1079, 1078, 1082, 1104, 
	1177, 1195, 1079, 1078, 1083, 1079, 1078, 1084, 
	1079, 1078, 1085, 1079, 1078, 1086, 1079, 1078, 
	1087, 1079, 1078, 1088, 1079, 1078, 1089, 1079, 
	1078, 1090, 1079, 1078, 1091, 1079, 1078, 1092, 
	1079, 1078, 1093, 1079, 1078, 1094, 1079, 1078, 
	1095, 1079, 1078, 1096, 1079, 1078, 1097, 1079, 
	1078, 1098, 1079, 1078, 1099, 1079, 1078, 1100, 
	1079, 1078, 1101, 1079, 1078, 1102, 1079, 1078, 
	1103, 1079, 1078, 1079, 185, 1078, 1105, 1079, 
	1078, 1106, 1079, 1078, 1107, 1079, 1078, 1108, 
	1079, 1078, 1109, 1079, 1078, 1110, 1079, 1078, 
	1111, 1079, 1078, 1112, 1079, 1078, 1113, 1079, 
	1078, 1114, 1079, 1078, 1115, 1079, 1078, 1116, 
	1162, 1079, 1078, 1117, 1079, 1078, 1118, 1079, 
	1078, 1119, 1079, 1078, 1120, 1079, 1078, 1121, 
	1079, 1078, 1122, 1079, 1078, 1123, 1079, 1078, 
	1124, 1079, 1078, 1125, 1079, 1078, 1126, 1079, 
	1078, 1127, 1079, 1078, 1128, 1079, 1078, 1129, 
	1079, 1078, 1130, 1079, 1078, 1131, 1079, 1078, 
	1132, 1079, 1078, 1133, 1079, 1078, 1134, 1079, 
	1078, 1135, 1079, 1078, 1136, 1079, 1078, 1137, 
	1079, 1078, 1138, 1079, 1078, 1139, 1079, 1078, 
	1140, 1079, 1078, 1141, 1079, 1078, 1142, 1079, 
	1078, 1143, 1079, 1078, 1144, 1079, 1078, 1145, 
	1079, 1078, 1146, 1079, 1078, 1147, 1079, 1078, 
	1148, 1079, 1078, 1149, 1079, 1078, 1150, 1079, 
	1078, 1151, 1079, 1078, 1152, 1079, 1078, 1153, 
	1079, 1078, 1154, 1079, 1078, 1155, 1079, 1078, 
	1156, 1079, 1078, 1157, 1079, 1078, 1158, 1079, 
	1078, 1159, 1079, 1078, 1160, 1079, 1078, 1161, 
	1079, 1078, 1079, 185, 1078, 1163, 1079, 1078, 
	1164, 1079, 1078, 1165, 1079, 1078, 1166, 1079, 
	1078, 1167, 1079, 1078, 1168, 1079, 1078, 1169, 
	1079, 1078, 1170, 1079, 1078, 1171, 1079, 1078, 
	1172, 1079, 1078, 1173, 1079, 1078, 1174, 1079, 
	1078, 1175, 1079, 1078, 1176, 1079, 1078, 1161, 
	1079, 1078, 1178, 1079, 1078, 1179, 1079, 1078, 
	1180, 1079, 1078, 1181, 1079, 1078, 1182, 1079, 
	1078, 1183, 1079, 1078, 1184, 1079, 1078, 1185, 
	1079, 1078, 1186, 1079, 1078, 1187, 1079, 1078, 
	1188, 1079, 1078, 1189, 1079, 1078, 1190, 1079, 
	1078, 1191, 1079, 1078, 1192, 1079, 1078, 1193, 
	1079, 1078, 1194, 1079, 1078, 1103, 1079, 1078, 
	1196, 1079, 1078, 1197, 1079, 1078, 1198, 1079, 
	1078, 1199, 1079, 1078, 1200, 1079, 1078, 1201, 
	1079, 1078, 1202, 1079, 1078, 1203, 1079, 1078, 
	1204, 1079, 1078, 1205, 1079, 1078, 1206, 1079, 
	1078, 1207, 1079, 1078, 1208, 1079, 1078, 1209, 
	1079, 1078, 1210, 1079, 1078, 1211, 1079, 1078, 
	1212, 1079, 1078, 1213, 1079, 1078, 1214, 1079, 
	1078, 1215, 1079, 1078, 1216, 1079, 1078, 1217, 
	1079, 1078, 1218, 1079, 1078, 1219, 1079, 1078, 
	1220, 1079, 1078, 1221, 1079, 1078, 1222, 1079, 
	1078, 1223, 1079, 1078, 1224, 1079, 1078, 1225, 
	1079, 1078, 1226, 1079, 1078, 1227, 1079, 1078, 
	1228, 1079, 1078, 1229, 1079, 1078, 1230, 1079, 
	1078, 1161, 1079, 1078, 1232, 1244, 1253, 1079, 
	1078, 1233, 1079, 1078, 1234, 1079, 1078, 1235, 
	1210, 1079, 1078, 1236, 1079, 1078, 1237, 1079, 
	1078, 1238, 1079, 1078, 1239, 1079, 1078, 1240, 
	1079, 1078, 1241, 1079, 1078, 1242, 1079, 1078, 
	1243, 1079, 1078, 1103, 1079, 1078, 1245, 1079, 
	1078, 1246, 1079, 1078, 1247, 1250, 1079, 1078, 
	1248, 1079, 1078, 1249, 1079, 1078, 1103, 1079, 
	1078, 1251, 1079, 1078, 1252, 1079, 1078, 1103, 
	1079, 1078, 1254, 1079, 1078, 1255, 1079, 1078, 
	1256, 1079, 1078, 1257, 1079, 1078, 1258, 1079, 
	1078, 1259, 1079, 1078, 1260, 1079, 1078, 1261, 
	1079, 1078, 1262, 1079, 1078, 1263, 1079, 1078, 
	1264, 1079, 1078, 1265, 1286, 1079, 1078, 1266, 
	1079, 1078, 1267, 1079, 1078, 1268, 1079, 1078, 
	1269, 1079, 1078, 1270, 1079, 1078, 1271, 1079, 
	1078, 1272, 1079, 1078, 1273, 1079, 1078, 1274, 
	1079, 1078, 1275, 1079, 1078, 1276, 1079, 1078, 
	1277, 1079, 1078, 1278, 1079, 1078, 1279, 1079, 
	1078, 1280, 1079, 1078, 1281, 1079, 1078, 1282, 
	1079, 1078, 1283, 1079, 1078, 1284, 1079, 1078, 
	1285, 1079, 1078, 1204, 1079, 1078, 1287, 1079, 
	1078, 1288, 1079, 1078, 1289, 1079, 1078, 1290, 
	1079, 1078, 1291, 1079, 1078, 1292, 1079, 1078, 
	1293, 1079, 1078, 1294, 1079, 1078, 1161, 1079, 
	1078, 1079, 1296, 1078, 1079, 1297, 1078, 1079, 
	1298, 1078, 1079, 1299, 1078, 1079, 1300, 1078, 
	1079, 1301, 1078, 1079, 1302, 1078, 1079, 1303, 
	1078, 1079, 1304, 1078, 1079, 1305, 1078, 1079, 
	1306, 1078, 1079, 1307, 1078, 1079, 1308, 1078, 
	1079, 28, 1078, 1310, 0, 1311, 0, 25, 
	0, 1313, 0, 1314, 0, 1315, 0, 1316, 
	0, 1317, 0, 1318, 0, 1319, 0, 1320, 
	0, 1321, 0, 1322, 0, 1323, 0, 1324, 
	1345, 0, 1325, 0, 1326, 0, 1327, 0, 
	1328, 0, 1329, 0, 1330, 0, 1331, 0, 
	1332, 0, 1333, 0, 1334, 0, 1335, 0, 
	1336, 0, 1337, 0, 1338, 0, 1339, 0, 
	1340, 0, 1341, 0, 1342, 0, 1343, 0, 
	1344, 0, 555, 0, 1346, 0, 1347, 0, 
	1348, 0, 1349, 0, 1350, 0, 1351, 0, 
	1352, 0, 1353, 0, 121, 0, 1355, 0, 
	28, 0, 0, 0
};

static const unsigned char _lexer_trans_actions[] = {
	29, 0, 54, 0, 5, 1, 0, 29, 
	1, 35, 0, 43, 0, 0, 43, 0, 
	0, 0, 0, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 149, 126, 57, 110, 23, 0, 29, 
	54, 0, 5, 1, 0, 29, 1, 35, 
	0, 43, 0, 43, 0, 43, 139, 48, 
	9, 106, 11, 0, 134, 45, 45, 45, 
	3, 122, 33, 33, 33, 0, 122, 33, 
	33, 33, 0, 122, 33, 0, 33, 0, 
	102, 7, 7, 43, 54, 0, 0, 43, 
	114, 25, 0, 54, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 43, 43, 43, 43, 0, 27, 118, 
	27, 27, 51, 27, 0, 54, 0, 1, 
	0, 43, 0, 0, 0, 43, 54, 37, 
	37, 87, 37, 37, 43, 0, 39, 0, 
	43, 0, 0, 54, 0, 0, 39, 0, 
	0, 96, 54, 0, 93, 90, 41, 96, 
	90, 99, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 144, 57, 54, 0, 84, 54, 0, 
	69, 33, 69, 0, 0, 0, 0, 54, 
	0, 0, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 54, 13, 0, 63, 130, 31, 
	60, 57, 31, 63, 57, 66, 31, 43, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	13, 0, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 144, 57, 54, 0, 84, 54, 0, 
	81, 81, 0, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 54, 
	21, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 144, 57, 54, 0, 84, 54, 0, 
	78, 33, 84, 78, 0, 0, 0, 0, 
	54, 0, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 54, 19, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 54, 19, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 19, 
	0, 0, 0, 0, 43, 0, 43, 0, 
	43, 0, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 144, 57, 54, 0, 84, 54, 
	0, 75, 33, 84, 75, 0, 0, 0, 
	0, 54, 0, 0, 0, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	54, 17, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 54, 
	17, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 17, 0, 0, 43, 0, 
	43, 0, 0, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 144, 57, 54, 
	0, 84, 54, 0, 72, 33, 84, 72, 
	0, 0, 0, 0, 54, 0, 0, 0, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 54, 15, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 54, 15, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 15, 0, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 0
};

static const unsigned char _lexer_eof_actions[] = {
	0, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43
};

static const int lexer_start = 1;
static const int lexer_first_final = 1356;
static const int lexer_error = 0;

static const int lexer_en_main = 1;


#line 258 "ragel/i18n/th.c.rl"

static VALUE 
unindent(VALUE con, int start_col)
{
  VALUE re;
  /* Gherkin will crash gracefully if the string representation of start_col pushes the pattern past 32 characters */
  char pat[32]; 
  snprintf(pat, 32, "^[\t ]{0,%d}", start_col); 
  re = rb_reg_regcomp(rb_str_new2(pat));
  rb_funcall(con, rb_intern("gsub!"), 2, re, rb_str_new2(""));

  return Qnil;

}

static void 
store_kw_con(VALUE listener, const char * event_name, 
             const char * keyword_at, size_t keyword_length, 
             const char * at,         size_t length, 
             int current_line)
{
  VALUE con = Qnil, kw = Qnil;
  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);
  rb_funcall(con, rb_intern("strip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 3, kw, con, INT2FIX(current_line)); 
}

static void
store_multiline_kw_con(VALUE listener, const char * event_name,
                      const char * keyword_at, size_t keyword_length,
                      const char * at,         size_t length,
                      int current_line, int start_col)
{
  VALUE split;
  VALUE con = Qnil, kw = Qnil, name = Qnil, desc = Qnil;

  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);

  unindent(con, start_col);
  
  split = rb_str_split(con, "\n");

  name = rb_funcall(split, rb_intern("shift"), 0);
  desc = rb_ary_join(split, rb_str_new2( "\n" ));

  if( name == Qnil ) 
  {
    name = rb_str_new2("");
  }
  if( rb_funcall(desc, rb_intern("size"), 0) == 0) 
  {
    desc = rb_str_new2("");
  }
  rb_funcall(name, rb_intern("strip!"), 0);
  rb_funcall(desc, rb_intern("rstrip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 4, kw, name, desc, INT2FIX(current_line)); 
}

static void 
store_attr(VALUE listener, const char * attr_type,
           const char * at, size_t length, 
           int line)
{
  VALUE val = ENCODED_STR_NEW(at, length);
  rb_funcall(listener, rb_intern(attr_type), 2, val, INT2FIX(line));
}
static void 
store_docstring_content(VALUE listener, 
          int start_col, 
          const char *type_at, size_t type_length,
          const char *at, size_t length, 
          int current_line)
{
  VALUE re2;
  VALUE unescape_escaped_quotes;
  VALUE con = ENCODED_STR_NEW(at, length);
  VALUE con_type = ENCODED_STR_NEW(type_at, type_length);

  unindent(con, start_col);

  re2 = rb_reg_regcomp(rb_str_new2("\r\\Z"));
  unescape_escaped_quotes = rb_reg_regcomp(rb_str_new2("\\\\\"\\\\\"\\\\\""));
  rb_funcall(con, rb_intern("sub!"), 2, re2, rb_str_new2(""));
  rb_funcall(con_type, rb_intern("strip!"), 0);
  rb_funcall(con, rb_intern("gsub!"), 2, unescape_escaped_quotes, rb_str_new2("\"\"\""));
  rb_funcall(listener, rb_intern("doc_string"), 3, con_type, con, INT2FIX(current_line));
}
static void 
raise_lexer_error(const char * at, int line)
{ 
  rb_raise(rb_eGherkinLexingError, "Lexing error on line %d: '%s'. See http://wiki.github.com/cucumber/gherkin/lexingerror for more information.", line, at);
}

static void lexer_init(lexer_state *lexer) {
  lexer->content_start = 0;
  lexer->content_end = 0;
  lexer->content_len = 0;
  lexer->docstring_content_type_start = 0;
  lexer->docstring_content_type_end = 0;
  lexer->mark = 0;
  lexer->keyword_start = 0;
  lexer->keyword_end = 0;
  lexer->next_keyword_start = 0;
  lexer->line_number = 1;
  lexer->last_newline = 0;
  lexer->final_newline = 0;
  lexer->start_col = 0;
}

static VALUE CLexer_alloc(VALUE klass)
{
  VALUE obj;
  lexer_state *lxr = ALLOC(lexer_state);
  lexer_init(lxr);

  obj = Data_Wrap_Struct(klass, NULL, -1, lxr);

  return obj;
}

static VALUE CLexer_init(VALUE self, VALUE listener)
{
  lexer_state *lxr; 
  rb_iv_set(self, "@listener", listener);
  
  lxr = NULL;
  DATA_GET(self, lexer_state, lxr);
  lexer_init(lxr);
  
  return self;
}

static VALUE CLexer_scan(VALUE self, VALUE input)
{
  VALUE input_copy;
  char *data;
  size_t len;
  VALUE listener = rb_iv_get(self, "@listener");

  lexer_state *lexer;
  lexer = NULL;
  DATA_GET(self, lexer_state, lexer);

  input_copy = rb_str_dup(input);

  rb_str_append(input_copy, rb_str_new2("\n%_FEATURE_END_%"));
  data = RSTRING_PTR(input_copy);
  len = RSTRING_LEN(input_copy);
  
  if (len == 0) { 
    rb_raise(rb_eGherkinLexingError, "No content to lex.");
  } else {

    const char *p, *pe, *eof;
    int cs = 0;
    
    VALUE current_row = Qnil;

    p = data;
    pe = data + len;
    eof = pe;
    
    assert(*pe == '\0' && "pointer does not end on NULL");
    
    
#line 2444 "ext/gherkin_lexer_th/gherkin_lexer_th.c"
	{
	cs = lexer_start;
	}

#line 425 "ragel/i18n/th.c.rl"
    
#line 2451 "ext/gherkin_lexer_th/gherkin_lexer_th.c"
	{
	int _klen;
	unsigned int _trans;
	const char *_acts;
	unsigned int _nacts;
	const char *_keys;

	if ( p == pe )
		goto _test_eof;
	if ( cs == 0 )
		goto _out;
_resume:
	_keys = _lexer_trans_keys + _lexer_key_offsets[cs];
	_trans = _lexer_index_offsets[cs];

	_klen = _lexer_single_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + _klen - 1;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + ((_upper-_lower) >> 1);
			if ( (*p) < *_mid )
				_upper = _mid - 1;
			else if ( (*p) > *_mid )
				_lower = _mid + 1;
			else {
				_trans += (unsigned int)(_mid - _keys);
				goto _match;
			}
		}
		_keys += _klen;
		_trans += _klen;
	}

	_klen = _lexer_range_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( (*p) < _mid[0] )
				_upper = _mid - 2;
			else if ( (*p) > _mid[1] )
				_lower = _mid + 2;
			else {
				_trans += (unsigned int)((_mid - _keys)>>1);
				goto _match;
			}
		}
		_trans += _klen;
	}

_match:
	cs = _lexer_trans_targs[_trans];

	if ( _lexer_trans_actions[_trans] == 0 )
		goto _again;

	_acts = _lexer_actions + _lexer_trans_actions[_trans];
	_nacts = (unsigned int) *_acts++;
	while ( _nacts-- > 0 )
	{
		switch ( *_acts++ )
		{
	case 0:
#line 83 "ragel/i18n/th.c.rl"
	{
		MARK(content_start, p);
    lexer->current_line = lexer->line_number;
    lexer->start_col = lexer->content_start - lexer->last_newline - (lexer->keyword_end - lexer->keyword_start) + 2;
  }
	break;
	case 1:
#line 89 "ragel/i18n/th.c.rl"
	{
    MARK(content_start, p);
  }
	break;
	case 2:
#line 93 "ragel/i18n/th.c.rl"
	{
    lexer->current_line = lexer->line_number;
    lexer->start_col = p - data - lexer->last_newline;
  }
	break;
	case 3:
#line 98 "ragel/i18n/th.c.rl"
	{
    int len = LEN(content_start, PTR_TO(final_newline));
    int type_len = LEN(docstring_content_type_start, PTR_TO(docstring_content_type_end));

    if (len < 0) len = 0;
    if (type_len < 0) len = 0;

    store_docstring_content(listener, lexer->start_col, PTR_TO(docstring_content_type_start), type_len, PTR_TO(content_start), len, lexer->current_line);
  }
	break;
	case 4:
#line 108 "ragel/i18n/th.c.rl"
	{ 
    MARK(docstring_content_type_start, p);
  }
	break;
	case 5:
#line 112 "ragel/i18n/th.c.rl"
	{ 
    MARK(docstring_content_type_end, p);
  }
	break;
	case 6:
#line 116 "ragel/i18n/th.c.rl"
	{
    STORE_KW_END_CON(feature);
  }
	break;
	case 7:
#line 120 "ragel/i18n/th.c.rl"
	{
    STORE_KW_END_CON(background);
  }
	break;
	case 8:
#line 124 "ragel/i18n/th.c.rl"
	{
    STORE_KW_END_CON(scenario);
  }
	break;
	case 9:
#line 128 "ragel/i18n/th.c.rl"
	{
    STORE_KW_END_CON(scenario_outline);
  }
	break;
	case 10:
#line 132 "ragel/i18n/th.c.rl"
	{
    STORE_KW_END_CON(examples);
  }
	break;
	case 11:
#line 136 "ragel/i18n/th.c.rl"
	{
    store_kw_con(listener, "step",
      PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end)),
      PTR_TO(content_start), LEN(content_start, p), 
      lexer->current_line);
  }
	break;
	case 12:
#line 143 "ragel/i18n/th.c.rl"
	{
    STORE_ATTR(comment);
    lexer->mark = 0;
  }
	break;
	case 13:
#line 148 "ragel/i18n/th.c.rl"
	{
    STORE_ATTR(tag);
    lexer->mark = 0;
  }
	break;
	case 14:
#line 153 "ragel/i18n/th.c.rl"
	{
    lexer->line_number += 1;
    MARK(final_newline, p);
  }
	break;
	case 15:
#line 158 "ragel/i18n/th.c.rl"
	{
    MARK(last_newline, p + 1);
  }
	break;
	case 16:
#line 162 "ragel/i18n/th.c.rl"
	{
    if (lexer->mark == 0) {
      MARK(mark, p);
    }
  }
	break;
	case 17:
#line 168 "ragel/i18n/th.c.rl"
	{
    MARK(keyword_end, p);
    MARK(keyword_start, PTR_TO(mark));
    MARK(content_start, p + 1);
    lexer->mark = 0;
  }
	break;
	case 18:
#line 175 "ragel/i18n/th.c.rl"
	{
    MARK(content_end, p);
  }
	break;
	case 19:
#line 179 "ragel/i18n/th.c.rl"
	{
    p = p - 1;
    lexer->current_line = lexer->line_number;
    current_row = rb_ary_new();
  }
	break;
	case 20:
#line 185 "ragel/i18n/th.c.rl"
	{
		MARK(content_start, p);
  }
	break;
	case 21:
#line 189 "ragel/i18n/th.c.rl"
	{
    VALUE re_pipe, re_newline, re_backslash;
    VALUE con = ENCODED_STR_NEW(PTR_TO(content_start), LEN(content_start, p));
    rb_funcall(con, rb_intern("strip!"), 0);
    re_pipe      = rb_reg_regcomp(rb_str_new2("\\\\\\|"));
    re_newline   = rb_reg_regcomp(rb_str_new2("\\\\n"));
    re_backslash = rb_reg_regcomp(rb_str_new2("\\\\\\\\"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_pipe,      rb_str_new2("|"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_newline,   rb_str_new2("\n"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_backslash, rb_str_new2("\\"));

    rb_ary_push(current_row, con);
  }
	break;
	case 22:
#line 203 "ragel/i18n/th.c.rl"
	{
    rb_funcall(listener, rb_intern("row"), 2, current_row, INT2FIX(lexer->current_line));
  }
	break;
	case 23:
#line 207 "ragel/i18n/th.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      /* Allocate as a ruby string so that it gets cleaned up by GC */
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; /* terminate new string at first newline found */
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); /* Re-initialize so we can scan again with the same lexer */
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 2741 "ext/gherkin_lexer_th/gherkin_lexer_th.c"
		}
	}

_again:
	if ( cs == 0 )
		goto _out;
	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	if ( p == eof )
	{
	const char *__acts = _lexer_actions + _lexer_eof_actions[cs];
	unsigned int __nacts = (unsigned int) *__acts++;
	while ( __nacts-- > 0 ) {
		switch ( *__acts++ ) {
	case 23:
#line 207 "ragel/i18n/th.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      /* Allocate as a ruby string so that it gets cleaned up by GC */
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; /* terminate new string at first newline found */
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); /* Re-initialize so we can scan again with the same lexer */
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 2804 "ext/gherkin_lexer_th/gherkin_lexer_th.c"
		}
	}
	}

	_out: {}
	}

#line 426 "ragel/i18n/th.c.rl"

    assert(p <= pe && "data overflow after parsing execute");
    assert(lexer->content_start <= len && "content starts after data end");
    assert(lexer->mark < len && "mark is after data end");
    
    /* Reset lexer by re-initializing the whole thing */
    lexer_init(lexer);

    if (cs == lexer_error) {
      rb_raise(rb_eGherkinLexingError, "Invalid format, lexing fails.");
    } else {
      return Qtrue;
    }
  }
}

void Init_gherkin_lexer_th()
{
  mGherkin = rb_define_module("Gherkin");
  mGherkinLexer = rb_define_module_under(mGherkin, "Lexer");
  rb_eGherkinLexingError = rb_const_get(mGherkinLexer, rb_intern("LexingError"));

  mCLexer = rb_define_module_under(mGherkin, "CLexer");
  cI18nLexer = rb_define_class_under(mCLexer, "Th", rb_cObject);
  rb_define_alloc_func(cI18nLexer, CLexer_alloc);
  rb_define_method(cI18nLexer, "initialize", CLexer_init, 1);
  rb_define_method(cI18nLexer, "scan", CLexer_scan, 1);
}

