/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.jline.console.completer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import scala.tools.jline.console.ConsoleReader;
import scala.tools.jline.console.CursorBuffer;
import scala.tools.jline.console.completer.CompletionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CandidateListCompletionHandler
implements CompletionHandler {
    @Override
    public boolean complete(ConsoleReader consoleReader, List<CharSequence> list, int n) throws IOException {
        CursorBuffer cursorBuffer = consoleReader.getCursorBuffer();
        if (list.size() == 1) {
            CharSequence charSequence = list.get(0);
            if (charSequence.equals(cursorBuffer.toString())) {
                return false;
            }
            CandidateListCompletionHandler.setBuffer(consoleReader, charSequence, n);
            return true;
        }
        if (list.size() > 1) {
            String string = this.getUnambiguousCompletions(list);
            CandidateListCompletionHandler.setBuffer(consoleReader, string, n);
        }
        CandidateListCompletionHandler.printCandidates(consoleReader, list);
        consoleReader.drawLine();
        return true;
    }

    public static void setBuffer(ConsoleReader consoleReader, CharSequence charSequence, int n) throws IOException {
        while (consoleReader.getCursorBuffer().cursor > n && consoleReader.backspace()) {
        }
        consoleReader.putString(charSequence);
        consoleReader.setCursorPosition(n + charSequence.length());
    }

    public static void printCandidates(ConsoleReader consoleReader, Collection<CharSequence> collection) throws IOException {
        HashSet<CharSequence> hashSet = new HashSet<CharSequence>(collection);
        if (hashSet.size() > consoleReader.getAutoprintThreshold()) {
            int n;
            consoleReader.print(Messages.DISPLAY_CANDIDATES.format(collection.size()));
            consoleReader.flush();
            String string = Messages.DISPLAY_CANDIDATES_NO.format(new Object[0]);
            CharSequence charSequence = Messages.DISPLAY_CANDIDATES_YES.format(new Object[0]);
            char[] cArray = new char[]{((String)charSequence).charAt(0), string.charAt(0)};
            while ((n = consoleReader.readCharacter(cArray)) != -1) {
                String string2 = new String(new char[]{(char)n});
                if (string.startsWith(string2)) {
                    consoleReader.println();
                    return;
                }
                if (((String)charSequence).startsWith(string2)) break;
                consoleReader.beep();
            }
        }
        if (hashSet.size() != collection.size()) {
            ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>();
            for (CharSequence charSequence : collection) {
                if (arrayList.contains(charSequence)) continue;
                arrayList.add(charSequence);
            }
            collection = arrayList;
        }
        consoleReader.println();
        consoleReader.printColumns(collection);
    }

    private String getUnambiguousCompletions(List<CharSequence> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        String[] stringArray = list.toArray(new String[list.size()]);
        String string = stringArray[0];
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length() && this.startsWith(string.substring(0, i + 1), stringArray); ++i) {
            stringBuilder.append(string.charAt(i));
        }
        return stringBuilder.toString();
    }

    private boolean startsWith(String string, String[] stringArray) {
        for (String string2 : stringArray) {
            if (string2.startsWith(string)) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Messages {
        DISPLAY_CANDIDATES,
        DISPLAY_CANDIDATES_YES,
        DISPLAY_CANDIDATES_NO;

        private static final ResourceBundle bundle;

        public String format(Object ... objectArray) {
            if (bundle == null) {
                return "";
            }
            return String.format(bundle.getString(this.name()), objectArray);
        }

        static {
            bundle = ResourceBundle.getBundle(CandidateListCompletionHandler.class.getName(), Locale.getDefault());
        }
    }
}

