/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_SCLVIVISITOR_H
#define _SC_SCLVIVISITOR_H


/**
 * visitor for ScLvi object.
 */
class ScLviVisitor
{
public:
  virtual ~ScLviVisitor(){}
};



template<typename A> class LviVisitor : public virtual ScLviVisitor
{
public:
  virtual void visit(A*) = 0;
};


#define ScLviAccept(T) void accept( ScLviVisitor* v )    \
{                                                        \
  LviVisitor<T>* pv = dynamic_cast<LviVisitor<T>*>(v);   \
  if( pv )                                               \
  {                                                      \
    pv->visit(this);                                     \
  }                                                      \
}


#endif // _SC_SCLVIVISITOR_H
