/* ====================================================================
 * Copyright (c) 2006-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_WCSELECTION_H
#define _SC_WCSELECTION_H

// sc
#include "svn/ClientTypes.h"
#include "svn/WcStatusTypes.h"

class WcSelection
{
public:
  WcSelection();
  WcSelection( const WcSelection& sel );
  WcSelection( const svn::WcStatuss& statuss );

  // \todo make all methods check all selected items and let the
  // caller check isSingle...
  bool isDiffable() const;          // single
  bool isVersioned() const;         // single
  bool isVersionedDir() const;      // single
  bool isVersionedFile() const;     // single
  bool isVersionedAll() const;      // multi
  bool isUnversionedAll() const;    // multi
  bool isMoveable() const;          // single
  bool isAddable() const;           // multi
  bool isConflicted() const;        // single
  bool isPropConflicted() const;    // single
  bool isRemoveable() const;        // multi
  bool isRevertable() const;        // multi
  bool isCommitable() const;        // multi

  /** anything selected? */
  bool isEmpty() const;
  /** only one item selected? */
  bool isSingle() const;
  /** multiple items selected? */
  bool isMulti() const;

  /** get all selected status objects */
  const svn::WcStatuss& get() const;
  /** get single selected status object */
  svn::WcStatusPtr getSingle() const;

  /** get selection names */
  void getNames( svn::Paths& paths );
  /** get selection names of versioned items */
  void getVersionedNames( svn::Paths& paths );
  /** get selection names of not versioned items */
  void getUnversionNames( svn::Paths& paths );

  /** Is @a path selected? */
  bool isSelected( const sc::String& path ) const;

private:
  svn::WcStatuss _statuss;
};


#endif // _SC_WCSELECTION_H
