/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_MERGECMD_H
#define _SC_MERGECMD_H

// sc
#include "ScCmd.h"
class MergeParam;
class CmdResultCallback;

/**
 * Command for merging changes into a working copy.
 */
class MergeCmd : public ScCmd
{
public:
  /**
   * Construct a MergeCmd.
   *
   * \param param the parameters for the command.
   * \param cb the callback that gets called when the command has finished.
   * The command takes ownership the callback.
   */
  MergeCmd( MergeParam* param, CmdResultCallback* cb );
  ~MergeCmd();

  /**
   * run the command.
   */
  void run();

private:
  // in
  MergeParam*        _param;

  // out
  CmdResultCallback* _cb;
};

#endif // _SC_MERGECMD_H
