/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#include "NullTextModel.h"
#include "Line.h"
#include "Cursor.h"

static const sc::String string( "null" );
static const sc::String empty;
static const Cursor     cursor;

NullTextModel NullTextModel::_instance;


NullTextModel* NullTextModel::getInstance()
{
  return &_instance;
}

NullTextModel::~NullTextModel()
{
}

const Line& NullTextModel::getLine( sc::Size /*svn::Offset*/ )
{
  return Line::getEmpty();
}

BlockInfo NullTextModel::getBlockInfo( int block )
{
  return BlockInfo();
}

size_t NullTextModel::getLineCnt()
{
  // minimum value that doesn't make the Splitter widget crazy.
  return 3;
}

size_t NullTextModel::getColumnCnt()
{
  // minimum value that doesn't make the Splitter widget crazy.
  return 3;
}

LineEnd NullTextModel::getLineEnd()
{
  return leNone;
}

unsigned int NullTextModel::getTabWidth()
{
  return 0;
}

const sc::String& NullTextModel::getSourceName()
{
  return string;
}

int NullTextModel::replaceBlock( int /*block*/, TextModel* /*src*/ )
{
  return 0;
}

const Cursor& NullTextModel::getCursor()
{
  return cursor;
}

const Cursor& NullTextModel::getCursor2()
{
  return cursor;
}

void NullTextModel::setCursor( const Cursor& )
{
}

void NullTextModel::setCursor2( const Cursor& )
{
}

Cursor NullTextModel::moveCursorRight( bool moveC2 )
{
  return cursor;
}

Cursor NullTextModel::moveCursorLeft( bool moveC2 )
{
  return cursor;
}

Cursor NullTextModel::moveCursorDown( bool moveC2 )
{
  return cursor;
}

Cursor NullTextModel::moveCursorUp( bool moveC2 )
{
  return cursor;
}

int NullTextModel::getLastColumn()
{
  return 0;
}

void NullTextModel::setLastColumn( int /*col*/ )
{
}

Cursor NullTextModel::calcNearestCursorPos( const Cursor& /*c*/ )
{
  return cursor;
}

void NullTextModel::addText( const sc::String& )
{
}

void NullTextModel::removeTextLeft()
{
}

void NullTextModel::removeTextRight()
{
}

sc::String NullTextModel::getHighlightedText()
{
  return empty;
}

void NullTextModel::undo()
{
}

void NullTextModel::redo()
{
}

bool NullTextModel::hasUndo()
{
  return false;
}

void NullTextModel::clearUndo()
{
}

