/*
 * Decompiled with CFR 0.152.
 */
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class ZlibInStream
extends InStream {
    static final int defaultBufSize = 16384;
    private InStream underlying;
    private int bufSize;
    private int ptrOffset;
    private Inflater inflater;
    private int bytesIn;

    public ZlibInStream() {
        this(16384);
    }

    public ZlibInStream(int n) {
        this.bufSize = n;
        this.b = new byte[this.bufSize];
        this.ptrOffset = 0;
        this.end = 0;
        this.ptr = 0;
        this.inflater = new Inflater();
    }

    private void decompress() throws Exception {
        try {
            this.underlying.check(1);
            int n = this.underlying.getend() - this.underlying.getptr();
            if (n > this.bytesIn) {
                n = this.bytesIn;
            }
            if (this.inflater.needsInput()) {
                this.inflater.setInput(this.underlying.getbuf(), this.underlying.getptr(), n);
            }
            int n2 = this.inflater.inflate(this.b, this.end, this.bufSize - this.end);
            this.end += n2;
            if (this.inflater.needsInput()) {
                this.bytesIn -= n;
                this.underlying.setptr(this.underlying.getptr() + n);
            }
        }
        catch (DataFormatException dataFormatException) {
            throw new Exception("ZlibInStream: inflate failed");
        }
    }

    protected int overrun(int n, int n2) throws Exception {
        if (n > this.bufSize) {
            throw new Exception("ZlibInStream overrun: max itemSize exceeded");
        }
        if (this.underlying == null) {
            throw new Exception("ZlibInStream overrun: no underlying stream");
        }
        if (this.end - this.ptr != 0) {
            System.arraycopy(this.b, this.ptr, this.b, 0, this.end - this.ptr);
        }
        this.ptrOffset += this.ptr;
        this.end -= this.ptr;
        this.ptr = 0;
        while (this.end < n) {
            this.decompress();
        }
        if (n * n2 > this.end) {
            n2 = this.end / n;
        }
        return n2;
    }

    public int pos() {
        return this.ptrOffset + this.ptr;
    }

    /*
     * Unable to fully structure code
     */
    public void reset() throws Exception {
        this.end = 0;
        this.ptr = 0;
        if (this.underlying != null) ** GOTO lbl7
        return;
lbl-1000:
        // 1 sources

        {
            this.decompress();
            this.end = 0;
lbl7:
            // 2 sources

            ** while (this.bytesIn > 0)
        }
lbl8:
        // 1 sources

        this.underlying = null;
    }

    public void setUnderlying(InStream inStream, int n) {
        this.underlying = inStream;
        this.bytesIn = n;
        this.end = 0;
        this.ptr = 0;
    }
}

