/*
 * Decompiled with CFR 0.152.
 */
package net.tinyos.message;

import net.tinyos.message.SerialPacket;

public class Message
implements Cloneable {
    public static final int MAX_CONVERTED_STRING_LENGTH = 512;
    private byte[] data;
    protected int base_offset;
    protected int data_length;
    protected int am_type;
    private SerialPacket serialPacket;

    protected Message() {
    }

    public Message(int n) {
        this.init(n);
    }

    public void init(int n) {
        this.init(new byte[n]);
    }

    public Message(int n, int n2) {
        this.init(n, n2);
    }

    protected void init(int n, int n2) {
        this.init(new byte[n + n2], n2);
    }

    public Message(byte[] byArray) {
        this.init(byArray);
    }

    protected void init(byte[] byArray) {
        this.init(byArray, 0);
    }

    public Message(byte[] byArray, int n) {
        this.init(byArray, n);
    }

    protected void init(byte[] byArray, int n) {
        this.init(byArray, n, byArray.length - n);
    }

    public Message(byte[] byArray, int n, int n2) {
        this.init(byArray, n, n2);
    }

    protected void init(byte[] byArray, int n, int n2) {
        this.data = byArray;
        this.base_offset = n;
        this.data_length = n2;
        if (n + n2 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException("Cannot create Message with base_offset " + n + ", data_length " + n2 + " and data array size " + byArray.length);
        }
    }

    public Message(Message message, int n, int n2) {
        this.init(message, n, n2);
    }

    protected void init(Message message, int n, int n2) {
        this.init(message.dataGet(), message.base_offset + n, n2);
    }

    private Message cloneself() {
        Message message;
        try {
            message = (Message)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Message: WARNING: CloneNotSupportedException in cloneself(): " + cloneNotSupportedException);
            System.err.println("Message: This is a bug - please contact dgay@intel-research.net");
            message = null;
            System.exit(2);
        }
        return message;
    }

    public Object clone() {
        Message message = this.cloneself();
        message.init((byte[])this.data.clone(), this.base_offset, this.data_length);
        message.am_type = this.am_type;
        return message;
    }

    public Message clone(int n) {
        Message message = this.cloneself();
        message.init(new byte[n], 0, n);
        message.am_type = this.am_type;
        return message;
    }

    public void dataSet(byte[] byArray) {
        this.dataSet(byArray, 0, this.base_offset, Math.min(this.data_length, byArray.length));
    }

    public void dataSet(byte[] byArray, int n, int n2, int n3) {
        System.arraycopy(byArray, n, this.data, n2 + this.base_offset, n3);
    }

    public void dataSet(Message message, int n) {
        System.arraycopy(message.dataGet(), message.baseOffset(), this.data, n + this.base_offset, message.dataLength());
    }

    public byte[] dataGet() {
        return this.data;
    }

    public int baseOffset() {
        return this.base_offset;
    }

    public int dataLength() {
        return this.data_length;
    }

    public int amType() {
        return this.am_type;
    }

    public void amTypeSet(int n) {
        this.am_type = n;
    }

    private void checkBounds(int n, int n2) {
        if (n < 0 || n2 <= 0 || n + n2 > this.data_length * 8) {
            throw new ArrayIndexOutOfBoundsException("Message.checkBounds: bad offset (" + n + ") or length (" + n2 + "), for data_length " + this.data_length + " in class " + this.getClass());
        }
    }

    private void checkValue(int n, long l) {
        if (n != 64 && (l < 0L || l >= 1L << n)) {
            throw new IllegalArgumentException("Message.checkValue: bad length (" + n + " or value (" + l + ")");
        }
    }

    private int ubyte(int n) {
        byte by = this.data[this.base_offset + n];
        if (by < 0) {
            return by + 256;
        }
        return by;
    }

    protected long getUIntElement(int n, int n2) {
        this.checkBounds(n, n2);
        int n3 = n >> 3;
        int n4 = n & 7;
        int n5 = 0;
        long l = 0L;
        if (n2 + n4 <= 8) {
            return this.ubyte(n3) >> n4 & (1 << n2) - 1;
        }
        if (n4 > 0) {
            l = this.ubyte(n3) >> n4;
            ++n3;
            n5 += 8 - n4;
            n2 -= 8 - n4;
        }
        while (n2 >= 8) {
            l |= (long)this.ubyte(n3++) << n5;
            n5 += 8;
            n2 -= 8;
        }
        if (n2 > 0) {
            l |= (long)(this.ubyte(n3) & (1 << n2) - 1) << n5;
        }
        return l;
    }

    protected void setUIntElement(int n, int n2, long l) {
        this.checkBounds(n, n2);
        int n3 = n >> 3;
        int n4 = n & 7;
        int n5 = 0;
        if (n2 + n4 <= 8) {
            this.data[this.base_offset + n3] = (byte)((long)(this.ubyte(n3) & ~((1 << n2) - 1 << n4)) | l << n4);
            return;
        }
        if (n4 > 0) {
            this.data[this.base_offset + n3] = (byte)((long)(this.ubyte(n3) & (1 << n4) - 1) | l << n4);
            ++n3;
            n5 += 8 - n4;
            n2 -= 8 - n4;
        }
        while (n2 >= 8) {
            this.data[this.base_offset + n3++] = (byte)(l >> n5);
            n5 += 8;
            n2 -= 8;
        }
        if (n2 > 0) {
            this.data[this.base_offset + n3] = (byte)((long)(this.ubyte(n3) & ~((1 << n2) - 1)) | l >> n5);
        }
    }

    protected long getSIntElement(int n, int n2) throws ArrayIndexOutOfBoundsException {
        long l = this.getUIntElement(n, n2);
        if (n2 == 64) {
            return l;
        }
        if ((l & 1L << n2 - 1) != 0L) {
            return l - (1L << n2);
        }
        return l;
    }

    protected void setSIntElement(int n, int n2, long l) throws ArrayIndexOutOfBoundsException {
        if (n2 != 64 && l >= 1L << n2 - 1) {
            throw new IllegalArgumentException();
        }
        if (n2 != 64 && l < 0L) {
            l += 1L << n2;
        }
        this.setUIntElement(n, n2, l);
    }

    protected long getUIntBEElement(int n, int n2) {
        this.checkBounds(n, n2);
        int n3 = n >> 3;
        int n4 = n & 7;
        long l = 0L;
        if (n2 + n4 <= 8) {
            return this.ubyte(n3) >> 8 - n4 - n2 & (1 << n2) - 1;
        }
        if (n4 > 0) {
            l = (long)(this.ubyte(n3) & (1 << 8 - n4) - 1) << (n2 -= 8 - n4);
            ++n3;
        }
        while (n2 >= 8) {
            l |= (long)this.ubyte(n3++) << (n2 -= 8);
        }
        if (n2 > 0) {
            l |= (long)(this.ubyte(n3) >> 8 - n2);
        }
        return l;
    }

    protected void setUIntBEElement(int n, int n2, long l) {
        int n3;
        this.checkBounds(n, n2);
        int n4 = n >> 3;
        int n5 = n & 7;
        if (n2 + n5 <= 8) {
            int n6 = (1 << n2) - 1 << 8 - n5 - n2;
            this.data[this.base_offset + n4] = (byte)((long)(this.ubyte(n4) & ~n6) | l << 8 - n5 - n2);
            return;
        }
        if (n5 > 0) {
            n3 = (1 << 8 - n5) - 1;
            this.data[this.base_offset + n4] = (byte)((long)(this.ubyte(n4) & ~n3) | l >> (n2 -= 8 - n5));
            ++n4;
        }
        while (n2 >= 8) {
            this.data[this.base_offset + n4++] = (byte)(l >> (n2 -= 8));
        }
        if (n2 > 0) {
            n3 = (1 << 8 - n2) - 1;
            this.data[this.base_offset + n4] = (byte)((long)(this.ubyte(n4) & n3) | l << 8 - n2);
        }
    }

    protected long getSIntBEElement(int n, int n2) throws ArrayIndexOutOfBoundsException {
        long l = this.getUIntBEElement(n, n2);
        if (n2 == 64) {
            return l;
        }
        if ((l & 1L << n2 - 1) != 0L) {
            return l - (1L << n2);
        }
        return l;
    }

    protected void setSIntBEElement(int n, int n2, long l) throws ArrayIndexOutOfBoundsException {
        if (n2 != 64 && l >= 1L << n2 - 1) {
            throw new IllegalArgumentException();
        }
        if (n2 != 64 && l < 0L) {
            l += 1L << n2;
        }
        this.setUIntBEElement(n, n2, l);
    }

    protected float getFloatElement(int n, int n2) throws ArrayIndexOutOfBoundsException {
        return Float.intBitsToFloat((int)this.getUIntElement(n, 32));
    }

    protected void setFloatElement(int n, int n2, float f) throws ArrayIndexOutOfBoundsException {
        this.setSIntElement(n, 32, Float.floatToRawIntBits(f));
    }

    public SerialPacket getSerialPacket() {
        return this.serialPacket;
    }

    protected void setSerialPacket(SerialPacket serialPacket) {
        this.serialPacket = serialPacket;
    }
}

