/*
 * Copyright (C) 2014 Canonical Ltd.
 *
 * This file is part of unity-chromium-extension
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef UNITY_WEBAPPS_INACTIVITY_TIMER_H
#define UNITY_WEBAPPS_INACTIVITY_TIMER_H

#include <QList>
#include <QObject>
#include <QTimer>

namespace UnityWebapps {

class InactivityTimer: public QObject
{
    Q_OBJECT

public:
    InactivityTimer(int interval, QObject *parent = 0);
    ~InactivityTimer() {}

    void watchObject(QObject *object);

Q_SIGNALS:
    void timeout();

private Q_SLOTS:
    void onIdleChanged();
    void onTimeout();

private:
    bool allObjectsAreIdle() const;

private:
    QList<QObject*> m_watchedObjects;
    QTimer m_timer;
    int m_interval;
};

} // namespace

#endif // UNITY_WEBAPPS_INACTIVITY_TIMER_H
