/*
 * Decompiled with CFR 0.152.
 */
package javax.enterprise.deploy.shared.factories;

import java.util.Vector;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;

public final class DeploymentFactoryManager {
    private Vector deploymentFactories = new Vector();
    private static DeploymentFactoryManager deploymentFactoryManager = null;

    private DeploymentFactoryManager() {
    }

    public static DeploymentFactoryManager getInstance() {
        if (deploymentFactoryManager == null) {
            deploymentFactoryManager = new DeploymentFactoryManager();
        }
        return deploymentFactoryManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeploymentFactory[] getDeploymentFactories() {
        Vector deploymentFactoriesSnapShot = null;
        DeploymentFactoryManager deploymentFactoryManager = this;
        synchronized (deploymentFactoryManager) {
            deploymentFactoriesSnapShot = (Vector)this.deploymentFactories.clone();
        }
        Object[] factoriesArray = new DeploymentFactory[deploymentFactoriesSnapShot.size()];
        deploymentFactoriesSnapShot.copyInto(factoriesArray);
        return factoriesArray;
    }

    public DeploymentManager getDeploymentManager(String uri, String username, String password) throws DeploymentManagerCreationException {
        try {
            DeploymentFactory[] factories = this.getDeploymentFactories();
            for (int factoryIndex = 0; factoryIndex < factories.length; ++factoryIndex) {
                if (!factories[factoryIndex].handlesURI(uri)) continue;
                return factories[factoryIndex].getDeploymentManager(uri, username, password);
            }
            throw new DeploymentManagerCreationException("URL [" + uri + "] not supported by any available factories");
        }
        catch (Throwable t) {
            throw new DeploymentManagerCreationException("Could not get DeploymentManager");
        }
    }

    public void registerDeploymentFactory(DeploymentFactory factory) {
        this.deploymentFactories.add(factory);
    }

    public DeploymentManager getDisconnectedDeploymentManager(String uri) throws DeploymentManagerCreationException {
        try {
            DeploymentFactory[] factories = this.getDeploymentFactories();
            for (int factoryIndex = 0; factoryIndex < factories.length; ++factoryIndex) {
                if (!factories[factoryIndex].handlesURI(uri)) continue;
                return factories[factoryIndex].getDisconnectedDeploymentManager(uri);
            }
            throw new DeploymentManagerCreationException("URL [" + uri + "] not supported by any available factories");
        }
        catch (Throwable t) {
            throw new DeploymentManagerCreationException("Could not get DeploymentManager");
        }
    }
}

