/*
 * Decompiled with CFR 0.152.
 */
package SharpTools;

import SharpTools.SharpDialog;
import SharpTools.SharpOptionPane;
import SharpTools.SharpTools;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPasswordField;

public class PasswordDialog
extends SharpDialog {
    private JFrame frame;
    private String typedText = null;
    private String password;
    private final JPasswordField textField;
    private final JPasswordField confirmField;
    final ImageIcon passwordIcon = new ImageIcon(this.getClass().getResource("/images/password32.gif"));

    public PasswordDialog(JFrame aFrame, String pass) {
        super(aFrame, "Password", true);
        this.frame = aFrame;
        this.password = pass;
        String msgString1 = SharpTools.translation.getProperty("Enter_password") + " : ";
        String msgString2 = SharpTools.translation.getProperty("Confirm_Password") + " : ";
        this.textField = new JPasswordField(10);
        this.confirmField = new JPasswordField(10);
        Object[] input = new Object[]{msgString1, this.textField, msgString2, this.confirmField};
        Object[] verify = new Object[]{msgString1, this.textField};
        Object[] array = this.password == null ? input : verify;
        this.setOptionPane(array, 3, 2, this.passwordIcon);
    }

    public String getValidatedText() {
        return this.typedText;
    }

    private static boolean fieldsAreTheSame(char[] input1, char[] input2) {
        if (input1.length != input2.length) {
            return false;
        }
        for (int i = 0; i < input1.length; ++i) {
            if (input1[i] == input2[i]) continue;
            return false;
        }
        return true;
    }

    protected boolean onOK() {
        this.typedText = new String(this.textField.getPassword());
        if (this.password != null) {
            if (!this.typedText.equals(this.password)) {
                SharpOptionPane.showMessageDialog(this, SharpTools.translation.getProperty("Password_Incorrect") + " !", SharpTools.translation.getProperty("Password"), 0);
                this.textField.setText(null);
                this.textField.requestFocus();
                return false;
            }
            return true;
        }
        if (PasswordDialog.fieldsAreTheSame(this.textField.getPassword(), this.confirmField.getPassword())) {
            return true;
        }
        this.textField.selectAll();
        SharpOptionPane.showMessageDialog(this, SharpTools.translation.getProperty("Passwords_do_not_match_Please_try_again"), SharpTools.translation.getProperty("Password"), 0, null);
        this.typedText = null;
        this.textField.setText(null);
        this.confirmField.setText(null);
        this.textField.requestFocus();
        return false;
    }

    protected boolean onCancel() {
        this.typedText = null;
        return true;
    }

    protected void onOpen() {
        this.textField.requestFocus();
    }
}

