package ONVIF::Media::Types::Object;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}


use base qw(ONVIF::Media::Types::ObjectId);
# Variety: sequence
use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Appearance_of :ATTR(:get<Appearance>);
my %Behaviour_of :ATTR(:get<Behaviour>);
my %Extension_of :ATTR(:get<Extension>);

__PACKAGE__->_factory(
    [ qw(        Appearance
        Behaviour
        Extension

    ) ],
    {
        'Appearance' => \%Appearance_of,
        'Behaviour' => \%Behaviour_of,
        'Extension' => \%Extension_of,
    },
    {
        'Appearance' => 'ONVIF::Media::Types::Appearance',
        'Behaviour' => 'ONVIF::Media::Types::Behaviour',
        'Extension' => 'ONVIF::Media::Types::ObjectExtension',
    },
    {

        'Appearance' => 'Appearance',
        'Behaviour' => 'Behaviour',
        'Extension' => 'Extension',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Media::Types::Object

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
Object from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Appearance


=item * Behaviour


=item * Extension




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Media::Types::Object
   Appearance =>  { # ONVIF::Media::Types::Appearance
     Transformation =>  { # ONVIF::Media::Types::Transformation
       Translate => ,
       Scale => ,
       Extension =>  { # ONVIF::Media::Types::TransformationExtension
       },
     },
     Shape =>  { # ONVIF::Media::Types::ShapeDescriptor
       BoundingBox => ,
       CenterOfGravity => ,
       Polygon =>  { # ONVIF::Media::Types::Polygon
         Point => ,
       },
       Extension =>  { # ONVIF::Media::Types::ShapeDescriptorExtension
       },
     },
     Color =>  { # ONVIF::Media::Types::ColorDescriptor
       ColorCluster =>  {
         Color => ,
         Weight =>  $some_value, # float
         Covariance => ,
       },
       Extension =>  { # ONVIF::Media::Types::ColorDescriptorExtension
       },
     },
     Class =>  { # ONVIF::Media::Types::ClassDescriptor
       ClassCandidate =>  {
         Type => $some_value, # ClassType
         Likelihood =>  $some_value, # float
       },
       Extension =>  { # ONVIF::Media::Types::ClassDescriptorExtension
         OtherTypes =>  { # ONVIF::Media::Types::OtherType
           Type =>  $some_value, # string
           Likelihood =>  $some_value, # float
         },
         Extension =>  { # ONVIF::Media::Types::ClassDescriptorExtension2
         },
       },
     },
     Extension =>  { # ONVIF::Media::Types::AppearanceExtension
     },
   },
   Behaviour =>  { # ONVIF::Media::Types::Behaviour
     Removed =>  {
     },
     Idle =>  {
     },
     Extension =>  { # ONVIF::Media::Types::BehaviourExtension
     },
   },
   Extension =>  { # ONVIF::Media::Types::ObjectExtension
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

