#! /bin/sh
# check script for Zutils - Utilities dealing with compressed files
# Copyright (C) 2009, 2010, 2011 Antonio Diaz Diaz.
#
# This script is free software: you have unlimited permission
# to copy, distribute and modify it.

LC_ALL=C
export LC_ALL
objdir=`pwd`
testdir=`cd "$1" ; pwd`
ZCAT="${objdir}"/zcat
ZCMP="${objdir}"/zcmp
ZDIFF="${objdir}"/zdiff
ZGREP="${objdir}"/zgrep
ZEGREP="${objdir}"/zegrep
ZFGREP="${objdir}"/zfgrep
ZTEST="${objdir}"/ztest
compressors="bzip2 gzip lzip"
extensions="bz2 gz lz"
framework_failure() { echo "failure in testing framework" ; exit 1 ; }
compressor_needed() { echo "${compressors} are needed to run tests" ; exit 1 ; }

if [ ! -x "${ZCAT}" ] ; then
	echo "${ZCAT}: cannot execute"
	exit 1
fi

if [ -d tmp ] ; then rm -rf tmp ; fi
mkdir tmp
cd "${objdir}"/tmp

for i in ${compressors}; do
	cat "${testdir}"/test.txt > in || framework_failure
	$i in || compressor_needed
done

printf "testing zutils-%s..." "$2"
cat "${testdir}"/test.txt > in || framework_failure
cat "${testdir}"/test.txt.tar > in.tar || framework_failure
printf "01234567890" > pin.tar || framework_failure
cat in.tar in.tar in.tar in.tar >> pin.tar || framework_failure
cat in > -in- || framework_failure
cat in.lz > -in-.lz || framework_failure
cat in.lz > lz_only.lz || framework_failure
cat in in in in in in > in6 || framework_failure
fail=0


printf "\ntesting   zcat-%s..." "$2"
for i in ${extensions}; do
	"${ZCAT}" in.$i > copy || fail=1
	cmp in copy || fail=1
	printf .
done

"${ZCAT}" < in > copy || fail=1
cmp in copy || fail=1
printf .
"${ZCAT}" < in.gz > copy || fail=1
cmp in copy || fail=1
printf .
"${ZCAT}" < in.bz2 > copy || fail=1
cmp in copy || fail=1
printf .
"${ZCAT}" < in.lz > copy || fail=1
cmp in copy || fail=1
printf .
"${ZCAT}" in > copy || fail=1
cmp in copy || fail=1
printf .
"${ZCAT}" lz_only > copy || fail=1
cmp in copy || fail=1
printf .
"${ZCAT}" in in.gz in.bz2 in.lz -- -in- -in-.lz > copy6 || fail=1
cmp in6 copy6 || fail=1
printf .


printf "\ntesting   zcmp-%s..." "$2"
for i in ${extensions}; do
	"${ZCMP}" in.$i || fail=1
	printf .
	"${ZCMP}" in in.$i || fail=1
	printf .
	"${ZCMP}" in.$i in || fail=1
	printf .
done

"${ZCMP}" in.tar pin.tar > /dev/null
if [ $? != 1 ] ; then fail=1 ; printf - ; else printf . ; fi
"${ZCMP}" - || fail=1
printf .
"${ZCMP}" in in || fail=1
printf .
"${ZCMP}" in || fail=1
printf .
"${ZCMP}" in.lz in.gz || fail=1
printf .
"${ZCMP}" in.gz -- -in-.lz || fail=1
printf .
"${ZCMP}" -- -in-.lz in.gz || fail=1
printf .
"${ZCMP}" in -- -in-.lz || fail=1
printf .
"${ZCMP}" -- -in- in.lz || fail=1
printf .
"${ZCMP}" in.lz -- -in- || fail=1
printf .
"${ZCMP}" -- -in-.lz in || fail=1
printf .
"${ZCMP}" -- -in- in || fail=1
printf .
"${ZCMP}" in -- -in- || fail=1
printf .
"${ZCMP}" lz_only.lz < in || fail=1
printf .
"${ZCMP}" in.lz - < in || fail=1
printf .
"${ZCMP}" - in.lz < in || fail=1
printf .
"${ZCMP}" in - < in.lz || fail=1
printf .
"${ZCMP}" - in < in.lz || fail=1
printf .


printf "\ntesting  zdiff-%s..." "$2"
for i in ${extensions}; do
	"${ZDIFF}" in.$i || fail=1
	printf .
	"${ZDIFF}" in in.$i || fail=1
	printf .
	"${ZDIFF}" in.$i in || fail=1
	printf .
done

#"${ZDIFF}" in.tar pin.tar > /dev/null
#if [ $? != 1 ] ; then fail=1 ; printf - ; else printf . ; fi
"${ZDIFF}" - || fail=1
printf .
"${ZDIFF}" in in || fail=1
printf .
"${ZDIFF}" in || fail=1
printf .
"${ZDIFF}" in.lz in.gz || fail=1
printf .
"${ZDIFF}" in.gz -- -in-.lz || fail=1
printf .
"${ZDIFF}" -- -in-.lz in.gz || fail=1
printf .
"${ZDIFF}" in -- -in-.lz || fail=1
printf .
"${ZDIFF}" -- -in- in.lz || fail=1
printf .
"${ZDIFF}" in.lz -- -in- || fail=1
printf .
"${ZDIFF}" -- -in-.lz in || fail=1
printf .
"${ZDIFF}" -- -in- in || fail=1
printf .
"${ZDIFF}" in -- -in- || fail=1
printf .
"${ZDIFF}" lz_only.lz < in || fail=1
printf .
"${ZDIFF}" in.lz - < in || fail=1
printf .
"${ZDIFF}" - in.lz < in || fail=1
printf .
"${ZDIFF}" in - < in.lz || fail=1
printf .
"${ZDIFF}" - in < in.lz || fail=1
printf .


printf "\ntesting  zgrep-%s..." "$2"
for i in ${extensions}; do
	"${ZGREP}" "GNU" in.$i > /dev/null || fail=1
	"${ZGREP}" "nx_pattern" in.$i > /dev/null && fail=1
	printf .
done

"${ZGREP}" "GNU" < pin.tar > /dev/null || fail=1
printf .
"${ZGREP}" "GNU" pin.tar > /dev/null || fail=1
printf .
"${ZGREP}" -r "GNU" . > /dev/null || fail=1
printf .
"${ZGREP}" "nx_pattern" -r . in > /dev/null && fail=1
printf .
"${ZGREP}" "GNU" < in > /dev/null || fail=1
printf .
"${ZGREP}" "GNU" < in.gz > /dev/null || fail=1
printf .
"${ZGREP}" "GNU" < in.bz2 > /dev/null || fail=1
printf .
"${ZGREP}" "GNU" < in.lz > /dev/null || fail=1
printf .
"${ZGREP}" "GNU" in > /dev/null || fail=1
printf .
"${ZGREP}" "GNU" -- -in- > /dev/null || fail=1
printf .
"${ZGREP}" "GNU" -- -in-.lz > /dev/null || fail=1
printf .
"${ZGREP}" "GNU" in in.gz in.bz2 in.lz -- -in- > /dev/null || fail=1
printf .
"${ZEGREP}" "GNU" in > /dev/null || fail=1
printf .
"${ZFGREP}" "GNU" in > /dev/null || fail=1
printf .


printf "\ntesting  ztest-%s..." "$2"
"${ZTEST}" in in.gz in.bz2 in.lz -- -in- || fail=1
printf .
"${ZTEST}" < in.gz || fail=1
printf .
"${ZTEST}" < in.bz2 || fail=1
printf .
"${ZTEST}" < in.lz || fail=1
printf .
"${ZTEST}" -r . || fail=1
printf .
"${ZTEST}" < in 2>/dev/null
if [ $? = 0 ] ; then fail=1 ; printf - ; else printf . ; fi
printf "LZIPvs0000000000000000000000" | "${ZTEST}" 2>/dev/null
if [ $? = 0 ] ; then fail=1 ; printf - ; else printf . ; fi

echo
if [ ${fail} = 0 ] ; then
	echo "tests completed successfully."
	cd "${objdir}" && rm -r tmp
else
	echo "tests failed."
fi
exit ${fail}
