//  (C) Copyright John Maddock 2006-7.
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

   static const boost::array<boost::array<typename table_type<T>::type, 5>, 1210> ibeta_inv_data = { {
      {{ SC_(0.104760829344741068780422210693359375e-4), SC_(39078.1875), SC_(0.913384497165679931640625), SC_(0.2135769916611873809373928693612157637794870746322109915739746618652569766882593624385400901395922558e-3760), SC_(BOOST_MATH_SMALL_CONSTANT(0.6169146818683135737866366973021696361959736535710675458813428774517757535576031054239811928697394346e-101417)) }}, 
      {{ SC_(0.1127331415773369371891021728515625e-4), SC_(0.0226620174944400787353515625), SC_(0.1355634629726409912109375), SC_(BOOST_MATH_SMALL_CONSTANT(0.6398069040886718270700942839013650119743974939592699138527850527236181568779785317811717302449254101e-76964)), SC_(BOOST_MATH_SMALL_CONSTANT(0.1123304116325227195797533167182832111272986902383876280357481893374380043283848201429836361152904889e-5592)) }}, 
      {{ SC_(0.113778432933031581342220306396484375e-4), SC_(0.03654421865940093994140625), SC_(0.9688708782196044921875), SC_(0.5825356514402150924555439351704966386176716144780670249830283141506929468296452211723778443894234951e-1195), SC_(BOOST_MATH_SMALL_CONSTANT(0.1299246431009640780314778465681510321819328250560790012308930348335051591055920757982605267188242976e-132423)) }}, 
      {{ SC_(0.1142846667789854109287261962890625e-4), SC_(0.00244517601095139980316162109375), SC_(0.1355634629726409912109375), SC_(BOOST_MATH_SMALL_CONSTANT(0.9626654068785645417511885142439608103434581112273323673426712424844243107090177710187642425011765594e-75761)), SC_(BOOST_MATH_SMALL_CONSTANT(0.1968131210354581442057523237500619235039616488884597039029510000400233015927645935497663749543679489e-5358)) }}, 
      {{ SC_(0.1184685606858693063259124755859375e-4), SC_(0.015964560210704803466796875), SC_(0.3082362115383148193359375), SC_(BOOST_MATH_SMALL_CONSTANT(0.3589991782488314563613963926946558354830549116688735009134661806895352582322279412078679966549495e-43116)), SC_(BOOST_MATH_SMALL_CONSTANT(0.8498116607235052405320447197085177573554285064950351753253894145078534997511294854886147550142192844e-13482)) }}, 
      {{ SC_(0.1215800511999987065792083740234375e-4), SC_(24110.49609375), SC_(0.1355634629726409912109375), SC_(BOOST_MATH_SMALL_CONSTANT(0.6446009470761694712696178802124602151206198100070272397820841954953457589393814080011513726764543968e-71386)), SC_(BOOST_MATH_SMALL_CONSTANT(0.4411620506592737532109016496457382048657857194340645526246628280311812592288988016544405559990034441e-5208)) }}, 
      {{ SC_(0.130341722979210317134857177734375e-4), SC_(26168.341796875), SC_(0.12707412242889404296875), SC_(BOOST_MATH_SMALL_CONSTANT(0.2166416563492047698893468112939141389204329099488114879770220649554966170201180232315257069497901648e-68742)), SC_(0.1077379305584195394942430687801727576986179591753422104711707268006164084179781893335299072659829737e-4532) }}, 
      {{ SC_(0.13885271982871927320957183837890625e-4), SC_(0.04976274073123931884765625), SC_(0.632396042346954345703125), SC_(BOOST_MATH_SMALL_CONSTANT(0.1505435304898114171757823372486217209606557096566030133214604079062750941794084777046798389177683298e-14323)), SC_(BOOST_MATH_SMALL_CONSTANT(0.8191336340381130196534918861139224810035912334983040442057176348873687528604185195239248980481620309e-31292)) }}, 
      {{ SC_(0.139016165121574886143207550048828125e-4), SC_(0.3188882328686304390430450439453125e-4), SC_(0.81474220752716064453125), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.4280498729519778987331529352631079454822421273284878121766790306889766290450686026189682387674704682e-41368)) }}, 
      {{ SC_(0.14759907571715302765369415283203125e-4), SC_(2.8241312503814697265625), SC_(0.632396042346954345703125), SC_(BOOST_MATH_SMALL_CONSTANT(0.149627207977763220942721958324439773028753443201215406980939699041850526798527355589362837986915531e-13483)), SC_(BOOST_MATH_SMALL_CONSTANT(0.2558857410093259430689102879079456979338542212672378310349005537672813392923619357148699354237694984e-29446)) }}, 
      {{ SC_(0.150794721776037476956844329833984375e-4), SC_(0.4875471131526865065097808837890625e-4), SC_(0.221111953258514404296875), SC_(BOOST_MATH_SMALL_CONSTANT(0.1196552230711909114279654256938815998740725267957310722981422063213023453615282876024769302334980208e-35700)), SC_(1.0) }}, 
      {{ SC_(0.1519624856882728636264801025390625e-4), SC_(16177.537109375), SC_(0.81474220752716064453125), SC_(BOOST_MATH_SMALL_CONSTANT(0.1452425209503955537338422359333948812006899768260140476005442384340571893909020382026092251217563149e-5859)), SC_(BOOST_MATH_SMALL_CONSTANT(0.1118345883008806780173762266422459055560035027762640953226900168492818873939725415273834608038325661e-48188)) }}, 
      {{ SC_(0.1554497794131748378276824951171875e-4), SC_(40.46924591064453125), SC_(0.905801355838775634765625), SC_(0.1263629472761081761336139611957096532344967812079201565462877028056022440086149370452532349289977537e-2765), SC_(BOOST_MATH_SMALL_CONSTANT(0.9919220074175430612528899218323716721906730140324380689847652631919111677660506550414306011565356188e-66001)) }}, 
      {{ SC_(0.15675454051233828067779541015625e-4), SC_(0.000101913392427377402782440185546875), SC_(0.81474220752716064453125), SC_(0.2853716542422836893914328033448649871440784183324642438029547731008406102487895766538278835997616547e-1712), SC_(BOOST_MATH_SMALL_CONSTANT(0.2298245136733929898089558753739834100156855492642462724846011273903684294484329372722305239196215964e-42747)) }}, 
      {{ SC_(0.15971760149113833904266357421875e-4), SC_(19.206241607666015625), SC_(0.913384497165679931640625), SC_(0.9582815834618172404720774906601516866545834853534306710079796796969465944037138120013655983754855937e-2465), SC_(BOOST_MATH_SMALL_CONSTANT(0.6326194310940251351062236483308143964837777396539364617390517845304796920345734401134182052813379253e-66519)) }}, 
      {{ SC_(0.16304524251609109342098236083984375e-4), SC_(0.00039033559733070433139801025390625), SC_(0.12707412242889404296875), SC_(BOOST_MATH_SMALL_CONSTANT(0.2749781704753392658488528370082054060663950436757594599541089373221441866088075915394337505609699445e-53860)), SC_(0.9828097758952314597050411618472387868890317665219757564769723884179197098195673563971975573178259902e-2530) }}, 
      {{ SC_(0.16487292668898589909076690673828125e-4), SC_(470997.15625), SC_(0.12707412242889404296875), SC_(BOOST_MATH_SMALL_CONSTANT(0.4541512737936566032722209936653561647042510033334139786119604257285077373847313505998057776219766456e-54347)), SC_(0.1549128670548823853403220618952571853257756905438794574182300339725200919598045497915626657567121817e-3585) }}, 
      {{ SC_(0.165044693858362734317779541015625e-4), SC_(3.57584381103515625), SC_(0.3082362115383148193359375), SC_(BOOST_MATH_SMALL_CONSTANT(0.794238046161941112343749823902683082201010853905108950104923153872086335073632221934630976272829339e-30969)), SC_(BOOST_MATH_SMALL_CONSTANT(0.2292466372763638638323475388751441681337812313997406078153894115038015753694828319985703460438800914e-9697)) }}, 
      {{ SC_(0.166259487741626799106597900390625e-4), SC_(147818.875), SC_(0.632396042346954345703125), SC_(BOOST_MATH_SMALL_CONSTANT(0.4840219552903389147605728190427790980761548760276021823940610272825144416373810916979400186204380198e-11975)), SC_(BOOST_MATH_SMALL_CONSTANT(0.3355691678737767782891887487339395952689357895271229870171944057769814627603827220615993999615612822e-26146)) }}, 
      {{ SC_(0.16847467122715897858142852783203125e-4), SC_(0.002207652665674686431884765625), SC_(0.9688708782196044921875), SC_(0.5906847920417500109372659805901565510642317169243157405152707420759307862602125145324167267749837092e-619), SC_(BOOST_MATH_SMALL_CONSTANT(0.170124244972649861948335303360579678196382235848312316943910825664898769097190318119987719590491326e-89243)) }}, 
      {{ SC_(0.1747490387060679495334625244140625e-4), SC_(0.26349246501922607421875), SC_(0.632396042346954345703125), SC_(BOOST_MATH_SMALL_CONSTANT(0.12843516647174278387874388748896407588386560678553377934101747757777562235501611818724095565006393e-11386)), SC_(BOOST_MATH_SMALL_CONSTANT(0.2536225597635438964484652244350105224785079947699063064898395295623461960169137518050619029664249122e-24869)) }}, 
      {{ SC_(0.17863809262053109705448150634765625e-4), SC_(439.38714599609375), SC_(0.8350250720977783203125), SC_(0.8244670330185256737263969143826902858678798594720040631958052373536602436314305948340758463250207469e-4386), SC_(BOOST_MATH_SMALL_CONSTANT(0.7352777980091604256079199692103097168555239346683458759313911552620269891691410672306190764078484364e-43811)) }}, 
      {{ SC_(0.1895247623906470835208892822265625e-4), SC_(1.07109558582305908203125), SC_(0.9688708782196044921875), SC_(0.1958346418095304122274704022704012284830310878577730588329056279113401343952355448951150975955101985e-724), SC_(BOOST_MATH_SMALL_CONSTANT(0.1204102194190057648286366185479451893365394896311826527650411245123421846075536145059629401728008699e-79505)) }}, 
      {{ SC_(0.19740999050554819405078887939453125e-4), SC_(105.41565704345703125), SC_(0.3082362115383148193359375), SC_(BOOST_MATH_SMALL_CONSTANT(0.4171715706701289778828007890899248697163485933652243450349057614457988149098646573044273964497613009e-25893)), SC_(BOOST_MATH_SMALL_CONSTANT(0.4289676998659303218462202648585110823764351223533266318047234914191374259260207999216104631145461676e-8109)) }}, 
      {{ SC_(0.2004335328820161521434783935546875e-4), SC_(482.00701904296875), SC_(0.905801355838775634765625), SC_(0.2300786867506388908353022364598233237429971469616025799538393909707204968894677299870201252175165343e-2146), SC_(BOOST_MATH_SMALL_CONSTANT(0.1799474819364733378341626493308533546950444872243502571473922786173950526564225295056238004071701751e-51189)) }}, 
      {{ SC_(0.2017128645093180239200592041015625e-4), SC_(232.9792938232421875), SC_(0.1355634629726409912109375), SC_(BOOST_MATH_SMALL_CONSTANT(0.9782152059532611372922752218945140821311267421642771819909290848934391306656384389032421044430100903e-43027)), SC_(0.7953007761061898269032745221331387025438802327808884652857398546810598867143141546217396350761801352e-3139) }}, 
      {{ SC_(0.20203804524498991668224334716796875e-4), SC_(42.8336334228515625), SC_(0.1355634629726409912109375), SC_(BOOST_MATH_SMALL_CONSTANT(0.9505827239534352483275638000309426098918435445176677914029048966050973796738555346371505206583029493e-42957)), SC_(0.4879738324842388808208264019692856316850110596695651192968764647838931697912322372907706638620027653e-3133) }}, 
      {{ SC_(0.20300331016187556087970733642578125e-4), SC_(42.38938140869140625), SC_(0.9688708782196044921875), SC_(0.3816869308438157775438575701400816009072542007939410749970155744055876159478755860836778076571703486e-678), SC_(BOOST_MATH_SMALL_CONSTANT(0.127201723496121023828113564898347237146568849457350377769280925620763942807444814392111020123066826e-74228)) }}, 
      {{ SC_(0.2051885167020373046398162841796875e-4), SC_(236087.890625), SC_(0.8350250720977783203125), SC_(0.2236779936126539857160222845963337050945115341054176739161533824043234207571359913112629207518401323e-3821), SC_(BOOST_MATH_SMALL_CONSTANT(0.5187557340526034705800892748375743405416818891180832866460176073642680219205270491482771189624680261e-38145)) }}, 
      {{ SC_(0.21041001673438586294651031494140625e-4), SC_(3.8230969905853271484375), SC_(0.12707412242889404296875), SC_(BOOST_MATH_SMALL_CONSTANT(0.2611050064285175125482131273698210462799115955403897510685180499383028995007734375008754345306902882e-42581)), SC_(0.1263421304086059092982729044494063450981720138268968234081464502945179653799025464601347361390558349e-2805) }}, 
      {{ SC_(0.2107691761921159923076629638671875e-4), SC_(0.04489715397357940673828125), SC_(0.221111953258514404296875), SC_(BOOST_MATH_SMALL_CONSTANT(0.3900373750276575859585149320905549732932763658865496075030893208483961831557459599669540245248710031e-31085)), SC_(BOOST_MATH_SMALL_CONSTANT(0.4404830308340426746130675276769279825579374873733567061860857053216363945038073562970896042079876724e-5139)) }}, 
      {{ SC_(0.21139929231139831244945526123046875e-4), SC_(0.17535277947899885475635528564453125e-4), SC_(0.8350250720977783203125), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.473270793701914810977987563126323761517466803284082613651628762799832085337970872475482395336393227e-20769)) }}, 
      {{ SC_(0.21433561414596624672412872314453125e-4), SC_(3719.279052734375), SC_(0.81474220752716064453125), SC_(0.5697755869431091234460288256178201914669184558313577703589192769624449530099467135008330171347109014e-4155), SC_(BOOST_MATH_SMALL_CONSTANT(0.5052326319604125969261540109121341746553338155418535572465629231132318093045693841291017785062704029e-34166)) }}, 
      {{ SC_(0.22448601157520897686481475830078125e-4), SC_(445071.28125), SC_(0.221111953258514404296875), SC_(BOOST_MATH_SMALL_CONSTANT(0.1154051199795256693167224940027851782575716013364780412354086379221856337304339043125449929568329416e-29200)), SC_(0.5317196597832401400329618898138594703102901476369725585493922299078299104951909429878615105121363765e-4840) }}, 
      {{ SC_(0.22683978386339731514453887939453125e-4), SC_(0.0405500046908855438232421875), SC_(0.905801355838775634765625), SC_(0.3320529691129112781183346091758024243131258015814127148220088686655475575144026542984765934147092121e-1883), SC_(BOOST_MATH_SMALL_CONSTANT(0.3063046523049329771837110182553346515767597472422624500690020343432489716503981152245110195835717713e-45217)) }}, 
      {{ SC_(0.234849067055620253086090087890625e-4), SC_(25542.79296875), SC_(0.9688708782196044921875), SC_(0.3441730180671123519495976583198624119926731047061369849411568660575245402127433117800519623117640306e-589), SC_(BOOST_MATH_SMALL_CONSTANT(0.3751784934105693320455113760515845925736447146431148474482569436486280690421206833759119870649005669e-64166)) }}, 
      {{ SC_(0.23615430109202861785888671875e-4), SC_(4.50702953338623046875), SC_(0.905801355838775634765625), SC_(0.4988379611542168986414874238506419923844468056925819195174874699047526593073353049454994954833639083e-1820), SC_(BOOST_MATH_SMALL_CONSTANT(0.7341840761161541739065036501325419142613794847229658509278972834999220997543398966712274676180693554e-43445)) }}, 
      {{ SC_(0.2399934965069405734539031982421875e-4), SC_(462.945892333984375), SC_(0.81474220752716064453125), SC_(0.3110095684445031013162420462860776918422474101001024588575132091902755892192793640381029649700096935e-3710), SC_(BOOST_MATH_SMALL_CONSTANT(0.8797682788975050110209751601822341604088251725221823097384363697152422631690456231980809725272529829e-30513)) }}, 
      {{ SC_(0.24066381229204125702381134033203125e-4), SC_(1270.3814697265625), SC_(0.12707412242889404296875), SC_(BOOST_MATH_SMALL_CONSTANT(0.4576190191092904160454048722884335228372052972542105302690069527168297955063547521360024576623301653e-37231)), SC_(0.1420858306336174465235602280120246573601819672841164112725840259803341782460177715076940711063890289e-2455) }}, 
      {{ SC_(0.25217834263457916676998138427734375e-4), SC_(1832.2723388671875), SC_(0.913384497165679931640625), SC_(0.1686620810515798084807520522209297815900439981037687996482171429286465763028158287049421053915524687e-1563), SC_(BOOST_MATH_SMALL_CONSTANT(0.2500645969247788958633246925374597812716157867336745565308065217364621462118518662925089351446878108e-42132)) }}, 
      {{ SC_(0.252623358392156660556793212890625e-4), SC_(0.18408362567424774169921875), SC_(0.1355634629726409912109375), SC_(BOOST_MATH_SMALL_CONSTANT(0.2743427505483676484256175431234170641774606693989735069168855839327638237012878361548973902795998892e-34351)), SC_(0.7031666053222338307595293315449316865297838014279428098534333754498580394690990873394128824939905225e-2502) }}, 
      {{ SC_(0.2568908166722394526004791259765625e-4), SC_(0.0026883506216108798980712890625), SC_(0.905801355838775634765625), SC_(0.1578875734130016176302992983732961079346954066547091801166809994581467564455851791032398832398018025e-1511), SC_(BOOST_MATH_SMALL_CONSTANT(0.2341259619261955766782778385507062619379614455720724579754306604198840826735605051621159618286928358e-39776)) }}, 
      {{ SC_(0.26870451620197854936122894287109375e-4), SC_(0.000144985810038633644580841064453125), SC_(0.8350250720977783203125), SC_(0.9888337425304244712013096232948525191068632527405749434176388147263952275675242673761059158623788143e-166), SC_(BOOST_MATH_SMALL_CONSTANT(0.5413087344681832213235005061729244935796516193762206919387843998935430650190903037264031499756215662e-26376)) }}, 
      {{ SC_(0.27549775040824897587299346923828125e-4), SC_(0.1503586471080780029296875), SC_(0.12707412242889404296875), SC_(BOOST_MATH_SMALL_CONSTANT(0.8181540477895649748762420463171081554083663224695416509954885206095656839589686087124835665442879842e-32518)), SC_(0.2462322550135262716431415588537906535110788732273365839795667016396525276471877892724411526414976991e-2139) }}, 
      {{ SC_(0.2782344745355658233165740966796875e-4), SC_(0.295027554035186767578125), SC_(0.8350250720977783203125), SC_(0.1278292308361380656193177947071432183369866616602705655667678332292163066466318520326718174045292449e-2812), SC_(BOOST_MATH_SMALL_CONSTANT(0.3860943098799782356408940219712438194770816672701033543757478725092151765852410278931715506024795017e-28125)) }}, 
      {{ SC_(0.28775624741683714091777801513671875e-4), SC_(25491.8359375), SC_(0.905801355838775634765625), SC_(0.1473261355137398155011141009775050446169103918759589552951768300766343955675642581210849928901748107e-1497), SC_(BOOST_MATH_SMALL_CONSTANT(0.5217155068967073959232563103611620257843968467713802555935398994953775819903315697408459540543981014e-35658)) }}, 
      {{ SC_(0.2893155397032387554645538330078125e-4), SC_(494.983856201171875), SC_(0.9688708782196044921875), SC_(0.2214048516998759629744858269037850383644604658166103544023139293349638862809561382032391592312324544e-477), SC_(BOOST_MATH_SMALL_CONSTANT(0.2322977714184520269211746119681752807171971177273511871734584204282302240392088583619323923321396253e-52085)) }}, 
      {{ SC_(0.29415024982881732285022735595703125e-4), SC_(0.00041924233664758503437042236328125), SC_(0.3082362115383148193359375), SC_(BOOST_MATH_SMALL_CONSTANT(0.1405534159248066997103271948013564698708179432152430515950232282291382253871954661868456467068231098e-16374)), SC_(0.222065748504377622879286572762480656498910969018522808743848314373828884496856282233576890159533318e-4439) }}, 
      {{ SC_(0.29590575650217942893505096435546875e-4), SC_(0.283195674419403076171875), SC_(0.81474220752716064453125), SC_(0.2154808290713006032100156759319481127361319809621867304793677964782374968778883573291545611646288826e-3005), SC_(BOOST_MATH_SMALL_CONSTANT(0.1603552053591524426177949971495129448566287164068848498039592571954479687286433631543286779538761406e-24743)) }}, 
      {{ SC_(0.299345629173330962657928466796875e-4), SC_(4.095668792724609375), SC_(0.81474220752716064453125), SC_(0.5196055449684084143516386383118687306867205699439977606524188083826834727571742938138760636632194297e-2973), SC_(BOOST_MATH_SMALL_CONSTANT(0.2437053630285360958851482887590704784303383342870823574692973085259514678816776828062492453198275383e-24461)) }}, 
      {{ SC_(0.30238283216021955013275146484375e-4), SC_(47.60295867919921875), SC_(0.221111953258514404296875), SC_(BOOST_MATH_SMALL_CONSTANT(0.9321887064205378872229585244564413110885910626258126088306621014298436870871951071821387187442611514e-21676)), SC_(0.1213736685648309514074587400458688769158875012929347831971984355375331163800085456183839159724919364e-3590) }}, 
      {{ SC_(0.3114132778136990964412689208984375e-4), SC_(348144.0), SC_(0.3082362115383148193359375), SC_(BOOST_MATH_SMALL_CONSTANT(0.2564169166061677471672615381864930435296242794719327337679452161494929456649170217667065978734305135e-16418)), SC_(BOOST_MATH_SMALL_CONSTANT(0.9688429129424356903276490372990977877118692169687936851001252857728923160632456013823032483855292724e-5145)) }}, 
      {{ SC_(0.31231902539730072021484375e-4), SC_(33712.953125), SC_(0.221111953258514404296875), SC_(BOOST_MATH_SMALL_CONSTANT(0.4571522067098797040562684640899168266975097279621382775130725293419218412779615105191774966472576827e-20989)), SC_(0.2573106672840410380822917482839769800185745410605353368659945769528618592560687539288531970023811281e-3479) }}, 
      {{ SC_(0.3187526090187020599842071533203125e-4), SC_(0.4971525049768388271331787109375e-4), SC_(0.905801355838775634765625), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.1507883810128888762679504360131900432849506796036146018007903657943596818799705890814512754055586328e-25436)) }}, 
      {{ SC_(0.3188861956004984676837921142578125e-4), SC_(16.32230377197265625), SC_(0.8350250720977783203125), SC_(0.1298262616465282715767271924980895028143644766095820511831644360803801759867912414728771230391885871e-2456), SC_(BOOST_MATH_SMALL_CONSTANT(0.2767627169830641075284656055027015246053535193598921144000819790157135165458466893549180906222486659e-24542)) }}, 
      {{ SC_(0.319889441016130149364471435546875e-4), SC_(3931.19482421875), SC_(0.3082362115383148193359375), SC_(BOOST_MATH_SMALL_CONSTANT(0.1773634713777084083511430573444851801451064251531875439312779096503415074392671715708488636019680445e-15981)), SC_(BOOST_MATH_SMALL_CONSTANT(0.1283323919641290075624851616052156931984540392148494145568105633891913544783329965742528684079350212e-5006)) }}, 
      {{ SC_(0.32712865504436194896697998046875e-4), SC_(3109.48583984375), SC_(0.9688708782196044921875), SC_(0.2623647149797575492783687118935843357045992324891910436571331718223281336138205915531066599158735727e-423), SC_(BOOST_MATH_SMALL_CONSTANT(0.7171758557203420523043470585211560466194322904609620567954214024282315826385950612765018545398284663e-46066)) }}, 
      {{ SC_(0.3275294511695392429828643798828125e-4), SC_(25796.328125), SC_(0.8350250720977783203125), SC_(0.4992053462405342599776391467632566097299408028157087143908341093542047028790242197689077688285241312e-2395), SC_(BOOST_MATH_SMALL_CONSTANT(0.7099977617736449666482713375435273015460103288886378949522985793917134341210311928525086779798465597e-23898)) }}, 
      {{ SC_(0.334105643560178577899932861328125e-4), SC_(3378.014404296875), SC_(0.221111953258514404296875), SC_(BOOST_MATH_SMALL_CONSTANT(0.1088187624965955505094982973627684721756921175095612110902472707075526924705943037821545606017059404e-19619)), SC_(0.9949684623152091367973910379436120989665211279519935888679097781126341226534544073475151448383513498e-3252) }}, 
      {{ SC_(0.334107098751701414585113525390625e-4), SC_(4.2327022552490234375), SC_(0.913384497165679931640625), SC_(0.3302140511476925970089440183947851498874384393056499070340845152546754963722596856715560438763361651e-1178), SC_(BOOST_MATH_SMALL_CONSTANT(0.721550812904941692732465523570115185441213777345946152740589938570407974601225828291058986399431556e-31799)) }}, 
      {{ SC_(0.3407927579246461391448974609375e-4), SC_(288782.71875), SC_(0.81474220752716064453125), SC_(0.2109135641523372669140280248988840170444293913802157477372092130970432429572818868611883540911372329e-2616), SC_(BOOST_MATH_SMALL_CONSTANT(0.2514162921223999573731802340282039350295774045119788634791113912254748615048375244034258269581906402e-21491)) }}, 
      {{ SC_(0.346417873515747487545013427734375e-4), SC_(411.559112548828125), SC_(0.913384497165679931640625), SC_(0.2133153834019422416023619900569771678826523672291925027801753594912575501262851665014411694977703309e-1138), SC_(BOOST_MATH_SMALL_CONSTANT(0.7010688922326638480573085051240538425179556810481349439133974938599939875403662654291337206727144197e-30671)) }}, 
      {{ SC_(0.3529437162796966731548309326171875e-4), SC_(0.22326681573758833110332489013671875e-4), SC_(0.632396042346954345703125), SC_(1.0), SC_(0.1679136383980843511637249694083361811044488550810665223615625087133701364929659445973904964914972386e-647) }}, 
      {{ SC_(0.358525212504900991916656494140625e-4), SC_(0.4175899922847747802734375), SC_(0.905801355838775634765625), SC_(0.2343697173729498422189297849832239496833304472905684856323496553026475588814733191639300150358207883e-1197), SC_(BOOST_MATH_SMALL_CONSTANT(0.6596727681214564022871450491580307900624839348498222377460976652541927290888421159671849121886582417e-28615)) }}, 
      {{ SC_(0.3616316462284885346889495849609375e-4), SC_(311936.78125), SC_(0.905801355838775634765625), SC_(0.1293118466016912108455958416176646899851260448619891462678002770480373451658206363414469153521598654e-1193), SC_(BOOST_MATH_SMALL_CONSTANT(0.119999815388237949074063308456434021313213735248807878200422481001986161451626398456876580517384044e-28375)) }}, 
      {{ SC_(0.362039208994247019290924072265625e-4), SC_(3.842815399169921875), SC_(0.221111953258514404296875), SC_(BOOST_MATH_SMALL_CONSTANT(0.3544734526213706099454685135575417560703279572478093675779813090605397694571956765464491678916570822e-18103)), SC_(0.4180206241677413514841559660483820475430290709184922818176636477679167481907369958639649743608398598e-2998) }}, 
      {{ SC_(0.3621911673690192401409149169921875e-4), SC_(0.001695460639894008636474609375), SC_(0.913384497165679931640625), SC_(0.1288280457224668780743816372420978938285421765081656239836959964838944253041009430275132356668406226e-832), SC_(BOOST_MATH_SMALL_CONSTANT(0.5697362458132279589783413883108821219398435118946284545945562849097738681418558423708732106133995706e-29079)) }}, 
      {{ SC_(0.36229626857675611972808837890625e-4), SC_(0.004191714338958263397216796875), SC_(0.12707412242889404296875), SC_(BOOST_MATH_SMALL_CONSTANT(0.3940400839080479567586394155768258914791983335204978210406036543210500908187185259963745776884174156e-24626)), SC_(0.1080292882256422099552040843840157970507678744503491295903443423718104140719602323148254017180211606e-1525) }}, 
      {{ SC_(0.3714940612553618848323822021484375e-4), SC_(0.00259495410136878490447998046875), SC_(0.632396042346954345703125), SC_(BOOST_MATH_SMALL_CONSTANT(0.1356989835799972192597273298949967565671434897149949467453728471572063953543506772625236862729694821e-5190)), SC_(BOOST_MATH_SMALL_CONSTANT(0.8561254770485099992034032886831374398058297406377657980857486120910212835422396954987295313640453016e-11533)) }}, 
      {{ SC_(0.3718810694408603012561798095703125e-4), SC_(1.01127374172210693359375), SC_(0.1355634629726409912109375), SC_(BOOST_MATH_SMALL_CONSTANT(0.1077735820964225917380470071662590042583243093922642245930134842359049963955754289626778087872649737e-23336)), SC_(0.5313597812912107703638905071150951907554665070138144057144001779439358176605035994445262936046356265e-1701) }}, 
      {{ SC_(0.3756858131964690983295440673828125e-4), SC_(386440.28125), SC_(0.913384497165679931640625), SC_(0.6938348459489127956412976095546426355497874607824619462541175972265423708569533419804404918656180059e-1053), SC_(BOOST_MATH_SMALL_CONSTANT(0.1249757466297388786057324955033321582981458421926062580808076861019234345529522100086401227723745064e-28284)) }}, 
      {{ SC_(0.3779314647545106709003448486328125e-4), SC_(0.015007309615612030029296875), SC_(0.8350250720977783203125), SC_(0.118810205222776899417803687178012075409991919564610841348835150094825747873487115628586985816217759e-2042), SC_(BOOST_MATH_SMALL_CONSTANT(0.810187046258777287646336537968837529857752705285400756632676692894477095757522513711438063422526438e-20678)) }}, 
      {{ SC_(0.3796306918957270681858062744140625e-4), SC_(26.5066623687744140625), SC_(0.3082362115383148193359375), SC_(BOOST_MATH_SMALL_CONSTANT(0.6598965623874491832972190274659900750010182028314223382636015593020450025268000629719755111735890524e-13465)), SC_(0.3989359837027342169859807648389591498610396713277327250235582229672408997817051079102203736651445381e-4217) }}, 
      {{ SC_(0.382418438675813376903533935546875e-4), SC_(0.041891194880008697509765625), SC_(0.12707412242889404296875), SC_(BOOST_MATH_SMALL_CONSTANT(0.9873323811638740353410732589920679289192321776712090313263010195106904399487210480324540942232188904e-23418)), SC_(0.8491512042328636035595900109307950549910858021615642828214730768092395164321337952830436535923471749e-1533) }}, 
      {{ SC_(0.3837459371425211429595947265625e-4), SC_(0.468349933624267578125), SC_(0.913384497165679931640625), SC_(0.2241235540048448638458579583517893589998982524673312917609725284970663516122466297631156386453714775e-1024), SC_(BOOST_MATH_SMALL_CONSTANT(0.3769155004866211354850679924222766333317426620770543639710709283784973890926589758868109311853381624e-27684)) }}, 
      {{ SC_(0.3972529884777031838893890380859375e-4), SC_(0.00289903464727103710174560546875), SC_(0.8350250720977783203125), SC_(0.5483575678917936436949935196603432950338084509938853676999723995665568731766873108531873188494847588e-1822), SC_(BOOST_MATH_SMALL_CONSTANT(0.8848369790249811078099793860211098854547582799501395652527369169917918737958891179693704276411854277e-19551)) }}, 
      {{ SC_(0.3992606434621848165988922119140625e-4), SC_(495351.78125), SC_(0.9688708782196044921875), SC_(0.1164534821982592030672927656096508086827152784596402335692547063157800378222976279629261862316799955e-349), SC_(BOOST_MATH_SMALL_CONSTANT(0.2929244484399204867185089747049556705503127694304187981003530977961498473815862621862143844671370993e-37746)) }}, 
      {{ SC_(0.4005068331025540828704833984375e-4), SC_(42.8498382568359375), SC_(0.12707412242889404296875), SC_(BOOST_MATH_SMALL_CONSTANT(0.7859204786488360510684191057998450107874559758216638101868641977764555934670971577857405050244603552e-22372)), SC_(0.2654442262986538279189732464500107656586452857842403732824436935911339751157770521150566856758628307e-1475) }}, 
      {{ SC_(0.401491633965633809566497802734375e-4), SC_(3246.22998046875), SC_(0.905801355838775634765625), SC_(0.112977412882178900134385777413607284643461048436540236745690012152735459343115315544141992726099701e-1073), SC_(BOOST_MATH_SMALL_CONSTANT(0.4424172903643803288578143023108364330817321606229579227313357011187183345623163738049426663155162042e-25557)) }}, 
      {{ SC_(0.401874640374444425106048583984375e-4), SC_(0.4230124056339263916015625), SC_(0.9688708782196044921875), SC_(0.1100720893157627362937366296851776187134318167340247108911993602928621672418382282695932224468424835e-340), SC_(BOOST_MATH_SMALL_CONSTANT(0.4883930877551489306324687755681617482312232773519412809834786339488860386961069019505126908456950954e-37494)) }}, 
      {{ SC_(0.40288010495714843273162841796875e-4), SC_(2569.28173828125), SC_(0.8350250720977783203125), SC_(0.6627313078473817098675390758464825155439030125385070059490309453377004511869090229363770345790413739e-1947), SC_(BOOST_MATH_SMALL_CONSTANT(0.4478580576144933415867115861353004306483506549857235464354358905466443067939229974382383708020959197e-19428)) }}, 
      {{ SC_(0.40309605537913739681243896484375e-4), SC_(0.0039625889621675014495849609375), SC_(0.81474220752716064453125), SC_(0.4297219759455842553977753641166272093924110867575498015986936377915839627832532881673730650860546229e-2098), SC_(BOOST_MATH_SMALL_CONSTANT(0.1131862219566481176250143724466206130773062564110751371526259863433521485903001058774208214004662327e-18055)) }}, 
      {{ SC_(0.4062067091581411659717559814453125e-4), SC_(0.12048657238483428955078125), SC_(0.221111953258514404296875), SC_(BOOST_MATH_SMALL_CONSTANT(0.1524431223087137054598773090361260966748907707997517149119120417069725647075815285192449448161909435e-16130)), SC_(0.718310945278950705305351059214126184320966441965831821856089475048512214946952047110303375327870065e-2668) }}, 
      {{ SC_(0.4116668787901289761066436767578125e-4), SC_(24253.806640625), SC_(0.3082362115383148193359375), SC_(BOOST_MATH_SMALL_CONSTANT(0.3884884579630244647432121874653720166074946306858397332980485597789894564589091428052418264063418006e-12420)), SC_(0.5039422300210376491185072692446958776841122680087188966755831182376679349874392686015199583363438428e-3892) }}, 
      {{ SC_(0.416882903664372861385345458984375e-4), SC_(0.00045137223787605762481689453125), SC_(0.913384497165679931640625), SC_(0.2941597748347749411754047337807015012576507844430748545298337852169539531016813003685811387576944405e-23), SC_(BOOST_MATH_SMALL_CONSTANT(0.6490759234749804574289194979741186257670139448339576708206530257959728849550179134048101279302420689e-24564)) }}, 
      {{ SC_(0.417713818023912608623504638671875e-4), SC_(274447.0), SC_(0.1355634629726409912109375), SC_(BOOST_MATH_SMALL_CONSTANT(0.8891395834060674840111369292928696900946762064913008632147212723122733242419191346912504649141260379e-20782)), SC_(0.5153076037935924074179248490891634896352435546614761313109653438459835935895159710831917889190593927e-1520) }}, 
      {{ SC_(0.418079944211058318614959716796875e-4), SC_(0.11457650363445281982421875), SC_(0.3082362115383148193359375), SC_(BOOST_MATH_SMALL_CONSTANT(0.2446650889729255533700789560277005533318807205110375390599135619137953482484990594137550691784617627e-12221)), SC_(0.4853460838101037201350937644183993874233733743743725662787994602960719050919207250899540608031639398e-3824) }}, 
      {{ SC_(0.42011219193227589130401611328125e-4), SC_(0.000218811779632233083248138427734375), SC_(0.632396042346954345703125), SC_(0.3179529997451293102768983483299318098705913075382976031049468527683708052258069951390726888744562447e-2921), SC_(BOOST_MATH_SMALL_CONSTANT(0.1833136034351968298404565348891649429152474775943227473503880078105211588710473018887964387242219035e-8529)) }}, 
      {{ SC_(0.4257139153196476399898529052734375e-4), SC_(219.9326934814453125), SC_(0.221111953258514404296875), SC_(BOOST_MATH_SMALL_CONSTANT(0.239715433935781453113059624532973263096379876488085000296126067107269694939393323284449360105557112e-15397)), SC_(0.1451318181094095558388067103539926698250898931142471176273042115024709390909492472743967403267308459e-2551) }}, 
      {{ SC_(0.4258894841768778860569000244140625e-4), SC_(0.15419080227729864418506622314453125e-4), SC_(0.12707412242889404296875), SC_(BOOST_MATH_SMALL_CONSTANT(0.1830534673552623209868695525333608693870478140986771641343952511061662952704389325698588842694442893e-7525)), SC_(1.0) }}, 
      {{ SC_(0.429383144364692270755767822265625e-4), SC_(0.0428761281073093414306640625), SC_(0.81474220752716064453125), SC_(0.6670993384074829827824185730735050260592416849695388102678720275285538601446792617170942562110737722e-2062), SC_(BOOST_MATH_SMALL_CONSTANT(0.1503852748893043569070584420804374973503282498107814611717957243181610257848040689066752011011521903e-17042)) }}, 
      {{ SC_(0.4323314715293236076831817626953125e-4), SC_(4174.39013671875), SC_(0.1355634629726409912109375), SC_(BOOST_MATH_SMALL_CONSTANT(0.1741737479435393164070743783516644538515708455721353687328907068917805988236924308779533332447842736e-20077)), SC_(0.5500647637598311764868356339788056582397278290971924670228151741233423921688471919435618588405276741e-1467) }}, 
      {{ SC_(0.43628693674691021442413330078125e-4), SC_(495.40863037109375), SC_(0.12707412242889404296875), SC_(BOOST_MATH_SMALL_CONSTANT(0.2635777732785853666597970569223099981540401902251114779117540286381653810376775458715609675588234809e-20538)), SC_(0.164074553389435495570864834112651743836218423938126161793683427926194069848835465073779036174452069e-1355) }}, 
      {{ SC_(0.4396517397253774106502532958984375e-4), SC_(0.001847697305493056774139404296875), SC_(0.221111953258514404296875), SC_(BOOST_MATH_SMALL_CONSTANT(0.2072584932333773564080754602009290026147836909320390107919267400046227568219163001236961402925266791e-14674)), SC_(0.7278393721393212191636655689421757500953426177953531997548969548847209180826615334861392217179462783e-2236) }}, 
      {{ SC_(0.45636130380444228649139404296875e-4), SC_(26.9266033172607421875), SC_(0.632396042346954345703125), SC_(0.323083658339483384179601029113392314163137312213380465279928094216180094437240628578107487940484812e-4362), SC_(BOOST_MATH_SMALL_CONSTANT(0.5453589185628250950056526063344565014212839206511911193164643251785928220063791558745558710897233194e-9525)) }}, 
      {{ SC_(0.4623167842510156333446502685546875e-4), SC_(0.43400345020927488803863525390625e-4), SC_(0.1355634629726409912109375), SC_(BOOST_MATH_SMALL_CONSTANT(0.8747815788931347648685677846348816901925149746536605658179046750713326074713944693294722365402966867e-11959)), SC_(1.0) }}, 
      {{ SC_(0.4653503492590971291065216064453125e-4), SC_(0.188413614523597061634063720703125e-4), SC_(0.3082362115383148193359375), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.4662941864808090031147003173828125e-4), SC_(0.0003559053293429315090179443359375), SC_(0.905801355838775634765625), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.2278846383149582863330657837021062220741269034971105380714965002593295259446413122677513482369829253e-20855)) }}, 
      {{ SC_(0.466877463622950017452239990234375e-4), SC_(3780.931396484375), SC_(0.632396042346954345703125), SC_(0.3792134529387148669313493271326150806492845076363064844674665222071394519228007370261867998775447123e-4266), SC_(BOOST_MATH_SMALL_CONSTANT(0.1244183253032945566273609797972337616590853930158142929015016671564364271096784974648192559147336436e-9312)) }}, 
      {{ SC_(0.47170542529784142971038818359375e-4), SC_(186.8951263427734375), SC_(0.632396042346954345703125), SC_(0.3266934840647815839338074317916427555204804089933043179563306543980085860044600040331042838063841602e-4221), SC_(BOOST_MATH_SMALL_CONSTANT(0.4802980821004654344184354328412999752992167798802903607491862312198391305372279970831923750822234395e-9216)) }}, 
      {{ SC_(0.4735972834168933331966400146484375e-4), SC_(0.00372543814592063426971435546875), SC_(0.3082362115383148193359375), SC_(BOOST_MATH_SMALL_CONSTANT(0.4203411708941611365307481908812525554332512659659422794425638587632778786194833657777412146496213478e-10676)), SC_(0.3545675968378522660735942462974295093159607103287951436777706458954341569448452537406723701671971643e-3263) }}, 
      {{ SC_(0.47360430471599102020263671875e-4), SC_(48598.65234375), SC_(0.632396042346954345703125), SC_(0.1031727817363177217505517656556272744304502709993537968787178645244928602428924058767552526928075161e-4206), SC_(BOOST_MATH_SMALL_CONSTANT(0.1611856191966404301510900622517923061426474848337196558453979507048007790994379343797797282769258803e-9181)) }}, 
      {{ SC_(0.4800888200406916439533233642578125e-4), SC_(0.029623560607433319091796875), SC_(0.913384497165679931640625), SC_(0.1157704297196141331216759930615622010791536997118194911791694800153490512580102625698468659796212328e-804), SC_(BOOST_MATH_SMALL_CONSTANT(0.198771528236678513687078507418301769671318186775841206361997488563487582517136901311543827876235759e-22114)) }}, 
      {{ SC_(0.4828667806577868759632110595703125e-4), SC_(0.000143944707815535366535186767578125), SC_(0.221111953258514404296875), SC_(BOOST_MATH_SMALL_CONSTANT(0.7495894240132409319745795199641789566690476465611793795414005142859915750552626889750001395354628769e-10971)), SC_(1.0) }}, 
      {{ SC_(0.4830027683055959641933441162109375e-4), SC_(0.49858455895446240901947021484375e-4), SC_(0.913384497165679931640625), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.1081870262766115490308798173959278837682400300098825729962424895789956287156042080991887099644208004e-15904)) }}, 
      {{ SC_(0.48371657612733542919158935546875e-4), SC_(33.2382659912109375), SC_(0.81474220752716064453125), SC_(0.5392295180080476545815126479353849047663688066564460469494117659565275079874806508978081193819639046e-1841), SC_(BOOST_MATH_SMALL_CONSTANT(0.6094665583717628530904316743021371250321111097379281222105980449051863532879698461913515793376942782e-15139)) }}, 
      {{ SC_(0.483796975458972156047821044921875e-4), SC_(0.00030146507197059690952301025390625), SC_(0.9688708782196044921875), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.1211173323113230084605677823903929547322642893402100963874701935994275378520822610889395584474783023e-29809)) }}, 
      {{ SC_(0.48389760195277631282806396484375e-4), SC_(3.295018672943115234375), SC_(0.8350250720977783203125), SC_(0.1512644959704413213389024275500845816126149022418010339140532986481037634186944658282689839722893346e-1618), SC_(BOOST_MATH_SMALL_CONSTANT(0.6736806796167028920949019281678663706552176285176919437958212962773296232922990951215758814014026536e-16173)) }}, 
      {{ SC_(0.4859554246650077402591705322265625e-4), SC_(0.487077995785512030124664306640625e-4), SC_(0.9688708782196044921875), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.4524908534324837441439801698100149083397057157404919827350847674356499061323376516388426576082523905e-24823)) }}, 
      {{ SC_(0.4882370922132395207881927490234375e-4), SC_(0.0004924438544549047946929931640625), SC_(0.1355634629726409912109375), SC_(BOOST_MATH_SMALL_CONSTANT(0.3646518140646385627314490689610669214632800685344959267311961453988290824656744707768834723394102092e-16934)), SC_(0.1161009047612075761242646775509747727341695136708928888262636983566409939790437312422345504636527041e-454) }}, 
      {{ SC_(0.0001018536931951530277729034423828125), SC_(0.000113726928248070180416107177734375), SC_(0.221111953258514404296875), SC_(0.2066954203816580316215441712214424636741228945439188594937361041977961072341864728543389711001325554e-3707), SC_(1.0) }}, 
      {{ SC_(0.0001061613802448846399784088134765625), SC_(26.1992549896240234375), SC_(0.3082362115383148193359375), SC_(0.6561769229143689591030927870417351314309952619922160057603842444780352906719559937783245361591823151e-4816), SC_(0.6349202856011439954093262170673225006615982635242278290596467860089210038061365580664316066990041684e-1509) }}, 
      {{ SC_(0.0001172095144283957779407501220703125), SC_(46.33734893798828125), SC_(0.632396042346954345703125), SC_(0.1517462141090208633893889901779005509855209226707053670733298611559957657254851288574150264553636184e-1699), SC_(0.1068817114613491257306433756926925641068877423362993610036747686945269519827489058223298955708257712e-3709) }}, 
      {{ SC_(0.00011986176832579076290130615234375), SC_(0.429382145404815673828125), SC_(0.1355634629726409912109375), SC_(BOOST_MATH_SMALL_CONSTANT(0.1946741600808288986054664384925735525358605351070691110016222896001799658815435484280158175061511342e-7239)), SC_(0.8756347278664867265476720199557627625281780369452883056692648818089895352084926565564504160356494136e-527) }}, 
      {{ SC_(0.0001239118282683193683624267578125), SC_(2.7409827709197998046875), SC_(0.9688708782196044921875), SC_(0.3612092388423149995861104392947964360431616042214108514709734050882172964038314449862238141943186574e-111), SC_(BOOST_MATH_SMALL_CONSTANT(0.7386482983728915712656473400428352870944476154256226050553993677753757147996331599078275854660490037e-12161)) }}, 
      {{ SC_(0.000130386673845350742340087890625), SC_(0.0404968559741973876953125), SC_(0.81474220752716064453125), SC_(0.1773260106876984756025313449304379872082783853967079538614627035844230412189487396086941287498508612e-671), SC_(BOOST_MATH_SMALL_CONSTANT(0.7832770003958532273454039144081940444751263099293398656352254531322877271068271591283147178715837703e-5605)) }}, 
      {{ SC_(0.000131270222482271492481231689453125), SC_(0.4417803938849829137325286865234375e-4), SC_(0.913384497165679931640625), SC_(1.0), SC_(0.2552140025859397293472505667061728339439104733457842212570630846542138002920485118928974128727523255e-3530) }}, 
      {{ SC_(0.0001324503100477159023284912109375), SC_(251.767547607421875), SC_(0.9688708782196044921875), SC_(0.4537064445901084811651717843855173961971944783493810912867535459756830764230572425068408950044450515e-106), SC_(BOOST_MATH_SMALL_CONSTANT(0.5718411759415848800487399921739353916100391666058108904922439323670404495330842459664454264197270132e-11379)) }}, 
      {{ SC_(0.0001335285487584769725799560546875), SC_(0.4650310074794106185436248779296875e-4), SC_(0.1355634629726409912109375), SC_(0.1386861059709135063224782373435801185647788993688987597179237811255267983919363186125254219690899373e-2096), SC_(1.0) }}, 
      {{ SC_(0.000133774345158599317073822021484375), SC_(0.00023849334684200584888458251953125), SC_(0.8350250720977783203125), SC_(1.0), SC_(0.3512738536442382533982801612128987500171783187226110529697072136004453295105076465628261914246784663e-4404) }}, 
      {{ SC_(0.00013858181773684918880462646484375), SC_(1.8936798572540283203125), SC_(0.632396042346954345703125), SC_(0.3494582932926073207268927514383887298030614732620636673718458010010860878919915968471379227812002172e-1436), SC_(0.2511767757063189074291668753082248028396011144842069611283346462421254885712421694124857786158458864e-3136) }}, 
      {{ SC_(0.000142661112477071583271026611328125), SC_(0.00029941767570562660694122314453125), SC_(0.12707412242889404296875), SC_(BOOST_MATH_SMALL_CONSTANT(0.9230347843647304902714845809226768084901559433590593943965868424691608898561307461463570335248331203e-5094)), SC_(1.0) }}, 
      {{ SC_(0.000144481091410852968692779541015625), SC_(0.16514885425567626953125), SC_(0.9688708782196044921875), SC_(0.2916808172152941371561907589392678444012691922523666932103740595982202193954671841759133631431519818e-92), SC_(BOOST_MATH_SMALL_CONSTANT(0.1767399381652639845722463679609700453372075076129773918407690123301707895227643938760353681085508816e-10426)) }}, 
      {{ SC_(0.000149327577673830091953277587890625), SC_(0.02011823840439319610595703125), SC_(0.905801355838775634765625), SC_(0.5707652265814761497948122667290630272105804336492195682579100294355459961672140791071880766429409731e-266), SC_(BOOST_MATH_SMALL_CONSTANT(0.9810863833475235469277958389544517047197068113645329771862609657404337986886753563876834604988200819e-6849)) }}, 
      {{ SC_(0.00015278931823559105396270751953125), SC_(2.961205959320068359375), SC_(0.81474220752716064453125), SC_(0.9686336621146354493433474249776172298665280233601677488791828735847807273311033210501894283315401415e-583), SC_(0.958455450908763408676259709003850505127184835507737618299201518879010869739080299459011514685706909e-4793) }}, 
      {{ SC_(0.0001544274273328483104705810546875), SC_(0.00420844554901123046875), SC_(0.81474220752716064453125), SC_(0.1422532322669166233547198932045080465165903362620672425042182798017888251987764727317957393358226225e-474), SC_(0.6406898334415580088458250645785874360637358207768999598619702089982929269362776370994287852924942151e-4640) }}, 
      {{ SC_(0.000157981921802274882793426513671875), SC_(0.0037211482413113117218017578125), SC_(0.9688708782196044921875), SC_(0.9999999999999999999999999999999566547630376536143214240420427142438210294188898619193763474238270252), SC_(BOOST_MATH_SMALL_CONSTANT(0.1939835336353642181185006651880056927592761406033161022047725735001855667514649920234337582255840696e-9423)) }}, 
      {{ SC_(0.000158215596457011997699737548828125), SC_(0.0021306932903826236724853515625), SC_(0.632396042346954345703125), SC_(0.585489069408415416859094179428755245059026878022058922110086645292918800665344436651745005494150636e-1061), SC_(0.4013779767791508783705177360072859499767304191374351949246605254518780551957188734709557279955995735e-2550) }}, 
      {{ SC_(0.000160951211000792682170867919921875), SC_(0.30127601348794996738433837890625e-4), SC_(0.632396042346954345703125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.00016759600839577615261077880859375), SC_(42.365489959716796875), SC_(0.81474220752716064453125), SC_(0.1618938996260777000048394331001333735828473724696664350638506114369038796698616072232027135104079628e-532), SC_(0.1406269609595736906072036049759311881759571600609412613234989755199146208324476469937305493352160618e-4370) }}, 
      {{ SC_(0.000168283222592435777187347412109375), SC_(195800.984375), SC_(0.905801355838775634765625), SC_(0.1354730836770779887008364134677020378373435913423079679236745608956186958884681592671816839314904849e-260), SC_(BOOST_MATH_SMALL_CONSTANT(0.7218328323442263055653806224369414129100300853748650804831763213770456908980115243842363711809518462e-6102)) }}, 
      {{ SC_(0.000172738815308548510074615478515625), SC_(0.0049294424243271350860595703125), SC_(0.221111953258514404296875), SC_(0.3114416249143174222707773893716090914119393864104215223191725870977046796409159221692930963037429121e-3707), SC_(0.2136540942872556917617205810810670917004987234999099979812297733739508644811512695176969110791906457e-541) }}, 
      {{ SC_(0.000173404449014924466609954833984375), SC_(254.2841949462890625), SC_(0.81474220752716064453125), SC_(0.1623807315528767333124878537842720894843097228461791649763010742074974165066564387287453755136810854e-515), SC_(0.5139903302901960528806296251774297557179593757281392427011217512831331097078087743413793585401593293e-4225) }}, 
      {{ SC_(0.000173563123098574578762054443359375), SC_(0.03019084036350250244140625), SC_(0.913384497165679931640625), SC_(0.4216616538689840580493202765005811219382538532665045593477628254798611397253732194894520035245541872e-212), SC_(BOOST_MATH_SMALL_CONSTANT(0.1519028677028408286426022642796355796371834777163384985260835697794432897435003268723798008701690198e-6106)) }}, 
      {{ SC_(0.000175581997609697282314300537109375), SC_(424.74957275390625), SC_(0.3082362115383148193359375), SC_(0.1374073145508158420949504228513669911289818766266752735396725961060062755831664433604536360630772639e-2913), SC_(0.4230605089159464618195269490875633033407067783316713382196399536598739632732026878413067460684943756e-914) }}, 
      {{ SC_(0.0001779057201929390430450439453125), SC_(276489.40625), SC_(0.81474220752716064453125), SC_(0.1433385239986982143091039354417074327444856302734237844209496604209186944824552623394484592702388461e-505), SC_(0.3254393884580671998800374872762169570117335009930005460956811676181892273519631542186785950401027696e-4121) }}, 
      {{ SC_(0.0001830969122238457202911376953125), SC_(316055.1875), SC_(0.12707412242889404296875), SC_(0.9511278427600094377135118355732841750467670552479250043093395362716056782940829083897373604472037431e-4899), SC_(0.7803532852087708371120942312492910554457076414343654065648757393181828534760153291925458722946512398e-328) }}, 
      {{ SC_(0.00019036870799027383327484130859375), SC_(159131.59375), SC_(0.8350250720977783203125), SC_(0.1729789634740508820735073120973928406958737581664893798113469681043431248697180368016298098828197989e-416), SC_(0.4700640179418385223918941195224263508328604356844341580801637757202846411167892041465379417600255792e-4116) }}, 
      {{ SC_(0.00019106571562588214874267578125), SC_(419861.28125), SC_(0.913384497165679931640625), SC_(0.1567576669925923896301071869259641587664399666797404809747965341633674144549694814185182492182916359e-211), SC_(BOOST_MATH_SMALL_CONSTANT(0.5162529790129837326772014329885342018774722215280077618717450046045677991761733763019240992747819678e-5566)) }}, 
      {{ SC_(0.000191590792383067309856414794921875), SC_(0.302199405268765985965728759765625e-4), SC_(0.221111953258514404296875), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.000192195278941653668880462646484375), SC_(177798.15625), SC_(0.3082362115383148193359375), SC_(0.138024604883116058538647719161923179568469814011119713441805481258801805364079413951746607008616879e-2664), SC_(0.6214268115306099755428145349231975501766324330655889187286806651500095053563428570653097584629241138e-838) }}, 
      {{ SC_(0.000193911953829228878021240234375), SC_(32.115245819091796875), SC_(0.12707412242889404296875), SC_(0.7767238465456004634736100276529162725456105769090847581548651993018816232724302032160238139545805979e-4622), SC_(0.7429515026924012391238347914599424230456893918918839669869898430745346529849722172954900298765714898e-306) }}, 
      {{ SC_(0.000195966451428830623626708984375), SC_(0.011618844233453273773193359375), SC_(0.8350250720977783203125), SC_(0.3146681743113886973623184980536034176049753150695447885790326381828535979784588451753885026920781476e-362), SC_(0.4068109297633604648746720510569521504676502764778768905020644717040368472889628052132454063237971075e-3956) }}, 
      {{ SC_(0.000195981003344058990478515625), SC_(0.0429041944444179534912109375), SC_(0.9688708782196044921875), SC_(0.9793461126578410718261695906281390846110182632432004412427194576795091500841705229627568129960234386e-60), SC_(BOOST_MATH_SMALL_CONSTANT(0.2513713796751235907828438441697789705001794518265066530445805548152265415098195397202775734780602226e-7678)) }}, 
      {{ SC_(0.000196676512132398784160614013671875), SC_(2.09101200103759765625), SC_(0.221111953258514404296875), SC_(0.1688684004935734129507194618787128291898404263112373618373185703765353001510076185646943439255116478e-3332), SC_(0.5581449070202207791994774311279788564219242110546247774044809308164393769681046251390741382417455546e-552) }}, 
      {{ SC_(0.000203948162379674613475799560546875), SC_(0.0001180238105007447302341461181640625), SC_(0.913384497165679931640625), SC_(1.0), SC_(0.7356283444570884230046659312487088392816310786287366174624575321932732040301877371734957580169884699e-3072) }}, 
      {{ SC_(0.00020552115165628492832183837890625), SC_(0.00138142076320946216583251953125), SC_(0.3082362115383148193359375), SC_(0.1429827774470379632418986529932925878067109333669332533336600330283131861737532258223510587704633786e-2193), SC_(0.2341877068862295533468430869601473825908234773332820544926420092056706340922633328773460900349255528e-485) }}, 
      {{ SC_(0.000218528322875499725341796875), SC_(215.121978759765625), SC_(0.1355634629726409912109375), SC_(0.1110048779300638146798390845398371246385429120249543548342792575685395517497744173530040172362869178e-3973), SC_(0.8022096643538665096478563944796581809361449139533689574989841323239405907634192771527922293461587945e-292) }}, 
      {{ SC_(0.0002204985357820987701416015625), SC_(107380.34375), SC_(0.1355634629726409912109375), SC_(0.6782041837753225116087366750982618373527264583758523076076086014196503295181969781109502388660601813e-3941), SC_(0.6193269243624208422105498405837256523212873871998352858610888692824299874430423276287869338392370258e-292) }}, 
      {{ SC_(0.000222539805690757930278778076171875), SC_(1432.2476806640625), SC_(0.81474220752716064453125), SC_(0.57005783132530430477178660612185945455201469411533462172661962177087568713696497865918979484150433e-403), SC_(0.1949708209168304244700929849309951337025573564168735921272358803506030706483920425247229543064894803e-3293) }}, 
      {{ SC_(0.000235087776673026382923126220703125), SC_(0.4550904333591461181640625), SC_(0.8350250720977783203125), SC_(0.4335349358585309381220181032114180746424093884422363206625486753112428399145977278964571410459447343e-332), SC_(0.650389236813766580597130012181305372203654735469315289707580896892498824640523282251757810144696338e-3328) }}, 
      {{ SC_(0.0002402908285148441791534423828125), SC_(49604.3984375), SC_(0.632396042346954345703125), SC_(0.7008040408929262235053554567227687464078590845635471762102308082913134656553621195767599520904107947e-833), SC_(0.2136735135969628152506263136824164963628961958196644184395709518512486579889049679404568483195700527e-1813) }}, 
      {{ SC_(0.000240380948525853455066680908203125), SC_(0.01798204891383647918701171875), SC_(0.221111953258514404296875), SC_(0.3342925463661810138117494511975629478239221152831799067641746784135917412668198052255609430627433737e-2702), SC_(0.3222196611766978181003356852573311778433944679181550734121443153023787300466516219418494602474315428e-427) }}, 
      {{ SC_(0.000241263434872962534427642822265625), SC_(12.126102447509765625), SC_(0.1355634629726409912109375), SC_(0.3531864134226105186113445040884967127732118481204280425244188718161546045615341370437272139518523856e-3598), SC_(0.2833215142990048384723627809281010909783009686245495386096462142955031280014848980304024933773380429e-263) }}, 
      {{ SC_(0.000247393851168453693389892578125), SC_(237.5718994140625), SC_(0.8350250720977783203125), SC_(0.7467758527304301930489712565401450019000732818359293236574052711086051715120317290915040602197067147e-319), SC_(0.1175295452624464467382186914508582066453868530811371083358007313613691947541112927930795321538689169e-3165) }}, 
      {{ SC_(0.00024769871379248797893524169921875), SC_(0.11330743134021759033203125), SC_(0.913384497165679931640625), SC_(0.8057198044616208830119760910157076849241866542779883149391963159894898988241621518833543730869926923e-155), SC_(0.4514395318214618210859394950896479927155638675687542053309365859168556452184857791642978414805273734e-4285) }}, 
      {{ SC_(0.0002514437655918300151824951171875), SC_(15605.75390625), SC_(0.1355634629726409912109375), SC_(0.1146473440389500630327805874308263045677581325180350222083785848704794308122851147951697341494068026e-3455), SC_(0.8743513856830855492899734290662061053243108228232205951055575280437649896310298019048383171343706971e-256) }}, 
      {{ SC_(0.00025589551660232245922088623046875), SC_(1.8412075042724609375), SC_(0.1355634629726409912109375), SC_(0.144764702440988308650494806788512955786110080943559530168493614487641884364690057578375458127802417e-3391), SC_(0.2373686569225434236642860222784830432836890438791463843492870900930642417630451865195735639496103942e-247) }}, 
      {{ SC_(0.00025991306756623089313507080078125), SC_(0.00044235005043447017669677734375), SC_(0.905801355838775634765625), SC_(1.0), SC_(0.1020933634675446432129245915691501904285268997926534185374436375239612656266249424861433627155489832e-3174) }}, 
      {{ SC_(0.00026072320179082453250885009765625), SC_(0.0252933166921138763427734375), SC_(0.632396042346954345703125), SC_(0.5774106906136499007306321848486766627704035275590374197989905359732583981267344953827337578567245077e-746), SC_(0.1221153212552572483556124274480657574097866431021822465743906129424047977110997402380370557851061013e-1649) }}, 
      {{ SC_(0.000261564855463802814483642578125), SC_(2.969768047332763671875), SC_(0.3082362115383148193359375), SC_(0.1917257176400386400114840135719818015469831009379409471718670646100779456798733130658135004020055163e-1954), SC_(0.3087647295581909311349470752466052134051176346344512798665157619492425697971635652332575362447818522e-612) }}, 
      {{ SC_(0.00026690683444030582904815673828125), SC_(0.4926892220973968505859375), SC_(0.12707412242889404296875), SC_(0.7163470255220061959892697761424551497832999779611393880732590164502424545866100604093527599253026298e-3356), SC_(0.303403321416841421491577998091602161311391778650138396443569143991396032274291169527827724536822046e-220) }}, 
      {{ SC_(0.000272565521299839019775390625), SC_(0.00399976409971714019775390625), SC_(0.12707412242889404296875), SC_(0.9205902969793391804289346438471724242443629260459170090697657561946770872247762543814516427553130581e-3182), SC_(0.3109865592710128973394498068097974142642216304306839600982877100239631214973288312317517622281276627e-111) }}, 
      {{ SC_(0.00027427947497926652431488037109375), SC_(289206.03125), SC_(0.9688708782196044921875), SC_(0.1639984034231756044229208583485966873535409439402821030525820001328658712135114090265218902644737584e-55), SC_(BOOST_MATH_SMALL_CONSTANT(0.3167971869880607999140021341487256982349274342231617849188200189421432360201900646993311294871619521e-5499)) }}, 
      {{ SC_(0.00027434344519861042499542236328125), SC_(2954.470947265625), SC_(0.3082362115383148193359375), SC_(0.1683233662674550433059541940673828771613870356265333292320684177950173516769252320642278291684226255e-1866), SC_(0.8216683369359972739531898111268752641450064211916381378045844365485522213413495802691798010671314424e-587) }}, 
      {{ SC_(0.0002770713181234896183013916015625), SC_(0.341692575602792203426361083984375e-4), SC_(0.9688708782196044921875), SC_(1.0), SC_(0.2721068366073813159984513012097720958528607157423265246716102639988508670094701055419666722351122037e-1975) }}, 
      {{ SC_(0.00027871350175701081752777099609375), SC_(4023.159423828125), SC_(0.632396042346954345703125), SC_(0.1291574753786667856129649195734480237580233476870127877698655245849801008629156532133192522949873216e-717), SC_(0.5840888368926630355728100612047316287689787084030763199998369840346014463888646072768489097278115931e-1563) }}, 
      {{ SC_(0.00028021665639244019985198974609375), SC_(0.38819736801087856292724609375e-4), SC_(0.12707412242889404296875), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999988604475158829819376999429596962), SC_(1.0) }}, 
      {{ SC_(0.0002803694806061685085296630859375), SC_(25.140018463134765625), SC_(0.9688708782196044921875), SC_(0.23552480440775539686430622396015067919780844087251368603606276838177295310310060990303562813841002e-50), SC_(BOOST_MATH_SMALL_CONSTANT(0.7995317643685616882578245050132329577447427558080918571872226097378941366069272208478020422926746699e-5376)) }}, 
      {{ SC_(0.0002883693086914718151092529296875), SC_(460073.28125), SC_(0.221111953258514404296875), SC_(0.2233396334407501063829398750137152674191646314810442525057378806386961277867880125954762433466669083e-2278), SC_(0.5577026830875732789213978609737026549387438908077397276340226474934141615055513094301940786850847488e-382) }}, 
      {{ SC_(0.00029471665038727223873138427734375), SC_(4642.259765625), SC_(0.221111953258514404296875), SC_(0.1964659986388620197949494436175138648990492072207094050745694462963416098007902395754209859034594654e-2227), SC_(0.7044089528885514023477501142531362477457204611307255297966202787746705705009966437731031365498302993e-372) }}, 
      {{ SC_(0.00029570105834864079952239990234375), SC_(0.3176224529743194580078125), SC_(0.81474220752716064453125), SC_(0.1860550124115277473494932781255212307204352935158359449028966694978708068397626706181905362647786932e-299), SC_(0.8953514270365841014322122635578319704715759052931331999014308297370740627613581765401103299082390701e-2475) }}, 
      {{ SC_(0.00029634564998559653759002685546875), SC_(0.19913904368877410888671875), SC_(0.632396042346954345703125), SC_(0.3197442029315312498712108245040093836159858776170946407071318462758591227686623736638502729118395128e-669), SC_(0.2864019299440505921197929128516171341714937141868930999923509260060292173867562602705635882811163529e-1464) }}, 
      {{ SC_(0.000303403474390506744384765625), SC_(2574.359375), SC_(0.8350250720977783203125), SC_(0.1840994253117250404805270607533887786632543289491523928148833468575841012798514684383612820611090692e-261), SC_(0.9872824860359492914166421780659541457135668770815119787692868189959520451348040383967872982692573163e-2583) }}, 
      {{ SC_(0.00030430863262154161930084228515625), SC_(4480.7470703125), SC_(0.905801355838775634765625), SC_(0.7989987554696839500514255411817667870611101697452949971475759879131344658215182377881990869415295713e-145), SC_(0.4653861011737469972581995931170302920614056467101385434957021898680109188966151056565374338629368917e-3375) }}, 
      {{ SC_(0.00030529979267157614231109619140625), SC_(0.01552005298435688018798828125), SC_(0.3082362115383148193359375), SC_(0.3584606429312655286690623662604306912951571449557885090347260432313337425472180112472160415519266155e-1646), SC_(0.306889407573192367982236699554140219590070599349393754514778733142111937925075703379086747451344186e-496) }}, 
      {{ SC_(0.00031313023646362125873565673828125), SC_(47957.0), SC_(0.3082362115383148193359375), SC_(0.6140467706083764734372135138377788724715450080825880868308108933067381056719150411174124070692627619e-1637), SC_(0.921284229323018599516905638825792787640889235297578211847748428274555272492297710369822293362663559e-516) }}, 
      {{ SC_(0.0003153369762003421783447265625), SC_(0.3186367757734842598438262939453125e-4), SC_(0.8350250720977783203125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.00031880356254987418651580810546875), SC_(387.38800048828125), SC_(0.12707412242889404296875), SC_(0.6806092213825624619059166962408870125659671706641577660035758374479363769205270046142419337689925199e-2813), SC_(0.1056613597655947279365524578962464014648880677807822247384977889481692322766476618718929426800897752e-187) }}, 
      {{ SC_(0.00031994408345781266689300537109375), SC_(0.001032375730574131011962890625), SC_(0.913384497165679931640625), SC_(1.0), SC_(0.7071017389283724848719234541455596441560699878086570131316193543123221660206945210464227104527457353e-2954) }}, 
      {{ SC_(0.00032006253604777157306671142578125), SC_(25544.60546875), SC_(0.905801355838775634765625), SC_(0.1248524509939406619596579531567627736258816407922955932512306168669861660695078961447792570278172773e-138), SC_(0.7212922995306375163192014889673288264391347567709589000969171380978292146911280122107793982675924702e-3210) }}, 
      {{ SC_(0.00033008345053531229496002197265625), SC_(4.030014514923095703125), SC_(0.913384497165679931640625), SC_(0.9975734560448468759612529128778237023224720265347600686528362953187318243265193740327710521926032536e-120), SC_(0.404526846609125045972658746510076149900605931107922656236043210827094920682796574738334879534014374e-3219) }}, 
      {{ SC_(0.00033188183442689478397369384765625), SC_(0.00350953754968941211700439453125), SC_(0.905801355838775634765625), SC_(0.5929422636197086077383456324233458183501129651519330355220259349760162240791889553954020855005798575e-11), SC_(0.8140457316736875576750652687443942190840577087450292599227936393072764836431179758206291852769523164e-2973) }}, 
      {{ SC_(0.00033481788705103099346160888671875), SC_(29065.5234375), SC_(0.9688708782196044921875), SC_(0.1846977919985391564952085508451195643220780086125410057224640319193074200803916612250673647805555597e-45), SC_(0.6763605950304196663024302270101499833327718979457806556597688261088430946341633164345438666291301375e-4505) }}, 
      {{ SC_(0.0003488220390863716602325439453125), SC_(0.02754667215049266815185546875), SC_(0.1355634629726409912109375), SC_(0.4803694959230362583861894599978585796781069351046673463471737782131751378039127886204508226680190055e-2472), SC_(0.1881645676206451221040555438895553361092799476658774551188871013525073673934531439221546279606645061e-165) }}, 
      {{ SC_(0.0003489900263957679271697998046875), SC_(41187.57421875), SC_(0.913384497165679931640625), SC_(0.2461287697594131036065526087031153526234119600360384291520933425868737012901277518270232084149652514e-117), SC_(0.8111329371534791775992847055300188369788393120543005567768130580733055137814280681581784408696956762e-3049) }}, 
      {{ SC_(0.0003502474282868206501007080078125), SC_(426.3076171875), SC_(0.905801355838775634765625), SC_(0.2779720876155144462226231822940338507029368188543079151109606163001676444543878012792912680119371577e-125), SC_(0.776281368475623007435924109522872763134641640702058648718943711099427857580529762384959142839004158e-2932) }}, 
      {{ SC_(0.0003577272291295230388641357421875), SC_(31752.21875), SC_(0.12707412242889404296875), SC_(0.5077481398220846169175873934098900060512122438035380364572926573556066996724374493264842300516515964e-2509), SC_(0.1795886622442780998993947658818667972685924928002620912560386356541581143519610392732103090809615381e-169) }}, 
      {{ SC_(0.00035909839789383113384246826171875), SC_(29.733074188232421875), SC_(0.913384497165679931640625), SC_(0.5172264183529136310816571658039709243363530167047491888758863921928978796296621667293682364579420138e-111), SC_(0.5633817993921249439488596686467497268571432769272195151617154434263338356468124515692430056590179221e-2960) }}, 
      {{ SC_(0.00035964619019068777561187744140625), SC_(20.331836700439453125), SC_(0.8350250720977783203125), SC_(0.5454020657516541752348926685111938100732030876604546779342791098793184139000285970382287935843595917e-219), SC_(0.2981513836075845871948585585900276715676949251519001622248417950277237254860152962355013294488298071e-2177) }}, 
      {{ SC_(0.00037471018731594085693359375), SC_(225.0031890869140625), SC_(0.632396042346954345703125), SC_(0.1959542074778042391457876920330541213801701770194694889936035142281974986320597938367660120674888976e-533), SC_(0.327824602633298506721332171507214246186231587684284682261203129977555286240686742378503132889096959e-1162) }}, 
      {{ SC_(0.0003926889621652662754058837890625), SC_(15.1938610076904296875), SC_(0.905801355838775634765625), SC_(0.1461372845271456162519492439784973745545637564674606848929018405041858236145166742338398319168692688e-110), SC_(0.8731056692346343710111531290721334091337998125020982916199858057459285124439648668923639126644139581e-2614) }}, 
      {{ SC_(0.0003978771273978054523468017578125), SC_(349.374237060546875), SC_(0.221111953258514404296875), SC_(0.9892213699474129847599810511050238830534088090963943091146782194667881168559896169671976068895693428e-1650), SC_(0.2797704543040406255932742694397766330962019064324697976678159154686827041790643099320823651025905441e-275) }}, 
      {{ SC_(0.0004099641810171306133270263671875), SC_(0.000490800826810300350189208984375), SC_(0.3082362115383148193359375), SC_(0.3218160183296792937046838756294220441968176150112890387727391031327850409376873427241690843145224799e-603), SC_(1.0) }}, 
      {{ SC_(0.00041028507985174655914306640625), SC_(2214.455810546875), SC_(0.1355634629726409912109375), SC_(0.1411999325669205965808790828551894850281098531738568598765881048916429345556342640556261373274044656e-2118), SC_(0.1592353273872976761249208714392391941822297390951273353638547435682169502626694415955289715845953966e-157) }}, 
      {{ SC_(0.0004120909725315868854522705078125), SC_(367.71405029296875), SC_(0.913384497165679931640625), SC_(0.5066933695521165176246523418071433957789857410769463562299570835647419512776726729210386677920997613e-98), SC_(0.1265970668797066435909007516523614130256666881000883260285413494011577443739674733192626358994408172e-2580) }}, 
      {{ SC_(0.00041210078052245080471038818359375), SC_(4.50945568084716796875), SC_(0.12707412242889404296875), SC_(0.1143960690535664250199860688726034012818174427865106800075523466764120531930011004598235789281682917e-2174), SC_(0.8345714108783484613695124908697811332193562702185916938670713435775303588214630436179835174257118356e-144) }}, 
      {{ SC_(0.00041793254786171019077301025390625), SC_(4668.47119140625), SC_(0.9688708782196044921875), SC_(0.1653269200479391627166453551451738992737497944313621698423560899994975621869369680458774970524358841e-36), SC_(0.4311041278163289726906716832984629926603491374575744907712225153743261254178894691245072594246653796e-3609) }}, 
      {{ SC_(0.000420027412474155426025390625), SC_(0.00036404779530130326747894287109375), SC_(0.9688708782196044921875), SC_(1.0), SC_(0.6544615268131893919716121151356027751896321910064426397522686169239852446274885797486469023450925966e-2794) }}, 
      {{ SC_(0.0004246321623213589191436767578125), SC_(17994.9140625), SC_(0.221111953258514404296875), SC_(0.1173832139213001016251231231498948821097068328774066553984995344586910438973319916034085479159778975e-1547), SC_(0.8323067186972441939225305044242012601658547116611162739805085661806078937444323648917138209234065968e-260) }}, 
      {{ SC_(0.00042692126589827239513397216796875), SC_(0.00024527459754608571529388427734375), SC_(0.632396042346954345703125), SC_(1.0), SC_(0.9999999745959413895422111611949978869110038927861511474365399998879884112988183104729392965896256825) }}, 
      {{ SC_(0.00042705106898210942745208740234375), SC_(2443.44287109375), SC_(0.913384497165679931640625), SC_(0.1684711453888413330180850480037749119191474189413222767926727603039642175762060143901160637948074481e-95), SC_(0.3914312069341425939799926652190186575518134867666977172976349625714896660256339724245245192049770776e-2491) }}, 
      {{ SC_(0.00042847762233577668666839599609375), SC_(22.90042877197265625), SC_(0.221111953258514404296875), SC_(0.67023835199603324035761977810576965514302257630983893399806168639614487075400273353527551989353986e-1531), SC_(0.1314702541432437672068577431852839495550335436186981264394870671747558289962630622146874262986783195e-254) }}, 
      {{ SC_(0.000430326792411506175994873046875), SC_(0.2849896918633021414279937744140625e-4), SC_(0.81474220752716064453125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.0004377235309220850467681884765625), SC_(454399.25), SC_(0.632396042346954345703125), SC_(0.2769317620368822406199630588725818387168895814972176990677612122217592741019585088966640945440495692e-460), SC_(0.1522676168730449323844882289007411395872182442478302256254177394851751556385766463462654899466666561e-998) }}, 
      {{ SC_(0.00044121246901340782642364501953125), SC_(0.031357325613498687744140625), SC_(0.12707412242889404296875), SC_(0.123953600051413911633401443135954055320585692725164007863409730605945760646384143668640273075473359e-2016), SC_(0.907220612639681471777217716352391243096414172127754922082989948849290430563197738167889573247151462e-120) }}, 
      {{ SC_(0.00044747791253030300140380859375), SC_(0.0003718078951351344585418701171875), SC_(0.81474220752716064453125), SC_(1.0), SC_(0.2783919010271951263778427406625842257025600371017910450175329489693649455022186772573538941734252615e-869) }}, 
      {{ SC_(0.000447716913186013698577880859375), SC_(0.00131022813729941844940185546875), SC_(0.8350250720977783203125), SC_(1.0), SC_(0.1554247596578328267770832121177776366935407241213750773111958052465777348508556145921269246367713627e-1462) }}, 
      {{ SC_(0.00045037711970508098602294921875), SC_(10660.8232421875), SC_(0.8350250720977783203125), SC_(0.7350737011457328778141747392073420751277644591269799245372468654051814693882793211166664863257880665e-178), SC_(0.1278433077734755966069798863603373854412033925325624066178732476370630333223722357933125776567949343e-1741) }}, 
      {{ SC_(0.000460021547041833400726318359375), SC_(0.2375358045101165771484375), SC_(0.905801355838775634765625), SC_(0.1901142495450547594736586672871446104883440608646089068645600325638994404376461244433410127934241496e-91), SC_(0.2805357565586276158855672314277788879077231320930272684963493398503973829330985881953286423835647166e-2228) }}, 
      {{ SC_(0.0004610864561982452869415283203125), SC_(0.2207309305667877197265625), SC_(0.221111953258514404296875), SC_(0.2692746917823974161515540005735972374815811731709126571639817167375377980485319144999252518681023766e-1419), SC_(0.2891796277655326002820228963978878622140636115972850622279110455835805504674205818053942429352702893e-233) }}, 
      {{ SC_(0.000464259064756333827972412109375), SC_(0.001531984074972569942474365234375), SC_(0.1355634629726409912109375), SC_(0.1901150060646678783370103795638980771427259917858810768078635816368255955970486367270040692709334892e-1621), SC_(1.0) }}, 
      {{ SC_(0.00046533494605682790279388427734375), SC_(0.3233075040043331682682037353515625e-4), SC_(0.3082362115383148193359375), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.000471754348836839199066162109375), SC_(2833.98779296875), SC_(0.12707412242889404296875), SC_(0.1332528719628748324149547941284096536271782949432045977983225537277282460861998849234047366091903546e-1902), SC_(0.1527924805657772456192431978212328705530084850003875978617361526677450735331119344343526583262464365e-128) }}, 
      {{ SC_(0.00047560062375850975513458251953125), SC_(19603.037109375), SC_(0.81474220752716064453125), SC_(0.2332827848019860377648462088562419445481904489469447291819318470398289925984817033338680075574667059e-191), SC_(0.7598637852153304708949850110408647807945863916443746925760321731093168705180978836087085594599710956e-1544) }}, 
      {{ SC_(0.0004768202197737991809844970703125), SC_(4.81977367401123046875), SC_(0.8350250720977783203125), SC_(0.7928522360097904375503171186580037210765485268367668964262723503298265005809246636636895526749251047e-165), SC_(0.7264814757267783217858734080239603609122008213001691122705230310251402689644149181465822231621526509e-1642) }}, 
      {{ SC_(0.00047791490214876830577850341796875), SC_(0.11917771399021148681640625), SC_(0.3082362115383148193359375), SC_(0.1221644439201177607039129248484271636993511893818937066510413514224230075376065956705326374452092366e-1065), SC_(0.4814009189282120124091290932584271319832655834371296538987404931173996568092311321257649037130883527e-331) }}, 
      {{ SC_(0.00048245381913147866725921630859375), SC_(3.6078746318817138671875), SC_(0.905801355838775634765625), SC_(0.1569573896221283300377645047167634242613687648522114673857804152118487804858306469302280850090520061e-89), SC_(0.5239509151041740103941049627147338321452752464794567892965369644455829457133639138224838124569889054e-2127) }}, 
      {{ SC_(0.00048475922085344791412353515625), SC_(0.0004919702769257128238677978515625), SC_(0.1355634629726409912109375), SC_(0.1297110620966190341863656648298430703032466060473899612769567635534733525340325973010326129668658037e-1175), SC_(1.0) }}, 
      {{ SC_(0.0004984539118595421314239501953125), SC_(0.27903375666937790811061859130859375e-4), SC_(0.905801355838775634765625), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.001114696613512933254241943359375), SC_(338.423187255859375), SC_(0.3082362115383148193359375), SC_(0.4963961026896803775804912348578249813706254358877191480524847828619124016799773085733593342992757499e-461), SC_(0.4428411647922142529576567209626885070998368972735715198836871903362632366824858239771306101140524469e-146) }}, 
      {{ SC_(0.00111688114702701568603515625), SC_(0.00206368253566324710845947265625), SC_(0.3082362115383148193359375), SC_(0.3731723266139428024302501079519295275900812437400758900334729231531872282134743369520722110283032042e-289), SC_(0.9999999999999999999999999996342384417872123916449259117690284035540024806964107976459219807050596692) }}, 
      {{ SC_(0.001122163725085556507110595703125), SC_(26.959133148193359375), SC_(0.12707412242889404296875), SC_(0.8328123863471218466764890606231881035415169500301245573427945687895534854373969897355432705057567363e-800), SC_(0.536960443521505632976179498595789046546079604037849388379037538521469167318762161312508982064599698e-54) }}, 
      {{ SC_(0.001150955446064472198486328125), SC_(0.4535874426364898681640625), SC_(0.12707412242889404296875), SC_(0.1884112751899531653353470394519634991110935884043691779105341925780485099073714347071458235118859373e-777), SC_(0.2677381828522148817096542550712851867675349614243582721868591874769540658898781673134665126974544976e-50) }}, 
      {{ SC_(0.00116972462274134159088134765625), SC_(4487.220703125), SC_(0.221111953258514404296875), SC_(0.6389086690605448247119453067369179386125416082108018876855352827978538584073354498658616465783284593e-564), SC_(0.2087339976113587967803954519246503785894251093939555753813431905242316206311014237844503107330224531e-96) }}, 
      {{ SC_(0.001238475437276065349578857421875), SC_(4809.8876953125), SC_(0.12707412242889404296875), SC_(0.4401995610661869647630337240790436247938682644912896167402354764604895613270759953023865963657788812e-727), SC_(0.257146039631154090279070058912979039963331502164832408349732557006095142050634339634895097243901494e-51) }}, 
      {{ SC_(0.0012418846599757671356201171875), SC_(211065.625), SC_(0.632396042346954345703125), SC_(0.150065008504587442907249824289035574284643996676551574073125737374305511087152690735468297579283637e-165), SC_(0.2866823017139563731059886116893985826564281919099433587103127212791629526607921556910936160936122832e-355) }}, 
      {{ SC_(0.00128578185103833675384521484375), SC_(4738.4111328125), SC_(0.3082362115383148193359375), SC_(0.3632014941716416097837726688741852597595060153546637296896248271543309090549151478329946524994450863e-401), SC_(0.4013135120598695569914363385293373337397387684720928189179791043914454320928137158700328972838739911e-128) }}, 
      {{ SC_(0.001333879190497100353240966796875), SC_(46277.76171875), SC_(0.913384497165679931640625), SC_(0.3861269427867878694953552464821751215567089565674050992124409445131844156800507304593675886788991902e-34), SC_(0.4047829577952564963360787049919969775591652443646408909391600685422889456664813118608454064356000822e-801) }}, 
      {{ SC_(0.001342063187621533870697021484375), SC_(0.0049741393886506557464599609375), SC_(0.12707412242889404296875), SC_(0.5101849744369723625647512450328136916848697306174957436869107693506179258050863793437177537050564382e-590), SC_(0.9999999999999999999999999999999999999999999986970111370740635209523747559800020432712116123756906164) }}, 
      {{ SC_(0.001386920106597244739532470703125), SC_(2158.757568359375), SC_(0.81474220752716064453125), SC_(0.1816862233465659420155343059846336717454893586240277022184749525581728298901934813060164995101706004e-67), SC_(0.2926837647863689633635010437730818161037241832823974270443891782219433536191348891898931407055604138e-531) }}, 
      {{ SC_(0.00139484903775155544281005859375), SC_(0.406741619110107421875), SC_(0.632396042346954345703125), SC_(0.1457257031604224981663525921028218209824865402177454502765759531993184145728169064941209529703823104e-141), SC_(0.1778039858662402623929403957393814248919911335053848551759317222350645692063732324422915176744668413e-310) }}, 
      {{ SC_(0.001427047536708414554595947265625), SC_(3.0078976154327392578125), SC_(0.12707412242889404296875), SC_(0.3294999423999770892396379482819550311506382248683104363039426872776498106273805461046006734840196967e-628), SC_(0.9719215842832902710532075733912799211607521814967135508129096589059249358430159236837391274037313728e-42) }}, 
      {{ SC_(0.00144447688944637775421142578125), SC_(0.3829285924439318478107452392578125e-4), SC_(0.905801355838775634765625), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.001469670678488910198211669921875), SC_(0.00022998542408458888530731201171875), SC_(0.81474220752716064453125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.001532684080302715301513671875), SC_(13060.16015625), SC_(0.9688708782196044921875), SC_(0.4711065147845850388023965708085548835686712881593262202653772650678489528320493323401559315023176681e-13), SC_(0.3165116417798003226025522674701410404417251799761158239245234784908344575155165366361416144393906069e-987) }}, 
      {{ SC_(0.001546212588436901569366455078125), SC_(0.4388438761234283447265625), SC_(0.913384497165679931640625), SC_(0.1996091026340976123686000097269018330539713196974958168701158739984532340253696643765258238321429449e-24), SC_(0.4426000575444700095009039446887329732424292699353914499479844816837055596050630154989917071772887781e-686) }}, 
      {{ SC_(0.001599461771547794342041015625), SC_(1780.4295654296875), SC_(0.9688708782196044921875), SC_(0.8180629485768102384668274394495349278331847509614769386523316130262382783290236010716298560476306601e-12), SC_(0.2581473049191021943763912596324526248388875982195073832381956213768878638873035207281527817565932389e-945) }}, 
      {{ SC_(0.001671708538196980953216552734375), SC_(485.198974609375), SC_(0.81474220752716064453125), SC_(0.6880011341315721937453661078904168849375124569731909893424561355473220707601440831403247524141059063e-56), SC_(0.1135963177761676946255194772314150641504678346047579000231036208189388189615205618630410340374136488e-440) }}, 
      {{ SC_(0.00169355445541441440582275390625), SC_(385561.5625), SC_(0.12707412242889404296875), SC_(0.1357644728330864490789824678976305163772099394360623876244722957279320763472294258387329915309912041e-534), SC_(0.2053505041582283169934672364999992838613518121457775564079632363481757795793068991443088908539966794e-40) }}, 
      {{ SC_(0.001731689902953803539276123046875), SC_(198.0077056884765625), SC_(0.12707412242889404296875), SC_(0.1184897635019623113755905467611596252446391301338516906810499898085379277304939002383658102663597767e-519), SC_(0.2347013981736398888882040571597309860335372391967607905014093714270788247334158374175037252070966765e-36) }}, 
      {{ SC_(0.00173926516436040401458740234375), SC_(0.333752905135042965412139892578125e-4), SC_(0.3082362115383148193359375), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.0017912392504513263702392578125), SC_(3.0554368495941162109375), SC_(0.9688708782196044921875), SC_(0.4701843995640270906121370034989701299669354541714496690750159004043846640973940704885301368826587965e-8), SC_(0.1305618986995183315696829609716360911015214096550628562258179664901524047564724897268801060603249478e-841) }}, 
      {{ SC_(0.001886987010948359966278076171875), SC_(0.00043248571455478668212890625), SC_(0.632396042346954345703125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.001926377532072365283966064453125), SC_(0.02606286108493804931640625), SC_(0.3082362115383148193359375), SC_(0.5406580046380102131640301770857145036121524819812279409608485271587105115434972991662539854510800795e-249), SC_(0.952132930610571873746115707945816219444814806871632571816788711973324426151777911105097474257863675e-67) }}, 
      {{ SC_(0.001949134399183094501495361328125), SC_(0.0048745614476501941680908203125), SC_(0.913384497165679931640625), SC_(1.0), SC_(0.7586243807725404042115823297048566847731005920245323387172990603811457373280862279498121973921178672e-470) }}, 
      {{ SC_(0.00195972807705402374267578125), SC_(233.2021026611328125), SC_(0.1355634629726409912109375), SC_(0.3446803528786989990219228812733230961882818325290924153111411079767043454658898139015238586738265495e-445), SC_(0.125809480222484732231087097071642553682078060449037442681423129657743058680079170711455722887816694e-34) }}, 
      {{ SC_(0.00203225878067314624786376953125), SC_(0.16493140719830989837646484375e-4), SC_(0.913384497165679931640625), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.00204748497344553470611572265625), SC_(0.23111911118030548095703125), SC_(0.81474220752716064453125), SC_(0.1866120253975158452196385346003687614854599456749753562595327991766529810036023996411443099746602595e-41), SC_(0.1282571993505349007609177480653695416984643937465465263078861285009075093190583536646702602781192856e-355) }}, 
      {{ SC_(0.00204884703271090984344482421875), SC_(0.0001168216476798988878726959228515625), SC_(0.1355634629726409912109375), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.0020499289967119693756103515625), SC_(0.00172629184089601039886474609375), SC_(0.1355634629726409912109375), SC_(0.2956233304559164347164896800185500753824608149620816533876297045088592336257572036169103413674439671e-257), SC_(1.0) }}, 
      {{ SC_(0.002186703495681285858154296875), SC_(0.0003623119555413722991943359375), SC_(0.8350250720977783203125), SC_(1.0), SC_(0.9999999999999999999999999999999954670685166314550494979207598775578417075148260249925377811395434216) }}, 
      {{ SC_(0.0022444091737270355224609375), SC_(0.1359292582492344081401824951171875e-4), SC_(0.12707412242889404296875), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.0022751130163669586181640625), SC_(0.00026807599351741373538970947265625), SC_(0.905801355838775634765625), SC_(1.0), SC_(0.3428482131331867258515389607787665103868888149481879465217278147319094564347041967603807065074845189e-21) }}, 
      {{ SC_(0.00233665225096046924591064453125), SC_(3.87988376617431640625), SC_(0.905801355838775634765625), SC_(0.6780362544309342304173716622518249237181041045434268075383298843383663030653228498316310064334534537e-19), SC_(0.1409036990351353603797011229152082183390222015220657787879784433068578378242776405117104022008759848e-439) }}, 
      {{ SC_(0.0023414273746311664581298828125), SC_(0.15162646770477294921875), SC_(0.8350250720977783203125), SC_(0.2010977133020093058897157714132466272232864696686180402319685385467594041760309896890522829839873531e-30), SC_(0.3249806441488893624816289516575606552785819201931814314936889669423502092086628733236841474531822932e-331) }}, 
      {{ SC_(0.00246974662877619266510009765625), SC_(0.016062967479228973388671875), SC_(0.913384497165679931640625), SC_(0.9999999999977651700409956690618497960817604205407645049691009442302480963790628969802821103328181306), SC_(0.9353372589230160596226574243795389958572033207316425972274497132429916236526182394850397892557523125e-405) }}, 
      {{ SC_(0.002563751302659511566162109375), SC_(346881.96875), SC_(0.1355634629726409912109375), SC_(0.5003960670170566131644722883866939687456782826706056888829746462818410665033363837206731671613155767e-344), SC_(0.3408679092300370474161109611285835642746367258253067106004290272644385115717942673912861423632215709e-30) }}, 
      {{ SC_(0.00258206087164580821990966796875), SC_(0.035458743572235107421875), SC_(0.905801355838775634765625), SC_(0.143622480612315952754644931389386278706415966727515052204717844005266047872767231469239298470505629e-4), SC_(0.2871464268203497590195825674770300558805974434291889133281028257872131828462321137969085454743093499e-385) }}, 
      {{ SC_(0.002597031183540821075439453125), SC_(443239.6875), SC_(0.81474220752716064453125), SC_(0.6942092347831083617285544219665777044691714225398929758117560336078228198628598858753278302578519522e-40), SC_(0.1436271744818629605869886210042467600469838818937698616140996345037017420231564825517453306189884096e-287) }}, 
      {{ SC_(0.00263487943448126316070556640625), SC_(0.153494547703303396701812744140625e-4), SC_(0.9688708782196044921875), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.00266719772480428218841552734375), SC_(346911.65625), SC_(0.905801355838775634765625), SC_(0.1260730238795489561138508283755776484269070983353784256410839887865847117281729154225183355605199679e-21), SC_(0.3576014021571111010934151525005149843936941986114814524397008393585894144808156223522149353014186649e-390) }}, 
      {{ SC_(0.00269666709937155246734619140625), SC_(0.000412763678468763828277587890625), SC_(0.913384497165679931640625), SC_(1.0), SC_(0.173348256594487599703092302385923976662594797698830094427805600882101939816744692282237400110829634e-68) }}, 
      {{ SC_(0.0027208295650780200958251953125), SC_(0.35322547773830592632293701171875e-4), SC_(0.221111953258514404296875), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.00272956606931984424591064453125), SC_(19772.78515625), SC_(0.8350250720977783203125), SC_(0.5863804516560304245741858773989103882781643265205511881179080803501510871065944578091414027546176614e-33), SC_(0.5604941162524537340659663839770563517419447622525305350925406775316567579902692412949602191075159081e-291) }}, 
      {{ SC_(0.00275547988712787628173828125), SC_(0.3721626490005291998386383056640625e-4), SC_(0.8350250720977783203125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.0028151907026767730712890625), SC_(27477.31640625), SC_(0.81474220752716064453125), SC_(0.5062181243865998137377395966222034140804656840060229403819882297612468021950235338593043155315545217e-36), SC_(0.1637008788043418297880665846729367695126612589341378894332192261176590005363933078725653287646841425e-264) }}, 
      {{ SC_(0.0028353952802717685699462890625), SC_(0.00185509095899760723114013671875), SC_(0.9688708782196044921875), SC_(1.0), SC_(0.4383941724974990952548765226186703315111360028760806564805656221770516794584814150418451843548925219e-389) }}, 
      {{ SC_(0.00288435374386608600616455078125), SC_(227.292877197265625), SC_(0.9688708782196044921875), SC_(0.4296681737246112185277247815054324892277031087762242784610226270686355003185546313967204197090833286e-7), SC_(0.9517251221303759156882164693317119448361477183418708643850432488357008638883192098963344158034343615e-525) }}, 
      {{ SC_(0.00291968858800828456878662109375), SC_(26.0607814788818359375), SC_(0.3082362115383148193359375), SC_(0.1924068424127740185555474123917374597190110649821002708143209027137327269789461141465167038457318581e-176), SC_(0.3372275780201584442826669821360849803603556515206481084696861282294622365497111291169906840850481736e-56) }}, 
      {{ SC_(0.00295443576760590076446533203125), SC_(0.002377311699092388153076171875), SC_(0.8350250720977783203125), SC_(1.0), SC_(0.700907724368058324525690048754858471439299289338280881803638384472216546657379137694334250922223981e-146) }}, 
      {{ SC_(0.00295559107325971126556396484375), SC_(0.0265316255390644073486328125), SC_(0.632396042346954345703125), SC_(0.1470499541968122086681373911972951068149378764710274396944658495178129010382275574015706845704383259e-51), SC_(0.2825555789544362991085166208398507728416019237885463467013082013340253718116518767922500347664067344e-131) }}, 
      {{ SC_(0.0029596057720482349395751953125), SC_(224.0623931884765625), SC_(0.632396042346954345703125), SC_(0.1440850342062154776859256736413078504748320470057325480436343926345028644442763241301647057593117571e-69), SC_(0.3551345595661543425427345320319242778131094254688046815915051724159171141780619835119258810932575214e-149) }}, 
      {{ SC_(0.00297669577412307262420654296875), SC_(1.050155162811279296875), SC_(0.221111953258514404296875), SC_(0.62027825090616647238240792845206041542761363974347071096437887794133279745980711656372280914035385e-220), SC_(0.3215897972601044866808086583377747006181420149537483820256820579415768988283055448609885032793966119e-36) }}, 
      {{ SC_(0.00300008966587483882904052734375), SC_(20.15772247314453125), SC_(0.221111953258514404296875), SC_(0.1001640106304162174564251079966166973069278815691966992511904094781829610422854212504793158859579374e-219), SC_(0.1918092322445028170891274807358733173119099336726461440340899953913051874286311108292385663325664168e-37) }}, 
      {{ SC_(0.00300188665278255939483642578125), SC_(229.01318359375), SC_(0.913384497165679931640625), SC_(0.1924256340617578492847187808675044621006843667411926528907838052528282300714519774121062193131953392e-15), SC_(0.3014774240903195554803009279365969795836624442724980477113226934665451413904050431971004407954578301e-356) }}, 
      {{ SC_(0.0030314330942928791046142578125), SC_(0.00014527700841426849365234375), SC_(0.9688708782196044921875), SC_(1.0), SC_(0.7818856020782235525559459407094684662821120388362084228368871196006327664519134685015016387016892397e-55) }}, 
      {{ SC_(0.00307437963783740997314453125), SC_(47442.203125), SC_(0.1355634629726409912109375), SC_(0.6127367051414342546306950698252506314933033967730905762181214476561033454994329284989763494561004771e-287), SC_(0.3129725265026077259950731489130996305028480814699618611756501719114922372391088754935928735018582111e-25) }}, 
      {{ SC_(0.003084543161094188690185546875), SC_(0.01759622059762477874755859375), SC_(0.221111953258514404296875), SC_(0.1795973463545674211531283634758630712040643731212358617943942775838746506528118263759004008991657051e-189), SC_(0.3512763044349039036775776522122718294634820640327104903300374983177457223199706028030207313774504709e-12) }}, 
      {{ SC_(0.00308659928850829601287841796875), SC_(3668.456298828125), SC_(0.632396042346954345703125), SC_(0.5131306025378273441356168314532611897734425524780138728934091986037266763252437314939563869962987609e-68), SC_(0.238431430293535094632193142053110352335338683123702842662512130531320667630162982589689002514567079e-144) }}, 
      {{ SC_(0.0031075035221874713897705078125), SC_(463574.59375), SC_(0.8350250720977783203125), SC_(0.7710392142754315313162068368826538979888632937258553455529661195921381727998285112908441898926510603e-31), SC_(0.1770318836797326850837052731489350350524494197239493075478442385156690317386156501048817829306432552e-257) }}, 
      {{ SC_(0.0031872228719294071197509765625), SC_(0.0190620534121990203857421875), SC_(0.1355634629726409912109375), SC_(0.577115962017126052001570284280954430349927397473554118254493632335154868387260086347371920956809803e-251), SC_(0.9477208271424566790545016992938743452477089993063218666345536030432891365671025916891280192700392815) }}, 
      {{ SC_(0.00330688594840466976165771484375), SC_(30.580783843994140625), SC_(0.9688708782196044921875), SC_(0.131522485269661766208492556914239979831950053474420695478330814616068545295864553544623763970897913e-5), SC_(0.4044628925670788801103869316697489861404886320685968119723882353196733207049327386273082787418628555e-457) }}, 
      {{ SC_(0.003314100205898284912109375), SC_(0.00212650909088551998138427734375), SC_(0.905801355838775634765625), SC_(1.0), SC_(0.3388908205490964552983511220312242405352765255550660985434397094317092284680898250036694059331235236e-186) }}, 
      {{ SC_(0.003379584290087223052978515625), SC_(0.0002798224450089037418365478515625), SC_(0.12707412242889404296875), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999999996606980154026), SC_(1.0) }}, 
      {{ SC_(0.00341137242503464221954345703125), SC_(0.00041894565219990909099578857421875), SC_(0.221111953258514404296875), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.003439466468989849090576171875), SC_(47.370025634765625), SC_(0.81474220752716064453125), SC_(0.1619558858388758971158451129363857722604453318134947140402061352735911928284565210549247250916679042e-27), SC_(0.1552152097766748966712126542813990830110876603377490598483294983873478546359277469011971113612588794e-214) }}, 
      {{ SC_(0.00347066554240882396697998046875), SC_(28.90100860595703125), SC_(0.8350250720977783203125), SC_(0.5451541501809570271240309060067988342378145813739340449037621513499420349972727417559509821334021862e-24), SC_(0.6493097789038924292302308051235160895435306469201827428272161035431567696755499905012324675418966527e-227) }}, 
      {{ SC_(0.0034962403587996959686279296875), SC_(0.01680609025061130523681640625), SC_(0.81474220752716064453125), SC_(0.01023475449683925775801269447904094563181803335258415704244024738931844541694585177946920760250821972), SC_(0.1078702430769200730088189298863811809186810299761201132983808719906821349513332866238254254439300782e-185) }}, 
      {{ SC_(0.003511893562972545623779296875), SC_(306009.46875), SC_(0.9688708782196044921875), SC_(0.226010120805150676790568596891217945895347398515604269562495163106758489877856504117944733974648284e-9), SC_(0.1581681388657578128303793715919566617458300988546837058599044395484107733165048668019023697956454298e-434) }}, 
      {{ SC_(0.003595965914428234100341796875), SC_(35727.2421875), SC_(0.3082362115383148193359375), SC_(0.1152314121354237875475671351300016526994202096841630068447221392428392781871482869200570837917385732e-146), SC_(0.4915579944572208525616018955650018153120791747556238586718623527845271899005135245696121631804344411e-49) }}, 
      {{ SC_(0.00361502938903868198394775390625), SC_(1.00639164447784423828125), SC_(0.1355634629726409912109375), SC_(0.8437823746032120722116726863335792964706776109053966789585476453555279311968001851160478379370722187e-240), SC_(0.3121736678319204776889772337819507513618281470059016095224642926822027728813009851078139976949443534e-17) }}, 
      {{ SC_(0.0036274394951760768890380859375), SC_(172327.484375), SC_(0.913384497165679931640625), SC_(0.4649312481727332039816520073900496916179025068719353039401217895367607004704533900433054852250834543e-16), SC_(0.4308131498468428446867651467850468833187556014000914794919454614953351234763533196676859284805644286e-298) }}, 
      {{ SC_(0.00363842095248401165008544921875), SC_(26888.734375), SC_(0.12707412242889404296875), SC_(0.119145386220547808480524616366713156332853811961203620074191450290897638690146586678011837675995321e-250), SC_(0.1256051639548185207680815322415102404102031438620545219662034165104794303091392934920416563962448165e-20) }}, 
      {{ SC_(0.00371654215268790721893310546875), SC_(0.0219620727002620697021484375), SC_(0.8350250720977783203125), SC_(0.001531278059688844425073725000859519313354950257248330294106894156978523044058885036817903086666484126), SC_(0.4859094956992954217828019527843846029699491564858516140256822168030701361210960800627416305926612673e-192) }}, 
      {{ SC_(0.00371891190297901630401611328125), SC_(0.21678431332111358642578125), SC_(0.905801355838775634765625), SC_(0.1989403348490392796904685775348199142204981483884462566869822878376183184621284526563509363689175446e-9), SC_(0.9489393224893896218229284264225474939925281655706600796746451824215551853290686066879759718963161733e-274) }}, 
      {{ SC_(0.00372788752429187297821044921875), SC_(3138.884033203125), SC_(0.1355634629726409912109375), SC_(0.2835078784307424509379511395715332008076185963175281368529214877556697232247824185919702531535221333e-236), SC_(0.1917335959520406081161566526216012567746180947258988940344121835526351456550501923219178225154323289e-20) }}, 
      {{ SC_(0.0037949834950268268585205078125), SC_(1.261780261993408203125), SC_(0.913384497165679931640625), SC_(0.2981269754756097686137559068916992843622873353672699474197772235699061667802581045739773108092736978e-10), SC_(0.7811363028797828131835435452883373589578828526579107095973771392924774048938053256833915587679522989e-280) }}, 
      {{ SC_(0.0038448632694780826568603515625), SC_(0.000167022328241728246212005615234375), SC_(0.3082362115383148193359375), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.00385077786631882190704345703125), SC_(398.761688232421875), SC_(0.905801355838775634765625), SC_(0.9828936112261782415985967453804788743838150619613710665079951432973822455676368890563206921694692795e-14), SC_(0.5277666571839977021788943094765966230883449219079265336177608285921856207934259594413320006891003543e-269) }}, 
      {{ SC_(0.00386014836840331554412841796875), SC_(1.3947961330413818359375), SC_(0.632396042346954345703125), SC_(0.1673319784108391751134807213566363471384314483183410950303884814914240425782895868947247472199800216e-51), SC_(0.1539334688335130872872671702819723220369217486873739608836654184343321871022481400926909069482358193e-112) }}, 
      {{ SC_(0.0038849101401865482330322265625), SC_(0.19230575859546661376953125), SC_(0.9688708782196044921875), SC_(0.03688948256569191248147479469209049373932687781560061299658914003644538190431436772756053031092806142), SC_(0.1766228434077789641249885662567890970164993416377231910418308836906393373468295260087634143150315055e-385) }}, 
      {{ SC_(0.00388975837267935276031494140625), SC_(3818.894775390625), SC_(0.913384497165679931640625), SC_(0.1130965385518089235021717846258252644159534392873432025821598310734261671427587156776023758345760556e-13), SC_(0.1096972566075886889991011825681462791403211072610317760833340637538038030658117691415129144552533749e-276) }}, 
      {{ SC_(0.003921323455870151519775390625), SC_(0.001402953988872468471527099609375), SC_(0.81474220752716064453125), SC_(1.0), SC_(0.9549146687332131394621837831013320445588897234334688006700153143358556851587238270186065756310287923e-39) }}, 
      {{ SC_(0.0039762970991432666778564453125), SC_(37.592052459716796875), SC_(0.1355634629726409912109375), SC_(0.8389716720688828476528458760266573984019911823781115074796311031492107865261799137849724135645517787e-220), SC_(0.1863859454038566611856639540834662658866206746232444028739812434318236212971049660232508914175083752e-17) }}, 
      {{ SC_(0.0041162068955600261688232421875), SC_(2.1463463306427001953125), SC_(0.3082362115383148193359375), SC_(0.2268533853413530014025398831552625548225271006270514902938715439712875944432209632673218463457072557e-124), SC_(0.4430420531872126866006457019895686749306791041207577372324369872478573784879364698921697277853156581e-39) }}, 
      {{ SC_(0.0041847354732453823089599609375), SC_(0.3331385552883148193359375), SC_(0.3082362115383148193359375), SC_(0.9215257753063606623976360918389807691700232795900471642801757502433225391905943806565514746109675049e-121), SC_(0.7219380498141287168951795018454285271671087930436064533715551096737209956194627052643520096495327471e-37) }}, 
      {{ SC_(0.0042013223282992839813232421875), SC_(28909.28515625), SC_(0.632396042346954345703125), SC_(0.8339930219923378464403640281618240270148226285191790531990776782196381361370167305281424357864930571e-52), SC_(0.6941381970990705941667619671027593803237143442584236274598258447879180795551815287189618186136392048e-108) }}, 
      {{ SC_(0.0042040585540235042572021484375), SC_(0.004051725380122661590576171875), SC_(0.221111953258514404296875), SC_(0.4281583185472131681817910428681166037538507437538097241292188083643615059534930331279625093793331541e-82), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999999999962089563349) }}, 
      {{ SC_(0.0042134574614465236663818359375), SC_(258792.734375), SC_(0.3082362115383148193359375), SC_(0.1076922726678175502266304792357998888032471508545474864585903483926665221223951252441637405234484482e-126), SC_(0.226096877346560869025837193899017879217587177157410066182445188361468939241838950022712580276422069e-43) }}, 
      {{ SC_(0.0042219576425850391387939453125), SC_(29.536075592041015625), SC_(0.913384497165679931640625), SC_(0.9297641096499359263244836840971327898602814987469309791581124278795476295520155367620472889418274595e-11), SC_(0.4466594212285694786832164822616296747722104585086540583619362853899300041358913628042231878252464539e-253) }}, 
      {{ SC_(0.004270188510417938232421875), SC_(1927.554443359375), SC_(0.905801355838775634765625), SC_(0.2534271542591935029194534544886225655476402525371102597458582253744193837761018475967111359488942468e-13), SC_(0.1606865936839639220154812320879434797276425946486486204866265102517808313851338914462897553890378346e-243) }}, 
      {{ SC_(0.0042725945822894573211669921875), SC_(1262.0977783203125), SC_(0.8350250720977783203125), SC_(0.2107197908691582408106923795027588929664026945476540469217274209034827723266997925366473217773569392e-21), SC_(0.3067113524451105232599675748625973038848538760344840883394096308983763742905731724217459062710595717e-186) }}, 
      {{ SC_(0.0043012551032006740570068359375), SC_(30236.775390625), SC_(0.905801355838775634765625), SC_(0.1909438305188898788814264748599955189429517806934431120097729159695462451949965256974249579420702566e-14), SC_(0.5567726537786740659237247837635144929992032684460483673627377512011859708639321325657862083432468764e-243) }}, 
      {{ SC_(0.004325519315898418426513671875), SC_(175633.671875), SC_(0.221111953258514404296875), SC_(0.9765627387546010023910914027597295878173964888796355428282381291389814020629671201078144611901105447e-157), SC_(0.2610896750074044197645530379036555019846456797376024435815564468923594221051029690431663375679088488e-30) }}, 
      {{ SC_(0.00443776883184909820556640625), SC_(34.436649322509765625), SC_(0.905801355838775634765625), SC_(0.3451928957866740588408828954078233604597538679306616933083169315226873823852118688529064012427854301e-11), SC_(0.1078915942536595243522784462880793666014494821265356734731677451255774856247457417296426805379830938e-232) }}, 
      {{ SC_(0.00454067252576351165771484375), SC_(0.483688652515411376953125), SC_(0.1355634629726409912109375), SC_(0.3197604923879217789859746878782699677311035400008250295888096076130923308633257872667919704328497876e-190), SC_(0.5025097548531777689853003365146214578426859535216756055251935938510515382607198788458252178015780957e-13) }}, 
      {{ SC_(0.0045460476540029048919677734375), SC_(300.9449462890625), SC_(0.221111953258514404296875), SC_(0.1278410421643053312617805860373795784242611632786671206617762379886575701940508719829985665766099267e-146), SC_(0.2516481805957556160750899491654067502018053045091140502314717903419696404429084482123749731527690037e-26) }}, 
      {{ SC_(0.004563690163195133209228515625), SC_(2.421394824981689453125), SC_(0.8350250720977783203125), SC_(0.2017685886919363554199774311910650936886798272742375469580619068335804281293454270581315916581611195e-17), SC_(0.9594588913692987312966703487802540766859002556225897887845836399580512373214374330849842190980280614e-172) }}, 
      {{ SC_(0.0046148826368153095245361328125), SC_(2.5390207767486572265625), SC_(0.81474220752716064453125), SC_(0.1431597830742336444069598992297912708591648328281176390591586113250058341782317192306933053420776114e-19), SC_(0.5904542992042702541514601392345148910666589794128306192733822779708773164752136296430855088479883883e-159) }}, 
      {{ SC_(0.00461888872087001800537109375), SC_(20.5790615081787109375), SC_(0.632396042346954345703125), SC_(0.2300485586767966234994335715920681715112370755435243914173836280407385046022932186637537011520962476e-44), SC_(0.2248735128594487048255690107468922819140198440701889168135910789033944858294448891258244865204972538e-95) }}, 
      {{ SC_(0.00461952388286590576171875), SC_(0.3906617712345905601978302001953125e-4), SC_(0.632396042346954345703125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.004653147421777248382568359375), SC_(0.10722650587558746337890625), SC_(0.221111953258514404296875), SC_(0.1110869291956305440666537777858921899700532148093702458811474202754346341664227080300181211809690756e-136), SC_(0.3724099241473006487583876674052397217537488028141782640059014309169316044786909001365671407243967563e-19) }}, 
      {{ SC_(0.0046935188584029674530029296875), SC_(0.3578202085918746888637542724609375e-4), SC_(0.1355634629726409912109375), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.0047154170460999011993408203125), SC_(0.00197655311785638332366943359375), SC_(0.632396042346954345703125), SC_(1.0), SC_(0.9999999999999999999999983035913271425854229338598822148694474368184071778831494112149345245860521988) }}, 
      {{ SC_(0.0048523540608584880828857421875), SC_(0.0342371277511119842529296875), SC_(0.12707412242889404296875), SC_(0.1578206741404555228849616307610741327060806805042283925959285809457335301344920285809434194454678809e-172), SC_(0.3250180423710289586903646591996830984979630235145801092107541107501723095629843098523357437055977376) }}, 
      {{ SC_(0.0048918980173766613006591796875), SC_(15688.6884765625), SC_(0.221111953258514404296875), SC_(0.3813810974341855962821232910351910158561747620015173564369275698682834148693298548308288109568662591e-138), SC_(0.2348853830672004421094954873666871549036931846034504807871747010651651531266527976547687624759714629e-26) }}, 
      {{ SC_(0.004914722405374050140380859375), SC_(192.96014404296875), SC_(0.8350250720977783203125), SC_(0.3426892818681607765858933992653171291084112575341691867992459853244855063478139531890254794285020963e-18), SC_(0.1716028798114187558818053346112044344239451353763686038343256729581466469290640888968919000444418206e-161) }}, 
      {{ SC_(0.004918993450701236724853515625), SC_(0.241855232161469757556915283203125e-4), SC_(0.81474220752716064453125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.0049519282765686511993408203125), SC_(0.0407697297632694244384765625), SC_(0.9688708782196044921875), SC_(0.9999999999999481177548872881559131864481882291493597646641119967866348812790977151949261580620359353), SC_(0.5408790804440555764019977938818919711218336041500303559479697889809462480751099740361960507302118638e-294) }}, 
      {{ SC_(0.01061948575079441070556640625), SC_(0.4264468225301243364810943603515625e-4), SC_(0.221111953258514404296875), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.01090050302445888519287109375), SC_(11.95932865142822265625), SC_(0.81474220752716064453125), SC_(0.3394548711434461399197039345131380203046457081597679661920569606097793947380113894583463547114207165e-9), SC_(0.3313744466116940090476197069004213675600085254774219296746348045612349303448474676381073764548320605e-68) }}, 
      {{ SC_(0.011304032988846302032470703125), SC_(0.01250172965228557586669921875), SC_(0.12707412242889404296875), SC_(0.2998962608480790729037021071511917956220561979343950860483291823104879112777934838685726392608676835e-54), SC_(0.999999999999999999999999999999999999999999999841925025061697347806166707185754050971408798885196788) }}, 
      {{ SC_(0.0113441534340381622314453125), SC_(311.568267822265625), SC_(0.905801355838775634765625), SC_(0.2971195863694997830543394940133533734343754644549564968600844963534549606105917468338659197548831525e-6), SC_(0.6627597251793105978687321545284255292409269300656607180589110086167563802344514514518005282404859079e-93) }}, 
      {{ SC_(0.01210707984864711761474609375), SC_(0.00047863091458566486835479736328125), SC_(0.221111953258514404296875), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.0127197094261646270751953125), SC_(461789.9375), SC_(0.9688708782196044921875), SC_(0.1073089003982785729211612242822796694580657253474227466141328249300714525126128516615939096195697843e-6), SC_(0.4216572140463037839478701614203258618039262646952168229008776670998410733907678437886133801643041537e-124) }}, 
      {{ SC_(0.01275224424898624420166015625), SC_(218.467041015625), SC_(0.913384497165679931640625), SC_(0.2138920668536116650923763784029482888081788505901512392275463109517963567566586164060195954810565678e-5), SC_(0.1271373015727443468258133231448740981986337253514336768904685034942767106930475440228248474639521289e-85) }}, 
      {{ SC_(0.013632931746542453765869140625), SC_(12715.3935546875), SC_(0.221111953258514404296875), SC_(0.3766809882753050332339841540453123504372151312937742176604638239143375081784240629647830954954601061e-52), SC_(0.4890377949202294716655264427893492458602405834218951535021966502025766177055748536387544797881547043e-12) }}, 
      {{ SC_(0.01376917399466037750244140625), SC_(410.58148193359375), SC_(0.1355634629726409912109375), SC_(0.1295152085297360548224891504057519332250394799330287418362793424784991911998971787766898873933294969e-65), SC_(0.3519751028939743964479649059523014401649181074141121774851033213679863835668634944178512177682593097e-7) }}, 
      {{ SC_(0.01422516815364360809326171875), SC_(3725.08544921875), SC_(0.913384497165679931640625), SC_(0.2616584564895064558838328693816469048100813108359535816540384465488602491190069286589721970808967354e-6), SC_(0.3151001467913376946111390809395674334746172602322988133063813096052289736896989179930034482842736077e-78) }}, 
      {{ SC_(0.014248653315007686614990234375), SC_(0.29711585739278234541416168212890625e-4), SC_(0.81474220752716064453125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.01431076042354106903076171875), SC_(2.4992504119873046875), SC_(0.9688708782196044921875), SC_(0.0322537112320909123908663905763058966956256503892518375406857130620853606110241063781298273111124396), SC_(0.1425415341795480451711357197794155364576207691109349446494267537879992036186582702803714840755254917e-105) }}, 
      {{ SC_(0.014824463985860347747802734375), SC_(0.38286387920379638671875), SC_(0.81474220752716064453125), SC_(0.7875582498245335999859780198556963440213434533013659870832326862021911261562243885680927508208465954e-5), SC_(0.3203274269925048157144573893217690941261315773803387622206790420512687432185563905952099394168772315e-48) }}, 
      {{ SC_(0.01512057520449161529541015625), SC_(0.0045269015245139598846435546875), SC_(0.905801355838775634765625), SC_(1.0), SC_(0.2026175862879462846825904993878800545690495617043500295770074381757591191185543056674874885357751654e-25) }}, 
      {{ SC_(0.0161462686955928802490234375), SC_(31081.712890625), SC_(0.632396042346954345703125), SC_(0.8650504859534052161394220631861355626763365067546896329375943500065210804045818208125820331078983277e-17), SC_(0.2212481623748096598916817360263562090863217687270136689151654559531467863855414704697580993561487733e-31) }}, 
      {{ SC_(0.01625619828701019287109375), SC_(0.0234319157898426055908203125), SC_(0.913384497165679931640625), SC_(0.9999999999999999999999999999844414628176971612104444798134241222810371841333574557212454590895690393), SC_(0.5102700906814067294868455940089865406605097366803499395027892554924528576204682146841162820583129873e-51) }}, 
      {{ SC_(0.01645939052104949951171875), SC_(29.5273590087890625), SC_(0.913384497165679931640625), SC_(0.7992099725772733917763246216610876778666581365429799400851868891218567399680407992481141565541073505e-4), SC_(0.556151960458916052452091489616758427476021279464763931344982676187009092998591484716878232065995807e-66) }}, 
      {{ SC_(0.01668673567473888397216796875), SC_(0.16884712749742902815341949462890625e-4), SC_(0.632396042346954345703125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.0168448425829410552978515625), SC_(0.0039571900852024555206298828125), SC_(0.9688708782196044921875), SC_(1.0), SC_(0.2134348748225123349932307593782225471681523334985269828368306161531263046434216159166307730043505442e-46) }}, 
      {{ SC_(0.01712529920041561126708984375), SC_(0.002250707708299160003662109375), SC_(0.8350250720977783203125), SC_(1.0), SC_(0.9999999999894075311447098296808212006987307544312421189047293981016038243909547924493553135648819657) }}, 
      {{ SC_(0.017150647938251495361328125), SC_(27.16506195068359375), SC_(0.9688708782196044921875), SC_(0.003706652304112249859678957069063629278050217800861606411459519133046697398106111903562855992524398811), SC_(0.2955394300970994786605969582220104300972154538595533594137052125461004533908165468588501817399355724e-89) }}, 
      {{ SC_(0.01761732995510101318359375), SC_(0.028260417282581329345703125), SC_(0.632396042346954345703125), SC_(0.8268992419747905923947012140316973102772449830512814904184525891690655021298046149742482598005300762), SC_(0.1797083812742240502805597311353349687154317075309024886270825089905675657121774890967927455704055761e-12) }}, 
      {{ SC_(0.017636947333812713623046875), SC_(0.3383924067020416259765625), SC_(0.221111953258514404296875), SC_(0.789770611712973988387653554198474848580604381983286912825497184554655636019060109347003870200820726e-36), SC_(0.8019698684092230949049132949539004728382515536906408051748924377915238929284603448260323645953828269e-5) }}, 
      {{ SC_(0.01792473532259464263916015625), SC_(0.4457229442778043448925018310546875e-4), SC_(0.905801355838775634765625), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.019047506153583526611328125), SC_(0.291198313236236572265625), SC_(0.905801355838775634765625), SC_(0.09714746849063963911850793492151269609338252056927476470985762213797128926236258411068264544725979384), SC_(0.2575556584401940413907031944009515103484688854872648617812452420011220330088098953732435792721842366e-52) }}, 
      {{ SC_(0.01962828077375888824462890625), SC_(266305.03125), SC_(0.632396042346954345703125), SC_(0.1555604313739735015901938650520214697779400557989383819195175049485038515797870208525810311528031064e-15), SC_(0.1542955688184419101260249799341720684350754849899964769433108541841786264292243968230581344198779469e-27) }}, 
      {{ SC_(0.02007224597036838531494140625), SC_(3.6188943386077880859375), SC_(0.12707412242889404296875), SC_(0.4200500010178663479086535266995461848290803868676925297649786766191130264094384661168897170680573091e-45), SC_(0.00020841529438597984759235826381569988401009909042885033296270118232111673872441543488969361728891619) }}, 
      {{ SC_(0.02042911946773529052734375), SC_(36.3684234619140625), SC_(0.3082362115383148193359375), SC_(0.1522944380092980010949523994857639151230211254034868226696760261665392551811295706624971347480191723e-26), SC_(0.2331694868022640177501169503766125230105072176314002152328740288242890890434410626589924004961939046e-9) }}, 
      {{ SC_(0.02061123587191104888916015625), SC_(4.98589992523193359375), SC_(0.3082362115383148193359375), SC_(0.2018027182595950471018861385410032560657936184489463649480416458206562403583101637564600011967706617e-25), SC_(0.2178070169890661188085382956542191138585921425303085133841186847656657449479729760873299056505279428e-8) }}, 
      {{ SC_(0.02065885998308658599853515625), SC_(12765.6015625), SC_(0.3082362115383148193359375), SC_(0.8124903330946992385592890975834638585297977073843082118319386091759428929784476167226127823714473906e-29), SC_(0.8011192642314648802698090945452703508069311843247477617465384482296269438966400552556174864001276506e-12) }}, 
      {{ SC_(0.020764775574207305908203125), SC_(0.0004887509276159107685089111328125), SC_(0.632396042346954345703125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.02124021016061305999755859375), SC_(20481.953125), SC_(0.81474220752716064453125), SC_(0.1804133428688939306148629915962607755322284727381966238911874389882135451431381352063182902403297396e-8), SC_(0.9375789089117065711653106955059991774590641083972486659353691358773808935028337996255472301440499586e-39) }}, 
      {{ SC_(0.021562583744525909423828125), SC_(122176.578125), SC_(0.8350250720977783203125), SC_(0.1093197240594170052825726082253850220584633886565177461733123246748950749433189796150443567155139784e-8), SC_(0.2379222155654957661039915655365132931615394211661434912021045753363455977510053346975647425828781689e-41) }}, 
      {{ SC_(0.02161762677133083343505859375), SC_(1.312267780303955078125), SC_(0.1355634629726409912109375), SC_(0.4714086940877840852821143985137268864926147210047059265428243761880552289621324642089922712547504202e-40), SC_(0.0007810642646207640045612813466958513879368564673482073846840965906031686880042769138441401094776980143) }}, 
      {{ SC_(0.021679364144802093505859375), SC_(0.42985266190953552722930908203125e-4), SC_(0.12707412242889404296875), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.02205819822847843170166015625), SC_(0.00224195979535579681396484375), SC_(0.12707412242889404296875), SC_(0.9999999743437499590557443158950072165278231989716255275627521246638428603444581414207632112728071398), SC_(1.0) }}, 
      {{ SC_(0.02250875532627105712890625), SC_(29.670085906982421875), SC_(0.905801355838775634765625), SC_(0.0002433325632778327092625401467766195146184308710720067695492470041597032477523579878820800465825231766), SC_(0.5150697612146282528479188903902894775941754906902990622440481573532248107930327498073735923156101498e-47) }}, 
      {{ SC_(0.02278398908674716949462890625), SC_(230.1311492919921875), SC_(0.9688708782196044921875), SC_(0.0007269574172873129411963343212040179380298594231431346881863522440015584973926902802527786654233465604), SC_(0.1822636223044223264876614628592099808902816805294045066946374796750942720853176549983920837474772324e-68) }}, 
      {{ SC_(0.02300582826137542724609375), SC_(3731.865966796875), SC_(0.905801355838775634765625), SC_(0.2095220367967429822377583481733573588449573561554430633594800500152630306434401785175101823741972512e-5), SC_(0.3891548069949160453151148712546364726284509317468922156564509523889746286159882981356563230852823478e-48) }}, 
      {{ SC_(0.0235797353088855743408203125), SC_(0.34650889574550092220306396484375e-4), SC_(0.9688708782196044921875), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.023755080997943878173828125), SC_(1.81503880023956298828125), SC_(0.905801355838775634765625), SC_(0.006590777671574961636879966170103174690307145737931865056518046168873372284928805513375880746090332096), SC_(0.2732298204659835001633308277475134635176330805279161997541799404532087072424619786027036565421763991e-43) }}, 
      {{ SC_(0.02475666068494319915771484375), SC_(0.0353721342980861663818359375), SC_(0.81474220752716064453125), SC_(0.9999999998494110550209180668867519886945065285008380827145488700175118810552211822653211287854941369), SC_(0.5086346159614278443874309789988432936439342562940915373695619962359493906444599481879963799093473505e-20) }}, 
      {{ SC_(0.02489638887345790863037109375), SC_(0.17812990336096845567226409912109375e-4), SC_(0.8350250720977783203125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.02505088783800601959228515625), SC_(0.169265210628509521484375), SC_(0.1355634629726409912109375), SC_(0.4393716825626699693872443420059657396353643390970939032698192277482060712029547256328024112303033391e-32), SC_(0.3901105901183525889244131508704606004217103825681865992243979450796731840068187120521771846343791852) }}, 
      {{ SC_(0.0253847651183605194091796875), SC_(0.107284702360630035400390625), SC_(0.913384497165679931640625), SC_(0.9994045085791551569103968035105521804207471937365816378886382546331050768608472270085348862863127296), SC_(0.5145347555259739464752295871433120206092645543317632406344287976112767546361956508719818550032235306e-38) }}, 
      {{ SC_(0.0263047702610492706298828125), SC_(3064.19140625), SC_(0.221111953258514404296875), SC_(0.2276044623595365355804976702547362035120692715163230908557837707260074670216838916528877567942150214e-28), SC_(0.1401816633150001466743385570849220453112069117593970203239771993963829017783750254698646084719194439e-7) }}, 
      {{ SC_(0.02670976333320140838623046875), SC_(0.00032671095686964690685272216796875), SC_(0.913384497165679931640625), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.0269134230911731719970703125), SC_(0.00032558594830334186553955078125), SC_(0.81474220752716064453125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.02691542543470859527587890625), SC_(257.891082763671875), SC_(0.12707412242889404296875), SC_(0.1150412241819363232833673608318559937646755708114443846743800566493561154751813921661001640063490556e-35), SC_(0.1435018135778254280693031610420688095952512143432353733456305218725676547775717965761626089663279399e-4) }}, 
      {{ SC_(0.02693811617791652679443359375), SC_(37925.875), SC_(0.1355634629726409912109375), SC_(0.9187161123493686719438004956412353263450037511534660051274427113116036446223699300277575940086965002e-37), SC_(0.6797905522345183257645865420255517633056506889336045237973988145253535545425635939196719522245615138e-7) }}, 
      {{ SC_(0.027010373771190643310546875), SC_(40.798625946044921875), SC_(0.8350250720977783203125), SC_(0.1798014437236270248138253704932871005342185469454746679709849450334996043701767160498292665465904483e-4), SC_(0.1513583089039433076177271740495099817137855269297600509792331707733889453043127305414711933792587926e-30) }}, 
      {{ SC_(0.027130119502544403076171875), SC_(0.390757262706756591796875), SC_(0.3082362115383148193359375), SC_(0.1044056975572376308765154294986005072870675981267343743712261762026740722231750616244863245447961042e-17), SC_(0.9101352243563679857557108216482150371660984226187518469036378819460978248146148548654889750588226441e-5) }}, 
      {{ SC_(0.027266047894954681396484375), SC_(0.2437297735013999044895172119140625e-4), SC_(0.1355634629726409912109375), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.0276034064590930938720703125), SC_(29335.0078125), SC_(0.8350250720977783203125), SC_(0.2853636941151348397657046931218866027359058046091082403852767018295428497577972128804643411608559971e-7), SC_(0.8724607943396310648606589264285688245751276561785703801250189294573768102186132977176096708340653321e-33) }}, 
      {{ SC_(0.02829697541892528533935546875), SC_(13777.6298828125), SC_(0.913384497165679931640625), SC_(0.1736589265737632964578838443456655981943262569238197086199834594805185366895681857318611358446257428e-5), SC_(0.1189397221041639610388746406584499663421681982547046090445251596832566221982881764122333759917158798e-41) }}, 
      {{ SC_(0.02842903696000576019287109375), SC_(0.03119052015244960784912109375), SC_(0.8350250720977783203125), SC_(0.9999999999999984084063316155836368075057977363893366558328934762346404058500127598619619457809450781), SC_(0.2229579796791742481372346796211945378302688231126931718756291563778710461961297903104990346987522257e-17) }}, 
      {{ SC_(0.02883697114884853363037109375), SC_(399.402069091796875), SC_(0.3082362115383148193359375), SC_(0.2718019908822349418386085673590849525238184767158595324397346436757882917012839726878013827414479547e-20), SC_(0.4061626135411854809919783794879608125371376531026679210955857871963161853148808488426049802248524438e-8) }}, 
      {{ SC_(0.0292808823287487030029296875), SC_(0.4510292112827301025390625), SC_(0.632396042346954345703125), SC_(0.7839128566060896947368087167226581474691026261923481810505924631799162620570913277755695945847927869e-6), SC_(0.704297546008106999661065436236280684549945454917873334339646674170284492387008449028099214191283426e-14) }}, 
      {{ SC_(0.0295875072479248046875), SC_(0.18167886082665063440799713134765625e-4), SC_(0.913384497165679931640625), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.03072208352386951446533203125), SC_(487934.875), SC_(0.12707412242889404296875), SC_(0.8108497381952252287827948136752107732445987862735089473441231977965098910583770562617792683501862499e-35), SC_(0.1424010664584348861459925411453889646057594967951447570239331171012944551007449427901915631630930771e-7) }}, 
      {{ SC_(0.0310857109725475311279296875), SC_(15232.21875), SC_(0.905801355838775634765625), SC_(0.1605220071657247271536519849691309457742442181828171823431993692890280781736459693024175399391200143e-5), SC_(0.3744778564571311897387386314508759605928284070246312365312062599270231291584888873497403385148538007e-37) }}, 
      {{ SC_(0.03123457171022891998291015625), SC_(3524.479736328125), SC_(0.12707412242889404296875), SC_(0.3380179741025625130594553963055123470797485945263619277584867014106077006962757168609399934695108262e-32), SC_(0.2122070084774707804526082035603305501395751934924392277461843556714874343017879250017413564403539705e-5) }}, 
      {{ SC_(0.0312533564865589141845703125), SC_(3994.4365234375), SC_(0.8350250720977783203125), SC_(0.4511537506193050038388193880869944677641536876360369056827823070369087023490799649584507772308784597e-6), SC_(0.1315153243537056845722888711609247845420905304884308854505370331509311419058278626789622963092543423e-28) }}, 
      {{ SC_(0.0315650589764118194580078125), SC_(0.001970894634723663330078125), SC_(0.3082362115383148193359375), SC_(0.999999999999999999999999999999999999999999999999999999999999999999986773890768532679810845499066263), SC_(1.0) }}, 
      {{ SC_(0.0319148339331150054931640625), SC_(0.00033934754901565611362457275390625), SC_(0.8350250720977783203125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.0324479900300502777099609375), SC_(0.015262463130056858062744140625), SC_(0.1355634629726409912109375), SC_(0.3149187279576306184549621540112105986790134560685035035373310464492501608768724258632508424293817365e-11), SC_(0.999999999999999999999999999999999999999999999878335855350655894771055071194203445152745817337995088) }}, 
      {{ SC_(0.0333194546401500701904296875), SC_(0.3989324867725372314453125), SC_(0.9688708782196044921875), SC_(0.9076022671185609356318275460599332838272469533810706043999439002307585692036734322358860139356297392), SC_(0.4004571394386775792378526406190674207722086797876156342313144718526485641114185022081848477461812071e-44) }}, 
      {{ SC_(0.0333627723157405853271484375), SC_(4.62843418121337890625), SC_(0.913384497165679931640625), SC_(0.009495430794609611285745311089905495207211316766447295313087966071837559050926626251228316995050282153), SC_(0.1988200916248673010231264871542099188285836982636547556239235129616956263350680171812112511832329089e-32) }}, 
      {{ SC_(0.0335802994668483734130859375), SC_(0.19390623271465301513671875), SC_(0.8350250720977783203125), SC_(0.3101259303428897448759502623465982078459374070521890316068903880544455874811387708830679648483255429), SC_(0.43817227603678849636483718203402523696114117333935808316629610574477590399816112854621342659480082e-21) }}, 
      {{ SC_(0.033774249255657196044921875), SC_(33.470600128173828125), SC_(0.632396042346954345703125), SC_(0.2240982180328528153376348860922966506583662621666756123148285138137017993555124368340020753097519876e-7), SC_(0.2368339479903695681825519330672978907953129951297616926141822971720965487483525401669922369156451521e-14) }}, 
      {{ SC_(0.033940948545932769775390625), SC_(489.9017333984375), SC_(0.221111953258514404296875), SC_(0.5779855454616287036488971814355227311194228848243043951395455986787463387086599101313294644939558598e-22), SC_(0.7486088979275406629872151513081228564880546374375168121769479646842170229180463234647520870805269882e-6) }}, 
      {{ SC_(0.0344383455812931060791015625), SC_(1315.3695068359375), SC_(0.9688708782196044921875), SC_(0.0002302459642131107220600058642530000749729392111928407677965236831855976073714186247947027253612216502), SC_(0.7727051779738960370969572634707950902399919432990357331654233405275120531881623075998432850012762696e-47) }}, 
      {{ SC_(0.0346836335957050323486328125), SC_(2.891076564788818359375), SC_(0.221111953258514404296875), SC_(0.3023939346799245474889614343081333672279624024944930954168238574929526605943598150596823325984803468e-19), SC_(0.0001769642654312224482994346593710366316945873332790755937870558274941448456030638235982038958524954951) }}, 
      {{ SC_(0.0355083644390106201171875), SC_(207270.546875), SC_(0.221111953258514404296875), SC_(0.9726849169561589116849417763433681153238325651038257954686149793803103996337638940073957962192110204e-24), SC_(0.2449868636768844281221570121589290029450213820578438505125850334328294225533967338063955907135292939e-8) }}, 
      {{ SC_(0.035541228950023651123046875), SC_(353.3453369140625), SC_(0.8350250720977783203125), SC_(0.1029493404851659323798555591278456853663035901821732091785769305841571957497380027113693353060338171e-4), SC_(0.1567472557091927255967284878430258903970679773155857479188474056597145541884272356841824738814775716e-24) }}, 
      {{ SC_(0.0357905812561511993408203125), SC_(0.19347016513347625732421875), SC_(0.12707412242889404296875), SC_(0.8089996578476739611683201471251152642605387617562762980206352749883173069660413160323836012055811324e-23), SC_(0.7414851586543001562992251821070565016281117574692107877887751001131367150603570478069309795827599006) }}, 
      {{ SC_(0.03617782890796661376953125), SC_(4978.021484375), SC_(0.1355634629726409912109375), SC_(0.1192207582058158611034074754189269323450354758681253801849211475591551962102103672422123552941910051e-27), SC_(0.2092098752949070369757674635111774348778709049099796198628307706752782755529124351631226934066372462e-5) }}, 
      {{ SC_(0.036653555929660797119140625), SC_(0.0039511634968221187591552734375), SC_(0.221111953258514404296875), SC_(0.9999999999999999423942615411677945622398325229157324970450891452483353627310106282217627277782955439), SC_(1.0) }}, 
      {{ SC_(0.0366611182689666748046875), SC_(0.001741903950460255146026611328125), SC_(0.81474220752716064453125), SC_(1.0), SC_(0.9999999999999999999999999999999999999997076004526314824509675943167281680151652569321500573070586097) }}, 
      {{ SC_(0.036767013370990753173828125), SC_(0.010332576930522918701171875), SC_(0.3082362115383148193359375), SC_(0.999992144192717218944390160156828962740552204049312515501550350503464834784238870642719888538815269), SC_(0.999999999999999999999999999999999999999172462637627935907220745589778298255248580642981397328908052) }}, 
      {{ SC_(0.036872327327728271484375), SC_(345497.65625), SC_(0.905801355838775634765625), SC_(0.1190082471525560964766619702069872873432833195067239213841573004802046186975018223120795818218151003e-6), SC_(0.2507719639693328414044245526231082409640480827888776893058606920509692934370216926401547010627493986e-33) }}, 
      {{ SC_(0.0370448939502239227294921875), SC_(289887.34375), SC_(0.81474220752716064453125), SC_(0.7926951867744425549192176475000268620250835614679804121689941763375135083967165117173589842503177612e-8), SC_(0.3421741613374386769397975711185431819316177728715406504529192137489545566190196480004637482252824979e-25) }}, 
      {{ SC_(0.0378056205809116363525390625), SC_(296247.6875), SC_(0.913384497165679931640625), SC_(0.187551344901301817278446813039995221620424177497732236699139156064496741436588974322647216739673362e-6), SC_(0.1545853555245189464326601817323343123570984653774348703168149564146503844843240553627578963069054235e-33) }}, 
      {{ SC_(0.0378379710018634796142578125), SC_(353.800811767578125), SC_(0.632396042346954345703125), SC_(0.9013014893192234368726332666625322304849885472269783647080282730025886066768624812069186618395938158e-8), SC_(0.5346656850872613414840350578982044422144135589733383804592734495987141582784644220206866651521315923e-14) }}, 
      {{ SC_(0.0379242189228534698486328125), SC_(0.004291436634957790374755859375), SC_(0.632396042346954345703125), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999999999996480854757), SC_(0.9999999999999999999999999999999999971909709440402806037598957186644483081349274767153397340279015115) }}, 
      {{ SC_(0.0379955135285854339599609375), SC_(128.872100830078125), SC_(0.81474220752716064453125), SC_(0.2057593481010501394053248972359360365741821779024343876009380114913562571373244722119072462203655395e-4), SC_(0.2414315586208764990263497135239449355155370047463438166370815226367728896907128345950460461980561219e-21) }}, 
      {{ SC_(0.0380439497530460357666015625), SC_(0.001482595689594745635986328125), SC_(0.1355634629726409912109375), SC_(0.9999999999999999999999999999999684277872266981787476366868617913445124596820410584518380349577262473), SC_(1.0) }}, 
      {{ SC_(0.0387343578040599822998046875), SC_(1982.2989501953125), SC_(0.632396042346954345703125), SC_(0.2128136580447557569739626428237849453668939497050964819247419585950869072911005579578716618524150027e-8), SC_(0.1759182855837408216877722167538436199224125759229454398449732316455171538313166405406851397170696071e-14) }}, 
      {{ SC_(0.0392099507153034210205078125), SC_(4.091603755950927734375), SC_(0.8350250720977783203125), SC_(0.001618745215042852642915975754780290766782518372579807628122426118809742913019123895761958098735234443), SC_(0.1759064016594466103298349630148639481092392549559347563253320621757165266075406167621512785822660288e-20) }}, 
      {{ SC_(0.039514325559139251708984375), SC_(0.000166679310495965182781219482421875), SC_(0.3082362115383148193359375), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.0411520861089229583740234375), SC_(28357.451171875), SC_(0.12707412242889404296875), SC_(0.3463899338911944599416716424104446286334168416072523675752121011114755317913004504380522453659129225e-26), SC_(0.768888035757411423985501222635596250662955308829176329460624390547011214090637387515003566072767682e-6) }}, 
      {{ SC_(0.04271042346954345703125), SC_(23.0694675445556640625), SC_(0.221111953258514404296875), SC_(0.1162476525693489478951760516978152752197286372124774231725766374773276352021282641511977835552972712e-16), SC_(0.7413641733242364493282738907518503477942578799273096910217563670772912597465032598195291176461417288e-4) }}, 
      {{ SC_(0.04279924929141998291015625), SC_(3897.815673828125), SC_(0.3082362115383148193359375), SC_(0.1703523526496431177506222422316448862824199948821976105705037895973838231527187395717099131951657675e-15), SC_(0.2717712746452144600134345993731485473936149769825120702002855040206892304731780905967027274917685412e-7) }}, 
      {{ SC_(0.04297505319118499755859375), SC_(3.1283900737762451171875), SC_(0.632396042346954345703125), SC_(0.5102425149125884451204896576908943381500161816656354342949661356251193726952081899931957614089556298e-5), SC_(0.1680015043778550379901912937010941504561279983270061167072289097042667721911306394859831084655370566e-10) }}, 
      {{ SC_(0.0442209132015705108642578125), SC_(0.02011293359100818634033203125), SC_(0.9688708782196044921875), SC_(0.9999999999999999999999999999999999999999999999999999999999999999998600129538442341782452795329462649), SC_(0.213930888086569819954947547602179113413858836226235564083071374915561987172359004319181764396333945e-22) }}, 
      {{ SC_(0.0450148619711399078369140625), SC_(14815.267578125), SC_(0.9688708782196044921875), SC_(0.2790981483929006578675128502938680134857856495244587836676051426616145326163650900370884438015476462e-4), SC_(0.1318968190899611506278702158108286611473207740456873125822909737834380134836425636631277345355401155e-37) }}, 
      {{ SC_(0.04518614709377288818359375), SC_(23.06797027587890625), SC_(0.1355634629726409912109375), SC_(0.1602807032610034359348994547984191884314964880307337893022088638569306789229109870390020903910761581e-20), SC_(0.001048522377657149884347487695341127526677154983682244326895427646595381180857818134179647586258993865) }}, 
      {{ SC_(0.04527465999126434326171875), SC_(0.013598117046058177947998046875), SC_(0.221111953258514404296875), SC_(0.2757276388527437619265454175619550075909906830860698677078645731568979239560750556006930444098598931), SC_(0.9999999999999999999999999999999999999998554861516547180206056185672659950700237157854991988760022554) }}, 
      {{ SC_(0.04625232517719268798828125), SC_(43.923553466796875), SC_(0.12707412242889404296875), SC_(0.5711472805990616461631481931006769376542692108365472293015546742452249415720924224044622283811555193e-21), SC_(0.0007317393197624427087672044834589789715927877153041172450661254278074230551544701869807894910884516244) }}, 
      {{ SC_(0.0468132793903350830078125), SC_(0.00025698760873638093471527099609375), SC_(0.1355634629726409912109375), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.04770947992801666259765625), SC_(0.00015248873387463390827178955078125), SC_(0.905801355838775634765625), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.0477449037134647369384765625), SC_(402512.65625), SC_(0.1355634629726409912109375), SC_(0.9643756757900491429593533711949718004033195001721149018759325935601935516334814491201736090459646375e-24), SC_(0.7043377719177572706523399562997591199543584733225048072846797482778581012090984256408577622579282115e-7) }}, 
      {{ SC_(0.0480652190744876861572265625), SC_(0.00045122022856958210468292236328125), SC_(0.12707412242889404296875), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.0483077578246593475341796875), SC_(389962.375), SC_(0.3082362115383148193359375), SC_(0.3933133085683340900052008172595028027726876612133686776175793358628825211556372315900037792795521679e-16), SC_(0.7282915815842453209666308554921117930751500864701807020893969609199529436331383617197729511393728933e-9) }}, 
      {{ SC_(0.04874597489833831787109375), SC_(2329.3564453125), SC_(0.81474220752716064453125), SC_(0.3779568494167474209370316114324776871363438039778577619306705852830433860240261447450864181647038624e-5), SC_(0.2387661263082519208035821906396036544344705953639292348978837066805965233473231873654835743398814258e-18) }}, 
      {{ SC_(0.04926551878452301025390625), SC_(0.0299147777259349822998046875), SC_(0.905801355838775634765625), SC_(0.9999999999999999999999999996373492635755034870805622561509808110865023503430344347529283076781788172), SC_(0.5438109334702437703928403553854168057932046115673454463872801643553587641714485474731401739134064939e-12) }}, 
      {{ SC_(0.049306534230709075927734375), SC_(4.597743988037109375), SC_(0.81474220752716064453125), SC_(0.002233657431127039185061456362763927646072436800567599503315660064327295094702062835222952789051316385), SC_(0.1994728283972980711561085314577665636038879373526847365155635580263741871987242792210945930962911643e-15) }}, 
      {{ SC_(0.0493220984935760498046875), SC_(0.00032175212982110679149627685546875), SC_(0.9688708782196044921875), SC_(1.0), SC_(0.9999999999999999999999999999999998858886921573991909999572496972225838746131509082118285021795072199) }}, 
      {{ SC_(0.0493625514209270477294921875), SC_(0.2173553002648986876010894775390625e-4), SC_(0.3082362115383148193359375), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.0499632172286510467529296875), SC_(0.00369685166515409946441650390625), SC_(0.913384497165679931640625), SC_(1.0), SC_(0.9949174783337980529271663335906462095369637046189064152314439551292043923497483017362512120929329974) }}, 
      {{ SC_(0.10046042501926422119140625), SC_(0.000209066798561252653598785400390625), SC_(0.1355634629726409912109375), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.102686129510402679443359375), SC_(0.19225277355872094631195068359375e-4), SC_(0.905801355838775634765625), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.11430509388446807861328125), SC_(0.00042258042958565056324005126953125), SC_(0.9688708782196044921875), SC_(1.0), SC_(0.9999999999999999999999999999835401693391560511732164415347979549347245029185814758228586763985196481) }}, 
      {{ SC_(0.11778163909912109375), SC_(206355.0), SC_(0.632396042346954345703125), SC_(0.6163195746125755950734897031441357409066155954965426452253014863019226486993850762333916009369013e-7), SC_(0.6088899035401520524177971509733632109330209813926331067829266028917907187752873944898778100259026017e-9) }}, 
      {{ SC_(0.1254365444183349609375), SC_(233.073516845703125), SC_(0.9688708782196044921875), SC_(0.004272755449388322273096950841426128550429514117092079361158463229777072211690255204610613124867916041), SC_(0.2583491650689547176630168506424024687908809022389285682944380234325291226753959508243371802923899776e-14) }}, 
      {{ SC_(0.13644538819789886474609375), SC_(0.0134486891329288482666015625), SC_(0.632396042346954345703125), SC_(0.9999999999999999999999999999957268006765890138886764961874241988301997893092066511961130042135489608), SC_(0.9999999999985879314902806425678715563810683893451606102907755247173976711412070907418233561418315768) }}, 
      {{ SC_(0.13752801716327667236328125), SC_(43384.8671875), SC_(0.1355634629726409912109375), SC_(0.7041902635877264941565289347363813032421460356409479683641279357269959500154481762620757461973823648e-11), SC_(0.6253287507097881974838192915751126251135767210941492678202173364256704919764851242734304186963504861e-5) }}, 
      {{ SC_(0.14231930673122406005859375), SC_(444.787506103515625), SC_(0.905801355838775634765625), SC_(0.001006130632027903235799102829092194198063035793358987177581974898177452438466276530705029498635752976), SC_(0.8717129727112130413784666169813012091564037280586173113736986953571651842281674653219292996865627678e-10) }}, 
      {{ SC_(0.14387898147106170654296875), SC_(282.2655029296875), SC_(0.913384497165679931640625), SC_(0.001753149801494672324070478182417001748598706266043829934772009562780972666118460184171288799256161453), SC_(0.9192031596368843001104447522520095668423438102179196298837488224075541819664580559340883096369449804e-10) }}, 
      {{ SC_(0.14768581092357635498046875), SC_(43.79425048828125), SC_(0.81474220752716064453125), SC_(0.004215487140776433965629018683908918618649143101235725193072424238312718636140952410665263870829337402), SC_(0.1597559052871092531371256555594429178656710940824688756408817609800313005764444411528090320127091132e-6) }}, 
      {{ SC_(0.14775849878787994384765625), SC_(0.1444317400455474853515625), SC_(0.905801355838775634765625), SC_(0.9999927624254942737388549138358433164035679016409778199470166515635635865602243010356964894271596794), SC_(0.1102197877930976138550630023823934774508790300399619182666051459043145385934572331154282056451896945e-4) }}, 
      {{ SC_(0.1555496752262115478515625), SC_(4926.16162109375), SC_(0.9688708782196044921875), SC_(0.0002340251718338386847857498968172725207964532672651165277910875656725154967411520012501616371329740537), SC_(0.2639019850946575455159231940212621856433751453096243942325320217489857622475996447321067695516891679e-13) }}, 
      {{ SC_(0.15999889373779296875), SC_(346211.125), SC_(0.1355634629726409912109375), SC_(0.6901726346579894040555906960026962295551341391308953311260145947198508089185836157414926096266694346e-11), SC_(0.9659232237036697623226583025443581749195269888551283450064367168060934988596803941773929539019222153e-6) }}, 
      {{ SC_(0.16108848154544830322265625), SC_(0.003161008469760417938232421875), SC_(0.3082362115383148193359375), SC_(0.999999999999999999999999999999999999999999999999135488486050759006314384089791230339136785990392787), SC_(1.0) }}, 
      {{ SC_(0.17034976184368133544921875), SC_(0.00294548436067998409271240234375), SC_(0.12707412242889404296875), SC_(0.9999999999999999975958565710829602176443484051162668590933504457417982718133859114111332944527058444), SC_(1.0) }}, 
      {{ SC_(0.17546479403972625732421875), SC_(0.045397706329822540283203125), SC_(0.221111953258514404296875), SC_(0.6417813913513644435500982329383686521897566198001533648309413980293322120837824470649582766851467426), SC_(0.9999999999995466279949628652277212540636607620058565782341893078308400996616771453876111962881474478) }}, 
      {{ SC_(0.17669810354709625244140625), SC_(0.00317144836299121379852294921875), SC_(0.8350250720977783203125), SC_(1.0), SC_(0.9999999999999999999999568546793599976833508720907328795026789550599278756571842612535185158863060156) }}, 
      {{ SC_(0.17681133747100830078125), SC_(4087.143798828125), SC_(0.913384497165679931640625), SC_(0.000149450928736923049910854453475824420280450008159422071879974491983627843002632618848691114571109052), SC_(0.154007378382369644824343785267977232196336485145781559727253270237353396255847206679519573480950959e-9) }}, 
      {{ SC_(0.1835739612579345703125), SC_(0.3351508080959320068359375), SC_(0.632396042346954345703125), SC_(0.4383035616633197248620227753135082187762558677157686360768357549560265832354557606207814967445074305), SC_(0.03043310897411578961648598000395404423049447906840816446120026090872754964244569296514069716272473635) }}, 
      {{ SC_(0.1874706447124481201171875), SC_(406.947998046875), SC_(0.8350250720977783203125), SC_(0.0007824871518437107963650884142269781375061557038770757255105767892797326397430722623867177155645875183), SC_(0.1064950864828473392035226911225804530197292387363906330915049621940432879379498417965461613011114761e-6) }}, 
      {{ SC_(0.18961600959300994873046875), SC_(0.4673106013797223567962646484375e-4), SC_(0.1355634629726409912109375), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.19449223577976226806640625), SC_(0.23129458725452423095703125), SC_(0.8350250720977783203125), SC_(0.9904818238756517953759876266954342241108787809293799200386316481842910908349939046305548045913891186), SC_(0.001628736453081428107007951649788268368622198091219711592055188548837782403694925848989473863648621578) }}, 
      {{ SC_(0.1971141397953033447265625), SC_(147358.625), SC_(0.8350250720977783203125), SC_(0.2312826825157954434751611052346991859910733226536919333442666317691037546565041971737891375025347097e-5), SC_(0.47337059925733744918750345867267392477595014971390050391685587273633649060304165207438814469689708e-9) }}, 
      {{ SC_(0.1971398293972015380859375), SC_(0.00232790899462997913360595703125), SC_(0.913384497165679931640625), SC_(1.0), SC_(0.9999999999999985389541857032427592271528383123464363031988982024923070885729883717764495782285277158) }}, 
      {{ SC_(0.2019160687923431396484375), SC_(0.4740857184515334665775299072265625e-4), SC_(0.12707412242889404296875), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.2025763988494873046875), SC_(2.372247219085693359375), SC_(0.913384497165679931640625), SC_(0.2932694844332986675934126540792195076302810520755200406771653923274205752989340208634416923486017584), SC_(0.1868082799618148954653617218675799200365113947763016432586871894728045632175979453458051966640411987e-5) }}, 
      {{ SC_(0.20485810935497283935546875), SC_(480505.75), SC_(0.3082362115383148193359375), SC_(0.4366607066111461425739143377407244977921357852123343896019306386301891073591545964946329640747303367e-8), SC_(0.2484325572354354033603290961942141000992936418323740737710335461292062894650826220846596398234506859e-6) }}, 
      {{ SC_(0.2059116065502166748046875), SC_(24.2244358062744140625), SC_(0.3082362115383148193359375), SC_(0.9074379344268687260600806097184099127223709300889977572649125775309169921491107605456694219159483604e-4), SC_(0.005051524865454660778216813074183373270106131057107560878667883895844861311410491948832336615482939867) }}, 
      {{ SC_(0.20762462913990020751953125), SC_(0.0442828945815563201904296875), SC_(0.12707412242889404296875), SC_(0.1701530015122572548036891207020082107920977299821548523844053218349686904965076044508552718907001937), SC_(0.9999999999999999996548059729130464765597532934061056571496648118073063034858127117694901998672624019) }}, 
      {{ SC_(0.21499927341938018798828125), SC_(0.0337234772741794586181640625), SC_(0.3082362115383148193359375), SC_(0.9990003380944731872609481331049937948026856547492910971910571414912156649595053370612357558946170489), SC_(0.9999999999999611130058563625471432636488995360353333363630593577382319507965063554115208185852835863) }}, 
      {{ SC_(0.22722963988780975341796875), SC_(39.870731353759765625), SC_(0.632396042346954345703125), SC_(0.002416110253181023783340346166808147570814705244710609438462644372975391564375949307870705196336879564), SC_(0.0002072023313923484783862041724933307554056356656081130379857007672135676632877645473725811460075375656) }}, 
      {{ SC_(0.22898872196674346923828125), SC_(0.000221865411731414496898651123046875), SC_(0.8350250720977783203125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.23644983768463134765625), SC_(0.00389209692366421222686767578125), SC_(0.632396042346954345703125), SC_(1.0), SC_(0.9999999999999999999999999999999999999999999999999649007295996492575399057607563749375486361046836478) }}, 
      {{ SC_(0.2377849519252777099609375), SC_(0.19049095499212853610515594482421875e-4), SC_(0.632396042346954345703125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.2390850484371185302734375), SC_(394272.125), SC_(0.12707412242889404296875), SC_(0.3040852216825054429806845573945959447237116244467689840458070209470925073102073099062360512960727705e-9), SC_(0.1467709448388560244778613115161044664029874183993745826721715085460497012162829615569861418760256704e-5) }}, 
      {{ SC_(0.24008722603321075439453125), SC_(1.274954319000244140625), SC_(0.3082362115383148193359375), SC_(0.005345589488510356931043376991153442272465535187890540841748721975562397553999534415837078424031000486), SC_(0.1606312388779836297782390940138553550670985349936254325315686586219518845029080049748145022132075425) }}, 
      {{ SC_(0.2436912953853607177734375), SC_(193457.484375), SC_(0.9688708782196044921875), SC_(0.7901873907795843114037659082521467823031955990361321194561611437183900327263529090721028147583627237e-5), SC_(0.2277778135811793829323627653892144754055956562688818626340524967315524894413680471393838084186004497e-11) }}, 
      {{ SC_(0.2463264763355255126953125), SC_(1483.4622802734375), SC_(0.221111953258514404296875), SC_(0.9929457881339474645933964080832334389660074622980018573318111721440819702082465873776160999910855324e-6), SC_(0.0002081124370684817793928405974195016332426698624129116483400787619795112702638927998405511162399921182) }}, 
      {{ SC_(0.254708468914031982421875), SC_(0.493781044497154653072357177734375e-4), SC_(0.9688708782196044921875), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.2573825418949127197265625), SC_(44778.4140625), SC_(0.8350250720977783203125), SC_(0.1066546274847743601553947456760707511347575526818910849774518840235738501426892932114993767895724449e-4), SC_(0.1380417178031393494338152733540189900328290477715146046892988769689404394461415758801369641177312646e-7) }}, 
      {{ SC_(0.2618319988250732421875), SC_(4353.03955078125), SC_(0.12707412242889404296875), SC_(0.5918106258984884304618178569299963307137448470784068570566339021403750902824172603669451597262516442e-7), SC_(0.0001461687342429989358597919583633167683499318426473614604421666767226892873893412178894385705862836655) }}, 
      {{ SC_(0.2664634287357330322265625), SC_(2.7337188720703125), SC_(0.81474220752716064453125), SC_(0.1665163629221338214801763906317702506899150180986728660187427011644595782190485557969560303259448221), SC_(0.0005119851811219490561714098031071765234141531078517346402644659971645150950107713073823044692592358643) }}, 
      {{ SC_(0.269739627838134765625), SC_(0.0001012004868243820965290069580078125), SC_(0.3082362115383148193359375), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.270291507244110107421875), SC_(0.04600088298320770263671875), SC_(0.913384497165679931640625), SC_(0.9999999999999999999998298879798194930664940429964110501934073665135526852611496336734149476355863891), SC_(0.1250704568495760184014672142148334229321021027168982298363565895756551259249483947206268011799193717) }}, 
      {{ SC_(0.276960909366607666015625), SC_(225226.28125), SC_(0.905801355838775634765625), SC_(0.3831050630138895446194262413689474063389412956447990532061948474764936664132789712467294878599758935e-5), SC_(0.602639433323155065262961017864667920108814815202791157543301554737996096506599007020163909240362633e-9) }}, 
      {{ SC_(0.279349148273468017578125), SC_(3217.235107421875), SC_(0.1355634629726409912109375), SC_(0.1673676825989532028881624960918872328326765160359367398452665537302459913142893855046809376437357099e-6), SC_(0.0001990113505082938765387810381617350838367775496221114971007753858202486584375445322995633766956596906) }}, 
      {{ SC_(0.280055105686187744140625), SC_(0.489566028118133544921875), SC_(0.9688708782196044921875), SC_(0.9951237119319888385745912777644157103648656643915674722936153010141627443054053012865778138546123643), SC_(0.1242174345224771145598312890509707016567136015290908210801488079936064750952575710067214353449978684e-4) }}, 
      {{ SC_(0.28349018096923828125), SC_(3.132917881011962890625), SC_(0.12707412242889404296875), SC_(0.00017107748028300755264174680478797086348266755930427029547243711903516105388101396331318185167369096), SC_(0.2186068103164437032138281283197983785985304277707866409098010533954520304756840512109746717974448754) }}, 
      {{ SC_(0.284366548061370849609375), SC_(0.0002785695833154022693634033203125), SC_(0.632396042346954345703125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.2849796712398529052734375), SC_(0.00028760623536072671413421630859375), SC_(0.221111953258514404296875), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.28854286670684814453125), SC_(0.00019903402426280081272125244140625), SC_(0.913384497165679931640625), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.2893944084644317626953125), SC_(0.0018625170923769474029541015625), SC_(0.221111953258514404296875), SC_(0.9999999999999999999999999999999999999999999999999999999988617342925642107651906853181813157308382494), SC_(1.0) }}, 
      {{ SC_(0.291785299777984619140625), SC_(38.487705230712890625), SC_(0.913384497165679931640625), SC_(0.02484007173179906033865157608482124083983784153040298382965595177727543370232983684956930377782541128), SC_(0.4157218704310742309952097356277113088335215919245130433482722743942900524399305559555889864769542049e-5) }}, 
      {{ SC_(0.293941318988800048828125), SC_(43703.57421875), SC_(0.81474220752716064453125), SC_(0.1122805105890045380376573874109506324045678800263167672438969753506104108112775350032973935674537289e-4), SC_(0.5139314735783948331590153009373593901670812744953978394702278888162620157242899472111190861744197539e-7) }}, 
      {{ SC_(0.308021008968353271484375), SC_(34557.2734375), SC_(0.9688708782196044921875), SC_(0.5083562831820649497652828522987300857553062383506786136367305342392985601967476335821313234334529561e-4), SC_(0.26007757373224433067807474647990621636053855556399049516185884203607852481531372136254826863149002e-9) }}, 
      {{ SC_(0.3089981377124786376953125), SC_(432.827178955078125), SC_(0.632396042346954345703125), SC_(0.0004211430003257416247483086112363866500624310627068424398017115032160291182880670703075174247014360852), SC_(0.6495858635902448649022033744121551063530380656048177406401407779923296220985379459030423383067265553e-4) }}, 
      {{ SC_(0.310161769390106201171875), SC_(24687.779296875), SC_(0.221111953258514404296875), SC_(0.2200277168684517438680725586139724742488707336725980923145639863777937550963404428880964490878643264e-6), SC_(0.1717931424026711274069571730965100756134477271461154729302447423496465991610582463506262024449781823e-4) }}, 
      {{ SC_(0.3121376931667327880859375), SC_(12025.0380859375), SC_(0.3082362115383148193359375), SC_(0.1363375046552933125327350435837596390626161786164464871591243253589146935668376807877139494379030431e-5), SC_(0.2171436598716613936257968308801421729280747855010444327718335224693341430467575243395096648355534956e-4) }}, 
      {{ SC_(0.31629574298858642578125), SC_(20.7625732421875), SC_(0.1355634629726409912109375), SC_(0.6228289449350647284114988319796782909468108047269796751394963481836673381203289345869650503847672269e-4), SC_(0.03493437135308178980239854702709799292860296145196635363770627993162371390903059659827648159585220423) }}, 
      {{ SC_(0.3175543844699859619140625), SC_(241.035797119140625), SC_(0.221111953258514404296875), SC_(0.2540474717791075092367715884071933645436003299684034695217707307293615550705080329773781036982874872e-4), SC_(0.001815123707475499842209925370618718561436055586128318613611210252388450620747094867673306507082615388) }}, 
      {{ SC_(0.3178864419460296630859375), SC_(403.9595947265625), SC_(0.12707412242889404296875), SC_(0.2656248620876179543939348412704049964495378075941163834724162336891831446816160927385299672252550866e-5), SC_(0.00190961151014375397391057404904998519545359222875369498248081020698628275152261409615869197850156592) }}, 
      {{ SC_(0.31863725185394287109375), SC_(0.049230270087718963623046875), SC_(0.905801355838775634765625), SC_(0.9999999999999999999823530819838983133333399939180532534505207194878695183755700511016824415115970125), SC_(0.2532981304502310145605131568584583373089343352683136060041260038949502481316691095228208094878783051) }}, 
      {{ SC_(0.330483734607696533203125), SC_(0.0469950400292873382568359375), SC_(0.81474220752716064453125), SC_(0.9999999999999971078609671070620787698543076974218366407394807077342152799778832571779583266640997082), SC_(0.870939409780308346976869726291013533196974422621452129111792656453150671740642770334968767034006661) }}, 
      {{ SC_(0.3328996598720550537109375), SC_(49.7097015380859375), SC_(0.12707412242889404296875), SC_(0.2937780853801564617897209428975616559098538016286600185872101986438057476527487569894049443259869024e-4), SC_(0.0161965942195194786594818608531327814519156895434121568294864323755080321582872722280221148000748778) }}, 
      {{ SC_(0.334436833858489990234375), SC_(365052.03125), SC_(0.221111953258514404296875), SC_(0.215451252767453021133622060345861224433384934183163761594745559998927854963526936770816301691875668e-7), SC_(0.1279813957453574184429401083597100660879017164963473831270243074788915952887059748129286569654831066e-5) }}, 
      {{ SC_(0.340868175029754638671875), SC_(0.3847523112199269235134124755859375e-4), SC_(0.913384497165679931640625), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.342921555042266845703125), SC_(0.14970906078815460205078125), SC_(0.913384497165679931640625), SC_(0.9999994072540801457283716820078950330566150428016369500133404996503845120700493070686125387311253465), SC_(0.02114488737679054640927838856772312763123716733278077673553251258920505189642266149925565740638442049) }}, 
      {{ SC_(0.3429556787014007568359375), SC_(0.00213477574288845062255859375), SC_(0.81474220752716064453125), SC_(1.0), SC_(0.9999999999999999999999999999999999999999758078596715361018588402308171898983547406182843420797371742) }}, 
      {{ SC_(0.345384299755096435546875), SC_(2.248920440673828125), SC_(0.9688708782196044921875), SC_(0.6154686047116787719559622378479139814024426952490381935800680865559287480782818998932711135539074658), SC_(0.1603960183186808603382774720227677448961058957890436785249090234242132064224075206303400541103053516e-4) }}, 
      {{ SC_(0.351158559322357177734375), SC_(2964.95703125), SC_(0.632396042346954345703125), SC_(0.7761429096227264653334739606310787715871212841177922036443340124848468571526942651587426264669584998e-4), SC_(0.1450075189246335661532905141365529750942025452476921840942295865016682220929135802047217774345864959e-4) }}, 
      {{ SC_(0.35431468486785888671875), SC_(0.411117613315582275390625), SC_(0.221111953258514404296875), SC_(0.05148248753105453292518516846799614130000474317506570221937918557302143632193440137752236672669183114), SC_(0.8921305656898779486519468845618169855895562661613347446848380830493742684778498106714230568524807617) }}, 
      {{ SC_(0.355726778507232666015625), SC_(49.3067169189453125), SC_(0.9688708782196044921875), SC_(0.0382468156409589884983535608344672235565834232181987996169319039105496222277565391878291445726267265), SC_(0.8561509233179379987503679456058136256819968991511450118021071374273155017018331282354269967923780426e-6) }}, 
      {{ SC_(0.357777118682861328125), SC_(0.047988586127758026123046875), SC_(0.9688708782196044921875), SC_(0.9999999999999999999999999999996530892664831199600005889137739458341493286545827466165950824821229019), SC_(0.02219260699886360296089220503974713186446740328897213143241306415305807727257967445484438793436180883) }}, 
      {{ SC_(0.358220756053924560546875), SC_(48.59809112548828125), SC_(0.905801355838775634765625), SC_(0.02198717482047037731640592820186482538724581359071094820991619955911234821486264409810795598495153801), SC_(0.2049871029606495277530251946497596398447144315282884629047306024076684880032229195576056616004782328e-4) }}, 
      {{ SC_(0.3589245975017547607421875), SC_(177.3041534423828125), SC_(0.1355634629726409912109375), SC_(0.1564556268439009603763137978399292069231253509422644356635921378784449034168591260404616020333706021e-4), SC_(0.004630980515581044782162562034964477328546278311093692995331376170595529008759416703481510654131121827) }}, 
      {{ SC_(0.35904705524444580078125), SC_(0.473808765411376953125), SC_(0.12707412242889404296875), SC_(0.009377404894940203255265409514970328362697357733711055961190542511188563188283452568957996108000231967), SC_(0.9488519662462962621280324598951247122766394536330802202525878769985476430276871627588026436304881419) }}, 
      {{ SC_(0.3647778928279876708984375), SC_(3.6492011547088623046875), SC_(0.1355634629726409912109375), SC_(0.0009088965746468331250623343745580084875699627582950240079618749174500976502417219773974986770509300459), SC_(0.2205237197602555525253682295120520485192139386582029409924481550487076838613928634158683674436027163) }}, 
      {{ SC_(0.364803850650787353515625), SC_(1.8238222599029541015625), SC_(0.632396042346954345703125), SC_(0.1481974826794736143587433243642095182208098736269206959245473197941836536920531739877747271820474345), SC_(0.03114453678221222620724651617573673402747492041226606288192253572172445159265800506804264523655485562) }}, 
      {{ SC_(0.367133080959320068359375), SC_(0.2215300992247648537158966064453125e-4), SC_(0.221111953258514404296875), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.3685724437236785888671875), SC_(13019.9375), SC_(0.905801355838775634765625), SC_(0.8438725177644407595392566647682492079336680327593670206622694837698449854706174523609803777509596657e-4), SC_(0.9207125544916172237475922612819587659309013784496885135679521738861698542520254364367815462331203742e-7) }}, 
      {{ SC_(0.3701328337192535400390625), SC_(0.30404355129576288163661956787109375e-4), SC_(0.8350250720977783203125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.37160670757293701171875), SC_(0.10332970321178436279296875), SC_(0.1355634629726409912109375), SC_(0.2115947089108716910511967502220451735113784644345792514121277662663380722185577889688354777459238881), SC_(0.9999999728760748297226236278934505399653179592000307055855690933604372158563205419787406582954619146) }}, 
      {{ SC_(0.373345315456390380859375), SC_(0.0465487875044345855712890625), SC_(0.8350250720977783203125), SC_(0.9999999999999998803391305480957180415892431095395989495800109204056179980962867410824967133731711152), SC_(0.8530305850785609967700788915487020763215737661161203241352387262982551422686246091551882347087517157) }}, 
      {{ SC_(0.375118434429168701171875), SC_(448846.15625), SC_(0.913384497165679931640625), SC_(0.2620288568991065152891878580060956395252585288836378203278596691744118148027496730862765442889908616e-5), SC_(0.239726054720757765133878906624133921489350718232709380084090898041187481481342200505706908752316404e-8) }}, 
      {{ SC_(0.37850654125213623046875), SC_(43846.46875), SC_(0.12707412242889404296875), SC_(0.718717701900941575729126175532280822701062476239784620582176738453099857202630762309863040379503539e-7), SC_(0.2072887669915794222807740851859953600789056289640475889382779530283024592468554114931139675557337361e-4) }}, 
      {{ SC_(0.3837126791477203369140625), SC_(0.3599123060703277587890625), SC_(0.81474220752716064453125), SC_(0.9622596347869636959927820153164466135310803132850172625953595988114397706777918142779209891332248932), SC_(0.05413959175362715294368681805089370270587030162321052029510594378044115920726211367662739725604428914) }}, 
      {{ SC_(0.3884186446666717529296875), SC_(178.5201263427734375), SC_(0.3082362115383148193359375), SC_(0.0002049351040524535924500526245135589801771172288833121021130673241043964660664070080600293503322926625), SC_(0.002051498471599523690596500433973310001136545362202233419886186374265254218589504695471705157526988364) }}, 
      {{ SC_(0.3887031972408294677734375), SC_(0.00263000768609344959259033203125), SC_(0.1355634629726409912109375), SC_(0.9999999999999999999999930955272684116390782402189829863744751436096276657323913089089785706869447143), SC_(1.0) }}, 
      {{ SC_(0.3953707516193389892578125), SC_(0.0040236986242234706878662109375), SC_(0.905801355838775634765625), SC_(1.0), SC_(0.9999999998440505046747544439551517056523365554757195970172692612880844966510948213928241062502766206) }}, 
      {{ SC_(0.3965031802654266357421875), SC_(11295.04296875), SC_(0.913384497165679931640625), SC_(0.0001087614812791005528413721254066329874038642265035237105582264014010254420330554544582274790285249046), SC_(0.1372143255190546374937396675236840374362199872259800984451059630374660460420723233503593932835866697e-6) }}, 
      {{ SC_(0.401973307132720947265625), SC_(467754.28125), SC_(0.81474220752716064453125), SC_(0.1495555284477043093110339412405782845265490875650605421698602249627007512381108649433038524592421102e-5), SC_(0.2412910221219984911510475726252097910899016669591849309440546139042055458780531666155865948515899998e-7) }}, 
      {{ SC_(0.4054018557071685791015625), SC_(1848.73486328125), SC_(0.3082362115383148193359375), SC_(0.2274361845613614064725413697622095227783848428821764711462766053078628716869831905710471847051622206e-4), SC_(0.000210629973591353616897072991054129025326733119000878439587679300729746938553937680148815320393623596) }}, 
      {{ SC_(0.4062000215053558349609375), SC_(0.0105956681072711944580078125), SC_(0.1355634629726409912109375), SC_(0.9999927707348406996432168909276264412552970483647983503430098367320009728018737467624148360501367626), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999999991618862592822851349) }}, 
      {{ SC_(0.4080638885498046875), SC_(0.0004883776418864727020263671875), SC_(0.81474220752716064453125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.4081141948699951171875), SC_(3.8330304622650146484375), SC_(0.221111953258514404296875), SC_(0.005261195830160613084211198223501084487249964579656078425492997759285236820760461358332861621864160851), SC_(0.154277007907432777966132773389854609518921074553799817811262413783579045296165271552997068224812911) }}, 
      {{ SC_(0.4087921679019927978515625), SC_(2638.619140625), SC_(0.81474220752716064453125), SC_(0.000269926481589751439535620366015402708637941613373844018754509890412176005239628168396174465896062777), SC_(0.4609129884163991704952988419893220292813062743846353212300648137174058489490215258644108307680889379e-5) }}, 
      {{ SC_(0.412207901477813720703125), SC_(0.2795807449729181826114654541015625e-4), SC_(0.81474220752716064453125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.4138956964015960693359375), SC_(0.0001860436168499290943145751953125), SC_(0.905801355838775634765625), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.433166682720184326171875), SC_(1.27705013751983642578125), SC_(0.905801355838775634765625), SC_(0.696519859006183793898470431876930663342291196425173724240358814471266669121542796258735779247818369), SC_(0.003162113604931681959899536870059023099243698851628822893816178722097632729890091008897672135641101386) }}, 
      {{ SC_(0.436771690845489501953125), SC_(1.04477035999298095703125), SC_(0.8350250720977783203125), SC_(0.6424650684007458288239938553729980069040422551753603991363742622678379230096718929378140195952749616), SC_(0.01529273363649364326725676524757446994955120230935064121839193221412092349210631474098199106412238969) }}, 
      {{ SC_(0.4377568662166595458984375), SC_(0.4160407115705311298370361328125e-4), SC_(0.3082362115383148193359375), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.444455921649932861328125), SC_(49022.46484375), SC_(0.632396042346954345703125), SC_(0.6927906992433522291016428433865362611161154159778103291408828578877988998944104254399789815979171429e-5), SC_(0.1731341778819023368951747139463564960248346504696620406290575766263776118701907292224265019961037221e-5) }}, 
      {{ SC_(0.447976410388946533203125), SC_(44.28264617919921875), SC_(0.221111953258514404296875), SC_(0.0006076460692261756814212492049591611909071489847078118919346897578738211417146103989246831430591323871), SC_(0.01493839908368976489498756194213370833411368740038276568721188775137832267988926012725995008099978244) }}, 
      {{ SC_(0.466396510601043701171875), SC_(0.000362085294909775257110595703125), SC_(0.12707412242889404296875), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(0.4669697284698486328125), SC_(0.004207052290439605712890625), SC_(0.9688708782196044921875), SC_(1.0), SC_(0.9974388693525674785737447191194264033432797680767940630804967193144787579269440818407068611746370907) }}, 
      {{ SC_(0.4731414318084716796875), SC_(4038.0458984375), SC_(0.8350250720977783203125), SC_(0.0002263436931985470623069554025901404750137366171451385477600503843294375224362071079580256662979642441), SC_(0.4300281102683826444303604298029173405210671918751202334751072622552987792446391018117289069062384341e-5) }}, 
      {{ SC_(0.4759317934513092041015625), SC_(18.6855449676513671875), SC_(0.8350250720977783203125), SC_(0.04866425753455599722081302948914309644620582599377254067883049520377574463635937751949282771277965168), SC_(0.0009649708262076704138158712614334072920940091172348759431605867723015569200232143254680295361962399698) }}, 
      {{ SC_(0.4780696332454681396484375), SC_(0.110383547842502593994140625), SC_(0.3082362115383148193359375), SC_(0.8745823795318758727968498863456703423009277605198028183788186129467687534970086892695532104900536248), SC_(0.9999119471506884567039816810340058478691314891400179254883209290110571435395075225190754083303153205) }}, 
      {{ SC_(0.489096343517303466796875), SC_(2428.257080078125), SC_(0.905801355838775634765625), SC_(0.0005668629859694813305378237557881070012593949895014536283487020623443953312224667955979425461593947559), SC_(0.2578500345693018997470272177777342176021446288432542126725574187171754818059149225529562996867491401e-5) }}, 
      {{ SC_(0.497481822967529296875), SC_(481.03790283203125), SC_(0.81474220752716064453125), SC_(0.001814148600754966551225040447711944447601894773640778015933908809229651699160796749858081480398887359), SC_(0.5603274097937640221400089900764948771553105798886687657379667098851587331651995859513992740762546886e-4) }}, 
      {{ SC_(1.00208950042724609375), SC_(1.134289264678955078125), SC_(0.913384497165679931640625), SC_(0.8845058781875564074697302557380234740598125360929172403026002410077118885477413333744400751666617372), SC_(0.07716705003114625608439129146308170510006784245482985741623226223088418443102782050334493090592350408) }}, 
      {{ SC_(1.06793177127838134765625), SC_(2593.565185546875), SC_(0.632396042346954345703125), SC_(0.0004164556117307835210059185117795125181331209167944909619269597035175679815783019314494579947944788868), SC_(0.0001969304816715304089356781627715840251498294317337799705781501983839477070325565001874516687928265681) }}, 
      {{ SC_(1.078310489654541015625), SC_(0.1611862899153493344783782958984375e-4), SC_(0.81474220752716064453125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(1.127964019775390625), SC_(28082.556640625), SC_(0.221111953258514404296875), SC_(0.1140591428062236314344782699995200947558508419914684786558012566166813744111564518342257595551928733e-4), SC_(0.6020566369424779976193598625809266203700130333890591994354679340172145079426581762927230954057229954e-4) }}, 
      {{ SC_(1.17060959339141845703125), SC_(374486.4375), SC_(0.221111953258514404296875), SC_(0.9205823762114880947670615545461770460060215826660405081365680512427786986296076678933990356753966741e-6), SC_(0.4674515653529951266664582896115453218297995443858733617196285486259742083016337936616390501189120662e-5) }}, 
      {{ SC_(1.1981303691864013671875), SC_(18840.236328125), SC_(0.81474220752716064453125), SC_(0.0001050853118774130372970668119071924296718548351327174487654751498986815417960205337285815348993283949), SC_(0.1611492201881255954767223873465552626610902482480651985362822593455937397211838607652504380380452816e-4) }}, 
      {{ SC_(1.2198965549468994140625), SC_(0.1385947167873382568359375), SC_(0.9688708782196044921875), SC_(0.9999999999899354070030649646048074812208880438597388773641322826847898039401345111255495466567011383), SC_(0.2938943213472305928216615905834280751246908103082346989701493932560513546866934909358618049891918352) }}, 
      {{ SC_(1.3339312076568603515625), SC_(327.5166015625), SC_(0.632396042346954345703125), SC_(0.004230465120837725941357601386231723928623325683651805279580720548971156732208563472830826734030664907), SC_(0.00220523359099786453043417328371775616377702898884544893736926530489301789958184029874442514138794833) }}, 
      {{ SC_(1.359802722930908203125), SC_(0.39465808868408203125), SC_(0.1355634629726409912109375), SC_(0.4437610966324638266826269825329555041588111492031747890397297218047030642421213130898621023983155023), SC_(0.995695817244306663097141367067913010257010325506779807518635619519745547979907341193297399087581953) }}, 
      {{ SC_(1.44682300090789794921875), SC_(0.17606438696384429931640625), SC_(0.221111953258514404296875), SC_(0.8458909669463521270960790298511605033325681625858584173422024844283208562765121975009790802637551565), SC_(0.999886336553159937346534850462277774995269727773185062985749407699151057520235200500421637129363372) }}, 
      {{ SC_(1.4834382534027099609375), SC_(1159.6116943359375), SC_(0.81474220752716064453125), SC_(0.002056807228369121237051091327627167224204263263316604574879812488292130937014494488012091946138749675), SC_(0.0003986065697168516904822900730941602055330996809471804237598028281091208000550310668475736553209310869) }}, 
      {{ SC_(1.49233496189117431640625), SC_(47973.6953125), SC_(0.913384497165679931640625), SC_(0.6830391976206895749556190775664300541457556915007650984618980145694353042492690714661229976875621645e-4), SC_(0.5406095207835446964362591371247893707386615748123698294385105952156822130447040921033281143418019975e-5) }}, 
      {{ SC_(1.54517018795013427734375), SC_(0.2047308981418609619140625), SC_(0.3082362115383148193359375), SC_(0.9040947213722921804188836344319104600957539998086103020945461418635843320568947055940903989910617216), SC_(0.9982290100229550815743015045337967893318357995402282689212918693624690152002795276639131504156674276) }}, 
      {{ SC_(1.5860595703125), SC_(268341.4375), SC_(0.12707412242889404296875), SC_(0.1465801574305476676539107209127776489766435472484594041230471696092317881774619276472003893770049005e-5), SC_(0.1110596740346227909528996593925982916576259005874750622985858526680224955126142907594515030069493142e-4) }}, 
      {{ SC_(1.5904328823089599609375), SC_(0.175132334232330322265625), SC_(0.913384497165679931640625), SC_(0.9999995447828679632723491974215900293768347156881864457001368345017648872246539288993224663169784807), SC_(0.6102658559543549792854219552398619751315702233232904385864644929795171168343057554405036764095827976) }}, 
      {{ SC_(1.61900937557220458984375), SC_(0.0355711281299591064453125), SC_(0.3082362115383148193359375), SC_(0.9999843556908109189924615361586702279026850095680063266208973711277140628696010749549257955304624426), SC_(0.9999999999999978879018481008599349797358705592880094084240033806448847332616189062796813720455293353) }}, 
      {{ SC_(1.6690142154693603515625), SC_(0.0045049847103655338287353515625), SC_(0.905801355838775634765625), SC_(1.0), SC_(0.999999999864263459222067874893621398109398254371437950436437576622059884560935650235737967090195376) }}, 
      {{ SC_(1.7562887668609619140625), SC_(374293.53125), SC_(0.1355634629726409912109375), SC_(0.1345250795183939169158118052974012003414175703788538762476672182935087694157008351312706026743333818e-5), SC_(0.8424789970376191199225424437051400627396586084028313139851628235260443384808951011555728879160486241e-5) }}, 
      {{ SC_(1.75884163379669189453125), SC_(0.369454860687255859375), SC_(0.8350250720977783203125), SC_(0.99621186464621633317859269092479516441799599828043494732987046390274930149129297134676593305349138), SC_(0.6174635084621955977997095346260852044937218341843690428616022442407999406336063502259646869385554335) }}, 
      {{ SC_(1.77004158496856689453125), SC_(49033.26953125), SC_(0.905801355838775634765625), SC_(0.7373675197413518903321678136500580762884458516442690941561338341861708795178825963717048392924068813e-4), SC_(0.8167629729235056937883553926045648341277856539241584268080565616747108507271439938553795639768719821e-5) }}, 
      {{ SC_(1.788215160369873046875), SC_(0.12965712812729179859161376953125e-4), SC_(0.9688708782196044921875), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(1.799451351165771484375), SC_(0.04982374608516693115234375), SC_(0.632396042346954345703125), SC_(0.9999999991832813507277292501077628783103657201917504957719290073627939354499972401136516642560939332), SC_(0.9999562542565086168949831312920333006932296705038591691423220935228448531979576631078675186931118502) }}, 
      {{ SC_(1.82197666168212890625), SC_(39458.8984375), SC_(0.9688708782196044921875), SC_(0.0001268574762160861115294921102913218341342810867460431110586484137363151627172616176651494267109218034), SC_(0.5460528472751130629371075897146399405773288824061641086977008300470195398332045068166565942771305106e-5) }}, 
      {{ SC_(1.837620258331298828125), SC_(3435.755859375), SC_(0.9688708782196044921875), SC_(0.001463695112375803803609727426442459308280253287293296055043913739196412145946668215474377786443495928), SC_(0.6411412176334436519737994561294870853645934280907944523858776304592672244006701391448928008926147062e-4) }}, 
      {{ SC_(1.86407566070556640625), SC_(0.000142144519486464560031890869140625), SC_(0.9688708782196044921875), SC_(1.0), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999034) }}, 
      {{ SC_(1.911371707916259765625), SC_(16.85260009765625), SC_(0.81474220752716064453125), SC_(0.1581159880008025721657321095854087061072555110449395192222109876064000275133299613105511501777259932), SC_(0.04109502640263896427688390556442590151994045918003648515226625447679875855620292680634369508954912126) }}, 
      {{ SC_(1.98693811893463134765625), SC_(298.79779052734375), SC_(0.221111953258514404296875), SC_(0.002913811445175273866084567639903064432733149318517862844914718617354576662471482505273645309811588141), SC_(0.009453423850870597093899017173160896828730965837768246817990046476376032610813536035940230028864964202) }}, 
      {{ SC_(2.081081867218017578125), SC_(0.171459905686788260936737060546875e-4), SC_(0.913384497165679931640625), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(2.1274673938751220703125), SC_(497909.9375), SC_(0.632396042346954345703125), SC_(0.460019634915205643970658678128087601607017882471903538266891079187315009631220516426696706980555205e-5), SC_(0.2800781052000278366315326737128600427349567293726611672233125423456618645562734278503815084715754891e-5) }}, 
      {{ SC_(2.274096965789794921875), SC_(0.0312146879732608795166015625), SC_(0.9688708782196044921875), SC_(0.9999999999999999999999999999999999999999999999998305906078338914578306219418153680347087173207692145), SC_(0.8635955452674145951317207009503193380459344162552204126575956657847421344385034722156743991964976376) }}, 
      {{ SC_(2.31026172637939453125), SC_(0.00233163125813007354736328125), SC_(0.221111953258514404296875), SC_(0.9999999999999999999999999999999999999999999999912456920129085491853277633793282155875032168873383006), SC_(1.0) }}, 
      {{ SC_(2.323431491851806640625), SC_(0.489291487610898911952972412109375e-4), SC_(0.8350250720977783203125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(2.44964599609375), SC_(12697.8740234375), SC_(0.632396042346954345703125), SC_(0.000208692856724679874555720331126775037887515680584457714689731776327333603733250052562364723031732801), SC_(0.0001319735340131210998408699505292715033953530561761954188411984482106450299800162565164445428189284356) }}, 
      {{ SC_(2.509582042694091796875), SC_(0.00033403583802282810211181640625), SC_(0.913384497165679931640625), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(2.564732074737548828125), SC_(0.000453212647698819637298583984375), SC_(0.3082362115383148193359375), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(2.57882976531982421875), SC_(0.3226127228117547929286956787109375e-4), SC_(0.1355634629726409912109375), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(2.5871660709381103515625), SC_(0.00046129638212732970714569091796875), SC_(0.81474220752716064453125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(2.6278192996978759765625), SC_(0.03557576239109039306640625), SC_(0.81474220752716064453125), SC_(0.9999999999999999999993011554331814705865871753591297220648103182049529046334467004674759250214191631), SC_(0.9991568393405557147567496606444205483041193752839369921122855950134127319392869298093838026538647882) }}, 
      {{ SC_(2.69723796844482421875), SC_(0.353506766259670257568359375e-4), SC_(0.905801355838775634765625), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(2.71968555450439453125), SC_(0.00041439200867898762226104736328125), SC_(0.1355634629726409912109375), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(2.754580020904541015625), SC_(0.0048456829972565174102783203125), SC_(0.632396042346954345703125), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999999999994966122847), SC_(0.9999999999999999999999999999999999999999978896734204565987555008202369634840299153638975065573923158) }}, 
      {{ SC_(2.769221782684326171875), SC_(0.366566746379248797893524169921875e-4), SC_(0.632396042346954345703125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(2.780732631683349609375), SC_(495953.28125), SC_(0.9688708782196044921875), SC_(0.1328760569137212732826683461584248053277423967755477221817299712143908594335598843653064718590142985e-4), SC_(0.1163536053249328979861723676621772216108872893118952428233105298118354574732022329149779866269192342e-5) }}, 
      {{ SC_(2.91809368133544921875), SC_(21.43137359619140625), SC_(0.3082362115383148193359375), SC_(0.08041217621139129745388982865942372908427332725282283279913368567509622265582208492706269485152926139), SC_(0.1439051628916274056884574818904327618894929223847986063526418335456810513302691803417126823137113327) }}, 
      {{ SC_(2.9371860027313232421875), SC_(2652.859619140625), SC_(0.905801355838775634765625), SC_(0.002002833591022518844164132966125807759052076409878083728645392945442781736824674136057400958127327017), SC_(0.0003900012251788526990830379600227225843995517056794422346396363919479396652641753884859333783544802793) }}, 
      {{ SC_(2.958280086517333984375), SC_(35774.58984375), SC_(0.8350250720977783203125), SC_(0.0001264482084667120638927081870570693927491610101542839477969626202722082459569072977754393501226927793), SC_(0.3813814577286534870950728607388973512947989261199900641452650157875256318590108126859850899724378359e-4) }}, 
      {{ SC_(2.98002338409423828125), SC_(0.1707812249660491943359375), SC_(0.905801355838775634765625), SC_(0.9999997564563190841949591666422939328988465733524883397554921191007961484669974001603856496624680006), SC_(0.8101430188720108023155814594683341942343254297299498960434520219489513134225054335462799914029094005) }}, 
      {{ SC_(2.98070812225341796875), SC_(0.2840107381343841552734375), SC_(0.81474220752716064453125), SC_(0.9993079463365542288238659467553309060670387514881374965877578091219818301113038573234053438711202266), SC_(0.8368196360585711292367217971010575508416694366517452090130637588013079393237631849165200056909329257) }}, 
      {{ SC_(2.99237728118896484375), SC_(13.7659931182861328125), SC_(0.8350250720977783203125), SC_(0.2668996278531875681011052847035990308819205966278328658682443286287869009676993280354016095704321167), SC_(0.08993513156273689590102146755133033175699063642350153844766793362839217023237322863917937219832834484) }}, 
      {{ SC_(2.9964640140533447265625), SC_(235220.21875), SC_(0.905801355838775634765625), SC_(0.2297201919248594326255779324268469595196046863323950796370646136197506740405377207328335130286530145e-4), SC_(0.4552404404549014763771060229869624065307686611954259272876474105259691057499325718260236235901830495e-5) }}, 
      {{ SC_(3.0576937198638916015625), SC_(0.03248409926891326904296875), SC_(0.12707412242889404296875), SC_(0.9965844026440237139401351951924641866178335811550625469419434377544927630676047411994788388626548569), SC_(0.9999999999999999999999999999415862135758341575921803509509796465442468111635593252605082171648687263) }}, 
      {{ SC_(3.1107203960418701171875), SC_(10.69952869415283203125), SC_(0.221111953258514404296875), SC_(0.135263069734440840721830009196120092918497118452185704042634359124836478194054985680578240528176975), SC_(0.3051024312119045474916115067098094412410832046258295187673826850829472203618815992547654132758046805) }}, 
      {{ SC_(3.1362564563751220703125), SC_(0.412800610065460205078125), SC_(0.12707412242889404296875), SC_(0.7093045141745812561031375363774058379457726411641919011797792690314983137060361476223153390913626471), SC_(0.9982272953803303358498116326420863735046104198215420799743861526819584914853596458381098470710602851) }}, 
      {{ SC_(3.143204212188720703125), SC_(245166.296875), SC_(0.913384497165679931640625), SC_(0.2337272872445519280515553112502576860342125217060840477571580357179559567871923855420366719673795095e-4), SC_(0.4564319908110801436633977445193748259739023745456709506049981833642263121134536450365786626045457728e-5) }}, 
      {{ SC_(3.1543867588043212890625), SC_(274237.21875), SC_(0.81474220752716064453125), SC_(0.1675492249876956076058494331042094118219773837365114279610494928741304328287837552716175242886854264e-4), SC_(0.5794054893865354808853388640148542082068009627957080956341540936614934193287416394828586493273199362e-5) }}, 
      {{ SC_(3.2091653347015380859375), SC_(12216.2568359375), SC_(0.12707412242889404296875), SC_(0.0001119626800023018988799537702734482313283415673684054669047485357488952476744293412374372661254976839), SC_(0.0004297682726515163735033810959764176730644789673218874343271657118560329432524912830077953304686016802) }}, 
      {{ SC_(3.24223804473876953125), SC_(1.68130600452423095703125), SC_(0.1355634629726409912109375), SC_(0.4229675431189993381450431035012671224162538776182654614566273353827141477533480293375631822826315622), SC_(0.8780017941012195483118384904075595913469590552497558577892286013741803835330546335591273295176158941) }}, 
      {{ SC_(3.2986447811126708984375), SC_(18.05455780029296875), SC_(0.913384497165679931640625), SC_(0.2669398577756162061178154612651788783824369903704039147382676355790812003419327210711418674120098536), SC_(0.06130295581967932394032726752160041388551292412170319761303663047647043023422709623034460302559699201) }}, 
      {{ SC_(3.3203613758087158203125), SC_(4707.14794921875), SC_(0.3082362115383148193359375), SC_(0.0004705461533889722135213591010627557576662872447897250495446286999555472739811562754388303481667388853), SC_(0.000835794665212889598129929700117428090345043027148372655202756547989946580085472597719043333152729154) }}, 
      {{ SC_(3.3257858753204345703125), SC_(3224.86181640625), SC_(0.1355634629726409912109375), SC_(0.0004610270441942790478429095860965936228257605345980239305816895606496609341767444500766254431661479988), SC_(0.001643662188977531929162978476610616636032156337804061203807180241671931657653185736382446205832550668) }}, 
      {{ SC_(3.331163883209228515625), SC_(1.9793136119842529296875), SC_(0.632396042346954345703125), SC_(0.7150071056629390174684732478208555306990777925379365398869128441805229918605311576323749943093364252), SC_(0.5689457521621854854195457899271162206983916078197963304375435799054029765389692467773855205872235514) }}, 
      {{ SC_(3.3439481258392333984375), SC_(334.433685302734375), SC_(0.1355634629726409912109375), SC_(0.004459721392212591387549156002824227520915758978326453609433132490851465252269200860041246077660459348), SC_(0.01575861700002204634272809540659948140564437176075437396554824405020886824553767849592894934459431347) }}, 
      {{ SC_(3.35210418701171875), SC_(0.0159323550760746002197265625), SC_(0.221111953258514404296875), SC_(0.9999999694638908304234083649438781443999705775520972990949385140725078784523625394851923105199475546), SC_(0.9999999999999999999999999999999999999999985519881973799143714860850272813704341374810601564390296407) }}, 
      {{ SC_(3.4502658843994140625), SC_(41.324951171875), SC_(0.12707412242889404296875), SC_(0.03533310771113411649137077606459205376365739582735749517646595258214984972708802478329326566419692959), SC_(0.1227997495891754139979015012689300191604719676364456612991162379845991018996321328980780812986540927) }}, 
      {{ SC_(3.45885372161865234375), SC_(29400.57421875), SC_(0.3082362115383148193359375), SC_(0.7939058874384343517986706694899412492015434995670291644766537477527271832285431222032845579001652639e-4), SC_(0.0001392669810329539197145663263381421405604696767077810527724129614270433521756276322661613231364326161) }}, 
      {{ SC_(3.5038392543792724609375), SC_(174.0391998291015625), SC_(0.81474220752716064453125), SC_(0.02831190811625148950629811738293090856905941482117483315983218294091214019414185694265444887579109466), SC_(0.01048576438126214419001568345089109473466189530208577936768746038776417079494581944826671082827560704) }}, 
      {{ SC_(3.519533634185791015625), SC_(43931.828125), SC_(0.1355634629726409912109375), SC_(0.3689578019714655501916986172160204255229570055685352150843811582865623907369965110121962134565184281e-4), SC_(0.0001265684216749623936927467504825319622653369844430810535577496583922263350961513388802214283792501461) }}, 
      {{ SC_(3.5407917499542236328125), SC_(192506.5), SC_(0.3082362115383148193359375), SC_(0.1249054040574437764812702474306916416986922584837581533520981622892594091069752524062037713606658788e-4), SC_(0.2175661363331754392799596575674735374150936113351543733088803746314541735794191869864118905695857851e-4) }}, 
      {{ SC_(3.643778324127197265625), SC_(460.66265869140625), SC_(0.8350250720977783203125), SC_(0.01162617103807386204618395649485293986823655834151308009029079926417025828324366565780692328108631927), SC_(0.004008970520404531385255109345997826723323544810732748931856994066347265315087362519283893094864965538) }}, 
      {{ SC_(3.6656649112701416015625), SC_(336.389312744140625), SC_(0.3082362115383148193359375), SC_(0.007410093655934871777916126024695256797868123973058917004228736809384654715863865881468091545089237717), SC_(0.01274063047515304924197084427058707421057037573513813565201720697962057489383065575228878768285518682) }}, 
      {{ SC_(3.6850574016571044921875), SC_(0.0037575312890112400054931640625), SC_(0.3082362115383148193359375), SC_(0.9999999999999999999999999999999999999999999550055435000173603516327895909993916222286204315188219793), SC_(1.0) }}, 
      {{ SC_(3.7146091461181640625), SC_(0.280897915363311767578125), SC_(0.632396042346954345703125), SC_(0.994124276182570671056242134133127123782111536753903540705092278778171584109099694643312519012512262), SC_(0.9560957522419724251975916743497843169817850657365193438204010331639551739957664907058969066116727901) }}, 
      {{ SC_(3.7336635589599609375), SC_(0.477436915389262139797210693359375e-4), SC_(0.221111953258514404296875), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(3.78065204620361328125), SC_(397517.0625), SC_(0.8350250720977783203125), SC_(0.1402573777599055124924158524253963663502797113818557117270184748387977184890983897103708611724924904e-4), SC_(0.4921498677015718869167446420931528221529013178148524471034212529290727375014124622096914910219864207e-5) }}, 
      {{ SC_(3.7866687774658203125), SC_(4.32257175445556640625), SC_(0.3082362115383148193359375), SC_(0.3752043963463212774669972976072432879928314818162278490533815627038082048494665857805481152643552336), SC_(0.5546074716576205788384672530343779402020121707771185014839296369586831454987793762134325285047848293) }}, 
      {{ SC_(3.81618976593017578125), SC_(0.30148139558150433003902435302734375e-4), SC_(0.3082362115383148193359375), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(3.9190075397491455078125), SC_(109.78485107421875), SC_(0.905801355838775634765625), SC_(0.05818137499888512731199262311335688221850363117567557405469895272524357817093870024092711712784297137), SC_(0.01475411130262191377259158346498613697438260756412598296481374349377615853556150344809653282457612583) }}, 
      {{ SC_(3.9453601837158203125), SC_(0.42322339140810072422027587890625e-4), SC_(0.12707412242889404296875), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(3.9545612335205078125), SC_(420.351806640625), SC_(0.12707412242889404296875), SC_(0.004443184595901805573106246367436792044916738912937875326762847620059994348887387655697173243400587628), SC_(0.01466509741146044593090570964776299501171009836882730681260908946465950059588245695793189050619783112) }}, 
      {{ SC_(3.994822978973388671875), SC_(0.02758073247969150543212890625), SC_(0.8350250720977783203125), SC_(0.9999999999999999999999999999931098987903787507581859231975364686387988234791959482359778270703687981), SC_(0.9997635174181014212493311832211529252788651863290971126131695694886514769633939249951379440245341559) }}, 
      {{ SC_(4.02030849456787109375), SC_(0.00037742473068647086620330810546875), SC_(0.905801355838775634765625), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(4.075417041778564453125), SC_(0.0046969656832516193389892578125), SC_(0.8350250720977783203125), SC_(1.0), SC_(0.9999999999999999966461360911776344448637690893981265442602290746899481432891677304255105802164823949) }}, 
      {{ SC_(4.0761165618896484375), SC_(3398.80859375), SC_(0.12707412242889404296875), SC_(0.0005774281549284668513504041516251273091444131290647558071176100779662792908498281180085815590896277301), SC_(0.00187728594647535991976462717642443037173717682490885708244530797173456316926372895466522517663753282) }}, 
      {{ SC_(4.076457500457763671875), SC_(0.000358947552740573883056640625), SC_(0.632396042346954345703125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(4.15985202789306640625), SC_(0.01332603581249713897705078125), SC_(0.913384497165679931640625), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999999970859055805903338665), SC_(0.999827771399310127624625627518389377963820902509851489763556753732737998120323549114602455553386564) }}, 
      {{ SC_(4.16162872314453125), SC_(0.0049612796865403652191162109375), SC_(0.12707412242889404296875), SC_(0.9999999999998054047735310904302531741056615997805813078425000080473978354671723108193475564544929739), SC_(1.0) }}, 
      {{ SC_(4.205390453338623046875), SC_(48.05587005615234375), SC_(0.632396042346954345703125), SC_(0.0880874600433708899405404613560881946794655246889395142256943513381182632164896166895782437521799585), SC_(0.06344312866068026399991054037675688346830646466316390963059397594638526710084149868878219891931067957) }}, 
      {{ SC_(4.2340564727783203125), SC_(0.000102389443782158195972442626953125), SC_(0.8350250720977783203125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(4.26158905029296875), SC_(1.5681400299072265625), SC_(0.81474220752716064453125), SC_(0.8930221335431818661894599337925977421493137587319208886373994158219626761334028449916074050856911158), SC_(0.5742893279140036665791717683878544190855034755565124371830942658846017705489384168457495825410154408) }}, 
      {{ SC_(4.286884784698486328125), SC_(0.00029798992909491062164306640625), SC_(0.12707412242889404296875), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(4.302335262298583984375), SC_(0.011135534383356571197509765625), SC_(0.905801355838775634765625), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999989088307), SC_(0.999979448998724399212293148879659381890444959240652775168788325406604322745793916612603484640881318) }}, 
      {{ SC_(4.33400249481201171875), SC_(0.0019063963554799556732177734375), SC_(0.81474220752716064453125), SC_(1.0), SC_(0.9999999999999999999999999999999999999999999999969048204608476914773554014990397567217038027970109533) }}, 
      {{ SC_(4.379422664642333984375), SC_(1518.1336669921875), SC_(0.913384497165679931640625), SC_(0.004869923984912166786102468927800013508789063595542371202939210873346949152234337197731863549873005929), SC_(0.001252311438651172531579755026509751178252007219494769513783106296333100184427911599029441558526314165) }}, 
      {{ SC_(4.3807125091552734375), SC_(40.12465667724609375), SC_(0.9688708782196044921875), SC_(0.1940583495804845720155510989664957983526418347054014024381116118844253135206193595660778108393072823), SC_(0.03234259344259383057173172600498581598153648167354662167473189916077555732882515950986625399200931335) }}, 
      {{ SC_(4.402850627899169921875), SC_(2.295498371124267578125), SC_(0.12707412242889404296875), SC_(0.4468963002575868323202001673614600025756934934849189377052761278834475001647615119995093616204487393), SC_(0.8544170484805286555011743102554138238380150575805848679237285814801323610815348158526897288186599822) }}, 
      {{ SC_(4.4479217529296875), SC_(0.0027269781567156314849853515625), SC_(0.913384497165679931640625), SC_(1.0), SC_(0.999999999999999470255365998244140582392523111779744462238505709967574253873302236770282088204688505) }}, 
      {{ SC_(4.45084285736083984375), SC_(3340.46728515625), SC_(0.8350250720977783203125), SC_(0.001916990152934278449218804560686690016107452130118837852841448210257175465453650985870674957072787346), SC_(0.0007353241039741081969769644489000336590454692832607850282709235705033329551323290967922846968136140186) }}, 
      {{ SC_(4.461754322052001953125), SC_(2.637157440185546875), SC_(0.9688708782196044921875), SC_(0.9060301894068220790891062311261691883942678518814080314388370756232219670242264180820670114838997658), SC_(0.2908171013276693365516382664527655737571592470655644735195922908710904946140104442591427445177047194) }}, 
      {{ SC_(4.516055583953857421875), SC_(1.62176787853240966796875), SC_(0.8350250720977783203125), SC_(0.9014818361757334469251672585816831942094008588123138523869016820282118498774225809140112219572614542), SC_(0.567137337487056192284034531480359572434683158264716149611917908105466064801672948638078690439175827) }}, 
      {{ SC_(4.537124156951904296875), SC_(0.043504618108272552490234375), SC_(0.1355634629726409912109375), SC_(0.994891557570639229708111241519989486910237516802063583044529419257011678348948307087377538655895795), SC_(0.9999999999999999999983914989777975903106413741869307097696147967382550101934445433063089862444580641) }}, 
      {{ SC_(4.55108356475830078125), SC_(0.00028587187989614903926849365234375), SC_(0.221111953258514404296875), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(4.56300830841064453125), SC_(205.750579833984375), SC_(0.913384497165679931640625), SC_(0.03625807704221101397682510932666619775464037832091349378355840937269375235209832797239184013185634279), SC_(0.009720822077064093274851813282079342482437543316530068365823770362834339721563583048195362994128191982) }}, 
      {{ SC_(4.60340976715087890625), SC_(20.9564685821533203125), SC_(0.905801355838775634765625), SC_(0.2841277065216559950271905956323889033901747795456017489791319391961164897777085282725130955097074557), SC_(0.08883724242506107795547042661149391384797364165160283984255453205471517712259217121829160187898030999) }}, 
      {{ SC_(4.71325206756591796875), SC_(1386.131103515625), SC_(0.221111953258514404296875), SC_(0.002141079347949870007522525057424298795510546117023931609383098586190329725812141622890709199891119502), SC_(0.004445864366466173003208194544276813193594581790536619787867646498671076722287888173109155654426308568) }}, 
      {{ SC_(4.7184352874755859375), SC_(1.0989363193511962890625), SC_(0.221111953258514404296875), SC_(0.707317939427190190968043361777120545835802458241181512314148656870051864820615324506863337291920052), SC_(0.9382165493203824990797159541848411579758141123224527139862881451652813919096294755907831203784711684) }}, 
      {{ SC_(4.79721546173095703125), SC_(0.001919968170113861560821533203125), SC_(0.1355634629726409912109375), SC_(0.9999999999999999999999999999999998542193045692748894632753663605964628044194699365854495887239512465), SC_(1.0) }}, 
      {{ SC_(4.9292125701904296875), SC_(413.006103515625), SC_(0.9688708782196044921875), SC_(0.02334574421112757433585372777733672485895892912295975318353328178485639957473832128065677442757311249), SC_(0.004046602163062999902759044186956465378017862124368986653051676437794054221491622387913826001175375954) }}, 
      {{ SC_(4.955646514892578125), SC_(2.21204280853271484375), SC_(0.905801355838775634765625), SC_(0.8933546014525428938186662562803984127659035863290198541691092368101570100206709606179731632334223322), SC_(0.4588407043101351511434170638540127741013382030860505433427025236211227676176337111687476863361559086) }}, 
      {{ SC_(4.95948886871337890625), SC_(0.0028835497796535491943359375), SC_(0.9688708782196044921875), SC_(1.0), SC_(0.9999978267466414320297230639673574896844269906223343831790598268953231615270855387212945106912393475) }}, 
      {{ SC_(4.95980072021484375), SC_(27.734874725341796875), SC_(0.1355634629726409912109375), SC_(0.08575225236565314522415114646836466240145731757542366540783151510085132813693461671794425689410370693), SC_(0.2209879941403962350244475670585516855503155307782705609187779839247485309119571416422820779315361365) }}, 
      {{ SC_(10.5313282012939453125), SC_(4949.1328125), SC_(0.81474220752716064453125), SC_(0.002686142481732706965704988857682381025637520384539031062795380975648182830129345773944313356526367634), SC_(0.001534555622997722767805542931616878026210248035131974887134563557399907150074985141621862969488232541) }}, 
      {{ SC_(11.0091266632080078125), SC_(0.01806267909705638885498046875), SC_(0.913384497165679931640625), SC_(0.9999999999999999999999999999999999999999999999999999999999991759387696639900832271210546834560530796), SC_(0.9996395664581205622872469923633278572991697290641636824321025593184851829319338095875187488973106511) }}, 
      {{ SC_(11.23558139801025390625), SC_(0.01205970533192157745361328125), SC_(0.1355634629726409912109375), SC_(0.9999997006097082315307478298804058327589536425610738221124726180202531317523687206475036790969822868), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999425910828495595116699341532) }}, 
      {{ SC_(11.8540496826171875), SC_(28582.3984375), SC_(0.905801355838775634765625), SC_(0.0005794368573253538519903337561124830547000305602782757004681623753728366924898954599872235451113889009), SC_(0.0002666541189256076578278089132824322501560314353569493700091667483160099229593799141684787350694686398) }}, 
      {{ SC_(12.08311557769775390625), SC_(0.000145281082950532436370849609375), SC_(0.905801355838775634765625), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(12.1501750946044921875), SC_(2569.097900390625), SC_(0.3082362115383148193359375), SC_(0.003947314265283763534130261769906570995556154082725838767714142728096796545453041539292418723318263244), SC_(0.00527631324911083642515636243154343204943734027149422161104707568873674245775018311697095379859261648) }}, 
      {{ SC_(12.16957950592041015625), SC_(0.2478319108486175537109375), SC_(0.632396042346954345703125), SC_(0.9989833939152605404820017605346903832588222232732099650281192011964241799958271657276527375408016281), SC_(0.9901969350412300746830303454446789584345955503367077735143123432831038761828727804007526572578708539) }}, 
      {{ SC_(12.2681884765625), SC_(31.347698211669921875), SC_(0.221111953258514404296875), SC_(0.2277027147482503127150296913972224007896043825317497502254385235842967636083267099784832543109561542), SC_(0.3321634681587807552007875100298756994660374595763156028971386074677812085187955268733357037189613391) }}, 
      {{ SC_(12.48180866241455078125), SC_(35551.12890625), SC_(0.81474220752716064453125), SC_(0.0004368576827667718467027161116485912321274546389947229836713586872425985223896130791672339500299463373), SC_(0.0002614229438549803342224613456667824883487110474085630520697804157838646658581086698818819709315184661) }}, 
      {{ SC_(12.5361804962158203125), SC_(0.0011118580587208271026611328125), SC_(0.1355634629726409912109375), SC_(0.9999999999999999999999999999999999999999999999999999999999415024426847849461098577106691388394939205), SC_(1.0) }}, 
      {{ SC_(12.85811328887939453125), SC_(1765.9459228515625), SC_(0.1355634629726409912109375), SC_(0.005084515792620766368154017278263048723764006331985079229849945220814864492955109313877302130922982567), SC_(0.00945094240444795408086586053613571535096016312921549386043297143118449105542842752216001577527707926) }}, 
      {{ SC_(13.23449611663818359375), SC_(385250.125), SC_(0.221111953258514404296875), SC_(0.2684206090177575202806497311501823196390064693359196712743753861382176264735178408204059858258560006e-4), SC_(0.4115838409201253856608252515384732822367348085127017584724222166062618532544131014694533738662619992e-4) }}, 
      {{ SC_(13.28284740447998046875), SC_(0.00048034972860477864742279052734375), SC_(0.1355634629726409912109375), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(13.5956668853759765625), SC_(153334.59375), SC_(0.1355634629726409912109375), SC_(0.6297308638298869060440428088111622962734002624865844395283432516042181984666939554328097987321434359e-4), SC_(0.0001152655326806725492693108593214106274722367121867112969536035061559994356520519027520659723433404668) }}, 
      {{ SC_(13.7348194122314453125), SC_(3484.218017578125), SC_(0.913384497165679931640625), SC_(0.005432379288960534105375864107652627534328394167857882646472035081610233740196644859320005656609912856), SC_(0.00258197843004596213892550161024638414317903043346706059004710337714981589708364724942695551542620364) }}, 
      {{ SC_(14.008861541748046875), SC_(2.686798095703125), SC_(0.9688708782196044921875), SC_(0.9644622542499765872821638355495793775111436667613767776377098982841046549385229166727625387729387154), SC_(0.6472241984016385522620389540582247470293854227267980354461338149541140156617163290589838788952657053) }}, 
      {{ SC_(14.066776275634765625), SC_(10778.09375), SC_(0.1355634629726409912109375), SC_(0.0009321184256471603036872441467162309507862125649224710023444800474774555861452509764168030193113800172), SC_(0.001687789433172683795187189064203571194955550954049045967869225873415216029951606311051464069013477185) }}, 
      {{ SC_(14.16046237945556640625), SC_(201.0361175537109375), SC_(0.1355634629726409912109375), SC_(0.04766799602155229035403944808044258904656877421775701044944497304486771170366178653867969060325189584), SC_(0.08451560061969932227379905604376448505965168861685054244104749264722057012450771156995396208612827573) }}, 
      {{ SC_(14.22837734222412109375), SC_(0.000125592589029110968112945556640625), SC_(0.221111953258514404296875), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(14.366168975830078125), SC_(236787.609375), SC_(0.8350250720977783203125), SC_(0.7600840593681305084069296115192037991394551886550105361041918570328823791111594348075174928927205939e-4), SC_(0.4518808095263781565205417112680880254125756158845253687482425708976145285305541338335608184238628531e-4) }}, 
      {{ SC_(14.726207733154296875), SC_(0.21476264297962188720703125), SC_(0.9688708782196044921875), SC_(0.999999995571119706748390836596933705104787069887220160010360219693754521044543231613353968460145251), SC_(0.9060060446572562067051327655887258833492007272752161121852030109812179366812822525661810432461676948) }}, 
      {{ SC_(14.9572906494140625), SC_(0.3900313095073215663433074951171875e-4), SC_(0.12707412242889404296875), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(15.357250213623046875), SC_(0.01863213069736957550048828125), SC_(0.12707412242889404296875), SC_(0.9999739388529974430711459662432089294755732241699513374709890721608182649829101482350052449464661195), SC_(0.9999999999999999999999999999999999999999999999999685431080352873599252909988834627227106682960722174) }}, 
      {{ SC_(15.364917755126953125), SC_(226.784942626953125), SC_(0.913384497165679931640625), SC_(0.08563696835052369478079789909258463947407294008500908276598717960448876794997957492186634957810234564), SC_(0.04332792402357449306342739304736647647019568182547055436378929388602672343782614833433106857615263862) }}, 
      {{ SC_(15.681644439697265625), SC_(0.00036581026506610214710235595703125), SC_(0.3082362115383148193359375), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(16.6584186553955078125), SC_(0.000170524624991230666637420654296875), SC_(0.632396042346954345703125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(17.026760101318359375), SC_(11.721271514892578125), SC_(0.81474220752716064453125), SC_(0.6747989591544321340862806920690054301518024342301211346889257938609261917426502336971980736873500048), SC_(0.5105297294944054604863619181552338843568586592913241320636454217849555560063062522140460532912007551) }}, 
      {{ SC_(17.084300994873046875), SC_(0.4187429845333099365234375), SC_(0.81474220752716064453125), SC_(0.9991963512770625763575236103943290975300885243709238460861486903618746060516238392059335107312435891), SC_(0.9574310523984230337446397725695448673178783683051392501709121630631963635113186789914294140891595251) }}, 
      {{ SC_(17.104099273681640625), SC_(0.0039452277123928070068359375), SC_(0.913384497165679931640625), SC_(1.0), SC_(0.9999999999963922341914190922196265836899897310812160921121941374348345328548516387889172192589238266) }}, 
      {{ SC_(17.1246776580810546875), SC_(44.7584991455078125), SC_(0.12707412242889404296875), SC_(0.2128755184474609548122009168308404786581390144550328248729847944771196861930199367732486100957628529), SC_(0.3420830695175494765205156663653431203920007113988531491413750911425447587730317710423688244024061047) }}, 
      {{ SC_(17.367763519287109375), SC_(211.8177642822265625), SC_(0.81474220752716064453125), SC_(0.09107662820311893304648687160374637650164095915645651723288674482794183261228764933997746108107315907), SC_(0.06000368686028256537594982015060731118399641027687527118364732370898455297767524436563684855809049378) }}, 
      {{ SC_(17.8663272857666015625), SC_(3551.811279296875), SC_(0.905801355838775634765625), SC_(0.006613418911304457306173187369164259698351325902453219072187298729887674252078234628388330044302524496), SC_(0.003531470352105413247357287763599727492810266524114772311405597117511875015273192716306608830389171223) }}, 
      {{ SC_(18.23902130126953125), SC_(0.387346590287052094936370849609375e-4), SC_(0.9688708782196044921875), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(18.3384532928466796875), SC_(0.4789576996699906885623931884765625e-4), SC_(0.81474220752716064453125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(18.3578662872314453125), SC_(44.260616302490234375), SC_(0.8350250720977783203125), SC_(0.3490057251077422416444444767107447853661025928113356132808944372095605581685059617586078196219577403), SC_(0.2371519547970952980941603528841351862460493552486107897209059849238966431987820382325042722384931507) }}, 
      {{ SC_(18.504062652587890625), SC_(410.696044921875), SC_(0.9688708782196044921875), SC_(0.06303465678479042321664959836745677241497772637888281271589908813965102155905347231862768545488330007), SC_(0.02669597926557915278174392435708393161838014395926925635544352490746276276005352899705775902235099875) }}, 
      {{ SC_(19.699462890625), SC_(1044.098388671875), SC_(0.221111953258514404296875), SC_(0.0152457512820509804557926939607426796555064716462045222206562503436557555635302637345771805568659174), SC_(0.02154455984297169364852960537380458257783244241955728011071492260050808764495198990846018404970572544) }}, 
      {{ SC_(20.811771392822265625), SC_(0.1686411633272655308246612548828125e-4), SC_(0.632396042346954345703125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(21.513973236083984375), SC_(1.2695052623748779296875), SC_(0.632396042346954345703125), SC_(0.9694744056089359088560198649521598118691707668820448785799986505966555533564856956618436373365148013), SC_(0.9410703433856380070917820341906353560822542177769326824866190771212063714598224727036953829303941223) }}, 
      {{ SC_(21.758922576904296875), SC_(208175.28125), SC_(0.9688708782196044921875), SC_(0.0001500466359235681042785211121547867514930398197857273496447417327446332948472197900080662686005054133), SC_(0.6687837735193438271222853271799154232170668315643389718387104703935801909715117518644850500025355354e-4) }}, 
      {{ SC_(21.821353912353515625), SC_(0.0424164198338985443115234375), SC_(0.632396042346954345703125), SC_(0.9999999999984569526680753522348732134527223794405508501127581568251642184717980578611028108827244775), SC_(0.9999994465885250543130767182581777302784806474702122330939663265431625938914603351830682770949892407) }}, 
      {{ SC_(21.8938732147216796875), SC_(12260.4462890625), SC_(0.632396042346954345703125), SC_(0.001886278525255599397942902160872446473544754079061675453685622268007122979099583736625641029207472592), SC_(0.001631060055831245901763051573675017119615409578441589820169729745075811661587259187169133687892522559) }}, 
      {{ SC_(21.929759979248046875), SC_(21858.861328125), SC_(0.8350250720977783203125), SC_(0.001208284064974422055583545233092297766883735883383924573775176789309825701618092190925110050209782334), SC_(0.0007946792239164184232055664779237285824694849937463396965418275403187061116095281031963800905820234102) }}, 
      {{ SC_(21.9974803924560546875), SC_(241.2039947509765625), SC_(0.905801355838775634765625), SC_(0.1066590214386868981069552249516453613324034561297450415850953695243375149328323233374569855036666908), SC_(0.06204051690645063658323371758957225227582839480990079279950015087734450886900420784989918815400289825) }}, 
      {{ SC_(22.052242279052734375), SC_(0.02685627527534961700439453125), SC_(0.3082362115383148193359375), SC_(0.9999999707735031783024153644551506990509971196878794681796980138387567488523889828208484401154924459), SC_(0.9999999999999999999975257488743170309159029934017184062771431656259786328411917304146236128348432542) }}, 
      {{ SC_(22.2946758270263671875), SC_(4700.37939453125), SC_(0.9688708782196044921875), SC_(0.006744819998768911082113699192391794823883103983351941725075896609950599618356914201893231324616409748), SC_(0.003041948296869511531901931904956940508867055906784239054395165109935073214136510403386271945191594783) }}, 
      {{ SC_(23.23316192626953125), SC_(0.13708417117595672607421875), SC_(0.905801355838775634765625), SC_(0.9999999991022416259443850235732902885092988330981298648318494742736933948849807006158040995246399171), SC_(0.9813796291391188704485860355106945299603228336929183358720861534071105614675352564565372832646213273) }}, 
      {{ SC_(23.2837123870849609375), SC_(33643.07421875), SC_(0.3082362115383148193359375), SC_(0.0006130328274102922900711308366980531620119282902618062137430882990138218132062391639072324821838554787), SC_(0.0007554012804612767182253284519542442306988419085709874202909276559594804095981345452579052273319107652) }}, 
      {{ SC_(23.31745147705078125), SC_(0.022672764956951141357421875), SC_(0.81474220752716064453125), SC_(0.9999999999999999999999999999999998730825024309490228256045590167177811363989325460301131258705733365), SC_(0.9999970193107604288613287959340264317543005419609700926717484423694228437082617567268605327470481068) }}, 
      {{ SC_(23.4339599609375), SC_(23.290653228759765625), SC_(0.632396042346954345703125), SC_(0.526408997421472500663240689968402450955016852665564692006063956605421855385549947230426360568085792), SC_(0.4766970424584372814897062539099098194074951655743193164378418946538028818423806663119140591581839947) }}, 
      {{ SC_(23.523906707763671875), SC_(363844.15625), SC_(0.913384497165679931640625), SC_(0.8347394594108981407457166338715220489151780580102033006281274065854910302557236798535919811676846616e-4), SC_(0.47388997866242602351512233004170067538970574364564182808876197323803471496156790282513440768509281e-4) }}, 
      {{ SC_(23.9151668548583984375), SC_(0.13243019580841064453125), SC_(0.221111953258514404296875), SC_(0.9956216868738135140724692421263886143991933225802155629655007835088769388795775909452117938069352284), SC_(0.9999997020562496462981483929134173750669772629325814279367124785988892398867012733427018809767038076) }}, 
      {{ SC_(24.385395050048828125), SC_(49.88166046142578125), SC_(0.1355634629726409912109375), SC_(0.2688341550369041026504224478548513009356684586170523692392794750251452139822997660303903543548976327), SC_(0.38854199533803636163748507873008026827044342550796681037204971822103441984296372978833645172556683) }}, 
      {{ SC_(25.94358062744140625), SC_(0.00362619315274059772491455078125), SC_(0.9688708782196044921875), SC_(1.0), SC_(0.9999963897001797301257614456823174268207772513229013190888553485565202426446131685812250726552888978) }}, 
      {{ SC_(26.580902099609375), SC_(2.500098705291748046875), SC_(0.81474220752716064453125), SC_(0.959795814670658177947873494741994484611914155593765860394924450828883293942598233581634208160657046), SC_(0.8715207849667045196920866123221515304442976338039779572524164670558639407483677560607858523292217254) }}, 
      {{ SC_(26.6811580657958984375), SC_(0.2598920036689378321170806884765625e-4), SC_(0.913384497165679931640625), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(27.668880462646484375), SC_(4626.693359375), SC_(0.632396042346954345703125), SC_(0.006260698039203155566049327102955568197912366677015184416346900192322512266576301275841424018660210963), SC_(0.005503677219655494734910471152344319975691214925407511238363625689672570879352896234552763837166670146) }}, 
      {{ SC_(27.841068267822265625), SC_(0.23176459968090057373046875), SC_(0.3082362115383148193359375), SC_(0.9944254480357241743488545430761140155498142148744462577782829804199010780266863754512170802197065478), SC_(0.999848142628309691160971204336161068044297944329597448305776043905416354876236980643803102544827675) }}, 
      {{ SC_(28.242305755615234375), SC_(45229.91796875), SC_(0.12707412242889404296875), SC_(0.0004931283014917675585300503067818782399815590227382773176913912671258477231135906384632850543714017116), SC_(0.0007593478802736354689750069930283228585029005121713994073411411472903871530674280289247324161614394997) }}, 
      {{ SC_(28.593597412109375), SC_(4.394314289093017578125), SC_(0.8350250720977783203125), SC_(0.9232612092714078185899343635654892522866616104868588806880147198465327527052173109350313876412839503), SC_(0.8107595802060556057355895596566021497382922653831685172802867720912912087541743814553658091400668833) }}, 
      {{ SC_(28.682727813720703125), SC_(0.0453636646270751953125), SC_(0.8350250720977783203125), SC_(0.999999999999999999884249635148540416467210764419532099849779315412940228603850720628436355760028545), SC_(0.9996080283210721346607198315602243646900414900387764772430050420350721097703141747603747611007034993) }}, 
      {{ SC_(28.738727569580078125), SC_(27.254573822021484375), SC_(0.9688708782196044921875), SC_(0.6360187936637276683076646198670267245358483951666700455693669545329222198713164494659646821191328767), SC_(0.3897030877187323283350455614637945822213025857231459180758977820688909179454636721282083699987864509) }}, 
      {{ SC_(29.614292144775390625), SC_(0.435002657468430697917938232421875e-4), SC_(0.1355634629726409912109375), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(30.21712493896484375), SC_(47917.328125), SC_(0.913384497165679931640625), SC_(0.0007914906355404200479586389534821251002403357828447798159506945117502013133464159872952347160480805488), SC_(0.0004807909336809068780299398518375606694373597433399463542918850653336184689410163896485309994904454226) }}, 
      {{ SC_(30.5350971221923828125), SC_(0.0039173173718154430389404296875), SC_(0.905801355838775634765625), SC_(1.0), SC_(0.9999999999997983708067378271703172349768314214673797191048023255552533891322338545810892993797782524) }}, 
      {{ SC_(30.87542724609375), SC_(25.78265380859375), SC_(0.3082362115383148193359375), SC_(0.5120990483437200393494919209828001200220949330583050231726214418919167475730716233816281750714523639), SC_(0.5785809600137220721850396422905665441347146859746726641406069096509439117725606675009328678106292058) }}, 
      {{ SC_(31.3508777618408203125), SC_(354516.9375), SC_(0.81474220752716064453125), SC_(0.0001023035325505147708021904216343789488106295198762512998130840128756995802632134118683417744160985881), SC_(0.7417569378190052466823928359801133141545537873376056323371876689371852512373794122336801497702505583e-4) }}, 
      {{ SC_(31.5992832183837890625), SC_(2.974167346954345703125), SC_(0.1355634629726409912109375), SC_(0.8618689875786587579727783691128455749672207146098456685175081189811686628983627264756106185743111621), SC_(0.9623294729430451068561447365237986563078654114105136269289248290655261801530346711146819436410967015) }}, 
      {{ SC_(32.361301422119140625), SC_(0.12657617032527923583984375), SC_(0.12707412242889404296875), SC_(0.9917540827706536839668605398341466723220464920430952098038298929490892162525170822279916753899757835), SC_(0.9999999983799560482776410704232446056938360079125523393759002009237207849464379990485615875235158242) }}, 
      {{ SC_(32.474456787109375), SC_(480.857269287109375), SC_(0.632396042346954345703125), SC_(0.0663782295012748516571753920774401901917817168825734642546345190765097805180650176450658829711691704), SC_(0.05914245111791633680767311994568065463044803741904524239819198501129181464192231563212488703964851851) }}, 
      {{ SC_(32.59918212890625), SC_(0.24035865862970240414142608642578125e-4), SC_(0.8350250720977783203125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(32.948390960693359375), SC_(0.000167359961778856813907623291015625), SC_(0.8350250720977783203125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(33.888454437255859375), SC_(331.263580322265625), SC_(0.8350250720977783203125), SC_(0.1075098742210071415293029376281489873713294528852466314005784920557663251169854055953697680951477932), SC_(0.07803038211087268530890037979173034169637850639353266331299735650014754032868563764009034111784453099) }}, 
      {{ SC_(34.838344573974609375), SC_(0.00024838323588483035564422607421875), SC_(0.81474220752716064453125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(35.242801666259765625), SC_(301364.125), SC_(0.12707412242889404296875), SC_(0.9490437175405729376700271769570696787227969637030890758479530703714870607946059823150883084432126777e-4), SC_(0.0001396214095424630945088079773992362447219048205525491492101258662863719808839261124458242710499609574) }}, 
      {{ SC_(35.6124725341796875), SC_(0.25395145712536759674549102783203125e-4), SC_(0.905801355838775634765625), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(35.927936553955078125), SC_(0.02636432647705078125), SC_(0.905801355838775634765625), SC_(0.9999999999999999999999999999999999999999802954791617207818306775513267125928615955551202126731225465), SC_(0.9996153904469860413531877294222967537390039253817760878952326248960036819549648491968760145169943545) }}, 
      {{ SC_(36.51232147216796875), SC_(0.17059408128261566162109375), SC_(0.8350250720977783203125), SC_(0.999999542040761300258098335895381970156403500836643532664333532085773937209159454454239393770391259), SC_(0.9923196117595220514966603954288682269942671529764229500566345244659415051303766016347548595916499821) }}, 
      {{ SC_(37.01564788818359375), SC_(23.332645416259765625), SC_(0.913384497165679931640625), SC_(0.6972990247727908718968910659073642533042184170132963892467804617450643951016600533990150429376783661), SC_(0.527253484661049767771910163414764297482200801647899661676888512437027241039978941838353468827405994) }}, 
      {{ SC_(38.27669525146484375), SC_(4.620498180389404296875), SC_(0.221111953258514404296875), SC_(0.8592413095390584788098932639872041005592724873412325669117716755112013192047506476772846651521060741), SC_(0.9301714468656560396154052656139369539597046676359710829092067518445178008461696459638767389441103691) }}, 
      {{ SC_(39.146465301513671875), SC_(0.00025820670998655259609222412109375), SC_(0.9688708782196044921875), SC_(1.0), SC_(0.999999999999999999999999999999999999999999999999999999906250983556606329641769537608099763777296335) }}, 
      {{ SC_(39.4506988525390625), SC_(136.2086944580078125), SC_(0.3082362115383148193359375), SC_(0.2080458783651402284684932867969269245847786664904621223081263961028872273546700388221391268356382558), SC_(0.2395607133506659070725040346382804735289665612845453322588401033297550507706513456124340474691032842) }}, 
      {{ SC_(39.513668060302734375), SC_(0.0025859004817903041839599609375), SC_(0.12707412242889404296875), SC_(0.9999999999999999999999997841215601249610958005821778690858312211873679562007256063230658040161612908), SC_(1.0) }}, 
      {{ SC_(39.82184600830078125), SC_(152.626007080078125), SC_(0.221111953258514404296875), SC_(0.1841009935737937123683824645248221466328479170176523895562223694876828033897778019577383651091184088), SC_(0.2289167928346057257013791142336965848287839199486770414502851414285018730843801420099005877734428225) }}, 
      {{ SC_(40.45703887939453125), SC_(32077.298828125), SC_(0.9688708782196044921875), SC_(0.001653348429248338668607781459319060773252199331784602251975781220883860349670497475874764795924957726), SC_(0.0009171296626673560965239333389652359522656974608483857227632984655955384358653444498341170697487773714) }}, 
      {{ SC_(40.55828094482421875), SC_(2.458832263946533203125), SC_(0.905801355838775634765625), SC_(0.9818070446160497624795286537557408327594725241405881928775579018088316336446960744993960836947463249), SC_(0.8936808074285039033392179584511297543378478460822836014837391665601685503036103300962388489842953467) }}, 
      {{ SC_(41.08962249755859375), SC_(470040.03125), SC_(0.3082362115383148193359375), SC_(0.8008113873612486135155629759210564064617748762604027489860852530840583511102649254055707387437908749e-4), SC_(0.9367771073089427258599753990191298012293090702403810024201315951629223698953093286712320562232476447e-4) }}, 
      {{ SC_(41.42235565185546875), SC_(0.0039965151809155941009521484375), SC_(0.8350250720977783203125), SC_(1.0), SC_(0.9999999999999999999996479854325521193161597598577896007309363523011831214329278264429078787631360971) }}, 
      {{ SC_(42.728160858154296875), SC_(1.57044470310211181640625), SC_(0.913384497165679931640625), SC_(0.9932442779378764241199230535658725092020091327541871224750490403282645369411867774021455928692337137), SC_(0.9239454596216220553329190363059482424486325012155275694370467259626695866020414213586821138337695992) }}, 
      {{ SC_(43.03235626220703125), SC_(365461.34375), SC_(0.905801355838775634765625), SC_(0.0001419248323008714730919343461157872745274907209163427560702590003046095572887253767541588082987740128), SC_(0.9487408680973144429945669849503842969526756228267588068173164093858995186613935457008472889043519245e-4) }}, 
      {{ SC_(43.688262939453125), SC_(0.011019987054169178009033203125), SC_(0.9688708782196044921875), SC_(1.0), SC_(0.9992317721388855249897615461158874473207864365280995208250770863704830631532442828343851481165849235) }}, 
      {{ SC_(44.11992645263671875), SC_(0.25921415726770646870136260986328125e-4), SC_(0.221111953258514404296875), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(44.16400146484375), SC_(0.3705587089061737060546875), SC_(0.1355634629726409912109375), SC_(0.9808728478021905610557719458457365821499701531544340253858794579417110212452407995153014214480785069), SC_(0.9999242296926159139430557403078079687780897718599941711104318417318280950286630431006387287228118927) }}, 
      {{ SC_(44.35755157470703125), SC_(0.00286526815034449100494384765625), SC_(0.81474220752716064453125), SC_(1.0), SC_(0.9999999999999999999999999999999988684790388456335825001401414357019984989001320279672754759206619322) }}, 
      {{ SC_(44.4176177978515625), SC_(0.0028001288883388042449951171875), SC_(0.221111953258514404296875), SC_(0.9999999999999999999999999999999999999999775857278911301640428185589442167589275849614798212226211956), SC_(1.0) }}, 
      {{ SC_(44.95709228515625), SC_(0.4406783045851625502109527587890625e-4), SC_(0.3082362115383148193359375), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(45.79766845703125), SC_(2480.718017578125), SC_(0.12707412242889404296875), SC_(0.01514842517913599952366203622679367896786950586977135028198659295051934926015333167180331261232363092), SC_(0.02118168883102576839861592577363678363129222845293853489870465374230816286203301380114788969256293927) }}, 
      {{ SC_(45.8876495361328125), SC_(3835.69384765625), SC_(0.8350250720977783203125), SC_(0.01350180863754580720784674798559548336589932563948442950108843071157566625851533096947139770542404081), SC_(0.01013355702420993985487305457056904106693446423400195742847539365043215889789925157456886369321731733) }}, 
      {{ SC_(45.93944549560546875), SC_(0.1238458156585693359375), SC_(0.913384497165679931640625), SC_(0.9999999999641397457401161607722805160808059786282994374016932190923535184747616998192468063501223612), SC_(0.9908394155719757056307736687066950135697591358777471810740427921676463695941892776789955880482544013) }}, 
      {{ SC_(46.205387115478515625), SC_(461419.53125), SC_(0.632396042346954345703125), SC_(0.0001044496842013316952537924037499322840639609505299280845260958738438170988651221169226034474236329212), SC_(0.9452781224572437413928853243661236221474428334388254092023916767069750256309771122985530821947324965e-4) }}, 
      {{ SC_(46.20613861083984375), SC_(17.2277240753173828125), SC_(0.905801355838775634765625), SC_(0.7996872536040298721124150128781278572531348389588561769085987369884057325578569299546752211742094232), SC_(0.6535657218221962679267532509820027994654339644802027781785969221436615928235406801233145082150135801) }}, 
      {{ SC_(46.48529815673828125), SC_(230.984283447265625), SC_(0.12707412242889404296875), SC_(0.1422628392972406720822854751946808466087943410940017243343385801968196353452746997193655414761026166), SC_(0.1932875560637871853220968671359781950816406753551110288039256989588439915142805103959053622119854053) }}, 
      {{ SC_(47.248058319091796875), SC_(0.00016102936933748424053192138671875), SC_(0.913384497165679931640625), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(47.3762054443359375), SC_(0.00139417522586882114410400390625), SC_(0.3082362115383148193359375), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(47.565670013427734375), SC_(0.012347941286861896514892578125), SC_(0.221111953258514404296875), SC_(0.9999999999804105608361826295362504811850177224042154552939651601855944822254904314691301915373660302), SC_(0.9999999999999999999999999999999999999999999999999999998990167760089209649060268402916728590987120861) }}, 
      {{ SC_(47.917327880859375), SC_(0.00043436698615550994873046875), SC_(0.12707412242889404296875), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(49.375934600830078125), SC_(0.004664070904254913330078125), SC_(0.632396042346954345703125), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999924629), SC_(0.9999999999999999999999999999999999999999999975286187264398936782455853845654992251525309122494729321) }}, 
      {{ SC_(49.536712646484375), SC_(3.863943576812744140625), SC_(0.12707412242889404296875), SC_(0.8869035687320245050320479712103996460378051949611994099651431817437083832521526519354375429023904899), SC_(0.9650056672346678161757640579393039709241834178114747481261362635654864220941295351177404706871098509) }}, 
      {{ SC_(49.81558990478515625), SC_(38816.20703125), SC_(0.221111953258514404296875), SC_(0.00113926767451546380608537276508558605080573154052016965260275176772031481773384448563472900605264791), SC_(0.001417192106236972123603917828009427753985712765241910018839959590173061485197209063261902039679761919) }}, 
      {{ SC_(49.97966766357421875), SC_(2.618212223052978515625), SC_(0.3082362115383148193359375), SC_(0.9402706406317171096001565369540545184233027819072191551063073339020473480943644712269282765932937647), SC_(0.9685153189197985262105112109054482121057638893157556379732554471988996358472953379537439114223368881) }}, 
      {{ SC_(103.12812042236328125), SC_(114067.6640625), SC_(0.1355634629726409912109375), SC_(0.0008062070690054487944700342087407593994612241890305325397705099111043855128216926918501951726786051306), SC_(0.001001582405995753996910078032826285156068089955757928417639107961052914318750128443151670905902022115) }}, 
      {{ SC_(104.1346435546875), SC_(0.27170151952304877340793609619140625e-4), SC_(0.1355634629726409912109375), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(114.89385223388671875), SC_(4951.32373046875), SC_(0.9688708782196044921875), SC_(0.02673004160226834858143874104024496817042342427526253563832801401322686480078292109542533227880244467), SC_(0.01893772132739098563841317632925061681395006807421945310935047321139426239117387027325128760559186579) }}, 
      {{ SC_(119.378936767578125), SC_(0.4208850805298425257205963134765625e-4), SC_(0.221111953258514404296875), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(120.53275299072265625), SC_(0.00151182874105870723724365234375), SC_(0.81474220752716064453125), SC_(1.0), SC_(0.999999999999999999999999999999999999999999999999999999999999934713404694008316323705262157631568417) }}, 
      {{ SC_(123.761322021484375), SC_(31601.099609375), SC_(0.632396042346954345703125), SC_(0.004010040734378233814242948996733585622357189983015409316167392705422241445595516166021627558918640461), SC_(0.003773669715797799336572537492575293637442447196072369048781319106309589505595534248388423323851773482) }}, 
      {{ SC_(124.63626861572265625), SC_(0.0002591950469650328159332275390625), SC_(0.3082362115383148193359375), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(129.1541290283203125), SC_(0.001998660154640674591064453125), SC_(0.8350250720977783203125), SC_(1.0), SC_(0.9999999999999999999999999999999999999999970885051274360058587535315338995015628689686110618313112197) }}, 
      {{ SC_(134.4938201904296875), SC_(0.369370639324188232421875), SC_(0.81474220752716064453125), SC_(0.9999431789399404592321474604039072880343312142550020619511559041497227627367374436512086950344289464), SC_(0.9952557054195093187036835280045208467233365750662020495290140233887671002788071654187511939779245275) }}, 
      {{ SC_(134.6666259765625), SC_(1.34013068675994873046875), SC_(0.3082362115383148193359375), SC_(0.9881824428801870939762019733469287411936348282558518582074289190342583690954781207462455412036637327), SC_(0.995487172599166041719533926968650604440806349481102904714344238844914975289328263125093599556024164) }}, 
      {{ SC_(135.4109954833984375), SC_(0.00301261036656796932220458984375), SC_(0.905801355838775634765625), SC_(1.0), SC_(0.9999999999999999771993857909723637311037816987438942261886619474458027446066479861998529534227137651) }}, 
      {{ SC_(136.5994873046875), SC_(43.41033172607421875), SC_(0.905801355838775634765625), SC_(0.7999856183687033041786291900036031861607309067584064599754266689512880462320195847072809067473273583), SC_(0.7162940326558927053796817365746784269373589856907197793993954699821063017039273481334619892987253744) }}, 
      {{ SC_(136.9409332275390625), SC_(131351.0625), SC_(0.12707412242889404296875), SC_(0.0009409134702661550572774371293890522931796521647080473661414375290145005814814543813274159137076528798), SC_(0.001143548351648569037802924154450093047369934589419038255892478355199508328874970183502617946978711212) }}, 
      {{ SC_(140.242523193359375), SC_(10.396793365478515625), SC_(0.3082362115383148193359375), SC_(0.9221977887743737958977507498329925320617004174300373550089323473186163475960212462035329196997939742), SC_(0.9426106922578314990258478791623251092464895939848228415142075804405333945932222048832755567875491515) }}, 
      {{ SC_(141.92529296875), SC_(0.000180798946530558168888092041015625), SC_(0.913384497165679931640625), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(141.9384918212890625), SC_(13.08813571929931640625), SC_(0.9688708782196044921875), SC_(0.9523978709464164161340019402513478256063356014793054447082580137611843588449227333784412867991776212), SC_(0.8699260144026967305999121229944727548840981552233519820101135001134975113452844438855283070979188917) }}, 
      {{ SC_(143.5271759033203125), SC_(276260.9375), SC_(0.8350250720977783203125), SC_(0.000561369285253392836120915139043458385244580388773771993870793512596805204974886692808216607574877678), SC_(0.0004770385646199412099686410562910291842868603673061550890196990388333814695553835389692477626358125564) }}, 
      {{ SC_(143.902008056640625), SC_(3178.291015625), SC_(0.12707412242889404296875), SC_(0.03931947971800156852737996401884754086090786825340705049818441093502319892461411071428284629944489017), SC_(0.04736635490185981331019515264702159625701385880449349068043835443652746336409775521719469903037862739) }}, 
      {{ SC_(144.141387939453125), SC_(0.02794832177460193634033203125), SC_(0.3082362115383148193359375), SC_(0.9999999924926815539995436797047539461517676129972860014460661022808042704348381789183955164337962705), SC_(0.9999999999999999999979396686288131742295836412870873742471214642371022827159581778631321468721370769) }}, 
      {{ SC_(144.9135894775390625), SC_(216.5679473876953125), SC_(0.12707412242889404296875), SC_(0.3715578369527994516401570335261347703345907865278261091876174613166722501489771278084473126090676443), SC_(0.4303286451873791788901327140281890119365177089983818507172377756336934202774299605942772369210364593) }}, 
      {{ SC_(146.9971466064453125), SC_(0.03688235580921173095703125), SC_(0.632396042346954345703125), SC_(0.9999999999999935072707490594127069530354459506793327400396201076459739499639513569219669094969195357), SC_(0.9999999841309976555921259801159128102593554174069986468016836296670325907991616227561698979931867794) }}, 
      {{ SC_(150.13287353515625), SC_(33750.34765625), SC_(0.913384497165679931640625), SC_(0.004927647268411316804198684333596643598877166682872716954127303987654952710723949280937692496751473655), SC_(0.003946281215364040154112408471317675205817582035766676829342008239391323059656931777006461031632702731) }}, 
      {{ SC_(150.599945068359375), SC_(306722.0), SC_(0.913384497165679931640625), SC_(0.0005460821308271826317895460788365649695589042917671462088647127876371128992823039171099106167078257653), SC_(0.000437287032441070861943581310523027797376186208238529672088614943963779478606480707245709396230423273) }}, 
      {{ SC_(151.1553497314453125), SC_(0.00040882988832890987396240234375), SC_(0.9688708782196044921875), SC_(1.0), SC_(0.9999999999999999999999999999999999990498214112849103875571994825064476827625508617785081369060509263) }}, 
      {{ SC_(152.060577392578125), SC_(48686.92578125), SC_(0.9688708782196044921875), SC_(0.003600009858977769588591487712773243264037421187347124615132505072032036617238480146701916423619682911), SC_(0.002660581893911085007022048060278930176611863392976502588995792768733420479707027083973424321060664375) }}, 
      {{ SC_(152.8331756591796875), SC_(0.01893596164882183074951171875), SC_(0.1355634629726409912109375), SC_(0.9999982930855065583884300504963961560978065126114968625177827331623160756207861552267370413864156487), SC_(0.9999999999999999999999999999999999999999999999994478911174062882172270591629827369974232987706218467) }}, 
      {{ SC_(153.7213134765625), SC_(247144.21875), SC_(0.9688708782196044921875), SC_(0.0007183226213779356686541861342457125408834541343867288421130069434186124215082107183437390081074761866), SC_(0.0005315488818620334514191949234134792617071209447318983167377666154175532497680355265415303115807859949) }}, 
      {{ SC_(160.7382049560546875), SC_(25.5228900909423828125), SC_(0.1355634629726409912109375), SC_(0.8350797750422063151326191031234970196792606327062197828858092622398207293510631180562045513059038507), SC_(0.8903059220009117692407734970952734774238624092647718807165995185097202562481593551528790211118626109) }}, 
      {{ SC_(174.9843292236328125), SC_(3107.8662109375), SC_(0.221111953258514404296875), SC_(0.05025515811401936641265985592996487424686407502979628120268591496946762294005097349167625357573711043), SC_(0.05627571295532612536113618367770810052127903464950555050000646843743303094004604686935149955283588914) }}, 
      {{ SC_(182.269805908203125), SC_(4.91394901275634765625), SC_(0.81474220752716064453125), SC_(0.9841940929714513739500072922936565218703907909835866021197913501123929256037236314160092662726783955), SC_(0.9639411888007886303742734474352531752122164371101478490035282823397768438775339341425229179751051369) }}, 
      {{ SC_(182.4111480712890625), SC_(1.8299617767333984375), SC_(0.221111953258514404296875), SC_(0.9856710052965877289902284903613142736737974396130380014205078927209298429784722102644843249268827903), SC_(0.9958246577958065173888664329129878365625480383021836767390054223845473927779077640176925461393793687) }}, 
      {{ SC_(191.581298828125), SC_(2.2190074920654296875), SC_(0.913384497165679931640625), SC_(0.9968899073863202697115111245323342853350475195372089761713107858826992139321308515943661073851182335), SC_(0.977373440637330075822174490304535050660350419097182167808851533513366838778350835027094729818804947) }}, 
      {{ SC_(193.9307708740234375), SC_(0.488285362720489501953125), SC_(0.1355634629726409912109375), SC_(0.994384612656008174878334502974516467645196442393653984968131145200046609482527505517721890101741558), SC_(0.9999321369583885135025890824838743146029099327548631066496221603610393204828052315340708597751821388) }}, 
      {{ SC_(194.9492034912109375), SC_(25.73528289794921875), SC_(0.81474220752716064453125), SC_(0.9028761365172547521560786907240162025789481171441088463083048125902727784102793617398509587958168374), SC_(0.8643445362046692397623099589773188356308673990397093386020170147010671415090331408921941860766545738) }}, 
      {{ SC_(206.4715423583984375), SC_(4999.44482421875), SC_(0.3082362115383148193359375), SC_(0.0382630812823879551268013866109437352951494756097308748017573326258518488200091963989309468658885091), SC_(0.0409704999839855165554751253811152003366375901968413666708153637145815220450711697093641642331978286) }}, 
      {{ SC_(209.1755218505859375), SC_(4321.3662109375), SC_(0.913384497165679931640625), SC_(0.05047051605278412124089151027551907247461800145419586880945740379069296987660894849435684452940128054), SC_(0.04198384174745690444910491257857255069531683636209824974563045970272549803807135604827062986640375684) }}, 
      {{ SC_(215.1907958984375), SC_(0.25329818527097813785076141357421875e-4), SC_(0.9688708782196044921875), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(216.6281280517578125), SC_(348.682403564453125), SC_(0.221111953258514404296875), SC_(0.3674311676456567093497835267003729165636048550611559851350782632512689488231547223297807678232383062), SC_(0.3988601646566989998449348117709218038794534768131308161171823629559540625427406579072424247924238366) }}, 
      {{ SC_(217.62652587890625), SC_(17.93491363525390625), SC_(0.632396042346954345703125), SC_(0.9307246967070102015150927085560552979094229015527609193566096119564129673707151759545073506931849683), SC_(0.919122850174271722315922168916708667032115301893756307730427610701679950800477210458097760122568205) }}, 
      {{ SC_(226.324554443359375), SC_(39210.1875), SC_(0.81474220752716064453125), SC_(0.00607768500134497139742906880598633184602248841652460720663240081283823824367343107828845055459206578), SC_(0.005396927091876590961508944404832313940753171331279395268306620673692103932858470035934807960036158532) }}, 
      {{ SC_(231.5256805419921875), SC_(0.0435504876077175140380859375), SC_(0.8350250720977783203125), SC_(0.9999999999999999999973002956007401185626244089882755276019162288341304186112562447153253719360871399), SC_(0.9999595611348830441856438673010932081421745805140344212579838916099361129994739264969923981309162267) }}, 
      {{ SC_(235.0335540771484375), SC_(0.00019701055134646594524383544921875), SC_(0.81474220752716064453125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(246.57464599609375), SC_(0.1393482387065887451171875), SC_(0.8350250720977783203125), SC_(0.9999999938511384845721355117294261922203288201925654913950288483616099750539921896555755573075585913), SC_(0.9991736671973034720884345238378882665891015305075737165922615423158841236523201224803807871853700462) }}, 
      {{ SC_(247.0611572265625), SC_(2.6212046146392822265625), SC_(0.1355634629726409912109375), SC_(0.9825439039626933953164951158737208696821909806854698565197359372169558956988419725253561318486642976), SC_(0.9958902544756431568680202490315828678910784282674450327847995842830959927384108359497783069320800962) }}, 
      {{ SC_(247.6795196533203125), SC_(0.3789966404438018798828125), SC_(0.905801355838775634765625), SC_(0.99999418232711504330126990735849251148387235764429545270330907883095312363963218760372532714651881), SC_(0.9954664137312897612651126469648847731314743530977621741930721975468648349621125539926506463269287038) }}, 
      {{ SC_(255.30865478515625), SC_(1.6643607616424560546875), SC_(0.8350250720977783203125), SC_(0.9979542217472028142218564962924983408160742712703296112530177584060709209683235404133003364424571307), SC_(0.989177716762129194816018881318447041845979530156509148618195236413419583034624141855463352253747431) }}, 
      {{ SC_(258.402679443359375), SC_(3463.272216796875), SC_(0.905801355838775634765625), SC_(0.07496591394342307468676527044835081737103677311460330059054327478448439673925114918515510569416041789), SC_(0.06401038948412829994964259497334008234279982519024189689484373849218439933414720062160719157372156161) }}, 
      {{ SC_(258.608306884765625), SC_(0.00045402420801110565662384033203125), SC_(0.221111953258514404296875), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(262.12615966796875), SC_(41.1895599365234375), SC_(0.913384497165679931640625), SC_(0.8902284854208787078842224649907493492387138059233155116091392583746578465693359767402950066738548246), SC_(0.8368032703401795290059711277299243504804569659979850508139503602820266509104355059075712640510967762) }}, 
      {{ SC_(269.2437744140625), SC_(248884.53125), SC_(0.221111953258514404296875), SC_(0.001029539378299970485415676957363883518355247057989156925052422900536153016171783931824378809660768808), SC_(0.001130633557610517884069041925013490678560193404679441664380193018571475462184287108511622074433834906) }}, 
      {{ SC_(271.8258056640625), SC_(40013.29296875), SC_(0.1355634629726409912109375), SC_(0.006300674528872691998643391561374789642163085566565730435628413990181863345875172173272315953401199027), SC_(0.007197869342850532440382462642653106240294122551011274218242845069086266215661288235648759399350064917) }}, 
      {{ SC_(272.993988037109375), SC_(213.918212890625), SC_(0.81474220752716064453125), SC_(0.5808232679875324325062469023057696546653747246517651582164401527777575267940605997383786668854497848), SC_(0.5405368465475943976204539822673972474720533539602758539485532412765075611828821807814549922325098759) }}, 
      {{ SC_(273.05694580078125), SC_(120.83953857421875), SC_(0.913384497165679931640625), SC_(0.7245592200924371928840014777609554959859146247515904422018833311209770604130790778210936168304767687), SC_(0.6613202603086886030459074802217352006032064150318568337355837729263915360352534686780664720822218848) }}, 
      {{ SC_(280.6956787109375), SC_(40294.875), SC_(0.221111953258514404296875), SC_(0.006598531612269405343929877389687162046076467539353361944147196460064751907126903063108797270124899447), SC_(0.007230534122462434330512566498121272979152139986257897432198311025282620449433381847538472186874938885) }}, 
      {{ SC_(293.792144775390625), SC_(43.755107879638671875), SC_(0.12707412242889404296875), SC_(0.849356239493810514761669447369672498434810745946259133696735825189314026672840644887460391837979087), SC_(0.8909475708594075892266751040494492986985770270993378956417592312382371982362260788627215755904805807) }}, 
      {{ SC_(294.09173583984375), SC_(0.0041162283159792423248291015625), SC_(0.1355634629726409912109375), SC_(0.9999999999999999991816710272088710907133767444914677526150752896026472146573856665561309148604825251), SC_(1.0) }}, 
      {{ SC_(295.04150390625), SC_(4611.853515625), SC_(0.81474220752716064453125), SC_(0.06315374226727988413684305395940247654931232466691641777353092789685273248568311514709684923029116248), SC_(0.05707849134785464787029652918339100877404672383311051245357951266365550077218054785069344122191478071) }}, 
      {{ SC_(310.44097900390625), SC_(0.3617111724452115595340728759765625e-4), SC_(0.81474220752716064453125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(312.348907470703125), SC_(17.8608245849609375), SC_(0.8350250720977783203125), SC_(0.9579847094536455565936055079809590053905045046475343440710454479816576950015985726873704447966804298), SC_(0.9339230786941222856604174440183761589360250718629131962344906181640781826811984484970193268408031568) }}, 
      {{ SC_(312.48370361328125), SC_(290847.96875), SC_(0.81474220752716064453125), SC_(0.001127319153733298194876285746021755920444111143355024044814954068496790284606906842295178853682914088), SC_(0.001018699336556359016449924190201115869261011247963059310385004622371904945355047702859930174928618389) }}, 
      {{ SC_(319.8160400390625), SC_(0.0034338268451392650604248046875), SC_(0.12707412242889404296875), SC_(0.9999999999999999999885782522121239720378924164702419364488175242026733242727982148213512890260261594), SC_(1.0) }}, 
      {{ SC_(320.71142578125), SC_(4.67389774322509765625), SC_(0.905801355838775634765625), SC_(0.9933229979246399817402177158975810073939488560333729833574769096502187908439301761830114660292703708), SC_(0.9764989101980150094953146998214058228380821313586494993889299591548323610709508523772754780594204425) }}, 
      {{ SC_(322.667938232421875), SC_(0.000298001919873058795928955078125), SC_(0.1355634629726409912109375), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(333.2742919921875), SC_(0.0451156608760356903076171875), SC_(0.9688708782196044921875), SC_(0.9999999999999999999999999999999999993024522414434959592528156591133109713644699769217764700867599862), SC_(0.9987553275939253861769882742122918788970674441262575497956877566317860577638704280647163852507564504) }}, 
      {{ SC_(339.176666259765625), SC_(0.4111320078372955322265625), SC_(0.9688708782196044921875), SC_(0.9999995236671855923438683507103921467223937679671553621101631997435391742327949564842653070262280338), SC_(0.9938910748133382239771236727930711742983670049790434303395950897494596427826116038671954023380345267) }}, 
      {{ SC_(341.38720703125), SC_(0.384202649001963436603546142578125e-4), SC_(0.632396042346954345703125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(341.41339111328125), SC_(468.468475341796875), SC_(0.3082362115383148193359375), SC_(0.4128184880043032809140395019499975322296948181157138611993089505021056371988042479120849961204236383), SC_(0.4302037456878193873356787723206187526028572520853624951542180385689884722486577946846142465981053205) }}, 
      {{ SC_(343.1463623046875), SC_(0.0001005965095828287303447723388671875), SC_(0.8350250720977783203125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(343.94287109375), SC_(36665.765625), SC_(0.3082362115383148193359375), SC_(0.009037013529627434527884964751407311798376414357668757074111954961131451142501337166101600605322602743), SC_(0.009536374879923418487679679263956006220860557443039503868720373564029333691688007568814491327612979529) }}, 
      {{ SC_(352.70654296875), SC_(212717.25), SC_(0.905801355838775634765625), SC_(0.001772286704155749904850572616733310267135395971245143557595896706014427386742310217816222627460115054), SC_(0.001540701157746761622809004875508828786105661861815249037593295147614312787858626788952997628299148919) }}, 
      {{ SC_(356.28717041015625), SC_(0.0463746227324008941650390625), SC_(0.81474220752716064453125), SC_(0.9999999999999999997339356445637361482652424936367171377768294874432208096948783418222254267363846753), SC_(0.9999801156387943709224884105375848088409941912487113654870827079099437708865174333535247407071178364) }}, 
      {{ SC_(356.7762451171875), SC_(3.3235576152801513671875), SC_(0.9688708782196044921875), SC_(0.9976938403420528084472435863529473878987142998231148844923075469329957921009393418824147344675511577), SC_(0.9794436309308570878826626815864396555178518229943269691186118747993594173886796230667427187870460625) }}, 
      {{ SC_(361.524810791015625), SC_(0.01847557537257671356201171875), SC_(0.905801355838775634765625), SC_(0.9999999999999999999999999999999999999999999999999999999999534466448091812626550346993803974910050023), SC_(0.9999925209388827223573361966487975623371832937108007569513852736353814048374024501229531314904219329) }}, 
      {{ SC_(362.19921875), SC_(344.353759765625), SC_(0.9688708782196044921875), SC_(0.5476281575497843624437893605159724208937184738549985337927500545951056343535331447933761833883481827), SC_(0.4775698867087671573501965764610067432811450131031398400305624887702874847230815601812005925276539136) }}, 
      {{ SC_(362.229278564453125), SC_(131165.359375), SC_(0.3082362115383148193359375), SC_(0.002679791707566526422755873589586630169446617530094936763418005754297611371885109650718284341833951093), SC_(0.002824467746507293749673505448781489244224217628755381251478421973997863132443544440211476576746619521) }}, 
      {{ SC_(367.16644287109375), SC_(0.23287344447453506290912628173828125e-4), SC_(0.3082362115383148193359375), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(369.317962646484375), SC_(35824.7421875), SC_(0.12707412242889404296875), SC_(0.009604414696686521852522972547773614043823800216874752316334044933885241724077465902173892674314645196), SC_(0.01080866133724440194045276794950516862598710840502502774055657657118093499050283654495869007666263032) }}, 
      {{ SC_(373.486236572265625), SC_(0.0390747748315334320068359375), SC_(0.12707412242889404296875), SC_(0.999951206676503304387915055645428392594015677689474745902804725085489497265877891084129832641009945), SC_(0.9999999999999999999999999817034830426939977466904491055711337484763575253234690673144785174501929868) }}, 
      {{ SC_(374.011383056640625), SC_(0.1863805353641510009765625), SC_(0.913384497165679931640625), SC_(0.9999999965492584154002232707554792943788734275004372821418230392127534622461170559829239167690554951), SC_(0.9982806677420339420495867853969963928053122887245253320195160068884607241629161287598291745863318699) }}, 
      {{ SC_(377.012786865234375), SC_(0.00041205019806511700153350830078125), SC_(0.12707412242889404296875), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(377.90087890625), SC_(133.8535003662109375), SC_(0.8350250720977783203125), SC_(0.7573768111819911907733305298341295258452551688515322550451218290419239612375694786774455041231820618), SC_(0.7195379032736576050350055599592024368543444672971916087921468093868440089478843571196322217701063024) }}, 
      {{ SC_(378.573211669921875), SC_(29545.880859375), SC_(0.905801355838775634765625), SC_(0.01350837749770206307739624546614705808313575619735876885193762596540502661976224026280762002530923324), SC_(0.01180940552044999402895433686264426291097939902639039269804194137142809327352362433621821394149601647) }}, 
      {{ SC_(382.9013671875), SC_(0.46764689614064991474151611328125e-4), SC_(0.905801355838775634765625), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(389.089813232421875), SC_(0.0373030789196491241455078125), SC_(0.221111953258514404296875), SC_(0.9999981638156162652397811256720214231850386643686371258447359791037752330919429919296948291706260477), SC_(0.9999999999999999999959855454783816868145889553634386516069323406345552212253592701677768430836791129) }}, 
      {{ SC_(389.16900634765625), SC_(413674.96875), SC_(0.632396042346954345703125), SC_(0.0009552624362049901669855123577411850520266689108108123768130918151898423984129852253994996692950398036), SC_(0.0009230668753777913260201878579216177559951057793650829829918551184784987279449976165063313716704841588) }}, 
      {{ SC_(391.8837890625), SC_(0.19626211724244058132171630859375e-4), SC_(0.8350250720977783203125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(393.736419677734375), SC_(0.004322923719882965087890625), SC_(0.632396042346954345703125), SC_(1.0), SC_(0.9999999999999999999999999999999999999999999999998681646674025799803647413200807347985795342485825951) }}, 
      {{ SC_(393.983001708984375), SC_(0.2691637575626373291015625), SC_(0.221111953258514404296875), SC_(0.9991104454540003775468926277949453030838143774120550859615860420242530752079505266653131075638920104), SC_(0.9999936079645851615121065984282499599641967765104370746154265792539398181425755442804864751790295789) }}, 
      {{ SC_(396.012939453125), SC_(0.3836281299591064453125), SC_(0.12707412242889404296875), SC_(0.9976773716410047586086328315418707524172428344528749929658542074981010458175248452222762668765665444), SC_(0.9999914072744088487882581829807620947616093547081324984203029110933446510694720873076122676680417324) }}, 
      {{ SC_(396.501617431640625), SC_(0.00025799489230848848819732666015625), SC_(0.905801355838775634765625), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(398.525390625), SC_(0.3569120235624723136425018310546875e-4), SC_(0.12707412242889404296875), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(399.652587890625), SC_(0.0480428077280521392822265625), SC_(0.913384497165679931640625), SC_(0.9999999999999999999999998874820134854074865216893772112145115755920760927680981771473318634136034848), SC_(0.9997572519799009283700038652961907458357451588614006315616458103059800790487333231192604116343004188) }}, 
      {{ SC_(403.239715576171875), SC_(231.1188201904296875), SC_(0.905801355838775634765625), SC_(0.6606842929715214649615606413209121731649068883032811201531852082398669402494589803335512537428810645), SC_(0.6104377133697563237980316718857496085294360624500839682414062863616728848087000500300566107380706249) }}, 
      {{ SC_(407.583343505859375), SC_(1515.2218017578125), SC_(0.8350250720977783203125), SC_(0.2210469837518396754245030417545908320101014855023436229245265454847262270084604209956247944948868399), SC_(0.2028895040165325283897593722215097234823471316892626088348638245966639724244640971097239316467797438) }}, 
      {{ SC_(408.7735595703125), SC_(3.076730251312255859375), SC_(0.632396042346954345703125), SC_(0.9945670466082144100175300085610724450412421987303313839503457885193680499599594291596269664166069007), SC_(0.9918731487981079274792102053341985296979518979685052943197625278535573404689289803590751271743508938) }}, 
      {{ SC_(409.088836669921875), SC_(41189.671875), SC_(0.8350250720977783203125), SC_(0.01030491517493573224348219258833419205924194409131107232375860117567446052852736555717660298780789813), SC_(0.009362604650398965161312439656384200499761224093952164921184959311116948404519195055038571923608488886) }}, 
      {{ SC_(412.0701904296875), SC_(0.000211175109143368899822235107421875), SC_(0.632396042346954345703125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(412.55084228515625), SC_(0.3415349419810809195041656494140625e-4), SC_(0.913384497165679931640625), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(412.772796630859375), SC_(10.2405414581298828125), SC_(0.221111953258514404296875), SC_(0.9704445538190006455424736980333975154565562870718988134034021420706722579237859043263453908496648727), SC_(0.9817458863876760104356452378387453129035208357425301108519161036516971353798754346284218081985113135) }}, 
      {{ SC_(413.771148681640625), SC_(210.19207763671875), SC_(0.1355634629726409912109375), SC_(0.6422789207811020452242460993436065347608271407873253303975613202531308803085636148018960054883695138), SC_(0.6839148376491906411893930261007279094002339036891440027472129458811747936033500816012549400969810303) }}, 
      {{ SC_(415.74554443359375), SC_(1.32294642925262451171875), SC_(0.12707412242889404296875), SC_(0.9938171514067981824911076676650964519986047161019420544097385203587818471804805527331495092608372084), SC_(0.999357421419547646836416841408036522951048184134115371612108076255116758676270860348926943699212568) }}, 
      {{ SC_(419.13214111328125), SC_(4420.99755859375), SC_(0.632396042346954345703125), SC_(0.08791159754060151735236530134706998582672087673450648723897653104443664176800041222568442553820796671), SC_(0.08517801016470882274259880932896101880878695655476693830268639902051634896240519724317287325449010689) }}, 
      {{ SC_(419.34033203125), SC_(0.00151284574531018733978271484375), SC_(0.913384497165679931640625), SC_(1.0), SC_(0.9999999999999999999999999999868286779516978916217629944408603688919986063426761968453431883448374035) }}, 
      {{ SC_(419.584075927734375), SC_(0.002538044936954975128173828125), SC_(0.3082362115383148193359375), SC_(0.9999999999999999999999999999999999999999999999999999999999999999988233292823385165541441358591397183), SC_(1.0) }}, 
      {{ SC_(446.7720947265625), SC_(0.13732771575450897216796875), SC_(0.632396042346954345703125), SC_(0.9999990427528384183556672208304425479489356574755042240527599929999172027078023101328127963474379694), SC_(0.9999492865471341704297726719416983285152663334722569079251832298347447157340619041388044615907409094) }}, 
      {{ SC_(456.1903076171875), SC_(0.002997568808495998382568359375), SC_(0.221111953258514404296875), SC_(0.9999999999999999999999999999999999999992284050657519963875410283844572006100664075360364542143258308), SC_(1.0) }}, 
      {{ SC_(473.50396728515625), SC_(2391.615234375), SC_(0.1355634629726409912109375), SC_(0.1576468984371367999649254141421197651984425203214701273351193938252678133626856401370203339484521789), SC_(0.1729160473311111984570739306443338817981085963903237158763973918215615250337480085874448538094186387) }}, 
      {{ SC_(477.203277587890625), SC_(0.0049147461540997028350830078125), SC_(0.9688708782196044921875), SC_(1.0), SC_(0.9999981000469922166656013548254552216899897992982588571658224137171236600326666007950484724998857371) }}, 
      {{ SC_(485.769073486328125), SC_(190.1673431396484375), SC_(0.632396042346954345703125), SC_(0.7247016274796441657805932836349874799938107338200500867491391407730100402002379783855141900766326269), SC_(0.7130022890858784246047289160013443347182386890214881107393115548911336360365239658957158075225170796) }}, 
      {{ SC_(488.2393798828125), SC_(0.434910595417022705078125), SC_(0.3082362115383148193359375), SC_(0.9991192122305962264529084799772767759243146988052486046064607617994825345072748510123510873523442851), SC_(0.9998925623289403616016717576063001969420445482560798712152728307143428562649004114320056341933694577) }}, 
      {{ SC_(1082.14306640625), SC_(10693.6611328125), SC_(0.12707412242889404296875), SC_(0.08886711310290948222954450915420763566475482768809682261129954691049281304026184847614793386139017977), SC_(0.09493770992983245202467835458147969396419331700378668761467819629801191656861181986227265218174042472) }}, 
      {{ SC_(1097.736083984375), SC_(1.48078691959381103515625), SC_(0.1355634629726409912109375), SC_(0.9975010522020994946185282402556947739472581564457920429912818147660444481871763724458556490879548718), SC_(0.9996731636877482620223061169090120133618466346464761416725375165874179882555721966100443747342702772) }}, 
      {{ SC_(1146.2520751953125), SC_(184.5145416259765625), SC_(0.9688708782196044921875), SC_(0.8785476460112856872786551382821636056277751075596785846175481339071975716595755170028509958329380188), SC_(0.8432502940829551166449358910723419034333340976044334062364194457694662231441717327429856430463239088) }}, 
      {{ SC_(1256.7484130859375), SC_(114671.2265625), SC_(0.221111953258514404296875), SC_(0.01060593725431252986702811756056748183494935555836228792236552941054959777617124983354561889652199492), SC_(0.01107329737933273044666188434446685031335209898146090091670376743489041660857669369725268105831467794) }}, 
      {{ SC_(1295.97900390625), SC_(0.00442600063979625701904296875), SC_(0.632396042346954345703125), SC_(1.0), SC_(0.9999999999999999999999999999999999999999999999995274717196950905697803182405509130752822233377887607) }}, 
      {{ SC_(1309.38720703125), SC_(0.00044117416837252676486968994140625), SC_(0.3082362115383148193359375), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(1394.074951171875), SC_(15.51703548431396484375), SC_(0.905801355838775634765625), SC_(0.992444766685700932203704217540834200817044502679558863331704926736559888250857685746703733482526587), SC_(0.9852014377836765578030010941110495204774619991265772821143987255772727273649449421666978133140391033) }}, 
      {{ SC_(1394.3763427734375), SC_(0.147156597449793480336666107177734375e-4), SC_(0.12707412242889404296875), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(1423.681640625), SC_(37.307399749755859375), SC_(0.3082362115383148193359375), SC_(0.9725685333485380637110287267501037178411982070242071814985930790456365042962937262121607935452487224), SC_(0.9766838842908712433900410425659379867203323063619989628888193722061354156929665325574614737194318392) }}, 
      {{ SC_(1480.748046875), SC_(2957.284423828125), SC_(0.221111953258514404296875), SC_(0.32820049033444896742347023117591698413027179364841901707235537648115127892448552420690732347880582), SC_(0.3390783773335733083079780686681878759048420814198746198082123567837311223705960268279749686752969664) }}, 
      {{ SC_(1499.490966796875), SC_(4.857861995697021484375), SC_(0.12707412242889404296875), SC_(0.9950902694606661107966633713571102955524864552209520984419571285570058317666919528880769980260614719), SC_(0.9983182823293437416520222850958119805893752267736000629673061030120119056199759839619364959833692301) }}, 
      {{ SC_(1568.1090087890625), SC_(0.3394500163267366588115692138671875e-4), SC_(0.1355634629726409912109375), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(1614.361572265625), SC_(257.008087158203125), SC_(0.81474220752716064453125), SC_(0.8698112478913624472277815753750393514138650269219464253707806120917493678652560271796161542992997805), SC_(0.8555660717176567404257654163156632333700556069775631688744214265352153075301526509778708684627646743) }}, 
      {{ SC_(1617.479248046875), SC_(0.032529197633266448974609375), SC_(0.12707412242889404296875), SC_(0.9999944876384744265638157393197757588660413275094485665783821328690650561737979446641441964312416976), SC_(0.9999999999999999999999999999998978309321272052183780981243687993749734714890207311595304625770690906) }}, 
      {{ SC_(1644.535888671875), SC_(0.0342094860970973968505859375), SC_(0.221111953258514404296875), SC_(0.9999997638318361501102436249804991606237926448371863446070930981630325665314545803041661414581513015), SC_(0.9999999999999999999999756021546614999275360380602008471989147383592438919375645221297985909165122545) }}, 
      {{ SC_(1654.0494384765625), SC_(34146.52734375), SC_(0.632396042346954345703125), SC_(0.04656946186270649325203371889209985930923163863709688003721651742142297620934728257705860934068111242), SC_(0.04581907856360845589227681576119497431538366759537784048803430947518484582119749452235136480990250005) }}, 
      {{ SC_(1654.2796630859375), SC_(364.202728271484375), SC_(0.12707412242889404296875), SC_(0.8097763494154385501779948938429754968992817409034980283246683682820854294564925938749705743350958928), SC_(0.8292922860202832371138605638981493887939417202120228799437476076794392165269268209797548868717810778) }}, 
      {{ SC_(1664.814208984375), SC_(0.00033929268829524517059326171875), SC_(0.913384497165679931640625), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(1673.0052490234375), SC_(0.106633078758022747933864593505859375e-4), SC_(0.221111953258514404296875), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(1681.7281494140625), SC_(0.00465255416929721832275390625), SC_(0.1355634629726409912109375), SC_(0.9999999999999999915464943224844109277439970357956668196215595059787772538302182014733407931642369973), SC_(1.0) }}, 
      {{ SC_(1700.0389404296875), SC_(23.1719760894775390625), SC_(0.9688708782196044921875), SC_(0.9912386402397966838078866083328881036260128763921385091738727701757716525291307528900888547300732994), SC_(0.9809377120153263090306024879583583577875486429235348687450755539992071841236516402200421236575781405) }}, 
      {{ SC_(1722.9510498046875), SC_(3180.828857421875), SC_(0.913384497165679931640625), SC_(0.3606527944318639142647664393896637139375753729722852737262040103908219641695453136139553729622961126), SC_(0.3420850150063576797970539825300214991419796153528742627223543545574122129808240426763729417823510615) }}, 
      {{ SC_(1737.734619140625), SC_(0.000441255629993975162506103515625), SC_(0.1355634629726409912109375), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(1784.9957275390625), SC_(0.28711086997645907104015350341796875e-4), SC_(0.3082362115383148193359375), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(1848.123291015625), SC_(0.00048024553689174354076385498046875), SC_(0.221111953258514404296875), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(1848.65283203125), SC_(24.98059844970703125), SC_(0.8350250720977783203125), SC_(0.9892406200969309745233783786304578441812145165495862703138749595543057652890938374265692201113950985), SC_(0.9841111680700725964246236205405944408491077986209480736023807958348075493596277894326056790779571806) }}, 
      {{ SC_(1870.2532958984375), SC_(0.13475679224939085543155670166015625e-4), SC_(0.8350250720977783203125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(1914.6778564453125), SC_(240454.8125), SC_(0.1355634629726409912109375), SC_(0.007702241172461522182927488337217654890776736581783007279895698144581955270976834168215586073013025344), SC_(0.00809799086706893437118501079989405633229602475317260622141758823859925522523234552626086471913041699) }}, 
      {{ SC_(1961.91357421875), SC_(1.22353923320770263671875), SC_(0.913384497165679931640625), SC_(0.9999189597740392322308096240304641080617951976014784116465947781536882151112287036726919302950329238), SC_(0.9985568240899114722326285268482529443193645124114394240580323456404549420348203292063890930257588808) }}, 
      {{ SC_(2004.1676025390625), SC_(0.1820631950977258384227752685546875e-4), SC_(0.905801355838775634765625), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(2021.546875), SC_(1278.527099609375), SC_(0.9688708782196044921875), SC_(0.6283279657023143372181239295335302986662395389955336828257980442608246564578954322734519507190584286), SC_(0.596711861087160501621963294567462333602685281737509419448705682767004635141951263589556756698539732) }}, 
      {{ SC_(2030.455078125), SC_(27725.34375), SC_(0.9688708782196044921875), SC_(0.07098647306540512237013190643602541398884032744035535137370146304660419212735086415593045193152771209), SC_(0.06553601281911640621795913050666991898076153128268375128057483694959203855736802792028818772210999688) }}, 
      {{ SC_(2031.1689453125), SC_(0.001671129255555570125579833984375), SC_(0.221111953258514404296875), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999968291028247470937869704075432259), SC_(1.0) }}, 
      {{ SC_(2160.7412109375), SC_(4.9396953582763671875), SC_(0.221111953258514404296875), SC_(0.9970211736764472981992584769643565936530529913415795324530390861333694978623965759899803537804442536), SC_(0.9985398559135000105076157678890167921545777454575400840676447268999825654520818710175094649905842631) }}, 
      {{ SC_(2176.594482421875), SC_(0.0227449946105480194091796875), SC_(0.905801355838775634765625), SC_(0.9999999999999999999999999999999999999999999999997945001902055666223173075251268943680454074283491904), SC_(0.9999965821776591191085125142449477558729166588337813785327104315900948957786446047724628964200694857) }}, 
      {{ SC_(2196.900146484375), SC_(0.4170066416263580322265625), SC_(0.221111953258514404296875), SC_(0.999722278253855111319270928574817283576951413134552336098369979384777072083791324431787579345450498), SC_(0.999990724925145146226544472674040172356197976002583110372862007084267207779086325010959802117294419) }}, 
      {{ SC_(2253.716064453125), SC_(0.00046744965948164463043212890625), SC_(0.905801355838775634765625), SC_(1.0), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999969891) }}, 
      {{ SC_(2265.716064453125), SC_(0.23549166144221089780330657958984375e-4), SC_(0.81474220752716064453125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(2269.919189453125), SC_(0.142603230415261350572109222412109375e-4), SC_(0.632396042346954345703125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(2270.08251953125), SC_(1.9198791980743408203125), SC_(0.3082362115383148193359375), SC_(0.9989851087751140414201639404022648120441634906485740303071471909255536803971106078679913484582938094), SC_(0.9995350234892520849190660987413299919959265928800584172560218236755153905777242686035828160762485838) }}, 
      {{ SC_(2303.33447265625), SC_(2434.39501953125), SC_(0.632396042346954345703125), SC_(0.4886226527026242425927877354548444502980087468839610348417351313432827275881412873727275046519901099), SC_(0.4837107443986534290816192714122409877735068066829240093612760027716889838437826459712602729026515089) }}, 
      {{ SC_(2341.2451171875), SC_(0.4919659197330474853515625), SC_(0.1355634629726409912109375), SC_(0.9995311091042536249169344075446825443137694299160853871208674503484886026279142192078030879612220254), SC_(0.99999419729365020246405250497877848408990220743565025539482969364049226089469404320605009933757253) }}, 
      {{ SC_(2403.10693359375), SC_(0.0393528044223785400390625), SC_(0.81474220752716064453125), SC_(0.9999999999999999999999403260396776824879680826025127868541699448561220230973300227979592388023804042), SC_(0.9999986735897355289420092114450719688929048173921047555391406481856923971942976430886050395627246893) }}, 
      {{ SC_(2438.42529296875), SC_(0.4890716075897216796875), SC_(0.81474220752716064453125), SC_(0.999989635462976810079963620979188718703151938381072626693636109688850602331761282464697559798490144), SC_(0.999648122130923654215652222595932330409371797656065246457273750406092502961552598983181348993097646) }}, 
      {{ SC_(2525.380859375), SC_(0.0469692982733249664306640625), SC_(0.1355634629726409912109375), SC_(0.9999893442739456990919099246506204772325062598512181204729379940520586175344390456574705987238265144), SC_(0.9999999999999999999999230233933863880642839717711215551703688036757194370986692471889994014590830451) }}, 
      {{ SC_(2563.04833984375), SC_(444797.40625), SC_(0.913384497165679931640625), SC_(0.005883569788134736855339814814576572977411718470890519107251477619292279607553921951851923073335478749), SC_(0.005576227185296419525370614800310638268542234296858363838212292724847599437465889941608049916705842887) }}, 
      {{ SC_(2587.197265625), SC_(0.001075554522685706615447998046875), SC_(0.3082362115383148193359375), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(2595.52294921875), SC_(2311.214111328125), SC_(0.8350250720977783203125), SC_(0.5359137034780078933541242790216228243797206248086254496941797970366959646254003758089146947037030627), SC_(0.5220292423804689268929343602454183808635079475840405577402086074589705486498222272331023396411710213) }}, 
      {{ SC_(2608.736083984375), SC_(0.0039381901733577251434326171875), SC_(0.913384497165679931640625), SC_(1.0), SC_(0.9999999999999779504826666101421960786833678166774406499573595671068833940511970169171200094007538076) }}, 
      {{ SC_(2609.55322265625), SC_(0.0041527482680976390838623046875), SC_(0.8350250720977783203125), SC_(1.0), SC_(0.999999999999999999999969854995653579710388859446743648689078341866550086726955797872617322024384578) }}, 
      {{ SC_(2660.373779296875), SC_(2036.114990234375), SC_(0.905801355838775634765625), SC_(0.5759643782653834530410184035816831426967687342521481657707037416445865813805822912570958715369606774), SC_(0.5569421620116699273953603600479229577907404528510450678765151384350618477825358205563826794921092394) }}, 
      {{ SC_(2676.193359375), SC_(457043.46875), SC_(0.905801355838775634765625), SC_(0.00596945690203513604046939447915064751124818502422664310189101628032489866704909111280054633816576759), SC_(0.005674308260742896421653219814794192782639924295378218904507290827993598155671523785984870391421115342) }}, 
      {{ SC_(2690.582763671875), SC_(0.22973056137561798095703125), SC_(0.632396042346954345703125), SC_(0.9999968026777637550886061753995980368500678801116814829226730461774328063491223312020933908450140479), SC_(0.9999635812226735212463411942883532232112708581243007118299873190536346294488385910984248326226035925) }}, 
      {{ SC_(2697.339111328125), SC_(0.3278447091579437255859375), SC_(0.913384497165679931640625), SC_(0.9999998487423327317214320267664313741434404368314828047691493007706295541973380475478308535506195685), SC_(0.999608590286994726692878508240889755385405234616077072026429542397076477085999223934366831492634963) }}, 
      {{ SC_(2717.423095703125), SC_(0.278538644313812255859375), SC_(0.9688708782196044921875), SC_(0.9999999990147941850848464304055922176494719255370290965616903869328997441632096847823978230374536375), SC_(0.9993908070566551778459866926184154377843076803552287888433797324837882183120205346207804226108452839) }}, 
      {{ SC_(2760.142333984375), SC_(46082.70703125), SC_(0.913384497165679931640625), SC_(0.05793868864177856762673169830489480311968897043247342612462355015145370485201769140170308060078635149), SC_(0.05509300753402485908932985040331754078244390764880917995012108815559292413950594907962263940652815708) }}, 
      {{ SC_(2810.3701171875), SC_(0.3556720912456512451171875), SC_(0.3082362115383148193359375), SC_(0.9998858193662071271068230990895756050112301362087060345336897160151302464172763025762778384844552219), SC_(0.9999904204596996728524701135675555196375785657564141391015135924607616110680140837439105366143661322) }}, 
      {{ SC_(2831.54541015625), SC_(2.64873027801513671875), SC_(0.905801355838775634765625), SC_(0.9996944080422230059353714096136281872138803195310585749660552892721876279066809824401791243822111955), SC_(0.998267141097206363369704384811010417520779981339965058385950195936543755085443504357062474732777082) }}, 
      {{ SC_(2853.04248046875), SC_(23.2325763702392578125), SC_(0.81474220752716064453125), SC_(0.9934289050610711926872877305799102861789539319388567469058440890371369917356324766205198358279338748), SC_(0.9904612941940193750881085688794720866543364319435342929953547231124453727260343519859354688310013782) }}, 
      {{ SC_(3066.23291015625), SC_(141.8632659912109375), SC_(0.3082362115383148193359375), SC_(0.9540345809743507228857632759697008707667696073237382336565231324955375503973526720917335856526773043), SC_(0.9576664920531744563115080997791539384609730001442212314186998214605909767884659248133006511360371453) }}, 
      {{ SC_(3100.1806640625), SC_(1447.2921142578125), SC_(0.3082362115383148193359375), SC_(0.6782973235197785337828958164963596024876434903190026795155097271656963151167170689070313395723063228), SC_(0.6852166903222047123364376387393308689134981289982658234597549641675163676925705830355672520807880833) }}, 
      {{ SC_(3122.51708984375), SC_(0.032955713570117950439453125), SC_(0.913384497165679931640625), SC_(0.9999999999999999999999999999999999989306181856043650431630628195331935669075838529720382300193527885), SC_(0.9999877398414850675780611754356863140399583357191174169787199209320861286553958146277847262904709834) }}, 
      {{ SC_(3163.536376953125), SC_(298.2393798828125), SC_(0.905801355838775634765625), SC_(0.920059752219469291849956189112384081775172652587453826467071447531722220196091626592646420633977314), SC_(0.9075195603111227038641386292126996925558951147404991526628169086696944305149031401604036329117705625) }}, 
      {{ SC_(3185.797607421875), SC_(2162.649658203125), SC_(0.81474220752716064453125), SC_(0.601660836210351783204688306722025568707360895039597871163740009686656862151462572451649638326957338), SC_(0.5896420124972164070566696133134090135467897097265324400462204710277490318832544941594848162476745779) }}, 
      {{ SC_(3222.951904296875), SC_(0.000114076086902059614658355712890625), SC_(0.12707412242889404296875), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(3231.15576171875), SC_(0.00042852279148064553737640380859375), SC_(0.8350250720977783203125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(3233.27685546875), SC_(0.302093982696533203125), SC_(0.8350250720977783203125), SC_(0.9999994447892267294233139471112205974004592316920241511137894817157201404407529047682597925924260588), SC_(0.9998223896785611945547756565446570159357924128712479023614927637876914862311322810257420681665151857) }}, 
      {{ SC_(3309.57666015625), SC_(19694.05859375), SC_(0.905801355838775634765625), SC_(0.1469229855485208567921653460230091013875483187048494397794438993777240604547424290009810249388549697), SC_(0.1408358815711554385131509290234356570253945657231749884496037976226980620540969037185163439067910986) }}, 
      {{ SC_(3389.960693359375), SC_(0.12216867506504058837890625), SC_(0.12707412242889404296875), SC_(0.9999259537447898868825577390775012297513622600448895371119263231177428977912282856651127244339228704), SC_(0.9999999999915518450489393977664257711333146761904721310137827185977849435131102071591360369308227246) }}, 
      {{ SC_(3482.687744140625), SC_(0.003345853649079799652099609375), SC_(0.9688708782196044921875), SC_(1.0), SC_(0.9999999872981465225555457428847342836637152633109757911884583978052129893856646090644418212099077675) }}, 
      {{ SC_(3489.989013671875), SC_(0.000430709798820316791534423828125), SC_(0.9688708782196044921875), SC_(1.0), SC_(0.9999999999999999999999999999999999979127030165009934195885406863326717048177962720921839396685282791) }}, 
      {{ SC_(3568.2431640625), SC_(352075.78125), SC_(0.8350250720977783203125), SC_(0.01019594166525430149200435838281382008328524986388404799066931478898386639319410545258404628914721996), SC_(0.009870339750212606640487932293679734492824862862279135706943791162813826791617088524661190850446627936) }}, 
      {{ SC_(3614.7607421875), SC_(3.387983798980712890625), SC_(0.632396042346954345703125), SC_(0.9993055338179926852432417628208893638974855042589652268759075685229748924412455994106741821409536363), SC_(0.9989812199137671427034829693872955967017844185198404867257863200294211515225439402383874784030999647) }}, 
      {{ SC_(3614.799560546875), SC_(45861.59765625), SC_(0.221111953258514404296875), SC_(0.07215972343674328534125793976092356612991602902508682045746913995365010128175170574645901372835420733), SC_(0.07395774731616175365121294218727555643474205035576718335442870073124915950215047272567571773721378778) }}, 
      {{ SC_(3663.94873046875), SC_(125.4974365234375), SC_(0.1355634629726409912109375), SC_(0.9636698179244358370075827204225064342743739819494816770395966196846755902198769861994239504220707161), SC_(0.9700602295021235566151204028964219840324224454111938529853432604522149921958296041358869402723954454) }}, 
      {{ SC_(3684.808837890625), SC_(238875.625), SC_(0.632396042346954345703125), SC_(0.01527411134756941588208272991865420085457953266889347467596474560538035647522307273463650582882173711), SC_(0.01510613284570503043883141259390742600784231438883420598012672463459388411549493956985151501944564418) }}, 
      {{ SC_(3718.935546875), SC_(284.95684814453125), SC_(0.913384497165679931640625), SC_(0.9343002484793394598061532039585267638648367326645466846836207656617475781598506111206012517209398915), SC_(0.9232377508750972980410657749500754754537058361584243935508019016092258625821350472700745772306893746) }}, 
      {{ SC_(3726.241943359375), SC_(28.8971099853515625), SC_(0.632396042346954345703125), SC_(0.9928610810200388210907966688423646914054038583422267319949449595690082597597681099943865868698865386), SC_(0.9919027020127570907946594278672321549294981512095577065787819717511430255743828194689406323031051264) }}, 
      {{ SC_(3736.384033203125), SC_(0.0043655070476233959197998046875), SC_(0.81474220752716064453125), SC_(1.0), SC_(0.9999999999999999999999993748012553811423167725010358722359229555032171580020828835168528500926215949) }}, 
      {{ SC_(3742.142822265625), SC_(0.02163856662809848785400390625), SC_(0.8350250720977783203125), SC_(0.99999999999999999999999999999999999999989580969181133077565088300611296068528387106664293775844641), SC_(0.9999999632378737581279756434663366643427468081864484836392830904846190038505663895924515045431713984) }}, 
      {{ SC_(3810.80908203125), SC_(139.7005615234375), SC_(0.632396042346954345703125), SC_(0.9656994100836084250851349956718237187279129084225772489488875092919578125543391477153399987296295341), SC_(0.9637140890060746075785115677750211387703348994647234860375837469532807115995083354679581909749157685) }}, 
      {{ SC_(3812.892822265625), SC_(0.290711686830036342144012451171875e-4), SC_(0.9688708782196044921875), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(3826.86083984375), SC_(0.00044492297456599771976470947265625), SC_(0.81474220752716064453125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(3860.85009765625), SC_(408688.75), SC_(0.81474220752716064453125), SC_(0.00949259190147308533885844990874001289337449382535665188199859917456402134908479020354858020544697019), SC_(0.009224116652405714563852972844552716825857277321889475854940187203130779474329803304850557871283837041) }}, 
      {{ SC_(3962.59228515625), SC_(31.1610393524169921875), SC_(0.1355634629726409912109375), SC_(0.9906557647113291904228871034741125890116344131826601711573860953261322220025380817682703167824804915), SC_(0.993704578123301685297170055863078166008518063506092591795067688150704553718825177098523279660344358) }}, 
      {{ SC_(3970.181396484375), SC_(0.46857738494873046875), SC_(0.905801355838775634765625), SC_(0.999998739304641240665798515343386716122952354802124231188426651566835886937026512354778000578720562), SC_(0.9996646897162708245178638728882630500119858099464470487598570874947359407548015506968273336983955274) }}, 
      {{ SC_(3974.75341796875), SC_(31.3806819915771484375), SC_(0.221111953258514404296875), SC_(0.9911358727449760088016955162077855948155384806713641409048077352354988412806331502267520169365728745), SC_(0.9932646708969124740118591523047195616848427514069229973665896200941575266262691483555793366177920613) }}, 
      {{ SC_(3994.4755859375), SC_(1430.89794921875), SC_(0.1355634629726409912109375), SC_(0.7296686519812832628416786186422783938815380308433676396174676803368847907844344352504197366735693985), SC_(0.7428354249948457078049928733148438491510476066250204974319160776931154865245064778355332191466472828) }}, 
      {{ SC_(4007.785888671875), SC_(325072.90625), SC_(0.12707412242889404296875), SC_(0.01196100624209917804150813243629156970775039664320000955363589445506592917804205925529691813999050435), SC_(0.01239705344161176054423664564839126888699548707588123808247560616410530304873034422600030009838041761) }}, 
      {{ SC_(4032.44970703125), SC_(0.014052885584533214569091796875), SC_(0.3082362115383148193359375), SC_(0.9999999999999994242619832814584104437618461608008267533528341413296516087350029420108163771433050611), SC_(0.9999999999999999999999999999999999999999400387554711202143670124844581193075515778313430411904586605) }}, 
      {{ SC_(4037.3095703125), SC_(16.8816509246826171875), SC_(0.12707412242889404296875), SC_(0.9946689119433654291169755193506694451155594497290568310006784320554416288511839365840809938936515889), SC_(0.9969540151350993618676408642841092741290954007495931598052108360499163656158180822381985884776135984) }}, 
      {{ SC_(4055.591552734375), SC_(3.02400684356689453125), SC_(0.9688708782196044921875), SC_(0.9998310071199696605529884495998945402974345492655730361137099132480577625222867244830441942883936962), SC_(0.9982827612774896758810839659332114396955952116330140012658311701434193819817317057136685835417761509) }}, 
      {{ SC_(4069.31787109375), SC_(325513.34375), SC_(0.3082362115383148193359375), SC_(0.01224980507511926066718542412122351119260473909794369869196839275988273545703738733305073886069575404), SC_(0.01244247883922169929502065155491433727664623825347333494596043124304911321525879113577916036941090879) }}, 
      {{ SC_(4178.6318359375), SC_(46566.515625), SC_(0.8350250720977783203125), SC_(0.08353395362030079782310630311506955211248576656933717858094505330555364771051041075755350947976198444), SC_(0.08115638133603639090307112471946075681599248640474962292497050093068216011519298980008633199078008674) }}, 
      {{ SC_(4236.8154296875), SC_(2638.01123046875), SC_(0.12707412242889404296875), SC_(0.6095883164573813537372133347926276691083297124064177532915269555343257570599557890302986601968825236), SC_(0.6229641090145724214005595647109580018938687367969042638185339313938844815878470418635960738883458639) }}, 
      {{ SC_(4264.560546875), SC_(235044.84375), SC_(0.9688708782196044921875), SC_(0.01832781831012444645573088541858009222094238006932617902401030422570011141005548953912176146384029192), SC_(0.01731939350464435829768005897542709000567868851782509796715659633851286729039900744184903510212885932) }}, 
      {{ SC_(4294.29833984375), SC_(39.17559051513671875), SC_(0.913384497165679931640625), SC_(0.9928463399880940817313506563943843068270382379667783103945747794935661911269021076672909658187360577), SC_(0.9889441543057289409025478181939523464524357644812228422522709522945489884992522139343776684774546924) }}, 
      {{ SC_(4329.69384765625), SC_(0.0356505475938320159912109375), SC_(0.9688708782196044921875), SC_(0.9999999999999999999999999999999999999999999999277782598188671506144465573936683884965170624568377927), SC_(0.9999269875859298070450425097037758320772474530758064879209023307969494680417617872484766056562000202) }}, 
      {{ SC_(4484.44482421875), SC_(0.0347605831921100616455078125), SC_(0.632396042346954345703125), SC_(0.9999999999999999595768717562151956829780307840435486289224606951905988945844102263311899820359933713), SC_(0.9999999997575176091976306328037440753277400584403248355983219243813182453273606780477920050821374753) }}, 
      {{ SC_(4571.689453125), SC_(0.30711162253282964229583740234375e-4), SC_(0.913384497165679931640625), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(4577.5576171875), SC_(462.9542236328125), SC_(0.221111953258514404296875), SC_(0.9050502722848642877389160969301943553513530305672240201071013950105214002464574293335512721689885972), SC_(0.9113005883994987174769648017930720458343401299944846190600182803449500339869043998585196566180610166) }}, 
      {{ SC_(4655.2021484375), SC_(0.0004921201034449040889739990234375), SC_(0.632396042346954345703125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(4684.38916015625), SC_(48115.4140625), SC_(0.81474220752716064453125), SC_(0.08982689184465506013087772637135936612701658646856888580997903532046524888257909532992446285452510119), SC_(0.08761069583661007132118290196898482550672212377309683288687036071462483273406451170626059400082729114) }}, 
      {{ SC_(4694.7021484375), SC_(15396.767578125), SC_(0.1355634629726409912109375), SC_(0.2303830162160288138894867524534260691663758945255666422001639201485209799768000010291830451480509929), SC_(0.2369535887943190731212944596031958384216222235986949855803346052424170867868112939477674707975642152) }}, 
      {{ SC_(4730.45458984375), SC_(39692.90234375), SC_(0.3082362115383148193359375), SC_(0.1057483458506921528330397090365659605110894139969411702951717734536310999323097278373310127101509832), SC_(0.1072143109795991704457544292330361392694948522543557481009433879614166286872309214709649776349197912) }}, 
      {{ SC_(4742.923828125), SC_(4.058574676513671875), SC_(0.8350250720977783203125), SC_(0.9995442470534273155584382837915646735436176863382243742446738471563140716281202290406006193325456334), SC_(0.9987520256430379371188752129865196354071055254101671387670505707008001855071100931352494993481108559) }}, 
      {{ SC_(4813.82861328125), SC_(366.26776123046875), SC_(0.8350250720977783203125), SC_(0.9327645080514947261497972101825048437441388896488369645757874186333606746848469030515421942822179822), SC_(0.9258276059571410675441278822187742987754175951068400252196364353274414399291099221534842328948949547) }}, 
      {{ SC_(4827.74365234375), SC_(3.2813909053802490234375), SC_(0.81474220752716064453125), SC_(0.9996516603409298014802771362669772691879583134922875961248950194642818425873078740444270657387912987), SC_(0.9990157498750257278622233771988785189756491595220493034072588240934993687308449853074626235836147666) }}, 
      {{ SC_(4931.3408203125), SC_(0.003918074071407318115234375), SC_(0.905801355838775634765625), SC_(1.0), SC_(0.9999999999999987656785162492447198043398096556864297466031265838952066059389595448844588550589683033) }}, 
      {{ SC_(4951.73876953125), SC_(0.0031504244543612003326416015625), SC_(0.12707412242889404296875), SC_(0.9999999999999999999999790632612544297245293487847972495825034992111437380717518449940294840176812509), SC_(1.0) }}, 
      {{ SC_(10727.1015625), SC_(20.6144351959228515625), SC_(0.3082362115383148193359375), SC_(0.9978955686639924254846463082255888815844409784459276612164324249474215720483426160490913925043215784), SC_(0.9983145054162888476351953692555791697469098543194412446337832240061564240355874779954246841172294519) }}, 
      {{ SC_(10865.9921875), SC_(0.472520351409912109375), SC_(0.1355634629726409912109375), SC_(0.999902527598677627627099893517024709728513497680107262208305775498427682062489516173726061536901377), SC_(0.9999989552266855229679184203491020048002641601761824100625539562380316530160690692516731246125089535) }}, 
      {{ SC_(11005.3994140625), SC_(0.00037013436667621135711669921875), SC_(0.913384497165679931640625), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(11199.677734375), SC_(2.693786144256591796875), SC_(0.8350250720977783203125), SC_(0.9998945175442020862399209110544974197462276260707163666707750050548457250473333718802620210069406171), SC_(0.9996270010697969051721123251770830488212868926888012470749945422020215041230377098617032765443502779) }}, 
      {{ SC_(11672.794921875), SC_(151.0876007080078125), SC_(0.3082362115383148193359375), SC_(0.9867256703837258484871249098586245266682605703847412280027938776483286303881310547703725105188179769), SC_(0.9877591279611092091737850233598184335139215256189040514216394070669543692230601104971020325274581911) }}, 
      {{ SC_(11802.0439453125), SC_(0.0215594768524169921875), SC_(0.81474220752716064453125), SC_(0.999999999999999999999999999999999999994727135521919649331606127072716166264835163260114994289415073), SC_(0.9999999963872231589868600884246281302817221464200328015349626830134887406294398937404650342191563155) }}, 
      {{ SC_(12400.75390625), SC_(0.351217095158062875270843505859375e-4), SC_(0.913384497165679931640625), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(12677.8505859375), SC_(38.009876251220703125), SC_(0.1355634629726409912109375), SC_(0.9964747986834723654193655436139027223181811561058840522862615540981362605148257260539509008912402134), SC_(0.9975358433153816783430513381551742890265912265148095987717614751202649401165295466016711394222147967) }}, 
      {{ SC_(13303.708984375), SC_(16683.587890625), SC_(0.905801355838775634765625), SC_(0.4474193622057988735589416805939281999767476359286401420686639949729906805819151696953663551119236678), SC_(0.4398721113279183668846926392489806951192851948047342135941452369641205350268715845316582269415674984) }}, 
      {{ SC_(13483.087890625), SC_(3.4626166820526123046875), SC_(0.913384497165679931640625), SC_(0.9999025526575328763219951238989195750265155710771616645986677866598951145076440879410435362197355439), SC_(0.9995421784522867502900163142955100750957382947411387417744911266063320671585631266970901388611131922) }}, 
      {{ SC_(13500.0146484375), SC_(0.0147750042378902435302734375), SC_(0.221111953258514404296875), SC_(0.9999999999980986282677136384284345207974877883583935407969120554109052108644598241612156406538435344), SC_(0.9999999999999999999999999999999999999999999999998153430035112169598360277026763715460122168952759577) }}, 
      {{ SC_(14277.6669921875), SC_(275.66424560546875), SC_(0.632396042346954345703125), SC_(0.9814597781115358811833627161047215221039299483734665999280352748833869329173047464238397057873053886), SC_(0.9806959269958255941975395587016036875822285206556720067002109445633959146970912522101970698705966525) }}, 
      {{ SC_(15026.18359375), SC_(191435.6875), SC_(0.905801355838775634765625), SC_(0.07353245190202421499485532824677833370778185184468790526084857388185721139814974400179596252891126533), SC_(0.07202848348546586671421776766625943413371958435196993074213136623105266325953701314322750209656968983) }}, 
      {{ SC_(15514.759765625), SC_(469.305145263671875), SC_(0.12707412242889404296875), SC_(0.969111114524703727445291304986292062169149765330399122797130089976810503311462271663381931205633886), SC_(0.9721554648035620136677684662661032647815655025206597529404303370691064089963014367498118632463759816) }}, 
      {{ SC_(15687.4873046875), SC_(0.000288298237137496471405029296875), SC_(0.905801355838775634765625), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(17074.203125), SC_(0.00107910879887640476226806640625), SC_(0.8350250720977783203125), SC_(1.0), SC_(0.999999999999999999999999999999999999999999999999999999999999999999999999999990941596841975836224893) }}, 
      {{ SC_(17224.67578125), SC_(0.0225061289966106414794921875), SC_(0.632396042346954345703125), SC_(0.9999999999999999999999983783551868046774596052440632041938455123758870210914281070005844499896783757), SC_(0.9999999999999522895369366162149259379463875654155117674501390313725113526863394858038435946209224247) }}, 
      {{ SC_(17285.642578125), SC_(252.595855712890625), SC_(0.221111953258514404296875), SC_(0.9849141042675603231144515179794140108587757688361283173548238059059996621083269170269888166833341869), SC_(0.986295849997757751831154068110663161330486304501040391103777557052040528679183855968227566880473113) }}, 
      {{ SC_(17364.01171875), SC_(0.0032844119705259799957275390625), SC_(0.12707412242889404296875), SC_(0.9999999999999999999999653007820588301033050715847054451804777051556330078548218276211537327732471081), SC_(1.0) }}, 
      {{ SC_(18709.283203125), SC_(311063.03125), SC_(0.8350250720977783203125), SC_(0.05712634471226769957760487161748027150822886849830307026706486598760198647036235929659506950273292972), SC_(0.0563414470998018054256062249684859150086943264137740179368722714803209410941185637765246088408408302) }}, 
      {{ SC_(18712.064453125), SC_(125.128173828125), SC_(0.1355634629726409912109375), SC_(0.9927032051201230904696940776616516369870796678085998023598946306579609043011734841579182623592187432), SC_(0.9940041955099621353883837610970256517983540238810168221044659739068241188141381975459097288757103277) }}, 
      {{ SC_(18950.81640625), SC_(0.02248309552669525146484375), SC_(0.12707412242889404296875), SC_(0.9999999283820834756332139807090482376302859631771417010547002349427910858127512481879637289366813636), SC_(0.9999999999999999999999999999999999999999999957339804623749150674917244604820125170867241693793878826) }}, 
      {{ SC_(18966.861328125), SC_(0.00021034784731455147266387939453125), SC_(0.3082362115383148193359375), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(19108.51171875), SC_(1.5829699039459228515625), SC_(0.3082362115383148193359375), SC_(0.9999005660289408808287488446768417432534831175543654941728338529665751672743724386973426527638215335), SC_(0.9999585148545766802527122293849186916878121148836667995614994145683867934860445764434343245261737478) }}, 
      {{ SC_(19766.611328125), SC_(1197.8387451171875), SC_(0.8350250720977783203125), SC_(0.9444255606618057912190171626867014506809355328077332452906022372567625428151975262732751300102423966), SC_(0.9413025433892331990072000089130898601128139314941542344353260926967844780346532513471692820347439945) }}, 
      {{ SC_(19945.158203125), SC_(1.323333263397216796875), SC_(0.1355634629726409912109375), SC_(0.9998742337659471264589891405151776780340992277030678302158013696254961400783537165625591532881579503), SC_(0.9999858271068561353597274455936624805404309978459386841555294939078049452854553616112298661320907262) }}, 
      {{ SC_(20612.880859375), SC_(0.0045445901341736316680908203125), SC_(0.913384497165679931640625), SC_(1.0), SC_(0.9999999999999398876927517487570928867858317709326610748968162185799411472499293440989664961146403825) }}, 
      {{ SC_(21002.7890625), SC_(3.6717395782470703125), SC_(0.12707412242889404296875), SC_(0.9997208981772715353346569701870259144957868588972129326730901618680209630371943500804033645969721831), SC_(0.9999199396978807617479475762835656869845780347204973233021308429276294404668427447504981645802765082) }}, 
      {{ SC_(21820.291015625), SC_(4256.572265625), SC_(0.905801355838775634765625), SC_(0.8397722044669133434188582508636213285212266912090034802586720593470585040870749373795587099541807801), SC_(0.8337517048186985599064171658551456688605809912406946491662285811081335376247624183743152675046530719) }}, 
      {{ SC_(22356.583984375), SC_(457832.53125), SC_(0.913384497165679931640625), SC_(0.04697248603589743079989187832250505557493791253633167587859474846600600779918374979564194592783709561), SC_(0.04614433675033637931978298157759241163918754213994435319017383531135194934480024724812588776402391934) }}, 
      {{ SC_(22697.115234375), SC_(0.3655127875390462577342987060546875e-4), SC_(0.12707412242889404296875), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(23467.970703125), SC_(2143.580810546875), SC_(0.632396042346954345703125), SC_(0.9168989447325276384087200175119604713614129900252388499824333876313752169709508936883689020423957098), SC_(0.9157285302919133836212637600431085604202514997159450246927562880855063033131047922071930670406502643) }}, 
      {{ SC_(23857.951171875), SC_(344059.4375), SC_(0.221111953258514404296875), SC_(0.06453365017911071192761837501125786989991975047335272960577931608804164272657159268862668533873761162), SC_(0.06515759634224947290553337355867883193493040865840623863527159097093338950278635753186320335338279283) }}, 
      {{ SC_(23897.50390625), SC_(0.0264662839472293853759765625), SC_(0.905801355838775634765625), SC_(0.9999999999999999999999999999999999999999999587245315531894780034512774942564949489218944664030370337), SC_(0.9999994209979344148377069200964884939258926474262867574596087610886833837297109006751033215153849676) }}, 
      {{ SC_(24178.228515625), SC_(454.8056640625), SC_(0.905801355838775634765625), SC_(0.9826550883174240389980247853034133059082404981104328100739816843469140526141807274610326295355789356), SC_(0.9803993983817405950297585799817063026832491221199635080272610777098276397446918282849078047379544755) }}, 
      {{ SC_(24181.37109375), SC_(463750.875), SC_(0.12707412242889404296875), SC_(0.0492047547338224323276341324386521173764842030652175465567778905332711436645993127453534699385571478), SC_(0.04991335636853231538939341877236745831289841064190155436394088895104253175531206033337030015518113149) }}, 
      {{ SC_(24202.947265625), SC_(0.000431136810220777988433837890625), SC_(0.1355634629726409912109375), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(24814.5078125), SC_(0.0022801845334470272064208984375), SC_(0.221111953258514404296875), SC_(0.9999999999999999999999999999999999999999999999999999423737912821878740225410135578559689737301822743), SC_(1.0) }}, 
      {{ SC_(24942.55078125), SC_(0.03099299408495426177978515625), SC_(0.1355634629726409912109375), SC_(0.9999997890509072921804849955268801103638939255783240450779496624413730309722694341249026819431248339), SC_(0.9999999999999999999999999999999977008559905607962233321801963118504181352459825413430951818675458934) }}, 
      {{ SC_(25332.25390625), SC_(0.1855850517749786376953125), SC_(0.8350250720977783203125), SC_(0.999999998451958054202392463336520764319591183978363832021479678406339155012894573745241012414349567), SC_(0.9999876123731212498822226827292402594334039685112971131981591478082034172634404446558974299300249778) }}, 
      {{ SC_(25354.7421875), SC_(0.02945673465728759765625), SC_(0.9688708782196044921875), SC_(0.9999999999999999999999999999999999999999999999999999999840951977145201086924102438429110315103896433), SC_(0.9999902839112550619518711055280174475112763268432701940883875555592708975953441202839453595637482537) }}, 
      {{ SC_(25489.81640625), SC_(0.00049681845121085643768310546875), SC_(0.8350250720977783203125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(26425.1640625), SC_(307.398162841796875), SC_(0.913384497165679931640625), SC_(0.9893782255633878133215110410411045634323733199919821453653986858960046992944871757946795992784130266), SC_(0.9876029174151440488349138533030389582787883814645697521271512826294733889438640441324531722471741995) }}, 
      {{ SC_(26463.7421875), SC_(19163.873046875), SC_(0.12707412242889404296875), SC_(0.5773587799210139835895410281967560412937529205679533550572817474774849892008131263979578267870911717), SC_(0.5826284792367414872899586808685685956725155939617726841767169154742728728762507956661000517313657644) }}, 
      {{ SC_(26537.091796875), SC_(270229.28125), SC_(0.81474220752716064453125), SC_(0.08988970588531338088302212964959781346369557053594521355011938810075437888886515055501217478763345617), SC_(0.08895156451012850787667613899850535727806206351279083144520437712393991439902344814299933789139693542) }}, 
      {{ SC_(26844.490234375), SC_(0.000473332009278237819671630859375), SC_(0.9688708782196044921875), SC_(1.0), SC_(0.9999999999999999999999999999999997982284687745902439702744724182541762695122090024552067473007140381) }}, 
      {{ SC_(27758.564453125), SC_(0.18002581782639026641845703125e-4), SC_(0.905801355838775634765625), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(28065.55078125), SC_(3.5871093273162841796875), SC_(0.221111953258514404296875), SC_(0.9998276723599410557319810329639575626259550862677278639207688486481367312960811822076433550491230291), SC_(0.9999261730973619097497356269425110589936821308609402249314266363573075960544358818173693741018341297) }}, 
      {{ SC_(28187.794921875), SC_(384992.25), SC_(0.632396042346954345703125), SC_(0.06835361760689158500326796469077140866256936059900593976741755051656277535675801795295066703834586806), SC_(0.06808830567480254515209379854228246312426351965353158104178383411363259331584031013698580024467712761) }}, 
      {{ SC_(30225.46484375), SC_(0.1016343958326615393161773681640625e-4), SC_(0.632396042346954345703125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(30472.796875), SC_(42078.734375), SC_(0.8350250720977783203125), SC_(0.4218010053615211357248356477540027371482660356747081739950736713296920949487766057782283939170652577), SC_(0.4182307248027768337746631949972411697153189925034155632257392128104074203602443267899162709267230083) }}, 
      {{ SC_(31113.873046875), SC_(2243.24951171875), SC_(0.9688708782196044921875), SC_(0.9352856822910349317324615526123413510155389751849792954434893684863793311280549743979385102829868276), SC_(0.9301725043843851659278657711289890824290617390619050707890761382714767104253160685040980089962301817) }}, 
      {{ SC_(31202.068359375), SC_(0.3144348561763763427734375), SC_(0.9688708782196044921875), SC_(0.9999999996360771443541725187564450517217830740998692948218123846219876242706125276069352982510308917), SC_(0.9999430150312608531914833526722188840347720843665370345138151455611847710045039658415224704716433894) }}, 
      {{ SC_(31365.501953125), SC_(42.0266265869140625), SC_(0.8350250720977783203125), SC_(0.9988625768098143974891208370985013656900157626652596157845079190489033072824896520246067538107281696), SC_(0.9984622744838168447439171759823789324759706622941499941125294232748312649471942664985703650498189881) }}, 
      {{ SC_(31426.568359375), SC_(3.5692617893218994140625), SC_(0.905801355838775634765625), SC_(0.9999545975847827574241102216530335162079695930944686171855960909599017574876859741734108306449645582), SC_(0.9998029307978248116369285497338433098615201938022227386805376199576193261592529697696982404954384888) }}, 
      {{ SC_(32071.69921875), SC_(37284.46484375), SC_(0.632396042346954345703125), SC_(0.4630602898402140381369276786929510276297830104230376122113078642985108959063567005337319286248343264), SC_(0.4617796999346913857406108973215305638038273581939198129540951663437446604827893445010330323573540936) }}, 
      {{ SC_(32841.03515625), SC_(0.00211882009170949459075927734375), SC_(0.81474220752716064453125), SC_(1.0), SC_(0.9999999999999999999999999999999999999999999999826741326053473323363767964902211257668520847421892785) }}, 
      {{ SC_(33019.796875), SC_(0.3179961740970611572265625), SC_(0.913384497165679931640625), SC_(0.9999999902555834352590615623476815609954383530917450155215110987540030639507876278929569761484087924), SC_(0.9999688093219751702819735398712145954760207022805299877046522812391023849697657247999537450926365041) }}, 
      {{ SC_(33341.328125), SC_(44482.7265625), SC_(0.3082362115383148193359375), SC_(0.4275304102578931194414209320667100468657295612481723446649145788627690273404144540362880182671916184), SC_(0.4293072990948414151592224859188384687988032523264524671078099200982593071393874400896545736722464192) }}, 
      {{ SC_(33342.82421875), SC_(33088.58203125), SC_(0.81474220752716064453125), SC_(0.5036507733336725191268809149164410412947751143494842893453277223941530096841116403984198058937958244), SC_(0.5001763726983576277345596011231961518960725294646717535086548571283889408651216297091961115557439058) }}, 
      {{ SC_(34105.53125), SC_(27232.5546875), SC_(0.1355634629726409912109375), SC_(0.5538175334012864242421866454077820828419632128250729290648244448710306286694652123801499778328731217), SC_(0.5582329274506246864727650871515081867137172675338621376246310076871741462531436281417650715688688868) }}, 
      {{ SC_(34199.625), SC_(0.000267275259830057621002197265625), SC_(0.81474220752716064453125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(34657.7421875), SC_(103.4410247802734375), SC_(0.81474220752716064453125), SC_(0.9972873131409786240435473974447900318168450000207416171089424854742680051082201725630979222283067374), SC_(0.9967649319008550750367403253702655655195218320118737631930475353151207906448758332762913290553948139) }}, 
      {{ SC_(34691.16796875), SC_(0.1412391960620880126953125), SC_(0.905801355838775634765625), SC_(0.9999999999990172889946551705628677906379459331818766888858057949390918356322653129074946230624519904), SC_(0.9999872164666197279998010605176676346865806440600722213798387753412098657955689268435626236981822648) }}, 
      {{ SC_(35037.50390625), SC_(11.6895084381103515625), SC_(0.9688708782196044921875), SC_(0.9998234270777126043310265470077550933170511006575704887520639104792556972872944189656868508124823306), SC_(0.9994627474382952507115836953782141880802342937787698921192662983636055431679919526515543879508391586) }}, 
      {{ SC_(35093.859375), SC_(0.19068343937397003173828125), SC_(0.12707412242889404296875), SC_(0.9999871806061984271732299759116531182406790284572528302456867722402300211744985059519928357557745093), SC_(0.9999999996301680530631740729459592647833045435034606785540769256302644818544393758145863144095721769) }}, 
      {{ SC_(35247.55078125), SC_(0.00044111299212090671062469482421875), SC_(0.12707412242889404296875), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(35426.453125), SC_(0.25611940145608969032764434814453125e-4), SC_(0.81474220752716064453125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(35604.6640625), SC_(0.0404350571334362030029296875), SC_(0.3082362115383148193359375), SC_(0.9999999982052466902689652389353026138870205028748927103503499162410021329021248584008630007166311474), SC_(0.9999999999999999962712981374584233401077240139155282675794938037697112418125551075276477108276706973) }}, 
      {{ SC_(36098.04296875), SC_(0.00035800389014184474945068359375), SC_(0.632396042346954345703125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(36424.671875), SC_(0.020534180104732513427734375), SC_(0.913384497165679931640625), SC_(0.9999999999999999999999999999999999999999999999999999999971367978193378361150141335731041897271126242), SC_(0.9999998085686165944084737902216262370234716796776713911046762618617779792449893745345976374575227153) }}, 
      {{ SC_(36495.27734375), SC_(2484.92626953125), SC_(0.81474220752716064453125), SC_(0.9373610983375433097891510458953221736075513997956681978308435675509206174312092261580205110553337405), SC_(0.9351450231650898190566776793089120341064078951111779236038044146938071453501510541290424017262886583) }}, 
      {{ SC_(37065.7890625), SC_(2610.560791015625), SC_(0.1355634629726409912109375), SC_(0.9328324061749901477199980266057720850561117043468208396668583199115369486387621698740948543001373855), SC_(0.935571723962425739160846855591352535089606447437035153695552480633269820208842958319498810147878698) }}, 
      {{ SC_(37207.1328125), SC_(3485.194091796875), SC_(0.913384497165679931640625), SC_(0.9162359801756381916619903730850397690369026385969008183038029762438351092364731126544777673951471186), SC_(0.9124575118836326646661657257635725319350531779780235779359233296229778650365705081171791831304614365) }}, 
      {{ SC_(37353.54296875), SC_(12.2282161712646484375), SC_(0.632396042346954345703125), SC_(0.9997117455109351904250178079495255884828394426149510195997611923636414735786233736938278808908045189), SC_(0.9996494466116136474250271435975043225817563667504613499261928478611292984517252413381827376599079152) }}, 
      {{ SC_(38782.8046875), SC_(35499.7734375), SC_(0.913384497165679931640625), SC_(0.5245940877071222447702286245642860923977179597665014196540467551126391893142226516052331800615389139), SC_(0.5196020905568873007190308283455495824249036862537454471417268359542118308530726511043585635114772211) }}, 
      {{ SC_(38926.94140625), SC_(0.02303241193294525146484375), SC_(0.8350250720977783203125), SC_(0.9999999999999999999999999999999999999984519515857123747111664771943786921555896538092060346705621197), SC_(0.9999999941422836004944425708023634135564157427206710012579559004033932392630523039546744179125677859) }}, 
      {{ SC_(39031.0078125), SC_(0.00275336927734315395355224609375), SC_(0.1355634629726409912109375), SC_(0.9999999999999999999999999998483268295522441292848378563231127171871478321527275417841693362459583778), SC_(1.0) }}, 
      {{ SC_(39044.17578125), SC_(143514.0), SC_(0.9688708782196044921875), SC_(0.2156643567181691349452732752770441344783939727522165345224911366796775156310940764296046424736894347), SC_(0.2120858434586875886433577306724960649525982151352921991683831958353923352314164621433779190944636427) }}, 
      {{ SC_(39369.1875), SC_(0.004928432404994964599609375), SC_(0.632396042346954345703125), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999990673811), SC_(0.9999999999999999999999999999999999999999999994032805030857586777254302553479107282173081241040464806) }}, 
      {{ SC_(39833.8984375), SC_(0.413198292255401611328125), SC_(0.632396042346954345703125), SC_(0.9999982517115124650308690547532739206726478482881555297934034242787259053082912851755543196518077233), SC_(0.9999924036933725301364996418913581513476350867393571622353148774769074338048074892075971510122481897) }}, 
      {{ SC_(40020.80078125), SC_(38980.671875), SC_(0.221111953258514404296875), SC_(0.5052161246750960764817102845196591027226306176086099417546299230369548032879389576104957911828927976), SC_(0.5079498640781166889039750657370799168571987037067260299656251606102713024934446176355388053306345133) }}, 
      {{ SC_(40673.2578125), SC_(3205.197998046875), SC_(0.3082362115383148193359375), SC_(0.9263355106719371694972929050694909016098674526227758596557034989600933217085050801752787872730331786), SC_(0.92757982388806061735503563379035771674110657024691566407181227695615343722302973333371027026711055) }}, 
      {{ SC_(41349.45703125), SC_(38.29947662353515625), SC_(0.81474220752716064453125), SC_(0.9992094455744368565789639819882726686306533933684699082366719140812284443895180973475189396303061871), SC_(0.998942961942599242069505094809871757368152730348999418241593258651518212760990219472867560134029507) }}, 
      {{ SC_(41562.9375), SC_(0.26003241146099753677845001220703125e-4), SC_(0.221111953258514404296875), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(42022.34375), SC_(0.4905900061130523681640625), SC_(0.3082362115383148193359375), SC_(0.9999879524298522425850660454104234530552499873604393279128367491253924250516140773312732361897225534), SC_(0.9999982258216174703756687222830066029419976175185290234480475061852674546108333212849682715012294103) }}, 
      {{ SC_(42083.65625), SC_(4.19858837127685546875), SC_(0.9688708782196044921875), SC_(0.9999697081182208270612909815895114336712074219961433290572810286189140088169754703035722432085055647), SC_(0.9997922413437575421696407083486105260221466508701881856007852891982163281972582594617633735134469065) }}, 
      {{ SC_(42177.98046875), SC_(2.612369060516357421875), SC_(0.632396042346954345703125), SC_(0.9999568647518409435414169911503960687007407534904236936413833710812576633954985745197859671608937712), SC_(0.9999328791004701063460751135525235300877254634646759472610840911055309210186397783551617740479692473) }}, 
      {{ SC_(42524.5078125), SC_(0.2802095115184783935546875), SC_(0.81474220752716064453125), SC_(0.99999996049223411512152794723833446386041020881833257485027511399693694701343634482745458658873267), SC_(0.9999891117732024108694503606111264063337705820526410692720332729516063382760413368785711130124440547) }}, 
      {{ SC_(42581.58984375), SC_(0.37374455132521688938140869140625e-4), SC_(0.1355634629726409912109375), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(43662.40625), SC_(0.0046618557535111904144287109375), SC_(0.3082362115383148193359375), SC_(0.9999999999999999999999999999999999999993964212845726553749568327761008131513541801090475135742185777), SC_(1.0) }}, 
      {{ SC_(44090.55859375), SC_(0.10735684554674662649631500244140625e-4), SC_(0.3082362115383148193359375), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(44669.99609375), SC_(0.4677930337493307888507843017578125e-4), SC_(0.9688708782196044921875), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(45414.3828125), SC_(48.6922149658203125), SC_(0.905801355838775634765625), SC_(0.9991248063293492785933708184233767348893339395398930175903417086806112215948366275762199334027639371), SC_(0.9987224602975359332859923347928164872014884624802128237949604429447291196699306258618932894158872125) }}, 
      {{ SC_(45461.75390625), SC_(459125.75), SC_(0.3082362115383148193359375), SC_(0.08989458139120597839683023048632079373780396765952994009542514996854861307492824150961806316647838022), SC_(0.09029834386779288090531961455989067736663196426767485870342215288186465421464924224123031571438405692) }}, 
      {{ SC_(45960.19921875), SC_(49.68207550048828125), SC_(0.913384497165679931640625), SC_(0.999121937554656805636527814473741386782287428787098621811627439650242635182527640240724333063873542), SC_(0.9987060853522577404596073508041032205431563655215373651594863967642516234374113889536631930200538368) }}, 
      {{ SC_(46422.796875), SC_(0.11781878769397735595703125), SC_(0.221111953258514404296875), SC_(0.9999982956833203304840924282175120424820605691880549531900871903222870257007699072012733817276916664), SC_(0.9999999999637122181041605680955512196247306257720159528388513871282546704937536781125663486095384214) }}, 
      {{ SC_(46983.234375), SC_(0.0014450610615313053131103515625), SC_(0.9688708782196044921875), SC_(1.0), SC_(0.9999999999999962525859605759102696514598545349352056782601216774079366820687946048849498857773076407) }}, 
      {{ SC_(47575.9296875), SC_(42.76256561279296875), SC_(0.221111953258514404296875), SC_(0.9989997920737591117315027214161125377003795850923233700914261890473041903165757239121699167151556175), SC_(0.999209876209891269419875501024512522062474996647412062240961226503994747053431584761949420357387767) }}, 
      {{ SC_(47586.44140625), SC_(449.601318359375), SC_(0.8350250720977783203125), SC_(0.991068540041441912097262247591298646634689622084322381265146267389262593636758372881584236495471144), SC_(0.9902128202322935003322179801024200539383721353949509588886218581332892691173675520852273971036626807) }}, 
      {{ SC_(47823.16796875), SC_(2585.581787109375), SC_(0.12707412242889404296875), SC_(0.9475855628064392308934119764081037663591417461625585179579692703761765940705446356537552931307785296), SC_(0.9498262296736527690283460228379157366290195261516900092008511677486094003215677920871759451459137479) }}, 
      {{ SC_(48035.7734375), SC_(0.4999766315449960529804229736328125e-4), SC_(0.8350250720977783203125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(48295.36328125), SC_(0.0023451945744454860687255859375), SC_(0.905801355838775634765625), SC_(1.0), SC_(0.9999999999999999999999944416540095785386133815836493833656190673175263062887727480278753123414027923) }}, 
      {{ SC_(48850.35546875), SC_(289555.46875), SC_(0.1355634629726409912109375), SC_(0.1436896602847792941829793219057274879174071260178716669252619997183682682963989706474354539870217676), SC_(0.1450193512591912767897945693872238861494143682347314275664079502951039611517704799792843742072492975) }}, 
      {{ SC_(49373.98046875), SC_(222.311065673828125), SC_(0.9688708782196044921875), SC_(0.996060100287803512550025100602986984317677232975832977153593945112190919810925374514175605667002065), SC_(0.9949420970976593386246675058260955550159345219304692751487920548769516958051751691461275916246921115) }}, 
      {{ SC_(49444.171875), SC_(4.673758029937744140625), SC_(0.81474220752716064453125), SC_(0.9999444692764372013756984706482328527285193393332804072651601107578118687562333519089665319977683821), SC_(0.9998690712429253254117083874667180999168901118078400631630076404524782005711290014515598781762582683) }}, 
      {{ SC_(49532.08984375), SC_(1899.7972412109375), SC_(0.221111953258514404296875), SC_(0.9624253022541134058331176643162512543643243176329651913613205466349437767586494749570107038007615207), SC_(0.9637033723130234784137320920928810064845654436611429071135587491711974167034758015677786783859126881) }}, 
      {{ SC_(49565.796875), SC_(27.7097911834716796875), SC_(0.12707412242889404296875), SC_(0.9993189296731291684182562248170714280486957502164574679389321395638789426972619162270269691657272291), SC_(0.9995595572386466784169117416190848013525366911642870650317096099709918477445175748965708102494166035) }}, 
      {{ SC_(49846.2421875), SC_(49663.23828125), SC_(0.9688708782196044921875), SC_(0.5038747058288205703458594633484809176322109967367170741796168947119807997792607082703018158039617706), SC_(0.4979643236735360395311069653797719393864927621217732396557141676295241565044114535503680047634411135) }}, 
      {{ SC_(49880.1328125), SC_(0.00046944446512497961521148681640625), SC_(0.221111953258514404296875), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(103920.8984375), SC_(0.111212420961237512528896331787109375e-4), SC_(0.221111953258514404296875), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(112769.0546875), SC_(421.523895263671875), SC_(0.905801355838775634765625), SC_(0.9965119017224594587353904055012860767240172885312736672582611278114879050633926663306760384838564335), SC_(0.9960357918240363601926777691159593470030344325056596962986442199671140384351208137512846453388556495) }}, 
      {{ SC_(116919.109375), SC_(234197.234375), SC_(0.8350250720977783203125), SC_(0.3337673241201914076766997314324820311834837998500225056897011916030350119635803230258061191974462806), SC_(0.3322176451850992380517468959022803801344084458626855477357519041564833136937998064149550567528599943) }}, 
      {{ SC_(117063.9375), SC_(0.4761638047057203948497772216796875e-4), SC_(0.8350250720977783203125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(117666.234375), SC_(0.003791221417486667633056640625), SC_(0.905801355838775634765625), SC_(1.0), SC_(0.9999999999999999777810078112355696655567034275388998958567750717497210046730218393487472432509683544) }}, 
      {{ SC_(119021.8671875), SC_(1724.5032958984375), SC_(0.8350250720977783203125), SC_(0.9860507265241485852809692677018381911505954860044114875092190090857418249631115054257361077122488509), SC_(0.9853854862386588175737032132804640836485107443013620580685687055323309032494098568700781187948818355) }}, 
      {{ SC_(121846.6484375), SC_(0.0102547816932201385498046875), SC_(0.9688708782196044921875), SC_(1.0), SC_(0.9999997816119974167581833329480964092693981528223395845190277350758167334728350151633515575899370106) }}, 
      {{ SC_(139635.859375), SC_(0.00359443644993007183074951171875), SC_(0.8350250720977783203125), SC_(1.0), SC_(0.9999999999999999999999999993365552345303433124959756352767325170545841418837879792392616177557525898) }}, 
      {{ SC_(139638.109375), SC_(0.00364904291927814483642578125), SC_(0.221111953258514404296875), SC_(0.9999999999999999999999999999999999926725534639887379885563532897092524752802152226014757335573964422), SC_(1.0) }}, 
      {{ SC_(140613.5625), SC_(0.04485572874546051025390625), SC_(0.905801355838775634765625), SC_(0.9999999999999999999999999999444559076204964799966644029997969834255970193944787878453335474819915623), SC_(0.9999995135204576606875885903417716354557560027487976268723959958197330759335253437122989830896741002) }}, 
      {{ SC_(143155.5625), SC_(0.00386732374317944049835205078125), SC_(0.12707412242889404296875), SC_(0.9999999999999999999978471674518793480825912471601106900793896195328068282272583089748520058127113945), SC_(1.0) }}, 
      {{ SC_(149909.609375), SC_(2.0033237934112548828125), SC_(0.632396042346954345703125), SC_(0.9999914137992328346821946496484917052823804457572554313151069612836902006288195971760236074462225983), SC_(0.9999856512924273917829175939544787544475060864292357858966719298716026234493217442093234683938808734) }}, 
      {{ SC_(155018.640625), SC_(0.27750885486602783203125), SC_(0.8350250720977783203125), SC_(0.999999993284749007784061165791983168463034029960619556018971595921617074325697424809685825074407882), SC_(0.9999966353737324607550401905699725040966863838162795984086051055309327405526441079231402131724087528) }}, 
      {{ SC_(155105.15625), SC_(27467.107421875), SC_(0.632396042346954345703125), SC_(0.8498389779165838399008439544458281639462850303258200593465321416415839180705835244180000245242776803), SC_(0.8492730286025777160870736617840227581802517362868892184640121550395037673944593018907779719286405155) }}, 
      {{ SC_(155440.6875), SC_(25353.65625), SC_(0.8350250720977783203125), SC_(0.8605608508272453326919162281803009458964435926629729642075043488410977588698636990055939506068745736), SC_(0.8589697106307119694948068903015924955978051443872555211349185487657041009532372813684201181856156157) }}, 
      {{ SC_(170849.5), SC_(0.00046143750660121440887451171875), SC_(0.8350250720977783203125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(171593.0), SC_(0.0390150845050811767578125), SC_(0.1355634629726409912109375), SC_(0.9999999182016170028240816694051743438151083807234463589353814909657842971204349332542837795398521521), SC_(0.9999999999999999999999999998075361964567606002504374045539705257620976592510057404191607415798915556) }}, 
      {{ SC_(172891.0), SC_(0.00412352383136749267578125), SC_(0.1355634629726409912109375), SC_(0.9999999999999999999985205512390218686672347331794721272946689059236635790595486234467824836403033921), SC_(1.0) }}, 
      {{ SC_(175682.734375), SC_(342375.09375), SC_(0.913384497165679931640625), SC_(0.340013936624143128319895411531998761580827778695574140363458760728414027388872466998401452636589358), SC_(0.3382224165947537986221531432052803196173801492237972008105082692829726202721619261235531463577436817) }}, 
      {{ SC_(177298.140625), SC_(0.00180856394581496715545654296875), SC_(0.632396042346954345703125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(184058.265625), SC_(0.0481239259243011474609375), SC_(0.3082362115383148193359375), SC_(0.999999998501517340243485593446017630273734258672829936958893520517353286866834220978927598070568492), SC_(0.9999999999999999240851006172778819033999127458719995011554737113105041659572358055390757693407381361) }}, 
      {{ SC_(189710.828125), SC_(0.0004468346596695482730865478515625), SC_(0.12707412242889404296875), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(192153.234375), SC_(4460.083984375), SC_(0.1355634629726409912109375), SC_(0.9769455901820997348887345253995695634315020528634661195458979946325701045306222537295506366491513153), SC_(0.977684633471454951983963188227637546510955719546415582110936101356641468061045330575747986530851934) }}, 
      {{ SC_(194577.984375), SC_(0.00036247042589820921421051025390625), SC_(0.81474220752716064453125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(196362.0), SC_(2509.231201171875), SC_(0.9688708782196044921875), SC_(0.9878452201746761743119076764636648709456201117103593672290496802483505008846898883385158868382497144), SC_(0.9869119557978296851475581119212898738357153986845979687042773361906845558079139190267938505956241518) }}, 
      {{ SC_(207621.90625), SC_(0.00042250819387845695018768310546875), SC_(0.1355634629726409912109375), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(212600.609375), SC_(3789.47216796875), SC_(0.12707412242889404296875), SC_(0.9821657909987468226785395863718408026609070451565141974272191028237381019176307784294718437570252797), SC_(0.9828088626022653884585911511818784576158744016105863662966508613099335997827668867848072139364768017) }}, 
      {{ SC_(212603.09375), SC_(20133.15625), SC_(0.221111953258514404296875), SC_(0.9130463974253991664774997349599327264165252882457909747242186532969835771927123908138456111976741852), SC_(0.913941934917976692974805125302548647312473409103874024240118162284227114270874117238543980497192635) }}, 
      {{ SC_(224776.03125), SC_(0.0415735431015491485595703125), SC_(0.12707412242889404296875), SC_(0.9999998995913399708856361813541390020619941800643644832192671882180852331755265265071082435560145536), SC_(0.9999999999999999999999999992733385493359408068152297661110045529020148351227806357439643861335921027) }}, 
      {{ SC_(228984.171875), SC_(46.157588958740234375), SC_(0.1355634629726409912109375), SC_(0.9997656304760950420416253802765211325948088414661384295157980938690116712314717402720256608597245666), SC_(0.9998306850793302994970813221924868257991851892171206046458118909006813485791755529306435751135685643) }}, 
      {{ SC_(231101.984375), SC_(155.261932373046875), SC_(0.3082362115383148193359375), SC_(0.9993027508076373421649453717093829893822054380130710149391831442233904939026162299839185040244491965), SC_(0.9993566411270408849422721364805008843713173524271877967076418351987228629610004411328150327316160072) }}, 
      {{ SC_(232169.4375), SC_(16.358287811279296875), SC_(0.81474220752716064453125), SC_(0.9999452622842397308842685753075899874480665950296524222820949462159277531291076657075033487575630072), SC_(0.9999143938643164734976139388620664182623111458572315902955918988662200085311644729084861518120847062) }}, 
      {{ SC_(235582.25), SC_(0.011084310710430145263671875), SC_(0.221111953258514404296875), SC_(0.9999999999999996107287073970621023909857554307873106358297121294251281498439342238220263907913423253), SC_(0.9999999999999999999999999999999999999999999999999999999999999999820693111308978763979694057064188765) }}, 
      {{ SC_(237315.15625), SC_(3.7124271392822265625), SC_(0.221111953258514404296875), SC_(0.9999789787267057557766914863819224387810232796496451854719352094722226220083881249875550763904392129), SC_(0.9999908524584306595382023347251859817291538519449250126093167551316022228697205653670043680473604581) }}, 
      {{ SC_(239513.921875), SC_(3236.540771484375), SC_(0.905801355838775634765625), SC_(0.9869724192881483164478744121105871165809521230136957948904152497407930030324079501946282460566332266), SC_(0.9863600504839974472081232225842362448757397669415898902701881305282862113836377583359721352729806264) }}, 
      {{ SC_(241256.71875), SC_(417787.0625), SC_(0.3082362115383148193359375), SC_(0.3657735440169616223240082140700858928286006610555350132758107704156143829189997677472060259320340028), SC_(0.3663679577337345984159655532071779161495068663145800178112243526529500679582032200941754481623143888) }}, 
      {{ SC_(242747.59375), SC_(307.633697509765625), SC_(0.913384497165679931640625), SC_(0.9988313062957533436629121919595039150735167510393667119061821612163184548160046050249344420767727482), SC_(0.9986349661144502879179450463301878277619553005078880262922536278571834139764410204284551391908608044) }}, 
      {{ SC_(244254.640625), SC_(17.7450542449951171875), SC_(0.905801355838775634765625), SC_(0.9999488559903647260822024603409214571534042530795749453223844339905093520000315114802403234313804953), SC_(0.9999038656165488302247866568649218503689202342955798456802206969405091711536692413285634303572226707) }}, 
      {{ SC_(246462.734375), SC_(43952.4453125), SC_(0.913384497165679931640625), SC_(0.8495615234988768587314974808379017809833639684408943041122961712267152787999608825530584148354502445), SC_(0.8477501388013102534832821057561799902463247841737113576394040469509251577841751733140391127470593812) }}, 
      {{ SC_(251274.4375), SC_(0.1303907993133179843425750732421875e-4), SC_(0.905801355838775634765625), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(256001.953125), SC_(0.3102722465991973876953125), SC_(0.905801355838775634765625), SC_(0.9999999986464354469100179028407483998325247675518109088009821215587631250444329710663753381941355475), SC_(0.9999962821163775111325631047242798699750500491603840915344880346168446856205572406527696829445868429) }}, 
      {{ SC_(256341.890625), SC_(0.045557327568531036376953125), SC_(0.913384497165679931640625), SC_(0.9999999999999999999999999999891292986980736393139988565434066533712068748581544688377985546852021828), SC_(0.9999996627510044198684252628207635802553835109279966703832369079462765923451069354668098771565646159) }}, 
      {{ SC_(259312.890625), SC_(4.09720611572265625), SC_(0.913384497165679931640625), SC_(0.9999933728327253819523736175855690436181603157601328865700587729902475643940668078696008473024396546), SC_(0.9999728493464064212546482602190478683755759499841234874581272818010475319666596735498989832788227078) }}, 
      {{ SC_(265560.28125), SC_(14.26784992218017578125), SC_(0.9688708782196044921875), SC_(0.9999695203151324801496889168698657840440823752450849636861085206814999723814629485272589372081787985), SC_(0.9999168453220045076703919866166687121990298424772966112371633665480225561878708598211707128092579087) }}, 
      {{ SC_(272688.46875), SC_(0.4279204308986663818359375), SC_(0.1355634629726409912109375), SC_(0.9999964490603117015277408911098898863242691396685434407404464843381585134408347117268344326708348559), SC_(0.9999999739577675403000030481279829247411707308448783459832418910491440761913519031172451006697835748) }}, 
      {{ SC_(279777.4375), SC_(110919.8125), SC_(0.632396042346954345703125), SC_(0.716342084516146773465565278863366032291361419987414019745211704773374969730032526936615582956139819), SC_(0.715854149711822101723646474977987731719100676984964565981257186067687086607452051273790812391420848) }}, 
      {{ SC_(280536.21875), SC_(1998.197021484375), SC_(0.913384497165679931640625), SC_(0.9931412974388037743560987947193559393525692315425893757085509254546053897290018110626117904868654813), SC_(0.9927119098452319617332869467686668658411022821497333019178203639293120603370703313322169211268108039) }}, 
      {{ SC_(290996.875), SC_(0.00046665043919347226619720458984375), SC_(0.3082362115383148193359375), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(294260.65625), SC_(0.393247187137603759765625), SC_(0.632396042346954345703125), SC_(0.9999997943449249955171938080905318288945050229620336163350673164421335892120652904146355762536189054), SC_(0.9999990515179070051184990966509393368455909297401987792097603947834106333630608018075236097300339701) }}, 
      {{ SC_(295837.75), SC_(414044.375), SC_(0.1355634629726409912109375), SC_(0.4160981457882858761512789972345990613612548998350061709883163850335988514645095637327134776879902863), SC_(0.4173860378392507197480139851689912868715414340645543869066327228694663375695492894693529290056351595) }}, 
      {{ SC_(295905.53125), SC_(0.0040032281540334224700927734375), SC_(0.3082362115383148193359375), SC_(0.9999999999999999999999999999999999999999999997998694799618628992869833672518405022823542668460381155), SC_(1.0) }}, 
      {{ SC_(296938.03125), SC_(220.9876708984375), SC_(0.12707412242889404296875), SC_(0.9991990113494480392179599700921853876238508570671618729024789001119929066186937154552802822703393878), SC_(0.9993129796215183216851691971028047934663527607383889624349329968629574647063342294846239703511433874) }}, 
      {{ SC_(300513.1875), SC_(0.37814271450042724609375), SC_(0.12707412242889404296875), SC_(0.9999969782050486769652136994182234485275829861644683583528927638148961341072493652861727078400340733), SC_(0.9999999895708495631574122655332682099829657430546711826259770208138190516103170397971109828049670558) }}, 
      {{ SC_(301512.3125), SC_(290772.15625), SC_(0.12707412242889404296875), SC_(0.5083259803742953085834127737217466902961187303754053062285802798488588125564488677103330951557012566), SC_(0.5098074558133211331819844504160880659968413691948379043781371606651571268126192357505538982067718515) }}, 
      {{ SC_(304061.0), SC_(0.015454678796231746673583984375), SC_(0.632396042346954345703125), SC_(0.9999999999999999999999999999999998588694073477108553987691148771575638522343970357448059014294547744), SC_(0.9999999999999999997518149599484678853861351970711480872190904043129582228626516270210032821150771143) }}, 
      {{ SC_(319723.40625), SC_(20.909183502197265625), SC_(0.632396042346954345703125), SC_(0.9999403190148524254379175206332931464568382187753583327271647261012396055662443510864446020246204106), SC_(0.9999307346650039643327092376540097242418342939548879360522811481721099641992421239211049628683949737) }}, 
      {{ SC_(320904.625), SC_(29.05339813232421875), SC_(0.221111953258514404296875), SC_(0.9998970697135290506106910317791569394420207485233153261768791709260527712812091966124554337341856922), SC_(0.9999227224043228154788932822721198527773973544680362689282215618990551014847660383597982064957627464) }}, 
      {{ SC_(322918.0625), SC_(0.00355008454062044620513916015625), SC_(0.913384497165679931640625), SC_(1.0), SC_(0.9999999999999999856029413730739658471968005363827010980266428532258411056823404064838535263144910335) }}, 
      {{ SC_(335283.75), SC_(21810.169921875), SC_(0.905801355838775634765625), SC_(0.9394496604431915054633823576643046372095015323082582291941274835953390365048842329396443282771327712), SC_(0.9383954534267339227937623599325170174723074700810661239028890744439637253418172617679988893235546671) }}, 
      {{ SC_(336243.46875), SC_(3128.056640625), SC_(0.632396042346954345703125), SC_(0.9908391258666329629575919260109096960776639987853278744200427115196247914490708644556950279608143322), SC_(0.9907281734000043994848829737411187816279140724177573954765961998473267555607767196804424190227689015) }}, 
      {{ SC_(347334.96875), SC_(4.06880474090576171875), SC_(0.1355634629726409912109375), SC_(0.9999819430001573210462266999645956158338753994331140631758118031222196089862793225439977383551853686), SC_(0.9999942182040833300599726446437265377188626217466152537681121397141772637474456654852569680911946187) }}, 
      {{ SC_(347788.625), SC_(37.86353302001953125), SC_(0.8350250720977783203125), SC_(0.9999083478012565433833809011745674628916746285081235370835760820113851611151622512323345259860401079), SC_(0.999874033425078797325574848417487602053549452769969921327235413212187855653939340754471112166411762) }}, 
      {{ SC_(349486.5625), SC_(0.0004298138082958757877349853515625), SC_(0.632396042346954345703125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(349829.1875), SC_(4556.69775390625), SC_(0.3082362115383148193359375), SC_(0.9870478912232100615407377518631041552521442157832159313239559510707949083985358116216378938821573168), SC_(0.987237458988263763824796001314439127833337805579138708121609401353551685489902810913204121753537649) }}, 
      {{ SC_(351569.59375), SC_(0.0152290202677249908447265625), SC_(0.8350250720977783203125), SC_(0.999999999999999999999999999999999999999999999999999999999337544568970008123871671335163903652543046), SC_(0.9999999999883271225037517008304526269270726376997179714491716399065912306255750135455436453416100986) }}, 
      {{ SC_(358590.96875), SC_(1.7338650226593017578125), SC_(0.8350250720977783203125), SC_(0.9999984263877108713328668060789151034168311888715896859320436867070281866451651074342505357980219349), SC_(0.9999919699128261352873137396136389773581712720757800125687385035676124891929768684608290888359673284) }}, 
      {{ SC_(364175.1875), SC_(2293.671875), SC_(0.81474220752716064453125), SC_(0.9938579874881970190241475981159980550693665900318741942458026198431159582210345561229830938645892546), SC_(0.9936246778145682588482032193112985156800909163568667937129102186549294511840416794388579946743714535) }}, 
      {{ SC_(365061.53125), SC_(135.407379150390625), SC_(0.9688708782196044921875), SC_(0.9996863176794632586706422604218158190159974256313279236968321237643660859561633874105624478272628204), SC_(0.9995676095027363370130978096808221600255355631598741377718600093954269785487207871592101820797243698) }}, 
      {{ SC_(366848.125), SC_(489622.875), SC_(0.9688708782196044921875), SC_(0.4293222628169663745558171295278155001926392610415034796095972460996581776097861096673087920357679668), SC_(0.4273284429743166615133863824717356268949243188239141619747315979964200770053566481771477282066549481) }}, 
      {{ SC_(369212.46875), SC_(0.00043601836659945547580718994140625), SC_(0.221111953258514404296875), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(377515.0625), SC_(0.25923203793354332447052001953125e-4), SC_(0.1355634629726409912109375), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(377897.28125), SC_(217.7733001708984375), SC_(0.1355634629726409912109375), SC_(0.9993809642265976154383717381207419114470415044406894651878153345176886420431903229202206000880886718), SC_(0.9994667749451229173897338105032212922523517596117925674539780226161151167199171208323521362627770887) }}, 
      {{ SC_(381735.84375), SC_(0.1554123082314617931842803955078125e-4), SC_(0.913384497165679931640625), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(384451.40625), SC_(2821.419677734375), SC_(0.221111953258514404296875), SC_(0.9926099871896123078684723066386032849974032581108770521411434971450896544796730143746189803506470856), SC_(0.9928199991963109071287575105571708040566262619163273683406366985829681958538001670553781136101988687) }}, 
      {{ SC_(385429.59375), SC_(3.3841388225555419921875), SC_(0.12707412242889404296875), SC_(0.9999857710862316626308886200674055735068361048994887325460030286049763167563594270764165414228363672), SC_(0.9999961463101950077215211361299610147215227526502164437034753993067657292616156855343024049275342271) }}, 
      {{ SC_(386018.0), SC_(14093.7041015625), SC_(0.12707412242889404296875), SC_(0.9644430127269426619183736034929423778475169305652455107070839929930622993276460689304581805792536094), SC_(0.9651076751275607043680541800650118221087969621585617130912614877060171578558867462369261333543364891) }}, 
      {{ SC_(391805.21875), SC_(0.3055977504118345677852630615234375e-4), SC_(0.9688708782196044921875), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(392234.125), SC_(2.3254187107086181640625), SC_(0.81474220752716064453125), SC_(0.9999974485003056966903937402928194859244134156329839210891209266939469887376578411857915820268130878), SC_(0.9999910059274056877196675524405017475977672250931933758535228907148186849815921846049106923261807746) }}, 
      {{ SC_(392420.34375), SC_(26721.41796875), SC_(0.3082362115383148193359375), SC_(0.9360588166131809414115448707596221147145947161943021966694623902354292754826644227343641185174034654), SC_(0.9364368278909332485238823067765771268369372557921270083256148767582934322381215597399727535283351517) }}, 
      {{ SC_(395628.875), SC_(169.021026611328125), SC_(0.81474220752716064453125), SC_(0.9996025064181200881100206422611691098034252814466028469788567254658356713206042929145292670546196381), SC_(0.99954374915820356500667666460563470033117280258708880946045071662016129765225947981489908197799767) }}, 
      {{ SC_(399928.875), SC_(2.3772995471954345703125), SC_(0.9688708782196044921875), SC_(0.999998973529290397777010867861541796446553860070978813445077322099914527527265485681176970566917336), SC_(0.9999851449804766483443475395998114534937065656196947448822622679434789040810220786478170917758051126) }}, 
      {{ SC_(402603.8125), SC_(15.56592464447021484375), SC_(0.913384497165679931640625), SC_(0.9999738551272416142186841753240307283354384922856722576418772212695756736954226385611368514921848777), SC_(0.9999474093547476264441382684753736909215910603608318473764367722720243147519806449667204560121132854) }}, 
      {{ SC_(406768.65625), SC_(0.00042969666537828743457794189453125), SC_(0.913384497165679931640625), SC_(1.0), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999626) }}, 
      {{ SC_(408381.65625), SC_(0.456345951533876359462738037109375e-4), SC_(0.81474220752716064453125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(408998.0), SC_(0.0042365207336843013763427734375), SC_(0.9688708782196044921875), SC_(1.0), SC_(0.9999999992103886391729073177905457547792850375379996834483515277700339789073753215708472808258258179) }}, 
      {{ SC_(413148.84375), SC_(0.4799632370122708380222320556640625e-4), SC_(0.12707412242889404296875), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(422703.84375), SC_(15069.125), SC_(0.9688708782196044921875), SC_(0.9660897392982058868656227001682921112419545706033093751961665865899461039486514250827102903147922631), SC_(0.965062274905023631733677391034079251654464055944302576321996680797937852368094477775017032828016675) }}, 
      {{ SC_(424641.03125), SC_(0.2840512692928314208984375), SC_(0.3082362115383148193359375), SC_(0.9999994750636549669670606473061109603761635212061967274985478848332176734538791017721257779548027605), SC_(0.9999999739814327156712234926962831943788993494932233013963790111365912453400671308543415084742014015) }}, 
      {{ SC_(431857.34375), SC_(0.000211423015571199357509613037109375), SC_(0.905801355838775634765625), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(433260.8125), SC_(3.3808853626251220703125), SC_(0.905801355838775634765625), SC_(0.9999969819317488587881461792850888475768718203652823126667535332673193874620970162529189308649544396), SC_(0.9999862985752257128652103590400974817457299983496624630313157549699524585549896935023931532699212086) }}, 
      {{ SC_(434088.21875), SC_(21.81499481201171875), SC_(0.12707412242889404296875), SC_(0.9999373373312823166558666370134409611695804442709662922918704832772088187585446175690336698789214258), SC_(0.9999616965351012448240568108749462155945157055968478012559160622065331568396155867317792166746127338) }}, 
      {{ SC_(434689.125), SC_(39291.4765625), SC_(0.81474220752716064453125), SC_(0.917461959010412182685915555568393955513643969597894372657100531180768279837135956151775654776489289), SC_(0.9167446673468778375962374922169420664609807836207411106316537831936914893386205048529899697184531553) }}, 
      {{ SC_(435121.25), SC_(397.58978271484375), SC_(0.632396042346954345703125), SC_(0.9991032356687607663170758081994663804545219752851748934242218706100390785290407790519388112949974116), SC_(0.9990722960117656720982176725927203880876672401511674631927254651106841735347495126259465844742175537) }}, 
      {{ SC_(437285.3125), SC_(0.2788266647257842123508453369140625e-4), SC_(0.3082362115383148193359375), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(442472.9375), SC_(49476.66015625), SC_(0.1355634629726409912109375), SC_(0.8989553759462725154195912825680002145390824453023265617169936644862701649915658110052894084041830153), SC_(0.8998991547281331197912897937898208409760268200326740982917502926455633491439458667387132339684255894) }}, 
      {{ SC_(450819.5), SC_(499216.46875), SC_(0.221111953258514404296875), SC_(0.4741351844340727004467290920964798805530388223292311537088183157505857155369303090852906203317270319), SC_(0.4749225520632804503831707896293591563564510578733056247136808234148925259976983491440388496735532279) }}, 
      {{ SC_(457779.125), SC_(0.326781928539276123046875), SC_(0.81474220752716064453125), SC_(0.9999999910727029325617530685760277558694771909650151522235239619750731721035596554760606019094289709), SC_(0.9999987858178995610219544528459401488999341746160983444951291984610165296616383478160281021221648139) }}, 
      {{ SC_(458356.625), SC_(0.00327513157390058040618896484375), SC_(0.81474220752716064453125), SC_(1.0), SC_(0.9999999999999999999999999999999991663668185381070411966512131706847600000660648405081952061008667392) }}, 
      {{ SC_(462545.71875), SC_(0.01835658587515354156494140625), SC_(0.81474220752716064453125), SC_(0.9999999999999999999999999999999999999999999998408559003203816496751827616995900078085841802845788018), SC_(0.9999999999824865494095113121276887961620751733866931423886562603084660496027804389884068533626778463) }}, 
      {{ SC_(466997.53125), SC_(0.356361567974090576171875), SC_(0.9688708782196044921875), SC_(0.999999999908585136073218599560639574585679002817051921225365716235382799011868956412143385957374377), SC_(0.9999959050920261602210872695621046203124487413396593115588810222179555364832748299668392611148334214) }}, 
      {{ SC_(468932.8125), SC_(0.182366857188753783702850341796875e-4), SC_(0.632396042346954345703125), SC_(1.0), SC_(1.0) }}, 
      {{ SC_(470942.5), SC_(0.326362073421478271484375), SC_(0.913384497165679931640625), SC_(0.9999999991634295790864615713201865731290532042979576143167684474434066293110330308591586719592525982), SC_(0.9999977662722746820150898269173378866588151731047916028888067446958373170001483823516884123613851415) }}, 
      {{ SC_(473791.3125), SC_(0.00037331905332393944263458251953125), SC_(0.9688708782196044921875), SC_(1.0), SC_(0.9999999999999999999999999999999999999999998073822602388688624653696078183429191536061547769537964575) }}, 
      {{ SC_(474410.90625), SC_(1.53685867786407470703125), SC_(0.3082362115383148193359375), SC_(0.9999961129062931113810979684551783321474081584789778624951890966223338422649810562505451410537303544), SC_(0.999998403265561481452323439582435790606202798849405347541950528356589895392491922180143509579003441) }}, 
      {{ SC_(481669.8125), SC_(360.35894775390625), SC_(0.8350250720977783203125), SC_(0.9992907831812886773473659863167020097660580060484200865493826163108597351525902267283025051442100653), SC_(0.999214115270590007552130187756931575538839868062918740780889455554092188930046874164289191809734251) }}, 
      {{ SC_(485412.125), SC_(483725.21875), SC_(0.81474220752716064453125), SC_(0.5013251403632957657097180440139352644280668716512067495231709003767868348011456320309173169758632819), SC_(0.5004154864846086974762398748354340355121671666386661965862493622607256259777758150232988196487155074) }}, 
      {{ SC_(489093.59375), SC_(101.60869598388671875), SC_(0.221111953258514404296875), SC_(0.9997767680266260123110682903130838658146825013373285034001164702953644249742530005306208421454781091), SC_(0.999808377593128038314593193233001644747928940615604047013939298656600726304242669404403355730826352) }}, 
      {{ SC_(489183.34375), SC_(118808.328125), SC_(0.905801355838775634765625), SC_(0.8052575261090612610637084789843685951634273246290044181560593884142556001108220633456497594556682558), SC_(0.8039197640541228765389792372480736779551687141239257074087097158639306091733737153424379109689825148) }}, 
      {{ SC_(491651.625), SC_(32.955524444580078125), SC_(0.3082362115383148193359375), SC_(0.9999276667129839450708195109501969031021375557304337628863198830422811974212658774808113659981096958), SC_(0.9999392952515020529866132904758764722582237171318891514012201689689695587113485590174396303118997795) }}, 
      {{ SC_(499024.09375), SC_(0.3617647588253021240234375), SC_(0.221111953258514404296875), SC_(0.9999989677510921954271873521993859181834023852192245015532772531114512443689750755333329075681050925), SC_(0.9999999774076213040954883510429323955048191846373634062085510975273422302416340711527143505910773273) }}
   } };
