An undefined atomic operation function was declared.

Erroneous code example:

```compile_fail,E0092
#![feature(intrinsics)]
#![allow(internal_features)]

#[rustc_intrinsic]
unsafe fn atomic_foo(); // error: unrecognized atomic operation
                        //        function
```

Please check you didn't make a mistake in the function's name. All intrinsic
functions are defined in `compiler/rustc_codegen_llvm/src/intrinsic.rs` and in
`library/core/src/intrinsics.rs` in the Rust source code. Example:

```
#![feature(intrinsics)]
#![allow(internal_features)]

#[rustc_intrinsic]
unsafe fn atomic_fence_seqcst(); // ok!
```
