/* shotwell-graphics-processor.h generated by valac 0.40.4, the Vala compiler, do not modify */


#ifndef __SRC_SHOTWELL_GRAPHICS_PROCESSOR_H__
#define __SRC_SHOTWELL_GRAPHICS_PROCESSOR_H__

#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gio/gio.h>
#include <gdk/gdk.h>

G_BEGIN_DECLS


#define TYPE_RGB_ANALYTIC_PIXEL (rgb_analytic_pixel_get_type ())
typedef struct _RGBAnalyticPixel RGBAnalyticPixel;

#define TYPE_HSV_ANALYTIC_PIXEL (hsv_analytic_pixel_get_type ())
typedef struct _HSVAnalyticPixel HSVAnalyticPixel;

#define TYPE_COMPOSITION_MODE (composition_mode_get_type ())

#define TYPE_PIXEL_FORMAT (pixel_format_get_type ())

#define TYPE_PIXEL_TRANSFORMATION_TYPE (pixel_transformation_type_get_type ())

#define TYPE_PIXEL_TRANSFORMATION_BUNDLE (pixel_transformation_bundle_get_type ())
#define PIXEL_TRANSFORMATION_BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIXEL_TRANSFORMATION_BUNDLE, PixelTransformationBundle))
#define PIXEL_TRANSFORMATION_BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIXEL_TRANSFORMATION_BUNDLE, PixelTransformationBundleClass))
#define IS_PIXEL_TRANSFORMATION_BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIXEL_TRANSFORMATION_BUNDLE))
#define IS_PIXEL_TRANSFORMATION_BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIXEL_TRANSFORMATION_BUNDLE))
#define PIXEL_TRANSFORMATION_BUNDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIXEL_TRANSFORMATION_BUNDLE, PixelTransformationBundleClass))

typedef struct _PixelTransformationBundle PixelTransformationBundle;
typedef struct _PixelTransformationBundleClass PixelTransformationBundleClass;
typedef struct _PixelTransformationBundlePrivate PixelTransformationBundlePrivate;

#define TYPE_PIXEL_TRANSFORMATION (pixel_transformation_get_type ())
#define PIXEL_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIXEL_TRANSFORMATION, PixelTransformation))
#define PIXEL_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIXEL_TRANSFORMATION, PixelTransformationClass))
#define IS_PIXEL_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIXEL_TRANSFORMATION))
#define IS_PIXEL_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIXEL_TRANSFORMATION))
#define PIXEL_TRANSFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIXEL_TRANSFORMATION, PixelTransformationClass))

typedef struct _PixelTransformation PixelTransformation;
typedef struct _PixelTransformationClass PixelTransformationClass;

#define TYPE_KEY_VALUE_MAP (key_value_map_get_type ())
#define KEY_VALUE_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KEY_VALUE_MAP, KeyValueMap))
#define KEY_VALUE_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KEY_VALUE_MAP, KeyValueMapClass))
#define IS_KEY_VALUE_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KEY_VALUE_MAP))
#define IS_KEY_VALUE_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KEY_VALUE_MAP))
#define KEY_VALUE_MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KEY_VALUE_MAP, KeyValueMapClass))

typedef struct _KeyValueMap KeyValueMap;
typedef struct _KeyValueMapClass KeyValueMapClass;

#define TYPE_PIXEL_TRANSFORMER (pixel_transformer_get_type ())
#define PIXEL_TRANSFORMER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIXEL_TRANSFORMER, PixelTransformer))
#define PIXEL_TRANSFORMER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIXEL_TRANSFORMER, PixelTransformerClass))
#define IS_PIXEL_TRANSFORMER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIXEL_TRANSFORMER))
#define IS_PIXEL_TRANSFORMER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIXEL_TRANSFORMER))
#define PIXEL_TRANSFORMER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIXEL_TRANSFORMER, PixelTransformerClass))

typedef struct _PixelTransformer PixelTransformer;
typedef struct _PixelTransformerClass PixelTransformerClass;
typedef struct _PixelTransformationPrivate PixelTransformationPrivate;

#define TYPE_RGB_TRANSFORMATION (rgb_transformation_get_type ())
#define RGB_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RGB_TRANSFORMATION, RGBTransformation))
#define RGB_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RGB_TRANSFORMATION, RGBTransformationClass))
#define IS_RGB_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RGB_TRANSFORMATION))
#define IS_RGB_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RGB_TRANSFORMATION))
#define RGB_TRANSFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RGB_TRANSFORMATION, RGBTransformationClass))

typedef struct _RGBTransformation RGBTransformation;
typedef struct _RGBTransformationClass RGBTransformationClass;
typedef struct _RGBTransformationPrivate RGBTransformationPrivate;

#define TYPE_HSV_TRANSFORMATION (hsv_transformation_get_type ())
#define HSV_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HSV_TRANSFORMATION, HSVTransformation))
#define HSV_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HSV_TRANSFORMATION, HSVTransformationClass))
#define IS_HSV_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HSV_TRANSFORMATION))
#define IS_HSV_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HSV_TRANSFORMATION))
#define HSV_TRANSFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HSV_TRANSFORMATION, HSVTransformationClass))

typedef struct _HSVTransformation HSVTransformation;
typedef struct _HSVTransformationClass HSVTransformationClass;
typedef struct _HSVTransformationPrivate HSVTransformationPrivate;

#define TYPE_TINT_TRANSFORMATION (tint_transformation_get_type ())
#define TINT_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TINT_TRANSFORMATION, TintTransformation))
#define TINT_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TINT_TRANSFORMATION, TintTransformationClass))
#define IS_TINT_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TINT_TRANSFORMATION))
#define IS_TINT_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TINT_TRANSFORMATION))
#define TINT_TRANSFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TINT_TRANSFORMATION, TintTransformationClass))

typedef struct _TintTransformation TintTransformation;
typedef struct _TintTransformationClass TintTransformationClass;
typedef struct _TintTransformationPrivate TintTransformationPrivate;

#define TYPE_TEMPERATURE_TRANSFORMATION (temperature_transformation_get_type ())
#define TEMPERATURE_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEMPERATURE_TRANSFORMATION, TemperatureTransformation))
#define TEMPERATURE_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEMPERATURE_TRANSFORMATION, TemperatureTransformationClass))
#define IS_TEMPERATURE_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEMPERATURE_TRANSFORMATION))
#define IS_TEMPERATURE_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEMPERATURE_TRANSFORMATION))
#define TEMPERATURE_TRANSFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEMPERATURE_TRANSFORMATION, TemperatureTransformationClass))

typedef struct _TemperatureTransformation TemperatureTransformation;
typedef struct _TemperatureTransformationClass TemperatureTransformationClass;
typedef struct _TemperatureTransformationPrivate TemperatureTransformationPrivate;

#define TYPE_SATURATION_TRANSFORMATION (saturation_transformation_get_type ())
#define SATURATION_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SATURATION_TRANSFORMATION, SaturationTransformation))
#define SATURATION_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SATURATION_TRANSFORMATION, SaturationTransformationClass))
#define IS_SATURATION_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SATURATION_TRANSFORMATION))
#define IS_SATURATION_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SATURATION_TRANSFORMATION))
#define SATURATION_TRANSFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SATURATION_TRANSFORMATION, SaturationTransformationClass))

typedef struct _SaturationTransformation SaturationTransformation;
typedef struct _SaturationTransformationClass SaturationTransformationClass;
typedef struct _SaturationTransformationPrivate SaturationTransformationPrivate;

#define TYPE_EXPOSURE_TRANSFORMATION (exposure_transformation_get_type ())
#define EXPOSURE_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPOSURE_TRANSFORMATION, ExposureTransformation))
#define EXPOSURE_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPOSURE_TRANSFORMATION, ExposureTransformationClass))
#define IS_EXPOSURE_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPOSURE_TRANSFORMATION))
#define IS_EXPOSURE_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPOSURE_TRANSFORMATION))
#define EXPOSURE_TRANSFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPOSURE_TRANSFORMATION, ExposureTransformationClass))

typedef struct _ExposureTransformation ExposureTransformation;
typedef struct _ExposureTransformationClass ExposureTransformationClass;
typedef struct _ExposureTransformationPrivate ExposureTransformationPrivate;

#define TYPE_CONTRAST_TRANSFORMATION (contrast_transformation_get_type ())
#define CONTRAST_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTRAST_TRANSFORMATION, ContrastTransformation))
#define CONTRAST_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONTRAST_TRANSFORMATION, ContrastTransformationClass))
#define IS_CONTRAST_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTRAST_TRANSFORMATION))
#define IS_CONTRAST_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONTRAST_TRANSFORMATION))
#define CONTRAST_TRANSFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONTRAST_TRANSFORMATION, ContrastTransformationClass))

typedef struct _ContrastTransformation ContrastTransformation;
typedef struct _ContrastTransformationClass ContrastTransformationClass;
typedef struct _ContrastTransformationPrivate ContrastTransformationPrivate;
typedef struct _PixelTransformerPrivate PixelTransformerPrivate;

#define TYPE_RGB_HISTOGRAM (rgb_histogram_get_type ())
#define RGB_HISTOGRAM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RGB_HISTOGRAM, RGBHistogram))
#define RGB_HISTOGRAM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RGB_HISTOGRAM, RGBHistogramClass))
#define IS_RGB_HISTOGRAM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RGB_HISTOGRAM))
#define IS_RGB_HISTOGRAM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RGB_HISTOGRAM))
#define RGB_HISTOGRAM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RGB_HISTOGRAM, RGBHistogramClass))

typedef struct _RGBHistogram RGBHistogram;
typedef struct _RGBHistogramClass RGBHistogramClass;
typedef struct _RGBHistogramPrivate RGBHistogramPrivate;

#define TYPE_INTENSITY_HISTOGRAM (intensity_histogram_get_type ())
#define INTENSITY_HISTOGRAM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_INTENSITY_HISTOGRAM, IntensityHistogram))
#define INTENSITY_HISTOGRAM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_INTENSITY_HISTOGRAM, IntensityHistogramClass))
#define IS_INTENSITY_HISTOGRAM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_INTENSITY_HISTOGRAM))
#define IS_INTENSITY_HISTOGRAM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_INTENSITY_HISTOGRAM))
#define INTENSITY_HISTOGRAM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_INTENSITY_HISTOGRAM, IntensityHistogramClass))

typedef struct _IntensityHistogram IntensityHistogram;
typedef struct _IntensityHistogramClass IntensityHistogramClass;
typedef struct _IntensityHistogramPrivate IntensityHistogramPrivate;

#define TYPE_EXPANSION_TRANSFORMATION (expansion_transformation_get_type ())
#define EXPANSION_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPANSION_TRANSFORMATION, ExpansionTransformation))
#define EXPANSION_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPANSION_TRANSFORMATION, ExpansionTransformationClass))
#define IS_EXPANSION_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPANSION_TRANSFORMATION))
#define IS_EXPANSION_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPANSION_TRANSFORMATION))
#define EXPANSION_TRANSFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPANSION_TRANSFORMATION, ExpansionTransformationClass))

typedef struct _ExpansionTransformation ExpansionTransformation;
typedef struct _ExpansionTransformationClass ExpansionTransformationClass;
typedef struct _ExpansionTransformationPrivate ExpansionTransformationPrivate;

#define TYPE_SHADOW_DETAIL_TRANSFORMATION (shadow_detail_transformation_get_type ())
#define SHADOW_DETAIL_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SHADOW_DETAIL_TRANSFORMATION, ShadowDetailTransformation))
#define SHADOW_DETAIL_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SHADOW_DETAIL_TRANSFORMATION, ShadowDetailTransformationClass))
#define IS_SHADOW_DETAIL_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SHADOW_DETAIL_TRANSFORMATION))
#define IS_SHADOW_DETAIL_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SHADOW_DETAIL_TRANSFORMATION))
#define SHADOW_DETAIL_TRANSFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SHADOW_DETAIL_TRANSFORMATION, ShadowDetailTransformationClass))

typedef struct _ShadowDetailTransformation ShadowDetailTransformation;
typedef struct _ShadowDetailTransformationClass ShadowDetailTransformationClass;
typedef struct _ShadowDetailTransformationPrivate ShadowDetailTransformationPrivate;

#define TYPE_HERMITE_GAMMA_APPROXIMATION_FUNCTION (hermite_gamma_approximation_function_get_type ())
#define HERMITE_GAMMA_APPROXIMATION_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HERMITE_GAMMA_APPROXIMATION_FUNCTION, HermiteGammaApproximationFunction))
#define HERMITE_GAMMA_APPROXIMATION_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HERMITE_GAMMA_APPROXIMATION_FUNCTION, HermiteGammaApproximationFunctionClass))
#define IS_HERMITE_GAMMA_APPROXIMATION_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HERMITE_GAMMA_APPROXIMATION_FUNCTION))
#define IS_HERMITE_GAMMA_APPROXIMATION_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HERMITE_GAMMA_APPROXIMATION_FUNCTION))
#define HERMITE_GAMMA_APPROXIMATION_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HERMITE_GAMMA_APPROXIMATION_FUNCTION, HermiteGammaApproximationFunctionClass))

typedef struct _HermiteGammaApproximationFunction HermiteGammaApproximationFunction;
typedef struct _HermiteGammaApproximationFunctionClass HermiteGammaApproximationFunctionClass;
typedef struct _HermiteGammaApproximationFunctionPrivate HermiteGammaApproximationFunctionPrivate;

#define TYPE_HIGHLIGHT_DETAIL_TRANSFORMATION (highlight_detail_transformation_get_type ())
#define HIGHLIGHT_DETAIL_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HIGHLIGHT_DETAIL_TRANSFORMATION, HighlightDetailTransformation))
#define HIGHLIGHT_DETAIL_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HIGHLIGHT_DETAIL_TRANSFORMATION, HighlightDetailTransformationClass))
#define IS_HIGHLIGHT_DETAIL_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HIGHLIGHT_DETAIL_TRANSFORMATION))
#define IS_HIGHLIGHT_DETAIL_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HIGHLIGHT_DETAIL_TRANSFORMATION))
#define HIGHLIGHT_DETAIL_TRANSFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HIGHLIGHT_DETAIL_TRANSFORMATION, HighlightDetailTransformationClass))

typedef struct _HighlightDetailTransformation HighlightDetailTransformation;
typedef struct _HighlightDetailTransformationClass HighlightDetailTransformationClass;
typedef struct _HighlightDetailTransformationPrivate HighlightDetailTransformationPrivate;
typedef struct _KeyValueMapPrivate KeyValueMapPrivate;

struct _RGBAnalyticPixel {
	gfloat red;
	gfloat green;
	gfloat blue;
};

struct _HSVAnalyticPixel {
	gfloat hue;
	gfloat saturation;
	gfloat light_value;
};

typedef enum  {
	COMPOSITION_MODE_NONE,
	COMPOSITION_MODE_RGB_MATRIX,
	COMPOSITION_MODE_HSV_LOOKUP
} CompositionMode;

typedef enum  {
	PIXEL_FORMAT_RGB,
	PIXEL_FORMAT_HSV
} PixelFormat;

typedef enum  {
	PIXEL_TRANSFORMATION_TYPE_TONE_EXPANSION,
	PIXEL_TRANSFORMATION_TYPE_SHADOWS,
	PIXEL_TRANSFORMATION_TYPE_HIGHLIGHTS,
	PIXEL_TRANSFORMATION_TYPE_TEMPERATURE,
	PIXEL_TRANSFORMATION_TYPE_TINT,
	PIXEL_TRANSFORMATION_TYPE_SATURATION,
	PIXEL_TRANSFORMATION_TYPE_EXPOSURE,
	PIXEL_TRANSFORMATION_TYPE_CONTRAST
} PixelTransformationType;

struct _PixelTransformationBundle {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PixelTransformationBundlePrivate * priv;
};

struct _PixelTransformationBundleClass {
	GTypeClass parent_class;
	void (*finalize) (PixelTransformationBundle *self);
};

struct _PixelTransformation {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PixelTransformationPrivate * priv;
};

struct _PixelTransformationClass {
	GTypeClass parent_class;
	void (*finalize) (PixelTransformation *self);
	CompositionMode (*get_composition_mode) (PixelTransformation* self);
	void (*compose_with) (PixelTransformation* self, PixelTransformation* other);
	gboolean (*is_identity) (PixelTransformation* self);
	void (*transform_pixel_hsv) (PixelTransformation* self, HSVAnalyticPixel* p, HSVAnalyticPixel* result);
	void (*transform_pixel_rgb) (PixelTransformation* self, RGBAnalyticPixel* p, RGBAnalyticPixel* result);
	gchar* (*to_string) (PixelTransformation* self);
	PixelTransformation* (*copy) (PixelTransformation* self);
};

struct _RGBTransformation {
	PixelTransformation parent_instance;
	RGBTransformationPrivate * priv;
	gfloat* matrix_entries;
	gint matrix_entries_length1;
	gboolean identity;
};

struct _RGBTransformationClass {
	PixelTransformationClass parent_class;
};

struct _HSVTransformation {
	PixelTransformation parent_instance;
	HSVTransformationPrivate * priv;
	gfloat remap_table[256];
};

struct _HSVTransformationClass {
	PixelTransformationClass parent_class;
};

struct _TintTransformation {
	RGBTransformation parent_instance;
	TintTransformationPrivate * priv;
};

struct _TintTransformationClass {
	RGBTransformationClass parent_class;
};

struct _TemperatureTransformation {
	RGBTransformation parent_instance;
	TemperatureTransformationPrivate * priv;
};

struct _TemperatureTransformationClass {
	RGBTransformationClass parent_class;
};

struct _SaturationTransformation {
	RGBTransformation parent_instance;
	SaturationTransformationPrivate * priv;
};

struct _SaturationTransformationClass {
	RGBTransformationClass parent_class;
};

struct _ExposureTransformation {
	RGBTransformation parent_instance;
	ExposureTransformationPrivate * priv;
};

struct _ExposureTransformationClass {
	RGBTransformationClass parent_class;
};

struct _ContrastTransformation {
	RGBTransformation parent_instance;
	ContrastTransformationPrivate * priv;
};

struct _ContrastTransformationClass {
	RGBTransformationClass parent_class;
};

struct _PixelTransformer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PixelTransformerPrivate * priv;
	PixelTransformation** optimized_transformations;
	gint optimized_transformations_length1;
	gint optimized_slots_used;
};

struct _PixelTransformerClass {
	GTypeClass parent_class;
	void (*finalize) (PixelTransformer *self);
};

struct _RGBHistogram {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RGBHistogramPrivate * priv;
};

struct _RGBHistogramClass {
	GTypeClass parent_class;
	void (*finalize) (RGBHistogram *self);
};

struct _IntensityHistogram {
	GTypeInstance parent_instance;
	volatile int ref_count;
	IntensityHistogramPrivate * priv;
};

struct _IntensityHistogramClass {
	GTypeClass parent_class;
	void (*finalize) (IntensityHistogram *self);
};

struct _ExpansionTransformation {
	HSVTransformation parent_instance;
	ExpansionTransformationPrivate * priv;
};

struct _ExpansionTransformationClass {
	HSVTransformationClass parent_class;
};

struct _ShadowDetailTransformation {
	HSVTransformation parent_instance;
	ShadowDetailTransformationPrivate * priv;
};

struct _ShadowDetailTransformationClass {
	HSVTransformationClass parent_class;
};

struct _HermiteGammaApproximationFunction {
	GTypeInstance parent_instance;
	volatile int ref_count;
	HermiteGammaApproximationFunctionPrivate * priv;
};

struct _HermiteGammaApproximationFunctionClass {
	GTypeClass parent_class;
	void (*finalize) (HermiteGammaApproximationFunction *self);
};

struct _HighlightDetailTransformation {
	HSVTransformation parent_instance;
	HighlightDetailTransformationPrivate * priv;
};

struct _HighlightDetailTransformationClass {
	HSVTransformationClass parent_class;
};

struct _KeyValueMap {
	GTypeInstance parent_instance;
	volatile int ref_count;
	KeyValueMapPrivate * priv;
};

struct _KeyValueMapClass {
	GTypeClass parent_class;
	void (*finalize) (KeyValueMap *self);
};


GType rgb_analytic_pixel_get_type (void) G_GNUC_CONST;
RGBAnalyticPixel* rgb_analytic_pixel_dup (const RGBAnalyticPixel* self);
void rgb_analytic_pixel_free (RGBAnalyticPixel* self);
void rgb_analytic_pixel_init (RGBAnalyticPixel *self);
void rgb_analytic_pixel_init_from_components (RGBAnalyticPixel *self,
                                              gfloat red,
                                              gfloat green,
                                              gfloat blue);
void rgb_analytic_pixel_init_from_quantized_components (RGBAnalyticPixel *self,
                                                        guchar red_quantized,
                                                        guchar green_quantized,
                                                        guchar blue_quantized);
GType hsv_analytic_pixel_get_type (void) G_GNUC_CONST;
HSVAnalyticPixel* hsv_analytic_pixel_dup (const HSVAnalyticPixel* self);
void hsv_analytic_pixel_free (HSVAnalyticPixel* self);
void rgb_analytic_pixel_init_from_hsv (RGBAnalyticPixel *self,
                                       HSVAnalyticPixel* hsv_pixel);
guchar rgb_analytic_pixel_quantized_red (RGBAnalyticPixel *self);
guchar rgb_analytic_pixel_quantized_green (RGBAnalyticPixel *self);
guchar rgb_analytic_pixel_quantized_blue (RGBAnalyticPixel *self);
gboolean rgb_analytic_pixel_equals (RGBAnalyticPixel *self,
                                    RGBAnalyticPixel* rhs);
guint rgb_analytic_pixel_hash_code (RGBAnalyticPixel *self);
void rgb_analytic_pixel_to_hsv (RGBAnalyticPixel *self,
                                HSVAnalyticPixel* result);
void hsv_analytic_pixel_init (HSVAnalyticPixel *self);
void hsv_analytic_pixel_init_from_components (HSVAnalyticPixel *self,
                                              gfloat hue,
                                              gfloat saturation,
                                              gfloat light_value);
void hsv_analytic_pixel_init_from_quantized_components (HSVAnalyticPixel *self,
                                                        guchar hue_quantized,
                                                        guchar saturation_quantized,
                                                        guchar light_value_quantized);
void hsv_analytic_pixel_init_from_rgb (HSVAnalyticPixel *self,
                                       RGBAnalyticPixel* p);
void hsv_analytic_pixel_to_rgb (HSVAnalyticPixel *self,
                                RGBAnalyticPixel* result);
gboolean hsv_analytic_pixel_equals (HSVAnalyticPixel *self,
                                    HSVAnalyticPixel* rhs);
guint hsv_analytic_pixel_hash_code (HSVAnalyticPixel *self);
GType composition_mode_get_type (void) G_GNUC_CONST;
GType pixel_format_get_type (void) G_GNUC_CONST;
GType pixel_transformation_type_get_type (void) G_GNUC_CONST;
gpointer pixel_transformation_bundle_ref (gpointer instance);
void pixel_transformation_bundle_unref (gpointer instance);
GParamSpec* param_spec_pixel_transformation_bundle (const gchar* name,
                                                    const gchar* nick,
                                                    const gchar* blurb,
                                                    GType object_type,
                                                    GParamFlags flags);
void value_set_pixel_transformation_bundle (GValue* value,
                                            gpointer v_object);
void value_take_pixel_transformation_bundle (GValue* value,
                                             gpointer v_object);
gpointer value_get_pixel_transformation_bundle (const GValue* value);
GType pixel_transformation_bundle_get_type (void) G_GNUC_CONST;
PixelTransformationBundle* pixel_transformation_bundle_new (void);
PixelTransformationBundle* pixel_transformation_bundle_construct (GType object_type);
PixelTransformationBundle* pixel_transformation_bundle_get_copied_color_adjustments (void);
void pixel_transformation_bundle_set_copied_color_adjustments (PixelTransformationBundle* adjustments);
gboolean pixel_transformation_bundle_has_copied_color_adjustments (void);
gpointer pixel_transformation_ref (gpointer instance);
void pixel_transformation_unref (gpointer instance);
GParamSpec* param_spec_pixel_transformation (const gchar* name,
                                             const gchar* nick,
                                             const gchar* blurb,
                                             GType object_type,
                                             GParamFlags flags);
void value_set_pixel_transformation (GValue* value,
                                     gpointer v_object);
void value_take_pixel_transformation (GValue* value,
                                      gpointer v_object);
gpointer value_get_pixel_transformation (const GValue* value);
GType pixel_transformation_get_type (void) G_GNUC_CONST;
void pixel_transformation_bundle_set (PixelTransformationBundle* self,
                                      PixelTransformation* transformation);
void pixel_transformation_bundle_set_to_identity (PixelTransformationBundle* self);
gpointer key_value_map_ref (gpointer instance);
void key_value_map_unref (gpointer instance);
GParamSpec* param_spec_key_value_map (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
void value_set_key_value_map (GValue* value,
                              gpointer v_object);
void value_take_key_value_map (GValue* value,
                               gpointer v_object);
gpointer value_get_key_value_map (const GValue* value);
GType key_value_map_get_type (void) G_GNUC_CONST;
void pixel_transformation_bundle_load (PixelTransformationBundle* self,
                                       KeyValueMap* store);
KeyValueMap* pixel_transformation_bundle_save (PixelTransformationBundle* self,
                                               const gchar* group);
gint pixel_transformation_bundle_get_count (PixelTransformationBundle* self);
PixelTransformation* pixel_transformation_bundle_get_transformation (PixelTransformationBundle* self,
                                                                     PixelTransformationType type);
GeeIterable* pixel_transformation_bundle_get_transformations (PixelTransformationBundle* self);
gboolean pixel_transformation_bundle_is_identity (PixelTransformationBundle* self);
gpointer pixel_transformer_ref (gpointer instance);
void pixel_transformer_unref (gpointer instance);
GParamSpec* param_spec_pixel_transformer (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags);
void value_set_pixel_transformer (GValue* value,
                                  gpointer v_object);
void value_take_pixel_transformer (GValue* value,
                                   gpointer v_object);
gpointer value_get_pixel_transformer (const GValue* value);
GType pixel_transformer_get_type (void) G_GNUC_CONST;
PixelTransformer* pixel_transformation_bundle_generate_transformer (PixelTransformationBundle* self);
PixelTransformationBundle* pixel_transformation_bundle_copy (PixelTransformationBundle* self);
PixelTransformation* pixel_transformation_construct (GType object_type,
                                                     PixelTransformationType type,
                                                     PixelFormat preferred_format);
PixelTransformationType pixel_transformation_get_transformation_type (PixelTransformation* self);
PixelFormat pixel_transformation_get_preferred_format (PixelTransformation* self);
CompositionMode pixel_transformation_get_composition_mode (PixelTransformation* self);
void pixel_transformation_compose_with (PixelTransformation* self,
                                        PixelTransformation* other);
gboolean pixel_transformation_is_identity (PixelTransformation* self);
void pixel_transformation_transform_pixel_hsv (PixelTransformation* self,
                                               HSVAnalyticPixel* p,
                                               HSVAnalyticPixel* result);
void pixel_transformation_transform_pixel_rgb (PixelTransformation* self,
                                               RGBAnalyticPixel* p,
                                               RGBAnalyticPixel* result);
gchar* pixel_transformation_to_string (PixelTransformation* self);
PixelTransformation* pixel_transformation_copy (PixelTransformation* self);
GType rgb_transformation_get_type (void) G_GNUC_CONST;
#define RGB_TRANSFORMATION_MATRIX_SIZE 16
RGBTransformation* rgb_transformation_new (PixelTransformationType type);
RGBTransformation* rgb_transformation_construct (GType object_type,
                                                 PixelTransformationType type);
GType hsv_transformation_get_type (void) G_GNUC_CONST;
HSVTransformation* hsv_transformation_construct (GType object_type,
                                                 PixelTransformationType type);
GType tint_transformation_get_type (void) G_GNUC_CONST;
#define TINT_TRANSFORMATION_MIN_PARAMETER (-16.0f)
#define TINT_TRANSFORMATION_MAX_PARAMETER 16.0f
TintTransformation* tint_transformation_new (gfloat client_param);
TintTransformation* tint_transformation_construct (GType object_type,
                                                   gfloat client_param);
gfloat tint_transformation_get_parameter (TintTransformation* self);
GType temperature_transformation_get_type (void) G_GNUC_CONST;
#define TEMPERATURE_TRANSFORMATION_MIN_PARAMETER (-16.0f)
#define TEMPERATURE_TRANSFORMATION_MAX_PARAMETER 16.0f
TemperatureTransformation* temperature_transformation_new (gfloat client_parameter);
TemperatureTransformation* temperature_transformation_construct (GType object_type,
                                                                 gfloat client_parameter);
gfloat temperature_transformation_get_parameter (TemperatureTransformation* self);
GType saturation_transformation_get_type (void) G_GNUC_CONST;
#define SATURATION_TRANSFORMATION_MIN_PARAMETER (-16.0f)
#define SATURATION_TRANSFORMATION_MAX_PARAMETER 16.0f
SaturationTransformation* saturation_transformation_new (gfloat client_parameter);
SaturationTransformation* saturation_transformation_construct (GType object_type,
                                                               gfloat client_parameter);
gfloat saturation_transformation_get_parameter (SaturationTransformation* self);
GType exposure_transformation_get_type (void) G_GNUC_CONST;
#define EXPOSURE_TRANSFORMATION_MIN_PARAMETER (-16.0f)
#define EXPOSURE_TRANSFORMATION_MAX_PARAMETER 16.0f
ExposureTransformation* exposure_transformation_new (gfloat client_parameter);
ExposureTransformation* exposure_transformation_construct (GType object_type,
                                                           gfloat client_parameter);
gfloat exposure_transformation_get_parameter (ExposureTransformation* self);
GType contrast_transformation_get_type (void) G_GNUC_CONST;
#define CONTRAST_TRANSFORMATION_MIN_PARAMETER (-16.0f)
#define CONTRAST_TRANSFORMATION_MAX_PARAMETER 16.0f
ContrastTransformation* contrast_transformation_new (gfloat client_parameter);
ContrastTransformation* contrast_transformation_construct (GType object_type,
                                                           gfloat client_parameter);
gfloat contrast_transformation_get_parameter (ContrastTransformation* self);
PixelTransformer* pixel_transformer_new (void);
PixelTransformer* pixel_transformer_construct (GType object_type);
PixelTransformer* pixel_transformer_copy (PixelTransformer* self);
void pixel_transformer_attach_transformation (PixelTransformer* self,
                                              PixelTransformation* trans);
void pixel_transformer_detach_transformation (PixelTransformer* self,
                                              PixelTransformation* victim);
void pixel_transformer_replace_transformation (PixelTransformer* self,
                                               PixelTransformation* old_trans,
                                               PixelTransformation* new_trans);
void pixel_transformer_transform_pixbuf (PixelTransformer* self,
                                         GdkPixbuf* pixbuf,
                                         GCancellable* cancellable);
void pixel_transformer_transform_from_fp (PixelTransformer* self,
                                          gfloat** fp_pixel_cache,
                                          int* fp_pixel_cache_length1,
                                          GdkPixbuf* dest);
void pixel_transformer_transform_to_other_pixbuf (PixelTransformer* self,
                                                  GdkPixbuf* source,
                                                  GdkPixbuf* dest,
                                                  GCancellable* cancellable,
                                                  gint jobs);
gpointer rgb_histogram_ref (gpointer instance);
void rgb_histogram_unref (gpointer instance);
GParamSpec* param_spec_rgb_histogram (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
void value_set_rgb_histogram (GValue* value,
                              gpointer v_object);
void value_take_rgb_histogram (GValue* value,
                               gpointer v_object);
gpointer value_get_rgb_histogram (const GValue* value);
GType rgb_histogram_get_type (void) G_GNUC_CONST;
#define RGB_HISTOGRAM_GRAPHIC_WIDTH 256
#define RGB_HISTOGRAM_GRAPHIC_HEIGHT 100
RGBHistogram* rgb_histogram_new (GdkPixbuf* pixbuf);
RGBHistogram* rgb_histogram_construct (GType object_type,
                                       GdkPixbuf* pixbuf);
GdkPixbuf* rgb_histogram_get_graphic (RGBHistogram* self);
gpointer intensity_histogram_ref (gpointer instance);
void intensity_histogram_unref (gpointer instance);
GParamSpec* param_spec_intensity_histogram (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
void value_set_intensity_histogram (GValue* value,
                                    gpointer v_object);
void value_take_intensity_histogram (GValue* value,
                                     gpointer v_object);
gpointer value_get_intensity_histogram (const GValue* value);
GType intensity_histogram_get_type (void) G_GNUC_CONST;
IntensityHistogram* intensity_histogram_new (GdkPixbuf* pixbuf);
IntensityHistogram* intensity_histogram_construct (GType object_type,
                                                   GdkPixbuf* pixbuf);
gfloat intensity_histogram_get_cumulative_probability (IntensityHistogram* self,
                                                       gint level);
GType expansion_transformation_get_type (void) G_GNUC_CONST;
ExpansionTransformation* expansion_transformation_new (IntensityHistogram* histogram);
ExpansionTransformation* expansion_transformation_construct (GType object_type,
                                                             IntensityHistogram* histogram);
ExpansionTransformation* expansion_transformation_new_from_extrema (gint black_point,
                                                                    gint white_point);
ExpansionTransformation* expansion_transformation_construct_from_extrema (GType object_type,
                                                                          gint black_point,
                                                                          gint white_point);
ExpansionTransformation* expansion_transformation_new_from_string (const gchar* encoded_transformation);
ExpansionTransformation* expansion_transformation_construct_from_string (GType object_type,
                                                                         const gchar* encoded_transformation);
gint expansion_transformation_get_white_point (ExpansionTransformation* self);
gint expansion_transformation_get_black_point (ExpansionTransformation* self);
GType shadow_detail_transformation_get_type (void) G_GNUC_CONST;
#define SHADOW_DETAIL_TRANSFORMATION_MIN_PARAMETER 0.0f
#define SHADOW_DETAIL_TRANSFORMATION_MAX_PARAMETER 32.0f
ShadowDetailTransformation* shadow_detail_transformation_new (gfloat user_intensity);
ShadowDetailTransformation* shadow_detail_transformation_construct (GType object_type,
                                                                    gfloat user_intensity);
gfloat shadow_detail_transformation_get_parameter (ShadowDetailTransformation* self);
gpointer hermite_gamma_approximation_function_ref (gpointer instance);
void hermite_gamma_approximation_function_unref (gpointer instance);
GParamSpec* param_spec_hermite_gamma_approximation_function (const gchar* name,
                                                             const gchar* nick,
                                                             const gchar* blurb,
                                                             GType object_type,
                                                             GParamFlags flags);
void value_set_hermite_gamma_approximation_function (GValue* value,
                                                     gpointer v_object);
void value_take_hermite_gamma_approximation_function (GValue* value,
                                                      gpointer v_object);
gpointer value_get_hermite_gamma_approximation_function (const GValue* value);
GType hermite_gamma_approximation_function_get_type (void) G_GNUC_CONST;
HermiteGammaApproximationFunction* hermite_gamma_approximation_function_new (gfloat user_interval_upper);
HermiteGammaApproximationFunction* hermite_gamma_approximation_function_construct (GType object_type,
                                                                                   gfloat user_interval_upper);
gfloat hermite_gamma_approximation_function_evaluate (HermiteGammaApproximationFunction* self,
                                                      gfloat x);
GType highlight_detail_transformation_get_type (void) G_GNUC_CONST;
#define HIGHLIGHT_DETAIL_TRANSFORMATION_MIN_PARAMETER (-32.0f)
#define HIGHLIGHT_DETAIL_TRANSFORMATION_MAX_PARAMETER 0.0f
HighlightDetailTransformation* highlight_detail_transformation_new (gfloat user_intensity);
HighlightDetailTransformation* highlight_detail_transformation_construct (GType object_type,
                                                                          gfloat user_intensity);
gfloat highlight_detail_transformation_get_parameter (HighlightDetailTransformation* self);
PixelTransformationBundle* auto_enhance_create_auto_enhance_adjustments (GdkPixbuf* pixbuf);
KeyValueMap* key_value_map_new (const gchar* group);
KeyValueMap* key_value_map_construct (GType object_type,
                                      const gchar* group);
KeyValueMap* key_value_map_copy (KeyValueMap* self);
gchar* key_value_map_get_group (KeyValueMap* self);
GeeSet* key_value_map_get_keys (KeyValueMap* self);
gboolean key_value_map_has_key (KeyValueMap* self,
                                const gchar* key);
void key_value_map_set_string (KeyValueMap* self,
                               const gchar* key,
                               const gchar* value);
void key_value_map_set_int (KeyValueMap* self,
                            const gchar* key,
                            gint value);
void key_value_map_set_double (KeyValueMap* self,
                               const gchar* key,
                               gdouble value);
void key_value_map_set_float (KeyValueMap* self,
                              const gchar* key,
                              gfloat value);
void key_value_map_set_bool (KeyValueMap* self,
                             const gchar* key,
                             gboolean value);
gchar* key_value_map_get_string (KeyValueMap* self,
                                 const gchar* key,
                                 const gchar* def);
gint key_value_map_get_int (KeyValueMap* self,
                            const gchar* key,
                            gint def);
gdouble key_value_map_get_double (KeyValueMap* self,
                                  const gchar* key,
                                  gdouble def);
gfloat key_value_map_get_float (KeyValueMap* self,
                                const gchar* key,
                                gfloat def);
gboolean key_value_map_get_bool (KeyValueMap* self,
                                 const gchar* key,
                                 gboolean def);
void key_value_map_get_point (KeyValueMap* self,
                              const gchar* key,
                              GdkPoint* def,
                              GdkPoint* result);
void key_value_map_set_point (KeyValueMap* self,
                              const gchar* key,
                              GdkPoint* point);

extern const gfloat rgb_lookup_table[256];

G_END_DECLS

#endif
