/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.locusiterator;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.Requires;
import htsjdk.samtools.CigarOperator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.broadinstitute.gatk.engine.downsampling.Downsampler;
import org.broadinstitute.gatk.engine.downsampling.LevelingDownsampler;
import org.broadinstitute.gatk.utils.locusiterator.AlignmentStateMachine;
import org.broadinstitute.gatk.utils.locusiterator.LIBSDownsamplingInfo;
import org.broadinstitute.gatk.utils.locusiterator.ReadStateManager;

@Invariant(value={"readStartsAreWellOrdered()", "! isDownsampling() || downsamplingTarget > 0", "nSites >= 0", "nSitesNeedingDownsampling >= 0", "nSitesNeedingDownsampling <= nSites"})
final class PerSampleReadStateManager
implements Iterable<AlignmentStateMachine> {
    private static final Logger logger = Logger.getLogger(ReadStateManager.class);
    private static final boolean CAPTURE_DOWNSAMPLING_STATS = false;
    private LinkedList<AlignmentStateMachine> readStatesByAlignmentStart = new LinkedList();
    private final Downsampler<LinkedList<AlignmentStateMachine>> levelingDownsampler;
    private final int downsamplingTarget;
    private int nSitesNeedingDownsampling = 0;
    private int nSites = 0;

    public PerSampleReadStateManager(LIBSDownsamplingInfo LIBSDownsamplingInfo2) {
        this.downsamplingTarget = LIBSDownsamplingInfo2.isPerformDownsampling() ? LIBSDownsamplingInfo2.getToCoverage() : -1;
        this.levelingDownsampler = LIBSDownsamplingInfo2.isPerformDownsampling() ? new LevelingDownsampler(LIBSDownsamplingInfo2.getToCoverage()) : null;
    }

    @Ensures(value={"result != null"})
    private List<LinkedList<AlignmentStateMachine>> groupByAlignmentStart() {
        LinkedList<LinkedList<AlignmentStateMachine>> grouped = new LinkedList<LinkedList<AlignmentStateMachine>>();
        AlignmentStateMachine last = null;
        for (AlignmentStateMachine stateMachine : this.readStatesByAlignmentStart) {
            if (last == null || stateMachine.getGenomeOffset() != last.getGenomeOffset()) {
                grouped.add(new LinkedList());
                last = stateMachine;
            }
            grouped.getLast().add(stateMachine);
        }
        return grouped;
    }

    @Ensures(value={"result != null"})
    private LinkedList<AlignmentStateMachine> flattenByAlignmentStart(List<LinkedList<AlignmentStateMachine>> grouped) {
        LinkedList<AlignmentStateMachine> flat = new LinkedList<AlignmentStateMachine>();
        for (List list : grouped) {
            flat.addAll(list);
        }
        return flat;
    }

    private boolean readStartsAreWellOrdered() {
        int lastStart = -1;
        for (AlignmentStateMachine machine : this.readStatesByAlignmentStart) {
            if (lastStart > machine.getRead().getAlignmentStart()) {
                return false;
            }
            lastStart = machine.getRead().getAlignmentStart();
        }
        return true;
    }

    @Requires(value={"states != null"})
    public int addStatesAtNextAlignmentStart(LinkedList<AlignmentStateMachine> states) {
        if (states.isEmpty()) {
            return 0;
        }
        this.readStatesByAlignmentStart.addAll(states);
        int nStatesAdded = states.size();
        if (this.isDownsampling() && this.readStatesByAlignmentStart.size() > this.downsamplingTarget) {
            this.captureDownsamplingStats();
            this.levelingDownsampler.submit(this.groupByAlignmentStart());
            this.levelingDownsampler.signalEndOfInput();
            nStatesAdded -= this.levelingDownsampler.getNumberOfDiscardedItems();
            this.readStatesByAlignmentStart = this.flattenByAlignmentStart(this.levelingDownsampler.consumeFinalizedItems());
            this.levelingDownsampler.resetStats();
        }
        return nStatesAdded;
    }

    private boolean isDownsampling() {
        return this.levelingDownsampler != null;
    }

    public AlignmentStateMachine getFirst() {
        return this.isEmpty() ? null : this.readStatesByAlignmentStart.getFirst();
    }

    @Requires(value={"isDownsampling()"})
    private void captureDownsamplingStats() {
    }

    public boolean isEmpty() {
        return this.readStatesByAlignmentStart.isEmpty();
    }

    @Ensures(value={"result >= 0"})
    public int size() {
        return this.readStatesByAlignmentStart.size();
    }

    public int updateReadStates() {
        int nRemoved = 0;
        Iterator<AlignmentStateMachine> it = this.iterator();
        while (it.hasNext()) {
            AlignmentStateMachine state = it.next();
            CigarOperator op = state.stepForwardOnGenome();
            if (op != null) continue;
            it.remove();
            ++nRemoved;
        }
        return nRemoved;
    }

    @Override
    @Ensures(value={"result != null"})
    public Iterator<AlignmentStateMachine> iterator() {
        return this.readStatesByAlignmentStart.iterator();
    }
}

